// +build !ignore_autogenerated

/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	spec "github.com/go-openapi/spec"
	resource "k8s.io/kubernetes/pkg/api/resource"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	common "k8s.io/kubernetes/pkg/genericapiserver/openapi/common"
	intstr "k8s.io/kubernetes/pkg/util/intstr"
)

var OpenAPIDefinitions *common.OpenAPIDefinitions = &common.OpenAPIDefinitions{
	"apps.StatefulSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n - Network: A single stable DNS and hostname.\n - Storage: As many VolumeClaims as requested.\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Ref:         spec.MustCreateRef("#/definitions/apps.StatefulSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Ref:         spec.MustCreateRef("#/definitions/apps.StatefulSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "apps.StatefulSetSpec", "apps.StatefulSetStatus"},
	},
	"apps.StatefulSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/apps.StatefulSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"apps.StatefulSet", "unversioned.ListMeta"},
	},
	"apps.StatefulSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.",
							Ref:         spec.MustCreateRef("#/definitions/api.PodTemplateSpec"),
						},
					},
					"volumeClaimTemplates": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/api.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"template", "serviceName"},
			},
		},
		Dependencies: []string{
			"api.PersistentVolumeClaim", "api.PodTemplateSpec", "unversioned.LabelSelector"},
	},
	"apps.StatefulSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of actual replicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{},
	},
	"authentication.TokenReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectMeta fulfills the meta.ObjectMetaAccessor interface so that the stock REST handler paths work",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/authentication.TokenReviewSpec"),
						},
					},
					"Status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request can be authenticated.",
							Ref:         spec.MustCreateRef("#/definitions/authentication.TokenReviewStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Spec", "Status"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "authentication.TokenReviewSpec", "authentication.TokenReviewStatus", "unversioned.TypeMeta"},
	},
	"authentication.TokenReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Properties: map[string]spec.Schema{
					"Token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Token"},
			},
		},
		Dependencies: []string{},
	},
	"authentication.TokenReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request. This type mirrors the authentication.Token interface",
				Properties: map[string]spec.Schema{
					"Authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"User": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Ref:         spec.MustCreateRef("#/definitions/authentication.UserInfo"),
						},
					},
					"Error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Authenticated", "User", "Error"},
			},
		},
		Dependencies: []string{
			"authentication.UserInfo"},
	},
	"authentication.UserInfo": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Properties: map[string]spec.Schema{
					"Username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"UID": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Groups": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"Extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type:   []string{"string"},
													Format: "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
				Required: []string{"Username", "UID", "Groups", "Extra"},
			},
		},
		Dependencies: []string{},
	},
	"authorization.LocalSubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SubjectAccessReviewSpec"),
						},
					},
					"Status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Spec", "Status"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "authorization.SubjectAccessReviewSpec", "authorization.SubjectAccessReviewStatus", "unversioned.TypeMeta"},
	},
	"authorization.NonResourceAttributes": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Properties: map[string]spec.Schema{
					"Path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Path", "Verb"},
			},
		},
		Dependencies: []string{},
	},
	"authorization.ResourceAttributes": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Properties: map[string]spec.Schema{
					"Namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Namespace", "Verb", "Group", "Version", "Resource", "Subresource", "Name"},
			},
		},
		Dependencies: []string{},
	},
	"authorization.SelfSubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SelfSubjectAccessReviewSpec"),
						},
					},
					"Status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Spec", "Status"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "authorization.SelfSubjectAccessReviewSpec", "authorization.SubjectAccessReviewStatus", "unversioned.TypeMeta"},
	},
	"authorization.SelfSubjectAccessReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAttributes and NonResourceAttributes must be set",
				Properties: map[string]spec.Schema{
					"ResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAttributes describes information for a resource access request",
							Ref:         spec.MustCreateRef("#/definitions/authorization.ResourceAttributes"),
						},
					},
					"NonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         spec.MustCreateRef("#/definitions/authorization.NonResourceAttributes"),
						},
					},
				},
				Required: []string{"ResourceAttributes", "NonResourceAttributes"},
			},
		},
		Dependencies: []string{
			"authorization.NonResourceAttributes", "authorization.ResourceAttributes"},
	},
	"authorization.SubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SubjectAccessReviewSpec"),
						},
					},
					"Status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/authorization.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Spec", "Status"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "authorization.SubjectAccessReviewSpec", "authorization.SubjectAccessReviewStatus", "unversioned.TypeMeta"},
	},
	"authorization.SubjectAccessReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAttributes and NonResourceAttributes must be set",
				Properties: map[string]spec.Schema{
					"ResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAttributes describes information for a resource access request",
							Ref:         spec.MustCreateRef("#/definitions/authorization.ResourceAttributes"),
						},
					},
					"NonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         spec.MustCreateRef("#/definitions/authorization.NonResourceAttributes"),
						},
					},
					"User": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Group\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Groups": {
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"Extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type:   []string{"string"},
													Format: "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
				Required: []string{"ResourceAttributes", "NonResourceAttributes", "User", "Groups", "Extra"},
			},
		},
		Dependencies: []string{
			"authorization.NonResourceAttributes", "authorization.ResourceAttributes"},
	},
	"authorization.SubjectAccessReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Properties: map[string]spec.Schema{
					"Allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required.  True if the action would be allowed, false otherwise.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"Reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"EvaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Allowed", "Reason", "EvaluationError"},
			},
		},
		Dependencies: []string{},
	},
	"autoscaling.CrossVersionObjectReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
		Dependencies: []string{},
	},
	"autoscaling.HorizontalPodAutoscaler": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "behaviour of autoscaler. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/autoscaling.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current information about the autoscaler.",
							Ref:         spec.MustCreateRef("#/definitions/autoscaling.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "autoscaling.HorizontalPodAutoscalerSpec", "autoscaling.HorizontalPodAutoscalerStatus"},
	},
	"autoscaling.HorizontalPodAutoscalerList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/autoscaling.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"autoscaling.HorizontalPodAutoscaler", "unversioned.ListMeta"},
	},
	"autoscaling.HorizontalPodAutoscalerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.",
							Ref:         spec.MustCreateRef("#/definitions/autoscaling.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "lower limit for the number of pods that can be set by the autoscaler, default 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "upper limit for the number of pods that can be set by the autoscaler. It cannot be smaller than MinReplicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"autoscaling.CrossVersionObjectReference"},
	},
	"autoscaling.HorizontalPodAutoscalerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"autoscaling.Scale": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/autoscaling.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status. Read-only.",
							Ref:         spec.MustCreateRef("#/definitions/autoscaling.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "autoscaling.ScaleSpec", "autoscaling.ScaleStatus"},
	},
	"autoscaling.ScaleSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"autoscaling.ScaleStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{},
	},
	"batch.CronJob": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJob represents the configuration of a single cron job.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job, including the schedule. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.CronJobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.CronJobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "batch.CronJobSpec", "batch.CronJobStatus"},
	},
	"batch.CronJobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobList is a collection of cron jobs.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of CronJob.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/batch.CronJob"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"batch.CronJob", "unversioned.ListMeta"},
	},
	"batch.CronJobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobSpec describes how the job execution will look like and when it will actually run.",
				Properties: map[string]spec.Schema{
					"schedule": {
						SchemaProps: spec.SchemaProps{
							Description: "Schedule contains the schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startingDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"concurrencyPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "ConcurrencyPolicy specifies how to treat concurrent executions of a Job.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"suspend": {
						SchemaProps: spec.SchemaProps{
							Description: "Suspend flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"jobTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "JobTemplate is the object that describes the job that will be created when executing a CronJob.",
							Ref:         spec.MustCreateRef("#/definitions/batch.JobTemplateSpec"),
						},
					},
				},
				Required: []string{"schedule", "jobTemplate"},
			},
		},
		Dependencies: []string{
			"batch.JobTemplateSpec"},
	},
	"batch.CronJobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobStatus represents the current state of a cron job.",
				Properties: map[string]spec.Schema{
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active holds pointers to currently running jobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/api.ObjectReference"),
									},
								},
							},
						},
					},
					"lastScheduleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "LastScheduleTime keeps information of when was the last time the job was successfully scheduled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectReference", "unversioned.Time"},
	},
	"batch.Job": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Job represents the configuration of a single job.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.JobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "batch.JobSpec", "batch.JobStatus"},
	},
	"batch.JobCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobCondition describes current state of a job.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of job condition, Complete or Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"batch.JobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobList is a collection of jobs.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Job.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/batch.Job"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"batch.Job", "unversioned.ListMeta"},
	},
	"batch.JobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobSpec describes how the job execution will look like.",
				Properties: map[string]spec.Schema{
					"parallelism": {
						SchemaProps: spec.SchemaProps{
							Description: "Parallelism specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completions": {
						SchemaProps: spec.SchemaProps{
							Description: "Completions specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the pod count. Normally, the system sets this field for you.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"manualSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ManualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created when executing a job.",
							Ref:         spec.MustCreateRef("#/definitions/api.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"api.PodTemplateSpec", "unversioned.LabelSelector"},
	},
	"batch.JobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobStatus represents the current state of a Job.",
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represent the latest available observations of an object's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/batch.JobCondition"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active is the number of actively running pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"succeeded": {
						SchemaProps: spec.SchemaProps{
							Description: "Succeeded is the number of pods which reached Phase Succeeded.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "Failed is the number of pods which reached Phase Failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"batch.JobCondition", "unversioned.Time"},
	},
	"batch.JobTemplate": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobTemplate describes a template for creating copies of a predefined pod.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines jobs that will be created from this template http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.JobTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "batch.JobTemplateSpec"},
	},
	"batch.JobTemplateSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobTemplateSpec describes the data a Job should have when created from a template",
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata of the jobs created from this template. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/batch.JobSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "batch.JobSpec"},
	},
	"certificates.CertificateSigningRequest": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a certificate signing request",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The certificate request itself and any additional information.",
							Ref:         spec.MustCreateRef("#/definitions/certificates.CertificateSigningRequestSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Derived information about the request.",
							Ref:         spec.MustCreateRef("#/definitions/certificates.CertificateSigningRequestStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "certificates.CertificateSigningRequestSpec", "certificates.CertificateSigningRequestStatus"},
	},
	"certificates.CertificateSigningRequestCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "request approval state, currently Approved or Denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "brief reason for the request state",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "human readable message with details about the request state",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "timestamp for the last update to this condition",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"certificates.CertificateSigningRequestList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/certificates.CertificateSigningRequest"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"certificates.CertificateSigningRequest", "unversioned.ListMeta"},
	},
	"certificates.CertificateSigningRequestSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "This information is immutable after the request is created. Only the Request and ExtraInfo fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.",
				Properties: map[string]spec.Schema{
					"request": {
						SchemaProps: spec.SchemaProps{
							Description: "Base64-encoded PKCS#10 CSR data",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "Information about the requesting user (if relevant) See user.Info interface for details",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"request"},
			},
		},
		Dependencies: []string{},
	},
	"certificates.CertificateSigningRequestStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions applied to the request, such as approval or denial.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/certificates.CertificateSigningRequestCondition"),
									},
								},
							},
						},
					},
					"certificate": {
						SchemaProps: spec.SchemaProps{
							Description: "If request was approved, the controller will place the issued certificate here.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"certificates.CertificateSigningRequestCondition"},
	},
	"componentconfig.IPVar": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"Val": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Val"},
			},
		},
		Dependencies: []string{},
	},
	"componentconfig.KubeControllerManagerConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "port is the port that the controller-manager's http service runs on.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "address is the IP address to serve on (set to 0.0.0.0 for all interfaces).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"useServiceAccountCredentials": {
						SchemaProps: spec.SchemaProps{
							Description: "useServiceAccountCredentials indicates whether controllers should be run with individual service account credentials.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cloudProvider": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudProvider is the provider for cloud services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cloudConfigFile": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudConfigFile is the path to the cloud provider configuration file.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"concurrentEndpointSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentEndpointSyncs is the number of endpoint syncing operations that will be done concurrently. Larger number = faster endpoint updating, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentRSSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentRSSyncs is the number of replica sets that are  allowed to sync concurrently. Larger number = more responsive replica  management, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentRCSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentRCSyncs is the number of replication controllers that are allowed to sync concurrently. Larger number = more responsive replica management, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentServiceSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentServiceSyncs is the number of services that are allowed to sync concurrently. Larger number = more responsive service management, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentResourceQuotaSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentResourceQuotaSyncs is the number of resource quotas that are allowed to sync concurrently. Larger number = more responsive quota management, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentDeploymentSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentDeploymentSyncs is the number of deployment objects that are allowed to sync concurrently. Larger number = more responsive deployments, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentDaemonSetSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentDaemonSetSyncs is the number of daemonset objects that are allowed to sync concurrently. Larger number = more responsive daemonset, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentJobSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentJobSyncs is the number of job objects that are allowed to sync concurrently. Larger number = more responsive jobs, but more CPU (and network) load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentNamespaceSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentNamespaceSyncs is the number of namespace objects that are allowed to sync concurrently.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"concurrentSATokenSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentSATokenSyncs is the number of service account token syncing operations that will be done concurrently.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lookupCacheSizeForRC": {
						SchemaProps: spec.SchemaProps{
							Description: "lookupCacheSizeForRC is the size of lookup cache for replication controllers. Larger number = more responsive replica management, but more MEM load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lookupCacheSizeForRS": {
						SchemaProps: spec.SchemaProps{
							Description: "lookupCacheSizeForRS is the size of lookup cache for replicatsets. Larger number = more responsive replica management, but more MEM load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lookupCacheSizeForDaemonSet": {
						SchemaProps: spec.SchemaProps{
							Description: "lookupCacheSizeForDaemonSet is the size of lookup cache for daemonsets. Larger number = more responsive daemonset, but more MEM load.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"serviceSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceSyncPeriod is the period for syncing services with their external load balancers.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeSyncPeriod is the period for syncing nodes from cloudprovider. Longer periods will result in fewer calls to cloud provider, but may delay addition of new nodes to cluster.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"routeReconciliationPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "routeReconciliationPeriod is the period for reconciling routes created for Nodes by cloud provider..",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"resourceQuotaSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceQuotaSyncPeriod is the period for syncing quota usage status in the system.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"namespaceSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "namespaceSyncPeriod is the period for syncing namespace life-cycle updates.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"pvClaimBinderSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "pvClaimBinderSyncPeriod is the period for syncing persistent volumes and persistent volume claims.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"minResyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "minResyncPeriod is the resync period in reflectors; will be random between minResyncPeriod and 2*minResyncPeriod.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"terminatedPodGCThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "terminatedPodGCThreshold is the number of terminated pods that can exist before the terminated pod garbage collector starts deleting terminated pods. If <= 0, the terminated pod garbage collector is disabled.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"horizontalPodAutoscalerSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "horizontalPodAutoscalerSyncPeriod is the period for syncing the number of pods in horizontal pod autoscaler.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"deploymentControllerSyncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "deploymentControllerSyncPeriod is the period for syncing the deployments.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"podEvictionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "podEvictionTimeout is the grace period for deleting pods on failed nodes.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"deletingPodsQps": {
						SchemaProps: spec.SchemaProps{
							Description: "DEPRECATED: deletingPodsQps is the number of nodes per second on which pods are deleted in case of node failure.",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"deletingPodsBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "DEPRECATED: deletingPodsBurst is the number of nodes on which pods are bursty deleted in case of node failure. For more details look into RateLimiter.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nodeMonitorGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeMontiorGracePeriod is the amount of time which we allow a running node to be unresponsive before marking it unhealthy. Must be N times more than kubelet's nodeStatusUpdateFrequency, where N means number of retries allowed for kubelet to post node status.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"registerRetryCount": {
						SchemaProps: spec.SchemaProps{
							Description: "registerRetryCount is the number of retries for initial node registration. Retry interval equals node-sync-period.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nodeStartupGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeStartupGracePeriod is the amount of time which we allow starting a node to be unresponsive before marking it unhealthy.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeMonitorPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeMonitorPeriod is the period for syncing NodeStatus in NodeController.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"serviceAccountKeyFile": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceAccountKeyFile is the filename containing a PEM-encoded private RSA key used to sign service account tokens.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterSigningCertFile": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterSigningCertFile is the filename containing a PEM-encoded X509 CA certificate used to issue cluster-scoped certificates",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterSigningKeyFile": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterSigningCertFile is the filename containing a PEM-encoded RSA or ECDSA private key used to issue cluster-scoped certificates",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"approveAllKubeletCSRsForGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "approveAllKubeletCSRs tells the CSR controller to approve all CSRs originating from the kubelet bootstrapping group automatically. WARNING: this grants all users with access to the certificates API group the ability to create credentials for any user that has access to the boostrapping user's credentials.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableProfiling": {
						SchemaProps: spec.SchemaProps{
							Description: "enableProfiling enables profiling via web interface host:port/debug/pprof/",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterName is the instance prefix for the cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterCIDR is CIDR Range for Pods in cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serviceCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceCIDR is CIDR Range for Services in cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeCIDRMaskSize": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeCIDRMaskSize is the mask size for node cidr in cluster.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"allocateNodeCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "allocateNodeCIDRs enables CIDRs for Pods to be allocated and, if ConfigureCloudRoutes is true, to be set on the cloud provider.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"configureCloudRoutes": {
						SchemaProps: spec.SchemaProps{
							Description: "configureCloudRoutes enables CIDRs allocated with allocateNodeCIDRs to be configured on the cloud provider.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rootCAFile": {
						SchemaProps: spec.SchemaProps{
							Description: "rootCAFile is the root certificate authority will be included in service account's token secret. This must be a valid PEM-encoded CA bundle.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"contentType": {
						SchemaProps: spec.SchemaProps{
							Description: "contentType is contentType of requests sent to apiserver.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeAPIQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIQPS is the QPS to use while talking with kubernetes apiserver.",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"kubeAPIBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIBurst is the burst to use while talking with kubernetes apiserver.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"leaderElection": {
						SchemaProps: spec.SchemaProps{
							Description: "leaderElection defines the configuration of leader election client.",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.LeaderElectionConfiguration"),
						},
					},
					"volumeConfiguration": {
						SchemaProps: spec.SchemaProps{
							Description: "volumeConfiguration holds configuration for volume related features.",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.VolumeConfiguration"),
						},
					},
					"controllerStartInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "How long to wait between starting controller managers",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"enableGarbageCollector": {
						SchemaProps: spec.SchemaProps{
							Description: "enables the generic garbage collector. MUST be synced with the corresponding flag of the kube-apiserver. WARNING: the generic garbage collector is an alpha feature.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"concurrentGCSyncs": {
						SchemaProps: spec.SchemaProps{
							Description: "concurrentGCSyncs is the number of garbage collector workers that are allowed to sync concurrently.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nodeEvictionRate": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeEvictionRate is the number of nodes per second on which pods are deleted in case of node failure when a zone is healthy",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"secondaryNodeEvictionRate": {
						SchemaProps: spec.SchemaProps{
							Description: "secondaryNodeEvictionRate is the number of nodes per second on which pods are deleted in case of node failure when a zone is unhealty",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"largeClusterSizeThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "secondaryNodeEvictionRate is implicitly overridden to 0 for clusters smaller than or equal to largeClusterSizeThreshold",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unhealthyZoneThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Zone is treated as unhealthy in nodeEvictionRate and secondaryNodeEvictionRate when at least unhealthyZoneThreshold (no less than 3) of Nodes in the zone are NotReady",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"disableAttachDetachReconcilerSync": {
						SchemaProps: spec.SchemaProps{
							Description: "Reconciler runs a periodic loop to reconcile the desired state of the with the actual state of the world by triggering attach detach operations. This flag enables or disables reconcile.  Is false by default, and thus enabled.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reconcilerSyncLoopPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "ReconcilerSyncLoopPeriod is the amount of time the reconciler sync states loop wait between successive executions. Is set to 5 min by default.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"TypeMeta", "port", "address", "useServiceAccountCredentials", "cloudProvider", "cloudConfigFile", "concurrentEndpointSyncs", "concurrentRSSyncs", "concurrentRCSyncs", "concurrentServiceSyncs", "concurrentResourceQuotaSyncs", "concurrentDeploymentSyncs", "concurrentDaemonSetSyncs", "concurrentJobSyncs", "concurrentNamespaceSyncs", "concurrentSATokenSyncs", "lookupCacheSizeForRC", "lookupCacheSizeForRS", "lookupCacheSizeForDaemonSet", "serviceSyncPeriod", "nodeSyncPeriod", "routeReconciliationPeriod", "resourceQuotaSyncPeriod", "namespaceSyncPeriod", "pvClaimBinderSyncPeriod", "minResyncPeriod", "terminatedPodGCThreshold", "horizontalPodAutoscalerSyncPeriod", "deploymentControllerSyncPeriod", "podEvictionTimeout", "deletingPodsQps", "deletingPodsBurst", "nodeMonitorGracePeriod", "registerRetryCount", "nodeStartupGracePeriod", "nodeMonitorPeriod", "serviceAccountKeyFile", "clusterSigningCertFile", "clusterSigningKeyFile", "approveAllKubeletCSRsForGroup", "enableProfiling", "clusterName", "clusterCIDR", "serviceCIDR", "nodeCIDRMaskSize", "allocateNodeCIDRs", "configureCloudRoutes", "rootCAFile", "contentType", "kubeAPIQPS", "kubeAPIBurst", "leaderElection", "volumeConfiguration", "controllerStartInterval", "enableGarbageCollector", "concurrentGCSyncs", "nodeEvictionRate", "secondaryNodeEvictionRate", "largeClusterSizeThreshold", "unhealthyZoneThreshold", "disableAttachDetachReconcilerSync", "reconcilerSyncLoopPeriod"},
			},
		},
		Dependencies: []string{
			"componentconfig.LeaderElectionConfiguration", "componentconfig.VolumeConfiguration", "unversioned.Duration", "unversioned.TypeMeta"},
	},
	"componentconfig.KubeProxyConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"bindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "bindAddress is the IP address for the proxy server to serve on (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterCIDR is the CIDR range of the pods in the cluster. It is used to bridge traffic coming from outside of the cluster. If not provided, no off-cluster bridging will be performed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"healthzBindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzBindAddress is the IP address for the health check server to serve on, defaulting to 127.0.0.1 (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"healthzPort": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzPort is the port to bind the health check server. Use 0 to disable.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"hostnameOverride": {
						SchemaProps: spec.SchemaProps{
							Description: "hostnameOverride, if non-empty, will be used as the identity instead of the actual hostname.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iptablesMasqueradeBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMasqueradeBit is the bit of the iptables fwmark space to use for SNAT if using the pure iptables proxy mode. Values must be within the range [0, 31].",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iptablesSyncPeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesSyncPeriod is the period that iptables rules are refreshed (e.g. '5s', '1m', '2h22m').  Must be greater than 0.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"iptablesMinSyncPeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMinSyncPeriod is the minimum period that iptables rules are refreshed (e.g. '5s', '1m', '2h22m').",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"kubeconfigPath": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeconfigPath is the path to the kubeconfig file with authorization information (the master location is set by the master flag).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"masqueradeAll": {
						SchemaProps: spec.SchemaProps{
							Description: "masqueradeAll tells kube-proxy to SNAT everything if using the pure iptables proxy mode.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"master": {
						SchemaProps: spec.SchemaProps{
							Description: "master is the address of the Kubernetes API server (overrides any value in kubeconfig)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"oomScoreAdj": {
						SchemaProps: spec.SchemaProps{
							Description: "oomScoreAdj is the oom-score-adj value for kube-proxy process. Values must be within the range [-1000, 1000]",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "mode specifies which proxy mode to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"portRange": {
						SchemaProps: spec.SchemaProps{
							Description: "portRange is the range of host ports (beginPort-endPort, inclusive) that may be consumed in order to proxy service traffic. If unspecified (0-0) then ports will be randomly chosen.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceContainer": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceContainer is the absolute name of the resource-only container to create and run the Kube-proxy in (Default: /kube-proxy).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"udpTimeoutMilliseconds": {
						SchemaProps: spec.SchemaProps{
							Description: "udpIdleTimeout is how long an idle UDP connection will be kept open (e.g. '250ms', '2s'). Must be greater than 0. Only applicable for proxyMode=userspace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"conntrackMax": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMax is the maximum number of NAT connections to track (0 to leave as-is).  This takes precedence over conntrackMaxPerCore and conntrackMin.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackMaxPerCore": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMaxPerCore is the maximum number of NAT connections to track per CPU core (0 to leave the limit as-is and ignore conntrackMin).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackMin": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMin is the minimum value of connect-tracking records to allocate, regardless of conntrackMaxPerCore (set conntrackMaxPerCore=0 to leave the limit as-is).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackTCPEstablishedTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackTCPEstablishedTimeout is how long an idle TCP connection will be kept open (e.g. '2s').  Must be greater than 0.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"conntrackTCPCloseWaitTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackTCPCloseWaitTimeout is how long an idle conntrack entry in CLOSE_WAIT state will remain in the conntrack table. (e.g. '60s'). Must be greater than 0 to set.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"TypeMeta", "bindAddress", "clusterCIDR", "healthzBindAddress", "healthzPort", "hostnameOverride", "iptablesMasqueradeBit", "iptablesSyncPeriodSeconds", "iptablesMinSyncPeriodSeconds", "kubeconfigPath", "masqueradeAll", "master", "oomScoreAdj", "mode", "portRange", "resourceContainer", "udpTimeoutMilliseconds", "conntrackMax", "conntrackMaxPerCore", "conntrackMin", "conntrackTCPEstablishedTimeout", "conntrackTCPCloseWaitTimeout"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration", "unversioned.TypeMeta"},
	},
	"componentconfig.KubeSchedulerConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "port is the port that the scheduler's http service runs on.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "address is the IP address to serve on.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"algorithmProvider": {
						SchemaProps: spec.SchemaProps{
							Description: "algorithmProvider is the scheduling algorithm provider to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policyConfigFile": {
						SchemaProps: spec.SchemaProps{
							Description: "policyConfigFile is the filepath to the scheduler policy configuration.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableProfiling": {
						SchemaProps: spec.SchemaProps{
							Description: "enableProfiling enables profiling via web interface.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"contentType": {
						SchemaProps: spec.SchemaProps{
							Description: "contentType is contentType of requests sent to apiserver.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeAPIQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIQPS is the QPS to use while talking with kubernetes apiserver.",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"kubeAPIBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIBurst is the QPS burst to use while talking with kubernetes apiserver.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"schedulerName": {
						SchemaProps: spec.SchemaProps{
							Description: "schedulerName is name of the scheduler, used to select which pods will be processed by this scheduler, based on pod's annotation with key 'scheduler.alpha.kubernetes.io/name'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hardPodAffinitySymmetricWeight": {
						SchemaProps: spec.SchemaProps{
							Description: "RequiredDuringScheduling affinity is not symmetric, but there is an implicit PreferredDuringScheduling affinity rule corresponding to every RequiredDuringScheduling affinity rule. HardPodAffinitySymmetricWeight represents the weight of implicit PreferredDuringScheduling affinity rule, in the range 0-100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failureDomains": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicate the \"all topologies\" set for empty topologyKey when it's used for PreferredDuringScheduling pod anti-affinity.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"leaderElection": {
						SchemaProps: spec.SchemaProps{
							Description: "leaderElection defines the configuration of leader election client.",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.LeaderElectionConfiguration"),
						},
					},
				},
				Required: []string{"TypeMeta", "port", "address", "algorithmProvider", "policyConfigFile", "enableProfiling", "contentType", "kubeAPIQPS", "kubeAPIBurst", "schedulerName", "hardPodAffinitySymmetricWeight", "failureDomains", "leaderElection"},
			},
		},
		Dependencies: []string{
			"componentconfig.LeaderElectionConfiguration", "unversioned.TypeMeta"},
	},
	"componentconfig.KubeletAnonymousAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "enabled allows anonymous requests to the kubelet server. Requests that are not rejected by another authentication method are treated as anonymous requests. Anonymous requests have a username of system:anonymous, and a group name of system:unauthenticated.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
		Dependencies: []string{},
	},
	"componentconfig.KubeletAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"x509": {
						SchemaProps: spec.SchemaProps{
							Description: "x509 contains settings related to x509 client certificate authentication",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletX509Authentication"),
						},
					},
					"webhook": {
						SchemaProps: spec.SchemaProps{
							Description: "webhook contains settings related to webhook bearer token authentication",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletWebhookAuthentication"),
						},
					},
					"anonymous": {
						SchemaProps: spec.SchemaProps{
							Description: "anonymous contains settings related to anonymous authentication",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletAnonymousAuthentication"),
						},
					},
				},
				Required: []string{"x509", "webhook", "anonymous"},
			},
		},
		Dependencies: []string{
			"componentconfig.KubeletAnonymousAuthentication", "componentconfig.KubeletWebhookAuthentication", "componentconfig.KubeletX509Authentication"},
	},
	"componentconfig.KubeletAuthorization": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "mode is the authorization mode to apply to requests to the kubelet server. Valid values are AlwaysAllow and Webhook. Webhook mode uses the SubjectAccessReview API to determine authorization.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"webhook": {
						SchemaProps: spec.SchemaProps{
							Description: "webhook contains settings related to Webhook authorization.",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletWebhookAuthorization"),
						},
					},
				},
				Required: []string{"mode", "webhook"},
			},
		},
		Dependencies: []string{
			"componentconfig.KubeletWebhookAuthorization"},
	},
	"componentconfig.KubeletConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"podManifestPath": {
						SchemaProps: spec.SchemaProps{
							Description: "podManifestPath is the path to the directory containing pod manifests to run, or the path to a single manifest file",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"syncFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "syncFrequency is the max period between synchronizing running containers and config",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"fileCheckFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "fileCheckFrequency is the duration between checking config files for new data",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"httpCheckFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "httpCheckFrequency is the duration between checking http for new data",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"manifestURL": {
						SchemaProps: spec.SchemaProps{
							Description: "manifestURL is the URL for accessing the container manifest",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"manifestURLHeader": {
						SchemaProps: spec.SchemaProps{
							Description: "manifestURLHeader is the HTTP header to use when accessing the manifest URL, with the key separated from the value with a ':', as in 'key:value'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableServer": {
						SchemaProps: spec.SchemaProps{
							Description: "enableServer enables the Kubelet's server",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "address is the IP address for the Kubelet to serve on (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "port is the port for the Kubelet to serve on.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnlyPort": {
						SchemaProps: spec.SchemaProps{
							Description: "readOnlyPort is the read-only port for the Kubelet to serve on with no authentication/authorization (set to 0 to disable)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"tlsCertFile": {
						SchemaProps: spec.SchemaProps{
							Description: "tlsCertFile is the file containing x509 Certificate for HTTPS.  (CA cert, if any, concatenated after server cert). If tlsCertFile and tlsPrivateKeyFile are not provided, a self-signed certificate and key are generated for the public address and saved to the directory passed to certDir.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tlsPrivateKeyFile": {
						SchemaProps: spec.SchemaProps{
							Description: "tlsPrivateKeyFile is the ile containing x509 private key matching tlsCertFile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"certDirectory": {
						SchemaProps: spec.SchemaProps{
							Description: "certDirectory is the directory where the TLS certs are located (by default /var/run/kubernetes). If tlsCertFile and tlsPrivateKeyFile are provided, this flag will be ignored.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"authentication": {
						SchemaProps: spec.SchemaProps{
							Description: "authentication specifies how requests to the Kubelet's server are authenticated",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletAuthentication"),
						},
					},
					"authorization": {
						SchemaProps: spec.SchemaProps{
							Description: "authorization specifies how requests to the Kubelet's server are authorized",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.KubeletAuthorization"),
						},
					},
					"hostnameOverride": {
						SchemaProps: spec.SchemaProps{
							Description: "hostnameOverride is the hostname used to identify the kubelet instead of the actual hostname.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podInfraContainerImage": {
						SchemaProps: spec.SchemaProps{
							Description: "podInfraContainerImage is the image whose network/ipc namespaces containers in each pod will use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dockerEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "dockerEndpoint is the path to the docker endpoint to communicate with.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rootDirectory": {
						SchemaProps: spec.SchemaProps{
							Description: "rootDirectory is the directory path to place kubelet files (volume mounts,etc).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seccompProfileRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "seccompProfileRoot is the directory path for seccomp profiles.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"allowPrivileged": {
						SchemaProps: spec.SchemaProps{
							Description: "allowPrivileged enables containers to request privileged mode. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostNetworkSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostNetworkSources is a comma-separated list of sources from which the Kubelet allows pods to use of host network. Defaults to \"*\". Valid options are \"file\", \"http\", \"api\", and \"*\" (all sources).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostPIDSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostPIDSources is a comma-separated list of sources from which the Kubelet allows pods to use the host pid namespace. Defaults to \"*\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostIPCSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostIPCSources is a comma-separated list of sources from which the Kubelet allows pods to use the host ipc namespace. Defaults to \"*\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"registryPullQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "registryPullQPS is the limit of registry pulls per second. If 0, unlimited. Set to 0 for no limit. Defaults to 5.0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"registryBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "registryBurst is the maximum size of a bursty pulls, temporarily allows pulls to burst to this number, while still not exceeding registryQps. Only used if registryQPS > 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"eventRecordQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "eventRecordQPS is the maximum event creations per second. If 0, there is no limit enforced.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"eventBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "eventBurst is the maximum size of a bursty event records, temporarily allows event records to burst to this number, while still not exceeding event-qps. Only used if eventQps > 0",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"enableDebuggingHandlers": {
						SchemaProps: spec.SchemaProps{
							Description: "enableDebuggingHandlers enables server endpoints for log collection and local running of containers and commands",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"minimumGCAge": {
						SchemaProps: spec.SchemaProps{
							Description: "minimumGCAge is the minimum age for a finished container before it is garbage collected.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"maxPerPodContainerCount": {
						SchemaProps: spec.SchemaProps{
							Description: "maxPerPodContainerCount is the maximum number of old instances to retain per container. Each container takes up some disk space.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxContainerCount": {
						SchemaProps: spec.SchemaProps{
							Description: "maxContainerCount is the maximum number of old instances of containers to retain globally. Each container takes up some disk space.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"cAdvisorPort": {
						SchemaProps: spec.SchemaProps{
							Description: "cAdvisorPort is the port of the localhost cAdvisor endpoint",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"healthzPort": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzPort is the port of the localhost healthz endpoint",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"healthzBindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzBindAddress is the IP address for the healthz server to serve on.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"oomScoreAdj": {
						SchemaProps: spec.SchemaProps{
							Description: "oomScoreAdj is The oom-score-adj value for kubelet process. Values must be within the range [-1000, 1000].",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"registerNode": {
						SchemaProps: spec.SchemaProps{
							Description: "registerNode enables automatic registration with the apiserver.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterDomain is the DNS domain for this cluster. If set, kubelet will configure all containers to search this domain in addition to the host's search domains.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"masterServiceNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "masterServiceNamespace is The namespace from which the kubernetes master services should be injected into pods.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterDNS": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterDNS is the IP address for a cluster DNS server.  If set, kubelet will configure all containers to use this for DNS resolution in addition to the host's DNS servers",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"streamingConnectionIdleTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "streamingConnectionIdleTimeout is the maximum time a streaming connection can be idle before the connection is automatically closed.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeStatusUpdateFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeStatusUpdateFrequency is the frequency that kubelet posts node status to master. Note: be cautious when changing the constant, it must work with nodeMonitorGracePeriod in nodecontroller.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"imageMinimumGCAge": {
						SchemaProps: spec.SchemaProps{
							Description: "imageMinimumGCAge is the minimum age for an unused image before it is garbage collected.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"imageGCHighThresholdPercent": {
						SchemaProps: spec.SchemaProps{
							Description: "imageGCHighThresholdPercent is the percent of disk usage after which image garbage collection is always run.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"imageGCLowThresholdPercent": {
						SchemaProps: spec.SchemaProps{
							Description: "imageGCLowThresholdPercent is the percent of disk usage before which image garbage collection is never run. Lowest disk usage to garbage collect to.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lowDiskSpaceThresholdMB": {
						SchemaProps: spec.SchemaProps{
							Description: "lowDiskSpaceThresholdMB is the absolute free disk space, in MB, to maintain. When disk space falls below this threshold, new pods would be rejected.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"volumeStatsAggPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "How frequently to calculate and cache volume disk usage for all pods",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"networkPluginName": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginName is the name of the network plugin to be invoked for various events in kubelet/pod lifecycle",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkPluginMTU": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginMTU is the MTU to be passed to the network plugin, and overrides the default MTU for cases where it cannot be automatically computed (such as IPSEC).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"networkPluginDir": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginDir is the full path of the directory in which to search for network plugins (and, for backwards-compat, CNI config files)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cniConfDir": {
						SchemaProps: spec.SchemaProps{
							Description: "CNIConfDir is the full path of the directory in which to search for CNI config files",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cniBinDir": {
						SchemaProps: spec.SchemaProps{
							Description: "CNIBinDir is the full path of the directory in which to search for CNI plugin binaries",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumePluginDir": {
						SchemaProps: spec.SchemaProps{
							Description: "volumePluginDir is the full path of the directory in which to search for additional third party volume plugins",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cloudProvider": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudProvider is the provider for cloud services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cloudConfigFile": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudConfigFile is the path to the cloud provider configuration file.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeletCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeletCgroups is the absolute name of cgroups to isolate the kubelet in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalCgroupsPerQOS": {
						SchemaProps: spec.SchemaProps{
							Description: "Enable QoS based Cgroup hierarchy: top level cgroups for QoS Classes And all Burstable and BestEffort pods are brought up under their specific top level QoS cgroup.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cgroupDriver": {
						SchemaProps: spec.SchemaProps{
							Description: "driver that the kubelet uses to manipulate cgroups on the host (cgroupfs or systemd)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"runtimeCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "Cgroups that container runtime is expected to be isolated in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"systemCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemCgroups is absolute name of cgroups in which to place all non-kernel processes that are not already in a container. Empty for no container. Rolling back the flag requires a reboot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cgroupRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "CgroupRoot is the root cgroup to use for pods. If ExperimentalCgroupsPerQOS is enabled, this is the root of the QoS cgroup hierarchy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntime": {
						SchemaProps: spec.SchemaProps{
							Description: "containerRuntime is the container runtime to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"remoteRuntimeEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "remoteRuntimeEndpoint is the endpoint of remote runtime service",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"remoteImageEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "remoteImageEndpoint is the endpoint of remote image service",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"runtimeRequestTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "runtimeRequestTimeout is the timeout for all runtime requests except long running requests - pull, logs, exec and attach.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"rktPath": {
						SchemaProps: spec.SchemaProps{
							Description: "rktPath is the path of rkt binary. Leave empty to use the first rkt in $PATH.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalMounterPath": {
						SchemaProps: spec.SchemaProps{
							Description: "experimentalMounterPath is the path of mounter binary. Leave empty to use the default mount path",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rktAPIEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "rktApiEndpoint is the endpoint of the rkt API service to communicate with.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rktStage1Image": {
						SchemaProps: spec.SchemaProps{
							Description: "rktStage1Image is the image to use as stage1. Local paths and http/https URLs are supported.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lockFilePath": {
						SchemaProps: spec.SchemaProps{
							Description: "lockFilePath is the path that kubelet will use to as a lock file. It uses this file as a lock to synchronize with other kubelet processes that may be running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"exitOnLockContention": {
						SchemaProps: spec.SchemaProps{
							Description: "ExitOnLockContention is a flag that signifies to the kubelet that it is running in \"bootstrap\" mode. This requires that 'LockFilePath' has been set. This will cause the kubelet to listen to inotify events on the lock file, releasing it and exiting when another process tries to open that file.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hairpinMode": {
						SchemaProps: spec.SchemaProps{
							Description: "How should the kubelet configure the container bridge for hairpin packets. Setting this flag allows endpoints in a Service to loadbalance back to themselves if they should try to access their own Service. Values:\n  \"promiscuous-bridge\": make the container bridge promiscuous.\n  \"hairpin-veth\":       set the hairpin flag on container veth interfaces.\n  \"none\":               do nothing.\nGenerally, one must set --hairpin-mode=veth-flag to achieve hairpin NAT, because promiscous-bridge assumes the existence of a container bridge named cbr0.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"babysitDaemons": {
						SchemaProps: spec.SchemaProps{
							Description: "The node has babysitter process monitoring docker and kubelet.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"maxPods": {
						SchemaProps: spec.SchemaProps{
							Description: "maxPods is the number of pods that can run on this Kubelet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nvidiaGPUs": {
						SchemaProps: spec.SchemaProps{
							Description: "nvidiaGPUs is the number of NVIDIA GPU devices on this node.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"dockerExecHandlerName": {
						SchemaProps: spec.SchemaProps{
							Description: "dockerExecHandlerName is the handler to use when executing a command in a container. Valid values are 'native' and 'nsenter'. Defaults to 'native'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "The CIDR to use for pod IP addresses, only used in standalone mode. In cluster mode, this is obtained from the master.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resolvConf": {
						SchemaProps: spec.SchemaProps{
							Description: "ResolverConfig is the resolver configuration file used as the basis for the container DNS resolution configuration.\"), []",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cpuCFSQuota": {
						SchemaProps: spec.SchemaProps{
							Description: "cpuCFSQuota is Enable CPU CFS quota enforcement for containers that specify CPU limits",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"containerized": {
						SchemaProps: spec.SchemaProps{
							Description: "containerized should be set to true if kubelet is running in a container.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"maxOpenFiles": {
						SchemaProps: spec.SchemaProps{
							Description: "maxOpenFiles is Number of files that can be opened by Kubelet process.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"reconcileCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "reconcileCIDR is Reconcile node CIDR with the CIDR specified by the API server. Won't have any effect if register-node is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"registerSchedulable": {
						SchemaProps: spec.SchemaProps{
							Description: "registerSchedulable tells the kubelet to register the node as schedulable. Won't have any effect if register-node is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"contentType": {
						SchemaProps: spec.SchemaProps{
							Description: "contentType is contentType of requests sent to apiserver.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeAPIQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIQPS is the QPS to use while talking with kubernetes apiserver",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"kubeAPIBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIBurst is the burst to allow while talking with kubernetes apiserver",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"serializeImagePulls": {
						SchemaProps: spec.SchemaProps{
							Description: "serializeImagePulls when enabled, tells the Kubelet to pull images one at a time. We recommend *not* changing the default value on nodes that run docker daemon with version  < 1.9 or an Aufs storage backend. Issue #10959 has more details.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"outOfDiskTransitionFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "outOfDiskTransitionFrequency is duration for which the kubelet has to wait before transitioning out of out-of-disk node condition status.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeIP": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeIP is IP address of the node. If set, kubelet will use this IP address for the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeLabels to add when registering the node in the cluster.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"nonMasqueradeCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "nonMasqueradeCIDR configures masquerading: traffic to IPs outside this range will use IP masquerade.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableCustomMetrics": {
						SchemaProps: spec.SchemaProps{
							Description: "enable gathering custom metrics.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evictionHard": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of hard eviction expressions.  For example, 'memory.available<300Mi'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionSoft": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of soft eviction expressions.  For example, 'memory.available<300Mi'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionSoftGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimeted list of grace periods for each soft eviction signal.  For example, 'memory.available=30s'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionPressureTransitionPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Duration for which the kubelet has to wait before transitioning out of an eviction pressure condition.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"evictionMaxPodGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum allowed grace period (in seconds) to use when terminating pods in response to a soft eviction threshold being met.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionMinimumReclaim": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of minimum reclaims (e.g. imagefs.available=2Gi) that describes the minimum amount of resource the kubelet will reclaim when performing a pod eviction if that resource is under pressure.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalKernelMemcgNotification": {
						SchemaProps: spec.SchemaProps{
							Description: "If enabled, the kubelet will integrate with the kernel memcg notification to determine if memory eviction thresholds are crossed rather than polling.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"podsPerCore": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum number of pods per core. Cannot exceed MaxPods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"enableControllerAttachDetach": {
						SchemaProps: spec.SchemaProps{
							Description: "enableControllerAttachDetach enables the Attach/Detach controller to manage attachment/detachment of volumes scheduled to this node, and disables kubelet from executing any attach/detach operations",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"systemReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "A set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently only cpu and memory are supported. [default=none] See http://kubernetes.io/docs/user-guide/compute-resources for more detail.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"kubeReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "A set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently only cpu and memory are supported. [default=none] See http://kubernetes.io/docs/user-guide/compute-resources for more detail.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"protectKernelDefaults": {
						SchemaProps: spec.SchemaProps{
							Description: "Default behaviour for kernel tuning",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"makeIPTablesUtilChains": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, Kubelet ensures a set of iptables rules are present on host. These rules will serve as utility for various components, e.g. kube-proxy. The rules will be created based on IPTablesMasqueradeBit and IPTablesDropBit.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"iptablesMasqueradeBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMasqueradeBit is the bit of the iptables fwmark space to use for SNAT Values must be within the range [0, 31]. Warning: Please match the value of corresponding parameter in kube-proxy",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iptablesDropBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesDropBit is the bit of the iptables fwmark space to use for dropping packets. Kubelet will ensure iptables mark and drop rules. Values must be within the range [0, 31]. Must be different from IPTablesMasqueradeBit",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"experimentalAllowedUnsafeSysctls": {
						SchemaProps: spec.SchemaProps{
							Description: "Whitelist of unsafe sysctls or sysctl patterns (ending in *).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "featureGates is a string of comma-separated key=value pairs that describe feature gates for alpha/experimental features.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableCRI": {
						SchemaProps: spec.SchemaProps{
							Description: "Enable Container Runtime Interface (CRI) integration.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"experimentalFailSwapOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Tells the Kubelet to fail to start if swap is enabled on the node.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"ExperimentalCheckNodeCapabilitiesBeforeMount": {
						SchemaProps: spec.SchemaProps{
							Description: "This flag, if set, enables a check prior to mount operations to verify that the required components (binaries, etc.) to mount the volume are available on the underlying node. If the check is enabled and fails the mount operation fails.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"KeepTerminatedPodVolumes": {
						SchemaProps: spec.SchemaProps{
							Description: "This flag, if set, instructs the kubelet to keep volumes from terminated pods mounted to the node. This can be useful for debugging volume related issues.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"TypeMeta", "podManifestPath", "syncFrequency", "fileCheckFrequency", "httpCheckFrequency", "manifestURL", "manifestURLHeader", "enableServer", "address", "port", "readOnlyPort", "tlsCertFile", "tlsPrivateKeyFile", "certDirectory", "authentication", "authorization", "hostnameOverride", "podInfraContainerImage", "dockerEndpoint", "rootDirectory", "seccompProfileRoot", "allowPrivileged", "hostNetworkSources", "hostPIDSources", "hostIPCSources", "registryPullQPS", "registryBurst", "eventRecordQPS", "eventBurst", "enableDebuggingHandlers", "minimumGCAge", "maxPerPodContainerCount", "maxContainerCount", "cAdvisorPort", "healthzPort", "healthzBindAddress", "oomScoreAdj", "registerNode", "clusterDomain", "masterServiceNamespace", "clusterDNS", "streamingConnectionIdleTimeout", "nodeStatusUpdateFrequency", "imageMinimumGCAge", "imageGCHighThresholdPercent", "imageGCLowThresholdPercent", "lowDiskSpaceThresholdMB", "volumeStatsAggPeriod", "networkPluginName", "networkPluginMTU", "networkPluginDir", "cniConfDir", "cniBinDir", "volumePluginDir", "containerRuntime", "remoteRuntimeEndpoint", "remoteImageEndpoint", "lockFilePath", "exitOnLockContention", "hairpinMode", "babysitDaemons", "maxPods", "nvidiaGPUs", "dockerExecHandlerName", "podCIDR", "resolvConf", "cpuCFSQuota", "containerized", "maxOpenFiles", "reconcileCIDR", "registerSchedulable", "contentType", "kubeAPIQPS", "kubeAPIBurst", "serializeImagePulls", "nodeLabels", "nonMasqueradeCIDR", "enableCustomMetrics", "podsPerCore", "enableControllerAttachDetach", "systemReserved", "kubeReserved", "protectKernelDefaults", "makeIPTablesUtilChains", "iptablesMasqueradeBit", "iptablesDropBit", "featureGates"},
			},
		},
		Dependencies: []string{
			"componentconfig.KubeletAuthentication", "componentconfig.KubeletAuthorization", "unversioned.Duration", "unversioned.TypeMeta"},
	},
	"componentconfig.KubeletWebhookAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "enabled allows bearer token authentication backed by the tokenreviews.authentication.k8s.io API",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cacheTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheTTL enables caching of authentication results",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"enabled", "cacheTTL"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"componentconfig.KubeletWebhookAuthorization": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"cacheAuthorizedTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheAuthorizedTTL is the duration to cache 'authorized' responses from the webhook authorizer.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"cacheUnauthorizedTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheUnauthorizedTTL is the duration to cache 'unauthorized' responses from the webhook authorizer.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"cacheAuthorizedTTL", "cacheUnauthorizedTTL"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"componentconfig.KubeletX509Authentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"clientCAFile": {
						SchemaProps: spec.SchemaProps{
							Description: "clientCAFile is the path to a PEM-encoded certificate bundle. If set, any request presenting a client certificate signed by one of the authorities in the bundle is authenticated with a username corresponding to the CommonName, and groups corresponding to the Organization in the client certificate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientCAFile"},
			},
		},
		Dependencies: []string{},
	},
	"componentconfig.LeaderElectionConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LeaderElectionConfiguration defines the configuration of leader election clients for components that can run with leader election enabled.",
				Properties: map[string]spec.Schema{
					"leaderElect": {
						SchemaProps: spec.SchemaProps{
							Description: "leaderElect enables a leader election client to gain leadership before executing the main loop. Enable this when running replicated components for high availability.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"leaseDuration": {
						SchemaProps: spec.SchemaProps{
							Description: "leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"renewDeadline": {
						SchemaProps: spec.SchemaProps{
							Description: "renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"retryPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"leaderElect", "leaseDuration", "renewDeadline", "retryPeriod"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"componentconfig.PersistentVolumeRecyclerConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"maximumRetry": {
						SchemaProps: spec.SchemaProps{
							Description: "maximumRetry is number of retries the PV recycler will execute on failure to recycle PV.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minimumTimeoutNFS": {
						SchemaProps: spec.SchemaProps{
							Description: "minimumTimeoutNFS is the minimum ActiveDeadlineSeconds to use for an NFS Recycler pod.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"podTemplateFilePathNFS": {
						SchemaProps: spec.SchemaProps{
							Description: "podTemplateFilePathNFS is the file path to a pod definition used as a template for NFS persistent volume recycling",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"incrementTimeoutNFS": {
						SchemaProps: spec.SchemaProps{
							Description: "incrementTimeoutNFS is the increment of time added per Gi to ActiveDeadlineSeconds for an NFS scrubber pod.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"podTemplateFilePathHostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "podTemplateFilePathHostPath is the file path to a pod definition used as a template for HostPath persistent volume recycling. This is for development and testing only and will not work in a multi-node cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"minimumTimeoutHostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "minimumTimeoutHostPath is the minimum ActiveDeadlineSeconds to use for a HostPath Recycler pod.  This is for development and testing only and will not work in a multi-node cluster.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"incrementTimeoutHostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "incrementTimeoutHostPath is the increment of time added per Gi to ActiveDeadlineSeconds for a HostPath scrubber pod.  This is for development and testing only and will not work in a multi-node cluster.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"maximumRetry", "minimumTimeoutNFS", "podTemplateFilePathNFS", "incrementTimeoutNFS", "podTemplateFilePathHostPath", "minimumTimeoutHostPath", "incrementTimeoutHostPath"},
			},
		},
		Dependencies: []string{},
	},
	"componentconfig.PortRangeVar": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"Val": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Val"},
			},
		},
		Dependencies: []string{},
	},
	"componentconfig.VolumeConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VolumeConfiguration contains *all* enumerated flags meant to configure all volume plugins. From this config, the controller-manager binary will create many instances of volume.VolumeConfig, each containing only the configuration needed for that plugin which are then passed to the appropriate plugin. The ControllerManager binary is the only part of the code which knows what plugins are supported and which flags correspond to each plugin.",
				Properties: map[string]spec.Schema{
					"enableHostPathProvisioning": {
						SchemaProps: spec.SchemaProps{
							Description: "enableHostPathProvisioning enables HostPath PV provisioning when running without a cloud provider. This allows testing and development of provisioning features. HostPath provisioning is not supported in any way, won't work in a multi-node cluster, and should not be used for anything other than testing or development.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"enableDynamicProvisioning": {
						SchemaProps: spec.SchemaProps{
							Description: "enableDynamicProvisioning enables the provisioning of volumes when running within an environment that supports dynamic provisioning. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"persitentVolumeRecyclerConfiguration": {
						SchemaProps: spec.SchemaProps{
							Description: "persistentVolumeRecyclerConfiguration holds configuration for persistent volume plugins.",
							Ref:         spec.MustCreateRef("#/definitions/componentconfig.PersistentVolumeRecyclerConfiguration"),
						},
					},
					"flexVolumePluginDir": {
						SchemaProps: spec.SchemaProps{
							Description: "volumePluginDir is the full path of the directory in which the flex volume plugin should search for additional third party volume plugins",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"enableHostPathProvisioning", "enableDynamicProvisioning", "persitentVolumeRecyclerConfiguration", "flexVolumePluginDir"},
			},
		},
		Dependencies: []string{
			"componentconfig.PersistentVolumeRecyclerConfiguration"},
	},
	"extensions.APIVersion": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An APIVersion represents a single concrete version of an object model.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of this version (e.g. 'v1').",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"extensions.CustomMetricCurrentStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric value (average).",
							Ref:         spec.MustCreateRef("#/definitions/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"extensions.CustomMetricCurrentStatusList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.CustomMetricCurrentStatus"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.CustomMetricCurrentStatus"},
	},
	"extensions.CustomMetricTarget": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Alpha-level support for Custom Metrics in HPA (as annotations).",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric value (average).",
							Ref:         spec.MustCreateRef("#/definitions/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"extensions.CustomMetricTargetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.CustomMetricTarget"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.CustomMetricTarget"},
	},
	"extensions.DaemonSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSet represents the configuration of a daemon set.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired behavior of this daemon set. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/extensions.DaemonSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/extensions.DaemonSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.DaemonSetSpec", "extensions.DaemonSetStatus"},
	},
	"extensions.DaemonSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.DaemonSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.DaemonSet", "unversioned.ListMeta"},
	},
	"extensions.DaemonSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: http://kubernetes.io/docs/user-guide/replication-controller#pod-template",
							Ref:         spec.MustCreateRef("#/definitions/api.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"api.PodTemplateSpec", "unversioned.LabelSelector"},
	},
	"extensions.DaemonSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "CurrentNumberScheduled is the number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "NumberMisscheduled is the number of nodes that are running the daemon pod, but are not supposed to run the daemon pod.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "DesiredNumberScheduled is the total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "NumberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{},
	},
	"extensions.Deployment": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.DeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.DeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.DeploymentSpec", "extensions.DeploymentStatus"},
	},
	"extensions.DeploymentCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"extensions.DeploymentList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.Deployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.Deployment", "unversioned.ListMeta"},
	},
	"extensions.DeploymentRollback": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentRollback stores the information required to rollback a deployment.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: This must match the Name of a deployment.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updatedAnnotations": {
						SchemaProps: spec.SchemaProps{
							Description: "The annotations to be updated to a deployment",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config of this deployment rollback.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.RollbackConfig"),
						},
					},
				},
				Required: []string{"name", "rollbackTo"},
			},
		},
		Dependencies: []string{
			"extensions.RollbackConfig"},
	},
	"extensions.DeploymentSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created.",
							Ref:         spec.MustCreateRef("#/definitions/api.PodTemplateSpec"),
						},
					},
					"strategy": {
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.DeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused and will not be processed by the deployment controller.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config this deployment is rolling back to. Will be cleared after rollback is done.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.RollbackConfig"),
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Once autoRollback is implemented, the deployment controller will automatically rollback failed deployments. Note that progress will not be estimated during the time a deployment is paused. This is not set by default.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"api.PodTemplateSpec", "extensions.DeploymentStrategy", "extensions.RollbackConfig", "unversioned.LabelSelector"},
	},
	"extensions.DeploymentStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.DeploymentCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.DeploymentCondition"},
	},
	"extensions.DeploymentStrategy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.RollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.RollingUpdateDeployment"},
	},
	"extensions.FSGroupStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FSGroupStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate what FSGroup is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.IDRange"},
	},
	"extensions.HTTPIngressPath": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional \"path\" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"backend": {
						SchemaProps: spec.SchemaProps{
							Description: "Backend defines the referenced service endpoint to which the traffic will be forwarded to.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.IngressBackend"),
						},
					},
				},
				Required: []string{"backend"},
			},
		},
		Dependencies: []string{
			"extensions.IngressBackend"},
	},
	"extensions.HTTPIngressRuleValue": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.",
				Properties: map[string]spec.Schema{
					"paths": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of paths that map requests to backends.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.HTTPIngressPath"),
									},
								},
							},
						},
					},
				},
				Required: []string{"paths"},
			},
		},
		Dependencies: []string{
			"extensions.HTTPIngressPath"},
	},
	"extensions.HostPortRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined.",
				Properties: map[string]spec.Schema{
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min is the start of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max is the end of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"min", "max"},
			},
		},
		Dependencies: []string{},
	},
	"extensions.IDRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IDRange provides a min/max of an allowed range of IDs.",
				Properties: map[string]spec.Schema{
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min is the start of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max is the end of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"min", "max"},
			},
		},
		Dependencies: []string{},
	},
	"extensions.Ingress": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is the desired state of the Ingress. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/extensions.IngressSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current state of the Ingress. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/extensions.IngressStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.IngressSpec", "extensions.IngressStatus"},
	},
	"extensions.IngressBackend": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressBackend describes all endpoints for a given service and port.",
				Properties: map[string]spec.Schema{
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the name of the referenced service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"servicePort": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the port of the referenced service.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
				Required: []string{"serviceName", "servicePort"},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"extensions.IngressList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressList is a collection of Ingress.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Ingress.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.Ingress"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.Ingress", "unversioned.ListMeta"},
	},
	"extensions.IngressRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.",
				Properties: map[string]spec.Schema{
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the \"host\" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the\n\t  IP in the Spec of the parent Ingress.\n2. The `:` delimiter is not respected because ports are not allowed.\n\t  Currently the port of an Ingress is implicitly :80 for http and\n\t  :443 for https.\nBoth these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"http": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/extensions.HTTPIngressRuleValue"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.HTTPIngressRuleValue"},
	},
	"extensions.IngressRuleValue": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressRuleValue represents a rule to apply against incoming requests. If the rule is satisfied, the request is routed to the specified backend. Currently mixing different types of rules in a single Ingress is disallowed, so exactly one of the following must be set.",
				Properties: map[string]spec.Schema{
					"http": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/extensions.HTTPIngressRuleValue"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.HTTPIngressRuleValue"},
	},
	"extensions.IngressSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressSpec describes the Ingress the user wishes to exist.",
				Properties: map[string]spec.Schema{
					"backend": {
						SchemaProps: spec.SchemaProps{
							Description: "A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.IngressBackend"),
						},
					},
					"tls": {
						SchemaProps: spec.SchemaProps{
							Description: "TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.IngressTLS"),
									},
								},
							},
						},
					},
					"rules": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.IngressRule"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.IngressBackend", "extensions.IngressRule", "extensions.IngressTLS"},
	},
	"extensions.IngressStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressStatus describe the current state of the Ingress.",
				Properties: map[string]spec.Schema{
					"loadBalancer": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancer contains the current status of the load-balancer.",
							Ref:         spec.MustCreateRef("#/definitions/api.LoadBalancerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.LoadBalancerStatus"},
	},
	"extensions.IngressTLS": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressTLS describes the transport layer security associated with an Ingress.",
				Properties: map[string]spec.Schema{
					"hosts": {
						SchemaProps: spec.SchemaProps{
							Description: "Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"extensions.NetworkPolicy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior for this NetworkPolicy.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.NetworkPolicySpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.NetworkPolicySpec"},
	},
	"extensions.NetworkPolicyIngressRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.",
				Properties: map[string]spec.Schema{
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is not provided, this rule matches all ports (traffic not restricted by port). If this field is empty, this rule matches no ports (no traffic matches). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.NetworkPolicyPort"),
									},
								},
							},
						},
					},
					"from": {
						SchemaProps: spec.SchemaProps{
							Description: "List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is not provided, this rule matches all sources (traffic not restricted by source). If this field is empty, this rule matches no sources (no traffic matches). If this field is present and contains at least on item, this rule allows traffic only if the traffic matches at least one item in the from list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.NetworkPolicyPeer"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.NetworkPolicyPeer", "extensions.NetworkPolicyPort"},
	},
	"extensions.NetworkPolicyList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NetworkPolicyList is a list of NetworkPolicy objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.NetworkPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.NetworkPolicy", "unversioned.ListMeta"},
	},
	"extensions.NetworkPolicyPeer": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"podSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "This is a label selector which selects Pods in this namespace. This field follows standard label selector semantics. If not provided, this selector selects no pods. If present but empty, this selector selects all pods in this namespace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects Namespaces using cluster scoped-labels.  This matches all pods in all namespaces selected by this label selector. This field follows standard label selector semantics. If omitted, this selector selects no namespaces. If present but empty, this selector selects all namespaces.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector"},
	},
	"extensions.NetworkPolicyPort": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional.  The protocol (TCP or UDP) which traffic must match. If not specified, this field defaults to TCP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"extensions.NetworkPolicySpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"podSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if namespace.networkPolicy.ingress.isolation is undefined and cluster policy allows it, OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not affect ingress isolation. If this field is present and contains at least one rule, this policy allows any traffic which matches at least one of the ingress rules in this list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.NetworkPolicyIngressRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"podSelector"},
			},
		},
		Dependencies: []string{
			"extensions.NetworkPolicyIngressRule", "unversioned.LabelSelector"},
	},
	"extensions.PodSecurityPolicy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSecurityPolicy governs the ability to make requests that affect the SecurityContext that will be applied to a pod and container.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the policy enforced.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.PodSecurityPolicySpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.PodSecurityPolicySpec"},
	},
	"extensions.PodSecurityPolicyList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSecurityPolicyList is a list of PodSecurityPolicy objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.PodSecurityPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.PodSecurityPolicy", "unversioned.ListMeta"},
	},
	"extensions.PodSecurityPolicySpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSecurityPolicySpec defines the policy enforced.",
				Properties: map[string]spec.Schema{
					"privileged": {
						SchemaProps: spec.SchemaProps{
							Description: "Privileged determines if a pod can request to be run as privileged.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"defaultAddCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both DefaultAddCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"requiredDropCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "RequiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"allowedCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both AllowedCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Description: "Volumes is a white list of allowed volume plugins.  Empty indicates that all plugins may be used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "HostNetwork determines if the policy allows the use of HostNetwork in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostPorts": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPorts determines which host port ranges are allowed to be exposed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.HostPortRange"),
									},
								},
							},
						},
					},
					"hostPID": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPID determines if the policy allows the use of HostPID in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostIPC": {
						SchemaProps: spec.SchemaProps{
							Description: "HostIPC determines if the policy allows the use of HostIPC in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"seLinux": {
						SchemaProps: spec.SchemaProps{
							Description: "SELinux is the strategy that will dictate the allowable labels that may be set.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.SELinuxStrategyOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "RunAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.RunAsUserStrategyOptions"),
						},
					},
					"supplementalGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "SupplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.SupplementalGroupsStrategyOptions"),
						},
					},
					"fsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "FSGroup is the strategy that will dictate what fs group is used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.FSGroupStrategyOptions"),
						},
					},
					"readOnlyRootFilesystem": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"seLinux", "runAsUser", "supplementalGroups", "fsGroup"},
			},
		},
		Dependencies: []string{
			"extensions.FSGroupStrategyOptions", "extensions.HostPortRange", "extensions.RunAsUserStrategyOptions", "extensions.SELinuxStrategyOptions", "extensions.SupplementalGroupsStrategyOptions"},
	},
	"extensions.ReplicaSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSet represents the configuration of a replica set.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired behavior of this ReplicaSet.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.ReplicaSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of this ReplicaSet. This data may be out of date by some window of time.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.ReplicaSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.ReplicaSetSpec", "extensions.ReplicaSetStatus"},
	},
	"extensions.ReplicaSetCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"extensions.ReplicaSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.ReplicaSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.ReplicaSet", "unversioned.ListMeta"},
	},
	"extensions.ReplicaSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet. As the internal representation of a ReplicaSet, it must have a Template set.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. Must match in order to be controlled. If empty, defaulted to labels on pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected.",
							Ref:         spec.MustCreateRef("#/definitions/api.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"api.PodTemplateSpec", "unversioned.LabelSelector"},
	},
	"extensions.ReplicaSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of actual replicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.ReplicaSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"extensions.ReplicaSetCondition"},
	},
	"extensions.ReplicationControllerDummy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Dummy definition",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"extensions.RollbackConfig": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "The revision to rollback to. If set to 0, rollbck to the last revision.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"extensions.RollingUpdateDeployment": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total pods at the start of update (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down by 30% immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that at least 70% of original number of pods are available at all times during the update.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the original number of pods. Value can be an absolute number (ex: 5) or a percentage of total pods at the start of the update (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up by 30% immediately when the rolling update starts. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is atmost 130% of original pods.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"extensions.RunAsUserStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate the allowable RunAsUser values that may be set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of uids that may be used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.IDRange"),
									},
								},
							},
						},
					},
				},
				Required: []string{"rule"},
			},
		},
		Dependencies: []string{
			"extensions.IDRange"},
	},
	"extensions.SELinuxStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SELinuxStrategyOptions defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate the allowable labels that may be set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "seLinuxOptions required to run as; required for MustRunAs More info: http://releases.k8s.io/HEAD/docs/design/security_context.md#security-context",
							Ref:         spec.MustCreateRef("#/definitions/api.SELinuxOptions"),
						},
					},
				},
				Required: []string{"rule"},
			},
		},
		Dependencies: []string{
			"api.SELinuxOptions"},
	},
	"extensions.Scale": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "represents a scaling request for a resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status. Read-only.",
							Ref:         spec.MustCreateRef("#/definitions/extensions.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.ScaleSpec", "extensions.ScaleStatus"},
	},
	"extensions.ScaleSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "describes the attributes of a scale subresource",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"extensions.ScaleStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "represents the current status of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "label query over pods that should match the replicas count. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector"},
	},
	"extensions.SupplementalGroupsStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"extensions.IDRange"},
	},
	"extensions.ThirdPartyResource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A ThirdPartyResource is a generic representation of a resource, it is used by add-ons and plugins to add new resource types to the API.  It consists of one or more Versions of the api.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is the description of this object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "Versions are versions for this third party object",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.APIVersion"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "extensions.APIVersion"},
	},
	"extensions.ThirdPartyResourceData": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An internal object, used for versioned storage in etcd.  Not exposed to the end user.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the raw JSON data for this data.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta"},
	},
	"extensions.ThirdPartyResourceDataList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of third party objects",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.ThirdPartyResourceData"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.ThirdPartyResourceData", "unversioned.ListMeta"},
	},
	"extensions.ThirdPartyResourceList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of horizontal pod autoscalers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/extensions.ThirdPartyResource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"extensions.ThirdPartyResource", "unversioned.ListMeta"},
	},
	"imagepolicy.ImageReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReview checks if the set of images in a pod are allowed.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the pod being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/imagepolicy.ImageReviewSpec"),
						},
					},
					"Status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the backend and indicates whether the pod should be allowed.",
							Ref:         spec.MustCreateRef("#/definitions/imagepolicy.ImageReviewStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Spec", "Status"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "imagepolicy.ImageReviewSpec", "imagepolicy.ImageReviewStatus", "unversioned.TypeMeta"},
	},
	"imagepolicy.ImageReviewContainerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewContainerSpec is a description of a container within the pod creation request.",
				Properties: map[string]spec.Schema{
					"Image": {
						SchemaProps: spec.SchemaProps{
							Description: "This can be in the form image:tag or image@SHA:012345679abcdef.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Image"},
			},
		},
		Dependencies: []string{},
	},
	"imagepolicy.ImageReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewSpec is a description of the pod creation request.",
				Properties: map[string]spec.Schema{
					"Containers": {
						SchemaProps: spec.SchemaProps{
							Description: "Containers is a list of a subset of the information in each container of the Pod being created.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/imagepolicy.ImageReviewContainerSpec"),
									},
								},
							},
						},
					},
					"Annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a list of key-value pairs extracted from the Pod's annotations. It only includes keys which match the pattern `*.image-policy.k8s.io/*`. It is up to each webhook backend to determine how to interpret these annotations, if at all.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"Namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace the pod is being created in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Containers", "Annotations", "Namespace"},
			},
		},
		Dependencies: []string{
			"imagepolicy.ImageReviewContainerSpec"},
	},
	"imagepolicy.ImageReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewStatus is the result of the token authentication request.",
				Properties: map[string]spec.Schema{
					"Allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed indicates that all images were allowed to be run.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"Reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason should be empty unless Allowed is false in which case it may contain a short description of what is wrong.  Kubernetes may truncate excessively long errors when displaying to the user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Allowed", "Reason"},
			},
		},
		Dependencies: []string{},
	},
	"intstr.IntOrString": intstr.IntOrString{}.OpenAPIDefinition(), "policy.Eviction": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/eviction.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectMeta describes the pod that is being evicted.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"deleteOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "DeleteOptions may be provided",
							Ref:         spec.MustCreateRef("#/definitions/api.DeleteOptions"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.DeleteOptions", "api.ObjectMeta"},
	},
	"policy.PodDisruptionBudget": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the PodDisruptionBudget.",
							Ref:         spec.MustCreateRef("#/definitions/policy.PodDisruptionBudgetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the PodDisruptionBudget.",
							Ref:         spec.MustCreateRef("#/definitions/policy.PodDisruptionBudgetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "policy.PodDisruptionBudgetSpec", "policy.PodDisruptionBudgetStatus"},
	},
	"policy.PodDisruptionBudgetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetList is a collection of PodDisruptionBudgets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/policy.PodDisruptionBudget"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"policy.PodDisruptionBudget", "unversioned.ListMeta"},
	},
	"policy.PodDisruptionBudgetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.",
				Properties: map[string]spec.Schema{
					"minAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "An eviction is allowed if at least \"minAvailable\" pods selected by \"selector\" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying \"100%\".",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label query over pods whose evictions are managed by the disruption budget.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString", "unversioned.LabelSelector"},
	},
	"policy.PodDisruptionBudgetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recent generation observed when updating this PDB status. PodDisruptionsAllowed and other status informatio is valid only if observedGeneration equals to PDB's object generation.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"disruptedPods": {
						SchemaProps: spec.SchemaProps{
							Description: "DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.Time"),
									},
								},
							},
						},
					},
					"disruptionsAllowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of pod disruptions that are currently allowed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentHealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of healthy pods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredHealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "minimum desired number of healthy pods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"expectedPods": {
						SchemaProps: spec.SchemaProps{
							Description: "total number of pods counted by this disruption budget",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"disruptedPods", "disruptionsAllowed", "currentHealthy", "desiredHealthy", "expectedPods"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"rbac.ClusterRole": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Rules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules holds all the PolicyRules for this ClusterRole",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.PolicyRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Rules"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "rbac.PolicyRule", "unversioned.TypeMeta"},
	},
	"rbac.ClusterRoleBinding": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Subjects": {
						SchemaProps: spec.SchemaProps{
							Description: "Subjects holds references to the objects the role applies to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.Subject"),
									},
								},
							},
						},
					},
					"RoleRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.",
							Ref:         spec.MustCreateRef("#/definitions/rbac.RoleRef"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Subjects", "RoleRef"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "rbac.RoleRef", "rbac.Subject", "unversioned.TypeMeta"},
	},
	"rbac.ClusterRoleBindingBuilder": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleBindingBuilder let's us attach methods.  A no-no for API types. We use it to construct bindings in code.  It's more compact than trying to write them out in a literal.",
				Properties: map[string]spec.Schema{
					"ClusterRoleBinding": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/rbac.ClusterRoleBinding"),
						},
					},
				},
				Required: []string{"ClusterRoleBinding"},
			},
		},
		Dependencies: []string{
			"rbac.ClusterRoleBinding"},
	},
	"rbac.ClusterRoleBindingList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleBindingList is a collection of ClusterRoleBindings",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ListMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"Items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ClusterRoleBindings",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.ClusterRoleBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ListMeta", "Items"},
			},
		},
		Dependencies: []string{
			"rbac.ClusterRoleBinding", "unversioned.ListMeta", "unversioned.TypeMeta"},
	},
	"rbac.ClusterRoleList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleList is a collection of ClusterRoles",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ListMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"Items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ClusterRoles",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.ClusterRole"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ListMeta", "Items"},
			},
		},
		Dependencies: []string{
			"rbac.ClusterRole", "unversioned.ListMeta", "unversioned.TypeMeta"},
	},
	"rbac.PolicyRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.",
				Properties: map[string]spec.Schema{
					"Verbs": {
						SchemaProps: spec.SchemaProps{
							Description: "Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.  VerbAll represents all kinds.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"AttributeRestrictions": {
						SchemaProps: spec.SchemaProps{
							Description: "AttributeRestrictions will vary depending on what the Authorizer/AuthorizationAttributeBuilder pair supports. If the Authorizer does not recognize how to handle the AttributeRestrictions, the Authorizer should report an error.",
							Ref:         spec.MustCreateRef("#/definitions/runtime.Object"),
						},
					},
					"APIGroups": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"Resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  ResourceAll represents all resources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"ResourceNames": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"NonResourceURLs": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path If an action is not a resource API request, then the URL is split on '/' and is checked against the NonResourceURLs to look for a match. Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as \"pods\" or \"secrets\") or non-resource URL paths (such as \"/api\"),  but not both.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"Verbs", "AttributeRestrictions", "APIGroups", "Resources", "ResourceNames", "NonResourceURLs"},
			},
		},
		Dependencies: []string{
			"runtime.Object"},
	},
	"rbac.PolicyRuleBuilder": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicyRuleBuilder let's us attach methods.  A no-no for API types. We use it to construct rules in code.  It's more compact than trying to write them out in a literal and allows us to perform some basic checking during construction",
				Properties: map[string]spec.Schema{
					"PolicyRule": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/rbac.PolicyRule"),
						},
					},
				},
				Required: []string{"PolicyRule"},
			},
		},
		Dependencies: []string{
			"rbac.PolicyRule"},
	},
	"rbac.Role": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Rules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules holds all the PolicyRules for this Role",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.PolicyRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Rules"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "rbac.PolicyRule", "unversioned.TypeMeta"},
	},
	"rbac.RoleBinding": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ObjectMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/api.ObjectMeta"),
						},
					},
					"Subjects": {
						SchemaProps: spec.SchemaProps{
							Description: "Subjects holds references to the objects the role applies to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.Subject"),
									},
								},
							},
						},
					},
					"RoleRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.",
							Ref:         spec.MustCreateRef("#/definitions/rbac.RoleRef"),
						},
					},
				},
				Required: []string{"TypeMeta", "ObjectMeta", "Subjects", "RoleRef"},
			},
		},
		Dependencies: []string{
			"api.ObjectMeta", "rbac.RoleRef", "rbac.Subject", "unversioned.TypeMeta"},
	},
	"rbac.RoleBindingList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleBindingList is a collection of RoleBindings",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ListMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"Items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of roleBindings",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.RoleBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ListMeta", "Items"},
			},
		},
		Dependencies: []string{
			"rbac.RoleBinding", "unversioned.ListMeta", "unversioned.TypeMeta"},
	},
	"rbac.RoleList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleList is a collection of Roles",
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"ListMeta": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"Items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of roles",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/rbac.Role"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMeta", "ListMeta", "Items"},
			},
		},
		Dependencies: []string{
			"rbac.Role", "unversioned.ListMeta", "unversioned.TypeMeta"},
	},
	"rbac.RoleRef": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleRef contains information that points to the role being used",
				Properties: map[string]spec.Schema{
					"APIGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup is the group for the resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the type of resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"APIGroup", "Kind", "Name"},
			},
		},
		Dependencies: []string{},
	},
	"rbac.Subject": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.",
				Properties: map[string]spec.Schema{
					"Kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"APIVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion holds the API group and version of the referenced object. For non-object references such as \"Group\" and \"User\" this is expected to be API version of this API group. For example, \"rbac/v1alpha1\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object being referenced.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"Namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Kind", "APIVersion", "Name", "Namespace"},
			},
		},
		Dependencies: []string{},
	},
	"resource.Quantity": resource.Quantity{}.OpenAPIDefinition(), "resource.int64Amount": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "int64Amount represents a fixed precision numerator and arbitrary scale exponent. It is faster than operations on inf.Dec for values that can be represented as int64.",
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
					"scale": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
				},
				Required: []string{"value", "scale"},
			},
		},
		Dependencies: []string{},
	},
	"runtime.RawExtension": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RawExtension is used to hold extensions in external versions.\n\nTo use this, make a field which has RawExtension as its type in your external, versioned struct, and Object in your internal struct. You also need to register your various plugin types.\n\n// Internal package: type MyAPIObject struct {\n\truntime.TypeMeta `json:\",inline\"`\n\tMyPlugin runtime.Object `json:\"myPlugin\"`\n} type PluginA struct {\n\tAOption string `json:\"aOption\"`\n}\n\n// External package: type MyAPIObject struct {\n\truntime.TypeMeta `json:\",inline\"`\n\tMyPlugin runtime.RawExtension `json:\"myPlugin\"`\n} type PluginA struct {\n\tAOption string `json:\"aOption\"`\n}\n\n// On the wire, the JSON will look something like this: {\n\t\"kind\":\"MyAPIObject\",\n\t\"apiVersion\":\"v1\",\n\t\"myPlugin\": {\n\t\t\"kind\":\"PluginA\",\n\t\t\"aOption\":\"foo\",\n\t},\n}\n\nSo what happens? Decode first uses json or yaml to unmarshal the serialized data into your external MyAPIObject. That causes the raw JSON to be stored, but not unpacked. The next step is to copy (using pkg/conversion) into the internal struct. The runtime package's DefaultScheme has conversion functions installed which will unpack the JSON stored in RawExtension, turning it into the correct object type, and storing it in the Object. (TODO: In the case where the object is of an unknown type, a runtime.Unknown object will be created and stored.)",
				Properties: map[string]spec.Schema{
					"Raw": {
						SchemaProps: spec.SchemaProps{
							Description: "Raw is the underlying serialization of this object.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
				Required: []string{"Raw"},
			},
		},
		Dependencies: []string{},
	},
	"runtime.TypeMeta": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeMeta is shared by all top level objects. The proper way to use it is to inline it in your type, like this: type MyAwesomeAPIObject struct {\n     runtime.TypeMeta    `json:\",inline\"`\n     ... // other fields\n} func (obj *MyAwesomeAPIObject) SetGroupVersionKind(gvk *unversioned.GroupVersionKind) { unversioned.UpdateTypeMeta(obj,gvk) }; GroupVersionKind() *GroupVersionKind\n\nTypeMeta is provided here for convenience. You may use it directly from this package or define your own with the same fields.",
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"runtime.Unknown": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Unknown allows api objects with unknown types to be passed-through. This can be used to deal with the API objects from a plug-in. Unknown objects still have functioning TypeMeta features-- kind, version, etc. metadata and field mutatation.",
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Raw": {
						SchemaProps: spec.SchemaProps{
							Description: "Raw will hold the complete serialized object which couldn't be matched with a registered type. Most likely, nothing should be done with this except for passing it through the system.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
					"ContentEncoding": {
						SchemaProps: spec.SchemaProps{
							Description: "ContentEncoding is encoding used to encode 'Raw' data. Unspecified means no encoding.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ContentType": {
						SchemaProps: spec.SchemaProps{
							Description: "ContentType  is serialization method used to serialize 'Raw'. Unspecified means ContentTypeJSON.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Raw", "ContentEncoding", "ContentType"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.APIGroup": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroup contains the name, the supported versions, and the preferred version of a group.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.GroupVersionForDiscovery"),
									},
								},
							},
						},
					},
					"preferredVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "preferredVersion is the version preferred by the API server, which probably is the storage version.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.GroupVersionForDiscovery"),
						},
					},
					"serverAddressByClientCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.ServerAddressByClientCIDR"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "versions", "serverAddressByClientCIDRs"},
			},
		},
		Dependencies: []string{
			"unversioned.GroupVersionForDiscovery", "unversioned.ServerAddressByClientCIDR"},
	},
	"unversioned.APIGroupList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Description: "groups is a list of APIGroup.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.APIGroup"),
									},
								},
							},
						},
					},
				},
				Required: []string{"groups"},
			},
		},
		Dependencies: []string{
			"unversioned.APIGroup"},
	},
	"unversioned.APIResource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResource specifies the name of a resource and whether it is namespaced.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaced": {
						SchemaProps: spec.SchemaProps{
							Description: "namespaced indicates if a resource is namespaced or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "namespaced", "kind"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.APIResourceList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "groupVersion is the group and version this APIResourceList is for.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "resources contains the name of the resources and if they are namespaced.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.APIResource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"groupVersion", "resources"},
			},
		},
		Dependencies: []string{
			"unversioned.APIResource"},
	},
	"unversioned.APIVersions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "versions are the api versions that are available.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"serverAddressByClientCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.ServerAddressByClientCIDR"),
									},
								},
							},
						},
					},
				},
				Required: []string{"versions", "serverAddressByClientCIDRs"},
			},
		},
		Dependencies: []string{
			"unversioned.ServerAddressByClientCIDR"},
	},
	"unversioned.Duration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Duration is a wrapper around time.Duration which supports correct marshaling to YAML and JSON. In particular, it marshals into strings, which can be used as map keys in json.",
				Properties: map[string]spec.Schema{
					"Duration": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
				},
				Required: []string{"Duration"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.ExportOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExportOptions is the query options to the standard REST get call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"export": {
						SchemaProps: spec.SchemaProps{
							Description: "Should this value be exported.  Export strips fields that a user can not specify.`",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"exact": {
						SchemaProps: spec.SchemaProps{
							Description: "Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"export", "exact"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupKind": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupKind specifies a Group and a Kind, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
				Properties: map[string]spec.Schema{
					"Group": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Group", "Kind"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupResource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupResource specifies a Group and a Resource, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
				Properties: map[string]spec.Schema{
					"Group": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Resource": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Group", "Resource"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupVersion": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersion contains the \"group\" and the \"version\", which uniquely identifies the API.",
				Properties: map[string]spec.Schema{
					"Group": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Group", "Version"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupVersionForDiscovery": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.",
				Properties: map[string]spec.Schema{
					"groupVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "groupVersion specifies the API group and version in the form \"group/version\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"groupVersion", "version"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupVersionKind": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersionKind unambiguously identifies a kind.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
				Properties: map[string]spec.Schema{
					"Group": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Group", "Version", "Kind"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.GroupVersionResource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersionResource unambiguously identifies a resource.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
				Properties: map[string]spec.Schema{
					"Group": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Resource": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Group", "Version", "Resource"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.LabelSelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.",
				Properties: map[string]spec.Schema{
					"matchLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.LabelSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelectorRequirement"},
	},
	"unversioned.LabelSelectorRequirement": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key is the label key that the selector applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "operator represents a key's relationship to a set of values. Valid operators ard In, NotIn, Exists and DoesNotExist.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"values": {
						SchemaProps: spec.SchemaProps{
							Description: "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"key", "operator"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.ListMeta": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.",
				Properties: map[string]spec.Schema{
					"selfLink": {
						SchemaProps: spec.SchemaProps{
							Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.Patch": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.",
				Properties:  map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.RootPaths": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RootPaths lists the paths available at root. For example: \"/healthz\", \"/apis\".",
				Properties: map[string]spec.Schema{
					"paths": {
						SchemaProps: spec.SchemaProps{
							Description: "paths are the paths available at root.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"paths"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.ServerAddressByClientCIDR": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
				Properties: map[string]spec.Schema{
					"clientCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serverAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientCIDR", "serverAddress"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.Status": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Status is a return value for calls that don't return other objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the operation. One of: \"Success\" or \"Failure\". More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the status of this operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"details": {
						SchemaProps: spec.SchemaProps{
							Description: "Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.StatusDetails"),
						},
					},
					"code": {
						SchemaProps: spec.SchemaProps{
							Description: "Suggested HTTP return code for this status, 0 if not set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "unversioned.StatusDetails"},
	},
	"unversioned.StatusCause": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.",
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A machine-readable description of the cause of the error. If this value is empty there is no information available.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the cause of the error.  This field may be presented as-is to a reader.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"field": {
						SchemaProps: spec.SchemaProps{
							Description: "The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  \"name\" - the field \"name\" on the current resource\n  \"items[0].name\" - the field \"name\" on the first array entry in \"items\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.StatusDetails": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "The group attribute of the resource associated with the status StatusReason.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"causes": {
						SchemaProps: spec.SchemaProps{
							Description: "The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.StatusCause"),
									},
								},
							},
						},
					},
					"retryAfterSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the time in seconds before the operation should be retried.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.StatusCause"},
	},
	"unversioned.Time": unversioned.Time{}.OpenAPIDefinition(), "unversioned.Timestamp": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Timestamp is a struct that is equivalent to Time, but intended for protobuf marshalling/unmarshalling. It is generated into a serialization that matches Time. Do not use in Go structs.",
				Properties: map[string]spec.Schema{
					"seconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"nanos": {
						SchemaProps: spec.SchemaProps{
							Description: "Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"seconds", "nanos"},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.TypeMeta": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeMeta describes an individual object in an API response or request with strings representing the type of the object and its API schema version. Structures that are versioned or persisted should inline TypeMeta.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"unversioned.emptyObjectKind": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	},
	"v1.AWSElasticBlockStoreVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Persistent Disk resource in AWS.\n\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify \"true\" to force and set the ReadOnly property in VolumeMounts to \"true\". If omitted, the default is \"false\". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Affinity": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Affinity is a group of affinity scheduling rules.",
				Properties: map[string]spec.Schema{
					"nodeAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes node affinity scheduling rules for the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeAffinity"),
						},
					},
					"podAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodAffinity"),
						},
					},
					"podAntiAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodAntiAffinity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.NodeAffinity", "v1.PodAffinity", "v1.PodAntiAffinity"},
	},
	"v1.AttachedVolume": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AttachedVolume describes a volume attached to a node",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the attached volume",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"devicePath": {
						SchemaProps: spec.SchemaProps{
							Description: "DevicePath represents the device path where the volume should be available",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "devicePath"},
			},
		},
		Dependencies: []string{},
	},
	"v1.AvoidPods": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AvoidPods describes pods that should avoid this node. This is the value for a Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and will eventually become a field of NodeStatus.",
				Properties: map[string]spec.Schema{
					"preferAvoidPods": {
						SchemaProps: spec.SchemaProps{
							Description: "Bounded-sized list of signatures of pods that should avoid this node, sorted in timestamp order from oldest to newest. Size of the slice is unspecified.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PreferAvoidPodsEntry"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.PreferAvoidPodsEntry"},
	},
	"v1.AzureDiskVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
				Properties: map[string]spec.Schema{
					"diskName": {
						SchemaProps: spec.SchemaProps{
							Description: "The Name of the data disk in the blob storage",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"diskURI": {
						SchemaProps: spec.SchemaProps{
							Description: "The URI the data disk in the blob storage",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cachingMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Host Caching mode: None, Read Only, Read Write.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"diskName", "diskURI"},
			},
		},
		Dependencies: []string{},
	},
	"v1.AzureFileVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "the name of secret that contains Azure Storage Account Name and Key",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"shareName": {
						SchemaProps: spec.SchemaProps{
							Description: "Share Name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"secretName", "shareName"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Binding": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Binding ties one object to another. For example, a pod is bound to a node by a scheduler.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "The target object that you want to bind to the standard object.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"target"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.ObjectReference"},
	},
	"v1.Capabilities": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adds and removes POSIX capabilities from running containers.",
				Properties: map[string]spec.Schema{
					"add": {
						SchemaProps: spec.SchemaProps{
							Description: "Added capabilities",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"drop": {
						SchemaProps: spec.SchemaProps{
							Description: "Removed capabilities",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.CephFSVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Used as the mounted root, rather than the full Ceph tree, default is /",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: User is the rados user name, default is admin More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretFile": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
							Ref:         spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors"},
			},
		},
		Dependencies: []string{
			"v1.LocalObjectReference"},
	},
	"v1.CinderVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "volume id used to identify the volume in cinder More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ComponentCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Information about the condition of a component.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of condition for a component. Valid value: \"Healthy\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition for a component. Valid values for \"Healthy\": \"True\", \"False\", or \"Unknown\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message about the condition for a component. For example, information about a health check.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition error code for a component. For example, a health check error code.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ComponentStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ComponentStatus (and ComponentStatusList) holds the cluster validation info.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "List of component conditions observed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ComponentCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ComponentCondition", "v1.ObjectMeta"},
	},
	"v1.ComponentStatusList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Status of all the conditions for the component as a list of ComponentStatus objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ComponentStatus objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ComponentStatus"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.ComponentStatus"},
	},
	"v1.ConfigMap": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMap holds configuration data for pods to consume.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the configuration data. Each key must be a valid DNS_SUBDOMAIN with an optional leading dot.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta"},
	},
	"v1.ConfigMapKeySelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Selects a key from a ConfigMap.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key to select.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ConfigMapList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapList is a resource containing a list of ConfigMap objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ConfigMaps.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ConfigMap"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.ConfigMap"},
	},
	"v1.ConfigMapVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a ConfigMap into a volume.\n\nThe contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.KeyToPath"},
	},
	"v1.Container": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A single application container that you want to run within a pod.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Docker image name. More info: http://kubernetes.io/docs/user-guide/images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"workingDir": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ContainerPort"),
									},
								},
							},
						},
					},
					"env": {
						SchemaProps: spec.SchemaProps{
							Description: "List of environment variables to set in the container. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.EnvVar"),
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Compute Resources required by this container. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#resources",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceRequirements"),
						},
					},
					"volumeMounts": {
						SchemaProps: spec.SchemaProps{
							Description: "Pod volumes to mount into the container's filesystem. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.VolumeMount"),
									},
								},
							},
						},
					},
					"livenessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes",
							Ref:         spec.MustCreateRef("#/definitions/v1.Probe"),
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes",
							Ref:         spec.MustCreateRef("#/definitions/v1.Probe"),
						},
					},
					"lifecycle": {
						SchemaProps: spec.SchemaProps{
							Description: "Actions that the management system should take in response to container lifecycle events. Cannot be updated.",
							Ref:         spec.MustCreateRef("#/definitions/v1.Lifecycle"),
						},
					},
					"terminationMessagePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "Security options the pod should run with. More info: http://releases.k8s.io/HEAD/docs/design/security_context.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.SecurityContext"),
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdinOnce": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"v1.ContainerPort", "v1.EnvVar", "v1.Lifecycle", "v1.Probe", "v1.ResourceRequirements", "v1.SecurityContext", "v1.VolumeMount"},
	},
	"v1.ContainerImage": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describe a container image",
				Properties: map[string]spec.Schema{
					"names": {
						SchemaProps: spec.SchemaProps{
							Description: "Names by which this image is known. e.g. [\"gcr.io/google_containers/hyperkube:v1.0.7\", \"dockerhub.io/google_containers/hyperkube:v1.0.7\"]",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"sizeBytes": {
						SchemaProps: spec.SchemaProps{
							Description: "The size of the image in bytes.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"names"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ContainerPort": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerPort represents a network port in a single container.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostPort": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"containerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Protocol for port. Must be UDP or TCP. Defaults to \"TCP\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostIP": {
						SchemaProps: spec.SchemaProps{
							Description: "What host IP to bind the external port to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"containerPort"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ContainerState": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.",
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting container",
							Ref:         spec.MustCreateRef("#/definitions/v1.ContainerStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a running container",
							Ref:         spec.MustCreateRef("#/definitions/v1.ContainerStateRunning"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a terminated container",
							Ref:         spec.MustCreateRef("#/definitions/v1.ContainerStateTerminated"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ContainerStateRunning", "v1.ContainerStateTerminated", "v1.ContainerStateWaiting"},
	},
	"v1.ContainerStateRunning": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateRunning is a running state of a container.",
				Properties: map[string]spec.Schema{
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the container was last (re-)started",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.ContainerStateTerminated": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateTerminated is a terminated state of a container.",
				Properties: map[string]spec.Schema{
					"exitCode": {
						SchemaProps: spec.SchemaProps{
							Description: "Exit status from the last termination of the container",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"signal": {
						SchemaProps: spec.SchemaProps{
							Description: "Signal from the last termination of the container",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason from the last termination of the container",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message regarding the last termination of the container",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which previous execution of the container started",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the container last terminated",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's ID in the format 'docker://<container_id>'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"exitCode"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.ContainerStateWaiting": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateWaiting is a waiting state of a container.",
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the container is not yet running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message regarding why the container is not yet running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ContainerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStatus contains details for the current status of this container.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about the container's current condition.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ContainerState"),
						},
					},
					"lastState": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about the container's last termination condition.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ContainerState"),
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies whether the container has passed its readiness probe.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"restartCount": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "The image the container is running. More info: http://kubernetes.io/docs/user-guide/images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageID": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageID of the container's image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's ID in the format 'docker://<container_id>'. More info: http://kubernetes.io/docs/user-guide/container-environment#container-information",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "ready", "restartCount", "image", "imageID"},
			},
		},
		Dependencies: []string{
			"v1.ContainerState"},
	},
	"v1.CrossVersionObjectReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
		Dependencies: []string{},
	},
	"v1.DaemonEndpoint": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonEndpoint contains information about a single Daemon endpoint.",
				Properties: map[string]spec.Schema{
					"Port": {
						SchemaProps: spec.SchemaProps{
							Description: "Port number of the given endpoint.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"Port"},
			},
		},
		Dependencies: []string{},
	},
	"v1.DeleteOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeleteOptions may be provided when deleting an API object",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"gracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"preconditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.",
							Ref:         spec.MustCreateRef("#/definitions/v1.Preconditions"),
						},
					},
					"orphanDependents": {
						SchemaProps: spec.SchemaProps{
							Description: "Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.Preconditions"},
	},
	"v1.DeprecatedDownwardAPIVolumeFile": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeprecatedDownwardAPIVolumeFile represents information to create the file containing the pod field This type is deprecated and should be replaced by use of the downwardAPI volume source.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Name is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectFieldSelector"),
						},
					},
					"resourceFieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceFieldSelector"),
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"v1.ObjectFieldSelector", "v1.ResourceFieldSelector"},
	},
	"v1.DeprecatedDownwardAPIVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeprecatedDownwardAPIVolumeSource represents a volume containing downward API info. This type is deprecated and should be replaced by use of the downwardAPI volume source.",
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of downward API volume file",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.DeprecatedDownwardAPIVolumeFile"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.DeprecatedDownwardAPIVolumeFile"},
	},
	"v1.DownwardAPIVolumeFile": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DownwardAPIVolumeFile represents information to create the file containing the pod field",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectFieldSelector"),
						},
					},
					"resourceFieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceFieldSelector"),
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"path"},
			},
		},
		Dependencies: []string{
			"v1.ObjectFieldSelector", "v1.ResourceFieldSelector"},
	},
	"v1.DownwardAPIVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of downward API volume file",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.DownwardAPIVolumeFile"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.DownwardAPIVolumeFile"},
	},
	"v1.EmptyDirVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"medium": {
						SchemaProps: spec.SchemaProps{
							Description: "What type of storage medium should back this directory. The default is \"\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.EndpointAddress": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointAddress is a tuple that describes single IP address.",
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "The Hostname of this endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Reference to object providing the endpoint.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"ip"},
			},
		},
		Dependencies: []string{
			"v1.ObjectReference"},
	},
	"v1.EndpointPort": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointPort is a tuple that describes a single port.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of this port (corresponds to ServicePort.Name). Must be a DNS_LABEL. Optional only if one port is defined.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "The port number of the endpoint.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP protocol for this port. Must be UDP or TCP. Default is TCP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{},
	},
	"v1.EndpointSubset": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:\n  {\n    Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n    Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n  }\nThe resulting set of endpoints can be viewed as:\n    a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],\n    b: [ 10.10.1.1:309, 10.10.2.2:309 ]",
				Properties: map[string]spec.Schema{
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.EndpointAddress"),
									},
								},
							},
						},
					},
					"notReadyAddresses": {
						SchemaProps: spec.SchemaProps{
							Description: "IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.EndpointAddress"),
									},
								},
							},
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Port numbers available on the related IP addresses.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.EndpointPort"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.EndpointAddress", "v1.EndpointPort"},
	},
	"v1.Endpoints": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Endpoints is a collection of endpoints that implement the actual service. Example:\n  Name: \"mysvc\",\n  Subsets: [\n    {\n      Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n      Ports: [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n    },\n    {\n      Addresses: [{\"ip\": \"10.10.3.3\"}],\n      Ports: [{\"name\": \"a\", \"port\": 93}, {\"name\": \"b\", \"port\": 76}]\n    },\n ]",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"subsets": {
						SchemaProps: spec.SchemaProps{
							Description: "The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.EndpointSubset"),
									},
								},
							},
						},
					},
				},
				Required: []string{"subsets"},
			},
		},
		Dependencies: []string{
			"v1.EndpointSubset", "v1.ObjectMeta"},
	},
	"v1.EndpointsList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointsList is a list of endpoints.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of endpoints.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Endpoints"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Endpoints"},
	},
	"v1.EnvVar": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnvVar represents an environment variable present in a Container.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the environment variable. Must be a C_IDENTIFIER.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "Source for the environment variable's value. Cannot be used if value is not empty.",
							Ref:         spec.MustCreateRef("#/definitions/v1.EnvVarSource"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"v1.EnvVarSource"},
	},
	"v1.EnvVarSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnvVarSource represents a source for the value of an EnvVar.",
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.podIP.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectFieldSelector"),
						},
					},
					"resourceFieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceFieldSelector"),
						},
					},
					"configMapKeyRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a key of a ConfigMap.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ConfigMapKeySelector"),
						},
					},
					"secretKeyRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a key of a secret in the pod's namespace",
							Ref:         spec.MustCreateRef("#/definitions/v1.SecretKeySelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ConfigMapKeySelector", "v1.ObjectFieldSelector", "v1.ResourceFieldSelector", "v1.SecretKeySelector"},
	},
	"v1.Event": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Event is a report of an event somewhere in the cluster.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"involvedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "The object that this event is about.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectReference"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "This should be a short, machine understandable string that gives the reason for the transition into the object's current status.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the status of this operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"source": {
						SchemaProps: spec.SchemaProps{
							Description: "The component reporting this event. Should be a short machine understandable string.",
							Ref:         spec.MustCreateRef("#/definitions/v1.EventSource"),
						},
					},
					"firstTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "The time at which the most recent occurrence of this event was recorded.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"count": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of times this event has occurred.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of this event (Normal, Warning), new types could be added in the future",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"metadata", "involvedObject"},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.EventSource", "v1.ObjectMeta", "v1.ObjectReference"},
	},
	"v1.EventList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventList is a list of events.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of events",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Event"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Event"},
	},
	"v1.EventSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventSource contains information for an event.",
				Properties: map[string]spec.Schema{
					"component": {
						SchemaProps: spec.SchemaProps{
							Description: "Component from which the event is generated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Node name on which the event is generated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ExecAction": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExecAction describes a \"run in container\" action.",
				Properties: map[string]spec.Schema{
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ExportOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExportOptions is the query options to the standard REST get call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"export": {
						SchemaProps: spec.SchemaProps{
							Description: "Should this value be exported.  Export strips fields that a user can not specify.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"exact": {
						SchemaProps: spec.SchemaProps{
							Description: "Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"export", "exact"},
			},
		},
		Dependencies: []string{},
	},
	"v1.FCVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"targetWWNs": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: FC target worldwide names (WWNs)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: FC target lun number",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"targetWWNs", "lun"},
			},
		},
		Dependencies: []string{},
	},
	"v1.FSGroupStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FSGroupStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the strategy that will dictate what FSGroup is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.IDRange"},
	},
	"v1.FlexVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
				Properties: map[string]spec.Schema{
					"driver": {
						SchemaProps: spec.SchemaProps{
							Description: "Driver is the name of the driver to use for this volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.",
							Ref:         spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"options": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Extra command options if any.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"driver"},
			},
		},
		Dependencies: []string{
			"v1.LocalObjectReference"},
	},
	"v1.FlockerVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"datasetName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"datasetUUID": {
						SchemaProps: spec.SchemaProps{
							Description: "UUID of the dataset. This is unique identifier of a Flocker dataset",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.GCEPersistentDiskVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Persistent Disk resource in Google Compute Engine.\n\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"pdName": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"pdName"},
			},
		},
		Dependencies: []string{},
	},
	"v1.GitRepoVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"repository": {
						SchemaProps: spec.SchemaProps{
							Description: "Repository URL",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Commit hash for the specified revision.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"directory": {
						SchemaProps: spec.SchemaProps{
							Description: "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"repository"},
			},
		},
		Dependencies: []string{},
	},
	"v1.GlusterfsVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"endpoints": {
						SchemaProps: spec.SchemaProps{
							Description: "EndpointsName is the endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"endpoints", "path"},
			},
		},
		Dependencies: []string{},
	},
	"v1.HTTPGetAction": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPGetAction describes an action based on HTTP Get requests.",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path to access on the HTTP server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"scheme": {
						SchemaProps: spec.SchemaProps{
							Description: "Scheme to use for connecting to the host. Defaults to HTTP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"httpHeaders": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom headers to set in the request. HTTP allows repeated headers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.HTTPHeader"),
									},
								},
							},
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString", "v1.HTTPHeader"},
	},
	"v1.HTTPHeader": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPHeader describes a custom header to be used in HTTP probes",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field value",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Handler": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Handler defines a specific action that should be taken",
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         spec.MustCreateRef("#/definitions/v1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         spec.MustCreateRef("#/definitions/v1.TCPSocketAction"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ExecAction", "v1.HTTPGetAction", "v1.TCPSocketAction"},
	},
	"v1.HorizontalPodAutoscaler": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "behaviour of autoscaler. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/v1.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current information about the autoscaler.",
							Ref:         spec.MustCreateRef("#/definitions/v1.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.HorizontalPodAutoscalerSpec", "v1.HorizontalPodAutoscalerStatus", "v1.ObjectMeta"},
	},
	"v1.HorizontalPodAutoscalerList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.HorizontalPodAutoscaler"},
	},
	"v1.HorizontalPodAutoscalerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.",
							Ref:         spec.MustCreateRef("#/definitions/v1.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "lower limit for the number of pods that can be set by the autoscaler, default 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"v1.CrossVersionObjectReference"},
	},
	"v1.HorizontalPodAutoscalerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.HostPathVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"path"},
			},
		},
		Dependencies: []string{},
	},
	"v1.IDRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IDRange provides a min/max of an allowed range of IDs.",
				Properties: map[string]spec.Schema{
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min is the start of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max is the end of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ISCSIVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"targetPortal": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iqn": {
						SchemaProps: spec.SchemaProps{
							Description: "Target iSCSI Qualified Name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI target lun number.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iscsiInterface": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to 'default' (tcp). iSCSI interface name that uses an iSCSI transport.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"targetPortal", "iqn", "lun"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Job": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Job represents the configuration of a single job.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.JobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.JobSpec", "v1.JobStatus", "v1.ObjectMeta"},
	},
	"v1.JobCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobCondition describes current state of a job.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of job condition, Complete or Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.JobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobList is a collection of jobs.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Job.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Job"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Job"},
	},
	"v1.JobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobSpec describes how the job execution will look like.",
				Properties: map[string]spec.Schema{
					"parallelism": {
						SchemaProps: spec.SchemaProps{
							Description: "Parallelism specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completions": {
						SchemaProps: spec.SchemaProps{
							Description: "Completions specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the pod count. Normally, the system sets this field for you. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"manualSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ManualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: http://releases.k8s.io/HEAD/docs/design/selector-generation.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created when executing a job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec"},
	},
	"v1.JobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobStatus represents the current state of a Job.",
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represent the latest available observations of an object's current state. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.JobCondition"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active is the number of actively running pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"succeeded": {
						SchemaProps: spec.SchemaProps{
							Description: "Succeeded is the number of pods which reached Phase Succeeded.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "Failed is the number of pods which reached Phase Failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.JobCondition"},
	},
	"v1.KeyToPath": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Maps a string key to a path within a volume.",
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key to project.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"key", "path"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Lifecycle": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.",
				Properties: map[string]spec.Schema{
					"postStart": {
						SchemaProps: spec.SchemaProps{
							Description: "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: http://kubernetes.io/docs/user-guide/container-environment#hook-details",
							Ref:         spec.MustCreateRef("#/definitions/v1.Handler"),
						},
					},
					"preStop": {
						SchemaProps: spec.SchemaProps{
							Description: "PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: http://kubernetes.io/docs/user-guide/container-environment#hook-details",
							Ref:         spec.MustCreateRef("#/definitions/v1.Handler"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.Handler"},
	},
	"v1.LimitRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRange sets resource usage limits for each kind of resource in a Namespace.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the limits enforced. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.LimitRangeSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.LimitRangeSpec", "v1.ObjectMeta"},
	},
	"v1.LimitRangeItem": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeItem defines a min/max usage limit for any resource that matches on kind.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of resource that this limit applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max usage constraints on this kind by resource name.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min usage constraints on this kind by resource name.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default resource requirement limit value by resource name if resource limit is omitted.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"defaultRequest": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"maxLimitRequestRatio": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.LimitRangeList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeList is a list of LimitRange items.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of LimitRange objects. More info: http://releases.k8s.io/HEAD/docs/design/admission_control_limit_range.md",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.LimitRange"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.LimitRange"},
	},
	"v1.LimitRangeSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeSpec defines a min/max usage limit for resources that match on kind.",
				Properties: map[string]spec.Schema{
					"limits": {
						SchemaProps: spec.SchemaProps{
							Description: "Limits is the list of LimitRangeItem objects that are enforced.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.LimitRangeItem"),
									},
								},
							},
						},
					},
				},
				Required: []string{"limits"},
			},
		},
		Dependencies: []string{
			"v1.LimitRangeItem"},
	},
	"v1.List": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "List holds a list of objects, which may not be known by the server.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of objects",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/runtime.RawExtension"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"runtime.RawExtension", "unversioned.ListMeta"},
	},
	"v1.ListOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ListOptions is the query options to a standard REST list call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A selector to restrict the list of returned objects by their labels. Defaults to everything.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A selector to restrict the list of returned objects by their fields. Defaults to everything.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"watch": {
						SchemaProps: spec.SchemaProps{
							Description: "Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Timeout for the list/watch call.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.LoadBalancerIngress": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.",
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.LoadBalancerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LoadBalancerStatus represents the status of a load-balancer.",
				Properties: map[string]spec.Schema{
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.LoadBalancerIngress"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.LoadBalancerIngress"},
	},
	"v1.LocalObjectReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.NFSVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"server": {
						SchemaProps: spec.SchemaProps{
							Description: "Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"server", "path"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Namespace": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Namespace provides a scope for Names. Use of multiple namespaces is optional.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of the Namespace. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.NamespaceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status describes the current status of a Namespace. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.NamespaceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.NamespaceSpec", "v1.NamespaceStatus", "v1.ObjectMeta"},
	},
	"v1.NamespaceList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceList is a list of Namespaces.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Namespace objects in the list. More info: http://kubernetes.io/docs/user-guide/namespaces",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Namespace"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Namespace"},
	},
	"v1.NamespaceSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceSpec describes the attributes on a Namespace.",
				Properties: map[string]spec.Schema{
					"finalizers": {
						SchemaProps: spec.SchemaProps{
							Description: "Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: http://releases.k8s.io/HEAD/docs/design/namespaces.md#finalizers",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.NamespaceStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceStatus is information about the current status of a Namespace.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is the current lifecycle phase of the namespace. More info: http://releases.k8s.io/HEAD/docs/design/namespaces.md#phases",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.Node": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of a node. http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the node. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.NodeSpec", "v1.NodeStatus", "v1.ObjectMeta"},
	},
	"v1.NodeAddress": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeAddress contains information for the node's address.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Node address type, one of Hostname, ExternalIP or InternalIP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "The node address.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "address"},
			},
		},
		Dependencies: []string{},
	},
	"v1.NodeAffinity": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Node affinity is a group of node affinity scheduling rules.",
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeSelector"),
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PreferredSchedulingTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.NodeSelector", "v1.PreferredSchedulingTerm"},
	},
	"v1.NodeCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeCondition contains condition information for a node.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of node condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastHeartbeatTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time we got an update on a given condition.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.NodeDaemonEndpoints": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeDaemonEndpoints lists ports opened by daemons running on the Node.",
				Properties: map[string]spec.Schema{
					"kubeletEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "Endpoint on which Kubelet is listening.",
							Ref:         spec.MustCreateRef("#/definitions/v1.DaemonEndpoint"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.DaemonEndpoint"},
	},
	"v1.NodeList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeList is the whole list of all Nodes which have been registered with master.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of nodes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Node"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Node"},
	},
	"v1.NodeProxyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeProxyOptions is the query options to a Node's proxy call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path to use for the current proxy request to node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.NodeSelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.",
				Properties: map[string]spec.Schema{
					"nodeSelectorTerms": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. A list of node selector terms. The terms are ORed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.NodeSelectorTerm"),
									},
								},
							},
						},
					},
				},
				Required: []string{"nodeSelectorTerms"},
			},
		},
		Dependencies: []string{
			"v1.NodeSelectorTerm"},
	},
	"v1.NodeSelectorRequirement": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The label key that the selector applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"values": {
						SchemaProps: spec.SchemaProps{
							Description: "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"key", "operator"},
			},
		},
		Dependencies: []string{},
	},
	"v1.NodeSelectorTerm": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A null or empty node selector term matches no objects.",
				Properties: map[string]spec.Schema{
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. A list of node selector requirements. The requirements are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.NodeSelectorRequirement"),
									},
								},
							},
						},
					},
				},
				Required: []string{"matchExpressions"},
			},
		},
		Dependencies: []string{
			"v1.NodeSelectorRequirement"},
	},
	"v1.NodeSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSpec describes the attributes that a node is created with.",
				Properties: map[string]spec.Schema{
					"podCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "PodCIDR represents the pod IP range assigned to the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"externalID": {
						SchemaProps: spec.SchemaProps{
							Description: "External ID of the node assigned by some machine database (e.g. a cloud provider). Deprecated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"unschedulable": {
						SchemaProps: spec.SchemaProps{
							Description: "Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#manual-node-administration\"",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.NodeStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeStatus is information about the current status of a node.",
				Properties: map[string]spec.Schema{
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Capacity represents the total resources of a node. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#capacity for more details.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"allocatable": {
						SchemaProps: spec.SchemaProps{
							Description: "Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "NodePhase is the recently observed lifecycle phase of the node. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#node-phase The field is never populated, and now is deprecated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions is an array of current observed node conditions. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#node-condition",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.NodeCondition"),
									},
								},
							},
						},
					},
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "List of addresses reachable to the node. Queried from cloud provider, if available. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#node-addresses",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.NodeAddress"),
									},
								},
							},
						},
					},
					"daemonEndpoints": {
						SchemaProps: spec.SchemaProps{
							Description: "Endpoints of daemons running on the Node.",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeDaemonEndpoints"),
						},
					},
					"nodeInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "Set of ids/uuids to uniquely identify the node. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#node-info",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeSystemInfo"),
						},
					},
					"images": {
						SchemaProps: spec.SchemaProps{
							Description: "List of container images on this node",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ContainerImage"),
									},
								},
							},
						},
					},
					"volumesInUse": {
						SchemaProps: spec.SchemaProps{
							Description: "List of attachable volumes in use (mounted) by the node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"volumesAttached": {
						SchemaProps: spec.SchemaProps{
							Description: "List of volumes that are attached to the node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.AttachedVolume"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity", "v1.AttachedVolume", "v1.ContainerImage", "v1.NodeAddress", "v1.NodeCondition", "v1.NodeDaemonEndpoints", "v1.NodeSystemInfo"},
	},
	"v1.NodeSystemInfo": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSystemInfo is a set of ids/uuids to uniquely identify the node.",
				Properties: map[string]spec.Schema{
					"machineID": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineID reported by the node. For unique machine identification in the cluster this field is prefered. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"systemUUID": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemUUID reported by the node. For unique machine identification MachineID is prefered. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bootID": {
						SchemaProps: spec.SchemaProps{
							Description: "Boot ID reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kernelVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"osImage": {
						SchemaProps: spec.SchemaProps{
							Description: "OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntimeVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeletVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet Version reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeProxyVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeProxy Version reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operatingSystem": {
						SchemaProps: spec.SchemaProps{
							Description: "The Operating System reported by the node",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"architecture": {
						SchemaProps: spec.SchemaProps{
							Description: "The Architecture reported by the node",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"machineID", "systemUUID", "bootID", "kernelVersion", "osImage", "containerRuntimeVersion", "kubeletVersion", "kubeProxyVersion", "operatingSystem", "architecture"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ObjectFieldSelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectFieldSelector selects an APIVersioned field of an object.",
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Version of the schema the FieldPath is written in terms of, defaults to \"v1\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldPath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path of the field to select in the specified API version.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldPath"},
			},
		},
		Dependencies: []string{},
	},
	"v1.ObjectMeta": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"generateName": {
						SchemaProps: spec.SchemaProps{
							Description: "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).\n\nApplied only if Name is not specified. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#idempotency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace defines the space within each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selfLink": {
						SchemaProps: spec.SchemaProps{
							Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"generation": {
						SchemaProps: spec.SchemaProps{
							Description: "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"creationTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"deletionTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field. Once set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"deletionGracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"ownerReferences": {
						SchemaProps: spec.SchemaProps{
							Description: "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.OwnerReference"),
									},
								},
							},
						},
					},
					"finalizers": {
						SchemaProps: spec.SchemaProps{
							Description: "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.OwnerReference"},
	},
	"v1.ObjectReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectReference contains enough information to let you inspect or modify the referred object.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referent. More info: http://kubernetes.io/docs/user-guide/namespaces",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Specific resourceVersion to which this reference is made, if any. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldPath": {
						SchemaProps: spec.SchemaProps{
							Description: "If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \"spec.containers{name}\" (where \"name\" refers to the name of the container that triggered the event) or if no container name is specified \"spec.containers[2]\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.OwnerReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.",
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"controller": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, this reference points to the managing controller.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"apiVersion", "kind", "name", "uid"},
			},
		},
		Dependencies: []string{},
	},
	"v1.PersistentVolume": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: http://kubernetes.io/docs/user-guide/persistent-volumes",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistent-volumes",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistent-volumes",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PersistentVolumeSpec", "v1.PersistentVolumeStatus"},
	},
	"v1.PersistentVolumeClaim": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaim is a user's request for and claim to a persistent volume",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaimSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status represents the current information/status of a persistent volume claim. Read-only. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaimStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PersistentVolumeClaimSpec", "v1.PersistentVolumeClaimStatus"},
	},
	"v1.PersistentVolumeClaimList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimList is a list of PersistentVolumeClaim items.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of persistent volume claims. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.PersistentVolumeClaim"},
	},
	"v1.PersistentVolumeClaimSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes",
				Properties: map[string]spec.Schema{
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains the desired access modes the volume should have. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#access-modes-1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over volumes to consider for binding.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources represents the minimum resources the volume should have. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#resources",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceRequirements"),
						},
					},
					"volumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeName is the binding reference to the PersistentVolume backing this claim.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.ResourceRequirements"},
	},
	"v1.PersistentVolumeClaimStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimStatus is the current status of a persistent volume claim.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase represents the current phase of PersistentVolumeClaim.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains the actual access modes the volume backing the PVC has. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#access-modes-1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the actual resources of the underlying volume.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.PersistentVolumeClaimVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).",
				Properties: map[string]spec.Schema{
					"claimName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Will force the ReadOnly setting in VolumeMounts. Default false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"claimName"},
			},
		},
		Dependencies: []string{},
	},
	"v1.PersistentVolumeList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeList is a list of PersistentVolume items.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of persistent volumes. More info: http://kubernetes.io/docs/user-guide/persistent-volumes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PersistentVolume"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.PersistentVolume"},
	},
	"v1.PersistentVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeSource is similar to VolumeSource but meant for the administrator who creates PVs. Exactly one of its members must be set.",
				Properties: map[string]spec.Schema{
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Ref:         spec.MustCreateRef("#/definitions/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Ref:         spec.MustCreateRef("#/definitions/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath",
							Ref:         spec.MustCreateRef("#/definitions/v1.HostPathVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.GlusterfsVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Ref:         spec.MustCreateRef("#/definitions/v1.NFSVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.RBDVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ISCSIVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.CinderVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.CephFSVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FCVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlockerVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlexVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureFileVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.AWSElasticBlockStoreVolumeSource", "v1.AzureDiskVolumeSource", "v1.AzureFileVolumeSource", "v1.CephFSVolumeSource", "v1.CinderVolumeSource", "v1.FCVolumeSource", "v1.FlexVolumeSource", "v1.FlockerVolumeSource", "v1.GCEPersistentDiskVolumeSource", "v1.GlusterfsVolumeSource", "v1.HostPathVolumeSource", "v1.ISCSIVolumeSource", "v1.NFSVolumeSource", "v1.PhotonPersistentDiskVolumeSource", "v1.QuobyteVolumeSource", "v1.RBDVolumeSource", "v1.VsphereVirtualDiskVolumeSource"},
	},
	"v1.PersistentVolumeSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeSpec is the specification of a persistent volume.",
				Properties: map[string]spec.Schema{
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "A description of the persistent volume's resources and capacity. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#capacity",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Ref:         spec.MustCreateRef("#/definitions/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Ref:         spec.MustCreateRef("#/definitions/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath",
							Ref:         spec.MustCreateRef("#/definitions/v1.HostPathVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.GlusterfsVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Ref:         spec.MustCreateRef("#/definitions/v1.NFSVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.RBDVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ISCSIVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.CinderVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.CephFSVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FCVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlockerVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlexVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureFileVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains all ways the volume can be mounted. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#access-modes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"claimRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#binding",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectReference"),
						},
					},
					"persistentVolumeReclaimPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "What happens to a persistent volume when released from its claim. Valid options are Retain (default) and Recycle. Recycling must be supported by the volume plugin underlying this persistent volume. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#recycling-policy",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity", "v1.AWSElasticBlockStoreVolumeSource", "v1.AzureDiskVolumeSource", "v1.AzureFileVolumeSource", "v1.CephFSVolumeSource", "v1.CinderVolumeSource", "v1.FCVolumeSource", "v1.FlexVolumeSource", "v1.FlockerVolumeSource", "v1.GCEPersistentDiskVolumeSource", "v1.GlusterfsVolumeSource", "v1.HostPathVolumeSource", "v1.ISCSIVolumeSource", "v1.NFSVolumeSource", "v1.ObjectReference", "v1.PhotonPersistentDiskVolumeSource", "v1.QuobyteVolumeSource", "v1.RBDVolumeSource", "v1.VsphereVirtualDiskVolumeSource"},
	},
	"v1.PersistentVolumeStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeStatus is the current status of a persistent volume.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#phase",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable message indicating details about why the volume is in this state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.PhotonPersistentDiskVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Photon Controller persistent disk resource.",
				Properties: map[string]spec.Schema{
					"pdID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID that identifies Photon Controller persistent disk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"pdID"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Pod": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the pod. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PodSpec", "v1.PodStatus"},
	},
	"v1.PodAffinity": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod affinity is a group of inter pod affinity scheduling rules.",
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "NOT YET IMPLEMENTED. TODO: Uncomment field once it is implemented. If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system will try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied. RequiredDuringSchedulingRequiredDuringExecution []PodAffinityTerm  `json:\"requiredDuringSchedulingRequiredDuringExecution,omitempty\"` If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PodAffinityTerm"),
									},
								},
							},
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.WeightedPodAffinityTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.PodAffinityTerm", "v1.WeightedPodAffinityTerm"},
	},
	"v1.PodAffinityTerm": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> tches that of any node on which a pod of the set of pods is running",
				Properties: map[string]spec.Schema{
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over a set of resources, in this case pods.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"namespaces": {
						SchemaProps: spec.SchemaProps{
							Description: "namespaces specifies which namespaces the labelSelector applies to (matches against); nil list means \"this pod's namespace,\" empty list means \"all namespaces\" The json tag here is not \"omitempty\" since we need to distinguish nil and empty. See https://golang.org/pkg/encoding/json/#Marshal for more details.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"topologyKey": {
						SchemaProps: spec.SchemaProps{
							Description: "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. For PreferredDuringScheduling pod anti-affinity, empty topologyKey is interpreted as \"all topologies\" (\"all topologies\" here means all the topologyKeys indicated by scheduler command-line argument --failure-domains); for affinity and for RequiredDuringScheduling pod anti-affinity, empty topologyKey is not allowed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"namespaces"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector"},
	},
	"v1.PodAntiAffinity": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod anti affinity is a group of inter pod anti affinity scheduling rules.",
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "NOT YET IMPLEMENTED. TODO: Uncomment field once it is implemented. If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system will try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied. RequiredDuringSchedulingRequiredDuringExecution []PodAffinityTerm  `json:\"requiredDuringSchedulingRequiredDuringExecution,omitempty\"` If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PodAffinityTerm"),
									},
								},
							},
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.WeightedPodAffinityTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.PodAffinityTerm", "v1.WeightedPodAffinityTerm"},
	},
	"v1.PodAttachOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodAttachOptions is the query options to a Pod's remote attach call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Stdin if true, redirects the standard input stream of the pod for this call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdout": {
						SchemaProps: spec.SchemaProps{
							Description: "Stdout if true indicates that stdout is to be redirected for the attach call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stderr": {
						SchemaProps: spec.SchemaProps{
							Description: "Stderr if true indicates that stderr is to be redirected for the attach call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "TTY if true indicates that a tty will be allocated for the attach call. This is passed through the container runtime so the tty is allocated on the worker node by the container runtime. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "The container in which to execute the command. Defaults to only container if there is only one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.PodCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodCondition contains details for the current condition of this pod.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the condition. Currently only Ready. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-conditions",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the status of the condition. Can be True, False, Unknown. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-conditions",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time we probed the condition.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique, one-word, CamelCase reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human-readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.PodExecOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodExecOptions is the query options to a Pod's remote exec call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard input stream of the pod for this call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdout": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard output stream of the pod for this call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stderr": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard error stream of the pod for this call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "TTY if true indicates that a tty will be allocated for the exec call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "Container in which to execute the command. Defaults to only container if there is only one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Command is the remote command to execute. argv array. Not executed within a shell.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"command"},
			},
		},
		Dependencies: []string{},
	},
	"v1.PodList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodList is a list of Pods.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of pods. More info: http://kubernetes.io/docs/user-guide/pods",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Pod"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Pod"},
	},
	"v1.PodLogOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogOptions is the query options for a Pod's logs REST call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "The container for which to stream logs. Defaults to only container if there is one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"follow": {
						SchemaProps: spec.SchemaProps{
							Description: "Follow the log stream of the pod. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"previous": {
						SchemaProps: spec.SchemaProps{
							Description: "Return previous terminated container logs. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"sinceSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "A relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"sinceTime": {
						SchemaProps: spec.SchemaProps{
							Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"timestamps": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tailLines": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"limitBytes": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.PodProxyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodProxyOptions is the query options to a Pod's proxy call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path to use for the current proxy request to pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.PodSecurityContext": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.",
				Properties: map[string]spec.Schema{
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
							Ref:         spec.MustCreateRef("#/definitions/v1.SELinuxOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsNonRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"supplementalGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"integer"},
										Format: "int64",
									},
								},
							},
						},
					},
					"fsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.SELinuxOptions"},
	},
	"v1.PodSignature": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes the class of pods that should avoid this node. Exactly one field should be set.",
				Properties: map[string]spec.Schema{
					"podController": {
						SchemaProps: spec.SchemaProps{
							Description: "Reference to controller whose pods should avoid this node.",
							Ref:         spec.MustCreateRef("#/definitions/v1.OwnerReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.OwnerReference"},
	},
	"v1.PodSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSpec is a description of a pod.",
				Properties: map[string]spec.Schema{
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Description: "List of volumes that can be mounted by containers belonging to the pod. More info: http://kubernetes.io/docs/user-guide/volumes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Volume"),
									},
								},
							},
						},
					},
					"containers": {
						SchemaProps: spec.SchemaProps{
							Description: "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Container"),
									},
								},
							},
						},
					},
					"restartPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationGracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"dnsPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Set DNS policy for containers within the pod. One of 'ClusterFirst' or 'Default'. Defaults to \"ClusterFirst\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection/README",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serviceAccount": {
						SchemaProps: spec.SchemaProps{
							Description: "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostPID": {
						SchemaProps: spec.SchemaProps{
							Description: "Use the host's pid namespace. Optional: Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostIPC": {
						SchemaProps: spec.SchemaProps{
							Description: "Use the host's ipc namespace. Optional: Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodSecurityContext"),
						},
					},
					"imagePullSecrets": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
									},
								},
							},
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subdomain": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the fully qualified Pod hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the pod will not have a domainname at all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"containers"},
			},
		},
		Dependencies: []string{
			"v1.Container", "v1.LocalObjectReference", "v1.PodSecurityContext", "v1.Volume"},
	},
	"v1.PodStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodStatus represents information about the status of a pod. Status may trail the actual state of a system.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Current condition of the pod. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-phase",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Current service state of pod. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-conditions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PodCondition"),
									},
								},
							},
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about why the pod is in this condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A brief CamelCase message indicating details about why the pod is in this state. e.g. 'OutOfDisk'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostIP": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address of the host to which the pod is assigned. Empty if not yet scheduled.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podIP": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"containerStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: http://kubernetes.io/docs/user-guide/pod-states#container-statuses",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ContainerStatus"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.ContainerStatus", "v1.PodCondition"},
	},
	"v1.PodStatusResult": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PodStatus"},
	},
	"v1.PodTemplate": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplate describes a template for creating copies of a predefined pod.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines the pods that will be created from this pod template. http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PodTemplateSpec"},
	},
	"v1.PodTemplateList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplateList is a list of PodTemplates.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of pod templates",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PodTemplate"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.PodTemplate"},
	},
	"v1.PodTemplateSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplateSpec describes the data a pod should have when created from a template",
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the pod. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.PodSpec"},
	},
	"v1.Preconditions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.",
				Properties: map[string]spec.Schema{
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the target UID.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.PreferAvoidPodsEntry": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a class of pods that should avoid this node.",
				Properties: map[string]spec.Schema{
					"podSignature": {
						SchemaProps: spec.SchemaProps{
							Description: "The class of pods.",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodSignature"),
						},
					},
					"evictionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which this entry was added to the list.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason why this entry was added to the list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating why this entry was added to the list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"podSignature"},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.PodSignature"},
	},
	"v1.PreferredSchedulingTerm": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).",
				Properties: map[string]spec.Schema{
					"weight": {
						SchemaProps: spec.SchemaProps{
							Description: "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"preference": {
						SchemaProps: spec.SchemaProps{
							Description: "A node selector term, associated with the corresponding weight.",
							Ref:         spec.MustCreateRef("#/definitions/v1.NodeSelectorTerm"),
						},
					},
				},
				Required: []string{"weight", "preference"},
			},
		},
		Dependencies: []string{
			"v1.NodeSelectorTerm"},
	},
	"v1.Probe": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.",
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         spec.MustCreateRef("#/definitions/v1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         spec.MustCreateRef("#/definitions/v1.TCPSocketAction"),
						},
					},
					"initialDelaySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"successThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failureThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ExecAction", "v1.HTTPGetAction", "v1.TCPSocketAction"},
	},
	"v1.QuobyteVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"registry": {
						SchemaProps: spec.SchemaProps{
							Description: "Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume is a string that references an already created Quobyte volume by name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User to map volume access to Defaults to serivceaccount user",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group to map volume access to Default is no group",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"registry", "volume"},
			},
		},
		Dependencies: []string{},
	},
	"v1.RBDVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pool": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"keyring": {
						SchemaProps: spec.SchemaProps{
							Description: "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Ref:         spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors", "image"},
			},
		},
		Dependencies: []string{
			"v1.LocalObjectReference"},
	},
	"v1.RangeAllocation": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RangeAllocation is not a public type.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"range": {
						SchemaProps: spec.SchemaProps{
							Description: "Range is string that identifies the range represented by 'data'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is a bit array containing all allocated addresses in the previous segment.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
				Required: []string{"range", "data"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta"},
	},
	"v1.ReplicationController": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationController represents the configuration of a replication controller.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the replication controller. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ReplicationControllerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the replication controller. This data may be out of date by some window of time. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ReplicationControllerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.ReplicationControllerSpec", "v1.ReplicationControllerStatus"},
	},
	"v1.ReplicationControllerCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerCondition describes the state of a replication controller at a certain point.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replication controller condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1.ReplicationControllerList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerList is a collection of replication controllers.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of replication controllers. More info: http://kubernetes.io/docs/user-guide/replication-controller",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ReplicationController"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.ReplicationController"},
	},
	"v1.ReplicationControllerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerSpec is the specification of a replication controller.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: http://kubernetes.io/docs/user-guide/replication-controller#what-is-a-replication-controller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: http://kubernetes.io/docs/user-guide/replication-controller#pod-template",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.PodTemplateSpec"},
	},
	"v1.ReplicationControllerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerStatus represents the current status of a replication controller.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently oberved number of replicas. More info: http://kubernetes.io/docs/user-guide/replication-controller#what-is-a-replication-controller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed replication controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replication controller's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ReplicationControllerCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"v1.ReplicationControllerCondition"},
	},
	"v1.ResourceFieldSelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceFieldSelector represents container resources (cpu, memory) and their output format",
				Properties: map[string]spec.Schema{
					"containerName": {
						SchemaProps: spec.SchemaProps{
							Description: "Container name: required for volumes, optional for env vars",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: resource to select",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"divisor": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the output format of the exposed resources, defaults to \"1\"",
							Ref:         spec.MustCreateRef("#/definitions/resource.Quantity"),
						},
					},
				},
				Required: []string{"resource"},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.ResourceQuota": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuota sets aggregate quota restrictions enforced per namespace",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired quota. http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceQuotaSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status defines the actual enforced quota and its current usage. http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ResourceQuotaStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.ResourceQuotaSpec", "v1.ResourceQuotaStatus"},
	},
	"v1.ResourceQuotaList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaList is a list of ResourceQuota items.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ResourceQuota objects. More info: http://releases.k8s.io/HEAD/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ResourceQuota"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.ResourceQuota"},
	},
	"v1.ResourceQuotaSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaSpec defines the desired hard limits to enforce for Quota.",
				Properties: map[string]spec.Schema{
					"hard": {
						SchemaProps: spec.SchemaProps{
							Description: "Hard is the set of desired hard limits for each named resource. More info: http://releases.k8s.io/HEAD/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"scopes": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.ResourceQuotaStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaStatus defines the enforced hard limits and observed use.",
				Properties: map[string]spec.Schema{
					"hard": {
						SchemaProps: spec.SchemaProps{
							Description: "Hard is the set of enforced hard limits for each named resource. More info: http://releases.k8s.io/HEAD/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"used": {
						SchemaProps: spec.SchemaProps{
							Description: "Used is the current observed total usage of the resource in the namespace.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.ResourceRequirements": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRequirements describes the compute resource requirements.",
				Properties: map[string]spec.Schema{
					"limits": {
						SchemaProps: spec.SchemaProps{
							Description: "Limits describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
					"requests": {
						SchemaProps: spec.SchemaProps{
							Description: "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: http://kubernetes.io/docs/user-guide/compute-resources/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1.RunAsUserStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is the user id that containers must run as.  Required for the MustRunAs strategy if not using namespace/service account allocated uids.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"uidRangeMin": {
						SchemaProps: spec.SchemaProps{
							Description: "UIDRangeMin defines the min value for a strategy that allocates by range.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"uidRangeMax": {
						SchemaProps: spec.SchemaProps{
							Description: "UIDRangeMax defines the max value for a strategy that allocates by range.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.SELinuxContextStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SELinuxContextStrategyOptions defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the strategy that will dictate what SELinux context is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "seLinuxOptions required to run as; required for MustRunAs",
							Ref:         spec.MustCreateRef("#/definitions/v1.SELinuxOptions"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.SELinuxOptions"},
	},
	"v1.SELinuxOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SELinuxOptions are the labels to be applied to the container",
				Properties: map[string]spec.Schema{
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is a SELinux user label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"role": {
						SchemaProps: spec.SchemaProps{
							Description: "Role is a SELinux role label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is a SELinux type label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"level": {
						SchemaProps: spec.SchemaProps{
							Description: "Level is SELinux level label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.Scale": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status. Read-only.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.ScaleSpec", "v1.ScaleStatus"},
	},
	"v1.ScaleSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ScaleStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Secret": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the secret data. Each key must be a valid DNS_SUBDOMAIN or leading dot followed by valid DNS_SUBDOMAIN. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "byte",
									},
								},
							},
						},
					},
					"stringData": {
						SchemaProps: spec.SchemaProps{
							Description: "stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Used to facilitate programmatic handling of secret data.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta"},
	},
	"v1.SecretKeySelector": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretKeySelector selects a key of a Secret.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key of the secret to select from.  Must be a valid secret key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
		Dependencies: []string{},
	},
	"v1.SecretList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretList is a list of Secret.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of secret objects. More info: http://kubernetes.io/docs/user-guide/secrets",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Secret"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Secret"},
	},
	"v1.SecretVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a Secret into a volume.\n\nThe contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.",
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.KeyToPath"},
	},
	"v1.SecurityContext": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.",
				Properties: map[string]spec.Schema{
					"capabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.",
							Ref:         spec.MustCreateRef("#/definitions/v1.Capabilities"),
						},
					},
					"privileged": {
						SchemaProps: spec.SchemaProps{
							Description: "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Ref:         spec.MustCreateRef("#/definitions/v1.SELinuxOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsNonRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"readOnlyRootFilesystem": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container has a read-only root filesystem. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.Capabilities", "v1.SELinuxOptions"},
	},
	"v1.SecurityContextConstraints": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecurityContextConstraints governs the ability to make requests that affect the SecurityContext that will be applied to a container.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"priority": {
						SchemaProps: spec.SchemaProps{
							Description: "Priority influences the sort order of SCCs when evaluating which SCCs to try first for a given pod request based on access in the Users and Groups fields.  The higher the int, the higher priority.  If scores for multiple SCCs are equal they will be sorted by name.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"allowPrivilegedContainer": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowPrivilegedContainer determines if a container can request to be run as privileged.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"defaultAddCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capabiility in both DefaultAddCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"requiredDropCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "RequiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"allowedCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field maybe added at the pod author's discretion. You must not list a capability in both AllowedCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"allowHostDirVolumePlugin": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowHostDirVolumePlugin determines if the policy allow containers to use the HostDir volume plugin",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Description: "Volumes is a white list of allowed volume plugins.  FSType corresponds directly with the field names of a VolumeSource (azureFile, configMap, emptyDir).  To allow all volumes you may use '*'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"allowHostNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowHostNetwork determines if the policy allows the use of HostNetwork in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"allowHostPorts": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowHostPorts determines if the policy allows host ports in the containers.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"allowHostPID": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowHostPID determines if the policy allows host pid in the containers.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"allowHostIPC": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowHostIPC determines if the policy allows host ipc in the containers.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"seLinuxContext": {
						SchemaProps: spec.SchemaProps{
							Description: "SELinuxContext is the strategy that will dictate what labels will be set in the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1.SELinuxContextStrategyOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "RunAsUser is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1.RunAsUserStrategyOptions"),
						},
					},
					"supplementalGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "SupplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1.SupplementalGroupsStrategyOptions"),
						},
					},
					"fsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "FSGroup is the strategy that will dictate what fs group is used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FSGroupStrategyOptions"),
						},
					},
					"readOnlyRootFilesystem": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the SCC should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"users": {
						SchemaProps: spec.SchemaProps{
							Description: "The users who have permissions to use this security context constraints",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Description: "The groups that have permission to use this security context constraints",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"seccompProfiles": {
						SchemaProps: spec.SchemaProps{
							Description: "SeccompProfiles lists the allowed profiles that may be set for the pod or container's seccomp annotations.  An unset (nil) or empty value means that no profiles may be specifid by the pod or container.\tThe wildcard '*' may be used to allow all profiles.  When used to generate a value for a pod the first non-wildcard profile will be used as the default.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"priority", "allowPrivilegedContainer", "defaultAddCapabilities", "requiredDropCapabilities", "allowedCapabilities", "allowHostDirVolumePlugin", "volumes", "allowHostNetwork", "allowHostPorts", "allowHostPID", "allowHostIPC", "readOnlyRootFilesystem"},
			},
		},
		Dependencies: []string{
			"v1.FSGroupStrategyOptions", "v1.ObjectMeta", "v1.RunAsUserStrategyOptions", "v1.SELinuxContextStrategyOptions", "v1.SupplementalGroupsStrategyOptions"},
	},
	"v1.SecurityContextConstraintsList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecurityContextConstraintsList is a list of SecurityContextConstraints objects",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of security context constraints.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.SecurityContextConstraints"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.SecurityContextConstraints"},
	},
	"v1.SerializedReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SerializedReference is a reference to serialized object.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reference": {
						SchemaProps: spec.SchemaProps{
							Description: "The reference to an object in the system.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectReference"},
	},
	"v1.Service": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of a service. http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ServiceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the service. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1.ServiceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1.ServiceSpec", "v1.ServiceStatus"},
	},
	"v1.ServiceAccount": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"secrets": {
						SchemaProps: spec.SchemaProps{
							Description: "Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: http://kubernetes.io/docs/user-guide/secrets",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ObjectReference"),
									},
								},
							},
						},
					},
					"imagePullSecrets": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: http://kubernetes.io/docs/user-guide/secrets#manually-specifying-an-imagepullsecret",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.LocalObjectReference", "v1.ObjectMeta", "v1.ObjectReference"},
	},
	"v1.ServiceAccountList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccountList is a list of ServiceAccount objects",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ServiceAccounts. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md#service-accounts",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ServiceAccount"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.ServiceAccount"},
	},
	"v1.ServiceList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceList holds a list of services.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of services",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.Service"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.Service"},
	},
	"v1.ServicePort": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServicePort contains information on service's port.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP protocol for this port. Supports \"TCP\" and \"UDP\". Default is TCP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "The port that will be exposed by this service.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetPort": {
						SchemaProps: spec.SchemaProps{
							Description: "Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: http://kubernetes.io/docs/user-guide/services#defining-a-service",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"nodePort": {
						SchemaProps: spec.SchemaProps{
							Description: "The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. More info: http://kubernetes.io/docs/user-guide/services#type--nodeport",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"v1.ServiceProxyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceProxyOptions is the query options to a Service's proxy call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.ServiceSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceSpec describes the attributes that a user creates on a service.",
				Properties: map[string]spec.Schema{
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "The list of ports that are exposed by this service. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ServicePort"),
									},
								},
							},
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: http://kubernetes.io/docs/user-guide/services#overview",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"clusterIP": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \"None\", empty string (\"\"), or a valid IP address. \"None\" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ExternalName\" maps to the specified externalName. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: http://kubernetes.io/docs/user-guide/services#overview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"externalIPs": {
						SchemaProps: spec.SchemaProps{
							Description: "externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.  A previous form of this functionality exists as the deprecatedPublicIPs field.  When using this field, callers should also clear the deprecatedPublicIPs field.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"deprecatedPublicIPs": {
						SchemaProps: spec.SchemaProps{
							Description: "deprecatedPublicIPs is deprecated and replaced by the externalIPs field with almost the exact same semantics.  This field is retained in the v1 API for compatibility until at least 8/20/2016.  It will be removed from any new API revisions.  If both deprecatedPublicIPs *and* externalIPs are set, deprecatedPublicIPs is used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"sessionAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"loadBalancerIP": {
						SchemaProps: spec.SchemaProps{
							Description: "Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"loadBalancerSourceRanges": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: http://kubernetes.io/docs/user-guide/services-firewalls",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"externalName": {
						SchemaProps: spec.SchemaProps{
							Description: "externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid DNS name and requires Type to be ExternalName.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ports"},
			},
		},
		Dependencies: []string{
			"v1.ServicePort"},
	},
	"v1.ServiceStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceStatus represents the current status of a service.",
				Properties: map[string]spec.Schema{
					"loadBalancer": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancer contains the current status of the load-balancer, if one is present.",
							Ref:         spec.MustCreateRef("#/definitions/v1.LoadBalancerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.LoadBalancerStatus"},
	},
	"v1.SupplementalGroupsStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the strategy that will dictate what supplemental groups is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.IDRange"},
	},
	"v1.TCPSocketAction": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TCPSocketAction describes an action based on opening a socket",
				Properties: map[string]spec.Schema{
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"v1.Taint": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "The node this Taint is attached to has the effect \"effect\" on any pod that that does not tolerate the Taint.",
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. The taint key to be applied to a node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. The taint value corresponding to the taint key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"effect": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule and PreferNoSchedule.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "effect"},
			},
		},
		Dependencies: []string{},
	},
	"v1.TestType": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.TestTypeStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.TestTypeStatus"},
	},
	"v1.TestTypeList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.TestType"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1.TestType"},
	},
	"v1.TestTypeStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"Blah": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"Blah"},
			},
		},
		Dependencies: []string{},
	},
	"v1.Toleration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.",
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. Key is the taint key that the toleration applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"effect": {
						SchemaProps: spec.SchemaProps{
							Description: "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and PreferNoSchedule.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1.Volume": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Volume represents a named volume in a pod that may be accessed by any container in the pod.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath",
							Ref:         spec.MustCreateRef("#/definitions/v1.HostPathVolumeSource"),
						},
					},
					"emptyDir": {
						SchemaProps: spec.SchemaProps{
							Description: "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
							Ref:         spec.MustCreateRef("#/definitions/v1.EmptyDirVolumeSource"),
						},
					},
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Ref:         spec.MustCreateRef("#/definitions/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Ref:         spec.MustCreateRef("#/definitions/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"gitRepo": {
						SchemaProps: spec.SchemaProps{
							Description: "GitRepo represents a git repository at a particular revision.",
							Ref:         spec.MustCreateRef("#/definitions/v1.GitRepoVolumeSource"),
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "Secret represents a secret that should populate this volume. More info: http://kubernetes.io/docs/user-guide/volumes#secrets",
							Ref:         spec.MustCreateRef("#/definitions/v1.SecretVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host that shares a pod's lifetime More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Ref:         spec.MustCreateRef("#/definitions/v1.NFSVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://releases.k8s.io/HEAD/examples/volumes/iscsi/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.ISCSIVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.GlusterfsVolumeSource"),
						},
					},
					"persistentVolumeClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaimVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.RBDVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlexVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.CinderVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.CephFSVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlockerVolumeSource"),
						},
					},
					"downwardAPI": {
						SchemaProps: spec.SchemaProps{
							Description: "DownwardAPI represents downward API about the pod that should populate this volume",
							Ref:         spec.MustCreateRef("#/definitions/v1.DownwardAPIVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FCVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureFileVolumeSource"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap represents a configMap that should populate this volume",
							Ref:         spec.MustCreateRef("#/definitions/v1.ConfigMapVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata represents metadata about the pod that should populate this volume Deprecated: Use downwardAPI instead.",
							Ref:         spec.MustCreateRef("#/definitions/v1.DeprecatedDownwardAPIVolumeSource"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"v1.AWSElasticBlockStoreVolumeSource", "v1.AzureDiskVolumeSource", "v1.AzureFileVolumeSource", "v1.CephFSVolumeSource", "v1.CinderVolumeSource", "v1.ConfigMapVolumeSource", "v1.DeprecatedDownwardAPIVolumeSource", "v1.DownwardAPIVolumeSource", "v1.EmptyDirVolumeSource", "v1.FCVolumeSource", "v1.FlexVolumeSource", "v1.FlockerVolumeSource", "v1.GCEPersistentDiskVolumeSource", "v1.GitRepoVolumeSource", "v1.GlusterfsVolumeSource", "v1.HostPathVolumeSource", "v1.ISCSIVolumeSource", "v1.NFSVolumeSource", "v1.PersistentVolumeClaimVolumeSource", "v1.PhotonPersistentDiskVolumeSource", "v1.QuobyteVolumeSource", "v1.RBDVolumeSource", "v1.SecretVolumeSource", "v1.VsphereVirtualDiskVolumeSource"},
	},
	"v1.VolumeMount": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VolumeMount describes a mounting of a Volume within a container.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "This must match the Name of a Volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"mountPath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path within the container at which the volume should be mounted.  Must not contain ':'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subPath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "mountPath"},
			},
		},
		Dependencies: []string{},
	},
	"v1.VolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the source of a volume to mount. Only one of its members may be specified.",
				Properties: map[string]spec.Schema{
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath",
							Ref:         spec.MustCreateRef("#/definitions/v1.HostPathVolumeSource"),
						},
					},
					"emptyDir": {
						SchemaProps: spec.SchemaProps{
							Description: "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
							Ref:         spec.MustCreateRef("#/definitions/v1.EmptyDirVolumeSource"),
						},
					},
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk",
							Ref:         spec.MustCreateRef("#/definitions/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore",
							Ref:         spec.MustCreateRef("#/definitions/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"gitRepo": {
						SchemaProps: spec.SchemaProps{
							Description: "GitRepo represents a git repository at a particular revision.",
							Ref:         spec.MustCreateRef("#/definitions/v1.GitRepoVolumeSource"),
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "Secret represents a secret that should populate this volume. More info: http://kubernetes.io/docs/user-guide/volumes#secrets",
							Ref:         spec.MustCreateRef("#/definitions/v1.SecretVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host that shares a pod's lifetime More info: http://kubernetes.io/docs/user-guide/volumes#nfs",
							Ref:         spec.MustCreateRef("#/definitions/v1.NFSVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: http://releases.k8s.io/HEAD/examples/volumes/iscsi/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.ISCSIVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.GlusterfsVolumeSource"),
						},
					},
					"persistentVolumeClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims",
							Ref:         spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaimVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.RBDVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlexVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
							Ref:         spec.MustCreateRef("#/definitions/v1.CinderVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.CephFSVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running",
							Ref:         spec.MustCreateRef("#/definitions/v1.FlockerVolumeSource"),
						},
					},
					"downwardAPI": {
						SchemaProps: spec.SchemaProps{
							Description: "DownwardAPI represents downward API about the pod that should populate this volume",
							Ref:         spec.MustCreateRef("#/definitions/v1.DownwardAPIVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.FCVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureFileVolumeSource"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap represents a configMap that should populate this volume",
							Ref:         spec.MustCreateRef("#/definitions/v1.ConfigMapVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         spec.MustCreateRef("#/definitions/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         spec.MustCreateRef("#/definitions/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         spec.MustCreateRef("#/definitions/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata represents metadata about the pod that should populate this volume Deprecated: Use downwardAPI instead.",
							Ref:         spec.MustCreateRef("#/definitions/v1.DeprecatedDownwardAPIVolumeSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.AWSElasticBlockStoreVolumeSource", "v1.AzureDiskVolumeSource", "v1.AzureFileVolumeSource", "v1.CephFSVolumeSource", "v1.CinderVolumeSource", "v1.ConfigMapVolumeSource", "v1.DeprecatedDownwardAPIVolumeSource", "v1.DownwardAPIVolumeSource", "v1.EmptyDirVolumeSource", "v1.FCVolumeSource", "v1.FlexVolumeSource", "v1.FlockerVolumeSource", "v1.GCEPersistentDiskVolumeSource", "v1.GitRepoVolumeSource", "v1.GlusterfsVolumeSource", "v1.HostPathVolumeSource", "v1.ISCSIVolumeSource", "v1.NFSVolumeSource", "v1.PersistentVolumeClaimVolumeSource", "v1.PhotonPersistentDiskVolumeSource", "v1.QuobyteVolumeSource", "v1.RBDVolumeSource", "v1.SecretVolumeSource", "v1.VsphereVirtualDiskVolumeSource"},
	},
	"v1.VsphereVirtualDiskVolumeSource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a vSphere volume resource.",
				Properties: map[string]spec.Schema{
					"volumePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path that identifies vSphere volume vmdk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"volumePath"},
			},
		},
		Dependencies: []string{},
	},
	"v1.WeightedPodAffinityTerm": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
				Properties: map[string]spec.Schema{
					"weight": {
						SchemaProps: spec.SchemaProps{
							Description: "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"podAffinityTerm": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. A pod affinity term, associated with the corresponding weight.",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodAffinityTerm"),
						},
					},
				},
				Required: []string{"weight", "podAffinityTerm"},
			},
		},
		Dependencies: []string{
			"v1.PodAffinityTerm"},
	},
	"v1alpha1.CertificateSigningRequest": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a certificate signing request",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The certificate request itself and any additional information.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.CertificateSigningRequestSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Derived information about the request.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.CertificateSigningRequestStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.CertificateSigningRequestSpec", "v1alpha1.CertificateSigningRequestStatus"},
	},
	"v1alpha1.CertificateSigningRequestCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "request approval state, currently Approved or Denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "brief reason for the request state",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "human readable message with details about the request state",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "timestamp for the last update to this condition",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1alpha1.CertificateSigningRequestList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.CertificateSigningRequest"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1alpha1.CertificateSigningRequest"},
	},
	"v1alpha1.CertificateSigningRequestSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "This information is immutable after the request is created. Only the Request and ExtraInfo fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.",
				Properties: map[string]spec.Schema{
					"request": {
						SchemaProps: spec.SchemaProps{
							Description: "Base64-encoded PKCS#10 CSR data",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "Information about the requesting user (if relevant) See user.Info interface for details",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"request"},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.CertificateSigningRequestStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions applied to the request, such as approval or denial.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.CertificateSigningRequestCondition"),
									},
								},
							},
						},
					},
					"certificate": {
						SchemaProps: spec.SchemaProps{
							Description: "If request was approved, the controller will place the issued certificate here.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1alpha1.CertificateSigningRequestCondition"},
	},
	"v1alpha1.ClusterRole": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"rules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules holds all the PolicyRules for this ClusterRole",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.PolicyRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"rules"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.PolicyRule"},
	},
	"v1alpha1.ClusterRoleBinding": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"subjects": {
						SchemaProps: spec.SchemaProps{
							Description: "Subjects holds references to the objects the role applies to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.Subject"),
									},
								},
							},
						},
					},
					"roleRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.RoleRef"),
						},
					},
				},
				Required: []string{"subjects", "roleRef"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.RoleRef", "v1alpha1.Subject"},
	},
	"v1alpha1.ClusterRoleBindingList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleBindingList is a collection of ClusterRoleBindings",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ClusterRoleBindings",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.ClusterRoleBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1alpha1.ClusterRoleBinding"},
	},
	"v1alpha1.ClusterRoleList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterRoleList is a collection of ClusterRoles",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ClusterRoles",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.ClusterRole"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1alpha1.ClusterRole"},
	},
	"v1alpha1.ImageReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReview checks if the set of images in a pod are allowed.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the pod being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.ImageReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the backend and indicates whether the pod should be allowed.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.ImageReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.ImageReviewSpec", "v1alpha1.ImageReviewStatus"},
	},
	"v1alpha1.ImageReviewContainerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewContainerSpec is a description of a container within the pod creation request.",
				Properties: map[string]spec.Schema{
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "This can be in the form image:tag or image@SHA:012345679abcdef.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.ImageReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewSpec is a description of the pod creation request.",
				Properties: map[string]spec.Schema{
					"containers": {
						SchemaProps: spec.SchemaProps{
							Description: "Containers is a list of a subset of the information in each container of the Pod being created.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.ImageReviewContainerSpec"),
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a list of key-value pairs extracted from the Pod's annotations. It only includes keys which match the pattern `*.image-policy.k8s.io/*`. It is up to each webhook backend to determine how to interpret these annotations, if at all.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace the pod is being created in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1alpha1.ImageReviewContainerSpec"},
	},
	"v1alpha1.ImageReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageReviewStatus is the result of the token authentication request.",
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed indicates that all images were allowed to be run.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason should be empty unless Allowed is false in which case it may contain a short description of what is wrong.  Kubernetes may truncate excessively long errors when displaying to the user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.KubeProxyConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"bindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "bindAddress is the IP address for the proxy server to serve on (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterCIDR is the CIDR range of the pods in the cluster. It is used to bridge traffic coming from outside of the cluster. If not provided, no off-cluster bridging will be performed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"healthzBindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzBindAddress is the IP address for the health check server to serve on, defaulting to 127.0.0.1 (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"healthzPort": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzPort is the port to bind the health check server. Use 0 to disable.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"hostnameOverride": {
						SchemaProps: spec.SchemaProps{
							Description: "hostnameOverride, if non-empty, will be used as the identity instead of the actual hostname.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iptablesMasqueradeBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMasqueradeBit is the bit of the iptables fwmark space to use for SNAT if using the pure iptables proxy mode. Values must be within the range [0, 31].",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iptablesSyncPeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesSyncPeriod is the period that iptables rules are refreshed (e.g. '5s', '1m', '2h22m').  Must be greater than 0.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"iptablesMinSyncPeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMinSyncPeriod is the minimum period that iptables rules are refreshed (e.g. '5s', '1m', '2h22m').",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"kubeconfigPath": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeconfigPath is the path to the kubeconfig file with authorization information (the master location is set by the master flag).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"masqueradeAll": {
						SchemaProps: spec.SchemaProps{
							Description: "masqueradeAll tells kube-proxy to SNAT everything if using the pure iptables proxy mode.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"master": {
						SchemaProps: spec.SchemaProps{
							Description: "master is the address of the Kubernetes API server (overrides any value in kubeconfig)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"oomScoreAdj": {
						SchemaProps: spec.SchemaProps{
							Description: "oomScoreAdj is the oom-score-adj value for kube-proxy process. Values must be within the range [-1000, 1000]",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "mode specifies which proxy mode to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"portRange": {
						SchemaProps: spec.SchemaProps{
							Description: "portRange is the range of host ports (beginPort-endPort, inclusive) that may be consumed in order to proxy service traffic. If unspecified (0-0) then ports will be randomly chosen.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceContainer": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceContainer is the bsolute name of the resource-only container to create and run the Kube-proxy in (Default: /kube-proxy).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"udpTimeoutMilliseconds": {
						SchemaProps: spec.SchemaProps{
							Description: "udpIdleTimeout is how long an idle UDP connection will be kept open (e.g. '250ms', '2s'). Must be greater than 0. Only applicable for proxyMode=userspace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"conntrackMax": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMax is the maximum number of NAT connections to track (0 to leave as-is).  This takes precedence over conntrackMaxPerCore and conntrackMin.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackMaxPerCore": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMaxPerCore is the maximum number of NAT connections to track per CPU core (0 to leave the limit as-is and ignore conntrackMin).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackMin": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackMin is the minimum value of connect-tracking records to allocate, regardless of conntrackMaxPerCore (set conntrackMaxPerCore=0 to leave the limit as-is).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conntrackTCPEstablishedTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackTCPEstablishedTimeout is how long an idle TCP connection will be kept open (e.g. '2s').  Must be greater than 0.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"conntrackTCPCloseWaitTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "conntrackTCPCloseWaitTimeout is how long an idle conntrack entry in CLOSE_WAIT state will remain in the conntrack table. (e.g. '60s'). Must be greater than 0 to set.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"TypeMeta", "bindAddress", "clusterCIDR", "healthzBindAddress", "healthzPort", "hostnameOverride", "iptablesMasqueradeBit", "iptablesSyncPeriodSeconds", "iptablesMinSyncPeriodSeconds", "kubeconfigPath", "masqueradeAll", "master", "oomScoreAdj", "mode", "portRange", "resourceContainer", "udpTimeoutMilliseconds", "conntrackMax", "conntrackMaxPerCore", "conntrackMin", "conntrackTCPEstablishedTimeout", "conntrackTCPCloseWaitTimeout"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration", "unversioned.TypeMeta"},
	},
	"v1alpha1.KubeSchedulerConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "port is the port that the scheduler's http service runs on.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "address is the IP address to serve on.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"algorithmProvider": {
						SchemaProps: spec.SchemaProps{
							Description: "algorithmProvider is the scheduling algorithm provider to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policyConfigFile": {
						SchemaProps: spec.SchemaProps{
							Description: "policyConfigFile is the filepath to the scheduler policy configuration.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableProfiling": {
						SchemaProps: spec.SchemaProps{
							Description: "enableProfiling enables profiling via web interface.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"contentType": {
						SchemaProps: spec.SchemaProps{
							Description: "contentType is contentType of requests sent to apiserver.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeAPIQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIQPS is the QPS to use while talking with kubernetes apiserver.",
							Type:        []string{"number"},
							Format:      "float",
						},
					},
					"kubeAPIBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIBurst is the QPS burst to use while talking with kubernetes apiserver.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"schedulerName": {
						SchemaProps: spec.SchemaProps{
							Description: "schedulerName is name of the scheduler, used to select which pods will be processed by this scheduler, based on pod's annotation with key 'scheduler.alpha.kubernetes.io/name'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hardPodAffinitySymmetricWeight": {
						SchemaProps: spec.SchemaProps{
							Description: "RequiredDuringScheduling affinity is not symmetric, but there is an implicit PreferredDuringScheduling affinity rule corresponding to every RequiredDuringScheduling affinity rule. HardPodAffinitySymmetricWeight represents the weight of implicit PreferredDuringScheduling affinity rule, in the range 0-100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failureDomains": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicate the \"all topologies\" set for empty topologyKey when it's used for PreferredDuringScheduling pod anti-affinity.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"leaderElection": {
						SchemaProps: spec.SchemaProps{
							Description: "leaderElection defines the configuration of leader election client.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.LeaderElectionConfiguration"),
						},
					},
				},
				Required: []string{"TypeMeta", "port", "address", "algorithmProvider", "policyConfigFile", "enableProfiling", "contentType", "kubeAPIQPS", "kubeAPIBurst", "schedulerName", "hardPodAffinitySymmetricWeight", "failureDomains", "leaderElection"},
			},
		},
		Dependencies: []string{
			"unversioned.TypeMeta", "v1alpha1.LeaderElectionConfiguration"},
	},
	"v1alpha1.KubeletAnonymousAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "enabled allows anonymous requests to the kubelet server. Requests that are not rejected by another authentication method are treated as anonymous requests. Anonymous requests have a username of system:anonymous, and a group name of system:unauthenticated.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.KubeletAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"x509": {
						SchemaProps: spec.SchemaProps{
							Description: "x509 contains settings related to x509 client certificate authentication",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletX509Authentication"),
						},
					},
					"webhook": {
						SchemaProps: spec.SchemaProps{
							Description: "webhook contains settings related to webhook bearer token authentication",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletWebhookAuthentication"),
						},
					},
					"anonymous": {
						SchemaProps: spec.SchemaProps{
							Description: "anonymous contains settings related to anonymous authentication",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletAnonymousAuthentication"),
						},
					},
				},
				Required: []string{"x509", "webhook", "anonymous"},
			},
		},
		Dependencies: []string{
			"v1alpha1.KubeletAnonymousAuthentication", "v1alpha1.KubeletWebhookAuthentication", "v1alpha1.KubeletX509Authentication"},
	},
	"v1alpha1.KubeletAuthorization": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "mode is the authorization mode to apply to requests to the kubelet server. Valid values are AlwaysAllow and Webhook. Webhook mode uses the SubjectAccessReview API to determine authorization.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"webhook": {
						SchemaProps: spec.SchemaProps{
							Description: "webhook contains settings related to Webhook authorization.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletWebhookAuthorization"),
						},
					},
				},
				Required: []string{"mode", "webhook"},
			},
		},
		Dependencies: []string{
			"v1alpha1.KubeletWebhookAuthorization"},
	},
	"v1alpha1.KubeletConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.TypeMeta"),
						},
					},
					"podManifestPath": {
						SchemaProps: spec.SchemaProps{
							Description: "podManifestPath is the path to the directory containing pod manifests to run, or the path to a single manifest file",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"syncFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "syncFrequency is the max period between synchronizing running containers and config",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"fileCheckFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "fileCheckFrequency is the duration between checking config files for new data",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"httpCheckFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "httpCheckFrequency is the duration between checking http for new data",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"manifestURL": {
						SchemaProps: spec.SchemaProps{
							Description: "manifestURL is the URL for accessing the container manifest",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"manifestURLHeader": {
						SchemaProps: spec.SchemaProps{
							Description: "manifestURLHeader is the HTTP header to use when accessing the manifest URL, with the key separated from the value with a ':', as in 'key:value'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableServer": {
						SchemaProps: spec.SchemaProps{
							Description: "enableServer enables the Kubelet's server",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "address is the IP address for the Kubelet to serve on (set to 0.0.0.0 for all interfaces)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "port is the port for the Kubelet to serve on.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnlyPort": {
						SchemaProps: spec.SchemaProps{
							Description: "readOnlyPort is the read-only port for the Kubelet to serve on with no authentication/authorization (set to 0 to disable)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"tlsCertFile": {
						SchemaProps: spec.SchemaProps{
							Description: "tlsCertFile is the file containing x509 Certificate for HTTPS.  (CA cert, if any, concatenated after server cert). If tlsCertFile and tlsPrivateKeyFile are not provided, a self-signed certificate and key are generated for the public address and saved to the directory passed to certDir.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tlsPrivateKeyFile": {
						SchemaProps: spec.SchemaProps{
							Description: "tlsPrivateKeyFile is the ile containing x509 private key matching tlsCertFile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"certDirectory": {
						SchemaProps: spec.SchemaProps{
							Description: "certDirectory is the directory where the TLS certs are located (by default /var/run/kubernetes). If tlsCertFile and tlsPrivateKeyFile are provided, this flag will be ignored.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"authentication": {
						SchemaProps: spec.SchemaProps{
							Description: "authentication specifies how requests to the Kubelet's server are authenticated",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletAuthentication"),
						},
					},
					"authorization": {
						SchemaProps: spec.SchemaProps{
							Description: "authorization specifies how requests to the Kubelet's server are authorized",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.KubeletAuthorization"),
						},
					},
					"hostnameOverride": {
						SchemaProps: spec.SchemaProps{
							Description: "hostnameOverride is the hostname used to identify the kubelet instead of the actual hostname.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podInfraContainerImage": {
						SchemaProps: spec.SchemaProps{
							Description: "podInfraContainerImage is the image whose network/ipc namespaces containers in each pod will use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dockerEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "dockerEndpoint is the path to the docker endpoint to communicate with.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rootDirectory": {
						SchemaProps: spec.SchemaProps{
							Description: "rootDirectory is the directory path to place kubelet files (volume mounts,etc).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seccompProfileRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "seccompProfileRoot is the directory path for seccomp profiles.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"allowPrivileged": {
						SchemaProps: spec.SchemaProps{
							Description: "allowPrivileged enables containers to request privileged mode. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostNetworkSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostNetworkSources is a comma-separated list of sources from which the Kubelet allows pods to use of host network. Defaults to \"*\". Valid options are \"file\", \"http\", \"api\", and \"*\" (all sources).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostPIDSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostPIDSources is a comma-separated list of sources from which the Kubelet allows pods to use the host pid namespace. Defaults to \"*\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostIPCSources": {
						SchemaProps: spec.SchemaProps{
							Description: "hostIPCSources is a comma-separated list of sources from which the Kubelet allows pods to use the host ipc namespace. Defaults to \"*\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"registryPullQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "registryPullQPS is the limit of registry pulls per second. If 0, unlimited. Set to 0 for no limit. Defaults to 5.0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"registryBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "registryBurst is the maximum size of a bursty pulls, temporarily allows pulls to burst to this number, while still not exceeding registryQps. Only used if registryQPS > 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"eventRecordQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "eventRecordQPS is the maximum event creations per second. If 0, there is no limit enforced.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"eventBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "eventBurst is the maximum size of a bursty event records, temporarily allows event records to burst to this number, while still not exceeding event-qps. Only used if eventQps > 0",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"enableDebuggingHandlers": {
						SchemaProps: spec.SchemaProps{
							Description: "enableDebuggingHandlers enables server endpoints for log collection and local running of containers and commands",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"minimumGCAge": {
						SchemaProps: spec.SchemaProps{
							Description: "minimumGCAge is the minimum age for a finished container before it is garbage collected.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"maxPerPodContainerCount": {
						SchemaProps: spec.SchemaProps{
							Description: "maxPerPodContainerCount is the maximum number of old instances to retain per container. Each container takes up some disk space.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxContainerCount": {
						SchemaProps: spec.SchemaProps{
							Description: "maxContainerCount is the maximum number of old instances of containers to retain globally. Each container takes up some disk space.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"cAdvisorPort": {
						SchemaProps: spec.SchemaProps{
							Description: "cAdvisorPort is the port of the localhost cAdvisor endpoint",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"healthzPort": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzPort is the port of the localhost healthz endpoint",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"healthzBindAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "healthzBindAddress is the IP address for the healthz server to serve on.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"oomScoreAdj": {
						SchemaProps: spec.SchemaProps{
							Description: "oomScoreAdj is The oom-score-adj value for kubelet process. Values must be within the range [-1000, 1000].",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"registerNode": {
						SchemaProps: spec.SchemaProps{
							Description: "registerNode enables automatic registration with the apiserver.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterDomain is the DNS domain for this cluster. If set, kubelet will configure all containers to search this domain in addition to the host's search domains.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"masterServiceNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "masterServiceNamespace is The namespace from which the kubernetes master services should be injected into pods.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterDNS": {
						SchemaProps: spec.SchemaProps{
							Description: "clusterDNS is the IP address for a cluster DNS server.  If set, kubelet will configure all containers to use this for DNS resolution in addition to the host's DNS servers",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"streamingConnectionIdleTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "streamingConnectionIdleTimeout is the maximum time a streaming connection can be idle before the connection is automatically closed.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeStatusUpdateFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeStatusUpdateFrequency is the frequency that kubelet posts node status to master. Note: be cautious when changing the constant, it must work with nodeMonitorGracePeriod in nodecontroller.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"imageMinimumGCAge": {
						SchemaProps: spec.SchemaProps{
							Description: "imageMinimumGCAge is the minimum age for an unused image before it is garbage collected.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"imageGCHighThresholdPercent": {
						SchemaProps: spec.SchemaProps{
							Description: "imageGCHighThresholdPercent is the percent of disk usage after which image garbage collection is always run. The percent is calculated as this field value out of 100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"imageGCLowThresholdPercent": {
						SchemaProps: spec.SchemaProps{
							Description: "imageGCLowThresholdPercent is the percent of disk usage before which image garbage collection is never run. Lowest disk usage to garbage collect to. The percent is calculated as this field value out of 100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lowDiskSpaceThresholdMB": {
						SchemaProps: spec.SchemaProps{
							Description: "lowDiskSpaceThresholdMB is the absolute free disk space, in MB, to maintain. When disk space falls below this threshold, new pods would be rejected.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"volumeStatsAggPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "How frequently to calculate and cache volume disk usage for all pods",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"networkPluginName": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginName is the name of the network plugin to be invoked for various events in kubelet/pod lifecycle",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkPluginDir": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginDir is the full path of the directory in which to search for network plugins (and, for backwards-compat, CNI config files)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cniConfDir": {
						SchemaProps: spec.SchemaProps{
							Description: "CNIConfDir is the full path of the directory in which to search for CNI config files",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cniBinDir": {
						SchemaProps: spec.SchemaProps{
							Description: "CNIBinDir is the full path of the directory in which to search for CNI plugin binaries",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkPluginMTU": {
						SchemaProps: spec.SchemaProps{
							Description: "networkPluginMTU is the MTU to be passed to the network plugin, and overrides the default MTU for cases where it cannot be automatically computed (such as IPSEC).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"volumePluginDir": {
						SchemaProps: spec.SchemaProps{
							Description: "volumePluginDir is the full path of the directory in which to search for additional third party volume plugins",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cloudProvider": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudProvider is the provider for cloud services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cloudConfigFile": {
						SchemaProps: spec.SchemaProps{
							Description: "cloudConfigFile is the path to the cloud provider configuration file.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeletCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeletCgroups is the absolute name of cgroups to isolate the kubelet in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"runtimeCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "runtimeCgroups are cgroups that container runtime is expected to be isolated in.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"systemCgroups": {
						SchemaProps: spec.SchemaProps{
							Description: "systemCgroups is absolute name of cgroups in which to place all non-kernel processes that are not already in a container. Empty for no container. Rolling back the flag requires a reboot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cgroupRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "cgroupRoot is the root cgroup to use for pods. This is handled by the container runtime on a best effort basis.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalCgroupsPerQOS": {
						SchemaProps: spec.SchemaProps{
							Description: "Enable QoS based Cgroup hierarchy: top level cgroups for QoS Classes And all Burstable and BestEffort pods are brought up under their specific top level QoS cgroup.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cgroupDriver": {
						SchemaProps: spec.SchemaProps{
							Description: "driver that the kubelet uses to manipulate cgroups on the host (cgroupfs or systemd)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntime": {
						SchemaProps: spec.SchemaProps{
							Description: "containerRuntime is the container runtime to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"remoteRuntimeEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "remoteRuntimeEndpoint is the endpoint of remote runtime service",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"remoteImageEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "remoteImageEndpoint is the endpoint of remote image service",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"runtimeRequestTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "runtimeRequestTimeout is the timeout for all runtime requests except long running requests - pull, logs, exec and attach.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"rktPath": {
						SchemaProps: spec.SchemaProps{
							Description: "rktPath is the  path of rkt binary. Leave empty to use the first rkt in $PATH.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalMounterPath": {
						SchemaProps: spec.SchemaProps{
							Description: "experimentalMounterPath is the path to mounter binary. If not set, kubelet will attempt to use mount binary that is available via $PATH,",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rktAPIEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "rktApiEndpoint is the endpoint of the rkt API service to communicate with.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rktStage1Image": {
						SchemaProps: spec.SchemaProps{
							Description: "rktStage1Image is the image to use as stage1. Local paths and http/https URLs are supported.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lockFilePath": {
						SchemaProps: spec.SchemaProps{
							Description: "lockFilePath is the path that kubelet will use to as a lock file. It uses this file as a lock to synchronize with other kubelet processes that may be running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"exitOnLockContention": {
						SchemaProps: spec.SchemaProps{
							Description: "ExitOnLockContention is a flag that signifies to the kubelet that it is running in \"bootstrap\" mode. This requires that 'LockFilePath' has been set. This will cause the kubelet to listen to inotify events on the lock file, releasing it and exiting when another process tries to open that file.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hairpinMode": {
						SchemaProps: spec.SchemaProps{
							Description: "How should the kubelet configure the container bridge for hairpin packets. Setting this flag allows endpoints in a Service to loadbalance back to themselves if they should try to access their own Service. Values:\n  \"promiscuous-bridge\": make the container bridge promiscuous.\n  \"hairpin-veth\":       set the hairpin flag on container veth interfaces.\n  \"none\":               do nothing.\nGenerally, one must set --hairpin-mode=veth-flag to achieve hairpin NAT, because promiscous-bridge assumes the existence of a container bridge named cbr0.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"babysitDaemons": {
						SchemaProps: spec.SchemaProps{
							Description: "The node has babysitter process monitoring docker and kubelet.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"maxPods": {
						SchemaProps: spec.SchemaProps{
							Description: "maxPods is the number of pods that can run on this Kubelet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nvidiaGPUs": {
						SchemaProps: spec.SchemaProps{
							Description: "nvidiaGPUs is the number of NVIDIA GPU devices on this node.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"dockerExecHandlerName": {
						SchemaProps: spec.SchemaProps{
							Description: "dockerExecHandlerName is the handler to use when executing a command in a container. Valid values are 'native' and 'nsenter'. Defaults to 'native'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "The CIDR to use for pod IP addresses, only used in standalone mode. In cluster mode, this is obtained from the master.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resolvConf": {
						SchemaProps: spec.SchemaProps{
							Description: "ResolverConfig is the resolver configuration file used as the basis for the container DNS resolution configuration.\"), []",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cpuCFSQuota": {
						SchemaProps: spec.SchemaProps{
							Description: "cpuCFSQuota is Enable CPU CFS quota enforcement for containers that specify CPU limits",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"containerized": {
						SchemaProps: spec.SchemaProps{
							Description: "containerized should be set to true if kubelet is running in a container.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"maxOpenFiles": {
						SchemaProps: spec.SchemaProps{
							Description: "maxOpenFiles is Number of files that can be opened by Kubelet process.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"reconcileCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "reconcileCIDR is Reconcile node CIDR with the CIDR specified by the API server. Won't have any effect if register-node is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"registerSchedulable": {
						SchemaProps: spec.SchemaProps{
							Description: "registerSchedulable tells the kubelet to register the node as schedulable. Won't have any effect if register-node is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"contentType": {
						SchemaProps: spec.SchemaProps{
							Description: "contentType is contentType of requests sent to apiserver.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeAPIQPS": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIQPS is the QPS to use while talking with kubernetes apiserver",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"kubeAPIBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "kubeAPIBurst is the burst to allow while talking with kubernetes apiserver",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"serializeImagePulls": {
						SchemaProps: spec.SchemaProps{
							Description: "serializeImagePulls when enabled, tells the Kubelet to pull images one at a time. We recommend *not* changing the default value on nodes that run docker daemon with version  < 1.9 or an Aufs storage backend. Issue #10959 has more details.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"outOfDiskTransitionFrequency": {
						SchemaProps: spec.SchemaProps{
							Description: "outOfDiskTransitionFrequency is duration for which the kubelet has to wait before transitioning out of out-of-disk node condition status.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"nodeIP": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeIP is IP address of the node. If set, kubelet will use this IP address for the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "nodeLabels to add when registering the node in the cluster.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"nonMasqueradeCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "nonMasqueradeCIDR configures masquerading: traffic to IPs outside this range will use IP masquerade.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableCustomMetrics": {
						SchemaProps: spec.SchemaProps{
							Description: "enable gathering custom metrics.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evictionHard": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of hard eviction expressions.  For example, 'memory.available<300Mi'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionSoft": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of soft eviction expressions.  For example, 'memory.available<300Mi'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionSoftGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimeted list of grace periods for each soft eviction signal.  For example, 'memory.available=30s'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionPressureTransitionPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Duration for which the kubelet has to wait before transitioning out of an eviction pressure condition.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"evictionMaxPodGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum allowed grace period (in seconds) to use when terminating pods in response to a soft eviction threshold being met.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionMinimumReclaim": {
						SchemaProps: spec.SchemaProps{
							Description: "Comma-delimited list of minimum reclaims (e.g. imagefs.available=2Gi) that describes the minimum amount of resource the kubelet will reclaim when performing a pod eviction if that resource is under pressure.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"experimentalKernelMemcgNotification": {
						SchemaProps: spec.SchemaProps{
							Description: "If enabled, the kubelet will integrate with the kernel memcg notification to determine if memory eviction thresholds are crossed rather than polling.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"podsPerCore": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum number of pods per core. Cannot exceed MaxPods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"enableControllerAttachDetach": {
						SchemaProps: spec.SchemaProps{
							Description: "enableControllerAttachDetach enables the Attach/Detach controller to manage attachment/detachment of volumes scheduled to this node, and disables kubelet from executing any attach/detach operations",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"systemReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "A set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently only cpu and memory are supported. [default=none] See http://kubernetes.io/docs/user-guide/compute-resources for more detail.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"kubeReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "A set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently only cpu and memory are supported. [default=none] See http://kubernetes.io/docs/user-guide/compute-resources for more detail.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"protectKernelDefaults": {
						SchemaProps: spec.SchemaProps{
							Description: "Default behaviour for kernel tuning",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"makeIPTablesUtilChains": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, Kubelet ensures a set of iptables rules are present on host. These rules will serve as utility rules for various components, e.g. KubeProxy. The rules will be created based on IPTablesMasqueradeBit and IPTablesDropBit.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"iptablesMasqueradeBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesMasqueradeBit is the bit of the iptables fwmark space to mark for SNAT Values must be within the range [0, 31]. Must be different from other mark bits. Warning: Please match the value of corresponding parameter in kube-proxy",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iptablesDropBit": {
						SchemaProps: spec.SchemaProps{
							Description: "iptablesDropBit is the bit of the iptables fwmark space to mark for dropping packets. Values must be within the range [0, 31]. Must be different from other mark bits.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"allowedUnsafeSysctls": {
						SchemaProps: spec.SchemaProps{
							Description: "Whitelist of unsafe sysctls or sysctl patterns (ending in *). Use these at your own risk. Resource isolation might be lacking and pod might influence each other on the same node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "featureGates is a string of comma-separated key=value pairs that describe feature gates for alpha/experimental features.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableCRI": {
						SchemaProps: spec.SchemaProps{
							Description: "Enable Container Runtime Interface (CRI) integration.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"experimentalFailSwapOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Tells the Kubelet to fail to start if swap is enabled on the node.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"ExperimentalCheckNodeCapabilitiesBeforeMount": {
						SchemaProps: spec.SchemaProps{
							Description: "This flag, if set, enables a check prior to mount operations to verify that the required components (binaries, etc.) to mount the volume are available on the underlying node. If the check is enabled and fails the mount operation fails.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"KeepTerminatedPodVolumes": {
						SchemaProps: spec.SchemaProps{
							Description: "This flag, if set, instructs the kubelet to keep volumes from terminated pods mounted to the node. This can be useful for debugging volume related issues.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"TypeMeta", "podManifestPath", "syncFrequency", "fileCheckFrequency", "httpCheckFrequency", "manifestURL", "manifestURLHeader", "enableServer", "address", "port", "readOnlyPort", "tlsCertFile", "tlsPrivateKeyFile", "certDirectory", "authentication", "authorization", "hostnameOverride", "podInfraContainerImage", "dockerEndpoint", "rootDirectory", "seccompProfileRoot", "allowPrivileged", "hostNetworkSources", "hostPIDSources", "hostIPCSources", "registryPullQPS", "registryBurst", "eventRecordQPS", "eventBurst", "enableDebuggingHandlers", "minimumGCAge", "maxPerPodContainerCount", "maxContainerCount", "cAdvisorPort", "healthzPort", "healthzBindAddress", "oomScoreAdj", "registerNode", "clusterDomain", "masterServiceNamespace", "clusterDNS", "streamingConnectionIdleTimeout", "nodeStatusUpdateFrequency", "imageMinimumGCAge", "imageGCHighThresholdPercent", "imageGCLowThresholdPercent", "lowDiskSpaceThresholdMB", "volumeStatsAggPeriod", "networkPluginName", "networkPluginDir", "cniConfDir", "cniBinDir", "networkPluginMTU", "volumePluginDir", "cloudProvider", "cloudConfigFile", "kubeletCgroups", "runtimeCgroups", "systemCgroups", "cgroupRoot", "containerRuntime", "remoteRuntimeEndpoint", "remoteImageEndpoint", "runtimeRequestTimeout", "rktPath", "rktAPIEndpoint", "rktStage1Image", "lockFilePath", "exitOnLockContention", "hairpinMode", "babysitDaemons", "maxPods", "nvidiaGPUs", "dockerExecHandlerName", "podCIDR", "resolvConf", "cpuCFSQuota", "containerized", "maxOpenFiles", "reconcileCIDR", "registerSchedulable", "contentType", "kubeAPIQPS", "kubeAPIBurst", "serializeImagePulls", "outOfDiskTransitionFrequency", "nodeIP", "nodeLabels", "nonMasqueradeCIDR", "enableCustomMetrics", "evictionHard", "evictionSoft", "evictionSoftGracePeriod", "evictionPressureTransitionPeriod", "evictionMaxPodGracePeriod", "evictionMinimumReclaim", "experimentalKernelMemcgNotification", "podsPerCore", "enableControllerAttachDetach", "systemReserved", "kubeReserved", "protectKernelDefaults", "makeIPTablesUtilChains", "iptablesMasqueradeBit", "iptablesDropBit"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration", "unversioned.TypeMeta", "v1alpha1.KubeletAuthentication", "v1alpha1.KubeletAuthorization"},
	},
	"v1alpha1.KubeletWebhookAuthentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "enabled allows bearer token authentication backed by the tokenreviews.authentication.k8s.io API",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cacheTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheTTL enables caching of authentication results",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"enabled", "cacheTTL"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"v1alpha1.KubeletWebhookAuthorization": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"cacheAuthorizedTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheAuthorizedTTL is the duration to cache 'authorized' responses from the webhook authorizer.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"cacheUnauthorizedTTL": {
						SchemaProps: spec.SchemaProps{
							Description: "cacheUnauthorizedTTL is the duration to cache 'unauthorized' responses from the webhook authorizer.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"cacheAuthorizedTTL", "cacheUnauthorizedTTL"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"v1alpha1.KubeletX509Authentication": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"clientCAFile": {
						SchemaProps: spec.SchemaProps{
							Description: "clientCAFile is the path to a PEM-encoded certificate bundle. If set, any request presenting a client certificate signed by one of the authorities in the bundle is authenticated with a username corresponding to the CommonName, and groups corresponding to the Organization in the client certificate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientCAFile"},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.LeaderElectionConfiguration": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LeaderElectionConfiguration defines the configuration of leader election clients for components that can run with leader election enabled.",
				Properties: map[string]spec.Schema{
					"leaderElect": {
						SchemaProps: spec.SchemaProps{
							Description: "leaderElect enables a leader election client to gain leadership before executing the main loop. Enable this when running replicated components for high availability.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"leaseDuration": {
						SchemaProps: spec.SchemaProps{
							Description: "leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"renewDeadline": {
						SchemaProps: spec.SchemaProps{
							Description: "renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
					"retryPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Duration"),
						},
					},
				},
				Required: []string{"leaderElect", "leaseDuration", "renewDeadline", "retryPeriod"},
			},
		},
		Dependencies: []string{
			"unversioned.Duration"},
	},
	"v1alpha1.PolicyRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.",
				Properties: map[string]spec.Schema{
					"verbs": {
						SchemaProps: spec.SchemaProps{
							Description: "Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.  VerbAll represents all kinds.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"attributeRestrictions": {
						SchemaProps: spec.SchemaProps{
							Description: "AttributeRestrictions will vary depending on what the Authorizer/AuthorizationAttributeBuilder pair supports. If the Authorizer does not recognize how to handle the AttributeRestrictions, the Authorizer should report an error.",
							Ref:         spec.MustCreateRef("#/definitions/runtime.RawExtension"),
						},
					},
					"apiGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  ResourceAll represents all resources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"resourceNames": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"nonResourceURLs": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path This name is intentionally different than the internal type so that the DefaultConvert works nicely and because the ordering may be different. Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as \"pods\" or \"secrets\") or non-resource URL paths (such as \"/api\"),  but not both.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
		Dependencies: []string{
			"runtime.RawExtension"},
	},
	"v1alpha1.Role": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"rules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules holds all the PolicyRules for this Role",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.PolicyRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"rules"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.PolicyRule"},
	},
	"v1alpha1.RoleBinding": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"subjects": {
						SchemaProps: spec.SchemaProps{
							Description: "Subjects holds references to the objects the role applies to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.Subject"),
									},
								},
							},
						},
					},
					"roleRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.",
							Ref:         spec.MustCreateRef("#/definitions/v1alpha1.RoleRef"),
						},
					},
				},
				Required: []string{"subjects", "roleRef"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1alpha1.RoleRef", "v1alpha1.Subject"},
	},
	"v1alpha1.RoleBindingList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleBindingList is a collection of RoleBindings",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of RoleBindings",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.RoleBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1alpha1.RoleBinding"},
	},
	"v1alpha1.RoleList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleList is a collection of Roles",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of Roles",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1alpha1.Role"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1alpha1.Role"},
	},
	"v1alpha1.RoleRef": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RoleRef contains information that points to the role being used",
				Properties: map[string]spec.Schema{
					"apiGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup is the group for the resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the type of resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of resource being referenced",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"apiGroup", "kind", "name"},
			},
		},
		Dependencies: []string{},
	},
	"v1alpha1.Subject": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion holds the API group and version of the referenced object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object being referenced.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.APIVersion": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An APIVersion represents a single concrete version of an object model.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of this version (e.g. 'v1').",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.CPUTargetUtilization": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"targetPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "fraction of the requested CPU that should be utilized/used, e.g. 70 means that 70% of the requested CPU should be in use.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"targetPercentage"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.Cluster": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Information about a registered cluster in a federated kubernetes setup. Clusters are not namespaced and have unique names in the federation.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of the Cluster.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ClusterSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status describes the current status of a Cluster",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ClusterStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.ClusterSpec", "v1beta1.ClusterStatus"},
	},
	"v1beta1.ClusterCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterCondition describes current state of a cluster.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of cluster condition, Complete or Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.ClusterList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A list of all the kubernetes clusters registered to the federation",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of Cluster objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.Cluster"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.Cluster"},
	},
	"v1beta1.ClusterSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterSpec describes the attributes of a kubernetes cluster.",
				Properties: map[string]spec.Schema{
					"serverAddressByClientCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "A map of client CIDR to server address. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ServerAddressByClientCIDR"),
									},
								},
							},
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the secret containing kubeconfig to access this cluster. The secret is read from the kubernetes cluster that is hosting federation control plane. Admin needs to ensure that the required secret exists. Secret should be in the same namespace where federation control plane is hosted and it should have kubeconfig in its data with key \"kubeconfig\". This will later be changed to a reference to secret in federation control plane when the federation control plane supports secrets. This can be left empty if the cluster allows insecure access.",
							Ref:         spec.MustCreateRef("#/definitions/v1.LocalObjectReference"),
						},
					},
				},
				Required: []string{"serverAddressByClientCIDRs"},
			},
		},
		Dependencies: []string{
			"v1.LocalObjectReference", "v1beta1.ServerAddressByClientCIDR"},
	},
	"v1beta1.ClusterStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterStatus is information about the current status of a cluster updated by cluster controller peridocally.",
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions is an array of current cluster conditions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ClusterCondition"),
									},
								},
							},
						},
					},
					"zones": {
						SchemaProps: spec.SchemaProps{
							Description: "Zones is the list of availability zones in which the nodes of the cluster exist, e.g. 'us-east1-a'. These will always be in the same region.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is the name of the region in which all of the nodes in the cluster exist.  e.g. 'us-east1'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.ClusterCondition"},
	},
	"v1beta1.CustomMetricCurrentStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric value (average).",
							Ref:         spec.MustCreateRef("#/definitions/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1beta1.CustomMetricCurrentStatusList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.CustomMetricCurrentStatus"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"v1beta1.CustomMetricCurrentStatus"},
	},
	"v1beta1.CustomMetricTarget": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Alpha-level support for Custom Metrics in HPA (as annotations).",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom Metric value (average).",
							Ref:         spec.MustCreateRef("#/definitions/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"resource.Quantity"},
	},
	"v1beta1.CustomMetricTargetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.CustomMetricTarget"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"v1beta1.CustomMetricTarget"},
	},
	"v1beta1.DaemonSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSet represents the configuration of a daemon set.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired behavior of this daemon set. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.DaemonSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.DaemonSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.DaemonSetSpec", "v1beta1.DaemonSetStatus"},
	},
	"v1beta1.DaemonSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.DaemonSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.DaemonSet"},
	},
	"v1beta1.DaemonSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: http://kubernetes.io/docs/user-guide/replication-controller#pod-template",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec"},
	},
	"v1beta1.DaemonSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "CurrentNumberScheduled is the number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: http://releases.k8s.io/HEAD/docs/admin/daemons.md",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "NumberMisscheduled is the number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: http://releases.k8s.io/HEAD/docs/admin/daemons.md",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "DesiredNumberScheduled is the total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: http://releases.k8s.io/HEAD/docs/admin/daemons.md",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "NumberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.Deployment": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Deployment enables declarative updates for Pods and ReplicaSets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.DeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.DeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.DeploymentSpec", "v1beta1.DeploymentStatus"},
	},
	"v1beta1.DeploymentCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.DeploymentList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.Deployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.Deployment"},
	},
	"v1beta1.DeploymentRollback": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentRollback stores the information required to rollback a deployment.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: This must match the Name of a deployment.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updatedAnnotations": {
						SchemaProps: spec.SchemaProps{
							Description: "The annotations to be updated to a deployment",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config of this deployment rollback.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.RollbackConfig"),
						},
					},
				},
				Required: []string{"name", "rollbackTo"},
			},
		},
		Dependencies: []string{
			"v1beta1.RollbackConfig"},
	},
	"v1beta1.DeploymentSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created.",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
					"strategy": {
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.DeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused and will not be processed by the deployment controller.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config this deployment is rolling back to. Will be cleared after rollback is done.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.RollbackConfig"),
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Once autoRollback is implemented, the deployment controller will automatically rollback failed deployments. Note that progress will not be estimated during the time a deployment is paused. This is not set by default.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec", "v1beta1.DeploymentStrategy", "v1beta1.RollbackConfig"},
	},
	"v1beta1.DeploymentStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.DeploymentCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.DeploymentCondition"},
	},
	"v1beta1.DeploymentStrategy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.RollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.RollingUpdateDeployment"},
	},
	"v1beta1.Eviction": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectMeta describes the pod that is being evicted.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"deleteOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "DeleteOptions may be provided",
							Ref:         spec.MustCreateRef("#/definitions/v1.DeleteOptions"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.DeleteOptions", "v1.ObjectMeta"},
	},
	"v1beta1.ExportOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExportOptions is the query options to the standard REST get call.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"export": {
						SchemaProps: spec.SchemaProps{
							Description: "Should this value be exported.  Export strips fields that a user can not specify.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"exact": {
						SchemaProps: spec.SchemaProps{
							Description: "Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"export", "exact"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.FSGroupStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FSGroupStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate what FSGroup is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.IDRange"},
	},
	"v1beta1.HTTPIngressPath": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional \"path\" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"backend": {
						SchemaProps: spec.SchemaProps{
							Description: "Backend defines the referenced service endpoint to which the traffic will be forwarded to.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.IngressBackend"),
						},
					},
				},
				Required: []string{"backend"},
			},
		},
		Dependencies: []string{
			"v1beta1.IngressBackend"},
	},
	"v1beta1.HTTPIngressRuleValue": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.",
				Properties: map[string]spec.Schema{
					"paths": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of paths that map requests to backends.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.HTTPIngressPath"),
									},
								},
							},
						},
					},
				},
				Required: []string{"paths"},
			},
		},
		Dependencies: []string{
			"v1beta1.HTTPIngressPath"},
	},
	"v1beta1.HorizontalPodAutoscaler": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "behaviour of autoscaler. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current information about the autoscaler.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.HorizontalPodAutoscalerSpec", "v1beta1.HorizontalPodAutoscalerStatus"},
	},
	"v1beta1.HorizontalPodAutoscalerList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.HorizontalPodAutoscaler"},
	},
	"v1beta1.HorizontalPodAutoscalerSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Properties: map[string]spec.Schema{
					"scaleRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to Scale subresource; horizontal pod autoscaler will learn the current resource consumption from its status, and will set the desired number of pods by modifying its spec.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubresourceReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "lower limit for the number of pods that can be set by the autoscaler, default 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"cpuUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified it defaults to the target CPU utilization at 80% of the requested resources.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.CPUTargetUtilization"),
						},
					},
				},
				Required: []string{"scaleRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"v1beta1.CPUTargetUtilization", "v1beta1.SubresourceReference"},
	},
	"v1beta1.HorizontalPodAutoscalerStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.HostPortRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Host Port Range defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined.",
				Properties: map[string]spec.Schema{
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "min is the start of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "max is the end of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"min", "max"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.IDRange": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ID Range provides a min/max of an allowed range of IDs.",
				Properties: map[string]spec.Schema{
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min is the start of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max is the end of the range, inclusive.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"min", "max"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.Ingress": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is the desired state of the Ingress. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.IngressSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current state of the Ingress. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.IngressStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.IngressSpec", "v1beta1.IngressStatus"},
	},
	"v1beta1.IngressBackend": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressBackend describes all endpoints for a given service and port.",
				Properties: map[string]spec.Schema{
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the name of the referenced service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"servicePort": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the port of the referenced service.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
				Required: []string{"serviceName", "servicePort"},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"v1beta1.IngressList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressList is a collection of Ingress.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Ingress.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.Ingress"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.Ingress"},
	},
	"v1beta1.IngressRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.",
				Properties: map[string]spec.Schema{
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the \"host\" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the\n\t  IP in the Spec of the parent Ingress.\n2. The `:` delimiter is not respected because ports are not allowed.\n\t  Currently the port of an Ingress is implicitly :80 for http and\n\t  :443 for https.\nBoth these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"http": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1beta1.HTTPIngressRuleValue"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.HTTPIngressRuleValue"},
	},
	"v1beta1.IngressRuleValue": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressRuleValue represents a rule to apply against incoming requests. If the rule is satisfied, the request is routed to the specified backend. Currently mixing different types of rules in a single Ingress is disallowed, so exactly one of the following must be set.",
				Properties: map[string]spec.Schema{
					"http": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1beta1.HTTPIngressRuleValue"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.HTTPIngressRuleValue"},
	},
	"v1beta1.IngressSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressSpec describes the Ingress the user wishes to exist.",
				Properties: map[string]spec.Schema{
					"backend": {
						SchemaProps: spec.SchemaProps{
							Description: "A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.IngressBackend"),
						},
					},
					"tls": {
						SchemaProps: spec.SchemaProps{
							Description: "TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.IngressTLS"),
									},
								},
							},
						},
					},
					"rules": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.IngressRule"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.IngressBackend", "v1beta1.IngressRule", "v1beta1.IngressTLS"},
	},
	"v1beta1.IngressStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressStatus describe the current state of the Ingress.",
				Properties: map[string]spec.Schema{
					"loadBalancer": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancer contains the current status of the load-balancer.",
							Ref:         spec.MustCreateRef("#/definitions/v1.LoadBalancerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.LoadBalancerStatus"},
	},
	"v1beta1.IngressTLS": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IngressTLS describes the transport layer security associated with an Ingress.",
				Properties: map[string]spec.Schema{
					"hosts": {
						SchemaProps: spec.SchemaProps{
							Description: "Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.Job": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Job represents the configuration of a single job. DEPRECATED: extensions/v1beta1.Job is deprecated, use batch/v1.Job instead.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.JobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.JobSpec", "v1beta1.JobStatus"},
	},
	"v1beta1.JobCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobCondition describes current state of a job.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of job condition, Complete or Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.JobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobList is a collection of jobs. DEPRECATED: extensions/v1beta1.JobList is deprecated, use batch/v1.JobList instead.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Job.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.Job"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.Job"},
	},
	"v1beta1.JobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobSpec describes how the job execution will look like.",
				Properties: map[string]spec.Schema{
					"parallelism": {
						SchemaProps: spec.SchemaProps{
							Description: "Parallelism specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completions": {
						SchemaProps: spec.SchemaProps{
							Description: "Completions specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the pod count. Normally, the system sets this field for you. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"autoSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "AutoSelector controls generation of pod labels and pod selectors. It was not present in the original extensions/v1beta1 Job definition, but exists to allow conversion from batch/v1 Jobs, where it corresponds to, but has the opposite meaning as, ManualSelector. More info: http://releases.k8s.io/HEAD/docs/design/selector-generation.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created when executing a job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec"},
	},
	"v1beta1.JobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobStatus represents the current state of a Job.",
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represent the latest available observations of an object's current state. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.JobCondition"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active is the number of actively running pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"succeeded": {
						SchemaProps: spec.SchemaProps{
							Description: "Succeeded is the number of pods which reached Phase Succeeded.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "Failed is the number of pods which reached Phase Failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1beta1.JobCondition"},
	},
	"v1beta1.LocalSubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.SubjectAccessReviewSpec", "v1beta1.SubjectAccessReviewStatus"},
	},
	"v1beta1.NetworkPolicy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior for this NetworkPolicy.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.NetworkPolicySpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.NetworkPolicySpec"},
	},
	"v1beta1.NetworkPolicyIngressRule": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.",
				Properties: map[string]spec.Schema{
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is not provided, this rule matches all ports (traffic not restricted by port). If this field is empty, this rule matches no ports (no traffic matches). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.NetworkPolicyPort"),
									},
								},
							},
						},
					},
					"from": {
						SchemaProps: spec.SchemaProps{
							Description: "List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is not provided, this rule matches all sources (traffic not restricted by source). If this field is empty, this rule matches no sources (no traffic matches). If this field is present and contains at least on item, this rule allows traffic only if the traffic matches at least one item in the from list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.NetworkPolicyPeer"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.NetworkPolicyPeer", "v1beta1.NetworkPolicyPort"},
	},
	"v1beta1.NetworkPolicyList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Network Policy List is a list of NetworkPolicy objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of schema objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.NetworkPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.NetworkPolicy"},
	},
	"v1beta1.NetworkPolicyPeer": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"podSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "This is a label selector which selects Pods in this namespace. This field follows standard label selector semantics. If not provided, this selector selects no pods. If present but empty, this selector selects all pods in this namespace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects Namespaces using cluster scoped-labels.  This matches all pods in all namespaces selected by this label selector. This field follows standard label selector semantics. If omitted, this selector selects no namespaces. If present but empty, this selector selects all namespaces.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector"},
	},
	"v1beta1.NetworkPolicyPort": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional.  The protocol (TCP or UDP) which traffic must match. If not specified, this field defaults to TCP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"v1beta1.NetworkPolicySpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"podSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if namespace.networkPolicy.ingress.isolation is undefined and cluster policy allows it, OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not affect ingress isolation. If this field is present and contains at least one rule, this policy allows any traffic which matches at least one of the ingress rules in this list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.NetworkPolicyIngressRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"podSelector"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1beta1.NetworkPolicyIngressRule"},
	},
	"v1beta1.NonResourceAttributes": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.PodDisruptionBudget": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the PodDisruptionBudget.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.PodDisruptionBudgetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the PodDisruptionBudget.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.PodDisruptionBudgetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.PodDisruptionBudgetSpec", "v1beta1.PodDisruptionBudgetStatus"},
	},
	"v1beta1.PodDisruptionBudgetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetList is a collection of PodDisruptionBudgets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.PodDisruptionBudget"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.PodDisruptionBudget"},
	},
	"v1beta1.PodDisruptionBudgetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.",
				Properties: map[string]spec.Schema{
					"minAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "An eviction is allowed if at least \"minAvailable\" pods selected by \"selector\" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying \"100%\".",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label query over pods whose evictions are managed by the disruption budget.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString", "unversioned.LabelSelector"},
	},
	"v1beta1.PodDisruptionBudgetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recent generation observed when updating this PDB status. PodDisruptionsAllowed and other status informatio is valid only if observedGeneration equals to PDB's object generation.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"disruptedPods": {
						SchemaProps: spec.SchemaProps{
							Description: "DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/unversioned.Time"),
									},
								},
							},
						},
					},
					"disruptionsAllowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of pod disruptions that are currently allowed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentHealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of healthy pods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredHealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "minimum desired number of healthy pods",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"expectedPods": {
						SchemaProps: spec.SchemaProps{
							Description: "total number of pods counted by this disruption budget",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"disruptedPods", "disruptionsAllowed", "currentHealthy", "desiredHealthy", "expectedPods"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.PodSecurityPolicy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod Security Policy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the policy enforced.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.PodSecurityPolicySpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.PodSecurityPolicySpec"},
	},
	"v1beta1.PodSecurityPolicyList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod Security Policy List is a list of PodSecurityPolicy objects.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of schema objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.PodSecurityPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.PodSecurityPolicy"},
	},
	"v1beta1.PodSecurityPolicySpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod Security Policy Spec defines the policy enforced.",
				Properties: map[string]spec.Schema{
					"privileged": {
						SchemaProps: spec.SchemaProps{
							Description: "privileged determines if a pod can request to be run as privileged.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"defaultAddCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capabiility in both DefaultAddCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"requiredDropCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "RequiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"allowedCapabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both AllowedCapabilities and RequiredDropCapabilities.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Description: "volumes is a white list of allowed volume plugins.  Empty indicates that all plugins may be used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"hostNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostPorts": {
						SchemaProps: spec.SchemaProps{
							Description: "hostPorts determines which host port ranges are allowed to be exposed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.HostPortRange"),
									},
								},
							},
						},
					},
					"hostPID": {
						SchemaProps: spec.SchemaProps{
							Description: "hostPID determines if the policy allows the use of HostPID in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostIPC": {
						SchemaProps: spec.SchemaProps{
							Description: "hostIPC determines if the policy allows the use of HostIPC in the pod spec.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"seLinux": {
						SchemaProps: spec.SchemaProps{
							Description: "seLinux is the strategy that will dictate the allowable labels that may be set.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SELinuxStrategyOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.RunAsUserStrategyOptions"),
						},
					},
					"supplementalGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "SupplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SupplementalGroupsStrategyOptions"),
						},
					},
					"fsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "FSGroup is the strategy that will dictate what fs group is used by the SecurityContext.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.FSGroupStrategyOptions"),
						},
					},
					"readOnlyRootFilesystem": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"seLinux", "runAsUser", "supplementalGroups", "fsGroup"},
			},
		},
		Dependencies: []string{
			"v1beta1.FSGroupStrategyOptions", "v1beta1.HostPortRange", "v1beta1.RunAsUserStrategyOptions", "v1beta1.SELinuxStrategyOptions", "v1beta1.SupplementalGroupsStrategyOptions"},
	},
	"v1beta1.ReplicaSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSet represents the configuration of a ReplicaSet.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the ReplicaSet. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ReplicaSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ReplicaSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.ReplicaSetSpec", "v1beta1.ReplicaSetStatus"},
	},
	"v1beta1.ReplicaSetCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v1beta1.ReplicaSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ReplicaSets. More info: http://kubernetes.io/docs/user-guide/replication-controller",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ReplicaSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.ReplicaSet"},
	},
	"v1beta1.ReplicaSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: http://kubernetes.io/docs/user-guide/replication-controller#what-is-a-replication-controller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. If the selector is empty, it is defaulted to the labels present on the pod template. Label keys and values that must match in order to be controlled by this replica set. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: http://kubernetes.io/docs/user-guide/replication-controller#pod-template",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec"},
	},
	"v1beta1.ReplicaSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently oberved number of replicas. More info: http://kubernetes.io/docs/user-guide/replication-controller#what-is-a-replication-controller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ReplicaSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"v1beta1.ReplicaSetCondition"},
	},
	"v1beta1.ReplicationControllerDummy": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Dummy definition",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.ResourceAttributes": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.RollbackConfig": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "The revision to rollback to. If set to 0, rollbck to the last revision.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.RollingUpdateDeployment": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is atmost 130% of desired pods.",
							Ref:         spec.MustCreateRef("#/definitions/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"intstr.IntOrString"},
	},
	"v1beta1.RunAsUserStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Run A sUser Strategy Options defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate the allowable RunAsUser values that may be set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of uids that may be used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.IDRange"),
									},
								},
							},
						},
					},
				},
				Required: []string{"rule"},
			},
		},
		Dependencies: []string{
			"v1beta1.IDRange"},
	},
	"v1beta1.SELinuxStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SELinux  Strategy Options defines the strategy type and any options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the strategy that will dictate the allowable labels that may be set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "seLinuxOptions required to run as; required for MustRunAs More info: http://releases.k8s.io/HEAD/docs/design/security_context.md#security-context",
							Ref:         spec.MustCreateRef("#/definitions/v1.SELinuxOptions"),
						},
					},
				},
				Required: []string{"rule"},
			},
		},
		Dependencies: []string{
			"v1.SELinuxOptions"},
	},
	"v1beta1.Scale": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "represents a scaling request for a resource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status. Read-only.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.ScaleSpec", "v1beta1.ScaleStatus"},
	},
	"v1beta1.ScaleSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "describes the attributes of a scale subresource",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.ScaleStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "represents the current status of a scale subresource.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "label query over pods that should match the replicas count. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"targetSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.SelfSubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  user and groups must be empty",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SelfSubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.SelfSubjectAccessReviewSpec", "v1beta1.SubjectAccessReviewStatus"},
	},
	"v1beta1.SelfSubjectAccessReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.NonResourceAttributes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.NonResourceAttributes", "v1beta1.ResourceAttributes"},
	},
	"v1beta1.ServerAddressByClientCIDR": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
				Properties: map[string]spec.Schema{
					"clientCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serverAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientCIDR", "serverAddress"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.StatefulSet": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n - Network: A single stable DNS and hostname.\n - Storage: As many VolumeClaims as requested.\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.StatefulSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.StatefulSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.StatefulSetSpec", "v1beta1.StatefulSetStatus"},
	},
	"v1beta1.StatefulSetList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.StatefulSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.StatefulSet"},
	},
	"v1beta1.StatefulSetSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
					"volumeClaimTemplates": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"template", "serviceName"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PersistentVolumeClaim", "v1.PodTemplateSpec"},
	},
	"v1beta1.StatefulSetStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of actual replicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.StorageClass": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.\n\nStorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"provisioner": {
						SchemaProps: spec.SchemaProps{
							Description: "Provisioner indicates the type of the provisioner.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"parameters": {
						SchemaProps: spec.SchemaProps{
							Description: "Parameters holds the parameters for the provisioner that should create volumes of this storage class.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"provisioner"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta"},
	},
	"v1beta1.StorageClassList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StorageClassList is a collection of storage classes.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of StorageClasses",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.StorageClass"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.StorageClass"},
	},
	"v1beta1.SubjectAccessReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.SubjectAccessReviewSpec", "v1beta1.SubjectAccessReviewStatus"},
	},
	"v1beta1.SubjectAccessReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.NonResourceAttributes"),
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Group\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type:   []string{"string"},
													Format: "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.NonResourceAttributes", "v1beta1.ResourceAttributes"},
	},
	"v1beta1.SubjectAccessReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required.  True if the action would be allowed, false otherwise.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.SubresourceReference": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubresourceReference contains enough information to let you inspect or modify the referred subresource.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource name of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.SupplementalGroupsStrategyOptions": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.",
				Properties: map[string]spec.Schema{
					"rule": {
						SchemaProps: spec.SchemaProps{
							Description: "Rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ranges": {
						SchemaProps: spec.SchemaProps{
							Description: "Ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.IDRange"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.IDRange"},
	},
	"v1beta1.ThirdPartyResource": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A ThirdPartyResource is a generic representation of a resource, it is used by add-ons and plugins to add new resource types to the API.  It consists of one or more Versions of the api.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is the description of this object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "Versions are versions for this third party object",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.APIVersion"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.APIVersion"},
	},
	"v1beta1.ThirdPartyResourceData": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An internal object, used for versioned storage in etcd.  Not exposed to the end user.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the raw JSON data for this data.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta"},
	},
	"v1beta1.ThirdPartyResourceDataList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ThirdPartyResrouceDataList is a list of ThirdPartyResourceData.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ThirdpartyResourceData.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ThirdPartyResourceData"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.ThirdPartyResourceData"},
	},
	"v1beta1.ThirdPartyResourceList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ThirdPartyResourceList is a list of ThirdPartyResources.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ThirdPartyResources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1beta1.ThirdPartyResource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v1beta1.ThirdPartyResource"},
	},
	"v1beta1.TokenReview": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.TokenReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request can be authenticated.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.TokenReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v1beta1.TokenReviewSpec", "v1beta1.TokenReviewStatus"},
	},
	"v1beta1.TokenReviewSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v1beta1.TokenReviewStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request.",
				Properties: map[string]spec.Schema{
					"authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Ref:         spec.MustCreateRef("#/definitions/v1beta1.UserInfo"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1beta1.UserInfo"},
	},
	"v1beta1.UserInfo": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Properties: map[string]spec.Schema{
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type:   []string{"string"},
													Format: "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{},
	},
	"v2alpha1.CronJob": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJob represents the configuration of a single cron job.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job, including the schedule. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.CronJobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.CronJobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v2alpha1.CronJobSpec", "v2alpha1.CronJobStatus"},
	},
	"v2alpha1.CronJobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobList is a collection of cron jobs.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of CronJob.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v2alpha1.CronJob"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v2alpha1.CronJob"},
	},
	"v2alpha1.CronJobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobSpec describes how the job execution will look like and when it will actually run.",
				Properties: map[string]spec.Schema{
					"schedule": {
						SchemaProps: spec.SchemaProps{
							Description: "Schedule contains the schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startingDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"concurrencyPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "ConcurrencyPolicy specifies how to treat concurrent executions of a Job.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"suspend": {
						SchemaProps: spec.SchemaProps{
							Description: "Suspend flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"jobTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "JobTemplate is the object that describes the job that will be created when executing a CronJob.",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.JobTemplateSpec"),
						},
					},
				},
				Required: []string{"schedule", "jobTemplate"},
			},
		},
		Dependencies: []string{
			"v2alpha1.JobTemplateSpec"},
	},
	"v2alpha1.CronJobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobStatus represents the current state of a cron job.",
				Properties: map[string]spec.Schema{
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active holds pointers to currently running jobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v1.ObjectReference"),
									},
								},
							},
						},
					},
					"lastScheduleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "LastScheduleTime keeps information of when was the last time the job was successfully scheduled.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v1.ObjectReference"},
	},
	"v2alpha1.Job": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Job represents the configuration of a single job.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is a structure defining the expected behavior of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.JobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a structure describing current status of a job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v2alpha1.JobSpec", "v2alpha1.JobStatus"},
	},
	"v2alpha1.JobCondition": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobCondition describes current state of a job.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of job condition, Complete or Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"unversioned.Time"},
	},
	"v2alpha1.JobList": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobList is a collection of jobs.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Job.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v2alpha1.Job"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"unversioned.ListMeta", "v2alpha1.Job"},
	},
	"v2alpha1.JobSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobSpec describes how the job execution will look like.",
				Properties: map[string]spec.Schema{
					"parallelism": {
						SchemaProps: spec.SchemaProps{
							Description: "Parallelism specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completions": {
						SchemaProps: spec.SchemaProps{
							Description: "Completions specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the pod count. Normally, the system sets this field for you. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.LabelSelector"),
						},
					},
					"manualSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ManualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: http://releases.k8s.io/HEAD/docs/design/selector-generation.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created when executing a job. More info: http://kubernetes.io/docs/user-guide/jobs",
							Ref:         spec.MustCreateRef("#/definitions/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"unversioned.LabelSelector", "v1.PodTemplateSpec"},
	},
	"v2alpha1.JobStatus": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobStatus represents the current state of a Job.",
				Properties: map[string]spec.Schema{
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represent the latest available observations of an object's current state. More info: http://kubernetes.io/docs/user-guide/jobs",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: spec.MustCreateRef("#/definitions/v2alpha1.JobCondition"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         spec.MustCreateRef("#/definitions/unversioned.Time"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active is the number of actively running pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"succeeded": {
						SchemaProps: spec.SchemaProps{
							Description: "Succeeded is the number of pods which reached Phase Succeeded.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "Failed is the number of pods which reached Phase Failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"unversioned.Time", "v2alpha1.JobCondition"},
	},
	"v2alpha1.JobTemplate": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobTemplate describes a template for creating copies of a predefined pod.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines jobs that will be created from this template http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.JobTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v2alpha1.JobTemplateSpec"},
	},
	"v2alpha1.JobTemplateSpec": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobTemplateSpec describes the data a Job should have when created from a template",
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata of the jobs created from this template. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
							Ref:         spec.MustCreateRef("#/definitions/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the job. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status",
							Ref:         spec.MustCreateRef("#/definitions/v2alpha1.JobSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"v1.ObjectMeta", "v2alpha1.JobSpec"},
	},
	"version.Info": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Info contains versioning information. how we'll want to distribute that information.",
				Properties: map[string]spec.Schema{
					"major": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"minor": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"gitVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"gitCommit": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"gitTreeState": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"buildDate": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"goVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"compiler": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"platform": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"major", "minor", "gitVersion", "gitCommit", "gitTreeState", "buildDate", "goVersion", "compiler", "platform"},
			},
		},
		Dependencies: []string{},
	},
	"versioned.Event": {
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Event represents a single event to a watched resource.",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *api.Status is recommended; other types may make sense\n   depending on context.",
							Ref:         spec.MustCreateRef("#/definitions/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"type", "object"},
			},
		},
		Dependencies: []string{
			"runtime.RawExtension"},
	},
}
