// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package s3 provides a client for Amazon Simple Storage Service.
package s3

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a request for the AbortMultipartUpload operation.
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AbortMultipartUploadOutput{}
	req.Data = output
	return
}

// Aborts a multipart upload.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the List Parts operation and ensure the
// parts list is empty.
func (c *S3) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a request for the CompleteMultipartUpload operation.
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *CompleteMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteMultipartUploadOutput{}
	req.Data = output
	return
}

// Completes a multipart upload by assembling previously uploaded parts.
func (c *S3) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCopyObject = "CopyObject"

// CopyObjectRequest generates a request for the CopyObject operation.
func (c *S3) CopyObjectRequest(input *CopyObjectInput) (req *request.Request, output *CopyObjectOutput) {
	op := &request.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyObjectOutput{}
	req.Data = output
	return
}

// Creates a copy of an object that is already stored in Amazon S3.
func (c *S3) CopyObject(input *CopyObjectInput) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a request for the CreateBucket operation.
func (c *S3) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateBucketOutput{}
	req.Data = output
	return
}

// Creates a new bucket.
func (c *S3) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	err := req.Send()
	return out, err
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest generates a request for the CreateMultipartUpload operation.
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) (req *request.Request, output *CreateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateMultipartUploadOutput{}
	req.Data = output
	return
}

// Initiates a multipart upload and returns an upload ID.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
func (c *S3) CreateMultipartUpload(input *CreateMultipartUploadInput) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a request for the DeleteBucket operation.
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketOutput{}
	req.Data = output
	return
}

// Deletes the bucket. All objects (including all object versions and Delete
// Markers) in the bucket must be deleted before the bucket itself can be deleted.
func (c *S3) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest generates a request for the DeleteBucketCors operation.
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) (req *request.Request, output *DeleteBucketCorsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketCorsOutput{}
	req.Data = output
	return
}

// Deletes the cors configuration information set for the bucket.
func (c *S3) DeleteBucketCors(input *DeleteBucketCorsInput) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest generates a request for the DeleteBucketLifecycle operation.
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) (req *request.Request, output *DeleteBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketLifecycleOutput{}
	req.Data = output
	return
}

// Deletes the lifecycle configuration from the bucket.
func (c *S3) DeleteBucketLifecycle(input *DeleteBucketLifecycleInput) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a request for the DeleteBucketPolicy operation.
func (c *S3) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketPolicyOutput{}
	req.Data = output
	return
}

// Deletes the policy from the bucket.
func (c *S3) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest generates a request for the DeleteBucketReplication operation.
func (c *S3) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) (req *request.Request, output *DeleteBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketReplicationOutput{}
	req.Data = output
	return
}

func (c *S3) DeleteBucketReplication(input *DeleteBucketReplicationInput) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a request for the DeleteBucketTagging operation.
func (c *S3) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketTaggingOutput{}
	req.Data = output
	return
}

// Deletes the tags from the bucket.
func (c *S3) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest generates a request for the DeleteBucketWebsite operation.
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) (req *request.Request, output *DeleteBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBucketWebsiteOutput{}
	req.Data = output
	return
}

// This operation removes the website configuration from the bucket.
func (c *S3) DeleteBucketWebsite(input *DeleteBucketWebsiteInput) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a request for the DeleteObject operation.
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteObjectOutput{}
	req.Data = output
	return
}

// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects.
func (c *S3) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest generates a request for the DeleteObjects operation.
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) (req *request.Request, output *DeleteObjectsOutput) {
	op := &request.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteObjectsOutput{}
	req.Data = output
	return
}

// This operation enables you to delete multiple objects from a bucket using
// a single HTTP request. You may specify up to 1000 keys.
func (c *S3) DeleteObjects(input *DeleteObjectsInput) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest generates a request for the GetBucketAcl operation.
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) (req *request.Request, output *GetBucketAclOutput) {
	op := &request.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketAclOutput{}
	req.Data = output
	return
}

// Gets the access control policy for the bucket.
func (c *S3) GetBucketAcl(input *GetBucketAclInput) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest generates a request for the GetBucketCors operation.
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) (req *request.Request, output *GetBucketCorsOutput) {
	op := &request.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketCorsOutput{}
	req.Data = output
	return
}

// Returns the cors configuration for the bucket.
func (c *S3) GetBucketCors(input *GetBucketCorsInput) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLifecycle = "GetBucketLifecycle"

// GetBucketLifecycleRequest generates a request for the GetBucketLifecycle operation.
func (c *S3) GetBucketLifecycleRequest(input *GetBucketLifecycleInput) (req *request.Request, output *GetBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycle,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLifecycleOutput{}
	req.Data = output
	return
}

// Deprecated, see the GetBucketLifecycleConfiguration operation.
func (c *S3) GetBucketLifecycle(input *GetBucketLifecycleInput) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a request for the GetBucketLifecycleConfiguration operation.
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLifecycleConfigurationOutput{}
	req.Data = output
	return
}

// Returns the lifecycle configuration information set on the bucket.
func (c *S3) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest generates a request for the GetBucketLocation operation.
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) (req *request.Request, output *GetBucketLocationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLocationOutput{}
	req.Data = output
	return
}

// Returns the region the bucket resides in.
func (c *S3) GetBucketLocation(input *GetBucketLocationInput) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest generates a request for the GetBucketLogging operation.
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) (req *request.Request, output *GetBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLoggingOutput{}
	req.Data = output
	return
}

// Returns the logging status of a bucket and the permissions users have to
// view and modify that status. To use GET, you must be the bucket owner.
func (c *S3) GetBucketLogging(input *GetBucketLoggingInput) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketNotification = "GetBucketNotification"

// GetBucketNotificationRequest generates a request for the GetBucketNotification operation.
func (c *S3) GetBucketNotificationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfigurationDeprecated) {
	op := &request.Operation{
		Name:       opGetBucketNotification,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	req = c.newRequest(op, input, output)
	output = &NotificationConfigurationDeprecated{}
	req.Data = output
	return
}

// Deprecated, see the GetBucketNotificationConfiguration operation.
func (c *S3) GetBucketNotification(input *GetBucketNotificationConfigurationRequest) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketNotificationConfiguration = "GetBucketNotificationConfiguration"

// GetBucketNotificationConfigurationRequest generates a request for the GetBucketNotificationConfiguration operation.
func (c *S3) GetBucketNotificationConfigurationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfiguration) {
	op := &request.Operation{
		Name:       opGetBucketNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	req = c.newRequest(op, input, output)
	output = &NotificationConfiguration{}
	req.Data = output
	return
}

// Returns the notification configuration of a bucket.
func (c *S3) GetBucketNotificationConfiguration(input *GetBucketNotificationConfigurationRequest) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a request for the GetBucketPolicy operation.
func (c *S3) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketPolicyOutput{}
	req.Data = output
	return
}

// Returns the policy of a specified bucket.
func (c *S3) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest generates a request for the GetBucketReplication operation.
func (c *S3) GetBucketReplicationRequest(input *GetBucketReplicationInput) (req *request.Request, output *GetBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketReplicationOutput{}
	req.Data = output
	return
}

func (c *S3) GetBucketReplication(input *GetBucketReplicationInput) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketRequestPayment = "GetBucketRequestPayment"

// GetBucketRequestPaymentRequest generates a request for the GetBucketRequestPayment operation.
func (c *S3) GetBucketRequestPaymentRequest(input *GetBucketRequestPaymentInput) (req *request.Request, output *GetBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opGetBucketRequestPayment,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &GetBucketRequestPaymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketRequestPaymentOutput{}
	req.Data = output
	return
}

// Returns the request payment configuration of a bucket.
func (c *S3) GetBucketRequestPayment(input *GetBucketRequestPaymentInput) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a request for the GetBucketTagging operation.
func (c *S3) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketTaggingOutput{}
	req.Data = output
	return
}

// Returns the tag set associated with the bucket.
func (c *S3) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a request for the GetBucketVersioning operation.
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketVersioningOutput{}
	req.Data = output
	return
}

// Returns the versioning state of a bucket.
func (c *S3) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest generates a request for the GetBucketWebsite operation.
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) (req *request.Request, output *GetBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketWebsiteOutput{}
	req.Data = output
	return
}

// Returns the website configuration for a bucket.
func (c *S3) GetBucketWebsite(input *GetBucketWebsiteInput) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opGetObject = "GetObject"

// GetObjectRequest generates a request for the GetObject operation.
func (c *S3) GetObjectRequest(input *GetObjectInput) (req *request.Request, output *GetObjectOutput) {
	op := &request.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectOutput{}
	req.Data = output
	return
}

// Retrieves objects from Amazon S3.
func (c *S3) GetObject(input *GetObjectInput) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	err := req.Send()
	return out, err
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest generates a request for the GetObjectAcl operation.
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) (req *request.Request, output *GetObjectAclOutput) {
	op := &request.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectAclOutput{}
	req.Data = output
	return
}

// Returns the access control list (ACL) of an object.
func (c *S3) GetObjectAcl(input *GetObjectAclInput) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	err := req.Send()
	return out, err
}

const opGetObjectTorrent = "GetObjectTorrent"

// GetObjectTorrentRequest generates a request for the GetObjectTorrent operation.
func (c *S3) GetObjectTorrentRequest(input *GetObjectTorrentInput) (req *request.Request, output *GetObjectTorrentOutput) {
	op := &request.Operation{
		Name:       opGetObjectTorrent,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?torrent",
	}

	if input == nil {
		input = &GetObjectTorrentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectTorrentOutput{}
	req.Data = output
	return
}

// Return torrent files from a bucket.
func (c *S3) GetObjectTorrent(input *GetObjectTorrentInput) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	err := req.Send()
	return out, err
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest generates a request for the HeadBucket operation.
func (c *S3) HeadBucketRequest(input *HeadBucketInput) (req *request.Request, output *HeadBucketOutput) {
	op := &request.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	req = c.newRequest(op, input, output)
	output = &HeadBucketOutput{}
	req.Data = output
	return
}

// This operation is useful to determine if a bucket exists and you have permission
// to access it.
func (c *S3) HeadBucket(input *HeadBucketInput) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	err := req.Send()
	return out, err
}

const opHeadObject = "HeadObject"

// HeadObjectRequest generates a request for the HeadObject operation.
func (c *S3) HeadObjectRequest(input *HeadObjectInput) (req *request.Request, output *HeadObjectOutput) {
	op := &request.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &HeadObjectOutput{}
	req.Data = output
	return
}

// The HEAD operation retrieves metadata from an object without returning the
// object itself. This operation is useful if you're only interested in an object's
// metadata. To use HEAD, you must have READ access to the object.
func (c *S3) HeadObject(input *HeadObjectInput) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	err := req.Send()
	return out, err
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest generates a request for the ListBuckets operation.
func (c *S3) ListBucketsRequest(input *ListBucketsInput) (req *request.Request, output *ListBucketsOutput) {
	op := &request.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBucketsOutput{}
	req.Data = output
	return
}

// Returns a list of all buckets owned by the authenticated sender of the request.
func (c *S3) ListBuckets(input *ListBucketsInput) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	err := req.Send()
	return out, err
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a request for the ListMultipartUploads operation.
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListMultipartUploadsOutput{}
	req.Data = output
	return
}

// This operation lists in-progress multipart uploads.
func (c *S3) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	err := req.Send()
	return out, err
}

func (c *S3) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(p *ListMultipartUploadsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMultipartUploadsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMultipartUploadsOutput), lastPage)
	})
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest generates a request for the ListObjectVersions operation.
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) (req *request.Request, output *ListObjectVersionsOutput) {
	op := &request.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListObjectVersionsOutput{}
	req.Data = output
	return
}

// Returns metadata about all of the versions of objects in a bucket.
func (c *S3) ListObjectVersions(input *ListObjectVersionsInput) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *S3) ListObjectVersionsPages(input *ListObjectVersionsInput, fn func(p *ListObjectVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListObjectVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListObjectVersionsOutput), lastPage)
	})
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a request for the ListObjects operation.
func (c *S3) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListObjectsOutput{}
	req.Data = output
	return
}

// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket.
func (c *S3) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	err := req.Send()
	return out, err
}

func (c *S3) ListObjectsPages(input *ListObjectsInput, fn func(p *ListObjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListObjectsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListObjectsOutput), lastPage)
	})
}

const opListParts = "ListParts"

// ListPartsRequest generates a request for the ListParts operation.
func (c *S3) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPartsOutput{}
	req.Data = output
	return
}

// Lists the parts that have been uploaded for a specific multipart upload.
func (c *S3) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	err := req.Send()
	return out, err
}

func (c *S3) ListPartsPages(input *ListPartsInput, fn func(p *ListPartsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPartsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPartsOutput), lastPage)
	})
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest generates a request for the PutBucketAcl operation.
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) (req *request.Request, output *PutBucketAclOutput) {
	op := &request.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketAclOutput{}
	req.Data = output
	return
}

// Sets the permissions on a bucket using access control lists (ACL).
func (c *S3) PutBucketAcl(input *PutBucketAclInput) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest generates a request for the PutBucketCors operation.
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) (req *request.Request, output *PutBucketCorsOutput) {
	op := &request.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketCorsOutput{}
	req.Data = output
	return
}

// Sets the cors configuration for a bucket.
func (c *S3) PutBucketCors(input *PutBucketCorsInput) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest generates a request for the PutBucketLifecycle operation.
func (c *S3) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) (req *request.Request, output *PutBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketLifecycleOutput{}
	req.Data = output
	return
}

// Deprecated, see the PutBucketLifecycleConfiguration operation.
func (c *S3) PutBucketLifecycle(input *PutBucketLifecycleInput) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a request for the PutBucketLifecycleConfiguration operation.
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketLifecycleConfigurationOutput{}
	req.Data = output
	return
}

// Sets lifecycle configuration for your bucket. If a lifecycle configuration
// exists, it replaces it.
func (c *S3) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest generates a request for the PutBucketLogging operation.
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) (req *request.Request, output *PutBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketLoggingOutput{}
	req.Data = output
	return
}

// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. To set the logging status of
// a bucket, you must be the bucket owner.
func (c *S3) PutBucketLogging(input *PutBucketLoggingInput) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketNotification = "PutBucketNotification"

// PutBucketNotificationRequest generates a request for the PutBucketNotification operation.
func (c *S3) PutBucketNotificationRequest(input *PutBucketNotificationInput) (req *request.Request, output *PutBucketNotificationOutput) {
	op := &request.Operation{
		Name:       opPutBucketNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketNotificationOutput{}
	req.Data = output
	return
}

// Deprecated, see the PutBucketNotificationConfiguraiton operation.
func (c *S3) PutBucketNotification(input *PutBucketNotificationInput) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest generates a request for the PutBucketNotificationConfiguration operation.
func (c *S3) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) (req *request.Request, output *PutBucketNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketNotificationConfigurationOutput{}
	req.Data = output
	return
}

// Enables notifications of specified events for a bucket.
func (c *S3) PutBucketNotificationConfiguration(input *PutBucketNotificationConfigurationInput) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a request for the PutBucketPolicy operation.
func (c *S3) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketPolicyOutput{}
	req.Data = output
	return
}

// Replaces a policy on a bucket. If the bucket already has a policy, the one
// in this request completely replaces it.
func (c *S3) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest generates a request for the PutBucketReplication operation.
func (c *S3) PutBucketReplicationRequest(input *PutBucketReplicationInput) (req *request.Request, output *PutBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketReplicationOutput{}
	req.Data = output
	return
}

// Creates a new replication configuration (or replaces an existing one, if
// present).
func (c *S3) PutBucketReplication(input *PutBucketReplicationInput) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketRequestPayment = "PutBucketRequestPayment"

// PutBucketRequestPaymentRequest generates a request for the PutBucketRequestPayment operation.
func (c *S3) PutBucketRequestPaymentRequest(input *PutBucketRequestPaymentInput) (req *request.Request, output *PutBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opPutBucketRequestPayment,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &PutBucketRequestPaymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketRequestPaymentOutput{}
	req.Data = output
	return
}

// Sets the request payment configuration for a bucket. By default, the bucket
// owner pays for downloads from the bucket. This configuration parameter enables
// the bucket owner (only) to specify that the person requesting the download
// will be charged for the download. Documentation on requester pays buckets
// can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
func (c *S3) PutBucketRequestPayment(input *PutBucketRequestPaymentInput) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a request for the PutBucketTagging operation.
func (c *S3) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketTaggingOutput{}
	req.Data = output
	return
}

// Sets the tags for a bucket.
func (c *S3) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a request for the PutBucketVersioning operation.
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketVersioningOutput{}
	req.Data = output
	return
}

// Sets the versioning state of an existing bucket. To set the versioning state,
// you must be the bucket owner.
func (c *S3) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest generates a request for the PutBucketWebsite operation.
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) (req *request.Request, output *PutBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutBucketWebsiteOutput{}
	req.Data = output
	return
}

// Set the website configuration for a bucket.
func (c *S3) PutBucketWebsite(input *PutBucketWebsiteInput) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opPutObject = "PutObject"

// PutObjectRequest generates a request for the PutObject operation.
func (c *S3) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutObjectOutput{}
	req.Data = output
	return
}

// Adds an object to a bucket.
func (c *S3) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	err := req.Send()
	return out, err
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest generates a request for the PutObjectAcl operation.
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) (req *request.Request, output *PutObjectAclOutput) {
	op := &request.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutObjectAclOutput{}
	req.Data = output
	return
}

// uses the acl subresource to set the access control list (ACL) permissions
// for an object that already exists in a bucket
func (c *S3) PutObjectAcl(input *PutObjectAclInput) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest generates a request for the RestoreObject operation.
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) (req *request.Request, output *RestoreObjectOutput) {
	op := &request.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreObjectOutput{}
	req.Data = output
	return
}

// Restores an archived copy of an object back into Amazon S3
func (c *S3) RestoreObject(input *RestoreObjectInput) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	err := req.Send()
	return out, err
}

const opUploadPart = "UploadPart"

// UploadPartRequest generates a request for the UploadPart operation.
func (c *S3) UploadPartRequest(input *UploadPartInput) (req *request.Request, output *UploadPartOutput) {
	op := &request.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadPartOutput{}
	req.Data = output
	return
}

// Uploads a part in a multipart upload.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
func (c *S3) UploadPart(input *UploadPartInput) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	err := req.Send()
	return out, err
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest generates a request for the UploadPartCopy operation.
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) (req *request.Request, output *UploadPartCopyOutput) {
	op := &request.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadPartCopyOutput{}
	req.Data = output
	return
}

// Uploads a part by copying data from an existing object as data source.
func (c *S3) UploadPartCopy(input *UploadPartCopyInput) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	err := req.Send()
	return out, err
}

type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLifecycleConfiguration) GoString() string {
	return s.String()
}

type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSConfiguration) GoString() string {
	return s.String()
}

type CORSRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a pre-flight OPTIONS request.
	AllowedHeaders []*string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// Identifies HTTP methods that the domain/origin specified in the rule is allowed
	// to execute.
	AllowedMethods []*string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	AllowedOrigins []*string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []*string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSRule) GoString() string {
	return s.String()
}

type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	CloudFunction *string `type:"string"`

	// Bucket event for which to send notifications.
	Event *string `type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFunctionConfiguration) GoString() string {
	return s.String()
}

type CommonPrefix struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonPrefix) GoString() string {
	return s.String()
}

type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure" payload:"MultipartUpload"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	Bucket *string `type:"string"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	Key *string `min:"1" type:"string"`

	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	Parts []*CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedPart) GoString() string {
	return s.String()
}

type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

type CopyObjectInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective *string `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"MetadataDirective"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectInput) GoString() string {
	return s.String()
}

type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	CopyObjectResult *CopyObjectResult `type:"structure"`

	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectResult) GoString() string {
	return s.String()
}

type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyPartResult) GoString() string {
	return s.String()
}

type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the region where the bucket will be created. If you don't specify
	// a region, the bucket will be created in US Standard.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

type CreateBucketInput struct {
	_ struct{} `type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

type CreateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

type Delete struct {
	_ struct{} `type:"structure"`

	Objects []*ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

type DeleteBucketCorsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

type DeleteBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

type DeleteBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

type DeleteObjectsInput struct {
	_ struct{} `type:"structure" payload:"Delete"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Delete *Delete `locationName:"Delete" type:"structure" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	Deleted []*DeletedObject `type:"list" flattened:"true"`

	Errors []*Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

type DeletedObject struct {
	_ struct{} `type:"structure"`

	DeleteMarker *bool `type:"boolean"`

	DeleteMarkerVersionId *string `type:"string"`

	Key *string `min:"1" type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletedObject) GoString() string {
	return s.String()
}

type Destination struct {
	_ struct{} `type:"structure"`

	// Amazon resource name (ARN) of the bucket where you want Amazon S3 to store
	// replicas of the object identified by the rule.
	Bucket *string `type:"string" required:"true"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

type Error struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Key *string `min:"1" type:"string"`

	Message *string `type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Container for key value pair that defines the criteria for the filter rule.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// Object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. Maximum prefix length can be up to 1,024 characters.
	// Overlapping prefixes and suffixes are not supported. For more information,
	// go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Name *string `type:"string" enum:"FilterRuleName"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterRule) GoString() string {
	return s.String()
}

type GetBucketAclInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

type GetBucketCorsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type GetBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleInput) GoString() string {
	return s.String()
}

type GetBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleOutput) GoString() string {
	return s.String()
}

type GetBucketLocationInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

type GetBucketLoggingInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

type GetBucketNotificationConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// Name of the buket to get the notification configuration for.
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketNotificationConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationConfigurationRequest) GoString() string {
	return s.String()
}

type GetBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The bucket policy as a JSON document.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

type GetBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

type GetBucketRequestPaymentInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentInput) GoString() string {
	return s.String()
}

type GetBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	Payer *string `type:"string" enum:"Payer"`
}

// String returns the string representation
func (s GetBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

type GetBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

type GetBucketVersioningInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

type GetBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

type GetObjectAclInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

type GetObjectInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInput) GoString() string {
	return s.String()
}

type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"integer"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectOutput) GoString() string {
	return s.String()
}

type GetObjectTorrentInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s GetObjectTorrentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentInput) GoString() string {
	return s.String()
}

type GetObjectTorrentOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadCloser `type:"blob"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectTorrentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentOutput) GoString() string {
	return s.String()
}

type Grant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	Type *string `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

type HeadBucketInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketInput) GoString() string {
	return s.String()
}

type HeadBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

type HeadObjectInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectInput) GoString() string {
	return s.String()
}

type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"integer"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s HeadObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectOutput) GoString() string {
	return s.String()
}

type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (e.g. if the suffix is index.html and you make a request to samplebucket/images/
	// the data that is returned will be for the object with the key name images/index.html)
	// The suffix must not be empty and must not include a slash character.
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocument) GoString() string {
	return s.String()
}

type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Initiator) GoString() string {
	return s.String()
}

// Container for object key name prefix and suffix filtering rules.
type KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for key value pair that defines the criteria for the
	// filter rule.
	FilterRules []*FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyFilter) GoString() string {
	return s.String()
}

// Container for specifying the AWS Lambda notification configuration.
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionConfiguration) GoString() string {
	return s.String()
}

type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

type LifecycleRule struct {
	_ struct{} `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	NoncurrentVersionTransitions []*NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transitions []*Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

type ListBucketsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsInput) GoString() string {
	return s.String()
}

type ListBucketsOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*Bucket `locationNameList:"Bucket" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s ListBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsOutput) GoString() string {
	return s.String()
}

type ListMultipartUploadsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Together with upload-id-marker, this parameter specifies the multipart upload
	// after which listing should begin.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of multipart uploads, from 1 to 1,000, to return
	// in the response body. 1,000 is the maximum number of uploads that can be
	// returned in a response.
	MaxUploads *int64 `location:"querystring" locationName:"max-uploads" type:"integer"`

	// Lists in-progress uploads only for those keys that begin with the specified
	// prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Together with key-marker, specifies the multipart upload after which listing
	// should begin. If key-marker is not specified, the upload-id-marker parameter
	// is ignored.
	UploadIdMarker *string `location:"querystring" locationName:"upload-id-marker" type:"string"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// Indicates whether the returned list of multipart uploads is truncated. A
	// value of true indicates that the list was truncated. The list can be truncated
	// if the number of multipart uploads exceeds the limit allowed or specified
	// by max uploads.
	IsTruncated *bool `type:"boolean"`

	// The key at or after which the listing began.
	KeyMarker *string `type:"string"`

	// Maximum number of multipart uploads that could have been included in the
	// response.
	MaxUploads *int64 `type:"integer"`

	// When a list is truncated, this element specifies the value that should be
	// used for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When a list is truncated, this element specifies the value that should be
	// used for the upload-id-marker request parameter in a subsequent request.
	NextUploadIdMarker *string `type:"string"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only keys starting with the specified prefix.
	Prefix *string `type:"string"`

	// Upload ID after which listing began.
	UploadIdMarker *string `type:"string"`

	Uploads []*MultipartUpload `locationName:"Upload" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

type ListObjectVersionsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Specifies the object version you want to start listing from.
	VersionIdMarker *string `location:"querystring" locationName:"version-id-marker" type:"string"`
}

// String returns the string representation
func (s ListObjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsInput) GoString() string {
	return s.String()
}

type ListObjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	DeleteMarkers []*DeleteMarkerEntry `locationName:"DeleteMarker" type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria. If your results were truncated, you can
	// make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker
	// response parameters as a starting place in another request to return the
	// rest of the results.
	IsTruncated *bool `type:"boolean"`

	// Marks the last Key returned in a truncated response.
	KeyMarker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// Use this value for the key marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// Use this value for the next version id marker parameter in a subsequent request.
	NextVersionIdMarker *string `type:"string"`

	Prefix *string `type:"string"`

	VersionIdMarker *string `type:"string"`

	Versions []*ObjectVersion `locationName:"Version" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListObjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsOutput) GoString() string {
	return s.String()
}

type ListObjectsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsInput) GoString() string {
	return s.String()
}

type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Contents []*Object `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	Marker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// When response is truncated (the IsTruncated element value in the response
	// is true), you can use the key name in this field as marker in the subsequent
	// request to get next set of objects. Amazon S3 lists objects in alphabetical
	// order Note: This element is returned only if you have delimiter request parameter
	// specified. If response does not include the NextMaker and it is truncated,
	// you can use the value of the last Key in the response as the marker in the
	// subsequent request to get the next set of object keys.
	NextMarker *string `type:"string"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

type ListPartsInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	Owner *Owner `type:"structure"`

	// Part number after which listing begins.
	PartNumberMarker *int64 `type:"integer"`

	Parts []*Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	TargetBucket *string `type:"string"`

	TargetGrants []*TargetGrant `locationNameList:"Grant" type:"list"`

	// This element lets you specify a prefix for the keys that the log files will
	// be stored under.
	TargetPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingEnabled) GoString() string {
	return s.String()
}

type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultipartUpload) GoString() string {
	return s.String()
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (/AmazonS3/latest/dev/s3-access-control.html) in the Amazon Simple Storage
	// Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
// versioning-enabled (or versioning is suspended), you can set this action
// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
// or GLACIER storage class at a specific period in the object's lifetime.
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (/AmazonS3/latest/dev/s3-access-control.html) in the Amazon Simple Storage
	// Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// Container for specifying the notification configuration of the bucket. If
// this element is empty, notifications are turned off on the bucket.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	LambdaFunctionConfigurations []*LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	QueueConfigurations []*QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	TopicConfigurations []*TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

type NotificationConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationDeprecated) GoString() string {
	return s.String()
}

// Container for object key name filtering rules. For information about key
// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon Simple Storage Service Developer Guide.
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// Container for object key name prefix and suffix filtering rules.
	Key *KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationFilter) GoString() string {
	return s.String()
}

type Object struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	Key *string `min:"1" type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectStorageClass"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Object) GoString() string {
	return s.String()
}

type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectIdentifier) GoString() string {
	return s.String()
}

type ObjectVersion struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectVersionStorageClass"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectVersion) GoString() string {
	return s.String()
}

type Owner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `type:"string"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Part) GoString() string {
	return s.String()
}

type PutBucketAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s PutBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclInput) GoString() string {
	return s.String()
}

type PutBucketAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclOutput) GoString() string {
	return s.String()
}

type PutBucketCorsInput struct {
	_ struct{} `type:"structure" payload:"CORSConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	CORSConfiguration *CORSConfiguration `locationName:"CORSConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsInput) GoString() string {
	return s.String()
}

type PutBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *BucketLifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleInput) GoString() string {
	return s.String()
}

type PutBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleOutput) GoString() string {
	return s.String()
}

type PutBucketLoggingInput struct {
	_ struct{} `type:"structure" payload:"BucketLoggingStatus"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingInput) GoString() string {
	return s.String()
}

type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingOutput) GoString() string {
	return s.String()
}

type PutBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for specifying the notification configuration of the bucket. If
	// this element is empty, notifications are turned off on the bucket.
	NotificationConfiguration *NotificationConfiguration `locationName:"NotificationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationInput) GoString() string {
	return s.String()
}

type PutBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketNotificationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	NotificationConfiguration *NotificationConfigurationDeprecated `locationName:"NotificationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationInput) GoString() string {
	return s.String()
}

type PutBucketNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationOutput) GoString() string {
	return s.String()
}

type PutBucketPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The bucket policy as a JSON document.
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketReplicationInput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `locationName:"ReplicationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationInput) GoString() string {
	return s.String()
}

type PutBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationOutput) GoString() string {
	return s.String()
}

type PutBucketRequestPaymentInput struct {
	_ struct{} `type:"structure" payload:"RequestPaymentConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	RequestPaymentConfiguration *RequestPaymentConfiguration `locationName:"RequestPaymentConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentInput) GoString() string {
	return s.String()
}

type PutBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

type PutBucketTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

type PutBucketVersioningInput struct {
	_ struct{} `type:"structure" payload:"VersioningConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

type PutBucketWebsiteInput struct {
	_ struct{} `type:"structure" payload:"WebsiteConfiguration"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteInput) GoString() string {
	return s.String()
}

type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteOutput) GoString() string {
	return s.String()
}

type PutObjectAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclInput) GoString() string {
	return s.String()
}

type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclOutput) GoString() string {
	return s.String()
}

type PutObjectInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"integer"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectInput) GoString() string {
	return s.String()
}

type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// Container for specifying an configuration when you want Amazon S3 to publish
// events to an Amazon Simple Queue Service (Amazon SQS) queue.
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SQS queue ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfiguration) GoString() string {
	return s.String()
}

type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfigurationDeprecated) GoString() string {
	return s.String()
}

type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the sibling is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Redirect) GoString() string {
	return s.String()
}

type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests will be redirected.
	HostName *string `type:"string" required:"true"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectAllRequestsTo) GoString() string {
	return s.String()
}

// Container for replication rules. You can add as many as 1,000 rules. Total
// replication configuration size can be up to 2 MB.
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating
	// the objects.
	Role *string `type:"string" required:"true"`

	// Container for information about a particular replication rule. Replication
	// configuration must have at least one rule and can contain up to 1,000 rules.
	Rules []*ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationConfiguration) GoString() string {
	return s.String()
}

type ReplicationRule struct {
	_ struct{} `type:"structure"`

	Destination *Destination `type:"structure" required:"true"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Object keyname prefix identifying one or more objects to which the rule applies.
	// Maximum prefix length can be up to 1,024 characters. Overlapping prefixes
	// are not supported.
	Prefix *string `type:"string" required:"true"`

	// The rule is ignored if status is not Enabled.
	Status *string `type:"string" required:"true" enum:"ReplicationRuleStatus"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRule) GoString() string {
	return s.String()
}

type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	Payer *string `type:"string" required:"true" enum:"Payer"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestPaymentConfiguration) GoString() string {
	return s.String()
}

type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectInput) GoString() string {
	return s.String()
}

type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectOutput) GoString() string {
	return s.String()
}

type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days
	Days *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreRequest) GoString() string {
	return s.String()
}

type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can can specify a different error code to return.
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingRule) GoString() string {
	return s.String()
}

type Rule struct {
	_ struct{} `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
	// versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
	// or GLACIER storage class at a specific period in the object's lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

type Tagging struct {
	_ struct{} `type:"structure"`

	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

type TargetGrant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission *string `type:"string" enum:"BucketLogsPermission"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGrant) GoString() string {
	return s.String()
}

// Container for specifying the configuration when you want Amazon S3 to publish
// events to an Amazon Simple Notification Service (Amazon SNS) topic.
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfiguration) GoString() string {
	return s.String()
}

type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfigurationDeprecated) GoString() string {
	return s.String()
}

type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

type UploadPartCopyInput struct {
	_ struct{} `type:"structure"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// The range of bytes to copy from the source object. The range value must use
	// the form bytes=first-last, where the first and last are the zero-based byte
	// offsets to copy. For example, bytes=0-9 indicates that you want to copy the
	// first ten bytes of the source. You can copy a range only if the source object
	// is greater than 5 GB.
	CopySourceRange *string `location:"header" locationName:"x-amz-copy-source-range" type:"string"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being copied. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being copied.
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyInput) GoString() string {
	return s.String()
}

type UploadPartCopyOutput struct {
	_ struct{} `type:"structure" payload:"CopyPartResult"`

	CopyPartResult *CopyPartResult `type:"structure"`

	// The version of the source object that was copied, if you have enabled versioning
	// on the source bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyOutput) GoString() string {
	return s.String()
}

type UploadPartInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadSeeker `type:"blob"`

	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"integer"`

	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being uploaded. This is a positive integer between 1
	// and 10,000.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being uploaded.
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartInput) GoString() string {
	return s.String()
}

type UploadPartOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartOutput) GoString() string {
	return s.String()
}

type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADelete"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersioningConfiguration) GoString() string {
	return s.String()
}

type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteConfiguration) GoString() string {
	return s.String()
}

const (
	// @enum BucketCannedACL
	BucketCannedACLPrivate = "private"
	// @enum BucketCannedACL
	BucketCannedACLPublicRead = "public-read"
	// @enum BucketCannedACL
	BucketCannedACLPublicReadWrite = "public-read-write"
	// @enum BucketCannedACL
	BucketCannedACLAuthenticatedRead = "authenticated-read"
)

const (
	// @enum BucketLocationConstraint
	BucketLocationConstraintEu = "EU"
	// @enum BucketLocationConstraint
	BucketLocationConstraintEuWest1 = "eu-west-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintUsWest1 = "us-west-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintUsWest2 = "us-west-2"
	// @enum BucketLocationConstraint
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"
	// @enum BucketLocationConstraint
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintSaEast1 = "sa-east-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintCnNorth1 = "cn-north-1"
	// @enum BucketLocationConstraint
	BucketLocationConstraintEuCentral1 = "eu-central-1"
)

const (
	// @enum BucketLogsPermission
	BucketLogsPermissionFullControl = "FULL_CONTROL"
	// @enum BucketLogsPermission
	BucketLogsPermissionRead = "READ"
	// @enum BucketLogsPermission
	BucketLogsPermissionWrite = "WRITE"
)

const (
	// @enum BucketVersioningStatus
	BucketVersioningStatusEnabled = "Enabled"
	// @enum BucketVersioningStatus
	BucketVersioningStatusSuspended = "Suspended"
)

// Requests Amazon S3 to encode the object keys in the response and specifies
// the encoding method to use. An object key may contain any Unicode character;
// however, XML 1.0 parser cannot parse some characters, such as characters
// with an ASCII value from 0 to 10. For characters that are not supported in
// XML 1.0, you can add this parameter to request that Amazon S3 encode the
// keys in the response.
const (
	// @enum EncodingType
	EncodingTypeUrl = "url"
)

// Bucket event for which to send notifications.
const (
	// @enum Event
	EventS3ReducedRedundancyLostObject = "s3:ReducedRedundancyLostObject"
	// @enum Event
	EventS3ObjectCreated = "s3:ObjectCreated:*"
	// @enum Event
	EventS3ObjectCreatedPut = "s3:ObjectCreated:Put"
	// @enum Event
	EventS3ObjectCreatedPost = "s3:ObjectCreated:Post"
	// @enum Event
	EventS3ObjectCreatedCopy = "s3:ObjectCreated:Copy"
	// @enum Event
	EventS3ObjectCreatedCompleteMultipartUpload = "s3:ObjectCreated:CompleteMultipartUpload"
	// @enum Event
	EventS3ObjectRemoved = "s3:ObjectRemoved:*"
	// @enum Event
	EventS3ObjectRemovedDelete = "s3:ObjectRemoved:Delete"
	// @enum Event
	EventS3ObjectRemovedDeleteMarkerCreated = "s3:ObjectRemoved:DeleteMarkerCreated"
)

const (
	// @enum ExpirationStatus
	ExpirationStatusEnabled = "Enabled"
	// @enum ExpirationStatus
	ExpirationStatusDisabled = "Disabled"
)

const (
	// @enum FilterRuleName
	FilterRuleNamePrefix = "prefix"
	// @enum FilterRuleName
	FilterRuleNameSuffix = "suffix"
)

const (
	// @enum MFADelete
	MFADeleteEnabled = "Enabled"
	// @enum MFADelete
	MFADeleteDisabled = "Disabled"
)

const (
	// @enum MFADeleteStatus
	MFADeleteStatusEnabled = "Enabled"
	// @enum MFADeleteStatus
	MFADeleteStatusDisabled = "Disabled"
)

const (
	// @enum MetadataDirective
	MetadataDirectiveCopy = "COPY"
	// @enum MetadataDirective
	MetadataDirectiveReplace = "REPLACE"
)

const (
	// @enum ObjectCannedACL
	ObjectCannedACLPrivate = "private"
	// @enum ObjectCannedACL
	ObjectCannedACLPublicRead = "public-read"
	// @enum ObjectCannedACL
	ObjectCannedACLPublicReadWrite = "public-read-write"
	// @enum ObjectCannedACL
	ObjectCannedACLAuthenticatedRead = "authenticated-read"
	// @enum ObjectCannedACL
	ObjectCannedACLAwsExecRead = "aws-exec-read"
	// @enum ObjectCannedACL
	ObjectCannedACLBucketOwnerRead = "bucket-owner-read"
	// @enum ObjectCannedACL
	ObjectCannedACLBucketOwnerFullControl = "bucket-owner-full-control"
)

const (
	// @enum ObjectStorageClass
	ObjectStorageClassStandard = "STANDARD"
	// @enum ObjectStorageClass
	ObjectStorageClassReducedRedundancy = "REDUCED_REDUNDANCY"
	// @enum ObjectStorageClass
	ObjectStorageClassGlacier = "GLACIER"
)

const (
	// @enum ObjectVersionStorageClass
	ObjectVersionStorageClassStandard = "STANDARD"
)

const (
	// @enum Payer
	PayerRequester = "Requester"
	// @enum Payer
	PayerBucketOwner = "BucketOwner"
)

const (
	// @enum Permission
	PermissionFullControl = "FULL_CONTROL"
	// @enum Permission
	PermissionWrite = "WRITE"
	// @enum Permission
	PermissionWriteAcp = "WRITE_ACP"
	// @enum Permission
	PermissionRead = "READ"
	// @enum Permission
	PermissionReadAcp = "READ_ACP"
)

const (
	// @enum Protocol
	ProtocolHttp = "http"
	// @enum Protocol
	ProtocolHttps = "https"
)

const (
	// @enum ReplicationRuleStatus
	ReplicationRuleStatusEnabled = "Enabled"
	// @enum ReplicationRuleStatus
	ReplicationRuleStatusDisabled = "Disabled"
)

const (
	// @enum ReplicationStatus
	ReplicationStatusComplete = "COMPLETE"
	// @enum ReplicationStatus
	ReplicationStatusPending = "PENDING"
	// @enum ReplicationStatus
	ReplicationStatusFailed = "FAILED"
	// @enum ReplicationStatus
	ReplicationStatusReplica = "REPLICA"
)

// If present, indicates that the requester was successfully charged for the
// request.
const (
	// @enum RequestCharged
	RequestChargedRequester = "requester"
)

// Confirms that the requester knows that she or he will be charged for the
// request. Bucket owners need not specify this parameter in their requests.
// Documentation on downloading objects from requester pays buckets can be found
// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
const (
	// @enum RequestPayer
	RequestPayerRequester = "requester"
)

const (
	// @enum ServerSideEncryption
	ServerSideEncryptionAes256 = "AES256"
	// @enum ServerSideEncryption
	ServerSideEncryptionAwsKms = "aws:kms"
)

const (
	// @enum StorageClass
	StorageClassStandard = "STANDARD"
	// @enum StorageClass
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"
	// @enum StorageClass
	StorageClassStandardIa = "STANDARD_IA"
)

const (
	// @enum TransitionStorageClass
	TransitionStorageClassGlacier = "GLACIER"
	// @enum TransitionStorageClass
	TransitionStorageClassStandardIa = "STANDARD_IA"
)

const (
	// @enum Type
	TypeCanonicalUser = "CanonicalUser"
	// @enum Type
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"
	// @enum Type
	TypeGroup = "Group"
)
