// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	api "github.com/openshift/origin/pkg/build/api"
	pkg_api "k8s.io/kubernetes/pkg/api"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
	time "time"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions,
		Convert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions,
		Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource,
		Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource,
		Convert_v1_Build_To_api_Build,
		Convert_api_Build_To_v1_Build,
		Convert_v1_BuildConfig_To_api_BuildConfig,
		Convert_api_BuildConfig_To_v1_BuildConfig,
		Convert_v1_BuildConfigList_To_api_BuildConfigList,
		Convert_api_BuildConfigList_To_v1_BuildConfigList,
		Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec,
		Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec,
		Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus,
		Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus,
		Convert_v1_BuildList_To_api_BuildList,
		Convert_api_BuildList_To_v1_BuildList,
		Convert_v1_BuildLog_To_api_BuildLog,
		Convert_api_BuildLog_To_v1_BuildLog,
		Convert_v1_BuildLogOptions_To_api_BuildLogOptions,
		Convert_api_BuildLogOptions_To_v1_BuildLogOptions,
		Convert_v1_BuildOutput_To_api_BuildOutput,
		Convert_api_BuildOutput_To_v1_BuildOutput,
		Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec,
		Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec,
		Convert_v1_BuildRequest_To_api_BuildRequest,
		Convert_api_BuildRequest_To_v1_BuildRequest,
		Convert_v1_BuildSource_To_api_BuildSource,
		Convert_api_BuildSource_To_v1_BuildSource,
		Convert_v1_BuildSpec_To_api_BuildSpec,
		Convert_api_BuildSpec_To_v1_BuildSpec,
		Convert_v1_BuildStatus_To_api_BuildStatus,
		Convert_api_BuildStatus_To_v1_BuildStatus,
		Convert_v1_BuildStatusOutput_To_api_BuildStatusOutput,
		Convert_api_BuildStatusOutput_To_v1_BuildStatusOutput,
		Convert_v1_BuildStatusOutputTo_To_api_BuildStatusOutputTo,
		Convert_api_BuildStatusOutputTo_To_v1_BuildStatusOutputTo,
		Convert_v1_BuildStrategy_To_api_BuildStrategy,
		Convert_api_BuildStrategy_To_v1_BuildStrategy,
		Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause,
		Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause,
		Convert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy,
		Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy,
		Convert_v1_CommonSpec_To_api_CommonSpec,
		Convert_api_CommonSpec_To_v1_CommonSpec,
		Convert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy,
		Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy,
		Convert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy,
		Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy,
		Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause,
		Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause,
		Convert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent,
		Convert_api_GenericWebHookEvent_To_v1_GenericWebHookEvent,
		Convert_v1_GitBuildSource_To_api_GitBuildSource,
		Convert_api_GitBuildSource_To_v1_GitBuildSource,
		Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause,
		Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause,
		Convert_v1_GitInfo_To_api_GitInfo,
		Convert_api_GitInfo_To_v1_GitInfo,
		Convert_v1_GitSourceRevision_To_api_GitSourceRevision,
		Convert_api_GitSourceRevision_To_v1_GitSourceRevision,
		Convert_v1_ImageChangeCause_To_api_ImageChangeCause,
		Convert_api_ImageChangeCause_To_v1_ImageChangeCause,
		Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger,
		Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger,
		Convert_v1_ImageLabel_To_api_ImageLabel,
		Convert_api_ImageLabel_To_v1_ImageLabel,
		Convert_v1_ImageSource_To_api_ImageSource,
		Convert_api_ImageSource_To_v1_ImageSource,
		Convert_v1_ImageSourcePath_To_api_ImageSourcePath,
		Convert_api_ImageSourcePath_To_v1_ImageSourcePath,
		Convert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy,
		Convert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy,
		Convert_v1_ProxyConfig_To_api_ProxyConfig,
		Convert_api_ProxyConfig_To_v1_ProxyConfig,
		Convert_v1_SecretBuildSource_To_api_SecretBuildSource,
		Convert_api_SecretBuildSource_To_v1_SecretBuildSource,
		Convert_v1_SecretSpec_To_api_SecretSpec,
		Convert_api_SecretSpec_To_v1_SecretSpec,
		Convert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy,
		Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy,
		Convert_v1_SourceControlUser_To_api_SourceControlUser,
		Convert_api_SourceControlUser_To_v1_SourceControlUser,
		Convert_v1_SourceRevision_To_api_SourceRevision,
		Convert_api_SourceRevision_To_v1_SourceRevision,
		Convert_v1_WebHookTrigger_To_api_WebHookTrigger,
		Convert_api_WebHookTrigger_To_v1_WebHookTrigger,
	)
}

func autoConvert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *api.BinaryBuildRequestOptions, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

func Convert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *api.BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildRequestOptions_To_api_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *api.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

func Convert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *api.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_api_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in *BinaryBuildSource, out *api.BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

func Convert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in *BinaryBuildSource, out *api.BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildSource_To_api_BinaryBuildSource(in, out, s)
}

func autoConvert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in *api.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

func Convert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in *api.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_api_BinaryBuildSource_To_v1_BinaryBuildSource(in, out, s)
}

func autoConvert_v1_Build_To_api_Build(in *Build, out *api.Build, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildSpec_To_api_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildStatus_To_api_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_Build_To_api_Build(in *Build, out *api.Build, s conversion.Scope) error {
	return autoConvert_v1_Build_To_api_Build(in, out, s)
}

func autoConvert_api_Build_To_v1_Build(in *api.Build, out *Build, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_BuildSpec_To_v1_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_BuildStatus_To_v1_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_Build_To_v1_Build(in *api.Build, out *Build, s conversion.Scope) error {
	return autoConvert_api_Build_To_v1_Build(in, out, s)
}

func autoConvert_v1_BuildConfig_To_api_BuildConfig(in *BuildConfig, out *api.BuildConfig, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_BuildConfig_To_v1_BuildConfig(in *api.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildConfig_To_v1_BuildConfig(in *api.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	return autoConvert_api_BuildConfig_To_v1_BuildConfig(in, out, s)
}

func autoConvert_v1_BuildConfigList_To_api_BuildConfigList(in *BuildConfigList, out *api.BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildConfig_To_api_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_BuildConfigList_To_api_BuildConfigList(in *BuildConfigList, out *api.BuildConfigList, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigList_To_api_BuildConfigList(in, out, s)
}

func autoConvert_api_BuildConfigList_To_v1_BuildConfigList(in *api.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_api_BuildConfig_To_v1_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_BuildConfigList_To_v1_BuildConfigList(in *api.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	return autoConvert_api_BuildConfigList_To_v1_BuildConfigList(in, out, s)
}

func autoConvert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in *BuildConfigSpec, out *api.BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]api.BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = api.BuildRunPolicy(in.RunPolicy)
	if err := Convert_v1_CommonSpec_To_api_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in *BuildConfigSpec, out *api.BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigSpec_To_api_BuildConfigSpec(in, out, s)
}

func autoConvert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in *api.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = BuildRunPolicy(in.RunPolicy)
	if err := Convert_api_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in *api.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_api_BuildConfigSpec_To_v1_BuildConfigSpec(in, out, s)
}

func autoConvert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in *BuildConfigStatus, out *api.BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

func Convert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in *BuildConfigStatus, out *api.BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigStatus_To_api_BuildConfigStatus(in, out, s)
}

func autoConvert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in *api.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

func Convert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in *api.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_api_BuildConfigStatus_To_v1_BuildConfigStatus(in, out, s)
}

func autoConvert_v1_BuildList_To_api_BuildList(in *BuildList, out *api.BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Build, len(*in))
		for i := range *in {
			if err := Convert_v1_Build_To_api_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_BuildList_To_api_BuildList(in *BuildList, out *api.BuildList, s conversion.Scope) error {
	return autoConvert_v1_BuildList_To_api_BuildList(in, out, s)
}

func autoConvert_api_BuildList_To_v1_BuildList(in *api.BuildList, out *BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Build, len(*in))
		for i := range *in {
			if err := Convert_api_Build_To_v1_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_BuildList_To_v1_BuildList(in *api.BuildList, out *BuildList, s conversion.Scope) error {
	return autoConvert_api_BuildList_To_v1_BuildList(in, out, s)
}

func autoConvert_v1_BuildLog_To_api_BuildLog(in *BuildLog, out *api.BuildLog, s conversion.Scope) error {
	return nil
}

func Convert_v1_BuildLog_To_api_BuildLog(in *BuildLog, out *api.BuildLog, s conversion.Scope) error {
	return autoConvert_v1_BuildLog_To_api_BuildLog(in, out, s)
}

func autoConvert_api_BuildLog_To_v1_BuildLog(in *api.BuildLog, out *BuildLog, s conversion.Scope) error {
	return nil
}

func Convert_api_BuildLog_To_v1_BuildLog(in *api.BuildLog, out *BuildLog, s conversion.Scope) error {
	return autoConvert_api_BuildLog_To_v1_BuildLog(in, out, s)
}

func autoConvert_v1_BuildLogOptions_To_api_BuildLogOptions(in *BuildLogOptions, out *api.BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*unversioned.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

func Convert_v1_BuildLogOptions_To_api_BuildLogOptions(in *BuildLogOptions, out *api.BuildLogOptions, s conversion.Scope) error {
	return autoConvert_v1_BuildLogOptions_To_api_BuildLogOptions(in, out, s)
}

func autoConvert_api_BuildLogOptions_To_v1_BuildLogOptions(in *api.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*unversioned.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

func Convert_api_BuildLogOptions_To_v1_BuildLogOptions(in *api.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	return autoConvert_api_BuildLogOptions_To_v1_BuildLogOptions(in, out, s)
}

func autoConvert_v1_BuildOutput_To_api_BuildOutput(in *BuildOutput, out *api.BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]api.ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

func autoConvert_api_BuildOutput_To_v1_BuildOutput(in *api.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

func Convert_api_BuildOutput_To_v1_BuildOutput(in *api.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	return autoConvert_api_BuildOutput_To_v1_BuildOutput(in, out, s)
}

func autoConvert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in *BuildPostCommitSpec, out *api.BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

func Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in *BuildPostCommitSpec, out *api.BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(in, out, s)
}

func autoConvert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *api.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

func Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *api.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in, out, s)
}

func autoConvert_v1_BuildRequest_To_api_BuildRequest(in *BuildRequest, out *api.BuildRequest, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*api.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]pkg_api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]api.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_v1_BuildRequest_To_api_BuildRequest(in *BuildRequest, out *api.BuildRequest, s conversion.Scope) error {
	return autoConvert_v1_BuildRequest_To_api_BuildRequest(in, out, s)
}

func autoConvert_api_BuildRequest_To_v1_BuildRequest(in *api.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_api_BuildRequest_To_v1_BuildRequest(in *api.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	return autoConvert_api_BuildRequest_To_v1_BuildRequest(in, out, s)
}

func autoConvert_v1_BuildSource_To_api_BuildSource(in *BuildSource, out *api.BuildSource, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Binary = (*api.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*api.GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]api.ImageSource, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSource_To_api_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]api.SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretBuildSource_To_api_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

func Convert_v1_BuildSource_To_api_BuildSource(in *BuildSource, out *api.BuildSource, s conversion.Scope) error {
	return autoConvert_v1_BuildSource_To_api_BuildSource(in, out, s)
}

func autoConvert_api_BuildSource_To_v1_BuildSource(in *api.BuildSource, out *BuildSource, s conversion.Scope) error {
	out.Binary = (*BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageSource, len(*in))
		for i := range *in {
			if err := Convert_api_ImageSource_To_v1_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_api_SecretBuildSource_To_v1_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

func autoConvert_v1_BuildSpec_To_api_BuildSpec(in *BuildSpec, out *api.BuildSpec, s conversion.Scope) error {
	if err := Convert_v1_CommonSpec_To_api_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]api.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_v1_BuildSpec_To_api_BuildSpec(in *BuildSpec, out *api.BuildSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildSpec_To_api_BuildSpec(in, out, s)
}

func autoConvert_api_BuildSpec_To_v1_BuildSpec(in *api.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	if err := Convert_api_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

func Convert_api_BuildSpec_To_v1_BuildSpec(in *api.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	return autoConvert_api_BuildSpec_To_v1_BuildSpec(in, out, s)
}

func autoConvert_v1_BuildStatus_To_api_BuildStatus(in *BuildStatus, out *api.BuildStatus, s conversion.Scope) error {
	out.Phase = api.BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = api.StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*unversioned.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*unversioned.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_v1_BuildStatusOutput_To_api_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_BuildStatus_To_api_BuildStatus(in *BuildStatus, out *api.BuildStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildStatus_To_api_BuildStatus(in, out, s)
}

func autoConvert_api_BuildStatus_To_v1_BuildStatus(in *api.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	out.Phase = BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*unversioned.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*unversioned.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_api_BuildStatusOutput_To_v1_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_BuildStatus_To_v1_BuildStatus(in *api.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	return autoConvert_api_BuildStatus_To_v1_BuildStatus(in, out, s)
}

func autoConvert_v1_BuildStatusOutput_To_api_BuildStatusOutput(in *BuildStatusOutput, out *api.BuildStatusOutput, s conversion.Scope) error {
	out.To = (*api.BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

func Convert_v1_BuildStatusOutput_To_api_BuildStatusOutput(in *BuildStatusOutput, out *api.BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutput_To_api_BuildStatusOutput(in, out, s)
}

func autoConvert_api_BuildStatusOutput_To_v1_BuildStatusOutput(in *api.BuildStatusOutput, out *BuildStatusOutput, s conversion.Scope) error {
	out.To = (*BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

func Convert_api_BuildStatusOutput_To_v1_BuildStatusOutput(in *api.BuildStatusOutput, out *BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_api_BuildStatusOutput_To_v1_BuildStatusOutput(in, out, s)
}

func autoConvert_v1_BuildStatusOutputTo_To_api_BuildStatusOutputTo(in *BuildStatusOutputTo, out *api.BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

func Convert_v1_BuildStatusOutputTo_To_api_BuildStatusOutputTo(in *BuildStatusOutputTo, out *api.BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutputTo_To_api_BuildStatusOutputTo(in, out, s)
}

func autoConvert_api_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *api.BuildStatusOutputTo, out *BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

func Convert_api_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *api.BuildStatusOutputTo, out *BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_api_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in, out, s)
}

func autoConvert_v1_BuildStrategy_To_api_BuildStrategy(in *BuildStrategy, out *api.BuildStrategy, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(api.DockerBuildStrategy)
		if err := Convert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(api.SourceBuildStrategy)
		if err := Convert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(api.CustomBuildStrategy)
		if err := Convert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	out.JenkinsPipelineStrategy = (*api.JenkinsPipelineBuildStrategy)(unsafe.Pointer(in.JenkinsPipelineStrategy))
	return nil
}

func Convert_v1_BuildStrategy_To_api_BuildStrategy(in *BuildStrategy, out *api.BuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_BuildStrategy_To_api_BuildStrategy(in, out, s)
}

func autoConvert_api_BuildStrategy_To_v1_BuildStrategy(in *api.BuildStrategy, out *BuildStrategy, s conversion.Scope) error {
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(DockerBuildStrategy)
		if err := Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(SourceBuildStrategy)
		if err := Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(CustomBuildStrategy)
		if err := Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	out.JenkinsPipelineStrategy = (*JenkinsPipelineBuildStrategy)(unsafe.Pointer(in.JenkinsPipelineStrategy))
	return nil
}

func autoConvert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in *BuildTriggerCause, out *api.BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(api.GenericWebHookCause)
		if err := Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(api.GitHubWebHookCause)
		if err := Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(api.ImageChangeCause)
		if err := Convert_v1_ImageChangeCause_To_api_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	return nil
}

func Convert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in *BuildTriggerCause, out *api.BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_v1_BuildTriggerCause_To_api_BuildTriggerCause(in, out, s)
}

func autoConvert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in *api.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(GenericWebHookCause)
		if err := Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(GitHubWebHookCause)
		if err := Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(ImageChangeCause)
		if err := Convert_api_ImageChangeCause_To_v1_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	return nil
}

func Convert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in *api.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_api_BuildTriggerCause_To_v1_BuildTriggerCause(in, out, s)
}

func autoConvert_v1_BuildTriggerPolicy_To_api_BuildTriggerPolicy(in *BuildTriggerPolicy, out *api.BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = api.BuildTriggerType(in.Type)
	out.GitHubWebHook = (*api.WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*api.WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(api.ImageChangeTrigger)
		if err := Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	return nil
}

func autoConvert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *api.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = BuildTriggerType(in.Type)
	out.GitHubWebHook = (*WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(ImageChangeTrigger)
		if err := Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	return nil
}

func Convert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *api.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	return autoConvert_api_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in, out, s)
}

func autoConvert_v1_CommonSpec_To_api_CommonSpec(in *CommonSpec, out *api.CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_v1_BuildSource_To_api_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_v1_BuildStrategy_To_api_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildOutput_To_api_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildPostCommitSpec_To_api_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

func Convert_v1_CommonSpec_To_api_CommonSpec(in *CommonSpec, out *api.CommonSpec, s conversion.Scope) error {
	return autoConvert_v1_CommonSpec_To_api_CommonSpec(in, out, s)
}

func autoConvert_api_CommonSpec_To_v1_CommonSpec(in *api.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_api_BuildSource_To_v1_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_api_BuildStrategy_To_v1_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_api_BuildOutput_To_v1_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_api_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*OptionalNodeSelector)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

func Convert_api_CommonSpec_To_v1_CommonSpec(in *api.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	return autoConvert_api_CommonSpec_To_v1_CommonSpec(in, out, s)
}

func autoConvert_v1_CustomBuildStrategy_To_api_CustomBuildStrategy(in *CustomBuildStrategy, out *api.CustomBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]pkg_api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]api.SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretSpec_To_api_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func autoConvert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *api.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_api_SecretSpec_To_v1_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func Convert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *api.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_CustomBuildStrategy_To_v1_CustomBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerBuildStrategy_To_api_DockerBuildStrategy(in *DockerBuildStrategy, out *api.DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]pkg_api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	return nil
}

func autoConvert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *api.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	return nil
}

func Convert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *api.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_DockerBuildStrategy_To_v1_DockerBuildStrategy(in, out, s)
}

func autoConvert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in *GenericWebHookCause, out *api.GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in *GenericWebHookCause, out *api.GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookCause_To_api_GenericWebHookCause(in, out, s)
}

func autoConvert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in *api.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in *api.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_api_GenericWebHookCause_To_v1_GenericWebHookCause(in, out, s)
}

func autoConvert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in *GenericWebHookEvent, out *api.GenericWebHookEvent, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(api.GitInfo)
		if err := Convert_v1_GitInfo_To_api_GitInfo(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]pkg_api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

func Convert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in *GenericWebHookEvent, out *api.GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookEvent_To_api_GenericWebHookEvent(in, out, s)
}

func autoConvert_api_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *api.GenericWebHookEvent, out *GenericWebHookEvent, s conversion.Scope) error {
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(GitInfo)
		if err := Convert_api_GitInfo_To_v1_GitInfo(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

func Convert_api_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *api.GenericWebHookEvent, out *GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_api_GenericWebHookEvent_To_v1_GenericWebHookEvent(in, out, s)
}

func autoConvert_v1_GitBuildSource_To_api_GitBuildSource(in *GitBuildSource, out *api.GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_v1_ProxyConfig_To_api_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_GitBuildSource_To_api_GitBuildSource(in *GitBuildSource, out *api.GitBuildSource, s conversion.Scope) error {
	return autoConvert_v1_GitBuildSource_To_api_GitBuildSource(in, out, s)
}

func autoConvert_api_GitBuildSource_To_v1_GitBuildSource(in *api.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_api_ProxyConfig_To_v1_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_GitBuildSource_To_v1_GitBuildSource(in *api.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	return autoConvert_api_GitBuildSource_To_v1_GitBuildSource(in, out, s)
}

func autoConvert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in *GitHubWebHookCause, out *api.GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(api.SourceRevision)
		if err := Convert_v1_SourceRevision_To_api_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in *GitHubWebHookCause, out *api.GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitHubWebHookCause_To_api_GitHubWebHookCause(in, out, s)
}

func autoConvert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *api.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_api_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

func Convert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *api.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_api_GitHubWebHookCause_To_v1_GitHubWebHookCause(in, out, s)
}

func autoConvert_v1_GitInfo_To_api_GitInfo(in *GitInfo, out *api.GitInfo, s conversion.Scope) error {
	if err := Convert_v1_GitBuildSource_To_api_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_v1_GitSourceRevision_To_api_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_GitInfo_To_api_GitInfo(in *GitInfo, out *api.GitInfo, s conversion.Scope) error {
	return autoConvert_v1_GitInfo_To_api_GitInfo(in, out, s)
}

func autoConvert_api_GitInfo_To_v1_GitInfo(in *api.GitInfo, out *GitInfo, s conversion.Scope) error {
	if err := Convert_api_GitBuildSource_To_v1_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_api_GitSourceRevision_To_v1_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	// INFO: in.Refs opted out of conversion generation
	return nil
}

func Convert_api_GitInfo_To_v1_GitInfo(in *api.GitInfo, out *GitInfo, s conversion.Scope) error {
	return autoConvert_api_GitInfo_To_v1_GitInfo(in, out, s)
}

func autoConvert_v1_GitSourceRevision_To_api_GitSourceRevision(in *GitSourceRevision, out *api.GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_v1_SourceControlUser_To_api_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_v1_SourceControlUser_To_api_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

func Convert_v1_GitSourceRevision_To_api_GitSourceRevision(in *GitSourceRevision, out *api.GitSourceRevision, s conversion.Scope) error {
	return autoConvert_v1_GitSourceRevision_To_api_GitSourceRevision(in, out, s)
}

func autoConvert_api_GitSourceRevision_To_v1_GitSourceRevision(in *api.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_api_SourceControlUser_To_v1_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_api_SourceControlUser_To_v1_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

func Convert_api_GitSourceRevision_To_v1_GitSourceRevision(in *api.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	return autoConvert_api_GitSourceRevision_To_v1_GitSourceRevision(in, out, s)
}

func autoConvert_v1_ImageChangeCause_To_api_ImageChangeCause(in *ImageChangeCause, out *api.ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

func Convert_v1_ImageChangeCause_To_api_ImageChangeCause(in *ImageChangeCause, out *api.ImageChangeCause, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeCause_To_api_ImageChangeCause(in, out, s)
}

func autoConvert_api_ImageChangeCause_To_v1_ImageChangeCause(in *api.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

func Convert_api_ImageChangeCause_To_v1_ImageChangeCause(in *api.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	return autoConvert_api_ImageChangeCause_To_v1_ImageChangeCause(in, out, s)
}

func autoConvert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in *ImageChangeTrigger, out *api.ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

func Convert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in *ImageChangeTrigger, out *api.ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeTrigger_To_api_ImageChangeTrigger(in, out, s)
}

func autoConvert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *api.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

func Convert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *api.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_api_ImageChangeTrigger_To_v1_ImageChangeTrigger(in, out, s)
}

func autoConvert_v1_ImageLabel_To_api_ImageLabel(in *ImageLabel, out *api.ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

func Convert_v1_ImageLabel_To_api_ImageLabel(in *ImageLabel, out *api.ImageLabel, s conversion.Scope) error {
	return autoConvert_v1_ImageLabel_To_api_ImageLabel(in, out, s)
}

func autoConvert_api_ImageLabel_To_v1_ImageLabel(in *api.ImageLabel, out *ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

func Convert_api_ImageLabel_To_v1_ImageLabel(in *api.ImageLabel, out *ImageLabel, s conversion.Scope) error {
	return autoConvert_api_ImageLabel_To_v1_ImageLabel(in, out, s)
}

func autoConvert_v1_ImageSource_To_api_ImageSource(in *ImageSource, out *api.ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.Paths = *(*[]api.ImageSourcePath)(unsafe.Pointer(&in.Paths))
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

func Convert_v1_ImageSource_To_api_ImageSource(in *ImageSource, out *api.ImageSource, s conversion.Scope) error {
	return autoConvert_v1_ImageSource_To_api_ImageSource(in, out, s)
}

func autoConvert_api_ImageSource_To_v1_ImageSource(in *api.ImageSource, out *ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.Paths = *(*[]ImageSourcePath)(unsafe.Pointer(&in.Paths))
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

func Convert_api_ImageSource_To_v1_ImageSource(in *api.ImageSource, out *ImageSource, s conversion.Scope) error {
	return autoConvert_api_ImageSource_To_v1_ImageSource(in, out, s)
}

func autoConvert_v1_ImageSourcePath_To_api_ImageSourcePath(in *ImageSourcePath, out *api.ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_v1_ImageSourcePath_To_api_ImageSourcePath(in *ImageSourcePath, out *api.ImageSourcePath, s conversion.Scope) error {
	return autoConvert_v1_ImageSourcePath_To_api_ImageSourcePath(in, out, s)
}

func autoConvert_api_ImageSourcePath_To_v1_ImageSourcePath(in *api.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_api_ImageSourcePath_To_v1_ImageSourcePath(in *api.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	return autoConvert_api_ImageSourcePath_To_v1_ImageSourcePath(in, out, s)
}

func autoConvert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *api.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	return nil
}

func Convert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *api.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_JenkinsPipelineBuildStrategy_To_api_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *api.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	return nil
}

func Convert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *api.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_v1_ProxyConfig_To_api_ProxyConfig(in *ProxyConfig, out *api.ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

func Convert_v1_ProxyConfig_To_api_ProxyConfig(in *ProxyConfig, out *api.ProxyConfig, s conversion.Scope) error {
	return autoConvert_v1_ProxyConfig_To_api_ProxyConfig(in, out, s)
}

func autoConvert_api_ProxyConfig_To_v1_ProxyConfig(in *api.ProxyConfig, out *ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

func Convert_api_ProxyConfig_To_v1_ProxyConfig(in *api.ProxyConfig, out *ProxyConfig, s conversion.Scope) error {
	return autoConvert_api_ProxyConfig_To_v1_ProxyConfig(in, out, s)
}

func autoConvert_v1_SecretBuildSource_To_api_SecretBuildSource(in *SecretBuildSource, out *api.SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_v1_SecretBuildSource_To_api_SecretBuildSource(in *SecretBuildSource, out *api.SecretBuildSource, s conversion.Scope) error {
	return autoConvert_v1_SecretBuildSource_To_api_SecretBuildSource(in, out, s)
}

func autoConvert_api_SecretBuildSource_To_v1_SecretBuildSource(in *api.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

func Convert_api_SecretBuildSource_To_v1_SecretBuildSource(in *api.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	return autoConvert_api_SecretBuildSource_To_v1_SecretBuildSource(in, out, s)
}

func autoConvert_v1_SecretSpec_To_api_SecretSpec(in *SecretSpec, out *api.SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

func Convert_v1_SecretSpec_To_api_SecretSpec(in *SecretSpec, out *api.SecretSpec, s conversion.Scope) error {
	return autoConvert_v1_SecretSpec_To_api_SecretSpec(in, out, s)
}

func autoConvert_api_SecretSpec_To_v1_SecretSpec(in *api.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

func Convert_api_SecretSpec_To_v1_SecretSpec(in *api.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	return autoConvert_api_SecretSpec_To_v1_SecretSpec(in, out, s)
}

func autoConvert_v1_SourceBuildStrategy_To_api_SourceBuildStrategy(in *SourceBuildStrategy, out *api.SourceBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]pkg_api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	out.RuntimeArtifacts = *(*[]api.ImageSourcePath)(unsafe.Pointer(&in.RuntimeArtifacts))
	return nil
}

func autoConvert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *api.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	out.RuntimeArtifacts = *(*[]ImageSourcePath)(unsafe.Pointer(&in.RuntimeArtifacts))
	return nil
}

func Convert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *api.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	return autoConvert_api_SourceBuildStrategy_To_v1_SourceBuildStrategy(in, out, s)
}

func autoConvert_v1_SourceControlUser_To_api_SourceControlUser(in *SourceControlUser, out *api.SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

func Convert_v1_SourceControlUser_To_api_SourceControlUser(in *SourceControlUser, out *api.SourceControlUser, s conversion.Scope) error {
	return autoConvert_v1_SourceControlUser_To_api_SourceControlUser(in, out, s)
}

func autoConvert_api_SourceControlUser_To_v1_SourceControlUser(in *api.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

func Convert_api_SourceControlUser_To_v1_SourceControlUser(in *api.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	return autoConvert_api_SourceControlUser_To_v1_SourceControlUser(in, out, s)
}

func autoConvert_v1_SourceRevision_To_api_SourceRevision(in *SourceRevision, out *api.SourceRevision, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Git = (*api.GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

func Convert_v1_SourceRevision_To_api_SourceRevision(in *SourceRevision, out *api.SourceRevision, s conversion.Scope) error {
	return autoConvert_v1_SourceRevision_To_api_SourceRevision(in, out, s)
}

func autoConvert_api_SourceRevision_To_v1_SourceRevision(in *api.SourceRevision, out *SourceRevision, s conversion.Scope) error {
	out.Git = (*GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

func autoConvert_v1_WebHookTrigger_To_api_WebHookTrigger(in *WebHookTrigger, out *api.WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

func Convert_v1_WebHookTrigger_To_api_WebHookTrigger(in *WebHookTrigger, out *api.WebHookTrigger, s conversion.Scope) error {
	return autoConvert_v1_WebHookTrigger_To_api_WebHookTrigger(in, out, s)
}

func autoConvert_api_WebHookTrigger_To_v1_WebHookTrigger(in *api.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

func Convert_api_WebHookTrigger_To_v1_WebHookTrigger(in *api.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	return autoConvert_api_WebHookTrigger_To_v1_WebHookTrigger(in, out, s)
}
