// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	api "github.com/openshift/origin/pkg/authorization/api"
	pkg_api "k8s.io/kubernetes/pkg/api"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_Action_To_api_Action,
		Convert_api_Action_To_v1_Action,
		Convert_v1_ClusterPolicy_To_api_ClusterPolicy,
		Convert_api_ClusterPolicy_To_v1_ClusterPolicy,
		Convert_v1_ClusterPolicyBinding_To_api_ClusterPolicyBinding,
		Convert_api_ClusterPolicyBinding_To_v1_ClusterPolicyBinding,
		Convert_v1_ClusterPolicyBindingList_To_api_ClusterPolicyBindingList,
		Convert_api_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList,
		Convert_v1_ClusterPolicyList_To_api_ClusterPolicyList,
		Convert_api_ClusterPolicyList_To_v1_ClusterPolicyList,
		Convert_v1_ClusterRole_To_api_ClusterRole,
		Convert_api_ClusterRole_To_v1_ClusterRole,
		Convert_v1_ClusterRoleBinding_To_api_ClusterRoleBinding,
		Convert_api_ClusterRoleBinding_To_v1_ClusterRoleBinding,
		Convert_v1_ClusterRoleBindingList_To_api_ClusterRoleBindingList,
		Convert_api_ClusterRoleBindingList_To_v1_ClusterRoleBindingList,
		Convert_v1_ClusterRoleList_To_api_ClusterRoleList,
		Convert_api_ClusterRoleList_To_v1_ClusterRoleList,
		Convert_v1_GroupRestriction_To_api_GroupRestriction,
		Convert_api_GroupRestriction_To_v1_GroupRestriction,
		Convert_v1_IsPersonalSubjectAccessReview_To_api_IsPersonalSubjectAccessReview,
		Convert_api_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview,
		Convert_v1_LocalResourceAccessReview_To_api_LocalResourceAccessReview,
		Convert_api_LocalResourceAccessReview_To_v1_LocalResourceAccessReview,
		Convert_v1_LocalSubjectAccessReview_To_api_LocalSubjectAccessReview,
		Convert_api_LocalSubjectAccessReview_To_v1_LocalSubjectAccessReview,
		Convert_v1_Policy_To_api_Policy,
		Convert_api_Policy_To_v1_Policy,
		Convert_v1_PolicyBinding_To_api_PolicyBinding,
		Convert_api_PolicyBinding_To_v1_PolicyBinding,
		Convert_v1_PolicyBindingList_To_api_PolicyBindingList,
		Convert_api_PolicyBindingList_To_v1_PolicyBindingList,
		Convert_v1_PolicyList_To_api_PolicyList,
		Convert_api_PolicyList_To_v1_PolicyList,
		Convert_v1_PolicyRule_To_api_PolicyRule,
		Convert_api_PolicyRule_To_v1_PolicyRule,
		Convert_v1_ResourceAccessReview_To_api_ResourceAccessReview,
		Convert_api_ResourceAccessReview_To_v1_ResourceAccessReview,
		Convert_v1_ResourceAccessReviewResponse_To_api_ResourceAccessReviewResponse,
		Convert_api_ResourceAccessReviewResponse_To_v1_ResourceAccessReviewResponse,
		Convert_v1_Role_To_api_Role,
		Convert_api_Role_To_v1_Role,
		Convert_v1_RoleBinding_To_api_RoleBinding,
		Convert_api_RoleBinding_To_v1_RoleBinding,
		Convert_v1_RoleBindingList_To_api_RoleBindingList,
		Convert_api_RoleBindingList_To_v1_RoleBindingList,
		Convert_v1_RoleBindingRestriction_To_api_RoleBindingRestriction,
		Convert_api_RoleBindingRestriction_To_v1_RoleBindingRestriction,
		Convert_v1_RoleBindingRestrictionList_To_api_RoleBindingRestrictionList,
		Convert_api_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList,
		Convert_v1_RoleBindingRestrictionSpec_To_api_RoleBindingRestrictionSpec,
		Convert_api_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec,
		Convert_v1_RoleList_To_api_RoleList,
		Convert_api_RoleList_To_v1_RoleList,
		Convert_v1_SelfSubjectRulesReview_To_api_SelfSubjectRulesReview,
		Convert_api_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview,
		Convert_v1_SelfSubjectRulesReviewSpec_To_api_SelfSubjectRulesReviewSpec,
		Convert_api_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec,
		Convert_v1_ServiceAccountReference_To_api_ServiceAccountReference,
		Convert_api_ServiceAccountReference_To_v1_ServiceAccountReference,
		Convert_v1_ServiceAccountRestriction_To_api_ServiceAccountRestriction,
		Convert_api_ServiceAccountRestriction_To_v1_ServiceAccountRestriction,
		Convert_v1_SubjectAccessReview_To_api_SubjectAccessReview,
		Convert_api_SubjectAccessReview_To_v1_SubjectAccessReview,
		Convert_v1_SubjectAccessReviewResponse_To_api_SubjectAccessReviewResponse,
		Convert_api_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse,
		Convert_v1_SubjectRulesReview_To_api_SubjectRulesReview,
		Convert_api_SubjectRulesReview_To_v1_SubjectRulesReview,
		Convert_v1_SubjectRulesReviewSpec_To_api_SubjectRulesReviewSpec,
		Convert_api_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec,
		Convert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus,
		Convert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus,
		Convert_v1_UserRestriction_To_api_UserRestriction,
		Convert_api_UserRestriction_To_v1_UserRestriction,
	)
}

func autoConvert_v1_Action_To_api_Action(in *Action, out *api.Action, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Verb = in.Verb
	out.Group = in.Group
	out.Version = in.Version
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.Content, &out.Content, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_Action_To_api_Action(in *Action, out *api.Action, s conversion.Scope) error {
	return autoConvert_v1_Action_To_api_Action(in, out, s)
}

func autoConvert_api_Action_To_v1_Action(in *api.Action, out *Action, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Verb = in.Verb
	out.Group = in.Group
	out.Version = in.Version
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.Content, &out.Content, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_Action_To_v1_Action(in *api.Action, out *Action, s conversion.Scope) error {
	return autoConvert_api_Action_To_v1_Action(in, out, s)
}

func autoConvert_v1_ClusterPolicy_To_api_ClusterPolicy(in *ClusterPolicy, out *api.ClusterPolicy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := Convert_v1_NamedClusterRoles_To_api_ClusterRolesByName(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_ClusterPolicy_To_v1_ClusterPolicy(in *api.ClusterPolicy, out *ClusterPolicy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := Convert_api_ClusterRolesByName_To_v1_NamedClusterRoles(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ClusterPolicy_To_v1_ClusterPolicy(in *api.ClusterPolicy, out *ClusterPolicy, s conversion.Scope) error {
	return autoConvert_api_ClusterPolicy_To_v1_ClusterPolicy(in, out, s)
}

func autoConvert_v1_ClusterPolicyBinding_To_api_ClusterPolicyBinding(in *ClusterPolicyBinding, out *api.ClusterPolicyBinding, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_v1_NamedClusterRoleBindings_To_api_ClusterRoleBindingsByName(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in *api.ClusterPolicyBinding, out *ClusterPolicyBinding, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_api_ClusterRoleBindingsByName_To_v1_NamedClusterRoleBindings(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in *api.ClusterPolicyBinding, out *ClusterPolicyBinding, s conversion.Scope) error {
	return autoConvert_api_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in, out, s)
}

func autoConvert_v1_ClusterPolicyBindingList_To_api_ClusterPolicyBindingList(in *ClusterPolicyBindingList, out *api.ClusterPolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ClusterPolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterPolicyBinding_To_api_ClusterPolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ClusterPolicyBindingList_To_api_ClusterPolicyBindingList(in *ClusterPolicyBindingList, out *api.ClusterPolicyBindingList, s conversion.Scope) error {
	return autoConvert_v1_ClusterPolicyBindingList_To_api_ClusterPolicyBindingList(in, out, s)
}

func autoConvert_api_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in *api.ClusterPolicyBindingList, out *ClusterPolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterPolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_api_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in *api.ClusterPolicyBindingList, out *ClusterPolicyBindingList, s conversion.Scope) error {
	return autoConvert_api_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in, out, s)
}

func autoConvert_v1_ClusterPolicyList_To_api_ClusterPolicyList(in *ClusterPolicyList, out *api.ClusterPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ClusterPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterPolicy_To_api_ClusterPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ClusterPolicyList_To_api_ClusterPolicyList(in *ClusterPolicyList, out *api.ClusterPolicyList, s conversion.Scope) error {
	return autoConvert_v1_ClusterPolicyList_To_api_ClusterPolicyList(in, out, s)
}

func autoConvert_api_ClusterPolicyList_To_v1_ClusterPolicyList(in *api.ClusterPolicyList, out *ClusterPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterPolicy, len(*in))
		for i := range *in {
			if err := Convert_api_ClusterPolicy_To_v1_ClusterPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ClusterPolicyList_To_v1_ClusterPolicyList(in *api.ClusterPolicyList, out *ClusterPolicyList, s conversion.Scope) error {
	return autoConvert_api_ClusterPolicyList_To_v1_ClusterPolicyList(in, out, s)
}

func autoConvert_v1_ClusterRole_To_api_ClusterRole(in *ClusterRole, out *api.ClusterRole, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]api.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_api_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

func Convert_v1_ClusterRole_To_api_ClusterRole(in *ClusterRole, out *api.ClusterRole, s conversion.Scope) error {
	return autoConvert_v1_ClusterRole_To_api_ClusterRole(in, out, s)
}

func autoConvert_api_ClusterRole_To_v1_ClusterRole(in *api.ClusterRole, out *ClusterRole, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_api_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

func Convert_api_ClusterRole_To_v1_ClusterRole(in *api.ClusterRole, out *ClusterRole, s conversion.Scope) error {
	return autoConvert_api_ClusterRole_To_v1_ClusterRole(in, out, s)
}

func autoConvert_v1_ClusterRoleBinding_To_api_ClusterRoleBinding(in *ClusterRoleBinding, out *api.ClusterRoleBinding, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	// INFO: in.UserNames opted out of conversion generation
	// INFO: in.GroupNames opted out of conversion generation
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]pkg_api.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_ClusterRoleBinding_To_v1_ClusterRoleBinding(in *api.ClusterRoleBinding, out *ClusterRoleBinding, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api_v1.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_ClusterRoleBindingList_To_api_ClusterRoleBindingList(in *ClusterRoleBindingList, out *api.ClusterRoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ClusterRoleBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterRoleBinding_To_api_ClusterRoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ClusterRoleBindingList_To_api_ClusterRoleBindingList(in *ClusterRoleBindingList, out *api.ClusterRoleBindingList, s conversion.Scope) error {
	return autoConvert_v1_ClusterRoleBindingList_To_api_ClusterRoleBindingList(in, out, s)
}

func autoConvert_api_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in *api.ClusterRoleBindingList, out *ClusterRoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterRoleBinding, len(*in))
		for i := range *in {
			if err := Convert_api_ClusterRoleBinding_To_v1_ClusterRoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in *api.ClusterRoleBindingList, out *ClusterRoleBindingList, s conversion.Scope) error {
	return autoConvert_api_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in, out, s)
}

func autoConvert_v1_ClusterRoleList_To_api_ClusterRoleList(in *ClusterRoleList, out *api.ClusterRoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ClusterRole, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterRole_To_api_ClusterRole(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ClusterRoleList_To_api_ClusterRoleList(in *ClusterRoleList, out *api.ClusterRoleList, s conversion.Scope) error {
	return autoConvert_v1_ClusterRoleList_To_api_ClusterRoleList(in, out, s)
}

func autoConvert_api_ClusterRoleList_To_v1_ClusterRoleList(in *api.ClusterRoleList, out *ClusterRoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterRole, len(*in))
		for i := range *in {
			if err := Convert_api_ClusterRole_To_v1_ClusterRole(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ClusterRoleList_To_v1_ClusterRoleList(in *api.ClusterRoleList, out *ClusterRoleList, s conversion.Scope) error {
	return autoConvert_api_ClusterRoleList_To_v1_ClusterRoleList(in, out, s)
}

func autoConvert_v1_GroupRestriction_To_api_GroupRestriction(in *GroupRestriction, out *api.GroupRestriction, s conversion.Scope) error {
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]unversioned.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

func Convert_v1_GroupRestriction_To_api_GroupRestriction(in *GroupRestriction, out *api.GroupRestriction, s conversion.Scope) error {
	return autoConvert_v1_GroupRestriction_To_api_GroupRestriction(in, out, s)
}

func autoConvert_api_GroupRestriction_To_v1_GroupRestriction(in *api.GroupRestriction, out *GroupRestriction, s conversion.Scope) error {
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]unversioned.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

func Convert_api_GroupRestriction_To_v1_GroupRestriction(in *api.GroupRestriction, out *GroupRestriction, s conversion.Scope) error {
	return autoConvert_api_GroupRestriction_To_v1_GroupRestriction(in, out, s)
}

func autoConvert_v1_IsPersonalSubjectAccessReview_To_api_IsPersonalSubjectAccessReview(in *IsPersonalSubjectAccessReview, out *api.IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return nil
}

func Convert_v1_IsPersonalSubjectAccessReview_To_api_IsPersonalSubjectAccessReview(in *IsPersonalSubjectAccessReview, out *api.IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return autoConvert_v1_IsPersonalSubjectAccessReview_To_api_IsPersonalSubjectAccessReview(in, out, s)
}

func autoConvert_api_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in *api.IsPersonalSubjectAccessReview, out *IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return nil
}

func Convert_api_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in *api.IsPersonalSubjectAccessReview, out *IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return autoConvert_api_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in, out, s)
}

func autoConvert_v1_LocalResourceAccessReview_To_api_LocalResourceAccessReview(in *LocalResourceAccessReview, out *api.LocalResourceAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_api_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_LocalResourceAccessReview_To_api_LocalResourceAccessReview(in *LocalResourceAccessReview, out *api.LocalResourceAccessReview, s conversion.Scope) error {
	return autoConvert_v1_LocalResourceAccessReview_To_api_LocalResourceAccessReview(in, out, s)
}

func autoConvert_api_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in *api.LocalResourceAccessReview, out *LocalResourceAccessReview, s conversion.Scope) error {
	if err := Convert_api_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in *api.LocalResourceAccessReview, out *LocalResourceAccessReview, s conversion.Scope) error {
	return autoConvert_api_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in, out, s)
}

func autoConvert_v1_LocalSubjectAccessReview_To_api_LocalSubjectAccessReview(in *LocalSubjectAccessReview, out *api.LocalSubjectAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_api_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.GroupsSlice opted out of conversion generation
	out.Scopes = *(*[]string)(unsafe.Pointer(&in.Scopes))
	return nil
}

func autoConvert_api_LocalSubjectAccessReview_To_v1_LocalSubjectAccessReview(in *api.LocalSubjectAccessReview, out *LocalSubjectAccessReview, s conversion.Scope) error {
	if err := Convert_api_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.Groups opted out of conversion generation
	out.Scopes = *(*OptionalScopes)(unsafe.Pointer(&in.Scopes))
	return nil
}

func autoConvert_v1_Policy_To_api_Policy(in *Policy, out *api.Policy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := Convert_v1_NamedRoles_To_api_RolesByName(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_Policy_To_v1_Policy(in *api.Policy, out *Policy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := Convert_api_RolesByName_To_v1_NamedRoles(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_Policy_To_v1_Policy(in *api.Policy, out *Policy, s conversion.Scope) error {
	return autoConvert_api_Policy_To_v1_Policy(in, out, s)
}

func autoConvert_v1_PolicyBinding_To_api_PolicyBinding(in *PolicyBinding, out *api.PolicyBinding, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_v1_NamedRoleBindings_To_api_RoleBindingsByName(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_PolicyBinding_To_v1_PolicyBinding(in *api.PolicyBinding, out *PolicyBinding, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.LastModified = in.LastModified
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_api_RoleBindingsByName_To_v1_NamedRoleBindings(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_PolicyBinding_To_v1_PolicyBinding(in *api.PolicyBinding, out *PolicyBinding, s conversion.Scope) error {
	return autoConvert_api_PolicyBinding_To_v1_PolicyBinding(in, out, s)
}

func autoConvert_v1_PolicyBindingList_To_api_PolicyBindingList(in *PolicyBindingList, out *api.PolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.PolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyBinding_To_api_PolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_PolicyBindingList_To_api_PolicyBindingList(in *PolicyBindingList, out *api.PolicyBindingList, s conversion.Scope) error {
	return autoConvert_v1_PolicyBindingList_To_api_PolicyBindingList(in, out, s)
}

func autoConvert_api_PolicyBindingList_To_v1_PolicyBindingList(in *api.PolicyBindingList, out *PolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_api_PolicyBinding_To_v1_PolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_PolicyBindingList_To_v1_PolicyBindingList(in *api.PolicyBindingList, out *PolicyBindingList, s conversion.Scope) error {
	return autoConvert_api_PolicyBindingList_To_v1_PolicyBindingList(in, out, s)
}

func autoConvert_v1_PolicyList_To_api_PolicyList(in *PolicyList, out *api.PolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Policy, len(*in))
		for i := range *in {
			if err := Convert_v1_Policy_To_api_Policy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_PolicyList_To_api_PolicyList(in *PolicyList, out *api.PolicyList, s conversion.Scope) error {
	return autoConvert_v1_PolicyList_To_api_PolicyList(in, out, s)
}

func autoConvert_api_PolicyList_To_v1_PolicyList(in *api.PolicyList, out *PolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Policy, len(*in))
		for i := range *in {
			if err := Convert_api_Policy_To_v1_Policy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_PolicyList_To_v1_PolicyList(in *api.PolicyList, out *PolicyList, s conversion.Scope) error {
	return autoConvert_api_PolicyList_To_v1_PolicyList(in, out, s)
}

func autoConvert_v1_PolicyRule_To_api_PolicyRule(in *PolicyRule, out *api.PolicyRule, s conversion.Scope) error {
	// WARNING: in.Verbs requires manual conversion: inconvertible types ([]string vs k8s.io/kubernetes/pkg/util/sets.String)
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.AttributeRestrictions, &out.AttributeRestrictions, s); err != nil {
		return err
	}
	out.APIGroups = *(*[]string)(unsafe.Pointer(&in.APIGroups))
	// WARNING: in.Resources requires manual conversion: inconvertible types ([]string vs k8s.io/kubernetes/pkg/util/sets.String)
	// WARNING: in.ResourceNames requires manual conversion: inconvertible types ([]string vs k8s.io/kubernetes/pkg/util/sets.String)
	// WARNING: in.NonResourceURLsSlice requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_api_PolicyRule_To_v1_PolicyRule(in *api.PolicyRule, out *PolicyRule, s conversion.Scope) error {
	// WARNING: in.Verbs requires manual conversion: inconvertible types (k8s.io/kubernetes/pkg/util/sets.String vs []string)
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.AttributeRestrictions, &out.AttributeRestrictions, s); err != nil {
		return err
	}
	out.APIGroups = *(*[]string)(unsafe.Pointer(&in.APIGroups))
	// WARNING: in.Resources requires manual conversion: inconvertible types (k8s.io/kubernetes/pkg/util/sets.String vs []string)
	// WARNING: in.ResourceNames requires manual conversion: inconvertible types (k8s.io/kubernetes/pkg/util/sets.String vs []string)
	// WARNING: in.NonResourceURLs requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1_ResourceAccessReview_To_api_ResourceAccessReview(in *ResourceAccessReview, out *api.ResourceAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_api_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_ResourceAccessReview_To_api_ResourceAccessReview(in *ResourceAccessReview, out *api.ResourceAccessReview, s conversion.Scope) error {
	return autoConvert_v1_ResourceAccessReview_To_api_ResourceAccessReview(in, out, s)
}

func autoConvert_api_ResourceAccessReview_To_v1_ResourceAccessReview(in *api.ResourceAccessReview, out *ResourceAccessReview, s conversion.Scope) error {
	if err := Convert_api_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ResourceAccessReview_To_v1_ResourceAccessReview(in *api.ResourceAccessReview, out *ResourceAccessReview, s conversion.Scope) error {
	return autoConvert_api_ResourceAccessReview_To_v1_ResourceAccessReview(in, out, s)
}

func autoConvert_v1_ResourceAccessReviewResponse_To_api_ResourceAccessReviewResponse(in *ResourceAccessReviewResponse, out *api.ResourceAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	// INFO: in.UsersSlice opted out of conversion generation
	// INFO: in.GroupsSlice opted out of conversion generation
	out.EvaluationError = in.EvaluationError
	return nil
}

func autoConvert_api_ResourceAccessReviewResponse_To_v1_ResourceAccessReviewResponse(in *api.ResourceAccessReviewResponse, out *ResourceAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	// INFO: in.Users opted out of conversion generation
	// INFO: in.Groups opted out of conversion generation
	out.EvaluationError = in.EvaluationError
	return nil
}

func autoConvert_v1_Role_To_api_Role(in *Role, out *api.Role, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]api.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_api_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

func Convert_v1_Role_To_api_Role(in *Role, out *api.Role, s conversion.Scope) error {
	return autoConvert_v1_Role_To_api_Role(in, out, s)
}

func autoConvert_api_Role_To_v1_Role(in *api.Role, out *Role, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_api_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

func Convert_api_Role_To_v1_Role(in *api.Role, out *Role, s conversion.Scope) error {
	return autoConvert_api_Role_To_v1_Role(in, out, s)
}

func autoConvert_v1_RoleBinding_To_api_RoleBinding(in *RoleBinding, out *api.RoleBinding, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	// INFO: in.UserNames opted out of conversion generation
	// INFO: in.GroupNames opted out of conversion generation
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]pkg_api.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_RoleBinding_To_v1_RoleBinding(in *api.RoleBinding, out *RoleBinding, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api_v1.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_RoleBindingList_To_api_RoleBindingList(in *RoleBindingList, out *api.RoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.RoleBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_RoleBinding_To_api_RoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_RoleBindingList_To_api_RoleBindingList(in *RoleBindingList, out *api.RoleBindingList, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingList_To_api_RoleBindingList(in, out, s)
}

func autoConvert_api_RoleBindingList_To_v1_RoleBindingList(in *api.RoleBindingList, out *RoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]RoleBinding, len(*in))
		for i := range *in {
			if err := Convert_api_RoleBinding_To_v1_RoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_RoleBindingList_To_v1_RoleBindingList(in *api.RoleBindingList, out *RoleBindingList, s conversion.Scope) error {
	return autoConvert_api_RoleBindingList_To_v1_RoleBindingList(in, out, s)
}

func autoConvert_v1_RoleBindingRestriction_To_api_RoleBindingRestriction(in *RoleBindingRestriction, out *api.RoleBindingRestriction, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_RoleBindingRestrictionSpec_To_api_RoleBindingRestrictionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_RoleBindingRestriction_To_api_RoleBindingRestriction(in *RoleBindingRestriction, out *api.RoleBindingRestriction, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestriction_To_api_RoleBindingRestriction(in, out, s)
}

func autoConvert_api_RoleBindingRestriction_To_v1_RoleBindingRestriction(in *api.RoleBindingRestriction, out *RoleBindingRestriction, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_RoleBindingRestriction_To_v1_RoleBindingRestriction(in *api.RoleBindingRestriction, out *RoleBindingRestriction, s conversion.Scope) error {
	return autoConvert_api_RoleBindingRestriction_To_v1_RoleBindingRestriction(in, out, s)
}

func autoConvert_v1_RoleBindingRestrictionList_To_api_RoleBindingRestrictionList(in *RoleBindingRestrictionList, out *api.RoleBindingRestrictionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.RoleBindingRestriction, len(*in))
		for i := range *in {
			if err := Convert_v1_RoleBindingRestriction_To_api_RoleBindingRestriction(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_RoleBindingRestrictionList_To_api_RoleBindingRestrictionList(in *RoleBindingRestrictionList, out *api.RoleBindingRestrictionList, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestrictionList_To_api_RoleBindingRestrictionList(in, out, s)
}

func autoConvert_api_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in *api.RoleBindingRestrictionList, out *RoleBindingRestrictionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]RoleBindingRestriction, len(*in))
		for i := range *in {
			if err := Convert_api_RoleBindingRestriction_To_v1_RoleBindingRestriction(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in *api.RoleBindingRestrictionList, out *RoleBindingRestrictionList, s conversion.Scope) error {
	return autoConvert_api_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in, out, s)
}

func autoConvert_v1_RoleBindingRestrictionSpec_To_api_RoleBindingRestrictionSpec(in *RoleBindingRestrictionSpec, out *api.RoleBindingRestrictionSpec, s conversion.Scope) error {
	out.UserRestriction = (*api.UserRestriction)(unsafe.Pointer(in.UserRestriction))
	out.GroupRestriction = (*api.GroupRestriction)(unsafe.Pointer(in.GroupRestriction))
	out.ServiceAccountRestriction = (*api.ServiceAccountRestriction)(unsafe.Pointer(in.ServiceAccountRestriction))
	return nil
}

func Convert_v1_RoleBindingRestrictionSpec_To_api_RoleBindingRestrictionSpec(in *RoleBindingRestrictionSpec, out *api.RoleBindingRestrictionSpec, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestrictionSpec_To_api_RoleBindingRestrictionSpec(in, out, s)
}

func autoConvert_api_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in *api.RoleBindingRestrictionSpec, out *RoleBindingRestrictionSpec, s conversion.Scope) error {
	out.UserRestriction = (*UserRestriction)(unsafe.Pointer(in.UserRestriction))
	out.GroupRestriction = (*GroupRestriction)(unsafe.Pointer(in.GroupRestriction))
	out.ServiceAccountRestriction = (*ServiceAccountRestriction)(unsafe.Pointer(in.ServiceAccountRestriction))
	return nil
}

func Convert_api_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in *api.RoleBindingRestrictionSpec, out *RoleBindingRestrictionSpec, s conversion.Scope) error {
	return autoConvert_api_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in, out, s)
}

func autoConvert_v1_RoleList_To_api_RoleList(in *RoleList, out *api.RoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Role, len(*in))
		for i := range *in {
			if err := Convert_v1_Role_To_api_Role(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_RoleList_To_api_RoleList(in *RoleList, out *api.RoleList, s conversion.Scope) error {
	return autoConvert_v1_RoleList_To_api_RoleList(in, out, s)
}

func autoConvert_api_RoleList_To_v1_RoleList(in *api.RoleList, out *RoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Role, len(*in))
		for i := range *in {
			if err := Convert_api_Role_To_v1_Role(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_RoleList_To_v1_RoleList(in *api.RoleList, out *RoleList, s conversion.Scope) error {
	return autoConvert_api_RoleList_To_v1_RoleList(in, out, s)
}

func autoConvert_v1_SelfSubjectRulesReview_To_api_SelfSubjectRulesReview(in *SelfSubjectRulesReview, out *api.SelfSubjectRulesReview, s conversion.Scope) error {
	if err := Convert_v1_SelfSubjectRulesReviewSpec_To_api_SelfSubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_SelfSubjectRulesReview_To_api_SelfSubjectRulesReview(in *SelfSubjectRulesReview, out *api.SelfSubjectRulesReview, s conversion.Scope) error {
	return autoConvert_v1_SelfSubjectRulesReview_To_api_SelfSubjectRulesReview(in, out, s)
}

func autoConvert_api_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in *api.SelfSubjectRulesReview, out *SelfSubjectRulesReview, s conversion.Scope) error {
	if err := Convert_api_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in *api.SelfSubjectRulesReview, out *SelfSubjectRulesReview, s conversion.Scope) error {
	return autoConvert_api_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in, out, s)
}

func autoConvert_v1_SelfSubjectRulesReviewSpec_To_api_SelfSubjectRulesReviewSpec(in *SelfSubjectRulesReviewSpec, out *api.SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	out.Scopes = *(*[]string)(unsafe.Pointer(&in.Scopes))
	return nil
}

func Convert_v1_SelfSubjectRulesReviewSpec_To_api_SelfSubjectRulesReviewSpec(in *SelfSubjectRulesReviewSpec, out *api.SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_v1_SelfSubjectRulesReviewSpec_To_api_SelfSubjectRulesReviewSpec(in, out, s)
}

func autoConvert_api_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(in *api.SelfSubjectRulesReviewSpec, out *SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	out.Scopes = *(*OptionalScopes)(unsafe.Pointer(&in.Scopes))
	return nil
}

func Convert_api_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(in *api.SelfSubjectRulesReviewSpec, out *SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_api_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(in, out, s)
}

func autoConvert_v1_ServiceAccountReference_To_api_ServiceAccountReference(in *ServiceAccountReference, out *api.ServiceAccountReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

func Convert_v1_ServiceAccountReference_To_api_ServiceAccountReference(in *ServiceAccountReference, out *api.ServiceAccountReference, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountReference_To_api_ServiceAccountReference(in, out, s)
}

func autoConvert_api_ServiceAccountReference_To_v1_ServiceAccountReference(in *api.ServiceAccountReference, out *ServiceAccountReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

func Convert_api_ServiceAccountReference_To_v1_ServiceAccountReference(in *api.ServiceAccountReference, out *ServiceAccountReference, s conversion.Scope) error {
	return autoConvert_api_ServiceAccountReference_To_v1_ServiceAccountReference(in, out, s)
}

func autoConvert_v1_ServiceAccountRestriction_To_api_ServiceAccountRestriction(in *ServiceAccountRestriction, out *api.ServiceAccountRestriction, s conversion.Scope) error {
	out.ServiceAccounts = *(*[]api.ServiceAccountReference)(unsafe.Pointer(&in.ServiceAccounts))
	out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	return nil
}

func Convert_v1_ServiceAccountRestriction_To_api_ServiceAccountRestriction(in *ServiceAccountRestriction, out *api.ServiceAccountRestriction, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountRestriction_To_api_ServiceAccountRestriction(in, out, s)
}

func autoConvert_api_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in *api.ServiceAccountRestriction, out *ServiceAccountRestriction, s conversion.Scope) error {
	out.ServiceAccounts = *(*[]ServiceAccountReference)(unsafe.Pointer(&in.ServiceAccounts))
	out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	return nil
}

func Convert_api_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in *api.ServiceAccountRestriction, out *ServiceAccountRestriction, s conversion.Scope) error {
	return autoConvert_api_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in, out, s)
}

func autoConvert_v1_SubjectAccessReview_To_api_SubjectAccessReview(in *SubjectAccessReview, out *api.SubjectAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_api_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.GroupsSlice opted out of conversion generation
	out.Scopes = *(*[]string)(unsafe.Pointer(&in.Scopes))
	return nil
}

func autoConvert_api_SubjectAccessReview_To_v1_SubjectAccessReview(in *api.SubjectAccessReview, out *SubjectAccessReview, s conversion.Scope) error {
	if err := Convert_api_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.Groups opted out of conversion generation
	out.Scopes = *(*OptionalScopes)(unsafe.Pointer(&in.Scopes))
	return nil
}

func autoConvert_v1_SubjectAccessReviewResponse_To_api_SubjectAccessReviewResponse(in *SubjectAccessReviewResponse, out *api.SubjectAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Allowed = in.Allowed
	out.Reason = in.Reason
	out.EvaluationError = in.EvaluationError
	return nil
}

func Convert_v1_SubjectAccessReviewResponse_To_api_SubjectAccessReviewResponse(in *SubjectAccessReviewResponse, out *api.SubjectAccessReviewResponse, s conversion.Scope) error {
	return autoConvert_v1_SubjectAccessReviewResponse_To_api_SubjectAccessReviewResponse(in, out, s)
}

func autoConvert_api_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in *api.SubjectAccessReviewResponse, out *SubjectAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Allowed = in.Allowed
	out.Reason = in.Reason
	out.EvaluationError = in.EvaluationError
	return nil
}

func Convert_api_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in *api.SubjectAccessReviewResponse, out *SubjectAccessReviewResponse, s conversion.Scope) error {
	return autoConvert_api_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in, out, s)
}

func autoConvert_v1_SubjectRulesReview_To_api_SubjectRulesReview(in *SubjectRulesReview, out *api.SubjectRulesReview, s conversion.Scope) error {
	if err := Convert_v1_SubjectRulesReviewSpec_To_api_SubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_SubjectRulesReview_To_api_SubjectRulesReview(in *SubjectRulesReview, out *api.SubjectRulesReview, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReview_To_api_SubjectRulesReview(in, out, s)
}

func autoConvert_api_SubjectRulesReview_To_v1_SubjectRulesReview(in *api.SubjectRulesReview, out *SubjectRulesReview, s conversion.Scope) error {
	if err := Convert_api_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_SubjectRulesReview_To_v1_SubjectRulesReview(in *api.SubjectRulesReview, out *SubjectRulesReview, s conversion.Scope) error {
	return autoConvert_api_SubjectRulesReview_To_v1_SubjectRulesReview(in, out, s)
}

func autoConvert_v1_SubjectRulesReviewSpec_To_api_SubjectRulesReviewSpec(in *SubjectRulesReviewSpec, out *api.SubjectRulesReviewSpec, s conversion.Scope) error {
	out.User = in.User
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Scopes = *(*[]string)(unsafe.Pointer(&in.Scopes))
	return nil
}

func Convert_v1_SubjectRulesReviewSpec_To_api_SubjectRulesReviewSpec(in *SubjectRulesReviewSpec, out *api.SubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReviewSpec_To_api_SubjectRulesReviewSpec(in, out, s)
}

func autoConvert_api_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in *api.SubjectRulesReviewSpec, out *SubjectRulesReviewSpec, s conversion.Scope) error {
	out.User = in.User
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Scopes = *(*OptionalScopes)(unsafe.Pointer(&in.Scopes))
	return nil
}

func Convert_api_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in *api.SubjectRulesReviewSpec, out *SubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_api_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in, out, s)
}

func autoConvert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus(in *SubjectRulesReviewStatus, out *api.SubjectRulesReviewStatus, s conversion.Scope) error {
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]api.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_api_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	out.EvaluationError = in.EvaluationError
	return nil
}

func Convert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus(in *SubjectRulesReviewStatus, out *api.SubjectRulesReviewStatus, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReviewStatus_To_api_SubjectRulesReviewStatus(in, out, s)
}

func autoConvert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in *api.SubjectRulesReviewStatus, out *SubjectRulesReviewStatus, s conversion.Scope) error {
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_api_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	out.EvaluationError = in.EvaluationError
	return nil
}

func Convert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in *api.SubjectRulesReviewStatus, out *SubjectRulesReviewStatus, s conversion.Scope) error {
	return autoConvert_api_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in, out, s)
}

func autoConvert_v1_UserRestriction_To_api_UserRestriction(in *UserRestriction, out *api.UserRestriction, s conversion.Scope) error {
	out.Users = *(*[]string)(unsafe.Pointer(&in.Users))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]unversioned.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

func Convert_v1_UserRestriction_To_api_UserRestriction(in *UserRestriction, out *api.UserRestriction, s conversion.Scope) error {
	return autoConvert_v1_UserRestriction_To_api_UserRestriction(in, out, s)
}

func autoConvert_api_UserRestriction_To_v1_UserRestriction(in *api.UserRestriction, out *UserRestriction, s conversion.Scope) error {
	out.Users = *(*[]string)(unsafe.Pointer(&in.Users))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]unversioned.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

func Convert_api_UserRestriction_To_v1_UserRestriction(in *api.UserRestriction, out *UserRestriction, s conversion.Scope) error {
	return autoConvert_api_UserRestriction_To_v1_UserRestriction(in, out, s)
}
