/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package extensions

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/kubernetes/pkg/api"
	pkg4_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	pkg6_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	pkg5_inf "speter.net/go/exp/math/dec/inf"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg4_resource.Quantity
		var v2 pkg1_unversioned.TypeMeta
		var v3 pkg3_types.UID
		var v4 pkg6_intstr.IntOrString
		var v5 pkg5_inf.Dec
		var v6 time.Time
		_, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [2]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = len(x.Selector) != 0
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(2)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym20 := z.DecBinary()
	_ = yym20
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct21 := r.ContainerType()
		if yyct21 == codecSelferValueTypeMap1234 {
			yyl21 := r.ReadMapStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl21, d)
			}
		} else if yyct21 == codecSelferValueTypeArray1234 {
			yyl21 := r.ReadArrayStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl21, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys22Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys22Slc
	var yyhl22 bool = l >= 0
	for yyj22 := 0; ; yyj22++ {
		if yyhl22 {
			if yyj22 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys22Slc = r.DecodeBytes(yys22Slc, true, true)
		yys22 := string(yys22Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys22 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv24 := &x.Selector
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else {
					z.F.DecMapStringStringX(yyv24, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys22)
		} // end switch yys22
	} // end for yyj22
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv28 := &x.Selector
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else {
			z.F.DecMapStringStringX(yyv28, false, d)
		}
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym30 := z.EncBinary()
		_ = yym30
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep31 := !z.EncBinary()
			yy2arr31 := z.EncBasicHandle().StructToArray
			var yyq31 [5]bool
			_, _, _ = yysep31, yyq31, yy2arr31
			const yyr31 bool = false
			yyq31[0] = x.Kind != ""
			yyq31[1] = x.APIVersion != ""
			yyq31[2] = true
			yyq31[3] = true
			yyq31[4] = true
			var yynn31 int
			if yyr31 || yy2arr31 {
				r.EncodeArrayStart(5)
			} else {
				yynn31 = 0
				for _, b := range yyq31 {
					if b {
						yynn31++
					}
				}
				r.EncodeMapStart(yynn31)
				yynn31 = 0
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[0] {
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[1] {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym37 := z.EncBinary()
					_ = yym37
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[2] {
					yy39 := &x.ObjectMeta
					yy39.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy40 := &x.ObjectMeta
					yy40.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[3] {
					yy42 := &x.Spec
					yy42.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.Spec
					yy43.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[4] {
					yy45 := &x.Status
					yy45.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy46 := &x.Status
					yy46.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym47 := z.DecBinary()
	_ = yym47
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct48 := r.ContainerType()
		if yyct48 == codecSelferValueTypeMap1234 {
			yyl48 := r.ReadMapStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl48, d)
			}
		} else if yyct48 == codecSelferValueTypeArray1234 {
			yyl48 := r.ReadArrayStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl48, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys49Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys49Slc
	var yyhl49 bool = l >= 0
	for yyj49 := 0; ; yyj49++ {
		if yyhl49 {
			if yyj49 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys49Slc = r.DecodeBytes(yys49Slc, true, true)
		yys49 := string(yys49Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys49 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv52 := &x.ObjectMeta
				yyv52.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv53 := &x.Spec
				yyv53.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv54 := &x.Status
				yyv54.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys49)
		} // end switch yys49
	} // end for yyj49
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj55 int
	var yyb55 bool
	var yyhl55 bool = l >= 0
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv58 := &x.ObjectMeta
		yyv58.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv59 := &x.Spec
		yyv59.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv60 := &x.Status
		yyv60.CodecDecodeSelf(d)
	}
	for {
		yyj55++
		if yyhl55 {
			yyb55 = yyj55 > l
		} else {
			yyb55 = r.CheckBreak()
		}
		if yyb55 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj55-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym61 := z.EncBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep62 := !z.EncBinary()
			yy2arr62 := z.EncBasicHandle().StructToArray
			var yyq62 [2]bool
			_, _, _ = yysep62, yyq62, yy2arr62
			const yyr62 bool = false
			yyq62[0] = x.Kind != ""
			yyq62[1] = x.APIVersion != ""
			var yynn62 int
			if yyr62 || yy2arr62 {
				r.EncodeArrayStart(2)
			} else {
				yynn62 = 0
				for _, b := range yyq62 {
					if b {
						yynn62++
					}
				}
				r.EncodeMapStart(yynn62)
				yynn62 = 0
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[0] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[1] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym69 := z.DecBinary()
	_ = yym69
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct70 := r.ContainerType()
		if yyct70 == codecSelferValueTypeMap1234 {
			yyl70 := r.ReadMapStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl70, d)
			}
		} else if yyct70 == codecSelferValueTypeArray1234 {
			yyl70 := r.ReadArrayStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl70, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys71Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys71Slc
	var yyhl71 bool = l >= 0
	for yyj71 := 0; ; yyj71++ {
		if yyhl71 {
			if yyj71 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys71Slc = r.DecodeBytes(yys71Slc, true, true)
		yys71 := string(yys71Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys71 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys71)
		} // end switch yys71
	} // end for yyj71
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj74 int
	var yyb74 bool
	var yyhl74 bool = l >= 0
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj74++
		if yyhl74 {
			yyb74 = yyj74 > l
		} else {
			yyb74 = r.CheckBreak()
		}
		if yyb74 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj74-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubresourceReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [4]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			yyq78[0] = x.Kind != ""
			yyq78[1] = x.Name != ""
			yyq78[2] = x.APIVersion != ""
			yyq78[3] = x.Subresource != ""
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(4)
			} else {
				yynn78 = 0
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[0] {
					yym80 := z.EncBinary()
					_ = yym80
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym81 := z.EncBinary()
					_ = yym81
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[1] {
					yym83 := z.EncBinary()
					_ = yym83
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym84 := z.EncBinary()
					_ = yym84
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[2] {
					yym86 := z.EncBinary()
					_ = yym86
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym87 := z.EncBinary()
					_ = yym87
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[3] {
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subresource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym90 := z.EncBinary()
					_ = yym90
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubresourceReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym91 := z.DecBinary()
	_ = yym91
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct92 := r.ContainerType()
		if yyct92 == codecSelferValueTypeMap1234 {
			yyl92 := r.ReadMapStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl92, d)
			}
		} else if yyct92 == codecSelferValueTypeArray1234 {
			yyl92 := r.ReadArrayStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl92, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubresourceReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys93Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys93Slc
	var yyhl93 bool = l >= 0
	for yyj93 := 0; ; yyj93++ {
		if yyhl93 {
			if yyj93 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys93Slc = r.DecodeBytes(yys93Slc, true, true)
		yys93 := string(yys93Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys93 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys93)
		} // end switch yys93
	} // end for yyj93
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubresourceReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj98 int
	var yyb98 bool
	var yyhl98 bool = l >= 0
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj98++
	if yyhl98 {
		yyb98 = yyj98 > l
	} else {
		yyb98 = r.CheckBreak()
	}
	if yyb98 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	for {
		yyj98++
		if yyhl98 {
			yyb98 = yyj98 > l
		} else {
			yyb98 = r.CheckBreak()
		}
		if yyb98 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj98-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CPUTargetUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym103 := z.EncBinary()
		_ = yym103
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep104 := !z.EncBinary()
			yy2arr104 := z.EncBasicHandle().StructToArray
			var yyq104 [1]bool
			_, _, _ = yysep104, yyq104, yy2arr104
			const yyr104 bool = false
			var yynn104 int
			if yyr104 || yy2arr104 {
				r.EncodeArrayStart(1)
			} else {
				yynn104 = 1
				for _, b := range yyq104 {
					if b {
						yynn104++
					}
				}
				r.EncodeMapStart(yynn104)
				yynn104 = 0
			}
			if yyr104 || yy2arr104 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym106 := z.EncBinary()
				_ = yym106
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPercentage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym107 := z.EncBinary()
				_ = yym107
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			}
			if yyr104 || yy2arr104 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CPUTargetUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym108 := z.DecBinary()
	_ = yym108
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct109 := r.ContainerType()
		if yyct109 == codecSelferValueTypeMap1234 {
			yyl109 := r.ReadMapStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl109, d)
			}
		} else if yyct109 == codecSelferValueTypeArray1234 {
			yyl109 := r.ReadArrayStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl109, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CPUTargetUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys110Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys110Slc
	var yyhl110 bool = l >= 0
	for yyj110 := 0; ; yyj110++ {
		if yyhl110 {
			if yyj110 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys110Slc = r.DecodeBytes(yys110Slc, true, true)
		yys110 := string(yys110Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys110 {
		case "targetPercentage":
			if r.TryDecodeAsNil() {
				x.TargetPercentage = 0
			} else {
				x.TargetPercentage = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys110)
		} // end switch yys110
	} // end for yyj110
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CPUTargetUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj112 int
	var yyb112 bool
	var yyhl112 bool = l >= 0
	yyj112++
	if yyhl112 {
		yyb112 = yyj112 > l
	} else {
		yyb112 = r.CheckBreak()
	}
	if yyb112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPercentage = 0
	} else {
		x.TargetPercentage = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj112++
		if yyhl112 {
			yyb112 = yyj112 > l
		} else {
			yyb112 = r.CheckBreak()
		}
		if yyb112 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj112-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym114 := z.EncBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep115 := !z.EncBinary()
			yy2arr115 := z.EncBasicHandle().StructToArray
			var yyq115 [4]bool
			_, _, _ = yysep115, yyq115, yy2arr115
			const yyr115 bool = false
			yyq115[1] = x.MinReplicas != nil
			yyq115[3] = x.CPUUtilization != nil
			var yynn115 int
			if yyr115 || yy2arr115 {
				r.EncodeArrayStart(4)
			} else {
				yynn115 = 2
				for _, b := range yyq115 {
					if b {
						yynn115++
					}
				}
				r.EncodeMapStart(yynn115)
				yynn115 = 0
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy117 := &x.ScaleRef
				yy117.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy118 := &x.ScaleRef
				yy118.CodecEncodeSelf(e)
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy120 := *x.MinReplicas
						yym121 := z.EncBinary()
						_ = yym121
						if false {
						} else {
							r.EncodeInt(int64(yy120))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy122 := *x.MinReplicas
						yym123 := z.EncBinary()
						_ = yym123
						if false {
						} else {
							r.EncodeInt(int64(yy122))
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym125 := z.EncBinary()
				_ = yym125
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[3] {
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cpuUtilization"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct129 := r.ContainerType()
		if yyct129 == codecSelferValueTypeMap1234 {
			yyl129 := r.ReadMapStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl129, d)
			}
		} else if yyct129 == codecSelferValueTypeArray1234 {
			yyl129 := r.ReadArrayStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl129, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys130Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys130Slc
	var yyhl130 bool = l >= 0
	for yyj130 := 0; ; yyj130++ {
		if yyhl130 {
			if yyj130 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys130Slc = r.DecodeBytes(yys130Slc, true, true)
		yys130 := string(yys130Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys130 {
		case "scaleRef":
			if r.TryDecodeAsNil() {
				x.ScaleRef = SubresourceReference{}
			} else {
				yyv131 := &x.ScaleRef
				yyv131.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int)
				}
				yym133 := z.DecBinary()
				_ = yym133
				if false {
				} else {
					*((*int)(x.MinReplicas)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "cpuUtilization":
			if r.TryDecodeAsNil() {
				if x.CPUUtilization != nil {
					x.CPUUtilization = nil
				}
			} else {
				if x.CPUUtilization == nil {
					x.CPUUtilization = new(CPUTargetUtilization)
				}
				x.CPUUtilization.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys130)
		} // end switch yys130
	} // end for yyj130
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj136 int
	var yyb136 bool
	var yyhl136 bool = l >= 0
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleRef = SubresourceReference{}
	} else {
		yyv137 := &x.ScaleRef
		yyv137.CodecDecodeSelf(d)
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int)
		}
		yym139 := z.DecBinary()
		_ = yym139
		if false {
		} else {
			*((*int)(x.MinReplicas)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj136++
	if yyhl136 {
		yyb136 = yyj136 > l
	} else {
		yyb136 = r.CheckBreak()
	}
	if yyb136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CPUUtilization != nil {
			x.CPUUtilization = nil
		}
	} else {
		if x.CPUUtilization == nil {
			x.CPUUtilization = new(CPUTargetUtilization)
		}
		x.CPUUtilization.CodecDecodeSelf(d)
	}
	for {
		yyj136++
		if yyhl136 {
			yyb136 = yyj136 > l
		} else {
			yyb136 = r.CheckBreak()
		}
		if yyb136 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj136-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym142 := z.EncBinary()
		_ = yym142
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep143 := !z.EncBinary()
			yy2arr143 := z.EncBasicHandle().StructToArray
			var yyq143 [5]bool
			_, _, _ = yysep143, yyq143, yy2arr143
			const yyr143 bool = false
			yyq143[0] = x.ObservedGeneration != nil
			yyq143[1] = x.LastScaleTime != nil
			yyq143[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn143 int
			if yyr143 || yy2arr143 {
				r.EncodeArrayStart(5)
			} else {
				yynn143 = 2
				for _, b := range yyq143 {
					if b {
						yynn143++
					}
				}
				r.EncodeMapStart(yynn143)
				yynn143 = 0
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy145 := *x.ObservedGeneration
						yym146 := z.EncBinary()
						_ = yym146
						if false {
						} else {
							r.EncodeInt(int64(yy145))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy147 := *x.ObservedGeneration
						yym148 := z.EncBinary()
						_ = yym148
						if false {
						} else {
							r.EncodeInt(int64(yy147))
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym150 := z.EncBinary()
						_ = yym150
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym150 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym150 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym151 := z.EncBinary()
						_ = yym151
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym151 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym151 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym153 := z.EncBinary()
				_ = yym153
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym154 := z.EncBinary()
				_ = yym154
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym157 := z.EncBinary()
				_ = yym157
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq143[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy159 := *x.CurrentCPUUtilizationPercentage
						yym160 := z.EncBinary()
						_ = yym160
						if false {
						} else {
							r.EncodeInt(int64(yy159))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq143[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy161 := *x.CurrentCPUUtilizationPercentage
						yym162 := z.EncBinary()
						_ = yym162
						if false {
						} else {
							r.EncodeInt(int64(yy161))
						}
					}
				}
			}
			if yyr143 || yy2arr143 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym163 := z.DecBinary()
	_ = yym163
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct164 := r.ContainerType()
		if yyct164 == codecSelferValueTypeMap1234 {
			yyl164 := r.ReadMapStart()
			if yyl164 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl164, d)
			}
		} else if yyct164 == codecSelferValueTypeArray1234 {
			yyl164 := r.ReadArrayStart()
			if yyl164 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl164, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys165Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys165Slc
	var yyhl165 bool = l >= 0
	for yyj165 := 0; ; yyj165++ {
		if yyhl165 {
			if yyj165 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys165Slc = r.DecodeBytes(yys165Slc, true, true)
		yys165 := string(yys165Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys165 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym167 := z.DecBinary()
				_ = yym167
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym169 := z.DecBinary()
				_ = yym169
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym169 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym169 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int)
				}
				yym173 := z.DecBinary()
				_ = yym173
				if false {
				} else {
					*((*int)(x.CurrentCPUUtilizationPercentage)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys165)
		} // end switch yys165
	} // end for yyj165
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj174 int
	var yyb174 bool
	var yyhl174 bool = l >= 0
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym176 := z.DecBinary()
		_ = yym176
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym178 := z.DecBinary()
		_ = yym178
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym178 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym178 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int)
		}
		yym182 := z.DecBinary()
		_ = yym182
		if false {
		} else {
			*((*int)(x.CurrentCPUUtilizationPercentage)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	for {
		yyj174++
		if yyhl174 {
			yyb174 = yyj174 > l
		} else {
			yyb174 = r.CheckBreak()
		}
		if yyb174 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj174-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym183 := z.EncBinary()
		_ = yym183
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep184 := !z.EncBinary()
			yy2arr184 := z.EncBasicHandle().StructToArray
			var yyq184 [5]bool
			_, _, _ = yysep184, yyq184, yy2arr184
			const yyr184 bool = false
			yyq184[0] = x.Kind != ""
			yyq184[1] = x.APIVersion != ""
			yyq184[2] = true
			yyq184[3] = true
			yyq184[4] = true
			var yynn184 int
			if yyr184 || yy2arr184 {
				r.EncodeArrayStart(5)
			} else {
				yynn184 = 0
				for _, b := range yyq184 {
					if b {
						yynn184++
					}
				}
				r.EncodeMapStart(yynn184)
				yynn184 = 0
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[0] {
					yym186 := z.EncBinary()
					_ = yym186
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq184[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym187 := z.EncBinary()
					_ = yym187
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[1] {
					yym189 := z.EncBinary()
					_ = yym189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq184[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym190 := z.EncBinary()
					_ = yym190
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[2] {
					yy192 := &x.ObjectMeta
					yy192.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy193 := &x.ObjectMeta
					yy193.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[3] {
					yy195 := &x.Spec
					yy195.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy196 := &x.Spec
					yy196.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq184[4] {
					yy198 := &x.Status
					yy198.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq184[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy199 := &x.Status
					yy199.CodecEncodeSelf(e)
				}
			}
			if yyr184 || yy2arr184 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym200 := z.DecBinary()
	_ = yym200
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct201 := r.ContainerType()
		if yyct201 == codecSelferValueTypeMap1234 {
			yyl201 := r.ReadMapStart()
			if yyl201 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl201, d)
			}
		} else if yyct201 == codecSelferValueTypeArray1234 {
			yyl201 := r.ReadArrayStart()
			if yyl201 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl201, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys202Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys202Slc
	var yyhl202 bool = l >= 0
	for yyj202 := 0; ; yyj202++ {
		if yyhl202 {
			if yyj202 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys202Slc = r.DecodeBytes(yys202Slc, true, true)
		yys202 := string(yys202Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys202 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv205 := &x.ObjectMeta
				yyv205.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv206 := &x.Spec
				yyv206.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv207 := &x.Status
				yyv207.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys202)
		} // end switch yys202
	} // end for yyj202
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj208 int
	var yyb208 bool
	var yyhl208 bool = l >= 0
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv211 := &x.ObjectMeta
		yyv211.CodecDecodeSelf(d)
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv212 := &x.Spec
		yyv212.CodecDecodeSelf(d)
	}
	yyj208++
	if yyhl208 {
		yyb208 = yyj208 > l
	} else {
		yyb208 = r.CheckBreak()
	}
	if yyb208 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv213 := &x.Status
		yyv213.CodecDecodeSelf(d)
	}
	for {
		yyj208++
		if yyhl208 {
			yyb208 = yyj208 > l
		} else {
			yyb208 = r.CheckBreak()
		}
		if yyb208 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj208-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym214 := z.EncBinary()
		_ = yym214
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep215 := !z.EncBinary()
			yy2arr215 := z.EncBasicHandle().StructToArray
			var yyq215 [4]bool
			_, _, _ = yysep215, yyq215, yy2arr215
			const yyr215 bool = false
			yyq215[0] = x.Kind != ""
			yyq215[1] = x.APIVersion != ""
			yyq215[2] = true
			var yynn215 int
			if yyr215 || yy2arr215 {
				r.EncodeArrayStart(4)
			} else {
				yynn215 = 1
				for _, b := range yyq215 {
					if b {
						yynn215++
					}
				}
				r.EncodeMapStart(yynn215)
				yynn215 = 0
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[0] {
					yym217 := z.EncBinary()
					_ = yym217
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq215[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym218 := z.EncBinary()
					_ = yym218
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[1] {
					yym220 := z.EncBinary()
					_ = yym220
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq215[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym221 := z.EncBinary()
					_ = yym221
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq215[2] {
					yy223 := &x.ListMeta
					yym224 := z.EncBinary()
					_ = yym224
					if false {
					} else if z.HasExtensions() && z.EncExt(yy223) {
					} else {
						z.EncFallback(yy223)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq215[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy225 := &x.ListMeta
					yym226 := z.EncBinary()
					_ = yym226
					if false {
					} else if z.HasExtensions() && z.EncExt(yy225) {
					} else {
						z.EncFallback(yy225)
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym228 := z.EncBinary()
					_ = yym228
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym229 := z.EncBinary()
					_ = yym229
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr215 || yy2arr215 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym230 := z.DecBinary()
	_ = yym230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct231 := r.ContainerType()
		if yyct231 == codecSelferValueTypeMap1234 {
			yyl231 := r.ReadMapStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl231, d)
			}
		} else if yyct231 == codecSelferValueTypeArray1234 {
			yyl231 := r.ReadArrayStart()
			if yyl231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys232Slc
	var yyhl232 bool = l >= 0
	for yyj232 := 0; ; yyj232++ {
		if yyhl232 {
			if yyj232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys232Slc = r.DecodeBytes(yys232Slc, true, true)
		yys232 := string(yys232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys232 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv235 := &x.ListMeta
				yym236 := z.DecBinary()
				_ = yym236
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv235) {
				} else {
					z.DecFallback(yyv235, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv237 := &x.Items
				yym238 := z.DecBinary()
				_ = yym238
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv237), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys232)
		} // end switch yys232
	} // end for yyj232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj239 int
	var yyb239 bool
	var yyhl239 bool = l >= 0
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv242 := &x.ListMeta
		yym243 := z.DecBinary()
		_ = yym243
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv242) {
		} else {
			z.DecFallback(yyv242, false)
		}
	}
	yyj239++
	if yyhl239 {
		yyb239 = yyj239 > l
	} else {
		yyb239 = r.CheckBreak()
	}
	if yyb239 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv244 := &x.Items
		yym245 := z.DecBinary()
		_ = yym245
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv244), d)
		}
	}
	for {
		yyj239++
		if yyhl239 {
			yyb239 = yyj239 > l
		} else {
			yyb239 = r.CheckBreak()
		}
		if yyb239 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj239-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym246 := z.EncBinary()
		_ = yym246
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep247 := !z.EncBinary()
			yy2arr247 := z.EncBasicHandle().StructToArray
			var yyq247 [5]bool
			_, _, _ = yysep247, yyq247, yy2arr247
			const yyr247 bool = false
			yyq247[0] = x.Kind != ""
			yyq247[1] = x.APIVersion != ""
			yyq247[2] = true
			yyq247[3] = x.Description != ""
			yyq247[4] = len(x.Versions) != 0
			var yynn247 int
			if yyr247 || yy2arr247 {
				r.EncodeArrayStart(5)
			} else {
				yynn247 = 0
				for _, b := range yyq247 {
					if b {
						yynn247++
					}
				}
				r.EncodeMapStart(yynn247)
				yynn247 = 0
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[0] {
					yym249 := z.EncBinary()
					_ = yym249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym250 := z.EncBinary()
					_ = yym250
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[1] {
					yym252 := z.EncBinary()
					_ = yym252
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym253 := z.EncBinary()
					_ = yym253
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[2] {
					yy255 := &x.ObjectMeta
					yy255.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq247[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy256 := &x.ObjectMeta
					yy256.CodecEncodeSelf(e)
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[3] {
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq247[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym259 := z.EncBinary()
					_ = yym259
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq247[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym261 := z.EncBinary()
						_ = yym261
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq247[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym262 := z.EncBinary()
						_ = yym262
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr247 || yy2arr247 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym263 := z.DecBinary()
	_ = yym263
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct264 := r.ContainerType()
		if yyct264 == codecSelferValueTypeMap1234 {
			yyl264 := r.ReadMapStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl264, d)
			}
		} else if yyct264 == codecSelferValueTypeArray1234 {
			yyl264 := r.ReadArrayStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl264, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys265Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys265Slc
	var yyhl265 bool = l >= 0
	for yyj265 := 0; ; yyj265++ {
		if yyhl265 {
			if yyj265 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys265Slc = r.DecodeBytes(yys265Slc, true, true)
		yys265 := string(yys265Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys265 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv268 := &x.ObjectMeta
				yyv268.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv270 := &x.Versions
				yym271 := z.DecBinary()
				_ = yym271
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv270), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys265)
		} // end switch yys265
	} // end for yyj265
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj272 int
	var yyb272 bool
	var yyhl272 bool = l >= 0
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv275 := &x.ObjectMeta
		yyv275.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv277 := &x.Versions
		yym278 := z.DecBinary()
		_ = yym278
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv277), d)
		}
	}
	for {
		yyj272++
		if yyhl272 {
			yyb272 = yyj272 > l
		} else {
			yyb272 = r.CheckBreak()
		}
		if yyb272 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj272-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym279 := z.EncBinary()
		_ = yym279
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep280 := !z.EncBinary()
			yy2arr280 := z.EncBasicHandle().StructToArray
			var yyq280 [4]bool
			_, _, _ = yysep280, yyq280, yy2arr280
			const yyr280 bool = false
			yyq280[0] = x.Kind != ""
			yyq280[1] = x.APIVersion != ""
			yyq280[2] = true
			var yynn280 int
			if yyr280 || yy2arr280 {
				r.EncodeArrayStart(4)
			} else {
				yynn280 = 1
				for _, b := range yyq280 {
					if b {
						yynn280++
					}
				}
				r.EncodeMapStart(yynn280)
				yynn280 = 0
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[0] {
					yym282 := z.EncBinary()
					_ = yym282
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq280[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym283 := z.EncBinary()
					_ = yym283
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[1] {
					yym285 := z.EncBinary()
					_ = yym285
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq280[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym286 := z.EncBinary()
					_ = yym286
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq280[2] {
					yy288 := &x.ListMeta
					yym289 := z.EncBinary()
					_ = yym289
					if false {
					} else if z.HasExtensions() && z.EncExt(yy288) {
					} else {
						z.EncFallback(yy288)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq280[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy290 := &x.ListMeta
					yym291 := z.EncBinary()
					_ = yym291
					if false {
					} else if z.HasExtensions() && z.EncExt(yy290) {
					} else {
						z.EncFallback(yy290)
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym293 := z.EncBinary()
					_ = yym293
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr280 || yy2arr280 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym295 := z.DecBinary()
	_ = yym295
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct296 := r.ContainerType()
		if yyct296 == codecSelferValueTypeMap1234 {
			yyl296 := r.ReadMapStart()
			if yyl296 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl296, d)
			}
		} else if yyct296 == codecSelferValueTypeArray1234 {
			yyl296 := r.ReadArrayStart()
			if yyl296 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl296, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys297Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys297Slc
	var yyhl297 bool = l >= 0
	for yyj297 := 0; ; yyj297++ {
		if yyhl297 {
			if yyj297 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys297Slc = r.DecodeBytes(yys297Slc, true, true)
		yys297 := string(yys297Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys297 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv300 := &x.ListMeta
				yym301 := z.DecBinary()
				_ = yym301
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv300) {
				} else {
					z.DecFallback(yyv300, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv302 := &x.Items
				yym303 := z.DecBinary()
				_ = yym303
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv302), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys297)
		} // end switch yys297
	} // end for yyj297
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj304 int
	var yyb304 bool
	var yyhl304 bool = l >= 0
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv307 := &x.ListMeta
		yym308 := z.DecBinary()
		_ = yym308
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv307) {
		} else {
			z.DecFallback(yyv307, false)
		}
	}
	yyj304++
	if yyhl304 {
		yyb304 = yyj304 > l
	} else {
		yyb304 = r.CheckBreak()
	}
	if yyb304 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv309 := &x.Items
		yym310 := z.DecBinary()
		_ = yym310
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv309), d)
		}
	}
	for {
		yyj304++
		if yyhl304 {
			yyb304 = yyj304 > l
		} else {
			yyb304 = r.CheckBreak()
		}
		if yyb304 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj304-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym311 := z.EncBinary()
		_ = yym311
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep312 := !z.EncBinary()
			yy2arr312 := z.EncBasicHandle().StructToArray
			var yyq312 [2]bool
			_, _, _ = yysep312, yyq312, yy2arr312
			const yyr312 bool = false
			yyq312[0] = x.Name != ""
			yyq312[1] = x.APIGroup != ""
			var yynn312 int
			if yyr312 || yy2arr312 {
				r.EncodeArrayStart(2)
			} else {
				yynn312 = 0
				for _, b := range yyq312 {
					if b {
						yynn312++
					}
				}
				r.EncodeMapStart(yynn312)
				yynn312 = 0
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq312[0] {
					yym314 := z.EncBinary()
					_ = yym314
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq312[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym315 := z.EncBinary()
					_ = yym315
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq312[1] {
					yym317 := z.EncBinary()
					_ = yym317
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq312[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym318 := z.EncBinary()
					_ = yym318
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
					}
				}
			}
			if yyr312 || yy2arr312 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym319 := z.DecBinary()
	_ = yym319
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct320 := r.ContainerType()
		if yyct320 == codecSelferValueTypeMap1234 {
			yyl320 := r.ReadMapStart()
			if yyl320 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl320, d)
			}
		} else if yyct320 == codecSelferValueTypeArray1234 {
			yyl320 := r.ReadArrayStart()
			if yyl320 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl320, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys321Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys321Slc
	var yyhl321 bool = l >= 0
	for yyj321 := 0; ; yyj321++ {
		if yyhl321 {
			if yyj321 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys321Slc = r.DecodeBytes(yys321Slc, true, true)
		yys321 := string(yys321Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys321 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiGroup":
			if r.TryDecodeAsNil() {
				x.APIGroup = ""
			} else {
				x.APIGroup = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys321)
		} // end switch yys321
	} // end for yyj321
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj324 int
	var yyb324 bool
	var yyhl324 bool = l >= 0
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIGroup = ""
	} else {
		x.APIGroup = string(r.DecodeString())
	}
	for {
		yyj324++
		if yyhl324 {
			yyb324 = yyj324 > l
		} else {
			yyb324 = r.CheckBreak()
		}
		if yyb324 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj324-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym327 := z.EncBinary()
		_ = yym327
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep328 := !z.EncBinary()
			yy2arr328 := z.EncBasicHandle().StructToArray
			var yyq328 [4]bool
			_, _, _ = yysep328, yyq328, yy2arr328
			const yyr328 bool = false
			yyq328[0] = x.Kind != ""
			yyq328[1] = x.APIVersion != ""
			yyq328[2] = true
			yyq328[3] = len(x.Data) != 0
			var yynn328 int
			if yyr328 || yy2arr328 {
				r.EncodeArrayStart(4)
			} else {
				yynn328 = 0
				for _, b := range yyq328 {
					if b {
						yynn328++
					}
				}
				r.EncodeMapStart(yynn328)
				yynn328 = 0
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[0] {
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq328[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[1] {
					yym333 := z.EncBinary()
					_ = yym333
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq328[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[2] {
					yy336 := &x.ObjectMeta
					yy336.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq328[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy337 := &x.ObjectMeta
					yy337.CodecEncodeSelf(e)
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq328[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym339 := z.EncBinary()
						_ = yym339
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq328[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym340 := z.EncBinary()
						_ = yym340
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr328 || yy2arr328 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym341 := z.DecBinary()
	_ = yym341
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct342 := r.ContainerType()
		if yyct342 == codecSelferValueTypeMap1234 {
			yyl342 := r.ReadMapStart()
			if yyl342 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl342, d)
			}
		} else if yyct342 == codecSelferValueTypeArray1234 {
			yyl342 := r.ReadArrayStart()
			if yyl342 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl342, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys343Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys343Slc
	var yyhl343 bool = l >= 0
	for yyj343 := 0; ; yyj343++ {
		if yyhl343 {
			if yyj343 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys343Slc = r.DecodeBytes(yys343Slc, true, true)
		yys343 := string(yys343Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys343 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv346 := &x.ObjectMeta
				yyv346.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv347 := &x.Data
				yym348 := z.DecBinary()
				_ = yym348
				if false {
				} else {
					*yyv347 = r.DecodeBytes(*(*[]byte)(yyv347), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys343)
		} // end switch yys343
	} // end for yyj343
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj349 int
	var yyb349 bool
	var yyhl349 bool = l >= 0
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv352 := &x.ObjectMeta
		yyv352.CodecDecodeSelf(d)
	}
	yyj349++
	if yyhl349 {
		yyb349 = yyj349 > l
	} else {
		yyb349 = r.CheckBreak()
	}
	if yyb349 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv353 := &x.Data
		yym354 := z.DecBinary()
		_ = yym354
		if false {
		} else {
			*yyv353 = r.DecodeBytes(*(*[]byte)(yyv353), false, false)
		}
	}
	for {
		yyj349++
		if yyhl349 {
			yyb349 = yyj349 > l
		} else {
			yyb349 = r.CheckBreak()
		}
		if yyb349 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj349-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym355 := z.EncBinary()
		_ = yym355
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep356 := !z.EncBinary()
			yy2arr356 := z.EncBasicHandle().StructToArray
			var yyq356 [5]bool
			_, _, _ = yysep356, yyq356, yy2arr356
			const yyr356 bool = false
			yyq356[0] = x.Kind != ""
			yyq356[1] = x.APIVersion != ""
			yyq356[2] = true
			yyq356[3] = true
			yyq356[4] = true
			var yynn356 int
			if yyr356 || yy2arr356 {
				r.EncodeArrayStart(5)
			} else {
				yynn356 = 0
				for _, b := range yyq356 {
					if b {
						yynn356++
					}
				}
				r.EncodeMapStart(yynn356)
				yynn356 = 0
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[0] {
					yym358 := z.EncBinary()
					_ = yym358
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq356[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym359 := z.EncBinary()
					_ = yym359
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[1] {
					yym361 := z.EncBinary()
					_ = yym361
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq356[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym362 := z.EncBinary()
					_ = yym362
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[2] {
					yy364 := &x.ObjectMeta
					yy364.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy365 := &x.ObjectMeta
					yy365.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[3] {
					yy367 := &x.Spec
					yy367.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy368 := &x.Spec
					yy368.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq356[4] {
					yy370 := &x.Status
					yy370.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq356[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy371 := &x.Status
					yy371.CodecEncodeSelf(e)
				}
			}
			if yyr356 || yy2arr356 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym372 := z.DecBinary()
	_ = yym372
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct373 := r.ContainerType()
		if yyct373 == codecSelferValueTypeMap1234 {
			yyl373 := r.ReadMapStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl373, d)
			}
		} else if yyct373 == codecSelferValueTypeArray1234 {
			yyl373 := r.ReadArrayStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl373, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys374Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys374Slc
	var yyhl374 bool = l >= 0
	for yyj374 := 0; ; yyj374++ {
		if yyhl374 {
			if yyj374 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys374Slc = r.DecodeBytes(yys374Slc, true, true)
		yys374 := string(yys374Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys374 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv377 := &x.ObjectMeta
				yyv377.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv378 := &x.Spec
				yyv378.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv379 := &x.Status
				yyv379.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys374)
		} // end switch yys374
	} // end for yyj374
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj380 int
	var yyb380 bool
	var yyhl380 bool = l >= 0
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv383 := &x.ObjectMeta
		yyv383.CodecDecodeSelf(d)
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv384 := &x.Spec
		yyv384.CodecDecodeSelf(d)
	}
	yyj380++
	if yyhl380 {
		yyb380 = yyj380 > l
	} else {
		yyb380 = r.CheckBreak()
	}
	if yyb380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv385 := &x.Status
		yyv385.CodecDecodeSelf(d)
	}
	for {
		yyj380++
		if yyhl380 {
			yyb380 = yyj380 > l
		} else {
			yyb380 = r.CheckBreak()
		}
		if yyb380 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj380-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym386 := z.EncBinary()
		_ = yym386
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep387 := !z.EncBinary()
			yy2arr387 := z.EncBasicHandle().StructToArray
			var yyq387 [5]bool
			_, _, _ = yysep387, yyq387, yy2arr387
			const yyr387 bool = false
			yyq387[0] = x.Replicas != 0
			yyq387[1] = len(x.Selector) != 0
			yyq387[3] = true
			yyq387[4] = x.UniqueLabelKey != ""
			var yynn387 int
			if yyr387 || yy2arr387 {
				r.EncodeArrayStart(5)
			} else {
				yynn387 = 1
				for _, b := range yyq387 {
					if b {
						yynn387++
					}
				}
				r.EncodeMapStart(yynn387)
				yynn387 = 0
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[0] {
					yym389 := z.EncBinary()
					_ = yym389
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq387[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym390 := z.EncBinary()
					_ = yym390
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym392 := z.EncBinary()
						_ = yym392
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym393 := z.EncBinary()
						_ = yym393
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy395 := &x.Template
				yy395.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy396 := &x.Template
				yy396.CodecEncodeSelf(e)
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[3] {
					yy398 := &x.Strategy
					yy398.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy399 := &x.Strategy
					yy399.CodecEncodeSelf(e)
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[4] {
					yym401 := z.EncBinary()
					_ = yym401
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UniqueLabelKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq387[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uniqueLabelKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym402 := z.EncBinary()
					_ = yym402
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UniqueLabelKey))
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym403 := z.DecBinary()
	_ = yym403
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct404 := r.ContainerType()
		if yyct404 == codecSelferValueTypeMap1234 {
			yyl404 := r.ReadMapStart()
			if yyl404 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl404, d)
			}
		} else if yyct404 == codecSelferValueTypeArray1234 {
			yyl404 := r.ReadArrayStart()
			if yyl404 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl404, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys405Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys405Slc
	var yyhl405 bool = l >= 0
	for yyj405 := 0; ; yyj405++ {
		if yyhl405 {
			if yyj405 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys405Slc = r.DecodeBytes(yys405Slc, true, true)
		yys405 := string(yys405Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys405 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv407 := &x.Selector
				yym408 := z.DecBinary()
				_ = yym408
				if false {
				} else {
					z.F.DecMapStringStringX(yyv407, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv409 := &x.Template
				yyv409.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv410 := &x.Strategy
				yyv410.CodecDecodeSelf(d)
			}
		case "uniqueLabelKey":
			if r.TryDecodeAsNil() {
				x.UniqueLabelKey = ""
			} else {
				x.UniqueLabelKey = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys405)
		} // end switch yys405
	} // end for yyj405
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj412 int
	var yyb412 bool
	var yyhl412 bool = l >= 0
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv414 := &x.Selector
		yym415 := z.DecBinary()
		_ = yym415
		if false {
		} else {
			z.F.DecMapStringStringX(yyv414, false, d)
		}
	}
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv416 := &x.Template
		yyv416.CodecDecodeSelf(d)
	}
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv417 := &x.Strategy
		yyv417.CodecDecodeSelf(d)
	}
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UniqueLabelKey = ""
	} else {
		x.UniqueLabelKey = string(r.DecodeString())
	}
	for {
		yyj412++
		if yyhl412 {
			yyb412 = yyj412 > l
		} else {
			yyb412 = r.CheckBreak()
		}
		if yyb412 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj412-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym419 := z.EncBinary()
		_ = yym419
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep420 := !z.EncBinary()
			yy2arr420 := z.EncBasicHandle().StructToArray
			var yyq420 [2]bool
			_, _, _ = yysep420, yyq420, yy2arr420
			const yyr420 bool = false
			yyq420[0] = x.Type != ""
			yyq420[1] = x.RollingUpdate != nil
			var yynn420 int
			if yyr420 || yy2arr420 {
				r.EncodeArrayStart(2)
			} else {
				yynn420 = 0
				for _, b := range yyq420 {
					if b {
						yynn420++
					}
				}
				r.EncodeMapStart(yynn420)
				yynn420 = 0
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq420[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq420[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym423 := z.DecBinary()
	_ = yym423
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct424 := r.ContainerType()
		if yyct424 == codecSelferValueTypeMap1234 {
			yyl424 := r.ReadMapStart()
			if yyl424 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl424, d)
			}
		} else if yyct424 == codecSelferValueTypeArray1234 {
			yyl424 := r.ReadArrayStart()
			if yyl424 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl424, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys425Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys425Slc
	var yyhl425 bool = l >= 0
	for yyj425 := 0; ; yyj425++ {
		if yyhl425 {
			if yyj425 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys425Slc = r.DecodeBytes(yys425Slc, true, true)
		yys425 := string(yys425Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys425 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys425)
		} // end switch yys425
	} // end for yyj425
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj428 int
	var yyb428 bool
	var yyhl428 bool = l >= 0
	yyj428++
	if yyhl428 {
		yyb428 = yyj428 > l
	} else {
		yyb428 = r.CheckBreak()
	}
	if yyb428 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj428++
	if yyhl428 {
		yyb428 = yyj428 > l
	} else {
		yyb428 = r.CheckBreak()
	}
	if yyb428 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj428++
		if yyhl428 {
			yyb428 = yyj428 > l
		} else {
			yyb428 = r.CheckBreak()
		}
		if yyb428 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj428-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym431 := z.EncBinary()
	_ = yym431
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym432 := z.DecBinary()
	_ = yym432
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym433 := z.EncBinary()
		_ = yym433
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep434 := !z.EncBinary()
			yy2arr434 := z.EncBasicHandle().StructToArray
			var yyq434 [3]bool
			_, _, _ = yysep434, yyq434, yy2arr434
			const yyr434 bool = false
			yyq434[0] = true
			yyq434[1] = true
			yyq434[2] = x.MinReadySeconds != 0
			var yynn434 int
			if yyr434 || yy2arr434 {
				r.EncodeArrayStart(3)
			} else {
				yynn434 = 0
				for _, b := range yyq434 {
					if b {
						yynn434++
					}
				}
				r.EncodeMapStart(yynn434)
				yynn434 = 0
			}
			if yyr434 || yy2arr434 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq434[0] {
					yy436 := &x.MaxUnavailable
					yym437 := z.EncBinary()
					_ = yym437
					if false {
					} else if z.HasExtensions() && z.EncExt(yy436) {
					} else if !yym437 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy436)
					} else {
						z.EncFallback(yy436)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq434[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy438 := &x.MaxUnavailable
					yym439 := z.EncBinary()
					_ = yym439
					if false {
					} else if z.HasExtensions() && z.EncExt(yy438) {
					} else if !yym439 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy438)
					} else {
						z.EncFallback(yy438)
					}
				}
			}
			if yyr434 || yy2arr434 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq434[1] {
					yy441 := &x.MaxSurge
					yym442 := z.EncBinary()
					_ = yym442
					if false {
					} else if z.HasExtensions() && z.EncExt(yy441) {
					} else if !yym442 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy441)
					} else {
						z.EncFallback(yy441)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq434[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy443 := &x.MaxSurge
					yym444 := z.EncBinary()
					_ = yym444
					if false {
					} else if z.HasExtensions() && z.EncExt(yy443) {
					} else if !yym444 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy443)
					} else {
						z.EncFallback(yy443)
					}
				}
			}
			if yyr434 || yy2arr434 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq434[2] {
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq434[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym447 := z.EncBinary()
					_ = yym447
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr434 || yy2arr434 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym448 := z.DecBinary()
	_ = yym448
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct449 := r.ContainerType()
		if yyct449 == codecSelferValueTypeMap1234 {
			yyl449 := r.ReadMapStart()
			if yyl449 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl449, d)
			}
		} else if yyct449 == codecSelferValueTypeArray1234 {
			yyl449 := r.ReadArrayStart()
			if yyl449 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl449, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys450Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys450Slc
	var yyhl450 bool = l >= 0
	for yyj450 := 0; ; yyj450++ {
		if yyhl450 {
			if yyj450 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys450Slc = r.DecodeBytes(yys450Slc, true, true)
		yys450 := string(yys450Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys450 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				x.MaxUnavailable = pkg6_intstr.IntOrString{}
			} else {
				yyv451 := &x.MaxUnavailable
				yym452 := z.DecBinary()
				_ = yym452
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv451) {
				} else if !yym452 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv451)
				} else {
					z.DecFallback(yyv451, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				x.MaxSurge = pkg6_intstr.IntOrString{}
			} else {
				yyv453 := &x.MaxSurge
				yym454 := z.DecBinary()
				_ = yym454
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv453) {
				} else if !yym454 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv453)
				} else {
					z.DecFallback(yyv453, false)
				}
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys450)
		} // end switch yys450
	} // end for yyj450
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj456 int
	var yyb456 bool
	var yyhl456 bool = l >= 0
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxUnavailable = pkg6_intstr.IntOrString{}
	} else {
		yyv457 := &x.MaxUnavailable
		yym458 := z.DecBinary()
		_ = yym458
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv457) {
		} else if !yym458 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv457)
		} else {
			z.DecFallback(yyv457, false)
		}
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxSurge = pkg6_intstr.IntOrString{}
	} else {
		yyv459 := &x.MaxSurge
		yym460 := z.DecBinary()
		_ = yym460
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv459) {
		} else if !yym460 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv459)
		} else {
			z.DecFallback(yyv459, false)
		}
	}
	yyj456++
	if yyhl456 {
		yyb456 = yyj456 > l
	} else {
		yyb456 = r.CheckBreak()
	}
	if yyb456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj456++
		if yyhl456 {
			yyb456 = yyj456 > l
		} else {
			yyb456 = r.CheckBreak()
		}
		if yyb456 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj456-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym462 := z.EncBinary()
		_ = yym462
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep463 := !z.EncBinary()
			yy2arr463 := z.EncBasicHandle().StructToArray
			var yyq463 [2]bool
			_, _, _ = yysep463, yyq463, yy2arr463
			const yyr463 bool = false
			yyq463[0] = x.Replicas != 0
			yyq463[1] = x.UpdatedReplicas != 0
			var yynn463 int
			if yyr463 || yy2arr463 {
				r.EncodeArrayStart(2)
			} else {
				yynn463 = 0
				for _, b := range yyq463 {
					if b {
						yynn463++
					}
				}
				r.EncodeMapStart(yynn463)
				yynn463 = 0
			}
			if yyr463 || yy2arr463 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq463[0] {
					yym465 := z.EncBinary()
					_ = yym465
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq463[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym466 := z.EncBinary()
					_ = yym466
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr463 || yy2arr463 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq463[1] {
					yym468 := z.EncBinary()
					_ = yym468
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq463[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr463 || yy2arr463 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym470 := z.DecBinary()
	_ = yym470
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct471 := r.ContainerType()
		if yyct471 == codecSelferValueTypeMap1234 {
			yyl471 := r.ReadMapStart()
			if yyl471 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl471, d)
			}
		} else if yyct471 == codecSelferValueTypeArray1234 {
			yyl471 := r.ReadArrayStart()
			if yyl471 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl471, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys472Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys472Slc
	var yyhl472 bool = l >= 0
	for yyj472 := 0; ; yyj472++ {
		if yyhl472 {
			if yyj472 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys472Slc = r.DecodeBytes(yys472Slc, true, true)
		yys472 := string(yys472Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys472 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys472)
		} // end switch yys472
	} // end for yyj472
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj475 int
	var yyb475 bool
	var yyhl475 bool = l >= 0
	yyj475++
	if yyhl475 {
		yyb475 = yyj475 > l
	} else {
		yyb475 = r.CheckBreak()
	}
	if yyb475 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj475++
	if yyhl475 {
		yyb475 = yyj475 > l
	} else {
		yyb475 = r.CheckBreak()
	}
	if yyb475 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj475++
		if yyhl475 {
			yyb475 = yyj475 > l
		} else {
			yyb475 = r.CheckBreak()
		}
		if yyb475 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj475-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym478 := z.EncBinary()
		_ = yym478
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep479 := !z.EncBinary()
			yy2arr479 := z.EncBasicHandle().StructToArray
			var yyq479 [4]bool
			_, _, _ = yysep479, yyq479, yy2arr479
			const yyr479 bool = false
			yyq479[0] = x.Kind != ""
			yyq479[1] = x.APIVersion != ""
			yyq479[2] = true
			var yynn479 int
			if yyr479 || yy2arr479 {
				r.EncodeArrayStart(4)
			} else {
				yynn479 = 1
				for _, b := range yyq479 {
					if b {
						yynn479++
					}
				}
				r.EncodeMapStart(yynn479)
				yynn479 = 0
			}
			if yyr479 || yy2arr479 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq479[0] {
					yym481 := z.EncBinary()
					_ = yym481
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq479[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym482 := z.EncBinary()
					_ = yym482
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr479 || yy2arr479 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq479[1] {
					yym484 := z.EncBinary()
					_ = yym484
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq479[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym485 := z.EncBinary()
					_ = yym485
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr479 || yy2arr479 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq479[2] {
					yy487 := &x.ListMeta
					yym488 := z.EncBinary()
					_ = yym488
					if false {
					} else if z.HasExtensions() && z.EncExt(yy487) {
					} else {
						z.EncFallback(yy487)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq479[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy489 := &x.ListMeta
					yym490 := z.EncBinary()
					_ = yym490
					if false {
					} else if z.HasExtensions() && z.EncExt(yy489) {
					} else {
						z.EncFallback(yy489)
					}
				}
			}
			if yyr479 || yy2arr479 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym492 := z.EncBinary()
					_ = yym492
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym493 := z.EncBinary()
					_ = yym493
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr479 || yy2arr479 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym494 := z.DecBinary()
	_ = yym494
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct495 := r.ContainerType()
		if yyct495 == codecSelferValueTypeMap1234 {
			yyl495 := r.ReadMapStart()
			if yyl495 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl495, d)
			}
		} else if yyct495 == codecSelferValueTypeArray1234 {
			yyl495 := r.ReadArrayStart()
			if yyl495 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl495, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys496Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys496Slc
	var yyhl496 bool = l >= 0
	for yyj496 := 0; ; yyj496++ {
		if yyhl496 {
			if yyj496 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys496Slc = r.DecodeBytes(yys496Slc, true, true)
		yys496 := string(yys496Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys496 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv499 := &x.ListMeta
				yym500 := z.DecBinary()
				_ = yym500
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv499) {
				} else {
					z.DecFallback(yyv499, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv501 := &x.Items
				yym502 := z.DecBinary()
				_ = yym502
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv501), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys496)
		} // end switch yys496
	} // end for yyj496
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj503 int
	var yyb503 bool
	var yyhl503 bool = l >= 0
	yyj503++
	if yyhl503 {
		yyb503 = yyj503 > l
	} else {
		yyb503 = r.CheckBreak()
	}
	if yyb503 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj503++
	if yyhl503 {
		yyb503 = yyj503 > l
	} else {
		yyb503 = r.CheckBreak()
	}
	if yyb503 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj503++
	if yyhl503 {
		yyb503 = yyj503 > l
	} else {
		yyb503 = r.CheckBreak()
	}
	if yyb503 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv506 := &x.ListMeta
		yym507 := z.DecBinary()
		_ = yym507
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv506) {
		} else {
			z.DecFallback(yyv506, false)
		}
	}
	yyj503++
	if yyhl503 {
		yyb503 = yyj503 > l
	} else {
		yyb503 = r.CheckBreak()
	}
	if yyb503 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv508 := &x.Items
		yym509 := z.DecBinary()
		_ = yym509
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv508), d)
		}
	}
	for {
		yyj503++
		if yyhl503 {
			yyb503 = yyj503 > l
		} else {
			yyb503 = r.CheckBreak()
		}
		if yyb503 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj503-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym510 := z.EncBinary()
		_ = yym510
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep511 := !z.EncBinary()
			yy2arr511 := z.EncBasicHandle().StructToArray
			var yyq511 [2]bool
			_, _, _ = yysep511, yyq511, yy2arr511
			const yyr511 bool = false
			yyq511[0] = x.Selector != nil
			yyq511[1] = x.Template != nil
			var yynn511 int
			if yyr511 || yy2arr511 {
				r.EncodeArrayStart(2)
			} else {
				yynn511 = 0
				for _, b := range yyq511 {
					if b {
						yynn511++
					}
				}
				r.EncodeMapStart(yynn511)
				yynn511 = 0
			}
			if yyr511 || yy2arr511 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq511[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq511[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr511 || yy2arr511 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq511[1] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq511[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr511 || yy2arr511 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym514 := z.DecBinary()
	_ = yym514
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct515 := r.ContainerType()
		if yyct515 == codecSelferValueTypeMap1234 {
			yyl515 := r.ReadMapStart()
			if yyl515 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl515, d)
			}
		} else if yyct515 == codecSelferValueTypeArray1234 {
			yyl515 := r.ReadArrayStart()
			if yyl515 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl515, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys516Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys516Slc
	var yyhl516 bool = l >= 0
	for yyj516 := 0; ; yyj516++ {
		if yyhl516 {
			if yyj516 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys516Slc = r.DecodeBytes(yys516Slc, true, true)
		yys516 := string(yys516Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys516 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(pkg2_api.PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys516)
		} // end switch yys516
	} // end for yyj516
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj519 int
	var yyb519 bool
	var yyhl519 bool = l >= 0
	yyj519++
	if yyhl519 {
		yyb519 = yyj519 > l
	} else {
		yyb519 = r.CheckBreak()
	}
	if yyb519 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj519++
	if yyhl519 {
		yyb519 = yyj519 > l
	} else {
		yyb519 = r.CheckBreak()
	}
	if yyb519 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(pkg2_api.PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj519++
		if yyhl519 {
			yyb519 = yyj519 > l
		} else {
			yyb519 = r.CheckBreak()
		}
		if yyb519 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj519-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym522 := z.EncBinary()
		_ = yym522
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep523 := !z.EncBinary()
			yy2arr523 := z.EncBasicHandle().StructToArray
			var yyq523 [3]bool
			_, _, _ = yysep523, yyq523, yy2arr523
			const yyr523 bool = false
			var yynn523 int
			if yyr523 || yy2arr523 {
				r.EncodeArrayStart(3)
			} else {
				yynn523 = 3
				for _, b := range yyq523 {
					if b {
						yynn523++
					}
				}
				r.EncodeMapStart(yynn523)
				yynn523 = 0
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym525 := z.EncBinary()
				_ = yym525
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym526 := z.EncBinary()
				_ = yym526
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym528 := z.EncBinary()
				_ = yym528
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym529 := z.EncBinary()
				_ = yym529
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym531 := z.EncBinary()
				_ = yym531
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym532 := z.EncBinary()
				_ = yym532
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr523 || yy2arr523 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym533 := z.DecBinary()
	_ = yym533
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct534 := r.ContainerType()
		if yyct534 == codecSelferValueTypeMap1234 {
			yyl534 := r.ReadMapStart()
			if yyl534 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl534, d)
			}
		} else if yyct534 == codecSelferValueTypeArray1234 {
			yyl534 := r.ReadArrayStart()
			if yyl534 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl534, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys535Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys535Slc
	var yyhl535 bool = l >= 0
	for yyj535 := 0; ; yyj535++ {
		if yyhl535 {
			if yyj535 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys535Slc = r.DecodeBytes(yys535Slc, true, true)
		yys535 := string(yys535Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys535 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys535)
		} // end switch yys535
	} // end for yyj535
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj539 int
	var yyb539 bool
	var yyhl539 bool = l >= 0
	yyj539++
	if yyhl539 {
		yyb539 = yyj539 > l
	} else {
		yyb539 = r.CheckBreak()
	}
	if yyb539 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj539++
	if yyhl539 {
		yyb539 = yyj539 > l
	} else {
		yyb539 = r.CheckBreak()
	}
	if yyb539 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj539++
	if yyhl539 {
		yyb539 = yyj539 > l
	} else {
		yyb539 = r.CheckBreak()
	}
	if yyb539 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj539++
		if yyhl539 {
			yyb539 = yyj539 > l
		} else {
			yyb539 = r.CheckBreak()
		}
		if yyb539 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj539-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym543 := z.EncBinary()
		_ = yym543
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep544 := !z.EncBinary()
			yy2arr544 := z.EncBasicHandle().StructToArray
			var yyq544 [5]bool
			_, _, _ = yysep544, yyq544, yy2arr544
			const yyr544 bool = false
			yyq544[0] = x.Kind != ""
			yyq544[1] = x.APIVersion != ""
			yyq544[2] = true
			yyq544[3] = true
			yyq544[4] = true
			var yynn544 int
			if yyr544 || yy2arr544 {
				r.EncodeArrayStart(5)
			} else {
				yynn544 = 0
				for _, b := range yyq544 {
					if b {
						yynn544++
					}
				}
				r.EncodeMapStart(yynn544)
				yynn544 = 0
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[0] {
					yym546 := z.EncBinary()
					_ = yym546
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq544[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym547 := z.EncBinary()
					_ = yym547
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[1] {
					yym549 := z.EncBinary()
					_ = yym549
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq544[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym550 := z.EncBinary()
					_ = yym550
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[2] {
					yy552 := &x.ObjectMeta
					yy552.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq544[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy553 := &x.ObjectMeta
					yy553.CodecEncodeSelf(e)
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[3] {
					yy555 := &x.Spec
					yy555.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq544[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy556 := &x.Spec
					yy556.CodecEncodeSelf(e)
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[4] {
					yy558 := &x.Status
					yy558.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq544[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy559 := &x.Status
					yy559.CodecEncodeSelf(e)
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym560 := z.DecBinary()
	_ = yym560
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct561 := r.ContainerType()
		if yyct561 == codecSelferValueTypeMap1234 {
			yyl561 := r.ReadMapStart()
			if yyl561 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl561, d)
			}
		} else if yyct561 == codecSelferValueTypeArray1234 {
			yyl561 := r.ReadArrayStart()
			if yyl561 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl561, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys562Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys562Slc
	var yyhl562 bool = l >= 0
	for yyj562 := 0; ; yyj562++ {
		if yyhl562 {
			if yyj562 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys562Slc = r.DecodeBytes(yys562Slc, true, true)
		yys562 := string(yys562Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys562 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv565 := &x.ObjectMeta
				yyv565.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv566 := &x.Spec
				yyv566.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv567 := &x.Status
				yyv567.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys562)
		} // end switch yys562
	} // end for yyj562
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj568 int
	var yyb568 bool
	var yyhl568 bool = l >= 0
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv571 := &x.ObjectMeta
		yyv571.CodecDecodeSelf(d)
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv572 := &x.Spec
		yyv572.CodecDecodeSelf(d)
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv573 := &x.Status
		yyv573.CodecDecodeSelf(d)
	}
	for {
		yyj568++
		if yyhl568 {
			yyb568 = yyj568 > l
		} else {
			yyb568 = r.CheckBreak()
		}
		if yyb568 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj568-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym574 := z.EncBinary()
		_ = yym574
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep575 := !z.EncBinary()
			yy2arr575 := z.EncBasicHandle().StructToArray
			var yyq575 [4]bool
			_, _, _ = yysep575, yyq575, yy2arr575
			const yyr575 bool = false
			yyq575[0] = x.Kind != ""
			yyq575[1] = x.APIVersion != ""
			yyq575[2] = true
			var yynn575 int
			if yyr575 || yy2arr575 {
				r.EncodeArrayStart(4)
			} else {
				yynn575 = 1
				for _, b := range yyq575 {
					if b {
						yynn575++
					}
				}
				r.EncodeMapStart(yynn575)
				yynn575 = 0
			}
			if yyr575 || yy2arr575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq575[0] {
					yym577 := z.EncBinary()
					_ = yym577
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq575[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym578 := z.EncBinary()
					_ = yym578
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr575 || yy2arr575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq575[1] {
					yym580 := z.EncBinary()
					_ = yym580
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq575[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym581 := z.EncBinary()
					_ = yym581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr575 || yy2arr575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq575[2] {
					yy583 := &x.ListMeta
					yym584 := z.EncBinary()
					_ = yym584
					if false {
					} else if z.HasExtensions() && z.EncExt(yy583) {
					} else {
						z.EncFallback(yy583)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq575[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy585 := &x.ListMeta
					yym586 := z.EncBinary()
					_ = yym586
					if false {
					} else if z.HasExtensions() && z.EncExt(yy585) {
					} else {
						z.EncFallback(yy585)
					}
				}
			}
			if yyr575 || yy2arr575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym588 := z.EncBinary()
					_ = yym588
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym589 := z.EncBinary()
					_ = yym589
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr575 || yy2arr575 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym590 := z.DecBinary()
	_ = yym590
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct591 := r.ContainerType()
		if yyct591 == codecSelferValueTypeMap1234 {
			yyl591 := r.ReadMapStart()
			if yyl591 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl591, d)
			}
		} else if yyct591 == codecSelferValueTypeArray1234 {
			yyl591 := r.ReadArrayStart()
			if yyl591 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl591, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys592Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys592Slc
	var yyhl592 bool = l >= 0
	for yyj592 := 0; ; yyj592++ {
		if yyhl592 {
			if yyj592 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys592Slc = r.DecodeBytes(yys592Slc, true, true)
		yys592 := string(yys592Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys592 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv595 := &x.ListMeta
				yym596 := z.DecBinary()
				_ = yym596
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv595) {
				} else {
					z.DecFallback(yyv595, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv597 := &x.Items
				yym598 := z.DecBinary()
				_ = yym598
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv597), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys592)
		} // end switch yys592
	} // end for yyj592
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj599 int
	var yyb599 bool
	var yyhl599 bool = l >= 0
	yyj599++
	if yyhl599 {
		yyb599 = yyj599 > l
	} else {
		yyb599 = r.CheckBreak()
	}
	if yyb599 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj599++
	if yyhl599 {
		yyb599 = yyj599 > l
	} else {
		yyb599 = r.CheckBreak()
	}
	if yyb599 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj599++
	if yyhl599 {
		yyb599 = yyj599 > l
	} else {
		yyb599 = r.CheckBreak()
	}
	if yyb599 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv602 := &x.ListMeta
		yym603 := z.DecBinary()
		_ = yym603
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv602) {
		} else {
			z.DecFallback(yyv602, false)
		}
	}
	yyj599++
	if yyhl599 {
		yyb599 = yyj599 > l
	} else {
		yyb599 = r.CheckBreak()
	}
	if yyb599 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv604 := &x.Items
		yym605 := z.DecBinary()
		_ = yym605
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv604), d)
		}
	}
	for {
		yyj599++
		if yyhl599 {
			yyb599 = yyj599 > l
		} else {
			yyb599 = r.CheckBreak()
		}
		if yyb599 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj599-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym606 := z.EncBinary()
		_ = yym606
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep607 := !z.EncBinary()
			yy2arr607 := z.EncBasicHandle().StructToArray
			var yyq607 [4]bool
			_, _, _ = yysep607, yyq607, yy2arr607
			const yyr607 bool = false
			yyq607[0] = x.Kind != ""
			yyq607[1] = x.APIVersion != ""
			yyq607[2] = true
			var yynn607 int
			if yyr607 || yy2arr607 {
				r.EncodeArrayStart(4)
			} else {
				yynn607 = 1
				for _, b := range yyq607 {
					if b {
						yynn607++
					}
				}
				r.EncodeMapStart(yynn607)
				yynn607 = 0
			}
			if yyr607 || yy2arr607 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq607[0] {
					yym609 := z.EncBinary()
					_ = yym609
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq607[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym610 := z.EncBinary()
					_ = yym610
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr607 || yy2arr607 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq607[1] {
					yym612 := z.EncBinary()
					_ = yym612
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq607[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym613 := z.EncBinary()
					_ = yym613
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr607 || yy2arr607 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq607[2] {
					yy615 := &x.ListMeta
					yym616 := z.EncBinary()
					_ = yym616
					if false {
					} else if z.HasExtensions() && z.EncExt(yy615) {
					} else {
						z.EncFallback(yy615)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq607[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy617 := &x.ListMeta
					yym618 := z.EncBinary()
					_ = yym618
					if false {
					} else if z.HasExtensions() && z.EncExt(yy617) {
					} else {
						z.EncFallback(yy617)
					}
				}
			}
			if yyr607 || yy2arr607 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym620 := z.EncBinary()
					_ = yym620
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym621 := z.EncBinary()
					_ = yym621
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr607 || yy2arr607 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym622 := z.DecBinary()
	_ = yym622
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct623 := r.ContainerType()
		if yyct623 == codecSelferValueTypeMap1234 {
			yyl623 := r.ReadMapStart()
			if yyl623 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl623, d)
			}
		} else if yyct623 == codecSelferValueTypeArray1234 {
			yyl623 := r.ReadArrayStart()
			if yyl623 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl623, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys624Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys624Slc
	var yyhl624 bool = l >= 0
	for yyj624 := 0; ; yyj624++ {
		if yyhl624 {
			if yyj624 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys624Slc = r.DecodeBytes(yys624Slc, true, true)
		yys624 := string(yys624Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys624 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv627 := &x.ListMeta
				yym628 := z.DecBinary()
				_ = yym628
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv627) {
				} else {
					z.DecFallback(yyv627, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv629 := &x.Items
				yym630 := z.DecBinary()
				_ = yym630
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv629), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys624)
		} // end switch yys624
	} // end for yyj624
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj631 int
	var yyb631 bool
	var yyhl631 bool = l >= 0
	yyj631++
	if yyhl631 {
		yyb631 = yyj631 > l
	} else {
		yyb631 = r.CheckBreak()
	}
	if yyb631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj631++
	if yyhl631 {
		yyb631 = yyj631 > l
	} else {
		yyb631 = r.CheckBreak()
	}
	if yyb631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj631++
	if yyhl631 {
		yyb631 = yyj631 > l
	} else {
		yyb631 = r.CheckBreak()
	}
	if yyb631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv634 := &x.ListMeta
		yym635 := z.DecBinary()
		_ = yym635
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv634) {
		} else {
			z.DecFallback(yyv634, false)
		}
	}
	yyj631++
	if yyhl631 {
		yyb631 = yyj631 > l
	} else {
		yyb631 = r.CheckBreak()
	}
	if yyb631 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv636 := &x.Items
		yym637 := z.DecBinary()
		_ = yym637
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv636), d)
		}
	}
	for {
		yyj631++
		if yyhl631 {
			yyb631 = yyj631 > l
		} else {
			yyb631 = r.CheckBreak()
		}
		if yyb631 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj631-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym638 := z.EncBinary()
		_ = yym638
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep639 := !z.EncBinary()
			yy2arr639 := z.EncBasicHandle().StructToArray
			var yyq639 [5]bool
			_, _, _ = yysep639, yyq639, yy2arr639
			const yyr639 bool = false
			yyq639[0] = x.Kind != ""
			yyq639[1] = x.APIVersion != ""
			yyq639[2] = true
			yyq639[3] = true
			yyq639[4] = true
			var yynn639 int
			if yyr639 || yy2arr639 {
				r.EncodeArrayStart(5)
			} else {
				yynn639 = 0
				for _, b := range yyq639 {
					if b {
						yynn639++
					}
				}
				r.EncodeMapStart(yynn639)
				yynn639 = 0
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[0] {
					yym641 := z.EncBinary()
					_ = yym641
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq639[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym642 := z.EncBinary()
					_ = yym642
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[1] {
					yym644 := z.EncBinary()
					_ = yym644
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq639[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym645 := z.EncBinary()
					_ = yym645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[2] {
					yy647 := &x.ObjectMeta
					yy647.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq639[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy648 := &x.ObjectMeta
					yy648.CodecEncodeSelf(e)
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[3] {
					yy650 := &x.Spec
					yy650.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq639[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy651 := &x.Spec
					yy651.CodecEncodeSelf(e)
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[4] {
					yy653 := &x.Status
					yy653.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq639[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy654 := &x.Status
					yy654.CodecEncodeSelf(e)
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym655 := z.DecBinary()
	_ = yym655
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct656 := r.ContainerType()
		if yyct656 == codecSelferValueTypeMap1234 {
			yyl656 := r.ReadMapStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl656, d)
			}
		} else if yyct656 == codecSelferValueTypeArray1234 {
			yyl656 := r.ReadArrayStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl656, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys657Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys657Slc
	var yyhl657 bool = l >= 0
	for yyj657 := 0; ; yyj657++ {
		if yyhl657 {
			if yyj657 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys657Slc = r.DecodeBytes(yys657Slc, true, true)
		yys657 := string(yys657Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys657 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv660 := &x.ObjectMeta
				yyv660.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv661 := &x.Spec
				yyv661.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv662 := &x.Status
				yyv662.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys657)
		} // end switch yys657
	} // end for yyj657
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj663 int
	var yyb663 bool
	var yyhl663 bool = l >= 0
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv666 := &x.ObjectMeta
		yyv666.CodecDecodeSelf(d)
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv667 := &x.Spec
		yyv667.CodecDecodeSelf(d)
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv668 := &x.Status
		yyv668.CodecDecodeSelf(d)
	}
	for {
		yyj663++
		if yyhl663 {
			yyb663 = yyj663 > l
		} else {
			yyb663 = r.CheckBreak()
		}
		if yyb663 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj663-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym669 := z.EncBinary()
		_ = yym669
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep670 := !z.EncBinary()
			yy2arr670 := z.EncBasicHandle().StructToArray
			var yyq670 [4]bool
			_, _, _ = yysep670, yyq670, yy2arr670
			const yyr670 bool = false
			yyq670[0] = x.Kind != ""
			yyq670[1] = x.APIVersion != ""
			yyq670[2] = true
			var yynn670 int
			if yyr670 || yy2arr670 {
				r.EncodeArrayStart(4)
			} else {
				yynn670 = 1
				for _, b := range yyq670 {
					if b {
						yynn670++
					}
				}
				r.EncodeMapStart(yynn670)
				yynn670 = 0
			}
			if yyr670 || yy2arr670 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq670[0] {
					yym672 := z.EncBinary()
					_ = yym672
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq670[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym673 := z.EncBinary()
					_ = yym673
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr670 || yy2arr670 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq670[1] {
					yym675 := z.EncBinary()
					_ = yym675
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq670[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym676 := z.EncBinary()
					_ = yym676
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr670 || yy2arr670 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq670[2] {
					yy678 := &x.ListMeta
					yym679 := z.EncBinary()
					_ = yym679
					if false {
					} else if z.HasExtensions() && z.EncExt(yy678) {
					} else {
						z.EncFallback(yy678)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq670[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy680 := &x.ListMeta
					yym681 := z.EncBinary()
					_ = yym681
					if false {
					} else if z.HasExtensions() && z.EncExt(yy680) {
					} else {
						z.EncFallback(yy680)
					}
				}
			}
			if yyr670 || yy2arr670 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym683 := z.EncBinary()
					_ = yym683
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym684 := z.EncBinary()
					_ = yym684
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr670 || yy2arr670 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym685 := z.DecBinary()
	_ = yym685
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct686 := r.ContainerType()
		if yyct686 == codecSelferValueTypeMap1234 {
			yyl686 := r.ReadMapStart()
			if yyl686 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl686, d)
			}
		} else if yyct686 == codecSelferValueTypeArray1234 {
			yyl686 := r.ReadArrayStart()
			if yyl686 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl686, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys687Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys687Slc
	var yyhl687 bool = l >= 0
	for yyj687 := 0; ; yyj687++ {
		if yyhl687 {
			if yyj687 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys687Slc = r.DecodeBytes(yys687Slc, true, true)
		yys687 := string(yys687Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys687 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv690 := &x.ListMeta
				yym691 := z.DecBinary()
				_ = yym691
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv690) {
				} else {
					z.DecFallback(yyv690, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv692 := &x.Items
				yym693 := z.DecBinary()
				_ = yym693
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv692), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys687)
		} // end switch yys687
	} // end for yyj687
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj694 int
	var yyb694 bool
	var yyhl694 bool = l >= 0
	yyj694++
	if yyhl694 {
		yyb694 = yyj694 > l
	} else {
		yyb694 = r.CheckBreak()
	}
	if yyb694 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj694++
	if yyhl694 {
		yyb694 = yyj694 > l
	} else {
		yyb694 = r.CheckBreak()
	}
	if yyb694 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj694++
	if yyhl694 {
		yyb694 = yyj694 > l
	} else {
		yyb694 = r.CheckBreak()
	}
	if yyb694 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv697 := &x.ListMeta
		yym698 := z.DecBinary()
		_ = yym698
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv697) {
		} else {
			z.DecFallback(yyv697, false)
		}
	}
	yyj694++
	if yyhl694 {
		yyb694 = yyj694 > l
	} else {
		yyb694 = r.CheckBreak()
	}
	if yyb694 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv699 := &x.Items
		yym700 := z.DecBinary()
		_ = yym700
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv699), d)
		}
	}
	for {
		yyj694++
		if yyhl694 {
			yyb694 = yyj694 > l
		} else {
			yyb694 = r.CheckBreak()
		}
		if yyb694 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj694-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym701 := z.EncBinary()
		_ = yym701
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep702 := !z.EncBinary()
			yy2arr702 := z.EncBasicHandle().StructToArray
			var yyq702 [5]bool
			_, _, _ = yysep702, yyq702, yy2arr702
			const yyr702 bool = false
			yyq702[0] = x.Parallelism != nil
			yyq702[1] = x.Completions != nil
			yyq702[2] = x.ActiveDeadlineSeconds != nil
			yyq702[3] = x.Selector != nil
			var yynn702 int
			if yyr702 || yy2arr702 {
				r.EncodeArrayStart(5)
			} else {
				yynn702 = 1
				for _, b := range yyq702 {
					if b {
						yynn702++
					}
				}
				r.EncodeMapStart(yynn702)
				yynn702 = 0
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq702[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy704 := *x.Parallelism
						yym705 := z.EncBinary()
						_ = yym705
						if false {
						} else {
							r.EncodeInt(int64(yy704))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq702[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy706 := *x.Parallelism
						yym707 := z.EncBinary()
						_ = yym707
						if false {
						} else {
							r.EncodeInt(int64(yy706))
						}
					}
				}
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq702[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy709 := *x.Completions
						yym710 := z.EncBinary()
						_ = yym710
						if false {
						} else {
							r.EncodeInt(int64(yy709))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq702[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy711 := *x.Completions
						yym712 := z.EncBinary()
						_ = yym712
						if false {
						} else {
							r.EncodeInt(int64(yy711))
						}
					}
				}
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq702[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy714 := *x.ActiveDeadlineSeconds
						yym715 := z.EncBinary()
						_ = yym715
						if false {
						} else {
							r.EncodeInt(int64(yy714))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq702[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy716 := *x.ActiveDeadlineSeconds
						yym717 := z.EncBinary()
						_ = yym717
						if false {
						} else {
							r.EncodeInt(int64(yy716))
						}
					}
				}
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq702[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq702[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy720 := &x.Template
				yy720.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy721 := &x.Template
				yy721.CodecEncodeSelf(e)
			}
			if yyr702 || yy2arr702 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym722 := z.DecBinary()
	_ = yym722
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct723 := r.ContainerType()
		if yyct723 == codecSelferValueTypeMap1234 {
			yyl723 := r.ReadMapStart()
			if yyl723 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl723, d)
			}
		} else if yyct723 == codecSelferValueTypeArray1234 {
			yyl723 := r.ReadArrayStart()
			if yyl723 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl723, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys724Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys724Slc
	var yyhl724 bool = l >= 0
	for yyj724 := 0; ; yyj724++ {
		if yyhl724 {
			if yyj724 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys724Slc = r.DecodeBytes(yys724Slc, true, true)
		yys724 := string(yys724Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys724 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int)
				}
				yym726 := z.DecBinary()
				_ = yym726
				if false {
				} else {
					*((*int)(x.Parallelism)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int)
				}
				yym728 := z.DecBinary()
				_ = yym728
				if false {
				} else {
					*((*int)(x.Completions)) = int(r.DecodeInt(codecSelferBitsize1234))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym730 := z.DecBinary()
				_ = yym730
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv732 := &x.Template
				yyv732.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys724)
		} // end switch yys724
	} // end for yyj724
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj733 int
	var yyb733 bool
	var yyhl733 bool = l >= 0
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int)
		}
		yym735 := z.DecBinary()
		_ = yym735
		if false {
		} else {
			*((*int)(x.Parallelism)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int)
		}
		yym737 := z.DecBinary()
		_ = yym737
		if false {
		} else {
			*((*int)(x.Completions)) = int(r.DecodeInt(codecSelferBitsize1234))
		}
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym739 := z.DecBinary()
		_ = yym739
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv741 := &x.Template
		yyv741.CodecDecodeSelf(d)
	}
	for {
		yyj733++
		if yyhl733 {
			yyb733 = yyj733 > l
		} else {
			yyb733 = r.CheckBreak()
		}
		if yyb733 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj733-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym742 := z.EncBinary()
		_ = yym742
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep743 := !z.EncBinary()
			yy2arr743 := z.EncBasicHandle().StructToArray
			var yyq743 [6]bool
			_, _, _ = yysep743, yyq743, yy2arr743
			const yyr743 bool = false
			yyq743[0] = len(x.Conditions) != 0
			yyq743[1] = x.StartTime != nil
			yyq743[2] = x.CompletionTime != nil
			yyq743[3] = x.Active != 0
			yyq743[4] = x.Succeeded != 0
			yyq743[5] = x.Failed != 0
			var yynn743 int
			if yyr743 || yy2arr743 {
				r.EncodeArrayStart(6)
			} else {
				yynn743 = 0
				for _, b := range yyq743 {
					if b {
						yynn743++
					}
				}
				r.EncodeMapStart(yynn743)
				yynn743 = 0
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym745 := z.EncBinary()
						_ = yym745
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq743[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym746 := z.EncBinary()
						_ = yym746
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym748 := z.EncBinary()
						_ = yym748
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym748 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym748 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq743[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym749 := z.EncBinary()
						_ = yym749
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym749 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym749 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym751 := z.EncBinary()
						_ = yym751
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym751 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym751 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq743[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym752 := z.EncBinary()
						_ = yym752
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym752 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym752 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[3] {
					yym754 := z.EncBinary()
					_ = yym754
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq743[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym755 := z.EncBinary()
					_ = yym755
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[4] {
					yym757 := z.EncBinary()
					_ = yym757
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq743[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym758 := z.EncBinary()
					_ = yym758
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq743[5] {
					yym760 := z.EncBinary()
					_ = yym760
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq743[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym761 := z.EncBinary()
					_ = yym761
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr743 || yy2arr743 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym762 := z.DecBinary()
	_ = yym762
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct763 := r.ContainerType()
		if yyct763 == codecSelferValueTypeMap1234 {
			yyl763 := r.ReadMapStart()
			if yyl763 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl763, d)
			}
		} else if yyct763 == codecSelferValueTypeArray1234 {
			yyl763 := r.ReadArrayStart()
			if yyl763 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl763, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys764Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys764Slc
	var yyhl764 bool = l >= 0
	for yyj764 := 0; ; yyj764++ {
		if yyhl764 {
			if yyj764 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys764Slc = r.DecodeBytes(yys764Slc, true, true)
		yys764 := string(yys764Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys764 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv765 := &x.Conditions
				yym766 := z.DecBinary()
				_ = yym766
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv765), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym768 := z.DecBinary()
				_ = yym768
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym768 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym768 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym770 := z.DecBinary()
				_ = yym770
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym770 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym770 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys764)
		} // end switch yys764
	} // end for yyj764
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj774 int
	var yyb774 bool
	var yyhl774 bool = l >= 0
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv775 := &x.Conditions
		yym776 := z.DecBinary()
		_ = yym776
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv775), d)
		}
	}
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym778 := z.DecBinary()
		_ = yym778
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym778 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym778 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym780 := z.DecBinary()
		_ = yym780
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym780 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym780 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj774++
	if yyhl774 {
		yyb774 = yyj774 > l
	} else {
		yyb774 = r.CheckBreak()
	}
	if yyb774 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj774++
		if yyhl774 {
			yyb774 = yyj774 > l
		} else {
			yyb774 = r.CheckBreak()
		}
		if yyb774 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj774-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym784 := z.EncBinary()
	_ = yym784
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym785 := z.DecBinary()
	_ = yym785
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym786 := z.EncBinary()
		_ = yym786
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep787 := !z.EncBinary()
			yy2arr787 := z.EncBasicHandle().StructToArray
			var yyq787 [6]bool
			_, _, _ = yysep787, yyq787, yy2arr787
			const yyr787 bool = false
			yyq787[2] = true
			yyq787[3] = true
			yyq787[4] = x.Reason != ""
			yyq787[5] = x.Message != ""
			var yynn787 int
			if yyr787 || yy2arr787 {
				r.EncodeArrayStart(6)
			} else {
				yynn787 = 2
				for _, b := range yyq787 {
					if b {
						yynn787++
					}
				}
				r.EncodeMapStart(yynn787)
				yynn787 = 0
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym790 := z.EncBinary()
				_ = yym790
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym791 := z.EncBinary()
				_ = yym791
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq787[2] {
					yy793 := &x.LastProbeTime
					yym794 := z.EncBinary()
					_ = yym794
					if false {
					} else if z.HasExtensions() && z.EncExt(yy793) {
					} else if yym794 {
						z.EncBinaryMarshal(yy793)
					} else if !yym794 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy793)
					} else {
						z.EncFallback(yy793)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq787[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy795 := &x.LastProbeTime
					yym796 := z.EncBinary()
					_ = yym796
					if false {
					} else if z.HasExtensions() && z.EncExt(yy795) {
					} else if yym796 {
						z.EncBinaryMarshal(yy795)
					} else if !yym796 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy795)
					} else {
						z.EncFallback(yy795)
					}
				}
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq787[3] {
					yy798 := &x.LastTransitionTime
					yym799 := z.EncBinary()
					_ = yym799
					if false {
					} else if z.HasExtensions() && z.EncExt(yy798) {
					} else if yym799 {
						z.EncBinaryMarshal(yy798)
					} else if !yym799 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy798)
					} else {
						z.EncFallback(yy798)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq787[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy800 := &x.LastTransitionTime
					yym801 := z.EncBinary()
					_ = yym801
					if false {
					} else if z.HasExtensions() && z.EncExt(yy800) {
					} else if yym801 {
						z.EncBinaryMarshal(yy800)
					} else if !yym801 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy800)
					} else {
						z.EncFallback(yy800)
					}
				}
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq787[4] {
					yym803 := z.EncBinary()
					_ = yym803
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq787[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym804 := z.EncBinary()
					_ = yym804
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq787[5] {
					yym806 := z.EncBinary()
					_ = yym806
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq787[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym807 := z.EncBinary()
					_ = yym807
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr787 || yy2arr787 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym808 := z.DecBinary()
	_ = yym808
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct809 := r.ContainerType()
		if yyct809 == codecSelferValueTypeMap1234 {
			yyl809 := r.ReadMapStart()
			if yyl809 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl809, d)
			}
		} else if yyct809 == codecSelferValueTypeArray1234 {
			yyl809 := r.ReadArrayStart()
			if yyl809 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl809, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys810Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys810Slc
	var yyhl810 bool = l >= 0
	for yyj810 := 0; ; yyj810++ {
		if yyhl810 {
			if yyj810 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys810Slc = r.DecodeBytes(yys810Slc, true, true)
		yys810 := string(yys810Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys810 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_api.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv813 := &x.LastProbeTime
				yym814 := z.DecBinary()
				_ = yym814
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv813) {
				} else if yym814 {
					z.DecBinaryUnmarshal(yyv813)
				} else if !yym814 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv813)
				} else {
					z.DecFallback(yyv813, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv815 := &x.LastTransitionTime
				yym816 := z.DecBinary()
				_ = yym816
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv815) {
				} else if yym816 {
					z.DecBinaryUnmarshal(yyv815)
				} else if !yym816 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv815)
				} else {
					z.DecFallback(yyv815, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys810)
		} // end switch yys810
	} // end for yyj810
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj819 int
	var yyb819 bool
	var yyhl819 bool = l >= 0
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_api.ConditionStatus(r.DecodeString())
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv822 := &x.LastProbeTime
		yym823 := z.DecBinary()
		_ = yym823
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv822) {
		} else if yym823 {
			z.DecBinaryUnmarshal(yyv822)
		} else if !yym823 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv822)
		} else {
			z.DecFallback(yyv822, false)
		}
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv824 := &x.LastTransitionTime
		yym825 := z.DecBinary()
		_ = yym825
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv824) {
		} else if yym825 {
			z.DecBinaryUnmarshal(yyv824)
		} else if !yym825 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv824)
		} else {
			z.DecFallback(yyv824, false)
		}
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj819++
		if yyhl819 {
			yyb819 = yyj819 > l
		} else {
			yyb819 = r.CheckBreak()
		}
		if yyb819 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj819-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym828 := z.EncBinary()
		_ = yym828
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep829 := !z.EncBinary()
			yy2arr829 := z.EncBasicHandle().StructToArray
			var yyq829 [5]bool
			_, _, _ = yysep829, yyq829, yy2arr829
			const yyr829 bool = false
			yyq829[0] = x.Kind != ""
			yyq829[1] = x.APIVersion != ""
			yyq829[2] = true
			yyq829[3] = true
			yyq829[4] = true
			var yynn829 int
			if yyr829 || yy2arr829 {
				r.EncodeArrayStart(5)
			} else {
				yynn829 = 0
				for _, b := range yyq829 {
					if b {
						yynn829++
					}
				}
				r.EncodeMapStart(yynn829)
				yynn829 = 0
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq829[0] {
					yym831 := z.EncBinary()
					_ = yym831
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq829[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym832 := z.EncBinary()
					_ = yym832
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq829[1] {
					yym834 := z.EncBinary()
					_ = yym834
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq829[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq829[2] {
					yy837 := &x.ObjectMeta
					yy837.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq829[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy838 := &x.ObjectMeta
					yy838.CodecEncodeSelf(e)
				}
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq829[3] {
					yy840 := &x.Spec
					yy840.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq829[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy841 := &x.Spec
					yy841.CodecEncodeSelf(e)
				}
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq829[4] {
					yy843 := &x.Status
					yy843.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq829[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy844 := &x.Status
					yy844.CodecEncodeSelf(e)
				}
			}
			if yyr829 || yy2arr829 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym845 := z.DecBinary()
	_ = yym845
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct846 := r.ContainerType()
		if yyct846 == codecSelferValueTypeMap1234 {
			yyl846 := r.ReadMapStart()
			if yyl846 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl846, d)
			}
		} else if yyct846 == codecSelferValueTypeArray1234 {
			yyl846 := r.ReadArrayStart()
			if yyl846 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl846, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys847Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys847Slc
	var yyhl847 bool = l >= 0
	for yyj847 := 0; ; yyj847++ {
		if yyhl847 {
			if yyj847 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys847Slc = r.DecodeBytes(yys847Slc, true, true)
		yys847 := string(yys847Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys847 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv850 := &x.ObjectMeta
				yyv850.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv851 := &x.Spec
				yyv851.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv852 := &x.Status
				yyv852.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys847)
		} // end switch yys847
	} // end for yyj847
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj853 int
	var yyb853 bool
	var yyhl853 bool = l >= 0
	yyj853++
	if yyhl853 {
		yyb853 = yyj853 > l
	} else {
		yyb853 = r.CheckBreak()
	}
	if yyb853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj853++
	if yyhl853 {
		yyb853 = yyj853 > l
	} else {
		yyb853 = r.CheckBreak()
	}
	if yyb853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj853++
	if yyhl853 {
		yyb853 = yyj853 > l
	} else {
		yyb853 = r.CheckBreak()
	}
	if yyb853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv856 := &x.ObjectMeta
		yyv856.CodecDecodeSelf(d)
	}
	yyj853++
	if yyhl853 {
		yyb853 = yyj853 > l
	} else {
		yyb853 = r.CheckBreak()
	}
	if yyb853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv857 := &x.Spec
		yyv857.CodecDecodeSelf(d)
	}
	yyj853++
	if yyhl853 {
		yyb853 = yyj853 > l
	} else {
		yyb853 = r.CheckBreak()
	}
	if yyb853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv858 := &x.Status
		yyv858.CodecDecodeSelf(d)
	}
	for {
		yyj853++
		if yyhl853 {
			yyb853 = yyj853 > l
		} else {
			yyb853 = r.CheckBreak()
		}
		if yyb853 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj853-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym859 := z.EncBinary()
		_ = yym859
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep860 := !z.EncBinary()
			yy2arr860 := z.EncBasicHandle().StructToArray
			var yyq860 [4]bool
			_, _, _ = yysep860, yyq860, yy2arr860
			const yyr860 bool = false
			yyq860[0] = x.Kind != ""
			yyq860[1] = x.APIVersion != ""
			yyq860[2] = true
			var yynn860 int
			if yyr860 || yy2arr860 {
				r.EncodeArrayStart(4)
			} else {
				yynn860 = 1
				for _, b := range yyq860 {
					if b {
						yynn860++
					}
				}
				r.EncodeMapStart(yynn860)
				yynn860 = 0
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[0] {
					yym862 := z.EncBinary()
					_ = yym862
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq860[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym863 := z.EncBinary()
					_ = yym863
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[1] {
					yym865 := z.EncBinary()
					_ = yym865
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq860[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym866 := z.EncBinary()
					_ = yym866
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[2] {
					yy868 := &x.ListMeta
					yym869 := z.EncBinary()
					_ = yym869
					if false {
					} else if z.HasExtensions() && z.EncExt(yy868) {
					} else {
						z.EncFallback(yy868)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq860[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy870 := &x.ListMeta
					yym871 := z.EncBinary()
					_ = yym871
					if false {
					} else if z.HasExtensions() && z.EncExt(yy870) {
					} else {
						z.EncFallback(yy870)
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym873 := z.EncBinary()
					_ = yym873
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym874 := z.EncBinary()
					_ = yym874
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym875 := z.DecBinary()
	_ = yym875
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct876 := r.ContainerType()
		if yyct876 == codecSelferValueTypeMap1234 {
			yyl876 := r.ReadMapStart()
			if yyl876 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl876, d)
			}
		} else if yyct876 == codecSelferValueTypeArray1234 {
			yyl876 := r.ReadArrayStart()
			if yyl876 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl876, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys877Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys877Slc
	var yyhl877 bool = l >= 0
	for yyj877 := 0; ; yyj877++ {
		if yyhl877 {
			if yyj877 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys877Slc = r.DecodeBytes(yys877Slc, true, true)
		yys877 := string(yys877Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys877 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv880 := &x.ListMeta
				yym881 := z.DecBinary()
				_ = yym881
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv880) {
				} else {
					z.DecFallback(yyv880, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv882 := &x.Items
				yym883 := z.DecBinary()
				_ = yym883
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv882), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys877)
		} // end switch yys877
	} // end for yyj877
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj884 int
	var yyb884 bool
	var yyhl884 bool = l >= 0
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv887 := &x.ListMeta
		yym888 := z.DecBinary()
		_ = yym888
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv887) {
		} else {
			z.DecFallback(yyv887, false)
		}
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv889 := &x.Items
		yym890 := z.DecBinary()
		_ = yym890
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv889), d)
		}
	}
	for {
		yyj884++
		if yyhl884 {
			yyb884 = yyj884 > l
		} else {
			yyb884 = r.CheckBreak()
		}
		if yyb884 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj884-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym891 := z.EncBinary()
		_ = yym891
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep892 := !z.EncBinary()
			yy2arr892 := z.EncBasicHandle().StructToArray
			var yyq892 [2]bool
			_, _, _ = yysep892, yyq892, yy2arr892
			const yyr892 bool = false
			yyq892[0] = x.Backend != nil
			yyq892[1] = len(x.Rules) != 0
			var yynn892 int
			if yyr892 || yy2arr892 {
				r.EncodeArrayStart(2)
			} else {
				yynn892 = 0
				for _, b := range yyq892 {
					if b {
						yynn892++
					}
				}
				r.EncodeMapStart(yynn892)
				yynn892 = 0
			}
			if yyr892 || yy2arr892 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq892[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq892[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr892 || yy2arr892 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq892[1] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym895 := z.EncBinary()
						_ = yym895
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq892[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym896 := z.EncBinary()
						_ = yym896
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr892 || yy2arr892 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym897 := z.DecBinary()
	_ = yym897
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct898 := r.ContainerType()
		if yyct898 == codecSelferValueTypeMap1234 {
			yyl898 := r.ReadMapStart()
			if yyl898 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl898, d)
			}
		} else if yyct898 == codecSelferValueTypeArray1234 {
			yyl898 := r.ReadArrayStart()
			if yyl898 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl898, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys899Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys899Slc
	var yyhl899 bool = l >= 0
	for yyj899 := 0; ; yyj899++ {
		if yyhl899 {
			if yyj899 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys899Slc = r.DecodeBytes(yys899Slc, true, true)
		yys899 := string(yys899Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys899 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv901 := &x.Rules
				yym902 := z.DecBinary()
				_ = yym902
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv901), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys899)
		} // end switch yys899
	} // end for yyj899
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj903 int
	var yyb903 bool
	var yyhl903 bool = l >= 0
	yyj903++
	if yyhl903 {
		yyb903 = yyj903 > l
	} else {
		yyb903 = r.CheckBreak()
	}
	if yyb903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj903++
	if yyhl903 {
		yyb903 = yyj903 > l
	} else {
		yyb903 = r.CheckBreak()
	}
	if yyb903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv905 := &x.Rules
		yym906 := z.DecBinary()
		_ = yym906
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv905), d)
		}
	}
	for {
		yyj903++
		if yyhl903 {
			yyb903 = yyj903 > l
		} else {
			yyb903 = r.CheckBreak()
		}
		if yyb903 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj903-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym907 := z.EncBinary()
		_ = yym907
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep908 := !z.EncBinary()
			yy2arr908 := z.EncBasicHandle().StructToArray
			var yyq908 [1]bool
			_, _, _ = yysep908, yyq908, yy2arr908
			const yyr908 bool = false
			yyq908[0] = true
			var yynn908 int
			if yyr908 || yy2arr908 {
				r.EncodeArrayStart(1)
			} else {
				yynn908 = 0
				for _, b := range yyq908 {
					if b {
						yynn908++
					}
				}
				r.EncodeMapStart(yynn908)
				yynn908 = 0
			}
			if yyr908 || yy2arr908 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq908[0] {
					yy910 := &x.LoadBalancer
					yy910.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq908[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy911 := &x.LoadBalancer
					yy911.CodecEncodeSelf(e)
				}
			}
			if yyr908 || yy2arr908 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym912 := z.DecBinary()
	_ = yym912
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct913 := r.ContainerType()
		if yyct913 == codecSelferValueTypeMap1234 {
			yyl913 := r.ReadMapStart()
			if yyl913 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl913, d)
			}
		} else if yyct913 == codecSelferValueTypeArray1234 {
			yyl913 := r.ReadArrayStart()
			if yyl913 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl913, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys914Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys914Slc
	var yyhl914 bool = l >= 0
	for yyj914 := 0; ; yyj914++ {
		if yyhl914 {
			if yyj914 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys914Slc = r.DecodeBytes(yys914Slc, true, true)
		yys914 := string(yys914Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys914 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
			} else {
				yyv915 := &x.LoadBalancer
				yyv915.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys914)
		} // end switch yys914
	} // end for yyj914
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj916 int
	var yyb916 bool
	var yyhl916 bool = l >= 0
	yyj916++
	if yyhl916 {
		yyb916 = yyj916 > l
	} else {
		yyb916 = r.CheckBreak()
	}
	if yyb916 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
	} else {
		yyv917 := &x.LoadBalancer
		yyv917.CodecDecodeSelf(d)
	}
	for {
		yyj916++
		if yyhl916 {
			yyb916 = yyj916 > l
		} else {
			yyb916 = r.CheckBreak()
		}
		if yyb916 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj916-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym918 := z.EncBinary()
		_ = yym918
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep919 := !z.EncBinary()
			yy2arr919 := z.EncBasicHandle().StructToArray
			var yyq919 [2]bool
			_, _, _ = yysep919, yyq919, yy2arr919
			const yyr919 bool = false
			yyq919[0] = x.Host != ""
			yyq919[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn919 int
			if yyr919 || yy2arr919 {
				r.EncodeArrayStart(2)
			} else {
				yynn919 = 0
				for _, b := range yyq919 {
					if b {
						yynn919++
					}
				}
				r.EncodeMapStart(yynn919)
				yynn919 = 0
			}
			if yyr919 || yy2arr919 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq919[0] {
					yym921 := z.EncBinary()
					_ = yym921
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq919[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym922 := z.EncBinary()
					_ = yym922
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn923 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn923 = true
				goto LABEL923
			}
		LABEL923:
			if yyr919 || yy2arr919 {
				if yyn923 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq919[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq919[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn923 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr919 || yy2arr919 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym924 := z.DecBinary()
	_ = yym924
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct925 := r.ContainerType()
		if yyct925 == codecSelferValueTypeMap1234 {
			yyl925 := r.ReadMapStart()
			if yyl925 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl925, d)
			}
		} else if yyct925 == codecSelferValueTypeArray1234 {
			yyl925 := r.ReadArrayStart()
			if yyl925 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl925, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys926Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys926Slc
	var yyhl926 bool = l >= 0
	for yyj926 := 0; ; yyj926++ {
		if yyhl926 {
			if yyj926 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys926Slc = r.DecodeBytes(yys926Slc, true, true)
		yys926 := string(yys926Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys926 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys926)
		} // end switch yys926
	} // end for yyj926
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj929 int
	var yyb929 bool
	var yyhl929 bool = l >= 0
	yyj929++
	if yyhl929 {
		yyb929 = yyj929 > l
	} else {
		yyb929 = r.CheckBreak()
	}
	if yyb929 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj929++
	if yyhl929 {
		yyb929 = yyj929 > l
	} else {
		yyb929 = r.CheckBreak()
	}
	if yyb929 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj929++
		if yyhl929 {
			yyb929 = yyj929 > l
		} else {
			yyb929 = r.CheckBreak()
		}
		if yyb929 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj929-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym932 := z.EncBinary()
		_ = yym932
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep933 := !z.EncBinary()
			yy2arr933 := z.EncBasicHandle().StructToArray
			var yyq933 [1]bool
			_, _, _ = yysep933, yyq933, yy2arr933
			const yyr933 bool = false
			yyq933[0] = x.HTTP != nil
			var yynn933 int
			if yyr933 || yy2arr933 {
				r.EncodeArrayStart(1)
			} else {
				yynn933 = 0
				for _, b := range yyq933 {
					if b {
						yynn933++
					}
				}
				r.EncodeMapStart(yynn933)
				yynn933 = 0
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym935 := z.DecBinary()
	_ = yym935
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct936 := r.ContainerType()
		if yyct936 == codecSelferValueTypeMap1234 {
			yyl936 := r.ReadMapStart()
			if yyl936 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl936, d)
			}
		} else if yyct936 == codecSelferValueTypeArray1234 {
			yyl936 := r.ReadArrayStart()
			if yyl936 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl936, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys937Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys937Slc
	var yyhl937 bool = l >= 0
	for yyj937 := 0; ; yyj937++ {
		if yyhl937 {
			if yyj937 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys937Slc = r.DecodeBytes(yys937Slc, true, true)
		yys937 := string(yys937Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys937 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys937)
		} // end switch yys937
	} // end for yyj937
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj939 int
	var yyb939 bool
	var yyhl939 bool = l >= 0
	yyj939++
	if yyhl939 {
		yyb939 = yyj939 > l
	} else {
		yyb939 = r.CheckBreak()
	}
	if yyb939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj939++
		if yyhl939 {
			yyb939 = yyj939 > l
		} else {
			yyb939 = r.CheckBreak()
		}
		if yyb939 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj939-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym941 := z.EncBinary()
		_ = yym941
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep942 := !z.EncBinary()
			yy2arr942 := z.EncBasicHandle().StructToArray
			var yyq942 [1]bool
			_, _, _ = yysep942, yyq942, yy2arr942
			const yyr942 bool = false
			var yynn942 int
			if yyr942 || yy2arr942 {
				r.EncodeArrayStart(1)
			} else {
				yynn942 = 1
				for _, b := range yyq942 {
					if b {
						yynn942++
					}
				}
				r.EncodeMapStart(yynn942)
				yynn942 = 0
			}
			if yyr942 || yy2arr942 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym944 := z.EncBinary()
					_ = yym944
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym945 := z.EncBinary()
					_ = yym945
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr942 || yy2arr942 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym946 := z.DecBinary()
	_ = yym946
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct947 := r.ContainerType()
		if yyct947 == codecSelferValueTypeMap1234 {
			yyl947 := r.ReadMapStart()
			if yyl947 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl947, d)
			}
		} else if yyct947 == codecSelferValueTypeArray1234 {
			yyl947 := r.ReadArrayStart()
			if yyl947 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl947, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys948Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys948Slc
	var yyhl948 bool = l >= 0
	for yyj948 := 0; ; yyj948++ {
		if yyhl948 {
			if yyj948 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys948Slc = r.DecodeBytes(yys948Slc, true, true)
		yys948 := string(yys948Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys948 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv949 := &x.Paths
				yym950 := z.DecBinary()
				_ = yym950
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv949), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys948)
		} // end switch yys948
	} // end for yyj948
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj951 int
	var yyb951 bool
	var yyhl951 bool = l >= 0
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv952 := &x.Paths
		yym953 := z.DecBinary()
		_ = yym953
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv952), d)
		}
	}
	for {
		yyj951++
		if yyhl951 {
			yyb951 = yyj951 > l
		} else {
			yyb951 = r.CheckBreak()
		}
		if yyb951 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj951-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym954 := z.EncBinary()
		_ = yym954
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep955 := !z.EncBinary()
			yy2arr955 := z.EncBasicHandle().StructToArray
			var yyq955 [2]bool
			_, _, _ = yysep955, yyq955, yy2arr955
			const yyr955 bool = false
			yyq955[0] = x.Path != ""
			var yynn955 int
			if yyr955 || yy2arr955 {
				r.EncodeArrayStart(2)
			} else {
				yynn955 = 1
				for _, b := range yyq955 {
					if b {
						yynn955++
					}
				}
				r.EncodeMapStart(yynn955)
				yynn955 = 0
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[0] {
					yym957 := z.EncBinary()
					_ = yym957
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq955[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym958 := z.EncBinary()
					_ = yym958
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy960 := &x.Backend
				yy960.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy961 := &x.Backend
				yy961.CodecEncodeSelf(e)
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym962 := z.DecBinary()
	_ = yym962
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct963 := r.ContainerType()
		if yyct963 == codecSelferValueTypeMap1234 {
			yyl963 := r.ReadMapStart()
			if yyl963 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl963, d)
			}
		} else if yyct963 == codecSelferValueTypeArray1234 {
			yyl963 := r.ReadArrayStart()
			if yyl963 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl963, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys964Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys964Slc
	var yyhl964 bool = l >= 0
	for yyj964 := 0; ; yyj964++ {
		if yyhl964 {
			if yyj964 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys964Slc = r.DecodeBytes(yys964Slc, true, true)
		yys964 := string(yys964Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys964 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv966 := &x.Backend
				yyv966.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys964)
		} // end switch yys964
	} // end for yyj964
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj967 int
	var yyb967 bool
	var yyhl967 bool = l >= 0
	yyj967++
	if yyhl967 {
		yyb967 = yyj967 > l
	} else {
		yyb967 = r.CheckBreak()
	}
	if yyb967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj967++
	if yyhl967 {
		yyb967 = yyj967 > l
	} else {
		yyb967 = r.CheckBreak()
	}
	if yyb967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv969 := &x.Backend
		yyv969.CodecDecodeSelf(d)
	}
	for {
		yyj967++
		if yyhl967 {
			yyb967 = yyj967 > l
		} else {
			yyb967 = r.CheckBreak()
		}
		if yyb967 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj967-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym970 := z.EncBinary()
		_ = yym970
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep971 := !z.EncBinary()
			yy2arr971 := z.EncBasicHandle().StructToArray
			var yyq971 [2]bool
			_, _, _ = yysep971, yyq971, yy2arr971
			const yyr971 bool = false
			var yynn971 int
			if yyr971 || yy2arr971 {
				r.EncodeArrayStart(2)
			} else {
				yynn971 = 2
				for _, b := range yyq971 {
					if b {
						yynn971++
					}
				}
				r.EncodeMapStart(yynn971)
				yynn971 = 0
			}
			if yyr971 || yy2arr971 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym973 := z.EncBinary()
				_ = yym973
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr971 || yy2arr971 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy976 := &x.ServicePort
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else if z.HasExtensions() && z.EncExt(yy976) {
				} else if !yym977 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy976)
				} else {
					z.EncFallback(yy976)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy978 := &x.ServicePort
				yym979 := z.EncBinary()
				_ = yym979
				if false {
				} else if z.HasExtensions() && z.EncExt(yy978) {
				} else if !yym979 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy978)
				} else {
					z.EncFallback(yy978)
				}
			}
			if yyr971 || yy2arr971 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym980 := z.DecBinary()
	_ = yym980
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct981 := r.ContainerType()
		if yyct981 == codecSelferValueTypeMap1234 {
			yyl981 := r.ReadMapStart()
			if yyl981 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl981, d)
			}
		} else if yyct981 == codecSelferValueTypeArray1234 {
			yyl981 := r.ReadArrayStart()
			if yyl981 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl981, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys982Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys982Slc
	var yyhl982 bool = l >= 0
	for yyj982 := 0; ; yyj982++ {
		if yyhl982 {
			if yyj982 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys982Slc = r.DecodeBytes(yys982Slc, true, true)
		yys982 := string(yys982Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys982 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg6_intstr.IntOrString{}
			} else {
				yyv984 := &x.ServicePort
				yym985 := z.DecBinary()
				_ = yym985
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv984) {
				} else if !yym985 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv984)
				} else {
					z.DecFallback(yyv984, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys982)
		} // end switch yys982
	} // end for yyj982
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj986 int
	var yyb986 bool
	var yyhl986 bool = l >= 0
	yyj986++
	if yyhl986 {
		yyb986 = yyj986 > l
	} else {
		yyb986 = r.CheckBreak()
	}
	if yyb986 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj986++
	if yyhl986 {
		yyb986 = yyj986 > l
	} else {
		yyb986 = r.CheckBreak()
	}
	if yyb986 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg6_intstr.IntOrString{}
	} else {
		yyv988 := &x.ServicePort
		yym989 := z.DecBinary()
		_ = yym989
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv988) {
		} else if !yym989 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv988)
		} else {
			z.DecFallback(yyv988, false)
		}
	}
	for {
		yyj986++
		if yyhl986 {
			yyb986 = yyj986 > l
		} else {
			yyb986 = r.CheckBreak()
		}
		if yyb986 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj986-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym990 := z.EncBinary()
	_ = yym990
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym991 := z.DecBinary()
	_ = yym991
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym992 := z.EncBinary()
		_ = yym992
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep993 := !z.EncBinary()
			yy2arr993 := z.EncBasicHandle().StructToArray
			var yyq993 [2]bool
			_, _, _ = yysep993, yyq993, yy2arr993
			const yyr993 bool = false
			var yynn993 int
			if yyr993 || yy2arr993 {
				r.EncodeArrayStart(2)
			} else {
				yynn993 = 2
				for _, b := range yyq993 {
					if b {
						yynn993++
					}
				}
				r.EncodeMapStart(yynn993)
				yynn993 = 0
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Resource.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Resource.CodecEncodeSelf(e)
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym996 := z.EncBinary()
				_ = yym996
				if false {
				} else {
					r.EncodeFloat64(float64(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym997 := z.EncBinary()
				_ = yym997
				if false {
				} else {
					r.EncodeFloat64(float64(x.Value))
				}
			}
			if yyr993 || yy2arr993 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym998 := z.DecBinary()
	_ = yym998
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct999 := r.ContainerType()
		if yyct999 == codecSelferValueTypeMap1234 {
			yyl999 := r.ReadMapStart()
			if yyl999 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl999, d)
			}
		} else if yyct999 == codecSelferValueTypeArray1234 {
			yyl999 := r.ReadArrayStart()
			if yyl999 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl999, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1000Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1000Slc
	var yyhl1000 bool = l >= 0
	for yyj1000 := 0; ; yyj1000++ {
		if yyhl1000 {
			if yyj1000 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1000Slc = r.DecodeBytes(yys1000Slc, true, true)
		yys1000 := string(yys1000Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1000 {
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = NodeResource(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = 0
			} else {
				x.Value = float64(r.DecodeFloat(false))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1000)
		} // end switch yys1000
	} // end for yyj1000
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1003 int
	var yyb1003 bool
	var yyhl1003 bool = l >= 0
	yyj1003++
	if yyhl1003 {
		yyb1003 = yyj1003 > l
	} else {
		yyb1003 = r.CheckBreak()
	}
	if yyb1003 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = NodeResource(r.DecodeString())
	}
	yyj1003++
	if yyhl1003 {
		yyb1003 = yyj1003 > l
	} else {
		yyb1003 = r.CheckBreak()
	}
	if yyb1003 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = 0
	} else {
		x.Value = float64(r.DecodeFloat(false))
	}
	for {
		yyj1003++
		if yyhl1003 {
			yyb1003 = yyj1003 > l
		} else {
			yyb1003 = r.CheckBreak()
		}
		if yyb1003 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1003-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1006 := z.EncBinary()
		_ = yym1006
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1007 := !z.EncBinary()
			yy2arr1007 := z.EncBasicHandle().StructToArray
			var yyq1007 [3]bool
			_, _, _ = yysep1007, yyq1007, yy2arr1007
			const yyr1007 bool = false
			var yynn1007 int
			if yyr1007 || yy2arr1007 {
				r.EncodeArrayStart(3)
			} else {
				yynn1007 = 3
				for _, b := range yyq1007 {
					if b {
						yynn1007++
					}
				}
				r.EncodeMapStart(yynn1007)
				yynn1007 = 0
			}
			if yyr1007 || yy2arr1007 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1009 := z.EncBinary()
				_ = yym1009
				if false {
				} else {
					r.EncodeInt(int64(x.MinNodes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minNodes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1010 := z.EncBinary()
				_ = yym1010
				if false {
				} else {
					r.EncodeInt(int64(x.MinNodes))
				}
			}
			if yyr1007 || yy2arr1007 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1012 := z.EncBinary()
				_ = yym1012
				if false {
				} else {
					r.EncodeInt(int64(x.MaxNodes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxNodes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeInt(int64(x.MaxNodes))
				}
			}
			if yyr1007 || yy2arr1007 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetUtilization == nil {
					r.EncodeNil()
				} else {
					yym1015 := z.EncBinary()
					_ = yym1015
					if false {
					} else {
						h.encSliceNodeUtilization(([]NodeUtilization)(x.TargetUtilization), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("target"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetUtilization == nil {
					r.EncodeNil()
				} else {
					yym1016 := z.EncBinary()
					_ = yym1016
					if false {
					} else {
						h.encSliceNodeUtilization(([]NodeUtilization)(x.TargetUtilization), e)
					}
				}
			}
			if yyr1007 || yy2arr1007 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1017 := z.DecBinary()
	_ = yym1017
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1018 := r.ContainerType()
		if yyct1018 == codecSelferValueTypeMap1234 {
			yyl1018 := r.ReadMapStart()
			if yyl1018 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1018, d)
			}
		} else if yyct1018 == codecSelferValueTypeArray1234 {
			yyl1018 := r.ReadArrayStart()
			if yyl1018 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1018, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1019Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1019Slc
	var yyhl1019 bool = l >= 0
	for yyj1019 := 0; ; yyj1019++ {
		if yyhl1019 {
			if yyj1019 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1019Slc = r.DecodeBytes(yys1019Slc, true, true)
		yys1019 := string(yys1019Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1019 {
		case "minNodes":
			if r.TryDecodeAsNil() {
				x.MinNodes = 0
			} else {
				x.MinNodes = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "maxNodes":
			if r.TryDecodeAsNil() {
				x.MaxNodes = 0
			} else {
				x.MaxNodes = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "target":
			if r.TryDecodeAsNil() {
				x.TargetUtilization = nil
			} else {
				yyv1022 := &x.TargetUtilization
				yym1023 := z.DecBinary()
				_ = yym1023
				if false {
				} else {
					h.decSliceNodeUtilization((*[]NodeUtilization)(yyv1022), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1019)
		} // end switch yys1019
	} // end for yyj1019
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1024 int
	var yyb1024 bool
	var yyhl1024 bool = l >= 0
	yyj1024++
	if yyhl1024 {
		yyb1024 = yyj1024 > l
	} else {
		yyb1024 = r.CheckBreak()
	}
	if yyb1024 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinNodes = 0
	} else {
		x.MinNodes = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1024++
	if yyhl1024 {
		yyb1024 = yyj1024 > l
	} else {
		yyb1024 = r.CheckBreak()
	}
	if yyb1024 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxNodes = 0
	} else {
		x.MaxNodes = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1024++
	if yyhl1024 {
		yyb1024 = yyj1024 > l
	} else {
		yyb1024 = r.CheckBreak()
	}
	if yyb1024 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetUtilization = nil
	} else {
		yyv1027 := &x.TargetUtilization
		yym1028 := z.DecBinary()
		_ = yym1028
		if false {
		} else {
			h.decSliceNodeUtilization((*[]NodeUtilization)(yyv1027), d)
		}
	}
	for {
		yyj1024++
		if yyhl1024 {
			yyb1024 = yyj1024 > l
		} else {
			yyb1024 = r.CheckBreak()
		}
		if yyb1024 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1024-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1029 := z.EncBinary()
		_ = yym1029
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1030 := !z.EncBinary()
			yy2arr1030 := z.EncBasicHandle().StructToArray
			var yyq1030 [4]bool
			_, _, _ = yysep1030, yyq1030, yy2arr1030
			const yyr1030 bool = false
			yyq1030[0] = x.Kind != ""
			yyq1030[1] = x.APIVersion != ""
			yyq1030[2] = true
			yyq1030[3] = true
			var yynn1030 int
			if yyr1030 || yy2arr1030 {
				r.EncodeArrayStart(4)
			} else {
				yynn1030 = 0
				for _, b := range yyq1030 {
					if b {
						yynn1030++
					}
				}
				r.EncodeMapStart(yynn1030)
				yynn1030 = 0
			}
			if yyr1030 || yy2arr1030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1030[0] {
					yym1032 := z.EncBinary()
					_ = yym1032
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1030[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1033 := z.EncBinary()
					_ = yym1033
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1030 || yy2arr1030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1030[1] {
					yym1035 := z.EncBinary()
					_ = yym1035
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1030[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1036 := z.EncBinary()
					_ = yym1036
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1030 || yy2arr1030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1030[2] {
					yy1038 := &x.ObjectMeta
					yy1038.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1030[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1039 := &x.ObjectMeta
					yy1039.CodecEncodeSelf(e)
				}
			}
			if yyr1030 || yy2arr1030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1030[3] {
					yy1041 := &x.Spec
					yy1041.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1030[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1042 := &x.Spec
					yy1042.CodecEncodeSelf(e)
				}
			}
			if yyr1030 || yy2arr1030 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1043 := z.DecBinary()
	_ = yym1043
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1044 := r.ContainerType()
		if yyct1044 == codecSelferValueTypeMap1234 {
			yyl1044 := r.ReadMapStart()
			if yyl1044 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1044, d)
			}
		} else if yyct1044 == codecSelferValueTypeArray1234 {
			yyl1044 := r.ReadArrayStart()
			if yyl1044 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1044, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1045Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1045Slc
	var yyhl1045 bool = l >= 0
	for yyj1045 := 0; ; yyj1045++ {
		if yyhl1045 {
			if yyj1045 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1045Slc = r.DecodeBytes(yys1045Slc, true, true)
		yys1045 := string(yys1045Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1045 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv1048 := &x.ObjectMeta
				yyv1048.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ClusterAutoscalerSpec{}
			} else {
				yyv1049 := &x.Spec
				yyv1049.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1045)
		} // end switch yys1045
	} // end for yyj1045
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1050 int
	var yyb1050 bool
	var yyhl1050 bool = l >= 0
	yyj1050++
	if yyhl1050 {
		yyb1050 = yyj1050 > l
	} else {
		yyb1050 = r.CheckBreak()
	}
	if yyb1050 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1050++
	if yyhl1050 {
		yyb1050 = yyj1050 > l
	} else {
		yyb1050 = r.CheckBreak()
	}
	if yyb1050 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1050++
	if yyhl1050 {
		yyb1050 = yyj1050 > l
	} else {
		yyb1050 = r.CheckBreak()
	}
	if yyb1050 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv1053 := &x.ObjectMeta
		yyv1053.CodecDecodeSelf(d)
	}
	yyj1050++
	if yyhl1050 {
		yyb1050 = yyj1050 > l
	} else {
		yyb1050 = r.CheckBreak()
	}
	if yyb1050 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ClusterAutoscalerSpec{}
	} else {
		yyv1054 := &x.Spec
		yyv1054.CodecDecodeSelf(d)
	}
	for {
		yyj1050++
		if yyhl1050 {
			yyb1050 = yyj1050 > l
		} else {
			yyb1050 = r.CheckBreak()
		}
		if yyb1050 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1050-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1055 := z.EncBinary()
		_ = yym1055
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1056 := !z.EncBinary()
			yy2arr1056 := z.EncBasicHandle().StructToArray
			var yyq1056 [4]bool
			_, _, _ = yysep1056, yyq1056, yy2arr1056
			const yyr1056 bool = false
			yyq1056[0] = x.Kind != ""
			yyq1056[1] = x.APIVersion != ""
			yyq1056[2] = true
			var yynn1056 int
			if yyr1056 || yy2arr1056 {
				r.EncodeArrayStart(4)
			} else {
				yynn1056 = 1
				for _, b := range yyq1056 {
					if b {
						yynn1056++
					}
				}
				r.EncodeMapStart(yynn1056)
				yynn1056 = 0
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1056[0] {
					yym1058 := z.EncBinary()
					_ = yym1058
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1056[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1059 := z.EncBinary()
					_ = yym1059
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1056[1] {
					yym1061 := z.EncBinary()
					_ = yym1061
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1056[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1062 := z.EncBinary()
					_ = yym1062
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1056[2] {
					yy1064 := &x.ListMeta
					yym1065 := z.EncBinary()
					_ = yym1065
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1064) {
					} else {
						z.EncFallback(yy1064)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1056[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1066 := &x.ListMeta
					yym1067 := z.EncBinary()
					_ = yym1067
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1066) {
					} else {
						z.EncFallback(yy1066)
					}
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1069 := z.EncBinary()
					_ = yym1069
					if false {
					} else {
						h.encSliceClusterAutoscaler(([]ClusterAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1070 := z.EncBinary()
					_ = yym1070
					if false {
					} else {
						h.encSliceClusterAutoscaler(([]ClusterAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1071 := z.DecBinary()
	_ = yym1071
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1072 := r.ContainerType()
		if yyct1072 == codecSelferValueTypeMap1234 {
			yyl1072 := r.ReadMapStart()
			if yyl1072 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1072, d)
			}
		} else if yyct1072 == codecSelferValueTypeArray1234 {
			yyl1072 := r.ReadArrayStart()
			if yyl1072 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1072, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1073Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1073Slc
	var yyhl1073 bool = l >= 0
	for yyj1073 := 0; ; yyj1073++ {
		if yyhl1073 {
			if yyj1073 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1073Slc = r.DecodeBytes(yys1073Slc, true, true)
		yys1073 := string(yys1073Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1073 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1076 := &x.ListMeta
				yym1077 := z.DecBinary()
				_ = yym1077
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1076) {
				} else {
					z.DecFallback(yyv1076, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1078 := &x.Items
				yym1079 := z.DecBinary()
				_ = yym1079
				if false {
				} else {
					h.decSliceClusterAutoscaler((*[]ClusterAutoscaler)(yyv1078), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1073)
		} // end switch yys1073
	} // end for yyj1073
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1080 int
	var yyb1080 bool
	var yyhl1080 bool = l >= 0
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1083 := &x.ListMeta
		yym1084 := z.DecBinary()
		_ = yym1084
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1083) {
		} else {
			z.DecFallback(yyv1083, false)
		}
	}
	yyj1080++
	if yyhl1080 {
		yyb1080 = yyj1080 > l
	} else {
		yyb1080 = r.CheckBreak()
	}
	if yyb1080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1085 := &x.Items
		yym1086 := z.DecBinary()
		_ = yym1086
		if false {
		} else {
			h.decSliceClusterAutoscaler((*[]ClusterAutoscaler)(yyv1085), d)
		}
	}
	for {
		yyj1080++
		if yyhl1080 {
			yyb1080 = yyj1080 > l
		} else {
			yyb1080 = r.CheckBreak()
		}
		if yyb1080 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1080-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1087 := z.EncBinary()
		_ = yym1087
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1088 := !z.EncBinary()
			yy2arr1088 := z.EncBasicHandle().StructToArray
			var yyq1088 [2]bool
			_, _, _ = yysep1088, yyq1088, yy2arr1088
			const yyr1088 bool = false
			yyq1088[0] = len(x.MatchLabels) != 0
			yyq1088[1] = len(x.MatchExpressions) != 0
			var yynn1088 int
			if yyr1088 || yy2arr1088 {
				r.EncodeArrayStart(2)
			} else {
				yynn1088 = 0
				for _, b := range yyq1088 {
					if b {
						yynn1088++
					}
				}
				r.EncodeMapStart(yynn1088)
				yynn1088 = 0
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1088[0] {
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1090 := z.EncBinary()
						_ = yym1090
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1088[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchLabels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1091 := z.EncBinary()
						_ = yym1091
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				}
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1088[1] {
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1093 := z.EncBinary()
						_ = yym1093
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1088[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1094 := z.EncBinary()
						_ = yym1094
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				}
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1095 := z.DecBinary()
	_ = yym1095
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1096 := r.ContainerType()
		if yyct1096 == codecSelferValueTypeMap1234 {
			yyl1096 := r.ReadMapStart()
			if yyl1096 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1096, d)
			}
		} else if yyct1096 == codecSelferValueTypeArray1234 {
			yyl1096 := r.ReadArrayStart()
			if yyl1096 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1096, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1097Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1097Slc
	var yyhl1097 bool = l >= 0
	for yyj1097 := 0; ; yyj1097++ {
		if yyhl1097 {
			if yyj1097 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1097Slc = r.DecodeBytes(yys1097Slc, true, true)
		yys1097 := string(yys1097Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1097 {
		case "matchLabels":
			if r.TryDecodeAsNil() {
				x.MatchLabels = nil
			} else {
				yyv1098 := &x.MatchLabels
				yym1099 := z.DecBinary()
				_ = yym1099
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1098, false, d)
				}
			}
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1100 := &x.MatchExpressions
				yym1101 := z.DecBinary()
				_ = yym1101
				if false {
				} else {
					h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1100), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1097)
		} // end switch yys1097
	} // end for yyj1097
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1102 int
	var yyb1102 bool
	var yyhl1102 bool = l >= 0
	yyj1102++
	if yyhl1102 {
		yyb1102 = yyj1102 > l
	} else {
		yyb1102 = r.CheckBreak()
	}
	if yyb1102 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchLabels = nil
	} else {
		yyv1103 := &x.MatchLabels
		yym1104 := z.DecBinary()
		_ = yym1104
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1103, false, d)
		}
	}
	yyj1102++
	if yyhl1102 {
		yyb1102 = yyj1102 > l
	} else {
		yyb1102 = r.CheckBreak()
	}
	if yyb1102 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1105 := &x.MatchExpressions
		yym1106 := z.DecBinary()
		_ = yym1106
		if false {
		} else {
			h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1105), d)
		}
	}
	for {
		yyj1102++
		if yyhl1102 {
			yyb1102 = yyj1102 > l
		} else {
			yyb1102 = r.CheckBreak()
		}
		if yyb1102 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1102-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1107 := z.EncBinary()
		_ = yym1107
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1108 := !z.EncBinary()
			yy2arr1108 := z.EncBasicHandle().StructToArray
			var yyq1108 [3]bool
			_, _, _ = yysep1108, yyq1108, yy2arr1108
			const yyr1108 bool = false
			yyq1108[2] = len(x.Values) != 0
			var yynn1108 int
			if yyr1108 || yy2arr1108 {
				r.EncodeArrayStart(3)
			} else {
				yynn1108 = 2
				for _, b := range yyq1108 {
					if b {
						yynn1108++
					}
				}
				r.EncodeMapStart(yynn1108)
				yynn1108 = 0
			}
			if yyr1108 || yy2arr1108 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1110 := z.EncBinary()
				_ = yym1110
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1111 := z.EncBinary()
				_ = yym1111
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1108 || yy2arr1108 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1108 || yy2arr1108 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1108[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1114 := z.EncBinary()
						_ = yym1114
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1108[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1115 := z.EncBinary()
						_ = yym1115
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1108 || yy2arr1108 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1116 := z.DecBinary()
	_ = yym1116
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1117 := r.ContainerType()
		if yyct1117 == codecSelferValueTypeMap1234 {
			yyl1117 := r.ReadMapStart()
			if yyl1117 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1117, d)
			}
		} else if yyct1117 == codecSelferValueTypeArray1234 {
			yyl1117 := r.ReadArrayStart()
			if yyl1117 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1117, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1118Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1118Slc
	var yyhl1118 bool = l >= 0
	for yyj1118 := 0; ; yyj1118++ {
		if yyhl1118 {
			if yyj1118 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1118Slc = r.DecodeBytes(yys1118Slc, true, true)
		yys1118 := string(yys1118Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1118 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = LabelSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1121 := &x.Values
				yym1122 := z.DecBinary()
				_ = yym1122
				if false {
				} else {
					z.F.DecSliceStringX(yyv1121, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1118)
		} // end switch yys1118
	} // end for yyj1118
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1123 int
	var yyb1123 bool
	var yyhl1123 bool = l >= 0
	yyj1123++
	if yyhl1123 {
		yyb1123 = yyj1123 > l
	} else {
		yyb1123 = r.CheckBreak()
	}
	if yyb1123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1123++
	if yyhl1123 {
		yyb1123 = yyj1123 > l
	} else {
		yyb1123 = r.CheckBreak()
	}
	if yyb1123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = LabelSelectorOperator(r.DecodeString())
	}
	yyj1123++
	if yyhl1123 {
		yyb1123 = yyj1123 > l
	} else {
		yyb1123 = r.CheckBreak()
	}
	if yyb1123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1126 := &x.Values
		yym1127 := z.DecBinary()
		_ = yym1127
		if false {
		} else {
			z.F.DecSliceStringX(yyv1126, false, d)
		}
	}
	for {
		yyj1123++
		if yyhl1123 {
			yyb1123 = yyj1123 > l
		} else {
			yyb1123 = r.CheckBreak()
		}
		if yyb1123 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1123-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LabelSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1128 := z.EncBinary()
	_ = yym1128
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LabelSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1129 := z.DecBinary()
	_ = yym1129
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ConfigMap) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1130 := z.EncBinary()
		_ = yym1130
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1131 := !z.EncBinary()
			yy2arr1131 := z.EncBasicHandle().StructToArray
			var yyq1131 [4]bool
			_, _, _ = yysep1131, yyq1131, yy2arr1131
			const yyr1131 bool = false
			yyq1131[0] = x.Kind != ""
			yyq1131[1] = x.APIVersion != ""
			yyq1131[2] = true
			yyq1131[3] = len(x.Data) != 0
			var yynn1131 int
			if yyr1131 || yy2arr1131 {
				r.EncodeArrayStart(4)
			} else {
				yynn1131 = 0
				for _, b := range yyq1131 {
					if b {
						yynn1131++
					}
				}
				r.EncodeMapStart(yynn1131)
				yynn1131 = 0
			}
			if yyr1131 || yy2arr1131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1131[0] {
					yym1133 := z.EncBinary()
					_ = yym1133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1131[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1134 := z.EncBinary()
					_ = yym1134
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1131 || yy2arr1131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1131[1] {
					yym1136 := z.EncBinary()
					_ = yym1136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1131[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1137 := z.EncBinary()
					_ = yym1137
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1131 || yy2arr1131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1131[2] {
					yy1139 := &x.ObjectMeta
					yy1139.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1131[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1140 := &x.ObjectMeta
					yy1140.CodecEncodeSelf(e)
				}
			}
			if yyr1131 || yy2arr1131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1131[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym1142 := z.EncBinary()
						_ = yym1142
						if false {
						} else {
							z.F.EncMapStringStringV(x.Data, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1131[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym1143 := z.EncBinary()
						_ = yym1143
						if false {
						} else {
							z.F.EncMapStringStringV(x.Data, false, e)
						}
					}
				}
			}
			if yyr1131 || yy2arr1131 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMap) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1144 := z.DecBinary()
	_ = yym1144
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1145 := r.ContainerType()
		if yyct1145 == codecSelferValueTypeMap1234 {
			yyl1145 := r.ReadMapStart()
			if yyl1145 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1145, d)
			}
		} else if yyct1145 == codecSelferValueTypeArray1234 {
			yyl1145 := r.ReadArrayStart()
			if yyl1145 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1145, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMap) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1146Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1146Slc
	var yyhl1146 bool = l >= 0
	for yyj1146 := 0; ; yyj1146++ {
		if yyhl1146 {
			if yyj1146 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1146Slc = r.DecodeBytes(yys1146Slc, true, true)
		yys1146 := string(yys1146Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1146 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv1149 := &x.ObjectMeta
				yyv1149.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv1150 := &x.Data
				yym1151 := z.DecBinary()
				_ = yym1151
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1150, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1146)
		} // end switch yys1146
	} // end for yyj1146
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMap) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1152 int
	var yyb1152 bool
	var yyhl1152 bool = l >= 0
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv1155 := &x.ObjectMeta
		yyv1155.CodecDecodeSelf(d)
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv1156 := &x.Data
		yym1157 := z.DecBinary()
		_ = yym1157
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1156, false, d)
		}
	}
	for {
		yyj1152++
		if yyhl1152 {
			yyb1152 = yyj1152 > l
		} else {
			yyb1152 = r.CheckBreak()
		}
		if yyb1152 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1152-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1158 := z.EncBinary()
		_ = yym1158
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1159 := !z.EncBinary()
			yy2arr1159 := z.EncBasicHandle().StructToArray
			var yyq1159 [4]bool
			_, _, _ = yysep1159, yyq1159, yy2arr1159
			const yyr1159 bool = false
			yyq1159[0] = x.Kind != ""
			yyq1159[1] = x.APIVersion != ""
			yyq1159[2] = true
			yyq1159[3] = len(x.Items) != 0
			var yynn1159 int
			if yyr1159 || yy2arr1159 {
				r.EncodeArrayStart(4)
			} else {
				yynn1159 = 0
				for _, b := range yyq1159 {
					if b {
						yynn1159++
					}
				}
				r.EncodeMapStart(yynn1159)
				yynn1159 = 0
			}
			if yyr1159 || yy2arr1159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1159[0] {
					yym1161 := z.EncBinary()
					_ = yym1161
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1159[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1162 := z.EncBinary()
					_ = yym1162
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1159 || yy2arr1159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1159[1] {
					yym1164 := z.EncBinary()
					_ = yym1164
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1159[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1165 := z.EncBinary()
					_ = yym1165
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1159 || yy2arr1159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1159[2] {
					yy1167 := &x.ListMeta
					yym1168 := z.EncBinary()
					_ = yym1168
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1167) {
					} else {
						z.EncFallback(yy1167)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1159[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1169 := &x.ListMeta
					yym1170 := z.EncBinary()
					_ = yym1170
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1169) {
					} else {
						z.EncFallback(yy1169)
					}
				}
			}
			if yyr1159 || yy2arr1159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1159[3] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1172 := z.EncBinary()
						_ = yym1172
						if false {
						} else {
							h.encSliceConfigMap(([]ConfigMap)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1159[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1173 := z.EncBinary()
						_ = yym1173
						if false {
						} else {
							h.encSliceConfigMap(([]ConfigMap)(x.Items), e)
						}
					}
				}
			}
			if yyr1159 || yy2arr1159 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1174 := z.DecBinary()
	_ = yym1174
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1175 := r.ContainerType()
		if yyct1175 == codecSelferValueTypeMap1234 {
			yyl1175 := r.ReadMapStart()
			if yyl1175 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1175, d)
			}
		} else if yyct1175 == codecSelferValueTypeArray1234 {
			yyl1175 := r.ReadArrayStart()
			if yyl1175 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1175, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1176Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1176Slc
	var yyhl1176 bool = l >= 0
	for yyj1176 := 0; ; yyj1176++ {
		if yyhl1176 {
			if yyj1176 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1176Slc = r.DecodeBytes(yys1176Slc, true, true)
		yys1176 := string(yys1176Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1176 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1179 := &x.ListMeta
				yym1180 := z.DecBinary()
				_ = yym1180
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1179) {
				} else {
					z.DecFallback(yyv1179, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1181 := &x.Items
				yym1182 := z.DecBinary()
				_ = yym1182
				if false {
				} else {
					h.decSliceConfigMap((*[]ConfigMap)(yyv1181), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1176)
		} // end switch yys1176
	} // end for yyj1176
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1183 int
	var yyb1183 bool
	var yyhl1183 bool = l >= 0
	yyj1183++
	if yyhl1183 {
		yyb1183 = yyj1183 > l
	} else {
		yyb1183 = r.CheckBreak()
	}
	if yyb1183 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1183++
	if yyhl1183 {
		yyb1183 = yyj1183 > l
	} else {
		yyb1183 = r.CheckBreak()
	}
	if yyb1183 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1183++
	if yyhl1183 {
		yyb1183 = yyj1183 > l
	} else {
		yyb1183 = r.CheckBreak()
	}
	if yyb1183 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1186 := &x.ListMeta
		yym1187 := z.DecBinary()
		_ = yym1187
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1186) {
		} else {
			z.DecFallback(yyv1186, false)
		}
	}
	yyj1183++
	if yyhl1183 {
		yyb1183 = yyj1183 > l
	} else {
		yyb1183 = r.CheckBreak()
	}
	if yyb1183 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1188 := &x.Items
		yym1189 := z.DecBinary()
		_ = yym1189
		if false {
		} else {
			h.decSliceConfigMap((*[]ConfigMap)(yyv1188), d)
		}
	}
	for {
		yyj1183++
		if yyhl1183 {
			yyb1183 = yyj1183 > l
		} else {
			yyb1183 = r.CheckBreak()
		}
		if yyb1183 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1183-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1190 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1191 := &yyv1190
		yy1191.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1192 := *v
	yyh1192, yyl1192 := z.DecSliceHelperStart()
	var yyc1192 bool
	if yyl1192 == 0 {
		if yyv1192 == nil {
			yyv1192 = []HorizontalPodAutoscaler{}
			yyc1192 = true
		} else if len(yyv1192) != 0 {
			yyv1192 = yyv1192[:0]
			yyc1192 = true
		}
	} else if yyl1192 > 0 {
		var yyrr1192, yyrl1192 int
		var yyrt1192 bool
		if yyl1192 > cap(yyv1192) {

			yyrg1192 := len(yyv1192) > 0
			yyv21192 := yyv1192
			yyrl1192, yyrt1192 = z.DecInferLen(yyl1192, z.DecBasicHandle().MaxInitLen, 320)
			if yyrt1192 {
				if yyrl1192 <= cap(yyv1192) {
					yyv1192 = yyv1192[:yyrl1192]
				} else {
					yyv1192 = make([]HorizontalPodAutoscaler, yyrl1192)
				}
			} else {
				yyv1192 = make([]HorizontalPodAutoscaler, yyrl1192)
			}
			yyc1192 = true
			yyrr1192 = len(yyv1192)
			if yyrg1192 {
				copy(yyv1192, yyv21192)
			}
		} else if yyl1192 != len(yyv1192) {
			yyv1192 = yyv1192[:yyl1192]
			yyc1192 = true
		}
		yyj1192 := 0
		for ; yyj1192 < yyrr1192; yyj1192++ {
			yyh1192.ElemContainerState(yyj1192)
			if r.TryDecodeAsNil() {
				yyv1192[yyj1192] = HorizontalPodAutoscaler{}
			} else {
				yyv1193 := &yyv1192[yyj1192]
				yyv1193.CodecDecodeSelf(d)
			}

		}
		if yyrt1192 {
			for ; yyj1192 < yyl1192; yyj1192++ {
				yyv1192 = append(yyv1192, HorizontalPodAutoscaler{})
				yyh1192.ElemContainerState(yyj1192)
				if r.TryDecodeAsNil() {
					yyv1192[yyj1192] = HorizontalPodAutoscaler{}
				} else {
					yyv1194 := &yyv1192[yyj1192]
					yyv1194.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1192 := 0
		for ; !r.CheckBreak(); yyj1192++ {

			if yyj1192 >= len(yyv1192) {
				yyv1192 = append(yyv1192, HorizontalPodAutoscaler{}) // var yyz1192 HorizontalPodAutoscaler
				yyc1192 = true
			}
			yyh1192.ElemContainerState(yyj1192)
			if yyj1192 < len(yyv1192) {
				if r.TryDecodeAsNil() {
					yyv1192[yyj1192] = HorizontalPodAutoscaler{}
				} else {
					yyv1195 := &yyv1192[yyj1192]
					yyv1195.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1192 < len(yyv1192) {
			yyv1192 = yyv1192[:yyj1192]
			yyc1192 = true
		} else if yyj1192 == 0 && yyv1192 == nil {
			yyv1192 = []HorizontalPodAutoscaler{}
			yyc1192 = true
		}
	}
	yyh1192.End()
	if yyc1192 {
		*v = yyv1192
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1196 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1197 := &yyv1196
		yy1197.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1198 := *v
	yyh1198, yyl1198 := z.DecSliceHelperStart()
	var yyc1198 bool
	if yyl1198 == 0 {
		if yyv1198 == nil {
			yyv1198 = []APIVersion{}
			yyc1198 = true
		} else if len(yyv1198) != 0 {
			yyv1198 = yyv1198[:0]
			yyc1198 = true
		}
	} else if yyl1198 > 0 {
		var yyrr1198, yyrl1198 int
		var yyrt1198 bool
		if yyl1198 > cap(yyv1198) {

			yyrg1198 := len(yyv1198) > 0
			yyv21198 := yyv1198
			yyrl1198, yyrt1198 = z.DecInferLen(yyl1198, z.DecBasicHandle().MaxInitLen, 32)
			if yyrt1198 {
				if yyrl1198 <= cap(yyv1198) {
					yyv1198 = yyv1198[:yyrl1198]
				} else {
					yyv1198 = make([]APIVersion, yyrl1198)
				}
			} else {
				yyv1198 = make([]APIVersion, yyrl1198)
			}
			yyc1198 = true
			yyrr1198 = len(yyv1198)
			if yyrg1198 {
				copy(yyv1198, yyv21198)
			}
		} else if yyl1198 != len(yyv1198) {
			yyv1198 = yyv1198[:yyl1198]
			yyc1198 = true
		}
		yyj1198 := 0
		for ; yyj1198 < yyrr1198; yyj1198++ {
			yyh1198.ElemContainerState(yyj1198)
			if r.TryDecodeAsNil() {
				yyv1198[yyj1198] = APIVersion{}
			} else {
				yyv1199 := &yyv1198[yyj1198]
				yyv1199.CodecDecodeSelf(d)
			}

		}
		if yyrt1198 {
			for ; yyj1198 < yyl1198; yyj1198++ {
				yyv1198 = append(yyv1198, APIVersion{})
				yyh1198.ElemContainerState(yyj1198)
				if r.TryDecodeAsNil() {
					yyv1198[yyj1198] = APIVersion{}
				} else {
					yyv1200 := &yyv1198[yyj1198]
					yyv1200.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1198 := 0
		for ; !r.CheckBreak(); yyj1198++ {

			if yyj1198 >= len(yyv1198) {
				yyv1198 = append(yyv1198, APIVersion{}) // var yyz1198 APIVersion
				yyc1198 = true
			}
			yyh1198.ElemContainerState(yyj1198)
			if yyj1198 < len(yyv1198) {
				if r.TryDecodeAsNil() {
					yyv1198[yyj1198] = APIVersion{}
				} else {
					yyv1201 := &yyv1198[yyj1198]
					yyv1201.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1198 < len(yyv1198) {
			yyv1198 = yyv1198[:yyj1198]
			yyc1198 = true
		} else if yyj1198 == 0 && yyv1198 == nil {
			yyv1198 = []APIVersion{}
			yyc1198 = true
		}
	}
	yyh1198.End()
	if yyc1198 {
		*v = yyv1198
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1202 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1203 := &yyv1202
		yy1203.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1204 := *v
	yyh1204, yyl1204 := z.DecSliceHelperStart()
	var yyc1204 bool
	if yyl1204 == 0 {
		if yyv1204 == nil {
			yyv1204 = []ThirdPartyResource{}
			yyc1204 = true
		} else if len(yyv1204) != 0 {
			yyv1204 = yyv1204[:0]
			yyc1204 = true
		}
	} else if yyl1204 > 0 {
		var yyrr1204, yyrl1204 int
		var yyrt1204 bool
		if yyl1204 > cap(yyv1204) {

			yyrg1204 := len(yyv1204) > 0
			yyv21204 := yyv1204
			yyrl1204, yyrt1204 = z.DecInferLen(yyl1204, z.DecBasicHandle().MaxInitLen, 232)
			if yyrt1204 {
				if yyrl1204 <= cap(yyv1204) {
					yyv1204 = yyv1204[:yyrl1204]
				} else {
					yyv1204 = make([]ThirdPartyResource, yyrl1204)
				}
			} else {
				yyv1204 = make([]ThirdPartyResource, yyrl1204)
			}
			yyc1204 = true
			yyrr1204 = len(yyv1204)
			if yyrg1204 {
				copy(yyv1204, yyv21204)
			}
		} else if yyl1204 != len(yyv1204) {
			yyv1204 = yyv1204[:yyl1204]
			yyc1204 = true
		}
		yyj1204 := 0
		for ; yyj1204 < yyrr1204; yyj1204++ {
			yyh1204.ElemContainerState(yyj1204)
			if r.TryDecodeAsNil() {
				yyv1204[yyj1204] = ThirdPartyResource{}
			} else {
				yyv1205 := &yyv1204[yyj1204]
				yyv1205.CodecDecodeSelf(d)
			}

		}
		if yyrt1204 {
			for ; yyj1204 < yyl1204; yyj1204++ {
				yyv1204 = append(yyv1204, ThirdPartyResource{})
				yyh1204.ElemContainerState(yyj1204)
				if r.TryDecodeAsNil() {
					yyv1204[yyj1204] = ThirdPartyResource{}
				} else {
					yyv1206 := &yyv1204[yyj1204]
					yyv1206.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1204 := 0
		for ; !r.CheckBreak(); yyj1204++ {

			if yyj1204 >= len(yyv1204) {
				yyv1204 = append(yyv1204, ThirdPartyResource{}) // var yyz1204 ThirdPartyResource
				yyc1204 = true
			}
			yyh1204.ElemContainerState(yyj1204)
			if yyj1204 < len(yyv1204) {
				if r.TryDecodeAsNil() {
					yyv1204[yyj1204] = ThirdPartyResource{}
				} else {
					yyv1207 := &yyv1204[yyj1204]
					yyv1207.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1204 < len(yyv1204) {
			yyv1204 = yyv1204[:yyj1204]
			yyc1204 = true
		} else if yyj1204 == 0 && yyv1204 == nil {
			yyv1204 = []ThirdPartyResource{}
			yyc1204 = true
		}
	}
	yyh1204.End()
	if yyc1204 {
		*v = yyv1204
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1208 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1209 := &yyv1208
		yy1209.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1210 := *v
	yyh1210, yyl1210 := z.DecSliceHelperStart()
	var yyc1210 bool
	if yyl1210 == 0 {
		if yyv1210 == nil {
			yyv1210 = []Deployment{}
			yyc1210 = true
		} else if len(yyv1210) != 0 {
			yyv1210 = yyv1210[:0]
			yyc1210 = true
		}
	} else if yyl1210 > 0 {
		var yyrr1210, yyrl1210 int
		var yyrt1210 bool
		if yyl1210 > cap(yyv1210) {

			yyrg1210 := len(yyv1210) > 0
			yyv21210 := yyv1210
			yyrl1210, yyrt1210 = z.DecInferLen(yyl1210, z.DecBasicHandle().MaxInitLen, 592)
			if yyrt1210 {
				if yyrl1210 <= cap(yyv1210) {
					yyv1210 = yyv1210[:yyrl1210]
				} else {
					yyv1210 = make([]Deployment, yyrl1210)
				}
			} else {
				yyv1210 = make([]Deployment, yyrl1210)
			}
			yyc1210 = true
			yyrr1210 = len(yyv1210)
			if yyrg1210 {
				copy(yyv1210, yyv21210)
			}
		} else if yyl1210 != len(yyv1210) {
			yyv1210 = yyv1210[:yyl1210]
			yyc1210 = true
		}
		yyj1210 := 0
		for ; yyj1210 < yyrr1210; yyj1210++ {
			yyh1210.ElemContainerState(yyj1210)
			if r.TryDecodeAsNil() {
				yyv1210[yyj1210] = Deployment{}
			} else {
				yyv1211 := &yyv1210[yyj1210]
				yyv1211.CodecDecodeSelf(d)
			}

		}
		if yyrt1210 {
			for ; yyj1210 < yyl1210; yyj1210++ {
				yyv1210 = append(yyv1210, Deployment{})
				yyh1210.ElemContainerState(yyj1210)
				if r.TryDecodeAsNil() {
					yyv1210[yyj1210] = Deployment{}
				} else {
					yyv1212 := &yyv1210[yyj1210]
					yyv1212.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1210 := 0
		for ; !r.CheckBreak(); yyj1210++ {

			if yyj1210 >= len(yyv1210) {
				yyv1210 = append(yyv1210, Deployment{}) // var yyz1210 Deployment
				yyc1210 = true
			}
			yyh1210.ElemContainerState(yyj1210)
			if yyj1210 < len(yyv1210) {
				if r.TryDecodeAsNil() {
					yyv1210[yyj1210] = Deployment{}
				} else {
					yyv1213 := &yyv1210[yyj1210]
					yyv1213.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1210 < len(yyv1210) {
			yyv1210 = yyv1210[:yyj1210]
			yyc1210 = true
		} else if yyj1210 == 0 && yyv1210 == nil {
			yyv1210 = []Deployment{}
			yyc1210 = true
		}
	}
	yyh1210.End()
	if yyc1210 {
		*v = yyv1210
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1214 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1215 := &yyv1214
		yy1215.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1216 := *v
	yyh1216, yyl1216 := z.DecSliceHelperStart()
	var yyc1216 bool
	if yyl1216 == 0 {
		if yyv1216 == nil {
			yyv1216 = []DaemonSet{}
			yyc1216 = true
		} else if len(yyv1216) != 0 {
			yyv1216 = yyv1216[:0]
			yyc1216 = true
		}
	} else if yyl1216 > 0 {
		var yyrr1216, yyrl1216 int
		var yyrt1216 bool
		if yyl1216 > cap(yyv1216) {

			yyrg1216 := len(yyv1216) > 0
			yyv21216 := yyv1216
			yyrl1216, yyrt1216 = z.DecInferLen(yyl1216, z.DecBasicHandle().MaxInitLen, 232)
			if yyrt1216 {
				if yyrl1216 <= cap(yyv1216) {
					yyv1216 = yyv1216[:yyrl1216]
				} else {
					yyv1216 = make([]DaemonSet, yyrl1216)
				}
			} else {
				yyv1216 = make([]DaemonSet, yyrl1216)
			}
			yyc1216 = true
			yyrr1216 = len(yyv1216)
			if yyrg1216 {
				copy(yyv1216, yyv21216)
			}
		} else if yyl1216 != len(yyv1216) {
			yyv1216 = yyv1216[:yyl1216]
			yyc1216 = true
		}
		yyj1216 := 0
		for ; yyj1216 < yyrr1216; yyj1216++ {
			yyh1216.ElemContainerState(yyj1216)
			if r.TryDecodeAsNil() {
				yyv1216[yyj1216] = DaemonSet{}
			} else {
				yyv1217 := &yyv1216[yyj1216]
				yyv1217.CodecDecodeSelf(d)
			}

		}
		if yyrt1216 {
			for ; yyj1216 < yyl1216; yyj1216++ {
				yyv1216 = append(yyv1216, DaemonSet{})
				yyh1216.ElemContainerState(yyj1216)
				if r.TryDecodeAsNil() {
					yyv1216[yyj1216] = DaemonSet{}
				} else {
					yyv1218 := &yyv1216[yyj1216]
					yyv1218.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1216 := 0
		for ; !r.CheckBreak(); yyj1216++ {

			if yyj1216 >= len(yyv1216) {
				yyv1216 = append(yyv1216, DaemonSet{}) // var yyz1216 DaemonSet
				yyc1216 = true
			}
			yyh1216.ElemContainerState(yyj1216)
			if yyj1216 < len(yyv1216) {
				if r.TryDecodeAsNil() {
					yyv1216[yyj1216] = DaemonSet{}
				} else {
					yyv1219 := &yyv1216[yyj1216]
					yyv1219.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1216 < len(yyv1216) {
			yyv1216 = yyv1216[:yyj1216]
			yyc1216 = true
		} else if yyj1216 == 0 && yyv1216 == nil {
			yyv1216 = []DaemonSet{}
			yyc1216 = true
		}
	}
	yyh1216.End()
	if yyc1216 {
		*v = yyv1216
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1220 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1221 := &yyv1220
		yy1221.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1222 := *v
	yyh1222, yyl1222 := z.DecSliceHelperStart()
	var yyc1222 bool
	if yyl1222 == 0 {
		if yyv1222 == nil {
			yyv1222 = []ThirdPartyResourceData{}
			yyc1222 = true
		} else if len(yyv1222) != 0 {
			yyv1222 = yyv1222[:0]
			yyc1222 = true
		}
	} else if yyl1222 > 0 {
		var yyrr1222, yyrl1222 int
		var yyrt1222 bool
		if yyl1222 > cap(yyv1222) {

			yyrg1222 := len(yyv1222) > 0
			yyv21222 := yyv1222
			yyrl1222, yyrt1222 = z.DecInferLen(yyl1222, z.DecBasicHandle().MaxInitLen, 216)
			if yyrt1222 {
				if yyrl1222 <= cap(yyv1222) {
					yyv1222 = yyv1222[:yyrl1222]
				} else {
					yyv1222 = make([]ThirdPartyResourceData, yyrl1222)
				}
			} else {
				yyv1222 = make([]ThirdPartyResourceData, yyrl1222)
			}
			yyc1222 = true
			yyrr1222 = len(yyv1222)
			if yyrg1222 {
				copy(yyv1222, yyv21222)
			}
		} else if yyl1222 != len(yyv1222) {
			yyv1222 = yyv1222[:yyl1222]
			yyc1222 = true
		}
		yyj1222 := 0
		for ; yyj1222 < yyrr1222; yyj1222++ {
			yyh1222.ElemContainerState(yyj1222)
			if r.TryDecodeAsNil() {
				yyv1222[yyj1222] = ThirdPartyResourceData{}
			} else {
				yyv1223 := &yyv1222[yyj1222]
				yyv1223.CodecDecodeSelf(d)
			}

		}
		if yyrt1222 {
			for ; yyj1222 < yyl1222; yyj1222++ {
				yyv1222 = append(yyv1222, ThirdPartyResourceData{})
				yyh1222.ElemContainerState(yyj1222)
				if r.TryDecodeAsNil() {
					yyv1222[yyj1222] = ThirdPartyResourceData{}
				} else {
					yyv1224 := &yyv1222[yyj1222]
					yyv1224.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1222 := 0
		for ; !r.CheckBreak(); yyj1222++ {

			if yyj1222 >= len(yyv1222) {
				yyv1222 = append(yyv1222, ThirdPartyResourceData{}) // var yyz1222 ThirdPartyResourceData
				yyc1222 = true
			}
			yyh1222.ElemContainerState(yyj1222)
			if yyj1222 < len(yyv1222) {
				if r.TryDecodeAsNil() {
					yyv1222[yyj1222] = ThirdPartyResourceData{}
				} else {
					yyv1225 := &yyv1222[yyj1222]
					yyv1225.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1222 < len(yyv1222) {
			yyv1222 = yyv1222[:yyj1222]
			yyc1222 = true
		} else if yyj1222 == 0 && yyv1222 == nil {
			yyv1222 = []ThirdPartyResourceData{}
			yyc1222 = true
		}
	}
	yyh1222.End()
	if yyc1222 {
		*v = yyv1222
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1226 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1227 := &yyv1226
		yy1227.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1228 := *v
	yyh1228, yyl1228 := z.DecSliceHelperStart()
	var yyc1228 bool
	if yyl1228 == 0 {
		if yyv1228 == nil {
			yyv1228 = []Job{}
			yyc1228 = true
		} else if len(yyv1228) != 0 {
			yyv1228 = yyv1228[:0]
			yyc1228 = true
		}
	} else if yyl1228 > 0 {
		var yyrr1228, yyrl1228 int
		var yyrt1228 bool
		if yyl1228 > cap(yyv1228) {

			yyrg1228 := len(yyv1228) > 0
			yyv21228 := yyv1228
			yyrl1228, yyrt1228 = z.DecInferLen(yyl1228, z.DecBasicHandle().MaxInitLen, 616)
			if yyrt1228 {
				if yyrl1228 <= cap(yyv1228) {
					yyv1228 = yyv1228[:yyrl1228]
				} else {
					yyv1228 = make([]Job, yyrl1228)
				}
			} else {
				yyv1228 = make([]Job, yyrl1228)
			}
			yyc1228 = true
			yyrr1228 = len(yyv1228)
			if yyrg1228 {
				copy(yyv1228, yyv21228)
			}
		} else if yyl1228 != len(yyv1228) {
			yyv1228 = yyv1228[:yyl1228]
			yyc1228 = true
		}
		yyj1228 := 0
		for ; yyj1228 < yyrr1228; yyj1228++ {
			yyh1228.ElemContainerState(yyj1228)
			if r.TryDecodeAsNil() {
				yyv1228[yyj1228] = Job{}
			} else {
				yyv1229 := &yyv1228[yyj1228]
				yyv1229.CodecDecodeSelf(d)
			}

		}
		if yyrt1228 {
			for ; yyj1228 < yyl1228; yyj1228++ {
				yyv1228 = append(yyv1228, Job{})
				yyh1228.ElemContainerState(yyj1228)
				if r.TryDecodeAsNil() {
					yyv1228[yyj1228] = Job{}
				} else {
					yyv1230 := &yyv1228[yyj1228]
					yyv1230.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1228 := 0
		for ; !r.CheckBreak(); yyj1228++ {

			if yyj1228 >= len(yyv1228) {
				yyv1228 = append(yyv1228, Job{}) // var yyz1228 Job
				yyc1228 = true
			}
			yyh1228.ElemContainerState(yyj1228)
			if yyj1228 < len(yyv1228) {
				if r.TryDecodeAsNil() {
					yyv1228[yyj1228] = Job{}
				} else {
					yyv1231 := &yyv1228[yyj1228]
					yyv1231.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1228 < len(yyv1228) {
			yyv1228 = yyv1228[:yyj1228]
			yyc1228 = true
		} else if yyj1228 == 0 && yyv1228 == nil {
			yyv1228 = []Job{}
			yyc1228 = true
		}
	}
	yyh1228.End()
	if yyc1228 {
		*v = yyv1228
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1232 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1233 := &yyv1232
		yy1233.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1234 := *v
	yyh1234, yyl1234 := z.DecSliceHelperStart()
	var yyc1234 bool
	if yyl1234 == 0 {
		if yyv1234 == nil {
			yyv1234 = []JobCondition{}
			yyc1234 = true
		} else if len(yyv1234) != 0 {
			yyv1234 = yyv1234[:0]
			yyc1234 = true
		}
	} else if yyl1234 > 0 {
		var yyrr1234, yyrl1234 int
		var yyrt1234 bool
		if yyl1234 > cap(yyv1234) {

			yyrg1234 := len(yyv1234) > 0
			yyv21234 := yyv1234
			yyrl1234, yyrt1234 = z.DecInferLen(yyl1234, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1234 {
				if yyrl1234 <= cap(yyv1234) {
					yyv1234 = yyv1234[:yyrl1234]
				} else {
					yyv1234 = make([]JobCondition, yyrl1234)
				}
			} else {
				yyv1234 = make([]JobCondition, yyrl1234)
			}
			yyc1234 = true
			yyrr1234 = len(yyv1234)
			if yyrg1234 {
				copy(yyv1234, yyv21234)
			}
		} else if yyl1234 != len(yyv1234) {
			yyv1234 = yyv1234[:yyl1234]
			yyc1234 = true
		}
		yyj1234 := 0
		for ; yyj1234 < yyrr1234; yyj1234++ {
			yyh1234.ElemContainerState(yyj1234)
			if r.TryDecodeAsNil() {
				yyv1234[yyj1234] = JobCondition{}
			} else {
				yyv1235 := &yyv1234[yyj1234]
				yyv1235.CodecDecodeSelf(d)
			}

		}
		if yyrt1234 {
			for ; yyj1234 < yyl1234; yyj1234++ {
				yyv1234 = append(yyv1234, JobCondition{})
				yyh1234.ElemContainerState(yyj1234)
				if r.TryDecodeAsNil() {
					yyv1234[yyj1234] = JobCondition{}
				} else {
					yyv1236 := &yyv1234[yyj1234]
					yyv1236.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1234 := 0
		for ; !r.CheckBreak(); yyj1234++ {

			if yyj1234 >= len(yyv1234) {
				yyv1234 = append(yyv1234, JobCondition{}) // var yyz1234 JobCondition
				yyc1234 = true
			}
			yyh1234.ElemContainerState(yyj1234)
			if yyj1234 < len(yyv1234) {
				if r.TryDecodeAsNil() {
					yyv1234[yyj1234] = JobCondition{}
				} else {
					yyv1237 := &yyv1234[yyj1234]
					yyv1237.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1234 < len(yyv1234) {
			yyv1234 = yyv1234[:yyj1234]
			yyc1234 = true
		} else if yyj1234 == 0 && yyv1234 == nil {
			yyv1234 = []JobCondition{}
			yyc1234 = true
		}
	}
	yyh1234.End()
	if yyc1234 {
		*v = yyv1234
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1238 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1239 := &yyv1238
		yy1239.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1240 := *v
	yyh1240, yyl1240 := z.DecSliceHelperStart()
	var yyc1240 bool
	if yyl1240 == 0 {
		if yyv1240 == nil {
			yyv1240 = []Ingress{}
			yyc1240 = true
		} else if len(yyv1240) != 0 {
			yyv1240 = yyv1240[:0]
			yyc1240 = true
		}
	} else if yyl1240 > 0 {
		var yyrr1240, yyrl1240 int
		var yyrt1240 bool
		if yyl1240 > cap(yyv1240) {

			yyrg1240 := len(yyv1240) > 0
			yyv21240 := yyv1240
			yyrl1240, yyrt1240 = z.DecInferLen(yyl1240, z.DecBasicHandle().MaxInitLen, 248)
			if yyrt1240 {
				if yyrl1240 <= cap(yyv1240) {
					yyv1240 = yyv1240[:yyrl1240]
				} else {
					yyv1240 = make([]Ingress, yyrl1240)
				}
			} else {
				yyv1240 = make([]Ingress, yyrl1240)
			}
			yyc1240 = true
			yyrr1240 = len(yyv1240)
			if yyrg1240 {
				copy(yyv1240, yyv21240)
			}
		} else if yyl1240 != len(yyv1240) {
			yyv1240 = yyv1240[:yyl1240]
			yyc1240 = true
		}
		yyj1240 := 0
		for ; yyj1240 < yyrr1240; yyj1240++ {
			yyh1240.ElemContainerState(yyj1240)
			if r.TryDecodeAsNil() {
				yyv1240[yyj1240] = Ingress{}
			} else {
				yyv1241 := &yyv1240[yyj1240]
				yyv1241.CodecDecodeSelf(d)
			}

		}
		if yyrt1240 {
			for ; yyj1240 < yyl1240; yyj1240++ {
				yyv1240 = append(yyv1240, Ingress{})
				yyh1240.ElemContainerState(yyj1240)
				if r.TryDecodeAsNil() {
					yyv1240[yyj1240] = Ingress{}
				} else {
					yyv1242 := &yyv1240[yyj1240]
					yyv1242.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1240 := 0
		for ; !r.CheckBreak(); yyj1240++ {

			if yyj1240 >= len(yyv1240) {
				yyv1240 = append(yyv1240, Ingress{}) // var yyz1240 Ingress
				yyc1240 = true
			}
			yyh1240.ElemContainerState(yyj1240)
			if yyj1240 < len(yyv1240) {
				if r.TryDecodeAsNil() {
					yyv1240[yyj1240] = Ingress{}
				} else {
					yyv1243 := &yyv1240[yyj1240]
					yyv1243.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1240 < len(yyv1240) {
			yyv1240 = yyv1240[:yyj1240]
			yyc1240 = true
		} else if yyj1240 == 0 && yyv1240 == nil {
			yyv1240 = []Ingress{}
			yyc1240 = true
		}
	}
	yyh1240.End()
	if yyc1240 {
		*v = yyv1240
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1244 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1245 := &yyv1244
		yy1245.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1246 := *v
	yyh1246, yyl1246 := z.DecSliceHelperStart()
	var yyc1246 bool
	if yyl1246 == 0 {
		if yyv1246 == nil {
			yyv1246 = []IngressRule{}
			yyc1246 = true
		} else if len(yyv1246) != 0 {
			yyv1246 = yyv1246[:0]
			yyc1246 = true
		}
	} else if yyl1246 > 0 {
		var yyrr1246, yyrl1246 int
		var yyrt1246 bool
		if yyl1246 > cap(yyv1246) {

			yyrg1246 := len(yyv1246) > 0
			yyv21246 := yyv1246
			yyrl1246, yyrt1246 = z.DecInferLen(yyl1246, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1246 {
				if yyrl1246 <= cap(yyv1246) {
					yyv1246 = yyv1246[:yyrl1246]
				} else {
					yyv1246 = make([]IngressRule, yyrl1246)
				}
			} else {
				yyv1246 = make([]IngressRule, yyrl1246)
			}
			yyc1246 = true
			yyrr1246 = len(yyv1246)
			if yyrg1246 {
				copy(yyv1246, yyv21246)
			}
		} else if yyl1246 != len(yyv1246) {
			yyv1246 = yyv1246[:yyl1246]
			yyc1246 = true
		}
		yyj1246 := 0
		for ; yyj1246 < yyrr1246; yyj1246++ {
			yyh1246.ElemContainerState(yyj1246)
			if r.TryDecodeAsNil() {
				yyv1246[yyj1246] = IngressRule{}
			} else {
				yyv1247 := &yyv1246[yyj1246]
				yyv1247.CodecDecodeSelf(d)
			}

		}
		if yyrt1246 {
			for ; yyj1246 < yyl1246; yyj1246++ {
				yyv1246 = append(yyv1246, IngressRule{})
				yyh1246.ElemContainerState(yyj1246)
				if r.TryDecodeAsNil() {
					yyv1246[yyj1246] = IngressRule{}
				} else {
					yyv1248 := &yyv1246[yyj1246]
					yyv1248.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1246 := 0
		for ; !r.CheckBreak(); yyj1246++ {

			if yyj1246 >= len(yyv1246) {
				yyv1246 = append(yyv1246, IngressRule{}) // var yyz1246 IngressRule
				yyc1246 = true
			}
			yyh1246.ElemContainerState(yyj1246)
			if yyj1246 < len(yyv1246) {
				if r.TryDecodeAsNil() {
					yyv1246[yyj1246] = IngressRule{}
				} else {
					yyv1249 := &yyv1246[yyj1246]
					yyv1249.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1246 < len(yyv1246) {
			yyv1246 = yyv1246[:yyj1246]
			yyc1246 = true
		} else if yyj1246 == 0 && yyv1246 == nil {
			yyv1246 = []IngressRule{}
			yyc1246 = true
		}
	}
	yyh1246.End()
	if yyc1246 {
		*v = yyv1246
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1250 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1251 := &yyv1250
		yy1251.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1252 := *v
	yyh1252, yyl1252 := z.DecSliceHelperStart()
	var yyc1252 bool
	if yyl1252 == 0 {
		if yyv1252 == nil {
			yyv1252 = []HTTPIngressPath{}
			yyc1252 = true
		} else if len(yyv1252) != 0 {
			yyv1252 = yyv1252[:0]
			yyc1252 = true
		}
	} else if yyl1252 > 0 {
		var yyrr1252, yyrl1252 int
		var yyrt1252 bool
		if yyl1252 > cap(yyv1252) {

			yyrg1252 := len(yyv1252) > 0
			yyv21252 := yyv1252
			yyrl1252, yyrt1252 = z.DecInferLen(yyl1252, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1252 {
				if yyrl1252 <= cap(yyv1252) {
					yyv1252 = yyv1252[:yyrl1252]
				} else {
					yyv1252 = make([]HTTPIngressPath, yyrl1252)
				}
			} else {
				yyv1252 = make([]HTTPIngressPath, yyrl1252)
			}
			yyc1252 = true
			yyrr1252 = len(yyv1252)
			if yyrg1252 {
				copy(yyv1252, yyv21252)
			}
		} else if yyl1252 != len(yyv1252) {
			yyv1252 = yyv1252[:yyl1252]
			yyc1252 = true
		}
		yyj1252 := 0
		for ; yyj1252 < yyrr1252; yyj1252++ {
			yyh1252.ElemContainerState(yyj1252)
			if r.TryDecodeAsNil() {
				yyv1252[yyj1252] = HTTPIngressPath{}
			} else {
				yyv1253 := &yyv1252[yyj1252]
				yyv1253.CodecDecodeSelf(d)
			}

		}
		if yyrt1252 {
			for ; yyj1252 < yyl1252; yyj1252++ {
				yyv1252 = append(yyv1252, HTTPIngressPath{})
				yyh1252.ElemContainerState(yyj1252)
				if r.TryDecodeAsNil() {
					yyv1252[yyj1252] = HTTPIngressPath{}
				} else {
					yyv1254 := &yyv1252[yyj1252]
					yyv1254.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1252 := 0
		for ; !r.CheckBreak(); yyj1252++ {

			if yyj1252 >= len(yyv1252) {
				yyv1252 = append(yyv1252, HTTPIngressPath{}) // var yyz1252 HTTPIngressPath
				yyc1252 = true
			}
			yyh1252.ElemContainerState(yyj1252)
			if yyj1252 < len(yyv1252) {
				if r.TryDecodeAsNil() {
					yyv1252[yyj1252] = HTTPIngressPath{}
				} else {
					yyv1255 := &yyv1252[yyj1252]
					yyv1255.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1252 < len(yyv1252) {
			yyv1252 = yyv1252[:yyj1252]
			yyc1252 = true
		} else if yyj1252 == 0 && yyv1252 == nil {
			yyv1252 = []HTTPIngressPath{}
			yyc1252 = true
		}
	}
	yyh1252.End()
	if yyc1252 {
		*v = yyv1252
	}
}

func (x codecSelfer1234) encSliceNodeUtilization(v []NodeUtilization, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1256 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1257 := &yyv1256
		yy1257.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNodeUtilization(v *[]NodeUtilization, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1258 := *v
	yyh1258, yyl1258 := z.DecSliceHelperStart()
	var yyc1258 bool
	if yyl1258 == 0 {
		if yyv1258 == nil {
			yyv1258 = []NodeUtilization{}
			yyc1258 = true
		} else if len(yyv1258) != 0 {
			yyv1258 = yyv1258[:0]
			yyc1258 = true
		}
	} else if yyl1258 > 0 {
		var yyrr1258, yyrl1258 int
		var yyrt1258 bool
		if yyl1258 > cap(yyv1258) {

			yyrg1258 := len(yyv1258) > 0
			yyv21258 := yyv1258
			yyrl1258, yyrt1258 = z.DecInferLen(yyl1258, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1258 {
				if yyrl1258 <= cap(yyv1258) {
					yyv1258 = yyv1258[:yyrl1258]
				} else {
					yyv1258 = make([]NodeUtilization, yyrl1258)
				}
			} else {
				yyv1258 = make([]NodeUtilization, yyrl1258)
			}
			yyc1258 = true
			yyrr1258 = len(yyv1258)
			if yyrg1258 {
				copy(yyv1258, yyv21258)
			}
		} else if yyl1258 != len(yyv1258) {
			yyv1258 = yyv1258[:yyl1258]
			yyc1258 = true
		}
		yyj1258 := 0
		for ; yyj1258 < yyrr1258; yyj1258++ {
			yyh1258.ElemContainerState(yyj1258)
			if r.TryDecodeAsNil() {
				yyv1258[yyj1258] = NodeUtilization{}
			} else {
				yyv1259 := &yyv1258[yyj1258]
				yyv1259.CodecDecodeSelf(d)
			}

		}
		if yyrt1258 {
			for ; yyj1258 < yyl1258; yyj1258++ {
				yyv1258 = append(yyv1258, NodeUtilization{})
				yyh1258.ElemContainerState(yyj1258)
				if r.TryDecodeAsNil() {
					yyv1258[yyj1258] = NodeUtilization{}
				} else {
					yyv1260 := &yyv1258[yyj1258]
					yyv1260.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1258 := 0
		for ; !r.CheckBreak(); yyj1258++ {

			if yyj1258 >= len(yyv1258) {
				yyv1258 = append(yyv1258, NodeUtilization{}) // var yyz1258 NodeUtilization
				yyc1258 = true
			}
			yyh1258.ElemContainerState(yyj1258)
			if yyj1258 < len(yyv1258) {
				if r.TryDecodeAsNil() {
					yyv1258[yyj1258] = NodeUtilization{}
				} else {
					yyv1261 := &yyv1258[yyj1258]
					yyv1261.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1258 < len(yyv1258) {
			yyv1258 = yyv1258[:yyj1258]
			yyc1258 = true
		} else if yyj1258 == 0 && yyv1258 == nil {
			yyv1258 = []NodeUtilization{}
			yyc1258 = true
		}
	}
	yyh1258.End()
	if yyc1258 {
		*v = yyv1258
	}
}

func (x codecSelfer1234) encSliceClusterAutoscaler(v []ClusterAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1262 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1263 := &yyv1262
		yy1263.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterAutoscaler(v *[]ClusterAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1264 := *v
	yyh1264, yyl1264 := z.DecSliceHelperStart()
	var yyc1264 bool
	if yyl1264 == 0 {
		if yyv1264 == nil {
			yyv1264 = []ClusterAutoscaler{}
			yyc1264 = true
		} else if len(yyv1264) != 0 {
			yyv1264 = yyv1264[:0]
			yyc1264 = true
		}
	} else if yyl1264 > 0 {
		var yyrr1264, yyrl1264 int
		var yyrt1264 bool
		if yyl1264 > cap(yyv1264) {

			yyrg1264 := len(yyv1264) > 0
			yyv21264 := yyv1264
			yyrl1264, yyrt1264 = z.DecInferLen(yyl1264, z.DecBasicHandle().MaxInitLen, 232)
			if yyrt1264 {
				if yyrl1264 <= cap(yyv1264) {
					yyv1264 = yyv1264[:yyrl1264]
				} else {
					yyv1264 = make([]ClusterAutoscaler, yyrl1264)
				}
			} else {
				yyv1264 = make([]ClusterAutoscaler, yyrl1264)
			}
			yyc1264 = true
			yyrr1264 = len(yyv1264)
			if yyrg1264 {
				copy(yyv1264, yyv21264)
			}
		} else if yyl1264 != len(yyv1264) {
			yyv1264 = yyv1264[:yyl1264]
			yyc1264 = true
		}
		yyj1264 := 0
		for ; yyj1264 < yyrr1264; yyj1264++ {
			yyh1264.ElemContainerState(yyj1264)
			if r.TryDecodeAsNil() {
				yyv1264[yyj1264] = ClusterAutoscaler{}
			} else {
				yyv1265 := &yyv1264[yyj1264]
				yyv1265.CodecDecodeSelf(d)
			}

		}
		if yyrt1264 {
			for ; yyj1264 < yyl1264; yyj1264++ {
				yyv1264 = append(yyv1264, ClusterAutoscaler{})
				yyh1264.ElemContainerState(yyj1264)
				if r.TryDecodeAsNil() {
					yyv1264[yyj1264] = ClusterAutoscaler{}
				} else {
					yyv1266 := &yyv1264[yyj1264]
					yyv1266.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1264 := 0
		for ; !r.CheckBreak(); yyj1264++ {

			if yyj1264 >= len(yyv1264) {
				yyv1264 = append(yyv1264, ClusterAutoscaler{}) // var yyz1264 ClusterAutoscaler
				yyc1264 = true
			}
			yyh1264.ElemContainerState(yyj1264)
			if yyj1264 < len(yyv1264) {
				if r.TryDecodeAsNil() {
					yyv1264[yyj1264] = ClusterAutoscaler{}
				} else {
					yyv1267 := &yyv1264[yyj1264]
					yyv1267.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1264 < len(yyv1264) {
			yyv1264 = yyv1264[:yyj1264]
			yyc1264 = true
		} else if yyj1264 == 0 && yyv1264 == nil {
			yyv1264 = []ClusterAutoscaler{}
			yyc1264 = true
		}
	}
	yyh1264.End()
	if yyc1264 {
		*v = yyv1264
	}
}

func (x codecSelfer1234) encSliceLabelSelectorRequirement(v []LabelSelectorRequirement, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1268 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1269 := &yyv1268
		yy1269.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceLabelSelectorRequirement(v *[]LabelSelectorRequirement, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1270 := *v
	yyh1270, yyl1270 := z.DecSliceHelperStart()
	var yyc1270 bool
	if yyl1270 == 0 {
		if yyv1270 == nil {
			yyv1270 = []LabelSelectorRequirement{}
			yyc1270 = true
		} else if len(yyv1270) != 0 {
			yyv1270 = yyv1270[:0]
			yyc1270 = true
		}
	} else if yyl1270 > 0 {
		var yyrr1270, yyrl1270 int
		var yyrt1270 bool
		if yyl1270 > cap(yyv1270) {

			yyrg1270 := len(yyv1270) > 0
			yyv21270 := yyv1270
			yyrl1270, yyrt1270 = z.DecInferLen(yyl1270, z.DecBasicHandle().MaxInitLen, 56)
			if yyrt1270 {
				if yyrl1270 <= cap(yyv1270) {
					yyv1270 = yyv1270[:yyrl1270]
				} else {
					yyv1270 = make([]LabelSelectorRequirement, yyrl1270)
				}
			} else {
				yyv1270 = make([]LabelSelectorRequirement, yyrl1270)
			}
			yyc1270 = true
			yyrr1270 = len(yyv1270)
			if yyrg1270 {
				copy(yyv1270, yyv21270)
			}
		} else if yyl1270 != len(yyv1270) {
			yyv1270 = yyv1270[:yyl1270]
			yyc1270 = true
		}
		yyj1270 := 0
		for ; yyj1270 < yyrr1270; yyj1270++ {
			yyh1270.ElemContainerState(yyj1270)
			if r.TryDecodeAsNil() {
				yyv1270[yyj1270] = LabelSelectorRequirement{}
			} else {
				yyv1271 := &yyv1270[yyj1270]
				yyv1271.CodecDecodeSelf(d)
			}

		}
		if yyrt1270 {
			for ; yyj1270 < yyl1270; yyj1270++ {
				yyv1270 = append(yyv1270, LabelSelectorRequirement{})
				yyh1270.ElemContainerState(yyj1270)
				if r.TryDecodeAsNil() {
					yyv1270[yyj1270] = LabelSelectorRequirement{}
				} else {
					yyv1272 := &yyv1270[yyj1270]
					yyv1272.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1270 := 0
		for ; !r.CheckBreak(); yyj1270++ {

			if yyj1270 >= len(yyv1270) {
				yyv1270 = append(yyv1270, LabelSelectorRequirement{}) // var yyz1270 LabelSelectorRequirement
				yyc1270 = true
			}
			yyh1270.ElemContainerState(yyj1270)
			if yyj1270 < len(yyv1270) {
				if r.TryDecodeAsNil() {
					yyv1270[yyj1270] = LabelSelectorRequirement{}
				} else {
					yyv1273 := &yyv1270[yyj1270]
					yyv1273.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1270 < len(yyv1270) {
			yyv1270 = yyv1270[:yyj1270]
			yyc1270 = true
		} else if yyj1270 == 0 && yyv1270 == nil {
			yyv1270 = []LabelSelectorRequirement{}
			yyc1270 = true
		}
	}
	yyh1270.End()
	if yyc1270 {
		*v = yyv1270
	}
}

func (x codecSelfer1234) encSliceConfigMap(v []ConfigMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1274 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1275 := &yyv1274
		yy1275.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceConfigMap(v *[]ConfigMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1276 := *v
	yyh1276, yyl1276 := z.DecSliceHelperStart()
	var yyc1276 bool
	if yyl1276 == 0 {
		if yyv1276 == nil {
			yyv1276 = []ConfigMap{}
			yyc1276 = true
		} else if len(yyv1276) != 0 {
			yyv1276 = yyv1276[:0]
			yyc1276 = true
		}
	} else if yyl1276 > 0 {
		var yyrr1276, yyrl1276 int
		var yyrt1276 bool
		if yyl1276 > cap(yyv1276) {

			yyrg1276 := len(yyv1276) > 0
			yyv21276 := yyv1276
			yyrl1276, yyrt1276 = z.DecInferLen(yyl1276, z.DecBasicHandle().MaxInitLen, 200)
			if yyrt1276 {
				if yyrl1276 <= cap(yyv1276) {
					yyv1276 = yyv1276[:yyrl1276]
				} else {
					yyv1276 = make([]ConfigMap, yyrl1276)
				}
			} else {
				yyv1276 = make([]ConfigMap, yyrl1276)
			}
			yyc1276 = true
			yyrr1276 = len(yyv1276)
			if yyrg1276 {
				copy(yyv1276, yyv21276)
			}
		} else if yyl1276 != len(yyv1276) {
			yyv1276 = yyv1276[:yyl1276]
			yyc1276 = true
		}
		yyj1276 := 0
		for ; yyj1276 < yyrr1276; yyj1276++ {
			yyh1276.ElemContainerState(yyj1276)
			if r.TryDecodeAsNil() {
				yyv1276[yyj1276] = ConfigMap{}
			} else {
				yyv1277 := &yyv1276[yyj1276]
				yyv1277.CodecDecodeSelf(d)
			}

		}
		if yyrt1276 {
			for ; yyj1276 < yyl1276; yyj1276++ {
				yyv1276 = append(yyv1276, ConfigMap{})
				yyh1276.ElemContainerState(yyj1276)
				if r.TryDecodeAsNil() {
					yyv1276[yyj1276] = ConfigMap{}
				} else {
					yyv1278 := &yyv1276[yyj1276]
					yyv1278.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1276 := 0
		for ; !r.CheckBreak(); yyj1276++ {

			if yyj1276 >= len(yyv1276) {
				yyv1276 = append(yyv1276, ConfigMap{}) // var yyz1276 ConfigMap
				yyc1276 = true
			}
			yyh1276.ElemContainerState(yyj1276)
			if yyj1276 < len(yyv1276) {
				if r.TryDecodeAsNil() {
					yyv1276[yyj1276] = ConfigMap{}
				} else {
					yyv1279 := &yyv1276[yyj1276]
					yyv1279.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1276 < len(yyv1276) {
			yyv1276 = yyv1276[:yyj1276]
			yyc1276 = true
		} else if yyj1276 == 0 && yyv1276 == nil {
			yyv1276 = []ConfigMap{}
			yyc1276 = true
		}
	}
	yyh1276.End()
	if yyc1276 {
		*v = yyv1276
	}
}
