#!/bin/bash

# Copyright 2014 The Kubernetes Authors All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -o errexit
set -o nounset
set -o pipefail

KUBE_ROOT=$(dirname "${BASH_SOURCE}")/..
source "${KUBE_ROOT}/hack/lib/init.sh"

kube::golang::setup_env

"${KUBE_ROOT}/hack/build-go.sh" \
    cmd/gendocs \
    cmd/genkubedocs \
    cmd/genman \
    cmd/genyaml \
    federation/cmd/genfeddocs

kube::util::ensure-temp-dir

kube::util::gen-docs "${KUBE_TEMP}"

# Verify the list matches the expected list (diff should be empty)
if [[ "$(diff ${KUBE_ROOT}/.generated_docs ${KUBE_TEMP}/.generated_docs)" != "" ]]; then
  echo "List of generated docs doesn't match a freshly built list. Please run hack/update-generated-docs.sh"
  exit 1
fi

# Verify the files in the repo all contain the boilerplate instead of the actual
# content.
while read file; do
  # Ignore .generated_docs-- it should not have the boilerplate!
  [[ "${file}" == ".generated_docs" ]] && continue

  # Search for "hack/generate-docs.sh" as a proxy for the boilerplate content,
  # since the munger adds a bunch of other stuff.
  if [[ "$(grep "hack/generate-docs.sh" "${KUBE_ROOT}/${file}")" == "" ]]; then
    echo "${file} doesn't seem to have the correct boilerplate content for an autogenerated file."
    echo "Please run hack/update-generated-docs.sh"
    exit 1
  fi
done <"${KUBE_ROOT}/.generated_docs"
