/*
 * Decompiled with CFR 0.152.
 */
package io.k8s.cassandra;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.SeedProvider;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KubernetesSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesSeedProvider.class);
    private List defaultSeeds;

    private static String getEnvOrDefault(String var, String def) {
        String val = System.getenv(var);
        if (val == null) {
            val = def;
        }
        return val;
    }

    public KubernetesSeedProvider(Map<String, String> params) {
        String[] hosts = params.get("seeds").split(",", -1);
        this.defaultSeeds = new ArrayList(hosts.length);
        for (String host : hosts) {
            try {
                this.defaultSeeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host " + host);
            }
        }
    }

    public List<InetAddress> getSeeds() {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        String protocol = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_API_PROTOCOL", "http");
        String hostName = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_RO_SERVICE_HOST", "localhost");
        String hostPort = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_RO_SERVICE_PORT", "8080");
        String host = protocol + "://" + hostName + ":" + hostPort;
        String serviceName = KubernetesSeedProvider.getEnvOrDefault("CASSANDRA_SERVICE", "cassandra");
        String path = "/api/v1beta1/endpoints/";
        try {
            URL url = new URL(host + path + serviceName);
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(url, Endpoints.class);
            if (endpoints != null && endpoints.endpoints != null) {
                for (String endpoint : endpoints.endpoints) {
                    String[] parts = endpoint.split(":");
                    list.add(InetAddress.getByName(parts[0]));
                }
            }
        }
        catch (IOException ex) {
            logger.warn("Request to kubernetes apiserver failed");
        }
        if (list.size() == 0) {
            return this.defaultSeeds;
        }
        return list;
    }

    public static void main(String[] args) {
        KubernetesSeedProvider provider = new KubernetesSeedProvider(new HashMap<String, String>());
        System.out.println(provider.getSeeds());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Endpoints {
        public String[] endpoints;

        Endpoints() {
        }
    }
}

