// Copyright 2016 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// generated by build/assets.sh; DO NOT EDIT

// Code generated by go-bindata.
// sources:
// pages/assets/html/containers.html
// DO NOT EDIT!

package pages

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _pagesAssetsHtmlContainersHtml = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xcc\x5a\x5b\x73\xdb\xb8\x15\x7e\x96\x7f\xc5\x29\xa7\x0f\xdb\x19\x93\x8a\x93\xbc\x74\x2b\x6b\x46\x2b\x27\x5d\x75\x1d\x3b\x63\xd9\xbb\xb3\x8f\x10\x09\x49\x88\x21\x82\x0b\x80\x96\x55\x8f\xff\x7b\x0f\x00\x52\x02\x6f\x92\x6f\x93\x54\x19\xc7\x22\x81\xf3\x9d\xef\xdc\x80\x03\xd2\x83\xbf\x85\xe1\x11\xc0\x58\x64\x1b\xc9\x16\x4b\x0d\xef\xdf\x9d\x7c\x84\x7f\x0b\xb1\xe0\x14\x26\x69\x1c\xc1\x88\x73\xb8\x32\x43\x0a\xae\xa8\xa2\xf2\x8e\x26\xd1\x11\x8a\x9c\xb3\x98\xa6\x8a\x26\x90\xa7\x09\x95\xa0\x97\x14\x46\x19\x89\xf1\x57\x31\x72\x0c\xbf\x53\xa9\x98\x48\xe1\x7d\xf4\x0e\x7e\x32\x13\x82\x62\x28\xf8\xc7\xbf\x10\x61\x23\x72\x58\x91\x0d\xa4\x42\x43\xae\x28\x42\x30\x05\x73\x86\x8a\xe9\x7d\x4c\x33\x0d\x2c\x85\x58\xac\x32\xce\x48\x1a\x53\x58\x33\xbd\xb4\x6a\x0a\x90\x08\x21\xfe\x2c\x20\xc4\x4c\x13\x9c\x4d\x70\x7e\x86\x57\x73\x7f\x1e\x10\x6d\xf8\x9a\xcf\x52\xeb\xec\xe7\x7e\x7f\xbd\x5e\x47\xc4\x72\x8d\x84\x5c\xf4\xb9\x9b\xa7\xfa\xe7\x93\xf1\xa7\x8b\xe9\xa7\x10\xf9\x1a\x89\x9b\x94\x53\xa5\x40\xd2\xbf\x72\x26\xd1\xd0\xd9\x06\x48\x86\x6c\x62\x32\x43\x8e\x9c\xac\x41\x48\x20\x0b\x49\x71\x4c\x0b\xc3\x76\x2d\x99\x66\xe9\xe2\x18\x94\x98\xeb\x35\x91\x14\x51\x12\xa6\xb4\x64\xb3\x5c\x57\x5c\x55\x72\x43\x8b\xfd\x09\xe8\x2c\x92\x42\x30\x9a\xc2\x64\x1a\xc0\x2f\xa3\xe9\x64\x7a\x8c\x18\x7f\x4c\xae\x7f\xbd\xbc\xb9\x86\x3f\x46\x57\x57\xa3\x8b\xeb\xc9\xa7\x29\x5c\x5e\xc1\xf8\xf2\xe2\x6c\x72\x3d\xb9\xbc\xc0\xab\xcf\x30\xba\xf8\x13\x7e\x9b\x5c\x9c\x1d\x03\x45\x47\xa1\x1a\x7a\x9f\x49\xc3\x1f\x49\x32\xe3\x44\x13\x37\x80\x29\xa5\x15\x02\x73\xe1\x08\xa9\x8c\xc6\x6c\xce\x62\xb4\x2b\x5d\xe4\x64\x41\x61\x21\xee\xa8\x4c\xd1\x1c\xc8\xa8\x5c\x31\x65\x42\xa9\x90\x5e\x82\x28\x9c\xad\x98\x26\xda\xde\x69\x18\x15\x1d\x85\xe1\xf0\xe8\x68\xb0\xd4\x2b\x3e\xc4\xc9\x83\x25\x25\xc9\xd0\x86\x60\xa0\x99\xe6\x74\x18\x8f\x92\x3b\xa6\x50\x73\x08\x0f\x0f\xd1\x19\x53\x19\x27\x9b\x0b\xb2\xa2\x8f\x8f\x83\xbe\x9b\xe2\xa6\x63\x76\xc2\x39\xd1\x54\x69\x9b\x09\x98\x1b\x89\x61\x00\x2b\x96\x22\x59\xbc\x18\x4f\xa7\x60\xb4\xd9\xd9\x9c\xa5\xb7\x18\x2e\x7e\x1a\x28\xbd\xc1\xd8\x2d\x29\xd5\x01\x2c\x25\x9d\x9f\x06\xa8\xe7\x4a\x08\xfd\xf8\xa8\x0c\xef\xb8\x3f\xc3\x0b\xf4\x3b\xc9\xc2\x0f\xd1\x09\xfe\x43\xc4\x28\x56\x2a\x18\x1e\xed\x34\x5f\x66\xc6\x42\xc2\x8d\x71\x2b\xfa\x5a\x3d\x16\xa4\x43\xdb\x73\x10\x63\x91\x9a\x64\xc7\xda\x6a\x10\xde\xeb\xaa\xff\x90\x3b\x32\x8d\x25\xc3\xc2\xda\x5a\xa2\xdc\xb5\x92\x71\x53\xcf\xb7\xbf\x72\x2a\x37\x21\xd2\x7d\x17\xbd\xb7\x8c\xbf\xa1\xb6\x41\xdf\xc9\x3c\x01\xa0\xcd\xc5\xdd\x10\x7a\x93\xd1\xd3\x40\xd3\x7b\xdd\xff\x86\x4c\xdd\xdd\xa0\x1d\x79\x61\xd7\xa7\xf0\x9b\x22\x19\xab\x41\xbe\x18\xd3\x73\xeb\x1b\x91\x8c\x97\x44\xea\x26\xda\xa0\x5f\xd6\xc3\x60\x26\x92\x4d\xa1\x20\x61\x77\x10\x73\xa2\xd4\x69\xb0\x65\xe2\xf2\x2e\x54\x4b\xb1\x8e\x09\xae\x9a\x30\x2c\xd6\xb1\x01\xa9\xe7\x46\xb0\x13\xe6\xa1\x5a\x85\x27\xef\x03\x60\xc9\x69\xc0\xc5\x42\x04\x5b\xb1\x3e\xd9\x7e\xad\xe8\x2b\x45\x86\x47\x3d\x7f\x20\xc3\x65\x20\x34\x64\xa9\x34\x43\xa6\x92\x4f\x86\xcd\x82\xc5\x9b\x28\xd7\x47\x41\xf3\x5b\xf0\x52\x7c\x26\x51\x34\x96\xf9\x6a\xe6\xa4\x1f\x1e\x24\xae\x2d\x14\xfe\x9e\xe1\xca\x98\xea\xf1\xd6\xcc\x9f\x4f\x21\xfa\x5a\xbd\xa7\x1e\x1f\xad\x42\xce\x86\x9e\xb1\x75\xc9\xe8\x1c\xeb\x06\x8d\x1f\xb6\x0c\x5d\x63\x90\x0c\x3b\x82\xce\x47\x14\x47\x80\xa6\x89\x01\x1e\xf4\x05\xdf\x39\xc5\x12\x77\x17\x0f\x0f\x6c\x0e\xd1\x44\x39\xa7\x1e\xf0\x15\x14\x9f\xc1\xf2\xe3\x8e\x64\x14\xf5\x13\x11\xdf\x1a\x8f\x9d\xd9\xdf\xb0\xb3\xc9\x91\xc1\xd9\xed\xaa\x1d\x39\x9f\xc8\x34\x9f\xc5\xbe\x47\x5e\x17\xbb\x0f\xc3\x0a\x1e\x32\xf9\xe0\x07\xce\x13\xe6\xb8\x25\x85\x0b\x29\xf2\xac\x16\x39\xe5\x01\xd8\xb0\xd5\x19\xf6\x2a\xc9\x59\x99\x5f\x06\xab\xa9\x24\x64\x9a\xae\x6c\x10\x2b\xf3\x77\x11\xac\x05\xcf\xf3\x5a\xb7\x0b\x9d\x07\x5d\x0c\xa6\x58\x91\xf9\x5b\x38\xf0\x4c\x32\xdc\x14\xc1\xe1\xd5\x1d\x98\xf3\x83\xfe\x73\xa9\xa1\xac\xb8\xf5\x5f\x8d\x9f\x4b\x79\x07\x03\x2d\x2e\x1a\xa8\x0c\xfb\x83\x42\x8b\x81\x09\x39\x99\x51\x6e\x7d\xe7\x63\x47\xbf\xd1\x8d\x71\x9d\x99\x3e\x84\xfa\xe0\xef\x84\xe7\xb6\x72\xeb\x75\x51\xf5\x9a\x33\x76\xc7\xad\xf7\x32\x6a\x53\x2d\x24\xfa\x72\x30\x93\xc3\x82\x90\x81\xea\x72\x56\x6f\xe7\x2b\xab\xbe\xe1\xab\x6e\x56\xcf\xf5\x97\x87\xdf\xf4\x97\x3f\x58\xf5\x57\x6f\xeb\x2e\x0c\x7d\xce\xad\x35\xa5\x27\x8b\x1b\x5d\xd9\xda\x56\xe3\xce\xaa\xc9\x0a\x5d\x74\x38\x43\x61\xfb\xe9\x4e\x55\xf0\x3e\x26\x67\x1d\xb4\x4b\x56\x6f\xc4\xe7\xe5\xd0\xcc\x7e\xe1\xf2\x24\x64\x56\xc6\xec\x5b\x95\x59\x26\x84\xf8\x73\xd4\x86\xd1\x66\x1b\x1e\x18\x44\x2e\x63\xaa\x46\x77\x84\x71\xd3\x36\xbf\x41\x0d\x4e\x94\xe0\xb6\xf5\xac\xd5\x9f\x53\x39\xce\x72\x5f\x59\x67\xa2\x79\x9e\xe8\xcc\x1f\x20\xb1\xc6\x34\xc0\x26\xbd\xd0\x18\xda\xde\x14\x30\x49\x28\x77\xdf\x83\xe1\xf8\xeb\x8d\x0b\xff\x0e\xb1\x58\xbc\xb1\xa3\x36\x74\x70\xdd\xc3\x66\x79\x6b\xf8\x7e\x95\xfb\xea\x08\xdb\x09\x13\xc7\x32\x47\x33\xc9\x52\xed\x6e\x36\x95\x41\x05\x26\x4f\xd9\x16\x46\xf9\x30\x4d\xe6\x7e\x10\x5b\x6c\xf9\x42\xee\xdf\xc8\x1c\x44\x02\x0b\x55\xb3\x68\x2c\xaa\x06\xed\x34\x76\xdb\x14\x8b\x57\x99\xa4\x6e\x5f\x6f\x0e\x1e\x93\xc5\xda\x1c\x48\x44\x33\x48\x46\x43\x4d\x21\xe0\xff\xf1\x12\xb7\xb9\x49\x3a\x17\xd1\x45\xbe\xb2\x72\xe5\x1a\xd3\x64\x5f\x2e\x35\xdb\x6b\x67\xc4\x17\xba\x12\x72\xf3\x7d\x13\xde\xe9\xdc\x93\xf3\x6e\x42\xe4\x9e\x16\x58\x98\xd7\xbb\xd7\x03\xab\x57\x00\xfb\x2f\xdd\xa3\xb8\x3b\x69\x0a\xf9\x1b\xbc\xb5\x47\xfe\x25\x59\x55\xe0\xbc\x51\xa1\xb4\x15\x49\xd3\xe8\x83\x35\xd2\x69\x6e\x21\xf9\x0a\x43\xa7\x6b\x92\xbd\xd5\x22\x87\x50\xad\xcb\x42\xd3\x62\x4f\xeb\x0b\xac\xf6\xa4\x0f\x58\x5e\x2f\xbd\xc2\xba\x4a\x17\xfa\xe2\xcd\xec\x46\x99\xd6\xa8\xbb\x13\xb7\x95\x57\xd4\x1f\x5a\xb2\x22\x72\xb3\xa7\x0d\x30\xb3\x8c\x06\x96\x2e\x9a\x8d\x40\x75\x5a\x51\xcc\x97\xd8\xe5\xdc\x31\xba\xde\xdf\x1e\x80\xd7\x21\xe4\x86\x71\xb8\x20\xf9\x82\x06\x55\x48\x73\x9a\xdd\xb6\x0c\x3f\xc4\x9a\xaf\x52\x60\xb3\xa1\x0e\x75\x3b\xbe\x39\x59\x29\x12\x6a\x91\x3d\xc9\xa0\x8e\x3e\xe3\x3b\x9a\x69\x5b\x8e\xa7\x18\xd8\x62\x4d\x4d\xc1\xc7\xe1\xb5\xd0\x84\x43\x99\x87\x1f\x6d\x66\x7a\xfe\x89\xb3\x1c\x3d\x83\x53\x42\x17\x78\xfb\x50\x63\xe7\x14\x3b\xd7\x3c\x7a\x32\x50\xc8\x0b\xce\x05\x49\x60\x84\x59\xb5\x07\x8f\xe3\x9c\x2a\xd0\xf6\x89\x94\xcf\xcc\x72\x32\x0f\x1f\xed\xa6\xda\x05\x86\xe3\xa1\xd9\xff\x5b\xf9\xb5\x43\xfe\x22\x29\xb9\x4d\xc4\x3a\xed\xc2\x74\x50\xb3\x72\x5a\x27\x68\x33\x35\x0e\xee\xce\xdf\x31\x4d\xca\x8d\xfa\x3b\x65\xca\xca\xaa\x3b\x1c\x86\x99\xec\xd7\xee\x78\x04\xa4\x58\x43\xfb\x81\x67\x6f\x08\x6b\xd3\x9a\xcb\xf1\x3f\xed\xd9\xb2\x62\xaa\x14\x0b\xf3\x7c\xbc\xa1\xa4\xe1\x93\x62\x62\x38\x23\x12\xfc\x8b\x30\x31\x07\x55\x19\x94\xeb\x88\x1b\x58\x0a\x1d\x3a\x57\xb4\x22\x43\x75\xaf\x52\x32\x14\x29\xc7\xa9\xbf\x0a\x0d\x65\xc0\xdc\x21\xb9\x45\xb2\xe9\xcd\xe7\xd0\x65\xd8\x6a\xd6\xc8\xa2\x77\x92\x97\xb0\x1d\xa3\xdc\x53\xe9\xf6\x7a\xad\xbc\xdb\x6f\x36\x23\xf7\x21\xf0\xb3\xcb\x3c\x7a\xad\xad\x3e\xcf\x2c\xca\x0b\xaa\xd7\x42\xde\x3e\xb3\x2a\x7b\xaf\x2f\xc7\x42\x71\xb1\xd9\x3f\xa7\x10\x7b\xf5\xd1\x44\x8a\xcc\x24\x7f\xb3\x40\x66\xb9\xd6\x62\x1b\xaf\x99\x4e\x01\x7f\xc2\x84\xce\x49\xce\x35\x94\x72\xb8\xa2\x2f\x16\xc8\xa9\x78\x9e\xed\x84\x9c\x9f\x53\xc7\x32\x54\x94\xd3\xd8\x1e\x01\xb6\xca\x20\x21\x9a\x14\xa2\x1e\x07\x20\x92\x91\x70\x49\x54\x26\xb2\x3c\x3b\x0d\xb4\xcc\x69\x71\x93\xde\xa3\x1d\x09\x45\xd8\x39\xe1\x8a\xb6\xa4\x98\x4b\xaf\x76\xc5\x65\xac\xdb\xf3\xab\x92\x98\x31\x9e\x69\xbd\xb9\xbd\x32\x13\x9c\x65\x0d\x2f\xe1\x11\xa9\x55\x65\x50\x77\x30\xd6\x46\x9a\x07\x20\x85\xb1\xd8\x7d\xb7\x86\xd9\xee\x92\xd3\x64\xb6\xd9\xeb\xb1\x66\xce\x17\x8f\x87\xf6\xa4\xed\x73\x16\xe4\x25\xb6\xd4\x8b\x65\x96\xeb\xe6\x2a\xb8\x5d\x96\x4b\x7a\xb3\x8d\xc6\x26\xa7\xb1\x7d\xbf\x40\xed\x27\x29\x85\x7d\x7c\xdc\xd8\x02\x4a\x5d\xd4\xce\xe8\x56\x56\x33\xbe\x56\xa1\x9f\xd5\x0f\xdb\x32\x3f\x33\x4e\xd5\x46\xe1\x19\xe5\xe9\x1d\xe4\x7c\x2b\xe3\xf6\xbe\xd6\x26\xb2\x1b\xa9\x63\x99\x1a\xe7\x4a\x8b\xd5\x17\xaa\x25\x8b\x9f\xeb\x8f\x03\x8b\x55\x6f\x9f\x07\x46\xee\x0d\xb7\xc9\x63\x28\xb4\xd7\x57\xac\x7d\xb9\x52\xeb\xa5\xac\x11\x58\x44\x16\xe7\x60\x3e\xf4\xea\x87\xcd\x96\xb7\x20\x3f\x2c\x35\x5a\xde\x9d\x1c\xca\x8e\xa7\x35\x55\x19\x98\xbe\xd9\xb6\x35\x3f\xd7\xd7\x0b\x96\x62\x71\x57\x5a\x5d\xff\x0d\x49\x98\xb8\x17\x71\xb8\x8d\xe7\xa9\x0e\x5a\xf7\xef\xed\xd6\xdd\x26\x67\xe1\x3b\xe4\xee\xcc\x43\xef\xd3\x93\x77\x35\xca\xdd\x0b\x4d\x2b\xc3\x4a\x37\x58\x43\x6a\x5f\x00\x5f\xe8\x43\xd7\x8c\x1c\x74\x63\xd1\x46\xfc\x7f\x7a\xb2\xd2\x6a\x39\x2d\xb8\xf3\x70\x4f\xcd\x8c\x8b\xf8\xb6\xee\x81\xe6\xfe\x58\xef\xc9\xdf\x30\x2c\x1d\x4b\x77\xcb\xa0\x3f\xe4\x0d\xec\x7f\x95\x5e\x0a\x2b\x8d\xd4\xbe\x22\xc9\x9f\x1e\x1e\xa2\xed\x1b\x54\xf7\xc6\xf9\xd8\xfc\xd1\x48\xf5\xfc\x6d\x6f\x35\x8e\x5b\xf6\xae\x7b\x95\x6b\xbf\x96\xef\x75\xed\x5f\x1f\x99\x4f\x22\xc9\xda\xbd\x1e\x31\x6a\xaa\x6f\x62\x8a\x49\xd5\x37\xf7\xee\x85\x3d\x86\xce\xfe\x69\xcb\xff\x02\x00\x00\xff\xff\x4b\x13\x4b\x6c\x3d\x25\x00\x00")

func pagesAssetsHtmlContainersHtmlBytes() ([]byte, error) {
	return bindataRead(
		_pagesAssetsHtmlContainersHtml,
		"pages/assets/html/containers.html",
	)
}

func pagesAssetsHtmlContainersHtml() (*asset, error) {
	bytes, err := pagesAssetsHtmlContainersHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "pages/assets/html/containers.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"pages/assets/html/containers.html": pagesAssetsHtmlContainersHtml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"pages": {nil, map[string]*bintree{
		"assets": {nil, map[string]*bintree{
			"html": {nil, map[string]*bintree{
				"containers.html": {pagesAssetsHtmlContainersHtml, map[string]*bintree{}},
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
