# Kubernetes

[![Submit Queue Widget]][Submit Queue] [![GoDoc Widget]][GoDoc] [![Coverage Status Widget]][Coverage Status]

<img src="https://github.com/kubernetes/kubernetes/raw/master/logo/logo.png" width="100">

[Submit Queue]: http://submit-queue.k8s.io/#/e2e
[Submit Queue Widget]: http://submit-queue.k8s.io/health.svg?v=1
[GoDoc]: https://godoc.org/k8s.io/kubernetes
[GoDoc Widget]: https://godoc.org/k8s.io/kubernetes?status.svg
[Coverage Status]: https://coveralls.io/r/kubernetes/kubernetes
[Coverage Status Widget]: https://coveralls.io/repos/kubernetes/kubernetes/badge.svg

## Introduction

Kubernetes is an open source system for managing [containerized applications](http://kubernetes.io/docs/whatisk8s/) across multiple hosts,
providing basic mechanisms for deployment, maintenance, and scaling of applications. Kubernetes is hosted by the Cloud Native Computing Foundation ([CNCF](https://www.cncf.io))

Kubernetes builds upon a decade and a half of experience at Google running production workloads at scale using a system called [Borg](https://research.google.com/pubs/pub43438.html), combined with best-of-breed ideas and practices from the community.

<hr>

### Are you ...

  * Interested in learning more about using Kubernetes?
    - See see our documentation on [kubernetes.io](http://kubernetes.io)
    - Try our [interactive tutorial](http://kubernetes.io/docs/tutorials/kubernetes-basics/)
    - Take a free course on [Scalable Microservices with Kubernetes](https://www.udacity.com/course/scalable-microservices-with-kubernetes--ud615).
  * Interested in developing the core Kubernetes code base, developing tools using the Kubernetes API or helping in anyway possible ?  Keep reading!

## Code of Conduct

The Kubernetes community abides by the CNCF [code of conduct](https://github.com/cncf/foundation/blob/master/code-of-conduct.md). Here is an excerpt:

_As contributors and maintainers of this project, and in the interest of fostering an open and welcoming community, we pledge to respect all people who contribute through reporting issues, posting feature requests, updating documentation, submitting pull requests or patches, and other activities._

## Community

Do you want to help "shape the evolution of technologies that are container-packaged, dynamically-scheduled and microservices-oriented? ". If you are a company, you should consider joining the [CNCF](https://cncf.io/about). For details about who's involved in CNCF and how Kubernetes plays a role, read [the announcement](https://cncf.io/news/announcement/2015/07/new-cloud-native-computing-foundation-drive-alignment-among-container). For general information about our community see the website [community](http://kubernetes.io/community/) page.

Join us on social media ([Twitter](https://twitter.com/kubernetesio), [Google+](https://plus.google.com/u/0/b/116512812300813784482/116512812300813784482)) and read our [blog](http://blog.kubernetes.io/)

Ask questions and help answer them on [Slack](http://slack.k8s.io/) or [Stack Overflow](http://stackoverflow.com/questions/tagged/kubernetes)

Attend our key events ([kubecon](http://events.linuxfoundation.org/events/kubecon), [cloudnativecon](http://events.linuxfoundation.org/events/cloudnativecon), weekly [community meeting](https://github.com/kubernetes/community/blob/master/community/README.md))

Join a Special Interest Group ([SIG](https://github.com/kubernetes/community))

## Contribute

If you're interested in being a contributor and want to get involved in developing Kubernetes, get started with with this reading:

*  The community [expectations](docs/devel/community-expectations.md)
*  The [contributor guidelines](CONTRIBUTING.md)
*  The [Kubernetes Developer Guide](docs/devel/README.md)

You will then most certainly gain a lot from joining a [SIG](https://github.com/kubernetes/community), attending the regular hangouts as well as the community [meeting](https://github.com/kubernetes/community/blob/master/community/README.md).

If you have an idea for a new feature, see the [Kubernetes Features](https://github.com/kubernetes/features) repository for a list of features that are coming in new releases as well as details on how to propose one.

## Support

While there are many different channels that you can use to get hold of us ([Slack](http://slack.k8s.io/), [Stack Overflow](http://stackoverflow.com/questions/tagged/kubernetes), [Issues](https://github.com/kubernetes/kubernetes/issues/new), [Forums/Mailing lists](https://groups.google.com/forum/#!forum/kubernetes-users)), you can help make sure that we are efficient in getting you the help that you need.

If you need support, start with the [troubleshooting guide](http://kubernetes.io/docs/troubleshooting/) and work your way through the process that we've outlined.

That said, if you have questions, reach out to us one way or another.  We don't bite!

[![Analytics](https://kubernetes-site.appspot.com/UA-36037335-10/GitHub/README.md?pixel)]()

