// Code generated by protoc-gen-gogo.
// source: mesos.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto/gogo.pb"

import io "io"
import math1 "math"
import fmt "fmt"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import fmt1 "fmt"
import strings "strings"
import reflect "reflect"

import math2 "math"

import fmt2 "fmt"
import strings1 "strings"
import github_com_gogo_protobuf_proto1 "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect1 "reflect"

import fmt3 "fmt"
import bytes "bytes"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// *
// Status is used to indicate the state of the scheduler and executor
// driver after function calls.
type Status int32

const (
	Status_DRIVER_NOT_STARTED Status = 1
	Status_DRIVER_RUNNING     Status = 2
	Status_DRIVER_ABORTED     Status = 3
	Status_DRIVER_STOPPED     Status = 4
)

var Status_name = map[int32]string{
	1: "DRIVER_NOT_STARTED",
	2: "DRIVER_RUNNING",
	3: "DRIVER_ABORTED",
	4: "DRIVER_STOPPED",
}
var Status_value = map[string]int32{
	"DRIVER_NOT_STARTED": 1,
	"DRIVER_RUNNING":     2,
	"DRIVER_ABORTED":     3,
	"DRIVER_STOPPED":     4,
}

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}
func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (x *Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Status_value, data, "Status")
	if err != nil {
		return err
	}
	*x = Status(value)
	return nil
}

// *
// Describes possible task states. IMPORTANT: Mesos assumes tasks that
// enter terminal states (see below) imply the task is no longer
// running and thus clean up any thing associated with the task
// (ultimately offering any resources being consumed by that task to
// another task).
type TaskState int32

const (
	TaskState_TASK_STAGING  TaskState = 6
	TaskState_TASK_STARTING TaskState = 0
	TaskState_TASK_RUNNING  TaskState = 1
	TaskState_TASK_FINISHED TaskState = 2
	TaskState_TASK_FAILED   TaskState = 3
	TaskState_TASK_KILLED   TaskState = 4
	TaskState_TASK_LOST     TaskState = 5
	// TASK_ERROR is currently unused but will be introduced in 0.22.0.
	// TODO(dhamon): Start using TASK_ERROR.
	TaskState_TASK_ERROR TaskState = 7
)

var TaskState_name = map[int32]string{
	6: "TASK_STAGING",
	0: "TASK_STARTING",
	1: "TASK_RUNNING",
	2: "TASK_FINISHED",
	3: "TASK_FAILED",
	4: "TASK_KILLED",
	5: "TASK_LOST",
	7: "TASK_ERROR",
}
var TaskState_value = map[string]int32{
	"TASK_STAGING":  6,
	"TASK_STARTING": 0,
	"TASK_RUNNING":  1,
	"TASK_FINISHED": 2,
	"TASK_FAILED":   3,
	"TASK_KILLED":   4,
	"TASK_LOST":     5,
	"TASK_ERROR":    7,
}

func (x TaskState) Enum() *TaskState {
	p := new(TaskState)
	*p = x
	return p
}
func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (x *TaskState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskState_value, data, "TaskState")
	if err != nil {
		return err
	}
	*x = TaskState(value)
	return nil
}

type Value_Type int32

const (
	Value_SCALAR Value_Type = 0
	Value_RANGES Value_Type = 1
	Value_SET    Value_Type = 2
	Value_TEXT   Value_Type = 3
)

var Value_Type_name = map[int32]string{
	0: "SCALAR",
	1: "RANGES",
	2: "SET",
	3: "TEXT",
}
var Value_Type_value = map[string]int32{
	"SCALAR": 0,
	"RANGES": 1,
	"SET":    2,
	"TEXT":   3,
}

func (x Value_Type) Enum() *Value_Type {
	p := new(Value_Type)
	*p = x
	return p
}
func (x Value_Type) String() string {
	return proto.EnumName(Value_Type_name, int32(x))
}
func (x *Value_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Value_Type_value, data, "Value_Type")
	if err != nil {
		return err
	}
	*x = Value_Type(value)
	return nil
}

// * Describes the source of the task status update.
type TaskStatus_Source int32

const (
	TaskStatus_SOURCE_MASTER   TaskStatus_Source = 0
	TaskStatus_SOURCE_SLAVE    TaskStatus_Source = 1
	TaskStatus_SOURCE_EXECUTOR TaskStatus_Source = 2
)

var TaskStatus_Source_name = map[int32]string{
	0: "SOURCE_MASTER",
	1: "SOURCE_SLAVE",
	2: "SOURCE_EXECUTOR",
}
var TaskStatus_Source_value = map[string]int32{
	"SOURCE_MASTER":   0,
	"SOURCE_SLAVE":    1,
	"SOURCE_EXECUTOR": 2,
}

func (x TaskStatus_Source) Enum() *TaskStatus_Source {
	p := new(TaskStatus_Source)
	*p = x
	return p
}
func (x TaskStatus_Source) String() string {
	return proto.EnumName(TaskStatus_Source_name, int32(x))
}
func (x *TaskStatus_Source) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Source_value, data, "TaskStatus_Source")
	if err != nil {
		return err
	}
	*x = TaskStatus_Source(value)
	return nil
}

// * Detailed reason for the task status update.
type TaskStatus_Reason int32

const (
	TaskStatus_REASON_COMMAND_EXECUTOR_FAILED TaskStatus_Reason = 0
	TaskStatus_REASON_EXECUTOR_TERMINATED     TaskStatus_Reason = 1
	TaskStatus_REASON_EXECUTOR_UNREGISTERED   TaskStatus_Reason = 2
	TaskStatus_REASON_FRAMEWORK_REMOVED       TaskStatus_Reason = 3
	TaskStatus_REASON_GC_ERROR                TaskStatus_Reason = 4
	TaskStatus_REASON_INVALID_FRAMEWORKID     TaskStatus_Reason = 5
	TaskStatus_REASON_INVALID_OFFERS          TaskStatus_Reason = 6
	TaskStatus_REASON_MASTER_DISCONNECTED     TaskStatus_Reason = 7
	TaskStatus_REASON_MEMORY_LIMIT            TaskStatus_Reason = 8
	TaskStatus_REASON_RECONCILIATION          TaskStatus_Reason = 9
	TaskStatus_REASON_SLAVE_DISCONNECTED      TaskStatus_Reason = 10
	TaskStatus_REASON_SLAVE_REMOVED           TaskStatus_Reason = 11
	TaskStatus_REASON_SLAVE_RESTARTED         TaskStatus_Reason = 12
	TaskStatus_REASON_SLAVE_UNKNOWN           TaskStatus_Reason = 13
	TaskStatus_REASON_TASK_INVALID            TaskStatus_Reason = 14
	TaskStatus_REASON_TASK_UNAUTHORIZED       TaskStatus_Reason = 15
	TaskStatus_REASON_TASK_UNKNOWN            TaskStatus_Reason = 16
)

var TaskStatus_Reason_name = map[int32]string{
	0:  "REASON_COMMAND_EXECUTOR_FAILED",
	1:  "REASON_EXECUTOR_TERMINATED",
	2:  "REASON_EXECUTOR_UNREGISTERED",
	3:  "REASON_FRAMEWORK_REMOVED",
	4:  "REASON_GC_ERROR",
	5:  "REASON_INVALID_FRAMEWORKID",
	6:  "REASON_INVALID_OFFERS",
	7:  "REASON_MASTER_DISCONNECTED",
	8:  "REASON_MEMORY_LIMIT",
	9:  "REASON_RECONCILIATION",
	10: "REASON_SLAVE_DISCONNECTED",
	11: "REASON_SLAVE_REMOVED",
	12: "REASON_SLAVE_RESTARTED",
	13: "REASON_SLAVE_UNKNOWN",
	14: "REASON_TASK_INVALID",
	15: "REASON_TASK_UNAUTHORIZED",
	16: "REASON_TASK_UNKNOWN",
}
var TaskStatus_Reason_value = map[string]int32{
	"REASON_COMMAND_EXECUTOR_FAILED": 0,
	"REASON_EXECUTOR_TERMINATED":     1,
	"REASON_EXECUTOR_UNREGISTERED":   2,
	"REASON_FRAMEWORK_REMOVED":       3,
	"REASON_GC_ERROR":                4,
	"REASON_INVALID_FRAMEWORKID":     5,
	"REASON_INVALID_OFFERS":          6,
	"REASON_MASTER_DISCONNECTED":     7,
	"REASON_MEMORY_LIMIT":            8,
	"REASON_RECONCILIATION":          9,
	"REASON_SLAVE_DISCONNECTED":      10,
	"REASON_SLAVE_REMOVED":           11,
	"REASON_SLAVE_RESTARTED":         12,
	"REASON_SLAVE_UNKNOWN":           13,
	"REASON_TASK_INVALID":            14,
	"REASON_TASK_UNAUTHORIZED":       15,
	"REASON_TASK_UNKNOWN":            16,
}

func (x TaskStatus_Reason) Enum() *TaskStatus_Reason {
	p := new(TaskStatus_Reason)
	*p = x
	return p
}
func (x TaskStatus_Reason) String() string {
	return proto.EnumName(TaskStatus_Reason_name, int32(x))
}
func (x *TaskStatus_Reason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Reason_value, data, "TaskStatus_Reason")
	if err != nil {
		return err
	}
	*x = TaskStatus_Reason(value)
	return nil
}

type ACL_Entity_Type int32

const (
	ACL_Entity_SOME ACL_Entity_Type = 0
	ACL_Entity_ANY  ACL_Entity_Type = 1
	ACL_Entity_NONE ACL_Entity_Type = 2
)

var ACL_Entity_Type_name = map[int32]string{
	0: "SOME",
	1: "ANY",
	2: "NONE",
}
var ACL_Entity_Type_value = map[string]int32{
	"SOME": 0,
	"ANY":  1,
	"NONE": 2,
}

func (x ACL_Entity_Type) Enum() *ACL_Entity_Type {
	p := new(ACL_Entity_Type)
	*p = x
	return p
}
func (x ACL_Entity_Type) String() string {
	return proto.EnumName(ACL_Entity_Type_name, int32(x))
}
func (x *ACL_Entity_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ACL_Entity_Type_value, data, "ACL_Entity_Type")
	if err != nil {
		return err
	}
	*x = ACL_Entity_Type(value)
	return nil
}

type Volume_Mode int32

const (
	Volume_RW Volume_Mode = 1
	Volume_RO Volume_Mode = 2
)

var Volume_Mode_name = map[int32]string{
	1: "RW",
	2: "RO",
}
var Volume_Mode_value = map[string]int32{
	"RW": 1,
	"RO": 2,
}

func (x Volume_Mode) Enum() *Volume_Mode {
	p := new(Volume_Mode)
	*p = x
	return p
}
func (x Volume_Mode) String() string {
	return proto.EnumName(Volume_Mode_name, int32(x))
}
func (x *Volume_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Volume_Mode_value, data, "Volume_Mode")
	if err != nil {
		return err
	}
	*x = Volume_Mode(value)
	return nil
}

// All container implementation types.
type ContainerInfo_Type int32

const (
	ContainerInfo_DOCKER ContainerInfo_Type = 1
	ContainerInfo_MESOS  ContainerInfo_Type = 2
)

var ContainerInfo_Type_name = map[int32]string{
	1: "DOCKER",
	2: "MESOS",
}
var ContainerInfo_Type_value = map[string]int32{
	"DOCKER": 1,
	"MESOS":  2,
}

func (x ContainerInfo_Type) Enum() *ContainerInfo_Type {
	p := new(ContainerInfo_Type)
	*p = x
	return p
}
func (x ContainerInfo_Type) String() string {
	return proto.EnumName(ContainerInfo_Type_name, int32(x))
}
func (x *ContainerInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_Type_value, data, "ContainerInfo_Type")
	if err != nil {
		return err
	}
	*x = ContainerInfo_Type(value)
	return nil
}

// Network options.
type ContainerInfo_DockerInfo_Network int32

const (
	ContainerInfo_DockerInfo_HOST   ContainerInfo_DockerInfo_Network = 1
	ContainerInfo_DockerInfo_BRIDGE ContainerInfo_DockerInfo_Network = 2
	ContainerInfo_DockerInfo_NONE   ContainerInfo_DockerInfo_Network = 3
)

var ContainerInfo_DockerInfo_Network_name = map[int32]string{
	1: "HOST",
	2: "BRIDGE",
	3: "NONE",
}
var ContainerInfo_DockerInfo_Network_value = map[string]int32{
	"HOST":   1,
	"BRIDGE": 2,
	"NONE":   3,
}

func (x ContainerInfo_DockerInfo_Network) Enum() *ContainerInfo_DockerInfo_Network {
	p := new(ContainerInfo_DockerInfo_Network)
	*p = x
	return p
}
func (x ContainerInfo_DockerInfo_Network) String() string {
	return proto.EnumName(ContainerInfo_DockerInfo_Network_name, int32(x))
}
func (x *ContainerInfo_DockerInfo_Network) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_DockerInfo_Network_value, data, "ContainerInfo_DockerInfo_Network")
	if err != nil {
		return err
	}
	*x = ContainerInfo_DockerInfo_Network(value)
	return nil
}

// *
// A unique ID assigned to a framework. A framework can reuse this ID
// in order to do failover (see MesosSchedulerDriver).
type FrameworkID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FrameworkID) Reset()      { *m = FrameworkID{} }
func (*FrameworkID) ProtoMessage() {}

func (m *FrameworkID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A unique ID assigned to an offer.
type OfferID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *OfferID) Reset()      { *m = OfferID{} }
func (*OfferID) ProtoMessage() {}

func (m *OfferID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A unique ID assigned to a slave. Currently, a slave gets a new ID
// whenever it (re)registers with Mesos. Framework writers shouldn't
// assume any binding between a slave ID and and a hostname.
type SlaveID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SlaveID) Reset()      { *m = SlaveID{} }
func (*SlaveID) ProtoMessage() {}

func (m *SlaveID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A framework generated ID to distinguish a task. The ID must remain
// unique while the task is active. However, a framework can reuse an
// ID _only_ if a previous task with the same ID has reached a
// terminal state (e.g., TASK_FINISHED, TASK_LOST, TASK_KILLED, etc.).
type TaskID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TaskID) Reset()      { *m = TaskID{} }
func (*TaskID) ProtoMessage() {}

func (m *TaskID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A framework generated ID to distinguish an executor. Only one
// executor with the same ID can be active on the same slave at a
// time.
type ExecutorID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExecutorID) Reset()      { *m = ExecutorID{} }
func (*ExecutorID) ProtoMessage() {}

func (m *ExecutorID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A slave generated ID to distinguish a container. The ID must be unique
// between any active or completed containers on the slave. In particular,
// containers for different runs of the same (framework, executor) pair must be
// unique.
type ContainerID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerID) Reset()      { *m = ContainerID{} }
func (*ContainerID) ProtoMessage() {}

func (m *ContainerID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Describes a framework. The user field is used to determine the
// Unix user that an executor/task should be launched as. If the user
// field is set to an empty string Mesos will automagically set it
// to the current user. Note that the ID is only available after a
// framework has registered, however, it is included here in order to
// facilitate scheduler failover (i.e., if it is set then the
// MesosSchedulerDriver expects the scheduler is performing failover).
// The amount of time that the master will wait for the scheduler to
// failover before removing the framework is specified by
// failover_timeout. If checkpoint is set, framework pid, executor
// pids and status updates are checkpointed to disk by the slaves.
// Checkpointing allows a restarted slave to reconnect with old
// executors and recover status updates, at the cost of disk I/O.
// The role field is used to group frameworks for allocation
// decisions, depending on the allocation policy being used.
// If the hostname field is set to an empty string Mesos will
// automagically set it to the current hostname.
// The principal field should match the credential the framework uses
// in authentication. This field is used for framework API rate
// exporting and limiting and should be set even if authentication is
// not enabled if these features are desired.
// The webui_url field allows a framework to advertise its web UI, so
// that the Mesos web UI can link to it. It is expected to be a full
// URL, for example http://my-scheduler.example.com:8080/.
type FrameworkInfo struct {
	User             *string      `protobuf:"bytes,1,req,name=user" json:"user,omitempty"`
	Name             *string      `protobuf:"bytes,2,req,name=name" json:"name,omitempty"`
	Id               *FrameworkID `protobuf:"bytes,3,opt,name=id" json:"id,omitempty"`
	FailoverTimeout  *float64     `protobuf:"fixed64,4,opt,name=failover_timeout,def=0" json:"failover_timeout,omitempty"`
	Checkpoint       *bool        `protobuf:"varint,5,opt,name=checkpoint,def=0" json:"checkpoint,omitempty"`
	Role             *string      `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	Hostname         *string      `protobuf:"bytes,7,opt,name=hostname" json:"hostname,omitempty"`
	Principal        *string      `protobuf:"bytes,8,opt,name=principal" json:"principal,omitempty"`
	WebuiUrl         *string      `protobuf:"bytes,9,opt,name=webui_url" json:"webui_url,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *FrameworkInfo) Reset()      { *m = FrameworkInfo{} }
func (*FrameworkInfo) ProtoMessage() {}

const Default_FrameworkInfo_FailoverTimeout float64 = 0
const Default_FrameworkInfo_Checkpoint bool = false
const Default_FrameworkInfo_Role string = "*"

func (m *FrameworkInfo) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *FrameworkInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FrameworkInfo) GetId() *FrameworkID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *FrameworkInfo) GetFailoverTimeout() float64 {
	if m != nil && m.FailoverTimeout != nil {
		return *m.FailoverTimeout
	}
	return Default_FrameworkInfo_FailoverTimeout
}

func (m *FrameworkInfo) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return Default_FrameworkInfo_Checkpoint
}

func (m *FrameworkInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_FrameworkInfo_Role
}

func (m *FrameworkInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *FrameworkInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *FrameworkInfo) GetWebuiUrl() string {
	if m != nil && m.WebuiUrl != nil {
		return *m.WebuiUrl
	}
	return ""
}

// *
// Describes a health check for a task or executor (or any arbitrary
// process/command). A "strategy" is picked by specifying one of the
// optional fields, currently only 'http' and 'command' are
// supported. Specifying more than one strategy is an error.
type HealthCheck struct {
	Http *HealthCheck_HTTP `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
	// Amount of time to wait until starting the health checks.
	DelaySeconds *float64 `protobuf:"fixed64,2,opt,name=delay_seconds,def=15" json:"delay_seconds,omitempty"`
	// Interval between health checks.
	IntervalSeconds *float64 `protobuf:"fixed64,3,opt,name=interval_seconds,def=10" json:"interval_seconds,omitempty"`
	// Amount of time to wait for the health check to complete.
	TimeoutSeconds *float64 `protobuf:"fixed64,4,opt,name=timeout_seconds,def=20" json:"timeout_seconds,omitempty"`
	// Number of consecutive failures until considered unhealthy.
	ConsecutiveFailures *uint32 `protobuf:"varint,5,opt,name=consecutive_failures,def=3" json:"consecutive_failures,omitempty"`
	// Amount of time to allow failed health checks since launch.
	GracePeriodSeconds *float64 `protobuf:"fixed64,6,opt,name=grace_period_seconds,def=10" json:"grace_period_seconds,omitempty"`
	// Command health check.
	Command          *CommandInfo `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *HealthCheck) Reset()      { *m = HealthCheck{} }
func (*HealthCheck) ProtoMessage() {}

const Default_HealthCheck_DelaySeconds float64 = 15
const Default_HealthCheck_IntervalSeconds float64 = 10
const Default_HealthCheck_TimeoutSeconds float64 = 20
const Default_HealthCheck_ConsecutiveFailures uint32 = 3
const Default_HealthCheck_GracePeriodSeconds float64 = 10

func (m *HealthCheck) GetHttp() *HealthCheck_HTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *HealthCheck) GetDelaySeconds() float64 {
	if m != nil && m.DelaySeconds != nil {
		return *m.DelaySeconds
	}
	return Default_HealthCheck_DelaySeconds
}

func (m *HealthCheck) GetIntervalSeconds() float64 {
	if m != nil && m.IntervalSeconds != nil {
		return *m.IntervalSeconds
	}
	return Default_HealthCheck_IntervalSeconds
}

func (m *HealthCheck) GetTimeoutSeconds() float64 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return Default_HealthCheck_TimeoutSeconds
}

func (m *HealthCheck) GetConsecutiveFailures() uint32 {
	if m != nil && m.ConsecutiveFailures != nil {
		return *m.ConsecutiveFailures
	}
	return Default_HealthCheck_ConsecutiveFailures
}

func (m *HealthCheck) GetGracePeriodSeconds() float64 {
	if m != nil && m.GracePeriodSeconds != nil {
		return *m.GracePeriodSeconds
	}
	return Default_HealthCheck_GracePeriodSeconds
}

func (m *HealthCheck) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

// Describes an HTTP health check.
type HealthCheck_HTTP struct {
	// Port to send the HTTP request.
	Port *uint32 `protobuf:"varint,1,req,name=port" json:"port,omitempty"`
	// HTTP request path.
	Path *string `protobuf:"bytes,2,opt,name=path,def=/" json:"path,omitempty"`
	// Expected response statuses. Not specifying any statuses implies
	// that any returned status is acceptable.
	Statuses         []uint32 `protobuf:"varint,4,rep,name=statuses" json:"statuses,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *HealthCheck_HTTP) Reset()      { *m = HealthCheck_HTTP{} }
func (*HealthCheck_HTTP) ProtoMessage() {}

const Default_HealthCheck_HTTP_Path string = "/"

func (m *HealthCheck_HTTP) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *HealthCheck_HTTP) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return Default_HealthCheck_HTTP_Path
}

func (m *HealthCheck_HTTP) GetStatuses() []uint32 {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// *
// Describes a command, executed via: '/bin/sh -c value'. Any URIs specified
// are fetched before executing the command.  If the executable field for an
// uri is set, executable file permission is set on the downloaded file.
// Otherwise, if the downloaded file has a recognized archive extension
// (currently [compressed] tar and zip) it is extracted into the executor's
// working directory. This extraction can be disabled by setting `extract` to
// false. In addition, any environment variables are set before executing
// the command (so they can be used to "parameterize" your command).
type CommandInfo struct {
	// NOTE: MesosContainerizer does currently not support this
	// attribute and tasks supplying a 'container' will fail.
	Container   *CommandInfo_ContainerInfo `protobuf:"bytes,4,opt,name=container" json:"container,omitempty"`
	Uris        []*CommandInfo_URI         `protobuf:"bytes,1,rep,name=uris" json:"uris,omitempty"`
	Environment *Environment               `protobuf:"bytes,2,opt,name=environment" json:"environment,omitempty"`
	// There are two ways to specify the command:
	// 1) If 'shell == true', the command will be launched via shell
	// 		(i.e., /bin/sh -c 'value'). The 'value' specified will be
	// 		treated as the shell command. The 'arguments' will be ignored.
	// 2) If 'shell == false', the command will be launched by passing
	// 		arguments to an executable. The 'value' specified will be
	// 		treated as the filename of the executable. The 'arguments'
	// 		will be treated as the arguments to the executable. This is
	// 		similar to how POSIX exec families launch processes (i.e.,
	// 		execlp(value, arguments(0), arguments(1), ...)).
	// NOTE: The field 'value' is changed from 'required' to 'optional'
	// in 0.20.0. It will only cause issues if a new framework is
	// connecting to an old master.
	Shell     *bool    `protobuf:"varint,6,opt,name=shell,def=1" json:"shell,omitempty"`
	Value     *string  `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	Arguments []string `protobuf:"bytes,7,rep,name=arguments" json:"arguments,omitempty"`
	// Enables executor and tasks to run as a specific user. If the user
	// field is present both in FrameworkInfo and here, the CommandInfo
	// user value takes precedence.
	User             *string `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CommandInfo) Reset()      { *m = CommandInfo{} }
func (*CommandInfo) ProtoMessage() {}

const Default_CommandInfo_Shell bool = true

func (m *CommandInfo) GetContainer() *CommandInfo_ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *CommandInfo) GetUris() []*CommandInfo_URI {
	if m != nil {
		return m.Uris
	}
	return nil
}

func (m *CommandInfo) GetEnvironment() *Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *CommandInfo) GetShell() bool {
	if m != nil && m.Shell != nil {
		return *m.Shell
	}
	return Default_CommandInfo_Shell
}

func (m *CommandInfo) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *CommandInfo) GetArguments() []string {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *CommandInfo) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

type CommandInfo_URI struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	Executable       *bool   `protobuf:"varint,2,opt,name=executable" json:"executable,omitempty"`
	Extract          *bool   `protobuf:"varint,3,opt,name=extract,def=1" json:"extract,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CommandInfo_URI) Reset()      { *m = CommandInfo_URI{} }
func (*CommandInfo_URI) ProtoMessage() {}

const Default_CommandInfo_URI_Extract bool = true

func (m *CommandInfo_URI) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *CommandInfo_URI) GetExecutable() bool {
	if m != nil && m.Executable != nil {
		return *m.Executable
	}
	return false
}

func (m *CommandInfo_URI) GetExtract() bool {
	if m != nil && m.Extract != nil {
		return *m.Extract
	}
	return Default_CommandInfo_URI_Extract
}

// Describes a container.
// Not all containerizers currently implement ContainerInfo, so it
// is possible that a launched task will fail due to supplying this
// attribute.
// NOTE: The containerizer API is currently in an early beta or
// even alpha state. Some details, like the exact semantics of an
// "image" or "options" are not yet hardened.
// TODO(tillt): Describe the exact scheme and semantics of "image"
// and "options".
type CommandInfo_ContainerInfo struct {
	// URI describing the container image name.
	Image *string `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	// Describes additional options passed to the containerizer.
	Options          []string `protobuf:"bytes,2,rep,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *CommandInfo_ContainerInfo) Reset()      { *m = CommandInfo_ContainerInfo{} }
func (*CommandInfo_ContainerInfo) ProtoMessage() {}

func (m *CommandInfo_ContainerInfo) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *CommandInfo_ContainerInfo) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

// *
// Describes information about an executor. The 'data' field can be
// used to pass arbitrary bytes to an executor.
type ExecutorInfo struct {
	ExecutorId  *ExecutorID  `protobuf:"bytes,1,req,name=executor_id" json:"executor_id,omitempty"`
	FrameworkId *FrameworkID `protobuf:"bytes,8,opt,name=framework_id" json:"framework_id,omitempty"`
	Command     *CommandInfo `protobuf:"bytes,7,req,name=command" json:"command,omitempty"`
	// Executor provided with a container will launch the container
	// with the executor's CommandInfo and we expect the container to
	// act as a Mesos executor.
	Container *ContainerInfo `protobuf:"bytes,11,opt,name=container" json:"container,omitempty"`
	Resources []*Resource    `protobuf:"bytes,5,rep,name=resources" json:"resources,omitempty"`
	Name      *string        `protobuf:"bytes,9,opt,name=name" json:"name,omitempty"`
	// Source is an identifier style string used by frameworks to track
	// the source of an executor. This is useful when it's possible for
	// different executor ids to be related semantically.
	// NOTE: Source is exposed alongside the resource usage of the
	// executor via JSON on the slave. This allows users to import
	// usage information into a time series database for monitoring.
	Source           *string `protobuf:"bytes,10,opt,name=source" json:"source,omitempty"`
	Data             []byte  `protobuf:"bytes,4,opt,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExecutorInfo) Reset()      { *m = ExecutorInfo{} }
func (*ExecutorInfo) ProtoMessage() {}

func (m *ExecutorInfo) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ExecutorInfo) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ExecutorInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ExecutorInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *ExecutorInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ExecutorInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ExecutorInfo) GetSource() string {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return ""
}

func (m *ExecutorInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// *
// Describes a master. This will probably have more fields in the
// future which might be used, for example, to link a framework webui
// to a master webui.
type MasterInfo struct {
	Id               *string `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	Ip               *uint32 `protobuf:"varint,2,req,name=ip" json:"ip,omitempty"`
	Port             *uint32 `protobuf:"varint,3,req,name=port,def=5050" json:"port,omitempty"`
	Pid              *string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	Hostname         *string `protobuf:"bytes,5,opt,name=hostname" json:"hostname,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *MasterInfo) Reset()      { *m = MasterInfo{} }
func (*MasterInfo) ProtoMessage() {}

const Default_MasterInfo_Port uint32 = 5050

func (m *MasterInfo) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *MasterInfo) GetIp() uint32 {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return 0
}

func (m *MasterInfo) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_MasterInfo_Port
}

func (m *MasterInfo) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

func (m *MasterInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

// *
// Describes a slave. Note that the 'id' field is only available after
// a slave is registered with the master, and is made available here
// to facilitate re-registration.  If checkpoint is set, the slave is
// checkpointing its own information and potentially frameworks'
// information (if a framework has checkpointing enabled).
type SlaveInfo struct {
	Hostname         *string      `protobuf:"bytes,1,req,name=hostname" json:"hostname,omitempty"`
	Port             *int32       `protobuf:"varint,8,opt,name=port,def=5051" json:"port,omitempty"`
	Resources        []*Resource  `protobuf:"bytes,3,rep,name=resources" json:"resources,omitempty"`
	Attributes       []*Attribute `protobuf:"bytes,5,rep,name=attributes" json:"attributes,omitempty"`
	Id               *SlaveID     `protobuf:"bytes,6,opt,name=id" json:"id,omitempty"`
	Checkpoint       *bool        `protobuf:"varint,7,opt,name=checkpoint,def=0" json:"checkpoint,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *SlaveInfo) Reset()      { *m = SlaveInfo{} }
func (*SlaveInfo) ProtoMessage() {}

const Default_SlaveInfo_Port int32 = 5051
const Default_SlaveInfo_Checkpoint bool = false

func (m *SlaveInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *SlaveInfo) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_SlaveInfo_Port
}

func (m *SlaveInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *SlaveInfo) GetAttributes() []*Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *SlaveInfo) GetId() *SlaveID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *SlaveInfo) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return Default_SlaveInfo_Checkpoint
}

// *
// Describes an Attribute or Resource "value". A value is described
// using the standard protocol buffer "union" trick.
type Value struct {
	Type             *Value_Type   `protobuf:"varint,1,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar           *Value_Scalar `protobuf:"bytes,2,opt,name=scalar" json:"scalar,omitempty"`
	Ranges           *Value_Ranges `protobuf:"bytes,3,opt,name=ranges" json:"ranges,omitempty"`
	Set              *Value_Set    `protobuf:"bytes,4,opt,name=set" json:"set,omitempty"`
	Text             *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Value) Reset()      { *m = Value{} }
func (*Value) ProtoMessage() {}

func (m *Value) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Value) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Value) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Value) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Value) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

type Value_Scalar struct {
	Value            *float64 `protobuf:"fixed64,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Value_Scalar) Reset()      { *m = Value_Scalar{} }
func (*Value_Scalar) ProtoMessage() {}

func (m *Value_Scalar) GetValue() float64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

type Value_Range struct {
	Begin            *uint64 `protobuf:"varint,1,req,name=begin" json:"begin,omitempty"`
	End              *uint64 `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Value_Range) Reset()      { *m = Value_Range{} }
func (*Value_Range) ProtoMessage() {}

func (m *Value_Range) GetBegin() uint64 {
	if m != nil && m.Begin != nil {
		return *m.Begin
	}
	return 0
}

func (m *Value_Range) GetEnd() uint64 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

type Value_Ranges struct {
	Range            []*Value_Range `protobuf:"bytes,1,rep,name=range" json:"range,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Value_Ranges) Reset()      { *m = Value_Ranges{} }
func (*Value_Ranges) ProtoMessage() {}

func (m *Value_Ranges) GetRange() []*Value_Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type Value_Set struct {
	Item             []string `protobuf:"bytes,1,rep,name=item" json:"item,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Value_Set) Reset()      { *m = Value_Set{} }
func (*Value_Set) ProtoMessage() {}

func (m *Value_Set) GetItem() []string {
	if m != nil {
		return m.Item
	}
	return nil
}

type Value_Text struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Value_Text) Reset()      { *m = Value_Text{} }
func (*Value_Text) ProtoMessage() {}

func (m *Value_Text) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Describes an attribute that can be set on a machine. For now,
// attributes and resources share the same "value" type, but this may
// change in the future and attributes may only be string based.
type Attribute struct {
	Name             *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *Value_Type   `protobuf:"varint,2,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar           *Value_Scalar `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges           *Value_Ranges `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set              *Value_Set    `protobuf:"bytes,6,opt,name=set" json:"set,omitempty"`
	Text             *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Attribute) Reset()      { *m = Attribute{} }
func (*Attribute) ProtoMessage() {}

func (m *Attribute) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Attribute) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Attribute) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Attribute) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Attribute) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Attribute) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

// *
// Describes a resource on a machine. A resource can take on one of
// three types: scalar (double), a list of finite and discrete ranges
// (e.g., [1-10, 20-30]), or a set of items. A resource is described
// using the standard protocol buffer "union" trick.
//
// TODO(benh): Add better support for "expected" resources (e.g.,
// cpus, memory, disk, network).
type Resource struct {
	Name             *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *Value_Type   `protobuf:"varint,2,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar           *Value_Scalar `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges           *Value_Ranges `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set              *Value_Set    `protobuf:"bytes,5,opt,name=set" json:"set,omitempty"`
	Role             *string       `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Resource) Reset()      { *m = Resource{} }
func (*Resource) ProtoMessage() {}

const Default_Resource_Role string = "*"

func (m *Resource) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Resource) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Resource) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Resource) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Resource) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Resource) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_Resource_Role
}

//
// A snapshot of resource usage statistics.
type ResourceStatistics struct {
	Timestamp *float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp,omitempty"`
	// CPU Usage Information:
	// Total CPU time spent in user mode, and kernel mode.
	CpusUserTimeSecs   *float64 `protobuf:"fixed64,2,opt,name=cpus_user_time_secs" json:"cpus_user_time_secs,omitempty"`
	CpusSystemTimeSecs *float64 `protobuf:"fixed64,3,opt,name=cpus_system_time_secs" json:"cpus_system_time_secs,omitempty"`
	// Number of CPUs allocated.
	CpusLimit *float64 `protobuf:"fixed64,4,opt,name=cpus_limit" json:"cpus_limit,omitempty"`
	// cpu.stat on process throttling (for contention issues).
	CpusNrPeriods         *uint32  `protobuf:"varint,7,opt,name=cpus_nr_periods" json:"cpus_nr_periods,omitempty"`
	CpusNrThrottled       *uint32  `protobuf:"varint,8,opt,name=cpus_nr_throttled" json:"cpus_nr_throttled,omitempty"`
	CpusThrottledTimeSecs *float64 `protobuf:"fixed64,9,opt,name=cpus_throttled_time_secs" json:"cpus_throttled_time_secs,omitempty"`
	// Memory Usage Information:
	MemRssBytes *uint64 `protobuf:"varint,5,opt,name=mem_rss_bytes" json:"mem_rss_bytes,omitempty"`
	// Amount of memory resources allocated.
	MemLimitBytes *uint64 `protobuf:"varint,6,opt,name=mem_limit_bytes" json:"mem_limit_bytes,omitempty"`
	// Broken out memory usage information (files, anonymous, and mmaped files)
	MemFileBytes       *uint64 `protobuf:"varint,10,opt,name=mem_file_bytes" json:"mem_file_bytes,omitempty"`
	MemAnonBytes       *uint64 `protobuf:"varint,11,opt,name=mem_anon_bytes" json:"mem_anon_bytes,omitempty"`
	MemMappedFileBytes *uint64 `protobuf:"varint,12,opt,name=mem_mapped_file_bytes" json:"mem_mapped_file_bytes,omitempty"`
	// Perf statistics.
	Perf *PerfStatistics `protobuf:"bytes,13,opt,name=perf" json:"perf,omitempty"`
	// Network Usage Information:
	NetRxPackets *uint64 `protobuf:"varint,14,opt,name=net_rx_packets" json:"net_rx_packets,omitempty"`
	NetRxBytes   *uint64 `protobuf:"varint,15,opt,name=net_rx_bytes" json:"net_rx_bytes,omitempty"`
	NetRxErrors  *uint64 `protobuf:"varint,16,opt,name=net_rx_errors" json:"net_rx_errors,omitempty"`
	NetRxDropped *uint64 `protobuf:"varint,17,opt,name=net_rx_dropped" json:"net_rx_dropped,omitempty"`
	NetTxPackets *uint64 `protobuf:"varint,18,opt,name=net_tx_packets" json:"net_tx_packets,omitempty"`
	NetTxBytes   *uint64 `protobuf:"varint,19,opt,name=net_tx_bytes" json:"net_tx_bytes,omitempty"`
	NetTxErrors  *uint64 `protobuf:"varint,20,opt,name=net_tx_errors" json:"net_tx_errors,omitempty"`
	NetTxDropped *uint64 `protobuf:"varint,21,opt,name=net_tx_dropped" json:"net_tx_dropped,omitempty"`
	// The kernel keeps track of RTT (round-trip time) for its TCP
	// sockets. RTT is a way to tell the latency of a container.
	NetTcpRttMicrosecsP50 *float64 `protobuf:"fixed64,22,opt,name=net_tcp_rtt_microsecs_p50" json:"net_tcp_rtt_microsecs_p50,omitempty"`
	NetTcpRttMicrosecsP90 *float64 `protobuf:"fixed64,23,opt,name=net_tcp_rtt_microsecs_p90" json:"net_tcp_rtt_microsecs_p90,omitempty"`
	NetTcpRttMicrosecsP95 *float64 `protobuf:"fixed64,24,opt,name=net_tcp_rtt_microsecs_p95" json:"net_tcp_rtt_microsecs_p95,omitempty"`
	NetTcpRttMicrosecsP99 *float64 `protobuf:"fixed64,25,opt,name=net_tcp_rtt_microsecs_p99" json:"net_tcp_rtt_microsecs_p99,omitempty"`
	XXX_unrecognized      []byte   `json:"-"`
}

func (m *ResourceStatistics) Reset()      { *m = ResourceStatistics{} }
func (*ResourceStatistics) ProtoMessage() {}

func (m *ResourceStatistics) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *ResourceStatistics) GetCpusUserTimeSecs() float64 {
	if m != nil && m.CpusUserTimeSecs != nil {
		return *m.CpusUserTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCpusSystemTimeSecs() float64 {
	if m != nil && m.CpusSystemTimeSecs != nil {
		return *m.CpusSystemTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCpusLimit() float64 {
	if m != nil && m.CpusLimit != nil {
		return *m.CpusLimit
	}
	return 0
}

func (m *ResourceStatistics) GetCpusNrPeriods() uint32 {
	if m != nil && m.CpusNrPeriods != nil {
		return *m.CpusNrPeriods
	}
	return 0
}

func (m *ResourceStatistics) GetCpusNrThrottled() uint32 {
	if m != nil && m.CpusNrThrottled != nil {
		return *m.CpusNrThrottled
	}
	return 0
}

func (m *ResourceStatistics) GetCpusThrottledTimeSecs() float64 {
	if m != nil && m.CpusThrottledTimeSecs != nil {
		return *m.CpusThrottledTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetMemRssBytes() uint64 {
	if m != nil && m.MemRssBytes != nil {
		return *m.MemRssBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemLimitBytes() uint64 {
	if m != nil && m.MemLimitBytes != nil {
		return *m.MemLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemFileBytes() uint64 {
	if m != nil && m.MemFileBytes != nil {
		return *m.MemFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemAnonBytes() uint64 {
	if m != nil && m.MemAnonBytes != nil {
		return *m.MemAnonBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemMappedFileBytes() uint64 {
	if m != nil && m.MemMappedFileBytes != nil {
		return *m.MemMappedFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetPerf() *PerfStatistics {
	if m != nil {
		return m.Perf
	}
	return nil
}

func (m *ResourceStatistics) GetNetRxPackets() uint64 {
	if m != nil && m.NetRxPackets != nil {
		return *m.NetRxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxBytes() uint64 {
	if m != nil && m.NetRxBytes != nil {
		return *m.NetRxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxErrors() uint64 {
	if m != nil && m.NetRxErrors != nil {
		return *m.NetRxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxDropped() uint64 {
	if m != nil && m.NetRxDropped != nil {
		return *m.NetRxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxPackets() uint64 {
	if m != nil && m.NetTxPackets != nil {
		return *m.NetTxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxBytes() uint64 {
	if m != nil && m.NetTxBytes != nil {
		return *m.NetTxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxErrors() uint64 {
	if m != nil && m.NetTxErrors != nil {
		return *m.NetTxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxDropped() uint64 {
	if m != nil && m.NetTxDropped != nil {
		return *m.NetTxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP50() float64 {
	if m != nil && m.NetTcpRttMicrosecsP50 != nil {
		return *m.NetTcpRttMicrosecsP50
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP90() float64 {
	if m != nil && m.NetTcpRttMicrosecsP90 != nil {
		return *m.NetTcpRttMicrosecsP90
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP95() float64 {
	if m != nil && m.NetTcpRttMicrosecsP95 != nil {
		return *m.NetTcpRttMicrosecsP95
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP99() float64 {
	if m != nil && m.NetTcpRttMicrosecsP99 != nil {
		return *m.NetTcpRttMicrosecsP99
	}
	return 0
}

// *
// Describes a snapshot of the resource usage for an executor.
//
// TODO(bmahler): Note that we want to be sending this information
// to the master, and subsequently to the relevant scheduler. So
// this proto is designed to be easy for the scheduler to use, this
// is why we provide the slave id, executor info / task info.
type ResourceUsage struct {
	SlaveId      *SlaveID     `protobuf:"bytes,1,req,name=slave_id" json:"slave_id,omitempty"`
	FrameworkId  *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	ExecutorId   *ExecutorID  `protobuf:"bytes,3,opt,name=executor_id" json:"executor_id,omitempty"`
	ExecutorName *string      `protobuf:"bytes,4,opt,name=executor_name" json:"executor_name,omitempty"`
	TaskId       *TaskID      `protobuf:"bytes,5,opt,name=task_id" json:"task_id,omitempty"`
	// If missing, the isolation module cannot provide resource usage.
	Statistics       *ResourceStatistics `protobuf:"bytes,6,opt,name=statistics" json:"statistics,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *ResourceUsage) Reset()      { *m = ResourceUsage{} }
func (*ResourceUsage) ProtoMessage() {}

func (m *ResourceUsage) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *ResourceUsage) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ResourceUsage) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ResourceUsage) GetExecutorName() string {
	if m != nil && m.ExecutorName != nil {
		return *m.ExecutorName
	}
	return ""
}

func (m *ResourceUsage) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *ResourceUsage) GetStatistics() *ResourceStatistics {
	if m != nil {
		return m.Statistics
	}
	return nil
}

// *
// Describes a sample of events from "perf stat". Only available on
// Linux.
//
// NOTE: Each optional field matches the name of a perf event (see
// "perf list") with the following changes:
// 1. Names are downcased.
// 2. Hyphens ('-') are replaced with underscores ('_').
// 3. Events with alternate names use the name "perf stat" returns,
//    e.g., for the event "cycles OR cpu-cycles" perf always returns
//    cycles.
type PerfStatistics struct {
	Timestamp *float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp,omitempty"`
	Duration  *float64 `protobuf:"fixed64,2,req,name=duration" json:"duration,omitempty"`
	// Hardware event.
	Cycles                *uint64 `protobuf:"varint,3,opt,name=cycles" json:"cycles,omitempty"`
	StalledCyclesFrontend *uint64 `protobuf:"varint,4,opt,name=stalled_cycles_frontend" json:"stalled_cycles_frontend,omitempty"`
	StalledCyclesBackend  *uint64 `protobuf:"varint,5,opt,name=stalled_cycles_backend" json:"stalled_cycles_backend,omitempty"`
	Instructions          *uint64 `protobuf:"varint,6,opt,name=instructions" json:"instructions,omitempty"`
	CacheReferences       *uint64 `protobuf:"varint,7,opt,name=cache_references" json:"cache_references,omitempty"`
	CacheMisses           *uint64 `protobuf:"varint,8,opt,name=cache_misses" json:"cache_misses,omitempty"`
	Branches              *uint64 `protobuf:"varint,9,opt,name=branches" json:"branches,omitempty"`
	BranchMisses          *uint64 `protobuf:"varint,10,opt,name=branch_misses" json:"branch_misses,omitempty"`
	BusCycles             *uint64 `protobuf:"varint,11,opt,name=bus_cycles" json:"bus_cycles,omitempty"`
	RefCycles             *uint64 `protobuf:"varint,12,opt,name=ref_cycles" json:"ref_cycles,omitempty"`
	// Software event.
	CpuClock        *float64 `protobuf:"fixed64,13,opt,name=cpu_clock" json:"cpu_clock,omitempty"`
	TaskClock       *float64 `protobuf:"fixed64,14,opt,name=task_clock" json:"task_clock,omitempty"`
	PageFaults      *uint64  `protobuf:"varint,15,opt,name=page_faults" json:"page_faults,omitempty"`
	MinorFaults     *uint64  `protobuf:"varint,16,opt,name=minor_faults" json:"minor_faults,omitempty"`
	MajorFaults     *uint64  `protobuf:"varint,17,opt,name=major_faults" json:"major_faults,omitempty"`
	ContextSwitches *uint64  `protobuf:"varint,18,opt,name=context_switches" json:"context_switches,omitempty"`
	CpuMigrations   *uint64  `protobuf:"varint,19,opt,name=cpu_migrations" json:"cpu_migrations,omitempty"`
	AlignmentFaults *uint64  `protobuf:"varint,20,opt,name=alignment_faults" json:"alignment_faults,omitempty"`
	EmulationFaults *uint64  `protobuf:"varint,21,opt,name=emulation_faults" json:"emulation_faults,omitempty"`
	// Hardware cache event.
	L1DcacheLoads          *uint64 `protobuf:"varint,22,opt,name=l1_dcache_loads" json:"l1_dcache_loads,omitempty"`
	L1DcacheLoadMisses     *uint64 `protobuf:"varint,23,opt,name=l1_dcache_load_misses" json:"l1_dcache_load_misses,omitempty"`
	L1DcacheStores         *uint64 `protobuf:"varint,24,opt,name=l1_dcache_stores" json:"l1_dcache_stores,omitempty"`
	L1DcacheStoreMisses    *uint64 `protobuf:"varint,25,opt,name=l1_dcache_store_misses" json:"l1_dcache_store_misses,omitempty"`
	L1DcachePrefetches     *uint64 `protobuf:"varint,26,opt,name=l1_dcache_prefetches" json:"l1_dcache_prefetches,omitempty"`
	L1DcachePrefetchMisses *uint64 `protobuf:"varint,27,opt,name=l1_dcache_prefetch_misses" json:"l1_dcache_prefetch_misses,omitempty"`
	L1IcacheLoads          *uint64 `protobuf:"varint,28,opt,name=l1_icache_loads" json:"l1_icache_loads,omitempty"`
	L1IcacheLoadMisses     *uint64 `protobuf:"varint,29,opt,name=l1_icache_load_misses" json:"l1_icache_load_misses,omitempty"`
	L1IcachePrefetches     *uint64 `protobuf:"varint,30,opt,name=l1_icache_prefetches" json:"l1_icache_prefetches,omitempty"`
	L1IcachePrefetchMisses *uint64 `protobuf:"varint,31,opt,name=l1_icache_prefetch_misses" json:"l1_icache_prefetch_misses,omitempty"`
	LlcLoads               *uint64 `protobuf:"varint,32,opt,name=llc_loads" json:"llc_loads,omitempty"`
	LlcLoadMisses          *uint64 `protobuf:"varint,33,opt,name=llc_load_misses" json:"llc_load_misses,omitempty"`
	LlcStores              *uint64 `protobuf:"varint,34,opt,name=llc_stores" json:"llc_stores,omitempty"`
	LlcStoreMisses         *uint64 `protobuf:"varint,35,opt,name=llc_store_misses" json:"llc_store_misses,omitempty"`
	LlcPrefetches          *uint64 `protobuf:"varint,36,opt,name=llc_prefetches" json:"llc_prefetches,omitempty"`
	LlcPrefetchMisses      *uint64 `protobuf:"varint,37,opt,name=llc_prefetch_misses" json:"llc_prefetch_misses,omitempty"`
	DtlbLoads              *uint64 `protobuf:"varint,38,opt,name=dtlb_loads" json:"dtlb_loads,omitempty"`
	DtlbLoadMisses         *uint64 `protobuf:"varint,39,opt,name=dtlb_load_misses" json:"dtlb_load_misses,omitempty"`
	DtlbStores             *uint64 `protobuf:"varint,40,opt,name=dtlb_stores" json:"dtlb_stores,omitempty"`
	DtlbStoreMisses        *uint64 `protobuf:"varint,41,opt,name=dtlb_store_misses" json:"dtlb_store_misses,omitempty"`
	DtlbPrefetches         *uint64 `protobuf:"varint,42,opt,name=dtlb_prefetches" json:"dtlb_prefetches,omitempty"`
	DtlbPrefetchMisses     *uint64 `protobuf:"varint,43,opt,name=dtlb_prefetch_misses" json:"dtlb_prefetch_misses,omitempty"`
	ItlbLoads              *uint64 `protobuf:"varint,44,opt,name=itlb_loads" json:"itlb_loads,omitempty"`
	ItlbLoadMisses         *uint64 `protobuf:"varint,45,opt,name=itlb_load_misses" json:"itlb_load_misses,omitempty"`
	BranchLoads            *uint64 `protobuf:"varint,46,opt,name=branch_loads" json:"branch_loads,omitempty"`
	BranchLoadMisses       *uint64 `protobuf:"varint,47,opt,name=branch_load_misses" json:"branch_load_misses,omitempty"`
	NodeLoads              *uint64 `protobuf:"varint,48,opt,name=node_loads" json:"node_loads,omitempty"`
	NodeLoadMisses         *uint64 `protobuf:"varint,49,opt,name=node_load_misses" json:"node_load_misses,omitempty"`
	NodeStores             *uint64 `protobuf:"varint,50,opt,name=node_stores" json:"node_stores,omitempty"`
	NodeStoreMisses        *uint64 `protobuf:"varint,51,opt,name=node_store_misses" json:"node_store_misses,omitempty"`
	NodePrefetches         *uint64 `protobuf:"varint,52,opt,name=node_prefetches" json:"node_prefetches,omitempty"`
	NodePrefetchMisses     *uint64 `protobuf:"varint,53,opt,name=node_prefetch_misses" json:"node_prefetch_misses,omitempty"`
	XXX_unrecognized       []byte  `json:"-"`
}

func (m *PerfStatistics) Reset()      { *m = PerfStatistics{} }
func (*PerfStatistics) ProtoMessage() {}

func (m *PerfStatistics) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *PerfStatistics) GetDuration() float64 {
	if m != nil && m.Duration != nil {
		return *m.Duration
	}
	return 0
}

func (m *PerfStatistics) GetCycles() uint64 {
	if m != nil && m.Cycles != nil {
		return *m.Cycles
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesFrontend() uint64 {
	if m != nil && m.StalledCyclesFrontend != nil {
		return *m.StalledCyclesFrontend
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesBackend() uint64 {
	if m != nil && m.StalledCyclesBackend != nil {
		return *m.StalledCyclesBackend
	}
	return 0
}

func (m *PerfStatistics) GetInstructions() uint64 {
	if m != nil && m.Instructions != nil {
		return *m.Instructions
	}
	return 0
}

func (m *PerfStatistics) GetCacheReferences() uint64 {
	if m != nil && m.CacheReferences != nil {
		return *m.CacheReferences
	}
	return 0
}

func (m *PerfStatistics) GetCacheMisses() uint64 {
	if m != nil && m.CacheMisses != nil {
		return *m.CacheMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranches() uint64 {
	if m != nil && m.Branches != nil {
		return *m.Branches
	}
	return 0
}

func (m *PerfStatistics) GetBranchMisses() uint64 {
	if m != nil && m.BranchMisses != nil {
		return *m.BranchMisses
	}
	return 0
}

func (m *PerfStatistics) GetBusCycles() uint64 {
	if m != nil && m.BusCycles != nil {
		return *m.BusCycles
	}
	return 0
}

func (m *PerfStatistics) GetRefCycles() uint64 {
	if m != nil && m.RefCycles != nil {
		return *m.RefCycles
	}
	return 0
}

func (m *PerfStatistics) GetCpuClock() float64 {
	if m != nil && m.CpuClock != nil {
		return *m.CpuClock
	}
	return 0
}

func (m *PerfStatistics) GetTaskClock() float64 {
	if m != nil && m.TaskClock != nil {
		return *m.TaskClock
	}
	return 0
}

func (m *PerfStatistics) GetPageFaults() uint64 {
	if m != nil && m.PageFaults != nil {
		return *m.PageFaults
	}
	return 0
}

func (m *PerfStatistics) GetMinorFaults() uint64 {
	if m != nil && m.MinorFaults != nil {
		return *m.MinorFaults
	}
	return 0
}

func (m *PerfStatistics) GetMajorFaults() uint64 {
	if m != nil && m.MajorFaults != nil {
		return *m.MajorFaults
	}
	return 0
}

func (m *PerfStatistics) GetContextSwitches() uint64 {
	if m != nil && m.ContextSwitches != nil {
		return *m.ContextSwitches
	}
	return 0
}

func (m *PerfStatistics) GetCpuMigrations() uint64 {
	if m != nil && m.CpuMigrations != nil {
		return *m.CpuMigrations
	}
	return 0
}

func (m *PerfStatistics) GetAlignmentFaults() uint64 {
	if m != nil && m.AlignmentFaults != nil {
		return *m.AlignmentFaults
	}
	return 0
}

func (m *PerfStatistics) GetEmulationFaults() uint64 {
	if m != nil && m.EmulationFaults != nil {
		return *m.EmulationFaults
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoads() uint64 {
	if m != nil && m.L1DcacheLoads != nil {
		return *m.L1DcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoadMisses() uint64 {
	if m != nil && m.L1DcacheLoadMisses != nil {
		return *m.L1DcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStores() uint64 {
	if m != nil && m.L1DcacheStores != nil {
		return *m.L1DcacheStores
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStoreMisses() uint64 {
	if m != nil && m.L1DcacheStoreMisses != nil {
		return *m.L1DcacheStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetches() uint64 {
	if m != nil && m.L1DcachePrefetches != nil {
		return *m.L1DcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetchMisses() uint64 {
	if m != nil && m.L1DcachePrefetchMisses != nil {
		return *m.L1DcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoads() uint64 {
	if m != nil && m.L1IcacheLoads != nil {
		return *m.L1IcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoadMisses() uint64 {
	if m != nil && m.L1IcacheLoadMisses != nil {
		return *m.L1IcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetches() uint64 {
	if m != nil && m.L1IcachePrefetches != nil {
		return *m.L1IcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetchMisses() uint64 {
	if m != nil && m.L1IcachePrefetchMisses != nil {
		return *m.L1IcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcLoads() uint64 {
	if m != nil && m.LlcLoads != nil {
		return *m.LlcLoads
	}
	return 0
}

func (m *PerfStatistics) GetLlcLoadMisses() uint64 {
	if m != nil && m.LlcLoadMisses != nil {
		return *m.LlcLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcStores() uint64 {
	if m != nil && m.LlcStores != nil {
		return *m.LlcStores
	}
	return 0
}

func (m *PerfStatistics) GetLlcStoreMisses() uint64 {
	if m != nil && m.LlcStoreMisses != nil {
		return *m.LlcStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcPrefetches() uint64 {
	if m != nil && m.LlcPrefetches != nil {
		return *m.LlcPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetLlcPrefetchMisses() uint64 {
	if m != nil && m.LlcPrefetchMisses != nil {
		return *m.LlcPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbLoads() uint64 {
	if m != nil && m.DtlbLoads != nil {
		return *m.DtlbLoads
	}
	return 0
}

func (m *PerfStatistics) GetDtlbLoadMisses() uint64 {
	if m != nil && m.DtlbLoadMisses != nil {
		return *m.DtlbLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbStores() uint64 {
	if m != nil && m.DtlbStores != nil {
		return *m.DtlbStores
	}
	return 0
}

func (m *PerfStatistics) GetDtlbStoreMisses() uint64 {
	if m != nil && m.DtlbStoreMisses != nil {
		return *m.DtlbStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbPrefetches() uint64 {
	if m != nil && m.DtlbPrefetches != nil {
		return *m.DtlbPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetDtlbPrefetchMisses() uint64 {
	if m != nil && m.DtlbPrefetchMisses != nil {
		return *m.DtlbPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetItlbLoads() uint64 {
	if m != nil && m.ItlbLoads != nil {
		return *m.ItlbLoads
	}
	return 0
}

func (m *PerfStatistics) GetItlbLoadMisses() uint64 {
	if m != nil && m.ItlbLoadMisses != nil {
		return *m.ItlbLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoads() uint64 {
	if m != nil && m.BranchLoads != nil {
		return *m.BranchLoads
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoadMisses() uint64 {
	if m != nil && m.BranchLoadMisses != nil {
		return *m.BranchLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoads() uint64 {
	if m != nil && m.NodeLoads != nil {
		return *m.NodeLoads
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoadMisses() uint64 {
	if m != nil && m.NodeLoadMisses != nil {
		return *m.NodeLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeStores() uint64 {
	if m != nil && m.NodeStores != nil {
		return *m.NodeStores
	}
	return 0
}

func (m *PerfStatistics) GetNodeStoreMisses() uint64 {
	if m != nil && m.NodeStoreMisses != nil {
		return *m.NodeStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetches() uint64 {
	if m != nil && m.NodePrefetches != nil {
		return *m.NodePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetchMisses() uint64 {
	if m != nil && m.NodePrefetchMisses != nil {
		return *m.NodePrefetchMisses
	}
	return 0
}

// *
// Describes a request for resources that can be used by a framework
// to proactively influence the allocator.  If 'slave_id' is provided
// then this request is assumed to only apply to resources on that
// slave.
type Request struct {
	SlaveId          *SlaveID    `protobuf:"bytes,1,opt,name=slave_id" json:"slave_id,omitempty"`
	Resources        []*Resource `protobuf:"bytes,2,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Request) Reset()      { *m = Request{} }
func (*Request) ProtoMessage() {}

func (m *Request) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Request) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes some resources available on a slave. An offer only
// contains resources from a single slave.
type Offer struct {
	Id               *OfferID      `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	FrameworkId      *FrameworkID  `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	SlaveId          *SlaveID      `protobuf:"bytes,3,req,name=slave_id" json:"slave_id,omitempty"`
	Hostname         *string       `protobuf:"bytes,4,req,name=hostname" json:"hostname,omitempty"`
	Resources        []*Resource   `protobuf:"bytes,5,rep,name=resources" json:"resources,omitempty"`
	Attributes       []*Attribute  `protobuf:"bytes,7,rep,name=attributes" json:"attributes,omitempty"`
	ExecutorIds      []*ExecutorID `protobuf:"bytes,6,rep,name=executor_ids" json:"executor_ids,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Offer) Reset()      { *m = Offer{} }
func (*Offer) ProtoMessage() {}

func (m *Offer) GetId() *OfferID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Offer) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *Offer) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Offer) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Offer) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Offer) GetAttributes() []*Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Offer) GetExecutorIds() []*ExecutorID {
	if m != nil {
		return m.ExecutorIds
	}
	return nil
}

// *
// Describes a task. Passed from the scheduler all the way to an
// executor (see SchedulerDriver::launchTasks and
// Executor::launchTask). Either ExecutorInfo or CommandInfo should be set.
// A different executor can be used to launch this task, and subsequent tasks
// meant for the same executor can reuse the same ExecutorInfo struct.
type TaskInfo struct {
	Name      *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	TaskId    *TaskID       `protobuf:"bytes,2,req,name=task_id" json:"task_id,omitempty"`
	SlaveId   *SlaveID      `protobuf:"bytes,3,req,name=slave_id" json:"slave_id,omitempty"`
	Resources []*Resource   `protobuf:"bytes,4,rep,name=resources" json:"resources,omitempty"`
	Executor  *ExecutorInfo `protobuf:"bytes,5,opt,name=executor" json:"executor,omitempty"`
	Command   *CommandInfo  `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	// Task provided with a container will launch the container as part
	// of this task paired with the task's CommandInfo.
	Container *ContainerInfo `protobuf:"bytes,9,opt,name=container" json:"container,omitempty"`
	Data      []byte         `protobuf:"bytes,6,opt,name=data" json:"data,omitempty"`
	// A health check for the task (currently in *alpha* and initial
	// support will only be for TaskInfo's that have a CommandInfo).
	HealthCheck      *HealthCheck `protobuf:"bytes,8,opt,name=health_check" json:"health_check,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *TaskInfo) Reset()      { *m = TaskInfo{} }
func (*TaskInfo) ProtoMessage() {}

func (m *TaskInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TaskInfo) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *TaskInfo) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *TaskInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *TaskInfo) GetExecutor() *ExecutorInfo {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (m *TaskInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *TaskInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *TaskInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskInfo) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

// *
// Describes the current status of a task.
type TaskStatus struct {
	TaskId     *TaskID            `protobuf:"bytes,1,req,name=task_id" json:"task_id,omitempty"`
	State      *TaskState         `protobuf:"varint,2,req,name=state,enum=mesosproto.TaskState" json:"state,omitempty"`
	Message    *string            `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	Source     *TaskStatus_Source `protobuf:"varint,9,opt,name=source,enum=mesosproto.TaskStatus_Source" json:"source,omitempty"`
	Reason     *TaskStatus_Reason `protobuf:"varint,10,opt,name=reason,enum=mesosproto.TaskStatus_Reason" json:"reason,omitempty"`
	Data       []byte             `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	SlaveId    *SlaveID           `protobuf:"bytes,5,opt,name=slave_id" json:"slave_id,omitempty"`
	ExecutorId *ExecutorID        `protobuf:"bytes,7,opt,name=executor_id" json:"executor_id,omitempty"`
	Timestamp  *float64           `protobuf:"fixed64,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// Describes whether the task has been determined to be healthy
	// (true) or unhealthy (false) according to the HealthCheck field in
	// the command info.
	Healthy          *bool  `protobuf:"varint,8,opt,name=healthy" json:"healthy,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskStatus) Reset()      { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage() {}

func (m *TaskStatus) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *TaskStatus) GetState() TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return TaskState_TASK_STAGING
}

func (m *TaskStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *TaskStatus) GetSource() TaskStatus_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return TaskStatus_SOURCE_MASTER
}

func (m *TaskStatus) GetReason() TaskStatus_Reason {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return TaskStatus_REASON_COMMAND_EXECUTOR_FAILED
}

func (m *TaskStatus) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskStatus) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *TaskStatus) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *TaskStatus) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *TaskStatus) GetHealthy() bool {
	if m != nil && m.Healthy != nil {
		return *m.Healthy
	}
	return false
}

// *
// Describes possible filters that can be applied to unused resources
// (see SchedulerDriver::launchTasks) to influence the allocator.
type Filters struct {
	// Time to consider unused resources refused. Note that all unused
	// resources will be considered refused and use the default value
	// (below) regardless of whether Filters was passed to
	// SchedulerDriver::launchTasks. You MUST pass Filters with this
	// field set to change this behavior (i.e., get another offer which
	// includes unused resources sooner or later than the default).
	RefuseSeconds    *float64 `protobuf:"fixed64,1,opt,name=refuse_seconds,def=5" json:"refuse_seconds,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Filters) Reset()      { *m = Filters{} }
func (*Filters) ProtoMessage() {}

const Default_Filters_RefuseSeconds float64 = 5

func (m *Filters) GetRefuseSeconds() float64 {
	if m != nil && m.RefuseSeconds != nil {
		return *m.RefuseSeconds
	}
	return Default_Filters_RefuseSeconds
}

// *
// Describes a collection of environment variables. This is used with
// CommandInfo in order to set environment variables before running a
// command.
type Environment struct {
	Variables        []*Environment_Variable `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *Environment) Reset()      { *m = Environment{} }
func (*Environment) ProtoMessage() {}

func (m *Environment) GetVariables() []*Environment_Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

type Environment_Variable struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Environment_Variable) Reset()      { *m = Environment_Variable{} }
func (*Environment_Variable) ProtoMessage() {}

func (m *Environment_Variable) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Environment_Variable) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A generic (key, value) pair used in various places for parameters.
type Parameter struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Parameter) Reset()      { *m = Parameter{} }
func (*Parameter) ProtoMessage() {}

func (m *Parameter) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Parameter) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Collection of Parameter.
type Parameters struct {
	Parameter        []*Parameter `protobuf:"bytes,1,rep,name=parameter" json:"parameter,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Parameters) Reset()      { *m = Parameters{} }
func (*Parameters) ProtoMessage() {}

func (m *Parameters) GetParameter() []*Parameter {
	if m != nil {
		return m.Parameter
	}
	return nil
}

// *
// Credential used in various places for authentication and
// authorization.
//
// NOTE: A 'principal' is different from 'FrameworkInfo.user'. The
// former is used for authentication and authorization while the
// latter is used to determine the default user under which the
// framework's executors/tasks are run.
type Credential struct {
	Principal        *string `protobuf:"bytes,1,req,name=principal" json:"principal,omitempty"`
	Secret           []byte  `protobuf:"bytes,2,opt,name=secret" json:"secret,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Credential) Reset()      { *m = Credential{} }
func (*Credential) ProtoMessage() {}

func (m *Credential) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *Credential) GetSecret() []byte {
	if m != nil {
		return m.Secret
	}
	return nil
}

// *
// Credentials used for framework authentication, HTTP authentication
// (where the common 'username' and 'password' are captured as
// 'principal' and 'secret' respectively), etc.
type Credentials struct {
	Credentials      []*Credential `protobuf:"bytes,1,rep,name=credentials" json:"credentials,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Credentials) Reset()      { *m = Credentials{} }
func (*Credentials) ProtoMessage() {}

func (m *Credentials) GetCredentials() []*Credential {
	if m != nil {
		return m.Credentials
	}
	return nil
}

// *
// ACLs used for authorization.
type ACL struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ACL) Reset()      { *m = ACL{} }
func (*ACL) ProtoMessage() {}

// Entity is used to describe a subject(s) or an object(s) of an ACL.
// NOTE:
// To allow everyone access to an Entity set its type to 'ANY'.
// To deny access to an Entity set its type to 'NONE'.
type ACL_Entity struct {
	Type             *ACL_Entity_Type `protobuf:"varint,1,opt,name=type,enum=mesosproto.ACL_Entity_Type,def=0" json:"type,omitempty"`
	Values           []string         `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ACL_Entity) Reset()      { *m = ACL_Entity{} }
func (*ACL_Entity) ProtoMessage() {}

const Default_ACL_Entity_Type ACL_Entity_Type = ACL_Entity_SOME

func (m *ACL_Entity) GetType() ACL_Entity_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_ACL_Entity_Type
}

func (m *ACL_Entity) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// ACLs.
type ACL_RegisterFramework struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	Roles            *ACL_Entity `protobuf:"bytes,2,req,name=roles" json:"roles,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *ACL_RegisterFramework) Reset()      { *m = ACL_RegisterFramework{} }
func (*ACL_RegisterFramework) ProtoMessage() {}

func (m *ACL_RegisterFramework) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_RegisterFramework) GetRoles() *ACL_Entity {
	if m != nil {
		return m.Roles
	}
	return nil
}

type ACL_RunTask struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	Users            *ACL_Entity `protobuf:"bytes,2,req,name=users" json:"users,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *ACL_RunTask) Reset()      { *m = ACL_RunTask{} }
func (*ACL_RunTask) ProtoMessage() {}

func (m *ACL_RunTask) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_RunTask) GetUsers() *ACL_Entity {
	if m != nil {
		return m.Users
	}
	return nil
}

// Which principals are authorized to shutdown frameworks of other
// principals.
type ACL_ShutdownFramework struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	FrameworkPrincipals *ACL_Entity `protobuf:"bytes,2,req,name=framework_principals" json:"framework_principals,omitempty"`
	XXX_unrecognized    []byte      `json:"-"`
}

func (m *ACL_ShutdownFramework) Reset()      { *m = ACL_ShutdownFramework{} }
func (*ACL_ShutdownFramework) ProtoMessage() {}

func (m *ACL_ShutdownFramework) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_ShutdownFramework) GetFrameworkPrincipals() *ACL_Entity {
	if m != nil {
		return m.FrameworkPrincipals
	}
	return nil
}

// *
// Collection of ACL.
//
// Each authorization request is evaluated against the ACLs in the order
// they are defined.
//
// For simplicity, the ACLs for a given action are not aggregated even
// when they have the same subjects or objects. The first ACL that
// matches the request determines whether that request should be
// permitted or not. An ACL matches iff both the subjects
// (e.g., clients, principals) and the objects (e.g., urls, users,
// roles) of the ACL match the request.
//
// If none of the ACLs match the request, the 'permissive' field
// determines whether the request should be permitted or not.
//
// TODO(vinod): Do aggregation of ACLs when possible.
//
type ACLs struct {
	Permissive         *bool                    `protobuf:"varint,1,opt,name=permissive,def=1" json:"permissive,omitempty"`
	RegisterFrameworks []*ACL_RegisterFramework `protobuf:"bytes,2,rep,name=register_frameworks" json:"register_frameworks,omitempty"`
	RunTasks           []*ACL_RunTask           `protobuf:"bytes,3,rep,name=run_tasks" json:"run_tasks,omitempty"`
	ShutdownFrameworks []*ACL_ShutdownFramework `protobuf:"bytes,4,rep,name=shutdown_frameworks" json:"shutdown_frameworks,omitempty"`
	XXX_unrecognized   []byte                   `json:"-"`
}

func (m *ACLs) Reset()      { *m = ACLs{} }
func (*ACLs) ProtoMessage() {}

const Default_ACLs_Permissive bool = true

func (m *ACLs) GetPermissive() bool {
	if m != nil && m.Permissive != nil {
		return *m.Permissive
	}
	return Default_ACLs_Permissive
}

func (m *ACLs) GetRegisterFrameworks() []*ACL_RegisterFramework {
	if m != nil {
		return m.RegisterFrameworks
	}
	return nil
}

func (m *ACLs) GetRunTasks() []*ACL_RunTask {
	if m != nil {
		return m.RunTasks
	}
	return nil
}

func (m *ACLs) GetShutdownFrameworks() []*ACL_ShutdownFramework {
	if m != nil {
		return m.ShutdownFrameworks
	}
	return nil
}

// *
// Rate (queries per second, QPS) limit for messages from a framework to master.
// Strictly speaking they are the combined rate from all frameworks of the same
// principal.
type RateLimit struct {
	// Leaving QPS unset gives it unlimited rate (i.e., not throttled),
	// which also implies unlimited capacity.
	Qps *float64 `protobuf:"fixed64,1,opt,name=qps" json:"qps,omitempty"`
	// Principal of framework(s) to be throttled. Should match
	// FrameworkInfo.princpal and Credential.principal (if using authentication).
	Principal *string `protobuf:"bytes,2,req,name=principal" json:"principal,omitempty"`
	// Max number of outstanding messages from frameworks of this principal
	// allowed by master before the next message is dropped and an error is sent
	// back to the sender. Messages received before the capacity is reached are
	// still going to be processed after the error is sent.
	// If unspecified, this principal is assigned unlimited capacity.
	// NOTE: This value is ignored if 'qps' is not set.
	Capacity         *uint64 `protobuf:"varint,3,opt,name=capacity" json:"capacity,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RateLimit) Reset()      { *m = RateLimit{} }
func (*RateLimit) ProtoMessage() {}

func (m *RateLimit) GetQps() float64 {
	if m != nil && m.Qps != nil {
		return *m.Qps
	}
	return 0
}

func (m *RateLimit) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *RateLimit) GetCapacity() uint64 {
	if m != nil && m.Capacity != nil {
		return *m.Capacity
	}
	return 0
}

// *
// Collection of RateLimit.
// Frameworks without rate limits defined here are not throttled unless
// 'aggregate_default_qps' is specified.
type RateLimits struct {
	// Items should have unique principals.
	Limits []*RateLimit `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty"`
	// All the frameworks not specified in 'limits' get this default rate.
	// This rate is an aggregate rate for all of them, i.e., their combined
	// traffic is throttled together at this rate.
	AggregateDefaultQps *float64 `protobuf:"fixed64,2,opt,name=aggregate_default_qps" json:"aggregate_default_qps,omitempty"`
	// All the frameworks not specified in 'limits' get this default capacity.
	// This is an aggregate value similar to 'aggregate_default_qps'.
	AggregateDefaultCapacity *uint64 `protobuf:"varint,3,opt,name=aggregate_default_capacity" json:"aggregate_default_capacity,omitempty"`
	XXX_unrecognized         []byte  `json:"-"`
}

func (m *RateLimits) Reset()      { *m = RateLimits{} }
func (*RateLimits) ProtoMessage() {}

func (m *RateLimits) GetLimits() []*RateLimit {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *RateLimits) GetAggregateDefaultQps() float64 {
	if m != nil && m.AggregateDefaultQps != nil {
		return *m.AggregateDefaultQps
	}
	return 0
}

func (m *RateLimits) GetAggregateDefaultCapacity() uint64 {
	if m != nil && m.AggregateDefaultCapacity != nil {
		return *m.AggregateDefaultCapacity
	}
	return 0
}

// *
// Describes a volume mapping either from host to container or vice
// versa. Both paths can either refer to a directory or a file.
type Volume struct {
	// Absolute path pointing to a directory or file in the container.
	ContainerPath *string `protobuf:"bytes,1,req,name=container_path" json:"container_path,omitempty"`
	// Absolute path pointing to a directory or file on the host or a path
	// relative to the container work directory.
	HostPath         *string      `protobuf:"bytes,2,opt,name=host_path" json:"host_path,omitempty"`
	Mode             *Volume_Mode `protobuf:"varint,3,req,name=mode,enum=mesosproto.Volume_Mode" json:"mode,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Volume) Reset()      { *m = Volume{} }
func (*Volume) ProtoMessage() {}

func (m *Volume) GetContainerPath() string {
	if m != nil && m.ContainerPath != nil {
		return *m.ContainerPath
	}
	return ""
}

func (m *Volume) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Volume) GetMode() Volume_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Volume_RW
}

// *
// Describes a container configuration and allows extensible
// configurations for different container implementations.
type ContainerInfo struct {
	Type             *ContainerInfo_Type       `protobuf:"varint,1,req,name=type,enum=mesosproto.ContainerInfo_Type" json:"type,omitempty"`
	Volumes          []*Volume                 `protobuf:"bytes,2,rep,name=volumes" json:"volumes,omitempty"`
	Hostname         *string                   `protobuf:"bytes,4,opt,name=hostname" json:"hostname,omitempty"`
	Docker           *ContainerInfo_DockerInfo `protobuf:"bytes,3,opt,name=docker" json:"docker,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *ContainerInfo) Reset()      { *m = ContainerInfo{} }
func (*ContainerInfo) ProtoMessage() {}

func (m *ContainerInfo) GetType() ContainerInfo_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ContainerInfo_DOCKER
}

func (m *ContainerInfo) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *ContainerInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *ContainerInfo) GetDocker() *ContainerInfo_DockerInfo {
	if m != nil {
		return m.Docker
	}
	return nil
}

type ContainerInfo_DockerInfo struct {
	// The docker image that is going to be passed to the registry.
	Image        *string                                 `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	Network      *ContainerInfo_DockerInfo_Network       `protobuf:"varint,2,opt,name=network,enum=mesosproto.ContainerInfo_DockerInfo_Network,def=1" json:"network,omitempty"`
	PortMappings []*ContainerInfo_DockerInfo_PortMapping `protobuf:"bytes,3,rep,name=port_mappings" json:"port_mappings,omitempty"`
	Privileged   *bool                                   `protobuf:"varint,4,opt,name=privileged,def=0" json:"privileged,omitempty"`
	// Allowing arbitrary parameters to be passed to docker CLI.
	// Note that anything passed to this field is not guranteed
	// to be supported moving forward, as we might move away from
	// the docker CLI.
	Parameters       []*Parameter `protobuf:"bytes,5,rep,name=parameters" json:"parameters,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ContainerInfo_DockerInfo) Reset()      { *m = ContainerInfo_DockerInfo{} }
func (*ContainerInfo_DockerInfo) ProtoMessage() {}

const Default_ContainerInfo_DockerInfo_Network ContainerInfo_DockerInfo_Network = ContainerInfo_DockerInfo_HOST
const Default_ContainerInfo_DockerInfo_Privileged bool = false

func (m *ContainerInfo_DockerInfo) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *ContainerInfo_DockerInfo) GetNetwork() ContainerInfo_DockerInfo_Network {
	if m != nil && m.Network != nil {
		return *m.Network
	}
	return Default_ContainerInfo_DockerInfo_Network
}

func (m *ContainerInfo_DockerInfo) GetPortMappings() []*ContainerInfo_DockerInfo_PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *ContainerInfo_DockerInfo) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return Default_ContainerInfo_DockerInfo_Privileged
}

func (m *ContainerInfo_DockerInfo) GetParameters() []*Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type ContainerInfo_DockerInfo_PortMapping struct {
	HostPort      *uint32 `protobuf:"varint,1,req,name=host_port" json:"host_port,omitempty"`
	ContainerPort *uint32 `protobuf:"varint,2,req,name=container_port" json:"container_port,omitempty"`
	// Protocol to expose as (ie: tcp, udp).
	Protocol         *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerInfo_DockerInfo_PortMapping) Reset()      { *m = ContainerInfo_DockerInfo_PortMapping{} }
func (*ContainerInfo_DockerInfo_PortMapping) ProtoMessage() {}

func (m *ContainerInfo_DockerInfo_PortMapping) GetHostPort() uint32 {
	if m != nil && m.HostPort != nil {
		return *m.HostPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetContainerPort() uint32 {
	if m != nil && m.ContainerPort != nil {
		return *m.ContainerPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

func init() {
	proto.RegisterEnum("mesosproto.Status", Status_name, Status_value)
	proto.RegisterEnum("mesosproto.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("mesosproto.Value_Type", Value_Type_name, Value_Type_value)
	proto.RegisterEnum("mesosproto.TaskStatus_Source", TaskStatus_Source_name, TaskStatus_Source_value)
	proto.RegisterEnum("mesosproto.TaskStatus_Reason", TaskStatus_Reason_name, TaskStatus_Reason_value)
	proto.RegisterEnum("mesosproto.ACL_Entity_Type", ACL_Entity_Type_name, ACL_Entity_Type_value)
	proto.RegisterEnum("mesosproto.Volume_Mode", Volume_Mode_name, Volume_Mode_value)
	proto.RegisterEnum("mesosproto.ContainerInfo_Type", ContainerInfo_Type_name, ContainerInfo_Type_value)
	proto.RegisterEnum("mesosproto.ContainerInfo_DockerInfo_Network", ContainerInfo_DockerInfo_Network_name, ContainerInfo_DockerInfo_Network_value)
}
func (m *FrameworkID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *OfferID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *SlaveID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *TaskID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ExecutorID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ContainerID) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *FrameworkInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.User = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &FrameworkID{}
			}
			if err := m.Id.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverTimeout", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.FailoverTimeout = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Checkpoint = &b
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Role = &s
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Hostname = &s
			index = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Principal = &s
			index = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WebuiUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.WebuiUrl = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *HealthCheck) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &HealthCheck_HTTP{}
			}
			if err := m.Http.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelaySeconds", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.DelaySeconds = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalSeconds", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.IntervalSeconds = &v2
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.TimeoutSeconds = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveFailures", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsecutiveFailures = &v
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GracePeriodSeconds", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.GracePeriodSeconds = &v2
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *HealthCheck_HTTP) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Path = &s
			index = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Statuses = append(m.Statuses, v)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *CommandInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &CommandInfo_ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uris", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uris = append(m.Uris, &CommandInfo_URI{})
			m.Uris[len(m.Uris)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Environment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Environment == nil {
				m.Environment = &Environment{}
			}
			if err := m.Environment.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shell", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Shell = &b
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Arguments", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Arguments = append(m.Arguments, string(data[index:postIndex]))
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.User = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *CommandInfo_URI) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Executable = &b
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extract", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Extract = &b
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *CommandInfo_ContainerInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Image = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(data[index:postIndex]))
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ExecutorInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorId == nil {
				m.ExecutorId = &ExecutorID{}
			}
			if err := m.ExecutorId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			m.Resources[len(m.Resources)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Source = &s
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[index:postIndex]...)
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *MasterInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Id = &s
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ip = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Pid = &s
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Hostname = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *SlaveInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Hostname = &s
			index = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			m.Resources[len(m.Resources)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &Attribute{})
			m.Attributes[len(m.Attributes)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &SlaveID{}
			}
			if err := m.Id.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Checkpoint = &b
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Text == nil {
				m.Text = &Value_Text{}
			}
			if err := m.Text.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value_Scalar) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Value = &v2
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value_Range) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Begin", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Begin = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.End = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value_Ranges) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Range = append(m.Range, &Value_Range{})
			m.Range[len(m.Range)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value_Set) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Item", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Item = append(m.Item, string(data[index:postIndex]))
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Value_Text) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Attribute) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Text == nil {
				m.Text = &Value_Text{}
			}
			if err := m.Text.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Resource) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Role = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ResourceStatistics) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Timestamp = &v2
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusUserTimeSecs", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.CpusUserTimeSecs = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusSystemTimeSecs", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.CpusSystemTimeSecs = &v2
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusLimit", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.CpusLimit = &v2
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusNrPeriods", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpusNrPeriods = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusNrThrottled", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpusNrThrottled = &v
		case 9:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusThrottledTimeSecs", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.CpusThrottledTimeSecs = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemRssBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemRssBytes = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemLimitBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemLimitBytes = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemFileBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemFileBytes = &v
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemAnonBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemAnonBytes = &v
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemMappedFileBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemMappedFileBytes = &v
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Perf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Perf == nil {
				m.Perf = &PerfStatistics{}
			}
			if err := m.Perf.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxPackets", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxPackets = &v
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxBytes = &v
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxErrors", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxErrors = &v
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxDropped", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxDropped = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxPackets", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxPackets = &v
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxBytes = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxErrors", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxErrors = &v
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxDropped", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxDropped = &v
		case 22:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP50", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.NetTcpRttMicrosecsP50 = &v2
		case 23:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP90", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.NetTcpRttMicrosecsP90 = &v2
		case 24:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP95", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.NetTcpRttMicrosecsP95 = &v2
		case 25:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP99", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.NetTcpRttMicrosecsP99 = &v2
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ResourceUsage) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorId == nil {
				m.ExecutorId = &ExecutorID{}
			}
			if err := m.ExecutorId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.ExecutorName = &s
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskId == nil {
				m.TaskId = &TaskID{}
			}
			if err := m.TaskId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statistics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Statistics == nil {
				m.Statistics = &ResourceStatistics{}
			}
			if err := m.Statistics.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *PerfStatistics) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Timestamp = &v2
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Duration = &v2
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Cycles = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StalledCyclesFrontend", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StalledCyclesFrontend = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StalledCyclesBackend", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StalledCyclesBackend = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instructions", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Instructions = &v
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheReferences", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheReferences = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheMisses = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Branches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Branches = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchMisses = &v
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BusCycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BusCycles = &v
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefCycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RefCycles = &v
		case 13:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuClock", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.CpuClock = &v2
		case 14:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskClock", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.TaskClock = &v2
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PageFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PageFaults = &v
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinorFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MinorFaults = &v
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MajorFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MajorFaults = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextSwitches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContextSwitches = &v
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuMigrations", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpuMigrations = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlignmentFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AlignmentFaults = &v
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmulationFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EmulationFaults = &v
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheLoads = &v
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheLoadMisses = &v
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheStores = &v
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheStoreMisses = &v
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcachePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcachePrefetches = &v
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcachePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcachePrefetchMisses = &v
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcacheLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcacheLoads = &v
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcacheLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcacheLoadMisses = &v
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcachePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcachePrefetches = &v
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcachePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcachePrefetchMisses = &v
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcLoads = &v
		case 33:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcLoadMisses = &v
		case 34:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcStores = &v
		case 35:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcStoreMisses = &v
		case 36:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcPrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcPrefetches = &v
		case 37:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcPrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcPrefetchMisses = &v
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbLoads = &v
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbLoadMisses = &v
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbStores = &v
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbStoreMisses = &v
		case 42:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbPrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbPrefetches = &v
		case 43:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbPrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbPrefetchMisses = &v
		case 44:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItlbLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ItlbLoads = &v
		case 45:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItlbLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ItlbLoadMisses = &v
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchLoads = &v
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchLoadMisses = &v
		case 48:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeLoads = &v
		case 49:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeLoadMisses = &v
		case 50:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeStores = &v
		case 51:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeStoreMisses = &v
		case 52:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodePrefetches = &v
		case 53:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodePrefetchMisses = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Request) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			m.Resources[len(m.Resources)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Offer) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &OfferID{}
			}
			if err := m.Id.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Hostname = &s
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			m.Resources[len(m.Resources)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &Attribute{})
			m.Attributes[len(m.Attributes)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorIds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecutorIds = append(m.ExecutorIds, &ExecutorID{})
			m.ExecutorIds[len(m.ExecutorIds)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *TaskInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskId == nil {
				m.TaskId = &TaskID{}
			}
			if err := m.TaskId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			m.Resources[len(m.Resources)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Executor == nil {
				m.Executor = &ExecutorInfo{}
			}
			if err := m.Executor.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[index:postIndex]...)
			index = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthCheck == nil {
				m.HealthCheck = &HealthCheck{}
			}
			if err := m.HealthCheck.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *TaskStatus) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskId == nil {
				m.TaskId = &TaskID{}
			}
			if err := m.TaskId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var v TaskState
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.State = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Message = &s
			index = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var v TaskStatus_Source
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (TaskStatus_Source(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Source = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var v TaskStatus_Reason
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (TaskStatus_Reason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reason = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[index:postIndex]...)
			index = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorId == nil {
				m.ExecutorId = &ExecutorID{}
			}
			if err := m.ExecutorId.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Timestamp = &v2
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Healthy = &b
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Filters) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefuseSeconds", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.RefuseSeconds = &v2
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Environment) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Variables = append(m.Variables, &Environment_Variable{})
			m.Variables[len(m.Variables)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Environment_Variable) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Name = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Parameter) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Key = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Value = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Parameters) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parameter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parameter = append(m.Parameter, &Parameter{})
			m.Parameter[len(m.Parameter)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Credential) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Principal = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = append([]byte{}, data[index:postIndex]...)
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Credentials) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Credentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Credentials = append(m.Credentials, &Credential{})
			m.Credentials[len(m.Credentials)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACL) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		switch fieldNum {
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACL_Entity) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v ACL_Entity_Type
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (ACL_Entity_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(data[index:postIndex]))
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACL_RegisterFramework) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Roles == nil {
				m.Roles = &ACL_Entity{}
			}
			if err := m.Roles.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACL_RunTask) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Users", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Users == nil {
				m.Users = &ACL_Entity{}
			}
			if err := m.Users.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACL_ShutdownFramework) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkPrincipals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkPrincipals == nil {
				m.FrameworkPrincipals = &ACL_Entity{}
			}
			if err := m.FrameworkPrincipals.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ACLs) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Permissive = &b
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegisterFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegisterFrameworks = append(m.RegisterFrameworks, &ACL_RegisterFramework{})
			m.RegisterFrameworks[len(m.RegisterFrameworks)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunTasks = append(m.RunTasks, &ACL_RunTask{})
			m.RunTasks[len(m.RunTasks)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShutdownFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShutdownFrameworks = append(m.ShutdownFrameworks, &ACL_ShutdownFramework{})
			m.ShutdownFrameworks[len(m.ShutdownFrameworks)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *RateLimit) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Qps", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.Qps = &v2
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Principal = &s
			index = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Capacity = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *RateLimits) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Limits = append(m.Limits, &RateLimit{})
			m.Limits[len(m.Limits)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregateDefaultQps", wireType)
			}
			var v uint64
			i := index + 8
			if i > l {
				return io.ErrUnexpectedEOF
			}
			index = i
			v = uint64(data[i-8])
			v |= uint64(data[i-7]) << 8
			v |= uint64(data[i-6]) << 16
			v |= uint64(data[i-5]) << 24
			v |= uint64(data[i-4]) << 32
			v |= uint64(data[i-3]) << 40
			v |= uint64(data[i-2]) << 48
			v |= uint64(data[i-1]) << 56
			v2 := math1.Float64frombits(v)
			m.AggregateDefaultQps = &v2
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregateDefaultCapacity", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AggregateDefaultCapacity = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *Volume) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.ContainerPath = &s
			index = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.HostPath = &s
			index = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v Volume_Mode
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (Volume_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ContainerInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v ContainerInfo_Type
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (ContainerInfo_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &Volume{})
			m.Volumes[len(m.Volumes)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Hostname = &s
			index = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Docker", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Docker == nil {
				m.Docker = &ContainerInfo_DockerInfo{}
			}
			if err := m.Docker.Unmarshal(data[index:postIndex]); err != nil {
				return err
			}
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ContainerInfo_DockerInfo) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Image = &s
			index = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var v ContainerInfo_DockerInfo_Network
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (ContainerInfo_DockerInfo_Network(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Network = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortMappings = append(m.PortMappings, &ContainerInfo_DockerInfo_PortMapping{})
			m.PortMappings[len(m.PortMappings)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileged", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Privileged = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parameters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parameters = append(m.Parameters, &Parameter{})
			m.Parameters[len(m.Parameters)-1].Unmarshal(data[index:postIndex])
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (m *ContainerInfo_DockerInfo_PortMapping) Unmarshal(data []byte) error {
	l := len(data)
	index := 0
	for index < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if index >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[index]
			index++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPort", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HostPort = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPort", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainerPort = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if index >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[index]
				index++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			postIndex := index + int(stringLen)
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[index:postIndex])
			m.Protocol = &s
			index = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			index -= sizeOfWire
			skippy, err := github_com_gogo_protobuf_proto.Skip(data[index:])
			if err != nil {
				return err
			}
			if (index + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[index:index+skippy]...)
			index += skippy
		}
	}
	return nil
}
func (this *FrameworkID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrameworkID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OfferID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OfferID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SlaveID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SlaveID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecutorID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutorID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FrameworkInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrameworkInfo{`,
		`User:` + valueToStringMesos(this.User) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Id:` + strings.Replace(fmt1.Sprintf("%v", this.Id), "FrameworkID", "FrameworkID", 1) + `,`,
		`FailoverTimeout:` + valueToStringMesos(this.FailoverTimeout) + `,`,
		`Checkpoint:` + valueToStringMesos(this.Checkpoint) + `,`,
		`Role:` + valueToStringMesos(this.Role) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`WebuiUrl:` + valueToStringMesos(this.WebuiUrl) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HealthCheck) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HealthCheck{`,
		`Http:` + strings.Replace(fmt1.Sprintf("%v", this.Http), "HealthCheck_HTTP", "HealthCheck_HTTP", 1) + `,`,
		`DelaySeconds:` + valueToStringMesos(this.DelaySeconds) + `,`,
		`IntervalSeconds:` + valueToStringMesos(this.IntervalSeconds) + `,`,
		`TimeoutSeconds:` + valueToStringMesos(this.TimeoutSeconds) + `,`,
		`ConsecutiveFailures:` + valueToStringMesos(this.ConsecutiveFailures) + `,`,
		`GracePeriodSeconds:` + valueToStringMesos(this.GracePeriodSeconds) + `,`,
		`Command:` + strings.Replace(fmt1.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HealthCheck_HTTP) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HealthCheck_HTTP{`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`Path:` + valueToStringMesos(this.Path) + `,`,
		`Statuses:` + fmt1.Sprintf("%v", this.Statuses) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo{`,
		`Container:` + strings.Replace(fmt1.Sprintf("%v", this.Container), "CommandInfo_ContainerInfo", "CommandInfo_ContainerInfo", 1) + `,`,
		`Uris:` + strings.Replace(fmt1.Sprintf("%v", this.Uris), "CommandInfo_URI", "CommandInfo_URI", 1) + `,`,
		`Environment:` + strings.Replace(fmt1.Sprintf("%v", this.Environment), "Environment", "Environment", 1) + `,`,
		`Shell:` + valueToStringMesos(this.Shell) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`Arguments:` + fmt1.Sprintf("%v", this.Arguments) + `,`,
		`User:` + valueToStringMesos(this.User) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo_URI) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo_URI{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`Executable:` + valueToStringMesos(this.Executable) + `,`,
		`Extract:` + valueToStringMesos(this.Extract) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo_ContainerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo_ContainerInfo{`,
		`Image:` + valueToStringMesos(this.Image) + `,`,
		`Options:` + fmt1.Sprintf("%v", this.Options) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecutorInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutorInfo{`,
		`ExecutorId:` + strings.Replace(fmt1.Sprintf("%v", this.ExecutorId), "ExecutorID", "ExecutorID", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt1.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`Command:` + strings.Replace(fmt1.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`Container:` + strings.Replace(fmt1.Sprintf("%v", this.Container), "ContainerInfo", "ContainerInfo", 1) + `,`,
		`Resources:` + strings.Replace(fmt1.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Source:` + valueToStringMesos(this.Source) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MasterInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MasterInfo{`,
		`Id:` + valueToStringMesos(this.Id) + `,`,
		`Ip:` + valueToStringMesos(this.Ip) + `,`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`Pid:` + valueToStringMesos(this.Pid) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SlaveInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SlaveInfo{`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`Resources:` + strings.Replace(fmt1.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Attributes:` + strings.Replace(fmt1.Sprintf("%v", this.Attributes), "Attribute", "Attribute", 1) + `,`,
		`Id:` + strings.Replace(fmt1.Sprintf("%v", this.Id), "SlaveID", "SlaveID", 1) + `,`,
		`Checkpoint:` + valueToStringMesos(this.Checkpoint) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt1.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt1.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Set:` + strings.Replace(fmt1.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`Text:` + strings.Replace(fmt1.Sprintf("%v", this.Text), "Value_Text", "Value_Text", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Scalar) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Scalar{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Range) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Range{`,
		`Begin:` + valueToStringMesos(this.Begin) + `,`,
		`End:` + valueToStringMesos(this.End) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Ranges) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Ranges{`,
		`Range:` + strings.Replace(fmt1.Sprintf("%v", this.Range), "Value_Range", "Value_Range", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Set) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Set{`,
		`Item:` + fmt1.Sprintf("%v", this.Item) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Text) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Text{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attribute) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attribute{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt1.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt1.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Set:` + strings.Replace(fmt1.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`Text:` + strings.Replace(fmt1.Sprintf("%v", this.Text), "Value_Text", "Value_Text", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt1.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt1.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Set:` + strings.Replace(fmt1.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`Role:` + valueToStringMesos(this.Role) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceStatistics{`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`CpusUserTimeSecs:` + valueToStringMesos(this.CpusUserTimeSecs) + `,`,
		`CpusSystemTimeSecs:` + valueToStringMesos(this.CpusSystemTimeSecs) + `,`,
		`CpusLimit:` + valueToStringMesos(this.CpusLimit) + `,`,
		`CpusNrPeriods:` + valueToStringMesos(this.CpusNrPeriods) + `,`,
		`CpusNrThrottled:` + valueToStringMesos(this.CpusNrThrottled) + `,`,
		`CpusThrottledTimeSecs:` + valueToStringMesos(this.CpusThrottledTimeSecs) + `,`,
		`MemRssBytes:` + valueToStringMesos(this.MemRssBytes) + `,`,
		`MemLimitBytes:` + valueToStringMesos(this.MemLimitBytes) + `,`,
		`MemFileBytes:` + valueToStringMesos(this.MemFileBytes) + `,`,
		`MemAnonBytes:` + valueToStringMesos(this.MemAnonBytes) + `,`,
		`MemMappedFileBytes:` + valueToStringMesos(this.MemMappedFileBytes) + `,`,
		`Perf:` + strings.Replace(fmt1.Sprintf("%v", this.Perf), "PerfStatistics", "PerfStatistics", 1) + `,`,
		`NetRxPackets:` + valueToStringMesos(this.NetRxPackets) + `,`,
		`NetRxBytes:` + valueToStringMesos(this.NetRxBytes) + `,`,
		`NetRxErrors:` + valueToStringMesos(this.NetRxErrors) + `,`,
		`NetRxDropped:` + valueToStringMesos(this.NetRxDropped) + `,`,
		`NetTxPackets:` + valueToStringMesos(this.NetTxPackets) + `,`,
		`NetTxBytes:` + valueToStringMesos(this.NetTxBytes) + `,`,
		`NetTxErrors:` + valueToStringMesos(this.NetTxErrors) + `,`,
		`NetTxDropped:` + valueToStringMesos(this.NetTxDropped) + `,`,
		`NetTcpRttMicrosecsP50:` + valueToStringMesos(this.NetTcpRttMicrosecsP50) + `,`,
		`NetTcpRttMicrosecsP90:` + valueToStringMesos(this.NetTcpRttMicrosecsP90) + `,`,
		`NetTcpRttMicrosecsP95:` + valueToStringMesos(this.NetTcpRttMicrosecsP95) + `,`,
		`NetTcpRttMicrosecsP99:` + valueToStringMesos(this.NetTcpRttMicrosecsP99) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceUsage{`,
		`SlaveId:` + strings.Replace(fmt1.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt1.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`ExecutorId:` + strings.Replace(fmt1.Sprintf("%v", this.ExecutorId), "ExecutorID", "ExecutorID", 1) + `,`,
		`ExecutorName:` + valueToStringMesos(this.ExecutorName) + `,`,
		`TaskId:` + strings.Replace(fmt1.Sprintf("%v", this.TaskId), "TaskID", "TaskID", 1) + `,`,
		`Statistics:` + strings.Replace(fmt1.Sprintf("%v", this.Statistics), "ResourceStatistics", "ResourceStatistics", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PerfStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PerfStatistics{`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`Duration:` + valueToStringMesos(this.Duration) + `,`,
		`Cycles:` + valueToStringMesos(this.Cycles) + `,`,
		`StalledCyclesFrontend:` + valueToStringMesos(this.StalledCyclesFrontend) + `,`,
		`StalledCyclesBackend:` + valueToStringMesos(this.StalledCyclesBackend) + `,`,
		`Instructions:` + valueToStringMesos(this.Instructions) + `,`,
		`CacheReferences:` + valueToStringMesos(this.CacheReferences) + `,`,
		`CacheMisses:` + valueToStringMesos(this.CacheMisses) + `,`,
		`Branches:` + valueToStringMesos(this.Branches) + `,`,
		`BranchMisses:` + valueToStringMesos(this.BranchMisses) + `,`,
		`BusCycles:` + valueToStringMesos(this.BusCycles) + `,`,
		`RefCycles:` + valueToStringMesos(this.RefCycles) + `,`,
		`CpuClock:` + valueToStringMesos(this.CpuClock) + `,`,
		`TaskClock:` + valueToStringMesos(this.TaskClock) + `,`,
		`PageFaults:` + valueToStringMesos(this.PageFaults) + `,`,
		`MinorFaults:` + valueToStringMesos(this.MinorFaults) + `,`,
		`MajorFaults:` + valueToStringMesos(this.MajorFaults) + `,`,
		`ContextSwitches:` + valueToStringMesos(this.ContextSwitches) + `,`,
		`CpuMigrations:` + valueToStringMesos(this.CpuMigrations) + `,`,
		`AlignmentFaults:` + valueToStringMesos(this.AlignmentFaults) + `,`,
		`EmulationFaults:` + valueToStringMesos(this.EmulationFaults) + `,`,
		`L1DcacheLoads:` + valueToStringMesos(this.L1DcacheLoads) + `,`,
		`L1DcacheLoadMisses:` + valueToStringMesos(this.L1DcacheLoadMisses) + `,`,
		`L1DcacheStores:` + valueToStringMesos(this.L1DcacheStores) + `,`,
		`L1DcacheStoreMisses:` + valueToStringMesos(this.L1DcacheStoreMisses) + `,`,
		`L1DcachePrefetches:` + valueToStringMesos(this.L1DcachePrefetches) + `,`,
		`L1DcachePrefetchMisses:` + valueToStringMesos(this.L1DcachePrefetchMisses) + `,`,
		`L1IcacheLoads:` + valueToStringMesos(this.L1IcacheLoads) + `,`,
		`L1IcacheLoadMisses:` + valueToStringMesos(this.L1IcacheLoadMisses) + `,`,
		`L1IcachePrefetches:` + valueToStringMesos(this.L1IcachePrefetches) + `,`,
		`L1IcachePrefetchMisses:` + valueToStringMesos(this.L1IcachePrefetchMisses) + `,`,
		`LlcLoads:` + valueToStringMesos(this.LlcLoads) + `,`,
		`LlcLoadMisses:` + valueToStringMesos(this.LlcLoadMisses) + `,`,
		`LlcStores:` + valueToStringMesos(this.LlcStores) + `,`,
		`LlcStoreMisses:` + valueToStringMesos(this.LlcStoreMisses) + `,`,
		`LlcPrefetches:` + valueToStringMesos(this.LlcPrefetches) + `,`,
		`LlcPrefetchMisses:` + valueToStringMesos(this.LlcPrefetchMisses) + `,`,
		`DtlbLoads:` + valueToStringMesos(this.DtlbLoads) + `,`,
		`DtlbLoadMisses:` + valueToStringMesos(this.DtlbLoadMisses) + `,`,
		`DtlbStores:` + valueToStringMesos(this.DtlbStores) + `,`,
		`DtlbStoreMisses:` + valueToStringMesos(this.DtlbStoreMisses) + `,`,
		`DtlbPrefetches:` + valueToStringMesos(this.DtlbPrefetches) + `,`,
		`DtlbPrefetchMisses:` + valueToStringMesos(this.DtlbPrefetchMisses) + `,`,
		`ItlbLoads:` + valueToStringMesos(this.ItlbLoads) + `,`,
		`ItlbLoadMisses:` + valueToStringMesos(this.ItlbLoadMisses) + `,`,
		`BranchLoads:` + valueToStringMesos(this.BranchLoads) + `,`,
		`BranchLoadMisses:` + valueToStringMesos(this.BranchLoadMisses) + `,`,
		`NodeLoads:` + valueToStringMesos(this.NodeLoads) + `,`,
		`NodeLoadMisses:` + valueToStringMesos(this.NodeLoadMisses) + `,`,
		`NodeStores:` + valueToStringMesos(this.NodeStores) + `,`,
		`NodeStoreMisses:` + valueToStringMesos(this.NodeStoreMisses) + `,`,
		`NodePrefetches:` + valueToStringMesos(this.NodePrefetches) + `,`,
		`NodePrefetchMisses:` + valueToStringMesos(this.NodePrefetchMisses) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Request{`,
		`SlaveId:` + strings.Replace(fmt1.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Resources:` + strings.Replace(fmt1.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer{`,
		`Id:` + strings.Replace(fmt1.Sprintf("%v", this.Id), "OfferID", "OfferID", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt1.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`SlaveId:` + strings.Replace(fmt1.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Resources:` + strings.Replace(fmt1.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Attributes:` + strings.Replace(fmt1.Sprintf("%v", this.Attributes), "Attribute", "Attribute", 1) + `,`,
		`ExecutorIds:` + strings.Replace(fmt1.Sprintf("%v", this.ExecutorIds), "ExecutorID", "ExecutorID", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskInfo{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`TaskId:` + strings.Replace(fmt1.Sprintf("%v", this.TaskId), "TaskID", "TaskID", 1) + `,`,
		`SlaveId:` + strings.Replace(fmt1.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Resources:` + strings.Replace(fmt1.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Executor:` + strings.Replace(fmt1.Sprintf("%v", this.Executor), "ExecutorInfo", "ExecutorInfo", 1) + `,`,
		`Command:` + strings.Replace(fmt1.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`Container:` + strings.Replace(fmt1.Sprintf("%v", this.Container), "ContainerInfo", "ContainerInfo", 1) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`HealthCheck:` + strings.Replace(fmt1.Sprintf("%v", this.HealthCheck), "HealthCheck", "HealthCheck", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus{`,
		`TaskId:` + strings.Replace(fmt1.Sprintf("%v", this.TaskId), "TaskID", "TaskID", 1) + `,`,
		`State:` + valueToStringMesos(this.State) + `,`,
		`Message:` + valueToStringMesos(this.Message) + `,`,
		`Source:` + valueToStringMesos(this.Source) + `,`,
		`Reason:` + valueToStringMesos(this.Reason) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`SlaveId:` + strings.Replace(fmt1.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`ExecutorId:` + strings.Replace(fmt1.Sprintf("%v", this.ExecutorId), "ExecutorID", "ExecutorID", 1) + `,`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`Healthy:` + valueToStringMesos(this.Healthy) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Filters) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Filters{`,
		`RefuseSeconds:` + valueToStringMesos(this.RefuseSeconds) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Environment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Environment{`,
		`Variables:` + strings.Replace(fmt1.Sprintf("%v", this.Variables), "Environment_Variable", "Environment_Variable", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Environment_Variable) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Environment_Variable{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Parameter) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Parameter{`,
		`Key:` + valueToStringMesos(this.Key) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Parameters) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Parameters{`,
		`Parameter:` + strings.Replace(fmt1.Sprintf("%v", this.Parameter), "Parameter", "Parameter", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Credential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Credential{`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`Secret:` + valueToStringMesos(this.Secret) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Credentials) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Credentials{`,
		`Credentials:` + strings.Replace(fmt1.Sprintf("%v", this.Credentials), "Credential", "Credential", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL{`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_Entity) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_Entity{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Values:` + fmt1.Sprintf("%v", this.Values) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_RegisterFramework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_RegisterFramework{`,
		`Principals:` + strings.Replace(fmt1.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`Roles:` + strings.Replace(fmt1.Sprintf("%v", this.Roles), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_RunTask) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_RunTask{`,
		`Principals:` + strings.Replace(fmt1.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`Users:` + strings.Replace(fmt1.Sprintf("%v", this.Users), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_ShutdownFramework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_ShutdownFramework{`,
		`Principals:` + strings.Replace(fmt1.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`FrameworkPrincipals:` + strings.Replace(fmt1.Sprintf("%v", this.FrameworkPrincipals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACLs) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACLs{`,
		`Permissive:` + valueToStringMesos(this.Permissive) + `,`,
		`RegisterFrameworks:` + strings.Replace(fmt1.Sprintf("%v", this.RegisterFrameworks), "ACL_RegisterFramework", "ACL_RegisterFramework", 1) + `,`,
		`RunTasks:` + strings.Replace(fmt1.Sprintf("%v", this.RunTasks), "ACL_RunTask", "ACL_RunTask", 1) + `,`,
		`ShutdownFrameworks:` + strings.Replace(fmt1.Sprintf("%v", this.ShutdownFrameworks), "ACL_ShutdownFramework", "ACL_ShutdownFramework", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RateLimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RateLimit{`,
		`Qps:` + valueToStringMesos(this.Qps) + `,`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`Capacity:` + valueToStringMesos(this.Capacity) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RateLimits) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RateLimits{`,
		`Limits:` + strings.Replace(fmt1.Sprintf("%v", this.Limits), "RateLimit", "RateLimit", 1) + `,`,
		`AggregateDefaultQps:` + valueToStringMesos(this.AggregateDefaultQps) + `,`,
		`AggregateDefaultCapacity:` + valueToStringMesos(this.AggregateDefaultCapacity) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Volume) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Volume{`,
		`ContainerPath:` + valueToStringMesos(this.ContainerPath) + `,`,
		`HostPath:` + valueToStringMesos(this.HostPath) + `,`,
		`Mode:` + valueToStringMesos(this.Mode) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Volumes:` + strings.Replace(fmt1.Sprintf("%v", this.Volumes), "Volume", "Volume", 1) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Docker:` + strings.Replace(fmt1.Sprintf("%v", this.Docker), "ContainerInfo_DockerInfo", "ContainerInfo_DockerInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo_DockerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo_DockerInfo{`,
		`Image:` + valueToStringMesos(this.Image) + `,`,
		`Network:` + valueToStringMesos(this.Network) + `,`,
		`PortMappings:` + strings.Replace(fmt1.Sprintf("%v", this.PortMappings), "ContainerInfo_DockerInfo_PortMapping", "ContainerInfo_DockerInfo_PortMapping", 1) + `,`,
		`Privileged:` + valueToStringMesos(this.Privileged) + `,`,
		`Parameters:` + strings.Replace(fmt1.Sprintf("%v", this.Parameters), "Parameter", "Parameter", 1) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo_DockerInfo_PortMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo_DockerInfo_PortMapping{`,
		`HostPort:` + valueToStringMesos(this.HostPort) + `,`,
		`ContainerPort:` + valueToStringMesos(this.ContainerPort) + `,`,
		`Protocol:` + valueToStringMesos(this.Protocol) + `,`,
		`XXX_unrecognized:` + fmt1.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMesos(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt1.Sprintf("*%v", pv)
}
func (m *FrameworkID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OfferID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SlaveID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecutorID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FrameworkInfo) Size() (n int) {
	var l int
	_ = l
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FailoverTimeout != nil {
		n += 9
	}
	if m.Checkpoint != nil {
		n += 2
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.WebuiUrl != nil {
		l = len(*m.WebuiUrl)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck) Size() (n int) {
	var l int
	_ = l
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.DelaySeconds != nil {
		n += 9
	}
	if m.IntervalSeconds != nil {
		n += 9
	}
	if m.TimeoutSeconds != nil {
		n += 9
	}
	if m.ConsecutiveFailures != nil {
		n += 1 + sovMesos(uint64(*m.ConsecutiveFailures))
	}
	if m.GracePeriodSeconds != nil {
		n += 9
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_HTTP) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Statuses) > 0 {
		for _, e := range m.Statuses {
			n += 1 + sovMesos(uint64(e))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Uris) > 0 {
		for _, e := range m.Uris {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Environment != nil {
		l = m.Environment.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Shell != nil {
		n += 2
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Arguments) > 0 {
		for _, s := range m.Arguments {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo_URI) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Executable != nil {
		n += 2
	}
	if m.Extract != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo_ContainerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecutorInfo) Size() (n int) {
	var l int
	_ = l
	if m.ExecutorId != nil {
		l = m.ExecutorId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Source != nil {
		l = len(*m.Source)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterInfo) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ip != nil {
		n += 1 + sovMesos(uint64(*m.Ip))
	}
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.Pid != nil {
		l = len(*m.Pid)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SlaveInfo) Size() (n int) {
	var l int
	_ = l
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Checkpoint != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Text != nil {
		l = m.Text.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Scalar) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Range) Size() (n int) {
	var l int
	_ = l
	if m.Begin != nil {
		n += 1 + sovMesos(uint64(*m.Begin))
	}
	if m.End != nil {
		n += 1 + sovMesos(uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Ranges) Size() (n int) {
	var l int
	_ = l
	if len(m.Range) > 0 {
		for _, e := range m.Range {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Set) Size() (n int) {
	var l int
	_ = l
	if len(m.Item) > 0 {
		for _, s := range m.Item {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Text) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Attribute) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Text != nil {
		l = m.Text.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		n += 9
	}
	if m.CpusUserTimeSecs != nil {
		n += 9
	}
	if m.CpusSystemTimeSecs != nil {
		n += 9
	}
	if m.CpusLimit != nil {
		n += 9
	}
	if m.CpusNrPeriods != nil {
		n += 1 + sovMesos(uint64(*m.CpusNrPeriods))
	}
	if m.CpusNrThrottled != nil {
		n += 1 + sovMesos(uint64(*m.CpusNrThrottled))
	}
	if m.CpusThrottledTimeSecs != nil {
		n += 9
	}
	if m.MemRssBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemRssBytes))
	}
	if m.MemLimitBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemLimitBytes))
	}
	if m.MemFileBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemFileBytes))
	}
	if m.MemAnonBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemAnonBytes))
	}
	if m.MemMappedFileBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemMappedFileBytes))
	}
	if m.Perf != nil {
		l = m.Perf.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.NetRxPackets != nil {
		n += 1 + sovMesos(uint64(*m.NetRxPackets))
	}
	if m.NetRxBytes != nil {
		n += 1 + sovMesos(uint64(*m.NetRxBytes))
	}
	if m.NetRxErrors != nil {
		n += 2 + sovMesos(uint64(*m.NetRxErrors))
	}
	if m.NetRxDropped != nil {
		n += 2 + sovMesos(uint64(*m.NetRxDropped))
	}
	if m.NetTxPackets != nil {
		n += 2 + sovMesos(uint64(*m.NetTxPackets))
	}
	if m.NetTxBytes != nil {
		n += 2 + sovMesos(uint64(*m.NetTxBytes))
	}
	if m.NetTxErrors != nil {
		n += 2 + sovMesos(uint64(*m.NetTxErrors))
	}
	if m.NetTxDropped != nil {
		n += 2 + sovMesos(uint64(*m.NetTxDropped))
	}
	if m.NetTcpRttMicrosecsP50 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP90 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP95 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP99 != nil {
		n += 10
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceUsage) Size() (n int) {
	var l int
	_ = l
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.ExecutorId != nil {
		l = m.ExecutorId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.ExecutorName != nil {
		l = len(*m.ExecutorName)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.TaskId != nil {
		l = m.TaskId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Statistics != nil {
		l = m.Statistics.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PerfStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		n += 9
	}
	if m.Duration != nil {
		n += 9
	}
	if m.Cycles != nil {
		n += 1 + sovMesos(uint64(*m.Cycles))
	}
	if m.StalledCyclesFrontend != nil {
		n += 1 + sovMesos(uint64(*m.StalledCyclesFrontend))
	}
	if m.StalledCyclesBackend != nil {
		n += 1 + sovMesos(uint64(*m.StalledCyclesBackend))
	}
	if m.Instructions != nil {
		n += 1 + sovMesos(uint64(*m.Instructions))
	}
	if m.CacheReferences != nil {
		n += 1 + sovMesos(uint64(*m.CacheReferences))
	}
	if m.CacheMisses != nil {
		n += 1 + sovMesos(uint64(*m.CacheMisses))
	}
	if m.Branches != nil {
		n += 1 + sovMesos(uint64(*m.Branches))
	}
	if m.BranchMisses != nil {
		n += 1 + sovMesos(uint64(*m.BranchMisses))
	}
	if m.BusCycles != nil {
		n += 1 + sovMesos(uint64(*m.BusCycles))
	}
	if m.RefCycles != nil {
		n += 1 + sovMesos(uint64(*m.RefCycles))
	}
	if m.CpuClock != nil {
		n += 9
	}
	if m.TaskClock != nil {
		n += 9
	}
	if m.PageFaults != nil {
		n += 1 + sovMesos(uint64(*m.PageFaults))
	}
	if m.MinorFaults != nil {
		n += 2 + sovMesos(uint64(*m.MinorFaults))
	}
	if m.MajorFaults != nil {
		n += 2 + sovMesos(uint64(*m.MajorFaults))
	}
	if m.ContextSwitches != nil {
		n += 2 + sovMesos(uint64(*m.ContextSwitches))
	}
	if m.CpuMigrations != nil {
		n += 2 + sovMesos(uint64(*m.CpuMigrations))
	}
	if m.AlignmentFaults != nil {
		n += 2 + sovMesos(uint64(*m.AlignmentFaults))
	}
	if m.EmulationFaults != nil {
		n += 2 + sovMesos(uint64(*m.EmulationFaults))
	}
	if m.L1DcacheLoads != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheLoads))
	}
	if m.L1DcacheLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheLoadMisses))
	}
	if m.L1DcacheStores != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheStores))
	}
	if m.L1DcacheStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheStoreMisses))
	}
	if m.L1DcachePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.L1DcachePrefetches))
	}
	if m.L1DcachePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcachePrefetchMisses))
	}
	if m.L1IcacheLoads != nil {
		n += 2 + sovMesos(uint64(*m.L1IcacheLoads))
	}
	if m.L1IcacheLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1IcacheLoadMisses))
	}
	if m.L1IcachePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.L1IcachePrefetches))
	}
	if m.L1IcachePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1IcachePrefetchMisses))
	}
	if m.LlcLoads != nil {
		n += 2 + sovMesos(uint64(*m.LlcLoads))
	}
	if m.LlcLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcLoadMisses))
	}
	if m.LlcStores != nil {
		n += 2 + sovMesos(uint64(*m.LlcStores))
	}
	if m.LlcStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcStoreMisses))
	}
	if m.LlcPrefetches != nil {
		n += 2 + sovMesos(uint64(*m.LlcPrefetches))
	}
	if m.LlcPrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcPrefetchMisses))
	}
	if m.DtlbLoads != nil {
		n += 2 + sovMesos(uint64(*m.DtlbLoads))
	}
	if m.DtlbLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbLoadMisses))
	}
	if m.DtlbStores != nil {
		n += 2 + sovMesos(uint64(*m.DtlbStores))
	}
	if m.DtlbStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbStoreMisses))
	}
	if m.DtlbPrefetches != nil {
		n += 2 + sovMesos(uint64(*m.DtlbPrefetches))
	}
	if m.DtlbPrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbPrefetchMisses))
	}
	if m.ItlbLoads != nil {
		n += 2 + sovMesos(uint64(*m.ItlbLoads))
	}
	if m.ItlbLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.ItlbLoadMisses))
	}
	if m.BranchLoads != nil {
		n += 2 + sovMesos(uint64(*m.BranchLoads))
	}
	if m.BranchLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.BranchLoadMisses))
	}
	if m.NodeLoads != nil {
		n += 2 + sovMesos(uint64(*m.NodeLoads))
	}
	if m.NodeLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodeLoadMisses))
	}
	if m.NodeStores != nil {
		n += 2 + sovMesos(uint64(*m.NodeStores))
	}
	if m.NodeStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodeStoreMisses))
	}
	if m.NodePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.NodePrefetches))
	}
	if m.NodePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodePrefetchMisses))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Request) Size() (n int) {
	var l int
	_ = l
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.ExecutorIds) > 0 {
		for _, e := range m.ExecutorIds {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskInfo) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.TaskId != nil {
		l = m.TaskId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Executor != nil {
		l = m.Executor.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.HealthCheck != nil {
		l = m.HealthCheck.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskStatus) Size() (n int) {
	var l int
	_ = l
	if m.TaskId != nil {
		l = m.TaskId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.State != nil {
		n += 1 + sovMesos(uint64(*m.State))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Source != nil {
		n += 1 + sovMesos(uint64(*m.Source))
	}
	if m.Reason != nil {
		n += 1 + sovMesos(uint64(*m.Reason))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.ExecutorId != nil {
		l = m.ExecutorId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Timestamp != nil {
		n += 9
	}
	if m.Healthy != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Filters) Size() (n int) {
	var l int
	_ = l
	if m.RefuseSeconds != nil {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Environment) Size() (n int) {
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for _, e := range m.Variables {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Environment_Variable) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Parameter) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Parameters) Size() (n int) {
	var l int
	_ = l
	if len(m.Parameter) > 0 {
		for _, e := range m.Parameter {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Credential) Size() (n int) {
	var l int
	_ = l
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Secret != nil {
		l = len(m.Secret)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Credentials) Size() (n int) {
	var l int
	_ = l
	if len(m.Credentials) > 0 {
		for _, e := range m.Credentials {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_Entity) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_RegisterFramework) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Roles != nil {
		l = m.Roles.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_RunTask) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Users != nil {
		l = m.Users.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_ShutdownFramework) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkPrincipals != nil {
		l = m.FrameworkPrincipals.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACLs) Size() (n int) {
	var l int
	_ = l
	if m.Permissive != nil {
		n += 2
	}
	if len(m.RegisterFrameworks) > 0 {
		for _, e := range m.RegisterFrameworks {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.RunTasks) > 0 {
		for _, e := range m.RunTasks {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.ShutdownFrameworks) > 0 {
		for _, e := range m.ShutdownFrameworks {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit) Size() (n int) {
	var l int
	_ = l
	if m.Qps != nil {
		n += 9
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Capacity != nil {
		n += 1 + sovMesos(uint64(*m.Capacity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimits) Size() (n int) {
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, e := range m.Limits {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.AggregateDefaultQps != nil {
		n += 9
	}
	if m.AggregateDefaultCapacity != nil {
		n += 1 + sovMesos(uint64(*m.AggregateDefaultCapacity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Volume) Size() (n int) {
	var l int
	_ = l
	if m.ContainerPath != nil {
		l = len(*m.ContainerPath)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.HostPath != nil {
		l = len(*m.HostPath)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovMesos(uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Docker != nil {
		l = m.Docker.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo_DockerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Network != nil {
		n += 1 + sovMesos(uint64(*m.Network))
	}
	if len(m.PortMappings) > 0 {
		for _, e := range m.PortMappings {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Privileged != nil {
		n += 2
	}
	if len(m.Parameters) > 0 {
		for _, e := range m.Parameters {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo_DockerInfo_PortMapping) Size() (n int) {
	var l int
	_ = l
	if m.HostPort != nil {
		n += 1 + sovMesos(uint64(*m.HostPort))
	}
	if m.ContainerPort != nil {
		n += 1 + sovMesos(uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMesos(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMesos(x uint64) (n int) {
	return sovMesos(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func NewPopulatedFrameworkID(r randyMesos, easy bool) *FrameworkID {
	this := &FrameworkID{}
	v1 := randStringMesos(r)
	this.Value = &v1
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOfferID(r randyMesos, easy bool) *OfferID {
	this := &OfferID{}
	v2 := randStringMesos(r)
	this.Value = &v2
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedSlaveID(r randyMesos, easy bool) *SlaveID {
	this := &SlaveID{}
	v3 := randStringMesos(r)
	this.Value = &v3
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedTaskID(r randyMesos, easy bool) *TaskID {
	this := &TaskID{}
	v4 := randStringMesos(r)
	this.Value = &v4
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedExecutorID(r randyMesos, easy bool) *ExecutorID {
	this := &ExecutorID{}
	v5 := randStringMesos(r)
	this.Value = &v5
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedContainerID(r randyMesos, easy bool) *ContainerID {
	this := &ContainerID{}
	v6 := randStringMesos(r)
	this.Value = &v6
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedFrameworkInfo(r randyMesos, easy bool) *FrameworkInfo {
	this := &FrameworkInfo{}
	v7 := randStringMesos(r)
	this.User = &v7
	v8 := randStringMesos(r)
	this.Name = &v8
	if r.Intn(10) != 0 {
		this.Id = NewPopulatedFrameworkID(r, easy)
	}
	if r.Intn(10) != 0 {
		v9 := r.Float64()
		if r.Intn(2) == 0 {
			v9 *= -1
		}
		this.FailoverTimeout = &v9
	}
	if r.Intn(10) != 0 {
		v10 := bool(r.Intn(2) == 0)
		this.Checkpoint = &v10
	}
	if r.Intn(10) != 0 {
		v11 := randStringMesos(r)
		this.Role = &v11
	}
	if r.Intn(10) != 0 {
		v12 := randStringMesos(r)
		this.Hostname = &v12
	}
	if r.Intn(10) != 0 {
		v13 := randStringMesos(r)
		this.Principal = &v13
	}
	if r.Intn(10) != 0 {
		v14 := randStringMesos(r)
		this.WebuiUrl = &v14
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 10)
	}
	return this
}

func NewPopulatedHealthCheck(r randyMesos, easy bool) *HealthCheck {
	this := &HealthCheck{}
	if r.Intn(10) != 0 {
		this.Http = NewPopulatedHealthCheck_HTTP(r, easy)
	}
	if r.Intn(10) != 0 {
		v15 := r.Float64()
		if r.Intn(2) == 0 {
			v15 *= -1
		}
		this.DelaySeconds = &v15
	}
	if r.Intn(10) != 0 {
		v16 := r.Float64()
		if r.Intn(2) == 0 {
			v16 *= -1
		}
		this.IntervalSeconds = &v16
	}
	if r.Intn(10) != 0 {
		v17 := r.Float64()
		if r.Intn(2) == 0 {
			v17 *= -1
		}
		this.TimeoutSeconds = &v17
	}
	if r.Intn(10) != 0 {
		v18 := r.Uint32()
		this.ConsecutiveFailures = &v18
	}
	if r.Intn(10) != 0 {
		v19 := r.Float64()
		if r.Intn(2) == 0 {
			v19 *= -1
		}
		this.GracePeriodSeconds = &v19
	}
	if r.Intn(10) != 0 {
		this.Command = NewPopulatedCommandInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedHealthCheck_HTTP(r randyMesos, easy bool) *HealthCheck_HTTP {
	this := &HealthCheck_HTTP{}
	v20 := r.Uint32()
	this.Port = &v20
	if r.Intn(10) != 0 {
		v21 := randStringMesos(r)
		this.Path = &v21
	}
	if r.Intn(10) != 0 {
		v22 := r.Intn(100)
		this.Statuses = make([]uint32, v22)
		for i := 0; i < v22; i++ {
			this.Statuses[i] = r.Uint32()
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedCommandInfo(r randyMesos, easy bool) *CommandInfo {
	this := &CommandInfo{}
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedCommandInfo_ContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v23 := r.Intn(10)
		this.Uris = make([]*CommandInfo_URI, v23)
		for i := 0; i < v23; i++ {
			this.Uris[i] = NewPopulatedCommandInfo_URI(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Environment = NewPopulatedEnvironment(r, easy)
	}
	if r.Intn(10) != 0 {
		v24 := bool(r.Intn(2) == 0)
		this.Shell = &v24
	}
	if r.Intn(10) != 0 {
		v25 := randStringMesos(r)
		this.Value = &v25
	}
	if r.Intn(10) != 0 {
		v26 := r.Intn(10)
		this.Arguments = make([]string, v26)
		for i := 0; i < v26; i++ {
			this.Arguments[i] = randStringMesos(r)
		}
	}
	if r.Intn(10) != 0 {
		v27 := randStringMesos(r)
		this.User = &v27
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedCommandInfo_URI(r randyMesos, easy bool) *CommandInfo_URI {
	this := &CommandInfo_URI{}
	v28 := randStringMesos(r)
	this.Value = &v28
	if r.Intn(10) != 0 {
		v29 := bool(r.Intn(2) == 0)
		this.Executable = &v29
	}
	if r.Intn(10) != 0 {
		v30 := bool(r.Intn(2) == 0)
		this.Extract = &v30
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedCommandInfo_ContainerInfo(r randyMesos, easy bool) *CommandInfo_ContainerInfo {
	this := &CommandInfo_ContainerInfo{}
	v31 := randStringMesos(r)
	this.Image = &v31
	if r.Intn(10) != 0 {
		v32 := r.Intn(10)
		this.Options = make([]string, v32)
		for i := 0; i < v32; i++ {
			this.Options[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedExecutorInfo(r randyMesos, easy bool) *ExecutorInfo {
	this := &ExecutorInfo{}
	this.ExecutorId = NewPopulatedExecutorID(r, easy)
	if r.Intn(10) != 0 {
		this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	}
	this.Command = NewPopulatedCommandInfo(r, easy)
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v33 := r.Intn(10)
		this.Resources = make([]*Resource, v33)
		for i := 0; i < v33; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v34 := randStringMesos(r)
		this.Name = &v34
	}
	if r.Intn(10) != 0 {
		v35 := randStringMesos(r)
		this.Source = &v35
	}
	if r.Intn(10) != 0 {
		v36 := r.Intn(100)
		this.Data = make([]byte, v36)
		for i := 0; i < v36; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 12)
	}
	return this
}

func NewPopulatedMasterInfo(r randyMesos, easy bool) *MasterInfo {
	this := &MasterInfo{}
	v37 := randStringMesos(r)
	this.Id = &v37
	v38 := r.Uint32()
	this.Ip = &v38
	v39 := r.Uint32()
	this.Port = &v39
	if r.Intn(10) != 0 {
		v40 := randStringMesos(r)
		this.Pid = &v40
	}
	if r.Intn(10) != 0 {
		v41 := randStringMesos(r)
		this.Hostname = &v41
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedSlaveInfo(r randyMesos, easy bool) *SlaveInfo {
	this := &SlaveInfo{}
	v42 := randStringMesos(r)
	this.Hostname = &v42
	if r.Intn(10) != 0 {
		v43 := r.Int31()
		if r.Intn(2) == 0 {
			v43 *= -1
		}
		this.Port = &v43
	}
	if r.Intn(10) != 0 {
		v44 := r.Intn(10)
		this.Resources = make([]*Resource, v44)
		for i := 0; i < v44; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v45 := r.Intn(10)
		this.Attributes = make([]*Attribute, v45)
		for i := 0; i < v45; i++ {
			this.Attributes[i] = NewPopulatedAttribute(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Id = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v46 := bool(r.Intn(2) == 0)
		this.Checkpoint = &v46
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 9)
	}
	return this
}

func NewPopulatedValue(r randyMesos, easy bool) *Value {
	this := &Value{}
	v47 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v47
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Text = NewPopulatedValue_Text(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedValue_Scalar(r randyMesos, easy bool) *Value_Scalar {
	this := &Value_Scalar{}
	v48 := r.Float64()
	if r.Intn(2) == 0 {
		v48 *= -1
	}
	this.Value = &v48
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Range(r randyMesos, easy bool) *Value_Range {
	this := &Value_Range{}
	v49 := uint64(r.Uint32())
	this.Begin = &v49
	v50 := uint64(r.Uint32())
	this.End = &v50
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedValue_Ranges(r randyMesos, easy bool) *Value_Ranges {
	this := &Value_Ranges{}
	if r.Intn(10) != 0 {
		v51 := r.Intn(10)
		this.Range = make([]*Value_Range, v51)
		for i := 0; i < v51; i++ {
			this.Range[i] = NewPopulatedValue_Range(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Set(r randyMesos, easy bool) *Value_Set {
	this := &Value_Set{}
	if r.Intn(10) != 0 {
		v52 := r.Intn(10)
		this.Item = make([]string, v52)
		for i := 0; i < v52; i++ {
			this.Item[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Text(r randyMesos, easy bool) *Value_Text {
	this := &Value_Text{}
	v53 := randStringMesos(r)
	this.Value = &v53
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedAttribute(r randyMesos, easy bool) *Attribute {
	this := &Attribute{}
	v54 := randStringMesos(r)
	this.Name = &v54
	v55 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v55
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Text = NewPopulatedValue_Text(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedResource(r randyMesos, easy bool) *Resource {
	this := &Resource{}
	v56 := randStringMesos(r)
	this.Name = &v56
	v57 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v57
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if r.Intn(10) != 0 {
		v58 := randStringMesos(r)
		this.Role = &v58
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedResourceStatistics(r randyMesos, easy bool) *ResourceStatistics {
	this := &ResourceStatistics{}
	v59 := r.Float64()
	if r.Intn(2) == 0 {
		v59 *= -1
	}
	this.Timestamp = &v59
	if r.Intn(10) != 0 {
		v60 := r.Float64()
		if r.Intn(2) == 0 {
			v60 *= -1
		}
		this.CpusUserTimeSecs = &v60
	}
	if r.Intn(10) != 0 {
		v61 := r.Float64()
		if r.Intn(2) == 0 {
			v61 *= -1
		}
		this.CpusSystemTimeSecs = &v61
	}
	if r.Intn(10) != 0 {
		v62 := r.Float64()
		if r.Intn(2) == 0 {
			v62 *= -1
		}
		this.CpusLimit = &v62
	}
	if r.Intn(10) != 0 {
		v63 := r.Uint32()
		this.CpusNrPeriods = &v63
	}
	if r.Intn(10) != 0 {
		v64 := r.Uint32()
		this.CpusNrThrottled = &v64
	}
	if r.Intn(10) != 0 {
		v65 := r.Float64()
		if r.Intn(2) == 0 {
			v65 *= -1
		}
		this.CpusThrottledTimeSecs = &v65
	}
	if r.Intn(10) != 0 {
		v66 := uint64(r.Uint32())
		this.MemRssBytes = &v66
	}
	if r.Intn(10) != 0 {
		v67 := uint64(r.Uint32())
		this.MemLimitBytes = &v67
	}
	if r.Intn(10) != 0 {
		v68 := uint64(r.Uint32())
		this.MemFileBytes = &v68
	}
	if r.Intn(10) != 0 {
		v69 := uint64(r.Uint32())
		this.MemAnonBytes = &v69
	}
	if r.Intn(10) != 0 {
		v70 := uint64(r.Uint32())
		this.MemMappedFileBytes = &v70
	}
	if r.Intn(10) != 0 {
		this.Perf = NewPopulatedPerfStatistics(r, easy)
	}
	if r.Intn(10) != 0 {
		v71 := uint64(r.Uint32())
		this.NetRxPackets = &v71
	}
	if r.Intn(10) != 0 {
		v72 := uint64(r.Uint32())
		this.NetRxBytes = &v72
	}
	if r.Intn(10) != 0 {
		v73 := uint64(r.Uint32())
		this.NetRxErrors = &v73
	}
	if r.Intn(10) != 0 {
		v74 := uint64(r.Uint32())
		this.NetRxDropped = &v74
	}
	if r.Intn(10) != 0 {
		v75 := uint64(r.Uint32())
		this.NetTxPackets = &v75
	}
	if r.Intn(10) != 0 {
		v76 := uint64(r.Uint32())
		this.NetTxBytes = &v76
	}
	if r.Intn(10) != 0 {
		v77 := uint64(r.Uint32())
		this.NetTxErrors = &v77
	}
	if r.Intn(10) != 0 {
		v78 := uint64(r.Uint32())
		this.NetTxDropped = &v78
	}
	if r.Intn(10) != 0 {
		v79 := r.Float64()
		if r.Intn(2) == 0 {
			v79 *= -1
		}
		this.NetTcpRttMicrosecsP50 = &v79
	}
	if r.Intn(10) != 0 {
		v80 := r.Float64()
		if r.Intn(2) == 0 {
			v80 *= -1
		}
		this.NetTcpRttMicrosecsP90 = &v80
	}
	if r.Intn(10) != 0 {
		v81 := r.Float64()
		if r.Intn(2) == 0 {
			v81 *= -1
		}
		this.NetTcpRttMicrosecsP95 = &v81
	}
	if r.Intn(10) != 0 {
		v82 := r.Float64()
		if r.Intn(2) == 0 {
			v82 *= -1
		}
		this.NetTcpRttMicrosecsP99 = &v82
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 26)
	}
	return this
}

func NewPopulatedResourceUsage(r randyMesos, easy bool) *ResourceUsage {
	this := &ResourceUsage{}
	this.SlaveId = NewPopulatedSlaveID(r, easy)
	this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	if r.Intn(10) != 0 {
		this.ExecutorId = NewPopulatedExecutorID(r, easy)
	}
	if r.Intn(10) != 0 {
		v83 := randStringMesos(r)
		this.ExecutorName = &v83
	}
	if r.Intn(10) != 0 {
		this.TaskId = NewPopulatedTaskID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Statistics = NewPopulatedResourceStatistics(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedPerfStatistics(r randyMesos, easy bool) *PerfStatistics {
	this := &PerfStatistics{}
	v84 := r.Float64()
	if r.Intn(2) == 0 {
		v84 *= -1
	}
	this.Timestamp = &v84
	v85 := r.Float64()
	if r.Intn(2) == 0 {
		v85 *= -1
	}
	this.Duration = &v85
	if r.Intn(10) != 0 {
		v86 := uint64(r.Uint32())
		this.Cycles = &v86
	}
	if r.Intn(10) != 0 {
		v87 := uint64(r.Uint32())
		this.StalledCyclesFrontend = &v87
	}
	if r.Intn(10) != 0 {
		v88 := uint64(r.Uint32())
		this.StalledCyclesBackend = &v88
	}
	if r.Intn(10) != 0 {
		v89 := uint64(r.Uint32())
		this.Instructions = &v89
	}
	if r.Intn(10) != 0 {
		v90 := uint64(r.Uint32())
		this.CacheReferences = &v90
	}
	if r.Intn(10) != 0 {
		v91 := uint64(r.Uint32())
		this.CacheMisses = &v91
	}
	if r.Intn(10) != 0 {
		v92 := uint64(r.Uint32())
		this.Branches = &v92
	}
	if r.Intn(10) != 0 {
		v93 := uint64(r.Uint32())
		this.BranchMisses = &v93
	}
	if r.Intn(10) != 0 {
		v94 := uint64(r.Uint32())
		this.BusCycles = &v94
	}
	if r.Intn(10) != 0 {
		v95 := uint64(r.Uint32())
		this.RefCycles = &v95
	}
	if r.Intn(10) != 0 {
		v96 := r.Float64()
		if r.Intn(2) == 0 {
			v96 *= -1
		}
		this.CpuClock = &v96
	}
	if r.Intn(10) != 0 {
		v97 := r.Float64()
		if r.Intn(2) == 0 {
			v97 *= -1
		}
		this.TaskClock = &v97
	}
	if r.Intn(10) != 0 {
		v98 := uint64(r.Uint32())
		this.PageFaults = &v98
	}
	if r.Intn(10) != 0 {
		v99 := uint64(r.Uint32())
		this.MinorFaults = &v99
	}
	if r.Intn(10) != 0 {
		v100 := uint64(r.Uint32())
		this.MajorFaults = &v100
	}
	if r.Intn(10) != 0 {
		v101 := uint64(r.Uint32())
		this.ContextSwitches = &v101
	}
	if r.Intn(10) != 0 {
		v102 := uint64(r.Uint32())
		this.CpuMigrations = &v102
	}
	if r.Intn(10) != 0 {
		v103 := uint64(r.Uint32())
		this.AlignmentFaults = &v103
	}
	if r.Intn(10) != 0 {
		v104 := uint64(r.Uint32())
		this.EmulationFaults = &v104
	}
	if r.Intn(10) != 0 {
		v105 := uint64(r.Uint32())
		this.L1DcacheLoads = &v105
	}
	if r.Intn(10) != 0 {
		v106 := uint64(r.Uint32())
		this.L1DcacheLoadMisses = &v106
	}
	if r.Intn(10) != 0 {
		v107 := uint64(r.Uint32())
		this.L1DcacheStores = &v107
	}
	if r.Intn(10) != 0 {
		v108 := uint64(r.Uint32())
		this.L1DcacheStoreMisses = &v108
	}
	if r.Intn(10) != 0 {
		v109 := uint64(r.Uint32())
		this.L1DcachePrefetches = &v109
	}
	if r.Intn(10) != 0 {
		v110 := uint64(r.Uint32())
		this.L1DcachePrefetchMisses = &v110
	}
	if r.Intn(10) != 0 {
		v111 := uint64(r.Uint32())
		this.L1IcacheLoads = &v111
	}
	if r.Intn(10) != 0 {
		v112 := uint64(r.Uint32())
		this.L1IcacheLoadMisses = &v112
	}
	if r.Intn(10) != 0 {
		v113 := uint64(r.Uint32())
		this.L1IcachePrefetches = &v113
	}
	if r.Intn(10) != 0 {
		v114 := uint64(r.Uint32())
		this.L1IcachePrefetchMisses = &v114
	}
	if r.Intn(10) != 0 {
		v115 := uint64(r.Uint32())
		this.LlcLoads = &v115
	}
	if r.Intn(10) != 0 {
		v116 := uint64(r.Uint32())
		this.LlcLoadMisses = &v116
	}
	if r.Intn(10) != 0 {
		v117 := uint64(r.Uint32())
		this.LlcStores = &v117
	}
	if r.Intn(10) != 0 {
		v118 := uint64(r.Uint32())
		this.LlcStoreMisses = &v118
	}
	if r.Intn(10) != 0 {
		v119 := uint64(r.Uint32())
		this.LlcPrefetches = &v119
	}
	if r.Intn(10) != 0 {
		v120 := uint64(r.Uint32())
		this.LlcPrefetchMisses = &v120
	}
	if r.Intn(10) != 0 {
		v121 := uint64(r.Uint32())
		this.DtlbLoads = &v121
	}
	if r.Intn(10) != 0 {
		v122 := uint64(r.Uint32())
		this.DtlbLoadMisses = &v122
	}
	if r.Intn(10) != 0 {
		v123 := uint64(r.Uint32())
		this.DtlbStores = &v123
	}
	if r.Intn(10) != 0 {
		v124 := uint64(r.Uint32())
		this.DtlbStoreMisses = &v124
	}
	if r.Intn(10) != 0 {
		v125 := uint64(r.Uint32())
		this.DtlbPrefetches = &v125
	}
	if r.Intn(10) != 0 {
		v126 := uint64(r.Uint32())
		this.DtlbPrefetchMisses = &v126
	}
	if r.Intn(10) != 0 {
		v127 := uint64(r.Uint32())
		this.ItlbLoads = &v127
	}
	if r.Intn(10) != 0 {
		v128 := uint64(r.Uint32())
		this.ItlbLoadMisses = &v128
	}
	if r.Intn(10) != 0 {
		v129 := uint64(r.Uint32())
		this.BranchLoads = &v129
	}
	if r.Intn(10) != 0 {
		v130 := uint64(r.Uint32())
		this.BranchLoadMisses = &v130
	}
	if r.Intn(10) != 0 {
		v131 := uint64(r.Uint32())
		this.NodeLoads = &v131
	}
	if r.Intn(10) != 0 {
		v132 := uint64(r.Uint32())
		this.NodeLoadMisses = &v132
	}
	if r.Intn(10) != 0 {
		v133 := uint64(r.Uint32())
		this.NodeStores = &v133
	}
	if r.Intn(10) != 0 {
		v134 := uint64(r.Uint32())
		this.NodeStoreMisses = &v134
	}
	if r.Intn(10) != 0 {
		v135 := uint64(r.Uint32())
		this.NodePrefetches = &v135
	}
	if r.Intn(10) != 0 {
		v136 := uint64(r.Uint32())
		this.NodePrefetchMisses = &v136
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 54)
	}
	return this
}

func NewPopulatedRequest(r randyMesos, easy bool) *Request {
	this := &Request{}
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v137 := r.Intn(10)
		this.Resources = make([]*Resource, v137)
		for i := 0; i < v137; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedOffer(r randyMesos, easy bool) *Offer {
	this := &Offer{}
	this.Id = NewPopulatedOfferID(r, easy)
	this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	this.SlaveId = NewPopulatedSlaveID(r, easy)
	v138 := randStringMesos(r)
	this.Hostname = &v138
	if r.Intn(10) != 0 {
		v139 := r.Intn(10)
		this.Resources = make([]*Resource, v139)
		for i := 0; i < v139; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v140 := r.Intn(10)
		this.Attributes = make([]*Attribute, v140)
		for i := 0; i < v140; i++ {
			this.Attributes[i] = NewPopulatedAttribute(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v141 := r.Intn(10)
		this.ExecutorIds = make([]*ExecutorID, v141)
		for i := 0; i < v141; i++ {
			this.ExecutorIds[i] = NewPopulatedExecutorID(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedTaskInfo(r randyMesos, easy bool) *TaskInfo {
	this := &TaskInfo{}
	v142 := randStringMesos(r)
	this.Name = &v142
	this.TaskId = NewPopulatedTaskID(r, easy)
	this.SlaveId = NewPopulatedSlaveID(r, easy)
	if r.Intn(10) != 0 {
		v143 := r.Intn(10)
		this.Resources = make([]*Resource, v143)
		for i := 0; i < v143; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Executor = NewPopulatedExecutorInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Command = NewPopulatedCommandInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v144 := r.Intn(100)
		this.Data = make([]byte, v144)
		for i := 0; i < v144; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.HealthCheck = NewPopulatedHealthCheck(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 10)
	}
	return this
}

func NewPopulatedTaskStatus(r randyMesos, easy bool) *TaskStatus {
	this := &TaskStatus{}
	this.TaskId = NewPopulatedTaskID(r, easy)
	v145 := TaskState([]int32{6, 0, 1, 2, 3, 4, 5, 7}[r.Intn(8)])
	this.State = &v145
	if r.Intn(10) != 0 {
		v146 := randStringMesos(r)
		this.Message = &v146
	}
	if r.Intn(10) != 0 {
		v147 := TaskStatus_Source([]int32{0, 1, 2}[r.Intn(3)])
		this.Source = &v147
	}
	if r.Intn(10) != 0 {
		v148 := TaskStatus_Reason([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}[r.Intn(17)])
		this.Reason = &v148
	}
	if r.Intn(10) != 0 {
		v149 := r.Intn(100)
		this.Data = make([]byte, v149)
		for i := 0; i < v149; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ExecutorId = NewPopulatedExecutorID(r, easy)
	}
	if r.Intn(10) != 0 {
		v150 := r.Float64()
		if r.Intn(2) == 0 {
			v150 *= -1
		}
		this.Timestamp = &v150
	}
	if r.Intn(10) != 0 {
		v151 := bool(r.Intn(2) == 0)
		this.Healthy = &v151
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 11)
	}
	return this
}

func NewPopulatedFilters(r randyMesos, easy bool) *Filters {
	this := &Filters{}
	if r.Intn(10) != 0 {
		v152 := r.Float64()
		if r.Intn(2) == 0 {
			v152 *= -1
		}
		this.RefuseSeconds = &v152
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedEnvironment(r randyMesos, easy bool) *Environment {
	this := &Environment{}
	if r.Intn(10) != 0 {
		v153 := r.Intn(10)
		this.Variables = make([]*Environment_Variable, v153)
		for i := 0; i < v153; i++ {
			this.Variables[i] = NewPopulatedEnvironment_Variable(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedEnvironment_Variable(r randyMesos, easy bool) *Environment_Variable {
	this := &Environment_Variable{}
	v154 := randStringMesos(r)
	this.Name = &v154
	v155 := randStringMesos(r)
	this.Value = &v155
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedParameter(r randyMesos, easy bool) *Parameter {
	this := &Parameter{}
	v156 := randStringMesos(r)
	this.Key = &v156
	v157 := randStringMesos(r)
	this.Value = &v157
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedParameters(r randyMesos, easy bool) *Parameters {
	this := &Parameters{}
	if r.Intn(10) != 0 {
		v158 := r.Intn(10)
		this.Parameter = make([]*Parameter, v158)
		for i := 0; i < v158; i++ {
			this.Parameter[i] = NewPopulatedParameter(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedCredential(r randyMesos, easy bool) *Credential {
	this := &Credential{}
	v159 := randStringMesos(r)
	this.Principal = &v159
	if r.Intn(10) != 0 {
		v160 := r.Intn(100)
		this.Secret = make([]byte, v160)
		for i := 0; i < v160; i++ {
			this.Secret[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedCredentials(r randyMesos, easy bool) *Credentials {
	this := &Credentials{}
	if r.Intn(10) != 0 {
		v161 := r.Intn(10)
		this.Credentials = make([]*Credential, v161)
		for i := 0; i < v161; i++ {
			this.Credentials[i] = NewPopulatedCredential(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedACL(r randyMesos, easy bool) *ACL {
	this := &ACL{}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 1)
	}
	return this
}

func NewPopulatedACL_Entity(r randyMesos, easy bool) *ACL_Entity {
	this := &ACL_Entity{}
	if r.Intn(10) != 0 {
		v162 := ACL_Entity_Type([]int32{0, 1, 2}[r.Intn(3)])
		this.Type = &v162
	}
	if r.Intn(10) != 0 {
		v163 := r.Intn(10)
		this.Values = make([]string, v163)
		for i := 0; i < v163; i++ {
			this.Values[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedACL_RegisterFramework(r randyMesos, easy bool) *ACL_RegisterFramework {
	this := &ACL_RegisterFramework{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.Roles = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedACL_RunTask(r randyMesos, easy bool) *ACL_RunTask {
	this := &ACL_RunTask{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.Users = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedACL_ShutdownFramework(r randyMesos, easy bool) *ACL_ShutdownFramework {
	this := &ACL_ShutdownFramework{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.FrameworkPrincipals = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedACLs(r randyMesos, easy bool) *ACLs {
	this := &ACLs{}
	if r.Intn(10) != 0 {
		v164 := bool(r.Intn(2) == 0)
		this.Permissive = &v164
	}
	if r.Intn(10) != 0 {
		v165 := r.Intn(10)
		this.RegisterFrameworks = make([]*ACL_RegisterFramework, v165)
		for i := 0; i < v165; i++ {
			this.RegisterFrameworks[i] = NewPopulatedACL_RegisterFramework(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v166 := r.Intn(10)
		this.RunTasks = make([]*ACL_RunTask, v166)
		for i := 0; i < v166; i++ {
			this.RunTasks[i] = NewPopulatedACL_RunTask(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v167 := r.Intn(10)
		this.ShutdownFrameworks = make([]*ACL_ShutdownFramework, v167)
		for i := 0; i < v167; i++ {
			this.ShutdownFrameworks[i] = NewPopulatedACL_ShutdownFramework(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedRateLimit(r randyMesos, easy bool) *RateLimit {
	this := &RateLimit{}
	if r.Intn(10) != 0 {
		v168 := r.Float64()
		if r.Intn(2) == 0 {
			v168 *= -1
		}
		this.Qps = &v168
	}
	v169 := randStringMesos(r)
	this.Principal = &v169
	if r.Intn(10) != 0 {
		v170 := uint64(r.Uint32())
		this.Capacity = &v170
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedRateLimits(r randyMesos, easy bool) *RateLimits {
	this := &RateLimits{}
	if r.Intn(10) != 0 {
		v171 := r.Intn(10)
		this.Limits = make([]*RateLimit, v171)
		for i := 0; i < v171; i++ {
			this.Limits[i] = NewPopulatedRateLimit(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v172 := r.Float64()
		if r.Intn(2) == 0 {
			v172 *= -1
		}
		this.AggregateDefaultQps = &v172
	}
	if r.Intn(10) != 0 {
		v173 := uint64(r.Uint32())
		this.AggregateDefaultCapacity = &v173
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedVolume(r randyMesos, easy bool) *Volume {
	this := &Volume{}
	v174 := randStringMesos(r)
	this.ContainerPath = &v174
	if r.Intn(10) != 0 {
		v175 := randStringMesos(r)
		this.HostPath = &v175
	}
	v176 := Volume_Mode([]int32{1, 2}[r.Intn(2)])
	this.Mode = &v176
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedContainerInfo(r randyMesos, easy bool) *ContainerInfo {
	this := &ContainerInfo{}
	v177 := ContainerInfo_Type([]int32{1, 2}[r.Intn(2)])
	this.Type = &v177
	if r.Intn(10) != 0 {
		v178 := r.Intn(10)
		this.Volumes = make([]*Volume, v178)
		for i := 0; i < v178; i++ {
			this.Volumes[i] = NewPopulatedVolume(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v179 := randStringMesos(r)
		this.Hostname = &v179
	}
	if r.Intn(10) != 0 {
		this.Docker = NewPopulatedContainerInfo_DockerInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedContainerInfo_DockerInfo(r randyMesos, easy bool) *ContainerInfo_DockerInfo {
	this := &ContainerInfo_DockerInfo{}
	v180 := randStringMesos(r)
	this.Image = &v180
	if r.Intn(10) != 0 {
		v181 := ContainerInfo_DockerInfo_Network([]int32{1, 2, 3}[r.Intn(3)])
		this.Network = &v181
	}
	if r.Intn(10) != 0 {
		v182 := r.Intn(10)
		this.PortMappings = make([]*ContainerInfo_DockerInfo_PortMapping, v182)
		for i := 0; i < v182; i++ {
			this.PortMappings[i] = NewPopulatedContainerInfo_DockerInfo_PortMapping(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v183 := bool(r.Intn(2) == 0)
		this.Privileged = &v183
	}
	if r.Intn(10) != 0 {
		v184 := r.Intn(10)
		this.Parameters = make([]*Parameter, v184)
		for i := 0; i < v184; i++ {
			this.Parameters[i] = NewPopulatedParameter(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedContainerInfo_DockerInfo_PortMapping(r randyMesos, easy bool) *ContainerInfo_DockerInfo_PortMapping {
	this := &ContainerInfo_DockerInfo_PortMapping{}
	v185 := r.Uint32()
	this.HostPort = &v185
	v186 := r.Uint32()
	this.ContainerPort = &v186
	if r.Intn(10) != 0 {
		v187 := randStringMesos(r)
		this.Protocol = &v187
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

type randyMesos interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMesos(r randyMesos) rune {
	res := rune(r.Uint32() % 1112064)
	if 55296 <= res {
		res += 2047
	}
	return res
}
func randStringMesos(r randyMesos) string {
	v188 := r.Intn(100)
	tmps := make([]rune, v188)
	for i := 0; i < v188; i++ {
		tmps[i] = randUTF8RuneMesos(r)
	}
	return string(tmps)
}
func randUnrecognizedMesos(r randyMesos, maxFieldNumber int) (data []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		data = randFieldMesos(data, r, fieldNumber, wire)
	}
	return data
}
func randFieldMesos(data []byte, r randyMesos, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		data = encodeVarintPopulateMesos(data, uint64(key))
		v189 := r.Int63()
		if r.Intn(2) == 0 {
			v189 *= -1
		}
		data = encodeVarintPopulateMesos(data, uint64(v189))
	case 1:
		data = encodeVarintPopulateMesos(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		data = encodeVarintPopulateMesos(data, uint64(key))
		ll := r.Intn(100)
		data = encodeVarintPopulateMesos(data, uint64(ll))
		for j := 0; j < ll; j++ {
			data = append(data, byte(r.Intn(256)))
		}
	default:
		data = encodeVarintPopulateMesos(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return data
}
func encodeVarintPopulateMesos(data []byte, v uint64) []byte {
	for v >= 1<<7 {
		data = append(data, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	data = append(data, uint8(v))
	return data
}
func (m *FrameworkID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FrameworkID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OfferID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *OfferID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SlaveID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SlaveID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExecutorID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ExecutorID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerID) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FrameworkInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FrameworkInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.User != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.User)))
		i += copy(data[i:], *m.User)
	}
	if m.Name != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Id != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n1, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.FailoverTimeout != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.FailoverTimeout)))
	}
	if m.Checkpoint != nil {
		data[i] = 0x28
		i++
		if *m.Checkpoint {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Role != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Role)))
		i += copy(data[i:], *m.Role)
	}
	if m.Hostname != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Principal != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.WebuiUrl != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.WebuiUrl)))
		i += copy(data[i:], *m.WebuiUrl)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HealthCheck) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Http != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Http.Size()))
		n2, err := m.Http.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DelaySeconds != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.DelaySeconds)))
	}
	if m.IntervalSeconds != nil {
		data[i] = 0x19
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.IntervalSeconds)))
	}
	if m.TimeoutSeconds != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.TimeoutSeconds)))
	}
	if m.ConsecutiveFailures != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ConsecutiveFailures))
	}
	if m.GracePeriodSeconds != nil {
		data[i] = 0x31
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.GracePeriodSeconds)))
	}
	if m.Command != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n3, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_HTTP) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HealthCheck_HTTP) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.Path != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Path)))
		i += copy(data[i:], *m.Path)
	}
	if len(m.Statuses) > 0 {
		for _, num := range m.Statuses {
			data[i] = 0x20
			i++
			i = encodeVarintMesos(data, i, uint64(num))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Container != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n4, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.Uris) > 0 {
		for _, msg := range m.Uris {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Environment != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Environment.Size()))
		n5, err := m.Environment.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Shell != nil {
		data[i] = 0x30
		i++
		if *m.Shell {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Value != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if len(m.Arguments) > 0 {
		for _, s := range m.Arguments {
			data[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.User != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.User)))
		i += copy(data[i:], *m.User)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo_URI) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo_URI) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.Executable != nil {
		data[i] = 0x10
		i++
		if *m.Executable {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Extract != nil {
		data[i] = 0x18
		i++
		if *m.Extract {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo_ContainerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo_ContainerInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Image != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Image)))
		i += copy(data[i:], *m.Image)
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExecutorInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ExecutorInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExecutorId != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorId.Size()))
		n6, err := m.ExecutorId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.FrameworkId != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n7, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Command != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n8, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Container != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n9, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Name != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Source != nil {
		data[i] = 0x52
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Source)))
		i += copy(data[i:], *m.Source)
	}
	if m.Data != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MasterInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Id)))
		i += copy(data[i:], *m.Id)
	}
	if m.Ip != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Ip))
	}
	if m.Port != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.Pid != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Pid)))
		i += copy(data[i:], *m.Pid)
	}
	if m.Hostname != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SlaveInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SlaveInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Port != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x1a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Id != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n10, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Checkpoint != nil {
		data[i] = 0x38
		i++
		if *m.Checkpoint {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n11, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.Ranges != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n12, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.Set != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n13, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Text != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Text.Size()))
		n14, err := m.Text.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Scalar) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Scalar) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Value)))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Range) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Range) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Begin != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Begin))
	}
	if m.End != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Ranges) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Ranges) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Range) > 0 {
		for _, msg := range m.Range {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Set) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Set) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Item) > 0 {
		for _, s := range m.Item {
			data[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Text) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Text) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Attribute) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Attribute) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Type != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n15, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Ranges != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n16, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.Set != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n17, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.Text != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Text.Size()))
		n18, err := m.Text.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Type != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n19, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Ranges != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n20, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Set != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n21, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Role != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Role)))
		i += copy(data[i:], *m.Role)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceStatistics) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceStatistics) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Timestamp)))
	}
	if m.CpusUserTimeSecs != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.CpusUserTimeSecs)))
	}
	if m.CpusSystemTimeSecs != nil {
		data[i] = 0x19
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.CpusSystemTimeSecs)))
	}
	if m.CpusLimit != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.CpusLimit)))
	}
	if m.CpusNrPeriods != nil {
		data[i] = 0x38
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpusNrPeriods))
	}
	if m.CpusNrThrottled != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpusNrThrottled))
	}
	if m.CpusThrottledTimeSecs != nil {
		data[i] = 0x49
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.CpusThrottledTimeSecs)))
	}
	if m.MemRssBytes != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemRssBytes))
	}
	if m.MemLimitBytes != nil {
		data[i] = 0x30
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemLimitBytes))
	}
	if m.MemFileBytes != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemFileBytes))
	}
	if m.MemAnonBytes != nil {
		data[i] = 0x58
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemAnonBytes))
	}
	if m.MemMappedFileBytes != nil {
		data[i] = 0x60
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemMappedFileBytes))
	}
	if m.Perf != nil {
		data[i] = 0x6a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Perf.Size()))
		n22, err := m.Perf.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.NetRxPackets != nil {
		data[i] = 0x70
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxPackets))
	}
	if m.NetRxBytes != nil {
		data[i] = 0x78
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxBytes))
	}
	if m.NetRxErrors != nil {
		data[i] = 0x80
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxErrors))
	}
	if m.NetRxDropped != nil {
		data[i] = 0x88
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxDropped))
	}
	if m.NetTxPackets != nil {
		data[i] = 0x90
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxPackets))
	}
	if m.NetTxBytes != nil {
		data[i] = 0x98
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxBytes))
	}
	if m.NetTxErrors != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxErrors))
	}
	if m.NetTxDropped != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxDropped))
	}
	if m.NetTcpRttMicrosecsP50 != nil {
		data[i] = 0xb1
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.NetTcpRttMicrosecsP50)))
	}
	if m.NetTcpRttMicrosecsP90 != nil {
		data[i] = 0xb9
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.NetTcpRttMicrosecsP90)))
	}
	if m.NetTcpRttMicrosecsP95 != nil {
		data[i] = 0xc1
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.NetTcpRttMicrosecsP95)))
	}
	if m.NetTcpRttMicrosecsP99 != nil {
		data[i] = 0xc9
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.NetTcpRttMicrosecsP99)))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceUsage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceUsage) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SlaveId != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n23, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.FrameworkId != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n24, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.ExecutorId != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorId.Size()))
		n25, err := m.ExecutorId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.ExecutorName != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.ExecutorName)))
		i += copy(data[i:], *m.ExecutorName)
	}
	if m.TaskId != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.TaskId.Size()))
		n26, err := m.TaskId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.Statistics != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Statistics.Size()))
		n27, err := m.Statistics.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PerfStatistics) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PerfStatistics) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Timestamp)))
	}
	if m.Duration != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Duration)))
	}
	if m.Cycles != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Cycles))
	}
	if m.StalledCyclesFrontend != nil {
		data[i] = 0x20
		i++
		i = encodeVarintMesos(data, i, uint64(*m.StalledCyclesFrontend))
	}
	if m.StalledCyclesBackend != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.StalledCyclesBackend))
	}
	if m.Instructions != nil {
		data[i] = 0x30
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Instructions))
	}
	if m.CacheReferences != nil {
		data[i] = 0x38
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CacheReferences))
	}
	if m.CacheMisses != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CacheMisses))
	}
	if m.Branches != nil {
		data[i] = 0x48
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Branches))
	}
	if m.BranchMisses != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchMisses))
	}
	if m.BusCycles != nil {
		data[i] = 0x58
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BusCycles))
	}
	if m.RefCycles != nil {
		data[i] = 0x60
		i++
		i = encodeVarintMesos(data, i, uint64(*m.RefCycles))
	}
	if m.CpuClock != nil {
		data[i] = 0x69
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.CpuClock)))
	}
	if m.TaskClock != nil {
		data[i] = 0x71
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.TaskClock)))
	}
	if m.PageFaults != nil {
		data[i] = 0x78
		i++
		i = encodeVarintMesos(data, i, uint64(*m.PageFaults))
	}
	if m.MinorFaults != nil {
		data[i] = 0x80
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MinorFaults))
	}
	if m.MajorFaults != nil {
		data[i] = 0x88
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MajorFaults))
	}
	if m.ContextSwitches != nil {
		data[i] = 0x90
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ContextSwitches))
	}
	if m.CpuMigrations != nil {
		data[i] = 0x98
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpuMigrations))
	}
	if m.AlignmentFaults != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.AlignmentFaults))
	}
	if m.EmulationFaults != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.EmulationFaults))
	}
	if m.L1DcacheLoads != nil {
		data[i] = 0xb0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheLoads))
	}
	if m.L1DcacheLoadMisses != nil {
		data[i] = 0xb8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheLoadMisses))
	}
	if m.L1DcacheStores != nil {
		data[i] = 0xc0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheStores))
	}
	if m.L1DcacheStoreMisses != nil {
		data[i] = 0xc8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheStoreMisses))
	}
	if m.L1DcachePrefetches != nil {
		data[i] = 0xd0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcachePrefetches))
	}
	if m.L1DcachePrefetchMisses != nil {
		data[i] = 0xd8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcachePrefetchMisses))
	}
	if m.L1IcacheLoads != nil {
		data[i] = 0xe0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcacheLoads))
	}
	if m.L1IcacheLoadMisses != nil {
		data[i] = 0xe8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcacheLoadMisses))
	}
	if m.L1IcachePrefetches != nil {
		data[i] = 0xf0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcachePrefetches))
	}
	if m.L1IcachePrefetchMisses != nil {
		data[i] = 0xf8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcachePrefetchMisses))
	}
	if m.LlcLoads != nil {
		data[i] = 0x80
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcLoads))
	}
	if m.LlcLoadMisses != nil {
		data[i] = 0x88
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcLoadMisses))
	}
	if m.LlcStores != nil {
		data[i] = 0x90
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcStores))
	}
	if m.LlcStoreMisses != nil {
		data[i] = 0x98
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcStoreMisses))
	}
	if m.LlcPrefetches != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcPrefetches))
	}
	if m.LlcPrefetchMisses != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcPrefetchMisses))
	}
	if m.DtlbLoads != nil {
		data[i] = 0xb0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbLoads))
	}
	if m.DtlbLoadMisses != nil {
		data[i] = 0xb8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbLoadMisses))
	}
	if m.DtlbStores != nil {
		data[i] = 0xc0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbStores))
	}
	if m.DtlbStoreMisses != nil {
		data[i] = 0xc8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbStoreMisses))
	}
	if m.DtlbPrefetches != nil {
		data[i] = 0xd0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbPrefetches))
	}
	if m.DtlbPrefetchMisses != nil {
		data[i] = 0xd8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbPrefetchMisses))
	}
	if m.ItlbLoads != nil {
		data[i] = 0xe0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ItlbLoads))
	}
	if m.ItlbLoadMisses != nil {
		data[i] = 0xe8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ItlbLoadMisses))
	}
	if m.BranchLoads != nil {
		data[i] = 0xf0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchLoads))
	}
	if m.BranchLoadMisses != nil {
		data[i] = 0xf8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchLoadMisses))
	}
	if m.NodeLoads != nil {
		data[i] = 0x80
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeLoads))
	}
	if m.NodeLoadMisses != nil {
		data[i] = 0x88
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeLoadMisses))
	}
	if m.NodeStores != nil {
		data[i] = 0x90
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeStores))
	}
	if m.NodeStoreMisses != nil {
		data[i] = 0x98
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeStoreMisses))
	}
	if m.NodePrefetches != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodePrefetches))
	}
	if m.NodePrefetchMisses != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodePrefetchMisses))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Request) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Request) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SlaveId != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n28, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n29, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.FrameworkId != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n30, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.SlaveId != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n31, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.Hostname != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			data[i] = 0x3a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ExecutorIds) > 0 {
		for _, msg := range m.ExecutorIds {
			data[i] = 0x32
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.TaskId != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.TaskId.Size()))
		n32, err := m.TaskId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.SlaveId != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n33, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x22
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Executor != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Executor.Size()))
		n34, err := m.Executor.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.Command != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n35, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.Container != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n36, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.Data != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.HealthCheck != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.HealthCheck.Size()))
		n37, err := m.HealthCheck.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskStatus) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TaskId != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.TaskId.Size()))
		n38, err := m.TaskId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.State != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.State))
	}
	if m.Message != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Message)))
		i += copy(data[i:], *m.Message)
	}
	if m.Source != nil {
		data[i] = 0x48
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Source))
	}
	if m.Reason != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Reason))
	}
	if m.Data != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.SlaveId != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n39, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.ExecutorId != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorId.Size()))
		n40, err := m.ExecutorId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.Timestamp != nil {
		data[i] = 0x31
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Timestamp)))
	}
	if m.Healthy != nil {
		data[i] = 0x40
		i++
		if *m.Healthy {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Filters) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Filters) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RefuseSeconds != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.RefuseSeconds)))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Environment) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Environment) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for _, msg := range m.Variables {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Environment_Variable) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Environment_Variable) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Value != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Parameter) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Parameter) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Key)))
		i += copy(data[i:], *m.Key)
	}
	if m.Value != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Parameters) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Parameters) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Parameter) > 0 {
		for _, msg := range m.Parameter {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Credential) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Credential) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principal != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.Secret != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Secret)))
		i += copy(data[i:], m.Secret)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Credentials) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Credentials) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Credentials) > 0 {
		for _, msg := range m.Credentials {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_Entity) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_Entity) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_RegisterFramework) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_RegisterFramework) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Principals.Size()))
		n41, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.Roles != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Roles.Size()))
		n42, err := m.Roles.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_RunTask) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_RunTask) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Principals.Size()))
		n43, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.Users != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Users.Size()))
		n44, err := m.Users.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_ShutdownFramework) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_ShutdownFramework) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Principals.Size()))
		n45, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.FrameworkPrincipals != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkPrincipals.Size()))
		n46, err := m.FrameworkPrincipals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACLs) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACLs) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Permissive != nil {
		data[i] = 0x8
		i++
		if *m.Permissive {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.RegisterFrameworks) > 0 {
		for _, msg := range m.RegisterFrameworks {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RunTasks) > 0 {
		for _, msg := range m.RunTasks {
			data[i] = 0x1a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ShutdownFrameworks) > 0 {
		for _, msg := range m.ShutdownFrameworks {
			data[i] = 0x22
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RateLimit) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Qps != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.Qps)))
	}
	if m.Principal != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.Capacity != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Capacity))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimits) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RateLimits) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, msg := range m.Limits {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AggregateDefaultQps != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math2.Float64bits(*m.AggregateDefaultQps)))
	}
	if m.AggregateDefaultCapacity != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.AggregateDefaultCapacity))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Volume) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Volume) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerPath != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.ContainerPath)))
		i += copy(data[i:], *m.ContainerPath)
	}
	if m.HostPath != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.HostPath)))
		i += copy(data[i:], *m.HostPath)
	}
	if m.Mode != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Hostname != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Docker != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Docker.Size()))
		n47, err := m.Docker.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo_DockerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo_DockerInfo) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Image != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Image)))
		i += copy(data[i:], *m.Image)
	}
	if m.Network != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Network))
	}
	if len(m.PortMappings) > 0 {
		for _, msg := range m.PortMappings {
			data[i] = 0x1a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Privileged != nil {
		data[i] = 0x20
		i++
		if *m.Privileged {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Parameters) > 0 {
		for _, msg := range m.Parameters {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo_DockerInfo_PortMapping) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo_DockerInfo_PortMapping) MarshalTo(data []byte) (n int, err error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HostPort != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.HostPort))
	}
	if m.ContainerPort != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Protocol)))
		i += copy(data[i:], *m.Protocol)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Mesos(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Mesos(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMesos(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (this *FrameworkID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.FrameworkID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *OfferID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.OfferID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *SlaveID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.SlaveID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *TaskID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.TaskID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ExecutorID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ExecutorID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ContainerID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ContainerID{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *FrameworkInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.FrameworkInfo{` +
		`User:` + valueToGoStringMesos(this.User, "string"),
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`Id:` + fmt2.Sprintf("%#v", this.Id),
		`FailoverTimeout:` + valueToGoStringMesos(this.FailoverTimeout, "float64"),
		`Checkpoint:` + valueToGoStringMesos(this.Checkpoint, "bool"),
		`Role:` + valueToGoStringMesos(this.Role, "string"),
		`Hostname:` + valueToGoStringMesos(this.Hostname, "string"),
		`Principal:` + valueToGoStringMesos(this.Principal, "string"),
		`WebuiUrl:` + valueToGoStringMesos(this.WebuiUrl, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *HealthCheck) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.HealthCheck{` +
		`Http:` + fmt2.Sprintf("%#v", this.Http),
		`DelaySeconds:` + valueToGoStringMesos(this.DelaySeconds, "float64"),
		`IntervalSeconds:` + valueToGoStringMesos(this.IntervalSeconds, "float64"),
		`TimeoutSeconds:` + valueToGoStringMesos(this.TimeoutSeconds, "float64"),
		`ConsecutiveFailures:` + valueToGoStringMesos(this.ConsecutiveFailures, "uint32"),
		`GracePeriodSeconds:` + valueToGoStringMesos(this.GracePeriodSeconds, "float64"),
		`Command:` + fmt2.Sprintf("%#v", this.Command),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *HealthCheck_HTTP) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.HealthCheck_HTTP{` +
		`Port:` + valueToGoStringMesos(this.Port, "uint32"),
		`Path:` + valueToGoStringMesos(this.Path, "string"),
		`Statuses:` + fmt2.Sprintf("%#v", this.Statuses),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *CommandInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.CommandInfo{` +
		`Container:` + fmt2.Sprintf("%#v", this.Container),
		`Uris:` + fmt2.Sprintf("%#v", this.Uris),
		`Environment:` + fmt2.Sprintf("%#v", this.Environment),
		`Shell:` + valueToGoStringMesos(this.Shell, "bool"),
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`Arguments:` + fmt2.Sprintf("%#v", this.Arguments),
		`User:` + valueToGoStringMesos(this.User, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *CommandInfo_URI) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.CommandInfo_URI{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`Executable:` + valueToGoStringMesos(this.Executable, "bool"),
		`Extract:` + valueToGoStringMesos(this.Extract, "bool"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *CommandInfo_ContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.CommandInfo_ContainerInfo{` +
		`Image:` + valueToGoStringMesos(this.Image, "string"),
		`Options:` + fmt2.Sprintf("%#v", this.Options),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ExecutorInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ExecutorInfo{` +
		`ExecutorId:` + fmt2.Sprintf("%#v", this.ExecutorId),
		`FrameworkId:` + fmt2.Sprintf("%#v", this.FrameworkId),
		`Command:` + fmt2.Sprintf("%#v", this.Command),
		`Container:` + fmt2.Sprintf("%#v", this.Container),
		`Resources:` + fmt2.Sprintf("%#v", this.Resources),
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`Source:` + valueToGoStringMesos(this.Source, "string"),
		`Data:` + valueToGoStringMesos(this.Data, "byte"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *MasterInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.MasterInfo{` +
		`Id:` + valueToGoStringMesos(this.Id, "string"),
		`Ip:` + valueToGoStringMesos(this.Ip, "uint32"),
		`Port:` + valueToGoStringMesos(this.Port, "uint32"),
		`Pid:` + valueToGoStringMesos(this.Pid, "string"),
		`Hostname:` + valueToGoStringMesos(this.Hostname, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *SlaveInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.SlaveInfo{` +
		`Hostname:` + valueToGoStringMesos(this.Hostname, "string"),
		`Port:` + valueToGoStringMesos(this.Port, "int32"),
		`Resources:` + fmt2.Sprintf("%#v", this.Resources),
		`Attributes:` + fmt2.Sprintf("%#v", this.Attributes),
		`Id:` + fmt2.Sprintf("%#v", this.Id),
		`Checkpoint:` + valueToGoStringMesos(this.Checkpoint, "bool"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value{` +
		`Type:` + valueToGoStringMesos(this.Type, "mesosproto.Value_Type"),
		`Scalar:` + fmt2.Sprintf("%#v", this.Scalar),
		`Ranges:` + fmt2.Sprintf("%#v", this.Ranges),
		`Set:` + fmt2.Sprintf("%#v", this.Set),
		`Text:` + fmt2.Sprintf("%#v", this.Text),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value_Scalar) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value_Scalar{` +
		`Value:` + valueToGoStringMesos(this.Value, "float64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value_Range) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value_Range{` +
		`Begin:` + valueToGoStringMesos(this.Begin, "uint64"),
		`End:` + valueToGoStringMesos(this.End, "uint64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value_Ranges) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value_Ranges{` +
		`Range:` + fmt2.Sprintf("%#v", this.Range),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value_Set) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value_Set{` +
		`Item:` + fmt2.Sprintf("%#v", this.Item),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Value_Text) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Value_Text{` +
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Attribute) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Attribute{` +
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`Type:` + valueToGoStringMesos(this.Type, "mesosproto.Value_Type"),
		`Scalar:` + fmt2.Sprintf("%#v", this.Scalar),
		`Ranges:` + fmt2.Sprintf("%#v", this.Ranges),
		`Set:` + fmt2.Sprintf("%#v", this.Set),
		`Text:` + fmt2.Sprintf("%#v", this.Text),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Resource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Resource{` +
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`Type:` + valueToGoStringMesos(this.Type, "mesosproto.Value_Type"),
		`Scalar:` + fmt2.Sprintf("%#v", this.Scalar),
		`Ranges:` + fmt2.Sprintf("%#v", this.Ranges),
		`Set:` + fmt2.Sprintf("%#v", this.Set),
		`Role:` + valueToGoStringMesos(this.Role, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ResourceStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ResourceStatistics{` +
		`Timestamp:` + valueToGoStringMesos(this.Timestamp, "float64"),
		`CpusUserTimeSecs:` + valueToGoStringMesos(this.CpusUserTimeSecs, "float64"),
		`CpusSystemTimeSecs:` + valueToGoStringMesos(this.CpusSystemTimeSecs, "float64"),
		`CpusLimit:` + valueToGoStringMesos(this.CpusLimit, "float64"),
		`CpusNrPeriods:` + valueToGoStringMesos(this.CpusNrPeriods, "uint32"),
		`CpusNrThrottled:` + valueToGoStringMesos(this.CpusNrThrottled, "uint32"),
		`CpusThrottledTimeSecs:` + valueToGoStringMesos(this.CpusThrottledTimeSecs, "float64"),
		`MemRssBytes:` + valueToGoStringMesos(this.MemRssBytes, "uint64"),
		`MemLimitBytes:` + valueToGoStringMesos(this.MemLimitBytes, "uint64"),
		`MemFileBytes:` + valueToGoStringMesos(this.MemFileBytes, "uint64"),
		`MemAnonBytes:` + valueToGoStringMesos(this.MemAnonBytes, "uint64"),
		`MemMappedFileBytes:` + valueToGoStringMesos(this.MemMappedFileBytes, "uint64"),
		`Perf:` + fmt2.Sprintf("%#v", this.Perf),
		`NetRxPackets:` + valueToGoStringMesos(this.NetRxPackets, "uint64"),
		`NetRxBytes:` + valueToGoStringMesos(this.NetRxBytes, "uint64"),
		`NetRxErrors:` + valueToGoStringMesos(this.NetRxErrors, "uint64"),
		`NetRxDropped:` + valueToGoStringMesos(this.NetRxDropped, "uint64"),
		`NetTxPackets:` + valueToGoStringMesos(this.NetTxPackets, "uint64"),
		`NetTxBytes:` + valueToGoStringMesos(this.NetTxBytes, "uint64"),
		`NetTxErrors:` + valueToGoStringMesos(this.NetTxErrors, "uint64"),
		`NetTxDropped:` + valueToGoStringMesos(this.NetTxDropped, "uint64"),
		`NetTcpRttMicrosecsP50:` + valueToGoStringMesos(this.NetTcpRttMicrosecsP50, "float64"),
		`NetTcpRttMicrosecsP90:` + valueToGoStringMesos(this.NetTcpRttMicrosecsP90, "float64"),
		`NetTcpRttMicrosecsP95:` + valueToGoStringMesos(this.NetTcpRttMicrosecsP95, "float64"),
		`NetTcpRttMicrosecsP99:` + valueToGoStringMesos(this.NetTcpRttMicrosecsP99, "float64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ResourceUsage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ResourceUsage{` +
		`SlaveId:` + fmt2.Sprintf("%#v", this.SlaveId),
		`FrameworkId:` + fmt2.Sprintf("%#v", this.FrameworkId),
		`ExecutorId:` + fmt2.Sprintf("%#v", this.ExecutorId),
		`ExecutorName:` + valueToGoStringMesos(this.ExecutorName, "string"),
		`TaskId:` + fmt2.Sprintf("%#v", this.TaskId),
		`Statistics:` + fmt2.Sprintf("%#v", this.Statistics),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *PerfStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.PerfStatistics{` +
		`Timestamp:` + valueToGoStringMesos(this.Timestamp, "float64"),
		`Duration:` + valueToGoStringMesos(this.Duration, "float64"),
		`Cycles:` + valueToGoStringMesos(this.Cycles, "uint64"),
		`StalledCyclesFrontend:` + valueToGoStringMesos(this.StalledCyclesFrontend, "uint64"),
		`StalledCyclesBackend:` + valueToGoStringMesos(this.StalledCyclesBackend, "uint64"),
		`Instructions:` + valueToGoStringMesos(this.Instructions, "uint64"),
		`CacheReferences:` + valueToGoStringMesos(this.CacheReferences, "uint64"),
		`CacheMisses:` + valueToGoStringMesos(this.CacheMisses, "uint64"),
		`Branches:` + valueToGoStringMesos(this.Branches, "uint64"),
		`BranchMisses:` + valueToGoStringMesos(this.BranchMisses, "uint64"),
		`BusCycles:` + valueToGoStringMesos(this.BusCycles, "uint64"),
		`RefCycles:` + valueToGoStringMesos(this.RefCycles, "uint64"),
		`CpuClock:` + valueToGoStringMesos(this.CpuClock, "float64"),
		`TaskClock:` + valueToGoStringMesos(this.TaskClock, "float64"),
		`PageFaults:` + valueToGoStringMesos(this.PageFaults, "uint64"),
		`MinorFaults:` + valueToGoStringMesos(this.MinorFaults, "uint64"),
		`MajorFaults:` + valueToGoStringMesos(this.MajorFaults, "uint64"),
		`ContextSwitches:` + valueToGoStringMesos(this.ContextSwitches, "uint64"),
		`CpuMigrations:` + valueToGoStringMesos(this.CpuMigrations, "uint64"),
		`AlignmentFaults:` + valueToGoStringMesos(this.AlignmentFaults, "uint64"),
		`EmulationFaults:` + valueToGoStringMesos(this.EmulationFaults, "uint64"),
		`L1DcacheLoads:` + valueToGoStringMesos(this.L1DcacheLoads, "uint64"),
		`L1DcacheLoadMisses:` + valueToGoStringMesos(this.L1DcacheLoadMisses, "uint64"),
		`L1DcacheStores:` + valueToGoStringMesos(this.L1DcacheStores, "uint64"),
		`L1DcacheStoreMisses:` + valueToGoStringMesos(this.L1DcacheStoreMisses, "uint64"),
		`L1DcachePrefetches:` + valueToGoStringMesos(this.L1DcachePrefetches, "uint64"),
		`L1DcachePrefetchMisses:` + valueToGoStringMesos(this.L1DcachePrefetchMisses, "uint64"),
		`L1IcacheLoads:` + valueToGoStringMesos(this.L1IcacheLoads, "uint64"),
		`L1IcacheLoadMisses:` + valueToGoStringMesos(this.L1IcacheLoadMisses, "uint64"),
		`L1IcachePrefetches:` + valueToGoStringMesos(this.L1IcachePrefetches, "uint64"),
		`L1IcachePrefetchMisses:` + valueToGoStringMesos(this.L1IcachePrefetchMisses, "uint64"),
		`LlcLoads:` + valueToGoStringMesos(this.LlcLoads, "uint64"),
		`LlcLoadMisses:` + valueToGoStringMesos(this.LlcLoadMisses, "uint64"),
		`LlcStores:` + valueToGoStringMesos(this.LlcStores, "uint64"),
		`LlcStoreMisses:` + valueToGoStringMesos(this.LlcStoreMisses, "uint64"),
		`LlcPrefetches:` + valueToGoStringMesos(this.LlcPrefetches, "uint64"),
		`LlcPrefetchMisses:` + valueToGoStringMesos(this.LlcPrefetchMisses, "uint64"),
		`DtlbLoads:` + valueToGoStringMesos(this.DtlbLoads, "uint64"),
		`DtlbLoadMisses:` + valueToGoStringMesos(this.DtlbLoadMisses, "uint64"),
		`DtlbStores:` + valueToGoStringMesos(this.DtlbStores, "uint64"),
		`DtlbStoreMisses:` + valueToGoStringMesos(this.DtlbStoreMisses, "uint64"),
		`DtlbPrefetches:` + valueToGoStringMesos(this.DtlbPrefetches, "uint64"),
		`DtlbPrefetchMisses:` + valueToGoStringMesos(this.DtlbPrefetchMisses, "uint64"),
		`ItlbLoads:` + valueToGoStringMesos(this.ItlbLoads, "uint64"),
		`ItlbLoadMisses:` + valueToGoStringMesos(this.ItlbLoadMisses, "uint64"),
		`BranchLoads:` + valueToGoStringMesos(this.BranchLoads, "uint64"),
		`BranchLoadMisses:` + valueToGoStringMesos(this.BranchLoadMisses, "uint64"),
		`NodeLoads:` + valueToGoStringMesos(this.NodeLoads, "uint64"),
		`NodeLoadMisses:` + valueToGoStringMesos(this.NodeLoadMisses, "uint64"),
		`NodeStores:` + valueToGoStringMesos(this.NodeStores, "uint64"),
		`NodeStoreMisses:` + valueToGoStringMesos(this.NodeStoreMisses, "uint64"),
		`NodePrefetches:` + valueToGoStringMesos(this.NodePrefetches, "uint64"),
		`NodePrefetchMisses:` + valueToGoStringMesos(this.NodePrefetchMisses, "uint64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Request{` +
		`SlaveId:` + fmt2.Sprintf("%#v", this.SlaveId),
		`Resources:` + fmt2.Sprintf("%#v", this.Resources),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Offer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Offer{` +
		`Id:` + fmt2.Sprintf("%#v", this.Id),
		`FrameworkId:` + fmt2.Sprintf("%#v", this.FrameworkId),
		`SlaveId:` + fmt2.Sprintf("%#v", this.SlaveId),
		`Hostname:` + valueToGoStringMesos(this.Hostname, "string"),
		`Resources:` + fmt2.Sprintf("%#v", this.Resources),
		`Attributes:` + fmt2.Sprintf("%#v", this.Attributes),
		`ExecutorIds:` + fmt2.Sprintf("%#v", this.ExecutorIds),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *TaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.TaskInfo{` +
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`TaskId:` + fmt2.Sprintf("%#v", this.TaskId),
		`SlaveId:` + fmt2.Sprintf("%#v", this.SlaveId),
		`Resources:` + fmt2.Sprintf("%#v", this.Resources),
		`Executor:` + fmt2.Sprintf("%#v", this.Executor),
		`Command:` + fmt2.Sprintf("%#v", this.Command),
		`Container:` + fmt2.Sprintf("%#v", this.Container),
		`Data:` + valueToGoStringMesos(this.Data, "byte"),
		`HealthCheck:` + fmt2.Sprintf("%#v", this.HealthCheck),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *TaskStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.TaskStatus{` +
		`TaskId:` + fmt2.Sprintf("%#v", this.TaskId),
		`State:` + valueToGoStringMesos(this.State, "mesosproto.TaskState"),
		`Message:` + valueToGoStringMesos(this.Message, "string"),
		`Source:` + valueToGoStringMesos(this.Source, "mesosproto.TaskStatus_Source"),
		`Reason:` + valueToGoStringMesos(this.Reason, "mesosproto.TaskStatus_Reason"),
		`Data:` + valueToGoStringMesos(this.Data, "byte"),
		`SlaveId:` + fmt2.Sprintf("%#v", this.SlaveId),
		`ExecutorId:` + fmt2.Sprintf("%#v", this.ExecutorId),
		`Timestamp:` + valueToGoStringMesos(this.Timestamp, "float64"),
		`Healthy:` + valueToGoStringMesos(this.Healthy, "bool"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Filters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Filters{` +
		`RefuseSeconds:` + valueToGoStringMesos(this.RefuseSeconds, "float64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Environment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Environment{` +
		`Variables:` + fmt2.Sprintf("%#v", this.Variables),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Environment_Variable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Environment_Variable{` +
		`Name:` + valueToGoStringMesos(this.Name, "string"),
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Parameter) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Parameter{` +
		`Key:` + valueToGoStringMesos(this.Key, "string"),
		`Value:` + valueToGoStringMesos(this.Value, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Parameters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Parameters{` +
		`Parameter:` + fmt2.Sprintf("%#v", this.Parameter),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Credential) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Credential{` +
		`Principal:` + valueToGoStringMesos(this.Principal, "string"),
		`Secret:` + valueToGoStringMesos(this.Secret, "byte"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Credentials) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Credentials{` +
		`Credentials:` + fmt2.Sprintf("%#v", this.Credentials),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACL) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACL{` +
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACL_Entity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACL_Entity{` +
		`Type:` + valueToGoStringMesos(this.Type, "mesosproto.ACL_Entity_Type"),
		`Values:` + fmt2.Sprintf("%#v", this.Values),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACL_RegisterFramework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACL_RegisterFramework{` +
		`Principals:` + fmt2.Sprintf("%#v", this.Principals),
		`Roles:` + fmt2.Sprintf("%#v", this.Roles),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACL_RunTask) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACL_RunTask{` +
		`Principals:` + fmt2.Sprintf("%#v", this.Principals),
		`Users:` + fmt2.Sprintf("%#v", this.Users),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACL_ShutdownFramework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACL_ShutdownFramework{` +
		`Principals:` + fmt2.Sprintf("%#v", this.Principals),
		`FrameworkPrincipals:` + fmt2.Sprintf("%#v", this.FrameworkPrincipals),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ACLs) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ACLs{` +
		`Permissive:` + valueToGoStringMesos(this.Permissive, "bool"),
		`RegisterFrameworks:` + fmt2.Sprintf("%#v", this.RegisterFrameworks),
		`RunTasks:` + fmt2.Sprintf("%#v", this.RunTasks),
		`ShutdownFrameworks:` + fmt2.Sprintf("%#v", this.ShutdownFrameworks),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *RateLimit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.RateLimit{` +
		`Qps:` + valueToGoStringMesos(this.Qps, "float64"),
		`Principal:` + valueToGoStringMesos(this.Principal, "string"),
		`Capacity:` + valueToGoStringMesos(this.Capacity, "uint64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *RateLimits) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.RateLimits{` +
		`Limits:` + fmt2.Sprintf("%#v", this.Limits),
		`AggregateDefaultQps:` + valueToGoStringMesos(this.AggregateDefaultQps, "float64"),
		`AggregateDefaultCapacity:` + valueToGoStringMesos(this.AggregateDefaultCapacity, "uint64"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *Volume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.Volume{` +
		`ContainerPath:` + valueToGoStringMesos(this.ContainerPath, "string"),
		`HostPath:` + valueToGoStringMesos(this.HostPath, "string"),
		`Mode:` + valueToGoStringMesos(this.Mode, "mesosproto.Volume_Mode"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ContainerInfo{` +
		`Type:` + valueToGoStringMesos(this.Type, "mesosproto.ContainerInfo_Type"),
		`Volumes:` + fmt2.Sprintf("%#v", this.Volumes),
		`Hostname:` + valueToGoStringMesos(this.Hostname, "string"),
		`Docker:` + fmt2.Sprintf("%#v", this.Docker),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ContainerInfo_DockerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ContainerInfo_DockerInfo{` +
		`Image:` + valueToGoStringMesos(this.Image, "string"),
		`Network:` + valueToGoStringMesos(this.Network, "mesosproto.ContainerInfo_DockerInfo_Network"),
		`PortMappings:` + fmt2.Sprintf("%#v", this.PortMappings),
		`Privileged:` + valueToGoStringMesos(this.Privileged, "bool"),
		`Parameters:` + fmt2.Sprintf("%#v", this.Parameters),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func (this *ContainerInfo_DockerInfo_PortMapping) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings1.Join([]string{`&mesosproto.ContainerInfo_DockerInfo_PortMapping{` +
		`HostPort:` + valueToGoStringMesos(this.HostPort, "uint32"),
		`ContainerPort:` + valueToGoStringMesos(this.ContainerPort, "uint32"),
		`Protocol:` + valueToGoStringMesos(this.Protocol, "string"),
		`XXX_unrecognized:` + fmt2.Sprintf("%#v", this.XXX_unrecognized) + `}`}, ", ")
	return s
}
func valueToGoStringMesos(v interface{}, typ string) string {
	rv := reflect1.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect1.Indirect(rv).Interface()
	return fmt2.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringMesos(e map[int32]github_com_gogo_protobuf_proto1.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings1.Join(ss, ",") + "}"
	return s
}
func (this *FrameworkID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		return fmt3.Errorf("that is not of type *FrameworkID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *FrameworkID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *FrameworkIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *FrameworkID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *OfferID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*OfferID)
	if !ok {
		return fmt3.Errorf("that is not of type *OfferID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *OfferID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *OfferIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *OfferID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*OfferID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SlaveID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*SlaveID)
	if !ok {
		return fmt3.Errorf("that is not of type *SlaveID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *SlaveID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *SlaveIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *SlaveID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SlaveID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskID)
	if !ok {
		return fmt3.Errorf("that is not of type *TaskID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *TaskID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *TaskIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ExecutorID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		return fmt3.Errorf("that is not of type *ExecutorID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ExecutorID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ExecutorIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ExecutorID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		return fmt3.Errorf("that is not of type *ContainerID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ContainerID but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ContainerIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *FrameworkInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *FrameworkInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *FrameworkInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *FrameworkInfobut is not nil && this == nil")
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt3.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt3.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt3.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.Id.Equal(that1.Id) {
		return fmt3.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return fmt3.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", *this.FailoverTimeout, *that1.FailoverTimeout)
		}
	} else if this.FailoverTimeout != nil {
		return fmt3.Errorf("this.FailoverTimeout == nil && that.FailoverTimeout != nil")
	} else if that1.FailoverTimeout != nil {
		return fmt3.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", this.FailoverTimeout, that1.FailoverTimeout)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt3.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt3.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt3.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt3.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt3.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt3.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt3.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt3.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.WebuiUrl != nil && that1.WebuiUrl != nil {
		if *this.WebuiUrl != *that1.WebuiUrl {
			return fmt3.Errorf("WebuiUrl this(%v) Not Equal that(%v)", *this.WebuiUrl, *that1.WebuiUrl)
		}
	} else if this.WebuiUrl != nil {
		return fmt3.Errorf("this.WebuiUrl == nil && that.WebuiUrl != nil")
	} else if that1.WebuiUrl != nil {
		return fmt3.Errorf("WebuiUrl this(%v) Not Equal that(%v)", this.WebuiUrl, that1.WebuiUrl)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *FrameworkInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return false
		}
	} else if this.FailoverTimeout != nil {
		return false
	} else if that1.FailoverTimeout != nil {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.WebuiUrl != nil && that1.WebuiUrl != nil {
		if *this.WebuiUrl != *that1.WebuiUrl {
			return false
		}
	} else if this.WebuiUrl != nil {
		return false
	} else if that1.WebuiUrl != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		return fmt3.Errorf("that is not of type *HealthCheck")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *HealthCheck but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *HealthCheckbut is not nil && this == nil")
	}
	if !this.Http.Equal(that1.Http) {
		return fmt3.Errorf("Http this(%v) Not Equal that(%v)", this.Http, that1.Http)
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return fmt3.Errorf("DelaySeconds this(%v) Not Equal that(%v)", *this.DelaySeconds, *that1.DelaySeconds)
		}
	} else if this.DelaySeconds != nil {
		return fmt3.Errorf("this.DelaySeconds == nil && that.DelaySeconds != nil")
	} else if that1.DelaySeconds != nil {
		return fmt3.Errorf("DelaySeconds this(%v) Not Equal that(%v)", this.DelaySeconds, that1.DelaySeconds)
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return fmt3.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", *this.IntervalSeconds, *that1.IntervalSeconds)
		}
	} else if this.IntervalSeconds != nil {
		return fmt3.Errorf("this.IntervalSeconds == nil && that.IntervalSeconds != nil")
	} else if that1.IntervalSeconds != nil {
		return fmt3.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", this.IntervalSeconds, that1.IntervalSeconds)
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return fmt3.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", *this.TimeoutSeconds, *that1.TimeoutSeconds)
		}
	} else if this.TimeoutSeconds != nil {
		return fmt3.Errorf("this.TimeoutSeconds == nil && that.TimeoutSeconds != nil")
	} else if that1.TimeoutSeconds != nil {
		return fmt3.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", this.TimeoutSeconds, that1.TimeoutSeconds)
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return fmt3.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", *this.ConsecutiveFailures, *that1.ConsecutiveFailures)
		}
	} else if this.ConsecutiveFailures != nil {
		return fmt3.Errorf("this.ConsecutiveFailures == nil && that.ConsecutiveFailures != nil")
	} else if that1.ConsecutiveFailures != nil {
		return fmt3.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", this.ConsecutiveFailures, that1.ConsecutiveFailures)
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return fmt3.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", *this.GracePeriodSeconds, *that1.GracePeriodSeconds)
		}
	} else if this.GracePeriodSeconds != nil {
		return fmt3.Errorf("this.GracePeriodSeconds == nil && that.GracePeriodSeconds != nil")
	} else if that1.GracePeriodSeconds != nil {
		return fmt3.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", this.GracePeriodSeconds, that1.GracePeriodSeconds)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt3.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *HealthCheck) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Http.Equal(that1.Http) {
		return false
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return false
		}
	} else if this.DelaySeconds != nil {
		return false
	} else if that1.DelaySeconds != nil {
		return false
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return false
		}
	} else if this.IntervalSeconds != nil {
		return false
	} else if that1.IntervalSeconds != nil {
		return false
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return false
		}
	} else if this.TimeoutSeconds != nil {
		return false
	} else if that1.TimeoutSeconds != nil {
		return false
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return false
		}
	} else if this.ConsecutiveFailures != nil {
		return false
	} else if that1.ConsecutiveFailures != nil {
		return false
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return false
		}
	} else if this.GracePeriodSeconds != nil {
		return false
	} else if that1.GracePeriodSeconds != nil {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_HTTP) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck_HTTP)
	if !ok {
		return fmt3.Errorf("that is not of type *HealthCheck_HTTP")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *HealthCheck_HTTP but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *HealthCheck_HTTPbut is not nil && this == nil")
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt3.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt3.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt3.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt3.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt3.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt3.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return fmt3.Errorf("Statuses this(%v) Not Equal that(%v)", len(this.Statuses), len(that1.Statuses))
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return fmt3.Errorf("Statuses this[%v](%v) Not Equal that[%v](%v)", i, this.Statuses[i], i, that1.Statuses[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *HealthCheck_HTTP) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck_HTTP)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return false
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *CommandInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *CommandInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *CommandInfobut is not nil && this == nil")
	}
	if !this.Container.Equal(that1.Container) {
		return fmt3.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if len(this.Uris) != len(that1.Uris) {
		return fmt3.Errorf("Uris this(%v) Not Equal that(%v)", len(this.Uris), len(that1.Uris))
	}
	for i := range this.Uris {
		if !this.Uris[i].Equal(that1.Uris[i]) {
			return fmt3.Errorf("Uris this[%v](%v) Not Equal that[%v](%v)", i, this.Uris[i], i, that1.Uris[i])
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return fmt3.Errorf("Environment this(%v) Not Equal that(%v)", this.Environment, that1.Environment)
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return fmt3.Errorf("Shell this(%v) Not Equal that(%v)", *this.Shell, *that1.Shell)
		}
	} else if this.Shell != nil {
		return fmt3.Errorf("this.Shell == nil && that.Shell != nil")
	} else if that1.Shell != nil {
		return fmt3.Errorf("Shell this(%v) Not Equal that(%v)", this.Shell, that1.Shell)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return fmt3.Errorf("Arguments this(%v) Not Equal that(%v)", len(this.Arguments), len(that1.Arguments))
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return fmt3.Errorf("Arguments this[%v](%v) Not Equal that[%v](%v)", i, this.Arguments[i], i, that1.Arguments[i])
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt3.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt3.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt3.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if len(this.Uris) != len(that1.Uris) {
		return false
	}
	for i := range this.Uris {
		if !this.Uris[i].Equal(that1.Uris[i]) {
			return false
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return false
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return false
		}
	} else if this.Shell != nil {
		return false
	} else if that1.Shell != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return false
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return false
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo_URI) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		return fmt3.Errorf("that is not of type *CommandInfo_URI")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *CommandInfo_URI but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *CommandInfo_URIbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return fmt3.Errorf("Executable this(%v) Not Equal that(%v)", *this.Executable, *that1.Executable)
		}
	} else if this.Executable != nil {
		return fmt3.Errorf("this.Executable == nil && that.Executable != nil")
	} else if that1.Executable != nil {
		return fmt3.Errorf("Executable this(%v) Not Equal that(%v)", this.Executable, that1.Executable)
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return fmt3.Errorf("Extract this(%v) Not Equal that(%v)", *this.Extract, *that1.Extract)
		}
	} else if this.Extract != nil {
		return fmt3.Errorf("this.Extract == nil && that.Extract != nil")
	} else if that1.Extract != nil {
		return fmt3.Errorf("Extract this(%v) Not Equal that(%v)", this.Extract, that1.Extract)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo_URI) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return false
		}
	} else if this.Executable != nil {
		return false
	} else if that1.Executable != nil {
		return false
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return false
		}
	} else if this.Extract != nil {
		return false
	} else if that1.Extract != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo_ContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo_ContainerInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *CommandInfo_ContainerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *CommandInfo_ContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *CommandInfo_ContainerInfobut is not nil && this == nil")
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return fmt3.Errorf("Image this(%v) Not Equal that(%v)", *this.Image, *that1.Image)
		}
	} else if this.Image != nil {
		return fmt3.Errorf("this.Image == nil && that.Image != nil")
	} else if that1.Image != nil {
		return fmt3.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if len(this.Options) != len(that1.Options) {
		return fmt3.Errorf("Options this(%v) Not Equal that(%v)", len(this.Options), len(that1.Options))
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return fmt3.Errorf("Options this[%v](%v) Not Equal that[%v](%v)", i, this.Options[i], i, that1.Options[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo_ContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo_ContainerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return false
		}
	} else if this.Image != nil {
		return false
	} else if that1.Image != nil {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ExecutorInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *ExecutorInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ExecutorInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ExecutorInfobut is not nil && this == nil")
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return fmt3.Errorf("ExecutorId this(%v) Not Equal that(%v)", this.ExecutorId, that1.ExecutorId)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt3.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt3.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt3.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt3.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt3.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt3.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt3.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt3.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt3.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ExecutorInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MasterInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *MasterInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *MasterInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *MasterInfobut is not nil && this == nil")
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return fmt3.Errorf("Id this(%v) Not Equal that(%v)", *this.Id, *that1.Id)
		}
	} else if this.Id != nil {
		return fmt3.Errorf("this.Id == nil && that.Id != nil")
	} else if that1.Id != nil {
		return fmt3.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return fmt3.Errorf("Ip this(%v) Not Equal that(%v)", *this.Ip, *that1.Ip)
		}
	} else if this.Ip != nil {
		return fmt3.Errorf("this.Ip == nil && that.Ip != nil")
	} else if that1.Ip != nil {
		return fmt3.Errorf("Ip this(%v) Not Equal that(%v)", this.Ip, that1.Ip)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt3.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt3.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt3.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Pid != nil && that1.Pid != nil {
		if *this.Pid != *that1.Pid {
			return fmt3.Errorf("Pid this(%v) Not Equal that(%v)", *this.Pid, *that1.Pid)
		}
	} else if this.Pid != nil {
		return fmt3.Errorf("this.Pid == nil && that.Pid != nil")
	} else if that1.Pid != nil {
		return fmt3.Errorf("Pid this(%v) Not Equal that(%v)", this.Pid, that1.Pid)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt3.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *MasterInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return false
		}
	} else if this.Id != nil {
		return false
	} else if that1.Id != nil {
		return false
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return false
		}
	} else if this.Ip != nil {
		return false
	} else if that1.Ip != nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if this.Pid != nil && that1.Pid != nil {
		if *this.Pid != *that1.Pid {
			return false
		}
	} else if this.Pid != nil {
		return false
	} else if that1.Pid != nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SlaveInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*SlaveInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *SlaveInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *SlaveInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *SlaveInfobut is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt3.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt3.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt3.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt3.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt3.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt3.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt3.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return fmt3.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if !this.Id.Equal(that1.Id) {
		return fmt3.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt3.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt3.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt3.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *SlaveInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SlaveInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value)
	if !ok {
		return fmt3.Errorf("that is not of type *Value")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Valuebut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt3.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt3.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt3.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt3.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt3.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt3.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt3.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Scalar) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		return fmt3.Errorf("that is not of type *Value_Scalar")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value_Scalar but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Value_Scalarbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Scalar) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Range) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		return fmt3.Errorf("that is not of type *Value_Range")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value_Range but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Value_Rangebut is not nil && this == nil")
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return fmt3.Errorf("Begin this(%v) Not Equal that(%v)", *this.Begin, *that1.Begin)
		}
	} else if this.Begin != nil {
		return fmt3.Errorf("this.Begin == nil && that.Begin != nil")
	} else if that1.Begin != nil {
		return fmt3.Errorf("Begin this(%v) Not Equal that(%v)", this.Begin, that1.Begin)
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return fmt3.Errorf("End this(%v) Not Equal that(%v)", *this.End, *that1.End)
		}
	} else if this.End != nil {
		return fmt3.Errorf("this.End == nil && that.End != nil")
	} else if that1.End != nil {
		return fmt3.Errorf("End this(%v) Not Equal that(%v)", this.End, that1.End)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Range) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return false
		}
	} else if this.Begin != nil {
		return false
	} else if that1.Begin != nil {
		return false
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return false
		}
	} else if this.End != nil {
		return false
	} else if that1.End != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Ranges) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		return fmt3.Errorf("that is not of type *Value_Ranges")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value_Ranges but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Value_Rangesbut is not nil && this == nil")
	}
	if len(this.Range) != len(that1.Range) {
		return fmt3.Errorf("Range this(%v) Not Equal that(%v)", len(this.Range), len(that1.Range))
	}
	for i := range this.Range {
		if !this.Range[i].Equal(that1.Range[i]) {
			return fmt3.Errorf("Range this[%v](%v) Not Equal that[%v](%v)", i, this.Range[i], i, that1.Range[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Ranges) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Range) != len(that1.Range) {
		return false
	}
	for i := range this.Range {
		if !this.Range[i].Equal(that1.Range[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Set) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		return fmt3.Errorf("that is not of type *Value_Set")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value_Set but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Value_Setbut is not nil && this == nil")
	}
	if len(this.Item) != len(that1.Item) {
		return fmt3.Errorf("Item this(%v) Not Equal that(%v)", len(this.Item), len(that1.Item))
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return fmt3.Errorf("Item this[%v](%v) Not Equal that[%v](%v)", i, this.Item[i], i, that1.Item[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Set) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Item) != len(that1.Item) {
		return false
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Text) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		return fmt3.Errorf("that is not of type *Value_Text")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Value_Text but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Value_Textbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Text) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Attribute) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Attribute)
	if !ok {
		return fmt3.Errorf("that is not of type *Attribute")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Attribute but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Attributebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt3.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt3.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt3.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt3.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt3.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt3.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt3.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Attribute) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Attribute)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource)
	if !ok {
		return fmt3.Errorf("that is not of type *Resource")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Resource but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Resourcebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt3.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt3.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt3.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt3.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt3.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt3.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt3.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt3.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt3.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ResourceStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		return fmt3.Errorf("that is not of type *ResourceStatistics")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ResourceStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ResourceStatisticsbut is not nil && this == nil")
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt3.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.CpusUserTimeSecs != nil && that1.CpusUserTimeSecs != nil {
		if *this.CpusUserTimeSecs != *that1.CpusUserTimeSecs {
			return fmt3.Errorf("CpusUserTimeSecs this(%v) Not Equal that(%v)", *this.CpusUserTimeSecs, *that1.CpusUserTimeSecs)
		}
	} else if this.CpusUserTimeSecs != nil {
		return fmt3.Errorf("this.CpusUserTimeSecs == nil && that.CpusUserTimeSecs != nil")
	} else if that1.CpusUserTimeSecs != nil {
		return fmt3.Errorf("CpusUserTimeSecs this(%v) Not Equal that(%v)", this.CpusUserTimeSecs, that1.CpusUserTimeSecs)
	}
	if this.CpusSystemTimeSecs != nil && that1.CpusSystemTimeSecs != nil {
		if *this.CpusSystemTimeSecs != *that1.CpusSystemTimeSecs {
			return fmt3.Errorf("CpusSystemTimeSecs this(%v) Not Equal that(%v)", *this.CpusSystemTimeSecs, *that1.CpusSystemTimeSecs)
		}
	} else if this.CpusSystemTimeSecs != nil {
		return fmt3.Errorf("this.CpusSystemTimeSecs == nil && that.CpusSystemTimeSecs != nil")
	} else if that1.CpusSystemTimeSecs != nil {
		return fmt3.Errorf("CpusSystemTimeSecs this(%v) Not Equal that(%v)", this.CpusSystemTimeSecs, that1.CpusSystemTimeSecs)
	}
	if this.CpusLimit != nil && that1.CpusLimit != nil {
		if *this.CpusLimit != *that1.CpusLimit {
			return fmt3.Errorf("CpusLimit this(%v) Not Equal that(%v)", *this.CpusLimit, *that1.CpusLimit)
		}
	} else if this.CpusLimit != nil {
		return fmt3.Errorf("this.CpusLimit == nil && that.CpusLimit != nil")
	} else if that1.CpusLimit != nil {
		return fmt3.Errorf("CpusLimit this(%v) Not Equal that(%v)", this.CpusLimit, that1.CpusLimit)
	}
	if this.CpusNrPeriods != nil && that1.CpusNrPeriods != nil {
		if *this.CpusNrPeriods != *that1.CpusNrPeriods {
			return fmt3.Errorf("CpusNrPeriods this(%v) Not Equal that(%v)", *this.CpusNrPeriods, *that1.CpusNrPeriods)
		}
	} else if this.CpusNrPeriods != nil {
		return fmt3.Errorf("this.CpusNrPeriods == nil && that.CpusNrPeriods != nil")
	} else if that1.CpusNrPeriods != nil {
		return fmt3.Errorf("CpusNrPeriods this(%v) Not Equal that(%v)", this.CpusNrPeriods, that1.CpusNrPeriods)
	}
	if this.CpusNrThrottled != nil && that1.CpusNrThrottled != nil {
		if *this.CpusNrThrottled != *that1.CpusNrThrottled {
			return fmt3.Errorf("CpusNrThrottled this(%v) Not Equal that(%v)", *this.CpusNrThrottled, *that1.CpusNrThrottled)
		}
	} else if this.CpusNrThrottled != nil {
		return fmt3.Errorf("this.CpusNrThrottled == nil && that.CpusNrThrottled != nil")
	} else if that1.CpusNrThrottled != nil {
		return fmt3.Errorf("CpusNrThrottled this(%v) Not Equal that(%v)", this.CpusNrThrottled, that1.CpusNrThrottled)
	}
	if this.CpusThrottledTimeSecs != nil && that1.CpusThrottledTimeSecs != nil {
		if *this.CpusThrottledTimeSecs != *that1.CpusThrottledTimeSecs {
			return fmt3.Errorf("CpusThrottledTimeSecs this(%v) Not Equal that(%v)", *this.CpusThrottledTimeSecs, *that1.CpusThrottledTimeSecs)
		}
	} else if this.CpusThrottledTimeSecs != nil {
		return fmt3.Errorf("this.CpusThrottledTimeSecs == nil && that.CpusThrottledTimeSecs != nil")
	} else if that1.CpusThrottledTimeSecs != nil {
		return fmt3.Errorf("CpusThrottledTimeSecs this(%v) Not Equal that(%v)", this.CpusThrottledTimeSecs, that1.CpusThrottledTimeSecs)
	}
	if this.MemRssBytes != nil && that1.MemRssBytes != nil {
		if *this.MemRssBytes != *that1.MemRssBytes {
			return fmt3.Errorf("MemRssBytes this(%v) Not Equal that(%v)", *this.MemRssBytes, *that1.MemRssBytes)
		}
	} else if this.MemRssBytes != nil {
		return fmt3.Errorf("this.MemRssBytes == nil && that.MemRssBytes != nil")
	} else if that1.MemRssBytes != nil {
		return fmt3.Errorf("MemRssBytes this(%v) Not Equal that(%v)", this.MemRssBytes, that1.MemRssBytes)
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return fmt3.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", *this.MemLimitBytes, *that1.MemLimitBytes)
		}
	} else if this.MemLimitBytes != nil {
		return fmt3.Errorf("this.MemLimitBytes == nil && that.MemLimitBytes != nil")
	} else if that1.MemLimitBytes != nil {
		return fmt3.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", this.MemLimitBytes, that1.MemLimitBytes)
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return fmt3.Errorf("MemFileBytes this(%v) Not Equal that(%v)", *this.MemFileBytes, *that1.MemFileBytes)
		}
	} else if this.MemFileBytes != nil {
		return fmt3.Errorf("this.MemFileBytes == nil && that.MemFileBytes != nil")
	} else if that1.MemFileBytes != nil {
		return fmt3.Errorf("MemFileBytes this(%v) Not Equal that(%v)", this.MemFileBytes, that1.MemFileBytes)
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return fmt3.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", *this.MemAnonBytes, *that1.MemAnonBytes)
		}
	} else if this.MemAnonBytes != nil {
		return fmt3.Errorf("this.MemAnonBytes == nil && that.MemAnonBytes != nil")
	} else if that1.MemAnonBytes != nil {
		return fmt3.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", this.MemAnonBytes, that1.MemAnonBytes)
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return fmt3.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", *this.MemMappedFileBytes, *that1.MemMappedFileBytes)
		}
	} else if this.MemMappedFileBytes != nil {
		return fmt3.Errorf("this.MemMappedFileBytes == nil && that.MemMappedFileBytes != nil")
	} else if that1.MemMappedFileBytes != nil {
		return fmt3.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", this.MemMappedFileBytes, that1.MemMappedFileBytes)
	}
	if !this.Perf.Equal(that1.Perf) {
		return fmt3.Errorf("Perf this(%v) Not Equal that(%v)", this.Perf, that1.Perf)
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return fmt3.Errorf("NetRxPackets this(%v) Not Equal that(%v)", *this.NetRxPackets, *that1.NetRxPackets)
		}
	} else if this.NetRxPackets != nil {
		return fmt3.Errorf("this.NetRxPackets == nil && that.NetRxPackets != nil")
	} else if that1.NetRxPackets != nil {
		return fmt3.Errorf("NetRxPackets this(%v) Not Equal that(%v)", this.NetRxPackets, that1.NetRxPackets)
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return fmt3.Errorf("NetRxBytes this(%v) Not Equal that(%v)", *this.NetRxBytes, *that1.NetRxBytes)
		}
	} else if this.NetRxBytes != nil {
		return fmt3.Errorf("this.NetRxBytes == nil && that.NetRxBytes != nil")
	} else if that1.NetRxBytes != nil {
		return fmt3.Errorf("NetRxBytes this(%v) Not Equal that(%v)", this.NetRxBytes, that1.NetRxBytes)
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return fmt3.Errorf("NetRxErrors this(%v) Not Equal that(%v)", *this.NetRxErrors, *that1.NetRxErrors)
		}
	} else if this.NetRxErrors != nil {
		return fmt3.Errorf("this.NetRxErrors == nil && that.NetRxErrors != nil")
	} else if that1.NetRxErrors != nil {
		return fmt3.Errorf("NetRxErrors this(%v) Not Equal that(%v)", this.NetRxErrors, that1.NetRxErrors)
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return fmt3.Errorf("NetRxDropped this(%v) Not Equal that(%v)", *this.NetRxDropped, *that1.NetRxDropped)
		}
	} else if this.NetRxDropped != nil {
		return fmt3.Errorf("this.NetRxDropped == nil && that.NetRxDropped != nil")
	} else if that1.NetRxDropped != nil {
		return fmt3.Errorf("NetRxDropped this(%v) Not Equal that(%v)", this.NetRxDropped, that1.NetRxDropped)
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return fmt3.Errorf("NetTxPackets this(%v) Not Equal that(%v)", *this.NetTxPackets, *that1.NetTxPackets)
		}
	} else if this.NetTxPackets != nil {
		return fmt3.Errorf("this.NetTxPackets == nil && that.NetTxPackets != nil")
	} else if that1.NetTxPackets != nil {
		return fmt3.Errorf("NetTxPackets this(%v) Not Equal that(%v)", this.NetTxPackets, that1.NetTxPackets)
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return fmt3.Errorf("NetTxBytes this(%v) Not Equal that(%v)", *this.NetTxBytes, *that1.NetTxBytes)
		}
	} else if this.NetTxBytes != nil {
		return fmt3.Errorf("this.NetTxBytes == nil && that.NetTxBytes != nil")
	} else if that1.NetTxBytes != nil {
		return fmt3.Errorf("NetTxBytes this(%v) Not Equal that(%v)", this.NetTxBytes, that1.NetTxBytes)
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return fmt3.Errorf("NetTxErrors this(%v) Not Equal that(%v)", *this.NetTxErrors, *that1.NetTxErrors)
		}
	} else if this.NetTxErrors != nil {
		return fmt3.Errorf("this.NetTxErrors == nil && that.NetTxErrors != nil")
	} else if that1.NetTxErrors != nil {
		return fmt3.Errorf("NetTxErrors this(%v) Not Equal that(%v)", this.NetTxErrors, that1.NetTxErrors)
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return fmt3.Errorf("NetTxDropped this(%v) Not Equal that(%v)", *this.NetTxDropped, *that1.NetTxDropped)
		}
	} else if this.NetTxDropped != nil {
		return fmt3.Errorf("this.NetTxDropped == nil && that.NetTxDropped != nil")
	} else if that1.NetTxDropped != nil {
		return fmt3.Errorf("NetTxDropped this(%v) Not Equal that(%v)", this.NetTxDropped, that1.NetTxDropped)
	}
	if this.NetTcpRttMicrosecsP50 != nil && that1.NetTcpRttMicrosecsP50 != nil {
		if *this.NetTcpRttMicrosecsP50 != *that1.NetTcpRttMicrosecsP50 {
			return fmt3.Errorf("NetTcpRttMicrosecsP50 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP50, *that1.NetTcpRttMicrosecsP50)
		}
	} else if this.NetTcpRttMicrosecsP50 != nil {
		return fmt3.Errorf("this.NetTcpRttMicrosecsP50 == nil && that.NetTcpRttMicrosecsP50 != nil")
	} else if that1.NetTcpRttMicrosecsP50 != nil {
		return fmt3.Errorf("NetTcpRttMicrosecsP50 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP50, that1.NetTcpRttMicrosecsP50)
	}
	if this.NetTcpRttMicrosecsP90 != nil && that1.NetTcpRttMicrosecsP90 != nil {
		if *this.NetTcpRttMicrosecsP90 != *that1.NetTcpRttMicrosecsP90 {
			return fmt3.Errorf("NetTcpRttMicrosecsP90 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP90, *that1.NetTcpRttMicrosecsP90)
		}
	} else if this.NetTcpRttMicrosecsP90 != nil {
		return fmt3.Errorf("this.NetTcpRttMicrosecsP90 == nil && that.NetTcpRttMicrosecsP90 != nil")
	} else if that1.NetTcpRttMicrosecsP90 != nil {
		return fmt3.Errorf("NetTcpRttMicrosecsP90 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP90, that1.NetTcpRttMicrosecsP90)
	}
	if this.NetTcpRttMicrosecsP95 != nil && that1.NetTcpRttMicrosecsP95 != nil {
		if *this.NetTcpRttMicrosecsP95 != *that1.NetTcpRttMicrosecsP95 {
			return fmt3.Errorf("NetTcpRttMicrosecsP95 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP95, *that1.NetTcpRttMicrosecsP95)
		}
	} else if this.NetTcpRttMicrosecsP95 != nil {
		return fmt3.Errorf("this.NetTcpRttMicrosecsP95 == nil && that.NetTcpRttMicrosecsP95 != nil")
	} else if that1.NetTcpRttMicrosecsP95 != nil {
		return fmt3.Errorf("NetTcpRttMicrosecsP95 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP95, that1.NetTcpRttMicrosecsP95)
	}
	if this.NetTcpRttMicrosecsP99 != nil && that1.NetTcpRttMicrosecsP99 != nil {
		if *this.NetTcpRttMicrosecsP99 != *that1.NetTcpRttMicrosecsP99 {
			return fmt3.Errorf("NetTcpRttMicrosecsP99 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP99, *that1.NetTcpRttMicrosecsP99)
		}
	} else if this.NetTcpRttMicrosecsP99 != nil {
		return fmt3.Errorf("this.NetTcpRttMicrosecsP99 == nil && that.NetTcpRttMicrosecsP99 != nil")
	} else if that1.NetTcpRttMicrosecsP99 != nil {
		return fmt3.Errorf("NetTcpRttMicrosecsP99 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP99, that1.NetTcpRttMicrosecsP99)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ResourceStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if this.CpusUserTimeSecs != nil && that1.CpusUserTimeSecs != nil {
		if *this.CpusUserTimeSecs != *that1.CpusUserTimeSecs {
			return false
		}
	} else if this.CpusUserTimeSecs != nil {
		return false
	} else if that1.CpusUserTimeSecs != nil {
		return false
	}
	if this.CpusSystemTimeSecs != nil && that1.CpusSystemTimeSecs != nil {
		if *this.CpusSystemTimeSecs != *that1.CpusSystemTimeSecs {
			return false
		}
	} else if this.CpusSystemTimeSecs != nil {
		return false
	} else if that1.CpusSystemTimeSecs != nil {
		return false
	}
	if this.CpusLimit != nil && that1.CpusLimit != nil {
		if *this.CpusLimit != *that1.CpusLimit {
			return false
		}
	} else if this.CpusLimit != nil {
		return false
	} else if that1.CpusLimit != nil {
		return false
	}
	if this.CpusNrPeriods != nil && that1.CpusNrPeriods != nil {
		if *this.CpusNrPeriods != *that1.CpusNrPeriods {
			return false
		}
	} else if this.CpusNrPeriods != nil {
		return false
	} else if that1.CpusNrPeriods != nil {
		return false
	}
	if this.CpusNrThrottled != nil && that1.CpusNrThrottled != nil {
		if *this.CpusNrThrottled != *that1.CpusNrThrottled {
			return false
		}
	} else if this.CpusNrThrottled != nil {
		return false
	} else if that1.CpusNrThrottled != nil {
		return false
	}
	if this.CpusThrottledTimeSecs != nil && that1.CpusThrottledTimeSecs != nil {
		if *this.CpusThrottledTimeSecs != *that1.CpusThrottledTimeSecs {
			return false
		}
	} else if this.CpusThrottledTimeSecs != nil {
		return false
	} else if that1.CpusThrottledTimeSecs != nil {
		return false
	}
	if this.MemRssBytes != nil && that1.MemRssBytes != nil {
		if *this.MemRssBytes != *that1.MemRssBytes {
			return false
		}
	} else if this.MemRssBytes != nil {
		return false
	} else if that1.MemRssBytes != nil {
		return false
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return false
		}
	} else if this.MemLimitBytes != nil {
		return false
	} else if that1.MemLimitBytes != nil {
		return false
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return false
		}
	} else if this.MemFileBytes != nil {
		return false
	} else if that1.MemFileBytes != nil {
		return false
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return false
		}
	} else if this.MemAnonBytes != nil {
		return false
	} else if that1.MemAnonBytes != nil {
		return false
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return false
		}
	} else if this.MemMappedFileBytes != nil {
		return false
	} else if that1.MemMappedFileBytes != nil {
		return false
	}
	if !this.Perf.Equal(that1.Perf) {
		return false
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return false
		}
	} else if this.NetRxPackets != nil {
		return false
	} else if that1.NetRxPackets != nil {
		return false
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return false
		}
	} else if this.NetRxBytes != nil {
		return false
	} else if that1.NetRxBytes != nil {
		return false
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return false
		}
	} else if this.NetRxErrors != nil {
		return false
	} else if that1.NetRxErrors != nil {
		return false
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return false
		}
	} else if this.NetRxDropped != nil {
		return false
	} else if that1.NetRxDropped != nil {
		return false
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return false
		}
	} else if this.NetTxPackets != nil {
		return false
	} else if that1.NetTxPackets != nil {
		return false
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return false
		}
	} else if this.NetTxBytes != nil {
		return false
	} else if that1.NetTxBytes != nil {
		return false
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return false
		}
	} else if this.NetTxErrors != nil {
		return false
	} else if that1.NetTxErrors != nil {
		return false
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return false
		}
	} else if this.NetTxDropped != nil {
		return false
	} else if that1.NetTxDropped != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP50 != nil && that1.NetTcpRttMicrosecsP50 != nil {
		if *this.NetTcpRttMicrosecsP50 != *that1.NetTcpRttMicrosecsP50 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP50 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP50 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP90 != nil && that1.NetTcpRttMicrosecsP90 != nil {
		if *this.NetTcpRttMicrosecsP90 != *that1.NetTcpRttMicrosecsP90 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP90 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP90 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP95 != nil && that1.NetTcpRttMicrosecsP95 != nil {
		if *this.NetTcpRttMicrosecsP95 != *that1.NetTcpRttMicrosecsP95 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP95 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP95 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP99 != nil && that1.NetTcpRttMicrosecsP99 != nil {
		if *this.NetTcpRttMicrosecsP99 != *that1.NetTcpRttMicrosecsP99 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP99 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP99 != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ResourceUsage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		return fmt3.Errorf("that is not of type *ResourceUsage")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ResourceUsage but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ResourceUsagebut is not nil && this == nil")
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt3.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt3.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return fmt3.Errorf("ExecutorId this(%v) Not Equal that(%v)", this.ExecutorId, that1.ExecutorId)
	}
	if this.ExecutorName != nil && that1.ExecutorName != nil {
		if *this.ExecutorName != *that1.ExecutorName {
			return fmt3.Errorf("ExecutorName this(%v) Not Equal that(%v)", *this.ExecutorName, *that1.ExecutorName)
		}
	} else if this.ExecutorName != nil {
		return fmt3.Errorf("this.ExecutorName == nil && that.ExecutorName != nil")
	} else if that1.ExecutorName != nil {
		return fmt3.Errorf("ExecutorName this(%v) Not Equal that(%v)", this.ExecutorName, that1.ExecutorName)
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return fmt3.Errorf("TaskId this(%v) Not Equal that(%v)", this.TaskId, that1.TaskId)
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return fmt3.Errorf("Statistics this(%v) Not Equal that(%v)", this.Statistics, that1.Statistics)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ResourceUsage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return false
	}
	if this.ExecutorName != nil && that1.ExecutorName != nil {
		if *this.ExecutorName != *that1.ExecutorName {
			return false
		}
	} else if this.ExecutorName != nil {
		return false
	} else if that1.ExecutorName != nil {
		return false
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return false
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PerfStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		return fmt3.Errorf("that is not of type *PerfStatistics")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *PerfStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *PerfStatisticsbut is not nil && this == nil")
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt3.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Duration != nil && that1.Duration != nil {
		if *this.Duration != *that1.Duration {
			return fmt3.Errorf("Duration this(%v) Not Equal that(%v)", *this.Duration, *that1.Duration)
		}
	} else if this.Duration != nil {
		return fmt3.Errorf("this.Duration == nil && that.Duration != nil")
	} else if that1.Duration != nil {
		return fmt3.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return fmt3.Errorf("Cycles this(%v) Not Equal that(%v)", *this.Cycles, *that1.Cycles)
		}
	} else if this.Cycles != nil {
		return fmt3.Errorf("this.Cycles == nil && that.Cycles != nil")
	} else if that1.Cycles != nil {
		return fmt3.Errorf("Cycles this(%v) Not Equal that(%v)", this.Cycles, that1.Cycles)
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return fmt3.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", *this.StalledCyclesFrontend, *that1.StalledCyclesFrontend)
		}
	} else if this.StalledCyclesFrontend != nil {
		return fmt3.Errorf("this.StalledCyclesFrontend == nil && that.StalledCyclesFrontend != nil")
	} else if that1.StalledCyclesFrontend != nil {
		return fmt3.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", this.StalledCyclesFrontend, that1.StalledCyclesFrontend)
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return fmt3.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", *this.StalledCyclesBackend, *that1.StalledCyclesBackend)
		}
	} else if this.StalledCyclesBackend != nil {
		return fmt3.Errorf("this.StalledCyclesBackend == nil && that.StalledCyclesBackend != nil")
	} else if that1.StalledCyclesBackend != nil {
		return fmt3.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", this.StalledCyclesBackend, that1.StalledCyclesBackend)
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return fmt3.Errorf("Instructions this(%v) Not Equal that(%v)", *this.Instructions, *that1.Instructions)
		}
	} else if this.Instructions != nil {
		return fmt3.Errorf("this.Instructions == nil && that.Instructions != nil")
	} else if that1.Instructions != nil {
		return fmt3.Errorf("Instructions this(%v) Not Equal that(%v)", this.Instructions, that1.Instructions)
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return fmt3.Errorf("CacheReferences this(%v) Not Equal that(%v)", *this.CacheReferences, *that1.CacheReferences)
		}
	} else if this.CacheReferences != nil {
		return fmt3.Errorf("this.CacheReferences == nil && that.CacheReferences != nil")
	} else if that1.CacheReferences != nil {
		return fmt3.Errorf("CacheReferences this(%v) Not Equal that(%v)", this.CacheReferences, that1.CacheReferences)
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return fmt3.Errorf("CacheMisses this(%v) Not Equal that(%v)", *this.CacheMisses, *that1.CacheMisses)
		}
	} else if this.CacheMisses != nil {
		return fmt3.Errorf("this.CacheMisses == nil && that.CacheMisses != nil")
	} else if that1.CacheMisses != nil {
		return fmt3.Errorf("CacheMisses this(%v) Not Equal that(%v)", this.CacheMisses, that1.CacheMisses)
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return fmt3.Errorf("Branches this(%v) Not Equal that(%v)", *this.Branches, *that1.Branches)
		}
	} else if this.Branches != nil {
		return fmt3.Errorf("this.Branches == nil && that.Branches != nil")
	} else if that1.Branches != nil {
		return fmt3.Errorf("Branches this(%v) Not Equal that(%v)", this.Branches, that1.Branches)
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return fmt3.Errorf("BranchMisses this(%v) Not Equal that(%v)", *this.BranchMisses, *that1.BranchMisses)
		}
	} else if this.BranchMisses != nil {
		return fmt3.Errorf("this.BranchMisses == nil && that.BranchMisses != nil")
	} else if that1.BranchMisses != nil {
		return fmt3.Errorf("BranchMisses this(%v) Not Equal that(%v)", this.BranchMisses, that1.BranchMisses)
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return fmt3.Errorf("BusCycles this(%v) Not Equal that(%v)", *this.BusCycles, *that1.BusCycles)
		}
	} else if this.BusCycles != nil {
		return fmt3.Errorf("this.BusCycles == nil && that.BusCycles != nil")
	} else if that1.BusCycles != nil {
		return fmt3.Errorf("BusCycles this(%v) Not Equal that(%v)", this.BusCycles, that1.BusCycles)
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return fmt3.Errorf("RefCycles this(%v) Not Equal that(%v)", *this.RefCycles, *that1.RefCycles)
		}
	} else if this.RefCycles != nil {
		return fmt3.Errorf("this.RefCycles == nil && that.RefCycles != nil")
	} else if that1.RefCycles != nil {
		return fmt3.Errorf("RefCycles this(%v) Not Equal that(%v)", this.RefCycles, that1.RefCycles)
	}
	if this.CpuClock != nil && that1.CpuClock != nil {
		if *this.CpuClock != *that1.CpuClock {
			return fmt3.Errorf("CpuClock this(%v) Not Equal that(%v)", *this.CpuClock, *that1.CpuClock)
		}
	} else if this.CpuClock != nil {
		return fmt3.Errorf("this.CpuClock == nil && that.CpuClock != nil")
	} else if that1.CpuClock != nil {
		return fmt3.Errorf("CpuClock this(%v) Not Equal that(%v)", this.CpuClock, that1.CpuClock)
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return fmt3.Errorf("TaskClock this(%v) Not Equal that(%v)", *this.TaskClock, *that1.TaskClock)
		}
	} else if this.TaskClock != nil {
		return fmt3.Errorf("this.TaskClock == nil && that.TaskClock != nil")
	} else if that1.TaskClock != nil {
		return fmt3.Errorf("TaskClock this(%v) Not Equal that(%v)", this.TaskClock, that1.TaskClock)
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return fmt3.Errorf("PageFaults this(%v) Not Equal that(%v)", *this.PageFaults, *that1.PageFaults)
		}
	} else if this.PageFaults != nil {
		return fmt3.Errorf("this.PageFaults == nil && that.PageFaults != nil")
	} else if that1.PageFaults != nil {
		return fmt3.Errorf("PageFaults this(%v) Not Equal that(%v)", this.PageFaults, that1.PageFaults)
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return fmt3.Errorf("MinorFaults this(%v) Not Equal that(%v)", *this.MinorFaults, *that1.MinorFaults)
		}
	} else if this.MinorFaults != nil {
		return fmt3.Errorf("this.MinorFaults == nil && that.MinorFaults != nil")
	} else if that1.MinorFaults != nil {
		return fmt3.Errorf("MinorFaults this(%v) Not Equal that(%v)", this.MinorFaults, that1.MinorFaults)
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return fmt3.Errorf("MajorFaults this(%v) Not Equal that(%v)", *this.MajorFaults, *that1.MajorFaults)
		}
	} else if this.MajorFaults != nil {
		return fmt3.Errorf("this.MajorFaults == nil && that.MajorFaults != nil")
	} else if that1.MajorFaults != nil {
		return fmt3.Errorf("MajorFaults this(%v) Not Equal that(%v)", this.MajorFaults, that1.MajorFaults)
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return fmt3.Errorf("ContextSwitches this(%v) Not Equal that(%v)", *this.ContextSwitches, *that1.ContextSwitches)
		}
	} else if this.ContextSwitches != nil {
		return fmt3.Errorf("this.ContextSwitches == nil && that.ContextSwitches != nil")
	} else if that1.ContextSwitches != nil {
		return fmt3.Errorf("ContextSwitches this(%v) Not Equal that(%v)", this.ContextSwitches, that1.ContextSwitches)
	}
	if this.CpuMigrations != nil && that1.CpuMigrations != nil {
		if *this.CpuMigrations != *that1.CpuMigrations {
			return fmt3.Errorf("CpuMigrations this(%v) Not Equal that(%v)", *this.CpuMigrations, *that1.CpuMigrations)
		}
	} else if this.CpuMigrations != nil {
		return fmt3.Errorf("this.CpuMigrations == nil && that.CpuMigrations != nil")
	} else if that1.CpuMigrations != nil {
		return fmt3.Errorf("CpuMigrations this(%v) Not Equal that(%v)", this.CpuMigrations, that1.CpuMigrations)
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return fmt3.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", *this.AlignmentFaults, *that1.AlignmentFaults)
		}
	} else if this.AlignmentFaults != nil {
		return fmt3.Errorf("this.AlignmentFaults == nil && that.AlignmentFaults != nil")
	} else if that1.AlignmentFaults != nil {
		return fmt3.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", this.AlignmentFaults, that1.AlignmentFaults)
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return fmt3.Errorf("EmulationFaults this(%v) Not Equal that(%v)", *this.EmulationFaults, *that1.EmulationFaults)
		}
	} else if this.EmulationFaults != nil {
		return fmt3.Errorf("this.EmulationFaults == nil && that.EmulationFaults != nil")
	} else if that1.EmulationFaults != nil {
		return fmt3.Errorf("EmulationFaults this(%v) Not Equal that(%v)", this.EmulationFaults, that1.EmulationFaults)
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return fmt3.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", *this.L1DcacheLoads, *that1.L1DcacheLoads)
		}
	} else if this.L1DcacheLoads != nil {
		return fmt3.Errorf("this.L1DcacheLoads == nil && that.L1DcacheLoads != nil")
	} else if that1.L1DcacheLoads != nil {
		return fmt3.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", this.L1DcacheLoads, that1.L1DcacheLoads)
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return fmt3.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1DcacheLoadMisses, *that1.L1DcacheLoadMisses)
		}
	} else if this.L1DcacheLoadMisses != nil {
		return fmt3.Errorf("this.L1DcacheLoadMisses == nil && that.L1DcacheLoadMisses != nil")
	} else if that1.L1DcacheLoadMisses != nil {
		return fmt3.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", this.L1DcacheLoadMisses, that1.L1DcacheLoadMisses)
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return fmt3.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", *this.L1DcacheStores, *that1.L1DcacheStores)
		}
	} else if this.L1DcacheStores != nil {
		return fmt3.Errorf("this.L1DcacheStores == nil && that.L1DcacheStores != nil")
	} else if that1.L1DcacheStores != nil {
		return fmt3.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", this.L1DcacheStores, that1.L1DcacheStores)
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return fmt3.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", *this.L1DcacheStoreMisses, *that1.L1DcacheStoreMisses)
		}
	} else if this.L1DcacheStoreMisses != nil {
		return fmt3.Errorf("this.L1DcacheStoreMisses == nil && that.L1DcacheStoreMisses != nil")
	} else if that1.L1DcacheStoreMisses != nil {
		return fmt3.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", this.L1DcacheStoreMisses, that1.L1DcacheStoreMisses)
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return fmt3.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", *this.L1DcachePrefetches, *that1.L1DcachePrefetches)
		}
	} else if this.L1DcachePrefetches != nil {
		return fmt3.Errorf("this.L1DcachePrefetches == nil && that.L1DcachePrefetches != nil")
	} else if that1.L1DcachePrefetches != nil {
		return fmt3.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", this.L1DcachePrefetches, that1.L1DcachePrefetches)
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return fmt3.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1DcachePrefetchMisses, *that1.L1DcachePrefetchMisses)
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return fmt3.Errorf("this.L1DcachePrefetchMisses == nil && that.L1DcachePrefetchMisses != nil")
	} else if that1.L1DcachePrefetchMisses != nil {
		return fmt3.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1DcachePrefetchMisses, that1.L1DcachePrefetchMisses)
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return fmt3.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", *this.L1IcacheLoads, *that1.L1IcacheLoads)
		}
	} else if this.L1IcacheLoads != nil {
		return fmt3.Errorf("this.L1IcacheLoads == nil && that.L1IcacheLoads != nil")
	} else if that1.L1IcacheLoads != nil {
		return fmt3.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", this.L1IcacheLoads, that1.L1IcacheLoads)
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return fmt3.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1IcacheLoadMisses, *that1.L1IcacheLoadMisses)
		}
	} else if this.L1IcacheLoadMisses != nil {
		return fmt3.Errorf("this.L1IcacheLoadMisses == nil && that.L1IcacheLoadMisses != nil")
	} else if that1.L1IcacheLoadMisses != nil {
		return fmt3.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", this.L1IcacheLoadMisses, that1.L1IcacheLoadMisses)
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return fmt3.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", *this.L1IcachePrefetches, *that1.L1IcachePrefetches)
		}
	} else if this.L1IcachePrefetches != nil {
		return fmt3.Errorf("this.L1IcachePrefetches == nil && that.L1IcachePrefetches != nil")
	} else if that1.L1IcachePrefetches != nil {
		return fmt3.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", this.L1IcachePrefetches, that1.L1IcachePrefetches)
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return fmt3.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1IcachePrefetchMisses, *that1.L1IcachePrefetchMisses)
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return fmt3.Errorf("this.L1IcachePrefetchMisses == nil && that.L1IcachePrefetchMisses != nil")
	} else if that1.L1IcachePrefetchMisses != nil {
		return fmt3.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1IcachePrefetchMisses, that1.L1IcachePrefetchMisses)
	}
	if this.LlcLoads != nil && that1.LlcLoads != nil {
		if *this.LlcLoads != *that1.LlcLoads {
			return fmt3.Errorf("LlcLoads this(%v) Not Equal that(%v)", *this.LlcLoads, *that1.LlcLoads)
		}
	} else if this.LlcLoads != nil {
		return fmt3.Errorf("this.LlcLoads == nil && that.LlcLoads != nil")
	} else if that1.LlcLoads != nil {
		return fmt3.Errorf("LlcLoads this(%v) Not Equal that(%v)", this.LlcLoads, that1.LlcLoads)
	}
	if this.LlcLoadMisses != nil && that1.LlcLoadMisses != nil {
		if *this.LlcLoadMisses != *that1.LlcLoadMisses {
			return fmt3.Errorf("LlcLoadMisses this(%v) Not Equal that(%v)", *this.LlcLoadMisses, *that1.LlcLoadMisses)
		}
	} else if this.LlcLoadMisses != nil {
		return fmt3.Errorf("this.LlcLoadMisses == nil && that.LlcLoadMisses != nil")
	} else if that1.LlcLoadMisses != nil {
		return fmt3.Errorf("LlcLoadMisses this(%v) Not Equal that(%v)", this.LlcLoadMisses, that1.LlcLoadMisses)
	}
	if this.LlcStores != nil && that1.LlcStores != nil {
		if *this.LlcStores != *that1.LlcStores {
			return fmt3.Errorf("LlcStores this(%v) Not Equal that(%v)", *this.LlcStores, *that1.LlcStores)
		}
	} else if this.LlcStores != nil {
		return fmt3.Errorf("this.LlcStores == nil && that.LlcStores != nil")
	} else if that1.LlcStores != nil {
		return fmt3.Errorf("LlcStores this(%v) Not Equal that(%v)", this.LlcStores, that1.LlcStores)
	}
	if this.LlcStoreMisses != nil && that1.LlcStoreMisses != nil {
		if *this.LlcStoreMisses != *that1.LlcStoreMisses {
			return fmt3.Errorf("LlcStoreMisses this(%v) Not Equal that(%v)", *this.LlcStoreMisses, *that1.LlcStoreMisses)
		}
	} else if this.LlcStoreMisses != nil {
		return fmt3.Errorf("this.LlcStoreMisses == nil && that.LlcStoreMisses != nil")
	} else if that1.LlcStoreMisses != nil {
		return fmt3.Errorf("LlcStoreMisses this(%v) Not Equal that(%v)", this.LlcStoreMisses, that1.LlcStoreMisses)
	}
	if this.LlcPrefetches != nil && that1.LlcPrefetches != nil {
		if *this.LlcPrefetches != *that1.LlcPrefetches {
			return fmt3.Errorf("LlcPrefetches this(%v) Not Equal that(%v)", *this.LlcPrefetches, *that1.LlcPrefetches)
		}
	} else if this.LlcPrefetches != nil {
		return fmt3.Errorf("this.LlcPrefetches == nil && that.LlcPrefetches != nil")
	} else if that1.LlcPrefetches != nil {
		return fmt3.Errorf("LlcPrefetches this(%v) Not Equal that(%v)", this.LlcPrefetches, that1.LlcPrefetches)
	}
	if this.LlcPrefetchMisses != nil && that1.LlcPrefetchMisses != nil {
		if *this.LlcPrefetchMisses != *that1.LlcPrefetchMisses {
			return fmt3.Errorf("LlcPrefetchMisses this(%v) Not Equal that(%v)", *this.LlcPrefetchMisses, *that1.LlcPrefetchMisses)
		}
	} else if this.LlcPrefetchMisses != nil {
		return fmt3.Errorf("this.LlcPrefetchMisses == nil && that.LlcPrefetchMisses != nil")
	} else if that1.LlcPrefetchMisses != nil {
		return fmt3.Errorf("LlcPrefetchMisses this(%v) Not Equal that(%v)", this.LlcPrefetchMisses, that1.LlcPrefetchMisses)
	}
	if this.DtlbLoads != nil && that1.DtlbLoads != nil {
		if *this.DtlbLoads != *that1.DtlbLoads {
			return fmt3.Errorf("DtlbLoads this(%v) Not Equal that(%v)", *this.DtlbLoads, *that1.DtlbLoads)
		}
	} else if this.DtlbLoads != nil {
		return fmt3.Errorf("this.DtlbLoads == nil && that.DtlbLoads != nil")
	} else if that1.DtlbLoads != nil {
		return fmt3.Errorf("DtlbLoads this(%v) Not Equal that(%v)", this.DtlbLoads, that1.DtlbLoads)
	}
	if this.DtlbLoadMisses != nil && that1.DtlbLoadMisses != nil {
		if *this.DtlbLoadMisses != *that1.DtlbLoadMisses {
			return fmt3.Errorf("DtlbLoadMisses this(%v) Not Equal that(%v)", *this.DtlbLoadMisses, *that1.DtlbLoadMisses)
		}
	} else if this.DtlbLoadMisses != nil {
		return fmt3.Errorf("this.DtlbLoadMisses == nil && that.DtlbLoadMisses != nil")
	} else if that1.DtlbLoadMisses != nil {
		return fmt3.Errorf("DtlbLoadMisses this(%v) Not Equal that(%v)", this.DtlbLoadMisses, that1.DtlbLoadMisses)
	}
	if this.DtlbStores != nil && that1.DtlbStores != nil {
		if *this.DtlbStores != *that1.DtlbStores {
			return fmt3.Errorf("DtlbStores this(%v) Not Equal that(%v)", *this.DtlbStores, *that1.DtlbStores)
		}
	} else if this.DtlbStores != nil {
		return fmt3.Errorf("this.DtlbStores == nil && that.DtlbStores != nil")
	} else if that1.DtlbStores != nil {
		return fmt3.Errorf("DtlbStores this(%v) Not Equal that(%v)", this.DtlbStores, that1.DtlbStores)
	}
	if this.DtlbStoreMisses != nil && that1.DtlbStoreMisses != nil {
		if *this.DtlbStoreMisses != *that1.DtlbStoreMisses {
			return fmt3.Errorf("DtlbStoreMisses this(%v) Not Equal that(%v)", *this.DtlbStoreMisses, *that1.DtlbStoreMisses)
		}
	} else if this.DtlbStoreMisses != nil {
		return fmt3.Errorf("this.DtlbStoreMisses == nil && that.DtlbStoreMisses != nil")
	} else if that1.DtlbStoreMisses != nil {
		return fmt3.Errorf("DtlbStoreMisses this(%v) Not Equal that(%v)", this.DtlbStoreMisses, that1.DtlbStoreMisses)
	}
	if this.DtlbPrefetches != nil && that1.DtlbPrefetches != nil {
		if *this.DtlbPrefetches != *that1.DtlbPrefetches {
			return fmt3.Errorf("DtlbPrefetches this(%v) Not Equal that(%v)", *this.DtlbPrefetches, *that1.DtlbPrefetches)
		}
	} else if this.DtlbPrefetches != nil {
		return fmt3.Errorf("this.DtlbPrefetches == nil && that.DtlbPrefetches != nil")
	} else if that1.DtlbPrefetches != nil {
		return fmt3.Errorf("DtlbPrefetches this(%v) Not Equal that(%v)", this.DtlbPrefetches, that1.DtlbPrefetches)
	}
	if this.DtlbPrefetchMisses != nil && that1.DtlbPrefetchMisses != nil {
		if *this.DtlbPrefetchMisses != *that1.DtlbPrefetchMisses {
			return fmt3.Errorf("DtlbPrefetchMisses this(%v) Not Equal that(%v)", *this.DtlbPrefetchMisses, *that1.DtlbPrefetchMisses)
		}
	} else if this.DtlbPrefetchMisses != nil {
		return fmt3.Errorf("this.DtlbPrefetchMisses == nil && that.DtlbPrefetchMisses != nil")
	} else if that1.DtlbPrefetchMisses != nil {
		return fmt3.Errorf("DtlbPrefetchMisses this(%v) Not Equal that(%v)", this.DtlbPrefetchMisses, that1.DtlbPrefetchMisses)
	}
	if this.ItlbLoads != nil && that1.ItlbLoads != nil {
		if *this.ItlbLoads != *that1.ItlbLoads {
			return fmt3.Errorf("ItlbLoads this(%v) Not Equal that(%v)", *this.ItlbLoads, *that1.ItlbLoads)
		}
	} else if this.ItlbLoads != nil {
		return fmt3.Errorf("this.ItlbLoads == nil && that.ItlbLoads != nil")
	} else if that1.ItlbLoads != nil {
		return fmt3.Errorf("ItlbLoads this(%v) Not Equal that(%v)", this.ItlbLoads, that1.ItlbLoads)
	}
	if this.ItlbLoadMisses != nil && that1.ItlbLoadMisses != nil {
		if *this.ItlbLoadMisses != *that1.ItlbLoadMisses {
			return fmt3.Errorf("ItlbLoadMisses this(%v) Not Equal that(%v)", *this.ItlbLoadMisses, *that1.ItlbLoadMisses)
		}
	} else if this.ItlbLoadMisses != nil {
		return fmt3.Errorf("this.ItlbLoadMisses == nil && that.ItlbLoadMisses != nil")
	} else if that1.ItlbLoadMisses != nil {
		return fmt3.Errorf("ItlbLoadMisses this(%v) Not Equal that(%v)", this.ItlbLoadMisses, that1.ItlbLoadMisses)
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return fmt3.Errorf("BranchLoads this(%v) Not Equal that(%v)", *this.BranchLoads, *that1.BranchLoads)
		}
	} else if this.BranchLoads != nil {
		return fmt3.Errorf("this.BranchLoads == nil && that.BranchLoads != nil")
	} else if that1.BranchLoads != nil {
		return fmt3.Errorf("BranchLoads this(%v) Not Equal that(%v)", this.BranchLoads, that1.BranchLoads)
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return fmt3.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", *this.BranchLoadMisses, *that1.BranchLoadMisses)
		}
	} else if this.BranchLoadMisses != nil {
		return fmt3.Errorf("this.BranchLoadMisses == nil && that.BranchLoadMisses != nil")
	} else if that1.BranchLoadMisses != nil {
		return fmt3.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", this.BranchLoadMisses, that1.BranchLoadMisses)
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return fmt3.Errorf("NodeLoads this(%v) Not Equal that(%v)", *this.NodeLoads, *that1.NodeLoads)
		}
	} else if this.NodeLoads != nil {
		return fmt3.Errorf("this.NodeLoads == nil && that.NodeLoads != nil")
	} else if that1.NodeLoads != nil {
		return fmt3.Errorf("NodeLoads this(%v) Not Equal that(%v)", this.NodeLoads, that1.NodeLoads)
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return fmt3.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", *this.NodeLoadMisses, *that1.NodeLoadMisses)
		}
	} else if this.NodeLoadMisses != nil {
		return fmt3.Errorf("this.NodeLoadMisses == nil && that.NodeLoadMisses != nil")
	} else if that1.NodeLoadMisses != nil {
		return fmt3.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", this.NodeLoadMisses, that1.NodeLoadMisses)
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return fmt3.Errorf("NodeStores this(%v) Not Equal that(%v)", *this.NodeStores, *that1.NodeStores)
		}
	} else if this.NodeStores != nil {
		return fmt3.Errorf("this.NodeStores == nil && that.NodeStores != nil")
	} else if that1.NodeStores != nil {
		return fmt3.Errorf("NodeStores this(%v) Not Equal that(%v)", this.NodeStores, that1.NodeStores)
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return fmt3.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", *this.NodeStoreMisses, *that1.NodeStoreMisses)
		}
	} else if this.NodeStoreMisses != nil {
		return fmt3.Errorf("this.NodeStoreMisses == nil && that.NodeStoreMisses != nil")
	} else if that1.NodeStoreMisses != nil {
		return fmt3.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", this.NodeStoreMisses, that1.NodeStoreMisses)
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return fmt3.Errorf("NodePrefetches this(%v) Not Equal that(%v)", *this.NodePrefetches, *that1.NodePrefetches)
		}
	} else if this.NodePrefetches != nil {
		return fmt3.Errorf("this.NodePrefetches == nil && that.NodePrefetches != nil")
	} else if that1.NodePrefetches != nil {
		return fmt3.Errorf("NodePrefetches this(%v) Not Equal that(%v)", this.NodePrefetches, that1.NodePrefetches)
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return fmt3.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", *this.NodePrefetchMisses, *that1.NodePrefetchMisses)
		}
	} else if this.NodePrefetchMisses != nil {
		return fmt3.Errorf("this.NodePrefetchMisses == nil && that.NodePrefetchMisses != nil")
	} else if that1.NodePrefetchMisses != nil {
		return fmt3.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", this.NodePrefetchMisses, that1.NodePrefetchMisses)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *PerfStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if this.Duration != nil && that1.Duration != nil {
		if *this.Duration != *that1.Duration {
			return false
		}
	} else if this.Duration != nil {
		return false
	} else if that1.Duration != nil {
		return false
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return false
		}
	} else if this.Cycles != nil {
		return false
	} else if that1.Cycles != nil {
		return false
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return false
		}
	} else if this.StalledCyclesFrontend != nil {
		return false
	} else if that1.StalledCyclesFrontend != nil {
		return false
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return false
		}
	} else if this.StalledCyclesBackend != nil {
		return false
	} else if that1.StalledCyclesBackend != nil {
		return false
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return false
		}
	} else if this.Instructions != nil {
		return false
	} else if that1.Instructions != nil {
		return false
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return false
		}
	} else if this.CacheReferences != nil {
		return false
	} else if that1.CacheReferences != nil {
		return false
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return false
		}
	} else if this.CacheMisses != nil {
		return false
	} else if that1.CacheMisses != nil {
		return false
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return false
		}
	} else if this.Branches != nil {
		return false
	} else if that1.Branches != nil {
		return false
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return false
		}
	} else if this.BranchMisses != nil {
		return false
	} else if that1.BranchMisses != nil {
		return false
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return false
		}
	} else if this.BusCycles != nil {
		return false
	} else if that1.BusCycles != nil {
		return false
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return false
		}
	} else if this.RefCycles != nil {
		return false
	} else if that1.RefCycles != nil {
		return false
	}
	if this.CpuClock != nil && that1.CpuClock != nil {
		if *this.CpuClock != *that1.CpuClock {
			return false
		}
	} else if this.CpuClock != nil {
		return false
	} else if that1.CpuClock != nil {
		return false
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return false
		}
	} else if this.TaskClock != nil {
		return false
	} else if that1.TaskClock != nil {
		return false
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return false
		}
	} else if this.PageFaults != nil {
		return false
	} else if that1.PageFaults != nil {
		return false
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return false
		}
	} else if this.MinorFaults != nil {
		return false
	} else if that1.MinorFaults != nil {
		return false
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return false
		}
	} else if this.MajorFaults != nil {
		return false
	} else if that1.MajorFaults != nil {
		return false
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return false
		}
	} else if this.ContextSwitches != nil {
		return false
	} else if that1.ContextSwitches != nil {
		return false
	}
	if this.CpuMigrations != nil && that1.CpuMigrations != nil {
		if *this.CpuMigrations != *that1.CpuMigrations {
			return false
		}
	} else if this.CpuMigrations != nil {
		return false
	} else if that1.CpuMigrations != nil {
		return false
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return false
		}
	} else if this.AlignmentFaults != nil {
		return false
	} else if that1.AlignmentFaults != nil {
		return false
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return false
		}
	} else if this.EmulationFaults != nil {
		return false
	} else if that1.EmulationFaults != nil {
		return false
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return false
		}
	} else if this.L1DcacheLoads != nil {
		return false
	} else if that1.L1DcacheLoads != nil {
		return false
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return false
		}
	} else if this.L1DcacheLoadMisses != nil {
		return false
	} else if that1.L1DcacheLoadMisses != nil {
		return false
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return false
		}
	} else if this.L1DcacheStores != nil {
		return false
	} else if that1.L1DcacheStores != nil {
		return false
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return false
		}
	} else if this.L1DcacheStoreMisses != nil {
		return false
	} else if that1.L1DcacheStoreMisses != nil {
		return false
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return false
		}
	} else if this.L1DcachePrefetches != nil {
		return false
	} else if that1.L1DcachePrefetches != nil {
		return false
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return false
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return false
	} else if that1.L1DcachePrefetchMisses != nil {
		return false
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return false
		}
	} else if this.L1IcacheLoads != nil {
		return false
	} else if that1.L1IcacheLoads != nil {
		return false
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return false
		}
	} else if this.L1IcacheLoadMisses != nil {
		return false
	} else if that1.L1IcacheLoadMisses != nil {
		return false
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return false
		}
	} else if this.L1IcachePrefetches != nil {
		return false
	} else if that1.L1IcachePrefetches != nil {
		return false
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return false
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return false
	} else if that1.L1IcachePrefetchMisses != nil {
		return false
	}
	if this.LlcLoads != nil && that1.LlcLoads != nil {
		if *this.LlcLoads != *that1.LlcLoads {
			return false
		}
	} else if this.LlcLoads != nil {
		return false
	} else if that1.LlcLoads != nil {
		return false
	}
	if this.LlcLoadMisses != nil && that1.LlcLoadMisses != nil {
		if *this.LlcLoadMisses != *that1.LlcLoadMisses {
			return false
		}
	} else if this.LlcLoadMisses != nil {
		return false
	} else if that1.LlcLoadMisses != nil {
		return false
	}
	if this.LlcStores != nil && that1.LlcStores != nil {
		if *this.LlcStores != *that1.LlcStores {
			return false
		}
	} else if this.LlcStores != nil {
		return false
	} else if that1.LlcStores != nil {
		return false
	}
	if this.LlcStoreMisses != nil && that1.LlcStoreMisses != nil {
		if *this.LlcStoreMisses != *that1.LlcStoreMisses {
			return false
		}
	} else if this.LlcStoreMisses != nil {
		return false
	} else if that1.LlcStoreMisses != nil {
		return false
	}
	if this.LlcPrefetches != nil && that1.LlcPrefetches != nil {
		if *this.LlcPrefetches != *that1.LlcPrefetches {
			return false
		}
	} else if this.LlcPrefetches != nil {
		return false
	} else if that1.LlcPrefetches != nil {
		return false
	}
	if this.LlcPrefetchMisses != nil && that1.LlcPrefetchMisses != nil {
		if *this.LlcPrefetchMisses != *that1.LlcPrefetchMisses {
			return false
		}
	} else if this.LlcPrefetchMisses != nil {
		return false
	} else if that1.LlcPrefetchMisses != nil {
		return false
	}
	if this.DtlbLoads != nil && that1.DtlbLoads != nil {
		if *this.DtlbLoads != *that1.DtlbLoads {
			return false
		}
	} else if this.DtlbLoads != nil {
		return false
	} else if that1.DtlbLoads != nil {
		return false
	}
	if this.DtlbLoadMisses != nil && that1.DtlbLoadMisses != nil {
		if *this.DtlbLoadMisses != *that1.DtlbLoadMisses {
			return false
		}
	} else if this.DtlbLoadMisses != nil {
		return false
	} else if that1.DtlbLoadMisses != nil {
		return false
	}
	if this.DtlbStores != nil && that1.DtlbStores != nil {
		if *this.DtlbStores != *that1.DtlbStores {
			return false
		}
	} else if this.DtlbStores != nil {
		return false
	} else if that1.DtlbStores != nil {
		return false
	}
	if this.DtlbStoreMisses != nil && that1.DtlbStoreMisses != nil {
		if *this.DtlbStoreMisses != *that1.DtlbStoreMisses {
			return false
		}
	} else if this.DtlbStoreMisses != nil {
		return false
	} else if that1.DtlbStoreMisses != nil {
		return false
	}
	if this.DtlbPrefetches != nil && that1.DtlbPrefetches != nil {
		if *this.DtlbPrefetches != *that1.DtlbPrefetches {
			return false
		}
	} else if this.DtlbPrefetches != nil {
		return false
	} else if that1.DtlbPrefetches != nil {
		return false
	}
	if this.DtlbPrefetchMisses != nil && that1.DtlbPrefetchMisses != nil {
		if *this.DtlbPrefetchMisses != *that1.DtlbPrefetchMisses {
			return false
		}
	} else if this.DtlbPrefetchMisses != nil {
		return false
	} else if that1.DtlbPrefetchMisses != nil {
		return false
	}
	if this.ItlbLoads != nil && that1.ItlbLoads != nil {
		if *this.ItlbLoads != *that1.ItlbLoads {
			return false
		}
	} else if this.ItlbLoads != nil {
		return false
	} else if that1.ItlbLoads != nil {
		return false
	}
	if this.ItlbLoadMisses != nil && that1.ItlbLoadMisses != nil {
		if *this.ItlbLoadMisses != *that1.ItlbLoadMisses {
			return false
		}
	} else if this.ItlbLoadMisses != nil {
		return false
	} else if that1.ItlbLoadMisses != nil {
		return false
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return false
		}
	} else if this.BranchLoads != nil {
		return false
	} else if that1.BranchLoads != nil {
		return false
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return false
		}
	} else if this.BranchLoadMisses != nil {
		return false
	} else if that1.BranchLoadMisses != nil {
		return false
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return false
		}
	} else if this.NodeLoads != nil {
		return false
	} else if that1.NodeLoads != nil {
		return false
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return false
		}
	} else if this.NodeLoadMisses != nil {
		return false
	} else if that1.NodeLoadMisses != nil {
		return false
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return false
		}
	} else if this.NodeStores != nil {
		return false
	} else if that1.NodeStores != nil {
		return false
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return false
		}
	} else if this.NodeStoreMisses != nil {
		return false
	} else if that1.NodeStoreMisses != nil {
		return false
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return false
		}
	} else if this.NodePrefetches != nil {
		return false
	} else if that1.NodePrefetches != nil {
		return false
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return false
		}
	} else if this.NodePrefetchMisses != nil {
		return false
	} else if that1.NodePrefetchMisses != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Request) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Request)
	if !ok {
		return fmt3.Errorf("that is not of type *Request")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Request but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Requestbut is not nil && this == nil")
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt3.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt3.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt3.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Request) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Request)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer)
	if !ok {
		return fmt3.Errorf("that is not of type *Offer")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Offer but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Offerbut is not nil && this == nil")
	}
	if !this.Id.Equal(that1.Id) {
		return fmt3.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt3.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt3.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt3.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt3.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt3.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt3.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return fmt3.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if len(this.ExecutorIds) != len(that1.ExecutorIds) {
		return fmt3.Errorf("ExecutorIds this(%v) Not Equal that(%v)", len(this.ExecutorIds), len(that1.ExecutorIds))
	}
	for i := range this.ExecutorIds {
		if !this.ExecutorIds[i].Equal(that1.ExecutorIds[i]) {
			return fmt3.Errorf("ExecutorIds this[%v](%v) Not Equal that[%v](%v)", i, this.ExecutorIds[i], i, that1.ExecutorIds[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if len(this.ExecutorIds) != len(that1.ExecutorIds) {
		return false
	}
	for i := range this.ExecutorIds {
		if !this.ExecutorIds[i].Equal(that1.ExecutorIds[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *TaskInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *TaskInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *TaskInfobut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return fmt3.Errorf("TaskId this(%v) Not Equal that(%v)", this.TaskId, that1.TaskId)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt3.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt3.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt3.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return fmt3.Errorf("Executor this(%v) Not Equal that(%v)", this.Executor, that1.Executor)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt3.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt3.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt3.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return fmt3.Errorf("HealthCheck this(%v) Not Equal that(%v)", this.HealthCheck, that1.HealthCheck)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		return fmt3.Errorf("that is not of type *TaskStatus")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *TaskStatus but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *TaskStatusbut is not nil && this == nil")
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return fmt3.Errorf("TaskId this(%v) Not Equal that(%v)", this.TaskId, that1.TaskId)
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return fmt3.Errorf("State this(%v) Not Equal that(%v)", *this.State, *that1.State)
		}
	} else if this.State != nil {
		return fmt3.Errorf("this.State == nil && that.State != nil")
	} else if that1.State != nil {
		return fmt3.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return fmt3.Errorf("Message this(%v) Not Equal that(%v)", *this.Message, *that1.Message)
		}
	} else if this.Message != nil {
		return fmt3.Errorf("this.Message == nil && that.Message != nil")
	} else if that1.Message != nil {
		return fmt3.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt3.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt3.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt3.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return fmt3.Errorf("Reason this(%v) Not Equal that(%v)", *this.Reason, *that1.Reason)
		}
	} else if this.Reason != nil {
		return fmt3.Errorf("this.Reason == nil && that.Reason != nil")
	} else if that1.Reason != nil {
		return fmt3.Errorf("Reason this(%v) Not Equal that(%v)", this.Reason, that1.Reason)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt3.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt3.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return fmt3.Errorf("ExecutorId this(%v) Not Equal that(%v)", this.ExecutorId, that1.ExecutorId)
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt3.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt3.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return fmt3.Errorf("Healthy this(%v) Not Equal that(%v)", *this.Healthy, *that1.Healthy)
		}
	} else if this.Healthy != nil {
		return fmt3.Errorf("this.Healthy == nil && that.Healthy != nil")
	} else if that1.Healthy != nil {
		return fmt3.Errorf("Healthy this(%v) Not Equal that(%v)", this.Healthy, that1.Healthy)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return false
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return false
		}
	} else if this.State != nil {
		return false
	} else if that1.State != nil {
		return false
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return false
		}
	} else if this.Message != nil {
		return false
	} else if that1.Message != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return false
		}
	} else if this.Reason != nil {
		return false
	} else if that1.Reason != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return false
		}
	} else if this.Healthy != nil {
		return false
	} else if that1.Healthy != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Filters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Filters)
	if !ok {
		return fmt3.Errorf("that is not of type *Filters")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Filters but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Filtersbut is not nil && this == nil")
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return fmt3.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", *this.RefuseSeconds, *that1.RefuseSeconds)
		}
	} else if this.RefuseSeconds != nil {
		return fmt3.Errorf("this.RefuseSeconds == nil && that.RefuseSeconds != nil")
	} else if that1.RefuseSeconds != nil {
		return fmt3.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", this.RefuseSeconds, that1.RefuseSeconds)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Filters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Filters)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return false
		}
	} else if this.RefuseSeconds != nil {
		return false
	} else if that1.RefuseSeconds != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Environment) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment)
	if !ok {
		return fmt3.Errorf("that is not of type *Environment")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Environment but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Environmentbut is not nil && this == nil")
	}
	if len(this.Variables) != len(that1.Variables) {
		return fmt3.Errorf("Variables this(%v) Not Equal that(%v)", len(this.Variables), len(that1.Variables))
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(that1.Variables[i]) {
			return fmt3.Errorf("Variables this[%v](%v) Not Equal that[%v](%v)", i, this.Variables[i], i, that1.Variables[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Environment) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Variables) != len(that1.Variables) {
		return false
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(that1.Variables[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Environment_Variable) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		return fmt3.Errorf("that is not of type *Environment_Variable")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Environment_Variable but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Environment_Variablebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt3.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt3.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt3.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Environment_Variable) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Parameter) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameter)
	if !ok {
		return fmt3.Errorf("that is not of type *Parameter")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Parameter but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Parameterbut is not nil && this == nil")
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return fmt3.Errorf("Key this(%v) Not Equal that(%v)", *this.Key, *that1.Key)
		}
	} else if this.Key != nil {
		return fmt3.Errorf("this.Key == nil && that.Key != nil")
	} else if that1.Key != nil {
		return fmt3.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt3.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt3.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt3.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Parameter) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameter)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return false
		}
	} else if this.Key != nil {
		return false
	} else if that1.Key != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Parameters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameters)
	if !ok {
		return fmt3.Errorf("that is not of type *Parameters")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Parameters but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Parametersbut is not nil && this == nil")
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return fmt3.Errorf("Parameter this(%v) Not Equal that(%v)", len(this.Parameter), len(that1.Parameter))
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(that1.Parameter[i]) {
			return fmt3.Errorf("Parameter this[%v](%v) Not Equal that[%v](%v)", i, this.Parameter[i], i, that1.Parameter[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Parameters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameters)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return false
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(that1.Parameter[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Credential) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credential)
	if !ok {
		return fmt3.Errorf("that is not of type *Credential")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Credential but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Credentialbut is not nil && this == nil")
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt3.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if !bytes.Equal(this.Secret, that1.Secret) {
		return fmt3.Errorf("Secret this(%v) Not Equal that(%v)", this.Secret, that1.Secret)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Credential) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credential)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if !bytes.Equal(this.Secret, that1.Secret) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Credentials) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credentials)
	if !ok {
		return fmt3.Errorf("that is not of type *Credentials")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Credentials but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Credentialsbut is not nil && this == nil")
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return fmt3.Errorf("Credentials this(%v) Not Equal that(%v)", len(this.Credentials), len(that1.Credentials))
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(that1.Credentials[i]) {
			return fmt3.Errorf("Credentials this[%v](%v) Not Equal that[%v](%v)", i, this.Credentials[i], i, that1.Credentials[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Credentials) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credentials)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return false
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(that1.Credentials[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL)
	if !ok {
		return fmt3.Errorf("that is not of type *ACL")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACL but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACLbut is not nil && this == nil")
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_Entity) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_Entity)
	if !ok {
		return fmt3.Errorf("that is not of type *ACL_Entity")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACL_Entity but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACL_Entitybut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt3.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt3.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt3.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if len(this.Values) != len(that1.Values) {
		return fmt3.Errorf("Values this(%v) Not Equal that(%v)", len(this.Values), len(that1.Values))
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return fmt3.Errorf("Values this[%v](%v) Not Equal that[%v](%v)", i, this.Values[i], i, that1.Values[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_Entity) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_Entity)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_RegisterFramework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_RegisterFramework)
	if !ok {
		return fmt3.Errorf("that is not of type *ACL_RegisterFramework")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACL_RegisterFramework but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACL_RegisterFrameworkbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt3.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.Roles.Equal(that1.Roles) {
		return fmt3.Errorf("Roles this(%v) Not Equal that(%v)", this.Roles, that1.Roles)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_RegisterFramework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_RegisterFramework)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.Roles.Equal(that1.Roles) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_RunTask) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_RunTask)
	if !ok {
		return fmt3.Errorf("that is not of type *ACL_RunTask")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACL_RunTask but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACL_RunTaskbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt3.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.Users.Equal(that1.Users) {
		return fmt3.Errorf("Users this(%v) Not Equal that(%v)", this.Users, that1.Users)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_RunTask) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_RunTask)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.Users.Equal(that1.Users) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_ShutdownFramework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_ShutdownFramework)
	if !ok {
		return fmt3.Errorf("that is not of type *ACL_ShutdownFramework")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACL_ShutdownFramework but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACL_ShutdownFrameworkbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt3.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.FrameworkPrincipals.Equal(that1.FrameworkPrincipals) {
		return fmt3.Errorf("FrameworkPrincipals this(%v) Not Equal that(%v)", this.FrameworkPrincipals, that1.FrameworkPrincipals)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_ShutdownFramework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_ShutdownFramework)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.FrameworkPrincipals.Equal(that1.FrameworkPrincipals) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACLs) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACLs)
	if !ok {
		return fmt3.Errorf("that is not of type *ACLs")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ACLs but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ACLsbut is not nil && this == nil")
	}
	if this.Permissive != nil && that1.Permissive != nil {
		if *this.Permissive != *that1.Permissive {
			return fmt3.Errorf("Permissive this(%v) Not Equal that(%v)", *this.Permissive, *that1.Permissive)
		}
	} else if this.Permissive != nil {
		return fmt3.Errorf("this.Permissive == nil && that.Permissive != nil")
	} else if that1.Permissive != nil {
		return fmt3.Errorf("Permissive this(%v) Not Equal that(%v)", this.Permissive, that1.Permissive)
	}
	if len(this.RegisterFrameworks) != len(that1.RegisterFrameworks) {
		return fmt3.Errorf("RegisterFrameworks this(%v) Not Equal that(%v)", len(this.RegisterFrameworks), len(that1.RegisterFrameworks))
	}
	for i := range this.RegisterFrameworks {
		if !this.RegisterFrameworks[i].Equal(that1.RegisterFrameworks[i]) {
			return fmt3.Errorf("RegisterFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.RegisterFrameworks[i], i, that1.RegisterFrameworks[i])
		}
	}
	if len(this.RunTasks) != len(that1.RunTasks) {
		return fmt3.Errorf("RunTasks this(%v) Not Equal that(%v)", len(this.RunTasks), len(that1.RunTasks))
	}
	for i := range this.RunTasks {
		if !this.RunTasks[i].Equal(that1.RunTasks[i]) {
			return fmt3.Errorf("RunTasks this[%v](%v) Not Equal that[%v](%v)", i, this.RunTasks[i], i, that1.RunTasks[i])
		}
	}
	if len(this.ShutdownFrameworks) != len(that1.ShutdownFrameworks) {
		return fmt3.Errorf("ShutdownFrameworks this(%v) Not Equal that(%v)", len(this.ShutdownFrameworks), len(that1.ShutdownFrameworks))
	}
	for i := range this.ShutdownFrameworks {
		if !this.ShutdownFrameworks[i].Equal(that1.ShutdownFrameworks[i]) {
			return fmt3.Errorf("ShutdownFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.ShutdownFrameworks[i], i, that1.ShutdownFrameworks[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACLs) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACLs)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Permissive != nil && that1.Permissive != nil {
		if *this.Permissive != *that1.Permissive {
			return false
		}
	} else if this.Permissive != nil {
		return false
	} else if that1.Permissive != nil {
		return false
	}
	if len(this.RegisterFrameworks) != len(that1.RegisterFrameworks) {
		return false
	}
	for i := range this.RegisterFrameworks {
		if !this.RegisterFrameworks[i].Equal(that1.RegisterFrameworks[i]) {
			return false
		}
	}
	if len(this.RunTasks) != len(that1.RunTasks) {
		return false
	}
	for i := range this.RunTasks {
		if !this.RunTasks[i].Equal(that1.RunTasks[i]) {
			return false
		}
	}
	if len(this.ShutdownFrameworks) != len(that1.ShutdownFrameworks) {
		return false
	}
	for i := range this.ShutdownFrameworks {
		if !this.ShutdownFrameworks[i].Equal(that1.ShutdownFrameworks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		return fmt3.Errorf("that is not of type *RateLimit")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *RateLimit but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *RateLimitbut is not nil && this == nil")
	}
	if this.Qps != nil && that1.Qps != nil {
		if *this.Qps != *that1.Qps {
			return fmt3.Errorf("Qps this(%v) Not Equal that(%v)", *this.Qps, *that1.Qps)
		}
	} else if this.Qps != nil {
		return fmt3.Errorf("this.Qps == nil && that.Qps != nil")
	} else if that1.Qps != nil {
		return fmt3.Errorf("Qps this(%v) Not Equal that(%v)", this.Qps, that1.Qps)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt3.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt3.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return fmt3.Errorf("Capacity this(%v) Not Equal that(%v)", *this.Capacity, *that1.Capacity)
		}
	} else if this.Capacity != nil {
		return fmt3.Errorf("this.Capacity == nil && that.Capacity != nil")
	} else if that1.Capacity != nil {
		return fmt3.Errorf("Capacity this(%v) Not Equal that(%v)", this.Capacity, that1.Capacity)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RateLimit) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Qps != nil && that1.Qps != nil {
		if *this.Qps != *that1.Qps {
			return false
		}
	} else if this.Qps != nil {
		return false
	} else if that1.Qps != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return false
		}
	} else if this.Capacity != nil {
		return false
	} else if that1.Capacity != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimits) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		return fmt3.Errorf("that is not of type *RateLimits")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *RateLimits but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *RateLimitsbut is not nil && this == nil")
	}
	if len(this.Limits) != len(that1.Limits) {
		return fmt3.Errorf("Limits this(%v) Not Equal that(%v)", len(this.Limits), len(that1.Limits))
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return fmt3.Errorf("Limits this[%v](%v) Not Equal that[%v](%v)", i, this.Limits[i], i, that1.Limits[i])
		}
	}
	if this.AggregateDefaultQps != nil && that1.AggregateDefaultQps != nil {
		if *this.AggregateDefaultQps != *that1.AggregateDefaultQps {
			return fmt3.Errorf("AggregateDefaultQps this(%v) Not Equal that(%v)", *this.AggregateDefaultQps, *that1.AggregateDefaultQps)
		}
	} else if this.AggregateDefaultQps != nil {
		return fmt3.Errorf("this.AggregateDefaultQps == nil && that.AggregateDefaultQps != nil")
	} else if that1.AggregateDefaultQps != nil {
		return fmt3.Errorf("AggregateDefaultQps this(%v) Not Equal that(%v)", this.AggregateDefaultQps, that1.AggregateDefaultQps)
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return fmt3.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", *this.AggregateDefaultCapacity, *that1.AggregateDefaultCapacity)
		}
	} else if this.AggregateDefaultCapacity != nil {
		return fmt3.Errorf("this.AggregateDefaultCapacity == nil && that.AggregateDefaultCapacity != nil")
	} else if that1.AggregateDefaultCapacity != nil {
		return fmt3.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", this.AggregateDefaultCapacity, that1.AggregateDefaultCapacity)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RateLimits) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return false
		}
	}
	if this.AggregateDefaultQps != nil && that1.AggregateDefaultQps != nil {
		if *this.AggregateDefaultQps != *that1.AggregateDefaultQps {
			return false
		}
	} else if this.AggregateDefaultQps != nil {
		return false
	} else if that1.AggregateDefaultQps != nil {
		return false
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return false
		}
	} else if this.AggregateDefaultCapacity != nil {
		return false
	} else if that1.AggregateDefaultCapacity != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Volume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume)
	if !ok {
		return fmt3.Errorf("that is not of type *Volume")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *Volume but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *Volumebut is not nil && this == nil")
	}
	if this.ContainerPath != nil && that1.ContainerPath != nil {
		if *this.ContainerPath != *that1.ContainerPath {
			return fmt3.Errorf("ContainerPath this(%v) Not Equal that(%v)", *this.ContainerPath, *that1.ContainerPath)
		}
	} else if this.ContainerPath != nil {
		return fmt3.Errorf("this.ContainerPath == nil && that.ContainerPath != nil")
	} else if that1.ContainerPath != nil {
		return fmt3.Errorf("ContainerPath this(%v) Not Equal that(%v)", this.ContainerPath, that1.ContainerPath)
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return fmt3.Errorf("HostPath this(%v) Not Equal that(%v)", *this.HostPath, *that1.HostPath)
		}
	} else if this.HostPath != nil {
		return fmt3.Errorf("this.HostPath == nil && that.HostPath != nil")
	} else if that1.HostPath != nil {
		return fmt3.Errorf("HostPath this(%v) Not Equal that(%v)", this.HostPath, that1.HostPath)
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt3.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt3.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt3.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Volume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ContainerPath != nil && that1.ContainerPath != nil {
		if *this.ContainerPath != *that1.ContainerPath {
			return false
		}
	} else if this.ContainerPath != nil {
		return false
	} else if that1.ContainerPath != nil {
		return false
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return false
		}
	} else if this.HostPath != nil {
		return false
	} else if that1.HostPath != nil {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *ContainerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ContainerInfobut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt3.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt3.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt3.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt3.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return fmt3.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt3.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt3.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !this.Docker.Equal(that1.Docker) {
		return fmt3.Errorf("Docker this(%v) Not Equal that(%v)", this.Docker, that1.Docker)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if !this.Docker.Equal(that1.Docker) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		return fmt3.Errorf("that is not of type *ContainerInfo_DockerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ContainerInfo_DockerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ContainerInfo_DockerInfobut is not nil && this == nil")
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return fmt3.Errorf("Image this(%v) Not Equal that(%v)", *this.Image, *that1.Image)
		}
	} else if this.Image != nil {
		return fmt3.Errorf("this.Image == nil && that.Image != nil")
	} else if that1.Image != nil {
		return fmt3.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return fmt3.Errorf("Network this(%v) Not Equal that(%v)", *this.Network, *that1.Network)
		}
	} else if this.Network != nil {
		return fmt3.Errorf("this.Network == nil && that.Network != nil")
	} else if that1.Network != nil {
		return fmt3.Errorf("Network this(%v) Not Equal that(%v)", this.Network, that1.Network)
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return fmt3.Errorf("PortMappings this(%v) Not Equal that(%v)", len(this.PortMappings), len(that1.PortMappings))
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(that1.PortMappings[i]) {
			return fmt3.Errorf("PortMappings this[%v](%v) Not Equal that[%v](%v)", i, this.PortMappings[i], i, that1.PortMappings[i])
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return fmt3.Errorf("Privileged this(%v) Not Equal that(%v)", *this.Privileged, *that1.Privileged)
		}
	} else if this.Privileged != nil {
		return fmt3.Errorf("this.Privileged == nil && that.Privileged != nil")
	} else if that1.Privileged != nil {
		return fmt3.Errorf("Privileged this(%v) Not Equal that(%v)", this.Privileged, that1.Privileged)
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return fmt3.Errorf("Parameters this(%v) Not Equal that(%v)", len(this.Parameters), len(that1.Parameters))
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(that1.Parameters[i]) {
			return fmt3.Errorf("Parameters this[%v](%v) Not Equal that[%v](%v)", i, this.Parameters[i], i, that1.Parameters[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return false
		}
	} else if this.Image != nil {
		return false
	} else if that1.Image != nil {
		return false
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return false
		}
	} else if this.Network != nil {
		return false
	} else if that1.Network != nil {
		return false
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return false
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(that1.PortMappings[i]) {
			return false
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return false
		}
	} else if this.Privileged != nil {
		return false
	} else if that1.Privileged != nil {
		return false
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return false
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(that1.Parameters[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo_PortMapping) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		return fmt3.Errorf("that is not of type *ContainerInfo_DockerInfo_PortMapping")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt3.Errorf("that is type *ContainerInfo_DockerInfo_PortMapping but is nil && this != nil")
	} else if this == nil {
		return fmt3.Errorf("that is type *ContainerInfo_DockerInfo_PortMappingbut is not nil && this == nil")
	}
	if this.HostPort != nil && that1.HostPort != nil {
		if *this.HostPort != *that1.HostPort {
			return fmt3.Errorf("HostPort this(%v) Not Equal that(%v)", *this.HostPort, *that1.HostPort)
		}
	} else if this.HostPort != nil {
		return fmt3.Errorf("this.HostPort == nil && that.HostPort != nil")
	} else if that1.HostPort != nil {
		return fmt3.Errorf("HostPort this(%v) Not Equal that(%v)", this.HostPort, that1.HostPort)
	}
	if this.ContainerPort != nil && that1.ContainerPort != nil {
		if *this.ContainerPort != *that1.ContainerPort {
			return fmt3.Errorf("ContainerPort this(%v) Not Equal that(%v)", *this.ContainerPort, *that1.ContainerPort)
		}
	} else if this.ContainerPort != nil {
		return fmt3.Errorf("this.ContainerPort == nil && that.ContainerPort != nil")
	} else if that1.ContainerPort != nil {
		return fmt3.Errorf("ContainerPort this(%v) Not Equal that(%v)", this.ContainerPort, that1.ContainerPort)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt3.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt3.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt3.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt3.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo_PortMapping) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostPort != nil && that1.HostPort != nil {
		if *this.HostPort != *that1.HostPort {
			return false
		}
	} else if this.HostPort != nil {
		return false
	} else if that1.HostPort != nil {
		return false
	}
	if this.ContainerPort != nil && that1.ContainerPort != nil {
		if *this.ContainerPort != *that1.ContainerPort {
			return false
		}
	} else if this.ContainerPort != nil {
		return false
	} else if that1.ContainerPort != nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
