/*
Copyright 2015 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// generated by hack/build-ui.sh; DO NOT EDIT

package ui

import (
	"fmt"
	"io/ioutil"
	"os"
	"path"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindata_file_info struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindata_file_info) Name() string {
	return fi.name
}
func (fi bindata_file_info) Size() int64 {
	return fi.size
}
func (fi bindata_file_info) Mode() os.FileMode {
	return fi.mode
}
func (fi bindata_file_info) ModTime() time.Time {
	return fi.modTime
}
func (fi bindata_file_info) IsDir() bool {
	return false
}
func (fi bindata_file_info) Sys() interface{} {
	return nil
}

var _www_app_assets_css_app_css = []byte(`.nav-back {
  width: 80px;
  font-size: 14px;
  padding-left: 14px;
  line-height: 15px;
}
.nav-back {
  /* :before */
  /* content: ""; */
  background-size: 14px 14px;
  background-repeat: no-repeat;
  display: block;
}
a {
  text-decoration: none;
}
.main-fab {
  position: absolute;
  z-index: 20;
  font-size: 30px;
  top: 100px;
  left: 24px;
  transform: scale(0.88, 0.88);
}
.md-breadcrumb {
  padding-left: 16px;
}
.md-table {
  min-width: 100%;
  border-collapse: collapse;
}
.md-table tbody tr:hover,
.md-table tbody tr:focus {
  cursor: pointer;
  background-color: rgba(63, 81, 181, 0.2);
}
.md-table-header {
  border-bottom: 1px solid #e6e6e6;
  color: #828282;
  text-align: left;
  font-size: 0.75em;
  font-weight: 700;
  padding: 16px 16px 16px 0;
}
.md-table-header a {
  text-decoration: none;
  color: inherit;
}
.md-table-caret {
  display: inline-block;
  vertical-align: middle;
}
.md-table-content {
  font-size: 0.8em;
  padding: 16px 16px 16px 0;
  height: 72px;
}
.md-table-td-more {
  max-width: 72px;
  width: 72px;
  padding: 16px;
}
.md-table-thumbs {
  max-width: 104px;
  width: 104px;
  padding: 16px 32px;
}
.md-table-thumbs div {
  overflow: hidden;
  width: 40px;
  height: 40px;
  border-radius: 20px;
  border: 1px solid rgba(0, 0, 0, 0.2);
  background-size: cover;
  box-shadow: 0 8px 10px rgba(0, 0, 0, 0.3);
  -webkit-box-shadow: 0 8px 10px rgba(0, 0, 0, 0.1);
}
.md-table-footer {
  height: 40px;
}
.md-table-count-info {
  line-height: 40px;
  font-size: .75em;
}
.md-table-footer-item {
  width: 40px;
  height: 40px;
  vertical-align: middle;
}
.md-table-active-page {
  font-weight: 700;
}
.bold {
  font-weight: 700;
}
.grey,
.gray {
  color: #888888;
}
md-input-container.md-default-theme .md-input {
  color: white;
  border-color: white;
  margin-top: 24px;
}
.dashboard-subnav {
  font-size: 0.9em;
  min-height: 38px;
  max-height: 38px;
  background-color: #09c1d1 !important;
}
.dashboard-subnav md-select.md-default-theme:focus .md-select-label {
  border-bottom: none;
  color: white;
}
.selectSubPages p {
  text-align: center;
  color: #fff;
}
.selectSubPages .md-default-theme .md-select-label.md-placeholder {
  color: #fff;
}
.selectSubPages .md-select-label {
  padding-top: 0px;
  font-size: 1em;
  line-height: 1em;
  border-bottom: none;
  padding-bottom: 0px;
}
.selectSubPages md-select {
  margin-top: 10px;
  margin-right: 80px;
  padding: 0px;
}
md-select-menu {
  max-height: none;
}
.md-toolbar-tools {
  padding-left: 8px;
  padding-right: 8px;
}
.md-toolbar-small {
  height: 38px;
  min-height: 38px;
}
.md-toolbar-tools-small {
  background-color: #09c1d1;
}
/* Begin kubernetes-ui Menu */
.kubernetes-ui-menu,
.kubernetes-ui-menu ul {
  list-style: none;
  padding: 0;
}
.kubernetes-ui-menu li {
  margin: 0;
}
.kubernetes-ui-menu > li {
  border-top: 1px solid rgba(0, 0, 0, 0.12);
}
.kubernetes-ui-menu .md-button {
  border-radius: 0;
  color: inherit;
  cursor: pointer;
  font-weight: 400;
  line-height: 40px;
  margin: 0;
  max-height: 40px;
  overflow: hidden;
  padding: 0px 16px;
  text-align: left;
  text-decoration: none;
  white-space: normal;
  width: 100%;
}
.kubernetes-ui-menu a.md-button {
  display: block;
}
.kubernetes-ui-menu button.md-button::-moz-focus-inner {
  padding: 0;
}
.kubernetes-ui-menu .md-button.active {
  color: #03a9f4;
}
.menu-heading {
  color: #888;
  display: block;
  font-size: inherit;
  font-weight: 500;
  line-height: 40px;
  margin: 0;
  padding: 0px 16px;
  text-align: left;
  width: 100%;
}
.kubernetes-ui-menu li.parentActive,
.kubernetes-ui-menu li.parentActive .menu-toggle-list {
  background-color: #f6f6f6;
}
.menu-toggle-list {
  background: #fff;
  max-height: 999px;
  overflow: hidden;
  position: relative;
  z-index: 1;
  -webkit-transition: 0.75s cubic-bezier(0.35, 0, 0.25, 1);
  -webkit-transition-property: max-height;
  -moz-transition: 0.75s cubic-bezier(0.35, 0, 0.25, 1);
  -moz-transition-property: max-height;
  transition: 0.75s cubic-bezier(0.35, 0, 0.25, 1);
  transition-property: max-height;
}
.menu-toggle-list.ng-hide {
  max-height: 0;
}
.kubernetes-ui-menu .menu-toggle-list a.md-button {
  display: block;
  padding: 0 16px 0 32px;
  text-transform: none;
}
.md-button-toggle .md-toggle-icon {
  background: transparent url(../img/icons/list_control_down.png) no-repeat center center;
  background-size: 100% auto;
  display: inline-block;
  height: 24px;
  margin: auto 0 auto auto;
  speak: none;
  width: 24px;
  transition: transform 0.3s ease-in-out;
  -webkit-transition: -webkit-transform 0.3s ease-in-out;
}
.md-button-toggle .md-toggle-icon.toggled {
  transform: rotate(180deg);
  -webkit-transform: rotate(180deg);
}
/* End kubernetes-ui Menu */
.menu-icon {
  background: none;
  border: none;
  margin-right: 16px;
  padding: 0;
}
.whiteframedemoBasicUsage md-whiteframe {
  background: #fff;
  margin: 2px;
  padding: 2px;
}
.tabsDefaultTabs {
  height: 100%;
  width: 100%;
  /*
   * Animation styles
   */
}
.tabsDefaultTabs .remove-tab {
  margin-bottom: 40px;
}
.tabsDefaultTabs .home-buttons .md-button {
  display: block;
  max-height: 30px;
}
.tabsDefaultTabs .home-buttons .md-button.add-tab {
  margin-top: 20px;
  max-height: 30px !important;
}
.tabsDefaultTabs .demo-tab {
  display: block;
  position: relative;
  background: white;
  border: 0px solid black;
  min-height: 0px;
  width: 100%;
}
.tabsDefaultTabs .tab0,
.tabsDefaultTabs .tab1,
.tabsDefaultTabs .tab2,
.tabsDefaultTabs .tab3 {
  background-color: #bbdefb;
}
.tabsDefaultTabs .md-header {
  background-color: #1976D2 !important;
}
.tabsDefaultTabs md-tab {
  color: #90caf9 !important;
}
.tabsDefaultTabs md-tab.active,
.tabsDefaultTabs md-tab:focus {
  color: white !important;
}
.tabsDefaultTabs md-tab[disabled] {
  opacity: 0.5;
}
.tabsDefaultTabs .md-header .md-ripple {
  border-color: #FFFF8D !important;
}
.tabsDefaultTabs md-tabs-ink-bar {
  background-color: #FFFF8D !important;
}
.tabsDefaultTabs .title {
  padding-top: 8px;
  padding-right: 8px;
  text-align: left;
  text-transform: uppercase;
  color: #888;
  margin-top: 24px;
}
.tabsDefaultTabs [layout-align] > * {
  margin-left: 8px;
}
.tabsDefaultTabs form > [layout] > * {
  margin-left: 8px;
}
.tabsDefaultTabs .long > input {
  width: 264px;
}
.menuBtn {
  background-color: transparent;
  border: none;
  height: 38px;
  margin: 16px;
  position: absolute;
  width: 36px;
}
md-toolbar h1 {
  font-size: 1.250em;
  font-weight: 400;
  margin: auto;
}
md-list .md-button {
  color: inherit;
  font-weight: 500;
  text-align: left;
  width: 100%;
}
.visuallyhidden {
  border: 0;
  clip: rect(0 0 0 0);
  height: 1px;
  margin: -1px;
  overflow: hidden;
  padding: 0;
  position: absolute;
  width: 1px;
}
md-list .md-button {
  color: inherit;
  font-weight: 500;
  text-align: left;
  width: 100%;
}
md-list .md-button.selected {
  color: #03a9f4;
}
#content {
  overflow: hidden;
}
#content md-content {
  padding-left: 0px;
  padding-right: 0px;
  padding-top: 0px;
}
#content .md-button.action {
  background-color: transparent;
  border: none;
  height: 38px;
  margin: 8px auto 16px 0;
  position: absolute;
  top: 10px;
  right: 25px;
  width: 36px;
}
#content img {
  display: block;
  height: auto;
  max-width: 500px;
}
.content-wrapper {
  position: relative;
}
.visuallyhidden {
  border: 0;
  clip: rect(0 0 0 0);
  height: 1px;
  margin: -1px;
  overflow: hidden;
  padding: 0;
  position: absolute;
  width: 1px;
}
md-toolbar h1 {
  font-size: 1.250em;
  font-weight: 400;
}
.menuBtn {
  background: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB2ZXJzaW9uPSIxLjEiIHg9IjBweCIgeT0iMHB4IiB3aWR0aD0iMjRweCIgaGVpZ2h0PSIyNHB4IiB2aWV3Qm94PSIwIDAgMjQgMjQiIGVuYWJsZS1iYWNrZ3JvdW5kPSJuZXcgMCAwIDI0IDI0IiB4bWw6c3BhY2U9InByZXNlcnZlIj4KPGcgaWQ9IkhlYWRlciI+CiAgICA8Zz4KICAgICAgICA8cmVjdCB4PSItNjE4IiB5PSItMjIzMiIgZmlsbD0ibm9uZSIgd2lkdGg9IjE0MDAiIGhlaWdodD0iMzYwMCIvPgogICAgPC9nPgo8L2c+CjxnIGlkPSJMYWJlbCI+CjwvZz4KPGcgaWQ9Ikljb24iPgogICAgPGc+CiAgICAgICAgPHJlY3QgZmlsbD0ibm9uZSIgd2lkdGg9IjI0IiBoZWlnaHQ9IjI0Ii8+CiAgICAgICAgPHBhdGggZD0iTTMsMThoMTh2LTJIM1YxOHogTTMsMTNoMTh2LTJIM1YxM3ogTTMsNnYyaDE4VjZIM3oiIHN0eWxlPSJmaWxsOiNmM2YzZjM7Ii8+CiAgICA8L2c+CjwvZz4KPGcgaWQ9IkdyaWQiIGRpc3BsYXk9Im5vbmUiPgogICAgPGcgZGlzcGxheT0iaW5saW5lIj4KICAgIDwvZz4KPC9nPgo8L3N2Zz4=) no-repeat center center;
}
.actionBtn {
  background: url(data:image/svg+xml;charset=utf-8;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzNiIgaGVpZ2h0PSIzNiIgdmlld0JveD0iMCAwIDM2IDM2Ij4NCiAgICA8cGF0aCBkPSJNMCAwaDM2djM2aC0zNnoiIGZpbGw9Im5vbmUiLz4NCiAgICA8cGF0aCBkPSJNNCAyN2gyOHYtM2gtMjh2M3ptMC04aDI4di0zaC0yOHYzem0wLTExdjNoMjh2LTNoLTI4eiIvPg0KPC9zdmc+) no-repeat center center;
}
.kubernetes-ui-logo {
  background-image: url("../img/kubernetes.svg");
  background-size: 40px 40px;
  width: 40px;
  height: 40px;
}
.kubernetes-ui-text {
  line-height: 40px;
  vertical-align: middle;
  padding: 2px;
}
.dashboard .body-wrapper {
  padding: 25px;
}
.dashboard [flex-align-self="end"] {
  -webkit-align-self: flex-end;
  -ms-flex-align-self: end;
  align-self: flex-end;
}
.dashboard .back {
  font-size: 18px;
  line-height: 27px;
  margin-bottom: 30px;
}
.dashboard .heading {
  font-size: 18px;
  line-height: 21px;
  color: #222222;
  margin-bottom: 25px;
}
.dashboard .heading .label {
  color: #777777;
}
.dashboard .clear-bg {
  background-color: transparent;
}
.dashboard .list-pods .pod-group {
  margin: 25px;
}
.dashboard .list-pods .pod-group md-grid-list {
  margin-top: 50px;
  color: white;
}
.dashboard .list-pods .pod-group md-grid-list figcaption {
  width: 100%;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-header {
  padding-left: 10px;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-header .labels {
  width: 100%;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile {
  transition: all 700ms ease-in 50ms;
}
.dashboard .list-pods .pod-group md-grid-list .inner-box {
  padding-left: 10px;
  padding-right: 10px;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-footer {
  background: rgba(0, 0, 0, 0.5);
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-footer .pod-title {
  margin-left: 10px;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-footer .pod-host {
  text-align: right;
  padding-right: 15px;
}
.dashboard .list-pods .pod-group md-grid-list md-grid-tile-footer a {
  color: white;
}
.dashboard .list-pods .pod-group md-grid-list .restarts {
  width: 100%;
  text-align: right;
  padding-right: 10px;
}
.dashboard .list-pods .pod-group md-grid-list .restarts .restart-button,
.dashboard .list-pods .pod-group md-grid-list .restarts .restart-button:not([disabled]):hover,
.dashboard .list-pods .pod-group md-grid-list .restarts .restart-button:not([disabled]):focus,
.dashboard .list-pods .pod-group md-grid-list .restarts .restart-button:hover,
.dashboard .list-pods .pod-group md-grid-list .restarts .restart-button:focus {
  background-color: #ff1744;
  width: 30px;
  height: 30px;
}
.dashboard .list-pods .gray {
  background: #f5f5f5;
}
.dashboard .list-pods .dark-overlay {
  background-color: #292935;
  opacity: 0.5;
}
.dashboard .list-pods .light-overlay {
  background-color: #FFFFFF;
  opacity: 0.2;
}
.dashboard .list-pods .color-1 {
  background-color: #2962ff;
  fill: #2962ff;
  stroke: #2962ff;
}
.dashboard .list-pods md-grid-list.list-color-1 md-grid-tile.colored {
  background-color: #2962ff;
}
.dashboard .list-pods .color-2 {
  background-color: #aa00ff;
  fill: #aa00ff;
  stroke: #aa00ff;
}
.dashboard .list-pods md-grid-list.list-color-2 md-grid-tile.colored {
  background-color: #aa00ff;
}
.dashboard .list-pods .color-3 {
  background-color: #00c853;
  fill: #00c853;
  stroke: #00c853;
}
.dashboard .list-pods md-grid-list.list-color-3 md-grid-tile.colored {
  background-color: #00c853;
}
.dashboard .list-pods .color-4 {
  background-color: #304ffe;
  fill: #304ffe;
  stroke: #304ffe;
}
.dashboard .list-pods md-grid-list.list-color-4 md-grid-tile.colored {
  background-color: #304ffe;
}
.dashboard .list-pods .color-5 {
  background-color: #0091ea;
  fill: #0091ea;
  stroke: #0091ea;
}
.dashboard .list-pods md-grid-list.list-color-5 md-grid-tile.colored {
  background-color: #0091ea;
}
.dashboard .list-pods .color-6 {
  background-color: #ff6d00;
  fill: #ff6d00;
  stroke: #ff6d00;
}
.dashboard .list-pods md-grid-list.list-color-6 md-grid-tile.colored {
  background-color: #ff6d00;
}
.dashboard .list-pods .color-7 {
  background-color: #00bfa5;
  fill: #00bfa5;
  stroke: #00bfa5;
}
.dashboard .list-pods md-grid-list.list-color-7 md-grid-tile.colored {
  background-color: #00bfa5;
}
.dashboard .list-pods .color-8 {
  background-color: #c51162;
  fill: #c51162;
  stroke: #c51162;
}
.dashboard .list-pods md-grid-list.list-color-8 md-grid-tile.colored {
  background-color: #c51162;
}
.dashboard .list-pods .color-9 {
  background-color: #64dd17;
  fill: #64dd17;
  stroke: #64dd17;
}
.dashboard .list-pods md-grid-list.list-color-9 md-grid-tile.colored {
  background-color: #64dd17;
}
.dashboard .list-pods .color-10 {
  background-color: #6200ea;
  fill: #6200ea;
  stroke: #6200ea;
}
.dashboard .list-pods md-grid-list.list-color-10 md-grid-tile.colored {
  background-color: #6200ea;
}
.dashboard .list-pods .color-11 {
  background-color: #ffd600;
  fill: #ffd600;
  stroke: #ffd600;
}
.dashboard .list-pods md-grid-list.list-color-11 md-grid-tile.colored {
  background-color: #ffd600;
}
.dashboard .list-pods .color-12 {
  background-color: #00b8d4;
  fill: #00b8d4;
  stroke: #00b8d4;
}
.dashboard .list-pods md-grid-list.list-color-12 md-grid-tile.colored {
  background-color: #00b8d4;
}
.dashboard .list-pods .color-13 {
  background-color: #ffab00;
  fill: #ffab00;
  stroke: #ffab00;
}
.dashboard .list-pods md-grid-list.list-color-13 md-grid-tile.colored {
  background-color: #ffab00;
}
.dashboard .list-pods .color-14 {
  background-color: #dd2c00;
  fill: #dd2c00;
  stroke: #dd2c00;
}
.dashboard .list-pods md-grid-list.list-color-14 md-grid-tile.colored {
  background-color: #dd2c00;
}
.dashboard .list-pods .color-15 {
  background-color: #2979ff;
  fill: #2979ff;
  stroke: #2979ff;
}
.dashboard .list-pods md-grid-list.list-color-15 md-grid-tile.colored {
  background-color: #2979ff;
}
.dashboard .list-pods .color-16 {
  background-color: #d500f9;
  fill: #d500f9;
  stroke: #d500f9;
}
.dashboard .list-pods md-grid-list.list-color-16 md-grid-tile.colored {
  background-color: #d500f9;
}
.dashboard .list-pods .color-17 {
  background-color: #00e676;
  fill: #00e676;
  stroke: #00e676;
}
.dashboard .list-pods md-grid-list.list-color-17 md-grid-tile.colored {
  background-color: #00e676;
}
.dashboard .list-pods .color-18 {
  background-color: #3d5afe;
  fill: #3d5afe;
  stroke: #3d5afe;
}
.dashboard .list-pods md-grid-list.list-color-18 md-grid-tile.colored {
  background-color: #3d5afe;
}
.dashboard .list-pods .color-19 {
  background-color: #00b0ff;
  fill: #00b0ff;
  stroke: #00b0ff;
}
.dashboard .list-pods md-grid-list.list-color-19 md-grid-tile.colored {
  background-color: #00b0ff;
}
.dashboard .list-pods .color-20 {
  background-color: #ff9100;
  fill: #ff9100;
  stroke: #ff9100;
}
.dashboard .list-pods md-grid-list.list-color-20 md-grid-tile.colored {
  background-color: #ff9100;
}
.dashboard .list-pods .color-21 {
  background-color: #1de9b6;
  fill: #1de9b6;
  stroke: #1de9b6;
}
.dashboard .list-pods md-grid-list.list-color-21 md-grid-tile.colored {
  background-color: #1de9b6;
}
.dashboard .list-pods .color-22 {
  background-color: #f50057;
  fill: #f50057;
  stroke: #f50057;
}
.dashboard .list-pods md-grid-list.list-color-22 md-grid-tile.colored {
  background-color: #f50057;
}
.dashboard .list-pods .color-23 {
  background-color: #76ff03;
  fill: #76ff03;
  stroke: #76ff03;
}
.dashboard .list-pods md-grid-list.list-color-23 md-grid-tile.colored {
  background-color: #76ff03;
}
.dashboard .list-pods .color-24 {
  background-color: #651fff;
  fill: #651fff;
  stroke: #651fff;
}
.dashboard .list-pods md-grid-list.list-color-24 md-grid-tile.colored {
  background-color: #651fff;
}
.dashboard .list-pods .color-25 {
  background-color: #ffea00;
  fill: #ffea00;
  stroke: #ffea00;
}
.dashboard .list-pods md-grid-list.list-color-25 md-grid-tile.colored {
  background-color: #ffea00;
}
.dashboard .list-pods .color-26 {
  background-color: #00e5ff;
  fill: #00e5ff;
  stroke: #00e5ff;
}
.dashboard .list-pods md-grid-list.list-color-26 md-grid-tile.colored {
  background-color: #00e5ff;
}
.dashboard .list-pods .color-27 {
  background-color: #ffc400;
  fill: #ffc400;
  stroke: #ffc400;
}
.dashboard .list-pods md-grid-list.list-color-27 md-grid-tile.colored {
  background-color: #ffc400;
}
.dashboard .list-pods .color-28 {
  background-color: #ff3d00;
  fill: #ff3d00;
  stroke: #ff3d00;
}
.dashboard .list-pods md-grid-list.list-color-28 md-grid-tile.colored {
  background-color: #ff3d00;
}
.dashboard .list-pods .color-29 {
  background-color: #448aff;
  fill: #448aff;
  stroke: #448aff;
}
.dashboard .list-pods md-grid-list.list-color-29 md-grid-tile.colored {
  background-color: #448aff;
}
.dashboard .list-pods .color-30 {
  background-color: #e040fb;
  fill: #e040fb;
  stroke: #e040fb;
}
.dashboard .list-pods md-grid-list.list-color-30 md-grid-tile.colored {
  background-color: #e040fb;
}
.dashboard .list-pods .color-31 {
  background-color: #69f0ae;
  fill: #69f0ae;
  stroke: #69f0ae;
}
.dashboard .list-pods md-grid-list.list-color-31 md-grid-tile.colored {
  background-color: #69f0ae;
}
.dashboard .list-pods .color-32 {
  background-color: #536dfe;
  fill: #536dfe;
  stroke: #536dfe;
}
.dashboard .list-pods md-grid-list.list-color-32 md-grid-tile.colored {
  background-color: #536dfe;
}
.dashboard .list-pods .color-33 {
  background-color: #40c4ff;
  fill: #40c4ff;
  stroke: #40c4ff;
}
.dashboard .list-pods md-grid-list.list-color-33 md-grid-tile.colored {
  background-color: #40c4ff;
}
.dashboard .list-pods .color-34 {
  background-color: #ffab40;
  fill: #ffab40;
  stroke: #ffab40;
}
.dashboard .list-pods md-grid-list.list-color-34 md-grid-tile.colored {
  background-color: #ffab40;
}
.dashboard .list-pods .color-35 {
  background-color: #64ffda;
  fill: #64ffda;
  stroke: #64ffda;
}
.dashboard .list-pods md-grid-list.list-color-35 md-grid-tile.colored {
  background-color: #64ffda;
}
.dashboard .list-pods .color-36 {
  background-color: #ff4081;
  fill: #ff4081;
  stroke: #ff4081;
}
.dashboard .list-pods md-grid-list.list-color-36 md-grid-tile.colored {
  background-color: #ff4081;
}
.dashboard .list-pods .color-37 {
  background-color: #b2ff59;
  fill: #b2ff59;
  stroke: #b2ff59;
}
.dashboard .list-pods md-grid-list.list-color-37 md-grid-tile.colored {
  background-color: #b2ff59;
}
.dashboard .list-pods .color-38 {
  background-color: #7c4dff;
  fill: #7c4dff;
  stroke: #7c4dff;
}
.dashboard .list-pods md-grid-list.list-color-38 md-grid-tile.colored {
  background-color: #7c4dff;
}
.dashboard .list-pods .color-39 {
  background-color: #ffff00;
  fill: #ffff00;
  stroke: #ffff00;
}
.dashboard .list-pods md-grid-list.list-color-39 md-grid-tile.colored {
  background-color: #ffff00;
}
.dashboard .list-pods .color-40 {
  background-color: #18ffff;
  fill: #18ffff;
  stroke: #18ffff;
}
.dashboard .list-pods md-grid-list.list-color-40 md-grid-tile.colored {
  background-color: #18ffff;
}
.dashboard .list-pods .color-41 {
  background-color: #ffd740;
  fill: #ffd740;
  stroke: #ffd740;
}
.dashboard .list-pods md-grid-list.list-color-41 md-grid-tile.colored {
  background-color: #ffd740;
}
.dashboard .list-pods .color-42 {
  background-color: #ff6e40;
  fill: #ff6e40;
  stroke: #ff6e40;
}
.dashboard .list-pods md-grid-list.list-color-42 md-grid-tile.colored {
  background-color: #ff6e40;
}
.dashboard .list-pods .color-warning {
  background-color: #ff9800 !important;
  border-color: #ff9800 !important;
  fill: #ff9800 !important;
  stroke: #ff9800 !important;
}
.dashboard .list-pods .color-critical {
  background-color: #f44336 !important;
  border-color: #f44336 !important;
  fill: #f44336 !important;
  stroke: #f44336 !important;
}
.dashboard .list-pods .status-waiting {
  background-color: #2e2e3b !important;
  border-color: #dad462 !important;
  border-width: 2px !important;
  border-style: solid !important;
}
.dashboard .list-pods .status-terminated,
.dashboard .list-pods .status-unknown {
  background-color: #ff1744 !important;
  border-color: #e3002c !important;
  border-width: 1px !important;
  border-style: solid !important;
}
.dashboard .dash-table {
  min-width: 100%;
  border-collapse: collapse;
}
.dashboard .dash-table tbody tr:hover:not(.no-link),
.dashboard .dash-table tbody tr:focus:not(.no-link) {
  cursor: pointer;
  background-color: rgba(63, 81, 181, 0.2);
}
.dashboard .dash-table .dash-table-header {
  border-bottom: 1px solid #e6e6e6;
  color: #828282;
  text-align: left;
  font-size: 0.75em;
  font-weight: 700;
  padding: 16px 16px 16px 0;
}
.dashboard .dash-table .dash-table-header a {
  text-decoration: none;
  color: inherit;
}
.dashboard .dash-table .dash-table-caret {
  display: inline-block;
  vertical-align: middle;
}
.dashboard .dash-table .dash-table-content {
  font-size: 0.8em;
  padding: 16px 16px 16px 0;
  height: 72px;
}
.dashboard .dash-table .dash-table-td-more {
  max-width: 72px;
  width: 72px;
  padding: 16px;
}
.dashboard .dash-table .dash-table-thumbs {
  max-width: 104px;
  width: 104px;
  padding: 16px 32px;
}
.dashboard .dash-table .dash-table-thumbs div {
  overflow: hidden;
  width: 40px;
  height: 40px;
  border-radius: 20px;
  border: 1px solid rgba(0, 0, 0, 0.2);
  background-size: cover;
  box-shadow: 0 8px 10px rgba(0, 0, 0, 0.3);
  -webkit-box-shadow: 0 8px 10px rgba(0, 0, 0, 0.1);
}
.dashboard .dash-table .dash-table-footer {
  height: 40px;
}
.dashboard .dash-table .dash-table-count-info {
  line-height: 40px;
  font-size: .75em;
}
.dashboard .dash-table .dash-table-footer-item {
  width: 40px;
  height: 40px;
  vertical-align: middle;
}
.dashboard .dash-table .dash-table-active-page {
  font-weight: 700;
}
.dashboard .dash-table .bold {
  font-weight: 700;
}
.dashboard .dash-table .grey {
  color: grey;
}
.dashboard .dash-table md-input-container.md-default-theme .md-input {
  color: white;
  border-color: white;
  margin-top: 24px;
}
.dashboard .server-overview .dark-overlay {
  background-color: #292935;
  opacity: 0.5;
}
.dashboard .server-overview .light-overlay {
  background-color: #FFFFFF;
  opacity: 0.2;
}
.dashboard .server-overview .color-1 {
  background-color: #2962ff;
  fill: #2962ff;
  stroke: #2962ff;
}
.dashboard .server-overview md-grid-list.list-color-1 md-grid-tile.colored {
  background-color: #2962ff;
}
.dashboard .server-overview .color-2 {
  background-color: #aa00ff;
  fill: #aa00ff;
  stroke: #aa00ff;
}
.dashboard .server-overview md-grid-list.list-color-2 md-grid-tile.colored {
  background-color: #aa00ff;
}
.dashboard .server-overview .color-3 {
  background-color: #00c853;
  fill: #00c853;
  stroke: #00c853;
}
.dashboard .server-overview md-grid-list.list-color-3 md-grid-tile.colored {
  background-color: #00c853;
}
.dashboard .server-overview .color-4 {
  background-color: #304ffe;
  fill: #304ffe;
  stroke: #304ffe;
}
.dashboard .server-overview md-grid-list.list-color-4 md-grid-tile.colored {
  background-color: #304ffe;
}
.dashboard .server-overview .color-5 {
  background-color: #0091ea;
  fill: #0091ea;
  stroke: #0091ea;
}
.dashboard .server-overview md-grid-list.list-color-5 md-grid-tile.colored {
  background-color: #0091ea;
}
.dashboard .server-overview .color-6 {
  background-color: #ff6d00;
  fill: #ff6d00;
  stroke: #ff6d00;
}
.dashboard .server-overview md-grid-list.list-color-6 md-grid-tile.colored {
  background-color: #ff6d00;
}
.dashboard .server-overview .color-7 {
  background-color: #00bfa5;
  fill: #00bfa5;
  stroke: #00bfa5;
}
.dashboard .server-overview md-grid-list.list-color-7 md-grid-tile.colored {
  background-color: #00bfa5;
}
.dashboard .server-overview .color-8 {
  background-color: #c51162;
  fill: #c51162;
  stroke: #c51162;
}
.dashboard .server-overview md-grid-list.list-color-8 md-grid-tile.colored {
  background-color: #c51162;
}
.dashboard .server-overview .color-9 {
  background-color: #64dd17;
  fill: #64dd17;
  stroke: #64dd17;
}
.dashboard .server-overview md-grid-list.list-color-9 md-grid-tile.colored {
  background-color: #64dd17;
}
.dashboard .server-overview .color-10 {
  background-color: #6200ea;
  fill: #6200ea;
  stroke: #6200ea;
}
.dashboard .server-overview md-grid-list.list-color-10 md-grid-tile.colored {
  background-color: #6200ea;
}
.dashboard .server-overview .color-11 {
  background-color: #ffd600;
  fill: #ffd600;
  stroke: #ffd600;
}
.dashboard .server-overview md-grid-list.list-color-11 md-grid-tile.colored {
  background-color: #ffd600;
}
.dashboard .server-overview .color-12 {
  background-color: #00b8d4;
  fill: #00b8d4;
  stroke: #00b8d4;
}
.dashboard .server-overview md-grid-list.list-color-12 md-grid-tile.colored {
  background-color: #00b8d4;
}
.dashboard .server-overview .color-13 {
  background-color: #ffab00;
  fill: #ffab00;
  stroke: #ffab00;
}
.dashboard .server-overview md-grid-list.list-color-13 md-grid-tile.colored {
  background-color: #ffab00;
}
.dashboard .server-overview .color-14 {
  background-color: #dd2c00;
  fill: #dd2c00;
  stroke: #dd2c00;
}
.dashboard .server-overview md-grid-list.list-color-14 md-grid-tile.colored {
  background-color: #dd2c00;
}
.dashboard .server-overview .color-15 {
  background-color: #2979ff;
  fill: #2979ff;
  stroke: #2979ff;
}
.dashboard .server-overview md-grid-list.list-color-15 md-grid-tile.colored {
  background-color: #2979ff;
}
.dashboard .server-overview .color-16 {
  background-color: #d500f9;
  fill: #d500f9;
  stroke: #d500f9;
}
.dashboard .server-overview md-grid-list.list-color-16 md-grid-tile.colored {
  background-color: #d500f9;
}
.dashboard .server-overview .color-17 {
  background-color: #00e676;
  fill: #00e676;
  stroke: #00e676;
}
.dashboard .server-overview md-grid-list.list-color-17 md-grid-tile.colored {
  background-color: #00e676;
}
.dashboard .server-overview .color-18 {
  background-color: #3d5afe;
  fill: #3d5afe;
  stroke: #3d5afe;
}
.dashboard .server-overview md-grid-list.list-color-18 md-grid-tile.colored {
  background-color: #3d5afe;
}
.dashboard .server-overview .color-19 {
  background-color: #00b0ff;
  fill: #00b0ff;
  stroke: #00b0ff;
}
.dashboard .server-overview md-grid-list.list-color-19 md-grid-tile.colored {
  background-color: #00b0ff;
}
.dashboard .server-overview .color-20 {
  background-color: #ff9100;
  fill: #ff9100;
  stroke: #ff9100;
}
.dashboard .server-overview md-grid-list.list-color-20 md-grid-tile.colored {
  background-color: #ff9100;
}
.dashboard .server-overview .color-21 {
  background-color: #1de9b6;
  fill: #1de9b6;
  stroke: #1de9b6;
}
.dashboard .server-overview md-grid-list.list-color-21 md-grid-tile.colored {
  background-color: #1de9b6;
}
.dashboard .server-overview .color-22 {
  background-color: #f50057;
  fill: #f50057;
  stroke: #f50057;
}
.dashboard .server-overview md-grid-list.list-color-22 md-grid-tile.colored {
  background-color: #f50057;
}
.dashboard .server-overview .color-23 {
  background-color: #76ff03;
  fill: #76ff03;
  stroke: #76ff03;
}
.dashboard .server-overview md-grid-list.list-color-23 md-grid-tile.colored {
  background-color: #76ff03;
}
.dashboard .server-overview .color-24 {
  background-color: #651fff;
  fill: #651fff;
  stroke: #651fff;
}
.dashboard .server-overview md-grid-list.list-color-24 md-grid-tile.colored {
  background-color: #651fff;
}
.dashboard .server-overview .color-25 {
  background-color: #ffea00;
  fill: #ffea00;
  stroke: #ffea00;
}
.dashboard .server-overview md-grid-list.list-color-25 md-grid-tile.colored {
  background-color: #ffea00;
}
.dashboard .server-overview .color-26 {
  background-color: #00e5ff;
  fill: #00e5ff;
  stroke: #00e5ff;
}
.dashboard .server-overview md-grid-list.list-color-26 md-grid-tile.colored {
  background-color: #00e5ff;
}
.dashboard .server-overview .color-27 {
  background-color: #ffc400;
  fill: #ffc400;
  stroke: #ffc400;
}
.dashboard .server-overview md-grid-list.list-color-27 md-grid-tile.colored {
  background-color: #ffc400;
}
.dashboard .server-overview .color-28 {
  background-color: #ff3d00;
  fill: #ff3d00;
  stroke: #ff3d00;
}
.dashboard .server-overview md-grid-list.list-color-28 md-grid-tile.colored {
  background-color: #ff3d00;
}
.dashboard .server-overview .color-29 {
  background-color: #448aff;
  fill: #448aff;
  stroke: #448aff;
}
.dashboard .server-overview md-grid-list.list-color-29 md-grid-tile.colored {
  background-color: #448aff;
}
.dashboard .server-overview .color-30 {
  background-color: #e040fb;
  fill: #e040fb;
  stroke: #e040fb;
}
.dashboard .server-overview md-grid-list.list-color-30 md-grid-tile.colored {
  background-color: #e040fb;
}
.dashboard .server-overview .color-31 {
  background-color: #69f0ae;
  fill: #69f0ae;
  stroke: #69f0ae;
}
.dashboard .server-overview md-grid-list.list-color-31 md-grid-tile.colored {
  background-color: #69f0ae;
}
.dashboard .server-overview .color-32 {
  background-color: #536dfe;
  fill: #536dfe;
  stroke: #536dfe;
}
.dashboard .server-overview md-grid-list.list-color-32 md-grid-tile.colored {
  background-color: #536dfe;
}
.dashboard .server-overview .color-33 {
  background-color: #40c4ff;
  fill: #40c4ff;
  stroke: #40c4ff;
}
.dashboard .server-overview md-grid-list.list-color-33 md-grid-tile.colored {
  background-color: #40c4ff;
}
.dashboard .server-overview .color-34 {
  background-color: #ffab40;
  fill: #ffab40;
  stroke: #ffab40;
}
.dashboard .server-overview md-grid-list.list-color-34 md-grid-tile.colored {
  background-color: #ffab40;
}
.dashboard .server-overview .color-35 {
  background-color: #64ffda;
  fill: #64ffda;
  stroke: #64ffda;
}
.dashboard .server-overview md-grid-list.list-color-35 md-grid-tile.colored {
  background-color: #64ffda;
}
.dashboard .server-overview .color-36 {
  background-color: #ff4081;
  fill: #ff4081;
  stroke: #ff4081;
}
.dashboard .server-overview md-grid-list.list-color-36 md-grid-tile.colored {
  background-color: #ff4081;
}
.dashboard .server-overview .color-37 {
  background-color: #b2ff59;
  fill: #b2ff59;
  stroke: #b2ff59;
}
.dashboard .server-overview md-grid-list.list-color-37 md-grid-tile.colored {
  background-color: #b2ff59;
}
.dashboard .server-overview .color-38 {
  background-color: #7c4dff;
  fill: #7c4dff;
  stroke: #7c4dff;
}
.dashboard .server-overview md-grid-list.list-color-38 md-grid-tile.colored {
  background-color: #7c4dff;
}
.dashboard .server-overview .color-39 {
  background-color: #ffff00;
  fill: #ffff00;
  stroke: #ffff00;
}
.dashboard .server-overview md-grid-list.list-color-39 md-grid-tile.colored {
  background-color: #ffff00;
}
.dashboard .server-overview .color-40 {
  background-color: #18ffff;
  fill: #18ffff;
  stroke: #18ffff;
}
.dashboard .server-overview md-grid-list.list-color-40 md-grid-tile.colored {
  background-color: #18ffff;
}
.dashboard .server-overview .color-41 {
  background-color: #ffd740;
  fill: #ffd740;
  stroke: #ffd740;
}
.dashboard .server-overview md-grid-list.list-color-41 md-grid-tile.colored {
  background-color: #ffd740;
}
.dashboard .server-overview .color-42 {
  background-color: #ff6e40;
  fill: #ff6e40;
  stroke: #ff6e40;
}
.dashboard .server-overview md-grid-list.list-color-42 md-grid-tile.colored {
  background-color: #ff6e40;
}
.dashboard .server-overview .color-warning {
  background-color: #ff9800 !important;
  border-color: #ff9800 !important;
  fill: #ff9800 !important;
  stroke: #ff9800 !important;
}
.dashboard .server-overview .color-critical {
  background-color: #f44336 !important;
  border-color: #f44336 !important;
  fill: #f44336 !important;
  stroke: #f44336 !important;
}
.dashboard .server-overview .status-waiting {
  background-color: #2e2e3b !important;
  border-color: #dad462 !important;
  border-width: 2px !important;
  border-style: solid !important;
}
.dashboard .server-overview .status-terminated,
.dashboard .server-overview .status-unknown {
  background-color: #ff1744 !important;
  border-color: #e3002c !important;
  border-width: 1px !important;
  border-style: solid !important;
}
.dashboard .server-overview .color-1 {
  background-color: #512DA8;
  border-color: #512DA8;
  fill: #512DA8;
  stroke: #512DA8;
}
.dashboard .server-overview .color-2 {
  background-color: #9C27B0;
  border-color: #9C27B0;
  fill: #9C27B0;
  stroke: #9C27B0;
}
.dashboard .server-overview .color-3 {
  background-color: #00BCD4;
  border-color: #00BCD4;
  fill: #00BCD4;
  stroke: #00BCD4;
}
.dashboard .server-overview .color-max-1 {
  background-color: #c5b6eb;
  border-color: #c5b6eb;
  fill: #c5b6eb;
}
.dashboard .server-overview .color-max-2 {
  background-color: #e6b5ee;
  border-color: #e6b5ee;
  fill: #e6b5ee;
}
.dashboard .server-overview .color-max-3 {
  background-color: #a1f4ff;
  border-color: #a1f4ff;
  fill: #a1f4ff;
}
.dashboard .server-overview .color-max-warning {
  background-color: #ffd699 !important;
  border-color: #ffd699 !important;
  fill: #ffd699 !important;
}
.dashboard .server-overview .color-max-critical {
  background-color: #fccbc7 !important;
  border-color: #fccbc7 !important;
  fill: #fccbc7 !important;
}
.dashboard .server-overview .max_tick_arc {
  stroke: #FFF !important;
}
.dashboard .server-overview .concentricchart .bg-circle {
  background: #F9F9F9;
  fill: #F9F9F9;
  stroke: #FFFFFF;
  stroke-width: 1px;
}
.dashboard .server-overview .concentricchart text {
  font-size: 12px;
  font-family: 'Roboto', sans-serif;
}
.dashboard .server-overview .concentricchart .value_group {
  fill: white;
}
.dashboard .server-overview .concentricchart .legend_group rect {
  opacity: 0.8;
}
.dashboard .server-overview svg.legend {
  height: 115px;
}
.dashboard .server-overview svg.legend text {
  font-size: 12px;
  font-family: 'Roboto', sans-serif;
}
.dashboard .server-overview svg.legend .hostName {
  font-size: 16px;
}
.dashboard .server-overview .minion-name {
  text-align: center;
  vertical-align: bottom;
  width: 100%;
}
.dashboard .server-overview .chart_area {
  width: 325px;
  height: 425px;
}
.dashboard .groups {
  font-size: 13px;
}
.dashboard .groups .header {
  line-height: 21px;
}
.dashboard .groups .header a {
  padding-left: 5px;
  padding-right: 5px;
}
.dashboard .groups .header .selector-area .filter-text {
  font-size: 13px;
  margin-left: 10px;
}
.dashboard .groups .header .selector-area .cancel-button {
  width: 18px;
  height: 18px;
  padding: 0;
}
.dashboard .groups .header .selector-area .cancel-button:focus,
.dashboard .groups .header .selector-area .cancel-button:hover {
  background-color: none !important;
}
.dashboard .groups .header .selector-area .cancel-icon {
  width: 15px;
  height: 15px;
  fill: #777777;
}
.dashboard .groups .select-group-by {
  min-width: 110px;
  margin-left: 10px;
  margin-right: 40px;
}
.dashboard .groups .select-group-by .md-select-label {
  padding-top: 6px;
  font-size: 13px;
}
.dashboard .groups .group-item {
  padding-top: 20px;
}
.dashboard .groups .group-item .filter-button {
  height: 18px;
  width: 18px;
}
.dashboard .groups .group-item .filter-button .filter-icon {
  width: 18px;
  height: 18px;
}
.dashboard .groups .icon-area {
  min-width: 34px;
}
.dashboard .groups .icon-area .group-icon {
  border-radius: 21px;
  width: 21px;
  height: 21px;
}
.dashboard .groups .group-main-area .subtype {
  line-height: 21px;
}
.dashboard .groups md-divider {
  margin-top: 40px;
  margin-bottom: 30px;
}
.dashboard .groups .group-name {
  padding-top: 10px;
}
.dashboard .groups .selectFilter {
  padding-top: 10px;
  margin-right: 30px;
}
.dashboard .groups .selectFilter .md-select-label {
  border-bottom: none !important;
  width: 17px;
  min-width: 17px;
  padding-right: 0;
}
.dashboard .groups md-select-menu {
  min-height: 40px;
  max-height: 40px;
}
.dashboard .groups .group-link-area {
  padding-left: 15px;
  padding-bottom: 15px;
}
.dashboard .groups .group-link-area button {
  line-height: 12px;
}
.dashboard .groups .group-type-circle {
  width: 21px;
  height: 21px;
}
.dashboard .groups md-select {
  margin-top: 0px;
}
.dashboard .detail {
  color: #222222;
}
.dashboard .detail .back {
  font-size: 18px;
  line-height: 27px;
  margin-bottom: 30px;
}
.dashboard .detail .heading {
  font-size: 18px;
  line-height: 21px;
  color: #222222;
  margin-bottom: 25px;
}
.dashboard .detail .heading .label {
  color: #777777;
}
.dashboard .detail td.name {
  font-size: 14px;
  color: #222222;
  line-height: 24px;
}
.dashboard .detail td.value {
  margin-left: 50px;
  font-size: 14px;
  color: #888888;
  line-height: 24px;
}
.dashboard .detail .containerTable td {
  padding-right: 20px;
}
.dashboard .align-top tbody {
  vertical-align: top;
}
`)

func www_app_assets_css_app_css_bytes() ([]byte, error) {
	return _www_app_assets_css_app_css, nil
}

func www_app_assets_css_app_css() (*asset, error) {
	bytes, err := www_app_assets_css_app_css_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/css/app.css", size: 37050, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_docarrow_png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00!\x00\x00\x00\"\b\x06\x00\x00\x00\xd1p\xb0\xc1\x00\x00\x00\x04sBIT\b\b\b\b|\bd\x88\x00\x00\x00\tpHYs\x00\x00\x15\xfd\x00\x00\x15\xfd\x01\xcdpQa\x00\x00\x00\x1ctEXtSoftware\x00Adobe Fireworks CS6輲\x8c\x00\x00\x00\xefIDATX\x85\xd5\xd71\x0e\xc20\f\x05І\xebq\x0568\x01\x8c\x1c\x80\xeep\x1aV\x18Y`\x05\xc1\x19\x10e\x81\xe13\x05UU\xab\xd8\xf1\xb7\xa2~\xc9K\x87\xf4)\x8e\xea4\x00\xa8JgR\x1aPUcB\x84\x10\xfeU\xef.X\xac\x8eh?KU2\x00\x92\x15\xb3ٞ\x01\x00\xaf\xe6\x83\xf9\xf2 >L\xc9\xf5\xa5\x88\b\x88\xd1@(\x88u}B_\xa4\x10\nb:\xdb\xe3\xf6xfCh\xed\xb0@h\b\v\x84\x8aȅ\xd0\x119\x10\x17\x84\x16\xe2\x86\xd0@\\\x11R\x88;\x82\x01\xa1 \xac\x10\xea(\x1f\xf2&')\xab\x1d\xd7{\xff.4\xef\xaf\u007f;\xac\x003B\x02\x90\xec\xb6\xe9c%\x01\xb8!4\x00\x17\x84\x16@G\xe4\x00\xa8\x88\\\x00\ra\x01\xd0\x10C\x17]\t\x80ڎ\xee\x95_\n\xa0\"\xda\x10\r\x80\x8e\x88\x10\r@\x82\bݗ\x94\xc8x\xfeʽ\xf3\x03\xba\v\x18\x94\x12\x8b\x872\x00\x00\x00\x00IEND\xaeB`\x82")

func www_app_assets_img_docarrow_png_bytes() ([]byte, error) {
	return _www_app_assets_img_docarrow_png, nil
}

func www_app_assets_img_docarrow_png() (*asset, error) {
	bytes, err := www_app_assets_img_docarrow_png_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/docArrow.png", size: 373, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_ic_arrow_drop_down_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
    <path d="M7 10l5 5 5-5z"/>
    <path d="M0 0h24v24h-24z" fill="none"/>
</svg>
`)

func www_app_assets_img_ic_arrow_drop_down_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_ic_arrow_drop_down_24px_svg, nil
}

func www_app_assets_img_ic_arrow_drop_down_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_ic_arrow_drop_down_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/ic_arrow_drop_down_24px.svg", size: 166, mode: os.FileMode(436), modTime: time.Unix(1431747225, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_ic_arrow_drop_up_24px_svg = []byte(`<?xml version="1.0" encoding="utf-8"?>
<!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px"
	 height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve">
<g id="Header">
	<g>
		<rect x="-618" y="-952" fill="none" width="1400" height="3600"/>
	</g>
</g>
<g id="Label">
</g>
<g id="Icon">
	<g>
		<g>
			<polygon points="7,14 12,9 17,14 			"/>
		</g>
		<rect fill="none" width="24" height="24"/>
	</g>
</g>
<g id="Grid" display="none">
	<g display="inline">
	</g>
</g>
</svg>
`)

func www_app_assets_img_ic_arrow_drop_up_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_ic_arrow_drop_up_24px_svg, nil
}

func www_app_assets_img_ic_arrow_drop_up_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_ic_arrow_drop_up_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/ic_arrow_drop_up_24px.svg", size: 795, mode: os.FileMode(436), modTime: time.Unix(1431747225, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_ic_keyboard_arrow_left_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z"/></svg>`)

func www_app_assets_img_ic_keyboard_arrow_left_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_ic_keyboard_arrow_left_24px_svg, nil
}

func www_app_assets_img_ic_keyboard_arrow_left_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_ic_keyboard_arrow_left_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/ic_keyboard_arrow_left_24px.svg", size: 151, mode: os.FileMode(436), modTime: time.Unix(1431747225, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_ic_keyboard_arrow_right_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z"/></svg>`)

func www_app_assets_img_ic_keyboard_arrow_right_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_ic_keyboard_arrow_right_24px_svg, nil
}

func www_app_assets_img_ic_keyboard_arrow_right_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_ic_keyboard_arrow_right_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/ic_keyboard_arrow_right_24px.svg", size: 149, mode: os.FileMode(436), modTime: time.Unix(1431747225, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_arrow_back_png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x80\x00\x00\x00\x80\b\x06\x00\x00\x00\xc3>a\xcb\x00\x00\x00\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x020IDATx\x9c\xed\xddIn\x13q\x10F\xf1ׄ\x05\xd7\xe0f\t\xc3\x166\x1c\xc0\x10\xa60\xc5!\x90\x046\x84Ab\xba\v7r`aY2\x02B\xecj\xf7_\xd5\xf5~\x92\x97\x91Jz_za\xc96H\x92$I\x92$I\x92$I\x92$I\x92$I\x92\xa4\xac\xb6Z\x1f\x90\xdc\x1ep\x15\xf8\xd1\xfa\x10\r\xab\x03\xde\x00?\x813\xe0V\xdbs4\xa4\xe5\xf8\x8b\x97#(\xa2\x03N\xf8=\xbe#(\xa2\x03\xa6\xfc=\xfe\xf2\bn\xb7:P\x9bs\x91\xf8\x8e`\xa4V\x89\xef\bF\xa6\x03\xf6Y-\xbe#\x18\x91\x87\xac\x17\u007f\xf1:\x1a\xfed\xf5e\xdd\xff\xfc\xc5k\xca\xfc\t\xa2\x84\xa2\xf1\x0f0~Z\xc6/,\x1a\xff%\xc6O\xeb\x05\xc6/+\x1a\xff\x10\xe3\xa7e\xfc\u008c_\xd8sb\xf1_a\xfc\xb4\x8c_X4\xfek\x8c\x9f\x96\xf1\v3~aψ\xc5?\xc2\xf8i\x19\xbf0\xe3\x17\x16\x8d\u007f\x8c\xf1\xd3z\x8a\xf1ˊ\xc6?\xc1\xf8iE\xe3\x9f\x02\x97\x86>Z\xfd0~aO0~Y\xd1\xf8\xef1~Z}\xc4\xf7;\x12\x922~a{\xc4\xe2\u007f\xc0\xf8i\x19\xbf\xb0h\xfc\x8f\x18?-\xe3\x17\xf6\x18\xe3\x975!\x16\xff\x13\xc6\xff\xa7\fo\x80\\\t\xfe\xfd\x8c\xf9\x10\x94\u0604\xd8S\xe0;py\xe8\xa3կ\t\x8e\xa0\xbc\t\xb1\x11|\xc3\x11\xa4w\x17GP\x9e#\x90#\x90#\x10p\x0fGP^t\x04_q\x04\xe99\x029\x02\xc1.\x8e\xa0<G G G \xe0>\x8e\xa0<G\xa0\xf0\b\xbe\xe0\b\xd2s\x04r\x04\x82\a8\x82\xf2\x1c\x81\x1c\x81\xe2#\xf8\x8c#H/\xfa\x03\x91\x8e`\x04\xfa\x18\x81\x1fAK\xce\x11\xc8\x11\b\x1e\x11\x1b\xc1)9>x\xabsDG\xf0\x0eG\x90Z\xc7\xfc\xeb\xe2##\xf0\xe7\xe3G`\xdd'\xc1\f\xd8\x1e\xfe\\mª_Qc\xfc\x11\xba\xe8\bf\xc0N\xa3\x1b\xb5A\x1d0\xe5\xff\xf1\xaf\xb5:P\x9bw\xde\bf\xc0\xf5v\xa7i(\x1dp\xc0\x9f\xf1o\xb4<J\xc3Z\x1e\xc1\x19p\xb3\xed9j\xa1\x03\xde\x02wZ\x1f\"I\x92$I\x92$I\x92$I\x92$I\x92$I\x92j\xfa\x05\xe7\xe1x\xb9\xc1\tI\xe0\x00\x00\x00\x00IEND\xaeB`\x82")

func www_app_assets_img_icons_arrow_back_png_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_arrow_back_png, nil
}

func www_app_assets_img_icons_arrow_back_png() (*asset, error) {
	bytes, err := www_app_assets_img_icons_arrow_back_png_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/arrow-back.png", size: 635, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_favicon_png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\b\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x03!iTXtXML:com.adobe.xmp\x00\x00\x00\x00\x00<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?> <x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 5.5-c014 79.151481, 2013/03/13-12:09:15        \"> <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"> <rdf:Description rdf:about=\"\" xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\" xmlns:stRef=\"http://ns.adobe.com/xap/1.0/sType/ResourceRef#\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\" xmpMM:DocumentID=\"xmp.did:756CA584644F11E4939EE4369DBF39D4\" xmpMM:InstanceID=\"xmp.iid:756CA583644F11E4939EE4369DBF39D4\" xmp:CreatorTool=\"Adobe Photoshop CC (Windows)\"> <xmpMM:DerivedFrom stRef:instanceID=\"xmp.iid:62F2AD71555711E48EAC88F7A4D19BF1\" stRef:documentID=\"xmp.did:62F2AD72555711E48EAC88F7A4D19BF1\"/> </rdf:Description> </rdf:RDF> </x:xmpmeta> <?xpacket end=\"r\"?>\xf7#U\x14\x00\x00\x02\xf4IDATx\xda|SkHSa\x18~\xceٙ\xd3m\xce\xcd\xcdL\x99I\xf7D\xa2?QXYBBZ\x19i\xa8\xe4\r\xaa\x95\x18*\x95B\xa4T&\bQZa\x96\x81\x05I\x14R\x96\x81H\x17B\xbbHY\x16d\x14\xa5\xa2&\xe4e\xe66\xddڙ\xbb\x9c\xad\xef\x9cyL\xff\xf4\xfd\xfa.\xcf\xf3\xbc\xcfy\xde\xf7P\x98\xb7|>\x9f\xba\u007f\xd4}\xd1h\xf1&5<\xb5\xe9\xbf\x0e\xbb\x85\xfb\xd8%R\x18\x92\x94\xa3a!\x92\xe71Q\xd2R\x8a\xa2L\"\x87\x9a%ꆌ\x9e\x9a\x91I.\xf1z\x9b-\xb2\xf7\x97\x9f\xa8\x92\xd3\b`\x80I\xabW8\xaf\xd6Kq$Yi\x8c\xd0H\xdaɾ\x98\bMR&+\x1778\xeeyx\xa1y:b`\xcc3\xdf\x106\xc5\xc8\x10\xa9\x95\xa0\xb9\x93]p\xbfl1\x83\x924\xd5D\xb8F\x92N\xf5\x8d\xb8\x9e\x1c\xbclJb\x9d\xbe\x05\xa0\xd8h)\xf6m\x96#(\x80B\xd3k\x16=\x83\xae\x05\xef\xfc\xfd\x8d\"\xed\v\xc6\xe6\xf0\xe9Er}a(\xeaZm0\xecPb\xdd\xd2\x00\x98\xff\xf8\xadW\x1fҀwW\xd7j\xc5\xf1T\x15\xf2\xaf\x9a\xe0p\xf9`c\xbdzz\xcc\xcciE\xd5\xf2\xc6)\xd4\x15\x84B\xafc\xb0\xeb\xec\x04\xda{f\xd0\xf5݉\xdd\x15\x13$\x0f\n7\x8fiQF0\x1eΏ\x1f1q:\xa6\xeb\x87S'\n\x90\x94A\x1c\x91\xe0(T\xe6\xaa!\x93R\xc2\xfe\\\x8e\x1a\xc1$\xd0q3G\xc4%0Z\xfc\n\xdd}N-\xf3y\xc0%\x15\x056\xac\n@\xdb\a\a\x1et\xdaq\xfb\x84\x0er\x19E:\x04\xc1\xae\xe1\x8a\t)\x1b\x83\x84`?\xf5\xfb\xf3\xe8\x19rS̨\x99\x9b\v\x86\xaf\x12\x1dƠ\"[\x8dp\xb5\x04\x8f߱Į\x0f\xe9\xf1\n\x9c\xca\b\x81\xc7\xebô\xdd;\x87\xff=́\x11\xfb}\xfe\x80ZH\x96'\xde{i\x17B\xcbۮ\x10\x80w;\xec\xe0\ve%(0E\x82\xad1hp\xa9\xc5\xcag\xe0\x17\xb0\xb2^\x1c\xbdf\x16,7\x97\x87\xe1}\xaf\v\xfb\x13\xe4h\xebv\x80#\x0e\xb4*\x1a-oY\xe4'+q\xb8\xd62\x97\x01\xbf\x98\x8cx9{\xff\r+\xe7\x0f|;\xab\x9a\xa6Q[\xa0Ap\x10\x8d\xbc\xeaIp\xc4q\xd3I\x1d֯\x94\tU\xe7\x93\xf7\xc6ɝ\xd4O\xa3\xfb\xd9\xe9;S\x89߆ݴ\xf8@D\x91\xb9U\x01\x9dJ\x02\x8a\f\xfb\x04\xf9V\xbe\x9dՏ\xacs\xe45QRT\xe6\xa8;\x98\xe8ELjY\x9a\xac\xb7\xb0\x81\xd3[f\ag\xdb\xda@\xe4\x92\xea\xe2\x80\xf1\"\xb7\xc8\fФ\x84\xd7\xeb\xcf\xecLV\xc8\xe0\xf2\b&\x85&?\x04\xfb\xf1nmiU\xb6\xc2L\xd3\xff\x06j\xfeh\xf3\xad,i\xb0\bd\x1eS\x95\xab\xb4\x90\xb0w\x12\xae\x9d\x12A#&O\xe6\xab/3\xf5Ħ\x06\xffY\xc5{\x82m[b\x03\x8bVDJ\x1b\xf9\xf3_\x01\x06\x00\xf19?q\xaaE\xa0\xa4\x00\x00\x00\x00IEND\xaeB`\x82")

func www_app_assets_img_icons_favicon_png_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_favicon_png, nil
}

func www_app_assets_img_icons_favicon_png() (*asset, error) {
	bytes, err := www_app_assets_img_icons_favicon_png_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/favicon.png", size: 1663, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_ic_arrow_forward_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"/></svg>`)

func www_app_assets_img_icons_ic_arrow_forward_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_ic_arrow_forward_24px_svg, nil
}

func www_app_assets_img_icons_ic_arrow_forward_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_icons_ic_arrow_forward_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/ic_arrow_forward_24px.svg", size: 158, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_ic_cancel_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"/></svg>`)

func www_app_assets_img_icons_ic_cancel_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_ic_cancel_24px_svg, nil
}

func www_app_assets_img_icons_ic_cancel_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_icons_ic_cancel_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/ic_cancel_24px.svg", size: 276, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_ic_close_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/></svg>`)

func www_app_assets_img_icons_ic_close_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_ic_close_24px_svg, nil
}

func www_app_assets_img_icons_ic_close_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_icons_ic_close_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/ic_close_24px.svg", size: 202, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_ic_menu_svg = []byte(`<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Generator: Adobe Illustrator 18.1.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 10 10" style="enable-background:new 0 0 10 10;" xml:space="preserve">
	<g>
		<path style="fill:#010002;" d="M9.5,4.5h-9C0.224,4.5,0,4.724,0,5s0.224,0.5,0.5,0.5h9C9.775,5.5,10,5.276,10,5
			S9.775,4.5,9.5,4.5z"/>
		<path style="fill:#010002;" d="M0.5,2.5h9C9.775,2.5,10,2.276,10,2S9.775,1.5,9.5,1.5h-9C0.224,1.5,0,1.724,0,2
			S0.224,2.5,0.5,2.5z"/>
		<path style="fill:#010002;" d="M9.5,7.5h-9C0.224,7.5,0,7.725,0,8s0.224,0.5,0.5,0.5h9C9.775,8.5,10,8.275,10,8
			S9.775,7.5,9.5,7.5z"/>
	</g>
</svg>
`)

func www_app_assets_img_icons_ic_menu_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_ic_menu_svg, nil
}

func www_app_assets_img_icons_ic_menu_svg() (*asset, error) {
	bytes, err := www_app_assets_img_icons_ic_menu_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/ic_menu.svg", size: 791, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_ic_menu_24px_svg = []byte(`<?xml version="1.0" encoding="utf-8"?>
<!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px"
     height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve">
<g id="Header">
    <g>
        <rect x="-618" y="-2232" fill="none" width="1400" height="3600"/>
    </g>
</g>
<g id="Label">
</g>
<g id="Icon">
    <g>
        <rect fill="none" width="24" height="24"/>
        <path d="M3,18h18v-2H3V18z M3,13h18v-2H3V13z M3,6v2h18V6H3z" style="fill:#f3f3f3;"/>
    </g>
</g>
<g id="Grid" display="none">
    <g display="inline">
    </g>
</g>
</svg>
`)

func www_app_assets_img_icons_ic_menu_24px_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_ic_menu_24px_svg, nil
}

func www_app_assets_img_icons_ic_menu_24px_svg() (*asset, error) {
	bytes, err := www_app_assets_img_icons_ic_menu_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/ic_menu_24px.svg", size: 841, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_icons_list_control_down_png = []byte("\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\b\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00'PLTE\xa8\xa8\xa8\xfc\xfc\xfc\xc0\xc0\xc0\xb6\xb6\xb6\xf7\xf7\xf7\xaa\xaa\xaa\xf6\xf6\xf6\xe6\xe6\xe6\xe8\xe8赵\xb5\xc3\xc3\xc3\xe5\xe5\xe5\xff\xff\xffZLu\xde\x00\x00\x00\rtRNS\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00=\xe8\"\x86\x00\x00\x00\x8bIDATx\xda\xec\xd4I\x12\x80 \fD\xd1\x04\x04\x9c\xee\u007f^ˁ\xd2`\xb7\x96k\xc3\xd2\xfao\xa1\t\xca\xfc\xf1\x88\x03\a\xbf\x01}\xd7\x06\xb9\u007f\x02S\x8a\x8d\xc8C*\x1c\x94$bE\x1eD\xac0`\x14\xb1\"\xc7\xf5\xc9H\x81\x06+\xba\xad\x0f\xca\xdf\xc1\nԷ_\xe9*`\u007f\x9b\xc3)p\u007f\x1f\\\x15\xa4\a\x93>\x04\xe9\xd1j\xec\x82\xf4p\x97\xaa@=^\xbe]\xc0\x9el\xeb*p\xcf\xd6[\x03\xe9\xe9}P\xf5\x9f\x80\x03\a\xafg\x11`\x00\xb0\xe4e\a\x17\x87\xea}\x00\x00\x00\x00IEND\xaeB`\x82")

func www_app_assets_img_icons_list_control_down_png_bytes() ([]byte, error) {
	return _www_app_assets_img_icons_list_control_down_png, nil
}

func www_app_assets_img_icons_list_control_down_png() (*asset, error) {
	bytes, err := www_app_assets_img_icons_list_control_down_png_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/icons/list_control_down.png", size: 309, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_img_kubernetes_svg = []byte(`<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg width="140px" height="139px" viewBox="0 0 140 139" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <path d="M69.564453,0.890625 C67.679438,0.97633863 65.83265,1.45183502 64.140625,2.2871094 L64.150425,2.2714844 L19.492222,24.177734 C15.776058,26.000423 13.087287,29.410414 12.181675,33.449219 L1.1484375,82.683594 C0.25354487,86.675977 1.1961448,90.859257 3.7167969,94.082031 L34.617188,133.57031 C37.204703,136.87615 41.169115,138.80794 45.367188,138.80859 L94.929688,138.81459 C99.128112,138.81501 103.09331,136.88391 105.68164,133.57826 L136.58984,94.097796 C139.11186,90.875671 140.05591,86.692328 139.16211,82.699359 L128.13867,33.462891 C127.23402,29.423742 124.54596,26.013013 120.83008,24.189453 L76.177734,2.2734375 C74.123956,1.26576975 71.849913,0.79027587 69.564453,0.890625 L69.564453,0.890625 Z" fill="#FFFFFF"></path>
  <path d="M69.785156,5.9277344 C68.596708,5.9813144 67.432255,6.2805743 66.365234,6.8066406 L66.371134,6.7988306 L21.712931,28.705081 C19.369578,29.854918 17.674286,32.00564 17.103556,34.552737 L6.0683594,83.785156 C5.504042,86.303482 6.0990134,88.942143 7.6894531,90.974609 L38.587891,130.46289 C40.219821,132.54737 42.719874,133.76535 45.367188,133.76562 L94.931641,133.77162 C97.578956,133.77135 100.079009,132.55338 101.71094,130.46889 L132.61914,90.990374 C134.20958,88.957907 134.80455,86.319246 134.24023,83.800921 L123.2168,34.564453 C122.6465,32.017743 120.95198,29.867093 118.60938,28.716797 L73.957031,6.8007812 C72.661541,6.1647578 71.22697,5.8645457 69.785156,5.9277344 L69.785156,5.9277344 Z" fill="#336EE5"></path>
  <path d="M70.158203,22.609375 C68.693809,22.609375 67.509033,23.95463 67.490234,25.621094 L67.486328,25.621094 C67.487016,25.861935 67.475646,26.208085 67.484375,26.439453 C67.519875,27.411433 67.725984,28.156904 67.849609,29.052734 C68.074983,30.968571 68.264312,32.557063 68.148438,34.033203 C68.042186,34.772109 67.626171,35.064535 67.279297,35.40625 L67.345703,35.451172 L67.275391,35.451172 L67.275391,35.455078 L67.208984,36.648438 C58.699449,37.421316 50.808823,41.403848 45.007812,47.625 L44.009766,46.898438 L43.964844,46.955078 L43.972656,46.871094 C43.495282,46.936971 43.014968,47.090461 42.386719,46.714844 C41.190848,45.887846 40.100492,44.745117 38.78125,43.369141 C38.178242,42.711651 37.740935,42.081769 37.023438,41.447266 C36.866687,41.309245 36.631678,41.126067 36.451172,40.980469 C36.443613,40.974161 36.437316,40.967191 36.429688,40.960938 C35.147441,39.910367 33.360321,40.0198 32.439453,41.205078 C31.527048,42.380511 31.812064,44.16996 33.066406,45.224609 L33.064453,45.228516 C33.248323,45.378891 33.50537,45.605709 33.6875,45.744141 C34.448628,46.321756 35.145669,46.619167 35.904297,47.078125 C37.502293,48.092354 38.829491,48.929643 39.880859,49.943359 C40.376858,50.488741 40.338814,51.005958 40.382812,51.498047 L40.457031,51.472656 L40.414062,51.529297 L41.300781,52.34375 C38.981079,55.873171 37.23995,59.878341 36.261719,64.253906 C35.291509,68.592614 35.15021,72.93213 35.71875,77.101562 L34.681641,77.408203 L34.697266,77.474609 L34.640625,77.419922 C34.393376,77.844336 34.208378,78.327212 33.53125,78.597656 C32.156134,79.042104 30.606646,79.207233 28.738281,79.408203 C27.861034,79.483198 27.107482,79.439514 26.177734,79.621094 C25.967973,79.661512 25.672514,79.741581 25.447266,79.794922 C25.443964,79.795686 25.440802,79.7961 25.4375,79.796875 C25.434011,79.797691 25.431218,79.799955 25.427734,79.800781 C25.419505,79.802709 25.408389,79.804799 25.400391,79.806641 L25.400391,79.808594 C23.823377,80.19742 22.811243,81.68559 23.136719,83.152344 C23.462521,84.618785 25.002575,85.507142 26.587891,85.15625 L26.587891,85.158203 C26.599278,85.155524 26.615088,85.153125 26.626953,85.150391 C26.631045,85.149431 26.634588,85.147459 26.638672,85.146484 C26.864586,85.094713 27.164032,85.034947 27.369141,84.978516 C28.282888,84.727334 28.943998,84.354858 29.765625,84.03125 C31.534121,83.379283 32.998915,82.836501 34.425781,82.625 C35.150409,82.56593 35.520136,82.917596 35.921875,83.189453 L35.949219,83.113281 L35.964844,83.183594 L37.03125,82.998047 C39.605936,91.246292 45.067458,98.389215 52.492188,102.85938 L52.046875,103.96289 L52.111328,103.99414 L52.029297,104.00586 C52.197542,104.46842 52.451249,104.91582 52.234375,105.62891 C51.714876,107.01143 50.8732,108.35796 49.861328,109.98438 C49.371579,110.73613 48.870608,111.3141 48.427734,112.17383 C48.330344,112.36321 48.209485,112.64157 48.111328,112.85547 C48.107725,112.863 48.103166,112.86938 48.099609,112.87695 C48.095681,112.88534 48.093699,112.89394 48.089844,112.90234 C48.087972,112.90637 48.085834,112.91205 48.083984,112.91602 L48.085938,112.91602 C47.40097,114.42514 47.900428,116.16537 49.21875,116.81836 C50.548871,117.47649 52.203768,116.77883 52.916016,115.26172 C52.91995,115.25333 52.921921,115.24473 52.925781,115.23633 C53.02742,115.02423 53.164417,114.75327 53.248047,114.55859 C53.626421,113.66636 53.753782,112.90269 54.019531,112.04102 C54.626529,110.21405 55.127221,108.70063 55.855469,107.42188 C56.263218,106.80303 56.761002,106.72716 57.21875,106.57422 L57.175781,106.50195 L57.240234,106.5332 L57.820312,105.45703 C59.279187,106.01887 60.786912,106.49484 62.349609,106.85938 C69.289342,108.47785 76.223872,107.82482 82.423828,105.39453 L83.060547,106.57812 L83.123047,106.54688 L83.082031,106.61719 C83.539779,106.77051 84.037813,106.84797 84.445312,107.4668 C85.173436,108.74441 85.674627,110.25896 86.28125,112.08594 C86.547374,112.94761 86.67361,113.71282 87.052734,114.60352 C87.135308,114.79955 87.272056,115.06752 87.373047,115.2793 C87.376902,115.2877 87.378886,115.2963 87.382812,115.30469 C88.09406,116.82295 89.750582,117.52154 91.080078,116.86328 C92.399875,116.21158 92.900929,114.47045 92.214844,112.96094 L92.216797,112.95898 C92.212007,112.94874 92.20611,112.9345 92.201172,112.92383 C92.200152,112.92165 92.198289,112.92014 92.197266,112.91797 C92.097824,112.70281 91.972439,112.41327 91.873047,112.21875 C91.430548,111.35862 90.929451,110.78092 90.439453,110.0293 C89.427455,108.40317 88.58578,107.0552 88.066406,105.67383 C87.849532,104.96074 88.102109,104.51449 88.271484,104.05078 L88.191406,104.03906 L88.255859,104.00781 L87.751953,102.75391 C94.885105,98.433344 100.514721,91.548722 103.20703,83.046875 L104.34961,83.246094 L104.36523,83.177734 L104.39258,83.253906 C104.79508,82.981665 105.16405,82.62843 105.88867,82.6875 C107.31516,82.899001 108.77997,83.441782 110.54883,84.09375 C111.37046,84.417358 112.03081,84.791017 112.94531,85.042969 C113.15137,85.098644 113.45395,85.160732 113.67969,85.212891 C113.68234,85.21352 113.68484,85.21422 113.6875,85.214844 C113.69016,85.21547 113.69265,85.216178 113.69531,85.216797 C113.70411,85.218846 113.71609,85.220642 113.72461,85.222656 L113.72461,85.220703 C115.30963,85.574117 116.85106,84.68396 117.17773,83.216797 C117.5032,81.75119 116.49071,80.262994 114.91406,79.873047 L114.91406,79.871094 C114.90306,79.868505 114.88838,79.864067 114.87695,79.861328 C114.87365,79.860551 114.87049,79.860141 114.86719,79.859375 C114.64143,79.805066 114.34542,79.726689 114.13672,79.685547 C113.20586,79.504737 112.45342,79.545569 111.57617,79.470703 C109.7078,79.268962 108.15808,79.104989 106.7832,78.660156 C106.10509,78.389969 105.92278,77.908918 105.67578,77.484375 L105.61719,77.541016 L105.63281,77.472656 L104.54883,77.150391 C105.81818,68.221389 103.69598,59.45007 99.085938,52.347656 L99.919922,51.580078 L99.876953,51.525391 L99.953125,51.550781 C99.99675,51.058563 99.957001,50.541477 100.453125,49.996094 C101.504,48.982379 102.83132,48.144575 104.42969,47.130859 C105.18869,46.672543 105.88537,46.374233 106.64648,45.796875 C106.8146,45.669733 107.03986,45.470697 107.21875,45.322266 C107.22551,45.316815 107.2335,45.314108 107.24023,45.308594 C108.52261,44.258023 108.81553,42.445045 107.89453,41.259766 C106.98249,40.083783 105.21899,39.970689 103.93945,40.992188 L103.9375,40.990234 C103.75362,41.141636 103.48363,41.347442 103.3125,41.5 C102.59501,42.134118 102.15686,42.765696 101.55273,43.423828 C100.234996,44.799034 99.143138,45.940579 97.947266,46.767578 C97.319018,47.143708 96.838576,46.989705 96.361328,46.923828 L96.369141,47.003906 L96.326172,46.949219 L95.417969,47.611328 C90.871424,42.674999 84.900337,39.013547 77.949219,37.392578 C76.33103,37.015067 74.713896,36.769878 73.105469,36.632812 L73.041016,35.455078 L73.041016,35.451172 L72.970703,35.451172 L73.037109,35.40625 C72.690235,35.064535 72.274344,34.772109 72.167969,34.033203 C72.052094,32.557063 72.239845,30.968571 72.464844,29.052734 C72.588844,28.156904 72.796281,27.411433 72.832031,26.439453 C72.84076,26.208085 72.829514,25.861935 72.830078,25.621094 L72.826172,25.621094 C72.80646,23.955428 71.622757,22.610521 70.158203,22.609375 L70.158203,22.609375 Z M73.501953,43.830078 C74.442204,43.947675 75.386211,44.113788 76.330078,44.333984 C81.549591,45.551151 86.083352,48.217305 89.625,51.828125 L78.119141,60.203125 L78.095703,60.191406 C77.706579,60.483038 77.226529,60.654297 76.707031,60.654297 C75.439284,60.654297 74.408969,59.62693 74.355469,58.337891 L74.298828,58.310547 L73.501953,43.830078 L73.501953,43.830078 Z M66.8125,43.837891 L66.013672,58.285156 L66.001953,58.291016 C65.981453,58.78606 65.81178,59.278861 65.488281,59.695312 C64.698158,60.713394 63.27156,60.900719 62.257812,60.140625 L62.216797,60.160156 L50.775391,51.826172 C55.08706,47.449717 60.722164,44.609096 66.8125,43.837891 L66.8125,43.837891 Z M46.615234,57.228516 L57.050781,66.820312 L57.044922,66.847656 C57.408796,67.172676 57.677719,67.614939 57.792969,68.134766 C58.074593,69.404543 57.32781,70.665429 56.117188,71.005859 L56.105469,71.058594 L42.640625,75.048828 C42.352667,72.040886 42.518719,68.93035 43.216797,65.808594 C43.915022,62.685476 45.081605,59.808054 46.615234,57.228516 L46.615234,57.228516 Z M93.769531,57.232422 C96.851248,62.438943 98.312826,68.673365 97.626953,75.097656 L84.234375,71.125 L84.224609,71.078125 C83.759736,70.947141 83.329733,70.669176 83.005859,70.251953 C82.216486,69.234642 82.354861,67.762405 83.302734,66.916016 L83.291016,66.859375 L93.769531,57.232422 L93.769531,57.232422 Z M68.058594,67.533203 L72.259766,67.533203 L74.945312,70.976562 L73.974609,75.330078 L70.160156,77.208984 L66.345703,75.332031 L65.375,70.976562 L68.058594,67.533203 L68.058594,67.533203 Z M58.345703,79.349609 C58.70919,79.339282 59.08083,79.416193 59.431641,79.589844 C59.554043,79.650391 59.664377,79.724576 59.771484,79.802734 L59.771484,79.925781 L60.085938,80.080078 C60.738857,80.764053 60.958553,81.803391 60.572266,82.726562 L60.589844,82.75 L55.193359,96.148438 C50.016365,92.739684 46.1366,87.648057 44.101562,81.767578 L57.960938,79.357422 L57.986328,79.388672 C58.104765,79.366199 58.224541,79.353052 58.345703,79.349609 L58.345703,79.349609 Z M81.904297,79.40625 C82.055953,79.404147 82.209001,79.418067 82.363281,79.447266 L82.384766,79.419922 L96.111328,81.810547 C93.985653,87.866972 90.034121,92.797189 85.068359,96.089844 L79.732422,82.832031 L79.771484,82.78125 C79.58086,82.326915 79.52475,81.806936 79.640625,81.287109 C79.887484,80.176167 80.842701,79.420971 81.904297,79.40625 L81.904297,79.40625 Z M70.025391,85.224609 C70.918397,85.170809 71.796516,85.646772 72.240234,86.5 L72.240234,86.494141 L72.246094,86.494141 L79.035156,99.101562 C74.341871,100.754225 69.160794,101.12885 63.96875,99.917969 C63.033715,99.69985 62.119901,99.435009 61.230469,99.126953 L68.035156,86.496094 L68.087891,86.496094 C68.31564,86.059993 68.674829,85.692087 69.142578,85.460938 C69.427827,85.319776 69.727722,85.242543 70.025391,85.224609 L70.025391,85.224609 Z" fill="#FFFFFF"></path>
</svg>`)

func www_app_assets_img_kubernetes_svg_bytes() ([]byte, error) {
	return _www_app_assets_img_kubernetes_svg, nil
}

func www_app_assets_img_kubernetes_svg() (*asset, error) {
	bytes, err := www_app_assets_img_kubernetes_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/img/kubernetes.svg", size: 11663, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_js_gitkeep = []byte(``)

func www_app_assets_js_gitkeep_bytes() ([]byte, error) {
	return _www_app_assets_js_gitkeep, nil
}

func www_app_assets_js_gitkeep() (*asset, error) {
	bytes, err := www_app_assets_js_gitkeep_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/js/.gitkeep", size: 0, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_js_app_js = []byte(`var componentNamespaces = ["kubernetesApp.components.dashboard"];
// APP START
// ****************************
// /www/app/assets/app.js is autogenerated. Do not modify.
// Changes should be made in /master/modules/js or /master/components/<component-name>/js
// ****************************
// -----------------------------------

var app = angular.module('kubernetesApp', [
  'ngRoute',
  'ngMaterial',
  'ngLodash',
  'door3.css',
  'kubernetesApp.config',
  'kubernetesApp.services',
  'angular.filter'
].concat(componentNamespaces));

app.factory('menu', [
  '$location',
  '$rootScope',
  'sections',
  '$route',
  function($location, $rootScope, sections, $route) {

    var self;

    $rootScope.$on('$locationChangeSuccess', onLocationChange);

    return self = {

      sections: sections,

      setSections: function(_sections) { this.sections = _sections; },
      selectSection: function(section) { self.openedSection = section; },
      toggleSelectSection: function(section) {
        self.openedSection = (self.openedSection === section ? null : section);
      },
      isSectionSelected: function(section) { return self.openedSection === section; },
      selectPage: function(section, page) {
        self.currentSection = section;
        self.currentPage = page;
      },
      isPageSelected: function(page) { return self.currentPage === page; }
    };

    function onLocationChange() {
      var path = $route.current.originalPath;

      var matchPage = function(section, page) {
        if (path === page.url || path === (page.url + '/')) {
          self.selectSection(section);
          self.selectPage(section, page);
        }
      };

      sections.forEach(function(section) {
        if (section.children) {
          section.children.forEach(function(childSection) {
            if (childSection.pages) {
              childSection.pages.forEach(function(page) { matchPage(childSection, page); });
            }
          });
        } else if (section.pages) {
          section.pages.forEach(function(page) { matchPage(section, page); });
        } else if (section.type === 'link') {
          matchPage(section, section);
        }
      });
    }
  }
]);

angular.module('kubernetesApp.config', []);
angular.module('kubernetesApp.services', ['kubernetesApp.config']);

app.config([
  '$routeProvider',
  function($routeProvider) {
    $routeProvider.when("/404", {templateUrl: "views/partials/404.html"})
        // else 404
        .otherwise({redirectTo: "/404"});
  }
])
    .config([
      '$routeProvider',
      'manifestRoutes',
      function($routeProvider, manifestRoutes) {
        angular.forEach(manifestRoutes, function(r) {
          var route = {
            templateUrl: r.templateUrl
          };
          if (r.controller) {
            route.controller = r.controller;
          }
          if (r.css) {
            route.css = r.css;
          }
          $routeProvider.when(r.url, route);
        });
      }
    ]);

app.value("sections", [{"name":"Dashboard","url":"/dashboard","type":"link","templateUrl":"/components/dashboard/pages/home.html"},{"name":"Dashboard","type":"heading","children":[{"name":"Dashboard","type":"toggle","url":"/dashboard","templateUrl":"/components/dashboard/pages/home.html","pages":[{"name":"Pods","url":"/dashboard/pods","templateUrl":"/components/dashboard/views/listPods.html","type":"link"},{"name":"Pod Visualizer","url":"/dashboard/visualpods","templateUrl":"/components/dashboard/views/listPodsVisualizer.html","type":"link"},{"name":"Services","url":"/dashboard/services","templateUrl":"/components/dashboard/views/listServices.html","type":"link"},{"name":"Replication Controllers","url":"/dashboard/replicationcontrollers","templateUrl":"/components/dashboard/views/listReplicationControllers.html","type":"link"},{"name":"Events","url":"/dashboard/events","templateUrl":"/components/dashboard/views/listEvents.html","type":"link"},{"name":"Nodes","url":"/dashboard/nodes","templateUrl":"/components/dashboard/views/listMinions.html","type":"link"},{"name":"Replication Controller","url":"/dashboard/replicationcontrollers/:replicationControllerId","templateUrl":"/components/dashboard/views/replication.html","type":"link"},{"name":"Service","url":"/dashboard/services/:serviceId","templateUrl":"/components/dashboard/views/service.html","type":"link"},{"name": "Node","url": "/dashboard/nodes/:nodeId","templateUrl": "/components/dashboard/views/node.html","type": "link"},{"name":"Explore","url":"/dashboard/groups/:grouping*?/selector/:selector*?","templateUrl":"/components/dashboard/views/groups.html","type":"link"},{"name":"Pod","url":"/dashboard/pods/:podId","templateUrl":"/components/dashboard/views/pod.html","type":"link"}]}]},{"name":"Graph","url":"/graph","type":"link","templateUrl":"/components/graph/pages/home.html"},{"name":"Graph","url":"/graph/inspect","type":"link","templateUrl":"/components/graph/pages/inspect.html","css":"/components/graph/css/show-details-table.css"},{"name":"Graph","type":"heading","children":[{"name":"Graph","type":"toggle","url":"/graph","templateUrl":"/components/graph/pages/home.html","pages":[{"name":"Test","url":"/graph/test","type":"link","templateUrl":"/components/graph/pages/home.html"}]}]}]);

app.directive('includeReplace',
              function() {
                'use strict';
                return {
                  require: 'ngInclude',
                  restrict: 'A', /* optional */
                  link: function(scope, el, attrs) { el.replaceWith(el.children()); }
                };
              })
    .directive('compile',
               ["$compile", function($compile) {
                 'use strict';
                 return function(scope, element, attrs) {
                   scope.$watch(function(scope) { return scope.$eval(attrs.compile); },
                                function(value) {
                                  element.html(value);
                                  $compile(element.contents())(scope);
                                });
                 };
               }])
    .directive("kubernetesUiMenu",
               function() {
                 'use strict';
                 return {
                   templateUrl: "views/partials/kubernetes-ui-menu.tmpl.html"
                 };
               })
    .directive('menuToggle', function() {
      'use strict';
      return {
        scope: {section: '='},
        templateUrl: 'views/partials/menu-toggle.tmpl.html',
        link: function($scope, $element) {
          var controller = $element.parent().controller();

          $scope.isOpen = function() { return controller.isOpen($scope.section); };
          $scope.toggle = function() { controller.toggleOpen($scope.section); };

          var parentNode = $element[0].parentNode.parentNode.parentNode;
          if (parentNode.classList.contains('parent-list-item')) {
            var heading = parentNode.querySelector('h2');
            $element[0].firstChild.setAttribute('aria-describedby', heading.id);
          }
        }
      };
    });

app.filter('startFrom',
           function() {
             'use strict';
             return function(input, start) { return input.slice(start); };
           })
    .filter('nospace', function() {
      'use strict';
      return function(value) { return (!value) ? '' : value.replace(/ /g, ''); };
    });

app.run(['$route', angular.noop])
    .run(["lodash", function(lodash) {
      // Alias lodash
      window['_'] = lodash;
    }]);

app.service('SidebarService', [
  '$rootScope',
  function($rootScope) {
    var service = this;
    service.sidebarItems = [];

    service.clearSidebarItems = function() { service.sidebarItems = []; };

    service.renderSidebar = function() {
      var _entries = '';
      service.sidebarItems.forEach(function(entry) { _entries += entry.Html; });

      if (_entries) {
        $rootScope.sidenavLeft = '<div layout="column">' + _entries + '</div>';
      }
    };

    service.addSidebarItem = function(item) {

      service.sidebarItems.push(item);

      service.sidebarItems.sort(function(a, b) { return (a.order > b.order) ? 1 : ((b.order > a.order) ? -1 : 0); });
    };
  }
]);


app.value("tabs", [{"component":"dashboard","title":"Dashboard"}]);
app.constant("manifestRoutes", [{"description":"Dashboard visualization.","url":"/dashboard/","templateUrl":"components/dashboard/pages/home.html"},{"description":"Pods","url":"/dashboard/pods","templateUrl":"components/dashboard/views/listPods.html"},{"description":"Pod Visualizer","url":"/dashboard/visualpods","templateUrl":"components/dashboard/views/listPodsVisualizer.html"},{"description":"Services","url":"/dashboard/services","templateUrl":"components/dashboard/views/listServices.html"},{"description":"Replication Controllers","url":"/dashboard/replicationcontrollers","templateUrl":"components/dashboard/views/listReplicationControllers.html"},{"description":"Events","url":"/dashboard/events","templateUrl":"components/dashboard/views/listEvents.html"},{"description":"Nodes","url":"/dashboard/nodes","templateUrl":"components/dashboard/views/listMinions.html"},{"description":"Replication Controller","url":"/dashboard/replicationcontrollers/:replicationControllerId","templateUrl":"components/dashboard/views/replication.html"},{"description":"Service","url":"/dashboard/services/:serviceId","templateUrl":"components/dashboard/views/service.html"},{"description":"Node","url":"/dashboard/nodes/:nodeId","templateUrl":"components/dashboard/views/node.html"},{"description":"Explore","url":"/dashboard/groups/:grouping*?/selector/:selector*?","templateUrl":"components/dashboard/views/groups.html"},{"description":"Pod","url":"/dashboard/pods/:podId","templateUrl":"components/dashboard/views/pod.html"}]);

angular.module("kubernetesApp.config", [])

.constant("ENV", {
	"/": {
		"k8sApiServer": "/api/v1beta2",
		"k8sApiv1beta3Server": "/api/v1beta3",
		"k8sDataServer": "/cluster",
		"k8sDataPollMinIntervalSec": 10,
		"k8sDataPollMaxIntervalSec": 120,
		"k8sDataPollErrorThreshold": 5,
		"cAdvisorProxy": "",
		"cAdvisorPort": "4194"
	}
})

.constant("ngConstant", true)

;
/**=========================================================
 * Module: config.js
 * App routes and resources configuration
 =========================================================*/
/**=========================================================
 * Module: constants.js
 * Define constants to inject across the application
 =========================================================*/
/**=========================================================
 * Module: home-page.js
 * Page Controller
 =========================================================*/

app.controller('PageCtrl', [
  '$scope',
  '$timeout',
  '$mdSidenav',
  'menu',
  '$rootScope',
  function($scope, $timeout, $mdSidenav, menu, $rootScope) {
  $scope.menu = menu;

  $scope.path = path;
  $scope.goHome = goHome;
  $scope.openMenu = openMenu;
  $rootScope.openMenu = openMenu;
  $scope.closeMenu = closeMenu;
  $scope.isSectionSelected = isSectionSelected;

  $rootScope.$on('$locationChangeSuccess', openPage);

  // Methods used by menuLink and menuToggle directives
  this.isOpen = isOpen;
  this.isSelected = isSelected;
  this.toggleOpen = toggleOpen;
  this.shouldLockOpen = shouldLockOpen;
  $scope.toggleKubernetesUiMenu = toggleKubernetesUiMenu;

  var mainContentArea = document.querySelector("[role='main']");
  var kubernetesUiMenu = document.querySelector("[role='kubernetes-ui-menu']");

  // *********************
  // Internal methods
  // *********************

  var _t = false;

  $scope.showKubernetesUiMenu = false;

  function shouldLockOpen() {
    return _t;
  }

  function toggleKubernetesUiMenu() {
    $scope.showKubernetesUiMenu = !$scope.showKubernetesUiMenu;
  }

  function closeMenu() {
    $timeout(function() {
      $mdSidenav('left').close();
    });
  }

  function openMenu() {
    $timeout(function() {
      _t = !$mdSidenav('left').isOpen();
      $mdSidenav('left').toggle();
    });
  }

  function path() {
    return $location.path();
  }

  function goHome($event) {
    menu.selectPage(null, null);
    $location.path( '/' );
  }

  function openPage() {
    $scope.closeMenu();
    mainContentArea.focus();
  }

  function isSelected(page) {
    return menu.isPageSelected(page);
  }

  function isSectionSelected(section) {
    var selected = false;
    var openedSection = menu.openedSection;
    if(openedSection === section){
      selected = true;
    }
    else if(section.children) {
      section.children.forEach(function(childSection) {
        if(childSection === openedSection){
          selected = true;
        }
      });
    }
    return selected;
  }

  function isOpen(section) {
    return menu.isSectionSelected(section);
  }

  function toggleOpen(section) {
    menu.toggleSelectSection(section);
  }

  }
]).filter('humanizeDoc', function() {
  return function(doc) {
    if (!doc) return;
    if (doc.type === 'directive') {
      return doc.name.replace(/([A-Z])/g, function($1) {
        return '-'+$1.toLowerCase();
      });
    }
    return doc.label || doc.name;
  }; });

/**=========================================================
 * Module: main.js
 * Main Application Controller
 =========================================================*/
/**=========================================================
 * Module: tabs-global.js
 * Page Controller
 =========================================================*/

app.controller('TabCtrl', [
  '$scope',
  '$location',
  'tabs',
  function($scope, $location, tabs) {
    $scope.tabs = tabs;

    $scope.switchTab = function(index) {
      var location_path = $location.path();
      var tab = tabs[index];

      if (tab) {
        var path = '/%s'.format(tab.component);
        if (location_path.indexOf(path) == -1) {
          $location.path(path);
        }
      }
    };
  }
]);

/**=========================================================
 * Module: sidebar.js
 * Wraps the sidebar and handles collapsed state
 =========================================================*/
(function() {
  "use strict";

  angular.module('kubernetesApp.services')
      .service('cAdvisorService', ["$http", "$q", "ENV", function($http, $q, ENV) {
        var _baseUrl = function(minionIp) {
          var minionPort = ENV['/']['cAdvisorPort'] || "8081";
          var proxy = ENV['/']['cAdvisorProxy'] || "/api/v1beta3/proxy/nodes/";

          return proxy + minionIp + ':' + minionPort + '/api/v1.0/';
        };

        this.getMachineInfo = getMachineInfo;

        function getMachineInfo(minionIp) {
          var fullUrl = _baseUrl(minionIp) + 'machine';
          var deferred = $q.defer();

          // hack
          $http.get(fullUrl).success(function(data) {
            deferred.resolve(data);
          }).error(function(data, status) { deferred.reject('There was an error') });
          return deferred.promise;
        }

        this.getContainerInfo = getContainerInfo;
        // containerId optional
        function getContainerInfo(minionIp, containerId) {
          containerId = (typeof containerId === "undefined") ? "/" : containerId;

          var fullUrl = _baseUrl(minionIp) + 'containers' + containerId;
          var deferred = $q.defer();

          var request = {
            "num_stats": 10,
            "num_samples": 0
          };

          $http.post(fullUrl, request)
              .success(function(data) { deferred.resolve(data); })
              .error(function() { deferred.reject('There was an error') });
          return deferred.promise;
        }

        this.getDataForMinion = function(minionIp) {
          var machineData, containerData;
          var deferred = $q.defer();

          var p = $q.all([getMachineInfo(minionIp), getContainerInfo(minionIp)])
                      .then(
                          function(dataArray) {
                            machineData = dataArray[0];
                            containerData = dataArray[1];

                            var memoryData = parseMemory(machineData, containerData);
                            var cpuData = parseCpu(machineData, containerData);
                            var fsData = parseFilesystems(machineData, containerData);
                            deferred.resolve({
                              memoryData: memoryData,
                              cpuData: cpuData,
                              filesystemData: fsData,
                              machineData: machineData,
                              containerData: containerData
                            });

                          },
                          function(errorData) { deferred.reject(errorData); });

          return deferred.promise;
        };

        // Utils to process cadvisor data
        function humanize(num, size, units) {
          var unit;
          for (unit = units.pop(); units.length && num >= size; unit = units.pop()) {
            num /= size;
          }
          return [num, unit];
        }

        // Following the IEC naming convention
        function humanizeIEC(num) {
          var ret = humanize(num, 1024, ["TiB", "GiB", "MiB", "KiB", "Bytes"]);
          return ret[0].toFixed(2) + " " + ret[1];
        }

        // Following the Metric naming convention
        function humanizeMetric(num) {
          var ret = humanize(num, 1000, ["TB", "GB", "MB", "KB", "Bytes"]);
          return ret[0].toFixed(2) + " " + ret[1];
        }

        function hasResource(stats, resource) { return stats.stats.length > 0 && stats.stats[0][resource]; }

        // Gets the length of the interval in nanoseconds.
        function getInterval(current, previous) {
          var cur = new Date(current);
          var prev = new Date(previous);

          // ms -> ns.
          return (cur.getTime() - prev.getTime()) * 1000000;
        }

        function parseCpu(machineInfo, containerInfo) {
          var cur = containerInfo.stats[containerInfo.stats.length - 1];
          var results = [];

          var cpuUsage = 0;
          if (containerInfo.spec.has_cpu && containerInfo.stats.length >= 2) {
            var prev = containerInfo.stats[containerInfo.stats.length - 2];
            var rawUsage = cur.cpu.usage.total - prev.cpu.usage.total;
            var intervalInNs = getInterval(cur.timestamp, prev.timestamp);

            // Convert to millicores and take the percentage
            cpuUsage = Math.round(((rawUsage / intervalInNs) / machineInfo.num_cores) * 100);
            if (cpuUsage > 100) {
              cpuUsage = 100;
            }
          }

          return {
            cpuPercentUsage: cpuUsage
          };
        }

        function parseFilesystems(machineInfo, containerInfo) {
          var cur = containerInfo.stats[containerInfo.stats.length - 1];
          if (!cur.filesystem) {
            return;
          }

          var filesystemData = [];
          for (var i = 0; i < cur.filesystem.length; i++) {
            var data = cur.filesystem[i];
            var totalUsage = Math.floor((data.usage * 100.0) / data.capacity);

            var f = {
              device: data.device,
              filesystemNumber: i + 1,
              usage: data.usage,
              usageDescription: humanizeMetric(data.usage),
              capacity: data.capacity,
              capacityDescription: humanizeMetric(data.capacity),
              totalUsage: Math.floor((data.usage * 100.0) / data.capacity)
            };

            filesystemData.push(f);
          }
          return filesystemData;
        }

        var oneMegabyte = 1024 * 1024;
        var oneGigabyte = 1024 * oneMegabyte;

        function parseMemory(machineInfo, containerInfo) {
          if (containerInfo.spec.has_memory && !hasResource(containerInfo, "memory")) {
            return;
          }

          // var titles = ["Time", "Total", "Hot"];
          var data = [];
          for (var i = 0; i < containerInfo.stats.length; i++) {
            var cur = containerInfo.stats[i];

            var elements = [];
            elements.push(cur.timestamp);
            elements.push(cur.memory.usage / oneMegabyte);
            elements.push(cur.memory.working_set / oneMegabyte);
            data.push(elements);
          }

          // Get the memory limit, saturate to the machine size.
          var memory_limit = machineInfo.memory_capacity;
          if (containerInfo.spec.memory.limit && (containerInfo.spec.memory.limit < memory_limit)) {
            memory_limit = containerInfo.spec.memory.limit;
          }

          var cur = containerInfo.stats[containerInfo.stats.length - 1];

          var r = {
            current: {
              memoryUsage: cur.memory.usage,
              workingMemoryUsage: cur.memory.working_set,
              memoryLimit: memory_limit,
              memoryUsageDescription: humanizeMetric(cur.memory.usage),
              workingMemoryUsageDescription: humanizeMetric(cur.memory.working_set),
              memoryLimitDescription: humanizeMetric(memory_limit)
            },
            historical: data
          };

          return r;
        }
      }]);
})();

app.provider('k8sApi',
             function() {

               var urlBase = '';

               this.setUrlBase = function(value) { urlBase = value; };

               var _get = function($http, baseUrl, query) {
                 var _fullUrl = baseUrl;
                 if (query !== undefined) {
                   _fullUrl += '/' + query;
                 }

                 return $http.get(_fullUrl);
               };

               this.$get = ["$http", "$q", function($http, $q) {
                 var api = {};

                 api.getUrlBase = function() { return urlBase; };

                 api.getPods = function(query) { return _get($http, urlBase + '/pods', query); };

                 api.getMinions = function(query) { return _get($http, urlBase + '/nodes', query); };

                 api.getNodes = api.getMinions;

                 api.getServices = function(query) { return _get($http, urlBase + '/services', query); };

                 api.getReplicationControllers = function(query) {
                   return _get($http, urlBase + '/replicationControllers', query)
                 };

                 api.getEvents = function(query) { return _get($http, urlBase + '/events', query); };

                 return api;
               }];
             })
    .config(["k8sApiProvider", "ENV", function(k8sApiProvider, ENV) {
      if (ENV && ENV['/'] && ENV['/']['k8sApiServer']) {
        var proxy = ENV['/']['cAdvisorProxy'] || '';
        k8sApiProvider.setUrlBase(proxy + ENV['/']['k8sApiServer']);
      }
    }]);

app.provider('k8sv1Beta3Api',
             function() {

               var urlBase = '';
               var _namespace = 'default';

               this.setUrlBase = function(value) { urlBase = value; };

               this.setNamespace = function(value) { _namespace = value; };
               this.getNamespace = function() { return _namespace; };

               var _get = function($http, baseUrl, query) {
                 var _fullUrl = baseUrl;

                 if (query !== undefined) {
                   _fullUrl += '/' + query;
                 }

                 return $http.get(_fullUrl);
               };

               this.$get = ["$http", "$q", function($http, $q) {
                 var api = {};

                 api.getUrlBase = function() { return urlBase + '/namespaces/' + _namespace; };

                 api.getPods = function(query) { return _get($http, api.getUrlBase() + '/pods', query); };

                 api.getMinions = function(query) { return _get($http, urlBase + '/nodes', query); };

                 api.getServices = function(query) { return _get($http, api.getUrlBase() + '/services', query); };

                 api.getReplicationControllers = function(query) {
                   return _get($http, api.getUrlBase() + '/replicationcontrollers', query)
                 };

                 api.getEvents = function(query) { return _get($http, api.getUrlBase() + '/events', query); };

                 return api;
               }];
             })
    .config(["k8sv1Beta3ApiProvider", "ENV", function(k8sv1Beta3ApiProvider, ENV) {
      if (ENV && ENV['/'] && ENV['/']['k8sApiv1beta3Server']) {
        var proxy = ENV['/']['cAdvisorProxy'] || '';
        k8sv1Beta3ApiProvider.setUrlBase(proxy + ENV['/']['k8sApiv1beta3Server']);
      }
    }]);

(function() {
  "use strict";

  var pollK8sDataServiceProvider = function PollK8sDataServiceProvider(_) {
    // A set of configuration controlling the polling behavior.
    // Their values should be configured in the application before
    // creating the service instance.

    var useSampleData = false;
    this.setUseSampleData = function(value) { useSampleData = value; };

    var sampleDataFiles = ["shared/assets/sampleData1.json"];
    this.setSampleDataFiles = function(value) { sampleDataFiles = value; };

    var dataServer = "http://localhost:5555/cluster";
    this.setDataServer = function(value) { dataServer = value; };

    var pollMinIntervalSec = 10;
    this.setPollMinIntervalSec = function(value) { pollMinIntervalSec = value; };

    var pollMaxIntervalSec = 120;
    this.setPollMaxIntervalSec = function(value) { pollMaxIntervalSec = value; };

    var pollErrorThreshold = 5;
    this.setPollErrorThreshold = function(value) { pollErrorThreshold = value; };

    this.$get = function($http, $timeout) {
      // Now the sequenceNumber will be used for debugging and verification purposes.
      var k8sdatamodel = {
        "data": undefined,
        "sequenceNumber": 0,
        "useSampleData": useSampleData
      };
      var pollingError = 0;
      var promise = undefined;

      // Implement fibonacci back off when the service is down.
      var pollInterval = pollMinIntervalSec;
      var pollIncrement = pollInterval;

      // Reset polling interval.
      var resetCounters = function() {
        pollInterval = pollMinIntervalSec;
        pollIncrement = pollInterval;
      };

      // Bump error count and polling interval.
      var bumpCounters = function() {
        // Bump the error count.
        pollingError++;

        // TODO: maybe display an error in the UI to the end user.
        if (pollingError % pollErrorThreshold === 0) {
          console.log("Error: " + pollingError + " consecutive polling errors for " + dataServer + ".");
        }

        // Bump the polling interval.
        var oldIncrement = pollIncrement;
        pollIncrement = pollInterval;
        pollInterval += oldIncrement;

        // Reset when limit reached.
        if (pollInterval > pollMaxIntervalSec) {
          resetCounters();
        }
      };

      var updateModel = function(newModel) {
        var dedupe = function(dataModel) {
          if (dataModel.resources) {
            dataModel.resources = _.uniq(dataModel.resources, function(resource) { return resource.id; });
          }

          if (dataModel.relations) {
            dataModel.relations =
                _.uniq(dataModel.relations, function(relation) { return relation.source + relation.target; });
          }
        };

        dedupe(newModel);

        var newModelString = JSON.stringify(newModel);
        var oldModelString = "";
        if (k8sdatamodel.data) {
          oldModelString = JSON.stringify(k8sdatamodel.data);
        }

        if (newModelString !== oldModelString) {
          k8sdatamodel.data = newModel;
          k8sdatamodel.sequenceNumber++;
        }

        pollingError = 0;
        resetCounters();
      };

      var nextSampleDataFile = 0;
      var getSampleDataFile = function() {
        var result = "";
        if (sampleDataFiles.length > 0) {
          result = sampleDataFiles[nextSampleDataFile % sampleDataFiles.length];
          ++nextSampleDataFile;
        }

        return result;
      };

      var pollOnce = function(scope, repeat) {
        var dataSource = (k8sdatamodel.useSampleData) ? getSampleDataFile() : dataServer;
        $.getJSON(dataSource)
            .done(function(newModel, jqxhr, textStatus) {
              if (newModel && newModel.success) {
                delete newModel.success;    // Remove success indicator.
                delete newModel.timestamp;  // Remove changing timestamp.
                updateModel(newModel);
                scope.$apply();
                promise = repeat ? $timeout(function() { pollOnce(scope, true); }, pollInterval * 1000) : undefined;
                return;
              }

              bumpCounters();
              promise = repeat ? $timeout(function() { pollOnce(scope, true); }, pollInterval * 1000) : undefined;
            })
            .fail(function(jqxhr, textStatus, error) {
              bumpCounters();
              promise = repeat ? $timeout(function() { pollOnce(scope, true); }, pollInterval * 1000) : undefined;
            });
      };

      var isPolling = function() { return promise ? true : false; };

      var start = function(scope) {
        // If polling has already started, then calling start() again would
        // just reset the counters and polling interval, but it will not
        // start a new thread polling in parallel to the existing polling
        // thread.
        resetCounters();
        if (!promise) {
          k8sdatamodel.data = undefined;
          pollOnce(scope, true);
        }
      };

      var stop = function() {
        if (promise) {
          $timeout.cancel(promise);
          promise = undefined;
        }
      };

      var refresh = function(scope) {
        stop(scope);
        resetCounters();
        k8sdatamodel.data = undefined;
        pollOnce(scope, false);
      };

      return {
        "k8sdatamodel": k8sdatamodel,
        "isPolling": isPolling,
        "refresh": refresh,
        "start": start,
        "stop": stop
      };
    };
  };

  angular.module("kubernetesApp.services")
      .provider("pollK8sDataService", ["lodash", pollK8sDataServiceProvider])
      .config(["pollK8sDataServiceProvider", "ENV", function(pollK8sDataServiceProvider, ENV) {
        if (ENV && ENV['/']) {
          if (ENV['/']['k8sDataServer']) {
            pollK8sDataServiceProvider.setDataServer(ENV['/']['k8sDataServer']);
          }
          if (ENV['/']['k8sDataPollIntervalMinSec']) {
            pollK8sDataServiceProvider.setPollIntervalSec(ENV['/']['k8sDataPollIntervalMinSec']);
          }
          if (ENV['/']['k8sDataPollIntervalMaxSec']) {
            pollK8sDataServiceProvider.setPollIntervalSec(ENV['/']['k8sDataPollIntervalMaxSec']);
          }
          if (ENV['/']['k8sDataPollErrorThreshold']) {
            pollK8sDataServiceProvider.setPollErrorThreshold(ENV['/']['k8sDataPollErrorThreshold']);
          }
        }
      }]);

}());

/**=========================================================
 * Module: toggle-state.js
 * Services to share toggle state functionality
 =========================================================*/


app.controller('cAdvisorController', [
  '$scope',
  '$routeParams',
  'k8sApi',
  'lodash',
  'cAdvisorService',
  '$q',
  '$interval',
  function($scope, $routeParams, k8sApi, lodash, cAdvisorService, $q, $interval) {
    $scope.k8sApi = k8sApi;

    $scope.activeMinionDataById = {};
    $scope.maxDataByById = {};

    $scope.getData = function() {
      $scope.loading = true;

      k8sApi.getMinions().success(angular.bind(this, function(res) {
        $scope.minions = res;
        // console.log(res);
        var promises = lodash.map(res.items, function(m) { return cAdvisorService.getDataForMinion(m.id); });

        $q.all(promises).then(
            function(dataArray) {
              lodash.each(dataArray, function(data, i) {
                var m = res.items[i];

                var maxData = maxMemCpuInfo(m.id, data.memoryData, data.cpuData, data.filesystemData);

                // console.log("maxData", maxData);

                $scope.activeMinionDataById[m.id] =
                    transformMemCpuInfo(data.memoryData, data.cpuData, data.filesystemData, maxData, m.hostIP)
              });

            },
            function(errorData) {
              // console.log("Error: " + errorData);
              $scope.loading = false;
            });

        $scope.loading = false;
      })).error(angular.bind(this, this.handleError));
    };

    function getcAdvisorDataForMinion(m) {
      var p = cAdvisorService.getDataForMinion(m.hostIP);
      return p;
    }

    function handleError(data, status, headers, config) {
      // console.log("Error (" + status + "): " + data);
      $scope.loading = false;
    };

    // d3
    function getColorForIndex(i, percentage) {
      // var colors = ['red', 'blue', 'yellow', 'pink', 'purple', 'green', 'orange'];
      // return colors[i];
      var c = "color-" + (i + 1);
      if (percentage && percentage >= 90)
        c = c + ' color-critical';
      else if (percentage && percentage >= 80)
        c = c + ' color-warning';

      return c;
    }

    function getMaxColorForIndex(i, percentage) {
      // var colors = ['red', 'blue', 'yellow', 'pink', 'purple', 'green', 'orange'];
      // return colors[i];
      var c = "color-max-" + (i + 1);
      if (percentage && percentage >= 90)
        c = c + ' color-max-critical';
      else if (percentage && percentage >= 80)
        c = c + ' color-max-warning';

      return c;
    }

    function maxMemCpuInfo(mId, mem, cpu, fsDataArray) {
      if ($scope.maxDataByById[mId] === undefined) $scope.maxDataByById[mId] = {};

      var currentMem = mem.current;
      var currentCpu = cpu;

      var items = [];

      if ($scope.maxDataByById[mId]['cpu'] === undefined ||
          $scope.maxDataByById[mId]['cpu'] < currentCpu.cpuPercentUsage) {
        // console.log("New max cpu " + mId, $scope.maxDataByById[mId].cpu, currentCpu.cpuPercentUsage);
        $scope.maxDataByById[mId]['cpu'] = currentCpu.cpuPercentUsage;
      }
      items.push({
        maxValue: $scope.maxDataByById[mId]['cpu'],
        maxTickClassNames: getColorForIndex(0, $scope.maxDataByById[mId]['cpu']),
        maxClassNames: getMaxColorForIndex(0, $scope.maxDataByById[mId]['cpu'])
      });

      var memPercentage = Math.floor((currentMem.memoryUsage * 100.0) / currentMem.memoryLimit);
      if ($scope.maxDataByById[mId]['mem'] === undefined || $scope.maxDataByById[mId]['mem'] < memPercentage)
        $scope.maxDataByById[mId]['mem'] = memPercentage;
      items.push({
        maxValue: $scope.maxDataByById[mId]['mem'],
        maxTickClassNames: getColorForIndex(1, $scope.maxDataByById[mId]['mem']),
        maxClassNames: getMaxColorForIndex(1, $scope.maxDataByById[mId]['mem'])
      });

      for (var i = 0; i < fsDataArray.length; i++) {
        var f = fsDataArray[i];
        var fid = 'FS #' + f.filesystemNumber;
        if ($scope.maxDataByById[mId][fid] === undefined || $scope.maxDataByById[mId][fid] < f.totalUsage)
          $scope.maxDataByById[mId][fid] = f.totalUsage;
        items.push({
          maxValue: $scope.maxDataByById[mId][fid],
          maxTickClassNames: getColorForIndex(2 + i, $scope.maxDataByById[mId][fid]),
          maxClassNames: getMaxColorForIndex(2 + i, $scope.maxDataByById[mId][fid])
        });
      }

      // console.log("Max Data is now " + mId, $scope.maxDataByById[mId]);
      return items;
    }

    function transformMemCpuInfo(mem, cpu, fsDataArray, maxData, hostName) {
      var currentMem = mem.current;
      var currentCpu = cpu;

      var items = [];

      items.push({
        label: 'CPU',
        stats: currentCpu.cpuPercentUsage + '%',
        value: currentCpu.cpuPercentUsage,
        classNames: getColorForIndex(0, currentCpu.cpuPercentUsage),
        maxData: maxData[0],
        hostName: hostName
      });

      var memPercentage = Math.floor((currentMem.memoryUsage * 100.0) / currentMem.memoryLimit);
      items.push({
        label: 'Memory',
        stats: currentMem.memoryUsageDescription + ' / ' + currentMem.memoryLimitDescription,
        value: memPercentage,
        classNames: getColorForIndex(1, memPercentage),
        maxData: maxData[1],
        hostName: hostName
      });

      for (var i = 0; i < fsDataArray.length; i++) {
        var f = fsDataArray[i];

        items.push({
          label: 'FS #' + f.filesystemNumber,
          stats: f.usageDescription + ' / ' + f.capacityDescription,
          value: f.totalUsage,
          classNames: getColorForIndex(2 + i, f.totalUsage),
          maxData: maxData[2 + i],
          hostName: hostName

        });
      }

      var a = [];
      var segments = {
        segments: items
      };
      a.push(segments);
      return a;
    };

    // end d3
    var promise = $interval($scope.getData, 3000);

    // Cancel interval on page changes
    $scope.$on('$destroy', function() {
      if (angular.isDefined(promise)) {
        $interval.cancel(promise);
        promise = undefined;
      }
    });

    $scope.getData();

  }
]);

/**=========================================================
 * Module: Dashboard
 * Visualizer for clusters
 =========================================================*/

app.controller('DashboardCtrl', ['$scope', function($scope) {}]);

/**=========================================================
 * Module: Group
 * Visualizer for groups
 =========================================================*/

app.controller('GroupCtrl', [
  '$scope',
  '$route',
  '$interval',
  '$routeParams',
  'k8sApi',
  '$rootScope',
  '$location',
  'lodash',
  function($scope, $route, $interval, $routeParams, k8sApi, $rootScope, $location, _) {
    'use strict';
    $scope.doTheBack = function() { window.history.back(); };

    $scope.capitalize = function(s) { return _.capitalize(s); };

    $rootScope.doTheBack = $scope.doTheBack;

    $scope.resetGroupLayout = function(group) { delete group.settings; };

    $scope.handlePath = function(path) {
      var parts = path.split("/");
      // split leaves an empty string at the beginning.
      parts = parts.slice(1);

      if (parts.length === 0) {
        return;
      }
      this.handleGroups(parts.slice(1));
    };

    $scope.getState = function(obj) { return Object.keys(obj)[0]; };

    $scope.clearSelector = function(grouping) { $location.path("/dashboard/groups/" + grouping + "/selector/"); };

    $scope.changeGroupBy = function() {
      var grouping = $scope.selectedGroupBy;

      var s = _.clone($location.search());
      if ($scope.routeParams.grouping != grouping)
        $location.path("/dashboard/groups/" + grouping + "/selector/").search(s);
    };

    $scope.createBarrier = function(count, callback) {
      var barrier = count;
      var barrierFunction = angular.bind(this, function(data) {
        // JavaScript is single threaded so this is safe.
        barrier--;
        if (barrier === 0) {
          if (callback) {
            callback();
          }
        }
      });
      return barrierFunction;
    };

    $scope.handleGroups = function(parts, selector) {
      $scope.groupBy = parts;
      $scope.loading = true;
      $scope.selector = selector;
      var args = [];
      var type = "";
      if (selector && selector.length > 0) {
        $scope.selectorPieces = selector.split(",");
        var labels = [];
        var fields = [];
        for (var i = 0; i < $scope.selectorPieces.length; i++) {
          var piece = $scope.selectorPieces[i];
          if (piece[0] == '$') {
            fields.push(piece.slice(2));
          } else {
            if (piece.indexOf("type=") === 0) {
              var labelParts = piece.split("=");
              if (labelParts.length > 1) {
                type = labelParts[1];
              }
            } else {
              labels.push(piece);
            }
          }
        }
        if (labels.length > 0) {
          args.push("labels=" + encodeURI(labels.join(",")));
        }
        if (fields.length > 0) {
          args.push("fields=" + encodeURI(fields.join(",")));
        }
      }
      var query = "?" + args.join("&");
      var list = [];
      var count = type.length > 0 ? 1 : 3;
      var barrier = $scope.createBarrier(count, function() {
        $scope.groups = $scope.groupData(list, 0);
        $scope.loading = false;
        $scope.groupByOptions = buildGroupByOptions();
        $scope.selectedGroupBy = $routeParams.grouping;
      });

      if (type === "" || type == "pod") {
        k8sApi.getPods(query).success(function(data) {
          $scope.addLabel("type", "pod", data.items);
          for (var i = 0; data.items && i < data.items.length; ++i) {
            data.items[i].labels.host = data.items[i].currentState.host;
            list.push(data.items[i]);
          }
          barrier();
        }).error($scope.handleError);
      }
      if (type === "" || type == "service") {
        k8sApi.getServices(query).success(function(data) {
          $scope.addLabel("type", "service", data.items);
          for (var i = 0; data.items && i < data.items.length; ++i) {
            list.push(data.items[i]);
          }
          barrier();
        }).error($scope.handleError);
      }
      if (type === "" || type == "replicationController") {
        k8sApi.getReplicationControllers(query).success(angular.bind(this, function(data) {
          $scope.addLabel("type", "replicationController", data.items);
          for (var i = 0; data.items && i < data.items.length; ++i) {
            list.push(data.items[i]);
          }
          barrier();
        })).error($scope.handleError);
      }
    };

    $scope.addLabel = function(key, value, items) {
      if (!items) {
        return;
      }
      for (var i = 0; i < items.length; i++) {
        if (!items[i].labels) {
          items[i].labels = [];
        }
        items[i].labels[key] = value;
      }
    };

    $scope.groupData = function(items, index) {
      var result = {
        "items": {},
        "kind": "grouping"
      };
      for (var i = 0; i < items.length; i++) {
        key = items[i].labels[$scope.groupBy[index]];
        if (!key) {
          key = "";
        }
        var list = result.items[key];
        if (!list) {
          list = [];
          result.items[key] = list;
        }
        list.push(items[i]);
      }

      if (index + 1 < $scope.groupBy.length) {
        for (var key in result.items) {
          result.items[key] = $scope.groupData(result.items[key], index + 1);
        }
      }
      return result;
    };
    $scope.getGroupColor = function(type) {
      if (type === 'pod') {
        return '#6193F0';
      } else if (type === 'replicationController') {
        return '#E008FE';
      } else if (type === 'service') {
        return '#7C43FF';
      }
    };

    var groups = $routeParams.grouping;
    if (!groups) {
      groups = '';
    }

    $scope.routeParams = $routeParams;
    $scope.route = $route;

    $scope.handleGroups(groups.split('/'), $routeParams.selector);

    $scope.handleError = function(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope_.loading = false;
    };

    function getDefaultGroupByOptions() { return [{name: 'Type', value: 'type'}, {name: 'Name', value: 'name'}]; }

    function buildGroupByOptions() {
      var g = $scope.groups;
      var options = getDefaultGroupByOptions();
      var newOptions = _.map(g.items, function(vals) { return _.map(vals, function(v) { return _.keys(v.labels); }); });
      newOptions =
          _.reject(_.uniq(_.flattenDeep(newOptions)), function(o) { return o == 'name' || o == 'type' || o == ""; });
      newOptions = _.map(newOptions, function(o) {
        return {
          name: o,
          value: o
        };
      });

      options = options.concat(newOptions);
      return options;
    }

    $scope.changeFilterBy = function(selector) {
      var grouping = $scope.selectedGroupBy;

      var s = _.clone($location.search());
      if ($scope.routeParams.selector != selector)
        $location.path("/dashboard/groups/" + $scope.routeParams.grouping + "/selector/" + selector).search(s);
    };
  }
]);

/**=========================================================
 * Module: Header
 * Visualizer for clusters
 =========================================================*/

angular.module('kubernetesApp.components.dashboard', [])
    .controller('HeaderCtrl', [
      '$scope',
      '$location',
      function($scope, $location) {
        'use strict';
        $scope.$watch('Pages', function(newValue, oldValue) {
          if (typeof newValue !== 'undefined') {
            $location.path(newValue);
          }
        });

        $scope.subPages = [
          {category: 'dashboard', name: 'Explore', value: '/dashboard/groups/type/selector/'},
          {category: 'dashboard', name: 'Pods', value: '/dashboard/pods'},
          {category: 'dashboard', name: 'Nodes', value: '/dashboard/nodes'},
          {category: 'dashboard', name: 'Replication Controllers', value: '/dashboard/replicationcontrollers'},
          {category: 'dashboard', name: 'Services', value: '/dashboard/services'},
          {category: 'dashboard', name: 'Events', value: '/dashboard/events'}
        ];
      }
    ]);

/**=========================================================
 * Module: List Events
 * Visualizer list events
 =========================================================*/

app.controller('ListEventsCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  '$location',
  '$filter',
  function($scope, $routeParams, k8sApi, $location, $filter) {
    'use strict';
    $scope.getData = getData;
    $scope.loading = true;
    $scope.k8sApi = k8sApi;
    $scope.pods = null;
    $scope.groupedPods = null;
    $scope.serverView = false;

    $scope.headers = [
      {name: 'Time', field: 'time'},
      {name: 'From', field: 'from'},
      {name: 'Sub Object Path', field: 'subobject'},
      {name: 'Reason', field: 'reason'},
      {name: 'Message', field: 'message'}
    ];

    $scope.custom = {
      time: '',
      from: 'grey',
      subobject: 'grey',
      reason: 'grey',
      message: 'grey'
    };
    $scope.sortable = ['time', 'from', 'subobject'];
    $scope.thumbs = 'thumb';
    $scope.count = 10;

    $scope.go = function(d) { $location.path('/dashboard/pods/' + d.id); };

    function handleError(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope.loading = false;
    }

    $scope.content = [];

    function getData() {
      $scope.loading = true;
      k8sApi.getEvents().success(function(data) {
        $scope.loading = false;

        var _fixComma = function(str) {
          if (str.substring(0, 1) == ',') {
            return str.substring(1);
          } else {
            return str;
          }
        };

        data.items.forEach(function(event) {

          $scope.content.push({
            time: $filter('date')(event.timestamp, 'medium'),
            from: event.source,
            subobject: event.involvedObject.fieldPath,
            reason: event.reason,
            message: event.message
          });

        });

      }).error($scope.handleError);
    }

    getData();

  }
]);

/**=========================================================
 * Module: Minions
 * Visualizer for minions
 =========================================================*/

app.controller('ListMinionsCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  '$location',
  function($scope, $routeParams, k8sApi, $location) {
    'use strict';
    $scope.getData = getData;
    $scope.loading = true;
    $scope.k8sApi = k8sApi;
    $scope.pods = null;
    $scope.groupedPods = null;
    $scope.serverView = false;

    $scope.headers = [{name: 'Name', field: 'name'}, {name: 'IP', field: 'ip'}, {name: 'Status', field: 'status'}];

    $scope.custom = {
      name: '',
      status: 'grey',
      ip: 'grey'
    };
    $scope.sortable = ['name', 'status', 'ip'];
    $scope.thumbs = 'thumb';
    $scope.count = 10;

    $scope.go = function(data) { $location.path('/dashboard/nodes/' + data.name); };

    function handleError(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope.loading = false;
    }

    $scope.content = [];

    function getData() {
      $scope.loading = true;
      k8sApi.getMinions().success(function(data) {
        $scope.loading = false;

        var _fixComma = function(str) {
          if (str.substring(0, 1) == ',') {
            return str.substring(1);
          } else {
            return str;
          }
        };

        data.items.forEach(function(minion) {
          var _kind = '';

          if (minion.status.conditions) {
            Object.keys(minion.status.conditions)
                .forEach(function(key) { _kind += minion.status.conditions[key].kind; });
          }

          $scope.content.push({name: minion.id, ip: minion.hostIP, status: _kind});

        });

      }).error($scope.handleError);
    }

    getData();

  }
]);



app.controller('ListPodsCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  'lodash',
  '$location',
  function($scope, $routeParams, k8sApi, lodash, $location) {
    var _ = lodash;
    $scope.getData = getData;
    $scope.loading = true;
    $scope.k8sApi = k8sApi;
    $scope.pods = null;
    $scope.groupedPods = null;
    $scope.serverView = false;

    $scope.headers = [
      {name: 'Pod', field: 'pod'},
      {name: 'IP', field: 'ip'},
      {name: 'Status', field: 'status'},
      {name: 'Containers', field: 'containers'},
      {name: 'Images', field: 'images'},
      {name: 'Host', field: 'host'},
      {name: 'Labels', field: 'labels'}
    ];

    $scope.custom = {
      pod: '',
      ip: 'grey',
      containers: 'grey',
      images: 'grey',
      host: 'grey',
      labels: 'grey',
      status: 'grey'
    };
    $scope.sortable = ['pod', 'ip', 'status'];
    $scope.count = 10;

    $scope.go = function(data) { $location.path('/dashboard/pods/' + data.pod); };

    var orderedPodNames = [];

    function handleError(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope.loading = false;
    };

    function getPodName(pod) { return _.has(pod.labels, 'name') ? pod.labels.name : pod.id; }

    $scope.content = [];

    function getData() {
      $scope.loading = true;
      k8sApi.getPods().success(angular.bind(this, function(data) {
        $scope.loading = false;

        var _fixComma = function(str) {
          if (str.substring(0, 1) == ',') {
            return str.substring(1);
          } else {
            return str;
          }
        };

        data.items.forEach(function(pod) {
          var _containers = '', _images = '', _labels = '', _uses = '';

          if (pod.desiredState.manifest) {
            Object.keys(pod.desiredState.manifest.containers)
                .forEach(function(key) {
                  _containers += ', ' + pod.desiredState.manifest.containers[key].name;
                  _images += ', ' + pod.desiredState.manifest.containers[key].image;
                });
          }

          if (pod.labels) {
            Object.keys(pod.labels)
                .forEach(function(key) {
                  if (key == 'name') {
                    _labels += ', ' + pod.labels[key];
                  }
                  if (key == 'uses') {
                    _uses += ', ' + pod.labels[key];
                  }
                });
            }

          $scope.content.push({
            pod: pod.id,
            ip: pod.currentState.podIP,
            containers: _fixComma(_containers),
            images: _fixComma(_images),
            host: pod.currentState.host,
            labels: _fixComma(_labels) + ':' + _fixComma(_uses),
            status: pod.currentState.status
          });

        });

      })).error(angular.bind(this, handleError));
    };

    $scope.getPodRestarts = function(pod) {
      var r = null;
      var container = _.first(pod.desiredState.manifest.containers);
      if (container) r = pod.currentState.info[container.name].restartCount;
      return r;
    };

    $scope.otherLabels = function(labels) { return _.omit(labels, 'name') };

    $scope.podStatusClass = function(pod) {

      var s = pod.currentState.status.toLowerCase();

      if (s == 'running' || s == 'succeeded')
        return null;
      else
        return "status-" + s;
    };

    $scope.podIndexFromName = function(pod) {
      var name = getPodName(pod);
      return _.indexOf(orderedPodNames, name) + 1;
    };

    getData();

  }
]);

/**=========================================================
 * Module: Replication Controllers
 * Visualizer for replication controllers
 =========================================================*/

app.controller('ListReplicationControllersCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  '$location',
  function($scope, $routeParams, k8sApi, $location) {
    'use strict';
    $scope.getData = getData;
    $scope.loading = true;
    $scope.k8sApi = k8sApi;
    $scope.pods = null;
    $scope.groupedPods = null;
    $scope.serverView = false;

    $scope.headers = [
      {name: 'Controller', field: 'controller'},
      {name: 'Containers', field: 'containers'},
      {name: 'Images', field: 'images'},
      {name: 'Selector', field: 'selector'},
      {name: 'Replicas', field: 'replicas'}
    ];

    $scope.custom = {
      controller: '',
      containers: 'grey',
      images: 'grey',
      selector: 'grey',
      replicas: 'grey'
    };
    $scope.sortable = ['controller', 'containers', 'images'];
    $scope.thumbs = 'thumb';
    $scope.count = 10;

    $scope.go = function(data) { $location.path('/dashboard/replicationcontrollers/' + data.controller); };

    function handleError(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope.loading = false;
    }

    $scope.content = [];

    function getData() {
      $scope.loading = true;
      k8sApi.getReplicationControllers().success(function(data) {
        $scope.loading = false;

        var _fixComma = function(str) {
          if (str.substring(0, 1) == ',') {
            return str.substring(1);
          } else {
            return str;
          }
        };

        data.items.forEach(function(replicationController) {

          var _name = '', _image = '';

          if (replicationController.desiredState.podTemplate.desiredState.manifest.containers) {
            Object.keys(replicationController.desiredState.podTemplate.desiredState.manifest.containers)
                .forEach(function(key) {
                  _name += replicationController.desiredState.podTemplate.desiredState.manifest.containers[key].name;
                  _image += replicationController.desiredState.podTemplate.desiredState.manifest.containers[key].image;
                });
          }

          var _name_selector = '';

          if (replicationController.desiredState.replicaSelector) {
            Object.keys(replicationController.desiredState.replicaSelector)
                .forEach(function(key) { _name_selector += replicationController.desiredState.replicaSelector[key]; });
          }

          $scope.content.push({
            controller: replicationController.id,
            containers: _name,
            images: _image,
            selector: _name_selector,
            replicas: replicationController.currentState.replicas
          });

        });

      }).error($scope.handleError);
    }

    getData();

  }
]);

/**=========================================================
 * Module: Services
 * Visualizer for services
 =========================================================*/

app.controller('ListServicesCtrl', [
  '$scope',
  '$interval',
  '$routeParams',
  'k8sApi',
  '$rootScope',
  '$location',
  function($scope, $interval, $routeParams, k8sApi, $rootScope, $location) {
    'use strict';
    $scope.doTheBack = function() { window.history.back(); };

    $scope.headers = [
      {name: 'Name', field: 'name'},
      {name: 'Labels', field: 'labels'},
      {name: 'Selector', field: 'selector'},
      {name: 'IP', field: 'ip'},
      {name: 'Port', field: 'port'}
    ];

    $scope.custom = {
      name: '',
      ip: 'grey',
      selector: 'grey',
      port: 'grey',
      labels: 'grey'
    };
    $scope.sortable = ['name', 'ip', 'port'];
    $scope.count = 10;

    $scope.go = function(data) { $location.path('/dashboard/services/' + data.name); };

    $scope.content = [];

    $rootScope.doTheBack = $scope.doTheBack;

    $scope.handleError = function(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope_.loading = false;
    };

    $scope.getData = function() {
      $scope.loading = true;
      k8sApi.getServices().success(angular.bind(this, function(data) {
        $scope.services = data;
        $scope.loading = false;

        var _fixComma = function(str) {
          if (str.substring(0, 1) == ',') {
            return str.substring(1);
          } else {
            return str;
          }
        };

        var addLabel = function(str, label) {
          if (str) {
            str = label + str;
          }
          return str;
        };

        if (data.items.constructor === Array) {
          data.items.forEach(function(service) {

            var _name = '', _uses = '', _component = '', _provider = '';

            if (service.labels !== null && typeof service.labels === 'object') {
              Object.keys(service.labels)
                  .forEach(function(key) {
                    if (key == 'name') {
                      _name += ',' + service.labels[key];
                    }
                    if (key == 'component') {
                      _component += ',' + service.labels[key];
                    }
                    if (key == 'provider') {
                      _provider += ',' + service.labels[key];
                    }
                  });
            }

            var _selectors = '';

            if (service.selector !== null && typeof service.selector === 'object') {
              Object.keys(service.selector)
                  .forEach(function(key) {
                    if (key == 'name') {
                      _selectors += ',' + service.selector[key];
                    }
                  });
            }

            $scope.content.push({
              name: service.id,
              ip: service.portalIP,
              port: service.port,
              selector: addLabel(_fixComma(_selectors), 'name='),
              labels: addLabel(_fixComma(_name), 'name=') + ' ' + addLabel(_fixComma(_component), 'component=') + ' ' +
                          addLabel(_fixComma(_provider), 'provider=')
            });
          });
        }
      })).error($scope.handleError);
    };

    $scope.getData();
  }
]);

/**=========================================================
 * Module: Nodes
 * Visualizer for nodes
 =========================================================*/

app.controller('NodeCtrl', [
  '$scope',
  '$interval',
  '$routeParams',
  'k8sApi',
  '$rootScope',
  function($scope, $interval, $routeParams, k8sApi, $rootScope) {
    'use strict';
    $scope.doTheBack = function() { window.history.back(); };

    $rootScope.doTheBack = $scope.doTheBack;

    $scope.handleError = function(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope_.loading = false;
    };

    $scope.handleNode = function(nodeId) {
      $scope.loading = true;
      k8sApi.getNodes(nodeId).success(angular.bind(this, function(data) {
        $scope.node = data;
        $scope.loading = false;
      })).error($scope.handleError);
    };

    $scope.handleNode($routeParams.nodeId);
  }
]);

/**=========================================================
 * Module: Pods
 * Visualizer for pods
 =========================================================*/

app.controller('PodCtrl', [
  '$scope',
  '$interval',
  '$routeParams',
  'k8sApi',
  '$rootScope',
  function($scope, $interval, $routeParams, k8sApi, $rootScope) {
    'use strict';
    $scope.doTheBack = function() { window.history.back(); };

    $rootScope.doTheBack = $scope.doTheBack;

    $scope.handleError = function(data, status, headers, config) {
      console.log("Error (" + status + "): " + data);
      $scope_.loading = false;
    };

    $scope.handlePod = function(podId) {
      $scope.loading = true;
      k8sApi.getPods(podId).success(angular.bind(this, function(data) {
        $scope.pod = data;
        $scope.loading = false;
      })).error($scope.handleError);
    };

    $scope.handlePod($routeParams.podId);
  }
]);

/**=========================================================
 * Module: Replication
 * Visualizer for replication controllers
 =========================================================*/

function ReplicationController() {
}

ReplicationController.prototype.getData = function(dataId) {
  this.scope.loading = true;
  this.k8sApi.getReplicationControllers(dataId).success(angular.bind(this, function(data) {
    this.scope.replicationController = data;
    this.scope.loading = false;
  })).error(angular.bind(this, this.handleError));
};

ReplicationController.prototype.handleError = function(data, status, headers, config) {
  console.log("Error (" + status + "): " + data);
  this.scope.loading = false;
};

app.controller('ReplicationControllerCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  function($scope, $routeParams, k8sApi) {
    $scope.controller = new ReplicationController();
    $scope.controller.k8sApi = k8sApi;
    $scope.controller.scope = $scope;
    $scope.controller.getData($routeParams.replicationControllerId);

    $scope.doTheBack = function() { window.history.back(); };

  }
]);

/**=========================================================
 * Module: Services
 * Visualizer for services
 =========================================================*/

function ServiceController() {
}

ServiceController.prototype.getData = function(dataId) {
  this.scope.loading = true;
  this.k8sApi.getServices(dataId).success(angular.bind(this, function(data) {
    this.scope.service = data;
    this.scope.loading = false;
  })).error(angular.bind(this, this.handleError));
};

ServiceController.prototype.handleError = function(data, status, headers, config) {
  console.log("Error (" + status + "): " + data);
  this.scope.loading = false;
};

app.controller('ServiceCtrl', [
  '$scope',
  '$routeParams',
  'k8sApi',
  '$location',
  function($scope, $routeParams, k8sApi, $location) {
    $scope.controller = new ServiceController();
    $scope.controller.k8sApi = k8sApi;
    $scope.controller.scope = $scope;
    $scope.controller.getData($routeParams.serviceId);

    $scope.doTheBack = function() { window.history.back(); };

  }
]);

(function() {
  'use strict';

  angular.module('kubernetesApp.components.dashboard')
      .directive('d3MinionBarGauge', [
        'd3DashboardService',
        function(d3DashboardService) {

          return {
            restrict: 'E',
            scope: {
              data: '=',
              thickness: '@',
              graphWidth: '@',
              graphHeight: '@'

            },
            link: function(scope, element, attrs) {

              var draw = function(d3) {
                var svg = d3.select("svg.chart");
                var legendSvg = d3.select("svg.legend");
                window.onresize = function() { return scope.$apply(); };

                scope.$watch(function() { return angular.element(window)[0].innerWidth; },
                             function() { return scope.render(scope.data); });

                scope.$watch('data', function(newVals, oldVals) {
                  return initOrUpdate(newVals, oldVals);

                }, true);

                function initOrUpdate(newVals, oldVals) {
                  if (oldVals === null || oldVals === undefined) {
                    return scope.render(newVals);
                  } else {
                    return update(oldVals, newVals);
                  }
                }

                var textOffset = 10;
                var el = null;
                var radius = 100;
                var oldData = [];

                function init(options) {
                  var clone = options.data;
                  var preparedData = setData(clone);
                  setup(preparedData, options.width, options.height);
                }

                function setup(data, w, h) {
                  svg = d3.select(element[0]).append("svg").attr("width", "100%");

                  legendSvg = d3.select(element[0]).append("svg").attr("width", "100%");

                  var chart = svg.attr("class", "chart")
                                  .attr("width", w)
                                  .attr("height", h - 25)
                                  .append("svg:g")
                                  .attr("class", "concentricchart")
                                  .attr("transform", "translate(" + ((w / 2)) + "," + h / 4 + ")");

                  var legend = legendSvg.attr("class", "legend").attr("width", w);

                  radius = Math.min(w, h) / 2;

                  var hostName = legendSvg.append("text")
                                     .attr("class", "hostName")
                                     .attr("transform", "translate(" + ((w - 120) / 2) + "," + 15 + ")");

                  var label_legend_area = legendSvg.append("svg:g")
                                              .attr("class", "label_legend_area")
                                              .attr("transform", "translate(" + ((w - 185) / 2) + "," + 35 + ")");

                  var legend_group = label_legend_area.append("svg:g").attr("class", "legend_group");

                  var label_group = label_legend_area.append("svg:g")
                                        .attr("class", "label_group")
                                        .attr("transform", "translate(" + 25 + "," + 11 + ")");

                  var stats_group = label_legend_area.append("svg:g")
                                        .attr("class", "stats_group")
                                        .attr("transform", "translate(" + 85 + "," + 11 + ")");

                  var path_group = chart.append("svg:g")
                                       .attr("class", "path_group")
                                       .attr("transform", "translate(0," + (h / 4) + ")");
                  var value_group = chart.append("svg:g")
                                        .attr("class", "value_group")
                                        .attr("transform", "translate(" + -(w * 0.205) + "," + -(h * 0.10) + ")");
                  generateArcs(chart, data);
                }

                function update(_oldData, _newData) {
                  if (_newData === undefined || _newData === null) {
                    return;
                  }

                  var clone = jQuery.extend(true, {}, _newData);
                  var cloneOld = jQuery.extend(true, {}, _oldData);
                  var preparedData = setData(clone);
                  oldData = setData(cloneOld);
                  animate(preparedData);
                }

                function animate(data) { generateArcs(null, data); }

                function setData(data) {
                  var diameter = 2 * Math.PI * radius;
                  var localData = [];

                  $.each(data[0].segments, function(ri, value) {

                    function calcAngles(v) {
                      var segmentValueSum = 200;
                      if (v > segmentValueSum) {
                        v = segmentValueSum;
                      }

                      var segmentValue = v;
                      var fraction = segmentValue / segmentValueSum;
                      var arcBatchLength = fraction * 4 * Math.PI;
                      var arcPartition = arcBatchLength;
                      var startAngle = Math.PI * 2;
                      var endAngle = startAngle + arcPartition;

                      return {
                        startAngle: startAngle,
                        endAngle: endAngle
                      };
                    }

                    var valueData = calcAngles(value.value);
                    data[0].segments[ri].startAngle = valueData.startAngle;
                    data[0].segments[ri].endAngle = valueData.endAngle;

                    var maxData = value.maxData;
                    var maxTickData = calcAngles(maxData.maxValue + 0.2);
                    data[0].segments[ri].maxTickStartAngle = maxTickData.startAngle;
                    data[0].segments[ri].maxTickEndAngle = maxTickData.endAngle;

                    var maxArcData = calcAngles(maxData.maxValue);
                    data[0].segments[ri].maxArcStartAngle = maxArcData.startAngle;
                    data[0].segments[ri].maxArcEndAngle = maxArcData.endAngle;

                    data[0].segments[ri].index = ri;
                  });
                  localData.push(data[0].segments);
                  return localData[0];
                }

                function generateArcs(_svg, data) {
                  var chart = svg;
                  var transitionTime = 750;
                  $.each(data, function(index, value) {
                    if (oldData[index] !== undefined) {
                      data[index].previousEndAngle = oldData[index].endAngle;
                    } else {
                      data[index].previousEndAngle = 0;
                    }
                  });
                  var thickness = parseInt(scope.thickness, 10);
                  var ir = (parseInt(scope.graphWidth, 10) / 3);
                  var path_group = svg.select('.path_group');
                  var arc_group = path_group.selectAll(".arc_group").data(data);
                  var arcEnter = arc_group.enter().append("g").attr("class", "arc_group");

                  arcEnter.append("path").attr("class", "bg-circle").attr("d", getBackgroundArc(thickness, ir));

                  arcEnter.append("path")
                      .attr("class", function(d, i) { return 'max_tick_arc ' + d.maxData.maxTickClassNames; });

                  arcEnter.append("path")
                      .attr("class", function(d, i) { return 'max_bg_arc ' + d.maxData.maxClassNames; });

                  arcEnter.append("path").attr("class", function(d, i) { return 'value_arc ' + d.classNames; });

                  var max_tick_arc = arc_group.select(".max_tick_arc");

                  max_tick_arc.transition()
                      .attr("class", function(d, i) { return 'max_tick_arc ' + d.maxData.maxTickClassNames; })
                      .attr("d", function(d) {
                        var arc = maxArc(thickness, ir);
                        arc.startAngle(d.maxTickStartAngle);
                        arc.endAngle(d.maxTickEndAngle);
                        return arc(d);
                      });

                  var max_bg_arc = arc_group.select(".max_bg_arc");

                  max_bg_arc.transition()
                      .attr("class", function(d, i) { return 'max_bg_arc ' + d.maxData.maxClassNames; })
                      .attr("d", function(d) {
                        var arc = maxArc(thickness, ir);
                        arc.startAngle(d.maxArcStartAngle);
                        arc.endAngle(d.maxArcEndAngle);
                        return arc(d);
                      });

                  var value_arc = arc_group.select(".value_arc");

                  value_arc.transition().ease("exp").attr("class", function(d, i) {
                    return 'value_arc ' + d.classNames;
                  }).duration(transitionTime).attrTween("d", function(d) { return arcTween(d, thickness, ir); });

                  arc_group.exit()
                      .select(".value_arc")
                      .transition()
                      .ease("exp")
                      .duration(transitionTime)
                      .attrTween("d", function(d) { return arcTween(d, thickness, ir); })
                      .remove();

                  drawLabels(chart, data, ir, thickness);
                  buildLegend(chart, data);
                }

                function arcTween(b, thickness, ir) {
                  var prev = JSON.parse(JSON.stringify(b));
                  prev.endAngle = b.previousEndAngle;
                  var i = d3.interpolate(prev, b);
                  return function(t) { return getArc(thickness, ir)(i(t)); };
                }

                function maxArc(thickness, ir) {
                  var arc = d3.svg.arc().innerRadius(function(d) {
                    return getRadiusRing(ir, d.index);
                  }).outerRadius(function(d) { return getRadiusRing(ir + thickness, d.index); });
                  return arc;
                }

                function drawLabels(chart, data, ir, thickness) {
                  svg.select('.value_group').selectAll("*").remove();
                  var counts = data.length;
                  var value_group = chart.select('.value_group');
                  var valueLabels = value_group.selectAll("text.value").data(data);
                  valueLabels.enter()
                      .append("svg:text")
                      .attr("class", "value")
                      .attr(
                           "transform", function(d) { return "translate(" + (getRadiusRing(ir, counts - 1)) + ", 0)"; })
                      .attr("dx", function(d, i) { return 0; })
                      .attr("dy", function(d, i) { return (thickness + 3) * i; })
                      .attr("text-anchor", function(d) { return "start"; })
                      .text(function(d) { return d.value; });
                  valueLabels.transition().duration(300).attrTween(
                      "d", function(d) { return arcTween(d, thickness, ir); });
                  valueLabels.exit().remove();
                }

                function buildLegend(chart, data) {
                  var svg = legendSvg;
                  svg.select('.label_group').selectAll("*").remove();
                  svg.select('.legend_group').selectAll("*").remove();
                  svg.select('.stats_group').selectAll("*").remove();

                  var host_name = svg.select('.hostName');
                  var label_group = svg.select('.label_group');
                  var stats_group = svg.select('.stats_group');

                  host_name.text(data[0].hostName);

                  host_name = svg.selectAll("text.hostName").data(data);

                  host_name.attr("text-anchor", function(d) { return "start"; })
                      .text(function(d) { return d.hostName; });
                  host_name.exit().remove();

                  var labels = label_group.selectAll("text.labels").data(data);
                  labels.enter()
                      .append("svg:text")
                      .attr("class", "labels")
                      .attr("dy", function(d, i) { return 19 * i; })
                      .attr("text-anchor", function(d) { return "start"; })
                      .text(function(d) { return d.label; });
                  labels.exit().remove();

                  var stats = stats_group.selectAll("text.stats").data(data);
                  stats.enter()
                      .append("svg:text")
                      .attr("class", "stats")
                      .attr("dy", function(d, i) { return 19 * i; })
                      .attr("text-anchor", function(d) { return "start"; })
                      .text(function(d) { return d.stats; });
                  stats.exit().remove();

                  var legend_group = svg.select('.legend_group');
                  var legend = legend_group.selectAll("rect").data(data);
                  legend.enter()
                      .append("svg:rect")
                      .attr("x", 2)
                      .attr("y", function(d, i) { return 19 * i; })
                      .attr("width", 13)
                      .attr("height", 13)
                      .attr("class", function(d, i) { return "rect " + d.classNames; });

                  legend.exit().remove();
                }

                function getRadiusRing(ir, i) { return ir - (i * 20); }

                function getArc(thickness, ir) {
                  var arc = d3.svg.arc()
                                .innerRadius(function(d) { return getRadiusRing(ir, d.index); })
                                .outerRadius(function(d) { return getRadiusRing(ir + thickness, d.index); })
                                .startAngle(function(d, i) { return d.startAngle; })
                                .endAngle(function(d, i) { return d.endAngle; });
                  return arc;
                }

                function getBackgroundArc(thickness, ir) {
                  var arc = d3.svg.arc()
                                .innerRadius(function(d) { return getRadiusRing(ir, d.index); })
                                .outerRadius(function(d) { return getRadiusRing(ir + thickness, d.index); })
                                .startAngle(0)
                                .endAngle(function() { return 2 * Math.PI; });
                  return arc;
                }

                scope.render = function(data) {
                  if (data === undefined || data === null) {
                    return;
                  }

                  svg.selectAll("*").remove();

                  var graph = $(element[0]);
                  var w = scope.graphWidth;
                  var h = scope.graphHeight;

                  var options = {
                    data: data,
                    width: w,
                    height: h
                  };

                  init(options);
                };
              };
              d3DashboardService.d3().then(draw);
            }
          };
        }
      ]);
}());

(function() {
  'use strict';

  angular.module('kubernetesApp.components.dashboard')
      .directive(
           'dashboardHeader',
           function() {
             'use strict';
             return {
               restrict: 'A',
               replace: true,
               scope: {user: '='},
               templateUrl: "components/dashboard/pages/header.html",
               controller: [
                 '$scope',
                 '$filter',
                 '$location',
                 'menu',
                 '$rootScope',
                 function($scope, $filter, $location, menu, $rootScope) {
                  $scope.menu = menu;
                   $scope.$watch('page', function(newValue, oldValue) {
                     if (typeof newValue !== 'undefined') {
                       $location.path(newValue);
                     }
                   });

                   $scope.subpages = [
                     {
                       category: 'dashboard',
                       name: 'Explore',
                       value: '/dashboard/groups/type/selector/',
                       id: 'groupsView'
                     },
                     {category: 'dashboard', name: 'Pods', value: '/dashboard/pods', id: 'podsView'},
                     {category: 'dashboard', name: 'Nodes', value: '/dashboard/nodes', id: 'minionsView'},
                     {
                       category: 'dashboard',
                       name: 'Replication Controllers',
                       value: '/dashboard/replicationcontrollers',
                       id: 'rcView'
                     },
                     {category: 'dashboard', name: 'Services', value: '/dashboard/services', id: 'servicesView'},
                     {category: 'dashboard', name: 'Events', value: '/dashboard/events', id: 'eventsView'},
                   ];
                 }
               ]
             };
           })
      .directive('dashboardFooter',
                 function() {
                   'use strict';
                   return {
                     restrict: 'A',
                     replace: true,
                     templateUrl: "components/dashboard/pages/footer.html",
                     controller: ['$scope', '$filter', function($scope, $filter) {}]
                   };
                 })
      .directive('mdTable', function() {
        'use strict';
        return {
          restrict: 'E',
          scope: {
            headers: '=',
            content: '=',
            sortable: '=',
            filters: '=',
            customClass: '=customClass',
            thumbs: '=',
            count: '=',
            doSelect: '&onSelect'
          },
          transclude: true,
          controller: ["$scope", "$filter", "$window", "$location", function($scope, $filter, $window, $location) {
            var orderBy = $filter('orderBy');
            $scope.currentPage = 0;
            $scope.nbOfPages = function() { return Math.ceil($scope.content.length / $scope.count); };
            $scope.handleSort = function(field) {
              if ($scope.sortable.indexOf(field) > -1) {
                return true;
              } else {
                return false;
              }
            };
            $scope.order = function(predicate, reverse) {
              $scope.content = orderBy($scope.content, predicate, reverse);
              $scope.predicate = predicate;
            };
            $scope.order($scope.sortable[0], false);
            $scope.getNumber = function(num) { return new Array(num); };
            $scope.goToPage = function(page) { $scope.currentPage = page; };
            $scope.showMore = function() { return angular.isDefined($scope.moreClick);}
          }],
          templateUrl: 'views/partials/md-table.tmpl.html'
        };
      });

}());

angular.module('kubernetesApp.components.dashboard')
    .factory('d3DashboardService', [
      '$document',
      '$q',
      '$rootScope',
      function($document, $q, $rootScope) {
        var d = $q.defer();
        function onScriptLoad() {
          // Load client in the browser
          $rootScope.$apply(function() { d.resolve(window.d3); });
        }
        // Create a script tag with d3 as the source
        // and call our onScriptLoad callback when it
        // has been loaded
        var scriptTag = $document[0].createElement('script');
        scriptTag.type = 'text/javascript';
        scriptTag.async = true;
        scriptTag.src = 'vendor/d3/d3.min.js';
        scriptTag.onreadystatechange = function() {
          if (this.readyState == 'complete') onScriptLoad();
        };
        scriptTag.onload = onScriptLoad;

        var s = $document[0].getElementsByTagName('body')[0];
        s.appendChild(scriptTag);

        return {
          d3: function() { return d.promise; }
        };
      }
    ]);

(function() {
  'use strict';

  angular.module('pods', []).service('podService', PodDataService);

  /**
   * Pod DataService
   * Mock async data service.
   *
   * @returns {{loadAll: Function}}
   * @constructor
   */
  function PodDataService($q) {
    var pods = {
    "kind": "Pod",
    "apiVersion": "v1beta3",
    "metadata": {
        "name": "redis-master-c0r1n",
        "generateName": "redis-master-",
        "namespace": "default",
        "selfLink": "/api/v1beta3/namespaces/default/pods/redis-master-c0r1n",
        "uid": "f12ddfaf-ff77-11e4-8f2d-080027213276",
        "resourceVersion": "39",
        "creationTimestamp": "2015-05-21T05:12:14Z",
        "labels": {
            "name": "redis-master"
        },
        "annotations": {
            "kubernetes.io/created-by": "{\"kind\":\"SerializedReference\",\"apiVersion\":\"v1beta3\",\"reference\":{\"kind\":\"ReplicationController\",\"namespace\":\"default\",\"name\":\"redis-master\",\"uid\":\"f12969e0-ff77-11e4-8f2d-080027213276\",\"apiVersion\":\"v1beta3\",\"resourceVersion\":\"26\"}}"
        }
    },
    "spec": {
        "volumes": [
            {
                "name": "default-token-zb4rq",
                "secret": {
                    "secretName": "default-token-zb4rq"
                }
            }
        ],
        "containers": [
            {
                "name": "master",
                "image": "redis",
                "ports": [
                    {
                        "containerPort": 6379,
                        "protocol": "TCP"
                    }
                ],
                "resources": {},
                "volumeMounts": [
                    {
                        "name": "default-token-zb4rq",
                        "readOnly": true,
                        "mountPath": "/var/run/secrets/kubernetes.io/serviceaccount"
                    }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                    "capabilities": {},
                    "privileged": false
                }
            }
        ],
        "restartPolicy": "Always",
        "dnsPolicy": "ClusterFirst",
        "serviceAccount": "default",
        "host": "127.0.0.1"
    },
    "status": {
        "phase": "Running",
        "Condition": [
            {
                "type": "Ready",
                "status": "True"
            }
        ],
        "hostIP": "127.0.0.1",
        "podIP": "172.17.0.1",
        "startTime": "2015-05-21T05:12:14Z",
        "containerStatuses": [
            {
                "name": "master",
                "state": {
                    "running": {
                        "startedAt": "2015-05-21T05:12:14Z"
                    }
                },
                "lastState": {},
                "ready": true,
                "restartCount": 0,
                "image": "redis",
                "imageID": "docker://95af5842ddb9b03f7c6ec7601e65924cec516fcedd7e590ae31660057085cf67",
                "containerID": "docker://ae2a1e0a91a8b1015191a0b8e2ce8c55a86fb1a9a2b1e8e3b29430c9d93c8c09"
            }
        ]
    }
};

    // Uses promises
    return {
      loadAll: function() {
        // Simulate async call
        return $q.when(pods);
      }
    };
  }
  PodDataService.$inject = ["$q"];

})();

(function() {
  'use strict';

  angular.module('replicationControllers', [])
      .service('replicationControllerService', ReplicationControllerDataService);

  /**
   * Replication Controller DataService
   * Mock async data service.
   *
   * @returns {{loadAll: Function}}
   * @constructor
   */
  function ReplicationControllerDataService($q) {
    var replicationControllers = {
    "kind": "List",
    "apiVersion": "v1beta3",
    "metadata": {},
    "items": [
        {
            "kind": "ReplicationController",
            "apiVersion": "v1beta3",
            "metadata": {
                "name": "redis-master",
                "namespace": "default",
                "selfLink": "/api/v1beta3/namespaces/default/replicationcontrollers/redis-master",
                "uid": "f12969e0-ff77-11e4-8f2d-080027213276",
                "resourceVersion": "28",
                "creationTimestamp": "2015-05-21T05:12:14Z",
                "labels": {
                    "name": "redis-master"
                }
            },
            "spec": {
                "replicas": 1,
                "selector": {
                    "name": "redis-master"
                },
                "template": {
                    "metadata": {
                        "creationTimestamp": null,
                        "labels": {
                            "name": "redis-master"
                        }
                    },
                    "spec": {
                        "containers": [
                            {
                                "name": "master",
                                "image": "redis",
                                "ports": [
                                    {
                                        "containerPort": 6379,
                                        "protocol": "TCP"
                                    }
                                ],
                                "resources": {},
                                "terminationMessagePath": "/dev/termination-log",
                                "imagePullPolicy": "IfNotPresent",
                                "capabilities": {},
                                "securityContext": {
                                    "capabilities": {},
                                    "privileged": false
                                }
                            }
                        ],
                        "restartPolicy": "Always",
                        "dnsPolicy": "ClusterFirst",
                        "serviceAccount": ""
                    }
                }
            },
            "status": {
                "replicas": 1
            }
        }
    ]};

    // Uses promises
    return {
      loadAll: function() {
        // Simulate async call
        return $q.when(replicationControllers);
      }
    };
  }
  ReplicationControllerDataService.$inject = ["$q"];

})();

(function() {
  'use strict';

  angular.module('services', []).service('serviceService', ServiceDataService);

  /**
   * Service DataService
   * Mock async data service.
   *
   * @returns {{loadAll: Function}}
   * @constructor
   */
  function ServiceDataService($q) {
    var services = {
    "kind": "List",
    "apiVersion": "v1beta3",
    "metadata": {},
    "items": [
        {
            "kind": "Service",
            "apiVersion": "v1beta3",
            "metadata": {
                "name": "kubernetes",
                "namespace": "default",
                "selfLink": "/api/v1beta3/namespaces/default/services/kubernetes",
                "resourceVersion": "6",
                "creationTimestamp": null,
                "labels": {
                    "component": "apiserver",
                    "provider": "kubernetes"
                }
            },
            "spec": {
                "ports": [
                    {
                        "protocol": "TCP",
                        "port": 443,
                        "targetPort": 443
                    }
                ],
                "portalIP": "10.0.0.2",
                "sessionAffinity": "None"
            },
            "status": {}
        },
        {
            "kind": "Service",
            "apiVersion": "v1beta3",
            "metadata": {
                "name": "kubernetes-ro",
                "namespace": "default",
                "selfLink": "/api/v1beta3/namespaces/default/services/kubernetes-ro",
                "resourceVersion": "8",
                "creationTimestamp": null,
                "labels": {
                    "component": "apiserver",
                    "provider": "kubernetes"
                }
            },
            "spec": {
                "ports": [
                    {
                        "protocol": "TCP",
                        "port": 80,
                        "targetPort": 80
                    }
                ],
                "portalIP": "10.0.0.1",
                "sessionAffinity": "None"
            },
            "status": {}
        },
        {
            "kind": "Service",
            "apiVersion": "v1beta3",
            "metadata": {
                "name": "redis-master",
                "namespace": "default",
                "selfLink": "/api/v1beta3/namespaces/default/services/redis-master",
                "uid": "a6fde246-ff78-11e4-8f2d-080027213276",
                "resourceVersion": "72",
                "creationTimestamp": "2015-05-21T05:17:19Z",
                "labels": {
                    "name": "redis-master"
                }
            },
            "spec": {
                "ports": [
                    {
                        "protocol": "TCP",
                        "port": 6379,
                        "targetPort": 6379
                    }
                ],
                "selector": {
                    "name": "redis-master"
                },
                "portalIP": "10.0.0.124",
                "sessionAffinity": "None"
            },
            "status": {}
        }
    ]
};

    // Uses promises
    return {
      loadAll: function() {
        // Simulate async call
        return $q.when(services);
      }
    };
  }
  ServiceDataService.$inject = ["$q"];

})();
`)

func www_app_assets_js_app_js_bytes() ([]byte, error) {
	return _www_app_assets_js_app_js, nil
}

func www_app_assets_js_app_js() (*asset, error) {
	bytes, err := www_app_assets_js_app_js_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/js/app.js", size: 93013, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_assets_js_base_js = []byte(`!function(e,t){"object"==typeof module&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(e,t){function n(e){var t=e.length,n=Z.type(e);return"function"===n||Z.isWindow(e)?!1:1===e.nodeType&&t?!0:"array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e}function r(e,t,n){if(Z.isFunction(t))return Z.grep(e,function(e,r){return!!t.call(e,r,e)!==n});if(t.nodeType)return Z.grep(e,function(e){return e===t!==n});if("string"==typeof t){if(ae.test(t))return Z.filter(t,e,n);t=Z.filter(t,e)}return Z.grep(e,function(e){return U.call(t,e)>=0!==n})}function i(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}function o(e){var t=he[e]={};return Z.each(e.match(de)||[],function(e,n){t[n]=!0}),t}function s(){J.removeEventListener("DOMContentLoaded",s,!1),e.removeEventListener("load",s,!1),Z.ready()}function a(){Object.defineProperty(this.cache={},0,{get:function(){return{}}}),this.expando=Z.expando+a.uid++}function u(e,t,n){var r;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(be,"-$1").toLowerCase(),n=e.getAttribute(r),"string"==typeof n){try{n="true"===n?!0:"false"===n?!1:"null"===n?null:+n+""===n?+n:xe.test(n)?Z.parseJSON(n):n}catch(i){}ye.set(e,t,n)}else n=void 0;return n}function l(){return!0}function c(){return!1}function f(){try{return J.activeElement}catch(e){}}function p(e,t){return Z.nodeName(e,"table")&&Z.nodeName(11!==t.nodeType?t:t.firstChild,"tr")?e.getElementsByTagName("tbody")[0]||e.appendChild(e.ownerDocument.createElement("tbody")):e}function d(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function h(e){var t=Pe.exec(e.type);return t?e.type=t[1]:e.removeAttribute("type"),e}function g(e,t){for(var n=0,r=e.length;r>n;n++)ve.set(e[n],"globalEval",!t||ve.get(t[n],"globalEval"))}function m(e,t){var n,r,i,o,s,a,u,l;if(1===t.nodeType){if(ve.hasData(e)&&(o=ve.access(e),s=ve.set(t,o),l=o.events)){delete s.handle,s.events={};for(i in l)for(n=0,r=l[i].length;r>n;n++)Z.event.add(t,i,l[i][n])}ye.hasData(e)&&(a=ye.access(e),u=Z.extend({},a),ye.set(t,u))}}function v(e,t){var n=e.getElementsByTagName?e.getElementsByTagName(t||"*"):e.querySelectorAll?e.querySelectorAll(t||"*"):[];return void 0===t||t&&Z.nodeName(e,t)?Z.merge([e],n):n}function y(e,t){var n=t.nodeName.toLowerCase();"input"===n&&Ne.test(e.type)?t.checked=e.checked:("input"===n||"textarea"===n)&&(t.defaultValue=e.defaultValue)}function x(t,n){var r,i=Z(n.createElement(t)).appendTo(n.body),o=e.getDefaultComputedStyle&&(r=e.getDefaultComputedStyle(i[0]))?r.display:Z.css(i[0],"display");return i.detach(),o}function b(e){var t=J,n=$e[e];return n||(n=x(e,t),"none"!==n&&n||(We=(We||Z("<iframe frameborder='0' width='0' height='0'/>")).appendTo(t.documentElement),t=We[0].contentDocument,t.write(),t.close(),n=x(e,t),We.detach()),$e[e]=n),n}function w(e,t,n){var r,i,o,s,a=e.style;return n=n||_e(e),n&&(s=n.getPropertyValue(t)||n[t]),n&&(""!==s||Z.contains(e.ownerDocument,e)||(s=Z.style(e,t)),Be.test(s)&&Ie.test(t)&&(r=a.width,i=a.minWidth,o=a.maxWidth,a.minWidth=a.maxWidth=a.width=s,s=n.width,a.width=r,a.minWidth=i,a.maxWidth=o)),void 0!==s?s+"":s}function T(e,t){return{get:function(){return e()?void delete this.get:(this.get=t).apply(this,arguments)}}}function C(e,t){if(t in e)return t;for(var n=t[0].toUpperCase()+t.slice(1),r=t,i=Ge.length;i--;)if(t=Ge[i]+n,t in e)return t;return r}function N(e,t,n){var r=Xe.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||"px"):t}function k(e,t,n,r,i){for(var o=n===(r?"border":"content")?4:"width"===t?1:0,s=0;4>o;o+=2)"margin"===n&&(s+=Z.css(e,n+Te[o],!0,i)),r?("content"===n&&(s-=Z.css(e,"padding"+Te[o],!0,i)),"margin"!==n&&(s-=Z.css(e,"border"+Te[o]+"Width",!0,i))):(s+=Z.css(e,"padding"+Te[o],!0,i),"padding"!==n&&(s+=Z.css(e,"border"+Te[o]+"Width",!0,i)));return s}function E(e,t,n){var r=!0,i="width"===t?e.offsetWidth:e.offsetHeight,o=_e(e),s="border-box"===Z.css(e,"boxSizing",!1,o);if(0>=i||null==i){if(i=w(e,t,o),(0>i||null==i)&&(i=e.style[t]),Be.test(i))return i;r=s&&(Q.boxSizingReliable()||i===e.style[t]),i=parseFloat(i)||0}return i+k(e,t,n||(s?"border":"content"),r,o)+"px"}function S(e,t){for(var n,r,i,o=[],s=0,a=e.length;a>s;s++)r=e[s],r.style&&(o[s]=ve.get(r,"olddisplay"),n=r.style.display,t?(o[s]||"none"!==n||(r.style.display=""),""===r.style.display&&Ce(r)&&(o[s]=ve.access(r,"olddisplay",b(r.nodeName)))):(i=Ce(r),"none"===n&&i||ve.set(r,"olddisplay",i?n:Z.css(r,"display"))));for(s=0;a>s;s++)r=e[s],r.style&&(t&&"none"!==r.style.display&&""!==r.style.display||(r.style.display=t?o[s]||"":"none"));return e}function D(e,t,n,r,i){return new D.prototype.init(e,t,n,r,i)}function j(){return setTimeout(function(){Qe=void 0}),Qe=Z.now()}function A(e,t){var n,r=0,i={height:e};for(t=t?1:0;4>r;r+=2-t)n=Te[r],i["margin"+n]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function L(e,t,n){for(var r,i=(nt[t]||[]).concat(nt["*"]),o=0,s=i.length;s>o;o++)if(r=i[o].call(n,t,e))return r}function q(e,t,n){var r,i,o,s,a,u,l,c,f=this,p={},d=e.style,h=e.nodeType&&Ce(e),g=ve.get(e,"fxshow");n.queue||(a=Z._queueHooks(e,"fx"),null==a.unqueued&&(a.unqueued=0,u=a.empty.fire,a.empty.fire=function(){a.unqueued||u()}),a.unqueued++,f.always(function(){f.always(function(){a.unqueued--,Z.queue(e,"fx").length||a.empty.fire()})})),1===e.nodeType&&("height"in t||"width"in t)&&(n.overflow=[d.overflow,d.overflowX,d.overflowY],l=Z.css(e,"display"),c="none"===l?ve.get(e,"olddisplay")||b(e.nodeName):l,"inline"===c&&"none"===Z.css(e,"float")&&(d.display="inline-block")),n.overflow&&(d.overflow="hidden",f.always(function(){d.overflow=n.overflow[0],d.overflowX=n.overflow[1],d.overflowY=n.overflow[2]}));for(r in t)if(i=t[r],Ke.exec(i)){if(delete t[r],o=o||"toggle"===i,i===(h?"hide":"show")){if("show"!==i||!g||void 0===g[r])continue;h=!0}p[r]=g&&g[r]||Z.style(e,r)}else l=void 0;if(Z.isEmptyObject(p))"inline"===("none"===l?b(e.nodeName):l)&&(d.display=l);else{g?"hidden"in g&&(h=g.hidden):g=ve.access(e,"fxshow",{}),o&&(g.hidden=!h),h?Z(e).show():f.done(function(){Z(e).hide()}),f.done(function(){var t;ve.remove(e,"fxshow");for(t in p)Z.style(e,t,p[t])});for(r in p)s=L(h?g[r]:0,r,f),r in g||(g[r]=s.start,h&&(s.end=s.start,s.start="width"===r||"height"===r?1:0))}}function H(e,t){var n,r,i,o,s;for(n in e)if(r=Z.camelCase(n),i=t[r],o=e[n],Z.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),s=Z.cssHooks[r],s&&"expand"in s){o=s.expand(o),delete e[r];for(n in o)n in e||(e[n]=o[n],t[n]=i)}else t[r]=i}function O(e,t,n){var r,i,o=0,s=tt.length,a=Z.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;for(var t=Qe||j(),n=Math.max(0,l.startTime+l.duration-t),r=n/l.duration||0,o=1-r,s=0,u=l.tweens.length;u>s;s++)l.tweens[s].run(o);return a.notifyWith(e,[l,o,n]),1>o&&u?n:(a.resolveWith(e,[l]),!1)},l=a.promise({elem:e,props:Z.extend({},t),opts:Z.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Qe||j(),duration:n.duration,tweens:[],createTween:function(t,n){var r=Z.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)l.tweens[n].run(1);return t?a.resolveWith(e,[l,t]):a.rejectWith(e,[l,t]),this}}),c=l.props;for(H(c,l.opts.specialEasing);s>o;o++)if(r=tt[o].call(l,e,c,l.opts))return r;return Z.map(c,L,l),Z.isFunction(l.opts.start)&&l.opts.start.call(e,l),Z.fx.timer(Z.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always)}function F(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var r,i=0,o=t.toLowerCase().match(de)||[];if(Z.isFunction(n))for(;r=o[i++];)"+"===r[0]?(r=r.slice(1)||"*",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function P(e,t,n,r){function i(a){var u;return o[a]=!0,Z.each(e[a]||[],function(e,a){var l=a(t,n,r);return"string"!=typeof l||s||o[l]?s?!(u=l):void 0:(t.dataTypes.unshift(l),i(l),!1)}),u}var o={},s=e===xt;return i(t.dataTypes[0])||!o["*"]&&i("*")}function R(e,t){var n,r,i=Z.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&Z.extend(!0,e,r),e}function M(e,t,n){for(var r,i,o,s,a=e.contents,u=e.dataTypes;"*"===u[0];)u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in a)if(a[i]&&a[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}s||(s=i)}o=o||s}return o?(o!==u[0]&&u.unshift(o),n[o]):void 0}function W(e,t,n,r){var i,o,s,a,u,l={},c=e.dataTypes.slice();if(c[1])for(s in e.converters)l[s.toLowerCase()]=e.converters[s];for(o=c.shift();o;)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(s=l[u+" "+o]||l["* "+o],!s)for(i in l)if(a=i.split(" "),a[1]===o&&(s=l[u+" "+a[0]]||l["* "+a[0]])){s===!0?s=l[i]:l[i]!==!0&&(o=a[0],c.unshift(a[1]));break}if(s!==!0)if(s&&e["throws"])t=s(t);else try{t=s(t)}catch(f){return{state:"parsererror",error:s?f:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}function $(e,t,n,r){var i;if(Z.isArray(t))Z.each(t,function(t,i){n||Nt.test(e)?r(e,i):$(e+"["+("object"==typeof i?t:"")+"]",i,n,r)});else if(n||"object"!==Z.type(t))r(e,t);else for(i in t)$(e+"["+i+"]",t[i],n,r)}function I(e){return Z.isWindow(e)?e:9===e.nodeType&&e.defaultView}var B=[],_=B.slice,z=B.concat,X=B.push,U=B.indexOf,V={},Y=V.toString,G=V.hasOwnProperty,Q={},J=e.document,K="2.1.3",Z=function(e,t){return new Z.fn.init(e,t)},ee=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,te=/^-ms-/,ne=/-([\da-z])/gi,re=function(e,t){return t.toUpperCase()};Z.fn=Z.prototype={jquery:K,constructor:Z,selector:"",length:0,toArray:function(){return _.call(this)},get:function(e){return null!=e?0>e?this[e+this.length]:this[e]:_.call(this)},pushStack:function(e){var t=Z.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return Z.each(this,e,t)},map:function(e){return this.pushStack(Z.map(this,function(t,n){return e.call(t,n,t)}))},slice:function(){return this.pushStack(_.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},end:function(){return this.prevObject||this.constructor(null)},push:X,sort:B.sort,splice:B.splice},Z.extend=Z.fn.extend=function(){var e,t,n,r,i,o,s=arguments[0]||{},a=1,u=arguments.length,l=!1;for("boolean"==typeof s&&(l=s,s=arguments[a]||{},a++),"object"==typeof s||Z.isFunction(s)||(s={}),a===u&&(s=this,a--);u>a;a++)if(null!=(e=arguments[a]))for(t in e)n=s[t],r=e[t],s!==r&&(l&&r&&(Z.isPlainObject(r)||(i=Z.isArray(r)))?(i?(i=!1,o=n&&Z.isArray(n)?n:[]):o=n&&Z.isPlainObject(n)?n:{},s[t]=Z.extend(l,o,r)):void 0!==r&&(s[t]=r));return s},Z.extend({expando:"jQuery"+(K+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isFunction:function(e){return"function"===Z.type(e)},isArray:Array.isArray,isWindow:function(e){return null!=e&&e===e.window},isNumeric:function(e){return!Z.isArray(e)&&e-parseFloat(e)+1>=0},isPlainObject:function(e){return"object"!==Z.type(e)||e.nodeType||Z.isWindow(e)?!1:e.constructor&&!G.call(e.constructor.prototype,"isPrototypeOf")?!1:!0},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},type:function(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?V[Y.call(e)]||"object":typeof e},globalEval:function(e){var t,n=eval;e=Z.trim(e),e&&(1===e.indexOf("use strict")?(t=J.createElement("script"),t.text=e,J.head.appendChild(t).parentNode.removeChild(t)):n(e))},camelCase:function(e){return e.replace(te,"ms-").replace(ne,re)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,r){var i,o=0,s=e.length,a=n(e);if(r){if(a)for(;s>o&&(i=t.apply(e[o],r),i!==!1);o++);else for(o in e)if(i=t.apply(e[o],r),i===!1)break}else if(a)for(;s>o&&(i=t.call(e[o],o,e[o]),i!==!1);o++);else for(o in e)if(i=t.call(e[o],o,e[o]),i===!1)break;return e},trim:function(e){return null==e?"":(e+"").replace(ee,"")},makeArray:function(e,t){var r=t||[];return null!=e&&(n(Object(e))?Z.merge(r,"string"==typeof e?[e]:e):X.call(r,e)),r},inArray:function(e,t,n){return null==t?-1:U.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;n>r;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r,i=[],o=0,s=e.length,a=!n;s>o;o++)r=!t(e[o],o),r!==a&&i.push(e[o]);return i},map:function(e,t,r){var i,o=0,s=e.length,a=n(e),u=[];if(a)for(;s>o;o++)i=t(e[o],o,r),null!=i&&u.push(i);else for(o in e)i=t(e[o],o,r),null!=i&&u.push(i);return z.apply([],u)},guid:1,proxy:function(e,t){var n,r,i;return"string"==typeof t&&(n=e[t],t=e,e=n),Z.isFunction(e)?(r=_.call(arguments,2),i=function(){return e.apply(t||this,r.concat(_.call(arguments)))},i.guid=e.guid=e.guid||Z.guid++,i):void 0},now:Date.now,support:Q}),Z.each("Boolean Number String Function Array Date RegExp Object Error".split(" "),function(e,t){V["[object "+t+"]"]=t.toLowerCase()});var ie=function(e){function t(e,t,n,r){var i,o,s,a,u,l,f,d,h,g;if((t?t.ownerDocument||t:$)!==q&&L(t),t=t||q,n=n||[],a=t.nodeType,"string"!=typeof e||!e||1!==a&&9!==a&&11!==a)return n;if(!r&&O){if(11!==a&&(i=ye.exec(e)))if(s=i[1]){if(9===a){if(o=t.getElementById(s),!o||!o.parentNode)return n;if(o.id===s)return n.push(o),n}else if(t.ownerDocument&&(o=t.ownerDocument.getElementById(s))&&M(t,o)&&o.id===s)return n.push(o),n}else{if(i[2])return K.apply(n,t.getElementsByTagName(e)),n;if((s=i[3])&&w.getElementsByClassName)return K.apply(n,t.getElementsByClassName(s)),n}if(w.qsa&&(!F||!F.test(e))){if(d=f=W,h=t,g=1!==a&&e,1===a&&"object"!==t.nodeName.toLowerCase()){for(l=k(e),(f=t.getAttribute("id"))?d=f.replace(be,"\\$&"):t.setAttribute("id",d),d="[id='"+d+"'] ",u=l.length;u--;)l[u]=d+p(l[u]);h=xe.test(e)&&c(t.parentNode)||t,g=l.join(",")}if(g)try{return K.apply(n,h.querySelectorAll(g)),n}catch(m){}finally{f||t.removeAttribute("id")}}}return S(e.replace(ue,"$1"),t,n,r)}function n(){function e(n,r){return t.push(n+" ")>T.cacheLength&&delete e[t.shift()],e[n+" "]=r}var t=[];return e}function r(e){return e[W]=!0,e}function i(e){var t=q.createElement("div");try{return!!e(t)}catch(n){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function o(e,t){for(var n=e.split("|"),r=e.length;r--;)T.attrHandle[n[r]]=t}function s(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&(~t.sourceIndex||V)-(~e.sourceIndex||V);if(r)return r;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function a(e){return function(t){var n=t.nodeName.toLowerCase();return"input"===n&&t.type===e}}function u(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function l(e){return r(function(t){return t=+t,r(function(n,r){for(var i,o=e([],n.length,t),s=o.length;s--;)n[i=o[s]]&&(n[i]=!(r[i]=n[i]))})})}function c(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}function f(){}function p(e){for(var t=0,n=e.length,r="";n>t;t++)r+=e[t].value;return r}function d(e,t,n){var r=t.dir,i=n&&"parentNode"===r,o=B++;return t.first?function(t,n,o){for(;t=t[r];)if(1===t.nodeType||i)return e(t,n,o)}:function(t,n,s){var a,u,l=[I,o];if(s){for(;t=t[r];)if((1===t.nodeType||i)&&e(t,n,s))return!0}else for(;t=t[r];)if(1===t.nodeType||i){if(u=t[W]||(t[W]={}),(a=u[r])&&a[0]===I&&a[1]===o)return l[2]=a[2];if(u[r]=l,l[2]=e(t,n,s))return!0}}}function h(e){return e.length>1?function(t,n,r){for(var i=e.length;i--;)if(!e[i](t,n,r))return!1;return!0}:e[0]}function g(e,n,r){for(var i=0,o=n.length;o>i;i++)t(e,n[i],r);return r}function m(e,t,n,r,i){for(var o,s=[],a=0,u=e.length,l=null!=t;u>a;a++)(o=e[a])&&(!n||n(o,r,i))&&(s.push(o),l&&t.push(a));return s}function v(e,t,n,i,o,s){return i&&!i[W]&&(i=v(i)),o&&!o[W]&&(o=v(o,s)),r(function(r,s,a,u){var l,c,f,p=[],d=[],h=s.length,v=r||g(t||"*",a.nodeType?[a]:a,[]),y=!e||!r&&t?v:m(v,p,e,a,u),x=n?o||(r?e:h||i)?[]:s:y;if(n&&n(y,x,a,u),i)for(l=m(x,d),i(l,[],a,u),c=l.length;c--;)(f=l[c])&&(x[d[c]]=!(y[d[c]]=f));if(r){if(o||e){if(o){for(l=[],c=x.length;c--;)(f=x[c])&&l.push(y[c]=f);o(null,x=[],l,u)}for(c=x.length;c--;)(f=x[c])&&(l=o?ee(r,f):p[c])>-1&&(r[l]=!(s[l]=f))}}else x=m(x===s?x.splice(h,x.length):x),o?o(null,s,x,u):K.apply(s,x)})}function y(e){for(var t,n,r,i=e.length,o=T.relative[e[0].type],s=o||T.relative[" "],a=o?1:0,u=d(function(e){return e===t},s,!0),l=d(function(e){return ee(t,e)>-1},s,!0),c=[function(e,n,r){var i=!o&&(r||n!==D)||((t=n).nodeType?u(e,n,r):l(e,n,r));return t=null,i}];i>a;a++)if(n=T.relative[e[a].type])c=[d(h(c),n)];else{if(n=T.filter[e[a].type].apply(null,e[a].matches),n[W]){for(r=++a;i>r&&!T.relative[e[r].type];r++);return v(a>1&&h(c),a>1&&p(e.slice(0,a-1).concat({value:" "===e[a-2].type?"*":""})).replace(ue,"$1"),n,r>a&&y(e.slice(a,r)),i>r&&y(e=e.slice(r)),i>r&&p(e))}c.push(n)}return h(c)}function x(e,n){var i=n.length>0,o=e.length>0,s=function(r,s,a,u,l){var c,f,p,d=0,h="0",g=r&&[],v=[],y=D,x=r||o&&T.find.TAG("*",l),b=I+=null==y?1:Math.random()||.1,w=x.length;for(l&&(D=s!==q&&s);h!==w&&null!=(c=x[h]);h++){if(o&&c){for(f=0;p=e[f++];)if(p(c,s,a)){u.push(c);break}l&&(I=b)}i&&((c=!p&&c)&&d--,r&&g.push(c))}if(d+=h,i&&h!==d){for(f=0;p=n[f++];)p(g,v,s,a);if(r){if(d>0)for(;h--;)g[h]||v[h]||(v[h]=Q.call(u));v=m(v)}K.apply(u,v),l&&!r&&v.length>0&&d+n.length>1&&t.uniqueSort(u)}return l&&(I=b,D=y),g};return i?r(s):s}var b,w,T,C,N,k,E,S,D,j,A,L,q,H,O,F,P,R,M,W="sizzle"+1*new Date,$=e.document,I=0,B=0,_=n(),z=n(),X=n(),U=function(e,t){return e===t&&(A=!0),0},V=1<<31,Y={}.hasOwnProperty,G=[],Q=G.pop,J=G.push,K=G.push,Z=G.slice,ee=function(e,t){for(var n=0,r=e.length;r>n;n++)if(e[n]===t)return n;return-1},te="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",ne="[\\x20\\t\\r\\n\\f]",re="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",ie=re.replace("w","w#"),oe="\\["+ne+"*("+re+")(?:"+ne+"*([*^$|!~]?=)"+ne+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+ie+"))|)"+ne+"*\\]",se=":("+re+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+oe+")*)|.*)\\)|)",ae=new RegExp(ne+"+","g"),ue=new RegExp("^"+ne+"+|((?:^|[^\\\\])(?:\\\\.)*)"+ne+"+$","g"),le=new RegExp("^"+ne+"*,"+ne+"*"),ce=new RegExp("^"+ne+"*([>+~]|"+ne+")"+ne+"*"),fe=new RegExp("="+ne+"*([^\\]'\"]*?)"+ne+"*\\]","g"),pe=new RegExp(se),de=new RegExp("^"+ie+"$"),he={ID:new RegExp("^#("+re+")"),CLASS:new RegExp("^\\.("+re+")"),TAG:new RegExp("^("+re.replace("w","w*")+")"),ATTR:new RegExp("^"+oe),PSEUDO:new RegExp("^"+se),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+ne+"*(even|odd|(([+-]|)(\\d*)n|)"+ne+"*(?:([+-]|)"+ne+"*(\\d+)|))"+ne+"*\\)|)","i"),bool:new RegExp("^(?:"+te+")$","i"),needsContext:new RegExp("^"+ne+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+ne+"*((?:-\\d)?\\d*)"+ne+"*\\)|)(?=[^-]|$)","i")},ge=/^(?:input|select|textarea|button)$/i,me=/^h\d$/i,ve=/^[^{]+\{\s*\[native \w/,ye=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,xe=/[+~]/,be=/'|\\/g,we=new RegExp("\\\\([\\da-f]{1,6}"+ne+"?|("+ne+")|.)","ig"),Te=function(e,t,n){var r="0x"+t-65536;return r!==r||n?t:0>r?String.fromCharCode(r+65536):String.fromCharCode(r>>10|55296,1023&r|56320)},Ce=function(){L()};try{K.apply(G=Z.call($.childNodes),$.childNodes),G[$.childNodes.length].nodeType}catch(Ne){K={apply:G.length?function(e,t){J.apply(e,Z.call(t))}:function(e,t){for(var n=e.length,r=0;e[n++]=t[r++];);e.length=n-1}}}w=t.support={},N=t.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?"HTML"!==t.nodeName:!1},L=t.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:$;return r!==q&&9===r.nodeType&&r.documentElement?(q=r,H=r.documentElement,n=r.defaultView,n&&n!==n.top&&(n.addEventListener?n.addEventListener("unload",Ce,!1):n.attachEvent&&n.attachEvent("onunload",Ce)),O=!N(r),w.attributes=i(function(e){return e.className="i",!e.getAttribute("className")}),w.getElementsByTagName=i(function(e){return e.appendChild(r.createComment("")),!e.getElementsByTagName("*").length}),w.getElementsByClassName=ve.test(r.getElementsByClassName),w.getById=i(function(e){return H.appendChild(e).id=W,!r.getElementsByName||!r.getElementsByName(W).length}),w.getById?(T.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&O){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},T.filter.ID=function(e){var t=e.replace(we,Te);return function(e){return e.getAttribute("id")===t}}):(delete T.find.ID,T.filter.ID=function(e){var t=e.replace(we,Te);return function(e){var n="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}}),T.find.TAG=w.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):w.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){for(;n=o[i++];)1===n.nodeType&&r.push(n);return r}return o},T.find.CLASS=w.getElementsByClassName&&function(e,t){return O?t.getElementsByClassName(e):void 0},P=[],F=[],(w.qsa=ve.test(r.querySelectorAll))&&(i(function(e){H.appendChild(e).innerHTML="<a id='"+W+"'></a><select id='"+W+"-\f]' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&F.push("[*^$]="+ne+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||F.push("\\["+ne+"*(?:value|"+te+")"),e.querySelectorAll("[id~="+W+"-]").length||F.push("~="),e.querySelectorAll(":checked").length||F.push(":checked"),e.querySelectorAll("a#"+W+"+*").length||F.push(".#.+[+~]")}),i(function(e){var t=r.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&F.push("name"+ne+"*[*^$|!~]?="),e.querySelectorAll(":enabled").length||F.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),F.push(",.*:")})),(w.matchesSelector=ve.test(R=H.matches||H.webkitMatchesSelector||H.mozMatchesSelector||H.oMatchesSelector||H.msMatchesSelector))&&i(function(e){w.disconnectedMatch=R.call(e,"div"),R.call(e,"[s!='']:x"),P.push("!=",se)}),F=F.length&&new RegExp(F.join("|")),P=P.length&&new RegExp(P.join("|")),t=ve.test(H.compareDocumentPosition),M=t||ve.test(H.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},U=t?function(e,t){if(e===t)return A=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n?n:(n=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1,1&n||!w.sortDetached&&t.compareDocumentPosition(e)===n?e===r||e.ownerDocument===$&&M($,e)?-1:t===r||t.ownerDocument===$&&M($,t)?1:j?ee(j,e)-ee(j,t):0:4&n?-1:1)}:function(e,t){if(e===t)return A=!0,0;var n,i=0,o=e.parentNode,a=t.parentNode,u=[e],l=[t];if(!o||!a)return e===r?-1:t===r?1:o?-1:a?1:j?ee(j,e)-ee(j,t):0;if(o===a)return s(e,t);for(n=e;n=n.parentNode;)u.unshift(n);for(n=t;n=n.parentNode;)l.unshift(n);for(;u[i]===l[i];)i++;return i?s(u[i],l[i]):u[i]===$?-1:l[i]===$?1:0},r):q},t.matches=function(e,n){return t(e,null,null,n)},t.matchesSelector=function(e,n){if((e.ownerDocument||e)!==q&&L(e),n=n.replace(fe,"='$1']"),!(!w.matchesSelector||!O||P&&P.test(n)||F&&F.test(n)))try{var r=R.call(e,n);if(r||w.disconnectedMatch||e.document&&11!==e.document.nodeType)return r}catch(i){}return t(n,q,null,[e]).length>0},t.contains=function(e,t){return(e.ownerDocument||e)!==q&&L(e),M(e,t)},t.attr=function(e,t){(e.ownerDocument||e)!==q&&L(e);var n=T.attrHandle[t.toLowerCase()],r=n&&Y.call(T.attrHandle,t.toLowerCase())?n(e,t,!O):void 0;return void 0!==r?r:w.attributes||!O?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},t.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},t.uniqueSort=function(e){var t,n=[],r=0,i=0;if(A=!w.detectDuplicates,j=!w.sortStable&&e.slice(0),e.sort(U),A){for(;t=e[i++];)t===e[i]&&(r=n.push(i));for(;r--;)e.splice(n[r],1)}return j=null,e},C=t.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=C(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r++];)n+=C(t);return n},T=t.selectors={cacheLength:50,createPseudo:r,match:he,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(we,Te),e[3]=(e[3]||e[4]||e[5]||"").replace(we,Te),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||t.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&t.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return he.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&pe.test(n)&&(t=k(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(we,Te).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=_[e+" "];return t||(t=new RegExp("(^|"+ne+")"+e+"("+ne+"|$)"))&&_(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(e,n,r){return function(i){var o=t.attr(i,e);return null==o?"!="===n:n?(o+="","="===n?o===r:"!="===n?o!==r:"^="===n?r&&0===o.indexOf(r):"*="===n?r&&o.indexOf(r)>-1:"$="===n?r&&o.slice(-r.length)===r:"~="===n?(" "+o.replace(ae," ")+" ").indexOf(r)>-1:"|="===n?o===r||o.slice(0,r.length+1)===r+"-":!1):!0}},CHILD:function(e,t,n,r,i){var o="nth"!==e.slice(0,3),s="last"!==e.slice(-4),a="of-type"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,f,p,d,h,g=o!==s?"nextSibling":"previousSibling",m=t.parentNode,v=a&&t.nodeName.toLowerCase(),y=!u&&!a;if(m){if(o){for(;g;){for(f=t;f=f[g];)if(a?f.nodeName.toLowerCase()===v:1===f.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[s?m.firstChild:m.lastChild],s&&y){for(c=m[W]||(m[W]={}),l=c[e]||[],d=l[0]===I&&l[1],p=l[0]===I&&l[2],f=d&&m.childNodes[d];f=++d&&f&&f[g]||(p=d=0)||h.pop();)if(1===f.nodeType&&++p&&f===t){c[e]=[I,d,p];break}}else if(y&&(l=(t[W]||(t[W]={}))[e])&&l[0]===I)p=l[1];else for(;(f=++d&&f&&f[g]||(p=d=0)||h.pop())&&((a?f.nodeName.toLowerCase()!==v:1!==f.nodeType)||!++p||(y&&((f[W]||(f[W]={}))[e]=[I,p]),f!==t)););return p-=i,p===r||p%r===0&&p/r>=0}}},PSEUDO:function(e,n){var i,o=T.pseudos[e]||T.setFilters[e.toLowerCase()]||t.error("unsupported pseudo: "+e);return o[W]?o(n):o.length>1?(i=[e,e,"",n],T.setFilters.hasOwnProperty(e.toLowerCase())?r(function(e,t){for(var r,i=o(e,n),s=i.length;s--;)r=ee(e,i[s]),e[r]=!(t[r]=i[s])}):function(e){return o(e,0,i)}):o}},pseudos:{not:r(function(e){var t=[],n=[],i=E(e.replace(ue,"$1"));return i[W]?r(function(e,t,n,r){for(var o,s=i(e,null,r,[]),a=e.length;a--;)(o=s[a])&&(e[a]=!(t[a]=o))}):function(e,r,o){return t[0]=e,i(t,null,o,n),t[0]=null,!n.pop()}}),has:r(function(e){return function(n){return t(e,n).length>0}}),contains:r(function(e){return e=e.replace(we,Te),function(t){return(t.textContent||t.innerText||C(t)).indexOf(e)>-1}}),lang:r(function(e){return de.test(e||"")||t.error("unsupported lang: "+e),e=e.replace(we,Te).toLowerCase(),function(t){var n;do if(n=O?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return n=n.toLowerCase(),n===e||0===n.indexOf(e+"-");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===H},focus:function(e){return e===q.activeElement&&(!q.hasFocus||q.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!T.pseudos.empty(e)},header:function(e){return me.test(e.nodeName)},input:function(e){return ge.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:l(function(){return[0]}),last:l(function(e,t){return[t-1]}),eq:l(function(e,t,n){return[0>n?n+t:n]}),even:l(function(e,t){for(var n=0;t>n;n+=2)e.push(n);return e}),odd:l(function(e,t){for(var n=1;t>n;n+=2)e.push(n);return e}),lt:l(function(e,t,n){for(var r=0>n?n+t:n;--r>=0;)e.push(r);return e}),gt:l(function(e,t,n){for(var r=0>n?n+t:n;++r<t;)e.push(r);return e})}},T.pseudos.nth=T.pseudos.eq;for(b in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})T.pseudos[b]=a(b);for(b in{submit:!0,reset:!0})T.pseudos[b]=u(b);return f.prototype=T.filters=T.pseudos,T.setFilters=new f,k=t.tokenize=function(e,n){var r,i,o,s,a,u,l,c=z[e+" "];if(c)return n?0:c.slice(0);for(a=e,u=[],l=T.preFilter;a;){(!r||(i=le.exec(a)))&&(i&&(a=a.slice(i[0].length)||a),u.push(o=[])),r=!1,(i=ce.exec(a))&&(r=i.shift(),o.push({value:r,type:i[0].replace(ue," ")}),a=a.slice(r.length));for(s in T.filter)!(i=he[s].exec(a))||l[s]&&!(i=l[s](i))||(r=i.shift(),o.push({value:r,type:s,matches:i}),a=a.slice(r.length));if(!r)break}return n?a.length:a?t.error(e):z(e,u).slice(0)},E=t.compile=function(e,t){var n,r=[],i=[],o=X[e+" "];if(!o){for(t||(t=k(e)),n=t.length;n--;)o=y(t[n]),o[W]?r.push(o):i.push(o);o=X(e,x(i,r)),o.selector=e}return o},S=t.select=function(e,t,n,r){var i,o,s,a,u,l="function"==typeof e&&e,f=!r&&k(e=l.selector||e);if(n=n||[],1===f.length){if(o=f[0]=f[0].slice(0),o.length>2&&"ID"===(s=o[0]).type&&w.getById&&9===t.nodeType&&O&&T.relative[o[1].type]){if(t=(T.find.ID(s.matches[0].replace(we,Te),t)||[])[0],!t)return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}for(i=he.needsContext.test(e)?0:o.length;i--&&(s=o[i],!T.relative[a=s.type]);)if((u=T.find[a])&&(r=u(s.matches[0].replace(we,Te),xe.test(o[0].type)&&c(t.parentNode)||t))){if(o.splice(i,1),e=r.length&&p(o),!e)return K.apply(n,r),n;break}}return(l||E(e,f))(r,t,!O,n,xe.test(e)&&c(t.parentNode)||t),n},w.sortStable=W.split("").sort(U).join("")===W,w.detectDuplicates=!!A,L(),w.sortDetached=i(function(e){return 1&e.compareDocumentPosition(q.createElement("div"))}),i(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||o("type|href|height|width",function(e,t,n){return n?void 0:e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),w.attributes&&i(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||o("value",function(e,t,n){return n||"input"!==e.nodeName.toLowerCase()?void 0:e.defaultValue}),i(function(e){return null==e.getAttribute("disabled")})||o(te,function(e,t,n){var r;return n?void 0:e[t]===!0?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),t}(e);Z.find=ie,Z.expr=ie.selectors,Z.expr[":"]=Z.expr.pseudos,Z.unique=ie.uniqueSort,Z.text=ie.getText,Z.isXMLDoc=ie.isXML,Z.contains=ie.contains;var oe=Z.expr.match.needsContext,se=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,ae=/^.[^:#\[\.,]*$/;Z.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?Z.find.matchesSelector(r,e)?[r]:[]:Z.find.matches(e,Z.grep(t,function(e){return 1===e.nodeType}))},Z.fn.extend({find:function(e){var t,n=this.length,r=[],i=this;if("string"!=typeof e)return this.pushStack(Z(e).filter(function(){
for(t=0;n>t;t++)if(Z.contains(i[t],this))return!0}));for(t=0;n>t;t++)Z.find(e,i[t],r);return r=this.pushStack(n>1?Z.unique(r):r),r.selector=this.selector?this.selector+" "+e:e,r},filter:function(e){return this.pushStack(r(this,e||[],!1))},not:function(e){return this.pushStack(r(this,e||[],!0))},is:function(e){return!!r(this,"string"==typeof e&&oe.test(e)?Z(e):e||[],!1).length}});var ue,le=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,ce=Z.fn.init=function(e,t){var n,r;if(!e)return this;if("string"==typeof e){if(n="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:le.exec(e),!n||!n[1]&&t)return!t||t.jquery?(t||ue).find(e):this.constructor(t).find(e);if(n[1]){if(t=t instanceof Z?t[0]:t,Z.merge(this,Z.parseHTML(n[1],t&&t.nodeType?t.ownerDocument||t:J,!0)),se.test(n[1])&&Z.isPlainObject(t))for(n in t)Z.isFunction(this[n])?this[n](t[n]):this.attr(n,t[n]);return this}return r=J.getElementById(n[2]),r&&r.parentNode&&(this.length=1,this[0]=r),this.context=J,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):Z.isFunction(e)?"undefined"!=typeof ue.ready?ue.ready(e):e(Z):(void 0!==e.selector&&(this.selector=e.selector,this.context=e.context),Z.makeArray(e,this))};ce.prototype=Z.fn,ue=Z(J);var fe=/^(?:parents|prev(?:Until|All))/,pe={children:!0,contents:!0,next:!0,prev:!0};Z.extend({dir:function(e,t,n){for(var r=[],i=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(i&&Z(e).is(n))break;r.push(e)}return r},sibling:function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}}),Z.fn.extend({has:function(e){var t=Z(e,this),n=t.length;return this.filter(function(){for(var e=0;n>e;e++)if(Z.contains(this,t[e]))return!0})},closest:function(e,t){for(var n,r=0,i=this.length,o=[],s=oe.test(e)||"string"!=typeof e?Z(e,t||this.context):0;i>r;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(s?s.index(n)>-1:1===n.nodeType&&Z.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(o.length>1?Z.unique(o):o)},index:function(e){return e?"string"==typeof e?U.call(Z(e),this[0]):U.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(Z.unique(Z.merge(this.get(),Z(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),Z.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return Z.dir(e,"parentNode")},parentsUntil:function(e,t,n){return Z.dir(e,"parentNode",n)},next:function(e){return i(e,"nextSibling")},prev:function(e){return i(e,"previousSibling")},nextAll:function(e){return Z.dir(e,"nextSibling")},prevAll:function(e){return Z.dir(e,"previousSibling")},nextUntil:function(e,t,n){return Z.dir(e,"nextSibling",n)},prevUntil:function(e,t,n){return Z.dir(e,"previousSibling",n)},siblings:function(e){return Z.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return Z.sibling(e.firstChild)},contents:function(e){return e.contentDocument||Z.merge([],e.childNodes)}},function(e,t){Z.fn[e]=function(n,r){var i=Z.map(this,t,n);return"Until"!==e.slice(-5)&&(r=n),r&&"string"==typeof r&&(i=Z.filter(r,i)),this.length>1&&(pe[e]||Z.unique(i),fe.test(e)&&i.reverse()),this.pushStack(i)}});var de=/\S+/g,he={};Z.Callbacks=function(e){e="string"==typeof e?he[e]||o(e):Z.extend({},e);var t,n,r,i,s,a,u=[],l=!e.once&&[],c=function(o){for(t=e.memory&&o,n=!0,a=i||0,i=0,s=u.length,r=!0;u&&s>a;a++)if(u[a].apply(o[0],o[1])===!1&&e.stopOnFalse){t=!1;break}r=!1,u&&(l?l.length&&c(l.shift()):t?u=[]:f.disable())},f={add:function(){if(u){var n=u.length;!function o(t){Z.each(t,function(t,n){var r=Z.type(n);"function"===r?e.unique&&f.has(n)||u.push(n):n&&n.length&&"string"!==r&&o(n)})}(arguments),r?s=u.length:t&&(i=n,c(t))}return this},remove:function(){return u&&Z.each(arguments,function(e,t){for(var n;(n=Z.inArray(t,u,n))>-1;)u.splice(n,1),r&&(s>=n&&s--,a>=n&&a--)}),this},has:function(e){return e?Z.inArray(e,u)>-1:!(!u||!u.length)},empty:function(){return u=[],s=0,this},disable:function(){return u=l=t=void 0,this},disabled:function(){return!u},lock:function(){return l=void 0,t||f.disable(),this},locked:function(){return!l},fireWith:function(e,t){return!u||n&&!l||(t=t||[],t=[e,t.slice?t.slice():t],r?l.push(t):c(t)),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!n}};return f},Z.extend({Deferred:function(e){var t=[["resolve","done",Z.Callbacks("once memory"),"resolved"],["reject","fail",Z.Callbacks("once memory"),"rejected"],["notify","progress",Z.Callbacks("memory")]],n="pending",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return Z.Deferred(function(n){Z.each(t,function(t,o){var s=Z.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&Z.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[o[0]+"With"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?Z.extend(e,r):r}},i={};return r.pipe=r.then,Z.each(t,function(e,o){var s=o[2],a=o[3];r[o[1]]=s.add,a&&s.add(function(){n=a},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+"With"](this===i?r:this,arguments),this},i[o[0]+"With"]=s.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t,n,r,i=0,o=_.call(arguments),s=o.length,a=1!==s||e&&Z.isFunction(e.promise)?s:0,u=1===a?e:Z.Deferred(),l=function(e,n,r){return function(i){n[e]=this,r[e]=arguments.length>1?_.call(arguments):i,r===t?u.notifyWith(n,r):--a||u.resolveWith(n,r)}};if(s>1)for(t=new Array(s),n=new Array(s),r=new Array(s);s>i;i++)o[i]&&Z.isFunction(o[i].promise)?o[i].promise().done(l(i,r,o)).fail(u.reject).progress(l(i,n,t)):--a;return a||u.resolveWith(r,o),u.promise()}});var ge;Z.fn.ready=function(e){return Z.ready.promise().done(e),this},Z.extend({isReady:!1,readyWait:1,holdReady:function(e){e?Z.readyWait++:Z.ready(!0)},ready:function(e){(e===!0?--Z.readyWait:Z.isReady)||(Z.isReady=!0,e!==!0&&--Z.readyWait>0||(ge.resolveWith(J,[Z]),Z.fn.triggerHandler&&(Z(J).triggerHandler("ready"),Z(J).off("ready"))))}}),Z.ready.promise=function(t){return ge||(ge=Z.Deferred(),"complete"===J.readyState?setTimeout(Z.ready):(J.addEventListener("DOMContentLoaded",s,!1),e.addEventListener("load",s,!1))),ge.promise(t)},Z.ready.promise();var me=Z.access=function(e,t,n,r,i,o,s){var a=0,u=e.length,l=null==n;if("object"===Z.type(n)){i=!0;for(a in n)Z.access(e,t,a,n[a],!0,o,s)}else if(void 0!==r&&(i=!0,Z.isFunction(r)||(s=!0),l&&(s?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(Z(e),n)})),t))for(;u>a;a++)t(e[a],n,s?r:r.call(e[a],a,t(e[a],n)));return i?e:l?t.call(e):u?t(e[0],n):o};Z.acceptData=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType},a.uid=1,a.accepts=Z.acceptData,a.prototype={key:function(e){if(!a.accepts(e))return 0;var t={},n=e[this.expando];if(!n){n=a.uid++;try{t[this.expando]={value:n},Object.defineProperties(e,t)}catch(r){t[this.expando]=n,Z.extend(e,t)}}return this.cache[n]||(this.cache[n]={}),n},set:function(e,t,n){var r,i=this.key(e),o=this.cache[i];if("string"==typeof t)o[t]=n;else if(Z.isEmptyObject(o))Z.extend(this.cache[i],t);else for(r in t)o[r]=t[r];return o},get:function(e,t){var n=this.cache[this.key(e)];return void 0===t?n:n[t]},access:function(e,t,n){var r;return void 0===t||t&&"string"==typeof t&&void 0===n?(r=this.get(e,t),void 0!==r?r:this.get(e,Z.camelCase(t))):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r,i,o=this.key(e),s=this.cache[o];if(void 0===t)this.cache[o]={};else{Z.isArray(t)?r=t.concat(t.map(Z.camelCase)):(i=Z.camelCase(t),t in s?r=[t,i]:(r=i,r=r in s?[r]:r.match(de)||[])),n=r.length;for(;n--;)delete s[r[n]]}},hasData:function(e){return!Z.isEmptyObject(this.cache[e[this.expando]]||{})},discard:function(e){e[this.expando]&&delete this.cache[e[this.expando]]}};var ve=new a,ye=new a,xe=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,be=/([A-Z])/g;Z.extend({hasData:function(e){return ye.hasData(e)||ve.hasData(e)},data:function(e,t,n){return ye.access(e,t,n)},removeData:function(e,t){ye.remove(e,t)},_data:function(e,t,n){return ve.access(e,t,n)},_removeData:function(e,t){ve.remove(e,t)}}),Z.fn.extend({data:function(e,t){var n,r,i,o=this[0],s=o&&o.attributes;if(void 0===e){if(this.length&&(i=ye.get(o),1===o.nodeType&&!ve.get(o,"hasDataAttrs"))){for(n=s.length;n--;)s[n]&&(r=s[n].name,0===r.indexOf("data-")&&(r=Z.camelCase(r.slice(5)),u(o,r,i[r])));ve.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof e?this.each(function(){ye.set(this,e)}):me(this,function(t){var n,r=Z.camelCase(e);if(o&&void 0===t){if(n=ye.get(o,e),void 0!==n)return n;if(n=ye.get(o,r),void 0!==n)return n;if(n=u(o,r,void 0),void 0!==n)return n}else this.each(function(){var n=ye.get(this,r);ye.set(this,r,t),-1!==e.indexOf("-")&&void 0!==n&&ye.set(this,e,t)})},null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){ye.remove(this,e)})}}),Z.extend({queue:function(e,t,n){var r;return e?(t=(t||"fx")+"queue",r=ve.get(e,t),n&&(!r||Z.isArray(n)?r=ve.access(e,t,Z.makeArray(n)):r.push(n)),r||[]):void 0},dequeue:function(e,t){t=t||"fx";var n=Z.queue(e,t),r=n.length,i=n.shift(),o=Z._queueHooks(e,t),s=function(){Z.dequeue(e,t)};"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,s,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return ve.get(e,n)||ve.access(e,n,{empty:Z.Callbacks("once memory").add(function(){ve.remove(e,[t+"queue",n])})})}}),Z.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?Z.queue(this[0],e):void 0===t?this:this.each(function(){var n=Z.queue(this,e,t);Z._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&Z.dequeue(this,e)})},dequeue:function(e){return this.each(function(){Z.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=Z.Deferred(),o=this,s=this.length,a=function(){--r||i.resolveWith(o,[o])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";s--;)n=ve.get(o[s],e+"queueHooks"),n&&n.empty&&(r++,n.empty.add(a));return a(),i.promise(t)}});var we=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,Te=["Top","Right","Bottom","Left"],Ce=function(e,t){return e=t||e,"none"===Z.css(e,"display")||!Z.contains(e.ownerDocument,e)},Ne=/^(?:checkbox|radio)$/i;!function(){var e=J.createDocumentFragment(),t=e.appendChild(J.createElement("div")),n=J.createElement("input");n.setAttribute("type","radio"),n.setAttribute("checked","checked"),n.setAttribute("name","t"),t.appendChild(n),Q.checkClone=t.cloneNode(!0).cloneNode(!0).lastChild.checked,t.innerHTML="<textarea>x</textarea>",Q.noCloneChecked=!!t.cloneNode(!0).lastChild.defaultValue}();var ke="undefined";Q.focusinBubbles="onfocusin"in e;var Ee=/^key/,Se=/^(?:mouse|pointer|contextmenu)|click/,De=/^(?:focusinfocus|focusoutblur)$/,je=/^([^.]*)(?:\.(.+)|)$/;Z.event={global:{},add:function(e,t,n,r,i){var o,s,a,u,l,c,f,p,d,h,g,m=ve.get(e);if(m)for(n.handler&&(o=n,n=o.handler,i=o.selector),n.guid||(n.guid=Z.guid++),(u=m.events)||(u=m.events={}),(s=m.handle)||(s=m.handle=function(t){return typeof Z!==ke&&Z.event.triggered!==t.type?Z.event.dispatch.apply(e,arguments):void 0}),t=(t||"").match(de)||[""],l=t.length;l--;)a=je.exec(t[l])||[],d=g=a[1],h=(a[2]||"").split(".").sort(),d&&(f=Z.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=Z.event.special[d]||{},c=Z.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&Z.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||(p=u[d]=[],p.delegateCount=0,f.setup&&f.setup.call(e,r,h,s)!==!1||e.addEventListener&&e.addEventListener(d,s,!1)),f.add&&(f.add.call(e,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),Z.event.global[d]=!0)},remove:function(e,t,n,r,i){var o,s,a,u,l,c,f,p,d,h,g,m=ve.hasData(e)&&ve.get(e);if(m&&(u=m.events)){for(t=(t||"").match(de)||[""],l=t.length;l--;)if(a=je.exec(t[l])||[],d=g=a[1],h=(a[2]||"").split(".").sort(),d){for(f=Z.event.special[d]||{},d=(r?f.delegateType:f.bindType)||d,p=u[d]||[],a=a[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),s=o=p.length;o--;)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||a&&!a.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));s&&!p.length&&(f.teardown&&f.teardown.call(e,h,m.handle)!==!1||Z.removeEvent(e,d,m.handle),delete u[d])}else for(d in u)Z.event.remove(e,d+t[l],n,r,!0);Z.isEmptyObject(u)&&(delete m.handle,ve.remove(e,"events"))}},trigger:function(t,n,r,i){var o,s,a,u,l,c,f,p=[r||J],d=G.call(t,"type")?t.type:t,h=G.call(t,"namespace")?t.namespace.split("."):[];if(s=a=r=r||J,3!==r.nodeType&&8!==r.nodeType&&!De.test(d+Z.event.triggered)&&(d.indexOf(".")>=0&&(h=d.split("."),d=h.shift(),h.sort()),l=d.indexOf(":")<0&&"on"+d,t=t[Z.expando]?t:new Z.Event(d,"object"==typeof t&&t),t.isTrigger=i?2:3,t.namespace=h.join("."),t.namespace_re=t.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=r),n=null==n?[t]:Z.makeArray(n,[t]),f=Z.event.special[d]||{},i||!f.trigger||f.trigger.apply(r,n)!==!1)){if(!i&&!f.noBubble&&!Z.isWindow(r)){for(u=f.delegateType||d,De.test(u+d)||(s=s.parentNode);s;s=s.parentNode)p.push(s),a=s;a===(r.ownerDocument||J)&&p.push(a.defaultView||a.parentWindow||e)}for(o=0;(s=p[o++])&&!t.isPropagationStopped();)t.type=o>1?u:f.bindType||d,c=(ve.get(s,"events")||{})[t.type]&&ve.get(s,"handle"),c&&c.apply(s,n),c=l&&s[l],c&&c.apply&&Z.acceptData(s)&&(t.result=c.apply(s,n),t.result===!1&&t.preventDefault());return t.type=d,i||t.isDefaultPrevented()||f._default&&f._default.apply(p.pop(),n)!==!1||!Z.acceptData(r)||l&&Z.isFunction(r[d])&&!Z.isWindow(r)&&(a=r[l],a&&(r[l]=null),Z.event.triggered=d,r[d](),Z.event.triggered=void 0,a&&(r[l]=a)),t.result}},dispatch:function(e){e=Z.event.fix(e);var t,n,r,i,o,s=[],a=_.call(arguments),u=(ve.get(this,"events")||{})[e.type]||[],l=Z.event.special[e.type]||{};if(a[0]=e,e.delegateTarget=this,!l.preDispatch||l.preDispatch.call(this,e)!==!1){for(s=Z.event.handlers.call(this,e,u),t=0;(i=s[t++])&&!e.isPropagationStopped();)for(e.currentTarget=i.elem,n=0;(o=i.handlers[n++])&&!e.isImmediatePropagationStopped();)(!e.namespace_re||e.namespace_re.test(o.namespace))&&(e.handleObj=o,e.data=o.data,r=((Z.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,a),void 0!==r&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()));return l.postDispatch&&l.postDispatch.call(this,e),e.result}},handlers:function(e,t){var n,r,i,o,s=[],a=t.delegateCount,u=e.target;if(a&&u.nodeType&&(!e.button||"click"!==e.type))for(;u!==this;u=u.parentNode||this)if(u.disabled!==!0||"click"!==e.type){for(r=[],n=0;a>n;n++)o=t[n],i=o.selector+" ",void 0===r[i]&&(r[i]=o.needsContext?Z(i,this).index(u)>=0:Z.find(i,this,null,[u]).length),r[i]&&r.push(o);r.length&&s.push({elem:u,handlers:r})}return a<t.length&&s.push({elem:this,handlers:t.slice(a)}),s},props:"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:"button buttons clientX clientY offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(e,t){var n,r,i,o=t.button;return null==e.pageX&&null!=t.clientX&&(n=e.target.ownerDocument||J,r=n.documentElement,i=n.body,e.pageX=t.clientX+(r&&r.scrollLeft||i&&i.scrollLeft||0)-(r&&r.clientLeft||i&&i.clientLeft||0),e.pageY=t.clientY+(r&&r.scrollTop||i&&i.scrollTop||0)-(r&&r.clientTop||i&&i.clientTop||0)),e.which||void 0===o||(e.which=1&o?1:2&o?3:4&o?2:0),e}},fix:function(e){if(e[Z.expando])return e;var t,n,r,i=e.type,o=e,s=this.fixHooks[i];for(s||(this.fixHooks[i]=s=Se.test(i)?this.mouseHooks:Ee.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new Z.Event(o),t=r.length;t--;)n=r[t],e[n]=o[n];return e.target||(e.target=J),3===e.target.nodeType&&(e.target=e.target.parentNode),s.filter?s.filter(e,o):e},special:{load:{noBubble:!0},focus:{trigger:function(){return this!==f()&&this.focus?(this.focus(),!1):void 0},delegateType:"focusin"},blur:{trigger:function(){return this===f()&&this.blur?(this.blur(),!1):void 0},delegateType:"focusout"},click:{trigger:function(){return"checkbox"===this.type&&this.click&&Z.nodeName(this,"input")?(this.click(),!1):void 0},_default:function(e){return Z.nodeName(e.target,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=Z.extend(new Z.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?Z.event.trigger(i,null,t):Z.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},Z.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)},Z.Event=function(e,t){return this instanceof Z.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&e.returnValue===!1?l:c):this.type=e,t&&Z.extend(this,t),this.timeStamp=e&&e.timeStamp||Z.now(),void(this[Z.expando]=!0)):new Z.Event(e,t)},Z.Event.prototype={isDefaultPrevented:c,isPropagationStopped:c,isImmediatePropagationStopped:c,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=l,e&&e.preventDefault&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=l,e&&e.stopPropagation&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=l,e&&e.stopImmediatePropagation&&e.stopImmediatePropagation(),this.stopPropagation()}},Z.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,t){Z.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;return(!i||i!==r&&!Z.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),Q.focusinBubbles||Z.each({focus:"focusin",blur:"focusout"},function(e,t){var n=function(e){Z.event.simulate(t,e.target,Z.event.fix(e),!0)};Z.event.special[t]={setup:function(){var r=this.ownerDocument||this,i=ve.access(r,t);i||r.addEventListener(e,n,!0),ve.access(r,t,(i||0)+1)},teardown:function(){var r=this.ownerDocument||this,i=ve.access(r,t)-1;i?ve.access(r,t,i):(r.removeEventListener(e,n,!0),ve.remove(r,t))}}}),Z.fn.extend({on:function(e,t,n,r,i){var o,s;if("object"==typeof e){"string"!=typeof t&&(n=n||t,t=void 0);for(s in e)this.on(s,t,n,e[s],i);return this}if(null==n&&null==r?(r=t,n=t=void 0):null==r&&("string"==typeof t?(r=n,n=void 0):(r=n,n=t,t=void 0)),r===!1)r=c;else if(!r)return this;return 1===i&&(o=r,r=function(e){return Z().off(e),o.apply(this,arguments)},r.guid=o.guid||(o.guid=Z.guid++)),this.each(function(){Z.event.add(this,e,r,n,t)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,Z(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return(t===!1||"function"==typeof t)&&(n=t,t=void 0),n===!1&&(n=c),this.each(function(){Z.event.remove(this,e,n,t)})},trigger:function(e,t){return this.each(function(){Z.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];return n?Z.event.trigger(e,t,n,!0):void 0}});var Ae=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,Le=/<([\w:]+)/,qe=/<|&#?\w+;/,He=/<(?:script|style|link)/i,Oe=/checked\s*(?:[^=]|=\s*.checked.)/i,Fe=/^$|\/(?:java|ecma)script/i,Pe=/^true\/(.*)/,Re=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,Me={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};Me.optgroup=Me.option,Me.tbody=Me.tfoot=Me.colgroup=Me.caption=Me.thead,Me.th=Me.td,Z.extend({clone:function(e,t,n){var r,i,o,s,a=e.cloneNode(!0),u=Z.contains(e.ownerDocument,e);if(!(Q.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||Z.isXMLDoc(e)))for(s=v(a),o=v(e),r=0,i=o.length;i>r;r++)y(o[r],s[r]);if(t)if(n)for(o=o||v(e),s=s||v(a),r=0,i=o.length;i>r;r++)m(o[r],s[r]);else m(e,a);return s=v(a,"script"),s.length>0&&g(s,!u&&v(e,"script")),a},buildFragment:function(e,t,n,r){for(var i,o,s,a,u,l,c=t.createDocumentFragment(),f=[],p=0,d=e.length;d>p;p++)if(i=e[p],i||0===i)if("object"===Z.type(i))Z.merge(f,i.nodeType?[i]:i);else if(qe.test(i)){for(o=o||c.appendChild(t.createElement("div")),s=(Le.exec(i)||["",""])[1].toLowerCase(),a=Me[s]||Me._default,o.innerHTML=a[1]+i.replace(Ae,"<$1></$2>")+a[2],l=a[0];l--;)o=o.lastChild;Z.merge(f,o.childNodes),o=c.firstChild,o.textContent=""}else f.push(t.createTextNode(i));for(c.textContent="",p=0;i=f[p++];)if((!r||-1===Z.inArray(i,r))&&(u=Z.contains(i.ownerDocument,i),o=v(c.appendChild(i),"script"),u&&g(o),n))for(l=0;i=o[l++];)Fe.test(i.type||"")&&n.push(i);return c},cleanData:function(e){for(var t,n,r,i,o=Z.event.special,s=0;void 0!==(n=e[s]);s++){if(Z.acceptData(n)&&(i=n[ve.expando],i&&(t=ve.cache[i]))){if(t.events)for(r in t.events)o[r]?Z.event.remove(n,r):Z.removeEvent(n,r,t.handle);ve.cache[i]&&delete ve.cache[i]}delete ye.cache[n[ye.expando]]}}}),Z.fn.extend({text:function(e){return me(this,function(e){return void 0===e?Z.text(this):this.empty().each(function(){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&(this.textContent=e)})},null,e,arguments.length)},append:function(){return this.domManip(arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=p(this,e);t.appendChild(e)}})},prepend:function(){return this.domManip(arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=p(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return this.domManip(arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){for(var n,r=e?Z.filter(e,this):this,i=0;null!=(n=r[i]);i++)t||1!==n.nodeType||Z.cleanData(v(n)),n.parentNode&&(t&&Z.contains(n.ownerDocument,n)&&g(v(n,"script")),n.parentNode.removeChild(n));return this},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(Z.cleanData(v(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return Z.clone(this,e,t)})},html:function(e){return me(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!He.test(e)&&!Me[(Le.exec(e)||["",""])[1].toLowerCase()]){e=e.replace(Ae,"<$1></$2>");try{for(;r>n;n++)t=this[n]||{},1===t.nodeType&&(Z.cleanData(v(t,!1)),t.innerHTML=e);t=0}catch(i){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var e=arguments[0];return this.domManip(arguments,function(t){e=this.parentNode,Z.cleanData(v(this)),e&&e.replaceChild(t,this)}),e&&(e.length||e.nodeType)?this:this.remove()},detach:function(e){return this.remove(e,!0)},domManip:function(e,t){e=z.apply([],e);var n,r,i,o,s,a,u=0,l=this.length,c=this,f=l-1,p=e[0],g=Z.isFunction(p);if(g||l>1&&"string"==typeof p&&!Q.checkClone&&Oe.test(p))return this.each(function(n){var r=c.eq(n);g&&(e[0]=p.call(this,n,r.html())),r.domManip(e,t)});if(l&&(n=Z.buildFragment(e,this[0].ownerDocument,!1,this),r=n.firstChild,1===n.childNodes.length&&(n=r),r)){for(i=Z.map(v(n,"script"),d),o=i.length;l>u;u++)s=n,u!==f&&(s=Z.clone(s,!0,!0),o&&Z.merge(i,v(s,"script"))),t.call(this[u],s,u);if(o)for(a=i[i.length-1].ownerDocument,Z.map(i,h),u=0;o>u;u++)s=i[u],Fe.test(s.type||"")&&!ve.access(s,"globalEval")&&Z.contains(a,s)&&(s.src?Z._evalUrl&&Z._evalUrl(s.src):Z.globalEval(s.textContent.replace(Re,"")))}return this}}),Z.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){Z.fn[e]=function(e){for(var n,r=[],i=Z(e),o=i.length-1,s=0;o>=s;s++)n=s===o?this:this.clone(!0),Z(i[s])[t](n),X.apply(r,n.get());return this.pushStack(r)}});var We,$e={},Ie=/^margin/,Be=new RegExp("^("+we+")(?!px)[a-z%]+$","i"),_e=function(t){return t.ownerDocument.defaultView.opener?t.ownerDocument.defaultView.getComputedStyle(t,null):e.getComputedStyle(t,null)};!function(){function t(){s.style.cssText="-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;display:block;margin-top:1%;top:1%;border:1px;padding:1px;width:4px;position:absolute",s.innerHTML="",i.appendChild(o);var t=e.getComputedStyle(s,null);n="1%"!==t.top,r="4px"===t.width,i.removeChild(o)}var n,r,i=J.documentElement,o=J.createElement("div"),s=J.createElement("div");s.style&&(s.style.backgroundClip="content-box",s.cloneNode(!0).style.backgroundClip="",Q.clearCloneStyle="content-box"===s.style.backgroundClip,o.style.cssText="border:0;width:0;height:0;top:0;left:-9999px;margin-top:1px;position:absolute",o.appendChild(s),e.getComputedStyle&&Z.extend(Q,{pixelPosition:function(){return t(),n},boxSizingReliable:function(){return null==r&&t(),r},reliableMarginRight:function(){var t,n=s.appendChild(J.createElement("div"));return n.style.cssText=s.style.cssText="-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0",n.style.marginRight=n.style.width="0",s.style.width="1px",i.appendChild(o),t=!parseFloat(e.getComputedStyle(n,null).marginRight),i.removeChild(o),s.removeChild(n),t}}))}(),Z.swap=function(e,t,n,r){var i,o,s={};for(o in t)s[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=s[o];return i};var ze=/^(none|table(?!-c[ea]).+)/,Xe=new RegExp("^("+we+")(.*)$","i"),Ue=new RegExp("^([+-])=("+we+")","i"),Ve={position:"absolute",visibility:"hidden",display:"block"},Ye={letterSpacing:"0",fontWeight:"400"},Ge=["Webkit","O","Moz","ms"];Z.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=w(e,"opacity");return""===n?"1":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":"cssFloat"},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,s,a=Z.camelCase(t),u=e.style;return t=Z.cssProps[a]||(Z.cssProps[a]=C(u,a)),s=Z.cssHooks[t]||Z.cssHooks[a],void 0===n?s&&"get"in s&&void 0!==(i=s.get(e,!1,r))?i:u[t]:(o=typeof n,"string"===o&&(i=Ue.exec(n))&&(n=(i[1]+1)*i[2]+parseFloat(Z.css(e,t)),o="number"),void(null!=n&&n===n&&("number"!==o||Z.cssNumber[a]||(n+="px"),Q.clearCloneStyle||""!==n||0!==t.indexOf("background")||(u[t]="inherit"),s&&"set"in s&&void 0===(n=s.set(e,n,r))||(u[t]=n))))}},css:function(e,t,n,r){var i,o,s,a=Z.camelCase(t);return t=Z.cssProps[a]||(Z.cssProps[a]=C(e.style,a)),s=Z.cssHooks[t]||Z.cssHooks[a],s&&"get"in s&&(i=s.get(e,!0,n)),void 0===i&&(i=w(e,t,r)),"normal"===i&&t in Ye&&(i=Ye[t]),""===n||n?(o=parseFloat(i),n===!0||Z.isNumeric(o)?o||0:i):i}}),Z.each(["height","width"],function(e,t){Z.cssHooks[t]={get:function(e,n,r){return n?ze.test(Z.css(e,"display"))&&0===e.offsetWidth?Z.swap(e,Ve,function(){return E(e,t,r)}):E(e,t,r):void 0},set:function(e,n,r){var i=r&&_e(e);return N(e,n,r?k(e,t,r,"border-box"===Z.css(e,"boxSizing",!1,i),i):0)}}}),Z.cssHooks.marginRight=T(Q.reliableMarginRight,function(e,t){return t?Z.swap(e,{display:"inline-block"},w,[e,"marginRight"]):void 0}),Z.each({margin:"",padding:"",border:"Width"},function(e,t){Z.cssHooks[e+t]={expand:function(n){for(var r=0,i={},o="string"==typeof n?n.split(" "):[n];4>r;r++)i[e+Te[r]+t]=o[r]||o[r-2]||o[0];return i}},Ie.test(e)||(Z.cssHooks[e+t].set=N)}),Z.fn.extend({css:function(e,t){return me(this,function(e,t,n){var r,i,o={},s=0;if(Z.isArray(t)){for(r=_e(e),i=t.length;i>s;s++)o[t[s]]=Z.css(e,t[s],!1,r);return o}return void 0!==n?Z.style(e,t,n):Z.css(e,t)},e,t,arguments.length>1)},show:function(){return S(this,!0)},hide:function(){return S(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){Ce(this)?Z(this).show():Z(this).hide()})}}),Z.Tween=D,D.prototype={constructor:D,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||"swing",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(Z.cssNumber[n]?"":"px")},cur:function(){var e=D.propHooks[this.prop];return e&&e.get?e.get(this):D.propHooks._default.get(this)},run:function(e){var t,n=D.propHooks[this.prop];return this.pos=t=this.options.duration?Z.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):D.propHooks._default.set(this),this}},D.prototype.init.prototype=D.prototype,D.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=Z.css(e.elem,e.prop,""),t&&"auto"!==t?t:0):e.elem[e.prop]},set:function(e){Z.fx.step[e.prop]?Z.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[Z.cssProps[e.prop]]||Z.cssHooks[e.prop])?Z.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},D.propHooks.scrollTop=D.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},Z.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},Z.fx=D.prototype.init,Z.fx.step={};var Qe,Je,Ke=/^(?:toggle|show|hide)$/,Ze=new RegExp("^(?:([+-])=|)("+we+")([a-z%]*)$","i"),et=/queueHooks$/,tt=[q],nt={"*":[function(e,t){var n=this.createTween(e,t),r=n.cur(),i=Ze.exec(t),o=i&&i[3]||(Z.cssNumber[e]?"":"px"),s=(Z.cssNumber[e]||"px"!==o&&+r)&&Ze.exec(Z.css(n.elem,e)),a=1,u=20;if(s&&s[3]!==o){o=o||s[3],i=i||[],s=+r||1;do a=a||".5",s/=a,Z.style(n.elem,e,s+o);while(a!==(a=n.cur()/r)&&1!==a&&--u)}return i&&(s=n.start=+s||+r||0,n.unit=o,n.end=i[1]?s+(i[1]+1)*i[2]:+i[2]),n}]};Z.Animation=Z.extend(O,{tweener:function(e,t){Z.isFunction(e)?(t=e,e=["*"]):e=e.split(" ");for(var n,r=0,i=e.length;i>r;r++)n=e[r],nt[n]=nt[n]||[],nt[n].unshift(t)},prefilter:function(e,t){t?tt.unshift(e):tt.push(e)}}),Z.speed=function(e,t,n){var r=e&&"object"==typeof e?Z.extend({},e):{complete:n||!n&&t||Z.isFunction(e)&&e,duration:e,easing:n&&t||t&&!Z.isFunction(t)&&t};return r.duration=Z.fx.off?0:"number"==typeof r.duration?r.duration:r.duration in Z.fx.speeds?Z.fx.speeds[r.duration]:Z.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue="fx"),r.old=r.complete,r.complete=function(){Z.isFunction(r.old)&&r.old.call(this),r.queue&&Z.dequeue(this,r.queue)},r},Z.fn.extend({fadeTo:function(e,t,n,r){return this.filter(Ce).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=Z.isEmptyObject(e),o=Z.speed(t,n,r),s=function(){var t=O(this,Z.extend({},e),o);(i||ve.get(this,"finish"))&&t.stop(!0)};return s.finish=s,i||o.queue===!1?this.each(s):this.queue(o.queue,s)},stop:function(e,t,n){var r=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&e!==!1&&this.queue(e||"fx",[]),this.each(function(){var t=!0,i=null!=e&&e+"queueHooks",o=Z.timers,s=ve.get(this);if(i)s[i]&&s[i].stop&&r(s[i]);else for(i in s)s[i]&&s[i].stop&&et.test(i)&&r(s[i]);for(i=o.length;i--;)o[i].elem!==this||null!=e&&o[i].queue!==e||(o[i].anim.stop(n),t=!1,o.splice(i,1));(t||!n)&&Z.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||"fx"),this.each(function(){var t,n=ve.get(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=Z.timers,s=r?r.length:0;for(n.finish=!0,Z.queue(this,e,[]),i&&i.stop&&i.stop.call(this,!0),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),
o.splice(t,1));for(t=0;s>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}}),Z.each(["toggle","show","hide"],function(e,t){var n=Z.fn[t];Z.fn[t]=function(e,r,i){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(A(t,!0),e,r,i)}}),Z.each({slideDown:A("show"),slideUp:A("hide"),slideToggle:A("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){Z.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),Z.timers=[],Z.fx.tick=function(){var e,t=0,n=Z.timers;for(Qe=Z.now();t<n.length;t++)e=n[t],e()||n[t]!==e||n.splice(t--,1);n.length||Z.fx.stop(),Qe=void 0},Z.fx.timer=function(e){Z.timers.push(e),e()?Z.fx.start():Z.timers.pop()},Z.fx.interval=13,Z.fx.start=function(){Je||(Je=setInterval(Z.fx.tick,Z.fx.interval))},Z.fx.stop=function(){clearInterval(Je),Je=null},Z.fx.speeds={slow:600,fast:200,_default:400},Z.fn.delay=function(e,t){return e=Z.fx?Z.fx.speeds[e]||e:e,t=t||"fx",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},function(){var e=J.createElement("input"),t=J.createElement("select"),n=t.appendChild(J.createElement("option"));e.type="checkbox",Q.checkOn=""!==e.value,Q.optSelected=n.selected,t.disabled=!0,Q.optDisabled=!n.disabled,e=J.createElement("input"),e.value="t",e.type="radio",Q.radioValue="t"===e.value}();var rt,it,ot=Z.expr.attrHandle;Z.fn.extend({attr:function(e,t){return me(this,Z.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){Z.removeAttr(this,e)})}}),Z.extend({attr:function(e,t,n){var r,i,o=e.nodeType;return e&&3!==o&&8!==o&&2!==o?typeof e.getAttribute===ke?Z.prop(e,t,n):(1===o&&Z.isXMLDoc(e)||(t=t.toLowerCase(),r=Z.attrHooks[t]||(Z.expr.match.bool.test(t)?it:rt)),void 0===n?r&&"get"in r&&null!==(i=r.get(e,t))?i:(i=Z.find.attr(e,t),null==i?void 0:i):null!==n?r&&"set"in r&&void 0!==(i=r.set(e,n,t))?i:(e.setAttribute(t,n+""),n):void Z.removeAttr(e,t)):void 0},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(de);if(o&&1===e.nodeType)for(;n=o[i++];)r=Z.propFix[n]||n,Z.expr.match.bool.test(n)&&(e[r]=!1),e.removeAttribute(n)},attrHooks:{type:{set:function(e,t){if(!Q.radioValue&&"radio"===t&&Z.nodeName(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}}}),it={set:function(e,t,n){return t===!1?Z.removeAttr(e,n):e.setAttribute(n,n),n}},Z.each(Z.expr.match.bool.source.match(/\w+/g),function(e,t){var n=ot[t]||Z.find.attr;ot[t]=function(e,t,r){var i,o;return r||(o=ot[t],ot[t]=i,i=null!=n(e,t,r)?t.toLowerCase():null,ot[t]=o),i}});var st=/^(?:input|select|textarea|button)$/i;Z.fn.extend({prop:function(e,t){return me(this,Z.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each(function(){delete this[Z.propFix[e]||e]})}}),Z.extend({propFix:{"for":"htmlFor","class":"className"},prop:function(e,t,n){var r,i,o,s=e.nodeType;return e&&3!==s&&8!==s&&2!==s?(o=1!==s||!Z.isXMLDoc(e),o&&(t=Z.propFix[t]||t,i=Z.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]):void 0},propHooks:{tabIndex:{get:function(e){return e.hasAttribute("tabindex")||st.test(e.nodeName)||e.href?e.tabIndex:-1}}}}),Q.optSelected||(Z.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null}}),Z.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){Z.propFix[this.toLowerCase()]=this});var at=/[\t\r\n\f]/g;Z.fn.extend({addClass:function(e){var t,n,r,i,o,s,a="string"==typeof e&&e,u=0,l=this.length;if(Z.isFunction(e))return this.each(function(t){Z(this).addClass(e.call(this,t,this.className))});if(a)for(t=(e||"").match(de)||[];l>u;u++)if(n=this[u],r=1===n.nodeType&&(n.className?(" "+n.className+" ").replace(at," "):" ")){for(o=0;i=t[o++];)r.indexOf(" "+i+" ")<0&&(r+=i+" ");s=Z.trim(r),n.className!==s&&(n.className=s)}return this},removeClass:function(e){var t,n,r,i,o,s,a=0===arguments.length||"string"==typeof e&&e,u=0,l=this.length;if(Z.isFunction(e))return this.each(function(t){Z(this).removeClass(e.call(this,t,this.className))});if(a)for(t=(e||"").match(de)||[];l>u;u++)if(n=this[u],r=1===n.nodeType&&(n.className?(" "+n.className+" ").replace(at," "):"")){for(o=0;i=t[o++];)for(;r.indexOf(" "+i+" ")>=0;)r=r.replace(" "+i+" "," ");s=e?Z.trim(r):"",n.className!==s&&(n.className=s)}return this},toggleClass:function(e,t){var n=typeof e;return"boolean"==typeof t&&"string"===n?t?this.addClass(e):this.removeClass(e):this.each(Z.isFunction(e)?function(n){Z(this).toggleClass(e.call(this,n,this.className,t),t)}:function(){if("string"===n)for(var t,r=0,i=Z(this),o=e.match(de)||[];t=o[r++];)i.hasClass(t)?i.removeClass(t):i.addClass(t);else(n===ke||"boolean"===n)&&(this.className&&ve.set(this,"__className__",this.className),this.className=this.className||e===!1?"":ve.get(this,"__className__")||"")})},hasClass:function(e){for(var t=" "+e+" ",n=0,r=this.length;r>n;n++)if(1===this[n].nodeType&&(" "+this[n].className+" ").replace(at," ").indexOf(t)>=0)return!0;return!1}});var ut=/\r/g;Z.fn.extend({val:function(e){var t,n,r,i=this[0];return arguments.length?(r=Z.isFunction(e),this.each(function(n){var i;1===this.nodeType&&(i=r?e.call(this,n,Z(this).val()):e,null==i?i="":"number"==typeof i?i+="":Z.isArray(i)&&(i=Z.map(i,function(e){return null==e?"":e+""})),t=Z.valHooks[this.type]||Z.valHooks[this.nodeName.toLowerCase()],t&&"set"in t&&void 0!==t.set(this,i,"value")||(this.value=i))})):i?(t=Z.valHooks[i.type]||Z.valHooks[i.nodeName.toLowerCase()],t&&"get"in t&&void 0!==(n=t.get(i,"value"))?n:(n=i.value,"string"==typeof n?n.replace(ut,""):null==n?"":n)):void 0}}),Z.extend({valHooks:{option:{get:function(e){var t=Z.find.attr(e,"value");return null!=t?t:Z.trim(Z.text(e))}},select:{get:function(e){for(var t,n,r=e.options,i=e.selectedIndex,o="select-one"===e.type||0>i,s=o?null:[],a=o?i+1:r.length,u=0>i?a:o?i:0;a>u;u++)if(n=r[u],!(!n.selected&&u!==i||(Q.optDisabled?n.disabled:null!==n.getAttribute("disabled"))||n.parentNode.disabled&&Z.nodeName(n.parentNode,"optgroup"))){if(t=Z(n).val(),o)return t;s.push(t)}return s},set:function(e,t){for(var n,r,i=e.options,o=Z.makeArray(t),s=i.length;s--;)r=i[s],(r.selected=Z.inArray(r.value,o)>=0)&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),Z.each(["radio","checkbox"],function(){Z.valHooks[this]={set:function(e,t){return Z.isArray(t)?e.checked=Z.inArray(Z(e).val(),t)>=0:void 0}},Q.checkOn||(Z.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),Z.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),function(e,t){Z.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),Z.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}});var lt=Z.now(),ct=/\?/;Z.parseJSON=function(e){return JSON.parse(e+"")},Z.parseXML=function(e){var t,n;if(!e||"string"!=typeof e)return null;try{n=new DOMParser,t=n.parseFromString(e,"text/xml")}catch(r){t=void 0}return(!t||t.getElementsByTagName("parsererror").length)&&Z.error("Invalid XML: "+e),t};var ft=/#.*$/,pt=/([?&])_=[^&]*/,dt=/^(.*?):[ \t]*([^\r\n]*)$/gm,ht=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,gt=/^(?:GET|HEAD)$/,mt=/^\/\//,vt=/^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/,yt={},xt={},bt="*/".concat("*"),wt=e.location.href,Tt=vt.exec(wt.toLowerCase())||[];Z.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:wt,type:"GET",isLocal:ht.test(Tt[1]),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":bt,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":Z.parseJSON,"text xml":Z.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?R(R(e,Z.ajaxSettings),t):R(Z.ajaxSettings,e)},ajaxPrefilter:F(yt),ajaxTransport:F(xt),ajax:function(e,t){function n(e,t,n,s){var u,c,v,y,b,T=t;2!==x&&(x=2,a&&clearTimeout(a),r=void 0,o=s||"",w.readyState=e>0?4:0,u=e>=200&&300>e||304===e,n&&(y=M(f,w,n)),y=W(f,y,w,u),u?(f.ifModified&&(b=w.getResponseHeader("Last-Modified"),b&&(Z.lastModified[i]=b),b=w.getResponseHeader("etag"),b&&(Z.etag[i]=b)),204===e||"HEAD"===f.type?T="nocontent":304===e?T="notmodified":(T=y.state,c=y.data,v=y.error,u=!v)):(v=T,(e||!T)&&(T="error",0>e&&(e=0))),w.status=e,w.statusText=(t||T)+"",u?h.resolveWith(p,[c,T,w]):h.rejectWith(p,[w,T,v]),w.statusCode(m),m=void 0,l&&d.trigger(u?"ajaxSuccess":"ajaxError",[w,f,u?c:v]),g.fireWith(p,[w,T]),l&&(d.trigger("ajaxComplete",[w,f]),--Z.active||Z.event.trigger("ajaxStop")))}"object"==typeof e&&(t=e,e=void 0),t=t||{};var r,i,o,s,a,u,l,c,f=Z.ajaxSetup({},t),p=f.context||f,d=f.context&&(p.nodeType||p.jquery)?Z(p):Z.event,h=Z.Deferred(),g=Z.Callbacks("once memory"),m=f.statusCode||{},v={},y={},x=0,b="canceled",w={readyState:0,getResponseHeader:function(e){var t;if(2===x){if(!s)for(s={};t=dt.exec(o);)s[t[1].toLowerCase()]=t[2];t=s[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===x?o:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return x||(e=y[n]=y[n]||e,v[e]=t),this},overrideMimeType:function(e){return x||(f.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>x)for(t in e)m[t]=[m[t],e[t]];else w.always(e[w.status]);return this},abort:function(e){var t=e||b;return r&&r.abort(t),n(0,t),this}};if(h.promise(w).complete=g.add,w.success=w.done,w.error=w.fail,f.url=((e||f.url||wt)+"").replace(ft,"").replace(mt,Tt[1]+"//"),f.type=t.method||t.type||f.method||f.type,f.dataTypes=Z.trim(f.dataType||"*").toLowerCase().match(de)||[""],null==f.crossDomain&&(u=vt.exec(f.url.toLowerCase()),f.crossDomain=!(!u||u[1]===Tt[1]&&u[2]===Tt[2]&&(u[3]||("http:"===u[1]?"80":"443"))===(Tt[3]||("http:"===Tt[1]?"80":"443")))),f.data&&f.processData&&"string"!=typeof f.data&&(f.data=Z.param(f.data,f.traditional)),P(yt,f,t,w),2===x)return w;l=Z.event&&f.global,l&&0===Z.active++&&Z.event.trigger("ajaxStart"),f.type=f.type.toUpperCase(),f.hasContent=!gt.test(f.type),i=f.url,f.hasContent||(f.data&&(i=f.url+=(ct.test(i)?"&":"?")+f.data,delete f.data),f.cache===!1&&(f.url=pt.test(i)?i.replace(pt,"$1_="+lt++):i+(ct.test(i)?"&":"?")+"_="+lt++)),f.ifModified&&(Z.lastModified[i]&&w.setRequestHeader("If-Modified-Since",Z.lastModified[i]),Z.etag[i]&&w.setRequestHeader("If-None-Match",Z.etag[i])),(f.data&&f.hasContent&&f.contentType!==!1||t.contentType)&&w.setRequestHeader("Content-Type",f.contentType),w.setRequestHeader("Accept",f.dataTypes[0]&&f.accepts[f.dataTypes[0]]?f.accepts[f.dataTypes[0]]+("*"!==f.dataTypes[0]?", "+bt+"; q=0.01":""):f.accepts["*"]);for(c in f.headers)w.setRequestHeader(c,f.headers[c]);if(f.beforeSend&&(f.beforeSend.call(p,w,f)===!1||2===x))return w.abort();b="abort";for(c in{success:1,error:1,complete:1})w[c](f[c]);if(r=P(xt,f,t,w)){w.readyState=1,l&&d.trigger("ajaxSend",[w,f]),f.async&&f.timeout>0&&(a=setTimeout(function(){w.abort("timeout")},f.timeout));try{x=1,r.send(v,n)}catch(T){if(!(2>x))throw T;n(-1,T)}}else n(-1,"No Transport");return w},getJSON:function(e,t,n){return Z.get(e,t,n,"json")},getScript:function(e,t){return Z.get(e,void 0,t,"script")}}),Z.each(["get","post"],function(e,t){Z[t]=function(e,n,r,i){return Z.isFunction(n)&&(i=i||r,r=n,n=void 0),Z.ajax({url:e,type:t,dataType:i,data:n,success:r})}}),Z._evalUrl=function(e){return Z.ajax({url:e,type:"GET",dataType:"script",async:!1,global:!1,"throws":!0})},Z.fn.extend({wrapAll:function(e){var t;return Z.isFunction(e)?this.each(function(t){Z(this).wrapAll(e.call(this,t))}):(this[0]&&(t=Z(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e}).append(this)),this)},wrapInner:function(e){return this.each(Z.isFunction(e)?function(t){Z(this).wrapInner(e.call(this,t))}:function(){var t=Z(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=Z.isFunction(e);return this.each(function(n){Z(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){Z.nodeName(this,"body")||Z(this).replaceWith(this.childNodes)}).end()}}),Z.expr.filters.hidden=function(e){return e.offsetWidth<=0&&e.offsetHeight<=0},Z.expr.filters.visible=function(e){return!Z.expr.filters.hidden(e)};var Ct=/%20/g,Nt=/\[\]$/,kt=/\r?\n/g,Et=/^(?:submit|button|image|reset|file)$/i,St=/^(?:input|select|textarea|keygen)/i;Z.param=function(e,t){var n,r=[],i=function(e,t){t=Z.isFunction(t)?t():null==t?"":t,r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(t)};if(void 0===t&&(t=Z.ajaxSettings&&Z.ajaxSettings.traditional),Z.isArray(e)||e.jquery&&!Z.isPlainObject(e))Z.each(e,function(){i(this.name,this.value)});else for(n in e)$(n,e[n],t,i);return r.join("&").replace(Ct,"+")},Z.fn.extend({serialize:function(){return Z.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=Z.prop(this,"elements");return e?Z.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!Z(this).is(":disabled")&&St.test(this.nodeName)&&!Et.test(e)&&(this.checked||!Ne.test(e))}).map(function(e,t){var n=Z(this).val();return null==n?null:Z.isArray(n)?Z.map(n,function(e){return{name:t.name,value:e.replace(kt,"\r\n")}}):{name:t.name,value:n.replace(kt,"\r\n")}}).get()}}),Z.ajaxSettings.xhr=function(){try{return new XMLHttpRequest}catch(e){}};var Dt=0,jt={},At={0:200,1223:204},Lt=Z.ajaxSettings.xhr();e.attachEvent&&e.attachEvent("onunload",function(){for(var e in jt)jt[e]()}),Q.cors=!!Lt&&"withCredentials"in Lt,Q.ajax=Lt=!!Lt,Z.ajaxTransport(function(e){var t;return Q.cors||Lt&&!e.crossDomain?{send:function(n,r){var i,o=e.xhr(),s=++Dt;if(o.open(e.type,e.url,e.async,e.username,e.password),e.xhrFields)for(i in e.xhrFields)o[i]=e.xhrFields[i];e.mimeType&&o.overrideMimeType&&o.overrideMimeType(e.mimeType),e.crossDomain||n["X-Requested-With"]||(n["X-Requested-With"]="XMLHttpRequest");for(i in n)o.setRequestHeader(i,n[i]);t=function(e){return function(){t&&(delete jt[s],t=o.onload=o.onerror=null,"abort"===e?o.abort():"error"===e?r(o.status,o.statusText):r(At[o.status]||o.status,o.statusText,"string"==typeof o.responseText?{text:o.responseText}:void 0,o.getAllResponseHeaders()))}},o.onload=t(),o.onerror=t("error"),t=jt[s]=t("abort");try{o.send(e.hasContent&&e.data||null)}catch(a){if(t)throw a}},abort:function(){t&&t()}}:void 0}),Z.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/(?:java|ecma)script/},converters:{"text script":function(e){return Z.globalEval(e),e}}}),Z.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),Z.ajaxTransport("script",function(e){if(e.crossDomain){var t,n;return{send:function(r,i){t=Z("<script>").prop({async:!0,charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&i("error"===e.type?404:200,e.type)}),J.head.appendChild(t[0])},abort:function(){n&&n()}}}});var qt=[],Ht=/(=)\?(?=&|$)|\?\?/;Z.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=qt.pop()||Z.expando+"_"+lt++;return this[e]=!0,e}}),Z.ajaxPrefilter("json jsonp",function(t,n,r){var i,o,s,a=t.jsonp!==!1&&(Ht.test(t.url)?"url":"string"==typeof t.data&&!(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Ht.test(t.data)&&"data");return a||"jsonp"===t.dataTypes[0]?(i=t.jsonpCallback=Z.isFunction(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,a?t[a]=t[a].replace(Ht,"$1"+i):t.jsonp!==!1&&(t.url+=(ct.test(t.url)?"&":"?")+t.jsonp+"="+i),t.converters["script json"]=function(){return s||Z.error(i+" was not called"),s[0]},t.dataTypes[0]="json",o=e[i],e[i]=function(){s=arguments},r.always(function(){e[i]=o,t[i]&&(t.jsonpCallback=n.jsonpCallback,qt.push(i)),s&&Z.isFunction(o)&&o(s[0]),s=o=void 0}),"script"):void 0}),Z.parseHTML=function(e,t,n){if(!e||"string"!=typeof e)return null;"boolean"==typeof t&&(n=t,t=!1),t=t||J;var r=se.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=Z.buildFragment([e],t,i),i&&i.length&&Z(i).remove(),Z.merge([],r.childNodes))};var Ot=Z.fn.load;Z.fn.load=function(e,t,n){if("string"!=typeof e&&Ot)return Ot.apply(this,arguments);var r,i,o,s=this,a=e.indexOf(" ");return a>=0&&(r=Z.trim(e.slice(a)),e=e.slice(0,a)),Z.isFunction(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),s.length>0&&Z.ajax({url:e,type:i,dataType:"html",data:t}).done(function(e){o=arguments,s.html(r?Z("<div>").append(Z.parseHTML(e)).find(r):e)}).complete(n&&function(e,t){s.each(n,o||[e.responseText,t,e])}),this},Z.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){Z.fn[t]=function(e){return this.on(t,e)}}),Z.expr.filters.animated=function(e){return Z.grep(Z.timers,function(t){return e===t.elem}).length};var Ft=e.document.documentElement;Z.offset={setOffset:function(e,t,n){var r,i,o,s,a,u,l,c=Z.css(e,"position"),f=Z(e),p={};"static"===c&&(e.style.position="relative"),a=f.offset(),o=Z.css(e,"top"),u=Z.css(e,"left"),l=("absolute"===c||"fixed"===c)&&(o+u).indexOf("auto")>-1,l?(r=f.position(),s=r.top,i=r.left):(s=parseFloat(o)||0,i=parseFloat(u)||0),Z.isFunction(t)&&(t=t.call(e,n,a)),null!=t.top&&(p.top=t.top-a.top+s),null!=t.left&&(p.left=t.left-a.left+i),"using"in t?t.using.call(e,p):f.css(p)}},Z.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each(function(t){Z.offset.setOffset(this,e,t)});var t,n,r=this[0],i={top:0,left:0},o=r&&r.ownerDocument;return o?(t=o.documentElement,Z.contains(t,r)?(typeof r.getBoundingClientRect!==ke&&(i=r.getBoundingClientRect()),n=I(o),{top:i.top+n.pageYOffset-t.clientTop,left:i.left+n.pageXOffset-t.clientLeft}):i):void 0},position:function(){if(this[0]){var e,t,n=this[0],r={top:0,left:0};return"fixed"===Z.css(n,"position")?t=n.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),Z.nodeName(e[0],"html")||(r=e.offset()),r.top+=Z.css(e[0],"borderTopWidth",!0),r.left+=Z.css(e[0],"borderLeftWidth",!0)),{top:t.top-r.top-Z.css(n,"marginTop",!0),left:t.left-r.left-Z.css(n,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var e=this.offsetParent||Ft;e&&!Z.nodeName(e,"html")&&"static"===Z.css(e,"position");)e=e.offsetParent;return e||Ft})}}),Z.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,n){var r="pageYOffset"===n;Z.fn[t]=function(i){return me(this,function(t,i,o){var s=I(t);return void 0===o?s?s[n]:t[i]:void(s?s.scrollTo(r?e.pageXOffset:o,r?o:e.pageYOffset):t[i]=o)},t,i,arguments.length,null)}}),Z.each(["top","left"],function(e,t){Z.cssHooks[t]=T(Q.pixelPosition,function(e,n){return n?(n=w(e,t),Be.test(n)?Z(e).position()[t]+"px":n):void 0})}),Z.each({Height:"height",Width:"width"},function(e,t){Z.each({padding:"inner"+e,content:t,"":"outer"+e},function(n,r){Z.fn[r]=function(r,i){var o=arguments.length&&(n||"boolean"!=typeof r),s=n||(r===!0||i===!0?"margin":"border");return me(this,function(t,n,r){var i;return Z.isWindow(t)?t.document.documentElement["client"+e]:9===t.nodeType?(i=t.documentElement,Math.max(t.body["scroll"+e],i["scroll"+e],t.body["offset"+e],i["offset"+e],i["client"+e])):void 0===r?Z.css(t,n,s):Z.style(t,n,r,s)},t,o?r:void 0,o,null)}})}),Z.fn.size=function(){return this.length},Z.fn.andSelf=Z.fn.addBack,"function"==typeof define&&define.amd&&define("jquery",[],function(){return Z});var Pt=e.jQuery,Rt=e.$;return Z.noConflict=function(t){return e.$===Z&&(e.$=Rt),t&&e.jQuery===Z&&(e.jQuery=Pt),Z},typeof t===ke&&(e.jQuery=e.$=Z),Z});
!function(t,e,i,n){"use strict";function r(t,e,i){return setTimeout(c(t,i),e)}function s(t,e,i){return Array.isArray(t)?(o(t,i[e],i),!0):!1}function o(t,e,i){var r;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==n)for(r=0;r<t.length;)e.call(i,t[r],r,t),r++;else for(r in t)t.hasOwnProperty(r)&&e.call(i,t[r],r,t)}function a(t,e,i){for(var r=Object.keys(e),s=0;s<r.length;)(!i||i&&t[r[s]]===n)&&(t[r[s]]=e[r[s]]),s++;return t}function h(t,e){return a(t,e,!0)}function u(t,e,i){var n,r=e.prototype;n=t.prototype=Object.create(r),n.constructor=t,n._super=r,i&&a(n,i)}function c(t,e){return function(){return t.apply(e,arguments)}}function l(t,e){return typeof t==ct?t.apply(e?e[0]||n:n,e):t}function p(t,e){return t===n?e:t}function f(t,e,i){o(g(e),function(e){t.addEventListener(e,i,!1)})}function d(t,e,i){o(g(e),function(e){t.removeEventListener(e,i,!1)})}function v(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function m(t,e){return t.indexOf(e)>-1}function g(t){return t.trim().split(/\s+/g)}function T(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function y(t){return Array.prototype.slice.call(t,0)}function E(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];T(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort(function(t,i){return t[e]>i[e]}):n.sort()),n}function I(t,e){for(var i,r,s=e[0].toUpperCase()+e.slice(1),o=0;o<ht.length;){if(i=ht[o],r=i?i+s:e,r in t)return r;o++}return n}function A(){return dt++}function _(t){var e=t.ownerDocument;return e.defaultView||e.parentWindow}function D(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){l(t.options.enable,[t])&&i.handler(e)},this.init()}function S(t){var e,i=t.options.inputClass;return new(e=i?i:gt?W:Tt?H:mt?U:F)(t,w)}function w(t,e,i){var n=i.pointers.length,r=i.changedPointers.length,s=e&Dt&&n-r===0,o=e&(wt|bt)&&n-r===0;i.isFirst=!!s,i.isFinal=!!o,s&&(t.session={}),i.eventType=e,b(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function b(t,e){var i=t.session,n=e.pointers,r=n.length;i.firstInput||(i.firstInput=z(e)),r>1&&!i.firstMultiple?i.firstMultiple=z(e):1===r&&(i.firstMultiple=!1);var s=i.firstInput,o=i.firstMultiple,a=o?o.center:s.center,h=e.center=N(n);e.timeStamp=ft(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=x(a,h),e.distance=O(a,h),C(i,e),e.offsetDirection=M(e.deltaX,e.deltaY),e.scale=o?Y(o.pointers,n):1,e.rotation=o?X(o.pointers,n):0,R(i,e);var u=t.element;v(e.srcEvent.target,u)&&(u=e.srcEvent.target),e.target=u}function C(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};(e.eventType===Dt||s.eventType===wt)&&(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y}),e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}function R(t,e){var i,r,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(e.eventType!=bt&&(h>_t||a.velocity===n)){var u=a.deltaX-e.deltaX,c=a.deltaY-e.deltaY,l=P(h,u,c);r=l.x,s=l.y,i=pt(l.x)>pt(l.y)?l.x:l.y,o=M(u,c),t.lastInterval=e}else i=a.velocity,r=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=r,e.velocityY=s,e.direction=o}function z(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:lt(t.pointers[i].clientX),clientY:lt(t.pointers[i].clientY)},i++;return{timeStamp:ft(),pointers:e,center:N(e),deltaX:t.deltaX,deltaY:t.deltaY}}function N(t){var e=t.length;if(1===e)return{x:lt(t[0].clientX),y:lt(t[0].clientY)};for(var i=0,n=0,r=0;e>r;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:lt(i/e),y:lt(n/e)}}function P(t,e,i){return{x:e/t||0,y:i/t||0}}function M(t,e){return t===e?Ct:pt(t)>=pt(e)?t>0?Rt:zt:e>0?Nt:Pt}function O(t,e,i){i||(i=Xt);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function x(t,e,i){i||(i=Xt);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}function X(t,e){return x(e[1],e[0],Yt)-x(t[1],t[0],Yt)}function Y(t,e){return O(e[0],e[1],Yt)/O(t[0],t[1],Yt)}function F(){this.evEl=Wt,this.evWin=qt,this.allow=!0,this.pressed=!1,D.apply(this,arguments)}function W(){this.evEl=kt,this.evWin=Ut,D.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}function q(){this.evTarget=Vt,this.evWin=jt,this.started=!1,D.apply(this,arguments)}function L(t,e){var i=y(t.touches),n=y(t.changedTouches);return e&(wt|bt)&&(i=E(i.concat(n),"identifier",!0)),[i,n]}function H(){this.evTarget=Bt,this.targetIds={},D.apply(this,arguments)}function k(t,e){var i=y(t.touches),n=this.targetIds;if(e&(Dt|St)&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=y(t.changedTouches),a=[],h=this.target;if(s=i.filter(function(t){return v(t.target,h)}),e===Dt)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),e&(wt|bt)&&delete n[o[r].identifier],r++;return a.length?[E(s.concat(a),"identifier",!0),a]:void 0}function U(){D.apply(this,arguments);var t=c(this.handler,this);this.touch=new H(this.manager,t),this.mouse=new F(this.manager,t)}function G(t,e){this.manager=t,this.set(e)}function V(t){if(m(t,ee))return ee;var e=m(t,ie),i=m(t,ne);return e&&i?ie+" "+ne:e||i?e?ie:ne:m(t,te)?te:$t}function j(t){this.id=A(),this.manager=null,this.options=h(t||{},this.defaults),this.options.enable=p(this.options.enable,!0),this.state=re,this.simultaneous={},this.requireFail=[]}function Z(t){return t&ue?"cancel":t&ae?"end":t&oe?"move":t&se?"start":""}function B(t){return t==Pt?"down":t==Nt?"up":t==Rt?"left":t==zt?"right":""}function J(t,e){var i=e.manager;return i?i.get(t):t}function K(){j.apply(this,arguments)}function Q(){K.apply(this,arguments),this.pX=null,this.pY=null}function $(){K.apply(this,arguments)}function tt(){j.apply(this,arguments),this._timer=null,this._input=null}function et(){K.apply(this,arguments)}function it(){K.apply(this,arguments)}function nt(){j.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function rt(t,e){return e=e||{},e.recognizers=p(e.recognizers,rt.defaults.preset),new st(t,e)}function st(t,e){e=e||{},this.options=h(e,rt.defaults),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.element=t,this.input=S(this),this.touchAction=new G(this,this.options.touchAction),ot(this,!0),o(e.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function ot(t,e){var i=t.element;o(t.options.cssProps,function(t,n){i.style[I(i.style,n)]=e?t:""})}function at(t,i){var n=e.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=i,i.target.dispatchEvent(n)}var ht=["","webkit","moz","MS","ms","o"],ut=e.createElement("div"),ct="function",lt=Math.round,pt=Math.abs,ft=Date.now,dt=1,vt=/mobile|tablet|ip(ad|hone|od)|android/i,mt="ontouchstart"in t,gt=I(t,"PointerEvent")!==n,Tt=mt&&vt.test(navigator.userAgent),yt="touch",Et="pen",It="mouse",At="kinect",_t=25,Dt=1,St=2,wt=4,bt=8,Ct=1,Rt=2,zt=4,Nt=8,Pt=16,Mt=Rt|zt,Ot=Nt|Pt,xt=Mt|Ot,Xt=["x","y"],Yt=["clientX","clientY"];D.prototype={handler:function(){},init:function(){this.evEl&&f(this.element,this.evEl,this.domHandler),this.evTarget&&f(this.target,this.evTarget,this.domHandler),this.evWin&&f(_(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&d(this.element,this.evEl,this.domHandler),this.evTarget&&d(this.target,this.evTarget,this.domHandler),this.evWin&&d(_(this.element),this.evWin,this.domHandler)}};var Ft={mousedown:Dt,mousemove:St,mouseup:wt},Wt="mousedown",qt="mousemove mouseup";u(F,D,{handler:function(t){var e=Ft[t.type];e&Dt&&0===t.button&&(this.pressed=!0),e&St&&1!==t.which&&(e=wt),this.pressed&&this.allow&&(e&wt&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:It,srcEvent:t}))}});var Lt={pointerdown:Dt,pointermove:St,pointerup:wt,pointercancel:bt,pointerout:bt},Ht={2:yt,3:Et,4:It,5:At},kt="pointerdown",Ut="pointermove pointerup pointercancel";t.MSPointerEvent&&(kt="MSPointerDown",Ut="MSPointerMove MSPointerUp MSPointerCancel"),u(W,D,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=Lt[n],s=Ht[t.pointerType]||t.pointerType,o=s==yt,a=T(e,t.pointerId,"pointerId");r&Dt&&(0===t.button||o)?0>a&&(e.push(t),a=e.length-1):r&(wt|bt)&&(i=!0),0>a||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var Gt={touchstart:Dt,touchmove:St,touchend:wt,touchcancel:bt},Vt="touchstart",jt="touchstart touchmove touchend touchcancel";u(q,D,{handler:function(t){var e=Gt[t.type];if(e===Dt&&(this.started=!0),this.started){var i=L.call(this,t,e);e&(wt|bt)&&i[0].length-i[1].length===0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:yt,srcEvent:t})}}});var Zt={touchstart:Dt,touchmove:St,touchend:wt,touchcancel:bt},Bt="touchstart touchmove touchend touchcancel";u(H,D,{handler:function(t){var e=Zt[t.type],i=k.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:yt,srcEvent:t})}}),u(U,D,{handler:function(t,e,i){var n=i.pointerType==yt,r=i.pointerType==It;if(n)this.mouse.allow=!1;else if(r&&!this.mouse.allow)return;e&(wt|bt)&&(this.mouse.allow=!0),this.callback(t,e,i)},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var Jt=I(ut.style,"touchAction"),Kt=Jt!==n,Qt="compute",$t="auto",te="manipulation",ee="none",ie="pan-x",ne="pan-y";G.prototype={set:function(t){t==Qt&&(t=this.compute()),Kt&&(this.manager.element.style[Jt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return o(this.manager.recognizers,function(e){l(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),V(t.join(" "))},preventDefaults:function(t){if(!Kt){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)return void e.preventDefault();var n=this.actions,r=m(n,ee),s=m(n,ne),o=m(n,ie);return r||s&&i&Mt||o&&i&Ot?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var re=1,se=2,oe=4,ae=8,he=ae,ue=16,ce=32;j.prototype={defaults:{},set:function(t){return a(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(s(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=J(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return s(t,"dropRecognizeWith",this)?this:(t=J(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(s(t,"requireFailure",this))return this;var e=this.requireFail;return t=J(t,this),-1===T(e,t)&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(s(t,"dropRequireFailure",this))return this;t=J(t,this);var e=T(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){function e(e){i.manager.emit(i.options.event+(e?Z(n):""),t)}var i=this,n=this.state;ae>n&&e(!0),e(),n>=ae&&e(!0)},tryEmit:function(t){return this.canEmit()?this.emit(t):void(this.state=ce)},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(ce|re)))return!1;t++}return!0},recognize:function(t){var e=a({},t);return l(this.options.enable,[this,e])?(this.state&(he|ue|ce)&&(this.state=re),this.state=this.process(e),void(this.state&(se|oe|ae|ue)&&this.tryEmit(e))):(this.reset(),void(this.state=ce))},process:function(t){},getTouchAction:function(){},reset:function(){}},u(K,j,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=e&(se|oe),r=this.attrTest(t);return n&&(i&bt||!r)?e|ue:n||r?i&wt?e|ae:e&se?e|oe:se:ce}}),u(Q,K,{defaults:{event:"pan",threshold:10,pointers:1,direction:xt},getTouchAction:function(){var t=this.options.direction,e=[];return t&Mt&&e.push(ne),t&Ot&&e.push(ie),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(e.direction&Mt?(r=0===s?Ct:0>s?Rt:zt,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?Ct:0>o?Nt:Pt,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return K.prototype.attrTest.call(this,t)&&(this.state&se||!(this.state&se)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=B(t.direction);e&&this.manager.emit(this.options.event+e,t),this._super.emit.call(this,t)}}),u($,K,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[ee]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&se)},emit:function(t){if(this._super.emit.call(this,t),1!==t.scale){var e=t.scale<1?"in":"out";this.manager.emit(this.options.event+e,t)}}}),u(tt,j,{defaults:{event:"press",pointers:1,time:500,threshold:5},getTouchAction:function(){return[$t]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,s=t.deltaTime>e.time;if(this._input=t,!n||!i||t.eventType&(wt|bt)&&!s)this.reset();else if(t.eventType&Dt)this.reset(),this._timer=r(function(){this.state=he,this.tryEmit()},e.time,this);else if(t.eventType&wt)return he;return ce},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===he&&(t&&t.eventType&wt?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=ft(),this.manager.emit(this.options.event,this._input)))}}),u(et,K,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[ee]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&se)}}),u(it,K,{defaults:{event:"swipe",threshold:10,velocity:.65,direction:Mt|Ot,pointers:1},getTouchAction:function(){return Q.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return i&(Mt|Ot)?e=t.velocity:i&Mt?e=t.velocityX:i&Ot&&(e=t.velocityY),this._super.attrTest.call(this,t)&&i&t.direction&&t.distance>this.options.threshold&&pt(e)>this.options.velocity&&t.eventType&wt},emit:function(t){var e=B(t.direction);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),u(nt,j,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:2,posThreshold:10},getTouchAction:function(){return[te]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,s=t.deltaTime<e.time;if(this.reset(),t.eventType&Dt&&0===this.count)return this.failTimeout();if(n&&s&&i){if(t.eventType!=wt)return this.failTimeout();var o=this.pTime?t.timeStamp-this.pTime<e.interval:!0,a=!this.pCenter||O(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,a&&o?this.count+=1:this.count=1,this._input=t;var h=this.count%e.taps;if(0===h)return this.hasRequireFailures()?(this._timer=r(function(){this.state=he,this.tryEmit()},e.interval,this),se):he}return ce},failTimeout:function(){return this._timer=r(function(){this.state=ce},this.options.interval,this),ce},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==he&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),rt.VERSION="2.0.4",rt.defaults={domEvents:!1,touchAction:Qt,enable:!0,inputTarget:null,inputClass:null,preset:[[et,{enable:!1}],[$,{enable:!1},["rotate"]],[it,{direction:Mt}],[Q,{direction:Mt},["swipe"]],[nt],[nt,{event:"doubletap",taps:2},["tap"]],[tt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};var le=1,pe=2;st.prototype={set:function(t){return a(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?pe:le},recognize:function(t){var e=this.session;if(!e.stopped){this.touchAction.preventDefaults(t);var i,n=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&he)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],e.stopped===pe||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&i.state&(se|oe|ae)&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof j)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(s(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(s(t,"remove",this))return this;var e=this.recognizers;return t=this.get(t),e.splice(T(e,t),1),this.touchAction.update(),this},on:function(t,e){var i=this.handlers;return o(g(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this},off:function(t,e){var i=this.handlers;return o(g(t),function(t){e?i[t].splice(T(i[t],e),1):delete i[t]}),this},emit:function(t,e){this.options.domEvents&&at(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var n=0;n<i.length;)i[n](e),n++}},destroy:function(){this.element&&ot(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},a(rt,{INPUT_START:Dt,INPUT_MOVE:St,INPUT_END:wt,INPUT_CANCEL:bt,STATE_POSSIBLE:re,STATE_BEGAN:se,STATE_CHANGED:oe,STATE_ENDED:ae,STATE_RECOGNIZED:he,STATE_CANCELLED:ue,STATE_FAILED:ce,DIRECTION_NONE:Ct,DIRECTION_LEFT:Rt,DIRECTION_RIGHT:zt,DIRECTION_UP:Nt,DIRECTION_DOWN:Pt,DIRECTION_HORIZONTAL:Mt,DIRECTION_VERTICAL:Ot,DIRECTION_ALL:xt,Manager:st,Input:D,TouchAction:G,TouchInput:H,MouseInput:F,PointerEventInput:W,TouchMouseInput:U,SingleTouchInput:q,Recognizer:j,AttrRecognizer:K,Tap:nt,Pan:Q,Swipe:it,Pinch:$,Rotate:et,Press:tt,on:f,off:d,each:o,merge:h,extend:a,inherit:u,bindFn:c,prefixed:I}),typeof define==ct&&define.amd?define(function(){return rt}):"undefined"!=typeof module&&module.exports?module.exports=rt:t[i]=rt}(window,document,"Hammer");
!function(t,e,n){"use strict";function r(t,e){return e=e||Error,function(){var n,r,i=arguments[0],o="["+(t?t+":":"")+i+"] ",a=arguments[1],s=arguments;for(n=o+a.replace(/\{\d+\}/g,function(t){var e=+t.slice(1,-1);return e+2<s.length?ht(s[e+2]):t}),n=n+"\nhttp://errors.angularjs.org/1.3.15/"+(t?t+"/":"")+i,r=2;r<arguments.length;r++)n=n+(2==r?"?":"&")+"p"+(r-2)+"="+encodeURIComponent(ht(arguments[r]));return new e(n)}}function i(t){if(null==t||A(t))return!1;var e=t.length;return t.nodeType===yr&&e?!0:w(t)||hr(t)||0===e||"number"==typeof e&&e>0&&e-1 in t}function o(t,e,n){var r,a;if(t)if(S(t))for(r in t)"prototype"==r||"length"==r||"name"==r||t.hasOwnProperty&&!t.hasOwnProperty(r)||e.call(n,t[r],r,t);else if(hr(t)||i(t)){var s="object"!=typeof t;for(r=0,a=t.length;a>r;r++)(s||r in t)&&e.call(n,t[r],r,t)}else if(t.forEach&&t.forEach!==o)t.forEach(e,n,t);else for(r in t)t.hasOwnProperty(r)&&e.call(n,t[r],r,t);return t}function a(t){return Object.keys(t).sort()}function s(t,e,n){for(var r=a(t),i=0;i<r.length;i++)e.call(n,t[r[i]],r[i]);return r}function u(t){return function(e,n){t(n,e)}}function c(){return++lr}function l(t,e){e?t.$$hashKey=e:delete t.$$hashKey}function f(t){for(var e=t.$$hashKey,n=1,r=arguments.length;r>n;n++){var i=arguments[n];if(i)for(var o=Object.keys(i),a=0,s=o.length;s>a;a++){var u=o[a];t[u]=i[u]}}return l(t,e),t}function h(t){return parseInt(t,10)}function $(t,e){return f(Object.create(t),e)}function p(){}function d(t){return t}function v(t){return function(){return t}}function m(t){return"undefined"==typeof t}function g(t){return"undefined"!=typeof t}function y(t){return null!==t&&"object"==typeof t}function w(t){return"string"==typeof t}function b(t){return"number"==typeof t}function x(t){return"[object Date]"===sr.call(t)}function S(t){return"function"==typeof t}function C(t){return"[object RegExp]"===sr.call(t)}function A(t){return t&&t.window===t}function E(t){return t&&t.$evalAsync&&t.$watch}function k(t){return"[object File]"===sr.call(t)}function O(t){return"[object FormData]"===sr.call(t)}function T(t){return"[object Blob]"===sr.call(t)}function M(t){return"boolean"==typeof t}function N(t){return t&&S(t.then)}function V(t){return!(!t||!(t.nodeName||t.prop&&t.attr&&t.find))}function D(t){var e,n={},r=t.split(",");for(e=0;e<r.length;e++)n[r[e]]=!0;return n}function j(t){return Jn(t.nodeName||t[0]&&t[0].nodeName)}function R(t,e){var n=t.indexOf(e);return n>=0&&t.splice(n,1),e}function P(t,e,n,r){if(A(t)||E(t))throw ur("cpws","Can't copy! Making copies of Window or Scope instances is not supported.");if(e){if(t===e)throw ur("cpi","Can't copy! Source and destination are identical.");if(n=n||[],r=r||[],y(t)){var i=n.indexOf(t);if(-1!==i)return r[i];n.push(t),r.push(e)}var a;if(hr(t)){e.length=0;for(var s=0;s<t.length;s++)a=P(t[s],null,n,r),y(t[s])&&(n.push(t[s]),r.push(a)),e.push(a)}else{var u=e.$$hashKey;hr(e)?e.length=0:o(e,function(t,n){delete e[n]});for(var c in t)t.hasOwnProperty(c)&&(a=P(t[c],null,n,r),y(t[c])&&(n.push(t[c]),r.push(a)),e[c]=a);l(e,u)}}else if(e=t,t)if(hr(t))e=P(t,[],n,r);else if(x(t))e=new Date(t.getTime());else if(C(t))e=new RegExp(t.source,t.toString().match(/[^\/]*$/)[0]),e.lastIndex=t.lastIndex;else if(y(t)){var f=Object.create(Object.getPrototypeOf(t));e=P(t,f,n,r)}return e}function _(t,e){if(hr(t)){e=e||[];for(var n=0,r=t.length;r>n;n++)e[n]=t[n]}else if(y(t)){e=e||{};for(var i in t)("$"!==i.charAt(0)||"$"!==i.charAt(1))&&(e[i]=t[i])}return e||t}function I(t,e){if(t===e)return!0;if(null===t||null===e)return!1;if(t!==t&&e!==e)return!0;var r,i,o,a=typeof t,s=typeof e;if(a==s&&"object"==a){if(!hr(t)){if(x(t))return x(e)?I(t.getTime(),e.getTime()):!1;if(C(t))return C(e)?t.toString()==e.toString():!1;if(E(t)||E(e)||A(t)||A(e)||hr(e)||x(e)||C(e))return!1;o={};for(i in t)if("$"!==i.charAt(0)&&!S(t[i])){if(!I(t[i],e[i]))return!1;o[i]=!0}for(i in e)if(!o.hasOwnProperty(i)&&"$"!==i.charAt(0)&&e[i]!==n&&!S(e[i]))return!1;return!0}if(!hr(e))return!1;if((r=t.length)==e.length){for(i=0;r>i;i++)if(!I(t[i],e[i]))return!1;return!0}}return!1}function q(t,e,n){return t.concat(ir.call(e,n))}function U(t,e){return ir.call(t,e||0)}function F(t,e){var n=arguments.length>2?U(arguments,2):[];return!S(e)||e instanceof RegExp?e:n.length?function(){return arguments.length?e.apply(t,q(n,arguments,0)):e.apply(t,n)}:function(){return arguments.length?e.apply(t,arguments):e.call(t)}}function H(t,r){var i=r;return"string"==typeof t&&"$"===t.charAt(0)&&"$"===t.charAt(1)?i=n:A(r)?i="$WINDOW":r&&e===r?i="$DOCUMENT":E(r)&&(i="$SCOPE"),i}function L(t,e){return"undefined"==typeof t?n:(b(e)||(e=e?2:null),JSON.stringify(t,H,e))}function B(t){return w(t)?JSON.parse(t):t}function z(t){t=er(t).clone();try{t.empty()}catch(e){}var n=er("<div>").append(t).html();try{return t[0].nodeType===wr?Jn(n):n.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/,function(t,e){return"<"+Jn(e)})}catch(e){return Jn(n)}}function G(t){try{return decodeURIComponent(t)}catch(e){}}function W(t){var e,n,r={};return o((t||"").split("&"),function(t){if(t&&(e=t.replace(/\+/g,"%20").split("="),n=G(e[0]),g(n))){var i=g(e[1])?G(e[1]):!0;Zn.call(r,n)?hr(r[n])?r[n].push(i):r[n]=[r[n],i]:r[n]=i}}),r}function Y(t){var e=[];return o(t,function(t,n){hr(t)?o(t,function(t){e.push(Z(n,!0)+(t===!0?"":"="+Z(t,!0)))}):e.push(Z(n,!0)+(t===!0?"":"="+Z(t,!0)))}),e.length?e.join("&"):""}function J(t){return Z(t,!0).replace(/%26/gi,"&").replace(/%3D/gi,"=").replace(/%2B/gi,"+")}function Z(t,e){return encodeURIComponent(t).replace(/%40/gi,"@").replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%3B/gi,";").replace(/%20/g,e?"%20":"+")}function K(t,e){var n,r,i=vr.length;for(t=er(t),r=0;i>r;++r)if(n=vr[r]+e,w(n=t.attr(n)))return n;return null}function X(t,e){var n,r,i={};o(vr,function(e){var i=e+"app";!n&&t.hasAttribute&&t.hasAttribute(i)&&(n=t,r=t.getAttribute(i))}),o(vr,function(e){var i,o=e+"app";!n&&(i=t.querySelector("["+o.replace(":","\\:")+"]"))&&(n=i,r=i.getAttribute(o))}),n&&(i.strictDi=null!==K(n,"strict-di"),e(n,r?[r]:[],i))}function Q(n,r,i){y(i)||(i={});var a={strictDi:!1};i=f(a,i);var s=function(){if(n=er(n),n.injector()){var t=n[0]===e?"document":z(n);throw ur("btstrpd","App Already Bootstrapped with this Element '{0}'",t.replace(/</,"&lt;").replace(/>/,"&gt;"))}r=r||[],r.unshift(["$provide",function(t){t.value("$rootElement",n)}]),i.debugInfoEnabled&&r.push(["$compileProvider",function(t){t.debugInfoEnabled(!0)}]),r.unshift("ng");var o=Bt(r,i.strictDi);return o.invoke(["$rootScope","$rootElement","$compile","$injector",function(t,e,n,r){t.$apply(function(){e.data("$injector",r),n(e)(t)})}]),o},u=/^NG_ENABLE_DEBUG_INFO!/,c=/^NG_DEFER_BOOTSTRAP!/;return t&&u.test(t.name)&&(i.debugInfoEnabled=!0,t.name=t.name.replace(u,"")),t&&!c.test(t.name)?s():(t.name=t.name.replace(c,""),cr.resumeBootstrap=function(t){return o(t,function(t){r.push(t)}),s()},void(S(cr.resumeDeferredBootstrap)&&cr.resumeDeferredBootstrap()))}function tt(){t.name="NG_ENABLE_DEBUG_INFO!"+t.name,t.location.reload()}function et(t){var e=cr.element(t).injector();if(!e)throw ur("test","no injector found for element argument to getTestability");return e.get("$$testability")}function nt(t,e){return e=e||"_",t.replace(mr,function(t,n){return(n?e:"")+t.toLowerCase()})}function rt(){var e;gr||(nr=t.jQuery,nr&&nr.fn.on?(er=nr,f(nr.fn,{scope:Ir.scope,isolateScope:Ir.isolateScope,controller:Ir.controller,injector:Ir.injector,inheritedData:Ir.inheritedData}),e=nr.cleanData,nr.cleanData=function(t){var n;if(fr)fr=!1;else for(var r,i=0;null!=(r=t[i]);i++)n=nr._data(r,"events"),n&&n.$destroy&&nr(r).triggerHandler("$destroy");e(t)}):er=wt,cr.element=er,gr=!0)}function it(t,e,n){if(!t)throw ur("areq","Argument '{0}' is {1}",e||"?",n||"required");return t}function ot(t,e,n){return n&&hr(t)&&(t=t[t.length-1]),it(S(t),e,"not a function, got "+(t&&"object"==typeof t?t.constructor.name||"Object":typeof t)),t}function at(t,e){if("hasOwnProperty"===t)throw ur("badname","hasOwnProperty is not a valid {0} name",e)}function st(t,e,n){if(!e)return t;for(var r,i=e.split("."),o=t,a=i.length,s=0;a>s;s++)r=i[s],t&&(t=(o=t)[r]);return!n&&S(t)?F(o,t):t}function ut(t){var e=t[0],n=t[t.length-1],r=[e];do{if(e=e.nextSibling,!e)break;r.push(e)}while(e!==n);return er(r)}function ct(){return Object.create(null)}function lt(t){function e(t,e,n){return t[e]||(t[e]=n())}var n=r("$injector"),i=r("ng"),o=e(t,"angular",Object);return o.$$minErr=o.$$minErr||r,e(o,"module",function(){var t={};return function(r,o,a){var s=function(t,e){if("hasOwnProperty"===t)throw i("badname","hasOwnProperty is not a valid {0} name",e)};return s(r,"module"),o&&t.hasOwnProperty(r)&&(t[r]=null),e(t,r,function(){function t(t,n,r,i){return i||(i=e),function(){return i[r||"push"]([t,n,arguments]),c}}if(!o)throw n("nomod","Module '{0}' is not available! You either misspelled the module name or forgot to load it. If registering a module ensure that you specify the dependencies as the second argument.",r);var e=[],i=[],s=[],u=t("$injector","invoke","push",i),c={_invokeQueue:e,_configBlocks:i,_runBlocks:s,requires:o,name:r,provider:t("$provide","provider"),factory:t("$provide","factory"),service:t("$provide","service"),value:t("$provide","value"),constant:t("$provide","constant","unshift"),animation:t("$animateProvider","register"),filter:t("$filterProvider","register"),controller:t("$controllerProvider","register"),directive:t("$compileProvider","directive"),config:u,run:function(t){return s.push(t),this}};return a&&u(a),c})}})}function ft(t){var e=[];return JSON.stringify(t,function(t,n){if(n=H(t,n),y(n)){if(e.indexOf(n)>=0)return"<<already seen>>";e.push(n)}return n})}function ht(t){return"function"==typeof t?t.toString().replace(/ \{[\s\S]*$/,""):"undefined"==typeof t?"undefined":"string"!=typeof t?ft(t):t}function $t(e){f(e,{bootstrap:Q,copy:P,extend:f,equals:I,element:er,forEach:o,injector:Bt,noop:p,bind:F,toJson:L,fromJson:B,identity:d,isUndefined:m,isDefined:g,isString:w,isFunction:S,isObject:y,isNumber:b,isElement:V,isArray:hr,version:Cr,isDate:x,lowercase:Jn,uppercase:Kn,callbacks:{counter:0},getTestability:et,$$minErr:r,$$csp:dr,reloadWithDebugInfo:tt}),rr=lt(t);try{rr("ngLocale")}catch(n){rr("ngLocale",[]).provider("$locale",ve)}rr("ng",["ngLocale"],["$provide",function(t){t.provider({$$sanitizeUri:Ye}),t.provider("$compile",Kt).directive({a:Mi,input:Wi,textarea:Wi,form:Ri,script:_o,select:Uo,style:Ho,option:Fo,ngBind:Zi,ngBindHtml:Xi,ngBindTemplate:Ki,ngClass:to,ngClassEven:no,ngClassOdd:eo,ngCloak:ro,ngController:io,ngForm:Pi,ngHide:No,ngIf:so,ngInclude:uo,ngInit:lo,ngNonBindable:Ao,ngPluralize:Eo,ngRepeat:ko,ngShow:Mo,ngStyle:Vo,ngSwitch:Do,ngSwitchWhen:jo,ngSwitchDefault:Ro,ngOptions:qo,ngTransclude:Po,ngModel:xo,ngList:fo,ngChange:Qi,pattern:Bo,ngPattern:Bo,required:Lo,ngRequired:Lo,minlength:Go,ngMinlength:Go,maxlength:zo,ngMaxlength:zo,ngValue:Ji,ngModelOptions:Co}).directive({ngInclude:co}).directive(Ni).directive(oo),t.provider({$anchorScroll:zt,$animate:Yr,$browser:Yt,$cacheFactory:Jt,$controller:ee,$document:ne,$exceptionHandler:re,$filter:sn,$interpolate:pe,$interval:de,$http:le,$httpBackend:he,$location:Me,$log:Ne,$parse:He,$rootScope:We,$q:Le,$$q:Be,$sce:Xe,$sceDelegate:Ke,$sniffer:Qe,$templateCache:Zt,$templateRequest:tn,$$testability:en,$timeout:nn,$window:an,$$rAF:Ge,$$asyncCallback:Gt,$$jqLite:qt})}])}function pt(){return++Er}function dt(t){return t.replace(Tr,function(t,e,n,r){return r?n.toUpperCase():n}).replace(Mr,"Moz$1")}function vt(t){return!jr.test(t)}function mt(t){var e=t.nodeType;return e===yr||!e||e===xr}function gt(t,e){var n,r,i,a,s=e.createDocumentFragment(),u=[];if(vt(t))u.push(e.createTextNode(t));else{for(n=n||s.appendChild(e.createElement("div")),r=(Rr.exec(t)||["",""])[1].toLowerCase(),i=_r[r]||_r._default,n.innerHTML=i[1]+t.replace(Pr,"<$1></$2>")+i[2],a=i[0];a--;)n=n.lastChild;u=q(u,n.childNodes),n=s.firstChild,n.textContent=""}return s.textContent="",s.innerHTML="",o(u,function(t){s.appendChild(t)}),s}function yt(t,n){n=n||e;var r;return(r=Dr.exec(t))?[n.createElement(r[1])]:(r=gt(t,n))?r.childNodes:[]}function wt(t){if(t instanceof wt)return t;var e;if(w(t)&&(t=$r(t),e=!0),!(this instanceof wt)){if(e&&"<"!=t.charAt(0))throw Vr("nosel","Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element");return new wt(t)}e?Mt(this,yt(t)):Mt(this,t)}function bt(t){return t.cloneNode(!0)}function xt(t,e){if(e||Ct(t),t.querySelectorAll)for(var n=t.querySelectorAll("*"),r=0,i=n.length;i>r;r++)Ct(n[r])}function St(t,e,n,r){if(g(r))throw Vr("offargs","jqLite#off() does not support the ` + "`" + `selector` + "`" + ` argument");var i=At(t),a=i&&i.events,s=i&&i.handle;if(s)if(e)o(e.split(" "),function(e){if(g(n)){var r=a[e];if(R(r||[],n),r&&r.length>0)return}Or(t,e,s),delete a[e]});else for(e in a)"$destroy"!==e&&Or(t,e,s),delete a[e]}function Ct(t,e){var r=t.ng339,i=r&&Ar[r];if(i){if(e)return void delete i.data[e];i.handle&&(i.events.$destroy&&i.handle({},"$destroy"),St(t)),delete Ar[r],t.ng339=n}}function At(t,e){var r=t.ng339,i=r&&Ar[r];return e&&!i&&(t.ng339=r=pt(),i=Ar[r]={events:{},data:{},handle:n}),i}function Et(t,e,n){if(mt(t)){var r=g(n),i=!r&&e&&!y(e),o=!e,a=At(t,!i),s=a&&a.data;if(r)s[e]=n;else{if(o)return s;if(i)return s&&s[e];f(s,e)}}}function kt(t,e){return t.getAttribute?(" "+(t.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ").indexOf(" "+e+" ")>-1:!1}function Ot(t,e){e&&t.setAttribute&&o(e.split(" "),function(e){t.setAttribute("class",$r((" "+(t.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ").replace(" "+$r(e)+" "," ")))})}function Tt(t,e){if(e&&t.setAttribute){var n=(" "+(t.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ");o(e.split(" "),function(t){t=$r(t),-1===n.indexOf(" "+t+" ")&&(n+=t+" ")}),t.setAttribute("class",$r(n))}}function Mt(t,e){if(e)if(e.nodeType)t[t.length++]=e;else{var n=e.length;if("number"==typeof n&&e.window!==e){if(n)for(var r=0;n>r;r++)t[t.length++]=e[r]}else t[t.length++]=e}}function Nt(t,e){return Vt(t,"$"+(e||"ngController")+"Controller")}function Vt(t,e,r){t.nodeType==xr&&(t=t.documentElement);for(var i=hr(e)?e:[e];t;){for(var o=0,a=i.length;a>o;o++)if((r=er.data(t,i[o]))!==n)return r;t=t.parentNode||t.nodeType===Sr&&t.host}}function Dt(t){for(xt(t,!0);t.firstChild;)t.removeChild(t.firstChild)}function jt(t,e){e||xt(t);var n=t.parentNode;n&&n.removeChild(t)}function Rt(e,n){n=n||t,"complete"===n.document.readyState?n.setTimeout(e):er(n).on("load",e)}function Pt(t,e){var n=qr[e.toLowerCase()];return n&&Ur[j(t)]&&n}function _t(t,e){var n=t.nodeName;return("INPUT"===n||"TEXTAREA"===n)&&Fr[e]}function It(t,e){var n=function(n,r){n.isDefaultPrevented=function(){return n.defaultPrevented};var i=e[r||n.type],o=i?i.length:0;if(o){if(m(n.immediatePropagationStopped)){var a=n.stopImmediatePropagation;n.stopImmediatePropagation=function(){n.immediatePropagationStopped=!0,n.stopPropagation&&n.stopPropagation(),a&&a.call(n)}}n.isImmediatePropagationStopped=function(){return n.immediatePropagationStopped===!0},o>1&&(i=_(i));for(var s=0;o>s;s++)n.isImmediatePropagationStopped()||i[s].call(t,n)}};return n.elem=t,n}function qt(){this.$get=function(){return f(wt,{hasClass:function(t,e){return t.attr&&(t=t[0]),kt(t,e)},addClass:function(t,e){return t.attr&&(t=t[0]),Tt(t,e)},removeClass:function(t,e){return t.attr&&(t=t[0]),Ot(t,e)}})}}function Ut(t,e){var n=t&&t.$$hashKey;if(n)return"function"==typeof n&&(n=t.$$hashKey()),n;var r=typeof t;return n="function"==r||"object"==r&&null!==t?t.$$hashKey=r+":"+(e||c)():r+":"+t}function Ft(t,e){if(e){var n=0;this.nextUid=function(){return++n}}o(t,this.put,this)}function Ht(t){var e=t.toString().replace(zr,""),n=e.match(Hr);return n?"function("+(n[1]||"").replace(/[\s\r\n]+/," ")+")":"fn"}function Lt(t,e,n){var r,i,a,s;if("function"==typeof t){if(!(r=t.$inject)){if(r=[],t.length){if(e)throw w(n)&&n||(n=t.name||Ht(t)),Gr("strictdi","{0} is not using explicit annotation and cannot be invoked in strict mode",n);i=t.toString().replace(zr,""),a=i.match(Hr),o(a[1].split(Lr),function(t){t.replace(Br,function(t,e,n){r.push(n)})})}t.$inject=r}}else hr(t)?(s=t.length-1,ot(t[s],"fn"),r=t.slice(0,s)):ot(t,"fn",!0);return r}function Bt(t,e){function r(t){return function(e,n){return y(e)?void o(e,u(t)):t(e,n)}}function i(t,e){if(at(t,"service"),(S(e)||hr(e))&&(e=E.instantiate(e)),!e.$get)throw Gr("pget","Provider '{0}' must define $get factory method.",t);return A[t+b]=e}function a(t,e){return function(){var n=O.invoke(e,this);if(m(n))throw Gr("undef","Provider '{0}' must return a value from $get factory method.",t);return n}}function s(t,e,n){return i(t,{$get:n!==!1?a(t,e):e})}function c(t,e){return s(t,["$injector",function(t){return t.instantiate(e)}])}function l(t,e){return s(t,v(e),!1)}function f(t,e){at(t,"constant"),A[t]=e,k[t]=e}function h(t,e){var n=E.get(t+b),r=n.$get;n.$get=function(){var t=O.invoke(r,n);return O.invoke(e,null,{$delegate:t})}}function $(t){var e,n=[];return o(t,function(t){function r(t){var e,n;for(e=0,n=t.length;n>e;e++){var r=t[e],i=E.get(r[0]);i[r[1]].apply(i,r[2])}}if(!C.get(t)){C.put(t,!0);try{w(t)?(e=rr(t),n=n.concat($(e.requires)).concat(e._runBlocks),r(e._invokeQueue),r(e._configBlocks)):S(t)?n.push(E.invoke(t)):hr(t)?n.push(E.invoke(t)):ot(t,"module")}catch(i){throw hr(t)&&(t=t[t.length-1]),i.message&&i.stack&&-1==i.stack.indexOf(i.message)&&(i=i.message+"\n"+i.stack),Gr("modulerr","Failed to instantiate module {0} due to:\n{1}",t,i.stack||i.message||i)}}}),n}function d(t,n){function r(e,r){if(t.hasOwnProperty(e)){if(t[e]===g)throw Gr("cdep","Circular dependency found: {0}",e+" <- "+x.join(" <- "));return t[e]}try{return x.unshift(e),t[e]=g,t[e]=n(e,r)}catch(i){throw t[e]===g&&delete t[e],i}finally{x.shift()}}function i(t,n,i,o){"string"==typeof i&&(o=i,i=null);var a,s,u,c=[],l=Bt.$$annotate(t,e,o);for(s=0,a=l.length;a>s;s++){if(u=l[s],"string"!=typeof u)throw Gr("itkn","Incorrect injection token! Expected service name as string, got {0}",u);c.push(i&&i.hasOwnProperty(u)?i[u]:r(u,o))}return hr(t)&&(t=t[a]),t.apply(n,c)}function o(t,e,n){var r=Object.create((hr(t)?t[t.length-1]:t).prototype||null),o=i(t,r,e,n);return y(o)||S(o)?o:r}return{invoke:i,instantiate:o,get:r,annotate:Bt.$$annotate,has:function(e){return A.hasOwnProperty(e+b)||t.hasOwnProperty(e)}}}e=e===!0;var g={},b="Provider",x=[],C=new Ft([],!0),A={$provide:{provider:r(i),factory:r(s),service:r(c),value:r(l),constant:r(f),decorator:h}},E=A.$injector=d(A,function(t,e){throw cr.isString(e)&&x.push(e),Gr("unpr","Unknown provider: {0}",x.join(" <- "))}),k={},O=k.$injector=d(k,function(t,e){var r=E.get(t+b,e);return O.invoke(r.$get,r,n,t)});return o($(t),function(t){O.invoke(t||p)}),O}function zt(){var t=!0;this.disableAutoScrolling=function(){t=!1},this.$get=["$window","$location","$rootScope",function(e,n,r){function i(t){var e=null;return Array.prototype.some.call(t,function(t){return"a"===j(t)?(e=t,!0):void 0}),e}function o(){var t=s.yOffset;if(S(t))t=t();else if(V(t)){var n=t[0],r=e.getComputedStyle(n);t="fixed"!==r.position?0:n.getBoundingClientRect().bottom}else b(t)||(t=0);return t}function a(t){if(t){t.scrollIntoView();var n=o();if(n){var r=t.getBoundingClientRect().top;e.scrollBy(0,r-n)}}else e.scrollTo(0,0)}function s(){var t,e=n.hash();e?(t=u.getElementById(e))?a(t):(t=i(u.getElementsByName(e)))?a(t):"top"===e&&a(null):a(null)}var u=e.document;return t&&r.$watch(function(){return n.hash()},function(t,e){(t!==e||""!==t)&&Rt(function(){r.$evalAsync(s)})}),s}]}function Gt(){this.$get=["$$rAF","$timeout",function(t,e){return t.supported?function(e){return t(e)}:function(t){return e(t,0,!1)}}]}function Wt(t,e,r,i){function a(t){try{t.apply(null,U(arguments,1))}finally{if(C--,0===C)for(;A.length;)try{A.pop()()}catch(e){r.error(e)}}}function s(t){var e=t.indexOf("#");return-1===e?"":t.substr(e+1)}function u(t,e){!function n(){o(k,function(t){t()}),E=e(n,t)}()}function c(){f(),h()}function l(){try{return y.state}catch(t){}}function f(){O=l(),O=m(O)?null:O,I(O,R)&&(O=R),R=O}function h(){(M!==d.url()||T!==O)&&(M=d.url(),T=O,o(D,function(t){t(d.url(),O)}))}function $(t){try{return decodeURIComponent(t)}catch(e){return t}}var d=this,v=e[0],g=t.location,y=t.history,b=t.setTimeout,x=t.clearTimeout,S={};d.isMock=!1;var C=0,A=[];d.$$completeOutstandingRequest=a,d.$$incOutstandingRequestCount=function(){C++},d.notifyWhenNoOutstandingRequests=function(t){o(k,function(t){t()}),0===C?t():A.push(t)};var E,k=[];d.addPollFn=function(t){return m(E)&&u(100,b),k.push(t),t};var O,T,M=g.href,N=e.find("base"),V=null;f(),T=O,d.url=function(e,n,r){if(m(r)&&(r=null),g!==t.location&&(g=t.location),y!==t.history&&(y=t.history),e){var o=T===r;if(M===e&&(!i.history||o))return d;var a=M&&be(M)===be(e);return M=e,T=r,!i.history||a&&o?(a||(V=e),n?g.replace(e):a?g.hash=s(e):g.href=e):(y[n?"replaceState":"pushState"](r,"",e),f(),T=O),d}return V||g.href.replace(/%27/g,"'")},d.state=function(){return O};var D=[],j=!1,R=null;d.onUrlChange=function(e){return j||(i.history&&er(t).on("popstate",c),er(t).on("hashchange",c),j=!0),D.push(e),e},d.$$checkUrlChange=h,d.baseHref=function(){var t=N.attr("href");return t?t.replace(/^(https?\:)?\/\/[^\/]*/,""):""};var P={},_="",q=d.baseHref();d.cookies=function(t,e){var i,o,a,s,u;if(!t){if(v.cookie!==_)for(_=v.cookie,o=_.split("; "),P={},s=0;s<o.length;s++)a=o[s],u=a.indexOf("="),u>0&&(t=$(a.substring(0,u)),P[t]===n&&(P[t]=$(a.substring(u+1))));return P}e===n?v.cookie=encodeURIComponent(t)+"=;path="+q+";expires=Thu, 01 Jan 1970 00:00:00 GMT":w(e)&&(i=(v.cookie=encodeURIComponent(t)+"="+encodeURIComponent(e)+";path="+q).length+1,i>4096&&r.warn("Cookie '"+t+"' possibly not set or overflowed because it was too large ("+i+" > 4096 bytes)!"))},d.defer=function(t,e){var n;return C++,n=b(function(){delete S[n],a(t)},e||0),S[n]=!0,n},d.defer.cancel=function(t){return S[t]?(delete S[t],x(t),a(p),!0):!1}}function Yt(){this.$get=["$window","$log","$sniffer","$document",function(t,e,n,r){return new Wt(t,r,e,n)}]}function Jt(){this.$get=function(){function t(t,n){function i(t){t!=h&&($?$==t&&($=t.n):$=t,o(t.n,t.p),o(t,h),h=t,h.n=null)}function o(t,e){t!=e&&(t&&(t.p=e),e&&(e.n=t))}if(t in e)throw r("$cacheFactory")("iid","CacheId '{0}' is already taken!",t);var a=0,s=f({},n,{id:t}),u={},c=n&&n.capacity||Number.MAX_VALUE,l={},h=null,$=null;return e[t]={put:function(t,e){if(c<Number.MAX_VALUE){var n=l[t]||(l[t]={key:t});i(n)}if(!m(e))return t in u||a++,u[t]=e,a>c&&this.remove($.key),e},get:function(t){if(c<Number.MAX_VALUE){var e=l[t];if(!e)return;i(e)}return u[t]},remove:function(t){if(c<Number.MAX_VALUE){var e=l[t];if(!e)return;e==h&&(h=e.p),e==$&&($=e.n),o(e.n,e.p),delete l[t]}delete u[t],a--},removeAll:function(){u={},a=0,l={},h=$=null},destroy:function(){u=null,s=null,l=null,delete e[t]},info:function(){return f({},s,{size:a})}}}var e={};return t.info=function(){var t={};return o(e,function(e,n){t[n]=e.info()}),t},t.get=function(t){return e[t]},t}}function Zt(){this.$get=["$cacheFactory",function(t){return t("templates")}]}function Kt(t,r){function i(t,e){var n=/^\s*([@&]|=(\*?))(\??)\s*(\w*)\s*$/,r={};return o(t,function(t,i){var o=t.match(n);if(!o)throw Jr("iscp","Invalid isolate scope definition for directive '{0}'. Definition: {... {1}: '{2}' ...}",e,i,t);r[i]={mode:o[1][0],collection:"*"===o[2],optional:"?"===o[3],attrName:o[4]||i}}),r}var a={},s="Directive",c=/^\s*directive\:\s*([\w\-]+)\s+(.*)$/,l=/(([\w\-]+)(?:\:([^;]+))?;?)/,h=D("ngSrc,ngSrcset,src,srcset"),m=/^(?:(\^\^?)?(\?)?(\^\^?)?)?/,b=/^(on[a-z]+|formaction)$/;this.directive=function C(e,n){return at(e,"directive"),w(e)?(it(n,"directiveFactory"),a.hasOwnProperty(e)||(a[e]=[],t.factory(e+s,["$injector","$exceptionHandler",function(t,n){var r=[];return o(a[e],function(o,a){try{var s=t.invoke(o);S(s)?s={compile:v(s)}:!s.compile&&s.link&&(s.compile=v(s.link)),s.priority=s.priority||0,s.index=a,s.name=s.name||e,s.require=s.require||s.controller&&s.name,s.restrict=s.restrict||"EA",y(s.scope)&&(s.$$isolateBindings=i(s.scope,s.name)),r.push(s)}catch(u){n(u)}}),r}])),a[e].push(n)):o(e,u(C)),this},this.aHrefSanitizationWhitelist=function(t){return g(t)?(r.aHrefSanitizationWhitelist(t),this):r.aHrefSanitizationWhitelist()},this.imgSrcSanitizationWhitelist=function(t){return g(t)?(r.imgSrcSanitizationWhitelist(t),this):r.imgSrcSanitizationWhitelist()};var x=!0;this.debugInfoEnabled=function(t){return g(t)?(x=t,this):x},this.$get=["$injector","$interpolate","$exceptionHandler","$templateRequest","$parse","$controller","$rootScope","$document","$sce","$animate","$$sanitizeUri",function(t,r,i,u,v,g,C,A,k,O,T){function M(t,e){try{t.addClass(e)}catch(n){}}function N(t,e,n,r,i){t instanceof er||(t=er(t)),o(t,function(e,n){e.nodeType==wr&&e.nodeValue.match(/\S+/)&&(t[n]=er(e).wrap("<span></span>").parent()[0])});var a=D(t,e,t,n,r,i);N.$$addScopeClass(t);var s=null;return function(e,n,r){it(e,"scope"),r=r||{};var i=r.parentBoundTranscludeFn,o=r.transcludeControllers,u=r.futureParentElement;i&&i.$$boundTransclude&&(i=i.$$boundTransclude),s||(s=V(u));var c;if(c="html"!==s?er(X(s,er("<div>").append(t).html())):n?Ir.clone.call(t):t,o)for(var l in o)c.data("$"+l+"Controller",o[l].instance);return N.$$addScopeInfo(c,e),n&&n(c,e),a&&a(e,c,c,i),c}}function V(t){var e=t&&t[0];return e&&"foreignobject"!==j(e)&&e.toString().match(/SVG/)?"svg":"html"}function D(t,e,r,i,o,a){function s(t,r,i,o){var a,s,u,c,l,f,h,$,v;if(p){var m=r.length;for(v=new Array(m),l=0;l<d.length;l+=3)h=d[l],v[h]=r[h]}else v=r;for(l=0,f=d.length;f>l;)u=v[d[l++]],a=d[l++],s=d[l++],a?(a.scope?(c=t.$new(),N.$$addScopeInfo(er(u),c)):c=t,$=a.transcludeOnThisElement?P(t,a.transclude,o,a.elementTranscludeOnThisElement):!a.templateOnThisElement&&o?o:!o&&e?P(t,e):null,a(s,c,u,i,$)):s&&s(t,u.childNodes,n,o)}for(var u,c,l,f,h,$,p,d=[],v=0;v<t.length;v++)u=new at,c=_(t[v],[],u,0===v?i:n,o),l=c.length?H(c,t[v],u,e,r,null,[],[],a):null,l&&l.scope&&N.$$addScopeClass(u.$$element),h=l&&l.terminal||!(f=t[v].childNodes)||!f.length?null:D(f,l?(l.transcludeOnThisElement||!l.templateOnThisElement)&&l.transclude:e),(l||h)&&(d.push(v,l,h),$=!0,p=p||l),a=null;return $?s:null}function P(t,e,n,r){var i=function(r,i,o,a,s){return r||(r=t.$new(!1,s),r.$$transcluded=!0),e(r,i,{parentBoundTranscludeFn:n,transcludeControllers:o,futureParentElement:a})};return i}function _(t,e,n,r,i){var o,a,s=t.nodeType,u=n.$attr;switch(s){case yr:B(e,Xt(j(t)),"E",r,i);for(var f,h,$,p,d,v,m=t.attributes,g=0,b=m&&m.length;b>g;g++){var x=!1,S=!1;f=m[g],h=f.name,d=$r(f.value),p=Xt(h),(v=ft.test(p))&&(h=h.replace(Zr,"").substr(8).replace(/_(.)/g,function(t,e){return e.toUpperCase()}));var C=p.replace(/(Start|End)$/,"");G(C)&&p===C+"Start"&&(x=h,S=h.substr(0,h.length-5)+"end",h=h.substr(0,h.length-6)),$=Xt(h.toLowerCase()),u[$]=h,(v||!n.hasOwnProperty($))&&(n[$]=d,Pt(t,$)&&(n[$]=!0)),tt(t,e,d,$,v),B(e,$,"A",r,i,x,S)}if(a=t.className,y(a)&&(a=a.animVal),w(a)&&""!==a)for(;o=l.exec(a);)$=Xt(o[2]),B(e,$,"C",r,i)&&(n[$]=$r(o[3])),a=a.substr(o.index+o[0].length);break;case wr:K(e,t.nodeValue);break;case br:try{o=c.exec(t.nodeValue),o&&($=Xt(o[1]),B(e,$,"M",r,i)&&(n[$]=$r(o[2])))}catch(A){}}return e.sort(J),e}function q(t,e,n){var r=[],i=0;if(e&&t.hasAttribute&&t.hasAttribute(e)){do{if(!t)throw Jr("uterdir","Unterminated attribute, found '{0}' but no matching '{1}' found.",e,n);t.nodeType==yr&&(t.hasAttribute(e)&&i++,t.hasAttribute(n)&&i--),r.push(t),t=t.nextSibling}while(i>0)}else r.push(t);return er(r)}function F(t,e,n){return function(r,i,o,a,s){return i=q(i[0],e,n),t(r,i,o,a,s)}}function H(t,a,s,u,c,l,f,h,$){function p(t,e,n,r){t&&(n&&(t=F(t,n,r)),t.require=A.require,t.directiveName=k,(j===A||A.$$isolateScope)&&(t=rt(t,{isolateScope:!0})),f.push(t)),e&&(n&&(e=F(e,n,r)),e.require=A.require,e.directiveName=k,(j===A||A.$$isolateScope)&&(e=rt(e,{isolateScope:!0})),h.push(e))}function d(t,e,n,r){var i,a,s="data",u=!1,c=n;if(w(e)){if(a=e.match(m),e=e.substring(a[0].length),a[3]&&(a[1]?a[3]=null:a[1]=a[3]),"^"===a[1]?s="inheritedData":"^^"===a[1]&&(s="inheritedData",c=n.parent()),"?"===a[2]&&(u=!0),i=null,r&&"data"===s&&(i=r[e])&&(i=i.instance),i=i||c[s]("$"+e+"Controller"),!i&&!u)throw Jr("ctreq","Controller '{0}', required by directive '{1}', can't be found!",e,t);return i||null}return hr(e)&&(i=[],o(e,function(e){i.push(d(t,e,n,r))})),i}function b(t,e,i,u,c){function l(t,e,r){var i;return E(t)||(r=e,e=t,t=n),G&&(i=b),r||(r=G?S.parent():S),c(t,e,i,r,T)}var $,p,m,y,w,b,x,S,A;if(a===i?(A=s,S=s.$$element):(S=er(i),A=new at(S,s)),j&&(w=e.$new(!0)),c&&(x=l,x.$$boundTransclude=c),D&&(C={},b={},o(D,function(t){var n,r={$scope:t===j||t.$$isolateScope?w:e,$element:S,$attrs:A,$transclude:x};y=t.controller,"@"==y&&(y=A[t.name]),n=g(y,r,!0,t.controllerAs),b[t.name]=n,G||S.data("$"+t.name+"Controller",n.instance),C[t.name]=n})),j){N.$$addScopeInfo(S,w,!0,!(R&&(R===j||R===j.$$originalDirective))),N.$$addScopeClass(S,!0);var k=C&&C[j.name],O=w;k&&k.identifier&&j.bindToController===!0&&(O=k.instance),o(w.$$isolateBindings=j.$$isolateBindings,function(t,n){var i,o,a,s,u=t.attrName,c=t.optional,l=t.mode;switch(l){case"@":A.$observe(u,function(t){O[n]=t}),A.$$observers[u].$$scope=e,A[u]&&(O[n]=r(A[u])(e));break;case"=":if(c&&!A[u])return;o=v(A[u]),s=o.literal?I:function(t,e){return t===e||t!==t&&e!==e},a=o.assign||function(){throw i=O[n]=o(e),Jr("nonassign","Expression '{0}' used with directive '{1}' is non-assignable!",A[u],j.name)},i=O[n]=o(e);var f=function(t){return s(t,O[n])||(s(t,i)?a(e,t=O[n]):O[n]=t),i=t};f.$stateful=!0;var h;h=t.collection?e.$watchCollection(A[u],f):e.$watch(v(A[u],f),null,o.literal),w.$on("$destroy",h);break;case"&":o=v(A[u]),O[n]=function(t){return o(e,t)}}})}for(C&&(o(C,function(t){t()}),C=null),$=0,p=f.length;p>$;$++)m=f[$],ot(m,m.isolateScope?w:e,S,A,m.require&&d(m.directiveName,m.require,S,b),x);var T=e;for(j&&(j.template||null===j.templateUrl)&&(T=w),t&&t(T,i.childNodes,n,c),$=h.length-1;$>=0;$--)m=h[$],ot(m,m.isolateScope?w:e,S,A,m.require&&d(m.directiveName,m.require,S,b),x)}$=$||{};for(var x,C,A,k,O,T,M,V=-Number.MAX_VALUE,D=$.controllerDirectives,j=$.newIsolateScopeDirective,R=$.templateDirective,P=$.nonTlbTranscludeDirective,H=!1,B=!1,G=$.hasElementTranscludeDirective,J=s.$$element=er(a),K=l,Q=u,tt=0,nt=t.length;nt>tt;tt++){A=t[tt];var it=A.$$start,st=A.$$end;if(it&&(J=q(a,it,st)),O=n,V>A.priority)break;if((M=A.scope)&&(A.templateUrl||(y(M)?(Z("new/isolated scope",j||x,A,J),j=A):Z("new/isolated scope",j,A,J)),x=x||A),k=A.name,!A.templateUrl&&A.controller&&(M=A.controller,D=D||{},Z("'"+k+"' controller",D[k],A,J),D[k]=A),(M=A.transclude)&&(H=!0,A.$$tlb||(Z("transclusion",P,A,J),P=A),"element"==M?(G=!0,V=A.priority,O=J,J=s.$$element=er(e.createComment(" "+k+": "+s[k]+" ")),a=J[0],et(c,U(O),a),Q=N(O,u,V,K&&K.name,{nonTlbTranscludeDirective:P})):(O=er(bt(a)).contents(),J.empty(),Q=N(O,u))),A.template)if(B=!0,Z("template",R,A,J),R=A,M=S(A.template)?A.template(J,s):A.template,M=lt(M),A.replace){if(K=A,O=vt(M)?[]:te(X(A.templateNamespace,$r(M))),a=O[0],1!=O.length||a.nodeType!==yr)throw Jr("tplrt","Template for directive '{0}' must have exactly one root element. {1}",k,"");et(c,J,a);var ut={$attr:{}},ct=_(a,[],ut),ft=t.splice(tt+1,t.length-(tt+1));j&&L(ct),t=t.concat(ct).concat(ft),W(s,ut),nt=t.length}else J.html(M);if(A.templateUrl)B=!0,Z("template",R,A,J),R=A,A.replace&&(K=A),b=Y(t.splice(tt,t.length-tt),J,s,c,H&&Q,f,h,{controllerDirectives:D,newIsolateScopeDirective:j,templateDirective:R,nonTlbTranscludeDirective:P}),nt=t.length;else if(A.compile)try{T=A.compile(J,s,Q),S(T)?p(null,T,it,st):T&&p(T.pre,T.post,it,st)}catch(ht){i(ht,z(J))}A.terminal&&(b.terminal=!0,V=Math.max(V,A.priority))}return b.scope=x&&x.scope===!0,b.transcludeOnThisElement=H,b.elementTranscludeOnThisElement=G,b.templateOnThisElement=B,b.transclude=Q,$.hasElementTranscludeDirective=G,b}function L(t){for(var e=0,n=t.length;n>e;e++)t[e]=$(t[e],{$$isolateScope:!0})}function B(e,r,o,u,c,l,f){if(r===c)return null;var h=null;if(a.hasOwnProperty(r))for(var p,d=t.get(r+s),v=0,m=d.length;m>v;v++)try{p=d[v],(u===n||u>p.priority)&&-1!=p.restrict.indexOf(o)&&(l&&(p=$(p,{
$$start:l,$$end:f})),e.push(p),h=p)}catch(g){i(g)}return h}function G(e){if(a.hasOwnProperty(e))for(var n,r=t.get(e+s),i=0,o=r.length;o>i;i++)if(n=r[i],n.multiElement)return!0;return!1}function W(t,e){var n=e.$attr,r=t.$attr,i=t.$$element;o(t,function(r,i){"$"!=i.charAt(0)&&(e[i]&&e[i]!==r&&(r+=("style"===i?";":" ")+e[i]),t.$set(i,r,!0,n[i]))}),o(e,function(e,o){"class"==o?(M(i,e),t["class"]=(t["class"]?t["class"]+" ":"")+e):"style"==o?(i.attr("style",i.attr("style")+";"+e),t.style=(t.style?t.style+";":"")+e):"$"==o.charAt(0)||t.hasOwnProperty(o)||(t[o]=e,r[o]=n[o])})}function Y(t,e,n,r,i,a,s,c){var l,f,h=[],p=e[0],d=t.shift(),v=$(d,{templateUrl:null,transclude:null,replace:null,$$originalDirective:d}),m=S(d.templateUrl)?d.templateUrl(e,n):d.templateUrl,g=d.templateNamespace;return e.empty(),u(k.getTrustedResourceUrl(m)).then(function(u){var $,w,b,x;if(u=lt(u),d.replace){if(b=vt(u)?[]:te(X(g,$r(u))),$=b[0],1!=b.length||$.nodeType!==yr)throw Jr("tplrt","Template for directive '{0}' must have exactly one root element. {1}",d.name,m);w={$attr:{}},et(r,e,$);var S=_($,[],w);y(d.scope)&&L(S),t=S.concat(t),W(n,w)}else $=p,e.html(u);for(t.unshift(v),l=H(t,$,n,i,e,d,a,s,c),o(r,function(t,n){t==$&&(r[n]=e[0])}),f=D(e[0].childNodes,i);h.length;){var C=h.shift(),A=h.shift(),E=h.shift(),k=h.shift(),O=e[0];if(!C.$$destroyed){if(A!==p){var T=A.className;c.hasElementTranscludeDirective&&d.replace||(O=bt($)),et(E,er(A),O),M(er(O),T)}x=l.transcludeOnThisElement?P(C,l.transclude,k):k,l(f,C,O,r,x)}}h=null}),function(t,e,n,r,i){var o=i;e.$$destroyed||(h?h.push(e,n,r,o):(l.transcludeOnThisElement&&(o=P(e,l.transclude,i)),l(f,e,n,r,o)))}}function J(t,e){var n=e.priority-t.priority;return 0!==n?n:t.name!==e.name?t.name<e.name?-1:1:t.index-e.index}function Z(t,e,n,r){if(e)throw Jr("multidir","Multiple directives [{0}, {1}] asking for {2} on: {3}",e.name,n.name,t,z(r))}function K(t,e){var n=r(e,!0);n&&t.push({priority:0,compile:function(t){var e=t.parent(),r=!!e.length;return r&&N.$$addBindingClass(e),function(t,e){var i=e.parent();r||N.$$addBindingClass(i),N.$$addBindingInfo(i,n.expressions),t.$watch(n,function(t){e[0].nodeValue=t})}}})}function X(t,n){switch(t=Jn(t||"html")){case"svg":case"math":var r=e.createElement("div");return r.innerHTML="<"+t+">"+n+"</"+t+">",r.childNodes[0].childNodes;default:return n}}function Q(t,e){if("srcdoc"==e)return k.HTML;var n=j(t);return"xlinkHref"==e||"form"==n&&"action"==e||"img"!=n&&("src"==e||"ngSrc"==e)?k.RESOURCE_URL:void 0}function tt(t,e,n,i,o){var a=Q(t,i);o=h[i]||o;var s=r(n,!0,a,o);if(s){if("multiple"===i&&"select"===j(t))throw Jr("selmulti","Binding to the 'multiple' attribute is not supported. Element: {0}",z(t));e.push({priority:100,compile:function(){return{pre:function(t,e,u){var c=u.$$observers||(u.$$observers={});if(b.test(i))throw Jr("nodomevents","Interpolations for HTML DOM event attributes are disallowed.  Please use the ng- versions (such as ng-click instead of onclick) instead.");var l=u[i];l!==n&&(s=l&&r(l,!0,a,o),n=l),s&&(u[i]=s(t),(c[i]||(c[i]=[])).$$inter=!0,(u.$$observers&&u.$$observers[i].$$scope||t).$watch(s,function(t,e){"class"===i&&t!=e?u.$updateClass(t,e):u.$set(i,t)}))}}}})}}function et(t,n,r){var i,o,a=n[0],s=n.length,u=a.parentNode;if(t)for(i=0,o=t.length;o>i;i++)if(t[i]==a){t[i++]=r;for(var c=i,l=c+s-1,f=t.length;f>c;c++,l++)f>l?t[c]=t[l]:delete t[c];t.length-=s-1,t.context===a&&(t.context=r);break}u&&u.replaceChild(r,a);var h=e.createDocumentFragment();h.appendChild(a),er(r).data(er(a).data()),nr?(fr=!0,nr.cleanData([a])):delete er.cache[a[er.expando]];for(var $=1,p=n.length;p>$;$++){var d=n[$];er(d).remove(),h.appendChild(d),delete n[$]}n[0]=r,n.length=1}function rt(t,e){return f(function(){return t.apply(null,arguments)},t,e)}function ot(t,e,n,r,o,a){try{t(e,n,r,o,a)}catch(s){i(s,z(n))}}var at=function(t,e){if(e){var n,r,i,o=Object.keys(e);for(n=0,r=o.length;r>n;n++)i=o[n],this[i]=e[i]}else this.$attr={};this.$$element=t};at.prototype={$normalize:Xt,$addClass:function(t){t&&t.length>0&&O.addClass(this.$$element,t)},$removeClass:function(t){t&&t.length>0&&O.removeClass(this.$$element,t)},$updateClass:function(t,e){var n=Qt(t,e);n&&n.length&&O.addClass(this.$$element,n);var r=Qt(e,t);r&&r.length&&O.removeClass(this.$$element,r)},$set:function(t,e,r,a){var s,u=this.$$element[0],c=Pt(u,t),l=_t(u,t),f=t;if(c?(this.$$element.prop(t,e),a=c):l&&(this[l]=e,f=l),this[t]=e,a?this.$attr[t]=a:(a=this.$attr[t],a||(this.$attr[t]=a=nt(t,"-"))),s=j(this.$$element),"a"===s&&"href"===t||"img"===s&&"src"===t)this[t]=e=T(e,"src"===t);else if("img"===s&&"srcset"===t){for(var h="",$=$r(e),p=/(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/,d=/\s/.test($)?p:/(,)/,v=$.split(d),m=Math.floor(v.length/2),g=0;m>g;g++){var y=2*g;h+=T($r(v[y]),!0),h+=" "+$r(v[y+1])}var w=$r(v[2*g]).split(/\s/);h+=T($r(w[0]),!0),2===w.length&&(h+=" "+$r(w[1])),this[t]=e=h}r!==!1&&(null===e||e===n?this.$$element.removeAttr(a):this.$$element.attr(a,e));var b=this.$$observers;b&&o(b[f],function(t){try{t(e)}catch(n){i(n)}})},$observe:function(t,e){var n=this,r=n.$$observers||(n.$$observers=ct()),i=r[t]||(r[t]=[]);return i.push(e),C.$evalAsync(function(){!i.$$inter&&n.hasOwnProperty(t)&&e(n[t])}),function(){R(i,e)}}};var st=r.startSymbol(),ut=r.endSymbol(),lt="{{"==st||"}}"==ut?d:function(t){return t.replace(/\{\{/g,st).replace(/}}/g,ut)},ft=/^ngAttr[A-Z]/;return N.$$addBindingInfo=x?function(t,e){var n=t.data("$binding")||[];hr(e)?n=n.concat(e):n.push(e),t.data("$binding",n)}:p,N.$$addBindingClass=x?function(t){M(t,"ng-binding")}:p,N.$$addScopeInfo=x?function(t,e,n,r){var i=n?r?"$isolateScopeNoTemplate":"$isolateScope":"$scope";t.data(i,e)}:p,N.$$addScopeClass=x?function(t,e){M(t,e?"ng-isolate-scope":"ng-scope")}:p,N}]}function Xt(t){return dt(t.replace(Zr,""))}function Qt(t,e){var n="",r=t.split(/\s+/),i=e.split(/\s+/);t:for(var o=0;o<r.length;o++){for(var a=r[o],s=0;s<i.length;s++)if(a==i[s])continue t;n+=(n.length>0?" ":"")+a}return n}function te(t){t=er(t);var e=t.length;if(1>=e)return t;for(;e--;){var n=t[e];n.nodeType===br&&or.call(t,e,1)}return t}function ee(){var t={},e=!1,i=/^(\S+)(\s+as\s+(\w+))?$/;this.register=function(e,n){at(e,"controller"),y(e)?f(t,e):t[e]=n},this.allowGlobals=function(){e=!0},this.$get=["$injector","$window",function(o,a){function s(t,e,n,i){if(!t||!y(t.$scope))throw r("$controller")("noscp","Cannot export controller '{0}' as '{1}'! No $scope object provided via ` + "`" + `locals` + "`" + `.",i,e);t.$scope[e]=n}return function(r,u,c,l){var h,$,p,d;if(c=c===!0,l&&w(l)&&(d=l),w(r)){if($=r.match(i),!$)throw Kr("ctrlfmt","Badly formed controller string '{0}'. Must match ` + "`" + `__name__ as __id__` + "`" + ` or ` + "`" + `__name__` + "`" + `.",r);p=$[1],d=d||$[3],r=t.hasOwnProperty(p)?t[p]:st(u.$scope,p,!0)||(e?st(a,p,!0):n),ot(r,p,!0)}if(c){var v=(hr(r)?r[r.length-1]:r).prototype;return h=Object.create(v||null),d&&s(u,d,h,p||r.name),f(function(){return o.invoke(r,h,u,p),h},{instance:h,identifier:d})}return h=o.instantiate(r,u,p),d&&s(u,d,h,p||r.name),h}}]}function ne(){this.$get=["$window",function(t){return er(t.document)}]}function re(){this.$get=["$log",function(t){return function(e,n){t.error.apply(t,arguments)}}]}function ie(t,e){if(w(t)){var n=t.replace(ni,"").trim();if(n){var r=e("Content-Type");(r&&0===r.indexOf(Xr)||oe(n))&&(t=B(n))}}return t}function oe(t){var e=t.match(ti);return e&&ei[e[0]].test(t)}function ae(t){var e,n,r,i=ct();return t?(o(t.split("\n"),function(t){r=t.indexOf(":"),e=Jn($r(t.substr(0,r))),n=$r(t.substr(r+1)),e&&(i[e]=i[e]?i[e]+", "+n:n)}),i):i}function se(t){var e=y(t)?t:n;return function(n){if(e||(e=ae(t)),n){var r=e[Jn(n)];return void 0===r&&(r=null),r}return e}}function ue(t,e,n,r){return S(r)?r(t,e,n):(o(r,function(r){t=r(t,e,n)}),t)}function ce(t){return t>=200&&300>t}function le(){var t=this.defaults={transformResponse:[ie],transformRequest:[function(t){return!y(t)||k(t)||T(t)||O(t)?t:L(t)}],headers:{common:{Accept:"application/json, text/plain, */*"},post:_(Qr),put:_(Qr),patch:_(Qr)},xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN"},e=!1;this.useApplyAsync=function(t){return g(t)?(e=!!t,this):e};var i=this.interceptors=[];this.$get=["$httpBackend","$browser","$cacheFactory","$rootScope","$q","$injector",function(a,u,c,l,h,$){function p(e){function i(t){var e=f({},t);return e.data=t.data?ue(t.data,t.headers,t.status,u.transformResponse):t.data,ce(t.status)?e:h.reject(e)}function a(t){var e,n={};return o(t,function(t,r){S(t)?(e=t(),null!=e&&(n[r]=e)):n[r]=t}),n}function s(e){var n,r,i,o=t.headers,s=f({},e.headers);o=f({},o.common,o[Jn(e.method)]);t:for(n in o){r=Jn(n);for(i in s)if(Jn(i)===r)continue t;s[n]=o[n]}return a(s)}if(!cr.isObject(e))throw r("$http")("badreq","Http request configuration must be an object.  Received: {0}",e);var u=f({method:"get",transformRequest:t.transformRequest,transformResponse:t.transformResponse},e);u.headers=s(e),u.method=Kn(u.method);var c=function(e){var r=e.headers,a=ue(e.data,se(r),n,e.transformRequest);return m(a)&&o(r,function(t,e){"content-type"===Jn(e)&&delete r[e]}),m(e.withCredentials)&&!m(t.withCredentials)&&(e.withCredentials=t.withCredentials),b(e,a).then(i,i)},l=[c,n],$=h.when(u);for(o(E,function(t){(t.request||t.requestError)&&l.unshift(t.request,t.requestError),(t.response||t.responseError)&&l.push(t.response,t.responseError)});l.length;){var p=l.shift(),d=l.shift();$=$.then(p,d)}return $.success=function(t){return $.then(function(e){t(e.data,e.status,e.headers,u)}),$},$.error=function(t){return $.then(null,function(e){t(e.data,e.status,e.headers,u)}),$},$}function d(t){o(arguments,function(t){p[t]=function(e,n){return p(f(n||{},{method:t,url:e}))}})}function v(t){o(arguments,function(t){p[t]=function(e,n,r){return p(f(r||{},{method:t,url:e,data:n}))}})}function b(r,i){function o(t,n,r,i){function o(){s(n,t,r,i)}$&&(ce(t)?$.put(x,[t,n,ae(r),i]):$.remove(x)),e?l.$applyAsync(o):(o(),l.$$phase||l.$apply())}function s(t,e,n,i){e=Math.max(e,0),(ce(e)?v.resolve:v.reject)({data:t,status:e,headers:se(n),config:r,statusText:i})}function c(t){s(t.data,t.status,_(t.headers()),t.statusText)}function f(){var t=p.pendingRequests.indexOf(r);-1!==t&&p.pendingRequests.splice(t,1)}var $,d,v=h.defer(),w=v.promise,b=r.headers,x=C(r.url,r.params);if(p.pendingRequests.push(r),w.then(f,f),!r.cache&&!t.cache||r.cache===!1||"GET"!==r.method&&"JSONP"!==r.method||($=y(r.cache)?r.cache:y(t.cache)?t.cache:A),$&&(d=$.get(x),g(d)?N(d)?d.then(c,c):hr(d)?s(d[1],d[0],_(d[2]),d[3]):s(d,200,{},"OK"):$.put(x,w)),m(d)){var S=on(r.url)?u.cookies()[r.xsrfCookieName||t.xsrfCookieName]:n;S&&(b[r.xsrfHeaderName||t.xsrfHeaderName]=S),a(r.method,x,i,o,b,r.timeout,r.withCredentials,r.responseType)}return w}function C(t,e){if(!e)return t;var n=[];return s(e,function(t,e){null===t||m(t)||(hr(t)||(t=[t]),o(t,function(t){y(t)&&(t=x(t)?t.toISOString():L(t)),n.push(Z(e)+"="+Z(t))}))}),n.length>0&&(t+=(-1==t.indexOf("?")?"?":"&")+n.join("&")),t}var A=c("$http"),E=[];return o(i,function(t){E.unshift(w(t)?$.get(t):$.invoke(t))}),p.pendingRequests=[],d("get","delete","head","jsonp"),v("post","put","patch"),p.defaults=t,p}]}function fe(){return new t.XMLHttpRequest}function he(){this.$get=["$browser","$window","$document",function(t,e,n){return $e(t,fe,t.defer,e.angular.callbacks,n[0])}]}function $e(t,e,r,i,a){function s(t,e,n){var r=a.createElement("script"),o=null;return r.type="text/javascript",r.src=t,r.async=!0,o=function(t){Or(r,"load",o),Or(r,"error",o),a.body.removeChild(r),r=null;var s=-1,u="unknown";t&&("load"!==t.type||i[e].called||(t={type:"error"}),u=t.type,s="error"===t.type?404:200),n&&n(s,u)},kr(r,"load",o),kr(r,"error",o),a.body.appendChild(r),o}return function(a,u,c,l,f,h,$,d){function v(){w&&w(),b&&b.abort()}function m(e,i,o,a,s){C!==n&&r.cancel(C),w=b=null,e(i,o,a,s),t.$$completeOutstandingRequest(p)}if(t.$$incOutstandingRequestCount(),u=u||t.url(),"jsonp"==Jn(a)){var y="_"+(i.counter++).toString(36);i[y]=function(t){i[y].data=t,i[y].called=!0};var w=s(u.replace("JSON_CALLBACK","angular.callbacks."+y),y,function(t,e){m(l,t,i[y].data,"",e),i[y]=p})}else{var b=e();b.open(a,u,!0),o(f,function(t,e){g(t)&&b.setRequestHeader(e,t)}),b.onload=function(){var t=b.statusText||"",e="response"in b?b.response:b.responseText,n=1223===b.status?204:b.status;0===n&&(n=e?200:"file"==rn(u).protocol?404:0),m(l,n,e,b.getAllResponseHeaders(),t)};var x=function(){m(l,-1,null,null,"")};if(b.onerror=x,b.onabort=x,$&&(b.withCredentials=!0),d)try{b.responseType=d}catch(S){if("json"!==d)throw S}b.send(c||null)}if(h>0)var C=r(v,h);else N(h)&&h.then(v)}}function pe(){var t="{{",e="}}";this.startSymbol=function(e){return e?(t=e,this):t},this.endSymbol=function(t){return t?(e=t,this):e},this.$get=["$parse","$exceptionHandler","$sce",function(n,r,i){function o(t){return"\\\\\\"+t}function a(o,a,h,$){function p(n){return n.replace(c,t).replace(l,e)}function d(t){try{return t=T(t),$&&!g(t)?t:M(t)}catch(e){var n=ri("interr","Can't interpolate: {0}\n{1}",o,e.toString());r(n)}}$=!!$;for(var v,y,w,b=0,x=[],C=[],A=o.length,E=[],k=[];A>b;){if(-1==(v=o.indexOf(t,b))||-1==(y=o.indexOf(e,v+s))){b!==A&&E.push(p(o.substring(b)));break}b!==v&&E.push(p(o.substring(b,v))),w=o.substring(v+s,y),x.push(w),C.push(n(w,d)),b=y+u,k.push(E.length),E.push("")}if(h&&E.length>1)throw ri("noconcat","Error while interpolating: {0}\nStrict Contextual Escaping disallows interpolations that concatenate multiple expressions when a trusted value is required.  See http://docs.angularjs.org/api/ng.$sce",o);if(!a||x.length){var O=function(t){for(var e=0,n=x.length;n>e;e++){if($&&m(t[e]))return;E[k[e]]=t[e]}return E.join("")},T=function(t){return h?i.getTrusted(h,t):i.valueOf(t)},M=function(t){if(null==t)return"";switch(typeof t){case"string":break;case"number":t=""+t;break;default:t=L(t)}return t};return f(function(t){var e=0,n=x.length,i=new Array(n);try{for(;n>e;e++)i[e]=C[e](t);return O(i)}catch(a){var s=ri("interr","Can't interpolate: {0}\n{1}",o,a.toString());r(s)}},{exp:o,expressions:x,$$watchDelegate:function(t,e,n){var r;return t.$watchGroup(C,function(n,i){var o=O(n);S(e)&&e.call(this,o,n!==i?r:o,t),r=o},n)}})}}var s=t.length,u=e.length,c=new RegExp(t.replace(/./g,o),"g"),l=new RegExp(e.replace(/./g,o),"g");return a.startSymbol=function(){return t},a.endSymbol=function(){return e},a}]}function de(){this.$get=["$rootScope","$window","$q","$$q",function(t,e,n,r){function i(i,a,s,u){var c=e.setInterval,l=e.clearInterval,f=0,h=g(u)&&!u,$=(h?r:n).defer(),p=$.promise;return s=g(s)?s:0,p.then(null,null,i),p.$$intervalId=c(function(){$.notify(f++),s>0&&f>=s&&($.resolve(f),l(p.$$intervalId),delete o[p.$$intervalId]),h||t.$apply()},a),o[p.$$intervalId]=$,p}var o={};return i.cancel=function(t){return t&&t.$$intervalId in o?(o[t.$$intervalId].reject("canceled"),e.clearInterval(t.$$intervalId),delete o[t.$$intervalId],!0):!1},i}]}function ve(){this.$get=function(){return{id:"en-us",NUMBER_FORMATS:{DECIMAL_SEP:".",GROUP_SEP:",",PATTERNS:[{minInt:1,minFrac:0,maxFrac:3,posPre:"",posSuf:"",negPre:"-",negSuf:"",gSize:3,lgSize:3},{minInt:1,minFrac:2,maxFrac:2,posPre:"¤",posSuf:"",negPre:"(¤",negSuf:")",gSize:3,lgSize:3}],CURRENCY_SYM:"$"},DATETIME_FORMATS:{MONTH:"January,February,March,April,May,June,July,August,September,October,November,December".split(","),SHORTMONTH:"Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),DAY:"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),SHORTDAY:"Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(","),AMPMS:["AM","PM"],medium:"MMM d, y h:mm:ss a","short":"M/d/yy h:mm a",fullDate:"EEEE, MMMM d, y",longDate:"MMMM d, y",mediumDate:"MMM d, y",shortDate:"M/d/yy",mediumTime:"h:mm:ss a",shortTime:"h:mm a",ERANAMES:["Before Christ","Anno Domini"],ERAS:["BC","AD"]},pluralCat:function(t){return 1===t?"one":"other"}}}}function me(t){for(var e=t.split("/"),n=e.length;n--;)e[n]=J(e[n]);return e.join("/")}function ge(t,e){var n=rn(t);e.$$protocol=n.protocol,e.$$host=n.hostname,e.$$port=h(n.port)||oi[n.protocol]||null}function ye(t,e){var n="/"!==t.charAt(0);n&&(t="/"+t);var r=rn(t);e.$$path=decodeURIComponent(n&&"/"===r.pathname.charAt(0)?r.pathname.substring(1):r.pathname),e.$$search=W(r.search),e.$$hash=decodeURIComponent(r.hash),e.$$path&&"/"!=e.$$path.charAt(0)&&(e.$$path="/"+e.$$path)}function we(t,e){return 0===e.indexOf(t)?e.substr(t.length):void 0}function be(t){var e=t.indexOf("#");return-1==e?t:t.substr(0,e)}function xe(t){return t.replace(/(#.+)|#$/,"$1")}function Se(t){return t.substr(0,be(t).lastIndexOf("/")+1)}function Ce(t){return t.substring(0,t.indexOf("/",t.indexOf("//")+2))}function Ae(t,e){this.$$html5=!0,e=e||"";var r=Se(t);ge(t,this),this.$$parse=function(t){var e=we(r,t);if(!w(e))throw ai("ipthprfx",'Invalid url "{0}", missing path prefix "{1}".',t,r);ye(e,this),this.$$path||(this.$$path="/"),this.$$compose()},this.$$compose=function(){var t=Y(this.$$search),e=this.$$hash?"#"+J(this.$$hash):"";this.$$url=me(this.$$path)+(t?"?"+t:"")+e,this.$$absUrl=r+this.$$url.substr(1)},this.$$parseLinkUrl=function(i,o){if(o&&"#"===o[0])return this.hash(o.slice(1)),!0;var a,s,u;return(a=we(t,i))!==n?(s=a,u=(a=we(e,a))!==n?r+(we("/",a)||a):t+s):(a=we(r,i))!==n?u=r+a:r==i+"/"&&(u=r),u&&this.$$parse(u),!!u}}function Ee(t,e){var n=Se(t);ge(t,this),this.$$parse=function(r){function i(t,e,n){var r,i=/^\/[A-Z]:(\/.*)/;return 0===e.indexOf(n)&&(e=e.replace(n,"")),i.exec(e)?t:(r=i.exec(t),r?r[1]:t)}var o,a=we(t,r)||we(n,r);"#"===a.charAt(0)?(o=we(e,a),m(o)&&(o=a)):o=this.$$html5?a:"",ye(o,this),this.$$path=i(this.$$path,o,t),this.$$compose()},this.$$compose=function(){var n=Y(this.$$search),r=this.$$hash?"#"+J(this.$$hash):"";this.$$url=me(this.$$path)+(n?"?"+n:"")+r,this.$$absUrl=t+(this.$$url?e+this.$$url:"")},this.$$parseLinkUrl=function(e,n){return be(t)==be(e)?(this.$$parse(e),!0):!1}}function ke(t,e){this.$$html5=!0,Ee.apply(this,arguments);var n=Se(t);this.$$parseLinkUrl=function(r,i){if(i&&"#"===i[0])return this.hash(i.slice(1)),!0;var o,a;return t==be(r)?o=r:(a=we(n,r))?o=t+e+a:n===r+"/"&&(o=n),o&&this.$$parse(o),!!o},this.$$compose=function(){var n=Y(this.$$search),r=this.$$hash?"#"+J(this.$$hash):"";this.$$url=me(this.$$path)+(n?"?"+n:"")+r,this.$$absUrl=t+e+this.$$url}}function Oe(t){return function(){return this[t]}}function Te(t,e){return function(n){return m(n)?this[t]:(this[t]=e(n),this.$$compose(),this)}}function Me(){var t="",e={enabled:!1,requireBase:!0,rewriteLinks:!0};this.hashPrefix=function(e){return g(e)?(t=e,this):t},this.html5Mode=function(t){return M(t)?(e.enabled=t,this):y(t)?(M(t.enabled)&&(e.enabled=t.enabled),M(t.requireBase)&&(e.requireBase=t.requireBase),M(t.rewriteLinks)&&(e.rewriteLinks=t.rewriteLinks),this):e},this.$get=["$rootScope","$browser","$sniffer","$rootElement","$window",function(n,r,i,o,a){function s(t,e,n){var i=c.url(),o=c.$$state;try{r.url(t,e,n),c.$$state=r.state()}catch(a){throw c.url(i),c.$$state=o,a}}function u(t,e){n.$broadcast("$locationChangeSuccess",c.absUrl(),t,c.$$state,e)}var c,l,f,h=r.baseHref(),$=r.url();if(e.enabled){if(!h&&e.requireBase)throw ai("nobase","$location in HTML5 mode requires a <base> tag to be present!");f=Ce($)+(h||"/"),l=i.history?Ae:ke}else f=be($),l=Ee;c=new l(f,"#"+t),c.$$parseLinkUrl($,$),c.$$state=r.state();var p=/^\s*(javascript|mailto):/i;o.on("click",function(t){if(e.rewriteLinks&&!t.ctrlKey&&!t.metaKey&&!t.shiftKey&&2!=t.which&&2!=t.button){for(var i=er(t.target);"a"!==j(i[0]);)if(i[0]===o[0]||!(i=i.parent())[0])return;var s=i.prop("href"),u=i.attr("href")||i.attr("xlink:href");y(s)&&"[object SVGAnimatedString]"===s.toString()&&(s=rn(s.animVal).href),p.test(s)||!s||i.attr("target")||t.isDefaultPrevented()||c.$$parseLinkUrl(s,u)&&(t.preventDefault(),c.absUrl()!=r.url()&&(n.$apply(),a.angular["ff-684208-preventDefault"]=!0))}}),xe(c.absUrl())!=xe($)&&r.url(c.absUrl(),!0);var d=!0;return r.onUrlChange(function(t,e){n.$evalAsync(function(){var r,i=c.absUrl(),o=c.$$state;c.$$parse(t),c.$$state=e,r=n.$broadcast("$locationChangeStart",t,i,e,o).defaultPrevented,c.absUrl()===t&&(r?(c.$$parse(i),c.$$state=o,s(i,!1,o)):(d=!1,u(i,o)))}),n.$$phase||n.$digest()}),n.$watch(function(){var t=xe(r.url()),e=xe(c.absUrl()),o=r.state(),a=c.$$replace,l=t!==e||c.$$html5&&i.history&&o!==c.$$state;(d||l)&&(d=!1,n.$evalAsync(function(){var e=c.absUrl(),r=n.$broadcast("$locationChangeStart",e,t,c.$$state,o).defaultPrevented;c.absUrl()===e&&(r?(c.$$parse(t),c.$$state=o):(l&&s(e,a,o===c.$$state?null:c.$$state),u(t,o)))})),c.$$replace=!1}),c}]}function Ne(){var t=!0,e=this;this.debugEnabled=function(e){return g(e)?(t=e,this):t},this.$get=["$window",function(n){function r(t){return t instanceof Error&&(t.stack?t=t.message&&-1===t.stack.indexOf(t.message)?"Error: "+t.message+"\n"+t.stack:t.stack:t.sourceURL&&(t=t.message+"\n"+t.sourceURL+":"+t.line)),t}function i(t){var e=n.console||{},i=e[t]||e.log||p,a=!1;try{a=!!i.apply}catch(s){}return a?function(){var t=[];return o(arguments,function(e){t.push(r(e))}),i.apply(e,t)}:function(t,e){i(t,null==e?"":e)}}return{log:i("log"),info:i("info"),warn:i("warn"),error:i("error"),debug:function(){var n=i("debug");return function(){t&&n.apply(e,arguments)}}()}}]}function Ve(t,e){if("__defineGetter__"===t||"__defineSetter__"===t||"__lookupGetter__"===t||"__lookupSetter__"===t||"__proto__"===t)throw ui("isecfld","Attempting to access a disallowed field in Angular expressions! Expression: {0}",e);return t}function De(t,e){if(t){if(t.constructor===t)throw ui("isecfn","Referencing Function in Angular expressions is disallowed! Expression: {0}",e);if(t.window===t)throw ui("isecwindow","Referencing the Window in Angular expressions is disallowed! Expression: {0}",e);if(t.children&&(t.nodeName||t.prop&&t.attr&&t.find))throw ui("isecdom","Referencing DOM nodes in Angular expressions is disallowed! Expression: {0}",e);if(t===Object)throw ui("isecobj","Referencing Object in Angular expressions is disallowed! Expression: {0}",e)}return t}function je(t,e){if(t){if(t.constructor===t)throw ui("isecfn","Referencing Function in Angular expressions is disallowed! Expression: {0}",e);if(t===ci||t===li||t===fi)throw ui("isecff","Referencing call, apply or bind in Angular expressions is disallowed! Expression: {0}",e)}}function Re(t){return t.constant}function Pe(t,e,n,r,i){De(t,i),De(e,i);for(var o,a=n.split("."),s=0;a.length>1;s++){o=Ve(a.shift(),i);var u=0===s&&e&&e[o]||t[o];u||(u={},t[o]=u),t=De(u,i)}return o=Ve(a.shift(),i),De(t[o],i),t[o]=r,r}function _e(t){return"constructor"==t}function Ie(t,e,r,i,o,a,s){Ve(t,a),Ve(e,a),Ve(r,a),Ve(i,a),Ve(o,a);var u=function(t){return De(t,a)},c=s||_e(t)?u:d,l=s||_e(e)?u:d,f=s||_e(r)?u:d,h=s||_e(i)?u:d,$=s||_e(o)?u:d;return function(a,s){var u=s&&s.hasOwnProperty(t)?s:a;return null==u?u:(u=c(u[t]),e?null==u?n:(u=l(u[e]),r?null==u?n:(u=f(u[r]),i?null==u?n:(u=h(u[i]),o?null==u?n:u=$(u[o]):u):u):u):u)}}function qe(t,e){return function(n,r){return t(n,r,De,e)}}function Ue(t,e,r){var i=e.expensiveChecks,a=i?gi:mi,s=a[t];if(s)return s;var u=t.split("."),c=u.length;if(e.csp)s=6>c?Ie(u[0],u[1],u[2],u[3],u[4],r,i):function(t,e){var o,a=0;do o=Ie(u[a++],u[a++],u[a++],u[a++],u[a++],r,i)(t,e),e=n,t=o;while(c>a);return o};else{var l="";i&&(l+="s = eso(s, fe);\nl = eso(l, fe);\n");var f=i;o(u,function(t,e){Ve(t,r);var n=(e?"s":'((l&&l.hasOwnProperty("'+t+'"))?l:s)')+"."+t;(i||_e(t))&&(n="eso("+n+", fe)",f=!0),l+="if(s == null) return undefined;\ns="+n+";\n"}),l+="return s;";var h=new Function("s","l","eso","fe",l);h.toString=v(l),f&&(h=qe(h,r)),s=h}return s.sharedGetter=!0,s.assign=function(e,n,r){return Pe(e,r,t,n,t)},a[t]=s,s}function Fe(t){return S(t.valueOf)?t.valueOf():yi.call(t)}function He(){var t=ct(),e=ct();this.$get=["$filter","$sniffer",function(n,r){function i(t){var e=t;return t.sharedGetter&&(e=function(e,n){return t(e,n)},e.literal=t.literal,e.constant=t.constant,e.assign=t.assign),e}function a(t,e){for(var n=0,r=t.length;r>n;n++){var i=t[n];i.constant||(i.inputs?a(i.inputs,e):-1===e.indexOf(i)&&e.push(i))}return e}function s(t,e){return null==t||null==e?t===e:"object"==typeof t&&(t=Fe(t),"object"==typeof t)?!1:t===e||t!==t&&e!==e}function u(t,e,n,r){var i,o=r.$$inputs||(r.$$inputs=a(r.inputs,[]));if(1===o.length){var u=s;return o=o[0],t.$watch(function(t){var e=o(t);return s(e,u)||(i=r(t),u=e&&Fe(e)),i},e,n)}for(var c=[],l=0,f=o.length;f>l;l++)c[l]=s;return t.$watch(function(t){for(var e=!1,n=0,a=o.length;a>n;n++){var u=o[n](t);(e||(e=!s(u,c[n])))&&(c[n]=u&&Fe(u))}return e&&(i=r(t)),i},e,n)}function c(t,e,n,r){var i,o;return i=t.$watch(function(t){return r(t)},function(t,n,r){o=t,S(e)&&e.apply(this,arguments),g(t)&&r.$$postDigest(function(){g(o)&&i()})},n)}function l(t,e,n,r){function i(t){var e=!0;return o(t,function(t){g(t)||(e=!1)}),e}var a,s;return a=t.$watch(function(t){return r(t)},function(t,n,r){s=t,S(e)&&e.call(this,t,n,r),i(t)&&r.$$postDigest(function(){i(s)&&a()})},n)}function f(t,e,n,r){var i;return i=t.$watch(function(t){return r(t)},function(t,n,r){S(e)&&e.apply(this,arguments),i()},n)}function h(t,e){if(!e)return t;var n=t.$$watchDelegate,r=n!==l&&n!==c,i=r?function(n,r){var i=t(n,r);return e(i,n,r)}:function(n,r){var i=t(n,r),o=e(i,n,r);return g(i)?o:i};return t.$$watchDelegate&&t.$$watchDelegate!==u?i.$$watchDelegate=t.$$watchDelegate:e.$stateful||(i.$$watchDelegate=u,i.inputs=[t]),i}var $={csp:r.csp,expensiveChecks:!1},d={csp:r.csp,expensiveChecks:!0};return function(r,o,a){var s,v,m;switch(typeof r){case"string":m=r=r.trim();var g=a?e:t;if(s=g[m],!s){":"===r.charAt(0)&&":"===r.charAt(1)&&(v=!0,r=r.substring(2));var y=a?d:$,w=new di(y),b=new vi(w,n,y);s=b.parse(r),s.constant?s.$$watchDelegate=f:v?(s=i(s),s.$$watchDelegate=s.literal?l:c):s.inputs&&(s.$$watchDelegate=u),g[m]=s}return h(s,o);case"function":return h(r,o);default:return h(p,o)}}}]}function Le(){this.$get=["$rootScope","$exceptionHandler",function(t,e){return ze(function(e){t.$evalAsync(e)},e)}]}function Be(){this.$get=["$browser","$exceptionHandler",function(t,e){return ze(function(e){t.defer(e)},e)}]}function ze(t,e){function i(t,e,n){function r(e){return function(n){i||(i=!0,e.call(t,n))}}var i=!1;return[r(e),r(n)]}function a(){this.$$state={status:0}}function s(t,e){return function(n){e.call(t,n)}}function u(t){var r,i,o;o=t.pending,t.processScheduled=!1,t.pending=n;for(var a=0,s=o.length;s>a;++a){i=o[a][0],r=o[a][t.status];try{S(r)?i.resolve(r(t.value)):1===t.status?i.resolve(t.value):i.reject(t.value)}catch(u){i.reject(u),e(u)}}}function c(e){!e.processScheduled&&e.pending&&(e.processScheduled=!0,t(function(){u(e)}))}function l(){this.promise=new a,this.resolve=s(this,this.resolve),this.reject=s(this,this.reject),this.notify=s(this,this.notify)}function f(t){var e=new l,n=0,r=hr(t)?[]:{};return o(t,function(t,i){n++,m(t).then(function(t){r.hasOwnProperty(i)||(r[i]=t,--n||e.resolve(r))},function(t){r.hasOwnProperty(i)||e.reject(t)})}),0===n&&e.resolve(r),e.promise}var h=r("$q",TypeError),$=function(){return new l};a.prototype={then:function(t,e,n){var r=new l;return this.$$state.pending=this.$$state.pending||[],this.$$state.pending.push([r,t,e,n]),this.$$state.status>0&&c(this.$$state),r.promise},"catch":function(t){return this.then(null,t)},"finally":function(t,e){return this.then(function(e){return v(e,!0,t)},function(e){return v(e,!1,t)},e)}},l.prototype={resolve:function(t){this.promise.$$state.status||(t===this.promise?this.$$reject(h("qcycle","Expected promise to be resolved with value other than itself '{0}'",t)):this.$$resolve(t))},$$resolve:function(t){var n,r;r=i(this,this.$$resolve,this.$$reject);try{(y(t)||S(t))&&(n=t&&t.then),S(n)?(this.promise.$$state.status=-1,n.call(t,r[0],r[1],this.notify)):(this.promise.$$state.value=t,this.promise.$$state.status=1,c(this.promise.$$state))}catch(o){r[1](o),e(o)}},reject:function(t){this.promise.$$state.status||this.$$reject(t)},$$reject:function(t){this.promise.$$state.value=t,this.promise.$$state.status=2,c(this.promise.$$state)},notify:function(n){var r=this.promise.$$state.pending;this.promise.$$state.status<=0&&r&&r.length&&t(function(){for(var t,i,o=0,a=r.length;a>o;o++){i=r[o][0],t=r[o][3];try{i.notify(S(t)?t(n):n)}catch(s){e(s)}}})}};var p=function(t){var e=new l;return e.reject(t),e.promise},d=function(t,e){var n=new l;return e?n.resolve(t):n.reject(t),n.promise},v=function(t,e,n){var r=null;try{S(n)&&(r=n())}catch(i){return d(i,!1)}return N(r)?r.then(function(){return d(t,e)},function(t){return d(t,!1)}):d(t,e)},m=function(t,e,n,r){var i=new l;return i.resolve(t),i.promise.then(e,n,r)},g=function w(t){function e(t){r.resolve(t)}function n(t){r.reject(t)}if(!S(t))throw h("norslvr","Expected resolverFn, got '{0}'",t);if(!(this instanceof w))return new w(t);var r=new l;return t(e,n),r.promise};return g.defer=$,g.reject=p,g.when=m,g.all=f,g}function Ge(){this.$get=["$window","$timeout",function(t,e){var n=t.requestAnimationFrame||t.webkitRequestAnimationFrame,r=t.cancelAnimationFrame||t.webkitCancelAnimationFrame||t.webkitCancelRequestAnimationFrame,i=!!n,o=i?function(t){var e=n(t);return function(){r(e)}}:function(t){var n=e(t,16.66,!1);return function(){e.cancel(n)}};return o.supported=i,o}]}function We(){function t(t){function e(){this.$$watchers=this.$$nextSibling=this.$$childHead=this.$$childTail=null,this.$$listeners={},this.$$listenerCount={},this.$$watchersCount=0,this.$id=c(),this.$$ChildScope=null}return e.prototype=t,e}var e=10,n=r("$rootScope"),a=null,s=null;this.digestTtl=function(t){return arguments.length&&(e=t),e},this.$get=["$injector","$exceptionHandler","$parse","$browser",function(r,u,l,f){function h(t){t.currentScope.$$destroyed=!0}function $(){this.$id=c(),this.$$phase=this.$parent=this.$$watchers=this.$$nextSibling=this.$$prevSibling=this.$$childHead=this.$$childTail=null,this.$root=this,this.$$destroyed=!1,this.$$listeners={},this.$$listenerCount={},this.$$isolateBindings=null}function d(t){if(C.$$phase)throw n("inprog","{0} already in progress",C.$$phase);C.$$phase=t}function v(){C.$$phase=null}function g(t,e,n){do t.$$listenerCount[n]-=e,0===t.$$listenerCount[n]&&delete t.$$listenerCount[n];while(t=t.$parent)}function w(){}function b(){for(;k.length;)try{k.shift()()}catch(t){u(t)}s=null}function x(){null===s&&(s=f.defer(function(){C.$apply(b)}))}$.prototype={constructor:$,$new:function(e,n){var r;return n=n||this,e?(r=new $,r.$root=this.$root):(this.$$ChildScope||(this.$$ChildScope=t(this)),r=new this.$$ChildScope),r.$parent=n,r.$$prevSibling=n.$$childTail,n.$$childHead?(n.$$childTail.$$nextSibling=r,n.$$childTail=r):n.$$childHead=n.$$childTail=r,(e||n!=this)&&r.$on("$destroy",h),r},$watch:function(t,e,n){var r=l(t);if(r.$$watchDelegate)return r.$$watchDelegate(this,e,n,r);var i=this,o=i.$$watchers,s={fn:e,last:w,get:r,exp:t,eq:!!n};return a=null,S(e)||(s.fn=p),o||(o=i.$$watchers=[]),o.unshift(s),function(){R(o,s),a=null}},$watchGroup:function(t,e){function n(){u=!1,c?(c=!1,e(i,i,s)):e(i,r,s)}var r=new Array(t.length),i=new Array(t.length),a=[],s=this,u=!1,c=!0;if(!t.length){var l=!0;return s.$evalAsync(function(){l&&e(i,i,s)}),function(){l=!1}}return 1===t.length?this.$watch(t[0],function(t,n,o){i[0]=t,r[0]=n,e(i,t===n?i:r,o)}):(o(t,function(t,e){var o=s.$watch(t,function(t,o){i[e]=t,r[e]=o,u||(u=!0,s.$evalAsync(n))});a.push(o)}),function(){for(;a.length;)a.shift()()})},$watchCollection:function(t,e){function n(t){o=t;var e,n,r,s,u;if(!m(o)){if(y(o))if(i(o)){a!==$&&(a=$,v=a.length=0,f++),e=o.length,v!==e&&(f++,a.length=v=e);for(var c=0;e>c;c++)u=a[c],s=o[c],r=u!==u&&s!==s,r||u===s||(f++,a[c]=s)}else{a!==p&&(a=p={},v=0,f++),e=0;for(n in o)o.hasOwnProperty(n)&&(e++,s=o[n],u=a[n],n in a?(r=u!==u&&s!==s,r||u===s||(f++,a[n]=s)):(v++,a[n]=s,f++));if(v>e){f++;for(n in a)o.hasOwnProperty(n)||(v--,delete a[n])}}else a!==o&&(a=o,f++);return f}}function r(){if(d?(d=!1,e(o,o,u)):e(o,s,u),c)if(y(o))if(i(o)){s=new Array(o.length);for(var t=0;t<o.length;t++)s[t]=o[t]}else{s={};for(var n in o)Zn.call(o,n)&&(s[n]=o[n])}else s=o}n.$stateful=!0;var o,a,s,u=this,c=e.length>1,f=0,h=l(t,n),$=[],p={},d=!0,v=0;return this.$watch(h,r)},$digest:function(){var t,r,i,o,c,l,h,$,p,m,g=e,y=this,x=[];d("$digest"),f.$$checkUrlChange(),this===C&&null!==s&&(f.defer.cancel(s),
b()),a=null;do{for(l=!1,$=y;A.length;){try{m=A.shift(),m.scope.$eval(m.expression,m.locals)}catch(k){u(k)}a=null}t:do{if(o=$.$$watchers)for(c=o.length;c--;)try{if(t=o[c])if((r=t.get($))===(i=t.last)||(t.eq?I(r,i):"number"==typeof r&&"number"==typeof i&&isNaN(r)&&isNaN(i))){if(t===a){l=!1;break t}}else l=!0,a=t,t.last=t.eq?P(r,null):r,t.fn(r,i===w?r:i,$),5>g&&(p=4-g,x[p]||(x[p]=[]),x[p].push({msg:S(t.exp)?"fn: "+(t.exp.name||t.exp.toString()):t.exp,newVal:r,oldVal:i}))}catch(k){u(k)}if(!(h=$.$$childHead||$!==y&&$.$$nextSibling))for(;$!==y&&!(h=$.$$nextSibling);)$=$.$parent}while($=h);if((l||A.length)&&!g--)throw v(),n("infdig","{0} $digest() iterations reached. Aborting!\nWatchers fired in the last 5 iterations: {1}",e,x)}while(l||A.length);for(v();E.length;)try{E.shift()()}catch(k){u(k)}},$destroy:function(){if(!this.$$destroyed){var t=this.$parent;if(this.$broadcast("$destroy"),this.$$destroyed=!0,this!==C){for(var e in this.$$listenerCount)g(this,this.$$listenerCount[e],e);t.$$childHead==this&&(t.$$childHead=this.$$nextSibling),t.$$childTail==this&&(t.$$childTail=this.$$prevSibling),this.$$prevSibling&&(this.$$prevSibling.$$nextSibling=this.$$nextSibling),this.$$nextSibling&&(this.$$nextSibling.$$prevSibling=this.$$prevSibling),this.$destroy=this.$digest=this.$apply=this.$evalAsync=this.$applyAsync=p,this.$on=this.$watch=this.$watchGroup=function(){return p},this.$$listeners={},this.$parent=this.$$nextSibling=this.$$prevSibling=this.$$childHead=this.$$childTail=this.$root=this.$$watchers=null}}},$eval:function(t,e){return l(t)(this,e)},$evalAsync:function(t,e){C.$$phase||A.length||f.defer(function(){A.length&&C.$digest()}),A.push({scope:this,expression:t,locals:e})},$$postDigest:function(t){E.push(t)},$apply:function(t){try{return d("$apply"),this.$eval(t)}catch(e){u(e)}finally{v();try{C.$digest()}catch(e){throw u(e),e}}},$applyAsync:function(t){function e(){n.$eval(t)}var n=this;t&&k.push(e),x()},$on:function(t,e){var n=this.$$listeners[t];n||(this.$$listeners[t]=n=[]),n.push(e);var r=this;do r.$$listenerCount[t]||(r.$$listenerCount[t]=0),r.$$listenerCount[t]++;while(r=r.$parent);var i=this;return function(){var r=n.indexOf(e);-1!==r&&(n[r]=null,g(i,1,t))}},$emit:function(t,e){var n,r,i,o=[],a=this,s=!1,c={name:t,targetScope:a,stopPropagation:function(){s=!0},preventDefault:function(){c.defaultPrevented=!0},defaultPrevented:!1},l=q([c],arguments,1);do{for(n=a.$$listeners[t]||o,c.currentScope=a,r=0,i=n.length;i>r;r++)if(n[r])try{n[r].apply(null,l)}catch(f){u(f)}else n.splice(r,1),r--,i--;if(s)return c.currentScope=null,c;a=a.$parent}while(a);return c.currentScope=null,c},$broadcast:function(t,e){var n=this,r=n,i=n,o={name:t,targetScope:n,preventDefault:function(){o.defaultPrevented=!0},defaultPrevented:!1};if(!n.$$listenerCount[t])return o;for(var a,s,c,l=q([o],arguments,1);r=i;){for(o.currentScope=r,a=r.$$listeners[t]||[],s=0,c=a.length;c>s;s++)if(a[s])try{a[s].apply(null,l)}catch(f){u(f)}else a.splice(s,1),s--,c--;if(!(i=r.$$listenerCount[t]&&r.$$childHead||r!==n&&r.$$nextSibling))for(;r!==n&&!(i=r.$$nextSibling);)r=r.$parent}return o.currentScope=null,o}};var C=new $,A=C.$$asyncQueue=[],E=C.$$postDigestQueue=[],k=C.$$applyAsyncQueue=[];return C}]}function Ye(){var t=/^\s*(https?|ftp|mailto|tel|file):/,e=/^\s*((https?|ftp|file|blob):|data:image\/)/;this.aHrefSanitizationWhitelist=function(e){return g(e)?(t=e,this):t},this.imgSrcSanitizationWhitelist=function(t){return g(t)?(e=t,this):e},this.$get=function(){return function(n,r){var i,o=r?e:t;return i=rn(n).href,""===i||i.match(o)?n:"unsafe:"+i}}}function Je(t){if("self"===t)return t;if(w(t)){if(t.indexOf("***")>-1)throw wi("iwcard","Illegal sequence *** in string matcher.  String: {0}",t);return t=pr(t).replace("\\*\\*",".*").replace("\\*","[^:/.?&;]*"),new RegExp("^"+t+"$")}if(C(t))return new RegExp("^"+t.source+"$");throw wi("imatcher",'Matchers may only be "self", string patterns or RegExp objects')}function Ze(t){var e=[];return g(t)&&o(t,function(t){e.push(Je(t))}),e}function Ke(){this.SCE_CONTEXTS=bi;var t=["self"],e=[];this.resourceUrlWhitelist=function(e){return arguments.length&&(t=Ze(e)),t},this.resourceUrlBlacklist=function(t){return arguments.length&&(e=Ze(t)),e},this.$get=["$injector",function(r){function i(t,e){return"self"===t?on(e):!!t.exec(e.href)}function o(n){var r,o,a=rn(n.toString()),s=!1;for(r=0,o=t.length;o>r;r++)if(i(t[r],a)){s=!0;break}if(s)for(r=0,o=e.length;o>r;r++)if(i(e[r],a)){s=!1;break}return s}function a(t){var e=function(t){this.$$unwrapTrustedValue=function(){return t}};return t&&(e.prototype=new t),e.prototype.valueOf=function(){return this.$$unwrapTrustedValue()},e.prototype.toString=function(){return this.$$unwrapTrustedValue().toString()},e}function s(t,e){var r=h.hasOwnProperty(t)?h[t]:null;if(!r)throw wi("icontext","Attempted to trust a value in invalid context. Context: {0}; Value: {1}",t,e);if(null===e||e===n||""===e)return e;if("string"!=typeof e)throw wi("itype","Attempted to trust a non-string value in a content requiring a string: Context: {0}",t);return new r(e)}function u(t){return t instanceof f?t.$$unwrapTrustedValue():t}function c(t,e){if(null===e||e===n||""===e)return e;var r=h.hasOwnProperty(t)?h[t]:null;if(r&&e instanceof r)return e.$$unwrapTrustedValue();if(t===bi.RESOURCE_URL){if(o(e))return e;throw wi("insecurl","Blocked loading resource from url not allowed by $sceDelegate policy.  URL: {0}",e.toString())}if(t===bi.HTML)return l(e);throw wi("unsafe","Attempting to use an unsafe value in a safe context.")}var l=function(t){throw wi("unsafe","Attempting to use an unsafe value in a safe context.")};r.has("$sanitize")&&(l=r.get("$sanitize"));var f=a(),h={};return h[bi.HTML]=a(f),h[bi.CSS]=a(f),h[bi.URL]=a(f),h[bi.JS]=a(f),h[bi.RESOURCE_URL]=a(h[bi.URL]),{trustAs:s,getTrusted:c,valueOf:u}}]}function Xe(){var t=!0;this.enabled=function(e){return arguments.length&&(t=!!e),t},this.$get=["$parse","$sceDelegate",function(e,n){if(t&&8>tr)throw wi("iequirks","Strict Contextual Escaping does not support Internet Explorer version < 11 in quirks mode.  You can fix this by adding the text <!doctype html> to the top of your HTML document.  See http://docs.angularjs.org/api/ng.$sce for more information.");var r=_(bi);r.isEnabled=function(){return t},r.trustAs=n.trustAs,r.getTrusted=n.getTrusted,r.valueOf=n.valueOf,t||(r.trustAs=r.getTrusted=function(t,e){return e},r.valueOf=d),r.parseAs=function(t,n){var i=e(n);return i.literal&&i.constant?i:e(n,function(e){return r.getTrusted(t,e)})};var i=r.parseAs,a=r.getTrusted,s=r.trustAs;return o(bi,function(t,e){var n=Jn(e);r[dt("parse_as_"+n)]=function(e){return i(t,e)},r[dt("get_trusted_"+n)]=function(e){return a(t,e)},r[dt("trust_as_"+n)]=function(e){return s(t,e)}}),r}]}function Qe(){this.$get=["$window","$document",function(t,e){var n,r,i={},o=h((/android (\d+)/.exec(Jn((t.navigator||{}).userAgent))||[])[1]),a=/Boxee/i.test((t.navigator||{}).userAgent),s=e[0]||{},u=/^(Moz|webkit|ms)(?=[A-Z])/,c=s.body&&s.body.style,l=!1,f=!1;if(c){for(var $ in c)if(r=u.exec($)){n=r[0],n=n.substr(0,1).toUpperCase()+n.substr(1);break}n||(n="WebkitOpacity"in c&&"webkit"),l=!!("transition"in c||n+"Transition"in c),f=!!("animation"in c||n+"Animation"in c),!o||l&&f||(l=w(s.body.style.webkitTransition),f=w(s.body.style.webkitAnimation))}return{history:!(!t.history||!t.history.pushState||4>o||a),hasEvent:function(t){if("input"===t&&11>=tr)return!1;if(m(i[t])){var e=s.createElement("div");i[t]="on"+t in e}return i[t]},csp:dr(),vendorPrefix:n,transitions:l,animations:f,android:o}}]}function tn(){this.$get=["$templateCache","$http","$q",function(t,e,n){function r(i,o){function a(t){if(!o)throw Jr("tpload","Failed to load template: {0}",i);return n.reject(t)}r.totalPendingRequests++;var s=e.defaults&&e.defaults.transformResponse;hr(s)?s=s.filter(function(t){return t!==ie}):s===ie&&(s=null);var u={cache:t,transformResponse:s};return e.get(i,u)["finally"](function(){r.totalPendingRequests--}).then(function(t){return t.data},a)}return r.totalPendingRequests=0,r}]}function en(){this.$get=["$rootScope","$browser","$location",function(t,e,n){var r={};return r.findBindings=function(t,e,n){var r=t.getElementsByClassName("ng-binding"),i=[];return o(r,function(t){var r=cr.element(t).data("$binding");r&&o(r,function(r){if(n){var o=new RegExp("(^|\\s)"+pr(e)+"(\\s|\\||$)");o.test(r)&&i.push(t)}else-1!=r.indexOf(e)&&i.push(t)})}),i},r.findModels=function(t,e,n){for(var r=["ng-","data-ng-","ng\\:"],i=0;i<r.length;++i){var o=n?"=":"*=",a="["+r[i]+"model"+o+'"'+e+'"]',s=t.querySelectorAll(a);if(s.length)return s}},r.getLocation=function(){return n.url()},r.setLocation=function(e){e!==n.url()&&(n.url(e),t.$digest())},r.whenStable=function(t){e.notifyWhenNoOutstandingRequests(t)},r}]}function nn(){this.$get=["$rootScope","$browser","$q","$$q","$exceptionHandler",function(t,e,n,r,i){function o(o,s,u){var c,l=g(u)&&!u,f=(l?r:n).defer(),h=f.promise;return c=e.defer(function(){try{f.resolve(o())}catch(e){f.reject(e),i(e)}finally{delete a[h.$$timeoutId]}l||t.$apply()},s),h.$$timeoutId=c,a[c]=f,h}var a={};return o.cancel=function(t){return t&&t.$$timeoutId in a?(a[t.$$timeoutId].reject("canceled"),delete a[t.$$timeoutId],e.defer.cancel(t.$$timeoutId)):!1},o}]}function rn(t){var e=t;return tr&&(xi.setAttribute("href",e),e=xi.href),xi.setAttribute("href",e),{href:xi.href,protocol:xi.protocol?xi.protocol.replace(/:$/,""):"",host:xi.host,search:xi.search?xi.search.replace(/^\?/,""):"",hash:xi.hash?xi.hash.replace(/^#/,""):"",hostname:xi.hostname,port:xi.port,pathname:"/"===xi.pathname.charAt(0)?xi.pathname:"/"+xi.pathname}}function on(t){var e=w(t)?rn(t):t;return e.protocol===Si.protocol&&e.host===Si.host}function an(){this.$get=v(t)}function sn(t){function e(r,i){if(y(r)){var a={};return o(r,function(t,n){a[n]=e(n,t)}),a}return t.factory(r+n,i)}var n="Filter";this.register=e,this.$get=["$injector",function(t){return function(e){return t.get(e+n)}}],e("currency",fn),e("date",Cn),e("filter",un),e("json",An),e("limitTo",En),e("lowercase",Oi),e("number",hn),e("orderBy",kn),e("uppercase",Ti)}function un(){return function(t,e,n){if(!hr(t))return t;var r,i;switch(typeof e){case"function":r=e;break;case"boolean":case"number":case"string":i=!0;case"object":r=cn(e,n,i);break;default:return t}return t.filter(r)}}function cn(t,e,n){var r,i=y(t)&&"$"in t;return e===!0?e=I:S(e)||(e=function(t,e){return y(t)||y(e)?!1:(t=Jn(""+t),e=Jn(""+e),-1!==t.indexOf(e))}),r=function(r){return i&&!y(r)?ln(r,t.$,e,!1):ln(r,t,e,n)}}function ln(t,e,n,r,i){var o=null!==t?typeof t:"null",a=null!==e?typeof e:"null";if("string"===a&&"!"===e.charAt(0))return!ln(t,e.substring(1),n,r);if(hr(t))return t.some(function(t){return ln(t,e,n,r)});switch(o){case"object":var s;if(r){for(s in t)if("$"!==s.charAt(0)&&ln(t[s],e,n,!0))return!0;return i?!1:ln(t,e,n,!1)}if("object"===a){for(s in e){var u=e[s];if(!S(u)&&!m(u)){var c="$"===s,l=c?t:t[s];if(!ln(l,u,n,c,c))return!1}}return!0}return n(t,e);case"function":return!1;default:return n(t,e)}}function fn(t){var e=t.NUMBER_FORMATS;return function(t,n,r){return m(n)&&(n=e.CURRENCY_SYM),m(r)&&(r=e.PATTERNS[1].maxFrac),null==t?t:$n(t,e.PATTERNS[1],e.GROUP_SEP,e.DECIMAL_SEP,r).replace(/\u00A4/g,n)}}function hn(t){var e=t.NUMBER_FORMATS;return function(t,n){return null==t?t:$n(t,e.PATTERNS[0],e.GROUP_SEP,e.DECIMAL_SEP,n)}}function $n(t,e,n,r,i){if(!isFinite(t)||y(t))return"";var o=0>t;t=Math.abs(t);var a=t+"",s="",u=[],c=!1;if(-1!==a.indexOf("e")){var l=a.match(/([\d\.]+)e(-?)(\d+)/);l&&"-"==l[2]&&l[3]>i+1?t=0:(s=a,c=!0)}if(c)i>0&&1>t&&(s=t.toFixed(i),t=parseFloat(s));else{var f=(a.split(Ci)[1]||"").length;m(i)&&(i=Math.min(Math.max(e.minFrac,f),e.maxFrac)),t=+(Math.round(+(t.toString()+"e"+i)).toString()+"e"+-i);var h=(""+t).split(Ci),$=h[0];h=h[1]||"";var p,d=0,v=e.lgSize,g=e.gSize;if($.length>=v+g)for(d=$.length-v,p=0;d>p;p++)(d-p)%g===0&&0!==p&&(s+=n),s+=$.charAt(p);for(p=d;p<$.length;p++)($.length-p)%v===0&&0!==p&&(s+=n),s+=$.charAt(p);for(;h.length<i;)h+="0";i&&"0"!==i&&(s+=r+h.substr(0,i))}return 0===t&&(o=!1),u.push(o?e.negPre:e.posPre,s,o?e.negSuf:e.posSuf),u.join("")}function pn(t,e,n){var r="";for(0>t&&(r="-",t=-t),t=""+t;t.length<e;)t="0"+t;return n&&(t=t.substr(t.length-e)),r+t}function dn(t,e,n,r){return n=n||0,function(i){var o=i["get"+t]();return(n>0||o>-n)&&(o+=n),0===o&&-12==n&&(o=12),pn(o,e,r)}}function vn(t,e){return function(n,r){var i=n["get"+t](),o=Kn(e?"SHORT"+t:t);return r[o][i]}}function mn(t){var e=-1*t.getTimezoneOffset(),n=e>=0?"+":"";return n+=pn(Math[e>0?"floor":"ceil"](e/60),2)+pn(Math.abs(e%60),2)}function gn(t){var e=new Date(t,0,1).getDay();return new Date(t,0,(4>=e?5:12)-e)}function yn(t){return new Date(t.getFullYear(),t.getMonth(),t.getDate()+(4-t.getDay()))}function wn(t){return function(e){var n=gn(e.getFullYear()),r=yn(e),i=+r-+n,o=1+Math.round(i/6048e5);return pn(o,t)}}function bn(t,e){return t.getHours()<12?e.AMPMS[0]:e.AMPMS[1]}function xn(t,e){return t.getFullYear()<=0?e.ERAS[0]:e.ERAS[1]}function Sn(t,e){return t.getFullYear()<=0?e.ERANAMES[0]:e.ERANAMES[1]}function Cn(t){function e(t){var e;if(e=t.match(n)){var r=new Date(0),i=0,o=0,a=e[8]?r.setUTCFullYear:r.setFullYear,s=e[8]?r.setUTCHours:r.setHours;e[9]&&(i=h(e[9]+e[10]),o=h(e[9]+e[11])),a.call(r,h(e[1]),h(e[2])-1,h(e[3]));var u=h(e[4]||0)-i,c=h(e[5]||0)-o,l=h(e[6]||0),f=Math.round(1e3*parseFloat("0."+(e[7]||0)));return s.call(r,u,c,l,f),r}return t}var n=/^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;return function(n,r,i){var a,s,u="",c=[];if(r=r||"mediumDate",r=t.DATETIME_FORMATS[r]||r,w(n)&&(n=ki.test(n)?h(n):e(n)),b(n)&&(n=new Date(n)),!x(n))return n;for(;r;)s=Ei.exec(r),s?(c=q(c,s,1),r=c.pop()):(c.push(r),r=null);return i&&"UTC"===i&&(n=new Date(n.getTime()),n.setMinutes(n.getMinutes()+n.getTimezoneOffset())),o(c,function(e){a=Ai[e],u+=a?a(n,t.DATETIME_FORMATS):e.replace(/(^'|'$)/g,"").replace(/''/g,"'")}),u}}function An(){return function(t,e){return m(e)&&(e=2),L(t,e)}}function En(){return function(t,e){return b(t)&&(t=t.toString()),hr(t)||w(t)?(e=Math.abs(Number(e))===1/0?Number(e):h(e),e?e>0?t.slice(0,e):t.slice(e):w(t)?"":[]):t}}function kn(t){return function(e,n,r){function o(t,e){for(var r=0;r<n.length;r++){var i=n[r](t,e);if(0!==i)return i}return 0}function a(t,e){return e?function(e,n){return t(n,e)}:t}function s(t){switch(typeof t){case"number":case"boolean":case"string":return!0;default:return!1}}function u(t){return null===t?"null":"function"==typeof t.valueOf&&(t=t.valueOf(),s(t))?t:"function"==typeof t.toString&&(t=t.toString(),s(t))?t:""}function c(t,e){var n=typeof t,r=typeof e;return n===r&&"object"===n&&(t=u(t),e=u(e)),n===r?("string"===n&&(t=t.toLowerCase(),e=e.toLowerCase()),t===e?0:e>t?-1:1):r>n?-1:1}return i(e)?(n=hr(n)?n:[n],0===n.length&&(n=["+"]),n=n.map(function(e){var n=!1,r=e||d;if(w(e)){if(("+"==e.charAt(0)||"-"==e.charAt(0))&&(n="-"==e.charAt(0),e=e.substring(1)),""===e)return a(c,n);if(r=t(e),r.constant){var i=r();return a(function(t,e){return c(t[i],e[i])},n)}}return a(function(t,e){return c(r(t),r(e))},n)}),ir.call(e).sort(a(o,r))):e}}function On(t){return S(t)&&(t={link:t}),t.restrict=t.restrict||"AC",v(t)}function Tn(t,e){t.$name=e}function Mn(t,e,r,i,a){var s=this,u=[],c=s.$$parentForm=t.parent().controller("form")||Vi;s.$error={},s.$$success={},s.$pending=n,s.$name=a(e.name||e.ngForm||"")(r),s.$dirty=!1,s.$pristine=!0,s.$valid=!0,s.$invalid=!1,s.$submitted=!1,c.$addControl(s),s.$rollbackViewValue=function(){o(u,function(t){t.$rollbackViewValue()})},s.$commitViewValue=function(){o(u,function(t){t.$commitViewValue()})},s.$addControl=function(t){at(t.$name,"input"),u.push(t),t.$name&&(s[t.$name]=t)},s.$$renameControl=function(t,e){var n=t.$name;s[n]===t&&delete s[n],s[e]=t,t.$name=e},s.$removeControl=function(t){t.$name&&s[t.$name]===t&&delete s[t.$name],o(s.$pending,function(e,n){s.$setValidity(n,null,t)}),o(s.$error,function(e,n){s.$setValidity(n,null,t)}),o(s.$$success,function(e,n){s.$setValidity(n,null,t)}),R(u,t)},zn({ctrl:this,$element:t,set:function(t,e,n){var r=t[e];if(r){var i=r.indexOf(n);-1===i&&r.push(n)}else t[e]=[n]},unset:function(t,e,n){var r=t[e];r&&(R(r,n),0===r.length&&delete t[e])},parentForm:c,$animate:i}),s.$setDirty=function(){i.removeClass(t,po),i.addClass(t,vo),s.$dirty=!0,s.$pristine=!1,c.$setDirty()},s.$setPristine=function(){i.setClass(t,po,vo+" "+Di),s.$dirty=!1,s.$pristine=!0,s.$submitted=!1,o(u,function(t){t.$setPristine()})},s.$setUntouched=function(){o(u,function(t){t.$setUntouched()})},s.$setSubmitted=function(){i.addClass(t,Di),s.$submitted=!0,c.$setSubmitted()}}function Nn(t){t.$formatters.push(function(e){return t.$isEmpty(e)?e:e.toString()})}function Vn(t,e,n,r,i,o){Dn(t,e,n,r,i,o),Nn(r)}function Dn(t,e,n,r,i,o){var a=Jn(e[0].type);if(!i.android){var s=!1;e.on("compositionstart",function(t){s=!0}),e.on("compositionend",function(){s=!1,u()})}var u=function(t){if(c&&(o.defer.cancel(c),c=null),!s){var i=e.val(),u=t&&t.type;"password"===a||n.ngTrim&&"false"===n.ngTrim||(i=$r(i)),(r.$viewValue!==i||""===i&&r.$$hasNativeValidators)&&r.$setViewValue(i,u)}};if(i.hasEvent("input"))e.on("input",u);else{var c,l=function(t,e,n){c||(c=o.defer(function(){c=null,e&&e.value===n||u(t)}))};e.on("keydown",function(t){var e=t.keyCode;91===e||e>15&&19>e||e>=37&&40>=e||l(t,this,this.value)}),i.hasEvent("paste")&&e.on("paste cut",l)}e.on("change",u),r.$render=function(){e.val(r.$isEmpty(r.$viewValue)?"":r.$viewValue)}}function jn(t,e){if(x(t))return t;if(w(t)){Li.lastIndex=0;var n=Li.exec(t);if(n){var r=+n[1],i=+n[2],o=0,a=0,s=0,u=0,c=gn(r),l=7*(i-1);return e&&(o=e.getHours(),a=e.getMinutes(),s=e.getSeconds(),u=e.getMilliseconds()),new Date(r,0,c.getDate()+l,o,a,s,u)}}return 0/0}function Rn(t,e){return function(n,r){var i,a;if(x(n))return n;if(w(n)){if('"'==n.charAt(0)&&'"'==n.charAt(n.length-1)&&(n=n.substring(1,n.length-1)),_i.test(n))return new Date(n);if(t.lastIndex=0,i=t.exec(n))return i.shift(),a=r?{yyyy:r.getFullYear(),MM:r.getMonth()+1,dd:r.getDate(),HH:r.getHours(),mm:r.getMinutes(),ss:r.getSeconds(),sss:r.getMilliseconds()/1e3}:{yyyy:1970,MM:1,dd:1,HH:0,mm:0,ss:0,sss:0},o(i,function(t,n){n<e.length&&(a[e[n]]=+t)}),new Date(a.yyyy,a.MM-1,a.dd,a.HH,a.mm,a.ss||0,1e3*a.sss||0)}return 0/0}}function Pn(t,e,r,i){return function(o,a,s,u,c,l,f){function h(t){return t&&!(t.getTime&&t.getTime()!==t.getTime())}function $(t){return g(t)?x(t)?t:r(t):n}_n(o,a,s,u),Dn(o,a,s,u,c,l);var p,d=u&&u.$options&&u.$options.timezone;if(u.$$parserName=t,u.$parsers.push(function(t){if(u.$isEmpty(t))return null;if(e.test(t)){var i=r(t,p);return"UTC"===d&&i.setMinutes(i.getMinutes()-i.getTimezoneOffset()),i}return n}),u.$formatters.push(function(t){if(t&&!x(t))throw wo("datefmt","Expected ` + "`" + `{0}` + "`" + ` to be a date",t);if(h(t)){if(p=t,p&&"UTC"===d){var e=6e4*p.getTimezoneOffset();p=new Date(p.getTime()+e)}return f("date")(t,i,d)}return p=null,""}),g(s.min)||s.ngMin){var v;u.$validators.min=function(t){return!h(t)||m(v)||r(t)>=v},s.$observe("min",function(t){v=$(t),u.$validate()})}if(g(s.max)||s.ngMax){var y;u.$validators.max=function(t){return!h(t)||m(y)||r(t)<=y},s.$observe("max",function(t){y=$(t),u.$validate()})}}}function _n(t,e,r,i){var o=e[0],a=i.$$hasNativeValidators=y(o.validity);a&&i.$parsers.push(function(t){var r=e.prop(Yn)||{};return r.badInput&&!r.typeMismatch?n:t})}function In(t,e,r,i,o,a){if(_n(t,e,r,i),Dn(t,e,r,i,o,a),i.$$parserName="number",i.$parsers.push(function(t){return i.$isEmpty(t)?null:Ui.test(t)?parseFloat(t):n}),i.$formatters.push(function(t){if(!i.$isEmpty(t)){if(!b(t))throw wo("numfmt","Expected ` + "`" + `{0}` + "`" + ` to be a number",t);t=t.toString()}return t}),g(r.min)||r.ngMin){var s;i.$validators.min=function(t){return i.$isEmpty(t)||m(s)||t>=s},r.$observe("min",function(t){g(t)&&!b(t)&&(t=parseFloat(t,10)),s=b(t)&&!isNaN(t)?t:n,i.$validate()})}if(g(r.max)||r.ngMax){var u;i.$validators.max=function(t){return i.$isEmpty(t)||m(u)||u>=t},r.$observe("max",function(t){g(t)&&!b(t)&&(t=parseFloat(t,10)),u=b(t)&&!isNaN(t)?t:n,i.$validate()})}}function qn(t,e,n,r,i,o){Dn(t,e,n,r,i,o),Nn(r),r.$$parserName="url",r.$validators.url=function(t,e){var n=t||e;return r.$isEmpty(n)||Ii.test(n)}}function Un(t,e,n,r,i,o){Dn(t,e,n,r,i,o),Nn(r),r.$$parserName="email",r.$validators.email=function(t,e){var n=t||e;return r.$isEmpty(n)||qi.test(n)}}function Fn(t,e,n,r){m(n.name)&&e.attr("name",c());var i=function(t){e[0].checked&&r.$setViewValue(n.value,t&&t.type)};e.on("click",i),r.$render=function(){var t=n.value;e[0].checked=t==r.$viewValue},n.$observe("value",r.$render)}function Hn(t,e,n,i,o){var a;if(g(i)){if(a=t(i),!a.constant)throw r("ngModel")("constexpr","Expected constant expression for ` + "`" + `{0}` + "`" + `, but saw ` + "`" + `{1}` + "`" + `.",n,i);return a(e)}return o}function Ln(t,e,n,r,i,o,a,s){var u=Hn(s,t,"ngTrueValue",n.ngTrueValue,!0),c=Hn(s,t,"ngFalseValue",n.ngFalseValue,!1),l=function(t){r.$setViewValue(e[0].checked,t&&t.type)};e.on("click",l),r.$render=function(){e[0].checked=r.$viewValue},r.$isEmpty=function(t){return t===!1},r.$formatters.push(function(t){return I(t,u)}),r.$parsers.push(function(t){return t?u:c})}function Bn(t,e){return t="ngClass"+t,["$animate",function(n){function r(t,e){var n=[];t:for(var r=0;r<t.length;r++){for(var i=t[r],o=0;o<e.length;o++)if(i==e[o])continue t;n.push(i)}return n}function i(t){if(hr(t))return t;if(w(t))return t.split(" ");if(y(t)){var e=[];return o(t,function(t,n){t&&(e=e.concat(n.split(" ")))}),e}return t}return{restrict:"AC",link:function(a,s,u){function c(t){var e=f(t,1);u.$addClass(e)}function l(t){var e=f(t,-1);u.$removeClass(e)}function f(t,e){var n=s.data("$classCounts")||{},r=[];return o(t,function(t){(e>0||n[t])&&(n[t]=(n[t]||0)+e,n[t]===+(e>0)&&r.push(t))}),s.data("$classCounts",n),r.join(" ")}function h(t,e){var i=r(e,t),o=r(t,e);i=f(i,1),o=f(o,-1),i&&i.length&&n.addClass(s,i),o&&o.length&&n.removeClass(s,o)}function $(t){if(e===!0||a.$index%2===e){var n=i(t||[]);if(p){if(!I(t,p)){var r=i(p);h(r,n)}}else c(n)}p=_(t)}var p;a.$watch(u[t],$,!0),u.$observe("class",function(e){$(a.$eval(u[t]))}),"ngClass"!==t&&a.$watch("$index",function(n,r){var o=1&n;if(o!==(1&r)){var s=i(a.$eval(u[t]));o===e?c(s):l(s)}})}}}]}function zn(t){function e(t,e,u){e===n?r("$pending",t,u):i("$pending",t,u),M(e)?e?(f(s.$error,t,u),l(s.$$success,t,u)):(l(s.$error,t,u),f(s.$$success,t,u)):(f(s.$error,t,u),f(s.$$success,t,u)),s.$pending?(o(yo,!0),s.$valid=s.$invalid=n,a("",null)):(o(yo,!1),s.$valid=Gn(s.$error),s.$invalid=!s.$valid,a("",s.$valid));var c;c=s.$pending&&s.$pending[t]?n:s.$error[t]?!1:s.$$success[t]?!0:null,a(t,c),h.$setValidity(t,c,s)}function r(t,e,n){s[t]||(s[t]={}),l(s[t],e,n)}function i(t,e,r){s[t]&&f(s[t],e,r),Gn(s[t])&&(s[t]=n)}function o(t,e){e&&!c[t]?($.addClass(u,t),c[t]=!0):!e&&c[t]&&($.removeClass(u,t),c[t]=!1)}function a(t,e){t=t?"-"+nt(t,"-"):"",o(ho+t,e===!0),o($o+t,e===!1)}var s=t.ctrl,u=t.$element,c={},l=t.set,f=t.unset,h=t.parentForm,$=t.$animate;c[$o]=!(c[ho]=u.hasClass(ho)),s.$setValidity=e}function Gn(t){if(t)for(var e in t)return!1;return!0}var Wn=/^\/(.+)\/([a-z]*)$/,Yn="validity",Jn=function(t){return w(t)?t.toLowerCase():t},Zn=Object.prototype.hasOwnProperty,Kn=function(t){return w(t)?t.toUpperCase():t},Xn=function(t){return w(t)?t.replace(/[A-Z]/g,function(t){return String.fromCharCode(32|t.charCodeAt(0))}):t},Qn=function(t){return w(t)?t.replace(/[a-z]/g,function(t){return String.fromCharCode(-33&t.charCodeAt(0))}):t};"i"!=="I".toLowerCase()&&(Jn=Xn,Kn=Qn);var tr,er,nr,rr,ir=[].slice,or=[].splice,ar=[].push,sr=Object.prototype.toString,ur=r("ng"),cr=t.angular||(t.angular={}),lr=0;tr=e.documentMode,p.$inject=[],d.$inject=[];var fr,hr=Array.isArray,$r=function(t){return w(t)?t.trim():t},pr=function(t){return t.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")},dr=function(){if(g(dr.isActive_))return dr.isActive_;var t=!(!e.querySelector("[ng-csp]")&&!e.querySelector("[data-ng-csp]"));if(!t)try{new Function("")}catch(n){t=!0}return dr.isActive_=t},vr=["ng-","data-ng-","ng:","x-ng-"],mr=/[A-Z]/g,gr=!1,yr=1,wr=3,br=8,xr=9,Sr=11,Cr={full:"1.3.15",major:1,minor:3,dot:15,codeName:"locality-filtration"};wt.expando="ng339";var Ar=wt.cache={},Er=1,kr=function(t,e,n){t.addEventListener(e,n,!1)},Or=function(t,e,n){t.removeEventListener(e,n,!1)};wt._data=function(t){return this.cache[t[this.expando]]||{}};var Tr=/([\:\-\_]+(.))/g,Mr=/^moz([A-Z])/,Nr={mouseleave:"mouseout",mouseenter:"mouseover"},Vr=r("jqLite"),Dr=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,jr=/<|&#?\w+;/,Rr=/<([\w:]+)/,Pr=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,_r={option:[1,'<select multiple="multiple">',"</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};_r.optgroup=_r.option,_r.tbody=_r.tfoot=_r.colgroup=_r.caption=_r.thead,_r.th=_r.td;var Ir=wt.prototype={ready:function(n){function r(){i||(i=!0,n())}var i=!1;"complete"===e.readyState?setTimeout(r):(this.on("DOMContentLoaded",r),wt(t).on("load",r))},toString:function(){var t=[];return o(this,function(e){t.push(""+e)}),"["+t.join(", ")+"]"},eq:function(t){return er(t>=0?this[t]:this[this.length+t])},length:0,push:ar,sort:[].sort,splice:[].splice},qr={};o("multiple,selected,checked,disabled,readOnly,required,open".split(","),function(t){qr[Jn(t)]=t});var Ur={};o("input,select,option,textarea,button,form,details".split(","),function(t){Ur[t]=!0});var Fr={ngMinlength:"minlength",ngMaxlength:"maxlength",ngMin:"min",ngMax:"max",ngPattern:"pattern"};o({data:Et,removeData:Ct},function(t,e){wt[e]=t}),o({data:Et,inheritedData:Vt,scope:function(t){return er.data(t,"$scope")||Vt(t.parentNode||t,["$isolateScope","$scope"])},isolateScope:function(t){return er.data(t,"$isolateScope")||er.data(t,"$isolateScopeNoTemplate")},controller:Nt,injector:function(t){return Vt(t,"$injector")},removeAttr:function(t,e){t.removeAttribute(e)},hasClass:kt,css:function(t,e,n){return e=dt(e),g(n)?void(t.style[e]=n):t.style[e]},attr:function(t,e,r){var i=Jn(e);if(qr[i]){if(!g(r))return t[e]||(t.attributes.getNamedItem(e)||p).specified?i:n;r?(t[e]=!0,t.setAttribute(e,i)):(t[e]=!1,t.removeAttribute(i))}else if(g(r))t.setAttribute(e,r);else if(t.getAttribute){var o=t.getAttribute(e,2);return null===o?n:o}},prop:function(t,e,n){return g(n)?void(t[e]=n):t[e]},text:function(){function t(t,e){if(m(e)){var n=t.nodeType;return n===yr||n===wr?t.textContent:""}t.textContent=e}return t.$dv="",t}(),val:function(t,e){if(m(e)){if(t.multiple&&"select"===j(t)){var n=[];return o(t.options,function(t){t.selected&&n.push(t.value||t.text)}),0===n.length?null:n}return t.value}t.value=e},html:function(t,e){return m(e)?t.innerHTML:(xt(t,!0),void(t.innerHTML=e))},empty:Dt},function(t,e){wt.prototype[e]=function(e,r){var i,o,a=this.length;if(t!==Dt&&(2==t.length&&t!==kt&&t!==Nt?e:r)===n){if(y(e)){for(i=0;a>i;i++)if(t===Et)t(this[i],e);else for(o in e)t(this[i],o,e[o]);return this}for(var s=t.$dv,u=s===n?Math.min(a,1):a,c=0;u>c;c++){var l=t(this[c],e,r);s=s?s+l:l}return s}for(i=0;a>i;i++)t(this[i],e,r);return this}}),o({removeData:Ct,on:function Wo(t,e,n,r){if(g(r))throw Vr("onargs","jqLite#on() does not support the ` + "`" + `selector` + "`" + ` or ` + "`" + `eventData` + "`" + ` parameters");if(mt(t)){var i=At(t,!0),o=i.events,a=i.handle;a||(a=i.handle=It(t,o));for(var s=e.indexOf(" ")>=0?e.split(" "):[e],u=s.length;u--;){e=s[u];var c=o[e];c||(o[e]=[],"mouseenter"===e||"mouseleave"===e?Wo(t,Nr[e],function(t){var n=this,r=t.relatedTarget;(!r||r!==n&&!n.contains(r))&&a(t,e)}):"$destroy"!==e&&kr(t,e,a),c=o[e]),c.push(n)}}},off:St,one:function(t,e,n){t=er(t),t.on(e,function r(){t.off(e,n),t.off(e,r)}),t.on(e,n)},replaceWith:function(t,e){var n,r=t.parentNode;xt(t),o(new wt(e),function(e){n?r.insertBefore(e,n.nextSibling):r.replaceChild(e,t),n=e})},children:function(t){var e=[];return o(t.childNodes,function(t){t.nodeType===yr&&e.push(t)}),e},contents:function(t){return t.contentDocument||t.childNodes||[]},append:function(t,e){var n=t.nodeType;if(n===yr||n===Sr){e=new wt(e);for(var r=0,i=e.length;i>r;r++){var o=e[r];t.appendChild(o)}}},prepend:function(t,e){if(t.nodeType===yr){var n=t.firstChild;o(new wt(e),function(e){t.insertBefore(e,n)})}},wrap:function(t,e){e=er(e).eq(0).clone()[0];var n=t.parentNode;n&&n.replaceChild(e,t),e.appendChild(t)},remove:jt,detach:function(t){jt(t,!0)},after:function(t,e){var n=t,r=t.parentNode;e=new wt(e);for(var i=0,o=e.length;o>i;i++){var a=e[i];r.insertBefore(a,n.nextSibling),n=a}},addClass:Tt,removeClass:Ot,toggleClass:function(t,e,n){e&&o(e.split(" "),function(e){var r=n;m(r)&&(r=!kt(t,e)),(r?Tt:Ot)(t,e)})},parent:function(t){var e=t.parentNode;return e&&e.nodeType!==Sr?e:null},next:function(t){return t.nextElementSibling},find:function(t,e){return t.getElementsByTagName?t.getElementsByTagName(e):[]},clone:bt,triggerHandler:function(t,e,n){var r,i,a,s=e.type||e,u=At(t),c=u&&u.events,l=c&&c[s];l&&(r={preventDefault:function(){this.defaultPrevented=!0},isDefaultPrevented:function(){return this.defaultPrevented===!0},stopImmediatePropagation:function(){this.immediatePropagationStopped=!0},isImmediatePropagationStopped:function(){return this.immediatePropagationStopped===!0},stopPropagation:p,type:s,target:t},e.type&&(r=f(r,e)),i=_(l),a=n?[r].concat(n):[r],o(i,function(e){r.isImmediatePropagationStopped()||e.apply(t,a)}))}},function(t,e){wt.prototype[e]=function(e,n,r){for(var i,o=0,a=this.length;a>o;o++)m(i)?(i=t(this[o],e,n,r),g(i)&&(i=er(i))):Mt(i,t(this[o],e,n,r));return g(i)?i:this},wt.prototype.bind=wt.prototype.on,wt.prototype.unbind=wt.prototype.off}),Ft.prototype={put:function(t,e){this[Ut(t,this.nextUid)]=e},get:function(t){return this[Ut(t,this.nextUid)]},remove:function(t){var e=this[t=Ut(t,this.nextUid)];return delete this[t],e}};var Hr=/^function\s*[^\(]*\(\s*([^\)]*)\)/m,Lr=/,/,Br=/^\s*(_?)(\S+?)\1\s*$/,zr=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm,Gr=r("$injector");Bt.$$annotate=Lt;var Wr=r("$animate"),Yr=["$provide",function(t){this.$$selectors={},this.register=function(e,n){var r=e+"-animation";if(e&&"."!=e.charAt(0))throw Wr("notcsel","Expecting class selector starting with '.' got '{0}'.",e);this.$$selectors[e.substr(1)]=r,t.factory(r,n)},this.classNameFilter=function(t){return 1===arguments.length&&(this.$$classNameFilter=t instanceof RegExp?t:null),this.$$classNameFilter},this.$get=["$$q","$$asyncCallback","$rootScope",function(t,e,n){function r(e){var r,i=t.defer();return i.promise.$$cancelFn=function(){r&&r()},n.$$postDigest(function(){r=e(function(){i.resolve()})}),i.promise}function i(t,e){var n=[],r=[],i=ct();return o((t.attr("class")||"").split(/\s+/),function(t){i[t]=!0}),o(e,function(t,e){var o=i[e];t===!1&&o?r.push(e):t!==!0||o||n.push(e)}),n.length+r.length>0&&[n.length?n:null,r.length?r:null]}function a(t,e,n){for(var r=0,i=e.length;i>r;++r){var o=e[r];t[o]=n}}function s(){return c||(c=t.defer(),e(function(){c.resolve(),c=null})),c.promise}function u(t,e){if(cr.isObject(e)){var n=f(e.from||{},e.to||{});t.css(n)}}var c;return{animate:function(t,e,n){return u(t,{from:e,to:n}),s()},enter:function(t,e,n,r){return u(t,r),n?n.after(t):e.prepend(t),s()},leave:function(t,e){return u(t,e),t.remove(),s()},move:function(t,e,n,r){return this.enter(t,e,n,r)},addClass:function(t,e,n){return this.setClass(t,e,[],n)},$$addClassImmediately:function(t,e,n){return t=er(t),e=w(e)?e:hr(e)?e.join(" "):"",o(t,function(t){Tt(t,e)}),u(t,n),s()},removeClass:function(t,e,n){return this.setClass(t,[],e,n)},$$removeClassImmediately:function(t,e,n){return t=er(t),e=w(e)?e:hr(e)?e.join(" "):"",o(t,function(t){Ot(t,e)}),u(t,n),s()},setClass:function(t,e,n,o){var s=this,u="$$animateClasses",c=!1;t=er(t);var l=t.data(u);l?o&&l.options&&(l.options=cr.extend(l.options||{},o)):(l={classes:{},options:o},c=!0);var f=l.classes;return e=hr(e)?e:e.split(" "),n=hr(n)?n:n.split(" "),a(f,e,!0),a(f,n,!1),c&&(l.promise=r(function(e){var n=t.data(u);if(t.removeData(u),n){var r=i(t,n.classes);r&&s.$$setClassImmediately(t,r[0],r[1],n.options)}e()}),t.data(u,l)),l.promise},$$setClassImmediately:function(t,e,n,r){
return e&&this.$$addClassImmediately(t,e),n&&this.$$removeClassImmediately(t,n),u(t,r),s()},enabled:p,cancel:p}}]}],Jr=r("$compile");Kt.$inject=["$provide","$$sanitizeUriProvider"];var Zr=/^((?:x|data)[\:\-_])/i,Kr=r("$controller"),Xr="application/json",Qr={"Content-Type":Xr+";charset=utf-8"},ti=/^\[|^\{(?!\{)/,ei={"[":/]$/,"{":/}$/},ni=/^\)\]\}',?\n/,ri=r("$interpolate"),ii=/^([^\?#]*)(\?([^#]*))?(#(.*))?$/,oi={http:80,https:443,ftp:21},ai=r("$location"),si={$$html5:!1,$$replace:!1,absUrl:Oe("$$absUrl"),url:function(t){if(m(t))return this.$$url;var e=ii.exec(t);return(e[1]||""===t)&&this.path(decodeURIComponent(e[1])),(e[2]||e[1]||""===t)&&this.search(e[3]||""),this.hash(e[5]||""),this},protocol:Oe("$$protocol"),host:Oe("$$host"),port:Oe("$$port"),path:Te("$$path",function(t){return t=null!==t?t.toString():"","/"==t.charAt(0)?t:"/"+t}),search:function(t,e){switch(arguments.length){case 0:return this.$$search;case 1:if(w(t)||b(t))t=t.toString(),this.$$search=W(t);else{if(!y(t))throw ai("isrcharg","The first argument of the ` + "`" + `$location#search()` + "`" + ` call must be a string or an object.");t=P(t,{}),o(t,function(e,n){null==e&&delete t[n]}),this.$$search=t}break;default:m(e)||null===e?delete this.$$search[t]:this.$$search[t]=e}return this.$$compose(),this},hash:Te("$$hash",function(t){return null!==t?t.toString():""}),replace:function(){return this.$$replace=!0,this}};o([ke,Ee,Ae],function(t){t.prototype=Object.create(si),t.prototype.state=function(e){if(!arguments.length)return this.$$state;if(t!==Ae||!this.$$html5)throw ai("nostate","History API state support is available only in HTML5 mode and only in browsers supporting HTML5 History API");return this.$$state=m(e)?null:e,this}});var ui=r("$parse"),ci=Function.prototype.call,li=Function.prototype.apply,fi=Function.prototype.bind,hi=ct();o({"null":function(){return null},"true":function(){return!0},"false":function(){return!1},undefined:function(){}},function(t,e){t.constant=t.literal=t.sharedGetter=!0,hi[e]=t}),hi["this"]=function(t){return t},hi["this"].sharedGetter=!0;var $i=f(ct(),{"+":function(t,e,r,i){return r=r(t,e),i=i(t,e),g(r)?g(i)?r+i:r:g(i)?i:n},"-":function(t,e,n,r){return n=n(t,e),r=r(t,e),(g(n)?n:0)-(g(r)?r:0)},"*":function(t,e,n,r){return n(t,e)*r(t,e)},"/":function(t,e,n,r){return n(t,e)/r(t,e)},"%":function(t,e,n,r){return n(t,e)%r(t,e)},"===":function(t,e,n,r){return n(t,e)===r(t,e)},"!==":function(t,e,n,r){return n(t,e)!==r(t,e)},"==":function(t,e,n,r){return n(t,e)==r(t,e)},"!=":function(t,e,n,r){return n(t,e)!=r(t,e)},"<":function(t,e,n,r){return n(t,e)<r(t,e)},">":function(t,e,n,r){return n(t,e)>r(t,e)},"<=":function(t,e,n,r){return n(t,e)<=r(t,e)},">=":function(t,e,n,r){return n(t,e)>=r(t,e)},"&&":function(t,e,n,r){return n(t,e)&&r(t,e)},"||":function(t,e,n,r){return n(t,e)||r(t,e)},"!":function(t,e,n){return!n(t,e)},"=":!0,"|":!0}),pi={n:"\n",f:"\f",r:"\r",t:"	",v:"","'":"'",'"':'"'},di=function(t){this.options=t};di.prototype={constructor:di,lex:function(t){for(this.text=t,this.index=0,this.tokens=[];this.index<this.text.length;){var e=this.text.charAt(this.index);if('"'===e||"'"===e)this.readString(e);else if(this.isNumber(e)||"."===e&&this.isNumber(this.peek()))this.readNumber();else if(this.isIdent(e))this.readIdent();else if(this.is(e,"(){}[].,;:?"))this.tokens.push({index:this.index,text:e}),this.index++;else if(this.isWhitespace(e))this.index++;else{var n=e+this.peek(),r=n+this.peek(2),i=$i[e],o=$i[n],a=$i[r];if(i||o||a){var s=a?r:o?n:e;this.tokens.push({index:this.index,text:s,operator:!0}),this.index+=s.length}else this.throwError("Unexpected next character ",this.index,this.index+1)}}return this.tokens},is:function(t,e){return-1!==e.indexOf(t)},peek:function(t){var e=t||1;return this.index+e<this.text.length?this.text.charAt(this.index+e):!1},isNumber:function(t){return t>="0"&&"9">=t&&"string"==typeof t},isWhitespace:function(t){return" "===t||"\r"===t||"	"===t||"\n"===t||""===t||" "===t},isIdent:function(t){return t>="a"&&"z">=t||t>="A"&&"Z">=t||"_"===t||"$"===t},isExpOperator:function(t){return"-"===t||"+"===t||this.isNumber(t)},throwError:function(t,e,n){n=n||this.index;var r=g(e)?"s "+e+"-"+this.index+" ["+this.text.substring(e,n)+"]":" "+n;throw ui("lexerr","Lexer Error: {0} at column{1} in expression [{2}].",t,r,this.text)},readNumber:function(){for(var t="",e=this.index;this.index<this.text.length;){var n=Jn(this.text.charAt(this.index));if("."==n||this.isNumber(n))t+=n;else{var r=this.peek();if("e"==n&&this.isExpOperator(r))t+=n;else if(this.isExpOperator(n)&&r&&this.isNumber(r)&&"e"==t.charAt(t.length-1))t+=n;else{if(!this.isExpOperator(n)||r&&this.isNumber(r)||"e"!=t.charAt(t.length-1))break;this.throwError("Invalid exponent")}}this.index++}this.tokens.push({index:e,text:t,constant:!0,value:Number(t)})},readIdent:function(){for(var t=this.index;this.index<this.text.length;){var e=this.text.charAt(this.index);if(!this.isIdent(e)&&!this.isNumber(e))break;this.index++}this.tokens.push({index:t,text:this.text.slice(t,this.index),identifier:!0})},readString:function(t){var e=this.index;this.index++;for(var n="",r=t,i=!1;this.index<this.text.length;){var o=this.text.charAt(this.index);if(r+=o,i){if("u"===o){var a=this.text.substring(this.index+1,this.index+5);a.match(/[\da-f]{4}/i)||this.throwError("Invalid unicode escape [\\u"+a+"]"),this.index+=4,n+=String.fromCharCode(parseInt(a,16))}else{var s=pi[o];n+=s||o}i=!1}else if("\\"===o)i=!0;else{if(o===t)return this.index++,void this.tokens.push({index:e,text:r,constant:!0,value:n});n+=o}this.index++}this.throwError("Unterminated quote",e)}};var vi=function(t,e,n){this.lexer=t,this.$filter=e,this.options=n};vi.ZERO=f(function(){return 0},{sharedGetter:!0,constant:!0}),vi.prototype={constructor:vi,parse:function(t){this.text=t,this.tokens=this.lexer.lex(t);var e=this.statements();return 0!==this.tokens.length&&this.throwError("is an unexpected token",this.tokens[0]),e.literal=!!e.literal,e.constant=!!e.constant,e},primary:function(){var t;this.expect("(")?(t=this.filterChain(),this.consume(")")):this.expect("[")?t=this.arrayDeclaration():this.expect("{")?t=this.object():this.peek().identifier&&this.peek().text in hi?t=hi[this.consume().text]:this.peek().identifier?t=this.identifier():this.peek().constant?t=this.constant():this.throwError("not a primary expression",this.peek());for(var e,n;e=this.expect("(","[",".");)"("===e.text?(t=this.functionCall(t,n),n=null):"["===e.text?(n=t,t=this.objectIndex(t)):"."===e.text?(n=t,t=this.fieldAccess(t)):this.throwError("IMPOSSIBLE");return t},throwError:function(t,e){throw ui("syntax","Syntax Error: Token '{0}' {1} at column {2} of the expression [{3}] starting at [{4}].",e.text,t,e.index+1,this.text,this.text.substring(e.index))},peekToken:function(){if(0===this.tokens.length)throw ui("ueoe","Unexpected end of expression: {0}",this.text);return this.tokens[0]},peek:function(t,e,n,r){return this.peekAhead(0,t,e,n,r)},peekAhead:function(t,e,n,r,i){if(this.tokens.length>t){var o=this.tokens[t],a=o.text;if(a===e||a===n||a===r||a===i||!e&&!n&&!r&&!i)return o}return!1},expect:function(t,e,n,r){var i=this.peek(t,e,n,r);return i?(this.tokens.shift(),i):!1},consume:function(t){if(0===this.tokens.length)throw ui("ueoe","Unexpected end of expression: {0}",this.text);var e=this.expect(t);return e||this.throwError("is unexpected, expecting ["+t+"]",this.peek()),e},unaryFn:function(t,e){var n=$i[t];return f(function(t,r){return n(t,r,e)},{constant:e.constant,inputs:[e]})},binaryFn:function(t,e,n,r){var i=$i[e];return f(function(e,r){return i(e,r,t,n)},{constant:t.constant&&n.constant,inputs:!r&&[t,n]})},identifier:function(){for(var t=this.consume().text;this.peek(".")&&this.peekAhead(1).identifier&&!this.peekAhead(2,"(");)t+=this.consume().text+this.consume().text;return Ue(t,this.options,this.text)},constant:function(){var t=this.consume().value;return f(function(){return t},{constant:!0,literal:!0})},statements:function(){for(var t=[];;)if(this.tokens.length>0&&!this.peek("}",")",";","]")&&t.push(this.filterChain()),!this.expect(";"))return 1===t.length?t[0]:function(e,n){for(var r,i=0,o=t.length;o>i;i++)r=t[i](e,n);return r}},filterChain:function(){for(var t,e=this.expression();t=this.expect("|");)e=this.filter(e);return e},filter:function(t){var e,r,i=this.$filter(this.consume().text);if(this.peek(":"))for(e=[],r=[];this.expect(":");)e.push(this.expression());var o=[t].concat(e||[]);return f(function(o,a){var s=t(o,a);if(r){r[0]=s;for(var u=e.length;u--;)r[u+1]=e[u](o,a);return i.apply(n,r)}return i(s)},{constant:!i.$stateful&&o.every(Re),inputs:!i.$stateful&&o})},expression:function(){return this.assignment()},assignment:function(){var t,e,n=this.ternary();return(e=this.expect("="))?(n.assign||this.throwError("implies assignment but ["+this.text.substring(0,e.index)+"] can not be assigned to",e),t=this.ternary(),f(function(e,r){return n.assign(e,t(e,r),r)},{inputs:[n,t]})):n},ternary:function(){var t,e,n=this.logicalOR();if((e=this.expect("?"))&&(t=this.assignment(),this.consume(":"))){var r=this.assignment();return f(function(e,i){return n(e,i)?t(e,i):r(e,i)},{constant:n.constant&&t.constant&&r.constant})}return n},logicalOR:function(){for(var t,e=this.logicalAND();t=this.expect("||");)e=this.binaryFn(e,t.text,this.logicalAND(),!0);return e},logicalAND:function(){for(var t,e=this.equality();t=this.expect("&&");)e=this.binaryFn(e,t.text,this.equality(),!0);return e},equality:function(){for(var t,e=this.relational();t=this.expect("==","!=","===","!==");)e=this.binaryFn(e,t.text,this.relational());return e},relational:function(){for(var t,e=this.additive();t=this.expect("<",">","<=",">=");)e=this.binaryFn(e,t.text,this.additive());return e},additive:function(){for(var t,e=this.multiplicative();t=this.expect("+","-");)e=this.binaryFn(e,t.text,this.multiplicative());return e},multiplicative:function(){for(var t,e=this.unary();t=this.expect("*","/","%");)e=this.binaryFn(e,t.text,this.unary());return e},unary:function(){var t;return this.expect("+")?this.primary():(t=this.expect("-"))?this.binaryFn(vi.ZERO,t.text,this.unary()):(t=this.expect("!"))?this.unaryFn(t.text,this.unary()):this.primary()},fieldAccess:function(t){var e=this.identifier();return f(function(r,i,o){var a=o||t(r,i);return null==a?n:e(a)},{assign:function(n,r,i){var o=t(n,i);return o||t.assign(n,o={},i),e.assign(o,r)}})},objectIndex:function(t){var e=this.text,r=this.expression();return this.consume("]"),f(function(i,o){var a,s=t(i,o),u=r(i,o);return Ve(u,e),s?a=De(s[u],e):n},{assign:function(n,i,o){var a=Ve(r(n,o),e),s=De(t(n,o),e);return s||t.assign(n,s={},o),s[a]=i}})},functionCall:function(t,e){var r=[];if(")"!==this.peekToken().text)do r.push(this.expression());while(this.expect(","));this.consume(")");var i=this.text,o=r.length?[]:null;return function(a,s){var u=e?e(a,s):g(e)?n:a,c=t(a,s,u)||p;if(o)for(var l=r.length;l--;)o[l]=De(r[l](a,s),i);De(u,i),je(c,i);var f=c.apply?c.apply(u,o):c(o[0],o[1],o[2],o[3],o[4]);return o&&(o.length=0),De(f,i)}},arrayDeclaration:function(){var t=[];if("]"!==this.peekToken().text)do{if(this.peek("]"))break;t.push(this.expression())}while(this.expect(","));return this.consume("]"),f(function(e,n){for(var r=[],i=0,o=t.length;o>i;i++)r.push(t[i](e,n));return r},{literal:!0,constant:t.every(Re),inputs:t})},object:function(){var t=[],e=[];if("}"!==this.peekToken().text)do{if(this.peek("}"))break;var n=this.consume();n.constant?t.push(n.value):n.identifier?t.push(n.text):this.throwError("invalid key",n),this.consume(":"),e.push(this.expression())}while(this.expect(","));return this.consume("}"),f(function(n,r){for(var i={},o=0,a=e.length;a>o;o++)i[t[o]]=e[o](n,r);return i},{literal:!0,constant:e.every(Re),inputs:e})}};var mi=ct(),gi=ct(),yi=Object.prototype.valueOf,wi=r("$sce"),bi={HTML:"html",CSS:"css",URL:"url",RESOURCE_URL:"resourceUrl",JS:"js"},Jr=r("$compile"),xi=e.createElement("a"),Si=rn(t.location.href);sn.$inject=["$provide"],fn.$inject=["$locale"],hn.$inject=["$locale"];var Ci=".",Ai={yyyy:dn("FullYear",4),yy:dn("FullYear",2,0,!0),y:dn("FullYear",1),MMMM:vn("Month"),MMM:vn("Month",!0),MM:dn("Month",2,1),M:dn("Month",1,1),dd:dn("Date",2),d:dn("Date",1),HH:dn("Hours",2),H:dn("Hours",1),hh:dn("Hours",2,-12),h:dn("Hours",1,-12),mm:dn("Minutes",2),m:dn("Minutes",1),ss:dn("Seconds",2),s:dn("Seconds",1),sss:dn("Milliseconds",3),EEEE:vn("Day"),EEE:vn("Day",!0),a:bn,Z:mn,ww:wn(2),w:wn(1),G:xn,GG:xn,GGG:xn,GGGG:Sn},Ei=/((?:[^yMdHhmsaZEwG']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z|G+|w+))(.*)/,ki=/^\-?\d+$/;Cn.$inject=["$locale"];var Oi=v(Jn),Ti=v(Kn);kn.$inject=["$parse"];var Mi=v({restrict:"E",compile:function(t,e){return e.href||e.xlinkHref||e.name?void 0:function(t,e){if("a"===e[0].nodeName.toLowerCase()){var n="[object SVGAnimatedString]"===sr.call(e.prop("href"))?"xlink:href":"href";e.on("click",function(t){e.attr(n)||t.preventDefault()})}}}}),Ni={};o(qr,function(t,e){if("multiple"!=t){var n=Xt("ng-"+e);Ni[n]=function(){return{restrict:"A",priority:100,link:function(t,r,i){t.$watch(i[n],function(t){i.$set(e,!!t)})}}}}}),o(Fr,function(t,e){Ni[e]=function(){return{priority:100,link:function(t,n,r){if("ngPattern"===e&&"/"==r.ngPattern.charAt(0)){var i=r.ngPattern.match(Wn);if(i)return void r.$set("ngPattern",new RegExp(i[1],i[2]))}t.$watch(r[e],function(t){r.$set(e,t)})}}}}),o(["src","srcset","href"],function(t){var e=Xt("ng-"+t);Ni[e]=function(){return{priority:99,link:function(n,r,i){var o=t,a=t;"href"===t&&"[object SVGAnimatedString]"===sr.call(r.prop("href"))&&(a="xlinkHref",i.$attr[a]="xlink:href",o=null),i.$observe(e,function(e){return e?(i.$set(a,e),void(tr&&o&&r.prop(o,i[a]))):void("href"===t&&i.$set(a,null))})}}}});var Vi={$addControl:p,$$renameControl:Tn,$removeControl:p,$setValidity:p,$setDirty:p,$setPristine:p,$setSubmitted:p},Di="ng-submitted";Mn.$inject=["$element","$attrs","$scope","$animate","$interpolate"];var ji=function(t){return["$timeout",function(e){var r={name:"form",restrict:t?"EAC":"E",controller:Mn,compile:function(r,i){r.addClass(po).addClass(ho);var o=i.name?"name":t&&i.ngForm?"ngForm":!1;return{pre:function(t,r,i,a){if(!("action"in i)){var s=function(e){t.$apply(function(){a.$commitViewValue(),a.$setSubmitted()}),e.preventDefault()};kr(r[0],"submit",s),r.on("$destroy",function(){e(function(){Or(r[0],"submit",s)},0,!1)})}var u=a.$$parentForm;o&&(Pe(t,null,a.$name,a,a.$name),i.$observe(o,function(e){a.$name!==e&&(Pe(t,null,a.$name,n,a.$name),u.$$renameControl(a,e),Pe(t,null,a.$name,a,a.$name))})),r.on("$destroy",function(){u.$removeControl(a),o&&Pe(t,null,i[o],n,a.$name),f(a,Vi)})}}}};return r}]},Ri=ji(),Pi=ji(!0),_i=/\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z)/,Ii=/^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/,qi=/^[a-z0-9!#$%&'*+\/=?^_` + "`" + `{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i,Ui=/^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/,Fi=/^(\d{4})-(\d{2})-(\d{2})$/,Hi=/^(\d{4})-(\d\d)-(\d\d)T(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/,Li=/^(\d{4})-W(\d\d)$/,Bi=/^(\d{4})-(\d\d)$/,zi=/^(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/,Gi={text:Vn,date:Pn("date",Fi,Rn(Fi,["yyyy","MM","dd"]),"yyyy-MM-dd"),"datetime-local":Pn("datetimelocal",Hi,Rn(Hi,["yyyy","MM","dd","HH","mm","ss","sss"]),"yyyy-MM-ddTHH:mm:ss.sss"),time:Pn("time",zi,Rn(zi,["HH","mm","ss","sss"]),"HH:mm:ss.sss"),week:Pn("week",Li,jn,"yyyy-Www"),month:Pn("month",Bi,Rn(Bi,["yyyy","MM"]),"yyyy-MM"),number:In,url:qn,email:Un,radio:Fn,checkbox:Ln,hidden:p,button:p,submit:p,reset:p,file:p},Wi=["$browser","$sniffer","$filter","$parse",function(t,e,n,r){return{restrict:"E",require:["?ngModel"],link:{pre:function(i,o,a,s){s[0]&&(Gi[Jn(a.type)]||Gi.text)(i,o,a,s[0],e,t,n,r)}}}}],Yi=/^(true|false|\d+)$/,Ji=function(){return{restrict:"A",priority:100,compile:function(t,e){return Yi.test(e.ngValue)?function(t,e,n){n.$set("value",t.$eval(n.ngValue))}:function(t,e,n){t.$watch(n.ngValue,function(t){n.$set("value",t)})}}}},Zi=["$compile",function(t){return{restrict:"AC",compile:function(e){return t.$$addBindingClass(e),function(e,r,i){t.$$addBindingInfo(r,i.ngBind),r=r[0],e.$watch(i.ngBind,function(t){r.textContent=t===n?"":t})}}}}],Ki=["$interpolate","$compile",function(t,e){return{compile:function(r){return e.$$addBindingClass(r),function(r,i,o){var a=t(i.attr(o.$attr.ngBindTemplate));e.$$addBindingInfo(i,a.expressions),i=i[0],o.$observe("ngBindTemplate",function(t){i.textContent=t===n?"":t})}}}}],Xi=["$sce","$parse","$compile",function(t,e,n){return{restrict:"A",compile:function(r,i){var o=e(i.ngBindHtml),a=e(i.ngBindHtml,function(t){return(t||"").toString()});return n.$$addBindingClass(r),function(e,r,i){n.$$addBindingInfo(r,i.ngBindHtml),e.$watch(a,function(){r.html(t.getTrustedHtml(o(e))||"")})}}}}],Qi=v({restrict:"A",require:"ngModel",link:function(t,e,n,r){r.$viewChangeListeners.push(function(){t.$eval(n.ngChange)})}}),to=Bn("",!0),eo=Bn("Odd",0),no=Bn("Even",1),ro=On({compile:function(t,e){e.$set("ngCloak",n),t.removeClass("ng-cloak")}}),io=[function(){return{restrict:"A",scope:!0,controller:"@",priority:500}}],oo={},ao={blur:!0,focus:!0};o("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "),function(t){var e=Xt("ng-"+t);oo[e]=["$parse","$rootScope",function(n,r){return{restrict:"A",compile:function(i,o){var a=n(o[e],null,!0);return function(e,n){n.on(t,function(n){var i=function(){a(e,{$event:n})};ao[t]&&r.$$phase?e.$evalAsync(i):e.$apply(i)})}}}}]});var so=["$animate",function(t){return{multiElement:!0,transclude:"element",priority:600,terminal:!0,restrict:"A",$$tlb:!0,link:function(n,r,i,o,a){var s,u,c;n.$watch(i.ngIf,function(n){n?u||a(function(n,o){u=o,n[n.length++]=e.createComment(" end ngIf: "+i.ngIf+" "),s={clone:n},t.enter(n,r.parent(),r)}):(c&&(c.remove(),c=null),u&&(u.$destroy(),u=null),s&&(c=ut(s.clone),t.leave(c).then(function(){c=null}),s=null))})}}}],uo=["$templateRequest","$anchorScroll","$animate","$sce",function(t,e,n,r){return{restrict:"ECA",priority:400,terminal:!0,transclude:"element",controller:cr.noop,compile:function(i,o){var a=o.ngInclude||o.src,s=o.onload||"",u=o.autoscroll;return function(i,o,c,l,f){var h,$,p,d=0,v=function(){$&&($.remove(),$=null),h&&(h.$destroy(),h=null),p&&(n.leave(p).then(function(){$=null}),$=p,p=null)};i.$watch(r.parseAsResourceUrl(a),function(r){var a=function(){!g(u)||u&&!i.$eval(u)||e()},c=++d;r?(t(r,!0).then(function(t){if(c===d){var e=i.$new();l.template=t;var u=f(e,function(t){v(),n.enter(t,null,o).then(a)});h=e,p=u,h.$emit("$includeContentLoaded",r),i.$eval(s)}},function(){c===d&&(v(),i.$emit("$includeContentError",r))}),i.$emit("$includeContentRequested",r)):(v(),l.template=null)})}}}}],co=["$compile",function(t){return{restrict:"ECA",priority:-400,require:"ngInclude",link:function(n,r,i,o){return/SVG/.test(r[0].toString())?(r.empty(),void t(gt(o.template,e).childNodes)(n,function(t){r.append(t)},{futureParentElement:r})):(r.html(o.template),void t(r.contents())(n))}}}],lo=On({priority:450,compile:function(){return{pre:function(t,e,n){t.$eval(n.ngInit)}}}}),fo=function(){return{restrict:"A",priority:100,require:"ngModel",link:function(t,e,r,i){var a=e.attr(r.$attr.ngList)||", ",s="false"!==r.ngTrim,u=s?$r(a):a,c=function(t){if(!m(t)){var e=[];return t&&o(t.split(u),function(t){t&&e.push(s?$r(t):t)}),e}};i.$parsers.push(c),i.$formatters.push(function(t){return hr(t)?t.join(a):n}),i.$isEmpty=function(t){return!t||!t.length}}}},ho="ng-valid",$o="ng-invalid",po="ng-pristine",vo="ng-dirty",mo="ng-untouched",go="ng-touched",yo="ng-pending",wo=new r("ngModel"),bo=["$scope","$exceptionHandler","$attrs","$element","$parse","$animate","$timeout","$rootScope","$q","$interpolate",function(t,e,r,i,a,s,u,c,l,f){this.$viewValue=Number.NaN,this.$modelValue=Number.NaN,this.$$rawModelValue=n,this.$validators={},this.$asyncValidators={},this.$parsers=[],this.$formatters=[],this.$viewChangeListeners=[],this.$untouched=!0,this.$touched=!1,this.$pristine=!0,this.$dirty=!1,this.$valid=!0,this.$invalid=!1,this.$error={},this.$$success={},this.$pending=n,this.$name=f(r.name||"",!1)(t);var h,$=a(r.ngModel),d=$.assign,v=$,y=d,w=null,x=this;this.$$setOptions=function(t){if(x.$options=t,t&&t.getterSetter){var e=a(r.ngModel+"()"),n=a(r.ngModel+"($$$p)");v=function(t){var n=$(t);return S(n)&&(n=e(t)),n},y=function(t,e){S($(t))?n(t,{$$$p:x.$modelValue}):d(t,x.$modelValue)}}else if(!$.assign)throw wo("nonassign","Expression '{0}' is non-assignable. Element: {1}",r.ngModel,z(i))},this.$render=p,this.$isEmpty=function(t){return m(t)||""===t||null===t||t!==t};var C=i.inheritedData("$formController")||Vi,A=0;zn({ctrl:this,$element:i,set:function(t,e){t[e]=!0},unset:function(t,e){delete t[e]},parentForm:C,$animate:s}),this.$setPristine=function(){x.$dirty=!1,x.$pristine=!0,s.removeClass(i,vo),s.addClass(i,po)},this.$setDirty=function(){x.$dirty=!0,x.$pristine=!1,s.removeClass(i,po),s.addClass(i,vo),C.$setDirty()},this.$setUntouched=function(){x.$touched=!1,x.$untouched=!0,s.setClass(i,mo,go)},this.$setTouched=function(){x.$touched=!0,x.$untouched=!1,s.setClass(i,go,mo)},this.$rollbackViewValue=function(){u.cancel(w),x.$viewValue=x.$$lastCommittedViewValue,x.$render()},this.$validate=function(){if(!b(x.$modelValue)||!isNaN(x.$modelValue)){var t=x.$$lastCommittedViewValue,e=x.$$rawModelValue,r=x.$valid,i=x.$modelValue,o=x.$options&&x.$options.allowInvalid;x.$$runValidators(e,t,function(t){o||r===t||(x.$modelValue=t?e:n,x.$modelValue!==i&&x.$$writeModelToScope())})}},this.$$runValidators=function(t,e,r){function i(){var t=x.$$parserName||"parse";return h!==n?(h||(o(x.$validators,function(t,e){u(e,null)}),o(x.$asyncValidators,function(t,e){u(e,null)})),u(t,h),h):(u(t,null),!0)}function a(){var n=!0;return o(x.$validators,function(r,i){var o=r(t,e);n=n&&o,u(i,o)}),n?!0:(o(x.$asyncValidators,function(t,e){u(e,null)}),!1)}function s(){var r=[],i=!0;o(x.$asyncValidators,function(o,a){var s=o(t,e);if(!N(s))throw wo("$asyncValidators","Expected asynchronous validator to return a promise but got '{0}' instead.",s);u(a,n),r.push(s.then(function(){u(a,!0)},function(t){i=!1,u(a,!1)}))}),r.length?l.all(r).then(function(){c(i)},p):c(!0)}function u(t,e){f===A&&x.$setValidity(t,e)}function c(t){f===A&&r(t)}A++;var f=A;return i()&&a()?void s():void c(!1)},this.$commitViewValue=function(){var t=x.$viewValue;u.cancel(w),(x.$$lastCommittedViewValue!==t||""===t&&x.$$hasNativeValidators)&&(x.$$lastCommittedViewValue=t,x.$pristine&&this.$setDirty(),this.$$parseAndValidate())},this.$$parseAndValidate=function(){function e(){x.$modelValue!==a&&x.$$writeModelToScope()}var r=x.$$lastCommittedViewValue,i=r;if(h=m(i)?n:!0)for(var o=0;o<x.$parsers.length;o++)if(i=x.$parsers[o](i),m(i)){h=!1;break}b(x.$modelValue)&&isNaN(x.$modelValue)&&(x.$modelValue=v(t));var a=x.$modelValue,s=x.$options&&x.$options.allowInvalid;x.$$rawModelValue=i,s&&(x.$modelValue=i,e()),x.$$runValidators(i,x.$$lastCommittedViewValue,function(t){s||(x.$modelValue=t?i:n,e())})},this.$$writeModelToScope=function(){y(t,x.$modelValue),o(x.$viewChangeListeners,function(t){try{t()}catch(n){e(n)}})},this.$setViewValue=function(t,e){x.$viewValue=t,(!x.$options||x.$options.updateOnDefault)&&x.$$debounceViewValueCommit(e)},this.$$debounceViewValueCommit=function(e){var n,r=0,i=x.$options;i&&g(i.debounce)&&(n=i.debounce,b(n)?r=n:b(n[e])?r=n[e]:b(n["default"])&&(r=n["default"])),u.cancel(w),r?w=u(function(){x.$commitViewValue()},r):c.$$phase?x.$commitViewValue():t.$apply(function(){x.$commitViewValue()})},t.$watch(function(){var e=v(t);if(e!==x.$modelValue){x.$modelValue=x.$$rawModelValue=e,h=n;for(var r=x.$formatters,i=r.length,o=e;i--;)o=r[i](o);x.$viewValue!==o&&(x.$viewValue=x.$$lastCommittedViewValue=o,x.$render(),x.$$runValidators(e,o,p))}return e})}],xo=["$rootScope",function(t){return{restrict:"A",require:["ngModel","^?form","^?ngModelOptions"],controller:bo,priority:1,compile:function(e){return e.addClass(po).addClass(mo).addClass(ho),{pre:function(t,e,n,r){var i=r[0],o=r[1]||Vi;i.$$setOptions(r[2]&&r[2].$options),o.$addControl(i),n.$observe("name",function(t){i.$name!==t&&o.$$renameControl(i,t)}),t.$on("$destroy",function(){o.$removeControl(i)})},post:function(e,n,r,i){var o=i[0];o.$options&&o.$options.updateOn&&n.on(o.$options.updateOn,function(t){o.$$debounceViewValueCommit(t&&t.type)}),n.on("blur",function(n){o.$touched||(t.$$phase?e.$evalAsync(o.$setTouched):e.$apply(o.$setTouched))})}}}}}],So=/(\s+|^)default(\s+|$)/,Co=function(){return{restrict:"A",controller:["$scope","$attrs",function(t,e){var r=this;this.$options=t.$eval(e.ngModelOptions),this.$options.updateOn!==n?(this.$options.updateOnDefault=!1,this.$options.updateOn=$r(this.$options.updateOn.replace(So,function(){return r.$options.updateOnDefault=!0," "}))):this.$options.updateOnDefault=!0}]}},Ao=On({terminal:!0,priority:1e3}),Eo=["$locale","$interpolate",function(t,e){var n=/{}/g,r=/^when(Minus)?(.+)$/;return{restrict:"EA",link:function(i,a,s){function u(t){a.text(t||"")}var c,l=s.count,f=s.$attr.when&&a.attr(s.$attr.when),h=s.offset||0,$=i.$eval(f)||{},p={},d=e.startSymbol(),v=e.endSymbol(),m=d+l+"-"+h+v,g=cr.noop;o(s,function(t,e){var n=r.exec(e);if(n){var i=(n[1]?"-":"")+Jn(n[2]);$[i]=a.attr(s.$attr[e])}}),o($,function(t,r){p[r]=e(t.replace(n,m))}),i.$watch(l,function(e){var n=parseFloat(e),r=isNaN(n);r||n in $||(n=t.pluralCat(n-h)),n===c||r&&isNaN(c)||(g(),g=i.$watch(p[n],u),c=n)})}}}],ko=["$parse","$animate",function(t,a){var s="$$NG_REMOVED",u=r("ngRepeat"),c=function(t,e,n,r,i,o,a){t[n]=r,i&&(t[i]=o),t.$index=e,t.$first=0===e,t.$last=e===a-1,t.$middle=!(t.$first||t.$last),t.$odd=!(t.$even=0===(1&e))},l=function(t){return t.clone[0]},f=function(t){return t.clone[t.clone.length-1]};return{restrict:"A",multiElement:!0,transclude:"element",priority:1e3,terminal:!0,$$tlb:!0,compile:function(r,h){var $=h.ngRepeat,p=e.createComment(" end ngRepeat: "+$+" "),d=$.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);if(!d)throw u("iexp","Expected expression in form of '_item_ in _collection_[ track by _id_]' but got '{0}'.",$);var v=d[1],m=d[2],g=d[3],y=d[4];if(d=v.match(/^(?:(\s*[\$\w]+)|\(\s*([\$\w]+)\s*,\s*([\$\w]+)\s*\))$/),!d)throw u("iidexp","'_item_' in '_item_ in _collection_' should be an identifier or '(_key_, _value_)' expression, but got '{0}'.",v);var w=d[3]||d[1],b=d[2];if(g&&(!/^[$a-zA-Z_][$a-zA-Z0-9_]*$/.test(g)||/^(null|undefined|this|\$index|\$first|\$middle|\$last|\$even|\$odd|\$parent|\$root|\$id)$/.test(g)))throw u("badident","alias '{0}' is invalid --- must be a valid JS identifier which is not a reserved name.",g);var x,S,C,A,E={$id:Ut};return y?x=t(y):(C=function(t,e){return Ut(e)},A=function(t){return t}),function(t,e,r,h,d){x&&(S=function(e,n,r){return b&&(E[b]=e),E[w]=n,E.$index=r,x(t,E)});var v=ct();t.$watchCollection(m,function(r){var h,m,y,x,E,k,O,T,M,N,V,D,j=e[0],R=ct();if(g&&(t[g]=r),i(r))M=r,T=S||C;else{T=S||A,M=[];for(var P in r)r.hasOwnProperty(P)&&"$"!=P.charAt(0)&&M.push(P);M.sort()}for(x=M.length,V=new Array(x),h=0;x>h;h++)if(E=r===M?h:M[h],k=r[E],O=T(E,k,h),v[O])N=v[O],delete v[O],R[O]=N,V[h]=N;else{if(R[O])throw o(V,function(t){t&&t.scope&&(v[t.id]=t)}),u("dupes","Duplicates in a repeater are not allowed. Use 'track by' expression to specify unique keys. Repeater: {0}, Duplicate key: {1}, Duplicate value: {2}",$,O,k);V[h]={id:O,scope:n,clone:n},R[O]=!0}for(var _ in v){if(N=v[_],D=ut(N.clone),a.leave(D),D[0].parentNode)for(h=0,m=D.length;m>h;h++)D[h][s]=!0;N.scope.$destroy()}for(h=0;x>h;h++)if(E=r===M?h:M[h],k=r[E],N=V[h],N.scope){y=j;do y=y.nextSibling;while(y&&y[s]);l(N)!=y&&a.move(ut(N.clone),null,er(j)),j=f(N),c(N.scope,h,w,k,b,E,x)}else d(function(t,e){N.scope=e;var n=p.cloneNode(!1);t[t.length++]=n,a.enter(t,null,er(j)),j=n,N.clone=t,R[N.id]=N,c(N.scope,h,w,k,b,E,x)});v=R})}}}}],Oo="ng-hide",To="ng-hide-animate",Mo=["$animate",function(t){return{restrict:"A",multiElement:!0,link:function(e,n,r){e.$watch(r.ngShow,function(e){t[e?"removeClass":"addClass"](n,Oo,{tempClasses:To})})}}}],No=["$animate",function(t){return{restrict:"A",multiElement:!0,link:function(e,n,r){e.$watch(r.ngHide,function(e){t[e?"addClass":"removeClass"](n,Oo,{tempClasses:To})})}}}],Vo=On(function(t,e,n){t.$watchCollection(n.ngStyle,function(t,n){n&&t!==n&&o(n,function(t,n){e.css(n,"")}),t&&e.css(t)})}),Do=["$animate",function(t){return{restrict:"EA",require:"ngSwitch",controller:["$scope",function(){this.cases={}}],link:function(n,r,i,a){var s=i.ngSwitch||i.on,u=[],c=[],l=[],f=[],h=function(t,e){return function(){t.splice(e,1)}};n.$watch(s,function(n){var r,i;for(r=0,i=l.length;i>r;++r)t.cancel(l[r]);for(l.length=0,r=0,i=f.length;i>r;++r){var s=ut(c[r].clone);f[r].$destroy();var $=l[r]=t.leave(s);$.then(h(l,r))}c.length=0,f.length=0,(u=a.cases["!"+n]||a.cases["?"])&&o(u,function(n){n.transclude(function(r,i){f.push(i);var o=n.element;r[r.length++]=e.createComment(" end ngSwitchWhen: ");var a={clone:r};c.push(a),t.enter(r,o.parent(),o)})})})}}}],jo=On({transclude:"element",priority:1200,require:"^ngSwitch",multiElement:!0,link:function(t,e,n,r,i){r.cases["!"+n.ngSwitchWhen]=r.cases["!"+n.ngSwitchWhen]||[],r.cases["!"+n.ngSwitchWhen].push({transclude:i,element:e})}}),Ro=On({transclude:"element",priority:1200,require:"^ngSwitch",multiElement:!0,link:function(t,e,n,r,i){r.cases["?"]=r.cases["?"]||[],r.cases["?"].push({transclude:i,element:e})}}),Po=On({restrict:"EAC",link:function(t,e,n,i,o){if(!o)throw r("ngTransclude")("orphan","Illegal use of ngTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}",z(e));o(function(t){e.empty(),e.append(t)})}}),_o=["$templateCache",function(t){return{restrict:"E",terminal:!0,compile:function(e,n){if("text/ng-template"==n.type){var r=n.id,i=e[0].text;t.put(r,i)}}}}],Io=r("ngOptions"),qo=v({restrict:"A",terminal:!0}),Uo=["$compile","$parse",function(t,r){var i=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/,s={$setViewValue:p};return{restrict:"E",require:["select","?ngModel"],controller:["$element","$scope","$attrs",function(t,e,n){var r,i,o=this,a={},u=s;o.databound=n.ngModel,o.init=function(t,e,n){u=t,r=e,i=n},o.addOption=function(e,n){at(e,'"option value"'),a[e]=!0,u.$viewValue==e&&(t.val(e),i.parent()&&i.remove()),n&&n[0].hasAttribute("selected")&&(n[0].selected=!0)},o.removeOption=function(t){this.hasOption(t)&&(delete a[t],u.$viewValue===t&&this.renderUnknownOption(t))},o.renderUnknownOption=function(e){var n="? "+Ut(e)+" ?";i.val(n),t.prepend(i),t.val(n),i.prop("selected",!0)},o.hasOption=function(t){return a.hasOwnProperty(t)},e.$on("$destroy",function(){o.renderUnknownOption=p})}],link:function(s,u,c,l){function f(t,e,n,r){n.$render=function(){var t=n.$viewValue;r.hasOption(t)?(A.parent()&&A.remove(),e.val(t),""===t&&p.prop("selected",!0)):m(t)&&p?e.val(""):r.renderUnknownOption(t)},e.on("change",function(){t.$apply(function(){A.parent()&&A.remove(),n.$setViewValue(e.val())})})}function h(t,e,n){var r;n.$render=function(){var t=new Ft(n.$viewValue);o(e.find("option"),function(e){e.selected=g(t.get(e.value))})},t.$watch(function(){I(r,n.$viewValue)||(r=_(n.$viewValue),n.$render())}),e.on("change",function(){t.$apply(function(){var t=[];o(e.find("option"),function(e){e.selected&&t.push(e.value)}),n.$setViewValue(t)})})}function $(e,s,u){function c(t,n,r){return I[k]=r,M&&(I[M]=n),t(e,I)}function l(){e.$apply(function(){var t,n=D(e)||[];if(y)t=[],o(s.val(),function(e){e=R?P[e]:e,t.push(f(e,n[e]))});else{var r=R?P[s.val()]:s.val();t=f(r,n[r])}u.$setViewValue(t),m()})}function f(t,e){if("?"===t)return n;if(""===t)return null;var r=T?T:V;return c(r,t,e)}function h(){var t,n=D(e);if(n&&hr(n)){t=new Array(n.length);for(var r=0,i=n.length;i>r;r++)t[r]=c(E,r,n[r]);return t}if(n){t={};for(var o in n)n.hasOwnProperty(o)&&(t[o]=c(E,o,n[o]))}return t}function $(t){
var e;if(y)if(R&&hr(t)){e=new Ft([]);for(var n=0;n<t.length;n++)e.put(c(R,null,t[n]),!0)}else e=new Ft(t);else R&&(t=c(R,null,t));return function(n,r){var i;return i=R?R:T?T:V,y?g(e.remove(c(i,n,r))):t===c(i,n,r)}}function p(){x||(e.$$postDigest(m),x=!0)}function v(t,e,n){t[e]=t[e]||0,t[e]+=n?1:-1}function m(){x=!1;var t,n,r,i,l,f,h,p,m,w,A,k,O,T,V,j,q,U={"":[]},F=[""],H=u.$viewValue,L=D(e)||[],B=M?a(L):L,z={},G=$(H),W=!1;for(P={},k=0;w=B.length,w>k;k++)h=k,M&&(h=B[k],"$"===h.charAt(0))||(p=L[h],t=c(N,h,p)||"",(n=U[t])||(n=U[t]=[],F.push(t)),O=G(h,p),W=W||O,j=c(E,h,p),j=g(j)?j:"",q=R?R(e,I):M?B[k]:k,R&&(P[q]=h),n.push({id:q,label:j,selected:O}));for(y||(b||null===H?U[""].unshift({id:"",label:"",selected:!W}):W||U[""].unshift({id:"?",label:"",selected:!0})),A=0,m=F.length;m>A;A++){for(t=F[A],n=U[t],_.length<=A?(i={element:C.clone().attr("label",t),label:n.label},l=[i],_.push(l),s.append(i.element)):(l=_[A],i=l[0],i.label!=t&&i.element.attr("label",i.label=t)),T=null,k=0,w=n.length;w>k;k++)r=n[k],(f=l[k+1])?(T=f.element,f.label!==r.label&&(v(z,f.label,!1),v(z,r.label,!0),T.text(f.label=r.label),T.prop("label",f.label)),f.id!==r.id&&T.val(f.id=r.id),T[0].selected!==r.selected&&(T.prop("selected",f.selected=r.selected),tr&&T.prop("selected",f.selected))):(""===r.id&&b?V=b:(V=S.clone()).val(r.id).prop("selected",r.selected).attr("selected",r.selected).prop("label",r.label).text(r.label),l.push(f={element:V,label:r.label,id:r.id,selected:r.selected}),v(z,r.label,!0),T?T.after(V):i.element.append(V),T=V);for(k++;l.length>k;)r=l.pop(),v(z,r.label,!1),r.element.remove()}for(;_.length>A;){for(n=_.pop(),k=1;k<n.length;++k)v(z,n[k].label,!1);n[0].element.remove()}o(z,function(t,e){t>0?d.addOption(e):0>t&&d.removeOption(e)})}var A;if(!(A=w.match(i)))throw Io("iexp","Expected expression in form of '_select_ (as _label_)? for (_key_,)?_value_ in _collection_' but got '{0}'. Element: {1}",w,z(s));var E=r(A[2]||A[1]),k=A[4]||A[6],O=/ as /.test(A[0])&&A[1],T=O?r(O):null,M=A[5],N=r(A[3]||""),V=r(A[2]?A[1]:k),D=r(A[7]),j=A[8],R=j?r(A[8]):null,P={},_=[[{element:s,label:""}]],I={};b&&(t(b)(e),b.removeClass("ng-scope"),b.remove()),s.empty(),s.on("change",l),u.$render=m,e.$watchCollection(D,p),e.$watchCollection(h,p),y&&e.$watchCollection(function(){return u.$modelValue},p)}if(l[1]){for(var p,d=l[0],v=l[1],y=c.multiple,w=c.ngOptions,b=!1,x=!1,S=er(e.createElement("option")),C=er(e.createElement("optgroup")),A=S.clone(),E=0,k=u.children(),O=k.length;O>E;E++)if(""===k[E].value){p=b=k.eq(E);break}d.init(v,b,A),y&&(v.$isEmpty=function(t){return!t||0===t.length}),w?$(s,u,v):y?h(s,u,v):f(s,u,v,d)}}}}],Fo=["$interpolate",function(t){var e={addOption:p,removeOption:p};return{restrict:"E",priority:100,compile:function(n,r){if(m(r.value)){var i=t(n.text(),!0);i||r.$set("value",n.text())}return function(t,n,r){var o="$selectController",a=n.parent(),s=a.data(o)||a.parent().data(o);s&&s.databound||(s=e),i?t.$watch(i,function(t,e){r.$set("value",t),e!==t&&s.removeOption(e),s.addOption(t,n)}):s.addOption(r.value,n),n.on("$destroy",function(){s.removeOption(r.value)})}}}}],Ho=v({restrict:"E",terminal:!1}),Lo=function(){return{restrict:"A",require:"?ngModel",link:function(t,e,n,r){r&&(n.required=!0,r.$validators.required=function(t,e){return!n.required||!r.$isEmpty(e)},n.$observe("required",function(){r.$validate()}))}}},Bo=function(){return{restrict:"A",require:"?ngModel",link:function(t,e,i,o){if(o){var a,s=i.ngPattern||i.pattern;i.$observe("pattern",function(t){if(w(t)&&t.length>0&&(t=new RegExp("^"+t+"$")),t&&!t.test)throw r("ngPattern")("noregexp","Expected {0} to be a RegExp but was {1}. Element: {2}",s,t,z(e));a=t||n,o.$validate()}),o.$validators.pattern=function(t){return o.$isEmpty(t)||m(a)||a.test(t)}}}}},zo=function(){return{restrict:"A",require:"?ngModel",link:function(t,e,n,r){if(r){var i=-1;n.$observe("maxlength",function(t){var e=h(t);i=isNaN(e)?-1:e,r.$validate()}),r.$validators.maxlength=function(t,e){return 0>i||r.$isEmpty(e)||e.length<=i}}}}},Go=function(){return{restrict:"A",require:"?ngModel",link:function(t,e,n,r){if(r){var i=0;n.$observe("minlength",function(t){i=h(t)||0,r.$validate()}),r.$validators.minlength=function(t,e){return r.$isEmpty(e)||e.length>=i}}}}};return t.angular.bootstrap?void console.log("WARNING: Tried to load angular more than once."):(rt(),$t(cr),void er(e).ready(function(){X(e,Q)}))}(window,document),!window.angular.$$csp()&&window.angular.element(document).find("head").prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide:not(.ng-hide-animate){display:none !important;}ng\\:form{display:block;}</style>');
!function(o,n,e){"use strict";n.module("ngCookies",["ng"]).factory("$cookies",["$rootScope","$browser",function(o,i){function r(){var o,r,t,u;for(o in f)a(c[o])&&i.cookies(o,e);for(o in c)r=c[o],n.isString(r)||(r=""+r,c[o]=r),r!==f[o]&&(i.cookies(o,r),u=!0);if(u){u=!1,t=i.cookies();for(o in c)c[o]!==t[o]&&(a(t[o])?delete c[o]:c[o]=t[o],u=!0)}}var t,c={},f={},u=!1,s=n.copy,a=n.isUndefined;return i.addPollFn(function(){var n=i.cookies();t!=n&&(t=n,s(n,f),s(n,c),u&&o.$apply())})(),u=!0,o.$watch(r),c}]).factory("$cookieStore",["$cookies",function(o){return{get:function(e){var i=o[e];return i?n.fromJson(i):i},put:function(e,i){o[e]=n.toJson(i)},remove:function(n){delete o[n]}}}])}(window,window.angular);
!function(n,t,e){"use strict";t.module("ngAnimate",["ng"]).directive("ngAnimateChildren",function(){var n="$$ngAnimateChildren";return function(e,a,i){var r=i.ngAnimateChildren;t.isString(r)&&0===r.length?a.data(n,!0):e.$watch(r,function(t){a.data(n,!!t)})}}).factory("$$animateReflow",["$$rAF","$document",function(n,t){var e=t[0].body;return function(t){return n(function(){e.offsetWidth+1;t()})}}]).config(["$provide","$animateProvider",function(a,i){function r(n){for(var t=0;t<n.length;t++){var e=n[t];if(e.nodeType==p)return e}}function s(n){return n&&t.element(n)}function o(n){return t.element(r(n))}function u(n,t){return r(n)==r(t)}var l,c=t.noop,f=t.forEach,v=i.$$selectors,d=t.isArray,m=t.isString,g=t.isObject,p=1,C="$$ngAnimateState",h="$$ngAnimateChildren",$="ng-animate",b={running:!0};a.decorator("$animate",["$delegate","$$q","$injector","$sniffer","$rootElement","$$asyncCallback","$rootScope","$document","$templateRequest","$$jqLite",function(n,e,a,p,y,D,A,w,k,x){function S(n,t){var e=n.data(C)||{};return t&&(e.running=!0,e.structural=!0,n.data(C,e)),e.disabled||e.running&&e.structural}function B(n){var t,a=e.defer();return a.promise.$$cancelFn=function(){t&&t()},A.$$postDigest(function(){t=n(function(){a.resolve()})}),a.promise}function F(n){return g(n)?(n.tempClasses&&m(n.tempClasses)&&(n.tempClasses=n.tempClasses.split(/\s+/)),n):void 0}function M(n,t,e){e=e||{};var a={};f(e,function(n,t){f(t.split(" "),function(t){a[t]=n})});var i=Object.create(null);f((n.attr("class")||"").split(/\s+/),function(n){i[n]=!0});var r=[],s=[];return f(t&&t.classes||[],function(n,t){var e=i[t],o=a[t]||{};n===!1?(e||"addClass"==o.event)&&s.push(t):n===!0&&(e&&"removeClass"!=o.event||r.push(t))}),r.length+s.length>0&&[r.join(" "),s.join(" ")]}function E(n){if(n){var t=[],e={},i=n.substr(1).split(".");(p.transitions||p.animations)&&t.push(a.get(v[""]));for(var r=0;r<i.length;r++){var s=i[r],o=v[s];o&&!e[s]&&(t.push(a.get(o)),e[s]=!0)}return t}}function R(n,e,a,i){function r(n,t){var e=n[t],a=n["before"+t.charAt(0).toUpperCase()+t.substr(1)];return e||a?("leave"==t&&(a=e,e=null),D.push({event:t,fn:e}),$.push({event:t,fn:a}),!0):void 0}function s(t,e,r){function s(n){if(e){if((e[n]||c)(),++v<o.length)return;e=null}r()}var o=[];f(t,function(n){n.fn&&o.push(n)});var v=0;f(o,function(t,r){var o=function(){s(r)};switch(t.event){case"setClass":e.push(t.fn(n,u,l,o,i));break;case"animate":e.push(t.fn(n,a,i.from,i.to,o));break;case"addClass":e.push(t.fn(n,u||a,o,i));break;case"removeClass":e.push(t.fn(n,l||a,o,i));break;default:e.push(t.fn(n,o,i))}}),e&&0===e.length&&r()}var o=n[0];if(o){i&&(i.to=i.to||{},i.from=i.from||{});var u,l;d(a)&&(u=a[0],l=a[1],u?l?a=u+" "+l:(a=u,e="addClass"):(a=l,e="removeClass"));var v="setClass"==e,m=v||"addClass"==e||"removeClass"==e||"animate"==e,g=n.attr("class"),p=g+" "+a;if(K(p)){var C=c,h=[],$=[],b=c,y=[],D=[],A=(" "+p).replace(/\s+/g,".");return f(E(A),function(n){var t=r(n,e);!t&&v&&(r(n,"addClass"),r(n,"removeClass"))}),{node:o,event:e,className:a,isClassBased:m,isSetClassOperation:v,applyStyles:function(){i&&n.css(t.extend(i.from||{},i.to||{}))},before:function(n){C=n,s($,h,function(){C=c,n()})},after:function(n){b=n,s(D,y,function(){b=c,n()})},cancel:function(){h&&(f(h,function(n){(n||c)(!0)}),C(!0)),y&&(f(y,function(n){(n||c)(!0)}),b(!0))}}}}}function N(n,e,a,i,r,s,o,u){function v(t){var i="$animate:"+t;A&&A[i]&&A[i].length>0&&D(function(){a.triggerHandler(i,{event:n,className:e})})}function d(){v("before")}function m(){v("after")}function g(){v("close"),u()}function p(){p.hasBeenRun||(p.hasBeenRun=!0,s())}function h(){if(!h.hasBeenRun){y&&y.applyStyles(),h.hasBeenRun=!0,o&&o.tempClasses&&f(o.tempClasses,function(n){l.removeClass(a,n)});var t=a.data(C);t&&(y&&y.isClassBased?T(a,e):(D(function(){var t=a.data(C)||{};N==t.index&&T(a,e,n)}),a.data(C,t))),g()}}var b=c,y=R(a,n,e,o);if(!y)return p(),d(),m(),h(),b;n=y.event,e=y.className;var A=t.element._data(y.node);if(A=A&&A.events,i||(i=r?r.parent():a.parent()),j(a,i))return p(),d(),m(),h(),b;var w=a.data(C)||{},k=w.active||{},x=w.totalActive||0,S=w.last,B=!1;if(x>0){var F=[];if(y.isClassBased){if("setClass"==S.event)F.push(S),T(a,e);else if(k[e]){var M=k[e];M.event==n?B=!0:(F.push(M),T(a,e))}}else if("leave"==n&&k["ng-leave"])B=!0;else{for(var E in k)F.push(k[E]);w={},T(a,!0)}F.length>0&&f(F,function(n){n.cancel()})}if(!y.isClassBased||y.isSetClassOperation||"animate"==n||B||(B="addClass"==n==a.hasClass(e)),B)return p(),d(),m(),g(),b;k=w.active||{},x=w.totalActive||0,"leave"==n&&a.one("$destroy",function(n){var e=t.element(this),a=e.data(C);if(a){var i=a.active["ng-leave"];i&&(i.cancel(),T(e,"ng-leave"))}}),l.addClass(a,$),o&&o.tempClasses&&f(o.tempClasses,function(n){l.addClass(a,n)});var N=P++;return x++,k[e]=y,a.data(C,{last:y,active:k,index:N,totalActive:x}),d(),y.before(function(t){var i=a.data(C);t=t||!i||!i.active[e]||y.isClassBased&&i.active[e].event!=n,p(),t===!0?h():(m(),y.after(h))}),y.cancel}function O(n){var e=r(n);if(e){var a=t.isFunction(e.getElementsByClassName)?e.getElementsByClassName($):e.querySelectorAll("."+$);f(a,function(n){n=t.element(n);var e=n.data(C);e&&e.active&&f(e.active,function(n){n.cancel()})})}}function T(n,t){if(u(n,y))b.disabled||(b.running=!1,b.structural=!1);else if(t){var e=n.data(C)||{},a=t===!0;!a&&e.active&&e.active[t]&&(e.totalActive--,delete e.active[t]),(a||!e.totalActive)&&(l.removeClass(n,$),n.removeData(C))}}function j(n,e){if(b.disabled)return!0;if(u(n,y))return b.running;var a,i,r;do{if(0===e.length)break;var s=u(e,y),o=s?b:e.data(C)||{};if(o.disabled)return!0;if(s&&(r=!0),a!==!1){var l=e.data(h);t.isDefined(l)&&(a=l)}i=i||o.running||o.last&&!o.last.isClassBased}while(e=e.parent());return!r||!a&&i}l=x,y.data(C,b);var I=A.$watch(function(){return k.totalPendingRequests},function(n,t){0===n&&(I(),A.$$postDigest(function(){A.$$postDigest(function(){b.running=!1})}))}),P=0,q=i.classNameFilter(),K=q?function(n){return q.test(n)}:function(){return!0};return{animate:function(n,t,e,a,i){return a=a||"ng-inline-animate",i=F(i)||{},i.from=e?t:null,i.to=e?e:t,B(function(t){return N("animate",a,o(n),null,null,c,i,t)})},enter:function(e,a,i,r){return r=F(r),e=t.element(e),a=s(a),i=s(i),S(e,!0),n.enter(e,a,i),B(function(n){return N("enter","ng-enter",o(e),a,i,c,r,n)})},leave:function(e,a){return a=F(a),e=t.element(e),O(e),S(e,!0),B(function(t){return N("leave","ng-leave",o(e),null,null,function(){n.leave(e)},a,t)})},move:function(e,a,i,r){return r=F(r),e=t.element(e),a=s(a),i=s(i),O(e),S(e,!0),n.move(e,a,i),B(function(n){return N("move","ng-move",o(e),a,i,c,r,n)})},addClass:function(n,t,e){return this.setClass(n,t,[],e)},removeClass:function(n,t,e){return this.setClass(n,[],t,e)},setClass:function(e,a,i,s){s=F(s);var u="$$animateClasses";if(e=t.element(e),e=o(e),S(e))return n.$$setClassImmediately(e,a,i,s);var l,c=e.data(u),v=!!c;return c||(c={},c.classes={}),l=c.classes,a=d(a)?a:a.split(" "),f(a,function(n){n&&n.length&&(l[n]=!0)}),i=d(i)?i:i.split(" "),f(i,function(n){n&&n.length&&(l[n]=!1)}),v?(s&&c.options&&(c.options=t.extend(c.options||{},s)),c.promise):(e.data(u,c={classes:l,options:s}),c.promise=B(function(t){var a=e.parent(),i=r(e),s=i.parentNode;if(!s||s.$$NG_REMOVED||i.$$NG_REMOVED)return void t();var o=e.data(u);e.removeData(u);var l=e.data(C)||{},c=M(e,o,l.active);return c?N("setClass",c,e,a,null,function(){c[0]&&n.$$addClassImmediately(e,c[0]),c[1]&&n.$$removeClassImmediately(e,c[1])},o.options,t):t()}))},cancel:function(n){n.$$cancelFn()},enabled:function(n,t){switch(arguments.length){case 2:if(n)T(t);else{var e=t.data(C)||{};e.disabled=!0,t.data(C,e)}break;case 1:b.disabled=!n;break;default:n=!b.disabled}return!!n}}}]),i.register("",["$window","$sniffer","$timeout","$$animateReflow",function(a,i,s,o){function u(){T||(T=o(function(){z=[],T=null,L={}}))}function v(n,t){T&&T(),z.push(t),T=o(function(){f(z,function(n){n()}),z=[],T=null,L={}})}function g(n,e){var a=r(n);n=t.element(a),X.push(n);var i=Date.now()+e;Q>=i||(s.cancel(J),Q=i,J=s(function(){C(X),X=[]},e,!1))}function C(n){f(n,function(n){var t=n.data(_);t&&f(t.closeAnimationFns,function(n){n()})})}function h(n,t){var e=t?L[t]:null;if(!e){var i=0,r=0,s=0,o=0;f(n,function(n){if(n.nodeType==p){var t=a.getComputedStyle(n)||{},e=t[M+j];i=Math.max($(e),i);var u=t[M+P];r=Math.max($(u),r);{t[R+P]}o=Math.max($(t[R+P]),o);var l=$(t[R+j]);l>0&&(l*=parseInt(t[R+q],10)||1),s=Math.max(l,s)}}),e={total:0,transitionDelay:r,transitionDuration:i,animationDelay:o,animationDuration:s},t&&(L[t]=e)}return e}function $(n){var t=0,e=m(n)?n.split(/\s*,\s*/):[];return f(e,function(n){t=Math.max(parseFloat(n)||0,t)}),t}function b(n){var t=n.parent(),e=t.data(W);return e||(t.data(W,++U),e=U),e+"-"+r(n).getAttribute("class")}function y(n,t,e,a){var i=["ng-enter","ng-leave","ng-move"].indexOf(e)>=0,s=b(t),o=s+" "+e,u=L[o]?++L[o].total:0,c={};if(u>0){var f=e+"-stagger",v=s+" "+f,d=!L[v];d&&l.addClass(t,f),c=h(t,v),d&&l.removeClass(t,f)}l.addClass(t,e);var m=t.data(_)||{},g=h(t,o),p=g.transitionDuration,C=g.animationDuration;if(i&&0===p&&0===C)return l.removeClass(t,e),!1;var $=a||i&&p>0,y=C>0&&c.animationDelay>0&&0===c.animationDuration,D=m.closeAnimationFns||[];t.data(_,{stagger:c,cacheKey:o,running:m.running||0,itemIndex:u,blockTransition:$,closeAnimationFns:D});var k=r(t);return $&&(A(k,!0),a&&t.css(a)),y&&w(k,!0),!0}function D(n,t,e,a,i){function o(){t.off(P,u),l.removeClass(t,d),l.removeClass(t,m),j&&s.cancel(j),B(t,e);var n=r(t);for(var a in C)n.style.removeProperty(C[a])}function u(n){n.stopPropagation();var t=n.originalEvent||n,e=t.$manualTimeStamp||t.timeStamp||Date.now(),i=parseFloat(t.elapsedTime.toFixed(G));Math.max(e-I,0)>=R&&i>=F&&a()}var c=r(t),v=t.data(_);if(-1==c.getAttribute("class").indexOf(e)||!v)return void a();var d="",m="";f(e.split(" "),function(n,t){var e=(t>0?" ":"")+n;d+=e+"-active",m+=e+"-pending"});var p="",C=[],$=v.itemIndex,b=v.stagger,y=0;if($>0){var D=0;b.transitionDelay>0&&0===b.transitionDuration&&(D=b.transitionDelay*$);var k=0;b.animationDelay>0&&0===b.animationDuration&&(k=b.animationDelay*$,C.push(O+"animation-play-state")),y=Math.round(100*Math.max(D,k))/100}y||(l.addClass(t,d),v.blockTransition&&A(c,!1));var x=v.cacheKey+" "+d,S=h(t,x),F=Math.max(S.transitionDuration,S.animationDuration);if(0===F)return l.removeClass(t,d),B(t,e),void a();!y&&i&&Object.keys(i).length>0&&(S.transitionDuration||(t.css("transition",S.animationDuration+"s linear all"),C.push("transition")),t.css(i));var M=Math.max(S.transitionDelay,S.animationDelay),R=M*H;if(C.length>0){var T=c.getAttribute("style")||"";";"!==T.charAt(T.length-1)&&(T+=";"),c.setAttribute("style",T+" "+p)}var j,I=Date.now(),P=N+" "+E,q=(M+F)*V,K=(y+q)*H;return y>0&&(l.addClass(t,m),j=s(function(){j=null,S.transitionDuration>0&&A(c,!1),S.animationDuration>0&&w(c,!1),l.addClass(t,d),l.removeClass(t,m),i&&(0===S.transitionDuration&&t.css("transition",S.animationDuration+"s linear all"),t.css(i),C.push("transition"))},y*H,!1)),t.on(P,u),v.closeAnimationFns.push(function(){o(),a()}),v.running++,g(t,K),o}function A(n,t){n.style[M+I]=t?"none":""}function w(n,t){n.style[R+K]=t?"paused":""}function k(n,t,e,a){return y(n,t,e,a)?function(n){n&&B(t,e)}:void 0}function x(n,t,e,a,i){return t.data(_)?D(n,t,e,a,i):(B(t,e),void a())}function S(n,t,e,a,i){var r=k(n,t,e,i.from);if(!r)return u(),void a();var s=r;return v(t,function(){s=x(n,t,e,a,i.to)}),function(n){(s||c)(n)}}function B(n,t){l.removeClass(n,t);var e=n.data(_);e&&(e.running&&e.running--,e.running&&0!==e.running||n.removeData(_))}function F(n,t){var e="";return n=d(n)?n:n.split(/\s+/),f(n,function(n,a){n&&n.length>0&&(e+=(a>0?" ":"")+n+t)}),e}var M,E,R,N,O="";n.ontransitionend===e&&n.onwebkittransitionend!==e?(O="-webkit-",M="WebkitTransition",E="webkitTransitionEnd transitionend"):(M="transition",E="transitionend"),n.onanimationend===e&&n.onwebkitanimationend!==e?(O="-webkit-",R="WebkitAnimation",N="webkitAnimationEnd animationend"):(R="animation",N="animationend");var T,j="Duration",I="Property",P="Delay",q="IterationCount",K="PlayState",W="$$ngAnimateKey",_="$$ngAnimateCSS3Data",G=3,V=1.5,H=1e3,L={},U=0,z=[],J=null,Q=0,X=[];return{animate:function(n,t,e,a,i,r){return r=r||{},r.from=e,r.to=a,S("animate",n,t,i,r)},enter:function(n,t,e){return e=e||{},S("enter",n,"ng-enter",t,e)},leave:function(n,t,e){return e=e||{},S("leave",n,"ng-leave",t,e)},move:function(n,t,e){return e=e||{},S("move",n,"ng-move",t,e)},beforeSetClass:function(n,t,e,a,i){i=i||{};var r=F(e,"-remove")+" "+F(t,"-add"),s=k("setClass",n,r,i.from);return s?(v(n,a),s):(u(),void a())},beforeAddClass:function(n,t,e,a){a=a||{};var i=k("addClass",n,F(t,"-add"),a.from);return i?(v(n,e),i):(u(),void e())},beforeRemoveClass:function(n,t,e,a){a=a||{};var i=k("removeClass",n,F(t,"-remove"),a.from);return i?(v(n,e),i):(u(),void e())},setClass:function(n,t,e,a,i){i=i||{},e=F(e,"-remove"),t=F(t,"-add");var r=e+" "+t;return x("setClass",n,r,a,i.to)},addClass:function(n,t,e,a){return a=a||{},x("addClass",n,F(t,"-add"),e,a.to)},removeClass:function(n,t,e,a){return a=a||{},x("removeClass",n,F(t,"-remove"),e,a.to)}}}])}])}(window,window.angular);
"use strict";angular.module("yaru22.jsonHuman",["yaru22.jsonHuman.tmpls"]).factory("RecursionHelper",["$compile",function(t){var e={compile:function(e){var n,s=e.contents().remove();return function(e,a){n||(n=t(s)),n(e,function(t){a.append(t)});var r=e.json;e.isBoolean=_.isBoolean(r),e.isNumber=_.isNumber(r),e.isString=_.isString(r),e.isPrimitive=e.isBoolean||e.isNumber||e.isString,e.isObject=_.isPlainObject(r),e.isArray=_.isArray(r),e.isEmpty=_.isEmpty(r)}}};return e}]).directive("jsonHuman",function(){return{restrict:"A",scope:{data:"=jsonHuman"},templateUrl:"template/angular-json-human-root.tmpl",link:function(t){t.$watch("data",function(e){if("string"==typeof e)try{e=JSON.parse(e)}catch(n){}t.json=e,t.isObject=_.isPlainObject(e),t.isArray=_.isArray(e)})}}}).directive("jsonHumanHelper",["RecursionHelper",function(t){return{restrict:"A",scope:{json:"=jsonHumanHelper"},templateUrl:"template/angular-json-human.tmpl",compile:function(e){return t.compile(e)}}}]),angular.module("yaru22.jsonHuman.tmpls",[]).run(["$templateCache",function(t){t.put("template/angular-json-human-root.tmpl","<table class=jh-root ng-class=\"{ 'jh-type-array': isArray, 'jh-type-object': isObject }\" json-human-helper=json></table>"),t.put("template/angular-json-human.tmpl","<span ng-if=isPrimitive ng-class=\"{ 'jh-type-bool': isBoolean, 'jh-type-number': isNumber, 'jh-type-string': isString, 'jh-type-array': isArray, 'jh-type-object': isObject }\">{{ json }} <span ng-if=\"isEmpty && isString\" class=jh-empty>(Empty String)</span></span> <span ng-if=\"isEmpty && isArray\" class=jh-empty>(Empty List)</span> <span ng-if=\"isEmpty && isObject\" class=jh-empty>(Empty Object)</span><table ng-if=\"!isEmpty && !isPrimitive\" ng-class=\"{ 'jh-type-array': isArray, 'jh-type-object': isObject }\"><tbody><tr ng-repeat=\"(key, val) in json track by $index\"><th class=jh-key ng-class=\"{ 'jh-array-key': isArray, 'jh-object-key': isObject }\">{{ key }}</th><td class=jh-value ng-class=\"{ 'jh-array-value': isArray, 'jh-object-value': isObject }\" json-human-helper=val></td></tr></tbody></table>")}]);
!function(e,r,t){"use strict";function n(){function e(e,t){return r.extend(Object.create(e),t)}function t(e,r){var t=r.caseInsensitiveMatch,n={originalPath:e,regexp:e},a=n.keys=[];return e=e.replace(/([().])/g,"\\$1").replace(/(\/)?:(\w+)([\?\*])?/g,function(e,r,t,n){var o="?"===n?n:null,i="*"===n?n:null;return a.push({name:t,optional:!!o}),r=r||"",""+(o?"":r)+"(?:"+(o?r:"")+(i&&"(.+?)"||"([^/]+)")+(o||"")+")"+(o||"")}).replace(/([\/$\*])/g,"\\$1"),n.regexp=new RegExp("^"+e+"$",t?"i":""),n}var n={};this.when=function(e,a){var o=r.copy(a);if(r.isUndefined(o.reloadOnSearch)&&(o.reloadOnSearch=!0),r.isUndefined(o.caseInsensitiveMatch)&&(o.caseInsensitiveMatch=this.caseInsensitiveMatch),n[e]=r.extend(o,e&&t(e,o)),e){var i="/"==e[e.length-1]?e.substr(0,e.length-1):e+"/";n[i]=r.extend({redirectTo:e},t(i,o))}return this},this.caseInsensitiveMatch=!1,this.otherwise=function(e){return"string"==typeof e&&(e={redirectTo:e}),this.when(null,e),this},this.$get=["$rootScope","$location","$routeParams","$q","$injector","$templateRequest","$sce",function(t,a,o,i,c,l,s){function h(e,r){var t=r.keys,n={};if(!r.regexp)return null;var a=r.regexp.exec(e);if(!a)return null;for(var o=1,i=a.length;i>o;++o){var c=t[o-1],u=a[o];c&&u&&(n[c.name]=u)}return n}function $(e){var n=w.current;v=f(),m=v&&n&&v.$$route===n.$$route&&r.equals(v.pathParams,n.pathParams)&&!v.reloadOnSearch&&!g,m||!n&&!v||t.$broadcast("$routeChangeStart",v,n).defaultPrevented&&e&&e.preventDefault()}function p(){var e=w.current,n=v;m?(e.params=n.params,r.copy(e.params,o),t.$broadcast("$routeUpdate",e)):(n||e)&&(g=!1,w.current=n,n&&n.redirectTo&&(r.isString(n.redirectTo)?a.path(d(n.redirectTo,n.params)).search(n.params).replace():a.url(n.redirectTo(n.pathParams,a.path(),a.search())).replace()),i.when(n).then(function(){if(n){var e,t,a=r.extend({},n.resolve);return r.forEach(a,function(e,t){a[t]=r.isString(e)?c.get(e):c.invoke(e,null,null,t)}),r.isDefined(e=n.template)?r.isFunction(e)&&(e=e(n.params)):r.isDefined(t=n.templateUrl)&&(r.isFunction(t)&&(t=t(n.params)),t=s.getTrustedResourceUrl(t),r.isDefined(t)&&(n.loadedTemplateUrl=t,e=l(t))),r.isDefined(e)&&(a.$template=e),i.all(a)}}).then(function(a){n==w.current&&(n&&(n.locals=a,r.copy(n.params,o)),t.$broadcast("$routeChangeSuccess",n,e))},function(r){n==w.current&&t.$broadcast("$routeChangeError",n,e,r)}))}function f(){var t,o;return r.forEach(n,function(n,i){!o&&(t=h(a.path(),n))&&(o=e(n,{params:r.extend({},a.search(),t),pathParams:t}),o.$$route=n)}),o||n[null]&&e(n[null],{params:{},pathParams:{}})}function d(e,t){var n=[];return r.forEach((e||"").split(":"),function(e,r){if(0===r)n.push(e);else{var a=e.match(/(\w+)(?:[?*])?(.*)/),o=a[1];n.push(t[o]),n.push(a[2]||""),delete t[o]}}),n.join("")}var v,m,g=!1,w={routes:n,reload:function(){g=!0,t.$evalAsync(function(){$(),p()})},updateParams:function(e){if(!this.current||!this.current.$$route)throw u("norout","Tried updating route when with no current route");e=r.extend({},this.current.params,e),a.path(d(this.current.$$route.originalPath,e)),a.search(e)}};return t.$on("$locationChangeStart",$),t.$on("$locationChangeSuccess",p),w}]}function a(){this.$get=function(){return{}}}function o(e,t,n){return{restrict:"ECA",terminal:!0,priority:400,transclude:"element",link:function(a,o,i,c,u){function l(){p&&(n.cancel(p),p=null),h&&(h.$destroy(),h=null),$&&(p=n.leave($),p.then(function(){p=null}),$=null)}function s(){var i=e.current&&e.current.locals,c=i&&i.$template;if(r.isDefined(c)){var s=a.$new(),p=e.current,v=u(s,function(e){n.enter(e,null,$||o).then(function(){!r.isDefined(f)||f&&!a.$eval(f)||t()}),l()});$=v,h=p.scope=s,h.$emit("$viewContentLoaded"),h.$eval(d)}else l()}var h,$,p,f=i.autoscroll,d=i.onload||"";a.$on("$routeChangeSuccess",s),s()}}}function i(e,r,t){return{restrict:"ECA",priority:-400,link:function(n,a){var o=t.current,i=o.locals;a.html(i.$template);var c=e(a.contents());if(o.controller){i.$scope=n;var u=r(o.controller,i);o.controllerAs&&(n[o.controllerAs]=u),a.data("$ngControllerController",u),a.children().data("$ngControllerController",u)}c(n)}}}var c=r.module("ngRoute",["ng"]).provider("$route",n),u=r.$$minErr("ngRoute");c.provider("$routeParams",a),c.directive("ngView",o),c.directive("ngView",i),o.$inject=["$route","$anchorScroll","$animate"],i.$inject=["$compile","$controller","$route"]}(window,window.angular);
"use strict";!function(e){var t=e.module("door3.css",[]);t.config(["$logProvider",function(e){e.debugEnabled(!1)}]),t.provider("$css",[function(){var t=this.defaults={element:"link",rel:"stylesheet",type:"text/css",container:"head",method:"append",weight:0};this.$get=["$rootScope","$injector","$q","$window","$timeout","$compile","$http","$filter","$log",function(s,n,o,i,c,u,a,h,f){function d(e,t,r){r&&t.hasOwnProperty("css")&&A.bind([m(t.css)],r)}function l(e,t,r){r&&(A.remove(A.getFromRoute(r).concat(O)),O.length=0),t&&A.add(A.getFromRoute(t))}function p(e,t,r,s){s&&(A.remove(A.getFromState(s).concat(O)),O.length=0),t&&A.add(A.getFromState(t))}function y(t){e.isDefined(w.breakpoints)&&(t.breakpoint in w.breakpoints&&(t.media=w.breakpoints[t.breakpoint]),delete t.breakpoints)}function m(t){return t?(e.isFunction(t)&&(t=e.copy(n.invoke(t))),e.isString(t)&&(t=e.extend({href:t},w)),e.isArray(t)&&e.isString(t[0])&&e.forEach(t,function(r){t=e.extend({href:r},w)}),e.isObject(t)&&!e.isArray(t)&&(t=e.extend(t,w)),e.isArray(t)&&e.isObject(t[0])&&e.forEach(t,function(r){t=e.extend(r,w)}),y(t),t):void 0}function v(e){if(!e)return f.error("No stylesheets provided");var t="?cache=";-1===e.href.indexOf(t)&&(e.href=e.href+(e.bustCache?t+(new Date).getTime():""))}function g(e,t){return e&&t?h("filter")(e,function(e){return e[t]}):f.error("filterBy: missing array or property")}function $(e){return e?(S[e.href]=i.matchMedia(e.media),N[e.href]=function(t){c(function(){if(t.matches)s.stylesheets.push(e);else{var r=s.stylesheets.indexOf(h("filter")(s.stylesheets,{href:e.href})[0]);-1!==r&&s.stylesheets.splice(r,1)}})},S[e.href].addListener(N[e.href]),void N[e.href](S[e.href])):f.error("No stylesheet provided")}function F(t){return t?void(s&&e.isDefined(S)&&S[t.href]&&e.isDefined(N)&&S[t.href].removeListener(N[t.href])):f.error("No stylesheet provided")}function b(e){return e?!(!e.media||-1!==k.indexOf(e.media)||!i.matchMedia):f.error("No stylesheet provided")}var A={},E='<link ng-repeat="stylesheet in stylesheets track by $index | orderBy: \'weight\' " rel="{{ stylesheet.rel }}" type="{{ stylesheet.type }}" ng-href="{{ stylesheet.href }}" ng-attr-media="{{ stylesheet.media }}">',S={},N={},k=["print"],w=e.extend({},t),x=e.element(document.querySelector?document.querySelector(w.container):document.getElementsByTagName(w.container)[0]),O=[];return e.forEach(r,function(e,t){e.hasOwnProperty("css")&&(r[t]=m(e.css))}),s.stylesheets=[],x[w.method](u(E)(s)),s.$on("$directiveAdd",d),s.$on("$routeChangeSuccess",l),s.$on("$stateChangeSuccess",p),A.getFromRoute=function(t){if(!t)return f.error("Get From Route: No route provided");var r=null,s=[];return t.$$route&&t.$$route.css?r=t.$$route.css:t.css&&(r=t.css),r&&(e.isArray(r)?e.forEach(r,function(t){e.isFunction(t)&&O.push(m(t)),s.push(m(t))}):(e.isFunction(r)&&O.push(m(r)),s.push(m(r)))),s},A.getFromRoutes=function(t){if(!t)return f.error("Get From Routes: No routes provided");var r=[];return e.forEach(t,function(e){var t=A.getFromRoute(e);t.length&&r.push(t[0])}),r},A.getFromState=function(t){if(!t)return f.error("Get From State: No state provided");var r=[];return e.isDefined(t.views)&&e.forEach(t.views,function(t){t.css&&(e.isFunction(t.css)&&O.push(m(t.css)),r.push(m(t.css)))}),e.isDefined(t.children)&&e.forEach(t.children,function(t){t.css&&(e.isFunction(t.css)&&O.push(m(t.css)),r.push(m(t.css))),e.isDefined(t.children)&&e.forEach(t.children,function(t){t.css&&(e.isFunction(t.css)&&O.push(m(t.css)),r.push(m(t.css)))})}),e.isDefined(t.css)&&(e.isArray(t.css)?e.forEach(t.css,function(t){e.isFunction(t)&&O.push(m(t)),r.push(m(t))}):(e.isFunction(t.css)&&O.push(m(t.css)),r.push(m(t.css)))),r},A.getFromStates=function(t){if(!t)return f.error("Get From States: No states provided");var r=[];return e.forEach(t,function(t){var s=A.getFromState(t);e.isArray(s)?e.forEach(s,function(e){r.push(e)}):r.push(s)}),r},A.preload=function(t,s){t||(t=[],r.length&&Array.prototype.push.apply(t,r),n.has("$route")&&Array.prototype.push.apply(t,A.getFromRoutes(n.get("$route").routes)),n.has("$state")&&Array.prototype.push.apply(t,A.getFromStates(n.get("$state").get())),t=g(t,"preload")),e.isArray(t)||(t=[t]);var i=[];e.forEach(t,function(e,r){e=t[r]=m(e),i.push(a.get(e.href).error(function(t){f.error("AngularCSS: Incorrect path for "+e.href)}))}),e.isFunction(s)&&o.all(i).then(function(){s(t)})},A.bind=function(t,r){if(!t||!r)return f.error("No scope or stylesheets provided");var s=[];e.isArray(t)?e.forEach(t,function(e){s.push(m(e))}):s.push(m(t)),A.add(s),f.debug("$css.bind(): Added",s),r.$on("$destroy",function(){A.remove(s),f.debug("$css.bind(): Removed",s)})},A.add=function(t,r){return t?(e.isArray(t)||(t=[t]),e.forEach(t,function(e){e=m(e),e.href&&!h("filter")(s.stylesheets,{href:e.href}).length&&(v(e),b(e)?$(e):s.stylesheets.push(e),f.debug("$css.add(): "+e.href))}),void s.$broadcast("$cssAdd",t,s.stylesheets)):f.error("No stylesheets provided")},A.remove=function(t,r){return t?(e.isArray(t)||(t=[t]),t=h("filter")(t,function(e){return!e.persist}),e.forEach(t,function(e){e=m(e);var t=s.stylesheets.indexOf(h("filter")(s.stylesheets,{href:e.href})[0]);-1!==t&&s.stylesheets.splice(t,1),F(e),f.debug("$css.remove(): "+e.href)}),void s.$broadcast("$cssRemove",t,s.stylesheets)):f.error("No stylesheets provided")},A.removeAll=function(){s&&s.hasOwnProperty("stylesheets")&&(s.stylesheets.length=0),f.debug("all stylesheets removed")},A.preload(),A}]}]),t.filter("$cssLinks",function(){return function(t){if(!t||!e.isArray(t))return t;var r="";return e.forEach(t,function(e){r+='<link rel="'+e.rel+'" type="'+e.type+'" href="'+e.href+'"',r+=e.media?' media="'+e.media+'"':"",r+=">\n\n"}),r}}),t.run(["$css",function(e){}]);var r=[],s=e.module;e.module=function(){var t=s.apply(this,arguments),n=t.directive;return t.directive=function(t,s){var o=e.isFunction(s)?s:s[s.length-1];try{var i=e.copy(o)();i.directiveName=t,i.hasOwnProperty("css")&&r.push(i)}catch(c){}return n.apply(this,arguments)},t.config(["$provide","$injector",function(t,s){e.forEach(r,function(e){var r=e.directiveName+"Directive";s.has(r)&&t.decorator(r,["$delegate","$rootScope","$timeout",function(t,r,s){var n=t[0],o=n.compile;return n.css&&(e.css=n.css),n.compile=function(){var e=o?o.apply(this,arguments):!1;return function(t){var o=arguments;s(function(){e&&e.apply(this,o)}),r.$broadcast("$directiveAdd",n,t)}},t}])})}]),t}}(angular);
!function(a,i,r){"use strict";function e(){function a(a,i,e){return function(t,n,c){var u=c.$normalize(i);r[u]&&!c[u]&&t.$watch(c[a],function(a){e&&(a=!a),n.attr(i,a)})}}var r={ariaHidden:!0,ariaChecked:!0,ariaDisabled:!0,ariaRequired:!0,ariaInvalid:!0,ariaMultiline:!0,ariaValue:!0,tabindex:!0,bindKeypress:!0};this.config=function(a){r=i.extend(r,a)},this.$get=function(){return{config:function(a){return r[a]},$$watchExpr:a}}}var t=i.module("ngAria",["ng"]).provider("$aria",e);t.directive("ngShow",["$aria",function(a){return a.$$watchExpr("ngShow","aria-hidden",!0)}]).directive("ngHide",["$aria",function(a){return a.$$watchExpr("ngHide","aria-hidden",!1)}]).directive("ngModel",["$aria",function(a){function i(i,r,e){return a.config(r)&&!e.attr(i)}function r(a,i){return!i.attr("role")&&i.attr("type")===a&&"INPUT"!==i[0].nodeName}function e(a,i){var r=a.type,e=a.role;return"checkbox"===(r||e)||"menuitemcheckbox"===e?"checkbox":"radio"===(r||e)||"menuitemradio"===e?"radio":"range"===r||"progressbar"===e||"slider"===e?"range":"textbox"===(r||e)||"TEXTAREA"===i[0].nodeName?"multiline":""}return{restrict:"A",require:"?ngModel",priority:200,link:function(t,n,c,u){function o(){return u.$modelValue}function d(){return s?(s=!1,function(a){var i=c.value==u.$viewValue;n.attr("aria-checked",i),n.attr("tabindex",0-!i)}):function(a){n.attr("aria-checked",c.value==u.$viewValue)}}function l(a){n.attr("aria-checked",!u.$isEmpty(u.$viewValue))}var f=e(c,n),s=i("tabindex","tabindex",n);switch(f){case"radio":case"checkbox":r(f,n)&&n.attr("role",f),i("aria-checked","ariaChecked",n)&&t.$watch(o,"radio"===f?d():l);break;case"range":r(f,n)&&n.attr("role","slider"),a.config("ariaValue")&&(c.min&&!n.attr("aria-valuemin")&&n.attr("aria-valuemin",c.min),c.max&&!n.attr("aria-valuemax")&&n.attr("aria-valuemax",c.max),n.attr("aria-valuenow")||t.$watch(o,function(a){n.attr("aria-valuenow",a)}));break;case"multiline":i("aria-multiline","ariaMultiline",n)&&n.attr("aria-multiline",!0)}s&&n.attr("tabindex",0),u.$validators.required&&i("aria-required","ariaRequired",n)&&t.$watch(function(){return u.$error.required},function(a){n.attr("aria-required",!!a)}),i("aria-invalid","ariaInvalid",n)&&t.$watch(function(){return u.$invalid},function(a){n.attr("aria-invalid",!!a)})}}}]).directive("ngDisabled",["$aria",function(a){return a.$$watchExpr("ngDisabled","aria-disabled")}]).directive("ngMessages",function(){return{restrict:"A",require:"?ngMessages",link:function(a,i,r,e){i.attr("aria-live")||i.attr("aria-live","assertive")}}}).directive("ngClick",["$aria","$parse",function(a,i){return{restrict:"A",compile:function(r,e){var t=i(e.ngClick,null,!0);return function(i,r,e){function n(a,i){return-1!==i.indexOf(a[0].nodeName)?!0:void 0}var c=["BUTTON","A","INPUT","TEXTAREA"];r.attr("role")||n(r,c)||r.attr("role","button"),a.config("tabindex")&&!r.attr("tabindex")&&r.attr("tabindex",0),!a.config("bindKeypress")||e.ngKeypress||n(r,c)||r.on("keypress",function(a){function r(){t(i,{$event:a})}(32===a.keyCode||13===a.keyCode)&&i.$apply(r)})}}}}]).directive("ngDblclick",["$aria",function(a){return function(i,r,e){a.config("tabindex")&&!r.attr("tabindex")&&r.attr("tabindex",0)}}])}(window,window.angular);
function mdMediaFactory(e,t,n){function r(e){var t=m[e];angular.isUndefined(t)&&(t=m[e]=o(e));var n=f[t];return angular.isUndefined(n)&&(n=a(t)),n}function o(t){return e.MEDIA[t]||("("!==t.charAt(0)?"("+t+")":t)}function a(e){var t=u[e]=n.matchMedia(e);return t.addListener(i),f[t.media]=!!t.matches}function i(e){t.$evalAsync(function(){f[e.media]=!!e.matches})}function c(e){return u[e]}function d(t,n){for(var r=0;r<e.MEDIA_PRIORITY.length;r++){var o=e.MEDIA_PRIORITY[r];if(u[m[o]].matches){var a=s(t,n+"-"+o);if(t[a])return t[a]}}return t[s(t,n)]}function l(t,n,r){var o=[];return t.forEach(function(t){var a=s(n,t);n[a]&&o.push(n.$observe(a,angular.bind(void 0,r,null)));for(var i in e.MEDIA){var a=s(n,t+"-"+i);if(!n[a])return;o.push(n.$observe(a,angular.bind(void 0,r,i)))}}),function(){o.forEach(function(e){e()})}}function s(e,t){return p[t]||(p[t]=e.$normalize(t))}var m={},u={},f={},p={};return r.getResponsiveAttribute=d,r.getQuery=c,r.watchResponsiveAttributes=l,r}angular.module("ngMaterial",["ng","ngAnimate","ngAria","material.core","material.core.theming.palette","material.core.theming","material.components.autocomplete","material.components.backdrop","material.components.bottomSheet","material.components.card","material.components.button","material.components.checkbox","material.components.content","material.components.dialog","material.components.divider","material.components.gridList","material.components.icon","material.components.input","material.components.list","material.components.progressCircular","material.components.progressLinear","material.components.radioButton","material.components.select","material.components.sidenav","material.components.slider","material.components.sticky","material.components.subheader","material.components.swipe","material.components.switch","material.components.tabs","material.components.textField","material.components.toast","material.components.toolbar","material.components.tooltip","material.components.whiteframe"]),function(){"use strict";function e(e,n){e.decorator("$$rAF",["$delegate",t]),n.theme("default").primaryPalette("indigo").accentPalette("pink").warnPalette("red").backgroundPalette("grey")}function t(e){return e.throttle=function(t){var n,r,o,a;return function(){n=arguments,a=this,o=t,r||(r=!0,e(function(){o.apply(a,n),r=!1}))}},e}angular.module("material.core",["material.core.theming"]).config(e),e.$inject=["$provide","$mdThemingProvider"]}(),function(){"use strict";function e(e,t){function n(e){return r?"webkit"+e.charAt(0).toUpperCase()+e.substring(1):e}var r=/webkit/i.test(t.vendorPrefix);return{KEY_CODE:{ENTER:13,ESCAPE:27,SPACE:32,LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,TAB:9},CSS:{TRANSITIONEND:"transitionend"+(r?" webkitTransitionEnd":""),ANIMATIONEND:"animationend"+(r?" webkitAnimationEnd":""),TRANSFORM:n("transform"),TRANSFORM_ORIGIN:n("transformOrigin"),TRANSITION:n("transition"),TRANSITION_DURATION:n("transitionDuration"),ANIMATION_PLAY_STATE:n("animationPlayState"),ANIMATION_DURATION:n("animationDuration"),ANIMATION_NAME:n("animationName"),ANIMATION_TIMING:n("animationTimingFunction"),ANIMATION_DIRECTION:n("animationDirection")},MEDIA:{sm:"(max-width: 600px)","gt-sm":"(min-width: 600px)",md:"(min-width: 600px) and (max-width: 960px)","gt-md":"(min-width: 960px)",lg:"(min-width: 960px) and (max-width: 1200px)","gt-lg":"(min-width: 1200px)"},MEDIA_PRIORITY:["gt-lg","lg","gt-md","md","gt-sm","sm"]}}angular.module("material.core").factory("$mdConstant",e),e.$inject=["$$rAF","$sniffer"]}(),function(){function e(e,t){function n(){return[].concat(b)}function r(){return b.length}function o(e){return b.length&&e>-1&&e<b.length}function a(e){return e?o(m(e)+1):!1}function i(e){return e?o(m(e)-1):!1}function c(e){return o(e)?b[e]:null}function d(e,t){return b.filter(function(n){return n[e]===t})}function l(e,t){return e?(angular.isNumber(t)||(t=b.length),b.splice(t,0,e),m(e)):-1}function s(e){u(e)&&b.splice(m(e),1)}function m(e){return b.indexOf(e)}function u(e){return e&&m(e)>-1}function f(){return b.length?b[0]:null}function p(){return b.length?b[b.length-1]:null}function h(e,n,r,a){r=r||g;for(var i=m(n);;){if(!o(i))return null;var c=i+(e?-1:1),d=null;if(o(c)?d=b[c]:t&&(d=e?p():f(),c=m(d)),null===d||c===a)return null;if(r(d))return d;angular.isUndefined(a)&&(a=c),i=c}}var g=function(){return!0};e&&!angular.isArray(e)&&(e=Array.prototype.slice.call(e)),t=!!t;var b=e||[];return{items:n,count:r,inRange:o,contains:u,indexOf:m,itemAt:c,findBy:d,add:l,remove:s,first:f,last:p,next:angular.bind(null,h,!1),previous:angular.bind(null,h,!0),hasPrevious:i,hasNext:a}}angular.module("material.core").config(["$provide",function(t){t.decorator("$mdUtil",["$delegate",function(t){return t.iterator=e,t}])}])}(),angular.module("material.core").factory("$mdMedia",mdMediaFactory),mdMediaFactory.$inject=["$mdConstant","$rootScope","$window"],function(){"use strict";var e=["0","0","0"];angular.module("material.core").factory("$mdUtil",["$cacheFactory","$document","$timeout","$q","$window","$mdConstant",function(t,n,r,o,a,i){function c(e){return e[0]||e}var d;return d={now:window.performance?angular.bind(window.performance,window.performance.now):Date.now,clientRect:function(e,t,n){var r=c(e);t=c(t||r.offsetParent||document.body);var o=r.getBoundingClientRect(),a=n?t.getBoundingClientRect():{left:0,top:0,width:0,height:0};return{left:o.left-a.left+t.scrollLeft,top:o.top-a.top+t.scrollTop,width:o.width,height:o.height}},offsetRect:function(e,t){return d.clientRect(e,t,!0)},floatingScrollbars:function(){if(void 0===this.floatingScrollbars.cached){var e=angular.element('<div style="z-index: -1; position: absolute; height: 1px; overflow-y: scroll"><div style="height: 2px;"></div></div>');n[0].body.appendChild(e[0]),this.floatingScrollbars.cached=e[0].offsetWidth==e[0].childNodes[0].offsetWidth,e.remove()}return this.floatingScrollbars.cached},forceFocus:function(e){var t=e[0]||e;document.addEventListener("click",function r(e){e.target===t&&e.$focus&&(t.focus(),e.stopImmediatePropagation(),e.preventDefault(),t.removeEventListener("click",r))},!0);var n=document.createEvent("MouseEvents");n.initMouseEvent("click",!1,!0,window,{},0,0,0,0,!1,!1,!1,!1,0,null),n.$material=!0,n.$focus=!0,t.dispatchEvent(n)},transitionEndPromise:function(e){function t(r){r.target===e[0]&&(e.off(i.CSS.TRANSITIONEND,t),n.resolve())}var n=o.defer();return e.on(i.CSS.TRANSITIONEND,t),n.promise},fakeNgModel:function(){return{$fake:!0,$setTouched:angular.noop,$setViewValue:function(e){this.$viewValue=e,this.$render(e),this.$viewChangeListeners.forEach(function(e){e()})},$isEmpty:function(e){return 0===(""+e).length},$parsers:[],$formatters:[],$viewChangeListeners:[],$render:angular.noop}},debounce:function(e,t,n,o){var a;return function(){var i=n,c=Array.prototype.slice.call(arguments);r.cancel(a),a=r(function(){a=void 0,e.apply(i,c)},t||10,o)}},throttle:function(e,t){var n;return function(){var r=this,o=arguments,a=d.now();(!n||a-n>t)&&(e.apply(r,o),n=a)}},time:function(e){var t=d.now();return e(),d.now()-t},nextUid:function(){for(var t,n=e.length;n;){if(n--,t=e[n].charCodeAt(0),57==t)return e[n]="A",e.join("");if(90!=t)return e[n]=String.fromCharCode(t+1),e.join("");e[n]="0"}return e.unshift("0"),e.join("")},disconnectScope:function(e){if(e&&e.$root!==e&&!e.$$destroyed){var t=e.$parent;e.$$disconnected=!0,t.$$childHead===e&&(t.$$childHead=e.$$nextSibling),t.$$childTail===e&&(t.$$childTail=e.$$prevSibling),e.$$prevSibling&&(e.$$prevSibling.$$nextSibling=e.$$nextSibling),e.$$nextSibling&&(e.$$nextSibling.$$prevSibling=e.$$prevSibling),e.$$nextSibling=e.$$prevSibling=null}},reconnectScope:function(e){if(e&&e.$root!==e&&e.$$disconnected){var t=e,n=t.$parent;t.$$disconnected=!1,t.$$prevSibling=n.$$childTail,n.$$childHead?(n.$$childTail.$$nextSibling=t,n.$$childTail=t):n.$$childHead=n.$$childTail=t}},getClosest:function(e,t){t=t.toUpperCase();do if(e.nodeName===t)return e;while(e=e.parentNode);return null}}}]),angular.element.prototype.focus=angular.element.prototype.focus||function(){return this.length&&this[0].focus(),this},angular.element.prototype.blur=angular.element.prototype.blur||function(){return this.length&&this[0].blur(),this}}(),function(){"use strict";function e(e,t,n){function r(e,n,r){var o=e[0];o.hasAttribute(n)||c(o,n)||(r=angular.isString(r)?r.trim():"",r.length?e.attr(n,r):t.warn('ARIA: Attribute "',n,'", required for accessibility, is missing on node:',o))}function o(t,n,o){e(function(){r(t,n,o())})}function a(e,t){o(e,t,function(){return i(e)})}function i(e){return e.text().trim()}function c(e,t){function r(e){var t=e.currentStyle?e.currentStyle:n.getComputedStyle(e);return"none"===t.display}var o=e.hasChildNodes(),a=!1;if(o)for(var i=e.childNodes,c=0;c<i.length;c++){var d=i[c];1===d.nodeType&&d.hasAttribute(t)&&(r(d)||(a=!0))}return a}return{expect:r,expectAsync:o,expectWithText:a}}angular.module("material.core").service("$mdAria",e),e.$inject=["$$rAF","$log","$window"]}(),function(){"use strict";function e(e,t){var n;for(var r in d)n=d[r],"start"===e&&n.cancel(),n[e](t,g)}function t(t){if(!g){var n=+Date.now();b&&!o(t,b)&&n-b.endTime<1500||(g=c(t),e("start",t))}}function n(t){g&&o(t,g)&&(i(t,g),e("move",t))}function r(t){g&&o(t,g)&&(i(t,g),g.endTime=+Date.now(),e("end",t),b=g,g=null)}function o(e,t){return e&&t&&e.type.charAt(0)===t.type}function a(e){return e=e.originalEvent||e,e.touches&&e.touches[0]||e.changedTouches&&e.changedTouches[0]||e}function i(e,t){var n=a(e),r=t.x=n.pageX,o=t.y=n.pageY;t.distanceX=r-t.startX,t.distanceY=o-t.startY,t.distance=Math.sqrt(t.distanceX*t.distanceX+t.distanceY*t.distanceY),t.directionX=t.distanceX>0?"right":t.distanceX<0?"left":"",t.directionY=t.distanceY>0?"up":t.distanceY<0?"down":"",t.duration=+Date.now()-t.startTime,t.velocityX=t.distanceX/t.duration,t.velocityY=t.distanceY/t.duration}function c(e){var t=a(e),n={startTime:+Date.now(),target:e.target,type:e.type.charAt(0)};return n.startX=n.x=t.pageX,n.startY=n.y=t.pageY,n}var d,l="mousedown touchstart pointerdown",s="mousemove touchmove pointermove",m="mouseup mouseleave touchend touchcancel pointerup pointercancel";document.contains||(document.contains=function(e){return document.body.contains(e)});var u=navigator.userAgent||navigator.vendor||window.opera,f=u.match(/iPad/i)||u.match(/iPhone/i)||u.match(/iPod/i),p=u.match(/Android/i),h=f||p;h&&document.addEventListener("click",function(e){var t=0===e.clientX&&0===e.clientY;t||e.$material||(e.preventDefault(),e.stopPropagation())},!0),angular.element(document).on(l,t).on(s,n).on(m,r).on("$$mdGestureReset",function(){b=g=null});var g,b;angular.module("material.core").run(["$mdGesture",function(){}]).factory("$mdGesture",["$$MdGestureHandler","$$rAF","$timeout",function(e,t,n){function r(t,n){var r=new e(t);return angular.extend(r,n),d[t]=r,a}function o(e,t,n){var r=d[t.replace(/^\$md./,"")];if(!r)throw new Error("Failed to register element with handler "+t+". Available handlers: "+Object.keys(d).join(", "));return r.registerElement(e,n)}d={},h&&r("click",{options:{maxDistance:6},onEnd:function(e,t){t.distance<this.state.options.maxDistance&&this.dispatchEvent(e,"click")}}),r("press",{onStart:function(e){this.dispatchEvent(e,"$md.pressdown")},onEnd:function(e){this.dispatchEvent(e,"$md.pressup")}}),r("hold",{options:{maxDistance:6,delay:500},onCancel:function(){n.cancel(this.state.timeout)},onStart:function(e,t){return this.state.registeredParent?(this.state.pos={x:t.x,y:t.y},void(this.state.timeout=n(angular.bind(this,function(){this.dispatchEvent(e,"$md.hold"),this.cancel()}),this.state.options.delay,!1))):this.cancel()},onMove:function(e,t){e.preventDefault();var n=this.state.pos.x-t.x,r=this.state.pos.y-t.y;Math.sqrt(n*n+r*r)>this.options.maxDistance&&this.cancel()},onEnd:function(){this.onCancel()}}),r("drag",{options:{minDistance:6,horizontal:!0},onStart:function(){this.state.registeredParent||this.cancel()},onMove:function(e,t){var n,r;e.preventDefault(),this.state.dragPointer?this.dispatchDragMove(e):(this.state.options.horizontal?(n=Math.abs(t.distanceX)>this.state.options.minDistance,r=Math.abs(t.distanceY)>1.5*this.state.options.minDistance):(n=Math.abs(t.distanceY)>this.state.options.minDistance,r=Math.abs(t.distanceX)>1.5*this.state.options.minDistance),n?(this.state.dragPointer=c(e),i(e,this.state.dragPointer),this.dispatchEvent(e,"$md.dragstart",this.state.dragPointer)):r&&this.cancel())},dispatchDragMove:t.throttle(function(e){this.state.isRunning&&(i(e,this.state.dragPointer),this.dispatchEvent(e,"$md.drag",this.state.dragPointer))}),onEnd:function(e){this.state.dragPointer&&(i(e,this.state.dragPointer),this.dispatchEvent(e,"$md.dragend",this.state.dragPointer))}}),r("swipe",{options:{minVelocity:.65,minDistance:10},onEnd:function(e,t){if(Math.abs(t.velocityX)>this.state.options.minVelocity&&Math.abs(t.distanceX)>this.state.options.minDistance){var n="left"==t.directionX?"$md.swipeleft":"$md.swiperight";this.dispatchEvent(e,n)}}});var a;return a={handler:r,register:o}}]).factory("$$MdGestureHandler",["$$rAF",function(){function e(e){this.name=e,this.state={}}function t(e,t,n){n=n||g;var r=new angular.element.Event(t);r.$material=!0,r.pointer=n,r.srcEvent=e,angular.extend(r,{clientX:n.x,clientY:n.y,screenX:n.x,screenY:n.y,pageX:n.x,pageY:n.y,ctrlKey:e.ctrlKey,altKey:e.altKey,shiftKey:e.shiftKey,metaKey:e.metaKey}),angular.element(n.target).trigger(r)}function n(e,t,n){n=n||g;var r;"click"===t?(r=document.createEvent("MouseEvents"),r.initMouseEvent("click",!0,!0,window,e.detail,n.x,n.y,n.x,n.y,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,e.relatedTarget||null)):(r=document.createEvent("CustomEvent"),r.initCustomEvent(t,!0,!0,{})),r.$material=!0,r.pointer=n,r.srcEvent=e,n.target.dispatchEvent(r)}return e.prototype={onStart:angular.noop,onMove:angular.noop,onEnd:angular.noop,onCancel:angular.noop,options:{},dispatchEvent:"undefined"!=typeof window.jQuery&&angular.element===window.jQuery?t:n,start:function(e,t){if(!this.state.isRunning){var n=this.getNearestParent(e.target),r=n&&n.$mdGesture[this.name]||{};this.state={isRunning:!0,options:angular.extend({},this.options,r),registeredParent:n},this.onStart(e,t)}},move:function(e,t){this.state.isRunning&&this.onMove(e,t)},end:function(e,t){this.state.isRunning&&(this.onEnd(e,t),this.state.isRunning=!1)},cancel:function(e,t){this.onCancel(e,t),this.state={}},getNearestParent:function(e){for(var t=e;t;){if((t.$mdGesture||{})[this.name])return t;t=t.parentNode}},registerElement:function(e,t){function n(){delete e[0].$mdGesture[r.name],e.off("$destroy",n)}var r=this;return e[0].$mdGesture=e[0].$mdGesture||{},e[0].$mdGesture[this.name]=t||{},e.on("$destroy",n),n}},e}])}(),function(){"use strict";function e(e,t,n,r,o,a){this.compile=function(i){var c=i.templateUrl,d=i.template||"",l=i.controller,s=i.controllerAs,m=i.resolve||{},u=i.locals||{},f=i.transformTemplate||angular.identity,p=i.bindToController;return angular.forEach(m,function(e,t){m[t]=angular.isString(e)?n.get(e):n.invoke(e)}),angular.extend(m,u),m.$template=c?t.get(c,{cache:a}).then(function(e){return e.data}):e.when(d),e.all(m).then(function(e){var t=f(e.$template),n=i.element||angular.element("<div>").html(t.trim()).contents(),a=r(n);return{locals:e,element:n,link:function(t){if(e.$scope=t,l){var r=o(l,e);p&&angular.extend(r,e),n.data("$ngControllerController",r),n.children().data("$ngControllerController",r),s&&(t[s]=r)}return a(t)}}})}}angular.module("material.core").service("$mdCompiler",e),e.$inject=["$q","$http","$injector","$compile","$controller","$templateCache"]}(),function(){"use strict";function e(){function e(e){function t(e){return c.optionsFactory=e.options,c.methods=(e.methods||[]).concat(a),d}function n(e,t){return i[e]=t,d}function r(t,n){if(n=n||{},n.methods=n.methods||[],n.options=n.options||function(){return{}},/^cancel|hide|show$/.test(t))throw new Error("Preset '"+t+"' in "+e+" is reserved!");if(n.methods.indexOf("_options")>-1)throw new Error("Method '_options' in "+e+" is reserved!");return c.presets[t]={methods:n.methods.concat(a),optionsFactory:n.options,argOption:n.argOption},d}function o(t,n,r){function o(e){return e&&e._options&&(e=e._options),s.show(angular.extend({},l,e))}function a(t,n){var o={};return o[e]=m,r.invoke(t||function(){return n},{},o)}var d,l,s=t(),m={hide:s.hide,cancel:s.cancel,show:o};return d=c.methods||[],l=a(c.optionsFactory,{}),angular.forEach(i,function(e,t){m[t]=e}),angular.forEach(c.presets,function(e,t){function n(e){this._options=angular.extend({},r,e)}var r=a(e.optionsFactory,{}),o=(e.methods||[]).concat(d);if(angular.extend(r,{$type:t}),angular.forEach(o,function(e){n.prototype[e]=function(t){return this._options[e]=t,this}}),e.argOption){var i="show"+t.charAt(0).toUpperCase()+t.slice(1);m[i]=function(e){var n=m[t](e);return m.show(n)}}m[t]=function(t){return arguments.length&&e.argOption&&!angular.isObject(t)&&!angular.isArray(t)?(new n)[e.argOption](t):new n(t)}}),m}var a=["onHide","onShow","onRemove"],i={},c={presets:{}},d={setDefaults:t,addPreset:r,addMethod:n,$get:o};return d.addPreset("build",{methods:["controller","controllerAs","resolve","template","templateUrl","themable","transformTemplate","parent"]}),o.$inject=["$$interimElement","$animate","$injector"],d}function t(e,t,n,r,o,a,i,c,d){function l(e){return e&&angular.isString(e)?e.replace(/\{\{/g,s).replace(/}}/g,m):e}var s=i.startSymbol(),m=i.endSymbol(),u="{{"===s&&"}}"===m,f=u?angular.identity:l;return function(){function i(e){if(p.length)return u.cancel().then(function(){return i(e)});var t=new m(e);return p.push(t),t.show().then(function(){return t.deferred.promise})}function l(e){var t=p.shift();return t&&t.remove().then(function(){t.deferred.resolve(e)})}function s(e){var n=p.shift();return t.when(n&&n.remove().then(function(){n.deferred.reject(e)}))}function m(i){var l,s,m,p,h;return i=i||{},i=angular.extend({preserveScope:!1,scope:i.scope||n.$new(i.isolateScope),onShow:function(e,t,n){return a.enter(t,n.parent)},onRemove:function(e,n){return n&&a.leave(n)||t.when()}},i),i.template&&(i.template=f(i.template)),l={options:i,deferred:t.defer(),show:function(){return p=c.compile(i).then(function(n){function a(){i.hideDelay&&(s=r(u.cancel,i.hideDelay))}angular.extend(n.locals,l.options),m=n.link(i.scope),angular.isFunction(i.parent)?i.parent=i.parent(i.scope,m,i):angular.isString(i.parent)&&(i.parent=angular.element(e[0].querySelector(i.parent))),(i.parent||{}).length||(i.parent=o.find("body"),i.parent.length||(i.parent=o)),i.themable&&d(m);var c=i.onShow(i.scope,m,i);return t.when(c).then(function(){(i.onComplete||angular.noop)(i.scope,m,i),a()})},function(e){p=!0,l.deferred.reject(e)})},cancelTimeout:function(){s&&(r.cancel(s),s=void 0)},remove:function(){return l.cancelTimeout(),h=t.when(p).then(function(){var e=m?i.onRemove(i.scope,m,i):!0;return t.when(e).then(function(){i.preserveScope||i.scope.$destroy(),h=!0})})}}}var u,p=[];return u={show:i,hide:l,cancel:s}}}return e.$get=t,t.$inject=["$document","$q","$rootScope","$timeout","$rootElement","$animate","$interpolate","$mdCompiler","$mdTheming"],e}angular.module("material.core").provider("$$interimElement",e)}(),function(){"use strict";function e(e,t){function n(e){return e&&""!==e}var r,o=[],a={};return r={notFoundError:function(t){e.error("No instance found for handle",t)},getInstances:function(){return o},get:function(e){if(!n(e))return null;var t,r,a;for(t=0,r=o.length;r>t;t++)if(a=o[t],a.$$mdHandle===e)return a;return null},register:function(e,t){function n(){var t=o.indexOf(e);-1!==t&&o.splice(t,1)}function r(){var n=a[t];n&&(n.resolve(e),delete a[t])}return t?(e.$$mdHandle=t,o.push(e),r(),n):angular.noop},when:function(e){if(n(e)){var o=t.defer(),i=r.get(e);return i?o.resolve(i):a[e]=o,o.promise}return t.reject("Invalid ` + "`" + `md-component-id` + "`" + ` value.")}}}angular.module("material.core").factory("$mdComponentRegistry",e),e.$inject=["$log","$q"]}(),function(){"use strict";function e(e){return{controller:angular.noop,link:function(t,n,r){r.hasOwnProperty("mdInkRippleCheckbox")?e.attachCheckboxBehavior(t,n):e.attachButtonBehavior(t,n)}}}function t(e,t){function n(e,t,n){return a(e,t,angular.extend({isFAB:t.hasClass("md-fab"),isMenuItem:t.hasClass("md-menu-item"),center:!1,dimBackground:!0},n))}function r(e,t,n){return a(e,t,angular.extend({center:!0,dimBackground:!1,fitRipple:!0},n))}function o(e,t,n){return a(e,t,angular.extend({center:!1,dimBackground:!0,outline:!0},n))}function a(n,r,o){function a(){var e=r.data("$mdRippleContainer");return e?e:(e=angular.element('<div class="md-ripple-container">'),r.append(e),r.data("$mdRippleContainer",e),e)}function i(e){function t(e){var t="#"===e.charAt(0)?e.substr(1):e,n=t.length/3,r=t.substr(0,n),o=t.substr(n,n),a=t.substr(2*n);return 1===n&&(r+=r,o+=o,a+=a),"rgba("+parseInt(r,16)+","+parseInt(o,16)+","+parseInt(a,16)+",0.1)"}function n(e){return e.replace(")",", 0.1)").replace("(","a(")}return e?0===e.indexOf("rgba")?e.replace(/\d?\.?\d*\s*\)\s*$/,"0.1)"):0===e.indexOf("rgb")?n(e):0===e.indexOf("#")?t(e):void 0:void 0}function c(e,n){g.splice(g.indexOf(e),1),0===g.length&&a().css({backgroundColor:""}),t(function(){e.remove()},n,!1)}function d(e){var t=g.indexOf(e),n=b[t]||{},r=g.length>1?!1:E,a=g.length>1?!1:$;r||n.animating||a?e.addClass("md-ripple-visible"):e&&(e.removeClass("md-ripple-visible"),o.outline&&e.css({width:f+"px",height:f+"px",marginLeft:-1*f+"px",marginTop:-1*f+"px"}),c(e,o.outline?450:650))}function l(n,c){function l(e){var t=angular.element('<div class="md-ripple" data-counter="'+h++ +'">');return g.unshift(t),b.unshift({animating:!0}),u.append(t),e&&t.css(e),t}function s(e,t){var n,r,a,i=u.prop("offsetWidth"),c=u.prop("offsetHeight");return o.isMenuItem?r=Math.sqrt(Math.pow(i,2)+Math.pow(c,2)):o.outline?(a=M.getBoundingClientRect(),e-=a.left,t-=a.top,i=Math.max(e,i-e),c=Math.max(t,c-t),r=2*Math.sqrt(Math.pow(i,2)+Math.pow(c,2))):(n=o.isFAB?1.1:.8,r=Math.sqrt(Math.pow(i,2)+Math.pow(c,2))*n,o.fitRipple&&(r=Math.min(c,i,r))),r}function m(e,t,n){function r(e){return e.replace("rgba","rgb").replace(/,[^\)\,]+\)/,")")}var a,i={backgroundColor:r(T),borderColor:r(T),width:e+"px",height:e+"px"};return o.outline?(i.width=0,i.height=0):i.marginLeft=i.marginTop=e*-.5+"px",o.center?i.left=i.top="50%":(a=M.getBoundingClientRect(),i.left=Math.round((t-a.left)/u.prop("offsetWidth")*100)+"%",i.top=Math.round((n-a.top)/u.prop("offsetHeight")*100)+"%"),i}T=i(r.attr("md-ink-ripple"))||i(e.getComputedStyle(o.colorElement[0]).color||"rgb(0, 0, 0)");var u=a(),p=s(n,c),v=m(p,n,c),E=l(v),$=g.indexOf(E),A=b[$]||{};return f=p,A.animating=!0,t(function(){o.dimBackground&&u.css({backgroundColor:T}),E.addClass("md-ripple-placed md-ripple-scaled"),E.css(o.outline?{borderWidth:.5*p+"px",marginLeft:p*-.5+"px",marginTop:p*-.5+"px"}:{left:"50%",top:"50%"}),d(E),t(function(){A.animating=!1,d(E)},o.outline?450:225,!1)},0,!1),E}function s(e){u()&&(l(e.pointer.x,e.pointer.y),$=!0)}function m(){$=!1;var e=g[g.length-1];t(function(){d(e)},0,!1)}function u(){function e(e){return e&&e.hasAttribute&&e.hasAttribute("disabled")}var t=M.parentNode,n=t&&t.parentNode,r=n&&n.parentNode;return!(e(M)||e(t)||e(n)||e(r))}if(r.controller("mdNoInk"))return angular.noop;o=angular.extend({colorElement:r,mousedown:!0,hover:!0,focus:!0,center:!1,mousedownPauseTime:150,dimBackground:!1,outline:!1,isFAB:!1,isMenuItem:!1,fitRipple:!1},o);var f,p=r.controller("mdInkRipple")||{},h=0,g=[],b=[],v=r.attr("md-highlight"),E=!1,$=!1,M=r[0],A=r.attr("md-ripple-size"),T=i(r.attr("md-ink-ripple"))||i(e.getComputedStyle(o.colorElement[0]).color||"rgb(0, 0, 0)");switch(A){case"full":o.isFAB=!0;break;case"partial":o.isFAB=!1}return o.mousedown&&r.on("$md.pressdown",s).on("$md.pressup",m),p.createRipple=l,v&&n.$watch(v,function(e){E=e,E&&!g.length&&t(function(){l(0,0)},0,!1),angular.forEach(g,d)}),function(){r.off("$md.pressdown",s).off("$md.pressup",m),a().remove()}}return{attachButtonBehavior:n,attachCheckboxBehavior:r,attachTabBehavior:o,attach:a}}function n(){return function(){return{controller:angular.noop}}}angular.module("material.core").factory("$mdInkRipple",t).directive("mdInkRipple",e).directive("mdNoInk",n()).directive("mdNoBar",n()).directive("mdNoStretch",n()),e.$inject=["$mdInkRipple"],t.$inject=["$window","$timeout"]}(),function(){"use strict";angular.module("material.core.theming.palette",[]).constant("$mdColorPalette",{red:{50:"#ffebee",100:"#ffcdd2",200:"#ef9a9a",300:"#e57373",400:"#ef5350",500:"#f44336",600:"#e53935",700:"#d32f2f",800:"#c62828",900:"#b71c1c",A100:"#ff8a80",A200:"#ff5252",A400:"#ff1744",A700:"#d50000",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100",contrastStrongLightColors:"500 600 700 A200 A400 A700"},pink:{50:"#fce4ec",100:"#f8bbd0",200:"#f48fb1",300:"#f06292",400:"#ec407a",500:"#e91e63",600:"#d81b60",700:"#c2185b",800:"#ad1457",900:"#880e4f",A100:"#ff80ab",A200:"#ff4081",A400:"#f50057",A700:"#c51162",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100",contrastStrongLightColors:"500 600 A200 A400 A700"},purple:{50:"#f3e5f5",100:"#e1bee7",200:"#ce93d8",300:"#ba68c8",400:"#ab47bc",500:"#9c27b0",600:"#8e24aa",700:"#7b1fa2",800:"#6a1b9a",900:"#4a148c",A100:"#ea80fc",A200:"#e040fb",A400:"#d500f9",A700:"#aa00ff",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200 A400 A700"},"deep-purple":{50:"#ede7f6",100:"#d1c4e9",200:"#b39ddb",300:"#9575cd",400:"#7e57c2",500:"#673ab7",600:"#5e35b1",700:"#512da8",800:"#4527a0",900:"#311b92",A100:"#b388ff",A200:"#7c4dff",A400:"#651fff",A700:"#6200ea",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200"},indigo:{50:"#e8eaf6",100:"#c5cae9",200:"#9fa8da",300:"#7986cb",400:"#5c6bc0",500:"#3f51b5",600:"#3949ab",700:"#303f9f",800:"#283593",900:"#1a237e",A100:"#8c9eff",A200:"#536dfe",A400:"#3d5afe",A700:"#304ffe",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200 A400"},blue:{50:"#e3f2fd",100:"#bbdefb",200:"#90caf9",300:"#64b5f6",400:"#42a5f5",500:"#2196f3",600:"#1e88e5",700:"#1976d2",800:"#1565c0",900:"#0d47a1",A100:"#82b1ff",A200:"#448aff",A400:"#2979ff",A700:"#2962ff",contrastDefaultColor:"light",contrastDarkColors:"100 200 300 400 A100",contrastStrongLightColors:"500 600 700 A200 A400 A700"},"light-blue":{50:"#e1f5fe",100:"#b3e5fc",200:"#81d4fa",300:"#4fc3f7",400:"#29b6f6",500:"#03a9f4",600:"#039be5",700:"#0288d1",800:"#0277bd",900:"#01579b",A100:"#80d8ff",A200:"#40c4ff",A400:"#00b0ff",A700:"#0091ea",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900 A700",contrastStrongLightColors:"500 600 700 800 A700"},cyan:{50:"#e0f7fa",100:"#b2ebf2",200:"#80deea",300:"#4dd0e1",400:"#26c6da",500:"#00bcd4",600:"#00acc1",700:"#0097a7",800:"#00838f",900:"#006064",A100:"#84ffff",A200:"#18ffff",A400:"#00e5ff",A700:"#00b8d4",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700 800"},teal:{50:"#e0f2f1",100:"#b2dfdb",200:"#80cbc4",300:"#4db6ac",400:"#26a69a",500:"#009688",600:"#00897b",700:"#00796b",800:"#00695c",900:"#004d40",A100:"#a7ffeb",A200:"#64ffda",A400:"#1de9b6",A700:"#00bfa5",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700"},green:{50:"#e8f5e9",100:"#c8e6c9",200:"#a5d6a7",300:"#81c784",400:"#66bb6a",500:"#4caf50",600:"#43a047",700:"#388e3c",800:"#2e7d32",900:"#1b5e20",A100:"#b9f6ca",A200:"#69f0ae",A400:"#00e676",A700:"#00c853",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700"},"light-green":{50:"#f1f8e9",100:"#dcedc8",200:"#c5e1a5",300:"#aed581",400:"#9ccc65",500:"#8bc34a",600:"#7cb342",700:"#689f38",800:"#558b2f",900:"#33691e",A100:"#ccff90",A200:"#b2ff59",A400:"#76ff03",A700:"#64dd17",contrastDefaultColor:"dark",contrastLightColors:"800 900",contrastStrongLightColors:"800 900"},lime:{50:"#f9fbe7",100:"#f0f4c3",200:"#e6ee9c",300:"#dce775",400:"#d4e157",500:"#cddc39",600:"#c0ca33",700:"#afb42b",800:"#9e9d24",900:"#827717",A100:"#f4ff81",A200:"#eeff41",A400:"#c6ff00",A700:"#aeea00",contrastDefaultColor:"dark",contrastLightColors:"900",contrastStrongLightColors:"900"},yellow:{50:"#fffde7",100:"#fff9c4",200:"#fff59d",300:"#fff176",400:"#ffee58",500:"#ffeb3b",600:"#fdd835",700:"#fbc02d",800:"#f9a825",900:"#f57f17",A100:"#ffff8d",A200:"#ffff00",A400:"#ffea00",A700:"#ffd600",contrastDefaultColor:"dark"},amber:{50:"#fff8e1",100:"#ffecb3",200:"#ffe082",300:"#ffd54f",400:"#ffca28",500:"#ffc107",600:"#ffb300",700:"#ffa000",800:"#ff8f00",900:"#ff6f00",A100:"#ffe57f",A200:"#ffd740",A400:"#ffc400",A700:"#ffab00",contrastDefaultColor:"dark"},orange:{50:"#fff3e0",100:"#ffe0b2",200:"#ffcc80",300:"#ffb74d",400:"#ffa726",500:"#ff9800",600:"#fb8c00",700:"#f57c00",800:"#ef6c00",900:"#e65100",A100:"#ffd180",A200:"#ffab40",A400:"#ff9100",A700:"#ff6d00",contrastDefaultColor:"dark",contrastLightColors:"800 900",contrastStrongLightColors:"800 900"},"deep-orange":{50:"#fbe9e7",100:"#ffccbc",200:"#ffab91",300:"#ff8a65",400:"#ff7043",500:"#ff5722",600:"#f4511e",700:"#e64a19",800:"#d84315",900:"#bf360c",A100:"#ff9e80",A200:"#ff6e40",A400:"#ff3d00",A700:"#dd2c00",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100 A200",contrastStrongLightColors:"500 600 700 800 900 A400 A700"},brown:{50:"#efebe9",100:"#d7ccc8",200:"#bcaaa4",300:"#a1887f",400:"#8d6e63",500:"#795548",600:"#6d4c41",700:"#5d4037",800:"#4e342e",900:"#3e2723",A100:"#d7ccc8",A200:"#bcaaa4",A400:"#8d6e63",A700:"#5d4037",contrastDefaultColor:"light",contrastDarkColors:"50 100 200",contrastStrongLightColors:"300 400"},grey:{0:"#ffffff",50:"#fafafa",100:"#f5f5f5",200:"#eeeeee",300:"#e0e0e0",400:"#bdbdbd",500:"#9e9e9e",600:"#757575",700:"#616161",800:"#424242",900:"#212121",1e3:"#000000",A100:"#ffffff",A200:"#eeeeee",A400:"#bdbdbd",A700:"#616161",contrastDefaultColor:"dark",contrastLightColors:"600 700 800 900"},"blue-grey":{50:"#eceff1",100:"#cfd8dc",200:"#b0bec5",300:"#90a4ae",400:"#78909c",500:"#607d8b",600:"#546e7a",700:"#455a64",800:"#37474f",900:"#263238",A100:"#cfd8dc",A200:"#b0bec5",A400:"#78909c",A700:"#455a64",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300",contrastStrongLightColors:"400 500"}})}(),function(){"use strict";function e(e){function t(e,t){return t=t||{},d[e]=o(e,t),s}function n(e,t){return o(e,angular.extend({},d[e]||{},t))}function o(e,t){var n=T.filter(function(e){return!t[e]});if(n.length)throw new Error("Missing colors %1 in palette %2!".replace("%1",n.join(", ")).replace("%2",e));return t}function a(e,t){if(t=t||"default",l[e])return l[e];var n="string"==typeof t?l[t]:t,r=new i(e);return n&&angular.forEach(n.colors,function(e,t){r.colors[t]={name:e.name,hues:angular.extend({},e.hues)}}),l[e]=r,r}function i(e){function t(e){if(e=0===arguments.length?!0:!!e,e!==n.isDark){n.isDark=e,n.foregroundPalette=n.isDark?f:u,n.foregroundShadow=n.isDark?p:h;var t=n.isDark?A:M,r=n.isDark?M:A;return angular.forEach(t,function(e,t){var o=n.colors[t],a=r[t];if(o)for(var i in o.hues)o.hues[i]===a[i]&&(o.hues[i]=e[i])}),n}}var n=this;n.name=e,n.colors={},n.dark=t,t(!1),E.forEach(function(e){var t=(n.isDark?A:M)[e];n[e+"Palette"]=function(r,o){var a=n.colors[e]={name:r,hues:angular.extend({},t,o)};return Object.keys(a.hues).forEach(function(e){if(!t[e])throw new Error("Invalid hue name '%1' in theme %2's %3 color %4. Available hue names: %4".replace("%1",e).replace("%2",n.name).replace("%3",r).replace("%4",Object.keys(t).join(", ")))}),Object.keys(a.hues).map(function(e){return a.hues[e]}).forEach(function(t){if(-1==T.indexOf(t))throw new Error("Invalid hue value '%1' in theme %2's %3 color %4. Available hue values: %5".replace("%1",t).replace("%2",n.name).replace("%3",e).replace("%4",r).replace("%5",T.join(", ")))}),n},n[e+"Color"]=function(){var t=Array.prototype.slice.call(arguments);return console.warn("$mdThemingProviderTheme."+e+"Color() has been deprecated. Use $mdThemingProviderTheme."+e+"Palette() instead."),
n[e+"Palette"].apply(n,t)}})}function m(e,t){function n(e){return void 0===e||""===e?!0:void 0!==l[e]}function r(t,n){void 0===n&&(n=t,t=void 0),void 0===t&&(t=e),r.inherit(n,n)}return r.inherit=function(r,o){function a(e){n(e)||t.warn("Attempted to use unregistered theme '"+e+"'. Register it with $mdThemingProvider.theme().");var o=r.data("$mdThemeName");o&&r.removeClass("md-"+o+"-theme"),r.addClass("md-"+e+"-theme"),r.data("$mdThemeName",e)}var i=o.controller("mdTheme"),c=r.attr("md-theme-watch");if((b||angular.isDefined(c))&&"false"!=c){var d=e.$watch(function(){return i&&i.$mdTheme||g},a);r.on("$destroy",d)}else{var l=i&&i.$mdTheme||g;a(l)}},r.registered=n,r.defaultTheme=function(){return g},r}d={},l={};var g="default",b=!1;return angular.extend(d,e),m.$inject=["$rootScope","$log"],s={definePalette:t,extendPalette:n,theme:a,setDefaultTheme:function(e){g=e},alwaysWatchTheme:function(e){b=e},$get:m,_LIGHT_DEFAULT_HUES:M,_DARK_DEFAULT_HUES:A,_PALETTES:d,_THEMES:l,_parseRules:r,_rgba:c}}function t(e,t,n){return{priority:100,link:{pre:function(r,o,a){var i={$setTheme:function(t){e.registered(t)||n.warn("attempted to use unregistered theme '"+t+"'"),i.$mdTheme=t}};o.data("$mdThemeController",i),i.$setTheme(t(a.mdTheme)(r)),a.$observe("mdTheme",i.$setTheme)}}}}function n(e){return e}function r(e,t,n){a(e,t),n=n.replace(/THEME_NAME/g,e.name);var r=[],o=e.colors[t],i=new RegExp(".md-"+e.name+"-theme","g"),l=new RegExp("('|\")?{{\\s*("+t+")-(color|contrast)-?(\\d\\.?\\d*)?\\s*}}(\"|')?","g"),s=/'?"?\{\{\s*([a-zA-Z]+)-(A?\d+|hue\-[0-3]|shadow)-?(\d\.?\d*)?\s*\}\}'?"?/g,m=d[o.name];return n=n.replace(s,function(t,n,r,o){return"foreground"===n?"shadow"==r?e.foregroundShadow:e.foregroundPalette[r]||e.foregroundPalette[1]:(0===r.indexOf("hue")&&(r=e.colors[n].hues[r]),c((d[e.colors[n].name][r]||"").value,o))}),angular.forEach(o.hues,function(t,o){var a=n.replace(l,function(e,n,r,o,a){return c(m[t]["color"===o?"value":"contrast"],a)});"default"!==o&&(a=a.replace(i,".md-"+e.name+"-theme.md-"+o)),r.push(a)}),r.join("")}function o(e){function t(e){var t=e.contrastDefaultColor,n=e.contrastLightColors||[],r=e.contrastStrongLightColors||[],o=e.contrastDarkColors||[];"string"==typeof n&&(n=n.split(" ")),"string"==typeof r&&(r=r.split(" ")),"string"==typeof o&&(o=o.split(" ")),delete e.contrastDefaultColor,delete e.contrastLightColors,delete e.contrastStrongLightColors,delete e.contrastDarkColors,angular.forEach(e,function(a,c){function d(){return"light"===t?o.indexOf(c)>-1?g:r.indexOf(c)>-1?v:b:n.indexOf(c)>-1?r.indexOf(c)>-1?v:b:g}if(!angular.isObject(a)){var l=i(a);if(!l)throw new Error("Color %1, in palette %2's hue %3, is invalid. Hex or rgb(a) color expected.".replace("%1",a).replace("%2",e.name).replace("%3",c));e[c]={value:l,contrast:d()}}})}var n=e.has("$MD_THEME_CSS")?e.get("$MD_THEME_CSS"):"";angular.forEach(d,t);var o=n.split(/\}(?!(\}|'|"|;))/).filter(function(e){return e&&e.length}).map(function(e){return e.trim()+"}"}),a={};E.forEach(function(e){a[e]=""});var c=new RegExp("md-("+E.join("|")+")","g");o.forEach(function(e){for(var t,n=(e.match(c),0);t=E[n];n++)if(e.indexOf(".md-"+t)>-1)return a[t]+=e;for(n=0;t=E[n];n++)if(e.indexOf(t)>-1)return a[t]+=e;return a[$]+=e});var s="";if(angular.forEach(l,function(e){E.forEach(function(t){s+=r(e,t,a[t]+"")}),e.colors.primary.name==e.colors.accent.name&&console.warn("$mdThemingProvider: Using the same palette for primary and accent. This violates the material design spec.")}),!m){var u=document.createElement("style");u.innerHTML=s;var f=document.getElementsByTagName("head")[0];f.insertBefore(u,f.firstElementChild),m=!0}}function a(e,t){if(!d[(e.colors[t]||{}).name])throw new Error("You supplied an invalid color palette for theme %1's %2 palette. Available palettes: %3".replace("%1",e.name).replace("%2",t).replace("%3",Object.keys(d).join(", ")))}function i(e){if(angular.isArray(e)&&3==e.length)return e;if(/^rgb/.test(e))return e.replace(/(^\s*rgba?\(|\)\s*$)/g,"").split(",").map(function(e,t){return 3==t?parseFloat(e,10):parseInt(e,10)});if("#"==e.charAt(0)&&(e=e.substring(1)),/^([a-fA-F0-9]{3}){1,2}$/g.test(e)){var t=e.length/3,n=e.substr(0,t),r=e.substr(t,t),o=e.substr(2*t);return 1===t&&(n+=n,r+=r,o+=o),[parseInt(n,16),parseInt(r,16),parseInt(o,16)]}}function c(e,t){return 4==e.length&&(e=angular.copy(e),t?e.pop():t=e.pop()),t&&("number"==typeof t||"string"==typeof t&&t.length)?"rgba("+e.join(",")+","+t+")":"rgb("+e.join(",")+")"}angular.module("material.core.theming",["material.core.theming.palette"]).directive("mdTheme",t).directive("mdThemable",n).provider("$mdTheming",e).run(o);var d,l,s,m,u={name:"dark",1:"rgba(0,0,0,0.87)",2:"rgba(0,0,0,0.54)",3:"rgba(0,0,0,0.26)",4:"rgba(0,0,0,0.12)"},f={name:"light",1:"rgba(255,255,255,1.0)",2:"rgba(255,255,255,0.7)",3:"rgba(255,255,255,0.3)",4:"rgba(255,255,255,0.12)"},p="1px 1px 0px rgba(0,0,0,0.4), -1px -1px 0px rgba(0,0,0,0.4)",h="",g=i("rgba(0,0,0,0.87)"),b=i("rgba(255,255,255,0.87"),v=i("rgb(255,255,255)"),E=["primary","accent","warn","background"],$="primary",M={accent:{"default":"A200","hue-1":"A100","hue-2":"A400","hue-3":"A700"}},A={background:{"default":"500","hue-1":"300","hue-2":"600","hue-3":"800"}};E.forEach(function(e){var t={"default":"500","hue-1":"300","hue-2":"800","hue-3":"A100"};M[e]||(M[e]=t),A[e]||(A[e]=t)});var T=["50","100","200","300","400","500","600","700","800","900","A100","A200","A400","A700"];e.$inject=["$mdColorPalette"],t.$inject=["$mdTheming","$interpolate","$log"],n.$inject=["$mdTheming"],o.$inject=["$injector"]}(),function(){"use strict";angular.module("material.components.autocomplete",["material.core","material.components.icon"])}(),function(){"use strict";function e(e){return e}angular.module("material.components.backdrop",["material.core"]).directive("mdBackdrop",e),e.$inject=["$mdTheming"]}(),function(){"use strict";function e(){return{restrict:"E"}}function t(e){function t(e,t,o,a,i,c,d,l,s,m){function u(n,r,a){h=i('<md-backdrop class="md-opaque md-bottom-sheet-backdrop">')(n),h.on("click",function(){o(d.cancel)}),c.inherit(h,a.parent),e.enter(h,a.parent,null);var s=new p(r,a.parent);return a.bottomSheet=s,a.targetEvent&&angular.element(a.targetEvent.target).blur(),c.inherit(s.element,a.parent),a.disableParentScroll&&(a.lastOverflow=a.parent.css("overflow"),a.parent.css("overflow","hidden")),e.enter(s.element,a.parent).then(function(){var e=angular.element(r[0].querySelector("button")||r[0].querySelector("a")||r[0].querySelector("[ng-click]"));e.focus(),a.escapeToClose&&(a.rootElementKeyupCallback=function(e){e.keyCode===t.KEY_CODE.ESCAPE&&o(d.cancel)},l.on("keyup",a.rootElementKeyupCallback))})}function f(t,n,r){var o=r.bottomSheet;return e.leave(h),e.leave(o.element).then(function(){r.disableParentScroll&&(r.parent.css("overflow",r.lastOverflow),delete r.lastOverflow),o.cleanup(),r.targetEvent&&angular.element(r.targetEvent.target).focus()})}function p(e,a){function i(){e.css(t.CSS.TRANSITION_DURATION,"0ms")}function c(n){var o=n.pointer.distanceY;5>o&&(o=Math.max(-r,o/2)),e.css(t.CSS.TRANSFORM,"translate3d(0,"+(r+o)+"px,0)")}function l(r){if(r.pointer.distanceY>0&&(r.pointer.distanceY>20||Math.abs(r.pointer.velocityY)>n)){var a=e.prop("offsetHeight")-r.pointer.distanceY,i=Math.min(a/r.pointer.velocityY*.75,500);e.css(t.CSS.TRANSITION_DURATION,i+"ms"),o(d.cancel)}else e.css(t.CSS.TRANSITION_DURATION,""),e.css(t.CSS.TRANSFORM,"")}var s=m.register(a,"drag",{horizontal:!1});return a.on("$md.dragstart",i).on("$md.drag",c).on("$md.dragend",l),{element:e,cleanup:function(){s(),a.off("$md.dragstart",i).off("$md.drag",c).off("$md.dragend",l)}}}var h;return{themable:!0,targetEvent:null,onShow:u,onRemove:f,escapeToClose:!0,disableParentScroll:!0}}var n=.5,r=80;return t.$inject=["$animate","$mdConstant","$timeout","$$rAF","$compile","$mdTheming","$mdBottomSheet","$rootElement","$rootScope","$mdGesture"],e("$mdBottomSheet").setDefaults({methods:["disableParentScroll","escapeToClose","targetEvent"],options:t})}angular.module("material.components.bottomSheet",["material.core","material.components.backdrop"]).directive("mdBottomSheet",e).provider("$mdBottomSheet",t),t.$inject=["$$interimElementProvider"]}(),function(){"use strict";function e(e){return{restrict:"E",link:function(t,n){e(n)}}}angular.module("material.components.card",["material.core"]).directive("mdCard",e),e.$inject=["$mdTheming"]}(),function(){"use strict";function e(e,t,n){function r(e){return angular.isDefined(e.href)||angular.isDefined(e.ngHref)}function o(e,t){return r(t)?'<a class="md-button" ng-transclude></a>':'<button class="md-button" ng-transclude></button>'}function a(o,a,i){var c=a[0];t(a),e.attachButtonBehavior(o,a);var d=c.textContent.trim();d||n.expect(a,"aria-label"),r(i)&&angular.isDefined(i.ngDisabled)&&o.$watch(i.ngDisabled,function(e){a.attr("tabindex",e?-1:0)})}return{restrict:"E",replace:!0,transclude:!0,template:o,link:a}}angular.module("material.components.button",["material.core"]).directive("mdButton",e),e.$inject=["$mdInkRipple","$mdTheming","$mdAria"]}(),function(){"use strict";function e(e,t,n,r,o,a){function i(t,i){return i.type="checkbox",i.tabIndex=0,t.attr("role",i.type),function(t,i,d,l){function s(e){e.which===r.KEY_CODE.SPACE&&(e.preventDefault(),m(e))}function m(e){i[0].hasAttribute("disabled")||t.$apply(function(){f=!f,l.$setViewValue(f,e&&e.type),l.$render()})}function u(){f=l.$viewValue,f?i.addClass(c):i.removeClass(c)}l=l||a.fakeNgModel();var f=!1;o(i),d.ngChecked&&t.$watch(t.$eval.bind(t,d.ngChecked),l.$setViewValue.bind(l)),n.expectWithText(i,"aria-label"),e.link.pre(t,{on:angular.noop,0:{}},d,[l]),i.on("click",m).on("keypress",s),l.$render=u}}e=e[0];var c="md-checked";return{restrict:"E",transclude:!0,require:"?ngModel",template:'<div class="md-container" md-ink-ripple md-ink-ripple-checkbox><div class="md-icon"></div></div><div ng-transclude class="md-label"></div>',compile:i}}angular.module("material.components.checkbox",["material.core"]).directive("mdCheckbox",e),e.$inject=["inputDirective","$mdInkRipple","$mdAria","$mdConstant","$mdTheming","$mdUtil"]}(),function(){"use strict";function e(e){function n(e,t){this.$scope=e,this.$element=t}return{restrict:"E",controller:["$scope","$element",n],link:function(n,r){r[0],e(r),n.$broadcast("$mdContentLoaded",r),t(r[0])}}}function t(e){angular.element(e).on("$md.pressdown",function(t){"t"===t.pointer.type&&(t.$materialScrollFixed||(t.$materialScrollFixed=!0,0===e.scrollTop?e.scrollTop=1:e.scrollHeight===e.scrollTop+e.offsetHeight&&(e.scrollTop-=1)))})}angular.module("material.components.content",["material.core"]).directive("mdContent",e),e.$inject=["$mdTheming"]}(),function(){"use strict";function e(e,t){return{restrict:"E",link:function(n,r){t(r),e(function(){var e=r[0].querySelector("md-content");e&&e.scrollHeight>e.clientHeight&&r.addClass("md-content-overflow")})}}}function t(e){function t(e,t){return{template:['<md-dialog md-theme="{{ dialog.theme }}" aria-label="{{ dialog.ariaLabel }}">',"<md-content>","<h2>{{ dialog.title }}</h2>","<p>{{ dialog.content }}</p>","</md-content>",'<div class="md-actions">','<md-button ng-if="dialog.$type == \'confirm\'" ng-click="dialog.abort()">',"{{ dialog.cancel }}","</md-button>",'<md-button ng-click="dialog.hide()" class="md-primary">',"{{ dialog.ok }}","</md-button>","</div>","</md-dialog>"].join(""),controller:function(){this.hide=function(){e.hide(!0)},this.abort=function(){e.cancel()}},controllerAs:"dialog",bindToController:!0,theme:t.defaultTheme()}}function n(e,t,n,r,o,a,i,c,d,l,s,m){function u(n,o,i){function l(){var e=o[0].querySelector(".dialog-close");if(!e){var t=o[0].querySelectorAll(".md-actions button");e=t[t.length-1]}return angular.element(e)}i.parent=angular.element(i.parent),i.popInTarget=angular.element((i.targetEvent||{}).target);var s=l();if(p(o.find("md-dialog")),i.hasBackdrop){var u=i.parent[0]==a[0].body&&a[0].documentElement&&a[0].scrollTop?angular.element(a[0].documentElement):i.parent,f=u.prop("scrollTop");i.backdrop=angular.element('<md-backdrop class="md-dialog-backdrop md-opaque">'),d.inherit(i.backdrop,i.parent),r.enter(i.backdrop,i.parent),o.css("top",f+"px")}return i.disableParentScroll&&(i.lastOverflow=i.parent.css("overflow"),i.parent.css("overflow","hidden")),h(o,i.parent,i.popInTarget&&i.popInTarget.length&&i.popInTarget).then(function(){i.escapeToClose&&(i.rootElementKeyupCallback=function(t){t.keyCode===c.KEY_CODE.ESCAPE&&e(m.cancel)},t.on("keyup",i.rootElementKeyupCallback)),i.clickOutsideToClose&&(i.dialogClickOutsideCallback=function(t){t.target===o[0]&&e(m.cancel)},o.on("click",i.dialogClickOutsideCallback)),s.focus()})}function f(e,n,o){return o.backdrop&&r.leave(o.backdrop),o.disableParentScroll&&(o.parent.css("overflow",o.lastOverflow),delete o.lastOverflow),o.escapeToClose&&t.off("keyup",o.rootElementKeyupCallback),o.clickOutsideToClose&&n.off("click",o.dialogClickOutsideCallback),g(n,o.parent,o.popInTarget&&o.popInTarget.length&&o.popInTarget).then(function(){o.scope.$destroy(),n.remove(),o.popInTarget&&o.popInTarget.focus()})}function p(e){e.attr({role:"dialog"});var t=e.find("md-content");0===t.length&&(t=e),o.expectAsync(e,"aria-label",function(){var e=t.text().split(/\s+/);return e.length>3&&(e=e.slice(0,3).concat("...")),e.join(" ")})}function h(e,t,n){var r=e.find("md-dialog");return t.append(e),b(r,n),l(function(){r.addClass("transition-in").css(c.CSS.TRANSFORM,"")}),i.transitionEndPromise(r)}function g(e,t,n){var r=e.find("md-dialog");return r.addClass("transition-out").removeClass("transition-in"),b(r,n),i.transitionEndPromise(r)}function b(e,t){if(t){var n=t[0].getBoundingClientRect(),r=e[0].getBoundingClientRect(),o=Math.min(.5,n.width/r.width),a=Math.min(.5,n.height/r.height);e.css(c.CSS.TRANSFORM,"translate3d("+(-r.left+n.left+n.width/2-r.width/2)+"px,"+(-r.top+n.top+n.height/2-r.height/2)+"px,0) scale("+o+","+a+")")}}return{hasBackdrop:!0,isolateScope:!0,onShow:u,onRemove:f,clickOutsideToClose:!0,escapeToClose:!0,targetEvent:null,disableParentScroll:!0,transformTemplate:function(e){return'<div class="md-dialog-container">'+e+"</div>"}}}return t.$inject=["$mdDialog","$mdTheming"],n.$inject=["$timeout","$rootElement","$compile","$animate","$mdAria","$document","$mdUtil","$mdConstant","$mdTheming","$$rAF","$q","$mdDialog"],e("$mdDialog").setDefaults({methods:["disableParentScroll","hasBackdrop","clickOutsideToClose","escapeToClose","targetEvent"],options:n}).addPreset("alert",{methods:["title","content","ariaLabel","ok","theme"],options:t}).addPreset("confirm",{methods:["title","content","ariaLabel","ok","cancel","theme"],options:t})}angular.module("material.components.dialog",["material.core","material.components.backdrop"]).directive("mdDialog",e).provider("$mdDialog",t),e.$inject=["$$rAF","$mdTheming"],t.$inject=["$$interimElementProvider"]}(),function(){"use strict";function e(){}function t(t){return{restrict:"E",link:t,controller:[e]}}angular.module("material.components.divider",["material.core"]).directive("mdDivider",t),t.$inject=["$mdTheming"]}(),function(){"use strict";function e(e,n,r,o){function a(t,a,i,c){function d(){for(var e in n.MEDIA)o(e),o.getQuery(n.MEDIA[e]).addListener(M);return o.watchResponsiveAttributes(["md-cols","md-row-height"],i,s)}function l(){A();for(var e in n.MEDIA)o.getQuery(n.MEDIA[e]).removeListener(M)}function s(e){null==e?c.invalidateLayout():o(e)&&c.invalidateLayout()}function m(){var e=p(),n=g(),o=E(),i=v(),c=b(),d=r(n,h(),p()).map(function(t,r){return{grid:{element:a,style:f(n,r,c,o,i)},tiles:t.map(function(t,a){return{element:angular.element(e[a]),style:u(t.position,t.spans,n,r,c,o,i)}})}}).reflow().performance();t.mdOnLayout({$event:{performance:d}})}function u(e,t,n,r,o,a,i){var c=1/n*100,d=1===n?0:(n-1)/n,l=T({share:c,gutterShare:d,gutter:o}),s={left:w({unit:l,offset:e.col,gutter:o}),width:k({unit:l,span:t.col,gutter:o}),paddingTop:"",marginTop:"",top:"",height:""};switch(a){case"fixed":s.top=w({unit:i,offset:e.row,gutter:o}),s.height=k({unit:i,span:t.row,gutter:o});break;case"ratio":var m=c*(1/i),u=T({share:m,gutterShare:d,gutter:o});s.paddingTop=k({unit:u,span:t.row,gutter:o}),s.marginTop=w({unit:u,offset:e.row,gutter:o});break;case"fit":var f=1===r?0:(r-1)/r,m=1/r*100,u=T({share:m,gutterShare:f,gutter:o});s.top=w({unit:u,offset:e.row,gutter:o}),s.height=k({unit:u,span:t.row,gutter:o})}return s}function f(e,t,n,r,o){var a={height:"",paddingBottom:""};switch(r){case"fixed":a.height=k({unit:o,span:t,gutter:n});break;case"ratio":var i=1===e?0:(e-1)/e,c=1/e*100,d=c*(1/o),l=T({share:d,gutterShare:i,gutter:n});a.paddingBottom=k({unit:l,span:t,gutter:n});break;case"fit":}return a}function p(){return c.tiles.map(function(e){return e.element})}function h(){return c.tiles.map(function(e){return{row:parseInt(o.getResponsiveAttribute(e.attrs,"md-rowspan"),10)||1,col:parseInt(o.getResponsiveAttribute(e.attrs,"md-colspan"),10)||1}})}function g(){var e=parseInt(o.getResponsiveAttribute(i,"md-cols"),10);if(isNaN(e))throw"md-grid-list: md-cols attribute was not found, or contained a non-numeric value";return e}function b(){return $(o.getResponsiveAttribute(i,"md-gutter")||1)}function v(){var e=o.getResponsiveAttribute(i,"md-row-height");switch(E()){case"fixed":return $(e);case"ratio":var t=e.split(":");return parseFloat(t[0])/parseFloat(t[1]);case"fit":return 0}}function E(){var e=o.getResponsiveAttribute(i,"md-row-height");return"fit"==e?"fit":-1!==e.indexOf(":")?"ratio":"fixed"}function $(e){return/\D$/.test(e)?e:e+"px"}a.attr("role","list"),c.layoutDelegate=m;var M=angular.bind(c,c.invalidateLayout),A=d();t.$on("$destroy",l);var T=e("{{ share }}% - ({{ gutter }} * {{ gutterShare }})"),w=e("calc(({{ unit }}) * {{ offset }} + {{ offset }} * {{ gutter }})"),k=e("calc(({{ unit }}) * {{ span }} + ({{ span }} - 1) * {{ gutter }})")}return{restrict:"E",controller:t,scope:{mdOnLayout:"&"},link:a}}function t(e){this.invalidated=!1,this.$timeout_=e,this.tiles=[],this.layoutDelegate=angular.noop}function n(e){function t(t,n){var a,i,c,d,l,s,i;return d=e.time(function(){i=r(t,n)}),a={layoutInfo:function(){return i},map:function(t){return l=e.time(function(){var e=a.layoutInfo();c=t(e.positioning,e.rowCount)}),a},reflow:function(t){return s=e.time(function(){var e=t||o;e(c.grid,c.tiles)}),a},performance:function(){return{tileCount:n.length,layoutTime:d,mapTime:l,reflowTime:s,totalTime:d+l+s}}}}function n(e,t){e.element.css(e.style),t.forEach(function(e){e.element.css(e.style)})}function r(e,t){function n(t,n){if(t.col>e)throw"md-grid-list: Tile at position "+n+" has a colspan ("+t.col+") that exceeds the column count ("+e+")";for(var i=0,s=0;s-i<t.col;)c>=e?r():(i=l.indexOf(0,c),-1!==i&&-1!==(s=a(i+1))?c=s+1:(i=s=0,r()));return o(i,t.col,t.row),c=i+t.col,{col:i,row:d}}function r(){c=0,d++,o(0,e,-1)}function o(e,t,n){for(var r=e;e+t>r;r++)l[r]=Math.max(l[r]+n,0)}function a(e){var t;for(t=e;t<l.length;t++)if(0!==l[t])return t;return t===l.length?t:void 0}function i(){for(var t=[],n=0;e>n;n++)t.push(0);return t}var c=0,d=0,l=i();return{positioning:t.map(function(e,t){return{spans:e,position:n(e,t)}}),rowCount:d+Math.max.apply(Math,l)}}var o=n;return t.animateWith=function(e){o=angular.isFunction(e)?e:n},t}function r(e){function t(t,n,r,o){n.attr("role","listitem");var a=e.watchResponsiveAttributes(["md-colspan","md-rowspan"],r,angular.bind(o,o.invalidateLayout));o.addTile(n,r,t.$parent.$index),t.$on("$destroy",function(){a(),o.removeTile(n,r)})}return{restrict:"E",require:"^mdGridList",template:"<figure ng-transclude></figure>",transclude:!0,scope:{},link:t}}function o(){return{template:"<figcaption ng-transclude></figcaption>",transclude:!0}}angular.module("material.components.gridList",["material.core"]).directive("mdGridList",e).directive("mdGridTile",r).directive("mdGridTileFooter",o).directive("mdGridTileHeader",o).factory("$mdGridLayout",n),e.$inject=["$interpolate","$mdConstant","$mdGridLayout","$mdMedia","$mdUtil"],t.$inject=["$timeout"],t.prototype={addTile:function(e,t,n){var r={element:e,attrs:t};angular.isUndefined(n)?this.tiles.push(r):this.tiles.splice(n,0,r),this.invalidateLayout()},removeTile:function(e,t){var n=this._findTileIndex(t);-1!==n&&(this.tiles.splice(n,1),this.invalidateLayout())},invalidateLayout:function(){this.invalidated||(this.invalidated=!0,this.$timeout_(angular.bind(this,this.layout)))},layout:function(){try{this.layoutDelegate()}finally{this.invalidated=!1}},_findTileIndex:function(e){for(var t=0;t<this.tiles.length;t++)if(this.tiles[t].attrs==e)return t;return-1}},n.$inject=["$mdUtil"],r.$inject=["$mdMedia"]}(),function(){"use strict";function e(e,t,n){function r(e,t){return t.mdFontIcon?'<span class="md-font" ng-class="fontIcon"></span>':""}function o(r,o,a){function i(){var e=o.parent();return e.attr("aria-label")||e.text()?!0:e.parent().attr("aria-label")||e.parent().text()?!0:!1}t(o);var c=a.alt||r.fontIcon||r.svgIcon,d=a.$normalize(a.$attr.mdSvgIcon||a.$attr.mdSvgSrc||"");""==a.alt||i()?n.expect(o,"aria-hidden","true"):(n.expect(o,"aria-label",c),n.expect(o,"role","img")),d&&a.$observe(d,function(t){o.empty(),t&&e(t).then(function(e){o.append(e)})})}return{scope:{fontIcon:"@mdFontIcon",svgIcon:"@mdSvgIcon",svgSrc:"@mdSvgSrc"},restrict:"E",template:r,link:o}}angular.module("material.components.icon",["material.core"]).directive("mdIcon",e),e.$inject=["$mdIcon","$mdTheming","$mdAria"]}(),function(){"use strict";function e(){}function t(e,t){this.url=e,this.iconSize=t||r.defaultIconSize}function n(e,t,n,r,o){function a(t){return function(n){return h[t]=m(n)?n:new u(n,e[t]),h[t].clone()}}function i(t){var r=e[t];return r?d(r.url).then(function(e){return new u(e,r)}):n.reject(t)}function c(t){function r(e){var r=t.slice(t.lastIndexOf(":")+1),o=e.querySelector("#"+r);return o?new u(o,a):n.reject(t)}var o=t.substring(0,t.lastIndexOf(":"))||"$default",a=e[o];return a?d(a.url).then(r):n.reject(t)}function d(e){return t.get(e,{cache:o}).then(function(e){for(var t=angular.element(e.data),n=0;n<t.length;++n)if("svg"==t[n].nodeName)return t[n]})}function l(e){var t;return angular.isString(e)&&(t="icon "+e+" not found",r.warn(t)),n.reject(t||e)}function s(e){var t=angular.isString(e)?e:e.message||e.data||e.statusText;return r.warn(t),n.reject(t)}function m(e){return angular.isDefined(e.element)&&angular.isDefined(e.config)}function u(e,t){"svg"!=e.tagName&&(e=angular.element('<svg xmlns="http://www.w3.org/2000/svg">').append(e)[0]),e=angular.element(e),e.attr("xmlns")||e.attr("xmlns","http://www.w3.org/2000/svg"),this.element=e,this.config=t,this.prepare()}function f(){var t=this.config?this.config.iconSize:e.defaultIconSize,n=angular.element(this.element);n.attr({fit:"",height:"100%",width:"100%",preserveAspectRatio:"xMidYMid meet",viewBox:n.attr("viewBox")||"0 0 "+t+" "+t}).css({"pointer-events":"none",display:"block"}),this.element=n}function p(){return angular.element(this.element[0].cloneNode(!0))}var h={},g=/[-a-zA-Z0-9@:%_\+.~#?&//=]{2,256}\.[a-z]{2,4}\b(\/[-a-zA-Z0-9@:%_\+.~#?&//=]*)?/i;return u.prototype={clone:p,prepare:f},function(e){return e=e||"",h[e]?n.when(h[e].clone()):g.test(e)?d(e).then(a(e)):(-1==e.indexOf(":")&&(e="$default:"+e),i(e)["catch"](c)["catch"](l)["catch"](s).then(a(e)))}}angular.module("material.components.icon").provider("$mdIcon",e);var r={defaultIconSize:24};e.prototype={icon:function(e,n,o){return-1==e.indexOf(":")&&(e="$default:"+e),r[e]=new t(n,o),this},iconSet:function(e,n,o){return r[e]=new t(n,o),this},defaultIconSet:function(e,n){var o="$default";return r[o]||(r[o]=new t(e,n)),r[o].iconSize=n||r.defaultIconSize,this},defaultIconSize:function(e){return r.defaultIconSize=e,this},preloadIcons:function(e){var t=this,n=[{id:"tabs-arrow",url:"tabs-arrow.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g id="tabs-arrow"><polygon points="15.4,7.4 14,6 8,12 14,18 15.4,16.6 10.8,12 "/></g></svg>'},{id:"close",url:"close.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g id="close"><path d="M19 6.41l-1.41-1.41-5.59 5.59-5.59-5.59-1.41 1.41 5.59 5.59-5.59 5.59 1.41 1.41 5.59-5.59 5.59 5.59 1.41-1.41-5.59-5.59z"/></g></svg>'},{id:"cancel",url:"cancel.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g id="cancel"><path d="M12 2c-5.53 0-10 4.47-10 10s4.47 10 10 10 10-4.47 10-10-4.47-10-10-10zm5 13.59l-1.41 1.41-3.59-3.59-3.59 3.59-1.41-1.41 3.59-3.59-3.59-3.59 1.41-1.41 3.59 3.59 3.59-3.59 1.41 1.41-3.59 3.59 3.59 3.59z"/></g></svg>'}];n.forEach(function(n){t.icon(n.id,n.url),e.put(n.url,n.svg)})},$get:["$http","$q","$log","$templateCache",function(e,t,o,a){return this.preloadIcons(a),new n(r,e,t,o,a)}]}}(),function(){function e(e,t){function n(t,n){e(n)}function r(e,n,r){var o=this;o.isErrorGetter=r.mdIsError&&t(r.mdIsError),o.element=n,o.setFocused=function(e){n.toggleClass("md-input-focused",!!e)},o.setHasValue=function(e){n.toggleClass("md-input-has-value",!!e)},o.setInvalid=function(e){n.toggleClass("md-input-invalid",!!e)},e.$watch(function(){return o.label&&o.input},function(e){e&&!o.label.attr("for")&&o.label.attr("for",o.input.attr("id"))})}return r.$inject=["$scope","$element","$attrs"],{restrict:"E",link:n,controller:r}}function t(){return{restrict:"E",require:"^?mdInputContainer",link:function(e,t,n,r){r&&!n.mdNoFloat&&(r.label=t,e.$on("$destroy",function(){r.label=null}))}}}function n(e,t){function n(n,r,o,a){function i(e){return l.setHasValue(!s.$isEmpty(e)),e}function c(){l.setHasValue(r.val().length>0||(r[0].validity||{}).badInput)}function d(){function o(e){return l(),e}function a(){d.style.height="auto",d.scrollTop=0;var e=i();e&&(d.style.height=e+"px")}function i(){var e=d.scrollHeight-d.offsetHeight;return d.offsetHeight+(e>0?e:0)}function c(){d.scrollTop=0;var e=d.scrollHeight-d.offsetHeight,t=d.offsetHeight+e;d.style.height=t+"px"}var d=r[0],l=e.debounce(a,1);s?(s.$formatters.push(o),s.$viewChangeListeners.push(o)):l(),r.on("keydown input",l),r.on("scroll",c),angular.element(t).on("resize",l),n.$on("$destroy",function(){angular.element(t).off("resize",l)})}var l=a[0],s=a[1]||e.fakeNgModel(),m=angular.isDefined(o.readonly);if(l){if(l.input)throw new Error("<md-input-container> can only have *one* <input> or <textarea> child element!");l.input=r,r.addClass("md-input"),r.attr("id")||r.attr("id","input_"+e.nextUid()),"textarea"===r[0].tagName.toLowerCase()&&d();var u=l.isErrorGetter||function(){return s.$invalid&&s.$touched};n.$watch(u,l.setInvalid),s.$parsers.push(i),s.$formatters.push(i),r.on("input",c),m||r.on("focus",function(){l.setFocused(!0),s.$setTouched(),u()&&l.setInvalid(!0)}).on("blur",function(){l.setFocused(!1),c()}),n.$on("$destroy",function(){l.setFocused(!1),l.setHasValue(!1),l.input=null})}}return{restrict:"E",require:["^?mdInputContainer","?ngModel"],link:n}}function r(e){function t(t,n,r,o){function a(e){return l.text((n.val()||e||"").length+"/"+i),e}var i,c=o[0],d=o[1],l=angular.element('<div class="md-char-counter">');r.$set("ngTrim","false"),d.element.append(l),c.$formatters.push(a),c.$viewChangeListeners.push(a),n.on("input keydown",function(){a()}),t.$watch(r.mdMaxlength,function(t){i=t,angular.isNumber(t)&&t>0?(l.parent().length||e.enter(l,d.element,angular.element(d.element[0].lastElementChild)),a()):e.leave(l)}),c.$validators["md-maxlength"]=function(e,t){return!angular.isNumber(i)||0>i?!0:(e||n.val()||t||"").length<=i}}return{restrict:"A",require:["ngModel","^mdInputContainer"],link:t}}function o(){function e(e,t,n,r){if(r){var o=n.placeholder;t.removeAttr("placeholder"),r.element.append('<div class="md-placeholder">'+o+"</div>")}}return{restrict:"A",require:"^^?mdInputContainer",link:e}}angular.module("material.components.input",["material.core"]).directive("mdInputContainer",e).directive("label",t).directive("input",n).directive("textarea",n).directive("mdMaxlength",r).directive("placeholder",o),e.$inject=["$mdTheming","$parse"],n.$inject=["$mdUtil","$window"],r.$inject=["$animate"]}(),function(){"use strict";function e(){return{restrict:"E",link:function(e,t){t.attr({role:"list"})}}}function t(){return{restrict:"E",link:function(e,t){t.attr({role:"listitem"})}}}angular.module("material.components.list",["material.core"]).directive("mdList",e).directive("mdItem",t)}(),function(){"use strict";function e(e,t,n){function r(e){return e.attr("aria-valuemin",0),e.attr("aria-valuemax",100),e.attr("role","progressbar"),o}function o(e,r,o){n(r);var d,l,s,m,u=r[0],f=u.querySelectorAll(".md-fill, .md-mask.md-full"),p=u.querySelectorAll(".md-fill.md-fix"),h=o.mdDiameter||48,g=h/48;u.style[t.CSS.TRANSFORM]="scale("+g.toString()+")",o.$observe("value",function(e){for(l=a(e),s=i[l],m=c[l],r.attr("aria-valuenow",l),d=0;d<f.length;d++)f[d].style[t.CSS.TRANSFORM]=s;for(d=0;d<p.length;d++)p[d].style[t.CSS.TRANSFORM]=m})}function a(e){return e>100?100:0>e?0:Math.ceil(e||0)}for(var i=new Array(101),c=new Array(101),d=0;101>d;d++){var l=d/100,s=Math.floor(180*l);i[d]="rotate("+s.toString()+"deg)",c[d]="rotate("+(2*s).toString()+"deg)"}return{restrict:"E",template:'<div class="md-spinner-wrapper"><div class="md-inner"><div class="md-gap"></div><div class="md-left"><div class="md-half-circle"></div></div><div class="md-right"><div class="md-half-circle"></div></div></div></div>',compile:r}}angular.module("material.components.progressCircular",["material.core"]).directive("mdProgressCircular",e),e.$inject=["$$rAF","$mdConstant","$mdTheming"]}(),function(){"use strict";function e(e,n,r){function o(e){return e.attr("aria-valuemin",0),e.attr("aria-valuemax",100),e.attr("role","progressbar"),a}function a(o,a,c){r(a);var d=a[0].querySelector(".md-bar1").style,l=a[0].querySelector(".md-bar2").style,s=angular.element(a[0].querySelector(".md-container"));c.$observe("value",function(e){if("query"!=c.mdMode){var r=i(e);a.attr("aria-valuenow",r),l[n.CSS.TRANSFORM]=t[r]}}),c.$observe("mdBufferValue",function(e){d[n.CSS.TRANSFORM]=t[i(e)]}),e(function(){s.addClass("md-ready")})}function i(e){return e>100?100:0>e?0:Math.ceil(e||0)}return{restrict:"E",template:'<div class="md-container"><div class="md-dashed"></div><div class="md-bar md-bar1"></div><div class="md-bar md-bar2"></div></div>',compile:o}}angular.module("material.components.progressLinear",["material.core"]).directive("mdProgressLinear",e),e.$inject=["$$rAF","$mdConstant","$mdTheming"];var t=function(){function e(e){var t=e/100,n=(e-100)/2;return"translateX("+n.toString()+"%) scale("+t.toString()+", 1)"}for(var t=new Array(101),n=0;101>n;n++)t[n]=e(n);return t}()}(),function(){"use strict";function e(e,t,n){function r(r,o,a,i){function c(n){switch(n.keyCode){case t.KEY_CODE.LEFT_ARROW:case t.KEY_CODE.UP_ARROW:n.preventDefault(),d.selectPrevious();break;case t.KEY_CODE.RIGHT_ARROW:case t.KEY_CODE.DOWN_ARROW:n.preventDefault(),d.selectNext();break;case t.KEY_CODE.ENTER:var r=angular.element(e.getClosest(o[0],"form"));r.length>0&&r.triggerHandler("submit")}}n(o);var d=i[0],l=i[1]||e.fakeNgModel();d.init(l),o.attr({role:"radiogroup",tabIndex:o.attr("tabindex")||"0"}).on("keydown",c)}function o(e){this._radioButtonRenderFns=[],this.$element=e}function a(){return{init:function(e){this._ngModelCtrl=e,this._ngModelCtrl.$render=angular.bind(this,this.render)},add:function(e){this._radioButtonRenderFns.push(e)},remove:function(e){var t=this._radioButtonRenderFns.indexOf(e);-1!==t&&this._radioButtonRenderFns.splice(t,1)},render:function(){this._radioButtonRenderFns.forEach(function(e){e()})},setViewValue:function(e,t){this._ngModelCtrl.$setViewValue(e,t),this.render()},getViewValue:function(){return this._ngModelCtrl.$viewValue},selectNext:function(){return i(this.$element,1)},selectPrevious:function(){return i(this.$element,-1)},setActiveDescendant:function(e){this.$element.attr("aria-activedescendant",e)}}}function i(t,n){var r=e.iterator(t[0].querySelectorAll("md-radio-button"),!0);if(r.count()){var o=function(e){return!angular.element(e).attr("disabled")},a=t[0].querySelector("md-radio-button.md-checked"),i=r[0>n?"previous":"next"](a,o)||r.first();angular.element(i).triggerHandler("click")}}return o.prototype=a(),{restrict:"E",controller:["$element",o],
require:["mdRadioGroup","?ngModel"],link:{pre:r}}}function t(e,t,n){function r(r,a,i,c){function d(e){a[0].hasAttribute("disabled")||r.$apply(function(){c.setViewValue(i.value,e&&e.type)})}function l(){var e=c.getViewValue()==i.value;e!==m&&(m=e,a.attr("aria-checked",e),e?(a.addClass(o),c.setActiveDescendant(a.attr("id"))):a.removeClass(o))}function s(n,r){function o(){return i.id||"radio_"+t.nextUid()}r.ariaId=o(),n.attr({id:r.ariaId,role:"radio","aria-checked":"false"}),e.expectWithText(n,"aria-label")}var m;n(a),s(a,r),c.add(l),i.$observe("value",l),a.on("click",d).on("$destroy",function(){c.remove(l)})}var o="md-checked";return{restrict:"E",require:"^mdRadioGroup",transclude:!0,template:'<div class="md-container" md-ink-ripple md-ink-ripple-checkbox><div class="md-off"></div><div class="md-on"></div></div><div ng-transclude class="md-label"></div>',link:r}}angular.module("material.components.radioButton",["material.core"]).directive("mdRadioGroup",e).directive("mdRadioButton",t),e.$inject=["$mdUtil","$mdConstant","$mdTheming"],t.$inject=["$mdAria","$mdUtil","$mdTheming"]}(),function(){"use strict";function e(e,t,n,r,o,a){function i(r,i){var l=r.find("md-select-label").remove();l.length||(l=angular.element("<md-select-label><span></span></md-select-label>")),l.append('<span class="md-select-icon" aria-hidden="true"></span>'),l.addClass("md-select-label"),l.addClass(c+i.ngModel+" !== undefined ? '' : 'md-placeholder'"+d),l.attr("id","select_label_"+t.nextUid()),r.find("md-content").length||r.append(angular.element("<md-content>").append(r.contents())),i.mdOnOpen&&r.find("md-content").prepend(angular.element("<md-progress-circular>").attr("md-mode","indeterminate").attr("ng-hide","$$loadingAsyncDone").wrap("<div>").parent());var s=angular.element('<div class="md-select-menu-container"><md-select-menu '+(angular.isDefined(i.multiple)?"multiple":"")+">"+r.html()+"</md-select-menu></div>");return r.empty().append(l),n(r),function(n,r,i,c){function d(){if(a(i.ngModel)(n)){var e=angular.element(s).find("md-select-menu");e.data("$ngModelController",c);var t=n.$new();e=o(e)(t);var r=e.controller("mdSelectMenu");t.$$postDigest(function(){c.$render(),l(r.selectedLabels()),e.scope().$destroy()})}else l()}function l(e){if(!h){var t=e||i.placeholder;p.html(t)}}function m(e){var t=[32,13,38,40];-1!=t.indexOf(e.keyCode)&&(e.preventDefault(),u(e))}function u(){n.$evalAsync(function(){var t=s.clone();t.find("md-select-menu").data("$ngModelController",c),f=!0,e.show({scope:n.$new(),element:t,target:r[0],hasBackdrop:!0,loadingAsync:i.mdOnOpen?n.$eval(i.mdOnOpen):!1,setLabelText:l}).then(function(){f=!1})})}var f,p=r.find("md-select-label"),h=0!==p.text().length;h||(p=p.children().eq(0)),d(),i.$observe("disabled",function(e){void 0!==e?(r.attr("tabindex",-1),r.off("click",u),r.off("keydown",m)):(r.attr("tabindex",0),r.on("click",u),r.on("keydown",m))}),void 0===i.disabled&&(r.on("click",u),r.on("keydown",m)),r.attr({role:"combobox",id:"select_"+t.nextUid(),"aria-haspopup":!0,"aria-expanded":"false","aria-labelledby":p.attr("id")}),n.$on("$destroy",function(){f&&e.cancel()})}}var c=r.startSymbol(),d=r.endSymbol();return{restrict:"E",require:"?ngModel",compile:i}}function t(e,t,n){function r(e,r,o,a){function i(){r.attr({id:"select_menu_"+t.nextUid(),role:"listbox","aria-multiselectable":l.isMultiple?"true":"false"})}function c(e){(13==e.keyCode||32==e.keyCode)&&d(e)}function d(n){var r=t.getClosest(n.target,"md-option"),o=r&&angular.element(r).data("$mdOptionController");if(r&&o){var a=l.hashGetter(o.value),i=angular.isDefined(l.selected[a]);e.$apply(function(){l.isMultiple?i?l.deselect(a):l.select(a,o.value):i||(l.deselect(Object.keys(l.selected)[0]),l.select(a,o.value)),l.refreshViewValue()})}}var l=a[0],s=a[1];n(r),r.on("click",d),r.on("keypress",c),s&&l.init(s),i()}function o(t,n,r){function o(){var e=d.ngModel.$modelValue||d.ngModel.$viewValue;if(angular.isArray(e)){var t=Object.keys(d.selected),n=e.map(d.hashGetter),r=t.filter(function(e){return-1===n.indexOf(e)});r.forEach(d.deselect),n.forEach(function(t,n){d.select(t,e[n])})}}function i(){var e=d.ngModel.$viewValue||d.ngModel.$modelValue;Object.keys(d.selected).forEach(d.deselect),d.select(d.hashGetter(e),e)}var d=this;d.isMultiple=angular.isDefined(n.multiple),d.selected={},d.options={},d.init=function(r){function a(e,t){return angular.isArray(e||t||[])}if(d.ngModel=r,r.$options&&r.$options.trackBy){var l={},s=e(r.$options.trackBy);d.hashGetter=function(e,n){return l.$value=e,s(n||t,l)}}else d.hashGetter=function(e){return angular.isObject(e)?"$$object_"+(e.$$mdSelectId||(e.$$mdSelectId=++c)):e};d.isMultiple?(r.$validators["md-multiple"]=a,r.$render=o,t.$watchCollection(n.ngModel,function(e){a(e)&&o(e)})):r.$render=i},d.selectedLabels=function(){var e=a(r[0].querySelectorAll("md-option[selected]"));return e.length?e.map(function(e){return e.textContent}).join(", "):""},d.select=function(e,t){var n=d.options[e];n&&n.setSelected(!0),d.selected[e]=t},d.deselect=function(e){var t=d.options[e];t&&t.setSelected(!1),delete d.selected[e]},d.addOption=function(e,t){if(angular.isDefined(d.options[e]))throw new Error('Duplicate md-option values are not allowed in a select. Duplicate value "'+t.value+'" found.');d.options[e]=t,angular.isDefined(d.selected[e])&&(d.select(e,t.value),d.refreshViewValue())},d.removeOption=function(e){delete d.options[e]},d.refreshViewValue=function(){var e,t=[];for(var n in d.selected)t.push((e=d.options[n])?e.value:d.selected[n]);d.ngModel.$setViewValue(d.isMultiple?t:t[0])}}return o.$inject=["$scope","$attrs","$element"],{restrict:"E",require:["mdSelectMenu","?ngModel"],controller:o,link:{pre:r}}}function n(e,t){function n(e,t){return e.append(angular.element('<div class="md-text">').append(e.contents())),void 0===t.tabindex&&e.attr("tabindex",0),r}function r(n,r,o,a){function i(e,t){var r=l.hashGetter(t,n),o=l.hashGetter(e,n);d.hashKey=o,d.value=e,l.removeOption(r,d),l.addOption(o,d)}function c(){r.attr({role:"option","aria-selected":"false",id:"select_option_"+t.nextUid()})}var d=a[0],l=a[1];if(angular.isDefined(o.ngValue))n.$watch(o.ngValue,i);else{if(!angular.isDefined(o.value))throw new Error("Expected either ngValue or value attr");i(o.value)}e.attachButtonBehavior(n,r),c(),n.$on("$destroy",function(){l.removeOption(d.hashKey,d)})}function o(e){this.selected=!1,this.setSelected=function(t){t&&!this.selected?e.attr({selected:"selected","aria-selected":"true"}):!t&&this.selected&&(e.removeAttr("selected"),e.attr("aria-selected","false")),this.selected=t}}return o.$inject=["$element"],{restrict:"E",require:["mdOption","^^mdSelectMenu"],controller:o,compile:n}}function r(){function e(e,t){var n=e.find("label");n.length||(n=angular.element("<label>"),e.prepend(n)),t.label&&n.text(t.label)}return{restrict:"E",compile:e}}function o(e){function t(e,t,o,c,d,l){function s(n,r,i){function s(){i.selectEl.attr("aria-labelledby",i.target.attr("id")),i.target.attr("aria-owns",i.selectEl.attr("id")),i.target.attr("aria-expanded","true")}function m(){function o(){var e;-1==(e=f.indexOf(i.focusedNode))?e=Math.floor((f.length-1)/2):e<f.length-1&&++e,i.focusedNode=f[e],f[e].focus()}function a(){var e;-1==(e=f.indexOf(i.focusedNode))?e=Math.floor((f.length-1)/2):e>0&&--e,i.focusedNode=f[e],f[e].focus()}function c(){i.restoreFocus=!0,n.$evalAsync(function(){e.hide(d.ngModel.$viewValue)})}if(!i.isRemoved){var d=i.selectEl.controller("mdSelectMenu")||{};r.addClass("md-clickable"),i.backdrop&&i.backdrop.on("click",function(t){t.preventDefault(),t.stopPropagation(),i.restoreFocus=!1,n.$apply(e.cancel)}),i.selectEl.on("keydown",function(r){switch(r.keyCode){case t.KEY_CODE.TAB:case t.KEY_CODE.ESCAPE:r.preventDefault(),i.restoreFocus=!0,n.$apply(e.cancel)}}),i.selectEl.on("keydown",function(e){switch(e.keyCode){case t.KEY_CODE.UP_ARROW:return a();case t.KEY_CODE.DOWN_ARROW:return o()}}),d.isMultiple||(i.selectEl.on("click",c),i.selectEl.on("keydown",function(e){(32==e.keyCode||13==e.keyCode)&&c()}))}}if(!i.target)throw new Error('$mdSelect.show() expected a target element in options.target but got "'+i.target+'"!');angular.extend(i,{target:angular.element(i.target),parent:angular.element(i.parent),selectEl:r.find("md-select-menu"),contentEl:r.find("md-content"),backdrop:i.hasBackdrop&&angular.element('<md-backdrop class="md-select-backdrop">')});var f=[];return s(),i.loadingAsync&&i.loadingAsync.then&&i.loadingAsync.then(function(){n.$$loadingAsyncDone=!0,o(function(){o(function(){i.isRemoved||(u(n,r,i),f=a(i.selectEl[0].getElementsByTagName("md-option")))})})}),i.disableParentScroll&&(i.disableTarget=i.parent.find("md-content"),i.disableTarget.length||(i.disableTarget=i.parent),i.lastOverflow=i.disableTarget.css("overflow"),i.disableTarget.css("overflow","hidden")),l(m,75,!1),i.backdrop&&(d.inherit(i.backdrop,i.parent),i.parent.append(i.backdrop)),i.parent.append(r),o(function(){o(function(){i.isRemoved||(u(n,r,i),f=a(r[0].querySelectorAll("md-option")))})}),c.transitionEndPromise(i.selectEl)}function m(e,t,n){return n.isRemoved=!0,t.addClass("md-leave").removeClass("md-clickable"),n.target.attr("aria-expanded","false"),n.disableParentScroll&&c.floatingScrollbars()&&(n.disableTarget.css("overflow",n.lastOverflow),delete n.lastOverflow,delete n.disableTarget),n.setLabelText&&n.setLabelText(n.selectEl.controller("mdSelectMenu").selectedLabels()),c.transitionEndPromise(t).then(function(){t.remove(),n.backdrop&&n.backdrop.remove(),n.restoreFocus&&n.target.focus()})}function u(e,d,l){var s,m=d[0],u=l.target[0],f=l.parent[0],p=l.selectEl[0],h=l.contentEl[0],g=f.getBoundingClientRect(),b=c.clientRect(u,f),v=!1,E={left:f.scrollLeft+i,top:f.scrollTop+i,bottom:g.height+f.scrollTop-i,right:g.width-f.scrollLeft-i},$={top:b.top-E.top,left:b.left-E.left,right:E.right-(b.left+b.width),bottom:E.bottom-(b.top+b.height)},M=g.width-2*i,A=h.scrollHeight>h.offsetHeight,T=p.querySelector("md-option[selected]"),w=a(p.getElementsByTagName("md-option")),k=p.getElementsByTagName("md-optgroup");s=T?T:k.length?w[0]:w.length?w[Math.floor(w.length/2)]:h.firstElementChild||h,h.offsetWidth>M&&(h.style["max-width"]=M+"px"),v&&(h.style["min-width"]=b.width+"px"),A&&p.classList.add("md-overflow");var y=p.getBoundingClientRect(),x=r(s);if(s){var C=window.getComputedStyle(s);x.paddingLeft=parseInt(C["padding-left"],10),x.paddingRight=parseInt(C["padding-right"],10)}var N=s||w[0];if(N&&(l.focusedNode=N,N.focus()),A){var _=h.offsetHeight/2;h.scrollTop=x.top+x.height/2-_,$.top<_?h.scrollTop=Math.min(x.top,h.scrollTop+_-$.top):$.bottom<_&&(h.scrollTop=Math.max(x.top+x.height-y.height,h.scrollTop-_+$.bottom))}var S,H,D;v?(S=b.left,H=b.top+b.height,D="50% 0",H+y.height>E.bottom&&(H=b.top-y.height,D="50% 100%")):(S=b.left+x.left-x.paddingLeft,H=b.top+b.height/2-x.height/2-x.top+h.scrollTop,D=x.left+b.width/2+"px "+(x.top+x.height/2-h.scrollTop)+"px 0px",m.style["min-width"]=b.width+x.paddingLeft+x.paddingRight+"px"),m.style.left=n(E.left,S,E.right)+"px",m.style.top=n(E.top,H,E.bottom)+"px",p.style[t.CSS.TRANSFORM_ORIGIN]=D,p.style[t.CSS.TRANSFORM]="scale("+Math.min(b.width/y.width,1)+","+Math.min(b.height/y.height,1)+")",o(function(){d.addClass("md-active"),p.style[t.CSS.TRANSFORM]=""})}return{parent:"body",onShow:s,onRemove:m,hasBackdrop:!0,disableParentScroll:c.floatingScrollbars(),themable:!0}}function n(e,t,n){return Math.min(n,Math.max(t,e))}function r(e){return e?{left:e.offsetLeft,top:e.offsetTop,width:e.offsetWidth,height:e.offsetHeight}:{left:0,top:0,width:0,height:0}}return t.$inject=["$mdSelect","$mdConstant","$$rAF","$mdUtil","$mdTheming","$timeout"],e("$mdSelect").setDefaults({methods:["target"],options:t})}function a(e){for(var t=[],n=0;n<e.length;++n)t.push(e.item(n));return t}var i=8,c=0;angular.module("material.components.select",["material.core","material.components.backdrop"]).directive("mdSelect",e).directive("mdSelectMenu",t).directive("mdOption",n).directive("mdOptgroup",r).provider("$mdSelect",o),e.$inject=["$mdSelect","$mdUtil","$mdTheming","$interpolate","$compile","$parse"],t.$inject=["$parse","$mdUtil","$mdTheming"],n.$inject=["$mdInkRipple","$mdUtil"],o.$inject=["$$interimElementProvider"]}(),function(){"use strict";function e(e,t){return function(n){var r="SideNav '"+n+"' is not available!",o=e.get(n);return o||e.notFoundError(n),{isOpen:function(){return o&&o.isOpen()},isLockedOpen:function(){return o&&o.isLockedOpen()},toggle:function(){return o?o.toggle():t.reject(r)},open:function(){return o?o.open():t.reject(r)},close:function(){return o?o.close():t.reject(r)}}}}function t(e,t,n,r,o,a,i,c,d){function l(l,s,m,u){function f(e,n){l.isLockedOpen=e,e===n?s.toggleClass("md-locked-open",!!e):t[e?"addClass":"removeClass"](s,"md-locked-open"),A.toggleClass("md-locked-open",!!e)}function p(e){var n=s.parent();return n[e?"on":"off"]("keydown",g),A[e?"on":"off"]("click",b),e&&(v=d[0].activeElement),E=c.all([t[e?"enter":"leave"](A,n),t[e?"removeClass":"addClass"](s,"md-closed").then(function(){l.isOpen&&s.focus()})])}function h(t){if(l.isOpen==t)return c.when(!0);var n=c.defer();return l.isOpen=t,e(function(){E.then(function(e){l.isOpen||(v&&v.focus(),v=null),n.resolve(e)})},0,!1),n.promise}function g(e){var t=e.keyCode===o.KEY_CODE.ESCAPE;return t?b(e):c.when(!0)}function b(e){return e.preventDefault(),e.stopPropagation(),u.close()}var v=null,E=c.when(!0),$=n(m.mdIsLockedOpen),M=function(){return $(l.$parent,{$media:r})},A=a('<md-backdrop class="md-sidenav-backdrop md-opaque ng-enter">')(l);s.on("$destroy",u.destroy),i.inherit(A,s),l.$watch(M,f),l.$watch("isOpen",p),u.$toggleOpen=h}return{restrict:"E",scope:{isOpen:"=?mdIsOpen"},controller:"$mdSidenavController",compile:function(e){return e.addClass("md-closed"),e.attr("tabIndex","-1"),l}}}function n(e,t,n,r,o){var a=this;a.$toggleOpen=function(){return o.when(e.isOpen)},a.isOpen=function(){return!!e.isOpen},a.isLockedOpen=function(){return!!e.isLockedOpen},a.open=function(){return a.$toggleOpen(!0)},a.close=function(){return a.$toggleOpen(!1)},a.toggle=function(){return a.$toggleOpen(!e.isOpen)},a.destroy=r.register(a,n.mdComponentId)}angular.module("material.components.sidenav",["material.core","material.components.backdrop"]).factory("$mdSidenav",e).directive("mdSidenav",t).controller("$mdSidenavController",n),e.$inject=["$mdComponentRegistry","$q"],t.$inject=["$timeout","$animate","$parse","$mdMedia","$mdConstant","$compile","$mdTheming","$q","$document"],n.$inject=["$scope","$element","$attrs","$mdComponentRegistry","$q"]}(),function(){"use strict";function e(e,t,n,r,o,a,i,c){function d(e){return e.attr({tabIndex:0,role:"slider"}),n.expect(e,"aria-label"),l}function l(n,d,l,s){function m(){b(),M(),g()}function u(e){G=parseFloat(e),d.attr("aria-valuemin",e),m()}function f(e){z=parseFloat(e),d.attr("aria-valuemax",e),m()}function p(e){W=parseFloat(e),g()}function h(e){d.attr("aria-disabled",!!e)}function g(){if(angular.isDefined(l.mdDiscrete)){var e=Math.floor((z-G)/W);if(!X){var n=t.getComputedStyle(V[0]);X=angular.element('<canvas style="position:absolute;">'),Q=X[0].getContext("2d"),Q.fillStyle=n.backgroundColor||"black",V.append(X)}var r=v();X[0].width=r.width,X[0].height=r.height;for(var o,a=0;e>=a;a++)o=Math.floor(r.width*(a/e)),Q.fillRect(o-1,0,2,r.height)}}function b(){Z=B[0].getBoundingClientRect()}function v(){return U(),Z}function E(e){if(!d[0].hasAttribute("disabled")){var t;e.keyCode===o.KEY_CODE.LEFT_ARROW?t=-W:e.keyCode===o.KEY_CODE.RIGHT_ARROW&&(t=W),t&&((e.metaKey||e.ctrlKey||e.altKey)&&(t*=4),e.preventDefault(),e.stopPropagation(),n.$evalAsync(function(){$(s.$viewValue+t)}))}}function $(e){s.$setViewValue(A(T(e)))}function M(){isNaN(s.$viewValue)&&(s.$viewValue=s.$modelValue);var e=(s.$viewValue-G)/(z-G);n.modelValue=s.$viewValue,d.attr("aria-valuenow",s.$viewValue),w(e),L.text(s.$viewValue)}function A(e){return angular.isNumber(e)?Math.max(G,Math.min(z,e)):void 0}function T(e){return angular.isNumber(e)?Math.round(e/W)*W:void 0}function w(e){q.css("width",100*e+"%"),F.css("left",100*e+"%"),d.toggleClass("md-min",0===e)}function k(e){if(!j()){d.addClass("active"),d[0].focus(),b();var t=O(D(e.pointer.x)),r=A(T(t));n.$apply(function(){$(r),w(I(r))})}}function y(e){if(!j()){d.removeClass("dragging active");var t=O(D(e.pointer.x)),r=A(T(t));n.$apply(function(){$(r),M()})}}function x(e){j()||(J=!0,e.stopPropagation(),d.addClass("dragging"),_(e))}function C(e){J&&(e.stopPropagation(),_(e))}function N(e){J&&(e.stopPropagation(),J=!1)}function _(e){ee?H(e.pointer.x):S(e.pointer.x)}function S(e){n.$evalAsync(function(){$(O(D(e)))})}function H(e){var t=O(D(e)),n=A(T(t));w(D(e)),L.text(n)}function D(e){return Math.max(0,Math.min(1,(e-Z.left)/Z.width))}function O(e){return G+e*(z-G)}function I(e){return(e-G)/(z-G)}a(d),s=s||{$setViewValue:function(e){this.$viewValue=e,this.$viewChangeListeners.forEach(function(e){e()})},$parsers:[],$formatters:[],$viewChangeListeners:[]};var R=l.ngDisabled&&c(l.ngDisabled),j=R?function(){return R(n.$parent)}:angular.noop,P=angular.element(d[0].querySelector(".md-thumb")),L=angular.element(d[0].querySelector(".md-thumb-text")),F=P.parent(),B=angular.element(d[0].querySelector(".md-track-container")),q=angular.element(d[0].querySelector(".md-track-fill")),V=angular.element(d[0].querySelector(".md-track-ticks")),U=r.throttle(b,5e3);l.min?l.$observe("min",u):u(0),l.max?l.$observe("max",f):f(100),l.step?l.$observe("step",p):p(1);var Y=angular.noop;l.ngDisabled&&(Y=n.$parent.$watch(l.ngDisabled,h)),i.register(d,"drag"),d.on("keydown",E).on("$md.pressdown",k).on("$md.pressup",y).on("$md.dragstart",x).on("$md.drag",C).on("$md.dragend",N),setTimeout(m);var K=e.throttle(m);angular.element(t).on("resize",K),n.$on("$destroy",function(){angular.element(t).off("resize",K),Y()}),s.$render=M,s.$viewChangeListeners.push(M),s.$formatters.push(A),s.$formatters.push(T);var G,z,W,X,Q,Z={};b();var J=!1,ee=angular.isDefined(l.mdDiscrete)}return{scope:{},require:"?ngModel",template:'<div class="md-slider-wrapper">        <div class="md-track-container">          <div class="md-track"></div>          <div class="md-track md-track-fill"></div>          <div class="md-track-ticks"></div>        </div>        <div class="md-thumb-container">          <div class="md-thumb"></div>          <div class="md-focus-thumb"></div>          <div class="md-focus-ring"></div>          <div class="md-sign">            <span class="md-thumb-text"></span>          </div>          <div class="md-disabled-thumb"></div>        </div>      </div>',compile:d}}angular.module("material.components.slider",["material.core"]).directive("mdSlider",e),e.$inject=["$$rAF","$window","$mdAria","$mdUtil","$mdConstant","$mdTheming","$mdGesture","$parse"]}(),function(){"use strict";function e(e,t,n,r,o){function a(e){function n(e,t){t.addClass("md-sticky-clone"),t.css("top",p+"px");var n={element:e,clone:t};return f.items.push(n),m.parent().prepend(n.clone),u(),function(){f.items.forEach(function(t,n){t.element[0]===e[0]&&(f.items.splice(n,1),t.clone.remove())}),u()}}function o(){f.items.forEach(a),f.items=f.items.sort(function(e,t){return e.top<t.top?-1:1});for(var e,t=m.prop("scrollTop"),n=f.items.length-1;n>=0;n--)if(t>f.items[n].top){e=f.items[n];break}d(e)}function a(e){var t=e.element[0];for(e.top=0,e.left=0;t&&t!==m[0];)e.top+=t.offsetTop,e.left+=t.offsetLeft,t=t.offsetParent;e.height=e.element.prop("offsetHeight"),e.clone.css("margin-left",e.left+"px")}function i(){var e=m.prop("scrollTop"),t=e>(i.prevScrollTop||0);i.prevScrollTop=e,0===e?d(null):t&&f.next?f.next.top-e<=0?d(f.next):f.current&&(f.next.top-e<=f.next.height?s(f.current,f.next.top-f.next.height-e):s(f.current,null)):!t&&f.current&&(e<f.current.top&&d(f.prev),f.current&&f.next&&(e>=f.next.top-f.current.height?s(f.current,f.next.top-e-f.current.height):s(f.current,null)))}function d(e){if(f.current!==e){f.current&&(s(f.current,null),l(f.current,null)),e&&l(e,"active"),f.current=e;var t=f.items.indexOf(e);f.next=f.items[t+1],f.prev=f.items[t-1],l(f.next,"next"),l(f.prev,"prev")}}function l(e,t){e&&e.state!==t&&(e.state&&(e.clone.attr("sticky-prev-state",e.state),e.element.attr("sticky-prev-state",e.state)),e.clone.attr("sticky-state",t),e.element.attr("sticky-state",t),e.state=t)}function s(e,n){e&&(null===n||void 0===n?e.translateY&&(e.translateY=null,e.clone.css(t.CSS.TRANSFORM,"")):(e.translateY=n,e.clone.css(t.CSS.TRANSFORM,"translate3d("+e.left+"px,"+n+"px,0)")))}var m=e.$element,u=r.throttle(o);c(m),m.on("$scrollstart",u),m.on("$scroll",i);var f,p=m.prop("offsetTop");return f={prev:null,current:null,next:null,items:[],add:n,refreshElements:o}}function i(){var t,n=angular.element("<div>");e[0].body.appendChild(n[0]);for(var r=["sticky","-webkit-sticky"],o=0;o<r.length;++o)if(n.css({position:r[o],top:0,"z-index":2}),n.css("position")==r[o]){t=r[o];break}return n.remove(),t}function c(e){function t(){+o.now()-a>i?(n=!1,e.triggerHandler("$scrollend")):(e.triggerHandler("$scroll"),r(t))}var n,a,i=200;e.on("scroll touchmove",function(){n||(n=!0,r(t),e.triggerHandler("$scrollstart")),e.triggerHandler("$scroll"),a=+o.now()})}var d=i();return function(e,t,n){var r=t.controller("mdContent");if(r)if(d)t.css({position:d,top:0,"z-index":2});else{var o=r.$element.data("$$sticky");o||(o=a(r),r.$element.data("$$sticky",o));var i=o.add(t,n||t.clone());e.$on("$destroy",i)}}}angular.module("material.components.sticky",["material.core","material.components.content"]).factory("$mdSticky",e),e.$inject=["$document","$mdConstant","$compile","$$rAF","$mdUtil"]}(),function(){"use strict";function e(e,t,n){return{restrict:"E",replace:!0,transclude:!0,template:'<h2 class="md-subheader"><span class="md-subheader-content"></span></h2>',compile:function(r,o,a){var i=r[0].outerHTML;return function(r,o){function c(e){return angular.element(e[0].querySelector(".md-subheader-content"))}n(o),a(r,function(e){c(o).append(e)}),a(r,function(a){var d=t(angular.element(i))(r);n(d),c(d).append(a),e(r,o,d)})}}}}angular.module("material.components.subheader",["material.core","material.components.sticky"]).directive("mdSubheader",e),e.$inject=["$mdSticky","$compile","$mdTheming"]}(),function(){"use strict";var e=angular.module("material.components.swipe",[]);["SwipeLeft","SwipeRight"].forEach(function(t){var n="md"+t,r="$md."+t.toLowerCase();e.directive(n,["$parse",function(e){function t(t,o,a){var i=e(a[n]);o.on(r,function(e){t.$apply(function(){i(t,{$event:e})})})}return{restrict:"A",link:t}}])})}(),function(){"use strict";function e(e,t,n,r,o,a,i,c){function d(e,t){var r=l.compile(e,t);return e.addClass("md-dragging"),function(e,t,d,l){function s(n){p(e)||(n.stopPropagation(),t.addClass("md-dragging"),b={width:h.prop("offsetWidth")},t.removeClass("transition"))}function m(e){if(b){e.stopPropagation(),e.srcEvent&&e.srcEvent.preventDefault();var t=e.pointer.distanceX/b.width,n=l.$viewValue?1+t:t;n=Math.max(0,Math.min(1,n)),h.css(o.CSS.TRANSFORM,"translate3d("+100*n+"%,0,0)"),b.translate=n}}function u(e){if(b){e.stopPropagation(),t.removeClass("md-dragging"),h.css(o.CSS.TRANSFORM,"");var n=l.$viewValue?b.translate<.5:b.translate>.5;n&&f(!l.$viewValue),b=null}}function f(t){e.$apply(function(){l.$setViewValue(t),l.$render()})}l=l||n.fakeNgModel();var p=a(d.ngDisabled),h=angular.element(t[0].querySelector(".md-thumb-container")),g=angular.element(t[0].querySelector(".md-container"));i(function(){t.removeClass("md-dragging")}),r(e,t,d,l),angular.isDefined(d.ngDisabled)&&e.$watch(p,function(e){t.attr("tabindex",e?-1:0)}),c.register(g,"drag"),g.on("$md.dragstart",s).on("$md.drag",m).on("$md.dragend",u);var b}}var l=e[0];return{restrict:"E",transclude:!0,template:'<div class="md-container"><div class="md-bar"></div><div class="md-thumb-container"><div class="md-thumb" md-ink-ripple md-ink-ripple-checkbox></div></div></div><div ng-transclude class="md-label"></div>',require:"?ngModel",compile:d}}angular.module("material.components.switch",["material.core","material.components.checkbox"]).directive("mdSwitch",e),e.$inject=["mdCheckboxDirective","$mdTheming","$mdUtil","$document","$mdConstant","$parse","$$rAF","$mdGesture"]}(),function(){"use strict";angular.module("material.components.tabs",["material.core","material.components.icon"])}(),function(){"use strict";function e(e,t,n,r){return{restrict:"E",replace:!0,scope:{fid:"@?mdFid",label:"@?",value:"=ngModel"},compile:function(o,a){return r.warn("<md-text-float> is deprecated. Please use ` + "`" + `<md-input-container>` + "`" + ` and ` + "`" + `<input>` + "`" + `.More information at http://material.angularjs.org/#/api/material.components.input/directive/mdInputContainer"),angular.isUndefined(a.mdFid)&&(a.mdFid=t.nextUid()),{pre:function(e,t,r){var o=n(r.ngDisabled);e.isDisabled=function(){return o(e.$parent)},e.inputType=r.type||"text"},post:e}},template:'<md-input-group tabindex="-1"> <label for="{{fid}}" >{{label}}</label> <md-input id="{{fid}}" ng-disabled="isDisabled()" ng-model="value" type="{{inputType}}"></md-input></md-input-group>'}}function t(e){return{restrict:"CE",controller:["$element",function(t){e.warn("<md-input-group> is deprecated. Please use ` + "`" + `<md-input-container>` + "`" + ` and ` + "`" + `<input>` + "`" + `.More information at http://material.angularjs.org/#/api/material.components.input/directive/mdInputContainer"),this.setFocused=function(e){t.toggleClass("md-input-focused",!!e)},this.setHasValue=function(e){t.toggleClass("md-input-has-value",e)}}]}}function n(e,t){return{restrict:"E",replace:!0,template:"<input >",require:["^?mdInputGroup","?ngModel"],link:function(e,n,r,o){function a(e){return e=angular.isUndefined(e)?n.val():e,angular.isDefined(e)&&null!==e&&""!==e.toString().trim()}if(o[0]){t.warn("<md-input> is deprecated. Please use ` + "`" + `<md-input-container>` + "`" + ` and ` + "`" + `<input>` + "`" + `.More information at http://material.angularjs.org/#/api/material.components.input/directive/mdInputContainer");var i=o[0],c=o[1];e.$watch(e.isDisabled,function(e){n.attr("aria-disabled",!!e),n.attr("tabindex",!!e)}),n.attr("type",r.type||n.parent().attr("type")||"text"),c&&c.$formatters.push(function(e){return i.setHasValue(a(e)),e}),n.on("input",function(){i.setHasValue(a())}).on("focus",function(){i.setFocused(!0)}).on("blur",function(){i.setFocused(!1),i.setHasValue(a())}),e.$on("$destroy",function(){i.setFocused(!1),i.setHasValue(!1)})}}}}angular.module("material.components.textField",["material.core"]).directive("mdInputGroup",t).directive("mdInput",n).directive("mdTextFloat",e),e.$inject=["$mdTheming","$mdUtil","$parse","$log"],t.$inject=["$log"],n.$inject=["$mdUtil","$log"]}(),function(){"use strict";function e(){return{restrict:"E"}}function t(e){function t(e,t,r){function o(o,a,c){return n=c.content,a.addClass(c.position.split(" ").map(function(e){return"md-"+e}).join(" ")),c.parent.addClass(i(c.position)),c.onSwipe=function(t){a.addClass("md-"+t.type.replace("$md.","")),e(r.cancel)},a.on("$md.swipeleft $md.swiperight",c.onSwipe),t.enter(a,c.parent)}function a(e,n,r){return n.off("$md.swipeleft $md.swiperight",r.onSwipe),r.parent.removeClass(i(r.position)),t.leave(n)}function i(e){return"md-toast-open-"+(e.indexOf("top")>-1?"top":"bottom")}return{onShow:o,onRemove:a,position:"bottom left",themable:!0,hideDelay:3e3}}var n,r=e("$mdToast").setDefaults({methods:["position","hideDelay","capsule"],options:t}).addPreset("simple",{argOption:"content",methods:["content","action","highlightAction","theme"],options:["$mdToast","$mdTheming",function(e,t){var r={template:['<md-toast md-theme="{{ toast.theme }}" ng-class="{\'md-capsule\': toast.capsule}">',"<span flex>{{ toast.content }}</span>",'<md-button class="md-action" ng-if="toast.action" ng-click="toast.resolve()" ng-class="{\'md-highlight\': toast.highlightAction}">',"{{ toast.action }}","</md-button>","</md-toast>"].join(""),controller:["$scope",function(t){var r=this;t.$watch(function(){return n},function(){r.content=n}),this.resolve=function(){e.hide()}}],theme:t.defaultTheme(),controllerAs:"toast",bindToController:!0};return r}]}).addMethod("updateContent",function(e){n=e});return t.$inject=["$timeout","$animate","$mdToast"],r}angular.module("material.components.toast",["material.core","material.components.button"]).directive("mdToast",e).provider("$mdToast",t),t.$inject=["$$interimElementProvider"]}(),function(){"use strict";function e(e,t,n,r){return{restrict:"E",controller:angular.noop,link:function(o,a,i){function c(){function r(t,n){a.parent()[0]===n.parent()[0]&&(s&&s.off("scroll",p),n.on("scroll",p),n.attr("scroll-shrink","true"),s=n,e(c))}function c(){l=a.prop("offsetHeight"),s.css("margin-top",-l*f+"px"),d()}function d(e){var n=e?e.target.scrollTop:u;h(),m=Math.min(l/f,Math.max(0,m+n-u)),a.css(t.CSS.TRANSFORM,"translate3d(0,"+-m*f+"px,0)"),s.css(t.CSS.TRANSFORM,"translate3d(0,"+(l-m)*f+"px,0)"),u=n}var l,s,m=0,u=0,f=i.mdShrinkSpeedFactor||.5,p=e.throttle(d),h=n.debounce(c,5e3);o.$on("$mdContentLoaded",r)}r(a),angular.isDefined(i.mdScrollShrink)&&c()}}}angular.module("material.components.toolbar",["material.core","material.components.content"]).directive("mdToolbar",e),e.$inject=["$$rAF","$mdConstant","$mdUtil","$mdTheming"]}(),function(){"use strict";function e(e,t,n,r,o,a,i,c,d){function l(l,u,f){function p(t){p.value=!!t,p.queued||(t?(p.queued=!0,e(function(){l.visible=p.value,p.queued=!1},l.delay)):e(function(){l.visible=!1}))}function h(){v.attr("aria-describedby",u.attr("id")),T.append(u),b(),c.addClass(u,"md-show"),c.addClass(E,"md-show"),c.addClass($,"md-show")}function g(){v.removeAttr("aria-describedby"),d.all([c.removeClass($,"md-show"),c.removeClass(E,"md-show"),c.removeClass(u,"md-show")]).then(function(){l.visible||u.detach()})}function b(){function e(){var e="left"===M||"right"===M?2*Math.sqrt(Math.pow(t.width,2)+Math.pow(t.height/2,2)):2*Math.sqrt(Math.pow(t.width/2,2)+Math.pow(t.height,2)),n="left"===M?{left:100,top:50}:"right"===M?{left:0,top:50}:"top"===M?{left:50,top:100}:{left:50,top:0};E.css({width:e+"px",height:e+"px",left:n.left+"%",top:n.top+"%"})}var t=o.offsetRect(u,T),n=o.offsetRect(v,T),r="bottom",a={left:n.left+n.width/2-t.width/2,top:n.top+n.height};a.left=Math.min(a.left,T.prop("scrollWidth")-t.width-m),a.left=Math.max(a.left,m),a.top+t.height>T.prop("scrollHeight")&&(a.top=n.top-t.height,r="top"),u.css({top:a.top+"px",left:a.left+"px"}),e()}a(u);for(var v=u.parent(),E=angular.element(u[0].getElementsByClassName("md-background")[0]),$=angular.element(u[0].getElementsByClassName("md-content")[0]),M=f.mdDirection;"none"==t.getComputedStyle(v[0])["pointer-events"];)v=v.parent();for(var A=u.parent()[0];A&&A!==i[0]&&A!==document.body&&(!A.tagName||"md-content"!=A.tagName.toLowerCase());)A=A.parentNode;var T=angular.element(A||document.body);angular.isDefined(f.mdDelay)||(l.delay=s),u.detach(),u.attr("role","tooltip"),u.attr("id",f.id||"tooltip_"+o.nextUid()),v.on("focus mouseenter touchstart",function(){p(!0)}),v.on("blur mouseleave touchend touchcancel",function(){r[0].activeElement!==v[0]&&p(!1)}),l.$watch("visible",function(e){e?h():g()});var w=n.throttle(function(){l.visible&&b()});angular.element(t).on("resize",w),l.$on("$destroy",function(){l.visible=!1,u.remove(),angular.element(t).off("resize",w)})}var s=0,m=8;return{restrict:"E",transclude:!0,template:'<div class="md-background"></div><div class="md-content" ng-transclude></div>',scope:{visible:"=?mdVisible",delay:"=?mdDelay"},link:l}}angular.module("material.components.tooltip",["material.core"]).directive("mdTooltip",e),e.$inject=["$timeout","$window","$$rAF","$document","$mdUtil","$mdTheming","$rootElement","$animate","$q"]}(),function(){"use strict";angular.module("material.components.whiteframe",[])}(),function(){"use strict";function e(e,t,n,r,o,a){function i(){l(),c()}function c(){var e=angular.element(A.ul),t=angular.element(A.input),n=e.attr("id")||"ul_"+o.nextUid();e.attr("id",n),t.attr("aria-owns",n)}function d(t){if(t){var n={};return E.itemName&&(n[E.itemName]=e.selectedItem),n}}function l(){e.$watch("searchText",function(t){if(E.index=-1,!t||t.length<Math.max(parseInt(e.minLength,10),1))return E.loading=!1,E.matches=[],void(E.hidden=p());var n=t.toLowerCase();T&&T.cancel&&(T.cancel(),
T=null),!e.noCache&&w[n]?E.matches=w[n]:E.fetch(t),E.hidden=p(),e.textChange&&e.textChange(d(e.selectedItem))}),e.$watch("selectedItem",function(t){e.itemChange&&e.itemChange(d(t))})}function s(t){function n(n){w[a]=n,t===e.searchText&&(T=null,E.loading=!1,E.matches=n,E.hidden=p())}var o=e.$parent.$eval(M),a=t.toLowerCase();angular.isArray(o)?n(o):(E.loading=!0,T=r.when(o).then(n))}function m(){E.hidden=!0}function u(e){switch(e.keyCode){case a.KEY_CODE.DOWN_ARROW:if(E.loading)return;e.preventDefault(),E.index=Math.min(E.index+1,E.matches.length-1),v();break;case a.KEY_CODE.UP_ARROW:if(E.loading)return;e.preventDefault(),E.index=Math.max(0,E.index-1),v();break;case a.KEY_CODE.ENTER:if(E.loading||E.index<0)return;e.preventDefault(),b(E.index);break;case a.KEY_CODE.ESCAPE:E.matches=[],E.hidden=!0,E.index=-1;break;case a.KEY_CODE.TAB:}}function f(){e.searchText="",b(-1),A.input.focus()}function p(){return 1===E.matches.length&&e.searchText===g(E.matches[0])}function h(){return g(E.matches[E.index])}function g(t){return t&&e.itemText?e.itemText(d(t)):t}function b(t){e.selectedItem=E.matches[t],e.searchText=g(e.selectedItem)||e.searchText,E.hidden=!0,E.index=-1,E.matches=[]}function v(){var e=41*E.index,t=e+41,n=225.5;e<A.ul.scrollTop?A.ul.scrollTop=e:t>A.ul.scrollTop+n&&(A.ul.scrollTop=t-n)}var E=this,$=e.itemsExpr.split(/ in /i),M=$[1],A={main:t[0],ul:t[0].getElementsByTagName("ul")[0],input:t[0].getElementsByTagName("input")[0]},T=null,w={};return E.scope=e,E.parent=e.$parent,E.itemName=$[0],E.matches=[],E.loading=!1,E.hidden=!0,E.index=0,E.keydown=u,E.blur=m,E.clear=f,E.select=b,E.getCurrentDisplayValue=h,E.fetch=o.debounce(s),i()}angular.module("material.components.autocomplete").controller("MdAutocompleteCtrl",e),e.$inject=["$scope","$element","$timeout","$q","$mdUtil","$mdConstant"]}(),function(){"use strict";function e(){return{template:'        <md-autocomplete-wrap role="listbox">          <input type="text"              ng-disabled="isDisabled"              ng-model="searchText"              ng-keydown="$mdAutocompleteCtrl.keydown($event)"              ng-blur="$mdAutocompleteCtrl.blur()"              placeholder="{{placeholder}}"              aria-label="{{placeholder}}"              aria-autocomplete="list"              aria-haspopup="true"              aria-activedescendant=""              aria-expanded="{{!$mdAutocompleteCtrl.hidden}}"/>          <button              type="button"              ng-if="searchText"              ng-click="$mdAutocompleteCtrl.clear()">              <md-icon md-svg-icon="cancel"></md-icon>              <span class="visually-hidden">Clear</span>              </button>          <md-progress-linear ng-if="$mdAutocompleteCtrl.loading" md-mode="indeterminate"></md-progress-linear>        </md-autocomplete-wrap>        <ul role="presentation">          <li ng-repeat="(index, item) in $mdAutocompleteCtrl.matches"              ng-class="{ selected: index === $mdAutocompleteCtrl.index }"              ng-show="searchText && !$mdAutocompleteCtrl.hidden"              ng-click="$mdAutocompleteCtrl.select(index)"              ng-transclude              md-autocomplete-list-item="$mdAutocompleteCtrl.itemName">          </li>        </ul>        <aria-status            class="visually-hidden"            role="status"            aria-live="assertive">          <p ng-if="$mdAutocompleteCtrl.index === -1 && $mdAutocompleteCtrl.matches.length === 1">There is 1 match available.</p>          <p ng-if="$mdAutocompleteCtrl.index === -1 && $mdAutocompleteCtrl.matches.length > 1">There are {{$mdAutocompleteCtrl.matches.length}} matches available.</p>          <p ng-if="$mdAutocompleteCtrl.index >= 0">{{ $mdAutocompleteCtrl.getCurrentDisplayValue() }}</p>        </aria-status>',transclude:!0,controller:"MdAutocompleteCtrl",controllerAs:"$mdAutocompleteCtrl",scope:{searchText:"=mdSearchText",selectedItem:"=mdSelectedItem",itemsExpr:"@mdItems",itemText:"&mdItemText",placeholder:"@placeholder",noCache:"=mdNoCache",itemChange:"&mdSelectedItemChange",textChange:"&mdSearchTextChange",isDisabled:"=ngDisabled",minLength:"=mdMinLength"}}}angular.module("material.components.autocomplete").directive("mdAutocomplete",e)}(),function(){"use strict";function e(e,t,n){function r(e){return e?e.replace(/[\*\[\]\(\)\{\}\\\^\$]/g,"\\$&"):e}var o=t.attr("md-highlight-text"),a=n(t.text())(e);e.$watch(o,function(e){var n=new RegExp("^"+r(e),"i"),o=a.replace(n,'<span class="highlight">$&</span>');t.html(o)})}angular.module("material.components.autocomplete").controller("MdHighlightCtrl",e),e.$inject=["$scope","$element","$interpolate"]}(),function(){"use strict";function e(){return{terminal:!0,scope:!1,controller:"MdHighlightCtrl"}}angular.module("material.components.autocomplete").directive("mdHighlightText",e)}(),function(){"use strict";function e(e,t){function n(n,r,o,a){var i=a.parent.$new(!1,a.parent),c=a.scope.$eval(o.mdAutocompleteListItem);i[c]=n.item,e(r.contents())(i),r.attr({role:"option",id:"item_"+t.nextUid()})}return{require:"^?mdAutocomplete",terminal:!0,link:n,scope:!1}}angular.module("material.components.autocomplete").directive("mdAutocompleteListItem",e),e.$inject=["$compile","$mdUtil"]}(),function(){"use strict";function e(e){function t(t,r,o,a){function i(){var e=d.getSelectedItem(),o=!e||d.count()<2||c;if(r.css("display",o?"none":"block"),!o&&t.pagination&&t.pagination.tabData){var a=d.getSelectedIndex(),i=t.pagination.tabData.tabs[a]||{left:0,right:0,width:0},l=r.parent().prop("offsetWidth")-i.right,s=["md-transition-left","md-transition-right","md-no-transition"],m=n>a?0:a>n?1:2;r.removeClass(s.join(" ")).addClass(s[m]).css({left:i.left+"px",right:l+"px"}),n=a}}var c=!!a[0],d=a[1],l=e.throttle(i);d.inkBarElement=r,t.$on("$mdTabsPaginationChanged",l)}var n=0;return{restrict:"E",require:["^?mdNoBar","^mdTabs"],link:t}}angular.module("material.components.tabs").directive("mdTabsInkBar",e),e.$inject=["$$rAF"]}(),function(){"use strict";function e(e,t,n,r,o,a){function i(i,d,l,s){function m(e,t){if(e){var n=b(e);T.active&&n!==T.page?(t&&t.element.blur(),v(n).then(function(){A=!1,e.element.focus()})):e.element.focus()}}function u(e){var t=T.tabData,n=Math.max(0,Math.min(t.pages.length-1,T.page+e)),r=t.pages[n][e>0?"firstTabIndex":"lastTabIndex"],o=s.itemAt(r);A=!0,m(o)}function f(){function e(){M.css("width","9999px"),angular.forEach(a.tabs,function(e){angular.element(e.element).css("margin-left",e.filler+"px")}),v(b(s.getSelectedItem()))}function t(){p(0),M.css("width",""),r.css("width",""),r.css("margin-left",""),T.page=null,T.active=!1}function n(){return l||i.$watch(function(){o(function(){d[0].offsetParent&&(angular.isFunction(l)&&l(),$(),l=null)},0,!1)})}if(d.prop("offsetParent")){var r=d.find("md-tab");t();var a=T.tabData=g(),c=T.active=a.pages.length>1;c&&e(),i.$evalAsync(function(){i.$broadcast("$mdTabsPaginationChanged")})}else var l=n()}function p(t){function n(t){t.target===M[0]&&(M.off(e.CSS.TRANSITIONEND,n),o.resolve())}if(s.pagingOffset===t)return r.when();var o=r.defer();return s.$$pagingOffset=t,M.css(e.CSS.TRANSFORM,"translate3d("+t+"px,0,0)"),M.on(e.CSS.TRANSITIONEND,n),o.promise}function h(){switch(i.stretchTabs){case"never":return!1;case"always":return!0;default:return a("sm")}}function g(e){function t(){var e=1===m.length?r:o,t=Math.min(Math.floor(e/l),E.length),n=Math.floor(e/t);return a.css("width",n+"px"),g(!0)}var n,r=d.parent().prop("offsetWidth"),o=r-c-1,a=angular.element(E),i=0,l=0,s=[],m=[];return a.css("max-width",""),angular.forEach(E,function(e,t){var a=Math.min(o,e.offsetWidth),c={element:e,left:i,width:a,right:i+a,filler:0};c.page=Math.ceil(c.right/(1===m.length&&t===E.length-1?r:o))-1,c.page>=m.length?(c.filler=o*c.page-c.left,c.right+=c.filler,c.left+=c.filler,n={left:c.left,firstTabIndex:t,lastTabIndex:t,tabs:[c]},m.push(n)):(n.lastTabIndex=t,n.tabs.push(c)),i=c.right,l=Math.max(l,a),s.push(c)}),a.css("max-width",o+"px"),!e&&h()?t():{width:i,max:l,tabs:s,pages:m,tabElements:E}}function b(e){var t=s.indexOf(e);if(-1===t)return 0;var n=T.tabData;return n?n.tabs[t].page:0}function v(e){if(e!==T.page){var t=T.tabData.pages.length-1;return 0>e&&(e=0),e>t&&(e=t),T.hasPrev=e>0,T.hasNext=t>e,T.page=e,i.$broadcast("$mdTabsPaginationChanged"),p(-T.tabData.pages[e].left)}}var E=d[0].getElementsByTagName("md-tab"),$=n.throttle(f),M=d.children(),A=!1,T=i.pagination={page:-1,active:!1,clickNext:function(){A||u(1)},clickPrevious:function(){A||u(-1)}};i.$on("$mdTabsChanged",$),angular.element(t).on("resize",$),i.$on("$destroy",function(){angular.element(t).off("resize",$)}),i.$watch(function(){return s.tabToFocus},m)}var c=64;return{restrict:"A",require:"^mdTabs",link:i}}angular.module("material.components.tabs").directive("mdTabsPagination",e),e.$inject=["$mdConstant","$window","$$rAF","$$q","$timeout","$mdMedia"]}(),function(){"use strict";function e(e,t,n,r,o,a,i,c){function d(){return b(e.$parent)}function l(t,n){h.content.length&&(h.contentContainer.append(h.content),h.contentScope=e.$parent.$new(),t.append(h.contentContainer),r(h.contentContainer)(h.contentScope),n===!0&&c(function(){a.disconnectScope(h.contentScope)},0,!1))}function s(){o.leave(h.contentContainer).then(function(){h.contentScope&&h.contentScope.$destroy(),h.contentScope=null})}function m(e){h.contentContainer[e?"addClass":"removeClass"]("md-transition-rtl")}function u(n){a.reconnectScope(h.contentScope),t.addClass("active").attr({"aria-selected":!0,tabIndex:0}).on("$md.swipeleft $md.swiperight",p),m(n),o.removeClass(h.contentContainer,"ng-hide"),e.onSelect()}function f(n){a.disconnectScope(h.contentScope),t.removeClass("active").attr({"aria-selected":!1,tabIndex:-1}).off("$md.swipeleft $md.swiperight",p),m(n),o.addClass(h.contentContainer,"ng-hide"),e.onDeselect()}function p(t){e.$apply(function(){g.select(/left/.test(t.type)?g.next():g.previous())})}var h=this,g=t.controller("mdTabs");h.contentContainer=angular.element('<div class="md-tab-content ng-hide">'),h.element=t,h.isDisabled=d,h.onAdd=l,h.onRemove=s,h.onSelect=u,h.onDeselect=f;var b=i(n.ngDisabled)}angular.module("material.components.tabs").controller("$mdTab",e),e.$inject=["$scope","$element","$attrs","$compile","$animate","$mdUtil","$parse","$timeout"]}(),function(){"use strict";function e(e,t,n,r,o){function a(a,i){var c=a.find("md-tab-label");c.length?c.remove():c=angular.isDefined(i.label)?angular.element("<md-tab-label>").html(i.label):angular.element("<md-tab-label>").append(a.contents().remove());var d=a.contents().remove();return function(a,i,l,s){function m(){var e=c.clone();i.append(e),t(e)(a.$parent),v.content=d.clone()}function u(){a.$apply(function(){E.select(v),E.focus(v)})}function f(e){e.keyCode==r.KEY_CODE.SPACE||e.keyCode==r.KEY_CODE.ENTER?(i.triggerHandler("click"),e.preventDefault()):e.keyCode===r.KEY_CODE.LEFT_ARROW?a.$evalAsync(function(){E.focus(E.previous(v))}):e.keyCode===r.KEY_CODE.RIGHT_ARROW&&a.$evalAsync(function(){E.focus(E.next(v))})}function p(){a.$watch("$parent.$index",function(e){E.move(v,e)})}function h(){function e(e){var t=E.getSelectedItem()===v;e&&!t?E.select(v):!e&&t&&E.deselect(v)}var t=a.$parent.$watch("!!("+l.mdActive+")",e);a.$on("$destroy",t)}function g(){function e(e){i.attr("aria-disabled",e);var t=E.getSelectedItem()===v;t&&e&&E.select(E.next()||E.previous())}a.$watch(v.isDisabled,e)}function b(){var e=l.id||"tab_"+n.nextUid();if(i.attr({id:e,role:"tab",tabIndex:-1}),d.length){var t="content_"+e;i.attr("aria-controls")||i.attr("aria-controls",t),v.contentContainer.attr({id:t,role:"tabpanel","aria-labelledby":e})}}var v=s[0],E=s[1];o(i.addClass.bind(i,"md-tab-themed"),0,!1),a.$watch(function(){return l.label},function(){o(function(){E.scope.$broadcast("$mdTabsChanged")},0,!1)}),m(),b(),e.attachTabBehavior(a,i,{colorElement:E.inkBarElement}),E.add(v),a.$on("$destroy",function(){E.remove(v)}),i.on("$destroy",function(){o(function(){E.scope.$broadcast("$mdTabsChanged")},0,!1)}),angular.isDefined(l.ngClick)||i.on("click",u),i.on("keydown",f),angular.isNumber(a.$parent.$index)&&p(),angular.isDefined(l.mdActive)&&h(),g()}}return{restrict:"E",require:["mdTab","^mdTabs"],controller:"$mdTab",scope:{onSelect:"&mdOnSelect",onDeselect:"&mdOnDeselect",label:"@"},compile:a}}angular.module("material.components.tabs").directive("mdTab",e),e.$inject=["$mdInkRipple","$compile","$mdUtil","$mdConstant","$timeout"]}(),function(){"use strict";function e(e,t,n){function r(){return b(e.selectedIndex)}function o(){return e.selectedIndex}function a(t,n){p.add(t,n),angular.isDefined(t.element.attr("md-active"))||-1!==e.selectedIndex&&angular.isNumber(e.selectedIndex)&&e.selectedIndex!==h.indexOf(t)?t.onAdd(h.contentArea,!0):(t.onAdd(h.contentArea,!1),h.select(t)),e.$broadcast("$mdTabsChanged")}function i(t,n){if(p.contains(t)&&!n){var o=r()===t,a=u()||m();s(t),p.remove(t),t.onRemove(),e.$broadcast("$mdTabsChanged"),o&&d(a)}}function c(t,n){var o=r()===t;p.remove(t),p.add(t,n),o&&d(t),e.$broadcast("$mdTabsChanged")}function d(t,n){!t||t.isSelected||t.isDisabled()||p.contains(t)&&(angular.isDefined(n)||(n=g(t)<e.selectedIndex),s(r(),n),e.selectedIndex=g(t),t.isSelected=!0,t.onSelect(n),e.$broadcast("$mdTabsChanged"))}function l(e){h.tabToFocus=e}function s(t,n){t&&t.isSelected&&p.contains(t)&&(e.selectedIndex=-1,t.isSelected=!1,t.onDeselect(n))}function m(e,t){return p.next(e||r(),t||f)}function u(e,t){return p.previous(e||r(),t||f)}function f(e){return e&&!e.isDisabled()}var p=n.iterator([],!1),h=this;h.$element=t,h.scope=e;var g=(h.contentArea=angular.element(t[0].querySelector(".md-tabs-content")),h.inRange=p.inRange,h.indexOf=p.indexOf),b=h.itemAt=p.itemAt;h.count=p.count,h.getSelectedItem=r,h.getSelectedIndex=o,h.add=a,h.remove=i,h.move=c,h.select=d,h.focus=l,h.deselect=s,h.next=m,h.previous=u,e.$on("$destroy",function(){s(r());for(var e=p.count()-1;e>=0;e--)i(p[e],!0)})}angular.module("material.components.tabs").controller("$mdTabs",e),e.$inject=["$scope","$element","$mdUtil","$timeout"]}(),function(){"use strict";function e(e){function t(t,n,r,o,a){function i(){n.attr("role","tablist")}function c(){t.$watch("selectedIndex",function(e,t){if(t!=e){var n=t>e;if(o.deselect(o.itemAt(t),n),o.inRange(e)){for(var r=o.itemAt(e);r&&r.isDisabled();)r=e>t?o.next(r):o.previous(r);o.select(r,n)}}})}t.stretchTabs=r.hasOwnProperty("mdStretchTabs")?r.mdStretchTabs||"always":"auto",e(n),i(),c(),a(t.$parent,function(e){angular.element(n[0].querySelector(".md-header-items")).append(e)})}return{restrict:"E",controller:"$mdTabs",require:"mdTabs",transclude:!0,scope:{selectedIndex:"=?mdSelected"},template:'<section class="md-header" ng-class="{\'md-paginating\': pagination.active}"><button class="md-paginator md-prev" ng-if="pagination.active && pagination.hasPrev" ng-click="pagination.clickPrevious()" aria-hidden="true"><md-icon md-svg-icon="tabs-arrow"></md-icon></button><div class="md-header-items-container" md-tabs-pagination><div class="md-header-items"><md-tabs-ink-bar></md-tabs-ink-bar></div></div><button class="md-paginator md-next" ng-if="pagination.active && pagination.hasNext" ng-click="pagination.clickNext()" aria-hidden="true"><md-icon md-svg-icon="tabs-arrow"></md-icon></button></section><section class="md-tabs-content"></section>',link:t}}angular.module("material.components.tabs").directive("mdTabs",e),e.$inject=["$mdTheming"]}(),angular.module("material.core").constant("$MD_THEME_CSS","md-autocomplete {  background: '{{background-50}}'; }  md-autocomplete button md-icon path {    fill: '{{background-600}}'; }  md-autocomplete button:after {    background: '{{background-600-0.3}}'; }  md-autocomplete ul {    background: '{{background-50}}'; }    md-autocomplete ul li {      border-top: 1px solid '{{background-400}}';      color: '{{background-900}}'; }      md-autocomplete ul li .highlight {        color: '{{background-600}}'; }      md-autocomplete ul li:hover, md-autocomplete ul li.selected {        background: '{{background-200}}'; }md-backdrop.md-opaque.md-THEME_NAME-theme {  background-color: '{{foreground-4-0.5}}'; }md-bottom-sheet.md-THEME_NAME-theme {  background-color: '{{background-50}}';  border-top-color: '{{background-300}}'; }  md-bottom-sheet.md-THEME_NAME-theme.md-list md-item {    color: '{{foreground-1}}'; }  md-bottom-sheet.md-THEME_NAME-theme .md-subheader {    background-color: '{{background-50}}'; }  md-bottom-sheet.md-THEME_NAME-theme .md-subheader {    color: '{{foreground-1}}'; }md-card.md-THEME_NAME-theme {  border-radius: 2px; }  md-card.md-THEME_NAME-theme .md-card-image {    border-radius: 2px 2px 0 0; }md-toolbar .md-button.md-THEME_NAME-theme.md-fab {  background-color: white; }.md-button.md-THEME_NAME-theme {  border-radius: 3px; }  .md-button.md-THEME_NAME-theme:not([disabled]):hover, .md-button.md-THEME_NAME-theme:not([disabled]):focus {    background-color: '{{background-500-0.2}}'; }  .md-button.md-THEME_NAME-theme.md-primary {    color: '{{primary-color}}'; }    .md-button.md-THEME_NAME-theme.md-primary.md-raised, .md-button.md-THEME_NAME-theme.md-primary.md-fab {      color: '{{primary-contrast}}';      background-color: '{{primary-color}}'; }      .md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]):focus, .md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]):focus {        background-color: '{{primary-600}}'; }  .md-button.md-THEME_NAME-theme.md-fab {    border-radius: 50%;    background-color: '{{accent-color}}';    color: '{{accent-contrast}}'; }    .md-button.md-THEME_NAME-theme.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]):focus {      background-color: '{{accent-A700}}'; }  .md-button.md-THEME_NAME-theme.md-raised {    color: '{{background-contrast}}';    background-color: '{{background-50}}'; }    .md-button.md-THEME_NAME-theme.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-raised:not([disabled]):focus {      background-color: '{{background-200}}'; }  .md-button.md-THEME_NAME-theme.md-warn {    color: '{{warn-color}}'; }    .md-button.md-THEME_NAME-theme.md-warn.md-raised, .md-button.md-THEME_NAME-theme.md-warn.md-fab {      color: '{{warn-contrast}}';      background-color: '{{warn-color}}'; }      .md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]):focus, .md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]):focus {        background-color: '{{warn-700}}'; }  .md-button.md-THEME_NAME-theme.md-accent {    color: '{{accent-color}}'; }    .md-button.md-THEME_NAME-theme.md-accent.md-raised, .md-button.md-THEME_NAME-theme.md-accent.md-fab {      color: '{{accent-contrast}}';      background-color: '{{accent-color}}'; }      .md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]):focus, .md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]):focus {        background-color: '{{accent-700}}'; }  .md-button.md-THEME_NAME-theme[disabled], .md-button.md-THEME_NAME-theme.md-raised[disabled], .md-button.md-THEME_NAME-theme.md-fab[disabled] {    color: '{{foreground-3}}';    background-color: transparent;    cursor: not-allowed; }md-checkbox.md-THEME_NAME-theme .md-ripple {  color: '{{accent-600}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-ripple {  color: '{{background-600}}'; }md-checkbox.md-THEME_NAME-theme .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-icon {  background-color: '{{accent-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary .md-ripple {  color: '{{primary-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-ripple {  color: '{{background-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-icon {  background-color: '{{primary-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn .md-ripple {  color: '{{warn-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-icon {  background-color: '{{warn-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme[disabled] .md-icon {  border-color: '{{foreground-3}}'; }md-checkbox.md-THEME_NAME-theme[disabled].md-checked .md-icon {  background-color: '{{foreground-3}}'; }md-content.md-THEME_NAME-theme {  background-color: '{{background-hue-3}}'; }md-dialog.md-THEME_NAME-theme {  border-radius: 4px;  background-color: '{{background-hue-3}}'; }  md-dialog.md-THEME_NAME-theme.md-content-overflow .md-actions {    border-top-color: '{{foreground-4}}'; }md-divider.md-THEME_NAME-theme {  border-top-color: '{{foreground-4}}'; }md-icon.md-THEME_NAME-theme.md-primary {  color: '{{primary-color}}'; }md-icon.md-THEME_NAME-theme.md-accent {  color: '{{accent-color}}'; }md-icon.md-THEME_NAME-theme.md-warn {  color: '{{warn-color}}'; }md-icon.md-THEME_NAME-theme.md-danger {  color: '{{danger-color}}'; }md-input-container.md-THEME_NAME-theme .md-input {  color: '{{foreground-1}}';  border-color: '{{foreground-4}}';  text-shadow: '{{foreground-shadow}}'; }  md-input-container.md-THEME_NAME-theme .md-input::-webkit-input-placeholder, md-input-container.md-THEME_NAME-theme .md-input::-moz-placeholder, md-input-container.md-THEME_NAME-theme .md-input:-moz-placeholder, md-input-container.md-THEME_NAME-theme .md-input:-ms-input-placeholder {    color: '{{foreground-3}}'; }md-input-container.md-THEME_NAME-theme label, md-input-container.md-THEME_NAME-theme .md-placeholder {  text-shadow: '{{foreground-shadow}}';  color: '{{foreground-3}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-has-value label {  color: '{{foreground-2}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused .md-input {  border-color: '{{primary-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused label {  color: '{{primary-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-accent .md-input {  border-color: '{{accent-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-accent label {  color: '{{accent-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-warn .md-input {  border-color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-warn label {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid .md-input {  border-color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid label {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid data-ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid x-ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid [ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid [data-ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid [x-ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid .md-char-counter {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme .md-input[disabled], [disabled] md-input-container.md-THEME_NAME-theme .md-input {  border-bottom-color: transparent;  color: '{{foreground-3}}';  background-image: linear-gradient(to right, '{{foreground-4}}' 0%, '{{foreground-4}}' 33%, transparent 0%);  background-image: -ms-linear-gradient(left, transparent 0%, '{{foreground-4}}' 100%); }md-progress-circular.md-THEME_NAME-theme {  background-color: transparent; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-gap {    border-top-color: '{{primary-color}}';    border-bottom-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme .md-inner .md-right .md-half-circle {    border-top-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-right .md-half-circle {    border-right-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-left .md-half-circle {    border-left-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-gap {    border-top-color: '{{warn-color}}';    border-bottom-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-right .md-half-circle {    border-top-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-right .md-half-circle {    border-right-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-left .md-half-circle {    border-left-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-gap {    border-top-color: '{{accent-color}}';    border-bottom-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-right .md-half-circle {    border-top-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-right .md-half-circle {    border-right-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-left .md-half-circle {    border-left-color: '{{accent-color}}'; }md-progress-linear.md-THEME_NAME-theme .md-container {  background-color: '{{primary-100}}'; }md-progress-linear.md-THEME_NAME-theme .md-bar {  background-color: '{{primary-color}}'; }md-progress-linear.md-THEME_NAME-theme.md-warn .md-container {  background-color: '{{warn-100}}'; }md-progress-linear.md-THEME_NAME-theme.md-warn .md-bar {  background-color: '{{warn-color}}'; }md-progress-linear.md-THEME_NAME-theme.md-accent .md-container {  background-color: '{{accent-100}}'; }md-progress-linear.md-THEME_NAME-theme.md-accent .md-bar {  background-color: '{{accent-color}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-warn .md-bar1 {  background-color: '{{warn-100}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-warn .md-dashed:before {  background: radial-gradient('{{warn-100}}' 0%, '{{warn-100}}' 16%, transparent 42%); }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-accent .md-bar1 {  background-color: '{{accent-100}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-accent .md-dashed:before {  background: radial-gradient('{{accent-100}}' 0%, '{{accent-100}}' 16%, transparent 42%); }md-radio-button.md-THEME_NAME-theme .md-off {  border-color: '{{foreground-2}}'; }md-radio-button.md-THEME_NAME-theme .md-on {  background-color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme.md-checked .md-off {  border-color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme.md-checked .md-ink-ripple {  color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme .md-container .md-ripple {  color: '{{accent-600}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-on {  background-color: '{{primary-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-off {  border-color: '{{primary-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-ink-ripple {  color: '{{primary-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-container .md-ripple {  color: '{{primary-600}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-on {  background-color: '{{warn-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-off {  border-color: '{{warn-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-ink-ripple {  color: '{{warn-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-container .md-ripple {  color: '{{warn-600}}'; }md-radio-button.md-THEME_NAME-theme[disabled] .md-container .md-off {  border-color: '{{foreground-3}}'; }md-radio-button.md-THEME_NAME-theme[disabled] .md-container .md-on {  border-color: '{{foreground-3}}'; }md-radio-group.md-THEME_NAME-theme:focus:not(:empty) {  border-color: '{{foreground-1}}'; }md-select.md-THEME_NAME-theme:not([disabled]):focus .md-select-label {  border-bottom-color: '{{primary-color}}';  color: '{{ foreground-1 }}'; }  md-select.md-THEME_NAME-theme:not([disabled]):focus .md-select-label.md-placeholder {    color: '{{ foreground-1 }}'; }md-select.md-THEME_NAME-theme:not([disabled]):focus.md-accent .md-select-label {  border-bottom-color: '{{accent-color}}'; }md-select.md-THEME_NAME-theme:not([disabled]):focus.md-warn .md-select-label {  border-bottom-color: '{{warn-color}}'; }md-select.md-THEME_NAME-theme[disabled] .md-select-label {  color: '{{foreground-3}}'; }  md-select.md-THEME_NAME-theme[disabled] .md-select-label.md-placeholder {    color: '{{foreground-3}}'; }md-select.md-THEME_NAME-theme .md-select-label {  border-bottom-color: '{{foreground-4}}'; }  md-select.md-THEME_NAME-theme .md-select-label.md-placeholder {    color: '{{foreground-2}}'; }md-select-menu.md-THEME_NAME-theme md-optgroup {  color: '{{foreground-2}}'; }  md-select-menu.md-THEME_NAME-theme md-optgroup md-option {    color: '{{foreground-1}}'; }md-select-menu.md-THEME_NAME-theme md-option[selected] {  background-color: '{{primary-50}}'; }  md-select-menu.md-THEME_NAME-theme md-option[selected]:focus {    background-color: '{{primary-100}}'; }  md-select-menu.md-THEME_NAME-theme md-option[selected].md-accent {    background-color: '{{accent-50}}'; }    md-select-menu.md-THEME_NAME-theme md-option[selected].md-accent:focus {      background-color: '{{accent-100}}'; }md-select-menu.md-THEME_NAME-theme md-option:focus:not([selected]) {  background: '{{background-200}}'; }md-sidenav.md-THEME_NAME-theme {  background-color: '{{background-hue-3}}'; }md-slider.md-THEME_NAME-theme .md-track {  background-color: '{{foreground-3}}'; }md-slider.md-THEME_NAME-theme .md-track-ticks {  background-color: '{{foreground-4}}'; }md-slider.md-THEME_NAME-theme .md-focus-thumb {  background-color: '{{foreground-2}}'; }md-slider.md-THEME_NAME-theme .md-focus-ring {  border-color: '{{foreground-4}}'; }md-slider.md-THEME_NAME-theme .md-disabled-thumb {  border-color: '{{background-hue-3}}'; }md-slider.md-THEME_NAME-theme.md-min .md-thumb:after {  background-color: '{{background-hue-3}}'; }md-slider.md-THEME_NAME-theme .md-track.md-track-fill {  background-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-thumb:after {  border-color: '{{accent-color}}';  background-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-sign {  background-color: '{{accent-color}}'; }  md-slider.md-THEME_NAME-theme .md-sign:after {    border-top-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-thumb-text {  color: '{{accent-contrast}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-track.md-track-fill {  background-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-thumb:after {  border-color: '{{warn-color}}';  background-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-sign {  background-color: '{{warn-color}}'; }  md-slider.md-THEME_NAME-theme.md-warn .md-sign:after {    border-top-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-thumb-text {  color: '{{warn-contrast}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-track.md-track-fill {  background-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-thumb:after {  border-color: '{{primary-color}}';  background-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-sign {  background-color: '{{primary-color}}'; }  md-slider.md-THEME_NAME-theme.md-primary .md-sign:after {    border-top-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-thumb-text {  color: '{{primary-contrast}}'; }md-slider.md-THEME_NAME-theme[disabled] .md-thumb:after {  border-color: '{{foreground-3}}'; }md-slider.md-THEME_NAME-theme[disabled]:not(.md-min) .md-thumb:after {  background-color: '{{foreground-3}}'; }.md-subheader.md-THEME_NAME-theme {  color: '{{ foreground-2-0.23 }}';  background-color: '{{background-hue-3}}'; }  .md-subheader.md-THEME_NAME-theme.md-primary {    color: '{{primary-color}}'; }  .md-subheader.md-THEME_NAME-theme.md-accent {    color: '{{accent-color}}'; }  .md-subheader.md-THEME_NAME-theme.md-warn {    color: '{{warn-color}}'; }md-switch.md-THEME_NAME-theme .md-thumb {  background-color: '{{background-50}}'; }md-switch.md-THEME_NAME-theme .md-bar {  background-color: '{{background-500}}'; }md-switch.md-THEME_NAME-theme.md-checked .md-thumb {  background-color: '{{accent-color}}'; }md-switch.md-THEME_NAME-theme.md-checked .md-bar {  background-color: '{{accent-color-0.5}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-primary .md-thumb {  background-color: '{{primary-color}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-primary .md-bar {  background-color: '{{primary-color-0.5}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-warn .md-thumb {  background-color: '{{warn-color}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-warn .md-bar {  background-color: '{{warn-color-0.5}}'; }md-switch.md-THEME_NAME-theme[disabled] .md-thumb {  background-color: '{{background-400}}'; }md-switch.md-THEME_NAME-theme[disabled] .md-bar {  background-color: '{{foreground-4}}'; }md-switch.md-THEME_NAME-theme:focus .md-label:not(:empty) {  border-color: '{{foreground-1}}';  border-style: dotted; }md-tabs.md-THEME_NAME-theme .md-header {  background-color: transparent; }md-tabs.md-THEME_NAME-theme .md-paginator md-icon {  color: '{{primary-color}}'; }md-tabs.md-THEME_NAME-theme.md-accent .md-header {  background-color: '{{accent-color}}'; }md-tabs.md-THEME_NAME-theme.md-accent md-tab:not([disabled]) {  color: '{{accent-100}}'; }  md-tabs.md-THEME_NAME-theme.md-accent md-tab:not([disabled]).active {    color: '{{accent-contrast}}'; }md-tabs.md-THEME_NAME-theme.md-primary .md-header {  background-color: '{{primary-color}}'; }md-tabs.md-THEME_NAME-theme.md-primary md-tab:not([disabled]) {  color: '{{primary-100}}'; }  md-tabs.md-THEME_NAME-theme.md-primary md-tab:not([disabled]).active {    color: '{{primary-contrast}}'; }md-tabs.md-THEME_NAME-theme.md-primary md-tab {  color: '{{primary-100}}'; }  md-tabs.md-THEME_NAME-theme.md-primary md-tab[disabled] {    color: '{{foreground-3}}'; }  md-tabs.md-THEME_NAME-theme.md-primary md-tab:focus {    color: '{{primary-contrast}}';    background-color: '{{primary-contrast-0.1}}'; }  md-tabs.md-THEME_NAME-theme.md-primary md-tab.active {    color: '{{primary-contrast}}'; }  md-tabs.md-THEME_NAME-theme.md-primary md-tab .md-ripple-container {    color: '{{primary-contrast}}'; }md-tabs.md-THEME_NAME-theme.md-warn .md-header {  background-color: '{{warn-color}}'; }md-tabs.md-THEME_NAME-theme.md-warn md-tab:not([disabled]) {  color: '{{warn-100}}'; }  md-tabs.md-THEME_NAME-theme.md-warn md-tab:not([disabled]).active {    color: '{{warn-contrast}}'; }md-tabs.md-THEME_NAME-theme md-tabs-ink-bar {  color: '{{accent-color}}';  background: '{{accent-color}}'; }md-tabs.md-THEME_NAME-theme md-tab {  color: '{{foreground-2}}'; }  md-tabs.md-THEME_NAME-theme md-tab[disabled] {    color: '{{foreground-3}}'; }  md-tabs.md-THEME_NAME-theme md-tab:focus {    color: '{{foreground-1}}'; }  md-tabs.md-THEME_NAME-theme md-tab.active {    color: '{{primary-color}}'; }  md-tabs.md-THEME_NAME-theme md-tab .md-ripple-container {    color: '{{accent-100}}'; }md-input-group.md-THEME_NAME-theme input, md-input-group.md-THEME_NAME-theme textarea {  text-shadow: '{{foreground-shadow}}'; }  md-input-group.md-THEME_NAME-theme input::-webkit-input-placeholder, md-input-group.md-THEME_NAME-theme input::-moz-placeholder, md-input-group.md-THEME_NAME-theme input:-moz-placeholder, md-input-group.md-THEME_NAME-theme input:-ms-input-placeholder, md-input-group.md-THEME_NAME-theme textarea::-webkit-input-placeholder, md-input-group.md-THEME_NAME-theme textarea::-moz-placeholder, md-input-group.md-THEME_NAME-theme textarea:-moz-placeholder, md-input-group.md-THEME_NAME-theme textarea:-ms-input-placeholder {    color: '{{foreground-3}}'; }md-input-group.md-THEME_NAME-theme label {  text-shadow: '{{foreground-shadow}}';  color: '{{foreground-3}}'; }md-input-group.md-THEME_NAME-theme input, md-input-group.md-THEME_NAME-theme textarea {  color: '{{foreground-1}}';  border-color: '{{foreground-4}}'; }md-input-group.md-THEME_NAME-theme.md-input-focused input, md-input-group.md-THEME_NAME-theme.md-input-focused textarea {  border-color: '{{primary-500}}'; }md-input-group.md-THEME_NAME-theme.md-input-focused label {  color: '{{primary-500}}'; }md-input-group.md-THEME_NAME-theme.md-input-focused.md-accent input, md-input-group.md-THEME_NAME-theme.md-input-focused.md-accent textarea {  border-color: '{{accent-500}}'; }md-input-group.md-THEME_NAME-theme.md-input-focused.md-accent label {  color: '{{accent-500}}'; }md-input-group.md-THEME_NAME-theme.md-input-has-value:not(.md-input-focused) label {  color: '{{foreground-2}}'; }md-input-group.md-THEME_NAME-theme .md-input[disabled] {  border-bottom-color: '{{foreground-4}}';  color: '{{foreground-3}}'; }md-toast.md-THEME_NAME-theme {  background-color: '{{foreground-1}}';  color: '{{background-50}}'; }  md-toast.md-THEME_NAME-theme .md-button {    color: '{{background-50}}'; }    md-toast.md-THEME_NAME-theme .md-button.md-highlight {      color: '{{primary-A200}}'; }      md-toast.md-THEME_NAME-theme .md-button.md-highlight.md-accent {        color: '{{accent-A200}}'; }      md-toast.md-THEME_NAME-theme .md-button.md-highlight.md-warn {        color: '{{warn-A200}}'; }md-toolbar.md-THEME_NAME-theme {  background-color: '{{primary-color}}';  color: '{{primary-contrast}}'; }  md-toolbar.md-THEME_NAME-theme .md-button {    color: '{{primary-contrast}}'; }  md-toolbar.md-THEME_NAME-theme.md-accent {    background-color: '{{accent-color}}';    color: '{{accent-contrast}}'; }  md-toolbar.md-THEME_NAME-theme.md-warn {    background-color: '{{warn-color}}';    color: '{{warn-contrast}}'; }md-tooltip.md-THEME_NAME-theme {  color: '{{background-A100}}'; }  md-tooltip.md-THEME_NAME-theme .md-background {    background-color: '{{foreground-2}}'; }");

!function(e,t,r){"use strict";function n(e){return A(e)?e:Object.keys(e).map(function(t){return e[t]})}function u(e){return null===e}function i(e,t){var n=Object.keys(e);return-1==n.map(function(n){return t[n]!==r&&t[n]==e[n]}).indexOf(!1)}function a(e,t){if(""===t)return e;var r=e.indexOf(t.charAt(0));return-1===r?!1:a(e.substr(r+1),t.substr(1))}function o(e,t,r){var n=0;return e.filter(function(e){var u=O(r)?t>n&&r(e):t>n;return n=u?n+1:n,u})}function s(e,t,r){return r.round(e*r.pow(10,t))/r.pow(10,t)}function f(e,t,r){t=t||[];var n=Object.keys(e);return n.forEach(function(n){if(N(e[n])&&!A(e[n])){var u=r?r+"."+n:r;f(e[n],t,u||n)}else{var i=r?r+"."+n:n;t.push(i)}}),t}function l(e){return e&&e.$evalAsync&&e.$watch}function c(){return function(e,t){return e>t}}function m(){return function(e,t){return e>=t}}function d(){return function(e,t){return t>e}}function p(){return function(e,t){return t>=e}}function b(){return function(e,t){return e==t}}function h(){return function(e,t){return e!=t}}function v(){return function(e,t){return e===t}}function g(){return function(e,t){return e!==t}}function y(e){return function(t,r){return t=N(t)?n(t):t,!A(t)||F(r)?!1:t.some(function(t){return N(t)||z(r)?e(r)(t):t===r})}}function w(e,t){return t=t||0,t>=e.length?e:A(e[t])?w(e.slice(0,t).concat(e[t],e.slice(t+1)),t):w(e,t+1)}function $(e){return function(t,r){function u(e,t){return F(t)?!1:e.some(function(e){return T(e,t)})}if(t=N(t)?n(t):t,!A(t))return t;var i=[],a=e(r);return t.filter(F(r)?function(e,t,r){return r.indexOf(e)===t}:function(e){var t=a(e);return u(i,t)?!1:(i.push(t),!0)})}}function x(e,t,r){return t?e+r+x(e,--t,r):e}var O=t.isDefined,F=t.isUndefined,z=t.isFunction,E=t.isString,j=t.isNumber,N=t.isObject,A=t.isArray,C=t.forEach,L=t.extend,B=t.copy,T=t.equals;String.prototype.contains||(String.prototype.contains=function(){return-1!==String.prototype.indexOf.apply(this,arguments)}),t.module("a8m.angular",[]).filter("isUndefined",function(){return function(e){return t.isUndefined(e)}}).filter("isDefined",function(){return function(e){return t.isDefined(e)}}).filter("isFunction",function(){return function(e){return t.isFunction(e)}}).filter("isString",function(){return function(e){return t.isString(e)}}).filter("isNumber",function(){return function(e){return t.isNumber(e)}}).filter("isArray",function(){return function(e){return t.isArray(e)}}).filter("isObject",function(){return function(e){return t.isObject(e)}}).filter("isEqual",function(){return function(e,r){return t.equals(e,r)}}),t.module("a8m.conditions",[]).filter({isGreaterThan:c,">":c,isGreaterThanOrEqualTo:m,">=":m,isLessThan:d,"<":d,isLessThanOrEqualTo:p,"<=":p,isEqualTo:b,"==":b,isNotEqualTo:h,"!=":h,isIdenticalTo:v,"===":v,isNotIdenticalTo:g,"!==":g}),t.module("a8m.is-null",[]).filter("isNull",function(){return function(e){return u(e)}}),t.module("a8m.after-where",[]).filter("afterWhere",function(){return function(e,t){if(e=N(e)?n(e):e,!A(e)||F(t))return e;var r=e.map(function(e){return i(t,e)}).indexOf(!0);return e.slice(-1===r?0:r)}}),t.module("a8m.after",[]).filter("after",function(){return function(e,t){return e=N(e)?n(e):e,A(e)?e.slice(t):e}}),t.module("a8m.before-where",[]).filter("beforeWhere",function(){return function(e,t){if(e=N(e)?n(e):e,!A(e)||F(t))return e;var r=e.map(function(e){return i(t,e)}).indexOf(!0);return e.slice(0,-1===r?e.length:++r)}}),t.module("a8m.before",[]).filter("before",function(){return function(e,t){return e=N(e)?n(e):e,A(e)?e.slice(0,t?--t:t):e}}),t.module("a8m.concat",[]).filter("concat",[function(){return function(e,t){if(F(t))return e;if(A(e))return e.concat(N(t)?n(t):t);if(N(e)){var r=n(e);return r.concat(N(t)?n(t):t)}return e}}]),t.module("a8m.contains",[]).filter({contains:["$parse",y],some:["$parse",y]}),t.module("a8m.count-by",[]).filter("countBy",["$parse",function(e){return function(t,r){var u,i={},a=e(r);return t=N(t)?n(t):t,!A(t)||F(r)?t:(t.forEach(function(e){u=a(e),i[u]||(i[u]=0),i[u]++}),i)}}]),t.module("a8m.defaults",[]).filter("defaults",["$parse",function(e){return function(t,r){if(t=N(t)?n(t):t,!A(t)||!N(r))return t;var u=f(r);return t.forEach(function(t){u.forEach(function(n){var u=e(n),i=u.assign;F(u(t))&&i(t,u(r))})}),t}}]),t.module("a8m.every",[]).filter("every",["$parse",function(e){return function(t,r){return t=N(t)?n(t):t,!A(t)||F(r)?!0:t.every(function(t){return N(t)||z(r)?e(r)(t):t===r})}}]),t.module("a8m.filter-by",[]).filter("filterBy",["$parse",function(e){return function(t,u,i){var a;return i=E(i)||j(i)?String(i).toLowerCase():r,t=N(t)?n(t):t,!A(t)||F(i)?t:t.filter(function(t){return u.some(function(r){if(~r.indexOf("+")){var n=r.replace(new RegExp("\\s","g"),"").split("+");a=n.reduce(function(r,n,u){return 1===u?e(r)(t)+" "+e(n)(t):r+" "+e(n)(t)})}else a=e(r)(t);return E(a)||j(a)?String(a).toLowerCase().contains(i):!1})})}}]),t.module("a8m.first",[]).filter("first",["$parse",function(e){return function(t){var u,i,a;return t=N(t)?n(t):t,A(t)?(a=Array.prototype.slice.call(arguments,1),u=j(a[0])?a[0]:1,i=j(a[0])?j(a[1])?r:a[1]:a[0],a.length?o(t,u,i?e(i):i):t[0]):t}}]),t.module("a8m.flatten",[]).filter("flatten",function(){return function(e,t){return t=t||!1,e=N(e)?n(e):e,A(e)?t?[].concat.apply([],e):w(e,0):e}}),t.module("a8m.fuzzy-by",[]).filter("fuzzyBy",["$parse",function(e){return function(t,r,u,i){var o,s,f=i||!1;return t=N(t)?n(t):t,!A(t)||F(r)||F(u)?t:(s=e(r),t.filter(function(e){return o=s(e),E(o)?(o=f?o:o.toLowerCase(),u=f?u:u.toLowerCase(),a(o,u)!==!1):!1}))}}]),t.module("a8m.fuzzy",[]).filter("fuzzy",function(){return function(e,t,r){function u(e,t){var r,n,u=Object.keys(e);return 0<u.filter(function(u){return r=e[u],n?!0:E(r)?(r=i?r:r.toLowerCase(),n=a(r,t)!==!1):!1}).length}var i=r||!1;return e=N(e)?n(e):e,!A(e)||F(t)?e:(t=i?t:t.toLowerCase(),e.filter(function(e){return E(e)?(e=i?e:e.toLowerCase(),a(e,t)!==!1):N(e)?u(e,t):!1}))}}),t.module("a8m.group-by",["a8m.filter-watcher"]).filter("groupBy",["$parse","filterWatcher",function(e,t){return function(r,n){function u(e,t){var r,n={};return C(e,function(e){r=t(e),n[r]||(n[r]=[]),n[r].push(e)}),n}if(!N(r)||F(n))return r;var i=e(n);return t.isMemoized("groupBy",arguments)||t.memoize("groupBy",arguments,this,u(r,i))}}]),t.module("a8m.is-empty",[]).filter("isEmpty",function(){return function(e){return N(e)?!n(e).length:!e.length}}),t.module("a8m.join",[]).filter("join",function(){return function(e,t){return F(e)||!A(e)?e:(F(t)&&(t=" "),e.join(t))}}),t.module("a8m.last",[]).filter("last",["$parse",function(e){return function(t){var u,i,a,s=B(t);return s=N(s)?n(s):s,A(s)?(a=Array.prototype.slice.call(arguments,1),u=j(a[0])?a[0]:1,i=j(a[0])?j(a[1])?r:a[1]:a[0],a.length?o(s.reverse(),u,i?e(i):i).reverse():s[s.length-1]):s}}]),t.module("a8m.map",[]).filter("map",["$parse",function(e){return function(t,r){return t=N(t)?n(t):t,!A(t)||F(r)?t:t.map(function(t){return e(r)(t)})}}]),t.module("a8m.omit",[]).filter("omit",["$parse",function(e){return function(t,r){return t=N(t)?n(t):t,!A(t)||F(r)?t:t.filter(function(t){return!e(r)(t)})}}]),t.module("a8m.pick",[]).filter("pick",["$parse",function(e){return function(t,r){return t=N(t)?n(t):t,!A(t)||F(r)?t:t.filter(function(t){return e(r)(t)})}}]),t.module("a8m.remove-with",[]).filter("removeWith",function(){return function(e,t){return F(t)?e:(e=N(e)?n(e):e,e.filter(function(e){return!i(t,e)}))}}),t.module("a8m.remove",[]).filter("remove",function(){return function(e){e=N(e)?n(e):e;var t=Array.prototype.slice.call(arguments,1);return A(e)?e.filter(function(e){return!t.some(function(t){return T(t,e)})}):e}}),t.module("a8m.reverse",[]).filter("reverse",[function(){return function(e){return e=N(e)?n(e):e,E(e)?e.split("").reverse().join(""):A(e)?e.slice().reverse():e}}]),t.module("a8m.search-field",[]).filter("searchField",["$parse",function(e){return function(t){var r,u;t=N(t)?n(t):t;var i=Array.prototype.slice.call(arguments,1);return A(t)&&i.length?t.map(function(t){return u=i.map(function(n){return(r=e(n))(t)}).join(" "),L(t,{searchField:u})}):t}}]),t.module("a8m.to-array",[]).filter("toArray",function(){return function(e,t){return N(e)?t?Object.keys(e).map(function(t){return L(e[t],{$key:t})}):n(e):e}}),t.module("a8m.unique",[]).filter({unique:["$parse",$],uniq:["$parse",$]}),t.module("a8m.where",[]).filter("where",function(){return function(e,t){return F(t)?e:(e=N(e)?n(e):e,e.filter(function(e){return i(t,e)}))}}),t.module("a8m.xor",[]).filter("xor",["$parse",function(e){return function(t,r,u){function i(t,r){var n=e(u);return r.some(function(e){return u?T(n(e),n(t)):T(e,t)})}return u=u||!1,t=N(t)?n(t):t,r=N(r)?n(r):r,A(t)&&A(r)?t.concat(r).filter(function(e){return!(i(e,t)&&i(e,r))}):t}}]),t.module("a8m.math.byteFmt",["a8m.math"]).filter("byteFmt",["$math",function(e){return function(t,r){return j(r)&&isFinite(r)&&r%1===0&&r>=0&&j(t)&&isFinite(t)?1024>t?s(t,r,e)+" B":1048576>t?s(t/1024,r,e)+" KB":1073741824>t?s(t/1048576,r,e)+" MB":s(t/1073741824,r,e)+" GB":"NaN"}}]),t.module("a8m.math.degrees",["a8m.math"]).filter("degrees",["$math",function(e){return function(t,r){if(j(r)&&isFinite(r)&&r%1===0&&r>=0&&j(t)&&isFinite(t)){var n=180*t/e.PI;return e.round(n*e.pow(10,r))/e.pow(10,r)}return"NaN"}}]),t.module("a8m.math.kbFmt",["a8m.math"]).filter("kbFmt",["$math",function(e){return function(t,r){return j(r)&&isFinite(r)&&r%1===0&&r>=0&&j(t)&&isFinite(t)?1024>t?s(t,r,e)+" KB":1048576>t?s(t/1024,r,e)+" MB":s(t/1048576,r,e)+" GB":"NaN"}}]),t.module("a8m.math",[]).factory("$math",["$window",function(e){return e.Math}]),t.module("a8m.math.max",["a8m.math"]).filter("max",["$math","$parse",function(e,t){function r(r,n){var u=r.map(function(e){return t(n)(e)});return u.indexOf(e.max.apply(e,u))}return function(t,n){return A(t)?F(n)?e.max.apply(e,t):t[r(t,n)]:t}}]),t.module("a8m.math.min",["a8m.math"]).filter("min",["$math","$parse",function(e,t){function r(r,n){var u=r.map(function(e){return t(n)(e)});return u.indexOf(e.min.apply(e,u))}return function(t,n){return A(t)?F(n)?e.min.apply(e,t):t[r(t,n)]:t}}]),t.module("a8m.math.percent",["a8m.math"]).filter("percent",["$math","$window",function(e,t){return function(r,n,u){var i=E(r)?t.Number(r):r;return n=n||100,u=u||!1,!j(i)||t.isNaN(i)?r:u?e.round(i/n*100):i/n*100}}]),t.module("a8m.math.radians",["a8m.math"]).filter("radians",["$math",function(e){return function(t,r){if(j(r)&&isFinite(r)&&r%1===0&&r>=0&&j(t)&&isFinite(t)){var n=3.14159265359*t/180;return e.round(n*e.pow(10,r))/e.pow(10,r)}return"NaN"}}]),t.module("a8m.math.radix",[]).filter("radix",function(){return function(e,t){var r=/^[2-9]$|^[1-2]\d$|^3[0-6]$/;return j(e)&&r.test(t)?e.toString(t).toUpperCase():e}}),t.module("a8m.math.shortFmt",["a8m.math"]).filter("shortFmt",["$math",function(e){return function(t,r){return j(r)&&isFinite(r)&&r%1===0&&r>=0&&j(t)&&isFinite(t)?1e3>t?t:1e6>t?s(t/1e3,r,e)+" K":1e9>t?s(t/1e6,r,e)+" M":s(t/1e9,r,e)+" B":"NaN"}}]),t.module("a8m.math.sum",[]).filter("sum",function(){return function(e,t){return A(e)?e.reduce(function(e,t){return e+t},t||0):e}}),t.module("a8m.ends-with",[]).filter("endsWith",function(){return function(e,t,r){var n,u=r||!1;return!E(e)||F(t)?e:(e=u?e:e.toLowerCase(),n=e.length-t.length,-1!==e.indexOf(u?t:t.toLowerCase(),n))}}),t.module("a8m.latinize",[]).filter("latinize",[function(){function e(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return r[e]||e})}for(var t=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],r={},n=0;n<t.length;n++)for(var u=t[n].letters.split(""),i=0;i<u.length;i++)r[u[i]]=t[n].base;return function(t){return E(t)?e(t):t}}]),t.module("a8m.ltrim",[]).filter("ltrim",function(){return function(e,t){var r=t||"\\s";return E(e)?e.replace(new RegExp("^"+r+"+"),""):e}}),t.module("a8m.match",[]).filter("match",function(){return function(e,t,r){var n=new RegExp(t,r);return E(e)?e.match(n):null}}),t.module("a8m.repeat",[]).filter("repeat",[function(){return function(e,t,r){var n=~~t;return E(e)&&n?x(e,--t,r||""):e}}]),t.module("a8m.rtrim",[]).filter("rtrim",function(){return function(e,t){var r=t||"\\s";return E(e)?e.replace(new RegExp(r+"+$"),""):e}}),t.module("a8m.slugify",[]).filter("slugify",[function(){return function(e,t){var r=F(t)?"-":t;return E(e)?e.toLowerCase().replace(/\s+/g,r):e}}]),t.module("a8m.starts-with",[]).filter("startsWith",function(){return function(e,t,r){var n=r||!1;return!E(e)||F(t)?e:(e=n?e:e.toLowerCase(),!e.indexOf(n?t:t.toLowerCase()))}}),t.module("a8m.stringular",[]).filter("stringular",function(){return function(e){var t=Array.prototype.slice.call(arguments,1);return e.replace(/{(\d+)}/g,function(e,r){return F(t[r])?e:t[r]})}}),t.module("a8m.strip-tags",[]).filter("stripTags",function(){return function(e){return E(e)?e.replace(/<\S[^><]*>/g,""):e}}),t.module("a8m.test",[]).filter("test",function(){return function(e,t,r){var n=new RegExp(t,r);return E(e)?n.test(e):e}}),t.module("a8m.trim",[]).filter("trim",function(){return function(e,t){var r=t||"\\s";return E(e)?e.replace(new RegExp("^"+r+"+|"+r+"+$","g"),""):e}}),t.module("a8m.truncate",[]).filter("truncate",function(){return function(e,t,r,n){return t=F(t)?e.length:t,n=n||!1,r=r||"",!E(e)||e.length<=t?e:e.substring(0,n?-1===e.indexOf(" ",t)?e.length:e.indexOf(" ",t):t)+r}}),t.module("a8m.ucfirst",[]).filter("ucfirst",[function(){return function(e){return E(e)?e.split(" ").map(function(e){return e.charAt(0).toUpperCase()+e.substring(1)}).join(" "):e}}]),t.module("a8m.uri-component-encode",[]).filter("uriComponentEncode",["$window",function(e){return function(t){return E(t)?e.encodeURIComponent(t):t}}]),t.module("a8m.uri-encode",[]).filter("uriEncode",["$window",function(e){return function(t){return E(t)?e.encodeURI(t):t}}]),t.module("a8m.wrap",[]).filter("wrap",function(){return function(e,t,r){return E(e)&&O(t)?[t,e,r||t].join(""):e}}),t.module("a8m.filter-watcher",[]).provider("filterWatcher",function(){this.$get=["$window","$rootScope",function(e,r){function n(e,r){return[e,t.toJson(r)].join("#").replace(/"/g,"")}function u(e){var t=e.targetScope.$id;C(c[t],function(e){delete f[e]}),delete c[t]}function i(){m(function(){r.$$phase||(f={})})}function a(e,t){var r=e.$id;return F(c[r])&&(e.$on("$destroy",u),c[r]=[]),c[r].push(t)}function o(e,t){var r=n(e,t);return f[r]}function s(e,t,r,u){var o=n(e,t);return f[o]=u,l(r)?a(r,o):i(),u}var f={},c={},m=e.setTimeout;return{isMemoized:o,memoize:s}}]}),t.module("angular.filter",["a8m.ucfirst","a8m.uri-encode","a8m.uri-component-encode","a8m.slugify","a8m.latinize","a8m.strip-tags","a8m.stringular","a8m.truncate","a8m.starts-with","a8m.ends-with","a8m.wrap","a8m.trim","a8m.ltrim","a8m.rtrim","a8m.repeat","a8m.test","a8m.match","a8m.to-array","a8m.concat","a8m.contains","a8m.unique","a8m.is-empty","a8m.after","a8m.after-where","a8m.before","a8m.before-where","a8m.defaults","a8m.where","a8m.reverse","a8m.remove","a8m.remove-with","a8m.group-by","a8m.count-by","a8m.search-field","a8m.fuzzy-by","a8m.fuzzy","a8m.omit","a8m.pick","a8m.every","a8m.filter-by","a8m.xor","a8m.map","a8m.first","a8m.last","a8m.flatten","a8m.join","a8m.math","a8m.math.max","a8m.math.min","a8m.math.percent","a8m.math.radix","a8m.math.sum","a8m.math.degrees","a8m.math.radians","a8m.math.byteFmt","a8m.math.kbFmt","a8m.math.shortFmt","a8m.angular","a8m.conditions","a8m.is-null","a8m.filter-watcher"])}(window,window.angular);
angular.module("ngLodash",[]).constant("lodash",null).config(["$provide",function(n){function t(n,t){if(n!==t){var r=n===n,e=t===t;if(n>t||!r||"undefined"==typeof n&&e)return 1;if(t>n||!e||"undefined"==typeof t&&r)return-1}return 0}function r(n,t,r){if(t!==t)return h(n,r);for(var e=(r||0)-1,u=n.length;++e<u;)if(n[e]===t)return e;return-1}function e(n,t){var r=n.length;for(n.sort(t);r--;)n[r]=n[r].value;return n}function u(n){return"string"==typeof n?n:null==n?"":n+""}function i(n){return n.charCodeAt(0)}function o(n,t){for(var r=-1,e=n.length;++r<e&&t.indexOf(n.charAt(r))>-1;);return r}function a(n,t){for(var r=n.length;r--&&t.indexOf(n.charAt(r))>-1;);return r}function f(n,r){return t(n.criteria,r.criteria)||n.index-r.index}function c(n,r){for(var e=-1,u=n.criteria,i=r.criteria,o=u.length;++e<o;){var a=t(u[e],i[e]);if(a)return a}return n.index-r.index}function l(n){return Dn[n]}function s(n){return zn[n]}function p(n){return"\\"+Pn[n]}function h(n,t,r){for(var e=n.length,u=r?t||e:(t||0)-1;r?u--:++u<e;){var i=n[u];if(i!==i)return u}return-1}function v(n){return n&&"object"==typeof n||!1}function g(n){return 160>=n&&n>=9&&13>=n||32==n||160==n||5760==n||6158==n||n>=8192&&(8202>=n||8232==n||8233==n||8239==n||8287==n||12288==n||65279==n)}function d(n,t){for(var r=-1,e=n.length,u=-1,i=[];++r<e;)n[r]===t&&(n[r]=z,i[++u]=r);return i}function y(n,t){for(var r,e=-1,u=n.length,i=-1,o=[];++e<u;){var a=n[e],f=t?t(a,e,n):a;e&&r===f||(r=f,o[++i]=a)}return o}function _(n){for(var t=-1,r=n.length;++t<r&&g(n.charCodeAt(t)););return t}function m(n){for(var t=n.length;t--&&g(n.charCodeAt(t)););return t}function w(n){return Mn[n]}function b(n){function g(n){if(v(n)&&!Mo(n)){if(n instanceof G)return n;if(Ki.call(n,"__wrapped__"))return new G(n.__wrapped__,n.__chain__,Hn(n.__actions__))}return new G(n)}function G(n,t,r){this.__actions__=r||[],this.__chain__=!!t,this.__wrapped__=n}function H(n){this.actions=null,this.dir=1,this.dropCount=0,this.filtered=!1,this.iteratees=null,this.takeCount=xo,this.views=null,this.wrapped=n}function nn(){var n=this.actions,t=this.iteratees,r=this.views,e=new H(this.wrapped);return e.actions=n?Hn(n):null,e.dir=this.dir,e.dropCount=this.dropCount,e.filtered=this.filtered,e.iteratees=t?Hn(t):null,e.takeCount=this.takeCount,e.views=r?Hn(r):null,e}function Dn(){if(this.filtered){var n=new H(this);n.dir=-1,n.filtered=!0}else n=this.clone(),n.dir*=-1;return n}function zn(){var n=this.wrapped.value();if(!Mo(n))return Yt(n,this.actions);var t=this.dir,r=0>t,e=dr(0,n.length,this.views),u=e.start,i=e.end,o=i-u,a=this.dropCount,f=go(o,this.takeCount-a),c=r?i:u-1,l=this.iteratees,s=l?l.length:0,p=0,h=[];n:for(;o--&&f>p;){c+=t;for(var v=-1,g=n[c];++v<s;){var d=l[v],y=d.iteratee,_=y(g,c,n),m=d.type;if(m==$)g=_;else if(!_){if(m==L)continue n;break n}}a?a--:h[p++]=g}return h}function Mn(){this.__data__={}}function qn(n){return this.has(n)&&delete this.__data__[n]}function Pn(n){return"__proto__"==n?x:this.__data__[n]}function Vn(n){return"__proto__"!=n&&Ki.call(this.__data__,n)}function Yn(n,t){return"__proto__"!=n&&(this.__data__[n]=t),this}function Gn(n){var t=n?n.length:0;for(this.data={hash:so(null),set:new uo};t--;)this.push(n[t])}function Jn(n,t){var r=n.data,e="string"==typeof t||wu(t)?r.set.has(t):r.hash[t];return e?0:-1}function Zn(n){var t=this.data;"string"==typeof n||wu(n)?t.set.add(n):t.hash[n]=!0}function Hn(n,t){var r=-1,e=n.length;for(t||(t=Ci(e));++r<e;)t[r]=n[r];return t}function Qn(n,t){for(var r=-1,e=n.length;++r<e&&t(n[r],r,n)!==!1;);return n}function nt(n,t){for(var r=n.length;r--&&t(n[r],r,n)!==!1;);return n}function tt(n,t){for(var r=-1,e=n.length;++r<e;)if(!t(n[r],r,n))return!1;return!0}function rt(n,t){for(var r=-1,e=n.length,u=-1,i=[];++r<e;){var o=n[r];t(o,r,n)&&(i[++u]=o)}return i}function et(n,t){for(var r=-1,e=n.length,u=Ci(e);++r<e;)u[r]=t(n[r],r,n);return u}function ut(n){for(var t=-1,r=n.length,e=bo;++t<r;){var u=n[t];u>e&&(e=u)}return e}function it(n){for(var t=-1,r=n.length,e=xo;++t<r;){var u=n[t];e>u&&(e=u)}return e}function ot(n,t,r,e){var u=-1,i=n.length;for(e&&i&&(r=n[++u]);++u<i;)r=t(r,n[u],u,n);return r}function at(n,t,r,e){var u=n.length;for(e&&u&&(r=n[--u]);u--;)r=t(r,n[u],u,n);return r}function ft(n,t){for(var r=-1,e=n.length;++r<e;)if(t(n[r],r,n))return!0;return!1}function ct(n,t){return"undefined"==typeof n?t:n}function lt(n,t,r,e){return"undefined"!=typeof n&&Ki.call(e,r)?n:t}function st(n,t,r){var e=Vo(t);if(!r)return ht(t,n,e);for(var u=-1,i=e.length;++u<i;){var o=e[u],a=n[o],f=r(a,t[o],o,n,t);(f===f?f===a:a!==a)&&("undefined"!=typeof a||o in n)||(n[o]=f)}return n}function pt(n,t){for(var r=-1,e=n.length,u=Ar(e),i=t.length,o=Ci(i);++r<i;){var a=t[r];u?(a=parseFloat(a),o[r]=br(a,e)?n[a]:x):o[r]=n[a]}return o}function ht(n,t,r){r||(r=t,t={});for(var e=-1,u=r.length;++e<u;){var i=r[e];t[i]=n[i]}return t}function vt(n,t){for(var r=-1,e=t.length;++r<e;){var u=t[r];n[u]=cr(n[u],j,n)}return n}function gt(n,t,r){var e=typeof n;return"function"==e?"undefined"!=typeof t&&wr(n)?Xt(n,t,r):n:null==n?wi:"object"==e?Ft(n):Bt(n+"")}function dt(n,t,r,e,u,i,o){var a;if(r&&(a=u?r(n,e,u):r(n)),"undefined"!=typeof a)return a;if(!wu(n))return n;var f=Mo(n);if(f){if(a=yr(n),!t)return Hn(n,a)}else{var c=Yi.call(n),l=c==Y;if(c!=X&&c!=M&&(!l||u))return $n[c]?mr(n,c,t):u?n:{};if(a=_r(l?{}:n),!t)return ht(n,a,Vo(n))}i||(i=[]),o||(o=[]);for(var s=i.length;s--;)if(i[s]==n)return o[s];return i.push(n),o.push(a),(f?Qn:kt)(n,function(e,u){a[u]=dt(e,t,r,u,n,i,o)}),a}function yt(n,t,r,e){if(!mu(n))throw new Bi(D);return io(function(){n.apply(x,qt(r,e))},t)}function _t(n,t){var e=n?n.length:0,u=[];if(!e)return u;var i=-1,o=gr(),a=o==r,f=a&&t.length>=200&&So(t),c=t.length;f&&(o=Jn,a=!1,t=f);n:for(;++i<e;){var l=n[i];if(a&&l===l){for(var s=c;s--;)if(t[s]===l)continue n;u.push(l)}else o(t,l)<0&&u.push(l)}return u}function mt(n,t){var r=n?n.length:0;if(!Ar(r))return kt(n,t);for(var e=-1,u=Sr(n);++e<r&&t(u[e],e,u)!==!1;);return n}function wt(n,t){var r=n?n.length:0;if(!Ar(r))return Ot(n,t);for(var e=Sr(n);r--&&t(e[r],r,e)!==!1;);return n}function bt(n,t){var r=!0;return mt(n,function(n,e,u){return r=!!t(n,e,u)}),r}function xt(n,t){var r=[];return mt(n,function(n,e,u){t(n,e,u)&&r.push(n)}),r}function At(n,t,r,e){var u;return r(n,function(n,r,i){return t(n,r,i)?(u=e?r:n,!1):void 0}),u}function jt(n,t,r,e){for(var u=(e||0)-1,i=n.length,o=-1,a=[];++u<i;){var f=n[u];if(v(f)&&Ar(f.length)&&(Mo(f)||pu(f))){t&&(f=jt(f,t,r));var c=-1,l=f.length;for(a.length+=l;++c<l;)a[++o]=f[c]}else r||(a[++o]=f)}return a}function Et(n,t,r){for(var e=-1,u=Sr(n),i=r(n),o=i.length;++e<o;){var a=i[e];if(t(u[a],a,u)===!1)break}return n}function Rt(n,t,r){for(var e=Sr(n),u=r(n),i=u.length;i--;){var o=u[i];if(t(e[o],o,e)===!1)break}return n}function It(n,t){return Et(n,t,qu)}function kt(n,t){return Et(n,t,Vo)}function Ot(n,t){return Rt(n,t,Vo)}function Ct(n,t){for(var r=-1,e=t.length,u=-1,i=[];++r<e;){var o=t[r];mu(n[o])&&(i[++u]=o)}return i}function Tt(n,t,r){var e=-1,u="function"==typeof t,i=n?n.length:0,o=Ar(i)?Ci(i):[];return mt(n,function(n){var i=u?t:null!=n&&n[t];o[++e]=i?i.apply(n,r):x}),o}function St(n,t,r,e,u,i){if(n===t)return 0!==n||1/n==1/t;var o=typeof n,a=typeof t;return"function"!=o&&"object"!=o&&"function"!=a&&"object"!=a||null==n||null==t?n!==n&&t!==t:Nt(n,t,St,r,e,u,i)}function Nt(n,t,r,e,u,i,o){var a=Mo(n),f=Mo(t),c=q,l=q;a||(c=Yi.call(n),c==M?c=X:c!=X&&(a=ku(n))),f||(l=Yi.call(t),l==M?l=X:l!=X&&(f=ku(t)));var s=c==X,p=l==X,h=c==l;if(h&&!a&&!s)return sr(n,t,c);var v=s&&Ki.call(n,"__wrapped__"),g=p&&Ki.call(t,"__wrapped__");if(v||g)return r(v?n.value():n,g?t.value():t,e,u,i,o);if(!h)return!1;i||(i=[]),o||(o=[]);for(var d=i.length;d--;)if(i[d]==n)return o[d]==t;i.push(n),o.push(t);var y=(a?lr:pr)(n,t,r,e,u,i,o);return i.pop(),o.pop(),y}function Ut(n,t,r,e,u){var i=t.length;if(null==n)return!i;for(var o=-1,a=!u;++o<i;)if(a&&e[o]?r[o]!==n[t[o]]:!Ki.call(n,t[o]))return!1;for(o=-1;++o<i;){var f=t[o];if(a&&e[o])var c=Ki.call(n,f);else{var l=n[f],s=r[o];c=u?u(l,s,f):x,"undefined"==typeof c&&(c=St(s,l,u,!0))}if(!c)return!1}return!0}function Wt(n,t){var r=[];return mt(n,function(n,e,u){r.push(t(n,e,u))}),r}function Ft(n){var t=Vo(n),r=t.length;if(1==r){var e=t[0],u=n[e];if(jr(u))return function(n){return null!=n&&u===n[e]&&Ki.call(n,e)}}for(var i=Ci(r),o=Ci(r);r--;)u=n[t[r]],i[r]=u,o[r]=jr(u);return function(n){return Ut(n,t,i,o)}}function Lt(n,t,r,e,u){var i=Ar(t.length)&&(Mo(t)||ku(t));return(i?Qn:kt)(t,function(t,o,a){if(v(t))return e||(e=[]),u||(u=[]),$t(n,a,o,Lt,r,e,u);var f=n[o],c=r?r(f,t,o,n,a):x,l="undefined"==typeof c;l&&(c=t),!i&&"undefined"==typeof c||!l&&(c===c?c===f:f!==f)||(n[o]=c)}),n}function $t(n,t,r,e,u,i,o){for(var a=i.length,f=t[r];a--;)if(i[a]==f)return void(n[r]=o[a]);var c=n[r],l=u?u(c,f,r,n,t):x,s="undefined"==typeof l;s&&(l=f,Ar(f.length)&&(Mo(f)||ku(f))?l=Mo(c)?c:c?Hn(c):[]:Po(f)||pu(f)?l=pu(c)?Tu(c):Po(c)?c:{}:s=!1),i.push(f),o.push(l),s?n[r]=e(l,f,u,i,o):(l===l?l!==c:c===c)&&(n[r]=l)}function Bt(n){return function(t){return null==t?x:t[n]}}function Dt(n,r){var e=r.length,u=pt(n,r);for(r.sort(t);e--;){var i=parseFloat(r[e]);if(i!=o&&br(i)){var o=i;oo.call(n,i,1)}}return u}function zt(n,t){return n+no(wo()*(t-n+1))}function Mt(n,t,r,e,u){return u(n,function(n,u,i){r=e?(e=!1,n):t(r,n,u,i)}),r}function qt(n,t,r){var e=-1,u=n.length;t=null==t?0:+t||0,0>t&&(t=-t>u?0:u+t),r="undefined"==typeof r||r>u?u:+r||0,0>r&&(r+=u),u=t>r?0:r-t>>>0,t>>>=0;for(var i=Ci(u);++e<u;)i[e]=n[e+t];return i}function Pt(n,t){var r;return mt(n,function(n,e,u){return r=t(n,e,u),!r}),!!r}function Kt(n,t){var e=-1,u=gr(),i=n.length,o=u==r,a=o&&i>=200,f=a&&So(),c=[];f?(u=Jn,o=!1):(a=!1,f=t?[]:c);n:for(;++e<i;){var l=n[e],s=t?t(l,e,n):l;if(o&&l===l){for(var p=f.length;p--;)if(f[p]===s)continue n;t&&f.push(s),c.push(l)}else u(f,s)<0&&((t||a)&&f.push(s),c.push(l))}return c}function Vt(n,t){for(var r=-1,e=t.length,u=Ci(e);++r<e;)u[r]=n[t[r]];return u}function Yt(n,t){var r=n;r instanceof H&&(r=r.value());for(var e=-1,u=t.length;++e<u;){var i=[r],o=t[e];ro.apply(i,o.args),r=o.func.apply(o.thisArg,i)}return r}function Gt(n,t,r){var e=0,u=n?n.length:e;if("number"==typeof t&&t===t&&Eo>=u){for(;u>e;){var i=e+u>>>1,o=n[i];(r?t>=o:t>o)?e=i+1:u=i}return u}return Jt(n,t,wi,r)}function Jt(n,t,r,e){t=r(t);for(var u=0,i=n?n.length:0,o=t!==t,a="undefined"==typeof t;i>u;){var f=no((u+i)/2),c=r(n[f]),l=c===c;if(o)var s=l||e;else s=a?l&&(e||"undefined"!=typeof c):e?t>=c:t>c;s?u=f+1:i=f}return go(i,jo)}function Xt(n,t,r){if("function"!=typeof n)return wi;if("undefined"==typeof t)return n;switch(r){case 1:return function(r){return n.call(t,r)};case 3:return function(r,e,u){return n.call(t,r,e,u)};case 4:return function(r,e,u,i){return n.call(t,r,e,u,i)};case 5:return function(r,e,u,i,o){return n.call(t,r,e,u,i,o)}}return function(){return n.apply(t,arguments)}}function Zt(n){return Zi.call(n,0)}function Ht(n,t,r){for(var e=r.length,u=-1,i=vo(n.length-e,0),o=-1,a=t.length,f=Ci(i+a);++o<a;)f[o]=t[o];for(;++u<e;)f[r[u]]=n[u];for(;i--;)f[o++]=n[u++];return f}function Qt(n,t,r){for(var e=-1,u=r.length,i=-1,o=vo(n.length-u,0),a=-1,f=t.length,c=Ci(o+f);++i<o;)c[i]=n[i];for(var l=i;++a<f;)c[l+a]=t[a];for(;++e<u;)c[l+r[e]]=n[i++];return c}function nr(n,t){return function(r,e,u){var i=t?t():{};if(e=vr(e,u,3),Mo(r))for(var o=-1,a=r.length;++o<a;){var f=r[o];n(i,f,e(f,o,r),r)}else mt(r,function(t,r,u){n(i,t,e(t,r,u),u)});return i}}function tr(n){return function(){var t=arguments.length,r=arguments[0];if(2>t||null==r)return r;if(t>3&&xr(arguments[1],arguments[2],arguments[3])&&(t=2),t>3&&"function"==typeof arguments[t-2])var e=Xt(arguments[--t-1],arguments[t--],5);else t>2&&"function"==typeof arguments[t-1]&&(e=arguments[--t]);for(var u=0;++u<t;){var i=arguments[u];i&&n(r,i,e)}return r}}function rr(n,t){function r(){return(this instanceof r?e:n).apply(t,arguments)}var e=ur(n);return r}function er(n){return function(t){for(var r=-1,e=di(ni(t)),u=e.length,i="";++r<u;)i=n(i,e[r],r);return i}}function ur(n){return function(){var t=Co(n.prototype),r=n.apply(t,arguments);return wu(r)?r:t}}function ir(n,t){return function(r,e,u){u&&xr(r,e,u)&&(e=null);var o=vr(),a=null==e;if(o===gt&&a||(a=!1,e=o(e,u,3)),a){var f=Mo(r);if(f||!Iu(r))return n(f?r:Tr(r));e=i}return hr(r,e,t)}}function or(n,t,r,e,u,i,o,a,f,c){function l(){for(var w=arguments.length,b=w,x=Ci(w);b--;)x[b]=arguments[b];if(e&&(x=Ht(x,e,u)),i&&(x=Qt(x,i,o)),v||y){var A=l.placeholder,R=d(x,A);if(w-=R.length,c>w){var I=a?Hn(a):null,k=vo(c-w,0),T=v?R:null,S=v?null:R,N=v?x:null,U=v?null:x;t|=v?O:C,t&=~(v?C:O),g||(t&=~(j|E));var W=or(n,t,r,N,T,U,S,I,f,k);return W.placeholder=A,W}}var F=p?r:this;return h&&(n=F[m]),a&&(x=kr(x,a)),s&&f<x.length&&(x.length=f),(this instanceof l?_||ur(n):n).apply(F,x)}var s=t&S,p=t&j,h=t&E,v=t&I,g=t&R,y=t&k,_=!h&&ur(n),m=n;return l}function ar(n,t,r){var e=n.length;if(t=+t,e>=t||!po(t))return"";var u=t-e;return r=null==r?" ":r+"",fi(r,Hi(u/r.length)).slice(0,u)}function fr(n,t,r,e){function u(){for(var t=-1,a=arguments.length,f=-1,c=e.length,l=Ci(a+c);++f<c;)l[f]=e[f];for(;a--;)l[f++]=arguments[++t];return(this instanceof u?o:n).apply(i?r:this,l)}var i=t&j,o=ur(n);return u}function cr(n,t,r,e,u,i,o,a){var f=t&E;if(!f&&!mu(n))throw new Bi(D);var c=e?e.length:0;if(c||(t&=~(O|C),e=u=null),c-=u?u.length:0,t&C){var l=e,s=u;e=u=null}var p=!f&&No(n),h=[n,t,r,e,u,l,s,i,o,a];if(p&&p!==!0&&(Er(h,p),t=h[1],a=h[9]),h[9]=null==a?f?0:n.length:vo(a-c,0)||0,t==j)var v=rr(h[0],h[2]);else v=t!=O&&t!=(j|O)||h[4].length?or.apply(null,h):fr.apply(null,h);var g=p?To:Uo;return g(v,h)}function lr(n,t,r,e,u,i,o){var a=-1,f=n.length,c=t.length,l=!0;if(f!=c&&!(u&&c>f))return!1;for(;l&&++a<f;){var s=n[a],p=t[a];if(l=x,e&&(l=u?e(p,s,a):e(s,p,a)),"undefined"==typeof l)if(u)for(var h=c;h--&&(p=t[h],!(l=s&&s===p||r(s,p,e,u,i,o))););else l=s&&s===p||r(s,p,e,u,i,o)}return!!l}function sr(n,t,r){switch(r){case P:case K:return+n==+t;case V:return n.name==t.name&&n.message==t.message;case J:return n!=+n?t!=+t:0==n?1/n==1/t:n==+t;case Z:case Q:return n==t+""}return!1}function pr(n,t,r,e,u,i,o){var a=Vo(n),f=a.length,c=Vo(t),l=c.length;if(f!=l&&!u)return!1;for(var s,p=-1;++p<f;){var h=a[p],v=Ki.call(t,h);if(v){var g=n[h],d=t[h];v=x,e&&(v=u?e(d,g,h):e(g,d,h)),"undefined"==typeof v&&(v=g&&g===d||r(g,d,e,u,i,o))}if(!v)return!1;s||(s="constructor"==h)}if(!s){var y=n.constructor,_=t.constructor;if(y!=_&&"constructor"in n&&"constructor"in t&&!("function"==typeof y&&y instanceof y&&"function"==typeof _&&_ instanceof _))return!1}return!0}function hr(n,t,r){var e=r?xo:bo,u=e,i=u;return mt(n,function(n,o,a){var f=t(n,o,a);((r?u>f:f>u)||f===e&&f===i)&&(u=f,i=n)}),i}function vr(n,t,r){var e=g.callback||_i;return e=e===_i?gt:e,r?e(n,t,r):e}function gr(n,t,e){var u=g.indexOf||Kr;return u=u===Kr?r:u,n?u(n,t,e):u}function dr(n,t,r){for(var e=-1,u=r?r.length:0;++e<u;){var i=r[e],o=i.size;switch(i.type){case"drop":n+=o;break;case"dropRight":t-=o;break;case"take":t=go(t,n+o);break;case"takeRight":n=vo(n,t-o)}}return{start:n,end:t}}function yr(n){var t=n.length,r=new n.constructor(t);return t&&"string"==typeof n[0]&&Ki.call(n,"index")&&(r.index=n.index,r.input=n.input),r}function _r(n){var t=n.constructor;return"function"==typeof t&&t instanceof t||(t=Fi),new t}function mr(n,t,r){var e=n.constructor;switch(t){case tn:return Zt(n);case P:case K:return new e(+n);case rn:case en:case un:case on:case an:case fn:case cn:case ln:case sn:var u=n.buffer;return new e(r?Zt(u):u,n.byteOffset,n.length);case J:case Q:return new e(n);case Z:var i=new e(n.source,An.exec(n));i.lastIndex=n.lastIndex}return i}function wr(n){var t=g.support,r=!(t.funcNames?n.name:t.funcDecomp);if(!r){var e=qi.call(n);t.funcNames||(r=!jn.test(e)),r||(r=Tn.test(e)||Au(n),To(n,r))}return r}function br(n,t){return n=+n,t=null==t?Io:t,n>-1&&n%1==0&&t>n}function xr(n,t,r){if(!wu(r))return!1;var e=typeof t;if("number"==e)var u=r.length,i=Ar(u)&&br(t,u);else i="string"==e&&t in r;return i&&r[t]===n}function Ar(n){return"number"==typeof n&&n>-1&&n%1==0&&Io>=n}function jr(n){return n===n&&(0===n?1/n>0:!wu(n))}function Er(n,t){var r=n[1],e=t[1],u=r|e,i=S|T,o=j|E,a=i|o|R|k,f=r&S&&!(e&S),c=r&T&&!(e&T),l=(c?n:t)[7],s=(f?n:t)[8],p=!(r>=T&&e>o||r>o&&e>=T),h=u>=i&&a>=u&&(T>r||(c||f)&&l.length<=s);if(!p&&!h)return n;e&j&&(n[2]=t[2],u|=r&j?0:R);var v=t[3];if(v){var g=n[3];n[3]=g?Ht(g,v,t[4]):Hn(v),n[4]=g?d(n[3],z):Hn(t[4])}return v=t[5],v&&(g=n[5],n[5]=g?Qt(g,v,t[6]):Hn(v),n[6]=g?d(n[5],z):Hn(t[6])),v=t[7],v&&(n[7]=Hn(v)),e&S&&(n[8]=null==n[8]?t[8]:go(n[8],t[8])),null==n[9]&&(n[9]=t[9]),n[0]=t[0],n[1]=u,n}function Rr(n,t){n=Sr(n);for(var r=-1,e=t.length,u={};++r<e;){var i=t[r];i in n&&(u[i]=n[i])}return u}function Ir(n,t){var r={};return It(n,function(n,e,u){t(n,e,u)&&(r[e]=n)}),r}function kr(n,t){for(var r=n.length,e=go(t.length,r),u=Hn(n);e--;){var i=t[e];n[e]=br(i,r)?u[i]:x}return n}function Or(n){{var t;g.support}if(!v(n)||Yi.call(n)!=X||!Ki.call(n,"constructor")&&(t=n.constructor,"function"==typeof t&&!(t instanceof t)))return!1;var r;return It(n,function(n,t){r=t}),"undefined"==typeof r||Ki.call(n,r)}function Cr(n){for(var t=qu(n),r=t.length,e=r&&n.length,u=g.support,i=e&&Ar(e)&&(Mo(n)||u.nonEnumArgs&&pu(n)),o=-1,a=[];++o<r;){var f=t[o];(i&&br(f,e)||Ki.call(n,f))&&a.push(f)}return a}function Tr(n){return null==n?[]:Ar(n.length)?wu(n)?n:Fi(n):Xu(n)}function Sr(n){return wu(n)?n:Fi(n)}function Nr(n,t,r){t=(r?xr(n,t,r):null==t)?1:vo(+t||1,1);for(var e=0,u=n?n.length:0,i=-1,o=Ci(Hi(u/t));u>e;)o[++i]=qt(n,e,e+=t);return o}function Ur(n){for(var t=-1,r=n?n.length:0,e=-1,u=[];++t<r;){var i=n[t];i&&(u[++e]=i)}return u}function Wr(){for(var n=-1,t=arguments.length;++n<t;){var r=arguments[n];if(Mo(r)||pu(r))break}return _t(r,jt(arguments,!1,!0,++n))}function Fr(n,t,r){var e=n?n.length:0;return e?((r?xr(n,t,r):null==t)&&(t=1),qt(n,0>t?0:t)):[]}function Lr(n,t,r){var e=n?n.length:0;return e?((r?xr(n,t,r):null==t)&&(t=1),t=e-(+t||0),qt(n,0,0>t?0:t)):[]}function $r(n,t,r){var e=n?n.length:0;if(!e)return[];for(t=vr(t,r,3);e--&&t(n[e],e,n););return qt(n,0,e+1)}function Br(n,t,r){var e=n?n.length:0;if(!e)return[];var u=-1;for(t=vr(t,r,3);++u<e&&t(n[u],u,n););return qt(n,u)}function Dr(n,t,r){var e=-1,u=n?n.length:0;for(t=vr(t,r,3);++e<u;)if(t(n[e],e,n))return e;return-1}function zr(n,t,r){var e=n?n.length:0;for(t=vr(t,r,3);e--;)if(t(n[e],e,n))return e;return-1}function Mr(n){return n?n[0]:x}function qr(n,t,r){var e=n?n.length:0;return r&&xr(n,t,r)&&(t=!1),e?jt(n,t):[]}function Pr(n){var t=n?n.length:0;return t?jt(n,!0):[]}function Kr(n,t,e){var u=n?n.length:0;if(!u)return-1;if("number"==typeof e)e=0>e?vo(u+e,0):e||0;else if(e){var i=Gt(n,t),o=n[i];return(t===t?t===o:o!==o)?i:-1}return r(n,t,e)}function Vr(n){return Lr(n,1)}function Yr(){for(var n=[],t=-1,e=arguments.length,u=[],i=gr(),o=i==r;++t<e;){var a=arguments[t];(Mo(a)||pu(a))&&(n.push(a),u.push(o&&a.length>=120&&So(t&&a)))}e=n.length;var f=n[0],c=-1,l=f?f.length:0,s=[],p=u[0];n:for(;++c<l;)if(a=f[c],(p?Jn(p,a):i(s,a))<0){for(t=e;--t;){var h=u[t];if((h?Jn(h,a):i(n[t],a))<0)continue n}p&&p.push(a),s.push(a)}return s}function Gr(n){var t=n?n.length:0;return t?n[t-1]:x}function Jr(n,t,r){var e=n?n.length:0;if(!e)return-1;var u=e;if("number"==typeof r)u=(0>r?vo(e+r,0):go(r||0,e-1))+1;else if(r){u=Gt(n,t,!0)-1;var i=n[u];return(t===t?t===i:i!==i)?u:-1}if(t!==t)return h(n,u,!0);for(;u--;)if(n[u]===t)return u;return-1}function Xr(){var n=arguments[0];if(!n||!n.length)return n;for(var t=0,r=gr(),e=arguments.length;++t<e;)for(var u=0,i=arguments[t];(u=r(n,i,u))>-1;)oo.call(n,u,1);return n}function Zr(n){return Dt(n||[],jt(arguments,!1,!1,1))}function Hr(n,t,r){var e=-1,u=n?n.length:0,i=[];for(t=vr(t,r,3);++e<u;){var o=n[e];t(o,e,n)&&(i.push(o),oo.call(n,e--,1),u--)}return i}function Qr(n){return Fr(n,1)}function ne(n,t,r){var e=n?n.length:0;return e?(r&&"number"!=typeof r&&xr(n,t,r)&&(t=0,r=e),qt(n,t,r)):[]}function te(n,t,r,e){var u=vr(r);return u===gt&&null==r?Gt(n,t):Jt(n,t,u(r,e,1))}function re(n,t,r,e){var u=vr(r);return u===gt&&null==r?Gt(n,t,!0):Jt(n,t,u(r,e,1),!0)}function ee(n,t,r){var e=n?n.length:0;return e?((r?xr(n,t,r):null==t)&&(t=1),qt(n,0,0>t?0:t)):[]}function ue(n,t,r){var e=n?n.length:0;return e?((r?xr(n,t,r):null==t)&&(t=1),t=e-(+t||0),qt(n,0>t?0:t)):[]}function ie(n,t,r){var e=n?n.length:0;if(!e)return[];for(t=vr(t,r,3);e--&&t(n[e],e,n););return qt(n,e+1)}function oe(n,t,r){var e=n?n.length:0;if(!e)return[];var u=-1;for(t=vr(t,r,3);++u<e&&t(n[u],u,n););return qt(n,0,u)}function ae(){return Kt(jt(arguments,!1,!0))}function fe(n,t,e,u){var i=n?n.length:0;if(!i)return[];"boolean"!=typeof t&&null!=t&&(u=e,e=xr(n,t,u)?null:t,t=!1);var o=vr();return(o!==gt||null!=e)&&(e=o(e,u,3)),t&&gr()==r?y(n,e):Kt(n,e)}function ce(n){for(var t=-1,r=(n&&n.length&&ut(et(n,Pi)))>>>0,e=Ci(r);++t<r;)e[t]=et(n,Bt(t));return e}function le(n){return _t(n,qt(arguments,1))}function se(){for(var n=-1,t=arguments.length;++n<t;){var r=arguments[n];if(Mo(r)||pu(r))var e=e?_t(e,r).concat(_t(r,e)):r}return e?Kt(e):[]}function pe(){for(var n=arguments.length,t=Ci(n);n--;)t[n]=arguments[n];return ce(t)}function he(n,t){var r=-1,e=n?n.length:0,u={};for(!e||t||Mo(n[0])||(t=[]);++r<e;){var i=n[r];t?u[i]=t[r]:i&&(u[i[0]]=i[1])}return u}function ve(n){var t=g(n);return t.__chain__=!0,t}function ge(n,t,r){return t.call(r,n),n}function de(n,t,r){return t.call(r,n)}function ye(){return ve(this)}function _e(){var n=this.__wrapped__;return n instanceof H?(this.__actions__.length&&(n=new H(this)),new G(n.reverse())):this.thru(function(n){return n.reverse()})}function me(){return this.value()+""}function we(){return Yt(this.__wrapped__,this.__actions__)}function be(n){var t=n?n.length:0;return Ar(t)&&(n=Tr(n)),pt(n,jt(arguments,!1,!1,1))}function xe(n,t,r){var e=n?n.length:0;return Ar(e)||(n=Xu(n),e=n.length),e?(r="number"==typeof r?0>r?vo(e+r,0):r||0:0,"string"==typeof n||!Mo(n)&&Iu(n)?e>r&&n.indexOf(t,r)>-1:gr(n,t,r)>-1):!1}function Ae(n,t,r){var e=Mo(n)?tt:bt;return("function"!=typeof t||"undefined"!=typeof r)&&(t=vr(t,r,3)),e(n,t)}function je(n,t,r){var e=Mo(n)?rt:xt;return t=vr(t,r,3),e(n,t)}function Ee(n,t,r){if(Mo(n)){var e=Dr(n,t,r);return e>-1?n[e]:x}return t=vr(t,r,3),At(n,t,mt)}function Re(n,t,r){return t=vr(t,r,3),At(n,t,wt)}function Ie(n,t){return Ee(n,Ft(t))}function ke(n,t,r){return"function"==typeof t&&"undefined"==typeof r&&Mo(n)?Qn(n,t):mt(n,Xt(t,r,3))}function Oe(n,t,r){return"function"==typeof t&&"undefined"==typeof r&&Mo(n)?nt(n,t):wt(n,Xt(t,r,3))}function Ce(n,t){return Tt(n,t,qt(arguments,2))}function Te(n,t,r){var e=Mo(n)?et:Wt;return t=vr(t,r,3),e(n,t)}function Se(n,t){return Te(n,Bt(t+""))}function Ne(n,t,r,e){var u=Mo(n)?ot:Mt;return u(n,vr(t,e,4),r,arguments.length<3,mt)}function Ue(n,t,r,e){var u=Mo(n)?at:Mt;return u(n,vr(t,e,4),r,arguments.length<3,wt)}function We(n,t,r){var e=Mo(n)?rt:xt;return t=vr(t,r,3),e(n,function(n,r,e){return!t(n,r,e)})}function Fe(n,t,r){if(r?xr(n,t,r):null==t){n=Tr(n);var e=n.length;return e>0?n[zt(0,e-1)]:x}var u=Le(n);return u.length=go(0>t?0:+t||0,u.length),u}function Le(n){n=Tr(n);for(var t=-1,r=n.length,e=Ci(r);++t<r;){var u=zt(0,t);t!=u&&(e[t]=e[u]),e[u]=n[t]}return e}function $e(n){var t=n?n.length:0;return Ar(t)?t:Vo(n).length}function Be(n,t,r){var e=Mo(n)?ft:Pt;return("function"!=typeof t||"undefined"!=typeof r)&&(t=vr(t,r,3)),e(n,t)}function De(n,t,r){var u=-1,i=n?n.length:0,o=Ar(i)?Ci(i):[];return r&&xr(n,t,r)&&(t=null),t=vr(t,r,3),mt(n,function(n,r,e){o[++u]={criteria:t(n,r,e),index:u,value:n}}),e(o,f)}function ze(n){var t=arguments;t.length>3&&xr(t[1],t[2],t[3])&&(t=[n,t[1]]);var r=-1,u=n?n.length:0,i=jt(t,!1,!1,1),o=Ar(u)?Ci(u):[];return mt(n,function(n,t,e){for(var u=i.length,a=Ci(u);u--;)a[u]=null==n?x:n[i[u]];o[++r]={criteria:a,index:r,value:n}}),e(o,c)}function Me(n,t){return je(n,Ft(t))}function qe(n,t){if(!mu(t)){if(!mu(n))throw new Bi(D);var r=n;n=t,t=r}return n=po(n=+n)?n:0,function(){return--n<1?t.apply(this,arguments):void 0}}function Pe(n,t,r){return r&&xr(n,t,r)&&(t=null),t=n&&null==t?n.length:vo(+t||0,0),cr(n,S,null,null,null,null,t)}function Ke(n,t){var r;if(!mu(t)){if(!mu(n))throw new Bi(D);var e=n;n=t,t=e}return function(){return--n>0?r=t.apply(this,arguments):t=null,r}}function Ve(n,t){var r=j;if(arguments.length>2){var e=qt(arguments,2),u=d(e,Ve.placeholder);r|=O}return cr(n,r,t,e,u)}function Ye(n){return vt(n,arguments.length>1?jt(arguments,!1,!1,1):Du(n))}function Ge(n,t){var r=j|E;if(arguments.length>2){var e=qt(arguments,2),u=d(e,Ge.placeholder);r|=O}return cr(t,r,n,e,u)}function Je(n,t,r){r&&xr(n,t,r)&&(t=null);var e=cr(n,I,null,null,null,null,null,t);return e.placeholder=Je.placeholder,e}function Xe(n,t,r){r&&xr(n,t,r)&&(t=null);var e=cr(n,k,null,null,null,null,null,t);return e.placeholder=Xe.placeholder,e}function Ze(n,t,r){function e(){p&&Qi(p),f&&Qi(f),f=p=h=x}function u(){var r=t-(zo()-l);if(0>=r||r>t){f&&Qi(f);var e=h;f=p=h=x,e&&(v=zo(),c=n.apply(s,a),p||f||(a=s=null))}else p=io(u,r)}function i(){p&&Qi(p),f=p=h=x,(d||g!==t)&&(v=zo(),c=n.apply(s,a),p||f||(a=s=null))}function o(){if(a=arguments,l=zo(),s=this,h=d&&(p||!y),g===!1)var r=y&&!p;else{f||y||(v=l);var e=g-(l-v),o=0>=e||e>g;o?(f&&(f=Qi(f)),v=l,c=n.apply(s,a)):f||(f=io(i,e))}return o&&p?p=Qi(p):p||t===g||(p=io(u,t)),r&&(o=!0,c=n.apply(s,a)),!o||p||f||(a=s=null),c}var a,f,c,l,s,p,h,v=0,g=!1,d=!0;if(!mu(n))throw new Bi(D);if(t=0>t?0:t,r===!0){var y=!0;d=!1}else wu(r)&&(y=r.leading,g="maxWait"in r&&vo(+r.maxWait||0,t),d="trailing"in r?r.trailing:d);return o.cancel=e,o}function He(n){return yt(n,1,arguments,1)}function Qe(n,t){return yt(n,t,arguments,2)}function nu(){var n=arguments,t=n.length;if(!t)return function(){};if(!tt(n,mu))throw new Bi(D);return function(){for(var r=0,e=n[r].apply(this,arguments);++r<t;)e=n[r].call(this,e);return e}}function tu(){var n=arguments,t=n.length-1;if(0>t)return function(){};if(!tt(n,mu))throw new Bi(D);return function(){for(var r=t,e=n[r].apply(this,arguments);r--;)e=n[r].call(this,e);return e}}function ru(n,t){if(!mu(n)||t&&!mu(t))throw new Bi(D);var r=function(){var e=r.cache,u=t?t.apply(this,arguments):arguments[0];if(e.has(u))return e.get(u);var i=n.apply(this,arguments);return e.set(u,i),i};return r.cache=new ru.Cache,r}function eu(n){if(!mu(n))throw new Bi(D);return function(){return!n.apply(this,arguments)}}function uu(n){return Ke(n,2)}function iu(n){var t=qt(arguments,1),r=d(t,iu.placeholder);return cr(n,O,null,t,r)}function ou(n){var t=qt(arguments,1),r=d(t,ou.placeholder);return cr(n,C,null,t,r)}function au(n){var t=jt(arguments,!1,!1,1);return cr(n,T,null,null,null,t)}function fu(n,t,r){var e=!0,u=!0;if(!mu(n))throw new Bi(D);return r===!1?e=!1:wu(r)&&(e="leading"in r?!!r.leading:e,u="trailing"in r?!!r.trailing:u),Bn.leading=e,Bn.maxWait=+t,Bn.trailing=u,Ze(n,t,Bn)}function cu(n,t){return t=null==t?wi:t,cr(t,O,null,[n],[])}function lu(n,t,r,e){return"boolean"!=typeof t&&null!=t&&(e=r,r=xr(n,t,e)?null:t,t=!1),r="function"==typeof r&&Xt(r,e,1),dt(n,t,r)}function su(n,t,r){return t="function"==typeof t&&Xt(t,r,1),dt(n,!0,t)}function pu(n){var t=v(n)?n.length:x;return Ar(t)&&Yi.call(n)==M||!1}function hu(n){return n===!0||n===!1||v(n)&&Yi.call(n)==P||!1}function vu(n){return v(n)&&Yi.call(n)==K||!1}function gu(n){return n&&1===n.nodeType&&v(n)&&Yi.call(n).indexOf("Element")>-1||!1}function du(n){if(null==n)return!0;var t=n.length;return Ar(t)&&(Mo(n)||Iu(n)||pu(n)||v(n)&&mu(n.splice))?!t:!Vo(n).length}function yu(n,t,r,e){if(r="function"==typeof r&&Xt(r,e,3),!r&&jr(n)&&jr(t))return n===t;var u=r?r(n,t):x;return"undefined"==typeof u?St(n,t,r):!!u}function _u(n){return v(n)&&"string"==typeof n.message&&Yi.call(n)==V||!1}function mu(n){return"function"==typeof n||!1}function wu(n){var t=typeof n;return"function"==t||n&&"object"==t||!1}function bu(n,t,r,e){var u=Vo(t),i=u.length;if(r="function"==typeof r&&Xt(r,e,3),!r&&1==i){var o=u[0],a=t[o];if(jr(a))return null!=n&&a===n[o]&&Ki.call(n,o)}for(var f=Ci(i),c=Ci(i);i--;)a=f[i]=t[u[i]],c[i]=jr(a);return Ut(n,u,f,c,r)}function xu(n){return Eu(n)&&n!=+n}function Au(n){return null==n?!1:Yi.call(n)==Y?Ji.test(qi.call(n)):v(n)&&Rn.test(n)||!1}function ju(n){return null===n}function Eu(n){return"number"==typeof n||v(n)&&Yi.call(n)==J||!1}function Ru(n){return v(n)&&Yi.call(n)==Z||!1}function Iu(n){return"string"==typeof n||v(n)&&Yi.call(n)==Q||!1}function ku(n){return v(n)&&Ar(n.length)&&Ln[Yi.call(n)]||!1}function Ou(n){return"undefined"==typeof n}function Cu(n){var t=n?n.length:0;return Ar(t)?t?Hn(n):[]:Xu(n)}function Tu(n){return ht(n,qu(n))}function Su(n,t,r){var e=Co(n);return r&&xr(n,t,r)&&(t=null),t?ht(t,e,Vo(t)):e}function Nu(n){if(null==n)return n;var t=Hn(arguments);return t.push(ct),Ko.apply(x,t)}function Uu(n,t,r){return t=vr(t,r,3),At(n,t,kt,!0)}function Wu(n,t,r){return t=vr(t,r,3),At(n,t,Ot,!0)}function Fu(n,t,r){return("function"!=typeof t||"undefined"!=typeof r)&&(t=Xt(t,r,3)),Et(n,t,qu)}function Lu(n,t,r){return t=Xt(t,r,3),Rt(n,t,qu)}function $u(n,t,r){return("function"!=typeof t||"undefined"!=typeof r)&&(t=Xt(t,r,3)),kt(n,t)}function Bu(n,t,r){return t=Xt(t,r,3),Rt(n,t,Vo)}function Du(n){return Ct(n,qu(n))}function zu(n,t){return n?Ki.call(n,t):!1}function Mu(n,t,r){r&&xr(n,t,r)&&(t=null);for(var e=-1,u=Vo(n),i=u.length,o={};++e<i;){var a=u[e],f=n[a];t?Ki.call(o,f)?o[f].push(a):o[f]=[a]:o[f]=a}return o}function qu(n){if(null==n)return[];wu(n)||(n=Fi(n));var t=n.length;t=t&&Ar(t)&&(Mo(n)||Oo.nonEnumArgs&&pu(n))&&t||0;for(var r=n.constructor,e=-1,u="function"==typeof r&&r.prototype==n,i=Ci(t),o=t>0;++e<t;)i[e]=e+"";for(var a in n)o&&br(a,t)||"constructor"==a&&(u||!Ki.call(n,a))||i.push(a);return i}function Pu(n,t,r){var e={};return t=vr(t,r,3),kt(n,function(n,r,u){e[r]=t(n,r,u)}),e}function Ku(n,t,r){if(null==n)return{};if("function"!=typeof t){var e=et(jt(arguments,!1,!1,1),$i);return Rr(n,_t(qu(n),e))}return t=Xt(t,r,3),Ir(n,function(n,r,e){return!t(n,r,e)})}function Vu(n){for(var t=-1,r=Vo(n),e=r.length,u=Ci(e);++t<e;){var i=r[t];u[t]=[i,n[i]]}return u}function Yu(n,t,r){return null==n?{}:"function"==typeof t?Ir(n,Xt(t,r,3)):Rr(n,jt(arguments,!1,!1,1))}function Gu(n,t,r){var e=null==n?x:n[t];return"undefined"==typeof e&&(e=r),mu(e)?e.call(n):e}function Ju(n,t,r,e){var u=Mo(n)||ku(n);if(t=vr(t,e,4),null==r)if(u||wu(n)){var i=n.constructor;r=u?Mo(n)?new i:[]:Co("function"==typeof i&&i.prototype)}else r={};return(u?Qn:kt)(n,function(n,e,u){return t(r,n,e,u)}),r}function Xu(n){return Vt(n,Vo(n))}function Zu(n){return Vt(n,qu(n))}function Hu(n,t,r){r&&xr(n,t,r)&&(t=r=null);var e=null==n,u=null==t;if(null==r&&(u&&"boolean"==typeof n?(r=n,n=1):"boolean"==typeof t&&(r=t,u=!0)),e&&u&&(t=1,u=!1),n=+n||0,u?(t=n,n=0):t=+t||0,r||n%1||t%1){var i=wo();return go(n+i*(t-n+parseFloat("1e-"+((i+"").length-1))),t)}return zt(n,t)}function Qu(n){return n=u(n),n&&n.charAt(0).toUpperCase()+n.slice(1)}function ni(n){return n=u(n),n&&n.replace(In,l)}function ti(n,t,r){n=u(n),t+="";var e=n.length;return r=("undefined"==typeof r?e:go(0>r?0:+r||0,e))-t.length,r>=0&&n.indexOf(t,r)==r}function ri(n){return n=u(n),n&&_n.test(n)?n.replace(dn,s):n}function ei(n){return n=u(n),n&&Cn.test(n)?n.replace(On,"\\$&"):n}function ui(n,t,r){n=u(n),t=+t;var e=n.length;if(e>=t||!po(t))return n;var i=(t-e)/2,o=no(i),a=Hi(i);return r=ar("",a,r),r.slice(0,o)+n+r}function ii(n,t,r){return n=u(n),n&&ar(n,t,r)+n}function oi(n,t,r){return n=u(n),n&&n+ar(n,t,r)}function ai(n,t,r){return r&&xr(n,t,r)&&(t=0),mo(n,t)}function fi(n,t){var r="";if(n=u(n),t=+t,1>t||!n||!po(t))return r;do t%2&&(r+=n),t=no(t/2),n+=n;while(t);return r}function ci(n,t,r){return n=u(n),r=null==r?0:go(0>r?0:+r||0,n.length),n.lastIndexOf(t,r)==r}function li(n,t,r){var e=g.templateSettings;r&&xr(n,t,r)&&(t=r=null),n=u(n),t=st(st({},r||t),e,lt);var i,o,a=st(st({},t.imports),e.imports,lt),f=Vo(a),c=Vt(a,f),l=0,s=t.interpolate||kn,h="__p += '",v=Li((t.escape||kn).source+"|"+s.source+"|"+(s===bn?xn:kn).source+"|"+(t.evaluate||kn).source+"|$","g"),d="//# sourceURL="+("sourceURL"in t?t.sourceURL:"lodash.templateSources["+ ++Fn+"]")+"\n";n.replace(v,function(t,r,e,u,a,f){return e||(e=u),h+=n.slice(l,f).replace(Sn,p),
r&&(i=!0,h+="' +\n__e("+r+") +\n'"),a&&(o=!0,h+="';\n"+a+";\n__p += '"),e&&(h+="' +\n((__t = ("+e+")) == null ? '' : __t) +\n'"),l=f+t.length,t}),h+="';\n";var y=t.variable;y||(h="with (obj) {\n"+h+"\n}\n"),h=(o?h.replace(pn,""):h).replace(hn,"$1").replace(vn,"$1;"),h="function("+(y||"obj")+") {\n"+(y?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(i?", __e = _.escape":"")+(o?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+h+"return __p\n}";var _=yi(function(){return Ni(f,d+"return "+h).apply(x,c)});if(_.source=h,_u(_))throw _;return _}function si(n,t,r){var e=n;return(n=u(n))?(r?xr(e,t,r):null==t)?n.slice(_(n),m(n)+1):(t+="",n.slice(o(n,t),a(n,t)+1)):n}function pi(n,t,r){var e=n;return n=u(n),n?n.slice((r?xr(e,t,r):null==t)?_(n):o(n,t+"")):n}function hi(n,t,r){var e=n;return n=u(n),n?(r?xr(e,t,r):null==t)?n.slice(0,m(n)+1):n.slice(0,a(n,t+"")+1):n}function vi(n,t,r){r&&xr(n,t,r)&&(t=null);var e=N,i=U;if(null!=t)if(wu(t)){var o="separator"in t?t.separator:o;e="length"in t?+t.length||0:e,i="omission"in t?u(t.omission):i}else e=+t||0;if(n=u(n),e>=n.length)return n;var a=e-i.length;if(1>a)return i;var f=n.slice(0,a);if(null==o)return f+i;if(Ru(o)){if(n.slice(a).search(o)){var c,l,s=n.slice(0,a);for(o.global||(o=Li(o.source,(An.exec(o)||"")+"g")),o.lastIndex=0;c=o.exec(s);)l=c.index;f=f.slice(0,null==l?a:l)}}else if(n.indexOf(o,a)!=a){var p=f.lastIndexOf(o);p>-1&&(f=f.slice(0,p))}return f+i}function gi(n){return n=u(n),n&&yn.test(n)?n.replace(gn,w):n}function di(n,t,r){return r&&xr(n,t,r)&&(t=null),n=u(n),n.match(t||Nn)||[]}function yi(n){try{return n()}catch(t){return _u(t)?t:Si(t)}}function _i(n,t,r){return r&&xr(n,t,r)&&(t=null),v(n)?bi(n):gt(n,t)}function mi(n){return function(){return n}}function wi(n){return n}function bi(n){return Ft(dt(n,!0))}function xi(n,t,r){if(null==r){var e=wu(t),u=e&&Vo(t),i=u&&u.length&&Ct(t,u);(i?i.length:e)||(i=!1,r=t,t=n,n=this)}i||(i=Ct(t,Vo(t)));var o=!0,a=-1,f=mu(n),c=i.length;r===!1?o=!1:wu(r)&&"chain"in r&&(o=r.chain);for(;++a<c;){var l=i[a],s=t[l];n[l]=s,f&&(n.prototype[l]=function(t){return function(){var r=this.__chain__;if(o||r){var e=n(this.__wrapped__);return(e.__actions__=Hn(this.__actions__)).push({func:t,args:arguments,thisArg:n}),e.__chain__=r,e}var u=[this.value()];return ro.apply(u,arguments),t.apply(n,u)}}(s))}return n}function Ai(){return n._=Gi,this}function ji(){}function Ei(n){return Bt(n+"")}function Ri(n){return function(t){return null==n?x:n[t]}}function Ii(n,t,r){r&&xr(n,t,r)&&(t=r=null),n=+n||0,r=null==r?1:+r||0,null==t?(t=n,n=0):t=+t||0;for(var e=-1,u=vo(Hi((t-n)/(r||1)),0),i=Ci(u);++e<u;)i[e]=n,n+=r;return i}function ki(n,t,r){if(n=+n,1>n||!po(n))return[];var e=-1,u=Ci(go(n,Ao));for(t=Xt(t,r,1);++e<n;)Ao>e?u[e]=t(e):t(e);return u}function Oi(n){var t=++Vi;return u(n)+t}n=n?Xn.defaults(Kn.Object(),n,Xn.pick(Kn,Wn)):Kn;var Ci=n.Array,Ti=n.Date,Si=n.Error,Ni=n.Function,Ui=n.Math,Wi=n.Number,Fi=n.Object,Li=n.RegExp,$i=n.String,Bi=n.TypeError,Di=Ci.prototype,zi=Fi.prototype,Mi=(Mi=n.window)&&Mi.document,qi=Ni.prototype.toString,Pi=Bt("length"),Ki=zi.hasOwnProperty,Vi=0,Yi=zi.toString,Gi=n._,Ji=Li("^"+ei(Yi).replace(/toString|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),Xi=Au(Xi=n.ArrayBuffer)&&Xi,Zi=Au(Zi=Xi&&new Xi(0).slice)&&Zi,Hi=Ui.ceil,Qi=n.clearTimeout,no=Ui.floor,to=Au(to=Fi.getPrototypeOf)&&to,ro=Di.push,eo=zi.propertyIsEnumerable,uo=Au(uo=n.Set)&&uo,io=n.setTimeout,oo=Di.splice,ao=Au(ao=n.Uint8Array)&&ao,fo=(Di.unshift,Au(fo=n.WeakMap)&&fo),co=function(){try{var t=Au(t=n.Float64Array)&&t,r=new t(new Xi(10),0,1)&&t}catch(e){}return r}(),lo=Au(lo=Ci.isArray)&&lo,so=Au(so=Fi.create)&&so,po=n.isFinite,ho=Au(ho=Fi.keys)&&ho,vo=Ui.max,go=Ui.min,yo=Au(yo=Ti.now)&&yo,_o=Au(_o=Wi.isFinite)&&_o,mo=n.parseInt,wo=Ui.random,bo=Wi.NEGATIVE_INFINITY,xo=Wi.POSITIVE_INFINITY,Ao=Ui.pow(2,32)-1,jo=Ao-1,Eo=Ao>>>1,Ro=co?co.BYTES_PER_ELEMENT:0,Io=Ui.pow(2,53)-1,ko=fo&&new fo,Oo=g.support={};!function(t){Oo.funcDecomp=!Au(n.WinRTError)&&Tn.test(b),Oo.funcNames="string"==typeof Ni.name;try{Oo.dom=11===Mi.createDocumentFragment().nodeType}catch(r){Oo.dom=!1}try{Oo.nonEnumArgs=!eo.call(arguments,1)}catch(r){Oo.nonEnumArgs=!0}}(0,0),g.templateSettings={escape:mn,evaluate:wn,interpolate:bn,variable:"",imports:{_:g}};var Co=function(){function t(){}return function(r){if(wu(r)){t.prototype=r;var e=new t;t.prototype=null}return e||n.Object()}}(),To=ko?function(n,t){return ko.set(n,t),n}:wi;Zi||(Zt=Xi&&ao?function(n){var t=n.byteLength,r=co?no(t/Ro):0,e=r*Ro,u=new Xi(t);if(r){var i=new co(u,0,r);i.set(new co(n,0,r))}return t!=e&&(i=new ao(u,e),i.set(new ao(n,e))),u}:mi(null));var So=so&&uo?function(n){return new Gn(n)}:mi(null),No=ko?function(n){return ko.get(n)}:ji,Uo=function(){var n=0,t=0;return function(r,e){var u=zo(),i=F-(u-t);if(t=u,i>0){if(++n>=W)return r}else n=0;return To(r,e)}}(),Wo=nr(function(n,t,r){Ki.call(n,r)?++n[r]:n[r]=1}),Fo=nr(function(n,t,r){Ki.call(n,r)?n[r].push(t):n[r]=[t]}),Lo=nr(function(n,t,r){n[r]=t}),$o=ir(ut),Bo=ir(it,!0),Do=nr(function(n,t,r){n[r?0:1].push(t)},function(){return[[],[]]}),zo=yo||function(){return(new Ti).getTime()},Mo=lo||function(n){return v(n)&&Ar(n.length)&&Yi.call(n)==q||!1};Oo.dom||(gu=function(n){return n&&1===n.nodeType&&v(n)&&!Po(n)||!1});var qo=_o||function(n){return"number"==typeof n&&po(n)};(mu(/x/)||ao&&!mu(ao))&&(mu=function(n){return Yi.call(n)==Y});var Po=to?function(n){if(!n||Yi.call(n)!=X)return!1;var t=n.valueOf,r=Au(t)&&(r=to(t))&&to(r);return r?n==r||to(n)==r:Or(n)}:Or,Ko=tr(st),Vo=ho?function(n){if(n)var t=n.constructor,r=n.length;return"function"==typeof t&&t.prototype===n||"function"!=typeof n&&r&&Ar(r)?Cr(n):wu(n)?ho(n):[]}:Cr,Yo=tr(Lt),Go=er(function(n,t,r){return t=t.toLowerCase(),n+(r?t.charAt(0).toUpperCase()+t.slice(1):t)}),Jo=er(function(n,t,r){return n+(r?"-":"")+t.toLowerCase()});8!=mo(Un+"08")&&(ai=function(n,t,r){return(r?xr(n,t,r):null==t)?t=0:t&&(t=+t),n=si(n),mo(n,t||(En.test(n)?16:10))});var Xo=er(function(n,t,r){return n+(r?"_":"")+t.toLowerCase()}),Zo=er(function(n,t,r){return n+(r?" ":"")+(t.charAt(0).toUpperCase()+t.slice(1))});return G.prototype=g.prototype,Mn.prototype["delete"]=qn,Mn.prototype.get=Pn,Mn.prototype.has=Vn,Mn.prototype.set=Yn,Gn.prototype.push=Zn,ru.Cache=Mn,g.after=qe,g.ary=Pe,g.assign=Ko,g.at=be,g.before=Ke,g.bind=Ve,g.bindAll=Ye,g.bindKey=Ge,g.callback=_i,g.chain=ve,g.chunk=Nr,g.compact=Ur,g.constant=mi,g.countBy=Wo,g.create=Su,g.curry=Je,g.curryRight=Xe,g.debounce=Ze,g.defaults=Nu,g.defer=He,g.delay=Qe,g.difference=Wr,g.drop=Fr,g.dropRight=Lr,g.dropRightWhile=$r,g.dropWhile=Br,g.filter=je,g.flatten=qr,g.flattenDeep=Pr,g.flow=nu,g.flowRight=tu,g.forEach=ke,g.forEachRight=Oe,g.forIn=Fu,g.forInRight=Lu,g.forOwn=$u,g.forOwnRight=Bu,g.functions=Du,g.groupBy=Fo,g.indexBy=Lo,g.initial=Vr,g.intersection=Yr,g.invert=Mu,g.invoke=Ce,g.keys=Vo,g.keysIn=qu,g.map=Te,g.mapValues=Pu,g.matches=bi,g.memoize=ru,g.merge=Yo,g.mixin=xi,g.negate=eu,g.omit=Ku,g.once=uu,g.pairs=Vu,g.partial=iu,g.partialRight=ou,g.partition=Do,g.pick=Yu,g.pluck=Se,g.property=Ei,g.propertyOf=Ri,g.pull=Xr,g.pullAt=Zr,g.range=Ii,g.rearg=au,g.reject=We,g.remove=Hr,g.rest=Qr,g.shuffle=Le,g.slice=ne,g.sortBy=De,g.sortByAll=ze,g.take=ee,g.takeRight=ue,g.takeRightWhile=ie,g.takeWhile=oe,g.tap=ge,g.throttle=fu,g.thru=de,g.times=ki,g.toArray=Cu,g.toPlainObject=Tu,g.transform=Ju,g.union=ae,g.uniq=fe,g.unzip=ce,g.values=Xu,g.valuesIn=Zu,g.where=Me,g.without=le,g.wrap=cu,g.xor=se,g.zip=pe,g.zipObject=he,g.backflow=tu,g.collect=Te,g.compose=tu,g.each=ke,g.eachRight=Oe,g.extend=Ko,g.iteratee=_i,g.methods=Du,g.object=he,g.select=je,g.tail=Qr,g.unique=fe,xi(g,g),g.attempt=yi,g.camelCase=Go,g.capitalize=Qu,g.clone=lu,g.cloneDeep=su,g.deburr=ni,g.endsWith=ti,g.escape=ri,g.escapeRegExp=ei,g.every=Ae,g.find=Ee,g.findIndex=Dr,g.findKey=Uu,g.findLast=Re,g.findLastIndex=zr,g.findLastKey=Wu,g.findWhere=Ie,g.first=Mr,g.has=zu,g.identity=wi,g.includes=xe,g.indexOf=Kr,g.isArguments=pu,g.isArray=Mo,g.isBoolean=hu,g.isDate=vu,g.isElement=gu,g.isEmpty=du,g.isEqual=yu,g.isError=_u,g.isFinite=qo,g.isFunction=mu,g.isMatch=bu,g.isNaN=xu,g.isNative=Au,g.isNull=ju,g.isNumber=Eu,g.isObject=wu,g.isPlainObject=Po,g.isRegExp=Ru,g.isString=Iu,g.isTypedArray=ku,g.isUndefined=Ou,g.kebabCase=Jo,g.last=Gr,g.lastIndexOf=Jr,g.max=$o,g.min=Bo,g.noConflict=Ai,g.noop=ji,g.now=zo,g.pad=ui,g.padLeft=ii,g.padRight=oi,g.parseInt=ai,g.random=Hu,g.reduce=Ne,g.reduceRight=Ue,g.repeat=fi,g.result=Gu,g.runInContext=b,g.size=$e,g.snakeCase=Xo,g.some=Be,g.sortedIndex=te,g.sortedLastIndex=re,g.startCase=Zo,g.startsWith=ci,g.template=li,g.trim=si,g.trimLeft=pi,g.trimRight=hi,g.trunc=vi,g.unescape=gi,g.uniqueId=Oi,g.words=di,g.all=Ae,g.any=Be,g.contains=xe,g.detect=Ee,g.foldl=Ne,g.foldr=Ue,g.head=Mr,g.include=xe,g.inject=Ne,xi(g,function(){var n={};return kt(g,function(t,r){g.prototype[r]||(n[r]=t)}),n}(),!1),g.sample=Fe,g.prototype.sample=function(n){return this.__chain__||null!=n?this.thru(function(t){return Fe(t,n)}):Fe(this.value())},g.VERSION=A,Qn(["bind","bindKey","curry","curryRight","partial","partialRight"],function(n){g[n].placeholder=g}),Qn(["filter","map","takeWhile"],function(n,t){var r=t==L;H.prototype[n]=function(n,e){var u=this.clone(),i=u.filtered,o=u.iteratees||(u.iteratees=[]);return u.filtered=i||r||t==B&&u.dir<0,o.push({iteratee:vr(n,e,3),type:t}),u}}),Qn(["drop","take"],function(n,t){var r=n+"Count",e=n+"While";H.prototype[n]=function(e){e=null==e?1:vo(+e||0,0);var u=this.clone();if(u.filtered){var i=u[r];u[r]=t?go(i,e):i+e}else{var o=u.views||(u.views=[]);o.push({size:e,type:n+(u.dir<0?"Right":"")})}return u},H.prototype[n+"Right"]=function(t){return this.reverse()[n](t).reverse()},H.prototype[n+"RightWhile"]=function(n,t){return this.reverse()[e](n,t).reverse()}}),Qn(["first","last"],function(n,t){var r="take"+(t?"Right":"");H.prototype[n]=function(){return this[r](1).value()[0]}}),Qn(["initial","rest"],function(n,t){var r="drop"+(t?"":"Right");H.prototype[n]=function(){return this[r](1)}}),Qn(["pluck","where"],function(n,t){var r=t?"filter":"map",e=t?Ft:Bt;H.prototype[n]=function(n){return this[r](e(t?n:n+""))}}),H.prototype.dropWhile=function(n,t){var r,e,u=this.dir<0;return n=vr(n,t,3),this.filter(function(t,i,o){return r=r&&(u?e>i:i>e),e=i,r||(r=!n(t,i,o))})},H.prototype.reject=function(n,t){return n=vr(n,t,3),this.filter(function(t,r,e){return!n(t,r,e)})},H.prototype.slice=function(n,t){n=null==n?0:+n||0;var r=0>n?this.takeRight(-n):this.drop(n);return"undefined"!=typeof t&&(t=+t||0,r=0>t?r.dropRight(-t):r.take(t-n)),r},kt(H.prototype,function(n,t){var r=g[t],e=/^(?:first|last)$/.test(t);g.prototype[t]=function(){var t=this.__wrapped__,u=arguments,i=this.__chain__,o=!!this.__actions__.length,a=t instanceof H,f=a&&!o;if(e&&!i)return f?n.call(t):r.call(g,this.value());var c=function(n){var t=[n];return ro.apply(t,u),r.apply(g,t)};if(a||Mo(t)){var l=f?t:new H(this),s=n.apply(l,u);if(!e&&(o||s.actions)){var p=s.actions||(s.actions=[]);p.push({func:de,args:[c],thisArg:g})}return new G(s,i)}return this.thru(c)}}),Qn(["concat","join","pop","push","shift","sort","splice","unshift"],function(n){var t=Di[n],r=/^(?:push|sort|unshift)$/.test(n)?"tap":"thru",e=/^(?:join|pop|shift)$/.test(n);g.prototype[n]=function(){var n=arguments;return e&&!this.__chain__?t.apply(this.value(),n):this[r](function(r){return t.apply(r,n)})}}),H.prototype.clone=nn,H.prototype.reverse=Dn,H.prototype.value=zn,g.prototype.chain=ye,g.prototype.reverse=_e,g.prototype.toString=me,g.prototype.toJSON=g.prototype.valueOf=g.prototype.value=we,g.prototype.collect=g.prototype.map,g.prototype.head=g.prototype.first,g.prototype.select=g.prototype.filter,g.prototype.tail=g.prototype.rest,g}var x,A="3.1.0",j=1,E=2,R=4,I=8,k=16,O=32,C=64,T=128,S=256,N=30,U="...",W=150,F=16,L=0,$=1,B=2,D="Expected a function",z="__lodash_placeholder__",M="[object Arguments]",q="[object Array]",P="[object Boolean]",K="[object Date]",V="[object Error]",Y="[object Function]",G="[object Map]",J="[object Number]",X="[object Object]",Z="[object RegExp]",H="[object Set]",Q="[object String]",nn="[object WeakMap]",tn="[object ArrayBuffer]",rn="[object Float32Array]",en="[object Float64Array]",un="[object Int8Array]",on="[object Int16Array]",an="[object Int32Array]",fn="[object Uint8Array]",cn="[object Uint8ClampedArray]",ln="[object Uint16Array]",sn="[object Uint32Array]",pn=/\b__p \+= '';/g,hn=/\b(__p \+=) '' \+/g,vn=/(__e\(.*?\)|\b__t\)) \+\n'';/g,gn=/&(?:amp|lt|gt|quot|#39|#96);/g,dn=/[&<>"'` + "`" + `]/g,yn=RegExp(gn.source),_n=RegExp(dn.source),mn=/<%-([\s\S]+?)%>/g,wn=/<%([\s\S]+?)%>/g,bn=/<%=([\s\S]+?)%>/g,xn=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,An=/\w*$/,jn=/^\s*function[ \n\r\t]+\w/,En=/^0[xX]/,Rn=/^\[object .+?Constructor\]$/,In=/[\xc0-\xd6\xd8-\xde\xdf-\xf6\xf8-\xff]/g,kn=/($^)/,On=/[.*+?^${}()|[\]\/\\]/g,Cn=RegExp(On.source),Tn=/\bthis\b/,Sn=/['\n\r\u2028\u2029\\]/g,Nn=function(){var n="[A-Z\\xc0-\\xd6\\xd8-\\xde]",t="[a-z\\xdf-\\xf6\\xf8-\\xff]+";return RegExp(n+"{2,}(?="+n+t+")|"+n+"?"+t+"|"+n+"+|[0-9]+","g")}(),Un=" 	\f \ufeff\n\r\u2028\u2029 ᠎             　",Wn=["Array","ArrayBuffer","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Math","Number","Object","RegExp","Set","String","_","clearTimeout","document","isFinite","parseInt","setTimeout","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","window","WinRTError"],Fn=-1,Ln={};Ln[rn]=Ln[en]=Ln[un]=Ln[on]=Ln[an]=Ln[fn]=Ln[cn]=Ln[ln]=Ln[sn]=!0,Ln[M]=Ln[q]=Ln[tn]=Ln[P]=Ln[K]=Ln[V]=Ln[Y]=Ln[G]=Ln[J]=Ln[X]=Ln[Z]=Ln[H]=Ln[Q]=Ln[nn]=!1;var $n={};$n[M]=$n[q]=$n[tn]=$n[P]=$n[K]=$n[rn]=$n[en]=$n[un]=$n[on]=$n[an]=$n[J]=$n[X]=$n[Z]=$n[Q]=$n[fn]=$n[cn]=$n[ln]=$n[sn]=!0,$n[V]=$n[Y]=$n[G]=$n[H]=$n[nn]=!1;var Bn={leading:!1,maxWait:0,trailing:!1},Dn={"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss"},zn={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","` + "`" + `":"&#96;"},Mn={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'","&#96;":"` + "`" + `"},qn={"function":!0,object:!0},Pn={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},Kn=qn[typeof window]&&window!==(this&&this.window)?window:this,Vn=qn[typeof exports]&&exports&&!exports.nodeType&&exports,Yn=qn[typeof module]&&module&&!module.nodeType&&module,Gn=Vn&&Yn&&"object"==typeof global&&global;!Gn||Gn.global!==Gn&&Gn.window!==Gn&&Gn.self!==Gn||(Kn=Gn);var Jn=Yn&&Yn.exports===Vn&&Vn,Xn=b();"function"==typeof define&&"object"==typeof define.amd&&define.amd?define(function(){return Xn}):Vn&&Yn&&(Jn?(Yn.exports=Xn)._=Xn:Vn._=Xn),n.constant("lodash",Xn)}]);
!function(e,t){"use strict";var r=e.String;r.prototype.format||(r.prototype.format=function(){var e,r=this,n=function(e){return!isNaN(parseFloat(e))&&isFinite(e)},o=function(){var e=function(e){var r=function(e){return new Array(e)};switch(!0){case/^#\{(\w+)\}*$/.test(e):this.formatter=function(e,t){return e.replace("#{"+RegExp.$1+"}",t[RegExp.$1])};break;case/^([ds])$/.test(e):this.formatter=function(t,r){if("d"===RegExp.$1&&!n(r))throw new TypeError;return t.replace("%"+e,r)};break;case/^(o)$/.test(e):this.formatter=function(t,r){if(!n(r))throw new TypeError;return t.replace("%"+e,parseInt(r).toString(8))};break;case/^(b)$/.test(e):this.formatter=function(t,r){if(!n(r))throw new TypeError;return t.replace("%"+e,parseInt(r).toString(2))};break;case/^([xX])$/.test(e):this.formatter=function(t,r){if(!n(r))throw new TypeError;var o=parseInt(r).toString(16);return"X"===e&&(o=o.toUpperCase()),t.replace("%"+e,o)};break;case/^(c)$/.test(e):this.formatter=function(t,r){if(!n(r))throw new TypeError;return t.replace("%"+e,String.fromCharCode(r))};break;case/^(u)$/.test(e):this.formatter=function(t,r){if(!n(r))throw new TypeError;return t.replace("%"+e,parseInt(r,10)>>>0)};break;case/^(-?)(\d*).?(\d?)(e)$/.test(e):this.formatter=function(o,a){if(!n(a))throw new TypeError;var i,s,c,p="-"===RegExp.$1,f=RegExp.$2,l=""!==RegExp.$3?RegExp.$3:t,g=a.toExponential(l);return""!==f&&(l!==t?(c=f-g.length,c>=0&&(g=p?g+r(c+1).join(" "):r(c+1).join(" ")+g)):(i=g.split("e")[0],s="e"+g.split("e")[1],c=f-(i.length+s.length),g=c>=0?i+r(c+1).join("0")+s:i.slice(0,c)+s)),o.replace("%"+e,g)};break;case/^(-?)(\d*).?(\d?)(f)$/.test(e):this.formatter=function(t,o){if(!n(o))throw new TypeError;var a,i,s="-"===RegExp.$1,c=RegExp.$2,p=RegExp.$3,f=".".length,l=o>0?Math.floor(o):Math.ceil(o),g=parseFloat(o).toFixed(""!==p?p:6);return""!==c&&(""!==p?(a=l.toString().length+f+parseInt(p,10),i=c-a,g=s?parseFloat(o).toFixed(p)+r(i+1).join(" "):r(i+1).join(" ")+parseFloat(o).toFixed(p)):g=parseFloat(o).toFixed(c-(l.toString().length+f))),t.replace("%"+e,g)};break;case/^([0\-]?)(\d+)d$/.test(e):this.formatter=function(t,o){if(!n(o))throw new TypeError;var a=RegExp.$2-o.toString().length,i="";switch(0>a&&(a=0),RegExp.$1){case"":i=(r(a+1).join(" ")+o).slice(-RegExp.$2);break;case"-":i=(o+r(a+1).join(" ")).slice(-RegExp.$2);break;case"0":i=(r(a+1).join("0")+o).slice(-RegExp.$2)}return t.replace("%"+e,i)};break;case/^(-?)(\d)s$/.test(e):this.formatter=function(t,n){var o=RegExp.$2-n.toString().length,a="";switch(0>o&&(o=0),RegExp.$1){case"":a=(r(o+1).join(" ")+n).slice(-RegExp.$2);break;case"-":a=(n+r(o+1).join(" ")).slice(-RegExp.$2)}return t.replace("%"+e,a)};break;case/^(-?\d?)\.(\d)s$/.test(e):this.formatter=function(t,n){var o,a,i="";return""===RegExp.$1?i=n.slice(0,RegExp.$2):(n=n.slice(0,RegExp.$2),o=Math.abs(RegExp.$1),a=o-n.toString().length,i=-1!==RegExp.$1.indexOf("-")?(n+r(a+1).join(" ")).slice(-o):(r(a+1).join(" ")+n).slice(-o)),t.replace("%"+e,i)};break;default:this.formatter=function(e,t){return e}}};return e.prototype={format:function(e,t){return this.formatter.call(this,e,t)}},e}(),a=Array.prototype.slice.call(arguments);if(1===a.length&&"object"==typeof a[0])for(e=0;e<Object.keys(a[0]).length;e+=1)r.match(/(#\{\w+\})/)&&(r=new o(RegExp.$1).format(r,a[0]));else for(e=0;e<a.length;e+=1)r.match(/%([.#0-9\-]*[bcdefosuxX])/)&&(r=new o(RegExp.$1).format(r,a[e]));return r})}("undefined"!=typeof global?global:window);
!function(e){function n(){var e=arguments[0],r=n.cache;return r[e]&&r.hasOwnProperty(e)||(r[e]=n.parse(e)),n.format.call(null,r[e],arguments)}function r(e){return Object.prototype.toString.call(e).slice(8,-1).toLowerCase()}function t(e,n){return Array(n+1).join(e)}var i={not_string:/[^s]/,number:/[dief]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fiosuxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/};n.format=function(e,s){var a,o,l,f,c,p,u,d=1,g=e.length,h="",x=[],b=!0,y="";for(o=0;g>o;o++)if(h=r(e[o]),"string"===h)x[x.length]=e[o];else if("array"===h){if(f=e[o],f[2])for(a=s[d],l=0;l<f[2].length;l++){if(!a.hasOwnProperty(f[2][l]))throw new Error(n("[sprintf] property '%s' does not exist",f[2][l]));a=a[f[2][l]]}else a=f[1]?s[f[1]]:s[d++];if("function"==r(a)&&(a=a()),i.not_string.test(f[8])&&"number"!=r(a)&&isNaN(a))throw new TypeError(n("[sprintf] expecting number but found %s",r(a)));switch(i.number.test(f[8])&&(b=a>=0),f[8]){case"b":a=a.toString(2);break;case"c":a=String.fromCharCode(a);break;case"d":case"i":a=parseInt(a,10);break;case"e":a=f[7]?a.toExponential(f[7]):a.toExponential();break;case"f":a=f[7]?parseFloat(a).toFixed(f[7]):parseFloat(a);break;case"o":a=a.toString(8);break;case"s":a=(a=String(a))&&f[7]?a.substring(0,f[7]):a;break;case"u":a>>>=0;break;case"x":a=a.toString(16);break;case"X":a=a.toString(16).toUpperCase()}!i.number.test(f[8])||b&&!f[3]?y="":(y=b?"+":"-",a=a.toString().replace(i.sign,"")),p=f[4]?"0"===f[4]?"0":f[4].charAt(1):" ",u=f[6]-(y+a).length,c=f[6]&&u>0?t(p,u):"",x[x.length]=f[5]?y+a+c:"0"===p?y+c+a:c+y+a}return x.join("")},n.cache={},n.parse=function(e){for(var n=e,r=[],t=[],s=0;n;){if(null!==(r=i.text.exec(n)))t[t.length]=r[0];else if(null!==(r=i.modulo.exec(n)))t[t.length]="%";else{if(null===(r=i.placeholder.exec(n)))throw new SyntaxError("[sprintf] unexpected placeholder");if(r[2]){s|=1;var a=[],o=r[2],l=[];if(null===(l=i.key.exec(o)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(a[a.length]=l[1];""!==(o=o.substring(l[0].length));)if(null!==(l=i.key_access.exec(o)))a[a.length]=l[1];else{if(null===(l=i.index_access.exec(o)))throw new SyntaxError("[sprintf] failed to parse named argument key");a[a.length]=l[1]}r[2]=a}else s|=2;if(3===s)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");t[t.length]=r}n=n.substring(r[0].length)}return t};var s=function(e,r,t){return t=(r||[]).slice(0),t.splice(0,0,e),n.apply(null,t)};"undefined"!=typeof exports?(exports.sprintf=n,exports.vsprintf=s):(e.sprintf=n,e.vsprintf=s,"function"==typeof define&&define.amd&&define(function(){return{sprintf:n,vsprintf:s}}))}("undefined"==typeof window?this:window);
!function(require){"use strict";function push(t,e){return t=t.slice(),t.push(e),t}function unshift(t,e){return e=e.slice(),e.unshift(t),e}function JSONPath(t,e,r){return this instanceof JSONPath?(t=t||{},this.resultType=t.resultType&&t.resultType.toLowerCase()||"value",this.flatten=t.flatten||!1,this.wrap=t.hasOwnProperty("wrap")?t.wrap:!0,this.sandbox=t.sandbox||{},t.autostart!==!1?this.evaluate(e||t.json,r||t.path):void 0):new JSONPath(t,e,r)}Array.isArray||(Array.isArray=function(t){return"[object Array]"===Object.prototype.toString.call(t)});var isNode="undefined"!=typeof module&&!!module.exports,vm=isNode?require("vm"):{runInNewContext:function(expr,context){return eval(Object.keys(context).reduce(function(t,e){return"var "+e+"="+JSON.stringify(context[e])+";"+t},expr))}},cache={};JSONPath.prototype.evaluate=function(t,e){var r=this;if(this.obj=t,e&&t&&("value"===this.resultType||"path"===this.resultType)){var n=this._normalize(e);"$"===n[0]&&n.length>1&&n.shift();var a=this._trace(n,t,["$"]);return a=a.filter(function(t){return t&&!t.isParentSelector}),a.length?1!==a.length||this.wrap||Array.isArray(a[0].value)?a.reduce(function(t,e){var n=e[r.resultType];return"path"===r.resultType&&(n=r._asPath(n)),r.flatten&&Array.isArray(n)?t=t.concat(n):t.push(n),t},[]):a[0][this.resultType]||!1:this.wrap?[]:!1}},JSONPath.prototype._normalize=function(t){if(cache[t])return cache[t];var e=[],r=t.replace(/[\['](\??\(.*?\))[\]']/g,function(t,r){return"[#"+(e.push(r)-1)+"]"}).replace(/'?\.'?|\['?/g,";").replace(/(?:;)?(\^+)(?:;)?/g,function(t,e){return";"+e.split("").join(";")+";"}).replace(/;;;|;;/g,";..;").replace(/;$|'?\]|'$/g,""),n=r.split(";").map(function(t){var r=t.match(/#([0-9]+)/);return r&&r[1]?e[r[1]]:t});return cache[t]=n,cache[t]},JSONPath.prototype._asPath=function(t){var e,r,n=t,a="$";for(e=1,r=n.length;r>e;e++)a+=/^[0-9*]+$/.test(n[e])?"["+n[e]+"]":"['"+n[e]+"']";return a},JSONPath.prototype._trace=function(t,e,r){function n(t){o=o.concat(t)}var a=this;if(!t.length)return[{path:r,value:e}];var i=t[0],s=t.slice(1);if("^"===i)return r.length?[{path:r.slice(0,-1),expr:s,isParentSelector:!0}]:[];var o=[];if(e&&e.hasOwnProperty(i))n(this._trace(s,e[i],push(r,i)));else if("*"===i)this._walk(i,s,e,r,function(t,e,r,i,s){n(a._trace(unshift(t,r),i,s))});else if(".."===i)n(this._trace(s,e,r)),this._walk(i,s,e,r,function(t,e,r,i,s){"object"==typeof i[t]&&n(a._trace(unshift("..",r),i[t],push(s,t)))});else if("("===i[0])n(this._trace(unshift(this._eval(i,e,r[r.length],r),s),e,r));else if(0===i.indexOf("?("))this._walk(i,s,e,r,function(t,e,i,s,o){a._eval(e.replace(/^\?\((.*?)\)$/,"$1"),s[t],t,r)&&n(a._trace(unshift(t,i),s,o))});else if(i.indexOf(",")>-1){var h,u;for(h=i.split(","),u=0;u<h.length;u++)n(this._trace(unshift(h[u],s),e,r))}else/^(-?[0-9]*):(-?[0-9]*):?([0-9]*)$/.test(i)&&n(this._slice(i,s,e,r));return o.reduce(function(t,r){return t.concat(r.isParentSelector?a._trace(r.expr,e,r.path):[r])},[])},JSONPath.prototype._walk=function(t,e,r,n,a){var i,s,o;if(Array.isArray(r))for(i=0,s=r.length;s>i;i++)a(i,t,e,r,n);else if("object"==typeof r)for(o in r)r.hasOwnProperty(o)&&a(o,t,e,r,n)},JSONPath.prototype._slice=function(t,e,r,n){if(Array.isArray(r)){var a,i=r.length,s=t.split(":"),o=s[0]&&parseInt(s[0],10)||0,h=s[1]&&parseInt(s[1],10)||i,u=s[2]&&parseInt(s[2],10)||1;o=0>o?Math.max(0,o+i):Math.min(i,o),h=0>h?Math.max(0,h+i):Math.min(i,h);var c=[];for(a=o;h>a;a+=u)c=c.concat(this._trace(unshift(a,e),r,n));return c}},JSONPath.prototype._eval=function(t,e,r,n){if(!this.obj||!e)return!1;t.indexOf("@path")>-1&&(this.sandbox._path=this._asPath(n.concat([r])),t=t.replace(/@path/g,"_path")),t.indexOf("@")>-1&&(this.sandbox._v=e,t=t.replace(/@/g,"_v"));try{return vm.runInNewContext(t,this.sandbox)}catch(a){throw console.log(a),new Error("jsonPath: "+a.message+": "+t)}},JSONPath.eval=function(t,e,r){return new JSONPath(r,t,e)},"undefined"==typeof module?(window.jsonPath={eval:JSONPath.eval},window.JSONPath=JSONPath):module.exports=JSONPath}("undefined"==typeof require?null:require);`)

func www_app_assets_js_base_js_bytes() ([]byte, error) {
	return _www_app_assets_js_base_js, nil
}

func www_app_assets_js_base_js() (*asset, error) {
	bytes, err := www_app_assets_js_base_js_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/assets/js/base.js", size: 477058, mode: os.FileMode(436), modTime: time.Unix(1431747252, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_img_icons_ic_arrow_drop_down_18px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M5 8l4 4 4-4z"/></svg>`)

func www_app_components_dashboard_img_icons_ic_arrow_drop_down_18px_svg_bytes() ([]byte, error) {
	return _www_app_components_dashboard_img_icons_ic_arrow_drop_down_18px_svg, nil
}

func www_app_components_dashboard_img_icons_ic_arrow_drop_down_18px_svg() (*asset, error) {
	bytes, err := www_app_components_dashboard_img_icons_ic_arrow_drop_down_18px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/img/icons/ic_arrow_drop_down_18px.svg", size: 114, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_img_icons_ic_arrow_drop_down_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
    <path d="M7 10l5 5 5-5z"/>
    <path d="M0 0h24v24h-24z" fill="none"/>
</svg>
`)

func www_app_components_dashboard_img_icons_ic_arrow_drop_down_24px_svg_bytes() ([]byte, error) {
	return _www_app_components_dashboard_img_icons_ic_arrow_drop_down_24px_svg, nil
}

func www_app_components_dashboard_img_icons_ic_arrow_drop_down_24px_svg() (*asset, error) {
	bytes, err := www_app_components_dashboard_img_icons_ic_arrow_drop_down_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/img/icons/ic_arrow_drop_down_24px.svg", size: 166, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_img_icons_ic_close_18px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z"/></svg>`)

func www_app_components_dashboard_img_icons_ic_close_18px_svg_bytes() ([]byte, error) {
	return _www_app_components_dashboard_img_icons_ic_close_18px_svg, nil
}

func www_app_components_dashboard_img_icons_ic_close_18px_svg() (*asset, error) {
	bytes, err := www_app_components_dashboard_img_icons_ic_close_18px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/img/icons/ic_close_18px.svg", size: 215, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_img_icons_ic_close_24px_svg = []byte(`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/></svg>`)

func www_app_components_dashboard_img_icons_ic_close_24px_svg_bytes() ([]byte, error) {
	return _www_app_components_dashboard_img_icons_ic_close_24px_svg, nil
}

func www_app_components_dashboard_img_icons_ic_close_24px_svg() (*asset, error) {
	bytes, err := www_app_components_dashboard_img_icons_ic_close_24px_svg_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/img/icons/ic_close_24px.svg", size: 202, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_manifest_json = []byte(`{
  "description": "The basic Kubernetes UI dashboard... ",
  "routes": [
    {
      "description": "Dashboard visualization.",
      "url": "/",
      "templateUrl": "components/dashboard/pages/home.html"
    },
    {
      "description": "Pods",
      "url": "/pods",
      "templateUrl": "components/dashboard/views/listPods.html"
    },
    {
      "description": "Pod Visualizer",
      "url": "/visualpods",
      "templateUrl": "components/dashboard/views/listPodsVisualizer.html"
    },
    {
      "description": "Services",
      "url": "/services",
      "templateUrl": "components/dashboard/views/listServices.html"
    },
    {
      "description": "Replication Controllers",
      "url": "/replicationcontrollers",
      "templateUrl": "components/dashboard/views/listReplicationControllers.html"
    },
    {
      "description": "Events",
      "url": "/events",
      "templateUrl": "components/dashboard/views/listEvents.html"
    },
    {
      "description": "Nodes",
      "url": "/nodes",
      "templateUrl": "components/dashboard/views/listMinions.html"
    },
    {
      "description": "Replication Controller",
      "url": "/replicationcontrollers/:replicationControllerId",
      "templateUrl": "components/dashboard/views/replication.html"
    },
    {
      "description": "Service",
      "url": "/services/:serviceId",
      "templateUrl": "components/dashboard/views/service.html"
    },
    {
      "description": "Node",
      "url": "/nodes/:nodeId",
      "templateUrl": "components/dashboard/views/node.html"
    },
    {
      "description": "Explore",
      "url": "/groups/:grouping*?/selector/:selector*?",
      "templateUrl": "components/dashboard/views/groups.html"
    },
    {
      "description": "Pod",
      "url": "/pods/:podId",
      "templateUrl": "components/dashboard/views/pod.html"
    }
  ]
}
`)

func www_app_components_dashboard_manifest_json_bytes() ([]byte, error) {
	return _www_app_components_dashboard_manifest_json, nil
}

func www_app_components_dashboard_manifest_json() (*asset, error) {
	bytes, err := www_app_components_dashboard_manifest_json_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/manifest.json", size: 1854, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_pages_footer_html = []byte(`<p></p>`)

func www_app_components_dashboard_pages_footer_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_pages_footer_html, nil
}

func www_app_components_dashboard_pages_footer_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_pages_footer_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/pages/footer.html", size: 7, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_pages_header_html = []byte(`<div layout-fill>
<md-toolbar md-scroll-shrink class="dashboard-subnav">
   <div class="md-toolbar-tools">
      <div layout="row" flex class="fill-height">
         <div class="md-toolbar-item md-breadcrumb"></div>
         <span ng-if="menu.currentPage.name !== menu.currentSection.name">
         <span hide-sm hide-md><a href="#{{menu.currentSection.url}}">{{menu.currentSection.name}}</a></span>
         <span class="menu-separator-icon" style="padding: 0 10px;" hide-sm hide-md>
         <img style="height: 12px;" src="assets/img/docArrow.png" alt="" aria-hidden="true">
         </span>
         </span>
         <span style="display: inline-block;">{{(menu.currentPage | humanizeDoc) || 'Kubernetes' }}</span>
         <span flex></span>
         <div class="md-toolbar-item md-tools" layout="row">
            <div layout="column" class="selectSubPages">
               <md-select ng-model="page" placeholder="Views" class="selectTitle">
                  <md-optgroup label="Dashboard">
                  <md-option id="{{subpage.id}}" ng-value="subpage.value" ng-repeat="subpage in subpages | filter: {category: 'dashboard' }">{{subpage.name}}</md-option>
                  </md-option-group>
               </md-select>
            </div>
         </div>
      </div>
   </div>
</md-toolbar>
</div>
`)

func www_app_components_dashboard_pages_header_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_pages_header_html, nil
}

func www_app_components_dashboard_pages_header_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_pages_header_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/pages/header.html", size: 1313, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_pages_home_html = []byte(`<div dashboard-header></div>
<div class="dashboard" ng-controller="DashboardCtrl" layout-fill>
  <md-content>
    <div ng-include="'components/dashboard/views/partials/cadvisor.html'">&gt;</div>
  </md-content>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_pages_home_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_pages_home_html, nil
}

func www_app_components_dashboard_pages_home_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_pages_home_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/pages/home.html", size: 247, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_protractor_smoke_spec_js = []byte(`describe("Kubernetes UI Dashboard",function(){it("should have all the expected components loaded",function(){browser.get("http://localhost:8000"),expect(browser.getTitle()).toEqual("Kubernetes UI");var e=element(by.id("tab_001"));expect(e).toBeDefined(),e.click(),expect(browser.getLocationAbsUrl()).toBe("/dashboard/");var t=element(by.model("page"));expect(t).toBeDefined()}),it("should have the subnav view",function(){browser.get("http://localhost:8000/"),expect(by.css(".dashboard-subnav")).toBeDefined();var e=element(by.css(".selectSubPages"));expect(e).toBeDefined(),e.click();var t=element(by.model("page"));expect(t).toBeDefined(),e.click(),t.click(),expect(element(by.id("groupsView"))).toBeDefined(),expect(element(by.id("podsView"))).toBeDefined(),expect(element(by.id("minionsView"))).toBeDefined(),expect(element(by.id("rcView"))).toBeDefined(),expect(element(by.id("servicesView"))).toBeDefined(),expect(element(by.id("eventsView"))).toBeDefined(),expect(element(by.id("cAdvisorView"))).toBeDefined()}),it("should have the cAdvisor view by default",function(){browser.get("http://localhost:8000/"),expect(browser.getTitle()).toEqual("Kubernetes UI"),expect(element.all(by.css(".dashboard")).count()).toBeGreaterThan(0),expect(element.all(by.css(".server-overview")).count()).toEqual(1),expect(element(by.repeater("minion in minions.items"))).toBeDefined();var e=element(by.css("svg"));expect(e).toBeDefined()}),it("should have the correct subviews",function(){browser.get("http://localhost:8000/");for(var e=["podsView","minionsView","rcView","servicesView","eventsView"],t=0;t<e.length;t++){var o=e[t],i=element(by.model("page"));i.click();var n=element(by.id(o));expect(n).toBeDefined(),n.click(),expect(browser.getTitle()).toEqual("Kubernetes UI"),expect(by.css(".dashboard-subnav")).toBeDefined(),expect(element(by.css(".selectSubPages"))).toBeDefined();var c=element(by.model("page"));expect(c).toBeDefined(),expect(element.all(by.css(".list-pods")).count()).toEqual(1),expect(element(by.repeater("h in headers"))).toBeDefined()}}),it("should have the correct groups view",function(){browser.get("http://localhost:8000/");var e=element(by.model("page"));e.click();var t=element(by.id("groupsView"));expect(t).toBeDefined(),t.click(),expect(browser.getTitle()).toEqual("Kubernetes UI"),expect(by.css(".dashboard-subnav")).toBeDefined(),expect(element(by.css(".selectSubPages"))).toBeDefined();var o=element(by.model("page"));expect(o).toBeDefined();var e=element(by.model("selectedGroupBy"));expect(e).toBeDefined(),e.click(),expect(element(by.repeater("g in groupByOptions"))).toBeDefined()})});`)

func www_app_components_dashboard_protractor_smoke_spec_js_bytes() ([]byte, error) {
	return _www_app_components_dashboard_protractor_smoke_spec_js, nil
}

func www_app_components_dashboard_protractor_smoke_spec_js() (*asset, error) {
	bytes, err := www_app_components_dashboard_protractor_smoke_spec_js_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/protractor/smoke.spec.js", size: 2616, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_test_controllers_header_spec_js = []byte(`"use strict";describe("header controller",function(){beforeEach(module("kubernetesApp.components.dashboard")),beforeEach(inject(function(e,t,o){this.rootScope=e,this.scope=e.$new(),this.location=t,spyOn(this.location,"path"),this.controller=o,this.ctrl=this.controller("HeaderCtrl",{$scope:this.scope}),this.scope.$apply()})),describe("subPages",function(){it("is defined",function(){expect(this.scope.subPages).not.toBeUndefined()}),it("is an array",function(){expect(Array.isArray(this.scope.subPages)).toBeTruthy()}),it("is not empty",function(){expect(this.scope.subPages.length).toBeGreaterThan(0)}),describe("each subPage",function(){it("has a category",function(){this.scope.subPages.forEach(function(e){expect(e.category).toBeTruthy()})}),it("has a name",function(){this.scope.subPages.forEach(function(e){expect(e.name).toBeTruthy()})}),it("has a value",function(){this.scope.subPages.forEach(function(e){expect(e.value).toBeTruthy()})})})}),describe("Pages",function(){it("does not change location on first detected change",function(){expect(this.location.path).not.toHaveBeenCalled()}),it("changes location on second detected change",function(){var e=this;this.scope.$apply(function(){e.scope.Pages="test_Pages"}),expect(this.location.path).toHaveBeenCalledWith("test_Pages")})})});`)

func www_app_components_dashboard_test_controllers_header_spec_js_bytes() ([]byte, error) {
	return _www_app_components_dashboard_test_controllers_header_spec_js, nil
}

func www_app_components_dashboard_test_controllers_header_spec_js() (*asset, error) {
	bytes, err := www_app_components_dashboard_test_controllers_header_spec_js_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/test/controllers/header.spec.js", size: 1293, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_groups_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="GroupCtrl" layout="column" class="body-wrapper groups">
    <md-content>
      <!-- page header -->
      <div class="header" layout="row">
          <div class="">Group by: </div>

          <md-select placeholder="{{routeParams.grouping}}" class="select-group-by" ng-model="selectedGroupBy" ng-change="changeGroupBy()">
              <md-option ng-value="g.value" ng-repeat="g in groupByOptions">{{g.name}}</md-option>
          </md-select>

          <div ng-if="selector" layout="row" class="selector-area">
            <div class="filter-label">Filter:</div>

            <div class="filter-text">{{selector}}</div>
            <div class="filter-area" ng-if="selector && selector.length > 0">

              <button ng-click="clearSelector(routeParams.grouping)" class="md-button cancel-button">

                <md-icon md-svg-src="components/dashboard/img/icons/ic_close_18px.svg" class="cancel-icon" alt="Cancel"></md-icon>

              </button>

            </div>

          </div>

      </div>
      <div class="group-item" ng-repeat="(groupName,group) in groups.items" ng-include="'components/dashboard/views/partials/groupBox.html'"></div>
    </md-content>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_groups_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_groups_html, nil
}

func www_app_components_dashboard_views_groups_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_groups_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/groups.html", size: 1298, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listevents_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListEventsCtrl" style="padding:25px;" class="list-pods">
  <md-table headers="headers" content="content" sortable="sortable" filters="search" custom-class="custom" thumbs="thumbs" count="count"></md-table>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listevents_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listevents_html, nil
}

func www_app_components_dashboard_views_listevents_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listevents_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listEvents.html", size: 326, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listminions_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListMinionsCtrl" style="padding:25px;" class="list-pods">
  <md-table headers="headers" content="content" sortable="sortable" filters="search" custom-class="custom" thumbs="thumbs" count="count" on-select="go(data)"></md-table>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listminions_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listminions_html, nil
}

func www_app_components_dashboard_views_listminions_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listminions_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listMinions.html", size: 348, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listpods_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListPodsCtrl" style="padding:25px;" class="list-pods">
  <md-table headers="headers" content="content" sortable="sortable" filters="search" custom-class="custom" thumbs="thumbs" count="count" on-select="go(data)"></md-table>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listpods_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listpods_html, nil
}

func www_app_components_dashboard_views_listpods_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listpods_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listPods.html", size: 345, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listpodscards_html = []byte(`<div class="dashboard">
  <div ng-controller="ListPodsCtrl" style="padding:25px;" class="list-pods">

    <md-whiteframe layout-margin class="md-whiteframe-z2">
    <md-toolbar class="">
      <div class="md-toolbar-tools">
        Pods
      </div>
    </md-toolbar>
    <md-content>


        <div class="pod-group">
          <md-grid-list md-cols="6" md-row-height="1:1.5" md-gutter="8px" ng-repeat="(podName, groupPods) in groupedPods">
            <md-grid-tile md-rowspan="1" md-colspan="2" class="gray">
              <md-grid-tile-footer>
                <div class="pod-title"><h2>{{podName}}</h2></div>
              </md-grid-tile-footer>
            </md-grid-tile>

            <md-grid-tile class="purple" md-rowspan="1" md-colspan="1" ng-repeat="pod in groupPods" >
              <div>

                <div>
                  Containers:
                  <span ng-repeat="container in pod.desiredState.manifest.containers">
                    {{container.name}}
                  </span>
                </div>
                <div>
                  Images:
                  <span ng-repeat="container in pod.desiredState.manifest.containers">
                    {{container.image}}
                  </span>
                </div>
                <div>Internal IP: {{pod.currentState.podIP}}</div>
                <div>
                Labels:
                  <span ng-repeat="(label, value) in pod.labels">{{label}}={{value}}<span ng-show="!$last">, </span></span>
                </div>
                <div>Status: {{pod.currentState.status}}</div>
              </div>
              <md-grid-tile-footer>

                <div class="pod-host">{{pod.currentState.host}}</div>
                <div><a ng-href="#/dashboard/pods/{{ pod.id }}"><h3>{{ pod.id }}</h3></a></div>

              </md-grid-tile-footer>
            </md-grid-tile>

          </md-grid-list>
        </div>


    </md-content>
    </md-whiteframe>

  </div>
</div>
`)

func www_app_components_dashboard_views_listpodscards_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listpodscards_html, nil
}

func www_app_components_dashboard_views_listpodscards_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listpodscards_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listPodsCards.html", size: 1967, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listpodsvisualizer_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListPodsCtrl" style="padding:25px;" class="list-pods">
    <md-whiteframe layout-margin class="md-whiteframe-z2">
    <md-content>
<div>
<md-button class="md-primary" ng-click="serverView = false">By Name</md-button> |
<md-button class="md-primary" ng-click="serverView = true">By Server</md-button>
  <div style="float:right;"><md-button class="md-primary" ng-href="#/dashboard/pods">View Pod Listing</md-button></div>
</div>
    <div class="pod-group" ng-show="!serverView" ng-include="'components/dashboard/views/partials/podTilesByName.html'"></div>
    <div class="pod-group" ng-show="serverView" ng-include="'components/dashboard/views/partials/podTilesByServer.html'"></div>
    </md-content>
    </md-whiteframe>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listpodsvisualizer_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listpodsvisualizer_html, nil
}

func www_app_components_dashboard_views_listpodsvisualizer_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listpodsvisualizer_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listPodsVisualizer.html", size: 841, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listreplicationcontrollers_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListReplicationControllersCtrl" style="padding:25px;" class="list-pods">
  <md-table headers="headers" content="content" sortable="sortable" filters="search" custom-class="custom" thumbs="thumbs" count="count" on-select="go(data)"></md-table>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listreplicationcontrollers_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listreplicationcontrollers_html, nil
}

func www_app_components_dashboard_views_listreplicationcontrollers_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listreplicationcontrollers_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listReplicationControllers.html", size: 363, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_listservices_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ListServicesCtrl" style="padding:25px;" class="list-pods">
  <md-table headers="headers" content="content" sortable="sortable" filters="search" custom-class="custom" thumbs="thumbs" count="count" on-select="go(data)"></md-table>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_listservices_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_listservices_html, nil
}

func www_app_components_dashboard_views_listservices_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_listservices_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/listServices.html", size: 349, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_node_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="NodeCtrl" layout="column" class="body-wrapper node">
    <div class="detail">

      <div class="back">
        <md-button class="md-default-theme" ng-click="doTheBack()">‹ BACK</md-button>
      </div>


      <div class="heading">
        <span class="label">Name:</span>
        <span>{{node.id}}</span>
      </div>


      <table>
        <tbody>
          <tr>
            <td class="name">Labels</td>
            <td class="value">
              <div ng-repeat="(label, value) in node.labels">
                {{label}}: {{value}}
              </div>
            </td>
          </tr>

          <tr>
            <td class="name">Created</td>
            <td class="value">
              {{node.creationTimestamp | date:'medium'}}
            </td>
          </tr>

          <tr>
            <td class="name">Host IP</td>
            <td class="value">
              {{node.hostIP}}
            </td>
          </tr>

          <tr>
            <td class="name">System Info</td>
            <td class="value">
              <div ng-repeat="(label, value) in node.status.nodeInfo">
                {{label}}: {{value}}
              </div>
            </td>
          </tr>


        </tbody>
      </table>



    </div>
  </div>
</div>
<div dashboard-footer></div>

`)

func www_app_components_dashboard_views_node_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_node_html, nil
}

func www_app_components_dashboard_views_node_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_node_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/node.html", size: 1353, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_partials_cadvisor_html = []byte(`<div class="dashboard" ng-controller="cAdvisorController">
  <div class="server-overview">
    <md-content layout="row" layout-wrap>
      <div flex-sm="100" flex-md="50" flex-lg="33" flex-gt-lg="25" class="chart_area" ng-repeat="minion in minions.items">
        <d3-minion-bar-gauge data="activeMinionDataById[minion.id]" class="concentric" graph-width="325" graph-height="325" thickness=18 />
      </div>
    </md-content>
  </div>
</div>
`)

func www_app_components_dashboard_views_partials_cadvisor_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_partials_cadvisor_html, nil
}

func www_app_components_dashboard_views_partials_cadvisor_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_partials_cadvisor_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/partials/cadvisor.html", size: 443, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_partials_groupbox_html = []byte(`<div>
  <md-content>
    <div class="server-overview" layout="column">
      <!-- subheader -->
      <div class="group-heading" layout="row">
        <div class="label">{{routeParams.grouping | ucfirst}}: <span class="bold">{{ (groupName) || "blank"  }}</span></div>
      </div>
      <!-- render group data -->
      <div ng-include="'components/dashboard/views/partials/groupItem.html'"></div>
      <div class="footer">
        <!-- Alternate box inside a box -->
        <div ng-if="group.kind == 'grouping'">
          {{group.kind}}
          <div ng-repeat="(groupName,group) in group.items" ng-include="'components/dashboard/views/partials/groupBox.html'"></div>
        </div>
        <md-divider></md-divider>
      </div>
    </div>
  </md-content>
</div>
`)

func www_app_components_dashboard_views_partials_groupbox_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_partials_groupbox_html, nil
}

func www_app_components_dashboard_views_partials_groupbox_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_partials_groupbox_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/partials/groupBox.html", size: 769, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_partials_groupitem_html = []byte(`<div layout="row" ng-if="group.kind != 'grouping'">
  <div>
    <!-- Default box display -->
      <div layout="row" class="group-item" ng-repeat="(groupType, data) in group | groupBy: 'labels.type'">
        <!-- left image -->
        <div class="icon-area">
          <div class="group-icon" style="background-color: {{getGroupColor(groupType)}}"></div>
        </div>
        <!-- right area -->
        <div class="group-main-area" layout="column">
          <!-- type -->
          <div class="subtype">
            {{groupType | ucfirst}}s
          </div>
          <!-- links -->
          <div layout="row" layout-wrap>
            <div layout="row" ng-repeat="item in data">
              <!-- title -->
              <div ng-switch on='item.labels["type"]'>
                <div class="group-name">
                  <a ng-switch-when='pod' ng-href="#/dashboard/pods/{{ item.id }}">{{ item.id }}</a>
                  <a ng-switch-when='service' ng-href="#/dashboard/services/{{ item.id }}">{{ item.id }}</a>
                  <a ng-switch-when='replicationController' ng-href="#/dashboard/replicationcontrollers/{{ item.id }}">{{ item.id }}</a>
                  <div ng-switch-default>{{item.id}}</div>
                </div>
              </div>
              <md-select ng-model="selectedFilter" ng-change="changeFilterBy(selectedFilter)" class="selectFilter">
                <md-optgroup label="FILTER">
                  <md-option ng-value="'{{key}}={{value}}'" ng-repeat="(key, value) in item.labels">{{key}}: {{value}}</md-option>
                  </md-option-group>
                </md-optgroup>
              </md-select>
              <!-- This is the official button design, but requires a custom dialog. Fix up after the demo. -->
              <!-- <md-button ng-click="" class="filter-button" style="padding:0">
                <md-icon md-svg-src="components/dashboard/img/icons/ic_arrow_drop_down_18px.svg" class="filter-icon" aria-label="" alt="Filter"></md-icon>
              </md-button> -->
            </div>
          </div>
        </div>
      </div>
  </div>
</div>
`)

func www_app_components_dashboard_views_partials_groupitem_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_partials_groupitem_html, nil
}

func www_app_components_dashboard_views_partials_groupitem_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_partials_groupitem_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/partials/groupItem.html", size: 2109, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_partials_podtilesbyname_html = []byte(`
<md-grid-list class="list-color-{{$index + 1}}" md-cols="6" md-row-height="1:1" md-gutter="8px" ng-repeat="(podName, groupPods) in podsByName">
  <md-grid-tile md-rowspan="2" md-colspan="2" class="colored">
    <md-grid-tile-footer>
      <div class="pod-title"><h2>{{podName}} overview</h2></div>
    </md-grid-tile-footer>
  </md-grid-tile>

  <md-grid-tile class="colored {{podStatusClass(pod)}}" md-rowspan="1" md-colspan="1" ng-repeat="pod in groupPods" >
    <md-grid-tile-header class="clear-bg">

      <div layout="row">
        <div class="labels"><span ng-repeat="(label, value) in otherLabels(pod.labels)">{{label}}: {{value}}<span ng-show="!$last">, </span></span></div>

        <div flex="20" class="restarts" ng-show="getPodRestarts(pod) > 0">
          <md-button class="md-fab restart-button">
              {{getPodRestarts(pod)}}
          </md-button>
        </div>
      </div>

    </md-grid-tile-header>
    <div class="inner-box">

      <div ng-show="podStatusClass(pod)">Status: {{pod.currentState.status}}</div>
    </div>
    <md-grid-tile-footer>

      <div class="pod-host">{{pod.currentState.host}}</div>
      <div><a ng-href="#/dashboard/pods/{{ pod.id }}"><h3>{{ pod.id }}</h3></a></div>

    </md-grid-tile-footer>
  </md-grid-tile>
</md-grid-list>`)

func www_app_components_dashboard_views_partials_podtilesbyname_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_partials_podtilesbyname_html, nil
}

func www_app_components_dashboard_views_partials_podtilesbyname_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_partials_podtilesbyname_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/partials/podTilesByName.html", size: 1287, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_partials_podtilesbyserver_html = []byte(`<md-grid-list class="" md-cols="6" md-row-height="1:1" md-gutter="8px" ng-repeat="(serverIp, groupPods) in podsByServer">
  <md-grid-tile md-rowspan="2" md-colspan="2" class="gray">
    <md-grid-tile-footer>
      <div class="pod-title"><h2>{{serverIp}} overview</h2></div>
    </md-grid-tile-footer>
  </md-grid-tile>

  <md-grid-tile class="color-{{podIndexFromName(pod)}} {{podStatusClass(pod)}}" md-rowspan="1" md-colspan="1" ng-repeat="pod in groupPods" >
    <md-grid-tile-header class="clear-bg">

      <div layout="row">
        <div class="labels"><span ng-repeat="(label, value) in otherLabels(pod.labels)">{{label}}: {{value}}<span ng-show="!$last">, </span></span></div>

        <div flex="20" class="restarts" ng-show="getPodRestarts(pod) > 0">
          <md-button class="md-fab restart-button">
              {{getPodRestarts(pod)}}
          </md-button>
        </div>
      </div>

    </md-grid-tile-header>
    <div class="inner-box">

      <div ng-show="podStatusClass(pod)">Status: {{pod.currentState.status}}</div>
    </div>
    <md-grid-tile-footer>

      <div class="pod-host">{{pod.labels.name}}</div>
      <div><a ng-href="#/dashboard/pods/{{ pod.id }}"><h3>{{ pod.id }}</h3></a></div>

    </md-grid-tile-footer>
  </md-grid-tile>

</md-grid-list>`)

func www_app_components_dashboard_views_partials_podtilesbyserver_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_partials_podtilesbyserver_html, nil
}

func www_app_components_dashboard_views_partials_podtilesbyserver_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_partials_podtilesbyserver_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/partials/podTilesByServer.html", size: 1281, mode: os.FileMode(436), modTime: time.Unix(1431747253, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_pod_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="PodCtrl" layout="column" class="body-wrapper pod">
    <div class="detail">

      <div class="back">
        <md-button class="md-default-theme" ng-click="doTheBack()">‹ BACK</md-button>
      </div>

      <div class="heading">
        <span class="label">Pod:</span>
        <span>{{pod.id}}</span>
      </div>


      <table>
        <tbody>
          <tr>
            <td class="name">Status</td>
            <td class="value">
              {{pod.currentState.status}} on <a ng-href="#/dashboard/groups/host/selector/host={{pod.currentState.host}}">{{pod.currentState.host}}</a>
            </td>
          </tr>

          <tr>
            <td class="name">Created</td>
            <td class="value">
              {{pod.creationTimestamp | date:'medium'}}
            </td>
          </tr>

          <tr>
            <td class="name">Pod Networking</td>
            <td class="value">
              {{pod.currentState.podIP}}
              <span ng-repeat="container in pod.desiredState.manifest.containers">
                    <span ng-repeat="port in container.ports">
                     : {{port.containerPort}}
                   </span>
              </span>
            </td>
          </tr>

          <tr>
            <td class="name">Host Networking</td>
            <td class="value">
              {{pod.currentState.hostIP}}
              <span ng-repeat="container in pod.desiredState.manifest.containers">
                  <span ng-repeat="port in container.ports">
                    :{{port.hostPort}}
                  </span>
              </span>
            </td>
          </tr>

          <tr>
            <td class="name">Labels</td>
            <td class="value">
              <div ng-repeat="(label, value) in pod.labels">
                {{label}}: {{value}}
              </div>
            </td>
          </tr>

          <tr>
            <td class="name">Containers</td>
            <td class="value">

              <table class="containerTable">
                <tr>
                  <td>Name</td>
                  <td>Image</td>
                  <td>Restarts</td>
                </tr>
                <tr ng-repeat="container in pod.desiredState.manifest.containers">
                  <td>{{container.name}}</td>
                  <td>{{container.image}}</td>
                  <td>{{pod.currentState.info[container.name].restartCount}}</td>
                </tr>
              </table>

            </td>
          </tr>


        </tbody>
      </table>



    </div>
  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_pod_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_pod_html, nil
}

func www_app_components_dashboard_views_pod_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_pod_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/pod.html", size: 2646, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_replication_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
<div ng-controller="ReplicationControllerCtrl" layout="column" class="body-wrapper">

  <div class="detail">

      <div class="back">
        <md-button class="md-default-theme" ng-click="doTheBack()">‹ BACK</md-button>
      </div>

      <div class="heading">
        <span class="label">Replication Controller: </span>
        <span>{{replicationController.id}}</span>
      </div>


      <table>
        <tbody>
          <tr>
            <td class="name">Created</td>
            <td class="value">
              {{replicationController.creationTimestamp | date:'medium'}}
            </td>
          </tr>

          <tr>
            <td class="name">Desired Replicas</td>
            <td class="value">
              {{replicationController.desiredState.replicas}}
            </td>
          </tr>

          <tr>
            <td class="name">Current Replicas</td>
            <td class="value">
              {{replicationController.currentState.replicas}}
            </td>
          </tr>

          <tr>
            <td class="name">Labels</td>
            <td class="value">
              <div ng-repeat="(label, value) in replicationController.labels">
                  {{label}}: {{value}}
              </div>
            </td>
          </tr>

          <tr>
            <td class="name">Related Pods</td>
            <td class="value">
              <div ng-repeat="(label, value) in replicationController.desiredState.replicaSelector">
                  <a ng-href="#/dashboard/groups/type/selector/{{label}}={{value}},type=pod">{{label}}: {{value}}</a>
                </div>
            </td>
          </tr>


          <tr>
            <td class="name">Related Services</td>
            <td class="value">
              <div ng-repeat="(label, value) in replicationController.desiredState.replicaSelector">
                  <a ng-href="#/dashboard/groups/type/selector/{{label}}={{value}},type=service">{{label}}: {{value}}</a>
                </div>
            </td>
          </tr>




        </tbody>
      </table>



    </div>



  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_replication_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_replication_html, nil
}

func www_app_components_dashboard_views_replication_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_replication_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/replication.html", size: 2165, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_components_dashboard_views_service_html = []byte(`<div dashboard-header></div>
<div class="dashboard">
  <div ng-controller="ServiceCtrl" layout="column" class="body-wrapper service">

    <div class="detail">

      <div class="back">
        <md-button class="md-default-theme" ng-click="doTheBack()">‹ BACK</md-button>
      </div>

      <div class="heading">
        <span class="label">Service: </span>
        <span>{{service.id}}</span>
      </div>


      <table>
        <tbody>
          <tr>
            <td class="name">Created</td>
            <td class="value">
              {{service.creationTimestamp | date:'medium'}}
            </td>
          </tr>

          <tr>
            <td class="name">Port</td>
            <td class="value">
              {{service.port}}
            </td>
          </tr>

          <tr>
            <td class="name">Container Port</td>
            <td class="value">
              {{service.containerPort}}
            </td>
          </tr>

          <tr>
            <td class="name">Portal IP</td>
            <td class="value">
              {{service.portalIP}}
            </td>
          </tr>

          <tr>
            <td class="name">Protocol</td>
            <td class="value">
              {{service.protocol}}
            </td>
          </tr>

          <tr>
            <td class="name">Session Affinity</td>
            <td class="value">
              {{service.sessionAffinity}}
            </td>
          </tr>

          <tr>
            <td class="name">Labels</td>
            <td class="value">
              <div ng-repeat="(label, value) in service.labels">
                {{label}}: {{value}}
              </div>
            </td>
          </tr>

          <tr>
            <td class="name">Related Pods</td>
            <td class="value">
              <div ng-repeat="(label, value) in service.selector">
                <a ng-href="#/dashboard/groups/type/selector/{{label}}={{value}},type=pod">{{label}}: {{value}}</a>
              </div>
            </td>
          </tr>

          <tr>
            <td class="name">Related Replication Controllers</td>
            <td class="value">
              <div ng-repeat="(label, value) in service.selector">
                <a ng-href="#/dashboard/groups/type/selector/{{label}}={{value}},type=replicationController">{{label}}: {{value}}</a>
              </div>
            </td>
          </tr>

        </tbody>
      </table>



    </div>

  </div>
</div>
<div dashboard-footer></div>
`)

func www_app_components_dashboard_views_service_html_bytes() ([]byte, error) {
	return _www_app_components_dashboard_views_service_html, nil
}

func www_app_components_dashboard_views_service_html() (*asset, error) {
	bytes, err := www_app_components_dashboard_views_service_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/components/dashboard/views/service.html", size: 2477, mode: os.FileMode(436), modTime: time.Unix(1431747314, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_index_html = []byte(`<!DOCTYPE html>
<html lang="en" ng-app="kubernetesApp">
<head>
  <title>Kubernetes UI</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="">
  <meta name="viewport" content="initial-scale=1, maximum-scale=1, user-scalable=no" />
  <link rel="stylesheet" href="vendor/angular-material/angular-material.css">
  <link rel="stylesheet" href="assets/css/app.css" >
  <link rel="shortcut icon" href="assets/img/icons/favicon.png" type="image/vnd.microsoft.icon" />
</head>
<body layout="row" ng-controller="PageCtrl">
  <md-sidenav layout="column"
              md-is-locked-open="shouldLockOpen()"
              style="overflow: hidden; display: flex;"
              class="site-sidenav md-sidenav-left md-whiteframe-z2"
              md-component-id="left"
              md-closed>
    <md-toolbar>
      <h1 class="md-toolbar-tools">
        <a ng-href="#/dashboard" layout="row" flex>
          <span class="kubernetes-ui-logo"></span>
          <div style="line-height:40px; text-indent: 15px;">Kubernetes</div>
        </a>
      </h1>
    </md-toolbar>
    <md-content flex>
    <div kubernetes-ui-menu role="kubernetes-ui-menu"></div>
      <div compile="sidenavLeft"></div>
    </md-content>
  </md-sidenav>
  <div layout="column" layout-fill tabIndex="-1" role="main" flex>
    <md-toolbar>
      <div class="md-toolbar-tools">
      <h1 class="md-toolbar-tools">
        <a ng-href="#/dashboard" layout="row" flex>
          <span class="kubernetes-ui-logo"></span>
          <div style="line-height:40px; text-indent: 15px;">Kubernetes</div>
        </a>
      </h1>
      </div>
    </md-toolbar>
    <md-content md-scroll-y flex>
    <md-whiteframe layout layout-align="center center">
      <div ng-controller="TabCtrl" class="tabsDefaultTabs">
        <md-tabs md-selected="0">
          <md-tab ng-repeat="tab in tabs" md-on-select="switchTab($index)" label="{{tab.title}}">
            <div class="demo-tab tab{{$index%4}}" layout="column" layout-fill></div>
          </md-tab>
        </md-tabs>
        <div ng-view layout="column" layout-fill role="main"></div>
      </div>
    </md-whiteframe>
    </md-content>
  </div>
  <script src="assets/js/base.js"></script>
  <script src="assets/js/app.js"></script>
</body>
</html>
`)

func www_app_index_html_bytes() ([]byte, error) {
	return _www_app_index_html, nil
}

func www_app_index_html() (*asset, error) {
	bytes, err := www_app_index_html_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/index.html", size: 2315, mode: os.FileMode(436), modTime: time.Unix(1431747225, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_vendor_gitkeep = []byte(``)

func www_app_vendor_gitkeep_bytes() ([]byte, error) {
	return _www_app_vendor_gitkeep, nil
}

func www_app_vendor_gitkeep() (*asset, error) {
	bytes, err := www_app_vendor_gitkeep_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/vendor/.gitkeep", size: 0, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_vendor_angular_json_human_dist_angular_json_human_css = []byte(`.jh-key,.jh-root,.jh-root tr,.jh-type-array,.jh-type-object,.jh-value{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}.jh-key,.jh-value{margin:0;padding:.2em}.jh-value{border-left:1px solid #ddd}.jh-type-bool,.jh-type-number{font-weight:700;text-align:center;color:#5286BC}.jh-type-string{font-style:italic;color:#839B00}.jh-array-key{font-style:italic;font-size:small;text-align:center}.jh-array-key,.jh-object-key{color:#444;vertical-align:top}.jh-type-array>tbody>tr:nth-child(odd),.jh-type-object>tbody>tr:nth-child(odd){background-color:#f5f5f5}.jh-type-array>tbody>tr:nth-child(even),.jh-type-object>tbody>tr:nth-child(even){background-color:#fff}.jh-type-array,.jh-type-object{width:100%;border-collapse:collapse}.jh-root{border:1px solid #ccc;margin:.2em}th.jh-key{text-align:left}.jh-type-array>tbody>tr,.jh-type-object>tbody>tr{border:1px solid #ddd;border-bottom:none}.jh-type-array>tbody>tr:last-child,.jh-type-object>tbody>tr:last-child{border-bottom:1px solid #ddd}.jh-type-array>tbody>tr:hover,.jh-type-object>tbody>tr:hover{border:1px solid #F99927}.jh-empty{font-style:italic;color:#999;font-size:small}`)

func www_app_vendor_angular_json_human_dist_angular_json_human_css_bytes() ([]byte, error) {
	return _www_app_vendor_angular_json_human_dist_angular_json_human_css, nil
}

func www_app_vendor_angular_json_human_dist_angular_json_human_css() (*asset, error) {
	bytes, err := www_app_vendor_angular_json_human_dist_angular_json_human_css_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/vendor/angular-json-human/dist/angular-json-human.css", size: 1151, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_vendor_angular_material_angular_material_css = []byte(`/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v0.8.1
 */*,:after,:before{box-sizing:border-box}:focus{outline:0}body,html{height:100%;color:rgba(0,0,0,.87);background:#fff;-webkit-tap-highlight-color:transparent;-webkit-touch-callout:none;-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}body p,html p{line-height:1.846}body h3,html h3{display:block;-webkit-margin-before:1em;-webkit-margin-after:1em;-webkit-margin-start:0;-webkit-margin-end:0;font-size:1.17em;font-weight:700}button,html,input,select,textarea{font-family:RobotoDraft,Roboto,'Helvetica Neue',sans-serif}body{margin:0;padding:0;outline:0}.inset{padding:10px}a{background:0 0;outline:0}h1{font-size:2em;margin:.67em 0}h2{font-size:1.5em;margin:.83em 0}h3{font-size:1.17em;margin:1em 0}h4{font-size:1em;margin:1.33em 0}h5{font-size:.83em;margin:1.67em 0}h6{font-size:.75em;margin:2.33em 0}button,input,select,textarea{margin:0;font-size:100%;font-family:inherit;vertical-align:baseline}button,html input[type=button],input[type=reset],input[type=submit]{cursor:pointer;-webkit-appearance:button}button[disabled],html input[type=button][disabled],input[type=reset][disabled],input[type=submit][disabled]{cursor:default}textarea{vertical-align:top;overflow:auto}input[type=radio],input[type=checkbox]{padding:0;box-sizing:border-box}input[type=search]{-webkit-appearance:textfield;box-sizing:content-box;-webkit-box-sizing:content-box}input[type=search]::-webkit-search-cancel-button,input[type=search]::-webkit-search-decoration{-webkit-appearance:none}.visually-hidden{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;text-transform:none;width:1px}.md-shadow{position:absolute;top:0;left:0;bottom:0;right:0;border-radius:inherit;pointer-events:none}.md-button.md-fab,.md-button.md-raised:not([disabled]),.md-shadow-bottom-z-1{box-shadow:0 2px 5px 0 rgba(0,0,0,.26)}.md-button.md-fab:not([disabled]):focus,.md-button.md-fab:not([disabled]):hover,.md-button.md-raised:not([disabled]):focus,.md-button.md-raised:not([disabled]):hover,.md-shadow-bottom-z-2{box-shadow:0 4px 8px 0 rgba(0,0,0,.4)}.md-shadow-animated.md-shadow{transition:box-shadow .28s cubic-bezier(.4,0,.2,1)}.md-ripple-container{pointer-events:none;position:absolute;overflow:hidden;left:0;top:0;width:100%;height:100%;transition:all .55s cubic-bezier(.25,.8,.25,1)}.md-ripple{position:absolute;-webkit-transform:scale(0);transform:scale(0);-webkit-transform-origin:50% 50%;transform-origin:50% 50%;opacity:0;border-radius:50%}.md-ripple.md-ripple-placed{transition:left .9s cubic-bezier(.25,.8,.25,1),top .9s cubic-bezier(.25,.8,.25,1),margin .65s cubic-bezier(.25,.8,.25,1),border .65s cubic-bezier(.25,.8,.25,1),width .65s cubic-bezier(.25,.8,.25,1),height .65s cubic-bezier(.25,.8,.25,1),opacity .65s cubic-bezier(.25,.8,.25,1),-webkit-transform .65s cubic-bezier(.25,.8,.25,1);transition:left .9s cubic-bezier(.25,.8,.25,1),top .9s cubic-bezier(.25,.8,.25,1),margin .65s cubic-bezier(.25,.8,.25,1),border .65s cubic-bezier(.25,.8,.25,1),width .65s cubic-bezier(.25,.8,.25,1),height .65s cubic-bezier(.25,.8,.25,1),opacity .65s cubic-bezier(.25,.8,.25,1),transform .65s cubic-bezier(.25,.8,.25,1)}.md-ripple.md-ripple-scaled{-webkit-transform:scale(1);transform:scale(1)}.md-ripple.md-ripple-active,.md-ripple.md-ripple-full,.md-ripple.md-ripple-visible{opacity:.2}md-tab>.md-ripple-container .md-ripple{box-sizing:content-box;background-color:transparent!important;border-width:0;border-style:solid;opacity:.2;-webkit-transform:none!important;transform:none!important}md-tab>.md-ripple-container .md-ripple.md-ripple-active,md-tab>.md-ripple-container .md-ripple.md-ripple-full,md-tab>.md-ripple-container .md-ripple.md-ripple-visible{opacity:.2}[layout]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[layout-padding],[layout-padding]>[flex]{padding:8px}[layout-margin],[layout-margin]>[flex]{margin:8px}[layout-wrap]{-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap}[layout-fill]{margin:0;min-height:100%;width:100%}@-moz-document url-prefix(){[layout-fill]{margin:0;width:100%;min-height:auto;height:inherit}}[flex]{-webkit-flex:1;-ms-flex:1;flex:1}[flex="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex="0"]{max-width:0}[layout=column]>[flex="0"]{max-height:0}[flex="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex="5"]{max-width:5%}[layout=column]>[flex="5"]{max-height:5%}[flex="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex="10"]{max-width:10%}[layout=column]>[flex="10"]{max-height:10%}[flex="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex="15"]{max-width:15%}[layout=column]>[flex="15"]{max-height:15%}[flex="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex="20"]{max-width:20%}[layout=column]>[flex="20"]{max-height:20%}[flex="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex="25"]{max-width:25%}[layout=column]>[flex="25"]{max-height:25%}[flex="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex="30"]{max-width:30%}[layout=column]>[flex="30"]{max-height:30%}[flex="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex="35"]{max-width:35%}[layout=column]>[flex="35"]{max-height:35%}[flex="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex="40"]{max-width:40%}[layout=column]>[flex="40"]{max-height:40%}[flex="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex="45"]{max-width:45%}[layout=column]>[flex="45"]{max-height:45%}[flex="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex="50"]{max-width:50%}[layout=column]>[flex="50"]{max-height:50%}[flex="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex="55"]{max-width:55%}[layout=column]>[flex="55"]{max-height:55%}[flex="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex="60"]{max-width:60%}[layout=column]>[flex="60"]{max-height:60%}[flex="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex="65"]{max-width:65%}[layout=column]>[flex="65"]{max-height:65%}[flex="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex="70"]{max-width:70%}[layout=column]>[flex="70"]{max-height:70%}[flex="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex="75"]{max-width:75%}[layout=column]>[flex="75"]{max-height:75%}[flex="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex="80"]{max-width:80%}[layout=column]>[flex="80"]{max-height:80%}[flex="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex="85"]{max-width:85%}[layout=column]>[flex="85"]{max-height:85%}[flex="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex="90"]{max-width:90%}[layout=column]>[flex="90"]{max-height:90%}[flex="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex="95"]{max-width:95%}[layout=column]>[flex="95"]{max-height:95%}[flex="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex="100"]{max-width:100%}[layout=column]>[flex="100"]{max-height:100%}[layout=row]>[flex="33"],[layout=row]>[flex="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex="66"],[layout=row]>[flex="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex="33"],[layout=column]>[flex="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex="66"],[layout=column]>[flex="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}[layout-align=center],[layout-align="center center"],[layout-align="center start"],[layout-align="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align=end],[layout-align="end center"],[layout-align="end start"],[layout-align="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align=space-around],[layout-align="space-around center"],[layout-align="space-around start"],[layout-align="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align=space-between],[layout-align="space-between center"],[layout-align="space-between start"],[layout-align="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align="center center"],[layout-align="end center"],[layout-align="space-around center"],[layout-align="space-between center"],[layout-align="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align="center start"],[layout-align="end start"],[layout-align="space-around start"],[layout-align="space-between start"],[layout-align="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align="center end"],[layout-align="end end"],[layout-align="space-around end"],[layout-align="space-between end"],[layout-align="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[flex-order="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order="9"]{-webkit-order:9;-ms-flex-order:9;order:9}@media (max-width:599px){[hide-sm]:not([show-sm]):not([show]),[hide]:not([show-sm]):not([show]){display:none}[flex-order-sm="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-sm="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-sm="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-sm="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-sm="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-sm="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-sm="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-sm="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-sm="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-sm="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-sm=center],[layout-align-sm="center center"],[layout-align-sm="center start"],[layout-align-sm="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-sm=end],[layout-align-sm="end center"],[layout-align-sm="end start"],[layout-align-sm="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-sm=space-around],[layout-align-sm="space-around center"],[layout-align-sm="space-around start"],[layout-align-sm="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-sm=space-between],[layout-align-sm="space-between center"],[layout-align-sm="space-between start"],[layout-align-sm="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-sm="center center"],[layout-align-sm="end center"],[layout-align-sm="space-around center"],[layout-align-sm="space-between center"],[layout-align-sm="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-sm="center start"],[layout-align-sm="end start"],[layout-align-sm="space-around start"],[layout-align-sm="space-between start"],[layout-align-sm="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-sm="center end"],[layout-align-sm="end end"],[layout-align-sm="space-around end"],[layout-align-sm="space-between end"],[layout-align-sm="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-sm]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-sm=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-sm=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-sm]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-sm="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-sm="0"]{max-width:0}[layout=column]>[flex-sm="0"]{max-height:0}[flex-sm="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-sm="5"]{max-width:5%}[layout=column]>[flex-sm="5"]{max-height:5%}[flex-sm="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-sm="10"]{max-width:10%}[layout=column]>[flex-sm="10"]{max-height:10%}[flex-sm="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-sm="15"]{max-width:15%}[layout=column]>[flex-sm="15"]{max-height:15%}[flex-sm="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-sm="20"]{max-width:20%}[layout=column]>[flex-sm="20"]{max-height:20%}[flex-sm="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-sm="25"]{max-width:25%}[layout=column]>[flex-sm="25"]{max-height:25%}[flex-sm="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-sm="30"]{max-width:30%}[layout=column]>[flex-sm="30"]{max-height:30%}[flex-sm="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-sm="35"]{max-width:35%}[layout=column]>[flex-sm="35"]{max-height:35%}[flex-sm="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-sm="40"]{max-width:40%}[layout=column]>[flex-sm="40"]{max-height:40%}[flex-sm="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-sm="45"]{max-width:45%}[layout=column]>[flex-sm="45"]{max-height:45%}[flex-sm="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-sm="50"]{max-width:50%}[layout=column]>[flex-sm="50"]{max-height:50%}[flex-sm="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-sm="55"]{max-width:55%}[layout=column]>[flex-sm="55"]{max-height:55%}[flex-sm="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-sm="60"]{max-width:60%}[layout=column]>[flex-sm="60"]{max-height:60%}[flex-sm="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-sm="65"]{max-width:65%}[layout=column]>[flex-sm="65"]{max-height:65%}[flex-sm="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-sm="70"]{max-width:70%}[layout=column]>[flex-sm="70"]{max-height:70%}[flex-sm="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-sm="75"]{max-width:75%}[layout=column]>[flex-sm="75"]{max-height:75%}[flex-sm="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-sm="80"]{max-width:80%}[layout=column]>[flex-sm="80"]{max-height:80%}[flex-sm="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-sm="85"]{max-width:85%}[layout=column]>[flex-sm="85"]{max-height:85%}[flex-sm="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-sm="90"]{max-width:90%}[layout=column]>[flex-sm="90"]{max-height:90%}[flex-sm="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-sm="95"]{max-width:95%}[layout=column]>[flex-sm="95"]{max-height:95%}[flex-sm="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-sm="100"]{max-width:100%}[layout=column]>[flex-sm="100"]{max-height:100%}[layout=row]>[flex-sm="33"],[layout=row]>[flex-sm="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-sm="66"],[layout=row]>[flex-sm="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-sm="33"],[layout=column]>[flex-sm="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-sm="66"],[layout=column]>[flex-sm="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@media (min-width:600px){[flex-order-gt-sm="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-gt-sm="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-gt-sm="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-gt-sm="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-gt-sm="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-gt-sm="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-gt-sm="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-gt-sm="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-gt-sm="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-gt-sm="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-gt-sm=center],[layout-align-gt-sm="center center"],[layout-align-gt-sm="center start"],[layout-align-gt-sm="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-gt-sm=end],[layout-align-gt-sm="end center"],[layout-align-gt-sm="end start"],[layout-align-gt-sm="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-gt-sm=space-around],[layout-align-gt-sm="space-around center"],[layout-align-gt-sm="space-around start"],[layout-align-gt-sm="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-gt-sm=space-between],[layout-align-gt-sm="space-between center"],[layout-align-gt-sm="space-between start"],[layout-align-gt-sm="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-gt-sm="center center"],[layout-align-gt-sm="end center"],[layout-align-gt-sm="space-around center"],[layout-align-gt-sm="space-between center"],[layout-align-gt-sm="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-gt-sm="center start"],[layout-align-gt-sm="end start"],[layout-align-gt-sm="space-around start"],[layout-align-gt-sm="space-between start"],[layout-align-gt-sm="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-gt-sm="center end"],[layout-align-gt-sm="end end"],[layout-align-gt-sm="space-around end"],[layout-align-gt-sm="space-between end"],[layout-align-gt-sm="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-gt-sm]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-gt-sm=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-gt-sm=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-gt-sm]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-gt-sm="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-gt-sm="0"]{max-width:0}[layout=column]>[flex-gt-sm="0"]{max-height:0}[flex-gt-sm="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-gt-sm="5"]{max-width:5%}[layout=column]>[flex-gt-sm="5"]{max-height:5%}[flex-gt-sm="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-gt-sm="10"]{max-width:10%}[layout=column]>[flex-gt-sm="10"]{max-height:10%}[flex-gt-sm="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-gt-sm="15"]{max-width:15%}[layout=column]>[flex-gt-sm="15"]{max-height:15%}[flex-gt-sm="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-gt-sm="20"]{max-width:20%}[layout=column]>[flex-gt-sm="20"]{max-height:20%}[flex-gt-sm="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-gt-sm="25"]{max-width:25%}[layout=column]>[flex-gt-sm="25"]{max-height:25%}[flex-gt-sm="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-gt-sm="30"]{max-width:30%}[layout=column]>[flex-gt-sm="30"]{max-height:30%}[flex-gt-sm="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-gt-sm="35"]{max-width:35%}[layout=column]>[flex-gt-sm="35"]{max-height:35%}[flex-gt-sm="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-gt-sm="40"]{max-width:40%}[layout=column]>[flex-gt-sm="40"]{max-height:40%}[flex-gt-sm="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-gt-sm="45"]{max-width:45%}[layout=column]>[flex-gt-sm="45"]{max-height:45%}[flex-gt-sm="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-gt-sm="50"]{max-width:50%}[layout=column]>[flex-gt-sm="50"]{max-height:50%}[flex-gt-sm="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-gt-sm="55"]{max-width:55%}[layout=column]>[flex-gt-sm="55"]{max-height:55%}[flex-gt-sm="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-gt-sm="60"]{max-width:60%}[layout=column]>[flex-gt-sm="60"]{max-height:60%}[flex-gt-sm="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-gt-sm="65"]{max-width:65%}[layout=column]>[flex-gt-sm="65"]{max-height:65%}[flex-gt-sm="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-gt-sm="70"]{max-width:70%}[layout=column]>[flex-gt-sm="70"]{max-height:70%}[flex-gt-sm="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-gt-sm="75"]{max-width:75%}[layout=column]>[flex-gt-sm="75"]{max-height:75%}[flex-gt-sm="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-gt-sm="80"]{max-width:80%}[layout=column]>[flex-gt-sm="80"]{max-height:80%}[flex-gt-sm="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-gt-sm="85"]{max-width:85%}[layout=column]>[flex-gt-sm="85"]{max-height:85%}[flex-gt-sm="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-gt-sm="90"]{max-width:90%}[layout=column]>[flex-gt-sm="90"]{max-height:90%}[flex-gt-sm="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-gt-sm="95"]{max-width:95%}[layout=column]>[flex-gt-sm="95"]{max-height:95%}[flex-gt-sm="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-gt-sm="100"]{max-width:100%}[layout=column]>[flex-gt-sm="100"]{max-height:100%}[layout=row]>[flex-gt-sm="33"],[layout=row]>[flex-gt-sm="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-gt-sm="66"],[layout=row]>[flex-gt-sm="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-gt-sm="33"],[layout=column]>[flex-gt-sm="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-gt-sm="66"],[layout=column]>[flex-gt-sm="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@media (min-width:600px) and (max-width:959px){[hide-gt-sm]:not([show-gt-sm]):not([show-md]):not([show]),[hide-md]:not([show-md]):not([show]),[hide]:not([show-gt-sm]):not([show-md]):not([show]){display:none}[flex-order-md="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-md="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-md="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-md="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-md="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-md="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-md="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-md="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-md="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-md="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-md=center],[layout-align-md="center center"],[layout-align-md="center start"],[layout-align-md="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-md=end],[layout-align-md="end center"],[layout-align-md="end start"],[layout-align-md="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-md=space-around],[layout-align-md="space-around center"],[layout-align-md="space-around start"],[layout-align-md="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-md=space-between],[layout-align-md="space-between center"],[layout-align-md="space-between start"],[layout-align-md="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-md="center center"],[layout-align-md="end center"],[layout-align-md="space-around center"],[layout-align-md="space-between center"],[layout-align-md="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-md="center start"],[layout-align-md="end start"],[layout-align-md="space-around start"],[layout-align-md="space-between start"],[layout-align-md="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-md="center end"],[layout-align-md="end end"],[layout-align-md="space-around end"],[layout-align-md="space-between end"],[layout-align-md="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-md]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-md=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-md=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-md]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-md="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-md="0"]{max-width:0}[layout=column]>[flex-md="0"]{max-height:0}[flex-md="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-md="5"]{max-width:5%}[layout=column]>[flex-md="5"]{max-height:5%}[flex-md="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-md="10"]{max-width:10%}[layout=column]>[flex-md="10"]{max-height:10%}[flex-md="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-md="15"]{max-width:15%}[layout=column]>[flex-md="15"]{max-height:15%}[flex-md="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-md="20"]{max-width:20%}[layout=column]>[flex-md="20"]{max-height:20%}[flex-md="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-md="25"]{max-width:25%}[layout=column]>[flex-md="25"]{max-height:25%}[flex-md="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-md="30"]{max-width:30%}[layout=column]>[flex-md="30"]{max-height:30%}[flex-md="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-md="35"]{max-width:35%}[layout=column]>[flex-md="35"]{max-height:35%}[flex-md="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-md="40"]{max-width:40%}[layout=column]>[flex-md="40"]{max-height:40%}[flex-md="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-md="45"]{max-width:45%}[layout=column]>[flex-md="45"]{max-height:45%}[flex-md="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-md="50"]{max-width:50%}[layout=column]>[flex-md="50"]{max-height:50%}[flex-md="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-md="55"]{max-width:55%}[layout=column]>[flex-md="55"]{max-height:55%}[flex-md="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-md="60"]{max-width:60%}[layout=column]>[flex-md="60"]{max-height:60%}[flex-md="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-md="65"]{max-width:65%}[layout=column]>[flex-md="65"]{max-height:65%}[flex-md="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-md="70"]{max-width:70%}[layout=column]>[flex-md="70"]{max-height:70%}[flex-md="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-md="75"]{max-width:75%}[layout=column]>[flex-md="75"]{max-height:75%}[flex-md="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-md="80"]{max-width:80%}[layout=column]>[flex-md="80"]{max-height:80%}[flex-md="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-md="85"]{max-width:85%}[layout=column]>[flex-md="85"]{max-height:85%}[flex-md="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-md="90"]{max-width:90%}[layout=column]>[flex-md="90"]{max-height:90%}[flex-md="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-md="95"]{max-width:95%}[layout=column]>[flex-md="95"]{max-height:95%}[flex-md="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-md="100"]{max-width:100%}[layout=column]>[flex-md="100"]{max-height:100%}[layout=row]>[flex-md="33"],[layout=row]>[flex-md="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-md="66"],[layout=row]>[flex-md="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-md="33"],[layout=column]>[flex-md="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-md="66"],[layout=column]>[flex-md="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@media (min-width:960px){[flex-order-gt-md="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-gt-md="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-gt-md="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-gt-md="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-gt-md="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-gt-md="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-gt-md="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-gt-md="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-gt-md="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-gt-md="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-gt-md=center],[layout-align-gt-md="center center"],[layout-align-gt-md="center start"],[layout-align-gt-md="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-gt-md=end],[layout-align-gt-md="end center"],[layout-align-gt-md="end start"],[layout-align-gt-md="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-gt-md=space-around],[layout-align-gt-md="space-around center"],[layout-align-gt-md="space-around start"],[layout-align-gt-md="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-gt-md=space-between],[layout-align-gt-md="space-between center"],[layout-align-gt-md="space-between start"],[layout-align-gt-md="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-gt-md="center center"],[layout-align-gt-md="end center"],[layout-align-gt-md="space-around center"],[layout-align-gt-md="space-between center"],[layout-align-gt-md="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-gt-md="center start"],[layout-align-gt-md="end start"],[layout-align-gt-md="space-around start"],[layout-align-gt-md="space-between start"],[layout-align-gt-md="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-gt-md="center end"],[layout-align-gt-md="end end"],[layout-align-gt-md="space-around end"],[layout-align-gt-md="space-between end"],[layout-align-gt-md="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-gt-md]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-gt-md=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-gt-md=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-gt-md]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-gt-md="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-gt-md="0"]{max-width:0}[layout=column]>[flex-gt-md="0"]{max-height:0}[flex-gt-md="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-gt-md="5"]{max-width:5%}[layout=column]>[flex-gt-md="5"]{max-height:5%}[flex-gt-md="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-gt-md="10"]{max-width:10%}[layout=column]>[flex-gt-md="10"]{max-height:10%}[flex-gt-md="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-gt-md="15"]{max-width:15%}[layout=column]>[flex-gt-md="15"]{max-height:15%}[flex-gt-md="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-gt-md="20"]{max-width:20%}[layout=column]>[flex-gt-md="20"]{max-height:20%}[flex-gt-md="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-gt-md="25"]{max-width:25%}[layout=column]>[flex-gt-md="25"]{max-height:25%}[flex-gt-md="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-gt-md="30"]{max-width:30%}[layout=column]>[flex-gt-md="30"]{max-height:30%}[flex-gt-md="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-gt-md="35"]{max-width:35%}[layout=column]>[flex-gt-md="35"]{max-height:35%}[flex-gt-md="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-gt-md="40"]{max-width:40%}[layout=column]>[flex-gt-md="40"]{max-height:40%}[flex-gt-md="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-gt-md="45"]{max-width:45%}[layout=column]>[flex-gt-md="45"]{max-height:45%}[flex-gt-md="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-gt-md="50"]{max-width:50%}[layout=column]>[flex-gt-md="50"]{max-height:50%}[flex-gt-md="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-gt-md="55"]{max-width:55%}[layout=column]>[flex-gt-md="55"]{max-height:55%}[flex-gt-md="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-gt-md="60"]{max-width:60%}[layout=column]>[flex-gt-md="60"]{max-height:60%}[flex-gt-md="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-gt-md="65"]{max-width:65%}[layout=column]>[flex-gt-md="65"]{max-height:65%}[flex-gt-md="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-gt-md="70"]{max-width:70%}[layout=column]>[flex-gt-md="70"]{max-height:70%}[flex-gt-md="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-gt-md="75"]{max-width:75%}[layout=column]>[flex-gt-md="75"]{max-height:75%}[flex-gt-md="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-gt-md="80"]{max-width:80%}[layout=column]>[flex-gt-md="80"]{max-height:80%}[flex-gt-md="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-gt-md="85"]{max-width:85%}[layout=column]>[flex-gt-md="85"]{max-height:85%}[flex-gt-md="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-gt-md="90"]{max-width:90%}[layout=column]>[flex-gt-md="90"]{max-height:90%}[flex-gt-md="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-gt-md="95"]{max-width:95%}[layout=column]>[flex-gt-md="95"]{max-height:95%}[flex-gt-md="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-gt-md="100"]{max-width:100%}[layout=column]>[flex-gt-md="100"]{max-height:100%}[layout=row]>[flex-gt-md="33"],[layout=row]>[flex-gt-md="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-gt-md="66"],[layout=row]>[flex-gt-md="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-gt-md="33"],[layout=column]>[flex-gt-md="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-gt-md="66"],[layout=column]>[flex-gt-md="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@media (min-width:960px) and (max-width:1199px){[hide-gt-md]:not([show-gt-sm]):not([show-gt-md]):not([show-lg]):not([show]),[hide-gt-sm]:not([show-gt-sm]):not([show-gt-md]):not([show-lg]):not([show]),[hide-lg]:not([show-lg]):not([show]),[hide]:not([show-gt-sm]):not([show-gt-md]):not([show-lg]):not([show]){display:none}[flex-order-lg="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-lg="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-lg="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-lg="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-lg="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-lg="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-lg="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-lg="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-lg="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-lg="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-lg=center],[layout-align-lg="center center"],[layout-align-lg="center start"],[layout-align-lg="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-lg=end],[layout-align-lg="end center"],[layout-align-lg="end start"],[layout-align-lg="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-lg=space-around],[layout-align-lg="space-around center"],[layout-align-lg="space-around start"],[layout-align-lg="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-lg=space-between],[layout-align-lg="space-between center"],[layout-align-lg="space-between start"],[layout-align-lg="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-lg="center center"],[layout-align-lg="end center"],[layout-align-lg="space-around center"],[layout-align-lg="space-between center"],[layout-align-lg="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-lg="center start"],[layout-align-lg="end start"],[layout-align-lg="space-around start"],[layout-align-lg="space-between start"],[layout-align-lg="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-lg="center end"],[layout-align-lg="end end"],[layout-align-lg="space-around end"],[layout-align-lg="space-between end"],[layout-align-lg="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-lg]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-lg=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-lg=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-lg]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-lg="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-lg="0"]{max-width:0}[layout=column]>[flex-lg="0"]{max-height:0}[flex-lg="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-lg="5"]{max-width:5%}[layout=column]>[flex-lg="5"]{max-height:5%}[flex-lg="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-lg="10"]{max-width:10%}[layout=column]>[flex-lg="10"]{max-height:10%}[flex-lg="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-lg="15"]{max-width:15%}[layout=column]>[flex-lg="15"]{max-height:15%}[flex-lg="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-lg="20"]{max-width:20%}[layout=column]>[flex-lg="20"]{max-height:20%}[flex-lg="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-lg="25"]{max-width:25%}[layout=column]>[flex-lg="25"]{max-height:25%}[flex-lg="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-lg="30"]{max-width:30%}[layout=column]>[flex-lg="30"]{max-height:30%}[flex-lg="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-lg="35"]{max-width:35%}[layout=column]>[flex-lg="35"]{max-height:35%}[flex-lg="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-lg="40"]{max-width:40%}[layout=column]>[flex-lg="40"]{max-height:40%}[flex-lg="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-lg="45"]{max-width:45%}[layout=column]>[flex-lg="45"]{max-height:45%}[flex-lg="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-lg="50"]{max-width:50%}[layout=column]>[flex-lg="50"]{max-height:50%}[flex-lg="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-lg="55"]{max-width:55%}[layout=column]>[flex-lg="55"]{max-height:55%}[flex-lg="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-lg="60"]{max-width:60%}[layout=column]>[flex-lg="60"]{max-height:60%}[flex-lg="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-lg="65"]{max-width:65%}[layout=column]>[flex-lg="65"]{max-height:65%}[flex-lg="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-lg="70"]{max-width:70%}[layout=column]>[flex-lg="70"]{max-height:70%}[flex-lg="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-lg="75"]{max-width:75%}[layout=column]>[flex-lg="75"]{max-height:75%}[flex-lg="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-lg="80"]{max-width:80%}[layout=column]>[flex-lg="80"]{max-height:80%}[flex-lg="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-lg="85"]{max-width:85%}[layout=column]>[flex-lg="85"]{max-height:85%}[flex-lg="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-lg="90"]{max-width:90%}[layout=column]>[flex-lg="90"]{max-height:90%}[flex-lg="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-lg="95"]{max-width:95%}[layout=column]>[flex-lg="95"]{max-height:95%}[flex-lg="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-lg="100"]{max-width:100%}[layout=column]>[flex-lg="100"]{max-height:100%}[layout=row]>[flex-lg="33"],[layout=row]>[flex-lg="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-lg="66"],[layout=row]>[flex-lg="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-lg="33"],[layout=column]>[flex-lg="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-lg="66"],[layout=column]>[flex-lg="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@media (min-width:1200px){[hide-gt-lg]:not([show-gt-sm]):not([show-gt-md]):not([show-gt-lg]):not([show]),[hide-gt-md]:not([show-gt-sm]):not([show-gt-md]):not([show-gt-lg]):not([show]),[hide-gt-sm]:not([show-gt-sm]):not([show-gt-md]):not([show-gt-lg]):not([show]),[hide]:not([show-gt-sm]):not([show-gt-md]):not([show-gt-lg]):not([show]){display:none}[flex-order-gt-lg="0"]{-webkit-order:0;-ms-flex-order:0;order:0}[flex-order-gt-lg="1"]{-webkit-order:1;-ms-flex-order:1;order:1}[flex-order-gt-lg="2"]{-webkit-order:2;-ms-flex-order:2;order:2}[flex-order-gt-lg="3"]{-webkit-order:3;-ms-flex-order:3;order:3}[flex-order-gt-lg="4"]{-webkit-order:4;-ms-flex-order:4;order:4}[flex-order-gt-lg="5"]{-webkit-order:5;-ms-flex-order:5;order:5}[flex-order-gt-lg="6"]{-webkit-order:6;-ms-flex-order:6;order:6}[flex-order-gt-lg="7"]{-webkit-order:7;-ms-flex-order:7;order:7}[flex-order-gt-lg="8"]{-webkit-order:8;-ms-flex-order:8;order:8}[flex-order-gt-lg="9"]{-webkit-order:9;-ms-flex-order:9;order:9}[layout-align-gt-lg=center],[layout-align-gt-lg="center center"],[layout-align-gt-lg="center start"],[layout-align-gt-lg="center end"]{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}[layout-align-gt-lg=end],[layout-align-gt-lg="end center"],[layout-align-gt-lg="end start"],[layout-align-gt-lg="end end"]{-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end}[layout-align-gt-lg=space-around],[layout-align-gt-lg="space-around center"],[layout-align-gt-lg="space-around start"],[layout-align-gt-lg="space-around end"]{-webkit-justify-content:space-around;-ms-flex-pack:distribute;justify-content:space-around}[layout-align-gt-lg=space-between],[layout-align-gt-lg="space-between center"],[layout-align-gt-lg="space-between start"],[layout-align-gt-lg="space-between end"]{-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}[layout-align-gt-lg="center center"],[layout-align-gt-lg="end center"],[layout-align-gt-lg="space-around center"],[layout-align-gt-lg="space-between center"],[layout-align-gt-lg="start center"]{-webkit-align-items:center;-ms-flex-align:center;align-items:center}[layout-align-gt-lg="center start"],[layout-align-gt-lg="end start"],[layout-align-gt-lg="space-around start"],[layout-align-gt-lg="space-between start"],[layout-align-gt-lg="start start"]{-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}[layout-align-gt-lg="center end"],[layout-align-gt-lg="end end"],[layout-align-gt-lg="space-around end"],[layout-align-gt-lg="space-between end"],[layout-align-gt-lg="start end"]{-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}[layout-gt-lg]{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex}[layout-gt-lg=column]{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}[layout-gt-lg=row]{-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row}[flex-gt-lg]{-webkit-flex:1;-ms-flex:1;flex:1}[flex-gt-lg="0"]{-webkit-flex:0 0 0;-ms-flex:0 0 0;flex:0 0 0}[layout=row]>[flex-gt-lg="0"]{max-width:0}[layout=column]>[flex-gt-lg="0"]{max-height:0}[flex-gt-lg="5"]{-webkit-flex:0 0 5%;-ms-flex:0 0 5%;flex:0 0 5%}[layout=row]>[flex-gt-lg="5"]{max-width:5%}[layout=column]>[flex-gt-lg="5"]{max-height:5%}[flex-gt-lg="10"]{-webkit-flex:0 0 10%;-ms-flex:0 0 10%;flex:0 0 10%}[layout=row]>[flex-gt-lg="10"]{max-width:10%}[layout=column]>[flex-gt-lg="10"]{max-height:10%}[flex-gt-lg="15"]{-webkit-flex:0 0 15%;-ms-flex:0 0 15%;flex:0 0 15%}[layout=row]>[flex-gt-lg="15"]{max-width:15%}[layout=column]>[flex-gt-lg="15"]{max-height:15%}[flex-gt-lg="20"]{-webkit-flex:0 0 20%;-ms-flex:0 0 20%;flex:0 0 20%}[layout=row]>[flex-gt-lg="20"]{max-width:20%}[layout=column]>[flex-gt-lg="20"]{max-height:20%}[flex-gt-lg="25"]{-webkit-flex:0 0 25%;-ms-flex:0 0 25%;flex:0 0 25%}[layout=row]>[flex-gt-lg="25"]{max-width:25%}[layout=column]>[flex-gt-lg="25"]{max-height:25%}[flex-gt-lg="30"]{-webkit-flex:0 0 30%;-ms-flex:0 0 30%;flex:0 0 30%}[layout=row]>[flex-gt-lg="30"]{max-width:30%}[layout=column]>[flex-gt-lg="30"]{max-height:30%}[flex-gt-lg="35"]{-webkit-flex:0 0 35%;-ms-flex:0 0 35%;flex:0 0 35%}[layout=row]>[flex-gt-lg="35"]{max-width:35%}[layout=column]>[flex-gt-lg="35"]{max-height:35%}[flex-gt-lg="40"]{-webkit-flex:0 0 40%;-ms-flex:0 0 40%;flex:0 0 40%}[layout=row]>[flex-gt-lg="40"]{max-width:40%}[layout=column]>[flex-gt-lg="40"]{max-height:40%}[flex-gt-lg="45"]{-webkit-flex:0 0 45%;-ms-flex:0 0 45%;flex:0 0 45%}[layout=row]>[flex-gt-lg="45"]{max-width:45%}[layout=column]>[flex-gt-lg="45"]{max-height:45%}[flex-gt-lg="50"]{-webkit-flex:0 0 50%;-ms-flex:0 0 50%;flex:0 0 50%}[layout=row]>[flex-gt-lg="50"]{max-width:50%}[layout=column]>[flex-gt-lg="50"]{max-height:50%}[flex-gt-lg="55"]{-webkit-flex:0 0 55%;-ms-flex:0 0 55%;flex:0 0 55%}[layout=row]>[flex-gt-lg="55"]{max-width:55%}[layout=column]>[flex-gt-lg="55"]{max-height:55%}[flex-gt-lg="60"]{-webkit-flex:0 0 60%;-ms-flex:0 0 60%;flex:0 0 60%}[layout=row]>[flex-gt-lg="60"]{max-width:60%}[layout=column]>[flex-gt-lg="60"]{max-height:60%}[flex-gt-lg="65"]{-webkit-flex:0 0 65%;-ms-flex:0 0 65%;flex:0 0 65%}[layout=row]>[flex-gt-lg="65"]{max-width:65%}[layout=column]>[flex-gt-lg="65"]{max-height:65%}[flex-gt-lg="70"]{-webkit-flex:0 0 70%;-ms-flex:0 0 70%;flex:0 0 70%}[layout=row]>[flex-gt-lg="70"]{max-width:70%}[layout=column]>[flex-gt-lg="70"]{max-height:70%}[flex-gt-lg="75"]{-webkit-flex:0 0 75%;-ms-flex:0 0 75%;flex:0 0 75%}[layout=row]>[flex-gt-lg="75"]{max-width:75%}[layout=column]>[flex-gt-lg="75"]{max-height:75%}[flex-gt-lg="80"]{-webkit-flex:0 0 80%;-ms-flex:0 0 80%;flex:0 0 80%}[layout=row]>[flex-gt-lg="80"]{max-width:80%}[layout=column]>[flex-gt-lg="80"]{max-height:80%}[flex-gt-lg="85"]{-webkit-flex:0 0 85%;-ms-flex:0 0 85%;flex:0 0 85%}[layout=row]>[flex-gt-lg="85"]{max-width:85%}[layout=column]>[flex-gt-lg="85"]{max-height:85%}[flex-gt-lg="90"]{-webkit-flex:0 0 90%;-ms-flex:0 0 90%;flex:0 0 90%}[layout=row]>[flex-gt-lg="90"]{max-width:90%}[layout=column]>[flex-gt-lg="90"]{max-height:90%}[flex-gt-lg="95"]{-webkit-flex:0 0 95%;-ms-flex:0 0 95%;flex:0 0 95%}[layout=row]>[flex-gt-lg="95"]{max-width:95%}[layout=column]>[flex-gt-lg="95"]{max-height:95%}[flex-gt-lg="100"]{-webkit-flex:0 0 100%;-ms-flex:0 0 100%;flex:0 0 100%}[layout=row]>[flex-gt-lg="100"]{max-width:100%}[layout=column]>[flex-gt-lg="100"]{max-height:100%}[layout=row]>[flex-gt-lg="33"],[layout=row]>[flex-gt-lg="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-width:33.33%}[layout=row]>[flex-gt-lg="66"],[layout=row]>[flex-gt-lg="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-width:66.66%}[layout=column]>[flex-gt-lg="33"],[layout=column]>[flex-gt-lg="34"]{-webkit-flex:0 0 33.33%;-ms-flex:0 0 33.33%;flex:0 0 33.33%;max-height:33.33%}[layout=column]>[flex-gt-lg="66"],[layout=column]>[flex-gt-lg="67"]{-webkit-flex:0 0 66.66%;-ms-flex:0 0 66.66%;flex:0 0 66.66%;max-height:66.66%}}@-webkit-keyframes md-autocomplete-list-out{0%{-webkit-animation-timing-function:linear;animation-timing-function:linear}50%{opacity:0;height:40px;-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}100%{height:0;opacity:0}}@keyframes md-autocomplete-list-out{0%{-webkit-animation-timing-function:linear;animation-timing-function:linear}50%{opacity:0;height:40px;-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}100%{height:0;opacity:0}}@-webkit-keyframes md-autocomplete-list-in{0%{opacity:0;height:0;-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}50%{opacity:0;height:40px}100%{opacity:1;height:40px}}@keyframes md-autocomplete-list-in{0%{opacity:0;height:0;-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}50%{opacity:0;height:40px}100%{opacity:1;height:40px}}md-autocomplete{box-shadow:0 2px 5px rgba(0,0,0,.25);border-radius:2px;display:block;height:40px;position:relative;overflow:visible}md-autocomplete md-autocomplete-wrap{display:block;position:relative;overflow:visible;height:40px}md-autocomplete md-autocomplete-wrap md-progress-linear{position:absolute;bottom:0;left:0;width:100%;height:3px;transition:none}md-autocomplete md-autocomplete-wrap md-progress-linear .md-container{transition:none;top:auto;height:3px}md-autocomplete md-autocomplete-wrap md-progress-linear.ng-enter{transition:opacity .15s linear}md-autocomplete md-autocomplete-wrap md-progress-linear.ng-enter.ng-enter-active{opacity:1}md-autocomplete md-autocomplete-wrap md-progress-linear.ng-leave{transition:opacity .15s linear}md-autocomplete md-autocomplete-wrap md-progress-linear.ng-leave.ng-leave-active{opacity:0}md-autocomplete input{position:absolute;left:0;top:0;width:100%;box-sizing:border-box;border:none;box-shadow:none;padding:0 15px;font-size:14px;line-height:40px;height:40px;outline:0;z-index:2;background:0 0}md-autocomplete input::-ms-clear{display:none}md-autocomplete button{position:absolute;top:10px;right:10px;line-height:20px;z-index:2;text-align:center;width:20px;height:20px;cursor:pointer;border:none;border-radius:50%;padding:0;font-size:12px;background:0 0}md-autocomplete button:after{content:'';position:absolute;top:-6px;right:-6px;bottom:-6px;left:-6px;border-radius:50%;-webkit-transform:scale(0);transform:scale(0);opacity:0;transition:all .4s cubic-bezier(.25,.8,.25,1);z-index:-1}md-autocomplete button:focus:after{-webkit-transform:scale(1);transform:scale(1);opacity:1}md-autocomplete button md-icon{position:absolute;top:50%;left:50%;-webkit-transform:translate3d(-50%,-50%,0) scale(.9);transform:translate3d(-50%,-50%,0) scale(.9)}md-autocomplete button md-icon path{stroke-width:0}md-autocomplete button.ng-enter{-webkit-transform:scale(0);transform:scale(0);transition:-webkit-transform .15s ease-out;transition:transform .15s ease-out}md-autocomplete button.ng-enter.ng-enter-active{-webkit-transform:scale(1);transform:scale(1)}md-autocomplete button.ng-leave{transition:-webkit-transform .15s ease-out;transition:transform .15s ease-out}md-autocomplete button.ng-leave.ng-leave-active{-webkit-transform:scale(0);transform:scale(0)}md-autocomplete ul{position:absolute;top:100%;left:0;right:0;box-shadow:0 2px 5px rgba(0,0,0,.25);margin:0;list-style:none;padding:0;overflow:auto;max-height:225.5px;z-index:49}md-autocomplete ul li{border-top:1px solid #ddd;padding:0 15px;line-height:40px;font-size:14px;overflow:hidden;height:40px;transition:background .15s linear;cursor:pointer;margin:0}md-autocomplete ul li.ng-enter,md-autocomplete ul li.ng-hide-remove{transition:none;-webkit-animation:md-autocomplete-list-in .2s;animation:md-autocomplete-list-in .2s}md-autocomplete ul li.ng-hide-add,md-autocomplete ul li.ng-leave{transition:none;-webkit-animation:md-autocomplete-list-out .2s;animation:md-autocomplete-list-out .2s}md-backdrop{z-index:50;background-color:transparent;position:fixed;left:0;top:0;right:0;bottom:0}md-backdrop.md-select-backdrop{z-index:81}md-backdrop.md-dialog-backdrop{z-index:79}md-backdrop.md-bottom-sheet-backdrop{z-index:69}md-backdrop.md-sidenav-backdrop{z-index:59}md-backdrop.ng-enter{-webkit-animation:cubic-bezier(.25,.8,.25,1) mdBackdropFadeIn .5s both;animation:cubic-bezier(.25,.8,.25,1) mdBackdropFadeIn .5s both}md-backdrop.ng-leave{-webkit-animation:cubic-bezier(.55,0,.55,.2) mdBackdropFadeOut .2s both;animation:cubic-bezier(.55,0,.55,.2) mdBackdropFadeOut .2s both}@-webkit-keyframes mdBackdropFadeIn{from{opacity:0}to{opacity:1}}@keyframes mdBackdropFadeIn{from{opacity:0}to{opacity:1}}@-webkit-keyframes mdBackdropFadeOut{from{opacity:1}to{opacity:0}}@keyframes mdBackdropFadeOut{from{opacity:1}to{opacity:0}}md-bottom-sheet{position:absolute;left:0;right:0;bottom:0;padding:8px 16px 88px;z-index:70;border-top:1px solid;-webkit-transform:translate3d(0,80px,0);transform:translate3d(0,80px,0);transition:all .4s cubic-bezier(.25,.8,.25,1);transition-property:-webkit-transform;transition-property:transform}md-bottom-sheet.md-has-header{padding-top:0}md-bottom-sheet.ng-enter{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}md-bottom-sheet.ng-enter-active{opacity:1;display:block;-webkit-transform:translate3d(0,80px,0)!important;transform:translate3d(0,80px,0)!important}md-bottom-sheet.ng-leave-active{-webkit-transform:translate3d(0,100%,0)!important;transform:translate3d(0,100%,0)!important;transition:all .3s cubic-bezier(.55,0,.55,.2)}md-bottom-sheet .md-subheader{background-color:transparent;font-family:RobotoDraft,Roboto,'Helvetica Neue',sans-serif;line-height:56px;padding:0;white-space:nowrap}md-bottom-sheet md-inline-icon{display:inline-block;height:24px;width:24px;fill:#444}md-bottom-sheet md-item{display:-webkit-flex;display:-ms-flexbox;display:flex;outline:0}md-bottom-sheet md-item:hover{cursor:pointer}md-bottom-sheet.md-list md-item{-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:48px}md-bottom-sheet.md-list md-item div.md-icon-container{display:inline-block;height:24px;margin-right:32px}md-bottom-sheet.md-grid{padding-left:24px;padding-right:24px;padding-top:0}md-bottom-sheet.md-grid md-list{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;transition:all .5s;-webkit-align-items:center;-ms-flex-align:center;align-items:center}md-bottom-sheet.md-grid md-item{-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;-webkit-align-items:center;-ms-flex-align:center;align-items:center;transition:all .5s;height:96px;margin-top:8px;margin-bottom:8px}@media screen and (max-width:600px){md-bottom-sheet.md-grid md-item{-webkit-flex:1 1 33.33333%;-ms-flex:1 1 33.33333%;flex:1 1 33.33333%;max-width:33.33333%}md-bottom-sheet.md-grid md-item:nth-of-type(3n+1){-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start}md-bottom-sheet.md-grid md-item:nth-of-type(3n){-webkit-align-items:flex-end;-ms-flex-align:end;align-items:flex-end}}@media screen and (min-width:600px) and (max-width:960px){md-bottom-sheet.md-grid md-item{-webkit-flex:1 1 25%;-ms-flex:1 1 25%;flex:1 1 25%;max-width:25%}}@media screen and (min-width:960px) and (max-width:1200px){md-bottom-sheet.md-grid md-item{-webkit-flex:1 1 16.66667%;-ms-flex:1 1 16.66667%;flex:1 1 16.66667%;max-width:16.66667%}}@media screen and (min-width:1200px){md-bottom-sheet.md-grid md-item{-webkit-flex:1 1 14.28571%;-ms-flex:1 1 14.28571%;flex:1 1 14.28571%;max-width:14.28571%}}md-bottom-sheet.md-grid md-item .md-item-content{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;-webkit-align-items:center;-ms-flex-align:center;align-items:center;width:48px;padding-bottom:16px}md-bottom-sheet.md-grid md-item .md-grid-item-content{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;-webkit-align-items:center;-ms-flex-align:center;align-items:center;width:80px}md-bottom-sheet.md-grid md-item .md-icon-container{display:inline-block;box-sizing:border-box;height:48px;width:48px;margin:0}md-bottom-sheet.md-grid md-item p.md-grid-text{font-weight:300;line-height:16px;font-size:13px;margin:0;white-space:nowrap;width:64px;text-align:center;padding-top:8px}md-card{box-sizing:border-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;margin:8px;box-shadow:0 2px 5px 0 rgba(0,0,0,.26)}md-card>:not(md-card-content) img,md-card>img{-webkit-order:0;-ms-flex-order:0;order:0;width:100%}md-card md-card-content{-webkit-order:1;-ms-flex-order:1;order:1;padding:16px}.md-button{color:currentColor;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;position:relative;outline:0;border:0;padding:6px;margin:0;background:0 0;white-space:nowrap;text-align:center;text-transform:uppercase;font-weight:500;font-style:inherit;font-variant:inherit;font-size:inherit;font-family:inherit;line-height:inherit;text-decoration:none;cursor:pointer;overflow:hidden;transition:box-shadow .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),-webkit-transform .4s cubic-bezier(.25,.8,.25,1);transition:box-shadow .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),transform .4s cubic-bezier(.25,.8,.25,1)}.md-button:focus{outline:0}.md-button:hover{text-decoration:none}.md-button.ng-hide{transition:none}.md-button.md-cornered{border-radius:0}.md-button.md-icon{padding:0;background:0 0}.md-button.md-raised{-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.md-button.md-fab{z-index:20;width:56px;height:56px;border-radius:50%;overflow:hidden;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);transition:.2s linear;transition-property:-webkit-transform,box-shadow;transition-property:transform,box-shadow}.md-button.md-fab.md-fab-bottom-right{top:auto;right:20px;bottom:20px;left:auto;position:absolute}.md-button.md-fab.md-fab-bottom-left{top:auto;right:auto;bottom:20px;left:20px;position:absolute}.md-button.md-fab.md-fab-top-right{top:20px;right:20px;bottom:auto;left:auto;position:absolute}.md-button.md-fab.md-fab-top-left{top:20px;right:auto;bottom:auto;left:20px;position:absolute}.md-button.md-fab md-icon{margin-top:0}.md-button.md-fab.md-mini{width:40px;height:40px}.md-button:not([disabled]).md-fab:focus,.md-button:not([disabled]).md-fab:hover,.md-button:not([disabled]).md-raised:focus,.md-button:not([disabled]).md-raised:hover{-webkit-transform:translate3d(0,-1px,0);transform:translate3d(0,-1px,0)}.md-toast-open-top .md-button.md-fab-top-left,.md-toast-open-top .md-button.md-fab-top-right{-webkit-transform:translate3d(0,42px,0);transform:translate3d(0,42px,0)}.md-toast-open-top .md-button.md-fab-top-left:not([disabled]):focus,.md-toast-open-top .md-button.md-fab-top-left:not([disabled]):hover,.md-toast-open-top .md-button.md-fab-top-right:not([disabled]):focus,.md-toast-open-top .md-button.md-fab-top-right:not([disabled]):hover{-webkit-transform:translate3d(0,41px,0);transform:translate3d(0,41px,0)}.md-toast-open-bottom .md-button.md-fab-bottom-left,.md-toast-open-bottom .md-button.md-fab-bottom-right{-webkit-transform:translate3d(0,-42px,0);transform:translate3d(0,-42px,0)}.md-toast-open-bottom .md-button.md-fab-bottom-left:not([disabled]):focus,.md-toast-open-bottom .md-button.md-fab-bottom-left:not([disabled]):hover,.md-toast-open-bottom .md-button.md-fab-bottom-right:not([disabled]):focus,.md-toast-open-bottom .md-button.md-fab-bottom-right:not([disabled]):hover{-webkit-transform:translate3d(0,-43px,0);transform:translate3d(0,-43px,0)}.md-button-group{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex:1;-ms-flex:1;flex:1;width:100%}.md-button-group>.md-button{-webkit-flex:1;-ms-flex:1;flex:1;display:block;overflow:hidden;width:0;border-width:1px 0 1px 1px;border-radius:0;text-align:center;text-overflow:ellipsis;white-space:nowrap}.md-button-group>.md-button:first-child{border-radius:2px 0 0 2px}.md-button-group>.md-button:last-child{border-right-width:1px;border-radius:0 2px 2px 0}md-checkbox{display:block;margin:15px;white-space:nowrap;cursor:pointer;outline:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}md-checkbox .md-container{position:relative;top:4px;display:inline-block;width:18px;height:18px}md-checkbox .md-container:after{content:'';position:absolute;top:-10px;right:-10px;bottom:-10px;left:-10px}md-checkbox .md-container .md-ripple-container{position:absolute;display:block;width:auto;height:auto;left:-15px;top:-15px;right:-15px;bottom:-15px}md-checkbox .md-icon{transition:240ms;position:absolute;top:0;left:0;width:18px;height:18px;border:2px solid;border-radius:2px}md-checkbox.md-checked .md-icon{border:none}md-checkbox[disabled]{cursor:no-drop}md-checkbox:focus .md-label:not(:empty){border-color:#000}md-checkbox.md-checked .md-icon:after{-webkit-transform:rotate(45deg);transform:rotate(45deg);position:absolute;left:6px;top:2px;display:table;width:6px;height:12px;border:2px solid;border-top:0;border-left:0;content:' '}md-checkbox .md-label{border:1px dotted transparent;position:relative;display:inline-block;margin-left:10px;vertical-align:middle;white-space:normal;pointer-events:none;-webkit-user-select:text;-moz-user-select:text;-ms-user-select:text;user-select:text}md-content{display:block;position:relative;overflow:auto;-webkit-overflow-scrolling:touch}md-content[md-scroll-y]{overflow-y:auto;overflow-x:hidden}md-content[md-scroll-x]{overflow-x:auto;overflow-y:hidden}md-content.md-padding{padding:8px}@media (min-width:600px){md-content.md-padding{padding:16px}}.md-dialog-container{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;position:absolute;top:0;left:0;width:100%;height:100%;z-index:80}md-dialog{opacity:0;min-width:240px;max-width:80%;max-height:80%;position:relative;overflow:hidden;box-shadow:0 27px 24px 0 rgba(0,0,0,.2);display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}md-dialog.transition-in{opacity:1;transition:all .4s cubic-bezier(.25,.8,.25,1);-webkit-transform:translate3d(0,0,0) scale(1);transform:translate3d(0,0,0) scale(1)}md-dialog.transition-out{transition:all .4s cubic-bezier(.25,.8,.25,1);-webkit-transform:translate3d(0,100%,0) scale(.2);transform:translate3d(0,100%,0) scale(.2)}md-dialog md-content{-webkit-order:1;-ms-flex-order:1;order:1;padding:24px;overflow:auto;-webkit-overflow-scrolling:touch}md-dialog md-content:not([layout=row])>:first-child:not(.md-subheader){margin-top:0}md-dialog .md-actions{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-order:2;-ms-flex-order:2;order:2;box-sizing:border-box;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-justify-content:flex-end;-ms-flex-pack:end;justify-content:flex-end;padding:16px;min-height:40px}md-dialog .md-actions>*{margin-left:8px}md-dialog.md-content-overflow .md-actions{border-top:1px solid}md-divider{display:block;border-top:1px solid;margin:0}md-divider[md-inset]{margin-left:80px}md-grid-list{display:block;position:relative}md-grid-list md-grid-tile{display:block;position:absolute}md-grid-list md-grid-tile figure{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;height:100%;position:absolute;top:0;right:0;bottom:0;left:0;padding:0;margin:0}md-grid-list md-grid-tile md-grid-tile-footer,md-grid-list md-grid-tile md-grid-tile-header{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:48px;color:#fff;background:rgba(0,0,0,.18);overflow:hidden;position:absolute;left:0;right:0}md-grid-list md-grid-tile md-grid-tile-footer h3,md-grid-list md-grid-tile md-grid-tile-footer h4,md-grid-list md-grid-tile md-grid-tile-header h3,md-grid-list md-grid-tile md-grid-tile-header h4{font-weight:400;margin:0 0 0 16px}md-grid-list md-grid-tile md-grid-tile-footer h3,md-grid-list md-grid-tile md-grid-tile-header h3{font-size:14px}md-grid-list md-grid-tile md-grid-tile-footer h4,md-grid-list md-grid-tile md-grid-tile-header h4{font-size:12px}md-grid-list md-grid-tile md-grid-tile-header{top:0}md-grid-list md-grid-tile md-grid-tile-footer{bottom:0}md-icon{margin:auto;background-repeat:no-repeat no-repeat;display:inline-block;vertical-align:middle;fill:currentcolor;height:24px;width:24px}md-input-container{display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;overflow-x:hidden;padding:2px 2px 26px}md-input-container input[type=text],md-input-container input[type=password],md-input-container input[type=datetime],md-input-container input[type=datetime-local],md-input-container input[type=date],md-input-container input[type=month],md-input-container input[type=time],md-input-container input[type=search],md-input-container input[type=week],md-input-container input[type=number],md-input-container input[type=email],md-input-container input[type=url],md-input-container input[type=tel],md-input-container input[type=color],md-input-container textarea{-moz-appearance:none;-webkit-appearance:none}md-input-container textarea{resize:none;overflow:hidden}md-input-container .md-placeholder,md-input-container label:not(.md-no-float){-webkit-order:1;-ms-flex-order:1;order:1;pointer-events:none;-webkit-font-smoothing:antialiased;padding-left:2px;z-index:1;-webkit-transform:translate3d(0,24px,0) scale(1);transform:translate3d(0,24px,0) scale(1);-webkit-transform-origin:left top;transform-origin:left top;transition:-webkit-transform cubic-bezier(.25,.8,.25,1) .25s;transition:transform cubic-bezier(.25,.8,.25,1) .25s}md-input-container .md-placeholder{position:absolute;top:0;opacity:0;transition-property:opacity,-webkit-transform;transition-property:opacity,transform;-webkit-transform:translate3d(0,30px,0);transform:translate3d(0,30px,0)}md-input-container.md-input-focused .md-placeholder{opacity:1;-webkit-transform:translate3d(0,24px,0);transform:translate3d(0,24px,0)}md-input-container.md-input-has-value .md-placeholder{transition:none;opacity:0}md-input-container:not(.md-input-has-value) input:not(:focus){color:transparent}md-input-container .md-input{-webkit-flex:1;-ms-flex:1;flex:1;-webkit-order:2;-ms-flex-order:2;order:2;display:block;background:0 0;padding:2px 2px 1px;border-width:0 0 1px;line-height:26px;-ms-flex-preferred-size:26px;border-radius:0}md-input-container .md-input:focus{outline:0}md-input-container .md-input:invalid{outline:0;box-shadow:none}md-input-container [data-ng-messages],md-input-container [ng-messages],md-input-container [x-ng-messages],md-input-container data-ng-messages,md-input-container ng-messages,md-input-container x-ng-messages{-webkit-order:3;-ms-flex-order:3;order:3;position:relative}md-input-container .md-char-counter,md-input-container [data-ng-message],md-input-container [ng-message],md-input-container [x-ng-message],md-input-container data-ng-message,md-input-container ng-message,md-input-container x-ng-message{-webkit-font-smoothing:antialiased;position:absolute;font-size:12px;line-height:24px}md-input-container .md-char-counter.ng-enter,md-input-container [data-ng-message].ng-enter,md-input-container [ng-message].ng-enter,md-input-container [x-ng-message].ng-enter,md-input-container data-ng-message.ng-enter,md-input-container ng-message.ng-enter,md-input-container x-ng-message.ng-enter{transition:all .4s cubic-bezier(.25,.8,.25,1);transition-delay:.2s}md-input-container .md-char-counter.ng-leave,md-input-container [data-ng-message].ng-leave,md-input-container [ng-message].ng-leave,md-input-container [x-ng-message].ng-leave,md-input-container data-ng-message.ng-leave,md-input-container ng-message.ng-leave,md-input-container x-ng-message.ng-leave{transition:all .3s cubic-bezier(.55,0,.55,.2)}md-input-container .md-char-counter.ng-enter,md-input-container .md-char-counter.ng-leave.ng-leave-active,md-input-container [data-ng-message].ng-enter,md-input-container [data-ng-message].ng-leave.ng-leave-active,md-input-container [ng-message].ng-enter,md-input-container [ng-message].ng-leave.ng-leave-active,md-input-container [x-ng-message].ng-enter,md-input-container [x-ng-message].ng-leave.ng-leave-active,md-input-container data-ng-message.ng-enter,md-input-container data-ng-message.ng-leave.ng-leave-active,md-input-container ng-message.ng-enter,md-input-container ng-message.ng-leave.ng-leave-active,md-input-container x-ng-message.ng-enter,md-input-container x-ng-message.ng-leave.ng-leave-active{opacity:0;-webkit-transform:translate3d(0,-20%,0);transform:translate3d(0,-20%,0)}md-input-container .md-char-counter.ng-enter.ng-enter-active,md-input-container .md-char-counter.ng-leave,md-input-container [data-ng-message].ng-enter.ng-enter-active,md-input-container [data-ng-message].ng-leave,md-input-container [ng-message].ng-enter.ng-enter-active,md-input-container [ng-message].ng-leave,md-input-container [x-ng-message].ng-enter.ng-enter-active,md-input-container [x-ng-message].ng-leave,md-input-container data-ng-message.ng-enter.ng-enter-active,md-input-container data-ng-message.ng-leave,md-input-container ng-message.ng-enter.ng-enter-active,md-input-container ng-message.ng-leave,md-input-container x-ng-message.ng-enter.ng-enter-active,md-input-container x-ng-message.ng-leave{opacity:1;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}md-input-container .md-char-counter{bottom:2px;right:2px}md-input-container.md-input-focused label:not(.md-no-float),md-input-container.md-input-has-value label:not(.md-no-float){-webkit-transform:translate3d(0,4px,0) scale(.75);transform:translate3d(0,4px,0) scale(.75)}md-input-container .md-input.ng-invalid.ng-dirty,md-input-container.md-input-focused .md-input{padding-bottom:0;border-width:0 0 2px}[disabled] md-input-container .md-input,md-input-container .md-input[disabled]{background-position:0 bottom;background-size:3px 1px;background-repeat:repeat-x}md-list{padding:8px 0}md-item-content{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;box-sizing:border-box;position:relative;padding:0}.md-tile-left{min-width:56px;margin-right:-16px}.md-tile-content{-webkit-flex:1;-ms-flex:1;flex:1;padding:16px;text-overflow:ellipsis}.md-tile-content h3{margin:0 0 3px;font-weight:400;font-size:1.1em}.md-tile-content h4{margin:0 0 3px;font-weight:400;font-size:.9em}.md-tile-content p{margin:0 0 3px;font-size:.75em}.md-tile-right{padding-right:0}@-webkit-keyframes outer-rotate{100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes outer-rotate{100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@-webkit-keyframes left-wobble{0%,100%{-webkit-transform:rotate(130deg);transform:rotate(130deg)}50%{-webkit-transform:rotate(-5deg);transform:rotate(-5deg)}}@keyframes left-wobble{0%,100%{-webkit-transform:rotate(130deg);transform:rotate(130deg)}50%{-webkit-transform:rotate(-5deg);transform:rotate(-5deg)}}@-webkit-keyframes right-wobble{0%,100%{-webkit-transform:rotate(-130deg);transform:rotate(-130deg)}50%{-webkit-transform:rotate(5deg);transform:rotate(5deg)}}@keyframes right-wobble{0%,100%{-webkit-transform:rotate(-130deg);transform:rotate(-130deg)}50%{-webkit-transform:rotate(5deg);transform:rotate(5deg)}}@-webkit-keyframes sporadic-rotate{12.5%{-webkit-transform:rotate(135deg);transform:rotate(135deg)}25%{-webkit-transform:rotate(270deg);transform:rotate(270deg)}37.5%{-webkit-transform:rotate(405deg);transform:rotate(405deg)}50%{-webkit-transform:rotate(540deg);transform:rotate(540deg)}62.5%{-webkit-transform:rotate(675deg);transform:rotate(675deg)}75%{-webkit-transform:rotate(810deg);transform:rotate(810deg)}87.5%{-webkit-transform:rotate(945deg);transform:rotate(945deg)}100%{-webkit-transform:rotate(1080deg);transform:rotate(1080deg)}}@keyframes sporadic-rotate{12.5%{-webkit-transform:rotate(135deg);transform:rotate(135deg)}25%{-webkit-transform:rotate(270deg);transform:rotate(270deg)}37.5%{-webkit-transform:rotate(405deg);transform:rotate(405deg)}50%{-webkit-transform:rotate(540deg);transform:rotate(540deg)}62.5%{-webkit-transform:rotate(675deg);transform:rotate(675deg)}75%{-webkit-transform:rotate(810deg);transform:rotate(810deg)}87.5%{-webkit-transform:rotate(945deg);transform:rotate(945deg)}100%{-webkit-transform:rotate(1080deg);transform:rotate(1080deg)}}md-progress-circular{width:50px;height:50px;display:block;position:relative;padding-top:0!important;margin-bottom:0!important;overflow:hidden}md-progress-circular .md-inner{width:50px;height:50px;position:relative}md-progress-circular .md-inner .md-gap{position:absolute;left:24px;right:24px;top:0;bottom:0;border-top:5px solid #000;box-sizing:border-box}md-progress-circular .md-inner .md-left,md-progress-circular .md-inner .md-right{position:absolute;top:0;height:50px;width:25px;overflow:hidden}md-progress-circular .md-inner .md-left .md-half-circle,md-progress-circular .md-inner .md-right .md-half-circle{position:absolute;top:0;width:50px;height:50px;box-sizing:border-box;border-width:5px;border-style:solid;border-color:#000 #000 transparent;border-radius:50%}md-progress-circular .md-inner .md-left{left:0}md-progress-circular .md-inner .md-left .md-half-circle{left:0;border-right-color:transparent}md-progress-circular .md-inner .md-right{right:0}md-progress-circular .md-inner .md-right .md-half-circle{right:0;border-left-color:transparent}md-progress-circular[value="0"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="0"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-135deg);transform:rotate(-135deg)}md-progress-circular[value="0"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="1"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="1"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-131.4deg);transform:rotate(-131.4deg)}md-progress-circular[value="1"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="2"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="2"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-127.8deg);transform:rotate(-127.8deg)}md-progress-circular[value="2"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="3"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="3"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-124.2deg);transform:rotate(-124.2deg)}md-progress-circular[value="3"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="4"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="4"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-120.6deg);transform:rotate(-120.6deg)}md-progress-circular[value="4"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="5"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="5"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-117deg);transform:rotate(-117deg)}md-progress-circular[value="5"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="6"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="6"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-113.4deg);transform:rotate(-113.4deg)}md-progress-circular[value="6"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="7"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="7"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-109.8deg);transform:rotate(-109.8deg)}md-progress-circular[value="7"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="8"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="8"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-106.2deg);transform:rotate(-106.2deg)}md-progress-circular[value="8"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="9"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="9"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-102.6deg);transform:rotate(-102.6deg)}md-progress-circular[value="9"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="10"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="10"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-99deg);transform:rotate(-99deg)}md-progress-circular[value="10"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="11"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="11"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-95.4deg);transform:rotate(-95.4deg)}md-progress-circular[value="11"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="12"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="12"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-91.8deg);transform:rotate(-91.8deg)}md-progress-circular[value="12"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="13"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="13"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-88.2deg);transform:rotate(-88.2deg)}md-progress-circular[value="13"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="14"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="14"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-84.6deg);transform:rotate(-84.6deg)}md-progress-circular[value="14"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="15"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="15"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-81deg);transform:rotate(-81deg)}md-progress-circular[value="15"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="16"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="16"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-77.4deg);transform:rotate(-77.4deg)}md-progress-circular[value="16"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="17"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="17"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-73.8deg);transform:rotate(-73.8deg)}md-progress-circular[value="17"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="18"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="18"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-70.2deg);transform:rotate(-70.2deg)}md-progress-circular[value="18"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="19"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="19"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-66.6deg);transform:rotate(-66.6deg)}md-progress-circular[value="19"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="20"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="20"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-63deg);transform:rotate(-63deg)}md-progress-circular[value="20"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="21"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="21"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-59.4deg);transform:rotate(-59.4deg)}md-progress-circular[value="21"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="22"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="22"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-55.8deg);transform:rotate(-55.8deg)}md-progress-circular[value="22"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="23"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="23"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-52.2deg);transform:rotate(-52.2deg)}md-progress-circular[value="23"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="24"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="24"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-48.6deg);transform:rotate(-48.6deg)}md-progress-circular[value="24"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="25"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="25"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}md-progress-circular[value="25"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="26"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="26"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-41.4deg);transform:rotate(-41.4deg)}md-progress-circular[value="26"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="27"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="27"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-37.8deg);transform:rotate(-37.8deg)}md-progress-circular[value="27"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="28"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="28"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-34.2deg);transform:rotate(-34.2deg)}md-progress-circular[value="28"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="29"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="29"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-30.6deg);transform:rotate(-30.6deg)}md-progress-circular[value="29"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="30"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="30"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-27deg);transform:rotate(-27deg)}md-progress-circular[value="30"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="31"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="31"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-23.4deg);transform:rotate(-23.4deg)}md-progress-circular[value="31"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="32"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="32"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-19.8deg);transform:rotate(-19.8deg)}md-progress-circular[value="32"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="33"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="33"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-16.2deg);transform:rotate(-16.2deg)}md-progress-circular[value="33"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="34"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="34"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-12.6deg);transform:rotate(-12.6deg)}md-progress-circular[value="34"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="35"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="35"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-9deg);transform:rotate(-9deg)}md-progress-circular[value="35"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="36"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="36"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-5.4deg);transform:rotate(-5.4deg)}md-progress-circular[value="36"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="37"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="37"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(-1.8deg);transform:rotate(-1.8deg)}md-progress-circular[value="37"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="38"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="38"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(1.8deg);transform:rotate(1.8deg)}md-progress-circular[value="38"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="39"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="39"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(5.4deg);transform:rotate(5.4deg)}md-progress-circular[value="39"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="40"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="40"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(9deg);transform:rotate(9deg)}md-progress-circular[value="40"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="41"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="41"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(12.6deg);transform:rotate(12.6deg)}md-progress-circular[value="41"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="42"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="42"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(16.2deg);transform:rotate(16.2deg)}md-progress-circular[value="42"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="43"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="43"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(19.8deg);transform:rotate(19.8deg)}md-progress-circular[value="43"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="44"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="44"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(23.4deg);transform:rotate(23.4deg)}md-progress-circular[value="44"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="45"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="45"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(27deg);transform:rotate(27deg)}md-progress-circular[value="45"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="46"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="46"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(30.6deg);transform:rotate(30.6deg)}md-progress-circular[value="46"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="47"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="47"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(34.2deg);transform:rotate(34.2deg)}md-progress-circular[value="47"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="48"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="48"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(37.8deg);transform:rotate(37.8deg)}md-progress-circular[value="48"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="49"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="49"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(41.4deg);transform:rotate(41.4deg)}md-progress-circular[value="49"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="50"] .md-inner .md-left .md-half-circle{-webkit-transform:rotate(135deg);transform:rotate(135deg)}md-progress-circular[value="50"] .md-inner .md-right .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="50"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;border-bottom-color:transparent!important}md-progress-circular[value="51"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(138.6deg);transform:rotate(138.6deg)}md-progress-circular[value="51"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="51"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="52"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(142.2deg);transform:rotate(142.2deg)}md-progress-circular[value="52"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="52"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="53"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(145.8deg);transform:rotate(145.8deg)}md-progress-circular[value="53"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="53"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="54"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(149.4deg);transform:rotate(149.4deg)}md-progress-circular[value="54"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="54"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="55"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(153deg);transform:rotate(153deg)}md-progress-circular[value="55"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="55"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="56"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(156.6deg);transform:rotate(156.6deg)}md-progress-circular[value="56"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="56"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="57"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(160.2deg);transform:rotate(160.2deg)}md-progress-circular[value="57"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="57"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="58"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(163.8deg);transform:rotate(163.8deg)}md-progress-circular[value="58"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="58"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="59"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(167.4deg);transform:rotate(167.4deg)}md-progress-circular[value="59"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="59"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="60"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(171deg);transform:rotate(171deg)}md-progress-circular[value="60"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="60"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="61"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(174.6deg);transform:rotate(174.6deg)}md-progress-circular[value="61"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="61"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="62"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(178.2deg);transform:rotate(178.2deg)}md-progress-circular[value="62"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="62"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="63"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(181.8deg);transform:rotate(181.8deg)}md-progress-circular[value="63"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="63"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="64"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(185.4deg);transform:rotate(185.4deg)}md-progress-circular[value="64"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="64"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="65"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(189deg);transform:rotate(189deg)}md-progress-circular[value="65"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="65"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="66"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(192.6deg);transform:rotate(192.6deg)}md-progress-circular[value="66"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="66"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="67"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(196.2deg);transform:rotate(196.2deg)}md-progress-circular[value="67"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="67"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="68"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(199.8deg);transform:rotate(199.8deg)}md-progress-circular[value="68"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="68"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="69"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(203.4deg);transform:rotate(203.4deg)}md-progress-circular[value="69"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="69"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="70"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(207deg);transform:rotate(207deg)}md-progress-circular[value="70"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="70"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="71"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(210.6deg);transform:rotate(210.6deg)}md-progress-circular[value="71"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="71"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="72"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(214.2deg);transform:rotate(214.2deg)}md-progress-circular[value="72"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="72"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="73"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(217.8deg);transform:rotate(217.8deg)}md-progress-circular[value="73"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="73"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="74"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(221.4deg);transform:rotate(221.4deg)}md-progress-circular[value="74"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="74"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="75"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(225deg);transform:rotate(225deg)}md-progress-circular[value="75"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="75"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="76"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(228.6deg);transform:rotate(228.6deg)}md-progress-circular[value="76"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="76"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="77"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(232.2deg);transform:rotate(232.2deg)}md-progress-circular[value="77"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="77"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="78"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(235.8deg);transform:rotate(235.8deg)}md-progress-circular[value="78"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="78"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="79"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(239.4deg);transform:rotate(239.4deg)}md-progress-circular[value="79"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="79"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="80"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(243deg);transform:rotate(243deg)}md-progress-circular[value="80"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="80"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="81"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(246.6deg);transform:rotate(246.6deg)}md-progress-circular[value="81"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="81"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="82"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(250.2deg);transform:rotate(250.2deg)}md-progress-circular[value="82"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="82"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="83"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(253.8deg);transform:rotate(253.8deg)}md-progress-circular[value="83"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="83"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="84"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(257.4deg);transform:rotate(257.4deg)}md-progress-circular[value="84"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="84"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="85"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(261deg);transform:rotate(261deg)}md-progress-circular[value="85"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="85"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="86"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(264.6deg);transform:rotate(264.6deg)}md-progress-circular[value="86"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="86"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="87"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(268.2deg);transform:rotate(268.2deg)}md-progress-circular[value="87"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="87"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="88"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(271.8deg);transform:rotate(271.8deg)}md-progress-circular[value="88"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="88"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="89"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(275.4deg);transform:rotate(275.4deg)}md-progress-circular[value="89"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="89"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="90"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(279deg);transform:rotate(279deg)}md-progress-circular[value="90"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="90"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="91"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(282.6deg);transform:rotate(282.6deg)}md-progress-circular[value="91"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="91"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="92"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(286.2deg);transform:rotate(286.2deg)}md-progress-circular[value="92"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="92"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="93"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(289.8deg);transform:rotate(289.8deg)}md-progress-circular[value="93"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="93"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="94"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(293.4deg);transform:rotate(293.4deg)}md-progress-circular[value="94"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="94"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="95"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(297deg);transform:rotate(297deg)}md-progress-circular[value="95"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="95"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="96"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(300.6deg);transform:rotate(300.6deg)}md-progress-circular[value="96"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="96"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="97"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(304.2deg);transform:rotate(304.2deg)}md-progress-circular[value="97"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="97"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="98"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(307.8deg);transform:rotate(307.8deg)}md-progress-circular[value="98"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="98"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="99"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(311.4deg);transform:rotate(311.4deg)}md-progress-circular[value="99"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="99"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[value="100"] .md-inner .md-left .md-half-circle{transition:-webkit-transform .1s linear;transition:transform .1s linear;-webkit-transform:rotate(315deg);transform:rotate(315deg)}md-progress-circular[value="100"] .md-inner .md-right .md-half-circle{-webkit-transform:rotate(45deg);transform:rotate(45deg)}md-progress-circular[value="100"] .md-inner .md-gap{border-bottom-width:5px;border-bottom-style:solid;transition:border-bottom-color .1s linear}md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper{-webkit-animation:outer-rotate 2.91667s linear infinite;animation:outer-rotate 2.91667s linear infinite}md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper .md-inner{-webkit-animation:sporadic-rotate 5.25s cubic-bezier(.35,0,.25,1) infinite;animation:sporadic-rotate 5.25s cubic-bezier(.35,0,.25,1) infinite}md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper .md-inner .md-left .md-half-circle,md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper .md-inner .md-right .md-half-circle{-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-duration:1.3125s;animation-duration:1.3125s;-webkit-animation-timing-function:cubic-bezier(.35,0,.25,1);animation-timing-function:cubic-bezier(.35,0,.25,1)}md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper .md-inner .md-left .md-half-circle{-webkit-animation-name:left-wobble;animation-name:left-wobble}md-progress-circular[md-mode=indeterminate] .md-spinner-wrapper .md-inner .md-right .md-half-circle{-webkit-animation-name:right-wobble;animation-name:right-wobble}md-progress-linear{display:block;width:100%;height:5px}md-progress-linear .md-container{overflow:hidden;position:relative;height:5px;top:5px;-webkit-transform:translate(0,5px) scale(1,0);transform:translate(0,5px) scale(1,0);transition:all .3s linear}md-progress-linear .md-container.md-ready{-webkit-transform:translate(0,0) scale(1,1);transform:translate(0,0) scale(1,1)}md-progress-linear .md-bar{height:5px;position:absolute;width:100%}md-progress-linear .md-bar1,md-progress-linear .md-bar2{transition:all .2s linear}md-progress-linear[md-mode=determinate] .md-bar1{display:none}md-progress-linear[md-mode=indeterminate] .md-bar1{-webkit-animation:indeterminate1 4s infinite linear;animation:indeterminate1 4s infinite linear}md-progress-linear[md-mode=indeterminate] .md-bar2{-webkit-animation:indeterminate2 4s infinite linear;animation:indeterminate2 4s infinite linear}md-progress-linear[md-mode=buffer] .md-container{background-color:transparent!important}md-progress-linear[md-mode=buffer] .md-dashed:before{content:"";display:block;height:5px;width:100%;margin-top:0;position:absolute;background-color:transparent;background-size:10px 10px!important;background-position:0 -23px;-webkit-animation:buffer 3s infinite linear;animation:buffer 3s infinite linear}md-progress-linear[md-mode=query] .md-bar2{-webkit-animation:query .8s infinite cubic-bezier(.39,.575,.565,1);animation:query .8s infinite cubic-bezier(.39,.575,.565,1)}@-webkit-keyframes indeterminate1{0%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}10%{-webkit-transform:translateX(25%) scale(.5,1);transform:translateX(25%) scale(.5,1)}19.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}20%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}30%{-webkit-transform:translateX(37.5%) scale(.25,1);transform:translateX(37.5%) scale(.25,1)}34.99%,36.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}37%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}47%{-webkit-transform:translateX(20%) scale(.25,1);transform:translateX(20%) scale(.25,1)}52%{-webkit-transform:translateX(35%) scale(.05,1);transform:translateX(35%) scale(.05,1)}55%{-webkit-transform:translateX(35%) scale(.1,1);transform:translateX(35%) scale(.1,1)}58%{-webkit-transform:translateX(50%) scale(.1,1);transform:translateX(50%) scale(.1,1)}61.99%,69.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}70%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}80%{-webkit-transform:translateX(20%) scale(.25,1);transform:translateX(20%) scale(.25,1)}85%{-webkit-transform:translateX(35%) scale(.05,1);transform:translateX(35%) scale(.05,1)}88%{-webkit-transform:translateX(35%) scale(.1,1);transform:translateX(35%) scale(.1,1)}91%{-webkit-transform:translateX(50%) scale(.1,1);transform:translateX(50%) scale(.1,1)}92.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}93%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}100%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}}@keyframes indeterminate1{0%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}10%{-webkit-transform:translateX(25%) scale(.5,1);transform:translateX(25%) scale(.5,1)}19.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}20%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}30%{-webkit-transform:translateX(37.5%) scale(.25,1);transform:translateX(37.5%) scale(.25,1)}34.99%,36.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}37%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}47%{-webkit-transform:translateX(20%) scale(.25,1);transform:translateX(20%) scale(.25,1)}52%{-webkit-transform:translateX(35%) scale(.05,1);transform:translateX(35%) scale(.05,1)}55%{-webkit-transform:translateX(35%) scale(.1,1);transform:translateX(35%) scale(.1,1)}58%{-webkit-transform:translateX(50%) scale(.1,1);transform:translateX(50%) scale(.1,1)}61.99%,69.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}70%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}80%{-webkit-transform:translateX(20%) scale(.25,1);transform:translateX(20%) scale(.25,1)}85%{-webkit-transform:translateX(35%) scale(.05,1);transform:translateX(35%) scale(.05,1)}88%{-webkit-transform:translateX(35%) scale(.1,1);transform:translateX(35%) scale(.1,1)}91%{-webkit-transform:translateX(50%) scale(.1,1);transform:translateX(50%) scale(.1,1)}92.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}93%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}100%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}}@-webkit-keyframes indeterminate2{0%,25.99%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}28%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}38%{-webkit-transform:translateX(37.5%) scale(.25,1);transform:translateX(37.5%) scale(.25,1)}42.99%,46.99%,49.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}50%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}60%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}70%{-webkit-transform:translateX(25%) scale(.5,1);transform:translateX(25%) scale(.5,1)}79.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}}@keyframes indeterminate2{0%,25.99%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}28%{-webkit-transform:translateX(-37.5%) scale(.25,1);transform:translateX(-37.5%) scale(.25,1)}38%{-webkit-transform:translateX(37.5%) scale(.25,1);transform:translateX(37.5%) scale(.25,1)}42.99%,46.99%,49.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}50%{-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}60%{-webkit-transform:translateX(-25%) scale(.5,1);transform:translateX(-25%) scale(.5,1)}70%{-webkit-transform:translateX(25%) scale(.5,1);transform:translateX(25%) scale(.5,1)}79.99%{-webkit-transform:translateX(50%) scale(0,1);transform:translateX(50%) scale(0,1)}}@-webkit-keyframes query{0%{opacity:1;-webkit-transform:translateX(35%) scale(.3,1);transform:translateX(35%) scale(.3,1)}100%{opacity:0;-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}}@keyframes query{0%{opacity:1;-webkit-transform:translateX(35%) scale(.3,1);transform:translateX(35%) scale(.3,1)}100%{opacity:0;-webkit-transform:translateX(-50%) scale(0,1);transform:translateX(-50%) scale(0,1)}}@-webkit-keyframes buffer{0%{opacity:1;background-position:0 -23px}50%{opacity:0}100%{opacity:1;background-position:-200px -23px}}@keyframes buffer{0%{opacity:1;background-position:0 -23px}50%{opacity:0}100%{opacity:1;background-position:-200px -23px}}.md-switch-thumb,md-radio-button{display:block;margin:15px;white-space:nowrap;cursor:pointer}.md-switch-thumb input,md-radio-button input{display:none}.md-switch-thumb .md-container,md-radio-button .md-container{position:relative;top:4px;display:inline-block;width:16px;height:16px;cursor:pointer}.md-switch-thumb .md-container .md-ripple-container,md-radio-button .md-container .md-ripple-container{position:absolute;display:block;width:48px;height:48px;left:-16px;top:-16px}.md-switch-thumb .md-off,md-radio-button .md-off{position:absolute;top:0;left:0;width:16px;height:16px;border:2px solid;border-radius:50%;transition:border-color ease .28s}.md-switch-thumb .md-on,md-radio-button .md-on{position:absolute;top:0;left:0;width:16px;height:16px;border-radius:50%;transition:-webkit-transform ease .28s;transition:transform ease .28s;-webkit-transform:scale(0);transform:scale(0)}.md-switch-thumb.md-checked .md-on,md-radio-button.md-checked .md-on{-webkit-transform:scale(.55);transform:scale(.55)}.md-switch-thumb .md-label,md-radio-button .md-label{position:relative;display:inline-block;margin-left:10px;margin-right:10px;vertical-align:middle;white-space:normal;pointer-events:none;width:auto}.md-switch-thumb .circle,md-radio-button .circle{border-radius:50%}md-radio-group{border:1px dotted transparent;display:block;outline:0}.radioButtondemoBasicUsage md-radio-group{border:none}.md-select-menu-container{position:absolute;left:0;top:0;z-index:99;opacity:0}.md-select-menu-container:not(.md-clickable){pointer-events:none}.md-select-menu-container md-progress-circular{display:table;margin:24px auto!important}.md-select-menu-container.md-active{opacity:1}.md-select-menu-container.md-active md-select-menu{transition:-webkit-transform all .4s cubic-bezier(.25,.8,.25,1);transition:transform all .4s cubic-bezier(.25,.8,.25,1);transition-duration:200ms}.md-select-menu-container.md-active md-select-menu>*{opacity:1;transition:all .3s cubic-bezier(.55,0,.55,.2);transition-duration:200ms;transition-delay:100ms}.md-select-menu-container.md-leave{opacity:0;transition:all .3s cubic-bezier(.55,0,.55,.2);transition-duration:250ms}md-select{display:inline-block;margin-top:20px}md-select[disabled]:hover{cursor:default}md-select:not([disabled]):hover{cursor:pointer}md-select:not([disabled]):focus .md-select-label{border-bottom:2px solid;padding-bottom:7px}.md-select-label{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;padding-top:9px;padding-right:32px;padding-bottom:8px;border-bottom:1px solid;font-size:.875em;line-height:.8em;position:relative;box-sizing:border-box;min-width:64px}.md-select-label .md-select-icon:after{content:'\25BC';display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;position:absolute;height:100%;top:0;right:2px;speak:none;-webkit-transform:scaleY(.6) scaleX(1);transform:scaleY(.6) scaleX(1)}md-select-menu{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;box-shadow:0 2px 5px 0 rgba(0,0,0,.26);-webkit-transform-origin:0 0;transform-origin:0 0;-webkit-transform:scale(1);transform:scale(1);max-height:256px;overflow-y:scroll}md-select-menu.md-reverse{-webkit-flex-direction:column-reverse;-ms-flex-direction:column-reverse;flex-direction:column-reverse}md-select-menu:not(.md-overflow) md-content{padding-top:8px;padding-bottom:8px}md-select-menu md-content{min-width:136px}md-select-menu>*{opacity:0}md-option{cursor:pointer;position:relative;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;width:auto;padding:0 16px;height:48px}md-option .md-text{width:auto;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;font-size:.875em}md-optgroup{display:block}md-optgroup label{display:block;font-size:.75em;text-transform:uppercase;padding:16px 8px}md-optgroup md-option{padding-left:24px}md-sidenav{position:absolute;width:304px;min-width:304px;max-width:304px;bottom:0;z-index:60;background-color:#fff;overflow:auto;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column}md-sidenav.md-closed{display:none}md-sidenav.md-closed-add,md-sidenav.md-closed-remove{display:-webkit-flex;display:-ms-flexbox;display:flex;transition:0s all}md-sidenav.md-closed-add.md-closed-add-active,md-sidenav.md-closed-remove.md-closed-remove-active{transition:all .4s cubic-bezier(.25,.8,.25,1)}md-sidenav.md-locked-open-add,md-sidenav.md-locked-open-remove{position:static;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}md-sidenav.md-locked-open{width:304px;min-width:304px;max-width:304px}md-sidenav.md-locked-open,md-sidenav.md-locked-open-remove.md-closed,md-sidenav.md-locked-open.md-closed,md-sidenav.md-locked-open.md-closed.md-sidenav-left,md-sidenav.md-locked-open.md-closed.md-sidenav-right{position:static;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}md-sidenav.md-locked-open-remove-active{transition:width .3s cubic-bezier(.55,0,.55,.2),min-width .3s cubic-bezier(.55,0,.55,.2);width:0;min-width:0}md-sidenav.md-closed.md-locked-open-add{width:0;min-width:0;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}md-sidenav.md-closed.md-locked-open-add-active{transition:width .3s cubic-bezier(.55,0,.55,.2),min-width .3s cubic-bezier(.55,0,.55,.2);width:304px;min-width:304px;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.md-sidenav-backdrop.md-locked-open{display:none}.md-sidenav-left,md-sidenav{left:0;top:0;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.md-sidenav-left.md-closed,md-sidenav.md-closed{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.md-sidenav-right{left:100%;top:0;-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.md-sidenav-right.md-closed{-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}@media (max-width:360px){md-sidenav{width:85%}}@-webkit-keyframes sliderFocusThumb{0%{opacity:0;-webkit-transform:scale(0);transform:scale(0)}50%{-webkit-transform:scale(1);transform:scale(1);opacity:1}100%{opacity:0}}@keyframes sliderFocusThumb{0%{opacity:0;-webkit-transform:scale(0);transform:scale(0)}50%{-webkit-transform:scale(1);transform:scale(1);opacity:1}100%{opacity:0}}md-slider{height:48px;position:relative;display:block;margin-left:4px;margin-right:4px;padding:0}md-slider .md-slider-wrapper{position:relative}md-slider .md-track-container{width:100%;position:absolute;top:23px;height:2px}md-slider .md-track{position:absolute;left:0;right:0;height:100%}md-slider .md-track-fill{transition:width .05s linear}md-slider .md-track-ticks{position:absolute;left:0;right:0;height:100%}md-slider .md-thumb-container{position:absolute;left:0;top:50%;-webkit-transform:translate3d(-50%,-50%,0);transform:translate3d(-50%,-50%,0);transition:left .1s linear}md-slider .md-thumb{z-index:1;position:absolute;left:-19px;top:5px;width:38px;height:38px;border-radius:38px;-webkit-transform:scale(.5);transform:scale(.5);transition:all .1s linear}md-slider .md-thumb:after{content:'';position:absolute;left:3px;top:3px;width:32px;height:32px;border-radius:32px;border:3px solid}md-slider .md-sign{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;position:absolute;left:-14px;top:-20px;width:28px;height:28px;border-radius:28px;-webkit-transform:scale(.4) translate3d(0,70px,0);transform:scale(.4) translate3d(0,70px,0);transition:all .2s ease-in-out}md-slider .md-sign:after{position:absolute;content:'';left:0;border-radius:16px;top:19px;border-left:14px solid transparent;border-right:14px solid transparent;border-top:16px solid;opacity:0;-webkit-transform:translate3d(0,-8px,0);transform:translate3d(0,-8px,0);transition:all .2s ease-in-out}md-slider .md-sign .md-thumb-text{z-index:1;font-size:12px;font-weight:700}md-slider .md-focus-thumb{position:absolute;left:-24px;top:0;width:48px;height:48px;border-radius:48px;display:none;opacity:0;background-color:silver;-webkit-animation:sliderFocusThumb .4s linear;animation:sliderFocusThumb .4s linear}md-slider .md-focus-ring{position:absolute;left:-24px;top:0;width:48px;height:48px;border-radius:48px;border:2px solid #D6D6D6;background-color:transparent;-webkit-transform:scale(0);transform:scale(0);transition:all .2s linear}md-slider .md-disabled-thumb{position:absolute;left:-22px;top:2px;width:44px;height:44px;border-radius:44px;-webkit-transform:scale(.35);transform:scale(.35);border:6px solid;display:none}md-slider.md-min .md-thumb:after{background-color:#fff}md-slider.md-min .md-sign{opacity:0}md-slider:focus{outline:0}md-slider.dragging .md-thumb-container,md-slider.dragging .md-track-fill{transition:none}md-slider:not([md-discrete]) .md-sign,md-slider:not([md-discrete]) .md-track-ticks{display:none}md-slider:not([md-discrete]):not([disabled]):hover .md-thumb{-webkit-transform:scale(.6);transform:scale(.6)}md-slider:not([md-discrete]):not([disabled]).active .md-focus-thumb,md-slider:not([md-discrete]):not([disabled]):focus .md-focus-thumb{display:block}md-slider:not([md-discrete]):not([disabled]).active .md-focus-ring,md-slider:not([md-discrete]):not([disabled]):focus .md-focus-ring{-webkit-transform:scale(1);transform:scale(1)}md-slider:not([md-discrete]):not([disabled]).active .md-thumb,md-slider:not([md-discrete]):not([disabled]):focus .md-thumb{-webkit-transform:scale(.85);transform:scale(.85)}md-slider[md-discrete] .md-focus-ring,md-slider[md-discrete] .md-focus-thumb{display:none}md-slider[md-discrete]:not([disabled]).active .md-sign,md-slider[md-discrete]:not([disabled]).active .md-sign:after,md-slider[md-discrete]:not([disabled]):focus .md-sign,md-slider[md-discrete]:not([disabled]):focus .md-sign:after{opacity:1;-webkit-transform:translate3d(0,0,0) scale(1);transform:translate3d(0,0,0) scale(1)}md-slider[disabled] .md-sign,md-slider[disabled] .md-track-fill{display:none}md-slider[disabled] .md-thumb{-webkit-transform:scale(.35);transform:scale(.35)}md-slider[disabled] .md-disabled-thumb{display:block}.md-sticky-clone{z-index:2;top:0;left:0;right:0;position:absolute!important;-webkit-transform:translate3d(-9999px,-9999px,0);transform:translate3d(-9999px,-9999px,0)}.md-sticky-clone[sticky-state=active]{-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.md-sticky-clone[sticky-state=active]:not(.md-sticky-no-effect):after{-webkit-animation:subheaderStickyHoverIn .3s ease-out both;animation:subheaderStickyHoverIn .3s ease-out both}@-webkit-keyframes subheaderStickyHoverIn{0%{box-shadow:0 0 0 0 transparent}100%{box-shadow:0 2px 4px 0 rgba(0,0,0,.16)}}@keyframes subheaderStickyHoverIn{0%{box-shadow:0 0 0 0 transparent}100%{box-shadow:0 2px 4px 0 rgba(0,0,0,.16)}}@-webkit-keyframes subheaderStickyHoverOut{0%{box-shadow:0 2px 4px 0 rgba(0,0,0,.16)}100%{box-shadow:0 0 0 0 transparent}}@keyframes subheaderStickyHoverOut{0%{box-shadow:0 2px 4px 0 rgba(0,0,0,.16)}100%{box-shadow:0 0 0 0 transparent}}.md-subheader{display:block;font-size:.9em;font-weight:400;line-height:1em;padding:16px 0 16px 16px;margin:0 16px 0 0;position:relative}.md-subheader:not(.md-sticky-no-effect){transition:.2s ease-out margin}.md-subheader:not(.md-sticky-no-effect):after{position:absolute;left:0;bottom:0;top:0;right:-16px;content:''}.md-subheader:not(.md-sticky-no-effect).md-sticky-clone{z-index:2}.md-subheader:not(.md-sticky-no-effect)[sticky-state=active]{margin-top:-2px}.md-subheader:not(.md-sticky-no-effect):not(.md-sticky-clone)[sticky-prev-state=active]:after{-webkit-animation:subheaderStickyHoverOut .3s ease-out both;animation:subheaderStickyHoverOut .3s ease-out both}.md-subheader .md-subheader-content{z-index:1;position:relative}md-switch{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;margin:15px;white-space:nowrap;cursor:pointer;outline:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}md-switch .md-container{cursor:-webkit-grab;cursor:grab;width:36px;height:24px;position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;margin-right:8px}md-switch:not([disabled]) .md-dragging,md-switch:not([disabled]).md-dragging .md-container{cursor:-webkit-grabbing;cursor:grabbing}md-switch .md-label{border-color:transparent;border-width:0}md-switch .md-bar{left:1px;width:34px;top:5px;height:14px;border-radius:8px;position:absolute}md-switch .md-thumb-container{top:2px;left:0;width:16px;position:absolute;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);z-index:1}md-switch.md-checked .md-thumb-container{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}md-switch .md-thumb{position:absolute;margin:0;left:0;top:0;outline:0;height:20px;width:20px;border-radius:50%;box-shadow:0 2px 5px 0 rgba(0,0,0,.26)}md-switch .md-thumb .md-ripple-container{position:absolute;display:block;width:auto;height:auto;left:-20px;top:-20px;right:-20px;bottom:-20px}md-switch:not(.md-dragging) .md-bar,md-switch:not(.md-dragging) .md-thumb,md-switch:not(.md-dragging) .md-thumb-container{transition:all .5s cubic-bezier(.35,0,.25,1);transition-property:-webkit-transform,background-color;transition-property:transform,background-color}md-switch:not(.md-dragging) .md-bar,md-switch:not(.md-dragging) .md-thumb{transition-delay:.05s}md-tabs{display:block;width:100%;font-weight:500;overflow:auto}.md-header{width:100%;height:48px;box-sizing:border-box;position:relative}.md-paginator{z-index:1;margin-right:-2px;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;width:32px;min-height:100%;cursor:pointer;border:none;background-color:transparent;background-repeat:no-repeat;background-position:center center;position:absolute}.md-paginator.md-prev{left:0}.md-paginator.md-next{right:0}.md-paginator.md-next md-icon{-webkit-transform:rotate(180deg);transform:rotate(180deg)}md-tabs[center] .md-header:not(.md-paginating) .md-header-items{-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center}.md-paginating .md-header-items-container{left:32px;right:32px}.md-header-items-container{overflow:hidden;position:absolute;left:0;right:0;height:100%;white-space:nowrap;font-size:14px;font-weight:500;text-transform:uppercase;margin:auto}.md-header-items-container .md-header-items{display:-webkit-flex;display:-ms-flexbox;display:flex;box-sizing:border-box;transition:-webkit-transform .5s cubic-bezier(.35,0,.25,1);transition:transform .5s cubic-bezier(.35,0,.25,1);-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);height:100%;width:99999px}.md-tabs-content{overflow:hidden;width:100%;position:relative}.md-tabs-content .md-tab-content{height:100%}.md-tabs-content .md-tab-content.ng-hide.ng-animate{display:block!important}.md-tabs-content .md-tab-content.ng-animate{transition:-webkit-transform .5s cubic-bezier(.35,0,.25,1);transition:transform .5s cubic-bezier(.35,0,.25,1);-webkit-transform:translateX(0);transform:translateX(0)}.md-tabs-content .md-tab-content.ng-animate.ng-hide-add{-webkit-transform:translateX(-100%);transform:translateX(-100%)}.md-tabs-content .md-tab-content.ng-animate.ng-hide-add.md-transition-rtl{-webkit-transform:translateX(100%);transform:translateX(100%)}.md-tabs-content .md-tab-content.ng-animate.ng-hide-remove{position:absolute;-webkit-transform:translateX(100%);transform:translateX(100%);top:0;left:0;right:0;bottom:0}.md-tabs-content .md-tab-content.ng-animate.ng-hide-remove.md-transition-rtl{-webkit-transform:translateX(-100%);transform:translateX(-100%)}.md-tabs-content .md-tab-content.ng-animate.ng-hide-remove.ng-hide-remove-active{-webkit-transform:translateX(0);transform:translateX(0)}md-tabs-ink-bar{z-index:1;display:none;position:absolute;left:0;bottom:0;box-sizing:border-box;height:2px;margin-top:-2px;-webkit-transform:scaleX(1);transform:scaleX(1);-webkit-transform-origin:0 0;transform-origin:0 0}md-tabs-ink-bar.md-transition-right{transition:right .25s cubic-bezier(.35,0,.25,1),left .25s cubic-bezier(.35,0,.25,1) .075s}md-tabs-ink-bar.md-transition-left{transition:right .25s cubic-bezier(.35,0,.25,1) .075s,left .25s cubic-bezier(.35,0,.25,1)}md-tab{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;position:relative;z-index:0;overflow:hidden;height:100%;text-align:center;cursor:pointer;padding:20px 24px;box-sizing:border-box;transition:none;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}md-tab.md-tab-themed{transition:background .35s cubic-bezier(.35,0,.25,1),color .35s cubic-bezier(.35,0,.25,1)}md-tab[disabled]{pointer-events:none;cursor:default}md-tab:focus{outline:0}md-tab md-tab-label{-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;z-index:100;opacity:1;overflow:hidden}.md-input-group label,md-input-group label{display:block}.md-input-group input[type=text],.md-input-group input[type=password],.md-input-group input[type=datetime],.md-input-group input[type=datetime-local],.md-input-group input[type=date],.md-input-group input[type=month],.md-input-group input[type=time],.md-input-group input[type=search],.md-input-group input[type=week],.md-input-group input[type=number],.md-input-group input[type=email],.md-input-group input[type=url],.md-input-group input[type=tel],.md-input-group input[type=color],.md-input-group textarea,md-input-group input[type=text],md-input-group input[type=password],md-input-group input[type=datetime],md-input-group input[type=datetime-local],md-input-group input[type=date],md-input-group input[type=month],md-input-group input[type=time],md-input-group input[type=search],md-input-group input[type=week],md-input-group input[type=number],md-input-group input[type=email],md-input-group input[type=url],md-input-group input[type=tel],md-input-group input[type=color],md-input-group textarea{display:block;border-width:0 0 1px;padding-top:2px;line-height:26px;padding-bottom:1px}.md-input-group input[type=text]:focus,.md-input-group input[type=password]:focus,.md-input-group input[type=datetime]:focus,.md-input-group input[type=datetime-local]:focus,.md-input-group input[type=date]:focus,.md-input-group input[type=month]:focus,.md-input-group input[type=time]:focus,.md-input-group input[type=search]:focus,.md-input-group input[type=week]:focus,.md-input-group input[type=number]:focus,.md-input-group input[type=email]:focus,.md-input-group input[type=url]:focus,.md-input-group input[type=tel]:focus,.md-input-group input[type=color]:focus,.md-input-group textarea:focus,md-input-group input[type=text]:focus,md-input-group input[type=password]:focus,md-input-group input[type=datetime]:focus,md-input-group input[type=datetime-local]:focus,md-input-group input[type=date]:focus,md-input-group input[type=month]:focus,md-input-group input[type=time]:focus,md-input-group input[type=search]:focus,md-input-group input[type=week]:focus,md-input-group input[type=number]:focus,md-input-group input[type=email]:focus,md-input-group input[type=url]:focus,md-input-group input[type=tel]:focus,md-input-group input[type=color]:focus,md-input-group textarea:focus{outline:0}.md-input-group input,.md-input-group textarea,md-input-group input,md-input-group textarea{background:0 0}.md-input-group,md-input-group{padding-bottom:2px;margin:10px 0 8px;position:relative;display:block}.md-input-group label,md-input-group label{font-size:1em;z-index:1;pointer-events:none;-webkit-font-smoothing:antialiased}.md-input-group label:hover,md-input-group label:hover{cursor:text}.md-input-group label,md-input-group label{-webkit-transform:translate3d(0,22px,0);transform:translate3d(0,22px,0);-webkit-transform-origin:left center;transform-origin:left center;transition:all .15s cubic-bezier(.35,0,.25,1)}.md-input-group input,.md-input-group textarea,md-input-group input,md-input-group textarea{border-bottom-width:1px;transition:all .15s cubic-bezier(.35,0,.25,1)}.md-input-group.md-input-focused label,md-input-group.md-input-focused label{-webkit-transform:translate3d(0,4px,0) scale(.75);transform:translate3d(0,4px,0) scale(.75)}.md-input-group.md-input-focused input,.md-input-group.md-input-focused textarea,md-input-group.md-input-focused input,md-input-group.md-input-focused textarea{border-bottom-width:2px}.md-input-group.md-input-focused input,md-input-group.md-input-focused input{padding-bottom:0}.md-input-group.md-input-has-value label,.md-input-group.md-input-has-value:not(.md-input-focused) label,md-input-group.md-input-has-value label,md-input-group.md-input-has-value:not(.md-input-focused) label{-webkit-transform:translate3d(0,4px,0) scale(.75);transform:translate3d(0,4px,0) scale(.75)}.md-input-group[disabled] input,.md-input-group[disabled] textarea,md-input-group[disabled] input,md-input-group[disabled] textarea{border-bottom-width:0;background-position:0 bottom;background-size:2px 1px;background-repeat:repeat-x;pointer-events:none}.md-input-group[disabled] label,md-input-group[disabled] label{-webkit-transform:translate3d(0,4px,0) scale(.75);transform:translate3d(0,4px,0) scale(.75)}.md-input-group[disabled] :not(.md-input-has-value) label,md-input-group[disabled] :not(.md-input-has-value) label{-webkit-transform:translate3d(0,22px,0);transform:translate3d(0,22px,0);-webkit-transform-origin:left center;transform-origin:left center;transition:all .15s cubic-bezier(.35,0,.25,1)}md-toast{display:-webkit-flex;display:-ms-flexbox;display:flex;position:absolute;box-sizing:border-box;-webkit-align-items:center;-ms-flex-align:center;align-items:center;min-height:48px;padding-left:24px;padding-right:24px;box-shadow:0 2px 5px 0 rgba(0,0,0,.26);border-radius:2px;font-size:14px;cursor:default;max-width:879px;max-height:40px;height:24px;z-index:90;opacity:1;-webkit-transform:translate3d(0,0,0) rotateZ(0deg);transform:translate3d(0,0,0) rotateZ(0deg);transition:all .4s cubic-bezier(.25,.8,.25,1)}md-toast.md-capsule{border-radius:24px}md-toast.ng-leave-active{transition:all .3s cubic-bezier(.55,0,.55,.2)}md-toast.md-swipedown,md-toast.md-swipeleft,md-toast.md-swiperight,md-toast.md-swipeup{transition:all .4s cubic-bezier(.25,.8,.25,1)}md-toast.ng-enter{-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0);opacity:0}md-toast.ng-enter.md-top{-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}md-toast.ng-enter.ng-enter-active{-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0);opacity:1}md-toast.ng-leave.ng-leave-active{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}md-toast.ng-leave.ng-leave-active.md-top{-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}md-toast.ng-leave.ng-leave-active.md-swipeleft{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}md-toast.ng-leave.ng-leave-active.md-swiperight{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}md-toast .md-action{line-height:19px;margin-left:24px;cursor:pointer;text-transform:uppercase;float:right}@media (max-width:600px){md-toast{left:0;right:0;width:100%;max-width:100%;min-width:0;border-radius:0;bottom:0}md-toast.md-top{bottom:auto;top:0}}@media (min-width:600px){md-toast{min-width:288px}md-toast.md-bottom{bottom:8px}md-toast.md-left{left:8px}md-toast.md-right{right:8px}md-toast.md-top{top:8px}md-toast.ng-leave.ng-leave-active.md-swipeleft{-webkit-transform:translate3d(-100%,25%,0) rotateZ(-15deg);transform:translate3d(-100%,25%,0) rotateZ(-15deg)}md-toast.ng-leave.ng-leave-active.md-swiperight{-webkit-transform:translate3d(100%,25%,0) rotateZ(15deg);transform:translate3d(100%,25%,0) rotateZ(15deg)}md-toast.ng-leave.ng-leave-active.md-top.md-swipeleft{-webkit-transform:translate3d(-100%,0,0) rotateZ(-15deg);transform:translate3d(-100%,0,0) rotateZ(-15deg)}md-toast.ng-leave.ng-leave-active.md-top.md-swiperight{-webkit-transform:translate3d(100%,0,0) rotateZ(15deg);transform:translate3d(100%,0,0) rotateZ(15deg)}}md-toolbar{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;position:relative;z-index:2;font-size:1.3em;min-height:64px;width:100%;box-shadow:0 2px 5px 0 rgba(0,0,0,.26)}md-toolbar.md-tall{height:128px;min-height:128px;max-height:128px}md-toolbar.md-medium-tall{height:88px;min-height:88px;max-height:88px}md-toolbar.md-medium-tall .md-toolbar-tools{height:48px;min-height:48px;max-height:48px}md-toolbar .md-indent{margin-left:64px}.md-toolbar-tools{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;width:100%;height:64px;max-height:64px;font-size:inherit;font-weight:400;padding:0 16px;margin:0}.md-toolbar-tools>*{font-size:inherit}.md-toolbar-tools h2,.md-toolbar-tools h3{font-weight:400}.md-toolbar-tools a{color:inherit;text-decoration:none}.md-toolbar-tools .fill-height{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-align-items:center;-ms-flex-align:center;align-items:center}.md-toolbar-tools .md-tools{margin-left:auto}.md-toolbar-tools .md-button{font-size:14px}md-tooltip{position:absolute;font-size:14px;z-index:100;overflow:hidden;pointer-events:none;border-radius:4px}md-tooltip .md-background{position:absolute;border-radius:50%;-webkit-transform:translate(-50%,-50%) scale(0);transform:translate(-50%,-50%) scale(0);opacity:1}md-tooltip .md-background.md-show-add{transition:all .4s cubic-bezier(.25,.8,.25,1);-webkit-transform:translate(-50%,-50%) scale(0);transform:translate(-50%,-50%) scale(0);opacity:0}md-tooltip .md-background.md-show,md-tooltip .md-background.md-show-add-active{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1);opacity:1}md-tooltip .md-background.md-show-remove{transition:all .3s cubic-bezier(.55,0,.55,.2)}md-tooltip .md-background.md-show-remove.md-show-remove-active{-webkit-transform:translate(-50%,-50%) scale(0);transform:translate(-50%,-50%) scale(0);opacity:0}md-tooltip .md-content{position:relative;max-width:240px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;padding:8px;background:0 0;opacity:0}md-tooltip .md-content.md-show-add{transition:all .4s cubic-bezier(.25,.8,.25,1);opacity:0}md-tooltip .md-content.md-show,md-tooltip .md-content.md-show-add-active{opacity:1}md-tooltip .md-content.md-show-remove{transition:all .3s cubic-bezier(.55,0,.55,.2)}md-tooltip .md-content.md-show-remove.md-show-remove-active{opacity:0}md-tooltip.md-hide{transition:all .3s cubic-bezier(.55,0,.55,.2)}md-tooltip.md-show{transition:all .4s cubic-bezier(.25,.8,.25,1);pointer-events:auto;-webkit-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.md-whiteframe-z1{box-shadow:0 2px 5px 0 rgba(0,0,0,.26)}.md-whiteframe-z2{box-shadow:0 8px 17px rgba(0,0,0,.2)}.md-whiteframe-z3{box-shadow:0 17px 50px rgba(0,0,0,.19)}.md-whiteframe-z4{box-shadow:0 16px 28px 0 rgba(0,0,0,.22)}.md-whiteframe-z5{box-shadow:0 27px 24px 0 rgba(0,0,0,.2)}`)

func www_app_vendor_angular_material_angular_material_css_bytes() ([]byte, error) {
	return _www_app_vendor_angular_material_angular_material_css, nil
}

func www_app_vendor_angular_material_angular_material_css() (*asset, error) {
	bytes, err := www_app_vendor_angular_material_angular_material_css_bytes()
	if err != nil {
		return nil, err
	}

	info := bindata_file_info{name: "www/app/vendor/angular-material/angular-material.css", size: 159606, mode: os.FileMode(436), modTime: time.Unix(1430492237, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _www_app_vendor_d3_d3_min_js = []byte(`!function(){function n(n){return n&&(n.ownerDocument||n.document||n).documentElement}function t(n){return n&&(n.ownerDocument&&n.ownerDocument.defaultView||n.document&&n||n.defaultView)}function e(n,t){return t>n?-1:n>t?1:n>=t?0:0/0}function r(n){return null===n?0/0:+n}function u(n){return!isNaN(n)}function i(n){return{left:function(t,e,r,u){for(arguments.length<3&&(r=0),arguments.length<4&&(u=t.length);u>r;){var i=r+u>>>1;n(t[i],e)<0?r=i+1:u=i}return r},right:function(t,e,r,u){for(arguments.length<3&&(r=0),arguments.length<4&&(u=t.length);u>r;){var i=r+u>>>1;n(t[i],e)>0?u=i:r=i+1}return r}}}function o(n){return n.length}function a(n){for(var t=1;n*t%1;)t*=10;return t}function c(n,t){for(var e in t)Object.defineProperty(n.prototype,e,{value:t[e],enumerable:!1})}function l(){this._=Object.create(null)}function s(n){return(n+="")===pa||n[0]===va?va+n:n}function f(n){return(n+="")[0]===va?n.slice(1):n}function h(n){return s(n)in this._}function g(n){return(n=s(n))in this._&&delete this._[n]}function p(){var n=[];for(var t in this._)n.push(f(t));return n}function v(){var n=0;for(var t in this._)++n;return n}function d(){for(var n in this._)return!1;return!0}function m(){this._=Object.create(null)}function y(n){return n}function M(n,t,e){return function(){var r=e.apply(t,arguments);return r===t?n:r}}function x(n,t){if(t in n)return t;t=t.charAt(0).toUpperCase()+t.slice(1);for(var e=0,r=da.length;r>e;++e){var u=da[e]+t;if(u in n)return u}}function b(){}function _(){}function w(n){function t(){for(var t,r=e,u=-1,i=r.length;++u<i;)(t=r[u].on)&&t.apply(this,arguments);return n}var e=[],r=new l;return t.on=function(t,u){var i,o=r.get(t);return arguments.length<2?o&&o.on:(o&&(o.on=null,e=e.slice(0,i=e.indexOf(o)).concat(e.slice(i+1)),r.remove(t)),u&&e.push(r.set(t,{on:u})),n)},t}function S(){ta.event.preventDefault()}function k(){for(var n,t=ta.event;n=t.sourceEvent;)t=n;return t}function E(n){for(var t=new _,e=0,r=arguments.length;++e<r;)t[arguments[e]]=w(t);return t.of=function(e,r){return function(u){try{var i=u.sourceEvent=ta.event;u.target=n,ta.event=u,t[u.type].apply(e,r)}finally{ta.event=i}}},t}function A(n){return ya(n,_a),n}function N(n){return"function"==typeof n?n:function(){return Ma(n,this)}}function C(n){return"function"==typeof n?n:function(){return xa(n,this)}}function z(n,t){function e(){this.removeAttribute(n)}function r(){this.removeAttributeNS(n.space,n.local)}function u(){this.setAttribute(n,t)}function i(){this.setAttributeNS(n.space,n.local,t)}function o(){var e=t.apply(this,arguments);null==e?this.removeAttribute(n):this.setAttribute(n,e)}function a(){var e=t.apply(this,arguments);null==e?this.removeAttributeNS(n.space,n.local):this.setAttributeNS(n.space,n.local,e)}return n=ta.ns.qualify(n),null==t?n.local?r:e:"function"==typeof t?n.local?a:o:n.local?i:u}function q(n){return n.trim().replace(/\s+/g," ")}function L(n){return new RegExp("(?:^|\\s+)"+ta.requote(n)+"(?:\\s+|$)","g")}function T(n){return(n+"").trim().split(/^|\s+/)}function R(n,t){function e(){for(var e=-1;++e<u;)n[e](this,t)}function r(){for(var e=-1,r=t.apply(this,arguments);++e<u;)n[e](this,r)}n=T(n).map(D);var u=n.length;return"function"==typeof t?r:e}function D(n){var t=L(n);return function(e,r){if(u=e.classList)return r?u.add(n):u.remove(n);var u=e.getAttribute("class")||"";r?(t.lastIndex=0,t.test(u)||e.setAttribute("class",q(u+" "+n))):e.setAttribute("class",q(u.replace(t," ")))}}function P(n,t,e){function r(){this.style.removeProperty(n)}function u(){this.style.setProperty(n,t,e)}function i(){var r=t.apply(this,arguments);null==r?this.style.removeProperty(n):this.style.setProperty(n,r,e)}return null==t?r:"function"==typeof t?i:u}function U(n,t){function e(){delete this[n]}function r(){this[n]=t}function u(){var e=t.apply(this,arguments);null==e?delete this[n]:this[n]=e}return null==t?e:"function"==typeof t?u:r}function j(n){function t(){var t=this.ownerDocument,e=this.namespaceURI;return e?t.createElementNS(e,n):t.createElement(n)}function e(){return this.ownerDocument.createElementNS(n.space,n.local)}return"function"==typeof n?n:(n=ta.ns.qualify(n)).local?e:t}function F(){var n=this.parentNode;n&&n.removeChild(this)}function H(n){return{__data__:n}}function O(n){return function(){return ba(this,n)}}function I(n){return arguments.length||(n=e),function(t,e){return t&&e?n(t.__data__,e.__data__):!t-!e}}function Y(n,t){for(var e=0,r=n.length;r>e;e++)for(var u,i=n[e],o=0,a=i.length;a>o;o++)(u=i[o])&&t(u,o,e);return n}function Z(n){return ya(n,Sa),n}function V(n){var t,e;return function(r,u,i){var o,a=n[i].update,c=a.length;for(i!=e&&(e=i,t=0),u>=t&&(t=u+1);!(o=a[t])&&++t<c;);return o}}function X(n,t,e){function r(){var t=this[o];t&&(this.removeEventListener(n,t,t.$),delete this[o])}function u(){var u=c(t,ra(arguments));r.call(this),this.addEventListener(n,this[o]=u,u.$=e),u._=t}function i(){var t,e=new RegExp("^__on([^.]+)"+ta.requote(n)+"$");for(var r in this)if(t=r.match(e)){var u=this[r];this.removeEventListener(t[1],u,u.$),delete this[r]}}var o="__on"+n,a=n.indexOf("."),c=$;a>0&&(n=n.slice(0,a));var l=ka.get(n);return l&&(n=l,c=B),a?t?u:r:t?b:i}function $(n,t){return function(e){var r=ta.event;ta.event=e,t[0]=this.__data__;try{n.apply(this,t)}finally{ta.event=r}}}function B(n,t){var e=$(n,t);return function(n){var t=this,r=n.relatedTarget;r&&(r===t||8&r.compareDocumentPosition(t))||e.call(t,n)}}function W(e){var r=".dragsuppress-"+ ++Aa,u="click"+r,i=ta.select(t(e)).on("touchmove"+r,S).on("dragstart"+r,S).on("selectstart"+r,S);if(null==Ea&&(Ea="onselectstart"in e?!1:x(e.style,"userSelect")),Ea){var o=n(e).style,a=o[Ea];o[Ea]="none"}return function(n){if(i.on(r,null),Ea&&(o[Ea]=a),n){var t=function(){i.on(u,null)};i.on(u,function(){S(),t()},!0),setTimeout(t,0)}}}function J(n,e){e.changedTouches&&(e=e.changedTouches[0]);var r=n.ownerSVGElement||n;if(r.createSVGPoint){var u=r.createSVGPoint();if(0>Na){var i=t(n);if(i.scrollX||i.scrollY){r=ta.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important");var o=r[0][0].getScreenCTM();Na=!(o.f||o.e),r.remove()}}return Na?(u.x=e.pageX,u.y=e.pageY):(u.x=e.clientX,u.y=e.clientY),u=u.matrixTransform(n.getScreenCTM().inverse()),[u.x,u.y]}var a=n.getBoundingClientRect();return[e.clientX-a.left-n.clientLeft,e.clientY-a.top-n.clientTop]}function G(){return ta.event.changedTouches[0].identifier}function K(n){return n>0?1:0>n?-1:0}function Q(n,t,e){return(t[0]-n[0])*(e[1]-n[1])-(t[1]-n[1])*(e[0]-n[0])}function nt(n){return n>1?0:-1>n?qa:Math.acos(n)}function tt(n){return n>1?Ra:-1>n?-Ra:Math.asin(n)}function et(n){return((n=Math.exp(n))-1/n)/2}function rt(n){return((n=Math.exp(n))+1/n)/2}function ut(n){return((n=Math.exp(2*n))-1)/(n+1)}function it(n){return(n=Math.sin(n/2))*n}function ot(){}function at(n,t,e){return this instanceof at?(this.h=+n,this.s=+t,void(this.l=+e)):arguments.length<2?n instanceof at?new at(n.h,n.s,n.l):bt(""+n,_t,at):new at(n,t,e)}function ct(n,t,e){function r(n){return n>360?n-=360:0>n&&(n+=360),60>n?i+(o-i)*n/60:180>n?o:240>n?i+(o-i)*(240-n)/60:i}function u(n){return Math.round(255*r(n))}var i,o;return n=isNaN(n)?0:(n%=360)<0?n+360:n,t=isNaN(t)?0:0>t?0:t>1?1:t,e=0>e?0:e>1?1:e,o=.5>=e?e*(1+t):e+t-e*t,i=2*e-o,new mt(u(n+120),u(n),u(n-120))}function lt(n,t,e){return this instanceof lt?(this.h=+n,this.c=+t,void(this.l=+e)):arguments.length<2?n instanceof lt?new lt(n.h,n.c,n.l):n instanceof ft?gt(n.l,n.a,n.b):gt((n=wt((n=ta.rgb(n)).r,n.g,n.b)).l,n.a,n.b):new lt(n,t,e)}function st(n,t,e){return isNaN(n)&&(n=0),isNaN(t)&&(t=0),new ft(e,Math.cos(n*=Da)*t,Math.sin(n)*t)}function ft(n,t,e){return this instanceof ft?(this.l=+n,this.a=+t,void(this.b=+e)):arguments.length<2?n instanceof ft?new ft(n.l,n.a,n.b):n instanceof lt?st(n.h,n.c,n.l):wt((n=mt(n)).r,n.g,n.b):new ft(n,t,e)}function ht(n,t,e){var r=(n+16)/116,u=r+t/500,i=r-e/200;return u=pt(u)*Xa,r=pt(r)*$a,i=pt(i)*Ba,new mt(dt(3.2404542*u-1.5371385*r-.4985314*i),dt(-.969266*u+1.8760108*r+.041556*i),dt(.0556434*u-.2040259*r+1.0572252*i))}function gt(n,t,e){return n>0?new lt(Math.atan2(e,t)*Pa,Math.sqrt(t*t+e*e),n):new lt(0/0,0/0,n)}function pt(n){return n>.206893034?n*n*n:(n-4/29)/7.787037}function vt(n){return n>.008856?Math.pow(n,1/3):7.787037*n+4/29}function dt(n){return Math.round(255*(.00304>=n?12.92*n:1.055*Math.pow(n,1/2.4)-.055))}function mt(n,t,e){return this instanceof mt?(this.r=~~n,this.g=~~t,void(this.b=~~e)):arguments.length<2?n instanceof mt?new mt(n.r,n.g,n.b):bt(""+n,mt,ct):new mt(n,t,e)}function yt(n){return new mt(n>>16,n>>8&255,255&n)}function Mt(n){return yt(n)+""}function xt(n){return 16>n?"0"+Math.max(0,n).toString(16):Math.min(255,n).toString(16)}function bt(n,t,e){var r,u,i,o=0,a=0,c=0;if(r=/([a-z]+)\((.*)\)/i.exec(n))switch(u=r[2].split(","),r[1]){case"hsl":return e(parseFloat(u[0]),parseFloat(u[1])/100,parseFloat(u[2])/100);case"rgb":return t(kt(u[0]),kt(u[1]),kt(u[2]))}return(i=Ga.get(n.toLowerCase()))?t(i.r,i.g,i.b):(null==n||"#"!==n.charAt(0)||isNaN(i=parseInt(n.slice(1),16))||(4===n.length?(o=(3840&i)>>4,o=o>>4|o,a=240&i,a=a>>4|a,c=15&i,c=c<<4|c):7===n.length&&(o=(16711680&i)>>16,a=(65280&i)>>8,c=255&i)),t(o,a,c))}function _t(n,t,e){var r,u,i=Math.min(n/=255,t/=255,e/=255),o=Math.max(n,t,e),a=o-i,c=(o+i)/2;return a?(u=.5>c?a/(o+i):a/(2-o-i),r=n==o?(t-e)/a+(e>t?6:0):t==o?(e-n)/a+2:(n-t)/a+4,r*=60):(r=0/0,u=c>0&&1>c?0:r),new at(r,u,c)}function wt(n,t,e){n=St(n),t=St(t),e=St(e);var r=vt((.4124564*n+.3575761*t+.1804375*e)/Xa),u=vt((.2126729*n+.7151522*t+.072175*e)/$a),i=vt((.0193339*n+.119192*t+.9503041*e)/Ba);return ft(116*u-16,500*(r-u),200*(u-i))}function St(n){return(n/=255)<=.04045?n/12.92:Math.pow((n+.055)/1.055,2.4)}function kt(n){var t=parseFloat(n);return"%"===n.charAt(n.length-1)?Math.round(2.55*t):t}function Et(n){return"function"==typeof n?n:function(){return n}}function At(n){return function(t,e,r){return 2===arguments.length&&"function"==typeof e&&(r=e,e=null),Nt(t,e,n,r)}}function Nt(n,t,e,r){function u(){var n,t=c.status;if(!t&&zt(c)||t>=200&&300>t||304===t){try{n=e.call(i,c)}catch(r){return void o.error.call(i,r)}o.load.call(i,n)}else o.error.call(i,c)}var i={},o=ta.dispatch("beforesend","progress","load","error"),a={},c=new XMLHttpRequest,l=null;return!this.XDomainRequest||"withCredentials"in c||!/^(http(s)?:)?\/\//.test(n)||(c=new XDomainRequest),"onload"in c?c.onload=c.onerror=u:c.onreadystatechange=function(){c.readyState>3&&u()},c.onprogress=function(n){var t=ta.event;ta.event=n;try{o.progress.call(i,c)}finally{ta.event=t}},i.header=function(n,t){return n=(n+"").toLowerCase(),arguments.length<2?a[n]:(null==t?delete a[n]:a[n]=t+"",i)},i.mimeType=function(n){return arguments.length?(t=null==n?null:n+"",i):t},i.responseType=function(n){return arguments.length?(l=n,i):l},i.response=function(n){return e=n,i},["get","post"].forEach(function(n){i[n]=function(){return i.send.apply(i,[n].concat(ra(arguments)))}}),i.send=function(e,r,u){if(2===arguments.length&&"function"==typeof r&&(u=r,r=null),c.open(e,n,!0),null==t||"accept"in a||(a.accept=t+",*/*"),c.setRequestHeader)for(var s in a)c.setRequestHeader(s,a[s]);return null!=t&&c.overrideMimeType&&c.overrideMimeType(t),null!=l&&(c.responseType=l),null!=u&&i.on("error",u).on("load",function(n){u(null,n)}),o.beforesend.call(i,c),c.send(null==r?null:r),i},i.abort=function(){return c.abort(),i},ta.rebind(i,o,"on"),null==r?i:i.get(Ct(r))}function Ct(n){return 1===n.length?function(t,e){n(null==t?e:null)}:n}function zt(n){var t=n.responseType;return t&&"text"!==t?n.response:n.responseText}function qt(){var n=Lt(),t=Tt()-n;t>24?(isFinite(t)&&(clearTimeout(tc),tc=setTimeout(qt,t)),nc=0):(nc=1,rc(qt))}function Lt(){var n=Date.now();for(ec=Ka;ec;)n>=ec.t&&(ec.f=ec.c(n-ec.t)),ec=ec.n;return n}function Tt(){for(var n,t=Ka,e=1/0;t;)t.f?t=n?n.n=t.n:Ka=t.n:(t.t<e&&(e=t.t),t=(n=t).n);return Qa=n,e}function Rt(n,t){return t-(n?Math.ceil(Math.log(n)/Math.LN10):1)}function Dt(n,t){var e=Math.pow(10,3*ga(8-t));return{scale:t>8?function(n){return n/e}:function(n){return n*e},symbol:n}}function Pt(n){var t=n.decimal,e=n.thousands,r=n.grouping,u=n.currency,i=r&&e?function(n,t){for(var u=n.length,i=[],o=0,a=r[0],c=0;u>0&&a>0&&(c+a+1>t&&(a=Math.max(1,t-c)),i.push(n.substring(u-=a,u+a)),!((c+=a+1)>t));)a=r[o=(o+1)%r.length];return i.reverse().join(e)}:y;return function(n){var e=ic.exec(n),r=e[1]||" ",o=e[2]||">",a=e[3]||"-",c=e[4]||"",l=e[5],s=+e[6],f=e[7],h=e[8],g=e[9],p=1,v="",d="",m=!1,y=!0;switch(h&&(h=+h.substring(1)),(l||"0"===r&&"="===o)&&(l=r="0",o="="),g){case"n":f=!0,g="g";break;case"%":p=100,d="%",g="f";break;case"p":p=100,d="%",g="r";break;case"b":case"o":case"x":case"X":"#"===c&&(v="0"+g.toLowerCase());case"c":y=!1;case"d":m=!0,h=0;break;case"s":p=-1,g="r"}"$"===c&&(v=u[0],d=u[1]),"r"!=g||h||(g="g"),null!=h&&("g"==g?h=Math.max(1,Math.min(21,h)):("e"==g||"f"==g)&&(h=Math.max(0,Math.min(20,h)))),g=oc.get(g)||Ut;var M=l&&f;return function(n){var e=d;if(m&&n%1)return"";var u=0>n||0===n&&0>1/n?(n=-n,"-"):"-"===a?"":a;if(0>p){var c=ta.formatPrefix(n,h);n=c.scale(n),e=c.symbol+d}else n*=p;n=g(n,h);var x,b,_=n.lastIndexOf(".");if(0>_){var w=y?n.lastIndexOf("e"):-1;0>w?(x=n,b=""):(x=n.substring(0,w),b=n.substring(w))}else x=n.substring(0,_),b=t+n.substring(_+1);!l&&f&&(x=i(x,1/0));var S=v.length+x.length+b.length+(M?0:u.length),k=s>S?new Array(S=s-S+1).join(r):"";return M&&(x=i(k+x,k.length?s-b.length:1/0)),u+=v,n=x+b,("<"===o?u+n+k:">"===o?k+u+n:"^"===o?k.substring(0,S>>=1)+u+n+k.substring(S):u+(M?n:k+n))+e}}}function Ut(n){return n+""}function jt(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0])}function Ft(n,t,e){function r(t){var e=n(t),r=i(e,1);return r-t>t-e?e:r}function u(e){return t(e=n(new cc(e-1)),1),e}function i(n,e){return t(n=new cc(+n),e),n}function o(n,r,i){var o=u(n),a=[];if(i>1)for(;r>o;)e(o)%i||a.push(new Date(+o)),t(o,1);else for(;r>o;)a.push(new Date(+o)),t(o,1);return a}function a(n,t,e){try{cc=jt;var r=new jt;return r._=n,o(r,t,e)}finally{cc=Date}}n.floor=n,n.round=r,n.ceil=u,n.offset=i,n.range=o;var c=n.utc=Ht(n);return c.floor=c,c.round=Ht(r),c.ceil=Ht(u),c.offset=Ht(i),c.range=a,n}function Ht(n){return function(t,e){try{cc=jt;var r=new jt;return r._=t,n(r,e)._}finally{cc=Date}}}function Ot(n){function t(n){function t(t){for(var e,u,i,o=[],a=-1,c=0;++a<r;)37===n.charCodeAt(a)&&(o.push(n.slice(c,a)),null!=(u=sc[e=n.charAt(++a)])&&(e=n.charAt(++a)),(i=N[e])&&(e=i(t,null==u?"e"===e?" ":"0":u)),o.push(e),c=a+1);return o.push(n.slice(c,a)),o.join("")}var r=n.length;return t.parse=function(t){var r={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null},u=e(r,n,t,0);if(u!=t.length)return null;"p"in r&&(r.H=r.H%12+12*r.p);var i=null!=r.Z&&cc!==jt,o=new(i?jt:cc);return"j"in r?o.setFullYear(r.y,0,r.j):"w"in r&&("W"in r||"U"in r)?(o.setFullYear(r.y,0,1),o.setFullYear(r.y,0,"W"in r?(r.w+6)%7+7*r.W-(o.getDay()+5)%7:r.w+7*r.U-(o.getDay()+6)%7)):o.setFullYear(r.y,r.m,r.d),o.setHours(r.H+(r.Z/100|0),r.M+r.Z%100,r.S,r.L),i?o._:o},t.toString=function(){return n},t}function e(n,t,e,r){for(var u,i,o,a=0,c=t.length,l=e.length;c>a;){if(r>=l)return-1;if(u=t.charCodeAt(a++),37===u){if(o=t.charAt(a++),i=C[o in sc?t.charAt(a++):o],!i||(r=i(n,e,r))<0)return-1}else if(u!=e.charCodeAt(r++))return-1}return r}function r(n,t,e){_.lastIndex=0;var r=_.exec(t.slice(e));return r?(n.w=w.get(r[0].toLowerCase()),e+r[0].length):-1}function u(n,t,e){x.lastIndex=0;var r=x.exec(t.slice(e));return r?(n.w=b.get(r[0].toLowerCase()),e+r[0].length):-1}function i(n,t,e){E.lastIndex=0;var r=E.exec(t.slice(e));return r?(n.m=A.get(r[0].toLowerCase()),e+r[0].length):-1}function o(n,t,e){S.lastIndex=0;var r=S.exec(t.slice(e));return r?(n.m=k.get(r[0].toLowerCase()),e+r[0].length):-1}function a(n,t,r){return e(n,N.c.toString(),t,r)}function c(n,t,r){return e(n,N.x.toString(),t,r)}function l(n,t,r){return e(n,N.X.toString(),t,r)}function s(n,t,e){var r=M.get(t.slice(e,e+=2).toLowerCase());return null==r?-1:(n.p=r,e)}var f=n.dateTime,h=n.date,g=n.time,p=n.periods,v=n.days,d=n.shortDays,m=n.months,y=n.shortMonths;t.utc=function(n){function e(n){try{cc=jt;var t=new cc;return t._=n,r(t)}finally{cc=Date}}var r=t(n);return e.parse=function(n){try{cc=jt;var t=r.parse(n);return t&&t._}finally{cc=Date}},e.toString=r.toString,e},t.multi=t.utc.multi=ae;var M=ta.map(),x=Yt(v),b=Zt(v),_=Yt(d),w=Zt(d),S=Yt(m),k=Zt(m),E=Yt(y),A=Zt(y);p.forEach(function(n,t){M.set(n.toLowerCase(),t)});var N={a:function(n){return d[n.getDay()]},A:function(n){return v[n.getDay()]},b:function(n){return y[n.getMonth()]},B:function(n){return m[n.getMonth()]},c:t(f),d:function(n,t){return It(n.getDate(),t,2)},e:function(n,t){return It(n.getDate(),t,2)},H:function(n,t){return It(n.getHours(),t,2)},I:function(n,t){return It(n.getHours()%12||12,t,2)},j:function(n,t){return It(1+ac.dayOfYear(n),t,3)},L:function(n,t){return It(n.getMilliseconds(),t,3)},m:function(n,t){return It(n.getMonth()+1,t,2)},M:function(n,t){return It(n.getMinutes(),t,2)},p:function(n){return p[+(n.getHours()>=12)]},S:function(n,t){return It(n.getSeconds(),t,2)},U:function(n,t){return It(ac.sundayOfYear(n),t,2)},w:function(n){return n.getDay()},W:function(n,t){return It(ac.mondayOfYear(n),t,2)},x:t(h),X:t(g),y:function(n,t){return It(n.getFullYear()%100,t,2)},Y:function(n,t){return It(n.getFullYear()%1e4,t,4)},Z:ie,"%":function(){return"%"}},C={a:r,A:u,b:i,B:o,c:a,d:Qt,e:Qt,H:te,I:te,j:ne,L:ue,m:Kt,M:ee,p:s,S:re,U:Xt,w:Vt,W:$t,x:c,X:l,y:Wt,Y:Bt,Z:Jt,"%":oe};return t}function It(n,t,e){var r=0>n?"-":"",u=(r?-n:n)+"",i=u.length;return r+(e>i?new Array(e-i+1).join(t)+u:u)}function Yt(n){return new RegExp("^(?:"+n.map(ta.requote).join("|")+")","i")}function Zt(n){for(var t=new l,e=-1,r=n.length;++e<r;)t.set(n[e].toLowerCase(),e);return t}function Vt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+1));return r?(n.w=+r[0],e+r[0].length):-1}function Xt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e));return r?(n.U=+r[0],e+r[0].length):-1}function $t(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e));return r?(n.W=+r[0],e+r[0].length):-1}function Bt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+4));return r?(n.y=+r[0],e+r[0].length):-1}function Wt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.y=Gt(+r[0]),e+r[0].length):-1}function Jt(n,t,e){return/^[+-]\d{4}$/.test(t=t.slice(e,e+5))?(n.Z=-t,e+5):-1}function Gt(n){return n+(n>68?1900:2e3)}function Kt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.m=r[0]-1,e+r[0].length):-1}function Qt(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.d=+r[0],e+r[0].length):-1}function ne(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+3));return r?(n.j=+r[0],e+r[0].length):-1}function te(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.H=+r[0],e+r[0].length):-1}function ee(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.M=+r[0],e+r[0].length):-1}function re(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+2));return r?(n.S=+r[0],e+r[0].length):-1}function ue(n,t,e){fc.lastIndex=0;var r=fc.exec(t.slice(e,e+3));return r?(n.L=+r[0],e+r[0].length):-1}function ie(n){var t=n.getTimezoneOffset(),e=t>0?"-":"+",r=ga(t)/60|0,u=ga(t)%60;return e+It(r,"0",2)+It(u,"0",2)}function oe(n,t,e){hc.lastIndex=0;var r=hc.exec(t.slice(e,e+1));return r?e+r[0].length:-1}function ae(n){for(var t=n.length,e=-1;++e<t;)n[e][0]=this(n[e][0]);return function(t){for(var e=0,r=n[e];!r[1](t);)r=n[++e];return r[0](t)}}function ce(){}function le(n,t,e){var r=e.s=n+t,u=r-n,i=r-u;e.t=n-i+(t-u)}function se(n,t){n&&dc.hasOwnProperty(n.type)&&dc[n.type](n,t)}function fe(n,t,e){var r,u=-1,i=n.length-e;for(t.lineStart();++u<i;)r=n[u],t.point(r[0],r[1],r[2]);t.lineEnd()}function he(n,t){var e=-1,r=n.length;for(t.polygonStart();++e<r;)fe(n[e],t,1);t.polygonEnd()}function ge(){function n(n,t){n*=Da,t=t*Da/2+qa/4;var e=n-r,o=e>=0?1:-1,a=o*e,c=Math.cos(t),l=Math.sin(t),s=i*l,f=u*c+s*Math.cos(a),h=s*o*Math.sin(a);yc.add(Math.atan2(h,f)),r=n,u=c,i=l}var t,e,r,u,i;Mc.point=function(o,a){Mc.point=n,r=(t=o)*Da,u=Math.cos(a=(e=a)*Da/2+qa/4),i=Math.sin(a)},Mc.lineEnd=function(){n(t,e)}}function pe(n){var t=n[0],e=n[1],r=Math.cos(e);return[r*Math.cos(t),r*Math.sin(t),Math.sin(e)]}function ve(n,t){return n[0]*t[0]+n[1]*t[1]+n[2]*t[2]}function de(n,t){return[n[1]*t[2]-n[2]*t[1],n[2]*t[0]-n[0]*t[2],n[0]*t[1]-n[1]*t[0]]}function me(n,t){n[0]+=t[0],n[1]+=t[1],n[2]+=t[2]}function ye(n,t){return[n[0]*t,n[1]*t,n[2]*t]}function Me(n){var t=Math.sqrt(n[0]*n[0]+n[1]*n[1]+n[2]*n[2]);n[0]/=t,n[1]/=t,n[2]/=t}function xe(n){return[Math.atan2(n[1],n[0]),tt(n[2])]}function be(n,t){return ga(n[0]-t[0])<Ca&&ga(n[1]-t[1])<Ca}function _e(n,t){n*=Da;var e=Math.cos(t*=Da);we(e*Math.cos(n),e*Math.sin(n),Math.sin(t))}function we(n,t,e){++xc,_c+=(n-_c)/xc,wc+=(t-wc)/xc,Sc+=(e-Sc)/xc}function Se(){function n(n,u){n*=Da;var i=Math.cos(u*=Da),o=i*Math.cos(n),a=i*Math.sin(n),c=Math.sin(u),l=Math.atan2(Math.sqrt((l=e*c-r*a)*l+(l=r*o-t*c)*l+(l=t*a-e*o)*l),t*o+e*a+r*c);bc+=l,kc+=l*(t+(t=o)),Ec+=l*(e+(e=a)),Ac+=l*(r+(r=c)),we(t,e,r)}var t,e,r;qc.point=function(u,i){u*=Da;var o=Math.cos(i*=Da);t=o*Math.cos(u),e=o*Math.sin(u),r=Math.sin(i),qc.point=n,we(t,e,r)}}function ke(){qc.point=_e}function Ee(){function n(n,t){n*=Da;var e=Math.cos(t*=Da),o=e*Math.cos(n),a=e*Math.sin(n),c=Math.sin(t),l=u*c-i*a,s=i*o-r*c,f=r*a-u*o,h=Math.sqrt(l*l+s*s+f*f),g=r*o+u*a+i*c,p=h&&-nt(g)/h,v=Math.atan2(h,g);Nc+=p*l,Cc+=p*s,zc+=p*f,bc+=v,kc+=v*(r+(r=o)),Ec+=v*(u+(u=a)),Ac+=v*(i+(i=c)),we(r,u,i)}var t,e,r,u,i;qc.point=function(o,a){t=o,e=a,qc.point=n,o*=Da;var c=Math.cos(a*=Da);r=c*Math.cos(o),u=c*Math.sin(o),i=Math.sin(a),we(r,u,i)},qc.lineEnd=function(){n(t,e),qc.lineEnd=ke,qc.point=_e}}function Ae(n,t){function e(e,r){return e=n(e,r),t(e[0],e[1])}return n.invert&&t.invert&&(e.invert=function(e,r){return e=t.invert(e,r),e&&n.invert(e[0],e[1])}),e}function Ne(){return!0}function Ce(n,t,e,r,u){var i=[],o=[];if(n.forEach(function(n){if(!((t=n.length-1)<=0)){var t,e=n[0],r=n[t];if(be(e,r)){u.lineStart();for(var a=0;t>a;++a)u.point((e=n[a])[0],e[1]);return void u.lineEnd()}var c=new qe(e,n,null,!0),l=new qe(e,null,c,!1);c.o=l,i.push(c),o.push(l),c=new qe(r,n,null,!1),l=new qe(r,null,c,!0),c.o=l,i.push(c),o.push(l)}}),o.sort(t),ze(i),ze(o),i.length){for(var a=0,c=e,l=o.length;l>a;++a)o[a].e=c=!c;for(var s,f,h=i[0];;){for(var g=h,p=!0;g.v;)if((g=g.n)===h)return;s=g.z,u.lineStart();do{if(g.v=g.o.v=!0,g.e){if(p)for(var a=0,l=s.length;l>a;++a)u.point((f=s[a])[0],f[1]);else r(g.x,g.n.x,1,u);g=g.n}else{if(p){s=g.p.z;for(var a=s.length-1;a>=0;--a)u.point((f=s[a])[0],f[1])}else r(g.x,g.p.x,-1,u);g=g.p}g=g.o,s=g.z,p=!p}while(!g.v);u.lineEnd()}}}function ze(n){if(t=n.length){for(var t,e,r=0,u=n[0];++r<t;)u.n=e=n[r],e.p=u,u=e;u.n=e=n[0],e.p=u}}function qe(n,t,e,r){this.x=n,this.z=t,this.o=e,this.e=r,this.v=!1,this.n=this.p=null}function Le(n,t,e,r){return function(u,i){function o(t,e){var r=u(t,e);n(t=r[0],e=r[1])&&i.point(t,e)}function a(n,t){var e=u(n,t);d.point(e[0],e[1])}function c(){y.point=a,d.lineStart()}function l(){y.point=o,d.lineEnd()}function s(n,t){v.push([n,t]);var e=u(n,t);x.point(e[0],e[1])}function f(){x.lineStart(),v=[]}function h(){s(v[0][0],v[0][1]),x.lineEnd();var n,t=x.clean(),e=M.buffer(),r=e.length;if(v.pop(),p.push(v),v=null,r)if(1&t){n=e[0];var u,r=n.length-1,o=-1;if(r>0){for(b||(i.polygonStart(),b=!0),i.lineStart();++o<r;)i.point((u=n[o])[0],u[1]);i.lineEnd()}}else r>1&&2&t&&e.push(e.pop().concat(e.shift())),g.push(e.filter(Te))}var g,p,v,d=t(i),m=u.invert(r[0],r[1]),y={point:o,lineStart:c,lineEnd:l,polygonStart:function(){y.point=s,y.lineStart=f,y.lineEnd=h,g=[],p=[]},polygonEnd:function(){y.point=o,y.lineStart=c,y.lineEnd=l,g=ta.merge(g);var n=Fe(m,p);g.length?(b||(i.polygonStart(),b=!0),Ce(g,De,n,e,i)):n&&(b||(i.polygonStart(),b=!0),i.lineStart(),e(null,null,1,i),i.lineEnd()),b&&(i.polygonEnd(),b=!1),g=p=null},sphere:function(){i.polygonStart(),i.lineStart(),e(null,null,1,i),i.lineEnd(),i.polygonEnd()}},M=Re(),x=t(M),b=!1;return y}}function Te(n){return n.length>1}function Re(){var n,t=[];return{lineStart:function(){t.push(n=[])},point:function(t,e){n.push([t,e])},lineEnd:b,buffer:function(){var e=t;return t=[],n=null,e},rejoin:function(){t.length>1&&t.push(t.pop().concat(t.shift()))}}}function De(n,t){return((n=n.x)[0]<0?n[1]-Ra-Ca:Ra-n[1])-((t=t.x)[0]<0?t[1]-Ra-Ca:Ra-t[1])}function Pe(n){var t,e=0/0,r=0/0,u=0/0;return{lineStart:function(){n.lineStart(),t=1},point:function(i,o){var a=i>0?qa:-qa,c=ga(i-e);ga(c-qa)<Ca?(n.point(e,r=(r+o)/2>0?Ra:-Ra),n.point(u,r),n.lineEnd(),n.lineStart(),n.point(a,r),n.point(i,r),t=0):u!==a&&c>=qa&&(ga(e-u)<Ca&&(e-=u*Ca),ga(i-a)<Ca&&(i-=a*Ca),r=Ue(e,r,i,o),n.point(u,r),n.lineEnd(),n.lineStart(),n.point(a,r),t=0),n.point(e=i,r=o),u=a},lineEnd:function(){n.lineEnd(),e=r=0/0},clean:function(){return 2-t}}}function Ue(n,t,e,r){var u,i,o=Math.sin(n-e);return ga(o)>Ca?Math.atan((Math.sin(t)*(i=Math.cos(r))*Math.sin(e)-Math.sin(r)*(u=Math.cos(t))*Math.sin(n))/(u*i*o)):(t+r)/2}function je(n,t,e,r){var u;if(null==n)u=e*Ra,r.point(-qa,u),r.point(0,u),r.point(qa,u),r.point(qa,0),r.point(qa,-u),r.point(0,-u),r.point(-qa,-u),r.point(-qa,0),r.point(-qa,u);else if(ga(n[0]-t[0])>Ca){var i=n[0]<t[0]?qa:-qa;u=e*i/2,r.point(-i,u),r.point(0,u),r.point(i,u)}else r.point(t[0],t[1])}function Fe(n,t){var e=n[0],r=n[1],u=[Math.sin(e),-Math.cos(e),0],i=0,o=0;yc.reset();for(var a=0,c=t.length;c>a;++a){var l=t[a],s=l.length;if(s)for(var f=l[0],h=f[0],g=f[1]/2+qa/4,p=Math.sin(g),v=Math.cos(g),d=1;;){d===s&&(d=0),n=l[d];var m=n[0],y=n[1]/2+qa/4,M=Math.sin(y),x=Math.cos(y),b=m-h,_=b>=0?1:-1,w=_*b,S=w>qa,k=p*M;if(yc.add(Math.atan2(k*_*Math.sin(w),v*x+k*Math.cos(w))),i+=S?b+_*La:b,S^h>=e^m>=e){var E=de(pe(f),pe(n));Me(E);var A=de(u,E);Me(A);var N=(S^b>=0?-1:1)*tt(A[2]);(r>N||r===N&&(E[0]||E[1]))&&(o+=S^b>=0?1:-1)}if(!d++)break;h=m,p=M,v=x,f=n}}return(-Ca>i||Ca>i&&0>yc)^1&o}function He(n){function t(n,t){return Math.cos(n)*Math.cos(t)>i}function e(n){var e,i,c,l,s;return{lineStart:function(){l=c=!1,s=1},point:function(f,h){var g,p=[f,h],v=t(f,h),d=o?v?0:u(f,h):v?u(f+(0>f?qa:-qa),h):0;if(!e&&(l=c=v)&&n.lineStart(),v!==c&&(g=r(e,p),(be(e,g)||be(p,g))&&(p[0]+=Ca,p[1]+=Ca,v=t(p[0],p[1]))),v!==c)s=0,v?(n.lineStart(),g=r(p,e),n.point(g[0],g[1])):(g=r(e,p),n.point(g[0],g[1]),n.lineEnd()),e=g;else if(a&&e&&o^v){var m;d&i||!(m=r(p,e,!0))||(s=0,o?(n.lineStart(),n.point(m[0][0],m[0][1]),n.point(m[1][0],m[1][1]),n.lineEnd()):(n.point(m[1][0],m[1][1]),n.lineEnd(),n.lineStart(),n.point(m[0][0],m[0][1])))}!v||e&&be(e,p)||n.point(p[0],p[1]),e=p,c=v,i=d},lineEnd:function(){c&&n.lineEnd(),e=null},clean:function(){return s|(l&&c)<<1}}}function r(n,t,e){var r=pe(n),u=pe(t),o=[1,0,0],a=de(r,u),c=ve(a,a),l=a[0],s=c-l*l;if(!s)return!e&&n;var f=i*c/s,h=-i*l/s,g=de(o,a),p=ye(o,f),v=ye(a,h);me(p,v);var d=g,m=ve(p,d),y=ve(d,d),M=m*m-y*(ve(p,p)-1);if(!(0>M)){var x=Math.sqrt(M),b=ye(d,(-m-x)/y);if(me(b,p),b=xe(b),!e)return b;var _,w=n[0],S=t[0],k=n[1],E=t[1];w>S&&(_=w,w=S,S=_);var A=S-w,N=ga(A-qa)<Ca,C=N||Ca>A;if(!N&&k>E&&(_=k,k=E,E=_),C?N?k+E>0^b[1]<(ga(b[0]-w)<Ca?k:E):k<=b[1]&&b[1]<=E:A>qa^(w<=b[0]&&b[0]<=S)){var z=ye(d,(-m+x)/y);return me(z,p),[b,xe(z)]}}}function u(t,e){var r=o?n:qa-n,u=0;return-r>t?u|=1:t>r&&(u|=2),-r>e?u|=4:e>r&&(u|=8),u}var i=Math.cos(n),o=i>0,a=ga(i)>Ca,c=gr(n,6*Da);return Le(t,e,c,o?[0,-n]:[-qa,n-qa])}function Oe(n,t,e,r){return function(u){var i,o=u.a,a=u.b,c=o.x,l=o.y,s=a.x,f=a.y,h=0,g=1,p=s-c,v=f-l;if(i=n-c,p||!(i>0)){if(i/=p,0>p){if(h>i)return;g>i&&(g=i)}else if(p>0){if(i>g)return;i>h&&(h=i)}if(i=e-c,p||!(0>i)){if(i/=p,0>p){if(i>g)return;i>h&&(h=i)}else if(p>0){if(h>i)return;g>i&&(g=i)}if(i=t-l,v||!(i>0)){if(i/=v,0>v){if(h>i)return;g>i&&(g=i)}else if(v>0){if(i>g)return;i>h&&(h=i)}if(i=r-l,v||!(0>i)){if(i/=v,0>v){if(i>g)return;i>h&&(h=i)}else if(v>0){if(h>i)return;g>i&&(g=i)}return h>0&&(u.a={x:c+h*p,y:l+h*v}),1>g&&(u.b={x:c+g*p,y:l+g*v}),u}}}}}}function Ie(n,t,e,r){function u(r,u){return ga(r[0]-n)<Ca?u>0?0:3:ga(r[0]-e)<Ca?u>0?2:1:ga(r[1]-t)<Ca?u>0?1:0:u>0?3:2}function i(n,t){return o(n.x,t.x)}function o(n,t){var e=u(n,1),r=u(t,1);return e!==r?e-r:0===e?t[1]-n[1]:1===e?n[0]-t[0]:2===e?n[1]-t[1]:t[0]-n[0]}return function(a){function c(n){for(var t=0,e=d.length,r=n[1],u=0;e>u;++u)for(var i,o=1,a=d[u],c=a.length,l=a[0];c>o;++o)i=a[o],l[1]<=r?i[1]>r&&Q(l,i,n)>0&&++t:i[1]<=r&&Q(l,i,n)<0&&--t,l=i;return 0!==t}function l(i,a,c,l){var s=0,f=0;if(null==i||(s=u(i,c))!==(f=u(a,c))||o(i,a)<0^c>0){do l.point(0===s||3===s?n:e,s>1?r:t);while((s=(s+c+4)%4)!==f)}else l.point(a[0],a[1])}function s(u,i){return u>=n&&e>=u&&i>=t&&r>=i}function f(n,t){s(n,t)&&a.point(n,t)}function h(){C.point=p,d&&d.push(m=[]),S=!0,w=!1,b=_=0/0}function g(){v&&(p(y,M),x&&w&&A.rejoin(),v.push(A.buffer())),C.point=f,w&&a.lineEnd()}function p(n,t){n=Math.max(-Tc,Math.min(Tc,n)),t=Math.max(-Tc,Math.min(Tc,t));var e=s(n,t);if(d&&m.push([n,t]),S)y=n,M=t,x=e,S=!1,e&&(a.lineStart(),a.point(n,t));else if(e&&w)a.point(n,t);else{var r={a:{x:b,y:_},b:{x:n,y:t}};N(r)?(w||(a.lineStart(),a.point(r.a.x,r.a.y)),a.point(r.b.x,r.b.y),e||a.lineEnd(),k=!1):e&&(a.lineStart(),a.point(n,t),k=!1)}b=n,_=t,w=e}var v,d,m,y,M,x,b,_,w,S,k,E=a,A=Re(),N=Oe(n,t,e,r),C={point:f,lineStart:h,lineEnd:g,polygonStart:function(){a=A,v=[],d=[],k=!0},polygonEnd:function(){a=E,v=ta.merge(v);var t=c([n,r]),e=k&&t,u=v.length;(e||u)&&(a.polygonStart(),e&&(a.lineStart(),l(null,null,1,a),a.lineEnd()),u&&Ce(v,i,t,l,a),a.polygonEnd()),v=d=m=null}};return C}}function Ye(n){var t=0,e=qa/3,r=ir(n),u=r(t,e);return u.parallels=function(n){return arguments.length?r(t=n[0]*qa/180,e=n[1]*qa/180):[t/qa*180,e/qa*180]},u}function Ze(n,t){function e(n,t){var e=Math.sqrt(i-2*u*Math.sin(t))/u;return[e*Math.sin(n*=u),o-e*Math.cos(n)]}var r=Math.sin(n),u=(r+Math.sin(t))/2,i=1+r*(2*u-r),o=Math.sqrt(i)/u;return e.invert=function(n,t){var e=o-t;return[Math.atan2(n,e)/u,tt((i-(n*n+e*e)*u*u)/(2*u))]},e}function Ve(){function n(n,t){Dc+=u*n-r*t,r=n,u=t}var t,e,r,u;Hc.point=function(i,o){Hc.point=n,t=r=i,e=u=o},Hc.lineEnd=function(){n(t,e)}}function Xe(n,t){Pc>n&&(Pc=n),n>jc&&(jc=n),Uc>t&&(Uc=t),t>Fc&&(Fc=t)}function $e(){function n(n,t){o.push("M",n,",",t,i)}function t(n,t){o.push("M",n,",",t),a.point=e}function e(n,t){o.push("L",n,",",t)}function r(){a.point=n}function u(){o.push("Z")}var i=Be(4.5),o=[],a={point:n,lineStart:function(){a.point=t},lineEnd:r,polygonStart:function(){a.lineEnd=u},polygonEnd:function(){a.lineEnd=r,a.point=n},pointRadius:function(n){return i=Be(n),a},result:function(){if(o.length){var n=o.join("");return o=[],n}}};return a}function Be(n){return"m0,"+n+"a"+n+","+n+" 0 1,1 0,"+-2*n+"a"+n+","+n+" 0 1,1 0,"+2*n+"z"}function We(n,t){_c+=n,wc+=t,++Sc}function Je(){function n(n,r){var u=n-t,i=r-e,o=Math.sqrt(u*u+i*i);kc+=o*(t+n)/2,Ec+=o*(e+r)/2,Ac+=o,We(t=n,e=r)}var t,e;Ic.point=function(r,u){Ic.point=n,We(t=r,e=u)}}function Ge(){Ic.point=We}function Ke(){function n(n,t){var e=n-r,i=t-u,o=Math.sqrt(e*e+i*i);kc+=o*(r+n)/2,Ec+=o*(u+t)/2,Ac+=o,o=u*n-r*t,Nc+=o*(r+n),Cc+=o*(u+t),zc+=3*o,We(r=n,u=t)}var t,e,r,u;Ic.point=function(i,o){Ic.point=n,We(t=r=i,e=u=o)},Ic.lineEnd=function(){n(t,e)}}function Qe(n){function t(t,e){n.moveTo(t+o,e),n.arc(t,e,o,0,La)}function e(t,e){n.moveTo(t,e),a.point=r}function r(t,e){n.lineTo(t,e)}function u(){a.point=t}function i(){n.closePath()}var o=4.5,a={point:t,lineStart:function(){a.point=e},lineEnd:u,polygonStart:function(){a.lineEnd=i},polygonEnd:function(){a.lineEnd=u,a.point=t},pointRadius:function(n){return o=n,a},result:b};return a}function nr(n){function t(n){return(a?r:e)(n)}function e(t){return rr(t,function(e,r){e=n(e,r),t.point(e[0],e[1])})}function r(t){function e(e,r){e=n(e,r),t.point(e[0],e[1])}function r(){M=0/0,S.point=i,t.lineStart()}function i(e,r){var i=pe([e,r]),o=n(e,r);u(M,x,y,b,_,w,M=o[0],x=o[1],y=e,b=i[0],_=i[1],w=i[2],a,t),t.point(M,x)}function o(){S.point=e,t.lineEnd()}function c(){r(),S.point=l,S.lineEnd=s}function l(n,t){i(f=n,h=t),g=M,p=x,v=b,d=_,m=w,S.point=i}function s(){u(M,x,y,b,_,w,g,p,f,v,d,m,a,t),S.lineEnd=o,o()}var f,h,g,p,v,d,m,y,M,x,b,_,w,S={point:e,lineStart:r,lineEnd:o,polygonStart:function(){t.polygonStart(),S.lineStart=c
},polygonEnd:function(){t.polygonEnd(),S.lineStart=r}};return S}function u(t,e,r,a,c,l,s,f,h,g,p,v,d,m){var y=s-t,M=f-e,x=y*y+M*M;if(x>4*i&&d--){var b=a+g,_=c+p,w=l+v,S=Math.sqrt(b*b+_*_+w*w),k=Math.asin(w/=S),E=ga(ga(w)-1)<Ca||ga(r-h)<Ca?(r+h)/2:Math.atan2(_,b),A=n(E,k),N=A[0],C=A[1],z=N-t,q=C-e,L=M*z-y*q;(L*L/x>i||ga((y*z+M*q)/x-.5)>.3||o>a*g+c*p+l*v)&&(u(t,e,r,a,c,l,N,C,E,b/=S,_/=S,w,d,m),m.point(N,C),u(N,C,E,b,_,w,s,f,h,g,p,v,d,m))}}var i=.5,o=Math.cos(30*Da),a=16;return t.precision=function(n){return arguments.length?(a=(i=n*n)>0&&16,t):Math.sqrt(i)},t}function tr(n){var t=nr(function(t,e){return n([t*Pa,e*Pa])});return function(n){return or(t(n))}}function er(n){this.stream=n}function rr(n,t){return{point:t,sphere:function(){n.sphere()},lineStart:function(){n.lineStart()},lineEnd:function(){n.lineEnd()},polygonStart:function(){n.polygonStart()},polygonEnd:function(){n.polygonEnd()}}}function ur(n){return ir(function(){return n})()}function ir(n){function t(n){return n=a(n[0]*Da,n[1]*Da),[n[0]*h+c,l-n[1]*h]}function e(n){return n=a.invert((n[0]-c)/h,(l-n[1])/h),n&&[n[0]*Pa,n[1]*Pa]}function r(){a=Ae(o=lr(m,M,x),i);var n=i(v,d);return c=g-n[0]*h,l=p+n[1]*h,u()}function u(){return s&&(s.valid=!1,s=null),t}var i,o,a,c,l,s,f=nr(function(n,t){return n=i(n,t),[n[0]*h+c,l-n[1]*h]}),h=150,g=480,p=250,v=0,d=0,m=0,M=0,x=0,b=Lc,_=y,w=null,S=null;return t.stream=function(n){return s&&(s.valid=!1),s=or(b(o,f(_(n)))),s.valid=!0,s},t.clipAngle=function(n){return arguments.length?(b=null==n?(w=n,Lc):He((w=+n)*Da),u()):w},t.clipExtent=function(n){return arguments.length?(S=n,_=n?Ie(n[0][0],n[0][1],n[1][0],n[1][1]):y,u()):S},t.scale=function(n){return arguments.length?(h=+n,r()):h},t.translate=function(n){return arguments.length?(g=+n[0],p=+n[1],r()):[g,p]},t.center=function(n){return arguments.length?(v=n[0]%360*Da,d=n[1]%360*Da,r()):[v*Pa,d*Pa]},t.rotate=function(n){return arguments.length?(m=n[0]%360*Da,M=n[1]%360*Da,x=n.length>2?n[2]%360*Da:0,r()):[m*Pa,M*Pa,x*Pa]},ta.rebind(t,f,"precision"),function(){return i=n.apply(this,arguments),t.invert=i.invert&&e,r()}}function or(n){return rr(n,function(t,e){n.point(t*Da,e*Da)})}function ar(n,t){return[n,t]}function cr(n,t){return[n>qa?n-La:-qa>n?n+La:n,t]}function lr(n,t,e){return n?t||e?Ae(fr(n),hr(t,e)):fr(n):t||e?hr(t,e):cr}function sr(n){return function(t,e){return t+=n,[t>qa?t-La:-qa>t?t+La:t,e]}}function fr(n){var t=sr(n);return t.invert=sr(-n),t}function hr(n,t){function e(n,t){var e=Math.cos(t),a=Math.cos(n)*e,c=Math.sin(n)*e,l=Math.sin(t),s=l*r+a*u;return[Math.atan2(c*i-s*o,a*r-l*u),tt(s*i+c*o)]}var r=Math.cos(n),u=Math.sin(n),i=Math.cos(t),o=Math.sin(t);return e.invert=function(n,t){var e=Math.cos(t),a=Math.cos(n)*e,c=Math.sin(n)*e,l=Math.sin(t),s=l*i-c*o;return[Math.atan2(c*i+l*o,a*r+s*u),tt(s*r-a*u)]},e}function gr(n,t){var e=Math.cos(n),r=Math.sin(n);return function(u,i,o,a){var c=o*t;null!=u?(u=pr(e,u),i=pr(e,i),(o>0?i>u:u>i)&&(u+=o*La)):(u=n+o*La,i=n-.5*c);for(var l,s=u;o>0?s>i:i>s;s-=c)a.point((l=xe([e,-r*Math.cos(s),-r*Math.sin(s)]))[0],l[1])}}function pr(n,t){var e=pe(t);e[0]-=n,Me(e);var r=nt(-e[1]);return((-e[2]<0?-r:r)+2*Math.PI-Ca)%(2*Math.PI)}function vr(n,t,e){var r=ta.range(n,t-Ca,e).concat(t);return function(n){return r.map(function(t){return[n,t]})}}function dr(n,t,e){var r=ta.range(n,t-Ca,e).concat(t);return function(n){return r.map(function(t){return[t,n]})}}function mr(n){return n.source}function yr(n){return n.target}function Mr(n,t,e,r){var u=Math.cos(t),i=Math.sin(t),o=Math.cos(r),a=Math.sin(r),c=u*Math.cos(n),l=u*Math.sin(n),s=o*Math.cos(e),f=o*Math.sin(e),h=2*Math.asin(Math.sqrt(it(r-t)+u*o*it(e-n))),g=1/Math.sin(h),p=h?function(n){var t=Math.sin(n*=h)*g,e=Math.sin(h-n)*g,r=e*c+t*s,u=e*l+t*f,o=e*i+t*a;return[Math.atan2(u,r)*Pa,Math.atan2(o,Math.sqrt(r*r+u*u))*Pa]}:function(){return[n*Pa,t*Pa]};return p.distance=h,p}function xr(){function n(n,u){var i=Math.sin(u*=Da),o=Math.cos(u),a=ga((n*=Da)-t),c=Math.cos(a);Yc+=Math.atan2(Math.sqrt((a=o*Math.sin(a))*a+(a=r*i-e*o*c)*a),e*i+r*o*c),t=n,e=i,r=o}var t,e,r;Zc.point=function(u,i){t=u*Da,e=Math.sin(i*=Da),r=Math.cos(i),Zc.point=n},Zc.lineEnd=function(){Zc.point=Zc.lineEnd=b}}function br(n,t){function e(t,e){var r=Math.cos(t),u=Math.cos(e),i=n(r*u);return[i*u*Math.sin(t),i*Math.sin(e)]}return e.invert=function(n,e){var r=Math.sqrt(n*n+e*e),u=t(r),i=Math.sin(u),o=Math.cos(u);return[Math.atan2(n*i,r*o),Math.asin(r&&e*i/r)]},e}function _r(n,t){function e(n,t){o>0?-Ra+Ca>t&&(t=-Ra+Ca):t>Ra-Ca&&(t=Ra-Ca);var e=o/Math.pow(u(t),i);return[e*Math.sin(i*n),o-e*Math.cos(i*n)]}var r=Math.cos(n),u=function(n){return Math.tan(qa/4+n/2)},i=n===t?Math.sin(n):Math.log(r/Math.cos(t))/Math.log(u(t)/u(n)),o=r*Math.pow(u(n),i)/i;return i?(e.invert=function(n,t){var e=o-t,r=K(i)*Math.sqrt(n*n+e*e);return[Math.atan2(n,e)/i,2*Math.atan(Math.pow(o/r,1/i))-Ra]},e):Sr}function wr(n,t){function e(n,t){var e=i-t;return[e*Math.sin(u*n),i-e*Math.cos(u*n)]}var r=Math.cos(n),u=n===t?Math.sin(n):(r-Math.cos(t))/(t-n),i=r/u+n;return ga(u)<Ca?ar:(e.invert=function(n,t){var e=i-t;return[Math.atan2(n,e)/u,i-K(u)*Math.sqrt(n*n+e*e)]},e)}function Sr(n,t){return[n,Math.log(Math.tan(qa/4+t/2))]}function kr(n){var t,e=ur(n),r=e.scale,u=e.translate,i=e.clipExtent;return e.scale=function(){var n=r.apply(e,arguments);return n===e?t?e.clipExtent(null):e:n},e.translate=function(){var n=u.apply(e,arguments);return n===e?t?e.clipExtent(null):e:n},e.clipExtent=function(n){var o=i.apply(e,arguments);if(o===e){if(t=null==n){var a=qa*r(),c=u();i([[c[0]-a,c[1]-a],[c[0]+a,c[1]+a]])}}else t&&(o=null);return o},e.clipExtent(null)}function Er(n,t){return[Math.log(Math.tan(qa/4+t/2)),-n]}function Ar(n){return n[0]}function Nr(n){return n[1]}function Cr(n){for(var t=n.length,e=[0,1],r=2,u=2;t>u;u++){for(;r>1&&Q(n[e[r-2]],n[e[r-1]],n[u])<=0;)--r;e[r++]=u}return e.slice(0,r)}function zr(n,t){return n[0]-t[0]||n[1]-t[1]}function qr(n,t,e){return(e[0]-t[0])*(n[1]-t[1])<(e[1]-t[1])*(n[0]-t[0])}function Lr(n,t,e,r){var u=n[0],i=e[0],o=t[0]-u,a=r[0]-i,c=n[1],l=e[1],s=t[1]-c,f=r[1]-l,h=(a*(c-l)-f*(u-i))/(f*o-a*s);return[u+h*o,c+h*s]}function Tr(n){var t=n[0],e=n[n.length-1];return!(t[0]-e[0]||t[1]-e[1])}function Rr(){tu(this),this.edge=this.site=this.circle=null}function Dr(n){var t=el.pop()||new Rr;return t.site=n,t}function Pr(n){Xr(n),Qc.remove(n),el.push(n),tu(n)}function Ur(n){var t=n.circle,e=t.x,r=t.cy,u={x:e,y:r},i=n.P,o=n.N,a=[n];Pr(n);for(var c=i;c.circle&&ga(e-c.circle.x)<Ca&&ga(r-c.circle.cy)<Ca;)i=c.P,a.unshift(c),Pr(c),c=i;a.unshift(c),Xr(c);for(var l=o;l.circle&&ga(e-l.circle.x)<Ca&&ga(r-l.circle.cy)<Ca;)o=l.N,a.push(l),Pr(l),l=o;a.push(l),Xr(l);var s,f=a.length;for(s=1;f>s;++s)l=a[s],c=a[s-1],Kr(l.edge,c.site,l.site,u);c=a[0],l=a[f-1],l.edge=Jr(c.site,l.site,null,u),Vr(c),Vr(l)}function jr(n){for(var t,e,r,u,i=n.x,o=n.y,a=Qc._;a;)if(r=Fr(a,o)-i,r>Ca)a=a.L;else{if(u=i-Hr(a,o),!(u>Ca)){r>-Ca?(t=a.P,e=a):u>-Ca?(t=a,e=a.N):t=e=a;break}if(!a.R){t=a;break}a=a.R}var c=Dr(n);if(Qc.insert(t,c),t||e){if(t===e)return Xr(t),e=Dr(t.site),Qc.insert(c,e),c.edge=e.edge=Jr(t.site,c.site),Vr(t),void Vr(e);if(!e)return void(c.edge=Jr(t.site,c.site));Xr(t),Xr(e);var l=t.site,s=l.x,f=l.y,h=n.x-s,g=n.y-f,p=e.site,v=p.x-s,d=p.y-f,m=2*(h*d-g*v),y=h*h+g*g,M=v*v+d*d,x={x:(d*y-g*M)/m+s,y:(h*M-v*y)/m+f};Kr(e.edge,l,p,x),c.edge=Jr(l,n,null,x),e.edge=Jr(n,p,null,x),Vr(t),Vr(e)}}function Fr(n,t){var e=n.site,r=e.x,u=e.y,i=u-t;if(!i)return r;var o=n.P;if(!o)return-1/0;e=o.site;var a=e.x,c=e.y,l=c-t;if(!l)return a;var s=a-r,f=1/i-1/l,h=s/l;return f?(-h+Math.sqrt(h*h-2*f*(s*s/(-2*l)-c+l/2+u-i/2)))/f+r:(r+a)/2}function Hr(n,t){var e=n.N;if(e)return Fr(e,t);var r=n.site;return r.y===t?r.x:1/0}function Or(n){this.site=n,this.edges=[]}function Ir(n){for(var t,e,r,u,i,o,a,c,l,s,f=n[0][0],h=n[1][0],g=n[0][1],p=n[1][1],v=Kc,d=v.length;d--;)if(i=v[d],i&&i.prepare())for(a=i.edges,c=a.length,o=0;c>o;)s=a[o].end(),r=s.x,u=s.y,l=a[++o%c].start(),t=l.x,e=l.y,(ga(r-t)>Ca||ga(u-e)>Ca)&&(a.splice(o,0,new Qr(Gr(i.site,s,ga(r-f)<Ca&&p-u>Ca?{x:f,y:ga(t-f)<Ca?e:p}:ga(u-p)<Ca&&h-r>Ca?{x:ga(e-p)<Ca?t:h,y:p}:ga(r-h)<Ca&&u-g>Ca?{x:h,y:ga(t-h)<Ca?e:g}:ga(u-g)<Ca&&r-f>Ca?{x:ga(e-g)<Ca?t:f,y:g}:null),i.site,null)),++c)}function Yr(n,t){return t.angle-n.angle}function Zr(){tu(this),this.x=this.y=this.arc=this.site=this.cy=null}function Vr(n){var t=n.P,e=n.N;if(t&&e){var r=t.site,u=n.site,i=e.site;if(r!==i){var o=u.x,a=u.y,c=r.x-o,l=r.y-a,s=i.x-o,f=i.y-a,h=2*(c*f-l*s);if(!(h>=-za)){var g=c*c+l*l,p=s*s+f*f,v=(f*g-l*p)/h,d=(c*p-s*g)/h,f=d+a,m=rl.pop()||new Zr;m.arc=n,m.site=u,m.x=v+o,m.y=f+Math.sqrt(v*v+d*d),m.cy=f,n.circle=m;for(var y=null,M=tl._;M;)if(m.y<M.y||m.y===M.y&&m.x<=M.x){if(!M.L){y=M.P;break}M=M.L}else{if(!M.R){y=M;break}M=M.R}tl.insert(y,m),y||(nl=m)}}}}function Xr(n){var t=n.circle;t&&(t.P||(nl=t.N),tl.remove(t),rl.push(t),tu(t),n.circle=null)}function $r(n){for(var t,e=Gc,r=Oe(n[0][0],n[0][1],n[1][0],n[1][1]),u=e.length;u--;)t=e[u],(!Br(t,n)||!r(t)||ga(t.a.x-t.b.x)<Ca&&ga(t.a.y-t.b.y)<Ca)&&(t.a=t.b=null,e.splice(u,1))}function Br(n,t){var e=n.b;if(e)return!0;var r,u,i=n.a,o=t[0][0],a=t[1][0],c=t[0][1],l=t[1][1],s=n.l,f=n.r,h=s.x,g=s.y,p=f.x,v=f.y,d=(h+p)/2,m=(g+v)/2;if(v===g){if(o>d||d>=a)return;if(h>p){if(i){if(i.y>=l)return}else i={x:d,y:c};e={x:d,y:l}}else{if(i){if(i.y<c)return}else i={x:d,y:l};e={x:d,y:c}}}else if(r=(h-p)/(v-g),u=m-r*d,-1>r||r>1)if(h>p){if(i){if(i.y>=l)return}else i={x:(c-u)/r,y:c};e={x:(l-u)/r,y:l}}else{if(i){if(i.y<c)return}else i={x:(l-u)/r,y:l};e={x:(c-u)/r,y:c}}else if(v>g){if(i){if(i.x>=a)return}else i={x:o,y:r*o+u};e={x:a,y:r*a+u}}else{if(i){if(i.x<o)return}else i={x:a,y:r*a+u};e={x:o,y:r*o+u}}return n.a=i,n.b=e,!0}function Wr(n,t){this.l=n,this.r=t,this.a=this.b=null}function Jr(n,t,e,r){var u=new Wr(n,t);return Gc.push(u),e&&Kr(u,n,t,e),r&&Kr(u,t,n,r),Kc[n.i].edges.push(new Qr(u,n,t)),Kc[t.i].edges.push(new Qr(u,t,n)),u}function Gr(n,t,e){var r=new Wr(n,null);return r.a=t,r.b=e,Gc.push(r),r}function Kr(n,t,e,r){n.a||n.b?n.l===e?n.b=r:n.a=r:(n.a=r,n.l=t,n.r=e)}function Qr(n,t,e){var r=n.a,u=n.b;this.edge=n,this.site=t,this.angle=e?Math.atan2(e.y-t.y,e.x-t.x):n.l===t?Math.atan2(u.x-r.x,r.y-u.y):Math.atan2(r.x-u.x,u.y-r.y)}function nu(){this._=null}function tu(n){n.U=n.C=n.L=n.R=n.P=n.N=null}function eu(n,t){var e=t,r=t.R,u=e.U;u?u.L===e?u.L=r:u.R=r:n._=r,r.U=u,e.U=r,e.R=r.L,e.R&&(e.R.U=e),r.L=e}function ru(n,t){var e=t,r=t.L,u=e.U;u?u.L===e?u.L=r:u.R=r:n._=r,r.U=u,e.U=r,e.L=r.R,e.L&&(e.L.U=e),r.R=e}function uu(n){for(;n.L;)n=n.L;return n}function iu(n,t){var e,r,u,i=n.sort(ou).pop();for(Gc=[],Kc=new Array(n.length),Qc=new nu,tl=new nu;;)if(u=nl,i&&(!u||i.y<u.y||i.y===u.y&&i.x<u.x))(i.x!==e||i.y!==r)&&(Kc[i.i]=new Or(i),jr(i),e=i.x,r=i.y),i=n.pop();else{if(!u)break;Ur(u.arc)}t&&($r(t),Ir(t));var o={cells:Kc,edges:Gc};return Qc=tl=Gc=Kc=null,o}function ou(n,t){return t.y-n.y||t.x-n.x}function au(n,t,e){return(n.x-e.x)*(t.y-n.y)-(n.x-t.x)*(e.y-n.y)}function cu(n){return n.x}function lu(n){return n.y}function su(){return{leaf:!0,nodes:[],point:null,x:null,y:null}}function fu(n,t,e,r,u,i){if(!n(t,e,r,u,i)){var o=.5*(e+u),a=.5*(r+i),c=t.nodes;c[0]&&fu(n,c[0],e,r,o,a),c[1]&&fu(n,c[1],o,r,u,a),c[2]&&fu(n,c[2],e,a,o,i),c[3]&&fu(n,c[3],o,a,u,i)}}function hu(n,t,e,r,u,i,o){var a,c=1/0;return function l(n,s,f,h,g){if(!(s>i||f>o||r>h||u>g)){if(p=n.point){var p,v=t-n.x,d=e-n.y,m=v*v+d*d;if(c>m){var y=Math.sqrt(c=m);r=t-y,u=e-y,i=t+y,o=e+y,a=p}}for(var M=n.nodes,x=.5*(s+h),b=.5*(f+g),_=t>=x,w=e>=b,S=w<<1|_,k=S+4;k>S;++S)if(n=M[3&S])switch(3&S){case 0:l(n,s,f,x,b);break;case 1:l(n,x,f,h,b);break;case 2:l(n,s,b,x,g);break;case 3:l(n,x,b,h,g)}}}(n,r,u,i,o),a}function gu(n,t){n=ta.rgb(n),t=ta.rgb(t);var e=n.r,r=n.g,u=n.b,i=t.r-e,o=t.g-r,a=t.b-u;return function(n){return"#"+xt(Math.round(e+i*n))+xt(Math.round(r+o*n))+xt(Math.round(u+a*n))}}function pu(n,t){var e,r={},u={};for(e in n)e in t?r[e]=mu(n[e],t[e]):u[e]=n[e];for(e in t)e in n||(u[e]=t[e]);return function(n){for(e in r)u[e]=r[e](n);return u}}function vu(n,t){return n=+n,t=+t,function(e){return n*(1-e)+t*e}}function du(n,t){var e,r,u,i=il.lastIndex=ol.lastIndex=0,o=-1,a=[],c=[];for(n+="",t+="";(e=il.exec(n))&&(r=ol.exec(t));)(u=r.index)>i&&(u=t.slice(i,u),a[o]?a[o]+=u:a[++o]=u),(e=e[0])===(r=r[0])?a[o]?a[o]+=r:a[++o]=r:(a[++o]=null,c.push({i:o,x:vu(e,r)})),i=ol.lastIndex;return i<t.length&&(u=t.slice(i),a[o]?a[o]+=u:a[++o]=u),a.length<2?c[0]?(t=c[0].x,function(n){return t(n)+""}):function(){return t}:(t=c.length,function(n){for(var e,r=0;t>r;++r)a[(e=c[r]).i]=e.x(n);return a.join("")})}function mu(n,t){for(var e,r=ta.interpolators.length;--r>=0&&!(e=ta.interpolators[r](n,t)););return e}function yu(n,t){var e,r=[],u=[],i=n.length,o=t.length,a=Math.min(n.length,t.length);for(e=0;a>e;++e)r.push(mu(n[e],t[e]));for(;i>e;++e)u[e]=n[e];for(;o>e;++e)u[e]=t[e];return function(n){for(e=0;a>e;++e)u[e]=r[e](n);return u}}function Mu(n){return function(t){return 0>=t?0:t>=1?1:n(t)}}function xu(n){return function(t){return 1-n(1-t)}}function bu(n){return function(t){return.5*(.5>t?n(2*t):2-n(2-2*t))}}function _u(n){return n*n}function wu(n){return n*n*n}function Su(n){if(0>=n)return 0;if(n>=1)return 1;var t=n*n,e=t*n;return 4*(.5>n?e:3*(n-t)+e-.75)}function ku(n){return function(t){return Math.pow(t,n)}}function Eu(n){return 1-Math.cos(n*Ra)}function Au(n){return Math.pow(2,10*(n-1))}function Nu(n){return 1-Math.sqrt(1-n*n)}function Cu(n,t){var e;return arguments.length<2&&(t=.45),arguments.length?e=t/La*Math.asin(1/n):(n=1,e=t/4),function(r){return 1+n*Math.pow(2,-10*r)*Math.sin((r-e)*La/t)}}function zu(n){return n||(n=1.70158),function(t){return t*t*((n+1)*t-n)}}function qu(n){return 1/2.75>n?7.5625*n*n:2/2.75>n?7.5625*(n-=1.5/2.75)*n+.75:2.5/2.75>n?7.5625*(n-=2.25/2.75)*n+.9375:7.5625*(n-=2.625/2.75)*n+.984375}function Lu(n,t){n=ta.hcl(n),t=ta.hcl(t);var e=n.h,r=n.c,u=n.l,i=t.h-e,o=t.c-r,a=t.l-u;return isNaN(o)&&(o=0,r=isNaN(r)?t.c:r),isNaN(i)?(i=0,e=isNaN(e)?t.h:e):i>180?i-=360:-180>i&&(i+=360),function(n){return st(e+i*n,r+o*n,u+a*n)+""}}function Tu(n,t){n=ta.hsl(n),t=ta.hsl(t);var e=n.h,r=n.s,u=n.l,i=t.h-e,o=t.s-r,a=t.l-u;return isNaN(o)&&(o=0,r=isNaN(r)?t.s:r),isNaN(i)?(i=0,e=isNaN(e)?t.h:e):i>180?i-=360:-180>i&&(i+=360),function(n){return ct(e+i*n,r+o*n,u+a*n)+""}}function Ru(n,t){n=ta.lab(n),t=ta.lab(t);var e=n.l,r=n.a,u=n.b,i=t.l-e,o=t.a-r,a=t.b-u;return function(n){return ht(e+i*n,r+o*n,u+a*n)+""}}function Du(n,t){return t-=n,function(e){return Math.round(n+t*e)}}function Pu(n){var t=[n.a,n.b],e=[n.c,n.d],r=ju(t),u=Uu(t,e),i=ju(Fu(e,t,-u))||0;t[0]*e[1]<e[0]*t[1]&&(t[0]*=-1,t[1]*=-1,r*=-1,u*=-1),this.rotate=(r?Math.atan2(t[1],t[0]):Math.atan2(-e[0],e[1]))*Pa,this.translate=[n.e,n.f],this.scale=[r,i],this.skew=i?Math.atan2(u,i)*Pa:0}function Uu(n,t){return n[0]*t[0]+n[1]*t[1]}function ju(n){var t=Math.sqrt(Uu(n,n));return t&&(n[0]/=t,n[1]/=t),t}function Fu(n,t,e){return n[0]+=e*t[0],n[1]+=e*t[1],n}function Hu(n,t){var e,r=[],u=[],i=ta.transform(n),o=ta.transform(t),a=i.translate,c=o.translate,l=i.rotate,s=o.rotate,f=i.skew,h=o.skew,g=i.scale,p=o.scale;return a[0]!=c[0]||a[1]!=c[1]?(r.push("translate(",null,",",null,")"),u.push({i:1,x:vu(a[0],c[0])},{i:3,x:vu(a[1],c[1])})):r.push(c[0]||c[1]?"translate("+c+")":""),l!=s?(l-s>180?s+=360:s-l>180&&(l+=360),u.push({i:r.push(r.pop()+"rotate(",null,")")-2,x:vu(l,s)})):s&&r.push(r.pop()+"rotate("+s+")"),f!=h?u.push({i:r.push(r.pop()+"skewX(",null,")")-2,x:vu(f,h)}):h&&r.push(r.pop()+"skewX("+h+")"),g[0]!=p[0]||g[1]!=p[1]?(e=r.push(r.pop()+"scale(",null,",",null,")"),u.push({i:e-4,x:vu(g[0],p[0])},{i:e-2,x:vu(g[1],p[1])})):(1!=p[0]||1!=p[1])&&r.push(r.pop()+"scale("+p+")"),e=u.length,function(n){for(var t,i=-1;++i<e;)r[(t=u[i]).i]=t.x(n);return r.join("")}}function Ou(n,t){return t=(t-=n=+n)||1/t,function(e){return(e-n)/t}}function Iu(n,t){return t=(t-=n=+n)||1/t,function(e){return Math.max(0,Math.min(1,(e-n)/t))}}function Yu(n){for(var t=n.source,e=n.target,r=Vu(t,e),u=[t];t!==r;)t=t.parent,u.push(t);for(var i=u.length;e!==r;)u.splice(i,0,e),e=e.parent;return u}function Zu(n){for(var t=[],e=n.parent;null!=e;)t.push(n),n=e,e=e.parent;return t.push(n),t}function Vu(n,t){if(n===t)return n;for(var e=Zu(n),r=Zu(t),u=e.pop(),i=r.pop(),o=null;u===i;)o=u,u=e.pop(),i=r.pop();return o}function Xu(n){n.fixed|=2}function $u(n){n.fixed&=-7}function Bu(n){n.fixed|=4,n.px=n.x,n.py=n.y}function Wu(n){n.fixed&=-5}function Ju(n,t,e){var r=0,u=0;if(n.charge=0,!n.leaf)for(var i,o=n.nodes,a=o.length,c=-1;++c<a;)i=o[c],null!=i&&(Ju(i,t,e),n.charge+=i.charge,r+=i.charge*i.cx,u+=i.charge*i.cy);if(n.point){n.leaf||(n.point.x+=Math.random()-.5,n.point.y+=Math.random()-.5);var l=t*e[n.point.index];n.charge+=n.pointCharge=l,r+=l*n.point.x,u+=l*n.point.y}n.cx=r/n.charge,n.cy=u/n.charge}function Gu(n,t){return ta.rebind(n,t,"sort","children","value"),n.nodes=n,n.links=ri,n}function Ku(n,t){for(var e=[n];null!=(n=e.pop());)if(t(n),(u=n.children)&&(r=u.length))for(var r,u;--r>=0;)e.push(u[r])}function Qu(n,t){for(var e=[n],r=[];null!=(n=e.pop());)if(r.push(n),(i=n.children)&&(u=i.length))for(var u,i,o=-1;++o<u;)e.push(i[o]);for(;null!=(n=r.pop());)t(n)}function ni(n){return n.children}function ti(n){return n.value}function ei(n,t){return t.value-n.value}function ri(n){return ta.merge(n.map(function(n){return(n.children||[]).map(function(t){return{source:n,target:t}})}))}function ui(n){return n.x}function ii(n){return n.y}function oi(n,t,e){n.y0=t,n.y=e}function ai(n){return ta.range(n.length)}function ci(n){for(var t=-1,e=n[0].length,r=[];++t<e;)r[t]=0;return r}function li(n){for(var t,e=1,r=0,u=n[0][1],i=n.length;i>e;++e)(t=n[e][1])>u&&(r=e,u=t);return r}function si(n){return n.reduce(fi,0)}function fi(n,t){return n+t[1]}function hi(n,t){return gi(n,Math.ceil(Math.log(t.length)/Math.LN2+1))}function gi(n,t){for(var e=-1,r=+n[0],u=(n[1]-r)/t,i=[];++e<=t;)i[e]=u*e+r;return i}function pi(n){return[ta.min(n),ta.max(n)]}function vi(n,t){return n.value-t.value}function di(n,t){var e=n._pack_next;n._pack_next=t,t._pack_prev=n,t._pack_next=e,e._pack_prev=t}function mi(n,t){n._pack_next=t,t._pack_prev=n}function yi(n,t){var e=t.x-n.x,r=t.y-n.y,u=n.r+t.r;return.999*u*u>e*e+r*r}function Mi(n){function t(n){s=Math.min(n.x-n.r,s),f=Math.max(n.x+n.r,f),h=Math.min(n.y-n.r,h),g=Math.max(n.y+n.r,g)}if((e=n.children)&&(l=e.length)){var e,r,u,i,o,a,c,l,s=1/0,f=-1/0,h=1/0,g=-1/0;if(e.forEach(xi),r=e[0],r.x=-r.r,r.y=0,t(r),l>1&&(u=e[1],u.x=u.r,u.y=0,t(u),l>2))for(i=e[2],wi(r,u,i),t(i),di(r,i),r._pack_prev=i,di(i,u),u=r._pack_next,o=3;l>o;o++){wi(r,u,i=e[o]);var p=0,v=1,d=1;for(a=u._pack_next;a!==u;a=a._pack_next,v++)if(yi(a,i)){p=1;break}if(1==p)for(c=r._pack_prev;c!==a._pack_prev&&!yi(c,i);c=c._pack_prev,d++);p?(d>v||v==d&&u.r<r.r?mi(r,u=a):mi(r=c,u),o--):(di(r,i),u=i,t(i))}var m=(s+f)/2,y=(h+g)/2,M=0;for(o=0;l>o;o++)i=e[o],i.x-=m,i.y-=y,M=Math.max(M,i.r+Math.sqrt(i.x*i.x+i.y*i.y));n.r=M,e.forEach(bi)}}function xi(n){n._pack_next=n._pack_prev=n}function bi(n){delete n._pack_next,delete n._pack_prev}function _i(n,t,e,r){var u=n.children;if(n.x=t+=r*n.x,n.y=e+=r*n.y,n.r*=r,u)for(var i=-1,o=u.length;++i<o;)_i(u[i],t,e,r)}function wi(n,t,e){var r=n.r+e.r,u=t.x-n.x,i=t.y-n.y;if(r&&(u||i)){var o=t.r+e.r,a=u*u+i*i;o*=o,r*=r;var c=.5+(r-o)/(2*a),l=Math.sqrt(Math.max(0,2*o*(r+a)-(r-=a)*r-o*o))/(2*a);e.x=n.x+c*u+l*i,e.y=n.y+c*i-l*u}else e.x=n.x+r,e.y=n.y}function Si(n,t){return n.parent==t.parent?1:2}function ki(n){var t=n.children;return t.length?t[0]:n.t}function Ei(n){var t,e=n.children;return(t=e.length)?e[t-1]:n.t}function Ai(n,t,e){var r=e/(t.i-n.i);t.c-=r,t.s+=e,n.c+=r,t.z+=e,t.m+=e}function Ni(n){for(var t,e=0,r=0,u=n.children,i=u.length;--i>=0;)t=u[i],t.z+=e,t.m+=e,e+=t.s+(r+=t.c)}function Ci(n,t,e){return n.a.parent===t.parent?n.a:e}function zi(n){return 1+ta.max(n,function(n){return n.y})}function qi(n){return n.reduce(function(n,t){return n+t.x},0)/n.length}function Li(n){var t=n.children;return t&&t.length?Li(t[0]):n}function Ti(n){var t,e=n.children;return e&&(t=e.length)?Ti(e[t-1]):n}function Ri(n){return{x:n.x,y:n.y,dx:n.dx,dy:n.dy}}function Di(n,t){var e=n.x+t[3],r=n.y+t[0],u=n.dx-t[1]-t[3],i=n.dy-t[0]-t[2];return 0>u&&(e+=u/2,u=0),0>i&&(r+=i/2,i=0),{x:e,y:r,dx:u,dy:i}}function Pi(n){var t=n[0],e=n[n.length-1];return e>t?[t,e]:[e,t]}function Ui(n){return n.rangeExtent?n.rangeExtent():Pi(n.range())}function ji(n,t,e,r){var u=e(n[0],n[1]),i=r(t[0],t[1]);return function(n){return i(u(n))}}function Fi(n,t){var e,r=0,u=n.length-1,i=n[r],o=n[u];return i>o&&(e=r,r=u,u=e,e=i,i=o,o=e),n[r]=t.floor(i),n[u]=t.ceil(o),n}function Hi(n){return n?{floor:function(t){return Math.floor(t/n)*n},ceil:function(t){return Math.ceil(t/n)*n}}:ml}function Oi(n,t,e,r){var u=[],i=[],o=0,a=Math.min(n.length,t.length)-1;for(n[a]<n[0]&&(n=n.slice().reverse(),t=t.slice().reverse());++o<=a;)u.push(e(n[o-1],n[o])),i.push(r(t[o-1],t[o]));return function(t){var e=ta.bisect(n,t,1,a)-1;return i[e](u[e](t))}}function Ii(n,t,e,r){function u(){var u=Math.min(n.length,t.length)>2?Oi:ji,c=r?Iu:Ou;return o=u(n,t,c,e),a=u(t,n,c,mu),i}function i(n){return o(n)}var o,a;return i.invert=function(n){return a(n)},i.domain=function(t){return arguments.length?(n=t.map(Number),u()):n},i.range=function(n){return arguments.length?(t=n,u()):t},i.rangeRound=function(n){return i.range(n).interpolate(Du)},i.clamp=function(n){return arguments.length?(r=n,u()):r},i.interpolate=function(n){return arguments.length?(e=n,u()):e},i.ticks=function(t){return Xi(n,t)},i.tickFormat=function(t,e){return $i(n,t,e)},i.nice=function(t){return Zi(n,t),u()},i.copy=function(){return Ii(n,t,e,r)},u()}function Yi(n,t){return ta.rebind(n,t,"range","rangeRound","interpolate","clamp")}function Zi(n,t){return Fi(n,Hi(Vi(n,t)[2]))}function Vi(n,t){null==t&&(t=10);var e=Pi(n),r=e[1]-e[0],u=Math.pow(10,Math.floor(Math.log(r/t)/Math.LN10)),i=t/r*u;return.15>=i?u*=10:.35>=i?u*=5:.75>=i&&(u*=2),e[0]=Math.ceil(e[0]/u)*u,e[1]=Math.floor(e[1]/u)*u+.5*u,e[2]=u,e}function Xi(n,t){return ta.range.apply(ta,Vi(n,t))}function $i(n,t,e){var r=Vi(n,t);if(e){var u=ic.exec(e);if(u.shift(),"s"===u[8]){var i=ta.formatPrefix(Math.max(ga(r[0]),ga(r[1])));return u[7]||(u[7]="."+Bi(i.scale(r[2]))),u[8]="f",e=ta.format(u.join("")),function(n){return e(i.scale(n))+i.symbol}}u[7]||(u[7]="."+Wi(u[8],r)),e=u.join("")}else e=",."+Bi(r[2])+"f";return ta.format(e)}function Bi(n){return-Math.floor(Math.log(n)/Math.LN10+.01)}function Wi(n,t){var e=Bi(t[2]);return n in yl?Math.abs(e-Bi(Math.max(ga(t[0]),ga(t[1]))))+ +("e"!==n):e-2*("%"===n)}function Ji(n,t,e,r){function u(n){return(e?Math.log(0>n?0:n):-Math.log(n>0?0:-n))/Math.log(t)}function i(n){return e?Math.pow(t,n):-Math.pow(t,-n)}function o(t){return n(u(t))}return o.invert=function(t){return i(n.invert(t))},o.domain=function(t){return arguments.length?(e=t[0]>=0,n.domain((r=t.map(Number)).map(u)),o):r},o.base=function(e){return arguments.length?(t=+e,n.domain(r.map(u)),o):t},o.nice=function(){var t=Fi(r.map(u),e?Math:xl);return n.domain(t),r=t.map(i),o},o.ticks=function(){var n=Pi(r),o=[],a=n[0],c=n[1],l=Math.floor(u(a)),s=Math.ceil(u(c)),f=t%1?2:t;if(isFinite(s-l)){if(e){for(;s>l;l++)for(var h=1;f>h;h++)o.push(i(l)*h);o.push(i(l))}else for(o.push(i(l));l++<s;)for(var h=f-1;h>0;h--)o.push(i(l)*h);for(l=0;o[l]<a;l++);for(s=o.length;o[s-1]>c;s--);o=o.slice(l,s)}return o},o.tickFormat=function(n,t){if(!arguments.length)return Ml;arguments.length<2?t=Ml:"function"!=typeof t&&(t=ta.format(t));var r,a=Math.max(.1,n/o.ticks().length),c=e?(r=1e-12,Math.ceil):(r=-1e-12,Math.floor);return function(n){return n/i(c(u(n)+r))<=a?t(n):""}},o.copy=function(){return Ji(n.copy(),t,e,r)},Yi(o,n)}function Gi(n,t,e){function r(t){return n(u(t))}var u=Ki(t),i=Ki(1/t);return r.invert=function(t){return i(n.invert(t))},r.domain=function(t){return arguments.length?(n.domain((e=t.map(Number)).map(u)),r):e},r.ticks=function(n){return Xi(e,n)},r.tickFormat=function(n,t){return $i(e,n,t)},r.nice=function(n){return r.domain(Zi(e,n))},r.exponent=function(o){return arguments.length?(u=Ki(t=o),i=Ki(1/t),n.domain(e.map(u)),r):t},r.copy=function(){return Gi(n.copy(),t,e)},Yi(r,n)}function Ki(n){return function(t){return 0>t?-Math.pow(-t,n):Math.pow(t,n)}}function Qi(n,t){function e(e){return i[((u.get(e)||("range"===t.t?u.set(e,n.push(e)):0/0))-1)%i.length]}function r(t,e){return ta.range(n.length).map(function(n){return t+e*n})}var u,i,o;return e.domain=function(r){if(!arguments.length)return n;n=[],u=new l;for(var i,o=-1,a=r.length;++o<a;)u.has(i=r[o])||u.set(i,n.push(i));return e[t.t].apply(e,t.a)},e.range=function(n){return arguments.length?(i=n,o=0,t={t:"range",a:arguments},e):i},e.rangePoints=function(u,a){arguments.length<2&&(a=0);var c=u[0],l=u[1],s=n.length<2?(c=(c+l)/2,0):(l-c)/(n.length-1+a);return i=r(c+s*a/2,s),o=0,t={t:"rangePoints",a:arguments},e},e.rangeRoundPoints=function(u,a){arguments.length<2&&(a=0);var c=u[0],l=u[1],s=n.length<2?(c=l=Math.round((c+l)/2),0):(l-c)/(n.length-1+a)|0;return i=r(c+Math.round(s*a/2+(l-c-(n.length-1+a)*s)/2),s),o=0,t={t:"rangeRoundPoints",a:arguments},e},e.rangeBands=function(u,a,c){arguments.length<2&&(a=0),arguments.length<3&&(c=a);var l=u[1]<u[0],s=u[l-0],f=u[1-l],h=(f-s)/(n.length-a+2*c);return i=r(s+h*c,h),l&&i.reverse(),o=h*(1-a),t={t:"rangeBands",a:arguments},e},e.rangeRoundBands=function(u,a,c){arguments.length<2&&(a=0),arguments.length<3&&(c=a);var l=u[1]<u[0],s=u[l-0],f=u[1-l],h=Math.floor((f-s)/(n.length-a+2*c));return i=r(s+Math.round((f-s-(n.length-a)*h)/2),h),l&&i.reverse(),o=Math.round(h*(1-a)),t={t:"rangeRoundBands",a:arguments},e},e.rangeBand=function(){return o},e.rangeExtent=function(){return Pi(t.a[0])},e.copy=function(){return Qi(n,t)},e.domain(n)}function no(n,t){function i(){var e=0,r=t.length;for(a=[];++e<r;)a[e-1]=ta.quantile(n,e/r);return o}function o(n){return isNaN(n=+n)?void 0:t[ta.bisect(a,n)]}var a;return o.domain=function(t){return arguments.length?(n=t.map(r).filter(u).sort(e),i()):n},o.range=function(n){return arguments.length?(t=n,i()):t},o.quantiles=function(){return a},o.invertExtent=function(e){return e=t.indexOf(e),0>e?[0/0,0/0]:[e>0?a[e-1]:n[0],e<a.length?a[e]:n[n.length-1]]},o.copy=function(){return no(n,t)},i()}function to(n,t,e){function r(t){return e[Math.max(0,Math.min(o,Math.floor(i*(t-n))))]}function u(){return i=e.length/(t-n),o=e.length-1,r}var i,o;return r.domain=function(e){return arguments.length?(n=+e[0],t=+e[e.length-1],u()):[n,t]},r.range=function(n){return arguments.length?(e=n,u()):e},r.invertExtent=function(t){return t=e.indexOf(t),t=0>t?0/0:t/i+n,[t,t+1/i]},r.copy=function(){return to(n,t,e)},u()}function eo(n,t){function e(e){return e>=e?t[ta.bisect(n,e)]:void 0}return e.domain=function(t){return arguments.length?(n=t,e):n},e.range=function(n){return arguments.length?(t=n,e):t},e.invertExtent=function(e){return e=t.indexOf(e),[n[e-1],n[e]]},e.copy=function(){return eo(n,t)},e}function ro(n){function t(n){return+n}return t.invert=t,t.domain=t.range=function(e){return arguments.length?(n=e.map(t),t):n},t.ticks=function(t){return Xi(n,t)},t.tickFormat=function(t,e){return $i(n,t,e)},t.copy=function(){return ro(n)},t}function uo(){return 0}function io(n){return n.innerRadius}function oo(n){return n.outerRadius}function ao(n){return n.startAngle}function co(n){return n.endAngle}function lo(n){return n&&n.padAngle}function so(n,t,e,r){return(n-e)*t-(t-r)*n>0?0:1}function fo(n,t,e,r,u){var i=n[0]-t[0],o=n[1]-t[1],a=(u?r:-r)/Math.sqrt(i*i+o*o),c=a*o,l=-a*i,s=n[0]+c,f=n[1]+l,h=t[0]+c,g=t[1]+l,p=(s+h)/2,v=(f+g)/2,d=h-s,m=g-f,y=d*d+m*m,M=e-r,x=s*g-h*f,b=(0>m?-1:1)*Math.sqrt(M*M*y-x*x),_=(x*m-d*b)/y,w=(-x*d-m*b)/y,S=(x*m+d*b)/y,k=(-x*d+m*b)/y,E=_-p,A=w-v,N=S-p,C=k-v;return E*E+A*A>N*N+C*C&&(_=S,w=k),[[_-c,w-l],[_*e/M,w*e/M]]}function ho(n){function t(t){function o(){l.push("M",i(n(s),a))}for(var c,l=[],s=[],f=-1,h=t.length,g=Et(e),p=Et(r);++f<h;)u.call(this,c=t[f],f)?s.push([+g.call(this,c,f),+p.call(this,c,f)]):s.length&&(o(),s=[]);return s.length&&o(),l.length?l.join(""):null}var e=Ar,r=Nr,u=Ne,i=go,o=i.key,a=.7;return t.x=function(n){return arguments.length?(e=n,t):e},t.y=function(n){return arguments.length?(r=n,t):r},t.defined=function(n){return arguments.length?(u=n,t):u},t.interpolate=function(n){return arguments.length?(o="function"==typeof n?i=n:(i=El.get(n)||go).key,t):o},t.tension=function(n){return arguments.length?(a=n,t):a},t}function go(n){return n.join("L")}function po(n){return go(n)+"Z"}function vo(n){for(var t=0,e=n.length,r=n[0],u=[r[0],",",r[1]];++t<e;)u.push("H",(r[0]+(r=n[t])[0])/2,"V",r[1]);return e>1&&u.push("H",r[0]),u.join("")}function mo(n){for(var t=0,e=n.length,r=n[0],u=[r[0],",",r[1]];++t<e;)u.push("V",(r=n[t])[1],"H",r[0]);return u.join("")}function yo(n){for(var t=0,e=n.length,r=n[0],u=[r[0],",",r[1]];++t<e;)u.push("H",(r=n[t])[0],"V",r[1]);return u.join("")}function Mo(n,t){return n.length<4?go(n):n[1]+_o(n.slice(1,-1),wo(n,t))}function xo(n,t){return n.length<3?go(n):n[0]+_o((n.push(n[0]),n),wo([n[n.length-2]].concat(n,[n[1]]),t))}function bo(n,t){return n.length<3?go(n):n[0]+_o(n,wo(n,t))}function _o(n,t){if(t.length<1||n.length!=t.length&&n.length!=t.length+2)return go(n);var e=n.length!=t.length,r="",u=n[0],i=n[1],o=t[0],a=o,c=1;if(e&&(r+="Q"+(i[0]-2*o[0]/3)+","+(i[1]-2*o[1]/3)+","+i[0]+","+i[1],u=n[1],c=2),t.length>1){a=t[1],i=n[c],c++,r+="C"+(u[0]+o[0])+","+(u[1]+o[1])+","+(i[0]-a[0])+","+(i[1]-a[1])+","+i[0]+","+i[1];for(var l=2;l<t.length;l++,c++)i=n[c],a=t[l],r+="S"+(i[0]-a[0])+","+(i[1]-a[1])+","+i[0]+","+i[1]}if(e){var s=n[c];r+="Q"+(i[0]+2*a[0]/3)+","+(i[1]+2*a[1]/3)+","+s[0]+","+s[1]}return r}function wo(n,t){for(var e,r=[],u=(1-t)/2,i=n[0],o=n[1],a=1,c=n.length;++a<c;)e=i,i=o,o=n[a],r.push([u*(o[0]-e[0]),u*(o[1]-e[1])]);return r}function So(n){if(n.length<3)return go(n);var t=1,e=n.length,r=n[0],u=r[0],i=r[1],o=[u,u,u,(r=n[1])[0]],a=[i,i,i,r[1]],c=[u,",",i,"L",No(Cl,o),",",No(Cl,a)];for(n.push(n[e-1]);++t<=e;)r=n[t],o.shift(),o.push(r[0]),a.shift(),a.push(r[1]),Co(c,o,a);return n.pop(),c.push("L",r),c.join("")}function ko(n){if(n.length<4)return go(n);for(var t,e=[],r=-1,u=n.length,i=[0],o=[0];++r<3;)t=n[r],i.push(t[0]),o.push(t[1]);for(e.push(No(Cl,i)+","+No(Cl,o)),--r;++r<u;)t=n[r],i.shift(),i.push(t[0]),o.shift(),o.push(t[1]),Co(e,i,o);return e.join("")}function Eo(n){for(var t,e,r=-1,u=n.length,i=u+4,o=[],a=[];++r<4;)e=n[r%u],o.push(e[0]),a.push(e[1]);for(t=[No(Cl,o),",",No(Cl,a)],--r;++r<i;)e=n[r%u],o.shift(),o.push(e[0]),a.shift(),a.push(e[1]),Co(t,o,a);return t.join("")}function Ao(n,t){var e=n.length-1;if(e)for(var r,u,i=n[0][0],o=n[0][1],a=n[e][0]-i,c=n[e][1]-o,l=-1;++l<=e;)r=n[l],u=l/e,r[0]=t*r[0]+(1-t)*(i+u*a),r[1]=t*r[1]+(1-t)*(o+u*c);return So(n)}function No(n,t){return n[0]*t[0]+n[1]*t[1]+n[2]*t[2]+n[3]*t[3]}function Co(n,t,e){n.push("C",No(Al,t),",",No(Al,e),",",No(Nl,t),",",No(Nl,e),",",No(Cl,t),",",No(Cl,e))}function zo(n,t){return(t[1]-n[1])/(t[0]-n[0])}function qo(n){for(var t=0,e=n.length-1,r=[],u=n[0],i=n[1],o=r[0]=zo(u,i);++t<e;)r[t]=(o+(o=zo(u=i,i=n[t+1])))/2;return r[t]=o,r}function Lo(n){for(var t,e,r,u,i=[],o=qo(n),a=-1,c=n.length-1;++a<c;)t=zo(n[a],n[a+1]),ga(t)<Ca?o[a]=o[a+1]=0:(e=o[a]/t,r=o[a+1]/t,u=e*e+r*r,u>9&&(u=3*t/Math.sqrt(u),o[a]=u*e,o[a+1]=u*r));for(a=-1;++a<=c;)u=(n[Math.min(c,a+1)][0]-n[Math.max(0,a-1)][0])/(6*(1+o[a]*o[a])),i.push([u||0,o[a]*u||0]);return i}function To(n){return n.length<3?go(n):n[0]+_o(n,Lo(n))}function Ro(n){for(var t,e,r,u=-1,i=n.length;++u<i;)t=n[u],e=t[0],r=t[1]-Ra,t[0]=e*Math.cos(r),t[1]=e*Math.sin(r);return n}function Do(n){function t(t){function c(){v.push("M",a(n(m),f),s,l(n(d.reverse()),f),"Z")}for(var h,g,p,v=[],d=[],m=[],y=-1,M=t.length,x=Et(e),b=Et(u),_=e===r?function(){return g}:Et(r),w=u===i?function(){return p}:Et(i);++y<M;)o.call(this,h=t[y],y)?(d.push([g=+x.call(this,h,y),p=+b.call(this,h,y)]),m.push([+_.call(this,h,y),+w.call(this,h,y)])):d.length&&(c(),d=[],m=[]);return d.length&&c(),v.length?v.join(""):null}var e=Ar,r=Ar,u=0,i=Nr,o=Ne,a=go,c=a.key,l=a,s="L",f=.7;return t.x=function(n){return arguments.length?(e=r=n,t):r},t.x0=function(n){return arguments.length?(e=n,t):e},t.x1=function(n){return arguments.length?(r=n,t):r
},t.y=function(n){return arguments.length?(u=i=n,t):i},t.y0=function(n){return arguments.length?(u=n,t):u},t.y1=function(n){return arguments.length?(i=n,t):i},t.defined=function(n){return arguments.length?(o=n,t):o},t.interpolate=function(n){return arguments.length?(c="function"==typeof n?a=n:(a=El.get(n)||go).key,l=a.reverse||a,s=a.closed?"M":"L",t):c},t.tension=function(n){return arguments.length?(f=n,t):f},t}function Po(n){return n.radius}function Uo(n){return[n.x,n.y]}function jo(n){return function(){var t=n.apply(this,arguments),e=t[0],r=t[1]-Ra;return[e*Math.cos(r),e*Math.sin(r)]}}function Fo(){return 64}function Ho(){return"circle"}function Oo(n){var t=Math.sqrt(n/qa);return"M0,"+t+"A"+t+","+t+" 0 1,1 0,"+-t+"A"+t+","+t+" 0 1,1 0,"+t+"Z"}function Io(n){return function(){var t,e;(t=this[n])&&(e=t[t.active])&&(--t.count?delete t[t.active]:delete this[n],t.active+=.5,e.event&&e.event.interrupt.call(this,this.__data__,e.index))}}function Yo(n,t,e){return ya(n,Pl),n.namespace=t,n.id=e,n}function Zo(n,t,e,r){var u=n.id,i=n.namespace;return Y(n,"function"==typeof e?function(n,o,a){n[i][u].tween.set(t,r(e.call(n,n.__data__,o,a)))}:(e=r(e),function(n){n[i][u].tween.set(t,e)}))}function Vo(n){return null==n&&(n=""),function(){this.textContent=n}}function Xo(n){return null==n?"__transition__":"__transition_"+n+"__"}function $o(n,t,e,r,u){var i=n[e]||(n[e]={active:0,count:0}),o=i[r];if(!o){var a=u.time;o=i[r]={tween:new l,time:a,delay:u.delay,duration:u.duration,ease:u.ease,index:t},u=null,++i.count,ta.timer(function(u){function c(e){if(i.active>r)return s();var u=i[i.active];u&&(--i.count,delete i[i.active],u.event&&u.event.interrupt.call(n,n.__data__,u.index)),i.active=r,o.event&&o.event.start.call(n,n.__data__,t),o.tween.forEach(function(e,r){(r=r.call(n,n.__data__,t))&&v.push(r)}),h=o.ease,f=o.duration,ta.timer(function(){return p.c=l(e||1)?Ne:l,1},0,a)}function l(e){if(i.active!==r)return 1;for(var u=e/f,a=h(u),c=v.length;c>0;)v[--c].call(n,a);return u>=1?(o.event&&o.event.end.call(n,n.__data__,t),s()):void 0}function s(){return--i.count?delete i[r]:delete n[e],1}var f,h,g=o.delay,p=ec,v=[];return p.t=g+a,u>=g?c(u-g):void(p.c=c)},0,a)}}function Bo(n,t,e){n.attr("transform",function(n){var r=t(n);return"translate("+(isFinite(r)?r:e(n))+",0)"})}function Wo(n,t,e){n.attr("transform",function(n){var r=t(n);return"translate(0,"+(isFinite(r)?r:e(n))+")"})}function Jo(n){return n.toISOString()}function Go(n,t,e){function r(t){return n(t)}function u(n,e){var r=n[1]-n[0],u=r/e,i=ta.bisect(Vl,u);return i==Vl.length?[t.year,Vi(n.map(function(n){return n/31536e6}),e)[2]]:i?t[u/Vl[i-1]<Vl[i]/u?i-1:i]:[Bl,Vi(n,e)[2]]}return r.invert=function(t){return Ko(n.invert(t))},r.domain=function(t){return arguments.length?(n.domain(t),r):n.domain().map(Ko)},r.nice=function(n,t){function e(e){return!isNaN(e)&&!n.range(e,Ko(+e+1),t).length}var i=r.domain(),o=Pi(i),a=null==n?u(o,10):"number"==typeof n&&u(o,n);return a&&(n=a[0],t=a[1]),r.domain(Fi(i,t>1?{floor:function(t){for(;e(t=n.floor(t));)t=Ko(t-1);return t},ceil:function(t){for(;e(t=n.ceil(t));)t=Ko(+t+1);return t}}:n))},r.ticks=function(n,t){var e=Pi(r.domain()),i=null==n?u(e,10):"number"==typeof n?u(e,n):!n.range&&[{range:n},t];return i&&(n=i[0],t=i[1]),n.range(e[0],Ko(+e[1]+1),1>t?1:t)},r.tickFormat=function(){return e},r.copy=function(){return Go(n.copy(),t,e)},Yi(r,n)}function Ko(n){return new Date(n)}function Qo(n){return JSON.parse(n.responseText)}function na(n){var t=ua.createRange();return t.selectNode(ua.body),t.createContextualFragment(n.responseText)}var ta={version:"3.5.5"},ea=[].slice,ra=function(n){return ea.call(n)},ua=this.document;if(ua)try{ra(ua.documentElement.childNodes)[0].nodeType}catch(ia){ra=function(n){for(var t=n.length,e=new Array(t);t--;)e[t]=n[t];return e}}if(Date.now||(Date.now=function(){return+new Date}),ua)try{ua.createElement("DIV").style.setProperty("opacity",0,"")}catch(oa){var aa=this.Element.prototype,ca=aa.setAttribute,la=aa.setAttributeNS,sa=this.CSSStyleDeclaration.prototype,fa=sa.setProperty;aa.setAttribute=function(n,t){ca.call(this,n,t+"")},aa.setAttributeNS=function(n,t,e){la.call(this,n,t,e+"")},sa.setProperty=function(n,t,e){fa.call(this,n,t+"",e)}}ta.ascending=e,ta.descending=function(n,t){return n>t?-1:t>n?1:t>=n?0:0/0},ta.min=function(n,t){var e,r,u=-1,i=n.length;if(1===arguments.length){for(;++u<i;)if(null!=(r=n[u])&&r>=r){e=r;break}for(;++u<i;)null!=(r=n[u])&&e>r&&(e=r)}else{for(;++u<i;)if(null!=(r=t.call(n,n[u],u))&&r>=r){e=r;break}for(;++u<i;)null!=(r=t.call(n,n[u],u))&&e>r&&(e=r)}return e},ta.max=function(n,t){var e,r,u=-1,i=n.length;if(1===arguments.length){for(;++u<i;)if(null!=(r=n[u])&&r>=r){e=r;break}for(;++u<i;)null!=(r=n[u])&&r>e&&(e=r)}else{for(;++u<i;)if(null!=(r=t.call(n,n[u],u))&&r>=r){e=r;break}for(;++u<i;)null!=(r=t.call(n,n[u],u))&&r>e&&(e=r)}return e},ta.extent=function(n,t){var e,r,u,i=-1,o=n.length;if(1===arguments.length){for(;++i<o;)if(null!=(r=n[i])&&r>=r){e=u=r;break}for(;++i<o;)null!=(r=n[i])&&(e>r&&(e=r),r>u&&(u=r))}else{for(;++i<o;)if(null!=(r=t.call(n,n[i],i))&&r>=r){e=u=r;break}for(;++i<o;)null!=(r=t.call(n,n[i],i))&&(e>r&&(e=r),r>u&&(u=r))}return[e,u]},ta.sum=function(n,t){var e,r=0,i=n.length,o=-1;if(1===arguments.length)for(;++o<i;)u(e=+n[o])&&(r+=e);else for(;++o<i;)u(e=+t.call(n,n[o],o))&&(r+=e);return r},ta.mean=function(n,t){var e,i=0,o=n.length,a=-1,c=o;if(1===arguments.length)for(;++a<o;)u(e=r(n[a]))?i+=e:--c;else for(;++a<o;)u(e=r(t.call(n,n[a],a)))?i+=e:--c;return c?i/c:void 0},ta.quantile=function(n,t){var e=(n.length-1)*t+1,r=Math.floor(e),u=+n[r-1],i=e-r;return i?u+i*(n[r]-u):u},ta.median=function(n,t){var i,o=[],a=n.length,c=-1;if(1===arguments.length)for(;++c<a;)u(i=r(n[c]))&&o.push(i);else for(;++c<a;)u(i=r(t.call(n,n[c],c)))&&o.push(i);return o.length?ta.quantile(o.sort(e),.5):void 0},ta.variance=function(n,t){var e,i,o=n.length,a=0,c=0,l=-1,s=0;if(1===arguments.length)for(;++l<o;)u(e=r(n[l]))&&(i=e-a,a+=i/++s,c+=i*(e-a));else for(;++l<o;)u(e=r(t.call(n,n[l],l)))&&(i=e-a,a+=i/++s,c+=i*(e-a));return s>1?c/(s-1):void 0},ta.deviation=function(){var n=ta.variance.apply(this,arguments);return n?Math.sqrt(n):n};var ha=i(e);ta.bisectLeft=ha.left,ta.bisect=ta.bisectRight=ha.right,ta.bisector=function(n){return i(1===n.length?function(t,r){return e(n(t),r)}:n)},ta.shuffle=function(n,t,e){(i=arguments.length)<3&&(e=n.length,2>i&&(t=0));for(var r,u,i=e-t;i;)u=Math.random()*i--|0,r=n[i+t],n[i+t]=n[u+t],n[u+t]=r;return n},ta.permute=function(n,t){for(var e=t.length,r=new Array(e);e--;)r[e]=n[t[e]];return r},ta.pairs=function(n){for(var t,e=0,r=n.length-1,u=n[0],i=new Array(0>r?0:r);r>e;)i[e]=[t=u,u=n[++e]];return i},ta.zip=function(){if(!(r=arguments.length))return[];for(var n=-1,t=ta.min(arguments,o),e=new Array(t);++n<t;)for(var r,u=-1,i=e[n]=new Array(r);++u<r;)i[u]=arguments[u][n];return e},ta.transpose=function(n){return ta.zip.apply(ta,n)},ta.keys=function(n){var t=[];for(var e in n)t.push(e);return t},ta.values=function(n){var t=[];for(var e in n)t.push(n[e]);return t},ta.entries=function(n){var t=[];for(var e in n)t.push({key:e,value:n[e]});return t},ta.merge=function(n){for(var t,e,r,u=n.length,i=-1,o=0;++i<u;)o+=n[i].length;for(e=new Array(o);--u>=0;)for(r=n[u],t=r.length;--t>=0;)e[--o]=r[t];return e};var ga=Math.abs;ta.range=function(n,t,e){if(arguments.length<3&&(e=1,arguments.length<2&&(t=n,n=0)),(t-n)/e===1/0)throw new Error("infinite range");var r,u=[],i=a(ga(e)),o=-1;if(n*=i,t*=i,e*=i,0>e)for(;(r=n+e*++o)>t;)u.push(r/i);else for(;(r=n+e*++o)<t;)u.push(r/i);return u},ta.map=function(n,t){var e=new l;if(n instanceof l)n.forEach(function(n,t){e.set(n,t)});else if(Array.isArray(n)){var r,u=-1,i=n.length;if(1===arguments.length)for(;++u<i;)e.set(u,n[u]);else for(;++u<i;)e.set(t.call(n,r=n[u],u),r)}else for(var o in n)e.set(o,n[o]);return e};var pa="__proto__",va="\x00";c(l,{has:h,get:function(n){return this._[s(n)]},set:function(n,t){return this._[s(n)]=t},remove:g,keys:p,values:function(){var n=[];for(var t in this._)n.push(this._[t]);return n},entries:function(){var n=[];for(var t in this._)n.push({key:f(t),value:this._[t]});return n},size:v,empty:d,forEach:function(n){for(var t in this._)n.call(this,f(t),this._[t])}}),ta.nest=function(){function n(t,o,a){if(a>=i.length)return r?r.call(u,o):e?o.sort(e):o;for(var c,s,f,h,g=-1,p=o.length,v=i[a++],d=new l;++g<p;)(h=d.get(c=v(s=o[g])))?h.push(s):d.set(c,[s]);return t?(s=t(),f=function(e,r){s.set(e,n(t,r,a))}):(s={},f=function(e,r){s[e]=n(t,r,a)}),d.forEach(f),s}function t(n,e){if(e>=i.length)return n;var r=[],u=o[e++];return n.forEach(function(n,u){r.push({key:n,values:t(u,e)})}),u?r.sort(function(n,t){return u(n.key,t.key)}):r}var e,r,u={},i=[],o=[];return u.map=function(t,e){return n(e,t,0)},u.entries=function(e){return t(n(ta.map,e,0),0)},u.key=function(n){return i.push(n),u},u.sortKeys=function(n){return o[i.length-1]=n,u},u.sortValues=function(n){return e=n,u},u.rollup=function(n){return r=n,u},u},ta.set=function(n){var t=new m;if(n)for(var e=0,r=n.length;r>e;++e)t.add(n[e]);return t},c(m,{has:h,add:function(n){return this._[s(n+="")]=!0,n},remove:g,values:p,size:v,empty:d,forEach:function(n){for(var t in this._)n.call(this,f(t))}}),ta.behavior={},ta.rebind=function(n,t){for(var e,r=1,u=arguments.length;++r<u;)n[e=arguments[r]]=M(n,t,t[e]);return n};var da=["webkit","ms","moz","Moz","o","O"];ta.dispatch=function(){for(var n=new _,t=-1,e=arguments.length;++t<e;)n[arguments[t]]=w(n);return n},_.prototype.on=function(n,t){var e=n.indexOf("."),r="";if(e>=0&&(r=n.slice(e+1),n=n.slice(0,e)),n)return arguments.length<2?this[n].on(r):this[n].on(r,t);if(2===arguments.length){if(null==t)for(n in this)this.hasOwnProperty(n)&&this[n].on(r,null);return this}},ta.event=null,ta.requote=function(n){return n.replace(ma,"\\$&")};var ma=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g,ya={}.__proto__?function(n,t){n.__proto__=t}:function(n,t){for(var e in t)n[e]=t[e]},Ma=function(n,t){return t.querySelector(n)},xa=function(n,t){return t.querySelectorAll(n)},ba=function(n,t){var e=n.matches||n[x(n,"matchesSelector")];return(ba=function(n,t){return e.call(n,t)})(n,t)};"function"==typeof Sizzle&&(Ma=function(n,t){return Sizzle(n,t)[0]||null},xa=Sizzle,ba=Sizzle.matchesSelector),ta.selection=function(){return ta.select(ua.documentElement)};var _a=ta.selection.prototype=[];_a.select=function(n){var t,e,r,u,i=[];n=N(n);for(var o=-1,a=this.length;++o<a;){i.push(t=[]),t.parentNode=(r=this[o]).parentNode;for(var c=-1,l=r.length;++c<l;)(u=r[c])?(t.push(e=n.call(u,u.__data__,c,o)),e&&"__data__"in u&&(e.__data__=u.__data__)):t.push(null)}return A(i)},_a.selectAll=function(n){var t,e,r=[];n=C(n);for(var u=-1,i=this.length;++u<i;)for(var o=this[u],a=-1,c=o.length;++a<c;)(e=o[a])&&(r.push(t=ra(n.call(e,e.__data__,a,u))),t.parentNode=e);return A(r)};var wa={svg:"http://www.w3.org/2000/svg",xhtml:"http://www.w3.org/1999/xhtml",xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};ta.ns={prefix:wa,qualify:function(n){var t=n.indexOf(":"),e=n;return t>=0&&(e=n.slice(0,t),n=n.slice(t+1)),wa.hasOwnProperty(e)?{space:wa[e],local:n}:n}},_a.attr=function(n,t){if(arguments.length<2){if("string"==typeof n){var e=this.node();return n=ta.ns.qualify(n),n.local?e.getAttributeNS(n.space,n.local):e.getAttribute(n)}for(t in n)this.each(z(t,n[t]));return this}return this.each(z(n,t))},_a.classed=function(n,t){if(arguments.length<2){if("string"==typeof n){var e=this.node(),r=(n=T(n)).length,u=-1;if(t=e.classList){for(;++u<r;)if(!t.contains(n[u]))return!1}else for(t=e.getAttribute("class");++u<r;)if(!L(n[u]).test(t))return!1;return!0}for(t in n)this.each(R(t,n[t]));return this}return this.each(R(n,t))},_a.style=function(n,e,r){var u=arguments.length;if(3>u){if("string"!=typeof n){2>u&&(e="");for(r in n)this.each(P(r,n[r],e));return this}if(2>u){var i=this.node();return t(i).getComputedStyle(i,null).getPropertyValue(n)}r=""}return this.each(P(n,e,r))},_a.property=function(n,t){if(arguments.length<2){if("string"==typeof n)return this.node()[n];for(t in n)this.each(U(t,n[t]));return this}return this.each(U(n,t))},_a.text=function(n){return arguments.length?this.each("function"==typeof n?function(){var t=n.apply(this,arguments);this.textContent=null==t?"":t}:null==n?function(){this.textContent=""}:function(){this.textContent=n}):this.node().textContent},_a.html=function(n){return arguments.length?this.each("function"==typeof n?function(){var t=n.apply(this,arguments);this.innerHTML=null==t?"":t}:null==n?function(){this.innerHTML=""}:function(){this.innerHTML=n}):this.node().innerHTML},_a.append=function(n){return n=j(n),this.select(function(){return this.appendChild(n.apply(this,arguments))})},_a.insert=function(n,t){return n=j(n),t=N(t),this.select(function(){return this.insertBefore(n.apply(this,arguments),t.apply(this,arguments)||null)})},_a.remove=function(){return this.each(F)},_a.data=function(n,t){function e(n,e){var r,u,i,o=n.length,f=e.length,h=Math.min(o,f),g=new Array(f),p=new Array(f),v=new Array(o);if(t){var d,m=new l,y=new Array(o);for(r=-1;++r<o;)m.has(d=t.call(u=n[r],u.__data__,r))?v[r]=u:m.set(d,u),y[r]=d;for(r=-1;++r<f;)(u=m.get(d=t.call(e,i=e[r],r)))?u!==!0&&(g[r]=u,u.__data__=i):p[r]=H(i),m.set(d,!0);for(r=-1;++r<o;)m.get(y[r])!==!0&&(v[r]=n[r])}else{for(r=-1;++r<h;)u=n[r],i=e[r],u?(u.__data__=i,g[r]=u):p[r]=H(i);for(;f>r;++r)p[r]=H(e[r]);for(;o>r;++r)v[r]=n[r]}p.update=g,p.parentNode=g.parentNode=v.parentNode=n.parentNode,a.push(p),c.push(g),s.push(v)}var r,u,i=-1,o=this.length;if(!arguments.length){for(n=new Array(o=(r=this[0]).length);++i<o;)(u=r[i])&&(n[i]=u.__data__);return n}var a=Z([]),c=A([]),s=A([]);if("function"==typeof n)for(;++i<o;)e(r=this[i],n.call(r,r.parentNode.__data__,i));else for(;++i<o;)e(r=this[i],n);return c.enter=function(){return a},c.exit=function(){return s},c},_a.datum=function(n){return arguments.length?this.property("__data__",n):this.property("__data__")},_a.filter=function(n){var t,e,r,u=[];"function"!=typeof n&&(n=O(n));for(var i=0,o=this.length;o>i;i++){u.push(t=[]),t.parentNode=(e=this[i]).parentNode;for(var a=0,c=e.length;c>a;a++)(r=e[a])&&n.call(r,r.__data__,a,i)&&t.push(r)}return A(u)},_a.order=function(){for(var n=-1,t=this.length;++n<t;)for(var e,r=this[n],u=r.length-1,i=r[u];--u>=0;)(e=r[u])&&(i&&i!==e.nextSibling&&i.parentNode.insertBefore(e,i),i=e);return this},_a.sort=function(n){n=I.apply(this,arguments);for(var t=-1,e=this.length;++t<e;)this[t].sort(n);return this.order()},_a.each=function(n){return Y(this,function(t,e,r){n.call(t,t.__data__,e,r)})},_a.call=function(n){var t=ra(arguments);return n.apply(t[0]=this,t),this},_a.empty=function(){return!this.node()},_a.node=function(){for(var n=0,t=this.length;t>n;n++)for(var e=this[n],r=0,u=e.length;u>r;r++){var i=e[r];if(i)return i}return null},_a.size=function(){var n=0;return Y(this,function(){++n}),n};var Sa=[];ta.selection.enter=Z,ta.selection.enter.prototype=Sa,Sa.append=_a.append,Sa.empty=_a.empty,Sa.node=_a.node,Sa.call=_a.call,Sa.size=_a.size,Sa.select=function(n){for(var t,e,r,u,i,o=[],a=-1,c=this.length;++a<c;){r=(u=this[a]).update,o.push(t=[]),t.parentNode=u.parentNode;for(var l=-1,s=u.length;++l<s;)(i=u[l])?(t.push(r[l]=e=n.call(u.parentNode,i.__data__,l,a)),e.__data__=i.__data__):t.push(null)}return A(o)},Sa.insert=function(n,t){return arguments.length<2&&(t=V(this)),_a.insert.call(this,n,t)},ta.select=function(t){var e;return"string"==typeof t?(e=[Ma(t,ua)],e.parentNode=ua.documentElement):(e=[t],e.parentNode=n(t)),A([e])},ta.selectAll=function(n){var t;return"string"==typeof n?(t=ra(xa(n,ua)),t.parentNode=ua.documentElement):(t=n,t.parentNode=null),A([t])},_a.on=function(n,t,e){var r=arguments.length;if(3>r){if("string"!=typeof n){2>r&&(t=!1);for(e in n)this.each(X(e,n[e],t));return this}if(2>r)return(r=this.node()["__on"+n])&&r._;e=!1}return this.each(X(n,t,e))};var ka=ta.map({mouseenter:"mouseover",mouseleave:"mouseout"});ua&&ka.forEach(function(n){"on"+n in ua&&ka.remove(n)});var Ea,Aa=0;ta.mouse=function(n){return J(n,k())};var Na=this.navigator&&/WebKit/.test(this.navigator.userAgent)?-1:0;ta.touch=function(n,t,e){if(arguments.length<3&&(e=t,t=k().changedTouches),t)for(var r,u=0,i=t.length;i>u;++u)if((r=t[u]).identifier===e)return J(n,r)},ta.behavior.drag=function(){function n(){this.on("mousedown.drag",i).on("touchstart.drag",o)}function e(n,t,e,i,o){return function(){function a(){var n,e,r=t(h,v);r&&(n=r[0]-M[0],e=r[1]-M[1],p|=n|e,M=r,g({type:"drag",x:r[0]+l[0],y:r[1]+l[1],dx:n,dy:e}))}function c(){t(h,v)&&(m.on(i+d,null).on(o+d,null),y(p&&ta.event.target===f),g({type:"dragend"}))}var l,s=this,f=ta.event.target,h=s.parentNode,g=r.of(s,arguments),p=0,v=n(),d=".drag"+(null==v?"":"-"+v),m=ta.select(e(f)).on(i+d,a).on(o+d,c),y=W(f),M=t(h,v);u?(l=u.apply(s,arguments),l=[l.x-M[0],l.y-M[1]]):l=[0,0],g({type:"dragstart"})}}var r=E(n,"drag","dragstart","dragend"),u=null,i=e(b,ta.mouse,t,"mousemove","mouseup"),o=e(G,ta.touch,y,"touchmove","touchend");return n.origin=function(t){return arguments.length?(u=t,n):u},ta.rebind(n,r,"on")},ta.touches=function(n,t){return arguments.length<2&&(t=k().touches),t?ra(t).map(function(t){var e=J(n,t);return e.identifier=t.identifier,e}):[]};var Ca=1e-6,za=Ca*Ca,qa=Math.PI,La=2*qa,Ta=La-Ca,Ra=qa/2,Da=qa/180,Pa=180/qa,Ua=Math.SQRT2,ja=2,Fa=4;ta.interpolateZoom=function(n,t){function e(n){var t=n*y;if(m){var e=rt(v),o=i/(ja*h)*(e*ut(Ua*t+v)-et(v));return[r+o*l,u+o*s,i*e/rt(Ua*t+v)]}return[r+n*l,u+n*s,i*Math.exp(Ua*t)]}var r=n[0],u=n[1],i=n[2],o=t[0],a=t[1],c=t[2],l=o-r,s=a-u,f=l*l+s*s,h=Math.sqrt(f),g=(c*c-i*i+Fa*f)/(2*i*ja*h),p=(c*c-i*i-Fa*f)/(2*c*ja*h),v=Math.log(Math.sqrt(g*g+1)-g),d=Math.log(Math.sqrt(p*p+1)-p),m=d-v,y=(m||Math.log(c/i))/Ua;return e.duration=1e3*y,e},ta.behavior.zoom=function(){function n(n){n.on(q,f).on(Oa+".zoom",g).on("dblclick.zoom",p).on(R,h)}function e(n){return[(n[0]-k.x)/k.k,(n[1]-k.y)/k.k]}function r(n){return[n[0]*k.k+k.x,n[1]*k.k+k.y]}function u(n){k.k=Math.max(N[0],Math.min(N[1],n))}function i(n,t){t=r(t),k.x+=n[0]-t[0],k.y+=n[1]-t[1]}function o(t,e,r,o){t.__chart__={x:k.x,y:k.y,k:k.k},u(Math.pow(2,o)),i(d=e,r),t=ta.select(t),C>0&&(t=t.transition().duration(C)),t.call(n.event)}function a(){b&&b.domain(x.range().map(function(n){return(n-k.x)/k.k}).map(x.invert)),w&&w.domain(_.range().map(function(n){return(n-k.y)/k.k}).map(_.invert))}function c(n){z++||n({type:"zoomstart"})}function l(n){a(),n({type:"zoom",scale:k.k,translate:[k.x,k.y]})}function s(n){--z||n({type:"zoomend"}),d=null}function f(){function n(){f=1,i(ta.mouse(u),g),l(a)}function r(){h.on(L,null).on(T,null),p(f&&ta.event.target===o),s(a)}var u=this,o=ta.event.target,a=D.of(u,arguments),f=0,h=ta.select(t(u)).on(L,n).on(T,r),g=e(ta.mouse(u)),p=W(u);Dl.call(u),c(a)}function h(){function n(){var n=ta.touches(p);return g=k.k,n.forEach(function(n){n.identifier in d&&(d[n.identifier]=e(n))}),n}function t(){var t=ta.event.target;ta.select(t).on(x,r).on(b,a),_.push(t);for(var e=ta.event.changedTouches,u=0,i=e.length;i>u;++u)d[e[u].identifier]=null;var c=n(),l=Date.now();if(1===c.length){if(500>l-M){var s=c[0];o(p,s,d[s.identifier],Math.floor(Math.log(k.k)/Math.LN2)+1),S()}M=l}else if(c.length>1){var s=c[0],f=c[1],h=s[0]-f[0],g=s[1]-f[1];m=h*h+g*g}}function r(){var n,t,e,r,o=ta.touches(p);Dl.call(p);for(var a=0,c=o.length;c>a;++a,r=null)if(e=o[a],r=d[e.identifier]){if(t)break;n=e,t=r}if(r){var s=(s=e[0]-n[0])*s+(s=e[1]-n[1])*s,f=m&&Math.sqrt(s/m);n=[(n[0]+e[0])/2,(n[1]+e[1])/2],t=[(t[0]+r[0])/2,(t[1]+r[1])/2],u(f*g)}M=null,i(n,t),l(v)}function a(){if(ta.event.touches.length){for(var t=ta.event.changedTouches,e=0,r=t.length;r>e;++e)delete d[t[e].identifier];for(var u in d)return void n()}ta.selectAll(_).on(y,null),w.on(q,f).on(R,h),E(),s(v)}var g,p=this,v=D.of(p,arguments),d={},m=0,y=".zoom-"+ta.event.changedTouches[0].identifier,x="touchmove"+y,b="touchend"+y,_=[],w=ta.select(p),E=W(p);t(),c(v),w.on(q,null).on(R,t)}function g(){var n=D.of(this,arguments);y?clearTimeout(y):(v=e(d=m||ta.mouse(this)),Dl.call(this),c(n)),y=setTimeout(function(){y=null,s(n)},50),S(),u(Math.pow(2,.002*Ha())*k.k),i(d,v),l(n)}function p(){var n=ta.mouse(this),t=Math.log(k.k)/Math.LN2;o(this,n,e(n),ta.event.shiftKey?Math.ceil(t)-1:Math.floor(t)+1)}var v,d,m,y,M,x,b,_,w,k={x:0,y:0,k:1},A=[960,500],N=Ia,C=250,z=0,q="mousedown.zoom",L="mousemove.zoom",T="mouseup.zoom",R="touchstart.zoom",D=E(n,"zoomstart","zoom","zoomend");return Oa||(Oa="onwheel"in ua?(Ha=function(){return-ta.event.deltaY*(ta.event.deltaMode?120:1)},"wheel"):"onmousewheel"in ua?(Ha=function(){return ta.event.wheelDelta},"mousewheel"):(Ha=function(){return-ta.event.detail},"MozMousePixelScroll")),n.event=function(n){n.each(function(){var n=D.of(this,arguments),t=k;Tl?ta.select(this).transition().each("start.zoom",function(){k=this.__chart__||{x:0,y:0,k:1},c(n)}).tween("zoom:zoom",function(){var e=A[0],r=A[1],u=d?d[0]:e/2,i=d?d[1]:r/2,o=ta.interpolateZoom([(u-k.x)/k.k,(i-k.y)/k.k,e/k.k],[(u-t.x)/t.k,(i-t.y)/t.k,e/t.k]);return function(t){var r=o(t),a=e/r[2];this.__chart__=k={x:u-r[0]*a,y:i-r[1]*a,k:a},l(n)}}).each("interrupt.zoom",function(){s(n)}).each("end.zoom",function(){s(n)}):(this.__chart__=k,c(n),l(n),s(n))})},n.translate=function(t){return arguments.length?(k={x:+t[0],y:+t[1],k:k.k},a(),n):[k.x,k.y]},n.scale=function(t){return arguments.length?(k={x:k.x,y:k.y,k:+t},a(),n):k.k},n.scaleExtent=function(t){return arguments.length?(N=null==t?Ia:[+t[0],+t[1]],n):N},n.center=function(t){return arguments.length?(m=t&&[+t[0],+t[1]],n):m},n.size=function(t){return arguments.length?(A=t&&[+t[0],+t[1]],n):A},n.duration=function(t){return arguments.length?(C=+t,n):C},n.x=function(t){return arguments.length?(b=t,x=t.copy(),k={x:0,y:0,k:1},n):b},n.y=function(t){return arguments.length?(w=t,_=t.copy(),k={x:0,y:0,k:1},n):w},ta.rebind(n,D,"on")};var Ha,Oa,Ia=[0,1/0];ta.color=ot,ot.prototype.toString=function(){return this.rgb()+""},ta.hsl=at;var Ya=at.prototype=new ot;Ya.brighter=function(n){return n=Math.pow(.7,arguments.length?n:1),new at(this.h,this.s,this.l/n)},Ya.darker=function(n){return n=Math.pow(.7,arguments.length?n:1),new at(this.h,this.s,n*this.l)},Ya.rgb=function(){return ct(this.h,this.s,this.l)},ta.hcl=lt;var Za=lt.prototype=new ot;Za.brighter=function(n){return new lt(this.h,this.c,Math.min(100,this.l+Va*(arguments.length?n:1)))},Za.darker=function(n){return new lt(this.h,this.c,Math.max(0,this.l-Va*(arguments.length?n:1)))},Za.rgb=function(){return st(this.h,this.c,this.l).rgb()},ta.lab=ft;var Va=18,Xa=.95047,$a=1,Ba=1.08883,Wa=ft.prototype=new ot;Wa.brighter=function(n){return new ft(Math.min(100,this.l+Va*(arguments.length?n:1)),this.a,this.b)},Wa.darker=function(n){return new ft(Math.max(0,this.l-Va*(arguments.length?n:1)),this.a,this.b)},Wa.rgb=function(){return ht(this.l,this.a,this.b)},ta.rgb=mt;var Ja=mt.prototype=new ot;Ja.brighter=function(n){n=Math.pow(.7,arguments.length?n:1);var t=this.r,e=this.g,r=this.b,u=30;return t||e||r?(t&&u>t&&(t=u),e&&u>e&&(e=u),r&&u>r&&(r=u),new mt(Math.min(255,t/n),Math.min(255,e/n),Math.min(255,r/n))):new mt(u,u,u)},Ja.darker=function(n){return n=Math.pow(.7,arguments.length?n:1),new mt(n*this.r,n*this.g,n*this.b)},Ja.hsl=function(){return _t(this.r,this.g,this.b)},Ja.toString=function(){return"#"+xt(this.r)+xt(this.g)+xt(this.b)};var Ga=ta.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});Ga.forEach(function(n,t){Ga.set(n,yt(t))}),ta.functor=Et,ta.xhr=At(y),ta.dsv=function(n,t){function e(n,e,i){arguments.length<3&&(i=e,e=null);var o=Nt(n,t,null==e?r:u(e),i);return o.row=function(n){return arguments.length?o.response(null==(e=n)?r:u(n)):e},o}function r(n){return e.parse(n.responseText)}function u(n){return function(t){return e.parse(t.responseText,n)}}function i(t){return t.map(o).join(n)}function o(n){return a.test(n)?'"'+n.replace(/\"/g,'""')+'"':n}var a=new RegExp('["'+n+"\n]"),c=n.charCodeAt(0);return e.parse=function(n,t){var r;return e.parseRows(n,function(n,e){if(r)return r(n,e-1);var u=new Function("d","return {"+n.map(function(n,t){return JSON.stringify(n)+": d["+t+"]"}).join(",")+"}");r=t?function(n,e){return t(u(n),e)}:u})},e.parseRows=function(n,t){function e(){if(s>=l)return o;if(u)return u=!1,i;var t=s;if(34===n.charCodeAt(t)){for(var e=t;e++<l;)if(34===n.charCodeAt(e)){if(34!==n.charCodeAt(e+1))break;++e}s=e+2;var r=n.charCodeAt(e+1);return 13===r?(u=!0,10===n.charCodeAt(e+2)&&++s):10===r&&(u=!0),n.slice(t+1,e).replace(/""/g,'"')}for(;l>s;){var r=n.charCodeAt(s++),a=1;if(10===r)u=!0;else if(13===r)u=!0,10===n.charCodeAt(s)&&(++s,++a);else if(r!==c)continue;return n.slice(t,s-a)}return n.slice(t)}for(var r,u,i={},o={},a=[],l=n.length,s=0,f=0;(r=e())!==o;){for(var h=[];r!==i&&r!==o;)h.push(r),r=e();t&&null==(h=t(h,f++))||a.push(h)}return a},e.format=function(t){if(Array.isArray(t[0]))return e.formatRows(t);var r=new m,u=[];return t.forEach(function(n){for(var t in n)r.has(t)||u.push(r.add(t))}),[u.map(o).join(n)].concat(t.map(function(t){return u.map(function(n){return o(t[n])}).join(n)})).join("\n")},e.formatRows=function(n){return n.map(i).join("\n")},e},ta.csv=ta.dsv(",","text/csv"),ta.tsv=ta.dsv("	","text/tab-separated-values");var Ka,Qa,nc,tc,ec,rc=this[x(this,"requestAnimationFrame")]||function(n){setTimeout(n,17)};ta.timer=function(n,t,e){var r=arguments.length;2>r&&(t=0),3>r&&(e=Date.now());var u=e+t,i={c:n,t:u,f:!1,n:null};Qa?Qa.n=i:Ka=i,Qa=i,nc||(tc=clearTimeout(tc),nc=1,rc(qt))},ta.timer.flush=function(){Lt(),Tt()},ta.round=function(n,t){return t?Math.round(n*(t=Math.pow(10,t)))/t:Math.round(n)};var uc=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map(Dt);ta.formatPrefix=function(n,t){var e=0;return n&&(0>n&&(n*=-1),t&&(n=ta.round(n,Rt(n,t))),e=1+Math.floor(1e-12+Math.log(n)/Math.LN10),e=Math.max(-24,Math.min(24,3*Math.floor((e-1)/3)))),uc[8+e/3]};var ic=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,oc=ta.map({b:function(n){return n.toString(2)},c:function(n){return String.fromCharCode(n)},o:function(n){return n.toString(8)},x:function(n){return n.toString(16)},X:function(n){return n.toString(16).toUpperCase()},g:function(n,t){return n.toPrecision(t)},e:function(n,t){return n.toExponential(t)},f:function(n,t){return n.toFixed(t)},r:function(n,t){return(n=ta.round(n,Rt(n,t))).toFixed(Math.max(0,Math.min(20,Rt(n*(1+1e-15),t))))}}),ac=ta.time={},cc=Date;jt.prototype={getDate:function(){return this._.getUTCDate()},getDay:function(){return this._.getUTCDay()},getFullYear:function(){return this._.getUTCFullYear()},getHours:function(){return this._.getUTCHours()},getMilliseconds:function(){return this._.getUTCMilliseconds()},getMinutes:function(){return this._.getUTCMinutes()},getMonth:function(){return this._.getUTCMonth()},getSeconds:function(){return this._.getUTCSeconds()},getTime:function(){return this._.getTime()},getTimezoneOffset:function(){return 0},valueOf:function(){return this._.valueOf()},setDate:function(){lc.setUTCDate.apply(this._,arguments)},setDay:function(){lc.setUTCDay.apply(this._,arguments)},setFullYear:function(){lc.setUTCFullYear.apply(this._,arguments)},setHours:function(){lc.setUTCHours.apply(this._,arguments)},setMilliseconds:function(){lc.setUTCMilliseconds.apply(this._,arguments)},setMinutes:function(){lc.setUTCMinutes.apply(this._,arguments)},setMonth:function(){lc.setUTCMonth.apply(this._,arguments)},setSeconds:function(){lc.setUTCSeconds.apply(this._,arguments)},setTime:function(){lc.setTime.apply(this._,arguments)}};var lc=Date.prototype;ac.year=Ft(function(n){return n=ac.day(n),n.setMonth(0,1),n},function(n,t){n.setFullYear(n.getFullYear()+t)},function(n){return n.getFullYear()}),ac.years=ac.year.range,ac.years.utc=ac.year.utc.range,ac.day=Ft(function(n){var t=new cc(2e3,0);return t.setFullYear(n.getFullYear(),n.getMonth(),n.getDate()),t},function(n,t){n.setDate(n.getDate()+t)},function(n){return n.getDate()-1}),ac.days=ac.day.range,ac.days.utc=ac.day.utc.range,ac.dayOfYear=function(n){var t=ac.year(n);return Math.floor((n-t-6e4*(n.getTimezoneOffset()-t.getTimezoneOffset()))/864e5)},["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach(function(n,t){t=7-t;var e=ac[n]=Ft(function(n){return(n=ac.day(n)).setDate(n.getDate()-(n.getDay()+t)%7),n},function(n,t){n.setDate(n.getDate()+7*Math.floor(t))},function(n){var e=ac.year(n).getDay();return Math.floor((ac.dayOfYear(n)+(e+t)%7)/7)-(e!==t)});ac[n+"s"]=e.range,ac[n+"s"].utc=e.utc.range,ac[n+"OfYear"]=function(n){var e=ac.year(n).getDay();return Math.floor((ac.dayOfYear(n)+(e+t)%7)/7)}}),ac.week=ac.sunday,ac.weeks=ac.sunday.range,ac.weeks.utc=ac.sunday.utc.range,ac.weekOfYear=ac.sundayOfYear;var sc={"-":"",_:" ",0:"0"},fc=/^\s*\d+/,hc=/^%/;ta.locale=function(n){return{numberFormat:Pt(n),timeFormat:Ot(n)}};var gc=ta.locale({decimal:".",thousands:",",grouping:[3],currency:["$",""],dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});ta.format=gc.numberFormat,ta.geo={},ce.prototype={s:0,t:0,add:function(n){le(n,this.t,pc),le(pc.s,this.s,this),this.s?this.t+=pc.t:this.s=pc.t
},reset:function(){this.s=this.t=0},valueOf:function(){return this.s}};var pc=new ce;ta.geo.stream=function(n,t){n&&vc.hasOwnProperty(n.type)?vc[n.type](n,t):se(n,t)};var vc={Feature:function(n,t){se(n.geometry,t)},FeatureCollection:function(n,t){for(var e=n.features,r=-1,u=e.length;++r<u;)se(e[r].geometry,t)}},dc={Sphere:function(n,t){t.sphere()},Point:function(n,t){n=n.coordinates,t.point(n[0],n[1],n[2])},MultiPoint:function(n,t){for(var e=n.coordinates,r=-1,u=e.length;++r<u;)n=e[r],t.point(n[0],n[1],n[2])},LineString:function(n,t){fe(n.coordinates,t,0)},MultiLineString:function(n,t){for(var e=n.coordinates,r=-1,u=e.length;++r<u;)fe(e[r],t,0)},Polygon:function(n,t){he(n.coordinates,t)},MultiPolygon:function(n,t){for(var e=n.coordinates,r=-1,u=e.length;++r<u;)he(e[r],t)},GeometryCollection:function(n,t){for(var e=n.geometries,r=-1,u=e.length;++r<u;)se(e[r],t)}};ta.geo.area=function(n){return mc=0,ta.geo.stream(n,Mc),mc};var mc,yc=new ce,Mc={sphere:function(){mc+=4*qa},point:b,lineStart:b,lineEnd:b,polygonStart:function(){yc.reset(),Mc.lineStart=ge},polygonEnd:function(){var n=2*yc;mc+=0>n?4*qa+n:n,Mc.lineStart=Mc.lineEnd=Mc.point=b}};ta.geo.bounds=function(){function n(n,t){M.push(x=[s=n,h=n]),f>t&&(f=t),t>g&&(g=t)}function t(t,e){var r=pe([t*Da,e*Da]);if(m){var u=de(m,r),i=[u[1],-u[0],0],o=de(i,u);Me(o),o=xe(o);var c=t-p,l=c>0?1:-1,v=o[0]*Pa*l,d=ga(c)>180;if(d^(v>l*p&&l*t>v)){var y=o[1]*Pa;y>g&&(g=y)}else if(v=(v+360)%360-180,d^(v>l*p&&l*t>v)){var y=-o[1]*Pa;f>y&&(f=y)}else f>e&&(f=e),e>g&&(g=e);d?p>t?a(s,t)>a(s,h)&&(h=t):a(t,h)>a(s,h)&&(s=t):h>=s?(s>t&&(s=t),t>h&&(h=t)):t>p?a(s,t)>a(s,h)&&(h=t):a(t,h)>a(s,h)&&(s=t)}else n(t,e);m=r,p=t}function e(){b.point=t}function r(){x[0]=s,x[1]=h,b.point=n,m=null}function u(n,e){if(m){var r=n-p;y+=ga(r)>180?r+(r>0?360:-360):r}else v=n,d=e;Mc.point(n,e),t(n,e)}function i(){Mc.lineStart()}function o(){u(v,d),Mc.lineEnd(),ga(y)>Ca&&(s=-(h=180)),x[0]=s,x[1]=h,m=null}function a(n,t){return(t-=n)<0?t+360:t}function c(n,t){return n[0]-t[0]}function l(n,t){return t[0]<=t[1]?t[0]<=n&&n<=t[1]:n<t[0]||t[1]<n}var s,f,h,g,p,v,d,m,y,M,x,b={point:n,lineStart:e,lineEnd:r,polygonStart:function(){b.point=u,b.lineStart=i,b.lineEnd=o,y=0,Mc.polygonStart()},polygonEnd:function(){Mc.polygonEnd(),b.point=n,b.lineStart=e,b.lineEnd=r,0>yc?(s=-(h=180),f=-(g=90)):y>Ca?g=90:-Ca>y&&(f=-90),x[0]=s,x[1]=h}};return function(n){g=h=-(s=f=1/0),M=[],ta.geo.stream(n,b);var t=M.length;if(t){M.sort(c);for(var e,r=1,u=M[0],i=[u];t>r;++r)e=M[r],l(e[0],u)||l(e[1],u)?(a(u[0],e[1])>a(u[0],u[1])&&(u[1]=e[1]),a(e[0],u[1])>a(u[0],u[1])&&(u[0]=e[0])):i.push(u=e);for(var o,e,p=-1/0,t=i.length-1,r=0,u=i[t];t>=r;u=e,++r)e=i[r],(o=a(u[1],e[0]))>p&&(p=o,s=e[0],h=u[1])}return M=x=null,1/0===s||1/0===f?[[0/0,0/0],[0/0,0/0]]:[[s,f],[h,g]]}}(),ta.geo.centroid=function(n){xc=bc=_c=wc=Sc=kc=Ec=Ac=Nc=Cc=zc=0,ta.geo.stream(n,qc);var t=Nc,e=Cc,r=zc,u=t*t+e*e+r*r;return za>u&&(t=kc,e=Ec,r=Ac,Ca>bc&&(t=_c,e=wc,r=Sc),u=t*t+e*e+r*r,za>u)?[0/0,0/0]:[Math.atan2(e,t)*Pa,tt(r/Math.sqrt(u))*Pa]};var xc,bc,_c,wc,Sc,kc,Ec,Ac,Nc,Cc,zc,qc={sphere:b,point:_e,lineStart:Se,lineEnd:ke,polygonStart:function(){qc.lineStart=Ee},polygonEnd:function(){qc.lineStart=Se}},Lc=Le(Ne,Pe,je,[-qa,-qa/2]),Tc=1e9;ta.geo.clipExtent=function(){var n,t,e,r,u,i,o={stream:function(n){return u&&(u.valid=!1),u=i(n),u.valid=!0,u},extent:function(a){return arguments.length?(i=Ie(n=+a[0][0],t=+a[0][1],e=+a[1][0],r=+a[1][1]),u&&(u.valid=!1,u=null),o):[[n,t],[e,r]]}};return o.extent([[0,0],[960,500]])},(ta.geo.conicEqualArea=function(){return Ye(Ze)}).raw=Ze,ta.geo.albers=function(){return ta.geo.conicEqualArea().rotate([96,0]).center([-.6,38.7]).parallels([29.5,45.5]).scale(1070)},ta.geo.albersUsa=function(){function n(n){var i=n[0],o=n[1];return t=null,e(i,o),t||(r(i,o),t)||u(i,o),t}var t,e,r,u,i=ta.geo.albers(),o=ta.geo.conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),a=ta.geo.conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),c={point:function(n,e){t=[n,e]}};return n.invert=function(n){var t=i.scale(),e=i.translate(),r=(n[0]-e[0])/t,u=(n[1]-e[1])/t;return(u>=.12&&.234>u&&r>=-.425&&-.214>r?o:u>=.166&&.234>u&&r>=-.214&&-.115>r?a:i).invert(n)},n.stream=function(n){var t=i.stream(n),e=o.stream(n),r=a.stream(n);return{point:function(n,u){t.point(n,u),e.point(n,u),r.point(n,u)},sphere:function(){t.sphere(),e.sphere(),r.sphere()},lineStart:function(){t.lineStart(),e.lineStart(),r.lineStart()},lineEnd:function(){t.lineEnd(),e.lineEnd(),r.lineEnd()},polygonStart:function(){t.polygonStart(),e.polygonStart(),r.polygonStart()},polygonEnd:function(){t.polygonEnd(),e.polygonEnd(),r.polygonEnd()}}},n.precision=function(t){return arguments.length?(i.precision(t),o.precision(t),a.precision(t),n):i.precision()},n.scale=function(t){return arguments.length?(i.scale(t),o.scale(.35*t),a.scale(t),n.translate(i.translate())):i.scale()},n.translate=function(t){if(!arguments.length)return i.translate();var l=i.scale(),s=+t[0],f=+t[1];return e=i.translate(t).clipExtent([[s-.455*l,f-.238*l],[s+.455*l,f+.238*l]]).stream(c).point,r=o.translate([s-.307*l,f+.201*l]).clipExtent([[s-.425*l+Ca,f+.12*l+Ca],[s-.214*l-Ca,f+.234*l-Ca]]).stream(c).point,u=a.translate([s-.205*l,f+.212*l]).clipExtent([[s-.214*l+Ca,f+.166*l+Ca],[s-.115*l-Ca,f+.234*l-Ca]]).stream(c).point,n},n.scale(1070)};var Rc,Dc,Pc,Uc,jc,Fc,Hc={point:b,lineStart:b,lineEnd:b,polygonStart:function(){Dc=0,Hc.lineStart=Ve},polygonEnd:function(){Hc.lineStart=Hc.lineEnd=Hc.point=b,Rc+=ga(Dc/2)}},Oc={point:Xe,lineStart:b,lineEnd:b,polygonStart:b,polygonEnd:b},Ic={point:We,lineStart:Je,lineEnd:Ge,polygonStart:function(){Ic.lineStart=Ke},polygonEnd:function(){Ic.point=We,Ic.lineStart=Je,Ic.lineEnd=Ge}};ta.geo.path=function(){function n(n){return n&&("function"==typeof a&&i.pointRadius(+a.apply(this,arguments)),o&&o.valid||(o=u(i)),ta.geo.stream(n,o)),i.result()}function t(){return o=null,n}var e,r,u,i,o,a=4.5;return n.area=function(n){return Rc=0,ta.geo.stream(n,u(Hc)),Rc},n.centroid=function(n){return _c=wc=Sc=kc=Ec=Ac=Nc=Cc=zc=0,ta.geo.stream(n,u(Ic)),zc?[Nc/zc,Cc/zc]:Ac?[kc/Ac,Ec/Ac]:Sc?[_c/Sc,wc/Sc]:[0/0,0/0]},n.bounds=function(n){return jc=Fc=-(Pc=Uc=1/0),ta.geo.stream(n,u(Oc)),[[Pc,Uc],[jc,Fc]]},n.projection=function(n){return arguments.length?(u=(e=n)?n.stream||tr(n):y,t()):e},n.context=function(n){return arguments.length?(i=null==(r=n)?new $e:new Qe(n),"function"!=typeof a&&i.pointRadius(a),t()):r},n.pointRadius=function(t){return arguments.length?(a="function"==typeof t?t:(i.pointRadius(+t),+t),n):a},n.projection(ta.geo.albersUsa()).context(null)},ta.geo.transform=function(n){return{stream:function(t){var e=new er(t);for(var r in n)e[r]=n[r];return e}}},er.prototype={point:function(n,t){this.stream.point(n,t)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}},ta.geo.projection=ur,ta.geo.projectionMutator=ir,(ta.geo.equirectangular=function(){return ur(ar)}).raw=ar.invert=ar,ta.geo.rotation=function(n){function t(t){return t=n(t[0]*Da,t[1]*Da),t[0]*=Pa,t[1]*=Pa,t}return n=lr(n[0]%360*Da,n[1]*Da,n.length>2?n[2]*Da:0),t.invert=function(t){return t=n.invert(t[0]*Da,t[1]*Da),t[0]*=Pa,t[1]*=Pa,t},t},cr.invert=ar,ta.geo.circle=function(){function n(){var n="function"==typeof r?r.apply(this,arguments):r,t=lr(-n[0]*Da,-n[1]*Da,0).invert,u=[];return e(null,null,1,{point:function(n,e){u.push(n=t(n,e)),n[0]*=Pa,n[1]*=Pa}}),{type:"Polygon",coordinates:[u]}}var t,e,r=[0,0],u=6;return n.origin=function(t){return arguments.length?(r=t,n):r},n.angle=function(r){return arguments.length?(e=gr((t=+r)*Da,u*Da),n):t},n.precision=function(r){return arguments.length?(e=gr(t*Da,(u=+r)*Da),n):u},n.angle(90)},ta.geo.distance=function(n,t){var e,r=(t[0]-n[0])*Da,u=n[1]*Da,i=t[1]*Da,o=Math.sin(r),a=Math.cos(r),c=Math.sin(u),l=Math.cos(u),s=Math.sin(i),f=Math.cos(i);return Math.atan2(Math.sqrt((e=f*o)*e+(e=l*s-c*f*a)*e),c*s+l*f*a)},ta.geo.graticule=function(){function n(){return{type:"MultiLineString",coordinates:t()}}function t(){return ta.range(Math.ceil(i/d)*d,u,d).map(h).concat(ta.range(Math.ceil(l/m)*m,c,m).map(g)).concat(ta.range(Math.ceil(r/p)*p,e,p).filter(function(n){return ga(n%d)>Ca}).map(s)).concat(ta.range(Math.ceil(a/v)*v,o,v).filter(function(n){return ga(n%m)>Ca}).map(f))}var e,r,u,i,o,a,c,l,s,f,h,g,p=10,v=p,d=90,m=360,y=2.5;return n.lines=function(){return t().map(function(n){return{type:"LineString",coordinates:n}})},n.outline=function(){return{type:"Polygon",coordinates:[h(i).concat(g(c).slice(1),h(u).reverse().slice(1),g(l).reverse().slice(1))]}},n.extent=function(t){return arguments.length?n.majorExtent(t).minorExtent(t):n.minorExtent()},n.majorExtent=function(t){return arguments.length?(i=+t[0][0],u=+t[1][0],l=+t[0][1],c=+t[1][1],i>u&&(t=i,i=u,u=t),l>c&&(t=l,l=c,c=t),n.precision(y)):[[i,l],[u,c]]},n.minorExtent=function(t){return arguments.length?(r=+t[0][0],e=+t[1][0],a=+t[0][1],o=+t[1][1],r>e&&(t=r,r=e,e=t),a>o&&(t=a,a=o,o=t),n.precision(y)):[[r,a],[e,o]]},n.step=function(t){return arguments.length?n.majorStep(t).minorStep(t):n.minorStep()},n.majorStep=function(t){return arguments.length?(d=+t[0],m=+t[1],n):[d,m]},n.minorStep=function(t){return arguments.length?(p=+t[0],v=+t[1],n):[p,v]},n.precision=function(t){return arguments.length?(y=+t,s=vr(a,o,90),f=dr(r,e,y),h=vr(l,c,90),g=dr(i,u,y),n):y},n.majorExtent([[-180,-90+Ca],[180,90-Ca]]).minorExtent([[-180,-80-Ca],[180,80+Ca]])},ta.geo.greatArc=function(){function n(){return{type:"LineString",coordinates:[t||r.apply(this,arguments),e||u.apply(this,arguments)]}}var t,e,r=mr,u=yr;return n.distance=function(){return ta.geo.distance(t||r.apply(this,arguments),e||u.apply(this,arguments))},n.source=function(e){return arguments.length?(r=e,t="function"==typeof e?null:e,n):r},n.target=function(t){return arguments.length?(u=t,e="function"==typeof t?null:t,n):u},n.precision=function(){return arguments.length?n:0},n},ta.geo.interpolate=function(n,t){return Mr(n[0]*Da,n[1]*Da,t[0]*Da,t[1]*Da)},ta.geo.length=function(n){return Yc=0,ta.geo.stream(n,Zc),Yc};var Yc,Zc={sphere:b,point:b,lineStart:xr,lineEnd:b,polygonStart:b,polygonEnd:b},Vc=br(function(n){return Math.sqrt(2/(1+n))},function(n){return 2*Math.asin(n/2)});(ta.geo.azimuthalEqualArea=function(){return ur(Vc)}).raw=Vc;var Xc=br(function(n){var t=Math.acos(n);return t&&t/Math.sin(t)},y);(ta.geo.azimuthalEquidistant=function(){return ur(Xc)}).raw=Xc,(ta.geo.conicConformal=function(){return Ye(_r)}).raw=_r,(ta.geo.conicEquidistant=function(){return Ye(wr)}).raw=wr;var $c=br(function(n){return 1/n},Math.atan);(ta.geo.gnomonic=function(){return ur($c)}).raw=$c,Sr.invert=function(n,t){return[n,2*Math.atan(Math.exp(t))-Ra]},(ta.geo.mercator=function(){return kr(Sr)}).raw=Sr;var Bc=br(function(){return 1},Math.asin);(ta.geo.orthographic=function(){return ur(Bc)}).raw=Bc;var Wc=br(function(n){return 1/(1+n)},function(n){return 2*Math.atan(n)});(ta.geo.stereographic=function(){return ur(Wc)}).raw=Wc,Er.invert=function(n,t){return[-t,2*Math.atan(Math.exp(n))-Ra]},(ta.geo.transverseMercator=function(){var n=kr(Er),t=n.center,e=n.rotate;return n.center=function(n){return n?t([-n[1],n[0]]):(n=t(),[n[1],-n[0]])},n.rotate=function(n){return n?e([n[0],n[1],n.length>2?n[2]+90:90]):(n=e(),[n[0],n[1],n[2]-90])},e([0,0,90])}).raw=Er,ta.geom={},ta.geom.hull=function(n){function t(n){if(n.length<3)return[];var t,u=Et(e),i=Et(r),o=n.length,a=[],c=[];for(t=0;o>t;t++)a.push([+u.call(this,n[t],t),+i.call(this,n[t],t),t]);for(a.sort(zr),t=0;o>t;t++)c.push([a[t][0],-a[t][1]]);var l=Cr(a),s=Cr(c),f=s[0]===l[0],h=s[s.length-1]===l[l.length-1],g=[];for(t=l.length-1;t>=0;--t)g.push(n[a[l[t]][2]]);for(t=+f;t<s.length-h;++t)g.push(n[a[s[t]][2]]);return g}var e=Ar,r=Nr;return arguments.length?t(n):(t.x=function(n){return arguments.length?(e=n,t):e},t.y=function(n){return arguments.length?(r=n,t):r},t)},ta.geom.polygon=function(n){return ya(n,Jc),n};var Jc=ta.geom.polygon.prototype=[];Jc.area=function(){for(var n,t=-1,e=this.length,r=this[e-1],u=0;++t<e;)n=r,r=this[t],u+=n[1]*r[0]-n[0]*r[1];return.5*u},Jc.centroid=function(n){var t,e,r=-1,u=this.length,i=0,o=0,a=this[u-1];for(arguments.length||(n=-1/(6*this.area()));++r<u;)t=a,a=this[r],e=t[0]*a[1]-a[0]*t[1],i+=(t[0]+a[0])*e,o+=(t[1]+a[1])*e;return[i*n,o*n]},Jc.clip=function(n){for(var t,e,r,u,i,o,a=Tr(n),c=-1,l=this.length-Tr(this),s=this[l-1];++c<l;){for(t=n.slice(),n.length=0,u=this[c],i=t[(r=t.length-a)-1],e=-1;++e<r;)o=t[e],qr(o,s,u)?(qr(i,s,u)||n.push(Lr(i,o,s,u)),n.push(o)):qr(i,s,u)&&n.push(Lr(i,o,s,u)),i=o;a&&n.push(n[0]),s=u}return n};var Gc,Kc,Qc,nl,tl,el=[],rl=[];Or.prototype.prepare=function(){for(var n,t=this.edges,e=t.length;e--;)n=t[e].edge,n.b&&n.a||t.splice(e,1);return t.sort(Yr),t.length},Qr.prototype={start:function(){return this.edge.l===this.site?this.edge.a:this.edge.b},end:function(){return this.edge.l===this.site?this.edge.b:this.edge.a}},nu.prototype={insert:function(n,t){var e,r,u;if(n){if(t.P=n,t.N=n.N,n.N&&(n.N.P=t),n.N=t,n.R){for(n=n.R;n.L;)n=n.L;n.L=t}else n.R=t;e=n}else this._?(n=uu(this._),t.P=null,t.N=n,n.P=n.L=t,e=n):(t.P=t.N=null,this._=t,e=null);for(t.L=t.R=null,t.U=e,t.C=!0,n=t;e&&e.C;)r=e.U,e===r.L?(u=r.R,u&&u.C?(e.C=u.C=!1,r.C=!0,n=r):(n===e.R&&(eu(this,e),n=e,e=n.U),e.C=!1,r.C=!0,ru(this,r))):(u=r.L,u&&u.C?(e.C=u.C=!1,r.C=!0,n=r):(n===e.L&&(ru(this,e),n=e,e=n.U),e.C=!1,r.C=!0,eu(this,r))),e=n.U;this._.C=!1},remove:function(n){n.N&&(n.N.P=n.P),n.P&&(n.P.N=n.N),n.N=n.P=null;var t,e,r,u=n.U,i=n.L,o=n.R;if(e=i?o?uu(o):i:o,u?u.L===n?u.L=e:u.R=e:this._=e,i&&o?(r=e.C,e.C=n.C,e.L=i,i.U=e,e!==o?(u=e.U,e.U=n.U,n=e.R,u.L=n,e.R=o,o.U=e):(e.U=u,u=e,n=e.R)):(r=n.C,n=e),n&&(n.U=u),!r){if(n&&n.C)return void(n.C=!1);do{if(n===this._)break;if(n===u.L){if(t=u.R,t.C&&(t.C=!1,u.C=!0,eu(this,u),t=u.R),t.L&&t.L.C||t.R&&t.R.C){t.R&&t.R.C||(t.L.C=!1,t.C=!0,ru(this,t),t=u.R),t.C=u.C,u.C=t.R.C=!1,eu(this,u),n=this._;break}}else if(t=u.L,t.C&&(t.C=!1,u.C=!0,ru(this,u),t=u.L),t.L&&t.L.C||t.R&&t.R.C){t.L&&t.L.C||(t.R.C=!1,t.C=!0,eu(this,t),t=u.L),t.C=u.C,u.C=t.L.C=!1,ru(this,u),n=this._;break}t.C=!0,n=u,u=u.U}while(!n.C);n&&(n.C=!1)}}},ta.geom.voronoi=function(n){function t(n){var t=new Array(n.length),r=a[0][0],u=a[0][1],i=a[1][0],o=a[1][1];return iu(e(n),a).cells.forEach(function(e,a){var c=e.edges,l=e.site,s=t[a]=c.length?c.map(function(n){var t=n.start();return[t.x,t.y]}):l.x>=r&&l.x<=i&&l.y>=u&&l.y<=o?[[r,o],[i,o],[i,u],[r,u]]:[];s.point=n[a]}),t}function e(n){return n.map(function(n,t){return{x:Math.round(i(n,t)/Ca)*Ca,y:Math.round(o(n,t)/Ca)*Ca,i:t}})}var r=Ar,u=Nr,i=r,o=u,a=ul;return n?t(n):(t.links=function(n){return iu(e(n)).edges.filter(function(n){return n.l&&n.r}).map(function(t){return{source:n[t.l.i],target:n[t.r.i]}})},t.triangles=function(n){var t=[];return iu(e(n)).cells.forEach(function(e,r){for(var u,i,o=e.site,a=e.edges.sort(Yr),c=-1,l=a.length,s=a[l-1].edge,f=s.l===o?s.r:s.l;++c<l;)u=s,i=f,s=a[c].edge,f=s.l===o?s.r:s.l,r<i.i&&r<f.i&&au(o,i,f)<0&&t.push([n[r],n[i.i],n[f.i]])}),t},t.x=function(n){return arguments.length?(i=Et(r=n),t):r},t.y=function(n){return arguments.length?(o=Et(u=n),t):u},t.clipExtent=function(n){return arguments.length?(a=null==n?ul:n,t):a===ul?null:a},t.size=function(n){return arguments.length?t.clipExtent(n&&[[0,0],n]):a===ul?null:a&&a[1]},t)};var ul=[[-1e6,-1e6],[1e6,1e6]];ta.geom.delaunay=function(n){return ta.geom.voronoi().triangles(n)},ta.geom.quadtree=function(n,t,e,r,u){function i(n){function i(n,t,e,r,u,i,o,a){if(!isNaN(e)&&!isNaN(r))if(n.leaf){var c=n.x,s=n.y;if(null!=c)if(ga(c-e)+ga(s-r)<.01)l(n,t,e,r,u,i,o,a);else{var f=n.point;n.x=n.y=n.point=null,l(n,f,c,s,u,i,o,a),l(n,t,e,r,u,i,o,a)}else n.x=e,n.y=r,n.point=t}else l(n,t,e,r,u,i,o,a)}function l(n,t,e,r,u,o,a,c){var l=.5*(u+a),s=.5*(o+c),f=e>=l,h=r>=s,g=h<<1|f;n.leaf=!1,n=n.nodes[g]||(n.nodes[g]=su()),f?u=l:a=l,h?o=s:c=s,i(n,t,e,r,u,o,a,c)}var s,f,h,g,p,v,d,m,y,M=Et(a),x=Et(c);if(null!=t)v=t,d=e,m=r,y=u;else if(m=y=-(v=d=1/0),f=[],h=[],p=n.length,o)for(g=0;p>g;++g)s=n[g],s.x<v&&(v=s.x),s.y<d&&(d=s.y),s.x>m&&(m=s.x),s.y>y&&(y=s.y),f.push(s.x),h.push(s.y);else for(g=0;p>g;++g){var b=+M(s=n[g],g),_=+x(s,g);v>b&&(v=b),d>_&&(d=_),b>m&&(m=b),_>y&&(y=_),f.push(b),h.push(_)}var w=m-v,S=y-d;w>S?y=d+w:m=v+S;var k=su();if(k.add=function(n){i(k,n,+M(n,++g),+x(n,g),v,d,m,y)},k.visit=function(n){fu(n,k,v,d,m,y)},k.find=function(n){return hu(k,n[0],n[1],v,d,m,y)},g=-1,null==t){for(;++g<p;)i(k,n[g],f[g],h[g],v,d,m,y);--g}else n.forEach(k.add);return f=h=n=s=null,k}var o,a=Ar,c=Nr;return(o=arguments.length)?(a=cu,c=lu,3===o&&(u=e,r=t,e=t=0),i(n)):(i.x=function(n){return arguments.length?(a=n,i):a},i.y=function(n){return arguments.length?(c=n,i):c},i.extent=function(n){return arguments.length?(null==n?t=e=r=u=null:(t=+n[0][0],e=+n[0][1],r=+n[1][0],u=+n[1][1]),i):null==t?null:[[t,e],[r,u]]},i.size=function(n){return arguments.length?(null==n?t=e=r=u=null:(t=e=0,r=+n[0],u=+n[1]),i):null==t?null:[r-t,u-e]},i)},ta.interpolateRgb=gu,ta.interpolateObject=pu,ta.interpolateNumber=vu,ta.interpolateString=du;var il=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,ol=new RegExp(il.source,"g");ta.interpolate=mu,ta.interpolators=[function(n,t){var e=typeof t;return("string"===e?Ga.has(t)||/^(#|rgb\(|hsl\()/.test(t)?gu:du:t instanceof ot?gu:Array.isArray(t)?yu:"object"===e&&isNaN(t)?pu:vu)(n,t)}],ta.interpolateArray=yu;var al=function(){return y},cl=ta.map({linear:al,poly:ku,quad:function(){return _u},cubic:function(){return wu},sin:function(){return Eu},exp:function(){return Au},circle:function(){return Nu},elastic:Cu,back:zu,bounce:function(){return qu}}),ll=ta.map({"in":y,out:xu,"in-out":bu,"out-in":function(n){return bu(xu(n))}});ta.ease=function(n){var t=n.indexOf("-"),e=t>=0?n.slice(0,t):n,r=t>=0?n.slice(t+1):"in";return e=cl.get(e)||al,r=ll.get(r)||y,Mu(r(e.apply(null,ea.call(arguments,1))))},ta.interpolateHcl=Lu,ta.interpolateHsl=Tu,ta.interpolateLab=Ru,ta.interpolateRound=Du,ta.transform=function(n){var t=ua.createElementNS(ta.ns.prefix.svg,"g");return(ta.transform=function(n){if(null!=n){t.setAttribute("transform",n);var e=t.transform.baseVal.consolidate()}return new Pu(e?e.matrix:sl)})(n)},Pu.prototype.toString=function(){return"translate("+this.translate+")rotate("+this.rotate+")skewX("+this.skew+")scale("+this.scale+")"};var sl={a:1,b:0,c:0,d:1,e:0,f:0};ta.interpolateTransform=Hu,ta.layout={},ta.layout.bundle=function(){return function(n){for(var t=[],e=-1,r=n.length;++e<r;)t.push(Yu(n[e]));return t}},ta.layout.chord=function(){function n(){var n,l,f,h,g,p={},v=[],d=ta.range(i),m=[];for(e=[],r=[],n=0,h=-1;++h<i;){for(l=0,g=-1;++g<i;)l+=u[h][g];v.push(l),m.push(ta.range(i)),n+=l}for(o&&d.sort(function(n,t){return o(v[n],v[t])}),a&&m.forEach(function(n,t){n.sort(function(n,e){return a(u[t][n],u[t][e])})}),n=(La-s*i)/n,l=0,h=-1;++h<i;){for(f=l,g=-1;++g<i;){var y=d[h],M=m[y][g],x=u[y][M],b=l,_=l+=x*n;p[y+"-"+M]={index:y,subindex:M,startAngle:b,endAngle:_,value:x}}r[y]={index:y,startAngle:f,endAngle:l,value:(l-f)/n},l+=s}for(h=-1;++h<i;)for(g=h-1;++g<i;){var w=p[h+"-"+g],S=p[g+"-"+h];(w.value||S.value)&&e.push(w.value<S.value?{source:S,target:w}:{source:w,target:S})}c&&t()}function t(){e.sort(function(n,t){return c((n.source.value+n.target.value)/2,(t.source.value+t.target.value)/2)})}var e,r,u,i,o,a,c,l={},s=0;return l.matrix=function(n){return arguments.length?(i=(u=n)&&u.length,e=r=null,l):u},l.padding=function(n){return arguments.length?(s=n,e=r=null,l):s},l.sortGroups=function(n){return arguments.length?(o=n,e=r=null,l):o},l.sortSubgroups=function(n){return arguments.length?(a=n,e=null,l):a},l.sortChords=function(n){return arguments.length?(c=n,e&&t(),l):c},l.chords=function(){return e||n(),e},l.groups=function(){return r||n(),r},l},ta.layout.force=function(){function n(n){return function(t,e,r,u){if(t.point!==n){var i=t.cx-n.x,o=t.cy-n.y,a=u-e,c=i*i+o*o;if(c>a*a/d){if(p>c){var l=t.charge/c;n.px-=i*l,n.py-=o*l}return!0}if(t.point&&c&&p>c){var l=t.pointCharge/c;n.px-=i*l,n.py-=o*l}}return!t.charge}}function t(n){n.px=ta.event.x,n.py=ta.event.y,a.resume()}var e,r,u,i,o,a={},c=ta.dispatch("start","tick","end"),l=[1,1],s=.9,f=fl,h=hl,g=-30,p=gl,v=.1,d=.64,m=[],M=[];return a.tick=function(){if((r*=.99)<.005)return c.end({type:"end",alpha:r=0}),!0;var t,e,a,f,h,p,d,y,x,b=m.length,_=M.length;for(e=0;_>e;++e)a=M[e],f=a.source,h=a.target,y=h.x-f.x,x=h.y-f.y,(p=y*y+x*x)&&(p=r*i[e]*((p=Math.sqrt(p))-u[e])/p,y*=p,x*=p,h.x-=y*(d=f.weight/(h.weight+f.weight)),h.y-=x*d,f.x+=y*(d=1-d),f.y+=x*d);if((d=r*v)&&(y=l[0]/2,x=l[1]/2,e=-1,d))for(;++e<b;)a=m[e],a.x+=(y-a.x)*d,a.y+=(x-a.y)*d;if(g)for(Ju(t=ta.geom.quadtree(m),r,o),e=-1;++e<b;)(a=m[e]).fixed||t.visit(n(a));for(e=-1;++e<b;)a=m[e],a.fixed?(a.x=a.px,a.y=a.py):(a.x-=(a.px-(a.px=a.x))*s,a.y-=(a.py-(a.py=a.y))*s);c.tick({type:"tick",alpha:r})},a.nodes=function(n){return arguments.length?(m=n,a):m},a.links=function(n){return arguments.length?(M=n,a):M},a.size=function(n){return arguments.length?(l=n,a):l},a.linkDistance=function(n){return arguments.length?(f="function"==typeof n?n:+n,a):f},a.distance=a.linkDistance,a.linkStrength=function(n){return arguments.length?(h="function"==typeof n?n:+n,a):h},a.friction=function(n){return arguments.length?(s=+n,a):s},a.charge=function(n){return arguments.length?(g="function"==typeof n?n:+n,a):g},a.chargeDistance=function(n){return arguments.length?(p=n*n,a):Math.sqrt(p)},a.gravity=function(n){return arguments.length?(v=+n,a):v},a.theta=function(n){return arguments.length?(d=n*n,a):Math.sqrt(d)},a.alpha=function(n){return arguments.length?(n=+n,r?r=n>0?n:0:n>0&&(c.start({type:"start",alpha:r=n}),ta.timer(a.tick)),a):r},a.start=function(){function n(n,r){if(!e){for(e=new Array(c),a=0;c>a;++a)e[a]=[];for(a=0;s>a;++a){var u=M[a];e[u.source.index].push(u.target),e[u.target.index].push(u.source)}}for(var i,o=e[t],a=-1,l=o.length;++a<l;)if(!isNaN(i=o[a][n]))return i;return Math.random()*r}var t,e,r,c=m.length,s=M.length,p=l[0],v=l[1];for(t=0;c>t;++t)(r=m[t]).index=t,r.weight=0;for(t=0;s>t;++t)r=M[t],"number"==typeof r.source&&(r.source=m[r.source]),"number"==typeof r.target&&(r.target=m[r.target]),++r.source.weight,++r.target.weight;for(t=0;c>t;++t)r=m[t],isNaN(r.x)&&(r.x=n("x",p)),isNaN(r.y)&&(r.y=n("y",v)),isNaN(r.px)&&(r.px=r.x),isNaN(r.py)&&(r.py=r.y);if(u=[],"function"==typeof f)for(t=0;s>t;++t)u[t]=+f.call(this,M[t],t);else for(t=0;s>t;++t)u[t]=f;if(i=[],"function"==typeof h)for(t=0;s>t;++t)i[t]=+h.call(this,M[t],t);else for(t=0;s>t;++t)i[t]=h;if(o=[],"function"==typeof g)for(t=0;c>t;++t)o[t]=+g.call(this,m[t],t);else for(t=0;c>t;++t)o[t]=g;return a.resume()},a.resume=function(){return a.alpha(.1)},a.stop=function(){return a.alpha(0)},a.drag=function(){return e||(e=ta.behavior.drag().origin(y).on("dragstart.force",Xu).on("drag.force",t).on("dragend.force",$u)),arguments.length?void this.on("mouseover.force",Bu).on("mouseout.force",Wu).call(e):e},ta.rebind(a,c,"on")};var fl=20,hl=1,gl=1/0;ta.layout.hierarchy=function(){function n(u){var i,o=[u],a=[];for(u.depth=0;null!=(i=o.pop());)if(a.push(i),(l=e.call(n,i,i.depth))&&(c=l.length)){for(var c,l,s;--c>=0;)o.push(s=l[c]),s.parent=i,s.depth=i.depth+1;r&&(i.value=0),i.children=l}else r&&(i.value=+r.call(n,i,i.depth)||0),delete i.children;return Qu(u,function(n){var e,u;t&&(e=n.children)&&e.sort(t),r&&(u=n.parent)&&(u.value+=n.value)}),a}var t=ei,e=ni,r=ti;return n.sort=function(e){return arguments.length?(t=e,n):t},n.children=function(t){return arguments.length?(e=t,n):e},n.value=function(t){return arguments.length?(r=t,n):r},n.revalue=function(t){return r&&(Ku(t,function(n){n.children&&(n.value=0)}),Qu(t,function(t){var e;t.children||(t.value=+r.call(n,t,t.depth)||0),(e=t.parent)&&(e.value+=t.value)})),t},n},ta.layout.partition=function(){function n(t,e,r,u){var i=t.children;if(t.x=e,t.y=t.depth*u,t.dx=r,t.dy=u,i&&(o=i.length)){var o,a,c,l=-1;for(r=t.value?r/t.value:0;++l<o;)n(a=i[l],e,c=a.value*r,u),e+=c}}function t(n){var e=n.children,r=0;if(e&&(u=e.length))for(var u,i=-1;++i<u;)r=Math.max(r,t(e[i]));return 1+r}function e(e,i){var o=r.call(this,e,i);return n(o[0],0,u[0],u[1]/t(o[0])),o}var r=ta.layout.hierarchy(),u=[1,1];return e.size=function(n){return arguments.length?(u=n,e):u},Gu(e,r)},ta.layout.pie=function(){function n(o){var a,c=o.length,l=o.map(function(e,r){return+t.call(n,e,r)}),s=+("function"==typeof r?r.apply(this,arguments):r),f=("function"==typeof u?u.apply(this,arguments):u)-s,h=Math.min(Math.abs(f)/c,+("function"==typeof i?i.apply(this,arguments):i)),g=h*(0>f?-1:1),p=(f-c*g)/ta.sum(l),v=ta.range(c),d=[];return null!=e&&v.sort(e===pl?function(n,t){return l[t]-l[n]}:function(n,t){return e(o[n],o[t])}),v.forEach(function(n){d[n]={data:o[n],value:a=l[n],startAngle:s,endAngle:s+=a*p+g,padAngle:h}}),d}var t=Number,e=pl,r=0,u=La,i=0;return n.value=function(e){return arguments.length?(t=e,n):t},n.sort=function(t){return arguments.length?(e=t,n):e},n.startAngle=function(t){return arguments.length?(r=t,n):r},n.endAngle=function(t){return arguments.length?(u=t,n):u},n.padAngle=function(t){return arguments.length?(i=t,n):i},n};var pl={};ta.layout.stack=function(){function n(a,c){if(!(h=a.length))return a;var l=a.map(function(e,r){return t.call(n,e,r)}),s=l.map(function(t){return t.map(function(t,e){return[i.call(n,t,e),o.call(n,t,e)]})}),f=e.call(n,s,c);l=ta.permute(l,f),s=ta.permute(s,f);var h,g,p,v,d=r.call(n,s,c),m=l[0].length;for(p=0;m>p;++p)for(u.call(n,l[0][p],v=d[p],s[0][p][1]),g=1;h>g;++g)u.call(n,l[g][p],v+=s[g-1][p][1],s[g][p][1]);return a}var t=y,e=ai,r=ci,u=oi,i=ui,o=ii;return n.values=function(e){return arguments.length?(t=e,n):t},n.order=function(t){return arguments.length?(e="function"==typeof t?t:vl.get(t)||ai,n):e},n.offset=function(t){return arguments.length?(r="function"==typeof t?t:dl.get(t)||ci,n):r},n.x=function(t){return arguments.length?(i=t,n):i},n.y=function(t){return arguments.length?(o=t,n):o},n.out=function(t){return arguments.length?(u=t,n):u},n};var vl=ta.map({"inside-out":function(n){var t,e,r=n.length,u=n.map(li),i=n.map(si),o=ta.range(r).sort(function(n,t){return u[n]-u[t]}),a=0,c=0,l=[],s=[];for(t=0;r>t;++t)e=o[t],c>a?(a+=i[e],l.push(e)):(c+=i[e],s.push(e));return s.reverse().concat(l)},reverse:function(n){return ta.range(n.length).reverse()},"default":ai}),dl=ta.map({silhouette:function(n){var t,e,r,u=n.length,i=n[0].length,o=[],a=0,c=[];for(e=0;i>e;++e){for(t=0,r=0;u>t;t++)r+=n[t][e][1];r>a&&(a=r),o.push(r)}for(e=0;i>e;++e)c[e]=(a-o[e])/2;return c},wiggle:function(n){var t,e,r,u,i,o,a,c,l,s=n.length,f=n[0],h=f.length,g=[];for(g[0]=c=l=0,e=1;h>e;++e){for(t=0,u=0;s>t;++t)u+=n[t][e][1];for(t=0,i=0,a=f[e][0]-f[e-1][0];s>t;++t){for(r=0,o=(n[t][e][1]-n[t][e-1][1])/(2*a);t>r;++r)o+=(n[r][e][1]-n[r][e-1][1])/a;i+=o*n[t][e][1]}g[e]=c-=u?i/u*a:0,l>c&&(l=c)}for(e=0;h>e;++e)g[e]-=l;return g},expand:function(n){var t,e,r,u=n.length,i=n[0].length,o=1/u,a=[];for(e=0;i>e;++e){for(t=0,r=0;u>t;t++)r+=n[t][e][1];if(r)for(t=0;u>t;t++)n[t][e][1]/=r;else for(t=0;u>t;t++)n[t][e][1]=o}for(e=0;i>e;++e)a[e]=0;return a},zero:ci});ta.layout.histogram=function(){function n(n,i){for(var o,a,c=[],l=n.map(e,this),s=r.call(this,l,i),f=u.call(this,s,l,i),i=-1,h=l.length,g=f.length-1,p=t?1:1/h;++i<g;)o=c[i]=[],o.dx=f[i+1]-(o.x=f[i]),o.y=0;if(g>0)for(i=-1;++i<h;)a=l[i],a>=s[0]&&a<=s[1]&&(o=c[ta.bisect(f,a,1,g)-1],o.y+=p,o.push(n[i]));return c}var t=!0,e=Number,r=pi,u=hi;return n.value=function(t){return arguments.length?(e=t,n):e},n.range=function(t){return arguments.length?(r=Et(t),n):r},n.bins=function(t){return arguments.length?(u="number"==typeof t?function(n){return gi(n,t)}:Et(t),n):u},n.frequency=function(e){return arguments.length?(t=!!e,n):t},n},ta.layout.pack=function(){function n(n,i){var o=e.call(this,n,i),a=o[0],c=u[0],l=u[1],s=null==t?Math.sqrt:"function"==typeof t?t:function(){return t};if(a.x=a.y=0,Qu(a,function(n){n.r=+s(n.value)}),Qu(a,Mi),r){var f=r*(t?1:Math.max(2*a.r/c,2*a.r/l))/2;Qu(a,function(n){n.r+=f}),Qu(a,Mi),Qu(a,function(n){n.r-=f})}return _i(a,c/2,l/2,t?1:1/Math.max(2*a.r/c,2*a.r/l)),o}var t,e=ta.layout.hierarchy().sort(vi),r=0,u=[1,1];return n.size=function(t){return arguments.length?(u=t,n):u},n.radius=function(e){return arguments.length?(t=null==e||"function"==typeof e?e:+e,n):t},n.padding=function(t){return arguments.length?(r=+t,n):r},Gu(n,e)},ta.layout.tree=function(){function n(n,u){var s=o.call(this,n,u),f=s[0],h=t(f);if(Qu(h,e),h.parent.m=-h.z,Ku(h,r),l)Ku(f,i);else{var g=f,p=f,v=f;Ku(f,function(n){n.x<g.x&&(g=n),n.x>p.x&&(p=n),n.depth>v.depth&&(v=n)});var d=a(g,p)/2-g.x,m=c[0]/(p.x+a(p,g)/2+d),y=c[1]/(v.depth||1);Ku(f,function(n){n.x=(n.x+d)*m,n.y=n.depth*y})}return s}function t(n){for(var t,e={A:null,children:[n]},r=[e];null!=(t=r.pop());)for(var u,i=t.children,o=0,a=i.length;a>o;++o)r.push((i[o]=u={_:i[o],parent:t,children:(u=i[o].children)&&u.slice()||[],A:null,a:null,z:0,m:0,c:0,s:0,t:null,i:o}).a=u);return e.children[0]}function e(n){var t=n.children,e=n.parent.children,r=n.i?e[n.i-1]:null;if(t.length){Ni(n);var i=(t[0].z+t[t.length-1].z)/2;r?(n.z=r.z+a(n._,r._),n.m=n.z-i):n.z=i}else r&&(n.z=r.z+a(n._,r._));n.parent.A=u(n,r,n.parent.A||e[0])}function r(n){n._.x=n.z+n.parent.m,n.m+=n.parent.m}function u(n,t,e){if(t){for(var r,u=n,i=n,o=t,c=u.parent.children[0],l=u.m,s=i.m,f=o.m,h=c.m;o=Ei(o),u=ki(u),o&&u;)c=ki(c),i=Ei(i),i.a=n,r=o.z+f-u.z-l+a(o._,u._),r>0&&(Ai(Ci(o,n,e),n,r),l+=r,s+=r),f+=o.m,l+=u.m,h+=c.m,s+=i.m;o&&!Ei(i)&&(i.t=o,i.m+=f-s),u&&!ki(c)&&(c.t=u,c.m+=l-h,e=n)}return e}function i(n){n.x*=c[0],n.y=n.depth*c[1]}var o=ta.layout.hierarchy().sort(null).value(null),a=Si,c=[1,1],l=null;return n.separation=function(t){return arguments.length?(a=t,n):a},n.size=function(t){return arguments.length?(l=null==(c=t)?i:null,n):l?null:c},n.nodeSize=function(t){return arguments.length?(l=null==(c=t)?null:i,n):l?c:null},Gu(n,o)},ta.layout.cluster=function(){function n(n,i){var o,a=t.call(this,n,i),c=a[0],l=0;Qu(c,function(n){var t=n.children;t&&t.length?(n.x=qi(t),n.y=zi(t)):(n.x=o?l+=e(n,o):0,n.y=0,o=n)});var s=Li(c),f=Ti(c),h=s.x-e(s,f)/2,g=f.x+e(f,s)/2;return Qu(c,u?function(n){n.x=(n.x-c.x)*r[0],n.y=(c.y-n.y)*r[1]}:function(n){n.x=(n.x-h)/(g-h)*r[0],n.y=(1-(c.y?n.y/c.y:1))*r[1]}),a}var t=ta.layout.hierarchy().sort(null).value(null),e=Si,r=[1,1],u=!1;return n.separation=function(t){return arguments.length?(e=t,n):e},n.size=function(t){return arguments.length?(u=null==(r=t),n):u?null:r},n.nodeSize=function(t){return arguments.length?(u=null!=(r=t),n):u?r:null},Gu(n,t)},ta.layout.treemap=function(){function n(n,t){for(var e,r,u=-1,i=n.length;++u<i;)r=(e=n[u]).value*(0>t?0:t),e.area=isNaN(r)||0>=r?0:r}function t(e){var i=e.children;if(i&&i.length){var o,a,c,l=f(e),s=[],h=i.slice(),p=1/0,v="slice"===g?l.dx:"dice"===g?l.dy:"slice-dice"===g?1&e.depth?l.dy:l.dx:Math.min(l.dx,l.dy);for(n(h,l.dx*l.dy/e.value),s.area=0;(c=h.length)>0;)s.push(o=h[c-1]),s.area+=o.area,"squarify"!==g||(a=r(s,v))<=p?(h.pop(),p=a):(s.area-=s.pop().area,u(s,v,l,!1),v=Math.min(l.dx,l.dy),s.length=s.area=0,p=1/0);s.length&&(u(s,v,l,!0),s.length=s.area=0),i.forEach(t)}}function e(t){var r=t.children;if(r&&r.length){var i,o=f(t),a=r.slice(),c=[];for(n(a,o.dx*o.dy/t.value),c.area=0;i=a.pop();)c.push(i),c.area+=i.area,null!=i.z&&(u(c,i.z?o.dx:o.dy,o,!a.length),c.length=c.area=0);r.forEach(e)}}function r(n,t){for(var e,r=n.area,u=0,i=1/0,o=-1,a=n.length;++o<a;)(e=n[o].area)&&(i>e&&(i=e),e>u&&(u=e));return r*=r,t*=t,r?Math.max(t*u*p/r,r/(t*i*p)):1/0}function u(n,t,e,r){var u,i=-1,o=n.length,a=e.x,l=e.y,s=t?c(n.area/t):0;if(t==e.dx){for((r||s>e.dy)&&(s=e.dy);++i<o;)u=n[i],u.x=a,u.y=l,u.dy=s,a+=u.dx=Math.min(e.x+e.dx-a,s?c(u.area/s):0);u.z=!0,u.dx+=e.x+e.dx-a,e.y+=s,e.dy-=s}else{for((r||s>e.dx)&&(s=e.dx);++i<o;)u=n[i],u.x=a,u.y=l,u.dx=s,l+=u.dy=Math.min(e.y+e.dy-l,s?c(u.area/s):0);u.z=!1,u.dy+=e.y+e.dy-l,e.x+=s,e.dx-=s}}function i(r){var u=o||a(r),i=u[0];return i.x=0,i.y=0,i.dx=l[0],i.dy=l[1],o&&a.revalue(i),n([i],i.dx*i.dy/i.value),(o?e:t)(i),h&&(o=u),u}var o,a=ta.layout.hierarchy(),c=Math.round,l=[1,1],s=null,f=Ri,h=!1,g="squarify",p=.5*(1+Math.sqrt(5));
return i.size=function(n){return arguments.length?(l=n,i):l},i.padding=function(n){function t(t){var e=n.call(i,t,t.depth);return null==e?Ri(t):Di(t,"number"==typeof e?[e,e,e,e]:e)}function e(t){return Di(t,n)}if(!arguments.length)return s;var r;return f=null==(s=n)?Ri:"function"==(r=typeof n)?t:"number"===r?(n=[n,n,n,n],e):e,i},i.round=function(n){return arguments.length?(c=n?Math.round:Number,i):c!=Number},i.sticky=function(n){return arguments.length?(h=n,o=null,i):h},i.ratio=function(n){return arguments.length?(p=n,i):p},i.mode=function(n){return arguments.length?(g=n+"",i):g},Gu(i,a)},ta.random={normal:function(n,t){var e=arguments.length;return 2>e&&(t=1),1>e&&(n=0),function(){var e,r,u;do e=2*Math.random()-1,r=2*Math.random()-1,u=e*e+r*r;while(!u||u>1);return n+t*e*Math.sqrt(-2*Math.log(u)/u)}},logNormal:function(){var n=ta.random.normal.apply(ta,arguments);return function(){return Math.exp(n())}},bates:function(n){var t=ta.random.irwinHall(n);return function(){return t()/n}},irwinHall:function(n){return function(){for(var t=0,e=0;n>e;e++)t+=Math.random();return t}}},ta.scale={};var ml={floor:y,ceil:y};ta.scale.linear=function(){return Ii([0,1],[0,1],mu,!1)};var yl={s:1,g:1,p:1,r:1,e:1};ta.scale.log=function(){return Ji(ta.scale.linear().domain([0,1]),10,!0,[1,10])};var Ml=ta.format(".0e"),xl={floor:function(n){return-Math.ceil(-n)},ceil:function(n){return-Math.floor(-n)}};ta.scale.pow=function(){return Gi(ta.scale.linear(),1,[0,1])},ta.scale.sqrt=function(){return ta.scale.pow().exponent(.5)},ta.scale.ordinal=function(){return Qi([],{t:"range",a:[[]]})},ta.scale.category10=function(){return ta.scale.ordinal().range(bl)},ta.scale.category20=function(){return ta.scale.ordinal().range(_l)},ta.scale.category20b=function(){return ta.scale.ordinal().range(wl)},ta.scale.category20c=function(){return ta.scale.ordinal().range(Sl)};var bl=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186,1556175].map(Mt),_l=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175,10410725].map(Mt),wl=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509,14589654].map(Mt),Sl=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877,14277081].map(Mt);ta.scale.quantile=function(){return no([],[])},ta.scale.quantize=function(){return to(0,1,[0,1])},ta.scale.threshold=function(){return eo([.5],[0,1])},ta.scale.identity=function(){return ro([0,1])},ta.svg={},ta.svg.arc=function(){function n(){var n=Math.max(0,+e.apply(this,arguments)),l=Math.max(0,+r.apply(this,arguments)),s=o.apply(this,arguments)-Ra,f=a.apply(this,arguments)-Ra,h=Math.abs(f-s),g=s>f?0:1;if(n>l&&(p=l,l=n,n=p),h>=Ta)return t(l,g)+(n?t(n,1-g):"")+"Z";var p,v,d,m,y,M,x,b,_,w,S,k,E=0,A=0,N=[];if((m=(+c.apply(this,arguments)||0)/2)&&(d=i===kl?Math.sqrt(n*n+l*l):+i.apply(this,arguments),g||(A*=-1),l&&(A=tt(d/l*Math.sin(m))),n&&(E=tt(d/n*Math.sin(m)))),l){y=l*Math.cos(s+A),M=l*Math.sin(s+A),x=l*Math.cos(f-A),b=l*Math.sin(f-A);var C=Math.abs(f-s-2*A)<=qa?0:1;if(A&&so(y,M,x,b)===g^C){var z=(s+f)/2;y=l*Math.cos(z),M=l*Math.sin(z),x=b=null}}else y=M=0;if(n){_=n*Math.cos(f-E),w=n*Math.sin(f-E),S=n*Math.cos(s+E),k=n*Math.sin(s+E);var q=Math.abs(s-f+2*E)<=qa?0:1;if(E&&so(_,w,S,k)===1-g^q){var L=(s+f)/2;_=n*Math.cos(L),w=n*Math.sin(L),S=k=null}}else _=w=0;if((p=Math.min(Math.abs(l-n)/2,+u.apply(this,arguments)))>.001){v=l>n^g?0:1;var T=null==S?[_,w]:null==x?[y,M]:Lr([y,M],[S,k],[x,b],[_,w]),R=y-T[0],D=M-T[1],P=x-T[0],U=b-T[1],j=1/Math.sin(Math.acos((R*P+D*U)/(Math.sqrt(R*R+D*D)*Math.sqrt(P*P+U*U)))/2),F=Math.sqrt(T[0]*T[0]+T[1]*T[1]);if(null!=x){var H=Math.min(p,(l-F)/(j+1)),O=fo(null==S?[_,w]:[S,k],[y,M],l,H,g),I=fo([x,b],[_,w],l,H,g);p===H?N.push("M",O[0],"A",H,",",H," 0 0,",v," ",O[1],"A",l,",",l," 0 ",1-g^so(O[1][0],O[1][1],I[1][0],I[1][1]),",",g," ",I[1],"A",H,",",H," 0 0,",v," ",I[0]):N.push("M",O[0],"A",H,",",H," 0 1,",v," ",I[0])}else N.push("M",y,",",M);if(null!=S){var Y=Math.min(p,(n-F)/(j-1)),Z=fo([y,M],[S,k],n,-Y,g),V=fo([_,w],null==x?[y,M]:[x,b],n,-Y,g);p===Y?N.push("L",V[0],"A",Y,",",Y," 0 0,",v," ",V[1],"A",n,",",n," 0 ",g^so(V[1][0],V[1][1],Z[1][0],Z[1][1]),",",1-g," ",Z[1],"A",Y,",",Y," 0 0,",v," ",Z[0]):N.push("L",V[0],"A",Y,",",Y," 0 0,",v," ",Z[0])}else N.push("L",_,",",w)}else N.push("M",y,",",M),null!=x&&N.push("A",l,",",l," 0 ",C,",",g," ",x,",",b),N.push("L",_,",",w),null!=S&&N.push("A",n,",",n," 0 ",q,",",1-g," ",S,",",k);return N.push("Z"),N.join("")}function t(n,t){return"M0,"+n+"A"+n+","+n+" 0 1,"+t+" 0,"+-n+"A"+n+","+n+" 0 1,"+t+" 0,"+n}var e=io,r=oo,u=uo,i=kl,o=ao,a=co,c=lo;return n.innerRadius=function(t){return arguments.length?(e=Et(t),n):e},n.outerRadius=function(t){return arguments.length?(r=Et(t),n):r},n.cornerRadius=function(t){return arguments.length?(u=Et(t),n):u},n.padRadius=function(t){return arguments.length?(i=t==kl?kl:Et(t),n):i},n.startAngle=function(t){return arguments.length?(o=Et(t),n):o},n.endAngle=function(t){return arguments.length?(a=Et(t),n):a},n.padAngle=function(t){return arguments.length?(c=Et(t),n):c},n.centroid=function(){var n=(+e.apply(this,arguments)+ +r.apply(this,arguments))/2,t=(+o.apply(this,arguments)+ +a.apply(this,arguments))/2-Ra;return[Math.cos(t)*n,Math.sin(t)*n]},n};var kl="auto";ta.svg.line=function(){return ho(y)};var El=ta.map({linear:go,"linear-closed":po,step:vo,"step-before":mo,"step-after":yo,basis:So,"basis-open":ko,"basis-closed":Eo,bundle:Ao,cardinal:bo,"cardinal-open":Mo,"cardinal-closed":xo,monotone:To});El.forEach(function(n,t){t.key=n,t.closed=/-closed$/.test(n)});var Al=[0,2/3,1/3,0],Nl=[0,1/3,2/3,0],Cl=[0,1/6,2/3,1/6];ta.svg.line.radial=function(){var n=ho(Ro);return n.radius=n.x,delete n.x,n.angle=n.y,delete n.y,n},mo.reverse=yo,yo.reverse=mo,ta.svg.area=function(){return Do(y)},ta.svg.area.radial=function(){var n=Do(Ro);return n.radius=n.x,delete n.x,n.innerRadius=n.x0,delete n.x0,n.outerRadius=n.x1,delete n.x1,n.angle=n.y,delete n.y,n.startAngle=n.y0,delete n.y0,n.endAngle=n.y1,delete n.y1,n},ta.svg.chord=function(){function n(n,a){var c=t(this,i,n,a),l=t(this,o,n,a);return"M"+c.p0+r(c.r,c.p1,c.a1-c.a0)+(e(c,l)?u(c.r,c.p1,c.r,c.p0):u(c.r,c.p1,l.r,l.p0)+r(l.r,l.p1,l.a1-l.a0)+u(l.r,l.p1,c.r,c.p0))+"Z"}function t(n,t,e,r){var u=t.call(n,e,r),i=a.call(n,u,r),o=c.call(n,u,r)-Ra,s=l.call(n,u,r)-Ra;return{r:i,a0:o,a1:s,p0:[i*Math.cos(o),i*Math.sin(o)],p1:[i*Math.cos(s),i*Math.sin(s)]}}function e(n,t){return n.a0==t.a0&&n.a1==t.a1}function r(n,t,e){return"A"+n+","+n+" 0 "+ +(e>qa)+",1 "+t}function u(n,t,e,r){return"Q 0,0 "+r}var i=mr,o=yr,a=Po,c=ao,l=co;return n.radius=function(t){return arguments.length?(a=Et(t),n):a},n.source=function(t){return arguments.length?(i=Et(t),n):i},n.target=function(t){return arguments.length?(o=Et(t),n):o},n.startAngle=function(t){return arguments.length?(c=Et(t),n):c},n.endAngle=function(t){return arguments.length?(l=Et(t),n):l},n},ta.svg.diagonal=function(){function n(n,u){var i=t.call(this,n,u),o=e.call(this,n,u),a=(i.y+o.y)/2,c=[i,{x:i.x,y:a},{x:o.x,y:a},o];return c=c.map(r),"M"+c[0]+"C"+c[1]+" "+c[2]+" "+c[3]}var t=mr,e=yr,r=Uo;return n.source=function(e){return arguments.length?(t=Et(e),n):t},n.target=function(t){return arguments.length?(e=Et(t),n):e},n.projection=function(t){return arguments.length?(r=t,n):r},n},ta.svg.diagonal.radial=function(){var n=ta.svg.diagonal(),t=Uo,e=n.projection;return n.projection=function(n){return arguments.length?e(jo(t=n)):t},n},ta.svg.symbol=function(){function n(n,r){return(zl.get(t.call(this,n,r))||Oo)(e.call(this,n,r))}var t=Ho,e=Fo;return n.type=function(e){return arguments.length?(t=Et(e),n):t},n.size=function(t){return arguments.length?(e=Et(t),n):e},n};var zl=ta.map({circle:Oo,cross:function(n){var t=Math.sqrt(n/5)/2;return"M"+-3*t+","+-t+"H"+-t+"V"+-3*t+"H"+t+"V"+-t+"H"+3*t+"V"+t+"H"+t+"V"+3*t+"H"+-t+"V"+t+"H"+-3*t+"Z"},diamond:function(n){var t=Math.sqrt(n/(2*Ll)),e=t*Ll;return"M0,"+-t+"L"+e+",0 0,"+t+" "+-e+",0Z"},square:function(n){var t=Math.sqrt(n)/2;return"M"+-t+","+-t+"L"+t+","+-t+" "+t+","+t+" "+-t+","+t+"Z"},"triangle-down":function(n){var t=Math.sqrt(n/ql),e=t*ql/2;return"M0,"+e+"L"+t+","+-e+" "+-t+","+-e+"Z"},"triangle-up":function(n){var t=Math.sqrt(n/ql),e=t*ql/2;return"M0,"+-e+"L"+t+","+e+" "+-t+","+e+"Z"}});ta.svg.symbolTypes=zl.keys();var ql=Math.sqrt(3),Ll=Math.tan(30*Da);_a.transition=function(n){for(var t,e,r=Tl||++Ul,u=Xo(n),i=[],o=Rl||{time:Date.now(),ease:Su,delay:0,duration:250},a=-1,c=this.length;++a<c;){i.push(t=[]);for(var l=this[a],s=-1,f=l.length;++s<f;)(e=l[s])&&$o(e,s,u,r,o),t.push(e)}return Yo(i,u,r)},_a.interrupt=function(n){return this.each(null==n?Dl:Io(Xo(n)))};var Tl,Rl,Dl=Io(Xo()),Pl=[],Ul=0;Pl.call=_a.call,Pl.empty=_a.empty,Pl.node=_a.node,Pl.size=_a.size,ta.transition=function(n,t){return n&&n.transition?Tl?n.transition(t):n:ta.selection().transition(n)},ta.transition.prototype=Pl,Pl.select=function(n){var t,e,r,u=this.id,i=this.namespace,o=[];n=N(n);for(var a=-1,c=this.length;++a<c;){o.push(t=[]);for(var l=this[a],s=-1,f=l.length;++s<f;)(r=l[s])&&(e=n.call(r,r.__data__,s,a))?("__data__"in r&&(e.__data__=r.__data__),$o(e,s,i,u,r[i][u]),t.push(e)):t.push(null)}return Yo(o,i,u)},Pl.selectAll=function(n){var t,e,r,u,i,o=this.id,a=this.namespace,c=[];n=C(n);for(var l=-1,s=this.length;++l<s;)for(var f=this[l],h=-1,g=f.length;++h<g;)if(r=f[h]){i=r[a][o],e=n.call(r,r.__data__,h,l),c.push(t=[]);for(var p=-1,v=e.length;++p<v;)(u=e[p])&&$o(u,p,a,o,i),t.push(u)}return Yo(c,a,o)},Pl.filter=function(n){var t,e,r,u=[];"function"!=typeof n&&(n=O(n));for(var i=0,o=this.length;o>i;i++){u.push(t=[]);for(var e=this[i],a=0,c=e.length;c>a;a++)(r=e[a])&&n.call(r,r.__data__,a,i)&&t.push(r)}return Yo(u,this.namespace,this.id)},Pl.tween=function(n,t){var e=this.id,r=this.namespace;return arguments.length<2?this.node()[r][e].tween.get(n):Y(this,null==t?function(t){t[r][e].tween.remove(n)}:function(u){u[r][e].tween.set(n,t)})},Pl.attr=function(n,t){function e(){this.removeAttribute(a)}function r(){this.removeAttributeNS(a.space,a.local)}function u(n){return null==n?e:(n+="",function(){var t,e=this.getAttribute(a);return e!==n&&(t=o(e,n),function(n){this.setAttribute(a,t(n))})})}function i(n){return null==n?r:(n+="",function(){var t,e=this.getAttributeNS(a.space,a.local);return e!==n&&(t=o(e,n),function(n){this.setAttributeNS(a.space,a.local,t(n))})})}if(arguments.length<2){for(t in n)this.attr(t,n[t]);return this}var o="transform"==n?Hu:mu,a=ta.ns.qualify(n);return Zo(this,"attr."+n,t,a.local?i:u)},Pl.attrTween=function(n,t){function e(n,e){var r=t.call(this,n,e,this.getAttribute(u));return r&&function(n){this.setAttribute(u,r(n))}}function r(n,e){var r=t.call(this,n,e,this.getAttributeNS(u.space,u.local));return r&&function(n){this.setAttributeNS(u.space,u.local,r(n))}}var u=ta.ns.qualify(n);return this.tween("attr."+n,u.local?r:e)},Pl.style=function(n,e,r){function u(){this.style.removeProperty(n)}function i(e){return null==e?u:(e+="",function(){var u,i=t(this).getComputedStyle(this,null).getPropertyValue(n);return i!==e&&(u=mu(i,e),function(t){this.style.setProperty(n,u(t),r)})})}var o=arguments.length;if(3>o){if("string"!=typeof n){2>o&&(e="");for(r in n)this.style(r,n[r],e);return this}r=""}return Zo(this,"style."+n,e,i)},Pl.styleTween=function(n,e,r){function u(u,i){var o=e.call(this,u,i,t(this).getComputedStyle(this,null).getPropertyValue(n));return o&&function(t){this.style.setProperty(n,o(t),r)}}return arguments.length<3&&(r=""),this.tween("style."+n,u)},Pl.text=function(n){return Zo(this,"text",n,Vo)},Pl.remove=function(){var n=this.namespace;return this.each("end.transition",function(){var t;this[n].count<2&&(t=this.parentNode)&&t.removeChild(this)})},Pl.ease=function(n){var t=this.id,e=this.namespace;return arguments.length<1?this.node()[e][t].ease:("function"!=typeof n&&(n=ta.ease.apply(ta,arguments)),Y(this,function(r){r[e][t].ease=n}))},Pl.delay=function(n){var t=this.id,e=this.namespace;return arguments.length<1?this.node()[e][t].delay:Y(this,"function"==typeof n?function(r,u,i){r[e][t].delay=+n.call(r,r.__data__,u,i)}:(n=+n,function(r){r[e][t].delay=n}))},Pl.duration=function(n){var t=this.id,e=this.namespace;return arguments.length<1?this.node()[e][t].duration:Y(this,"function"==typeof n?function(r,u,i){r[e][t].duration=Math.max(1,n.call(r,r.__data__,u,i))}:(n=Math.max(1,n),function(r){r[e][t].duration=n}))},Pl.each=function(n,t){var e=this.id,r=this.namespace;if(arguments.length<2){var u=Rl,i=Tl;try{Tl=e,Y(this,function(t,u,i){Rl=t[r][e],n.call(t,t.__data__,u,i)})}finally{Rl=u,Tl=i}}else Y(this,function(u){var i=u[r][e];(i.event||(i.event=ta.dispatch("start","end","interrupt"))).on(n,t)});return this},Pl.transition=function(){for(var n,t,e,r,u=this.id,i=++Ul,o=this.namespace,a=[],c=0,l=this.length;l>c;c++){a.push(n=[]);for(var t=this[c],s=0,f=t.length;f>s;s++)(e=t[s])&&(r=e[o][u],$o(e,s,o,i,{time:r.time,ease:r.ease,delay:r.delay+r.duration,duration:r.duration})),n.push(e)}return Yo(a,o,i)},ta.svg.axis=function(){function n(n){n.each(function(){var n,l=ta.select(this),s=this.__chart__||e,f=this.__chart__=e.copy(),h=null==c?f.ticks?f.ticks.apply(f,a):f.domain():c,g=null==t?f.tickFormat?f.tickFormat.apply(f,a):y:t,p=l.selectAll(".tick").data(h,f),v=p.enter().insert("g",".domain").attr("class","tick").style("opacity",Ca),d=ta.transition(p.exit()).style("opacity",Ca).remove(),m=ta.transition(p.order()).style("opacity",1),M=Math.max(u,0)+o,x=Ui(f),b=l.selectAll(".domain").data([0]),_=(b.enter().append("path").attr("class","domain"),ta.transition(b));v.append("line"),v.append("text");var w,S,k,E,A=v.select("line"),N=m.select("line"),C=p.select("text").text(g),z=v.select("text"),q=m.select("text"),L="top"===r||"left"===r?-1:1;if("bottom"===r||"top"===r?(n=Bo,w="x",k="y",S="x2",E="y2",C.attr("dy",0>L?"0em":".71em").style("text-anchor","middle"),_.attr("d","M"+x[0]+","+L*i+"V0H"+x[1]+"V"+L*i)):(n=Wo,w="y",k="x",S="y2",E="x2",C.attr("dy",".32em").style("text-anchor",0>L?"end":"start"),_.attr("d","M"+L*i+","+x[0]+"H0V"+x[1]+"H"+L*i)),A.attr(E,L*u),z.attr(k,L*M),N.attr(S,0).attr(E,L*u),q.attr(w,0).attr(k,L*M),f.rangeBand){var T=f,R=T.rangeBand()/2;s=f=function(n){return T(n)+R}}else s.rangeBand?s=f:d.call(n,f,s);v.call(n,s,f),m.call(n,f,f)})}var t,e=ta.scale.linear(),r=jl,u=6,i=6,o=3,a=[10],c=null;return n.scale=function(t){return arguments.length?(e=t,n):e},n.orient=function(t){return arguments.length?(r=t in Fl?t+"":jl,n):r},n.ticks=function(){return arguments.length?(a=arguments,n):a},n.tickValues=function(t){return arguments.length?(c=t,n):c},n.tickFormat=function(e){return arguments.length?(t=e,n):t},n.tickSize=function(t){var e=arguments.length;return e?(u=+t,i=+arguments[e-1],n):u},n.innerTickSize=function(t){return arguments.length?(u=+t,n):u},n.outerTickSize=function(t){return arguments.length?(i=+t,n):i},n.tickPadding=function(t){return arguments.length?(o=+t,n):o},n.tickSubdivide=function(){return arguments.length&&n},n};var jl="bottom",Fl={top:1,right:1,bottom:1,left:1};ta.svg.brush=function(){function n(t){t.each(function(){var t=ta.select(this).style("pointer-events","all").style("-webkit-tap-highlight-color","rgba(0,0,0,0)").on("mousedown.brush",i).on("touchstart.brush",i),o=t.selectAll(".background").data([0]);o.enter().append("rect").attr("class","background").style("visibility","hidden").style("cursor","crosshair"),t.selectAll(".extent").data([0]).enter().append("rect").attr("class","extent").style("cursor","move");var a=t.selectAll(".resize").data(v,y);a.exit().remove(),a.enter().append("g").attr("class",function(n){return"resize "+n}).style("cursor",function(n){return Hl[n]}).append("rect").attr("x",function(n){return/[ew]$/.test(n)?-3:null}).attr("y",function(n){return/^[ns]/.test(n)?-3:null}).attr("width",6).attr("height",6).style("visibility","hidden"),a.style("display",n.empty()?"none":null);var c,f=ta.transition(t),h=ta.transition(o);l&&(c=Ui(l),h.attr("x",c[0]).attr("width",c[1]-c[0]),r(f)),s&&(c=Ui(s),h.attr("y",c[0]).attr("height",c[1]-c[0]),u(f)),e(f)})}function e(n){n.selectAll(".resize").attr("transform",function(n){return"translate("+f[+/e$/.test(n)]+","+h[+/^s/.test(n)]+")"})}function r(n){n.select(".extent").attr("x",f[0]),n.selectAll(".extent,.n>rect,.s>rect").attr("width",f[1]-f[0])}function u(n){n.select(".extent").attr("y",h[0]),n.selectAll(".extent,.e>rect,.w>rect").attr("height",h[1]-h[0])}function i(){function i(){32==ta.event.keyCode&&(C||(M=null,q[0]-=f[1],q[1]-=h[1],C=2),S())}function v(){32==ta.event.keyCode&&2==C&&(q[0]+=f[1],q[1]+=h[1],C=0,S())}function d(){var n=ta.mouse(b),t=!1;x&&(n[0]+=x[0],n[1]+=x[1]),C||(ta.event.altKey?(M||(M=[(f[0]+f[1])/2,(h[0]+h[1])/2]),q[0]=f[+(n[0]<M[0])],q[1]=h[+(n[1]<M[1])]):M=null),A&&m(n,l,0)&&(r(k),t=!0),N&&m(n,s,1)&&(u(k),t=!0),t&&(e(k),w({type:"brush",mode:C?"move":"resize"}))}function m(n,t,e){var r,u,i=Ui(t),c=i[0],l=i[1],s=q[e],v=e?h:f,d=v[1]-v[0];return C&&(c-=s,l-=d+s),r=(e?p:g)?Math.max(c,Math.min(l,n[e])):n[e],C?u=(r+=s)+d:(M&&(s=Math.max(c,Math.min(l,2*M[e]-r))),r>s?(u=r,r=s):u=s),v[0]!=r||v[1]!=u?(e?a=null:o=null,v[0]=r,v[1]=u,!0):void 0}function y(){d(),k.style("pointer-events","all").selectAll(".resize").style("display",n.empty()?"none":null),ta.select("body").style("cursor",null),L.on("mousemove.brush",null).on("mouseup.brush",null).on("touchmove.brush",null).on("touchend.brush",null).on("keydown.brush",null).on("keyup.brush",null),z(),w({type:"brushend"})}var M,x,b=this,_=ta.select(ta.event.target),w=c.of(b,arguments),k=ta.select(b),E=_.datum(),A=!/^(n|s)$/.test(E)&&l,N=!/^(e|w)$/.test(E)&&s,C=_.classed("extent"),z=W(b),q=ta.mouse(b),L=ta.select(t(b)).on("keydown.brush",i).on("keyup.brush",v);if(ta.event.changedTouches?L.on("touchmove.brush",d).on("touchend.brush",y):L.on("mousemove.brush",d).on("mouseup.brush",y),k.interrupt().selectAll("*").interrupt(),C)q[0]=f[0]-q[0],q[1]=h[0]-q[1];else if(E){var T=+/w$/.test(E),R=+/^n/.test(E);x=[f[1-T]-q[0],h[1-R]-q[1]],q[0]=f[T],q[1]=h[R]}else ta.event.altKey&&(M=q.slice());k.style("pointer-events","none").selectAll(".resize").style("display",null),ta.select("body").style("cursor",_.style("cursor")),w({type:"brushstart"}),d()}var o,a,c=E(n,"brushstart","brush","brushend"),l=null,s=null,f=[0,0],h=[0,0],g=!0,p=!0,v=Ol[0];return n.event=function(n){n.each(function(){var n=c.of(this,arguments),t={x:f,y:h,i:o,j:a},e=this.__chart__||t;this.__chart__=t,Tl?ta.select(this).transition().each("start.brush",function(){o=e.i,a=e.j,f=e.x,h=e.y,n({type:"brushstart"})}).tween("brush:brush",function(){var e=yu(f,t.x),r=yu(h,t.y);return o=a=null,function(u){f=t.x=e(u),h=t.y=r(u),n({type:"brush",mode:"resize"})}}).each("end.brush",function(){o=t.i,a=t.j,n({type:"brush",mode:"resize"}),n({type:"brushend"})}):(n({type:"brushstart"}),n({type:"brush",mode:"resize"}),n({type:"brushend"}))})},n.x=function(t){return arguments.length?(l=t,v=Ol[!l<<1|!s],n):l},n.y=function(t){return arguments.length?(s=t,v=Ol[!l<<1|!s],n):s},n.clamp=function(t){return arguments.length?(l&&s?(g=!!t[0],p=!!t[1]):l?g=!!t:s&&(p=!!t),n):l&&s?[g,p]:l?g:s?p:null},n.extent=function(t){var e,r,u,i,c;return arguments.length?(l&&(e=t[0],r=t[1],s&&(e=e[0],r=r[0]),o=[e,r],l.invert&&(e=l(e),r=l(r)),e>r&&(c=e,e=r,r=c),(e!=f[0]||r!=f[1])&&(f=[e,r])),s&&(u=t[0],i=t[1],l&&(u=u[1],i=i[1]),a=[u,i],s.invert&&(u=s(u),i=s(i)),u>i&&(c=u,u=i,i=c),(u!=h[0]||i!=h[1])&&(h=[u,i])),n):(l&&(o?(e=o[0],r=o[1]):(e=f[0],r=f[1],l.invert&&(e=l.invert(e),r=l.invert(r)),e>r&&(c=e,e=r,r=c))),s&&(a?(u=a[0],i=a[1]):(u=h[0],i=h[1],s.invert&&(u=s.invert(u),i=s.invert(i)),u>i&&(c=u,u=i,i=c))),l&&s?[[e,u],[r,i]]:l?[e,r]:s&&[u,i])},n.clear=function(){return n.empty()||(f=[0,0],h=[0,0],o=a=null),n},n.empty=function(){return!!l&&f[0]==f[1]||!!s&&h[0]==h[1]},ta.rebind(n,c,"on")};var Hl={n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"},Ol=[["n","e","s","w","nw","ne","se","sw"],["e","w"],["n","s"],[]],Il=ac.format=gc.timeFormat,Yl=Il.utc,Zl=Yl("%Y-%m-%dT%H:%M:%S.%LZ");Il.iso=Date.prototype.toISOString&&+new Date("2000-01-01T00:00:00.000Z")?Jo:Zl,Jo.parse=function(n){var t=new Date(n);return isNaN(t)?null:t},Jo.toString=Zl.toString,ac.second=Ft(function(n){return new cc(1e3*Math.floor(n/1e3))},function(n,t){n.setTime(n.getTime()+1e3*Math.floor(t))},function(n){return n.getSeconds()}),ac.seconds=ac.second.range,ac.seconds.utc=ac.second.utc.range,ac.minute=Ft(function(n){return new cc(6e4*Math.floor(n/6e4))},function(n,t){n.setTime(n.getTime()+6e4*Math.floor(t))},function(n){return n.getMinutes()}),ac.minutes=ac.minute.range,ac.minutes.utc=ac.minute.utc.range,ac.hour=Ft(function(n){var t=n.getTimezoneOffset()/60;return new cc(36e5*(Math.floor(n/36e5-t)+t))},function(n,t){n.setTime(n.getTime()+36e5*Math.floor(t))},function(n){return n.getHours()}),ac.hours=ac.hour.range,ac.hours.utc=ac.hour.utc.range,ac.month=Ft(function(n){return n=ac.day(n),n.setDate(1),n},function(n,t){n.setMonth(n.getMonth()+t)},function(n){return n.getMonth()}),ac.months=ac.month.range,ac.months.utc=ac.month.utc.range;var Vl=[1e3,5e3,15e3,3e4,6e4,3e5,9e5,18e5,36e5,108e5,216e5,432e5,864e5,1728e5,6048e5,2592e6,7776e6,31536e6],Xl=[[ac.second,1],[ac.second,5],[ac.second,15],[ac.second,30],[ac.minute,1],[ac.minute,5],[ac.minute,15],[ac.minute,30],[ac.hour,1],[ac.hour,3],[ac.hour,6],[ac.hour,12],[ac.day,1],[ac.day,