# Developing Kubernetes

Docs in this directory relate to developing Kubernetes.

* **On Collaborative Development** ([collab.md](collab.md)): info on pull requests and code reviews.

* **Development Guide** ([development.md](development.md)): Setting up your environment tests.

* **Hunting flaky tests** ([flaky-tests.md](flaky-tests.md)): We have a goal of 99.9% flake free tests.
  Here's how to run your tests many times.

* **GitHub Issues** ([issues.md](issues.md)): How incoming issues are reviewed and prioritized.

* **Logging Conventions** ([logging.md](logging.md)]: Glog levels.

* **Pull Request Process** ([pull-requests.md](pull-requests.md)): When and why pull requests are closed.

* **Releasing Kubernetes** ([releasing.md](releasing.md)): How to create a Kubernetes release (as in version)
  and how the version information gets embedded into the built binaries.

* **Profiling Kubernetes** ([profiling.md](profiling.md)): How to plug in go pprof profiler to Kubernetes.


[![Analytics](https://kubernetes-site.appspot.com/UA-36037335-10/GitHub/docs/devel/README.md?pixel)]()
