// Code generated by protoc-gen-go.
// source: google.golang.org/appengine/internal/datastore/datastore_v3.proto
// DO NOT EDIT!

/*
Package datastore is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/appengine/internal/datastore/datastore_v3.proto

It has these top-level messages:
	Action
	PropertyValue
	Property
	Path
	Reference
	User
	EntityProto
	CompositeProperty
	Index
	CompositeIndex
	IndexPostfix
	IndexPosition
	Snapshot
	InternalHeader
	Transaction
	Query
	CompiledQuery
	CompiledCursor
	Cursor
	Error
	Cost
	GetRequest
	GetResponse
	PutRequest
	PutResponse
	TouchRequest
	TouchResponse
	DeleteRequest
	DeleteResponse
	NextRequest
	QueryResult
	AllocateIdsRequest
	AllocateIdsResponse
	CompositeIndices
	AddActionsRequest
	AddActionsResponse
	BeginTransactionRequest
	CommitResponse
*/
package datastore

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

type Property_Meaning int32

const (
	Property_NO_MEANING       Property_Meaning = 0
	Property_BLOB             Property_Meaning = 14
	Property_TEXT             Property_Meaning = 15
	Property_BYTESTRING       Property_Meaning = 16
	Property_ATOM_CATEGORY    Property_Meaning = 1
	Property_ATOM_LINK        Property_Meaning = 2
	Property_ATOM_TITLE       Property_Meaning = 3
	Property_ATOM_CONTENT     Property_Meaning = 4
	Property_ATOM_SUMMARY     Property_Meaning = 5
	Property_ATOM_AUTHOR      Property_Meaning = 6
	Property_GD_WHEN          Property_Meaning = 7
	Property_GD_EMAIL         Property_Meaning = 8
	Property_GEORSS_POINT     Property_Meaning = 9
	Property_GD_IM            Property_Meaning = 10
	Property_GD_PHONENUMBER   Property_Meaning = 11
	Property_GD_POSTALADDRESS Property_Meaning = 12
	Property_GD_RATING        Property_Meaning = 13
	Property_BLOBKEY          Property_Meaning = 17
	Property_ENTITY_PROTO     Property_Meaning = 19
	Property_INDEX_VALUE      Property_Meaning = 18
)

var Property_Meaning_name = map[int32]string{
	0:  "NO_MEANING",
	14: "BLOB",
	15: "TEXT",
	16: "BYTESTRING",
	1:  "ATOM_CATEGORY",
	2:  "ATOM_LINK",
	3:  "ATOM_TITLE",
	4:  "ATOM_CONTENT",
	5:  "ATOM_SUMMARY",
	6:  "ATOM_AUTHOR",
	7:  "GD_WHEN",
	8:  "GD_EMAIL",
	9:  "GEORSS_POINT",
	10: "GD_IM",
	11: "GD_PHONENUMBER",
	12: "GD_POSTALADDRESS",
	13: "GD_RATING",
	17: "BLOBKEY",
	19: "ENTITY_PROTO",
	18: "INDEX_VALUE",
}
var Property_Meaning_value = map[string]int32{
	"NO_MEANING":       0,
	"BLOB":             14,
	"TEXT":             15,
	"BYTESTRING":       16,
	"ATOM_CATEGORY":    1,
	"ATOM_LINK":        2,
	"ATOM_TITLE":       3,
	"ATOM_CONTENT":     4,
	"ATOM_SUMMARY":     5,
	"ATOM_AUTHOR":      6,
	"GD_WHEN":          7,
	"GD_EMAIL":         8,
	"GEORSS_POINT":     9,
	"GD_IM":            10,
	"GD_PHONENUMBER":   11,
	"GD_POSTALADDRESS": 12,
	"GD_RATING":        13,
	"BLOBKEY":          17,
	"ENTITY_PROTO":     19,
	"INDEX_VALUE":      18,
}

func (x Property_Meaning) Enum() *Property_Meaning {
	p := new(Property_Meaning)
	*p = x
	return p
}
func (x Property_Meaning) String() string {
	return proto.EnumName(Property_Meaning_name, int32(x))
}
func (x *Property_Meaning) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Property_Meaning_value, data, "Property_Meaning")
	if err != nil {
		return err
	}
	*x = Property_Meaning(value)
	return nil
}

type Property_FtsTokenizationOption int32

const (
	Property_HTML Property_FtsTokenizationOption = 1
	Property_ATOM Property_FtsTokenizationOption = 2
)

var Property_FtsTokenizationOption_name = map[int32]string{
	1: "HTML",
	2: "ATOM",
}
var Property_FtsTokenizationOption_value = map[string]int32{
	"HTML": 1,
	"ATOM": 2,
}

func (x Property_FtsTokenizationOption) Enum() *Property_FtsTokenizationOption {
	p := new(Property_FtsTokenizationOption)
	*p = x
	return p
}
func (x Property_FtsTokenizationOption) String() string {
	return proto.EnumName(Property_FtsTokenizationOption_name, int32(x))
}
func (x *Property_FtsTokenizationOption) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Property_FtsTokenizationOption_value, data, "Property_FtsTokenizationOption")
	if err != nil {
		return err
	}
	*x = Property_FtsTokenizationOption(value)
	return nil
}

type EntityProto_Kind int32

const (
	EntityProto_GD_CONTACT EntityProto_Kind = 1
	EntityProto_GD_EVENT   EntityProto_Kind = 2
	EntityProto_GD_MESSAGE EntityProto_Kind = 3
)

var EntityProto_Kind_name = map[int32]string{
	1: "GD_CONTACT",
	2: "GD_EVENT",
	3: "GD_MESSAGE",
}
var EntityProto_Kind_value = map[string]int32{
	"GD_CONTACT": 1,
	"GD_EVENT":   2,
	"GD_MESSAGE": 3,
}

func (x EntityProto_Kind) Enum() *EntityProto_Kind {
	p := new(EntityProto_Kind)
	*p = x
	return p
}
func (x EntityProto_Kind) String() string {
	return proto.EnumName(EntityProto_Kind_name, int32(x))
}
func (x *EntityProto_Kind) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EntityProto_Kind_value, data, "EntityProto_Kind")
	if err != nil {
		return err
	}
	*x = EntityProto_Kind(value)
	return nil
}

type Index_Property_Direction int32

const (
	Index_Property_ASCENDING  Index_Property_Direction = 1
	Index_Property_DESCENDING Index_Property_Direction = 2
)

var Index_Property_Direction_name = map[int32]string{
	1: "ASCENDING",
	2: "DESCENDING",
}
var Index_Property_Direction_value = map[string]int32{
	"ASCENDING":  1,
	"DESCENDING": 2,
}

func (x Index_Property_Direction) Enum() *Index_Property_Direction {
	p := new(Index_Property_Direction)
	*p = x
	return p
}
func (x Index_Property_Direction) String() string {
	return proto.EnumName(Index_Property_Direction_name, int32(x))
}
func (x *Index_Property_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Index_Property_Direction_value, data, "Index_Property_Direction")
	if err != nil {
		return err
	}
	*x = Index_Property_Direction(value)
	return nil
}

type CompositeIndex_State int32

const (
	CompositeIndex_WRITE_ONLY CompositeIndex_State = 1
	CompositeIndex_READ_WRITE CompositeIndex_State = 2
	CompositeIndex_DELETED    CompositeIndex_State = 3
	CompositeIndex_ERROR      CompositeIndex_State = 4
)

var CompositeIndex_State_name = map[int32]string{
	1: "WRITE_ONLY",
	2: "READ_WRITE",
	3: "DELETED",
	4: "ERROR",
}
var CompositeIndex_State_value = map[string]int32{
	"WRITE_ONLY": 1,
	"READ_WRITE": 2,
	"DELETED":    3,
	"ERROR":      4,
}

func (x CompositeIndex_State) Enum() *CompositeIndex_State {
	p := new(CompositeIndex_State)
	*p = x
	return p
}
func (x CompositeIndex_State) String() string {
	return proto.EnumName(CompositeIndex_State_name, int32(x))
}
func (x *CompositeIndex_State) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CompositeIndex_State_value, data, "CompositeIndex_State")
	if err != nil {
		return err
	}
	*x = CompositeIndex_State(value)
	return nil
}

type Snapshot_Status int32

const (
	Snapshot_INACTIVE Snapshot_Status = 0
	Snapshot_ACTIVE   Snapshot_Status = 1
)

var Snapshot_Status_name = map[int32]string{
	0: "INACTIVE",
	1: "ACTIVE",
}
var Snapshot_Status_value = map[string]int32{
	"INACTIVE": 0,
	"ACTIVE":   1,
}

func (x Snapshot_Status) Enum() *Snapshot_Status {
	p := new(Snapshot_Status)
	*p = x
	return p
}
func (x Snapshot_Status) String() string {
	return proto.EnumName(Snapshot_Status_name, int32(x))
}
func (x *Snapshot_Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Snapshot_Status_value, data, "Snapshot_Status")
	if err != nil {
		return err
	}
	*x = Snapshot_Status(value)
	return nil
}

type Query_Hint int32

const (
	Query_ORDER_FIRST    Query_Hint = 1
	Query_ANCESTOR_FIRST Query_Hint = 2
	Query_FILTER_FIRST   Query_Hint = 3
)

var Query_Hint_name = map[int32]string{
	1: "ORDER_FIRST",
	2: "ANCESTOR_FIRST",
	3: "FILTER_FIRST",
}
var Query_Hint_value = map[string]int32{
	"ORDER_FIRST":    1,
	"ANCESTOR_FIRST": 2,
	"FILTER_FIRST":   3,
}

func (x Query_Hint) Enum() *Query_Hint {
	p := new(Query_Hint)
	*p = x
	return p
}
func (x Query_Hint) String() string {
	return proto.EnumName(Query_Hint_name, int32(x))
}
func (x *Query_Hint) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Query_Hint_value, data, "Query_Hint")
	if err != nil {
		return err
	}
	*x = Query_Hint(value)
	return nil
}

type Query_Filter_Operator int32

const (
	Query_Filter_LESS_THAN             Query_Filter_Operator = 1
	Query_Filter_LESS_THAN_OR_EQUAL    Query_Filter_Operator = 2
	Query_Filter_GREATER_THAN          Query_Filter_Operator = 3
	Query_Filter_GREATER_THAN_OR_EQUAL Query_Filter_Operator = 4
	Query_Filter_EQUAL                 Query_Filter_Operator = 5
	Query_Filter_IN                    Query_Filter_Operator = 6
	Query_Filter_EXISTS                Query_Filter_Operator = 7
)

var Query_Filter_Operator_name = map[int32]string{
	1: "LESS_THAN",
	2: "LESS_THAN_OR_EQUAL",
	3: "GREATER_THAN",
	4: "GREATER_THAN_OR_EQUAL",
	5: "EQUAL",
	6: "IN",
	7: "EXISTS",
}
var Query_Filter_Operator_value = map[string]int32{
	"LESS_THAN":             1,
	"LESS_THAN_OR_EQUAL":    2,
	"GREATER_THAN":          3,
	"GREATER_THAN_OR_EQUAL": 4,
	"EQUAL":                 5,
	"IN":                    6,
	"EXISTS":                7,
}

func (x Query_Filter_Operator) Enum() *Query_Filter_Operator {
	p := new(Query_Filter_Operator)
	*p = x
	return p
}
func (x Query_Filter_Operator) String() string {
	return proto.EnumName(Query_Filter_Operator_name, int32(x))
}
func (x *Query_Filter_Operator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Query_Filter_Operator_value, data, "Query_Filter_Operator")
	if err != nil {
		return err
	}
	*x = Query_Filter_Operator(value)
	return nil
}

type Query_Order_Direction int32

const (
	Query_Order_ASCENDING  Query_Order_Direction = 1
	Query_Order_DESCENDING Query_Order_Direction = 2
)

var Query_Order_Direction_name = map[int32]string{
	1: "ASCENDING",
	2: "DESCENDING",
}
var Query_Order_Direction_value = map[string]int32{
	"ASCENDING":  1,
	"DESCENDING": 2,
}

func (x Query_Order_Direction) Enum() *Query_Order_Direction {
	p := new(Query_Order_Direction)
	*p = x
	return p
}
func (x Query_Order_Direction) String() string {
	return proto.EnumName(Query_Order_Direction_name, int32(x))
}
func (x *Query_Order_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Query_Order_Direction_value, data, "Query_Order_Direction")
	if err != nil {
		return err
	}
	*x = Query_Order_Direction(value)
	return nil
}

type Error_ErrorCode int32

const (
	Error_BAD_REQUEST                  Error_ErrorCode = 1
	Error_CONCURRENT_TRANSACTION       Error_ErrorCode = 2
	Error_INTERNAL_ERROR               Error_ErrorCode = 3
	Error_NEED_INDEX                   Error_ErrorCode = 4
	Error_TIMEOUT                      Error_ErrorCode = 5
	Error_PERMISSION_DENIED            Error_ErrorCode = 6
	Error_BIGTABLE_ERROR               Error_ErrorCode = 7
	Error_COMMITTED_BUT_STILL_APPLYING Error_ErrorCode = 8
	Error_CAPABILITY_DISABLED          Error_ErrorCode = 9
	Error_TRY_ALTERNATE_BACKEND        Error_ErrorCode = 10
	Error_SAFE_TIME_TOO_OLD            Error_ErrorCode = 11
)

var Error_ErrorCode_name = map[int32]string{
	1:  "BAD_REQUEST",
	2:  "CONCURRENT_TRANSACTION",
	3:  "INTERNAL_ERROR",
	4:  "NEED_INDEX",
	5:  "TIMEOUT",
	6:  "PERMISSION_DENIED",
	7:  "BIGTABLE_ERROR",
	8:  "COMMITTED_BUT_STILL_APPLYING",
	9:  "CAPABILITY_DISABLED",
	10: "TRY_ALTERNATE_BACKEND",
	11: "SAFE_TIME_TOO_OLD",
}
var Error_ErrorCode_value = map[string]int32{
	"BAD_REQUEST":                  1,
	"CONCURRENT_TRANSACTION":       2,
	"INTERNAL_ERROR":               3,
	"NEED_INDEX":                   4,
	"TIMEOUT":                      5,
	"PERMISSION_DENIED":            6,
	"BIGTABLE_ERROR":               7,
	"COMMITTED_BUT_STILL_APPLYING": 8,
	"CAPABILITY_DISABLED":          9,
	"TRY_ALTERNATE_BACKEND":        10,
	"SAFE_TIME_TOO_OLD":            11,
}

func (x Error_ErrorCode) Enum() *Error_ErrorCode {
	p := new(Error_ErrorCode)
	*p = x
	return p
}
func (x Error_ErrorCode) String() string {
	return proto.EnumName(Error_ErrorCode_name, int32(x))
}
func (x *Error_ErrorCode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Error_ErrorCode_value, data, "Error_ErrorCode")
	if err != nil {
		return err
	}
	*x = Error_ErrorCode(value)
	return nil
}

type PutRequest_AutoIdPolicy int32

const (
	PutRequest_CURRENT    PutRequest_AutoIdPolicy = 0
	PutRequest_SEQUENTIAL PutRequest_AutoIdPolicy = 1
)

var PutRequest_AutoIdPolicy_name = map[int32]string{
	0: "CURRENT",
	1: "SEQUENTIAL",
}
var PutRequest_AutoIdPolicy_value = map[string]int32{
	"CURRENT":    0,
	"SEQUENTIAL": 1,
}

func (x PutRequest_AutoIdPolicy) Enum() *PutRequest_AutoIdPolicy {
	p := new(PutRequest_AutoIdPolicy)
	*p = x
	return p
}
func (x PutRequest_AutoIdPolicy) String() string {
	return proto.EnumName(PutRequest_AutoIdPolicy_name, int32(x))
}
func (x *PutRequest_AutoIdPolicy) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PutRequest_AutoIdPolicy_value, data, "PutRequest_AutoIdPolicy")
	if err != nil {
		return err
	}
	*x = PutRequest_AutoIdPolicy(value)
	return nil
}

type Action struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *Action) Reset()         { *m = Action{} }
func (m *Action) String() string { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()    {}

type PropertyValue struct {
	Int64Value       *int64                        `protobuf:"varint,1,opt,name=int64Value" json:"int64Value,omitempty"`
	BooleanValue     *bool                         `protobuf:"varint,2,opt,name=booleanValue" json:"booleanValue,omitempty"`
	StringValue      *string                       `protobuf:"bytes,3,opt,name=stringValue" json:"stringValue,omitempty"`
	DoubleValue      *float64                      `protobuf:"fixed64,4,opt,name=doubleValue" json:"doubleValue,omitempty"`
	Pointvalue       *PropertyValue_PointValue     `protobuf:"group,5,opt,name=PointValue" json:"pointvalue,omitempty"`
	Uservalue        *PropertyValue_UserValue      `protobuf:"group,8,opt,name=UserValue" json:"uservalue,omitempty"`
	Referencevalue   *PropertyValue_ReferenceValue `protobuf:"group,12,opt,name=ReferenceValue" json:"referencevalue,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *PropertyValue) Reset()         { *m = PropertyValue{} }
func (m *PropertyValue) String() string { return proto.CompactTextString(m) }
func (*PropertyValue) ProtoMessage()    {}

func (m *PropertyValue) GetInt64Value() int64 {
	if m != nil && m.Int64Value != nil {
		return *m.Int64Value
	}
	return 0
}

func (m *PropertyValue) GetBooleanValue() bool {
	if m != nil && m.BooleanValue != nil {
		return *m.BooleanValue
	}
	return false
}

func (m *PropertyValue) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *PropertyValue) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *PropertyValue) GetPointvalue() *PropertyValue_PointValue {
	if m != nil {
		return m.Pointvalue
	}
	return nil
}

func (m *PropertyValue) GetUservalue() *PropertyValue_UserValue {
	if m != nil {
		return m.Uservalue
	}
	return nil
}

func (m *PropertyValue) GetReferencevalue() *PropertyValue_ReferenceValue {
	if m != nil {
		return m.Referencevalue
	}
	return nil
}

type PropertyValue_PointValue struct {
	X                *float64 `protobuf:"fixed64,6,req,name=x" json:"x,omitempty"`
	Y                *float64 `protobuf:"fixed64,7,req,name=y" json:"y,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *PropertyValue_PointValue) Reset()         { *m = PropertyValue_PointValue{} }
func (m *PropertyValue_PointValue) String() string { return proto.CompactTextString(m) }
func (*PropertyValue_PointValue) ProtoMessage()    {}

func (m *PropertyValue_PointValue) GetX() float64 {
	if m != nil && m.X != nil {
		return *m.X
	}
	return 0
}

func (m *PropertyValue_PointValue) GetY() float64 {
	if m != nil && m.Y != nil {
		return *m.Y
	}
	return 0
}

type PropertyValue_UserValue struct {
	Email             *string `protobuf:"bytes,9,req,name=email" json:"email,omitempty"`
	AuthDomain        *string `protobuf:"bytes,10,req,name=auth_domain" json:"auth_domain,omitempty"`
	Nickname          *string `protobuf:"bytes,11,opt,name=nickname" json:"nickname,omitempty"`
	FederatedIdentity *string `protobuf:"bytes,21,opt,name=federated_identity" json:"federated_identity,omitempty"`
	FederatedProvider *string `protobuf:"bytes,22,opt,name=federated_provider" json:"federated_provider,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *PropertyValue_UserValue) Reset()         { *m = PropertyValue_UserValue{} }
func (m *PropertyValue_UserValue) String() string { return proto.CompactTextString(m) }
func (*PropertyValue_UserValue) ProtoMessage()    {}

func (m *PropertyValue_UserValue) GetEmail() string {
	if m != nil && m.Email != nil {
		return *m.Email
	}
	return ""
}

func (m *PropertyValue_UserValue) GetAuthDomain() string {
	if m != nil && m.AuthDomain != nil {
		return *m.AuthDomain
	}
	return ""
}

func (m *PropertyValue_UserValue) GetNickname() string {
	if m != nil && m.Nickname != nil {
		return *m.Nickname
	}
	return ""
}

func (m *PropertyValue_UserValue) GetFederatedIdentity() string {
	if m != nil && m.FederatedIdentity != nil {
		return *m.FederatedIdentity
	}
	return ""
}

func (m *PropertyValue_UserValue) GetFederatedProvider() string {
	if m != nil && m.FederatedProvider != nil {
		return *m.FederatedProvider
	}
	return ""
}

type PropertyValue_ReferenceValue struct {
	App              *string                                     `protobuf:"bytes,13,req,name=app" json:"app,omitempty"`
	NameSpace        *string                                     `protobuf:"bytes,20,opt,name=name_space" json:"name_space,omitempty"`
	Pathelement      []*PropertyValue_ReferenceValue_PathElement `protobuf:"group,14,rep,name=PathElement" json:"pathelement,omitempty"`
	XXX_unrecognized []byte                                      `json:"-"`
}

func (m *PropertyValue_ReferenceValue) Reset()         { *m = PropertyValue_ReferenceValue{} }
func (m *PropertyValue_ReferenceValue) String() string { return proto.CompactTextString(m) }
func (*PropertyValue_ReferenceValue) ProtoMessage()    {}

func (m *PropertyValue_ReferenceValue) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

func (m *PropertyValue_ReferenceValue) GetNameSpace() string {
	if m != nil && m.NameSpace != nil {
		return *m.NameSpace
	}
	return ""
}

func (m *PropertyValue_ReferenceValue) GetPathelement() []*PropertyValue_ReferenceValue_PathElement {
	if m != nil {
		return m.Pathelement
	}
	return nil
}

type PropertyValue_ReferenceValue_PathElement struct {
	Type             *string `protobuf:"bytes,15,req,name=type" json:"type,omitempty"`
	Id               *int64  `protobuf:"varint,16,opt,name=id" json:"id,omitempty"`
	Name             *string `protobuf:"bytes,17,opt,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PropertyValue_ReferenceValue_PathElement) Reset() {
	*m = PropertyValue_ReferenceValue_PathElement{}
}
func (m *PropertyValue_ReferenceValue_PathElement) String() string { return proto.CompactTextString(m) }
func (*PropertyValue_ReferenceValue_PathElement) ProtoMessage()    {}

func (m *PropertyValue_ReferenceValue_PathElement) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *PropertyValue_ReferenceValue_PathElement) GetId() int64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *PropertyValue_ReferenceValue_PathElement) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type Property struct {
	Meaning               *Property_Meaning               `protobuf:"varint,1,opt,name=meaning,enum=appengine.Property_Meaning,def=0" json:"meaning,omitempty"`
	MeaningUri            *string                         `protobuf:"bytes,2,opt,name=meaning_uri" json:"meaning_uri,omitempty"`
	Name                  *string                         `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Value                 *PropertyValue                  `protobuf:"bytes,5,req,name=value" json:"value,omitempty"`
	Multiple              *bool                           `protobuf:"varint,4,req,name=multiple" json:"multiple,omitempty"`
	Searchable            *bool                           `protobuf:"varint,6,opt,name=searchable,def=0" json:"searchable,omitempty"`
	FtsTokenizationOption *Property_FtsTokenizationOption `protobuf:"varint,8,opt,name=fts_tokenization_option,enum=appengine.Property_FtsTokenizationOption" json:"fts_tokenization_option,omitempty"`
	Locale                *string                         `protobuf:"bytes,9,opt,name=locale,def=en" json:"locale,omitempty"`
	XXX_unrecognized      []byte                          `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}

const Default_Property_Meaning Property_Meaning = Property_NO_MEANING
const Default_Property_Searchable bool = false
const Default_Property_Locale string = "en"

func (m *Property) GetMeaning() Property_Meaning {
	if m != nil && m.Meaning != nil {
		return *m.Meaning
	}
	return Default_Property_Meaning
}

func (m *Property) GetMeaningUri() string {
	if m != nil && m.MeaningUri != nil {
		return *m.MeaningUri
	}
	return ""
}

func (m *Property) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Property) GetValue() *PropertyValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Property) GetMultiple() bool {
	if m != nil && m.Multiple != nil {
		return *m.Multiple
	}
	return false
}

func (m *Property) GetSearchable() bool {
	if m != nil && m.Searchable != nil {
		return *m.Searchable
	}
	return Default_Property_Searchable
}

func (m *Property) GetFtsTokenizationOption() Property_FtsTokenizationOption {
	if m != nil && m.FtsTokenizationOption != nil {
		return *m.FtsTokenizationOption
	}
	return Property_HTML
}

func (m *Property) GetLocale() string {
	if m != nil && m.Locale != nil {
		return *m.Locale
	}
	return Default_Property_Locale
}

type Path struct {
	Element          []*Path_Element `protobuf:"group,1,rep" json:"element,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *Path) Reset()         { *m = Path{} }
func (m *Path) String() string { return proto.CompactTextString(m) }
func (*Path) ProtoMessage()    {}

func (m *Path) GetElement() []*Path_Element {
	if m != nil {
		return m.Element
	}
	return nil
}

type Path_Element struct {
	Type             *string `protobuf:"bytes,2,req,name=type" json:"type,omitempty"`
	Id               *int64  `protobuf:"varint,3,opt,name=id" json:"id,omitempty"`
	Name             *string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Path_Element) Reset()         { *m = Path_Element{} }
func (m *Path_Element) String() string { return proto.CompactTextString(m) }
func (*Path_Element) ProtoMessage()    {}

func (m *Path_Element) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *Path_Element) GetId() int64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *Path_Element) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type Reference struct {
	App              *string `protobuf:"bytes,13,req,name=app" json:"app,omitempty"`
	NameSpace        *string `protobuf:"bytes,20,opt,name=name_space" json:"name_space,omitempty"`
	Path             *Path   `protobuf:"bytes,14,req,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Reference) Reset()         { *m = Reference{} }
func (m *Reference) String() string { return proto.CompactTextString(m) }
func (*Reference) ProtoMessage()    {}

func (m *Reference) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

func (m *Reference) GetNameSpace() string {
	if m != nil && m.NameSpace != nil {
		return *m.NameSpace
	}
	return ""
}

func (m *Reference) GetPath() *Path {
	if m != nil {
		return m.Path
	}
	return nil
}

type User struct {
	Email             *string `protobuf:"bytes,1,req,name=email" json:"email,omitempty"`
	AuthDomain        *string `protobuf:"bytes,2,req,name=auth_domain" json:"auth_domain,omitempty"`
	Nickname          *string `protobuf:"bytes,3,opt,name=nickname" json:"nickname,omitempty"`
	FederatedIdentity *string `protobuf:"bytes,6,opt,name=federated_identity" json:"federated_identity,omitempty"`
	FederatedProvider *string `protobuf:"bytes,7,opt,name=federated_provider" json:"federated_provider,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}

func (m *User) GetEmail() string {
	if m != nil && m.Email != nil {
		return *m.Email
	}
	return ""
}

func (m *User) GetAuthDomain() string {
	if m != nil && m.AuthDomain != nil {
		return *m.AuthDomain
	}
	return ""
}

func (m *User) GetNickname() string {
	if m != nil && m.Nickname != nil {
		return *m.Nickname
	}
	return ""
}

func (m *User) GetFederatedIdentity() string {
	if m != nil && m.FederatedIdentity != nil {
		return *m.FederatedIdentity
	}
	return ""
}

func (m *User) GetFederatedProvider() string {
	if m != nil && m.FederatedProvider != nil {
		return *m.FederatedProvider
	}
	return ""
}

type EntityProto struct {
	Key              *Reference        `protobuf:"bytes,13,req,name=key" json:"key,omitempty"`
	EntityGroup      *Path             `protobuf:"bytes,16,req,name=entity_group" json:"entity_group,omitempty"`
	Owner            *User             `protobuf:"bytes,17,opt,name=owner" json:"owner,omitempty"`
	Kind             *EntityProto_Kind `protobuf:"varint,4,opt,name=kind,enum=appengine.EntityProto_Kind" json:"kind,omitempty"`
	KindUri          *string           `protobuf:"bytes,5,opt,name=kind_uri" json:"kind_uri,omitempty"`
	Property         []*Property       `protobuf:"bytes,14,rep,name=property" json:"property,omitempty"`
	RawProperty      []*Property       `protobuf:"bytes,15,rep,name=raw_property" json:"raw_property,omitempty"`
	Rank             *int32            `protobuf:"varint,18,opt,name=rank" json:"rank,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *EntityProto) Reset()         { *m = EntityProto{} }
func (m *EntityProto) String() string { return proto.CompactTextString(m) }
func (*EntityProto) ProtoMessage()    {}

func (m *EntityProto) GetKey() *Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *EntityProto) GetEntityGroup() *Path {
	if m != nil {
		return m.EntityGroup
	}
	return nil
}

func (m *EntityProto) GetOwner() *User {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *EntityProto) GetKind() EntityProto_Kind {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return EntityProto_GD_CONTACT
}

func (m *EntityProto) GetKindUri() string {
	if m != nil && m.KindUri != nil {
		return *m.KindUri
	}
	return ""
}

func (m *EntityProto) GetProperty() []*Property {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *EntityProto) GetRawProperty() []*Property {
	if m != nil {
		return m.RawProperty
	}
	return nil
}

func (m *EntityProto) GetRank() int32 {
	if m != nil && m.Rank != nil {
		return *m.Rank
	}
	return 0
}

type CompositeProperty struct {
	IndexId          *int64   `protobuf:"varint,1,req,name=index_id" json:"index_id,omitempty"`
	Value            []string `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *CompositeProperty) Reset()         { *m = CompositeProperty{} }
func (m *CompositeProperty) String() string { return proto.CompactTextString(m) }
func (*CompositeProperty) ProtoMessage()    {}

func (m *CompositeProperty) GetIndexId() int64 {
	if m != nil && m.IndexId != nil {
		return *m.IndexId
	}
	return 0
}

func (m *CompositeProperty) GetValue() []string {
	if m != nil {
		return m.Value
	}
	return nil
}

type Index struct {
	EntityType       *string           `protobuf:"bytes,1,req,name=entity_type" json:"entity_type,omitempty"`
	Ancestor         *bool             `protobuf:"varint,5,req,name=ancestor" json:"ancestor,omitempty"`
	Property         []*Index_Property `protobuf:"group,2,rep" json:"property,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Index) Reset()         { *m = Index{} }
func (m *Index) String() string { return proto.CompactTextString(m) }
func (*Index) ProtoMessage()    {}

func (m *Index) GetEntityType() string {
	if m != nil && m.EntityType != nil {
		return *m.EntityType
	}
	return ""
}

func (m *Index) GetAncestor() bool {
	if m != nil && m.Ancestor != nil {
		return *m.Ancestor
	}
	return false
}

func (m *Index) GetProperty() []*Index_Property {
	if m != nil {
		return m.Property
	}
	return nil
}

type Index_Property struct {
	Name             *string                   `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Direction        *Index_Property_Direction `protobuf:"varint,4,opt,name=direction,enum=appengine.Index_Property_Direction,def=1" json:"direction,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *Index_Property) Reset()         { *m = Index_Property{} }
func (m *Index_Property) String() string { return proto.CompactTextString(m) }
func (*Index_Property) ProtoMessage()    {}

const Default_Index_Property_Direction Index_Property_Direction = Index_Property_ASCENDING

func (m *Index_Property) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Index_Property) GetDirection() Index_Property_Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return Default_Index_Property_Direction
}

type CompositeIndex struct {
	AppId             *string               `protobuf:"bytes,1,req,name=app_id" json:"app_id,omitempty"`
	Id                *int64                `protobuf:"varint,2,req,name=id" json:"id,omitempty"`
	Definition        *Index                `protobuf:"bytes,3,req,name=definition" json:"definition,omitempty"`
	State             *CompositeIndex_State `protobuf:"varint,4,req,name=state,enum=appengine.CompositeIndex_State" json:"state,omitempty"`
	OnlyUseIfRequired *bool                 `protobuf:"varint,6,opt,name=only_use_if_required,def=0" json:"only_use_if_required,omitempty"`
	XXX_unrecognized  []byte                `json:"-"`
}

func (m *CompositeIndex) Reset()         { *m = CompositeIndex{} }
func (m *CompositeIndex) String() string { return proto.CompactTextString(m) }
func (*CompositeIndex) ProtoMessage()    {}

const Default_CompositeIndex_OnlyUseIfRequired bool = false

func (m *CompositeIndex) GetAppId() string {
	if m != nil && m.AppId != nil {
		return *m.AppId
	}
	return ""
}

func (m *CompositeIndex) GetId() int64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *CompositeIndex) GetDefinition() *Index {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (m *CompositeIndex) GetState() CompositeIndex_State {
	if m != nil && m.State != nil {
		return *m.State
	}
	return CompositeIndex_WRITE_ONLY
}

func (m *CompositeIndex) GetOnlyUseIfRequired() bool {
	if m != nil && m.OnlyUseIfRequired != nil {
		return *m.OnlyUseIfRequired
	}
	return Default_CompositeIndex_OnlyUseIfRequired
}

type IndexPostfix struct {
	IndexValue       []*IndexPostfix_IndexValue `protobuf:"bytes,1,rep,name=index_value" json:"index_value,omitempty"`
	Key              *Reference                 `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	Before           *bool                      `protobuf:"varint,3,opt,name=before,def=1" json:"before,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *IndexPostfix) Reset()         { *m = IndexPostfix{} }
func (m *IndexPostfix) String() string { return proto.CompactTextString(m) }
func (*IndexPostfix) ProtoMessage()    {}

const Default_IndexPostfix_Before bool = true

func (m *IndexPostfix) GetIndexValue() []*IndexPostfix_IndexValue {
	if m != nil {
		return m.IndexValue
	}
	return nil
}

func (m *IndexPostfix) GetKey() *Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *IndexPostfix) GetBefore() bool {
	if m != nil && m.Before != nil {
		return *m.Before
	}
	return Default_IndexPostfix_Before
}

type IndexPostfix_IndexValue struct {
	PropertyName     *string        `protobuf:"bytes,1,req,name=property_name" json:"property_name,omitempty"`
	Value            *PropertyValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *IndexPostfix_IndexValue) Reset()         { *m = IndexPostfix_IndexValue{} }
func (m *IndexPostfix_IndexValue) String() string { return proto.CompactTextString(m) }
func (*IndexPostfix_IndexValue) ProtoMessage()    {}

func (m *IndexPostfix_IndexValue) GetPropertyName() string {
	if m != nil && m.PropertyName != nil {
		return *m.PropertyName
	}
	return ""
}

func (m *IndexPostfix_IndexValue) GetValue() *PropertyValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type IndexPosition struct {
	Key              *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Before           *bool   `protobuf:"varint,2,opt,name=before,def=1" json:"before,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *IndexPosition) Reset()         { *m = IndexPosition{} }
func (m *IndexPosition) String() string { return proto.CompactTextString(m) }
func (*IndexPosition) ProtoMessage()    {}

const Default_IndexPosition_Before bool = true

func (m *IndexPosition) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *IndexPosition) GetBefore() bool {
	if m != nil && m.Before != nil {
		return *m.Before
	}
	return Default_IndexPosition_Before
}

type Snapshot struct {
	Ts               *int64 `protobuf:"varint,1,req,name=ts" json:"ts,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}

func (m *Snapshot) GetTs() int64 {
	if m != nil && m.Ts != nil {
		return *m.Ts
	}
	return 0
}

type InternalHeader struct {
	Qos              *string `protobuf:"bytes,1,opt,name=qos" json:"qos,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *InternalHeader) Reset()         { *m = InternalHeader{} }
func (m *InternalHeader) String() string { return proto.CompactTextString(m) }
func (*InternalHeader) ProtoMessage()    {}

func (m *InternalHeader) GetQos() string {
	if m != nil && m.Qos != nil {
		return *m.Qos
	}
	return ""
}

type Transaction struct {
	Header           *InternalHeader `protobuf:"bytes,4,opt,name=header" json:"header,omitempty"`
	Handle           *uint64         `protobuf:"fixed64,1,req,name=handle" json:"handle,omitempty"`
	App              *string         `protobuf:"bytes,2,req,name=app" json:"app,omitempty"`
	MarkChanges      *bool           `protobuf:"varint,3,opt,name=mark_changes,def=0" json:"mark_changes,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *Transaction) Reset()         { *m = Transaction{} }
func (m *Transaction) String() string { return proto.CompactTextString(m) }
func (*Transaction) ProtoMessage()    {}

const Default_Transaction_MarkChanges bool = false

func (m *Transaction) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *Transaction) GetHandle() uint64 {
	if m != nil && m.Handle != nil {
		return *m.Handle
	}
	return 0
}

func (m *Transaction) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

func (m *Transaction) GetMarkChanges() bool {
	if m != nil && m.MarkChanges != nil {
		return *m.MarkChanges
	}
	return Default_Transaction_MarkChanges
}

type Query struct {
	Header              *InternalHeader   `protobuf:"bytes,39,opt,name=header" json:"header,omitempty"`
	App                 *string           `protobuf:"bytes,1,req,name=app" json:"app,omitempty"`
	NameSpace           *string           `protobuf:"bytes,29,opt,name=name_space" json:"name_space,omitempty"`
	Kind                *string           `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Ancestor            *Reference        `protobuf:"bytes,17,opt,name=ancestor" json:"ancestor,omitempty"`
	Filter              []*Query_Filter   `protobuf:"group,4,rep" json:"filter,omitempty"`
	SearchQuery         *string           `protobuf:"bytes,8,opt,name=search_query" json:"search_query,omitempty"`
	Order               []*Query_Order    `protobuf:"group,9,rep" json:"order,omitempty"`
	Hint                *Query_Hint       `protobuf:"varint,18,opt,name=hint,enum=appengine.Query_Hint" json:"hint,omitempty"`
	Count               *int32            `protobuf:"varint,23,opt,name=count" json:"count,omitempty"`
	Offset              *int32            `protobuf:"varint,12,opt,name=offset,def=0" json:"offset,omitempty"`
	Limit               *int32            `protobuf:"varint,16,opt,name=limit" json:"limit,omitempty"`
	CompiledCursor      *CompiledCursor   `protobuf:"bytes,30,opt,name=compiled_cursor" json:"compiled_cursor,omitempty"`
	EndCompiledCursor   *CompiledCursor   `protobuf:"bytes,31,opt,name=end_compiled_cursor" json:"end_compiled_cursor,omitempty"`
	CompositeIndex      []*CompositeIndex `protobuf:"bytes,19,rep,name=composite_index" json:"composite_index,omitempty"`
	RequirePerfectPlan  *bool             `protobuf:"varint,20,opt,name=require_perfect_plan,def=0" json:"require_perfect_plan,omitempty"`
	KeysOnly            *bool             `protobuf:"varint,21,opt,name=keys_only,def=0" json:"keys_only,omitempty"`
	Transaction         *Transaction      `protobuf:"bytes,22,opt,name=transaction" json:"transaction,omitempty"`
	Compile             *bool             `protobuf:"varint,25,opt,name=compile,def=0" json:"compile,omitempty"`
	FailoverMs          *int64            `protobuf:"varint,26,opt,name=failover_ms" json:"failover_ms,omitempty"`
	Strong              *bool             `protobuf:"varint,32,opt,name=strong" json:"strong,omitempty"`
	PropertyName        []string          `protobuf:"bytes,33,rep,name=property_name" json:"property_name,omitempty"`
	GroupByPropertyName []string          `protobuf:"bytes,34,rep,name=group_by_property_name" json:"group_by_property_name,omitempty"`
	Distinct            *bool             `protobuf:"varint,24,opt,name=distinct" json:"distinct,omitempty"`
	MinSafeTimeSeconds  *int64            `protobuf:"varint,35,opt,name=min_safe_time_seconds" json:"min_safe_time_seconds,omitempty"`
	SafeReplicaName     []string          `protobuf:"bytes,36,rep,name=safe_replica_name" json:"safe_replica_name,omitempty"`
	PersistOffset       *bool             `protobuf:"varint,37,opt,name=persist_offset,def=0" json:"persist_offset,omitempty"`
	XXX_unrecognized    []byte            `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}

const Default_Query_Offset int32 = 0
const Default_Query_RequirePerfectPlan bool = false
const Default_Query_KeysOnly bool = false
const Default_Query_Compile bool = false
const Default_Query_PersistOffset bool = false

func (m *Query) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *Query) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

func (m *Query) GetNameSpace() string {
	if m != nil && m.NameSpace != nil {
		return *m.NameSpace
	}
	return ""
}

func (m *Query) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *Query) GetAncestor() *Reference {
	if m != nil {
		return m.Ancestor
	}
	return nil
}

func (m *Query) GetFilter() []*Query_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Query) GetSearchQuery() string {
	if m != nil && m.SearchQuery != nil {
		return *m.SearchQuery
	}
	return ""
}

func (m *Query) GetOrder() []*Query_Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Query) GetHint() Query_Hint {
	if m != nil && m.Hint != nil {
		return *m.Hint
	}
	return Query_ORDER_FIRST
}

func (m *Query) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *Query) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return Default_Query_Offset
}

func (m *Query) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

func (m *Query) GetCompiledCursor() *CompiledCursor {
	if m != nil {
		return m.CompiledCursor
	}
	return nil
}

func (m *Query) GetEndCompiledCursor() *CompiledCursor {
	if m != nil {
		return m.EndCompiledCursor
	}
	return nil
}

func (m *Query) GetCompositeIndex() []*CompositeIndex {
	if m != nil {
		return m.CompositeIndex
	}
	return nil
}

func (m *Query) GetRequirePerfectPlan() bool {
	if m != nil && m.RequirePerfectPlan != nil {
		return *m.RequirePerfectPlan
	}
	return Default_Query_RequirePerfectPlan
}

func (m *Query) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return Default_Query_KeysOnly
}

func (m *Query) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *Query) GetCompile() bool {
	if m != nil && m.Compile != nil {
		return *m.Compile
	}
	return Default_Query_Compile
}

func (m *Query) GetFailoverMs() int64 {
	if m != nil && m.FailoverMs != nil {
		return *m.FailoverMs
	}
	return 0
}

func (m *Query) GetStrong() bool {
	if m != nil && m.Strong != nil {
		return *m.Strong
	}
	return false
}

func (m *Query) GetPropertyName() []string {
	if m != nil {
		return m.PropertyName
	}
	return nil
}

func (m *Query) GetGroupByPropertyName() []string {
	if m != nil {
		return m.GroupByPropertyName
	}
	return nil
}

func (m *Query) GetDistinct() bool {
	if m != nil && m.Distinct != nil {
		return *m.Distinct
	}
	return false
}

func (m *Query) GetMinSafeTimeSeconds() int64 {
	if m != nil && m.MinSafeTimeSeconds != nil {
		return *m.MinSafeTimeSeconds
	}
	return 0
}

func (m *Query) GetSafeReplicaName() []string {
	if m != nil {
		return m.SafeReplicaName
	}
	return nil
}

func (m *Query) GetPersistOffset() bool {
	if m != nil && m.PersistOffset != nil {
		return *m.PersistOffset
	}
	return Default_Query_PersistOffset
}

type Query_Filter struct {
	Op               *Query_Filter_Operator `protobuf:"varint,6,req,name=op,enum=appengine.Query_Filter_Operator" json:"op,omitempty"`
	Property         []*Property            `protobuf:"bytes,14,rep,name=property" json:"property,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *Query_Filter) Reset()         { *m = Query_Filter{} }
func (m *Query_Filter) String() string { return proto.CompactTextString(m) }
func (*Query_Filter) ProtoMessage()    {}

func (m *Query_Filter) GetOp() Query_Filter_Operator {
	if m != nil && m.Op != nil {
		return *m.Op
	}
	return Query_Filter_LESS_THAN
}

func (m *Query_Filter) GetProperty() []*Property {
	if m != nil {
		return m.Property
	}
	return nil
}

type Query_Order struct {
	Property         *string                `protobuf:"bytes,10,req,name=property" json:"property,omitempty"`
	Direction        *Query_Order_Direction `protobuf:"varint,11,opt,name=direction,enum=appengine.Query_Order_Direction,def=1" json:"direction,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *Query_Order) Reset()         { *m = Query_Order{} }
func (m *Query_Order) String() string { return proto.CompactTextString(m) }
func (*Query_Order) ProtoMessage()    {}

const Default_Query_Order_Direction Query_Order_Direction = Query_Order_ASCENDING

func (m *Query_Order) GetProperty() string {
	if m != nil && m.Property != nil {
		return *m.Property
	}
	return ""
}

func (m *Query_Order) GetDirection() Query_Order_Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return Default_Query_Order_Direction
}

type CompiledQuery struct {
	Primaryscan       *CompiledQuery_PrimaryScan     `protobuf:"group,1,req,name=PrimaryScan" json:"primaryscan,omitempty"`
	Mergejoinscan     []*CompiledQuery_MergeJoinScan `protobuf:"group,7,rep,name=MergeJoinScan" json:"mergejoinscan,omitempty"`
	IndexDef          *Index                         `protobuf:"bytes,21,opt,name=index_def" json:"index_def,omitempty"`
	Offset            *int32                         `protobuf:"varint,10,opt,name=offset,def=0" json:"offset,omitempty"`
	Limit             *int32                         `protobuf:"varint,11,opt,name=limit" json:"limit,omitempty"`
	KeysOnly          *bool                          `protobuf:"varint,12,req,name=keys_only" json:"keys_only,omitempty"`
	PropertyName      []string                       `protobuf:"bytes,24,rep,name=property_name" json:"property_name,omitempty"`
	DistinctInfixSize *int32                         `protobuf:"varint,25,opt,name=distinct_infix_size" json:"distinct_infix_size,omitempty"`
	Entityfilter      *CompiledQuery_EntityFilter    `protobuf:"group,13,opt,name=EntityFilter" json:"entityfilter,omitempty"`
	XXX_unrecognized  []byte                         `json:"-"`
}

func (m *CompiledQuery) Reset()         { *m = CompiledQuery{} }
func (m *CompiledQuery) String() string { return proto.CompactTextString(m) }
func (*CompiledQuery) ProtoMessage()    {}

const Default_CompiledQuery_Offset int32 = 0

func (m *CompiledQuery) GetPrimaryscan() *CompiledQuery_PrimaryScan {
	if m != nil {
		return m.Primaryscan
	}
	return nil
}

func (m *CompiledQuery) GetMergejoinscan() []*CompiledQuery_MergeJoinScan {
	if m != nil {
		return m.Mergejoinscan
	}
	return nil
}

func (m *CompiledQuery) GetIndexDef() *Index {
	if m != nil {
		return m.IndexDef
	}
	return nil
}

func (m *CompiledQuery) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return Default_CompiledQuery_Offset
}

func (m *CompiledQuery) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

func (m *CompiledQuery) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

func (m *CompiledQuery) GetPropertyName() []string {
	if m != nil {
		return m.PropertyName
	}
	return nil
}

func (m *CompiledQuery) GetDistinctInfixSize() int32 {
	if m != nil && m.DistinctInfixSize != nil {
		return *m.DistinctInfixSize
	}
	return 0
}

func (m *CompiledQuery) GetEntityfilter() *CompiledQuery_EntityFilter {
	if m != nil {
		return m.Entityfilter
	}
	return nil
}

type CompiledQuery_PrimaryScan struct {
	IndexName                  *string  `protobuf:"bytes,2,opt,name=index_name" json:"index_name,omitempty"`
	StartKey                   *string  `protobuf:"bytes,3,opt,name=start_key" json:"start_key,omitempty"`
	StartInclusive             *bool    `protobuf:"varint,4,opt,name=start_inclusive" json:"start_inclusive,omitempty"`
	EndKey                     *string  `protobuf:"bytes,5,opt,name=end_key" json:"end_key,omitempty"`
	EndInclusive               *bool    `protobuf:"varint,6,opt,name=end_inclusive" json:"end_inclusive,omitempty"`
	StartPostfixValue          []string `protobuf:"bytes,22,rep,name=start_postfix_value" json:"start_postfix_value,omitempty"`
	EndPostfixValue            []string `protobuf:"bytes,23,rep,name=end_postfix_value" json:"end_postfix_value,omitempty"`
	EndUnappliedLogTimestampUs *int64   `protobuf:"varint,19,opt,name=end_unapplied_log_timestamp_us" json:"end_unapplied_log_timestamp_us,omitempty"`
	XXX_unrecognized           []byte   `json:"-"`
}

func (m *CompiledQuery_PrimaryScan) Reset()         { *m = CompiledQuery_PrimaryScan{} }
func (m *CompiledQuery_PrimaryScan) String() string { return proto.CompactTextString(m) }
func (*CompiledQuery_PrimaryScan) ProtoMessage()    {}

func (m *CompiledQuery_PrimaryScan) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

func (m *CompiledQuery_PrimaryScan) GetStartKey() string {
	if m != nil && m.StartKey != nil {
		return *m.StartKey
	}
	return ""
}

func (m *CompiledQuery_PrimaryScan) GetStartInclusive() bool {
	if m != nil && m.StartInclusive != nil {
		return *m.StartInclusive
	}
	return false
}

func (m *CompiledQuery_PrimaryScan) GetEndKey() string {
	if m != nil && m.EndKey != nil {
		return *m.EndKey
	}
	return ""
}

func (m *CompiledQuery_PrimaryScan) GetEndInclusive() bool {
	if m != nil && m.EndInclusive != nil {
		return *m.EndInclusive
	}
	return false
}

func (m *CompiledQuery_PrimaryScan) GetStartPostfixValue() []string {
	if m != nil {
		return m.StartPostfixValue
	}
	return nil
}

func (m *CompiledQuery_PrimaryScan) GetEndPostfixValue() []string {
	if m != nil {
		return m.EndPostfixValue
	}
	return nil
}

func (m *CompiledQuery_PrimaryScan) GetEndUnappliedLogTimestampUs() int64 {
	if m != nil && m.EndUnappliedLogTimestampUs != nil {
		return *m.EndUnappliedLogTimestampUs
	}
	return 0
}

type CompiledQuery_MergeJoinScan struct {
	IndexName        *string  `protobuf:"bytes,8,req,name=index_name" json:"index_name,omitempty"`
	PrefixValue      []string `protobuf:"bytes,9,rep,name=prefix_value" json:"prefix_value,omitempty"`
	ValuePrefix      *bool    `protobuf:"varint,20,opt,name=value_prefix,def=0" json:"value_prefix,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *CompiledQuery_MergeJoinScan) Reset()         { *m = CompiledQuery_MergeJoinScan{} }
func (m *CompiledQuery_MergeJoinScan) String() string { return proto.CompactTextString(m) }
func (*CompiledQuery_MergeJoinScan) ProtoMessage()    {}

const Default_CompiledQuery_MergeJoinScan_ValuePrefix bool = false

func (m *CompiledQuery_MergeJoinScan) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

func (m *CompiledQuery_MergeJoinScan) GetPrefixValue() []string {
	if m != nil {
		return m.PrefixValue
	}
	return nil
}

func (m *CompiledQuery_MergeJoinScan) GetValuePrefix() bool {
	if m != nil && m.ValuePrefix != nil {
		return *m.ValuePrefix
	}
	return Default_CompiledQuery_MergeJoinScan_ValuePrefix
}

type CompiledQuery_EntityFilter struct {
	Distinct         *bool      `protobuf:"varint,14,opt,name=distinct,def=0" json:"distinct,omitempty"`
	Kind             *string    `protobuf:"bytes,17,opt,name=kind" json:"kind,omitempty"`
	Ancestor         *Reference `protobuf:"bytes,18,opt,name=ancestor" json:"ancestor,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *CompiledQuery_EntityFilter) Reset()         { *m = CompiledQuery_EntityFilter{} }
func (m *CompiledQuery_EntityFilter) String() string { return proto.CompactTextString(m) }
func (*CompiledQuery_EntityFilter) ProtoMessage()    {}

const Default_CompiledQuery_EntityFilter_Distinct bool = false

func (m *CompiledQuery_EntityFilter) GetDistinct() bool {
	if m != nil && m.Distinct != nil {
		return *m.Distinct
	}
	return Default_CompiledQuery_EntityFilter_Distinct
}

func (m *CompiledQuery_EntityFilter) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *CompiledQuery_EntityFilter) GetAncestor() *Reference {
	if m != nil {
		return m.Ancestor
	}
	return nil
}

type CompiledCursor struct {
	Position         *CompiledCursor_Position `protobuf:"group,2,opt" json:"position,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *CompiledCursor) Reset()         { *m = CompiledCursor{} }
func (m *CompiledCursor) String() string { return proto.CompactTextString(m) }
func (*CompiledCursor) ProtoMessage()    {}

func (m *CompiledCursor) GetPosition() *CompiledCursor_Position {
	if m != nil {
		return m.Position
	}
	return nil
}

type CompiledCursor_Position struct {
	StartKey         *string                               `protobuf:"bytes,27,opt,name=start_key" json:"start_key,omitempty"`
	Indexvalue       []*CompiledCursor_Position_IndexValue `protobuf:"group,29,rep,name=IndexValue" json:"indexvalue,omitempty"`
	Key              *Reference                            `protobuf:"bytes,32,opt,name=key" json:"key,omitempty"`
	StartInclusive   *bool                                 `protobuf:"varint,28,opt,name=start_inclusive,def=1" json:"start_inclusive,omitempty"`
	XXX_unrecognized []byte                                `json:"-"`
}

func (m *CompiledCursor_Position) Reset()         { *m = CompiledCursor_Position{} }
func (m *CompiledCursor_Position) String() string { return proto.CompactTextString(m) }
func (*CompiledCursor_Position) ProtoMessage()    {}

const Default_CompiledCursor_Position_StartInclusive bool = true

func (m *CompiledCursor_Position) GetStartKey() string {
	if m != nil && m.StartKey != nil {
		return *m.StartKey
	}
	return ""
}

func (m *CompiledCursor_Position) GetIndexvalue() []*CompiledCursor_Position_IndexValue {
	if m != nil {
		return m.Indexvalue
	}
	return nil
}

func (m *CompiledCursor_Position) GetKey() *Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CompiledCursor_Position) GetStartInclusive() bool {
	if m != nil && m.StartInclusive != nil {
		return *m.StartInclusive
	}
	return Default_CompiledCursor_Position_StartInclusive
}

type CompiledCursor_Position_IndexValue struct {
	Property         *string        `protobuf:"bytes,30,opt,name=property" json:"property,omitempty"`
	Value            *PropertyValue `protobuf:"bytes,31,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *CompiledCursor_Position_IndexValue) Reset()         { *m = CompiledCursor_Position_IndexValue{} }
func (m *CompiledCursor_Position_IndexValue) String() string { return proto.CompactTextString(m) }
func (*CompiledCursor_Position_IndexValue) ProtoMessage()    {}

func (m *CompiledCursor_Position_IndexValue) GetProperty() string {
	if m != nil && m.Property != nil {
		return *m.Property
	}
	return ""
}

func (m *CompiledCursor_Position_IndexValue) GetValue() *PropertyValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type Cursor struct {
	Cursor           *uint64 `protobuf:"fixed64,1,req,name=cursor" json:"cursor,omitempty"`
	App              *string `protobuf:"bytes,2,opt,name=app" json:"app,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Cursor) Reset()         { *m = Cursor{} }
func (m *Cursor) String() string { return proto.CompactTextString(m) }
func (*Cursor) ProtoMessage()    {}

func (m *Cursor) GetCursor() uint64 {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return 0
}

func (m *Cursor) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

type Error struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}

type Cost struct {
	IndexWrites             *int32           `protobuf:"varint,1,opt,name=index_writes" json:"index_writes,omitempty"`
	IndexWriteBytes         *int32           `protobuf:"varint,2,opt,name=index_write_bytes" json:"index_write_bytes,omitempty"`
	EntityWrites            *int32           `protobuf:"varint,3,opt,name=entity_writes" json:"entity_writes,omitempty"`
	EntityWriteBytes        *int32           `protobuf:"varint,4,opt,name=entity_write_bytes" json:"entity_write_bytes,omitempty"`
	Commitcost              *Cost_CommitCost `protobuf:"group,5,opt,name=CommitCost" json:"commitcost,omitempty"`
	ApproximateStorageDelta *int32           `protobuf:"varint,8,opt,name=approximate_storage_delta" json:"approximate_storage_delta,omitempty"`
	IdSequenceUpdates       *int32           `protobuf:"varint,9,opt,name=id_sequence_updates" json:"id_sequence_updates,omitempty"`
	XXX_unrecognized        []byte           `json:"-"`
}

func (m *Cost) Reset()         { *m = Cost{} }
func (m *Cost) String() string { return proto.CompactTextString(m) }
func (*Cost) ProtoMessage()    {}

func (m *Cost) GetIndexWrites() int32 {
	if m != nil && m.IndexWrites != nil {
		return *m.IndexWrites
	}
	return 0
}

func (m *Cost) GetIndexWriteBytes() int32 {
	if m != nil && m.IndexWriteBytes != nil {
		return *m.IndexWriteBytes
	}
	return 0
}

func (m *Cost) GetEntityWrites() int32 {
	if m != nil && m.EntityWrites != nil {
		return *m.EntityWrites
	}
	return 0
}

func (m *Cost) GetEntityWriteBytes() int32 {
	if m != nil && m.EntityWriteBytes != nil {
		return *m.EntityWriteBytes
	}
	return 0
}

func (m *Cost) GetCommitcost() *Cost_CommitCost {
	if m != nil {
		return m.Commitcost
	}
	return nil
}

func (m *Cost) GetApproximateStorageDelta() int32 {
	if m != nil && m.ApproximateStorageDelta != nil {
		return *m.ApproximateStorageDelta
	}
	return 0
}

func (m *Cost) GetIdSequenceUpdates() int32 {
	if m != nil && m.IdSequenceUpdates != nil {
		return *m.IdSequenceUpdates
	}
	return 0
}

type Cost_CommitCost struct {
	RequestedEntityPuts    *int32 `protobuf:"varint,6,opt,name=requested_entity_puts" json:"requested_entity_puts,omitempty"`
	RequestedEntityDeletes *int32 `protobuf:"varint,7,opt,name=requested_entity_deletes" json:"requested_entity_deletes,omitempty"`
	XXX_unrecognized       []byte `json:"-"`
}

func (m *Cost_CommitCost) Reset()         { *m = Cost_CommitCost{} }
func (m *Cost_CommitCost) String() string { return proto.CompactTextString(m) }
func (*Cost_CommitCost) ProtoMessage()    {}

func (m *Cost_CommitCost) GetRequestedEntityPuts() int32 {
	if m != nil && m.RequestedEntityPuts != nil {
		return *m.RequestedEntityPuts
	}
	return 0
}

func (m *Cost_CommitCost) GetRequestedEntityDeletes() int32 {
	if m != nil && m.RequestedEntityDeletes != nil {
		return *m.RequestedEntityDeletes
	}
	return 0
}

type GetRequest struct {
	Header           *InternalHeader `protobuf:"bytes,6,opt,name=header" json:"header,omitempty"`
	Key              []*Reference    `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	Transaction      *Transaction    `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	FailoverMs       *int64          `protobuf:"varint,3,opt,name=failover_ms" json:"failover_ms,omitempty"`
	Strong           *bool           `protobuf:"varint,4,opt,name=strong" json:"strong,omitempty"`
	AllowDeferred    *bool           `protobuf:"varint,5,opt,name=allow_deferred,def=0" json:"allow_deferred,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *GetRequest) Reset()         { *m = GetRequest{} }
func (m *GetRequest) String() string { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()    {}

const Default_GetRequest_AllowDeferred bool = false

func (m *GetRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *GetRequest) GetKey() []*Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *GetRequest) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *GetRequest) GetFailoverMs() int64 {
	if m != nil && m.FailoverMs != nil {
		return *m.FailoverMs
	}
	return 0
}

func (m *GetRequest) GetStrong() bool {
	if m != nil && m.Strong != nil {
		return *m.Strong
	}
	return false
}

func (m *GetRequest) GetAllowDeferred() bool {
	if m != nil && m.AllowDeferred != nil {
		return *m.AllowDeferred
	}
	return Default_GetRequest_AllowDeferred
}

type GetResponse struct {
	Entity           []*GetResponse_Entity `protobuf:"group,1,rep" json:"entity,omitempty"`
	Deferred         []*Reference          `protobuf:"bytes,5,rep,name=deferred" json:"deferred,omitempty"`
	InOrder          *bool                 `protobuf:"varint,6,opt,name=in_order,def=1" json:"in_order,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *GetResponse) Reset()         { *m = GetResponse{} }
func (m *GetResponse) String() string { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()    {}

const Default_GetResponse_InOrder bool = true

func (m *GetResponse) GetEntity() []*GetResponse_Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *GetResponse) GetDeferred() []*Reference {
	if m != nil {
		return m.Deferred
	}
	return nil
}

func (m *GetResponse) GetInOrder() bool {
	if m != nil && m.InOrder != nil {
		return *m.InOrder
	}
	return Default_GetResponse_InOrder
}

type GetResponse_Entity struct {
	Entity           *EntityProto `protobuf:"bytes,2,opt,name=entity" json:"entity,omitempty"`
	Key              *Reference   `protobuf:"bytes,4,opt,name=key" json:"key,omitempty"`
	Version          *int64       `protobuf:"varint,3,opt,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *GetResponse_Entity) Reset()         { *m = GetResponse_Entity{} }
func (m *GetResponse_Entity) String() string { return proto.CompactTextString(m) }
func (*GetResponse_Entity) ProtoMessage()    {}

func (m *GetResponse_Entity) GetEntity() *EntityProto {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *GetResponse_Entity) GetKey() *Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *GetResponse_Entity) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

type PutRequest struct {
	Header           *InternalHeader          `protobuf:"bytes,11,opt,name=header" json:"header,omitempty"`
	Entity           []*EntityProto           `protobuf:"bytes,1,rep,name=entity" json:"entity,omitempty"`
	Transaction      *Transaction             `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	CompositeIndex   []*CompositeIndex        `protobuf:"bytes,3,rep,name=composite_index" json:"composite_index,omitempty"`
	Trusted          *bool                    `protobuf:"varint,4,opt,name=trusted,def=0" json:"trusted,omitempty"`
	Force            *bool                    `protobuf:"varint,7,opt,name=force,def=0" json:"force,omitempty"`
	MarkChanges      *bool                    `protobuf:"varint,8,opt,name=mark_changes,def=0" json:"mark_changes,omitempty"`
	Snapshot         []*Snapshot              `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
	AutoIdPolicy     *PutRequest_AutoIdPolicy `protobuf:"varint,10,opt,name=auto_id_policy,enum=appengine.PutRequest_AutoIdPolicy,def=0" json:"auto_id_policy,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *PutRequest) Reset()         { *m = PutRequest{} }
func (m *PutRequest) String() string { return proto.CompactTextString(m) }
func (*PutRequest) ProtoMessage()    {}

const Default_PutRequest_Trusted bool = false
const Default_PutRequest_Force bool = false
const Default_PutRequest_MarkChanges bool = false
const Default_PutRequest_AutoIdPolicy PutRequest_AutoIdPolicy = PutRequest_CURRENT

func (m *PutRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *PutRequest) GetEntity() []*EntityProto {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *PutRequest) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *PutRequest) GetCompositeIndex() []*CompositeIndex {
	if m != nil {
		return m.CompositeIndex
	}
	return nil
}

func (m *PutRequest) GetTrusted() bool {
	if m != nil && m.Trusted != nil {
		return *m.Trusted
	}
	return Default_PutRequest_Trusted
}

func (m *PutRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return Default_PutRequest_Force
}

func (m *PutRequest) GetMarkChanges() bool {
	if m != nil && m.MarkChanges != nil {
		return *m.MarkChanges
	}
	return Default_PutRequest_MarkChanges
}

func (m *PutRequest) GetSnapshot() []*Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

func (m *PutRequest) GetAutoIdPolicy() PutRequest_AutoIdPolicy {
	if m != nil && m.AutoIdPolicy != nil {
		return *m.AutoIdPolicy
	}
	return Default_PutRequest_AutoIdPolicy
}

type PutResponse struct {
	Key              []*Reference `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	Cost             *Cost        `protobuf:"bytes,2,opt,name=cost" json:"cost,omitempty"`
	Version          []int64      `protobuf:"varint,3,rep,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *PutResponse) Reset()         { *m = PutResponse{} }
func (m *PutResponse) String() string { return proto.CompactTextString(m) }
func (*PutResponse) ProtoMessage()    {}

func (m *PutResponse) GetKey() []*Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *PutResponse) GetCost() *Cost {
	if m != nil {
		return m.Cost
	}
	return nil
}

func (m *PutResponse) GetVersion() []int64 {
	if m != nil {
		return m.Version
	}
	return nil
}

type TouchRequest struct {
	Header           *InternalHeader   `protobuf:"bytes,10,opt,name=header" json:"header,omitempty"`
	Key              []*Reference      `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	CompositeIndex   []*CompositeIndex `protobuf:"bytes,2,rep,name=composite_index" json:"composite_index,omitempty"`
	Force            *bool             `protobuf:"varint,3,opt,name=force,def=0" json:"force,omitempty"`
	Snapshot         []*Snapshot       `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *TouchRequest) Reset()         { *m = TouchRequest{} }
func (m *TouchRequest) String() string { return proto.CompactTextString(m) }
func (*TouchRequest) ProtoMessage()    {}

const Default_TouchRequest_Force bool = false

func (m *TouchRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *TouchRequest) GetKey() []*Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TouchRequest) GetCompositeIndex() []*CompositeIndex {
	if m != nil {
		return m.CompositeIndex
	}
	return nil
}

func (m *TouchRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return Default_TouchRequest_Force
}

func (m *TouchRequest) GetSnapshot() []*Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

type TouchResponse struct {
	Cost             *Cost  `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TouchResponse) Reset()         { *m = TouchResponse{} }
func (m *TouchResponse) String() string { return proto.CompactTextString(m) }
func (*TouchResponse) ProtoMessage()    {}

func (m *TouchResponse) GetCost() *Cost {
	if m != nil {
		return m.Cost
	}
	return nil
}

type DeleteRequest struct {
	Header           *InternalHeader `protobuf:"bytes,10,opt,name=header" json:"header,omitempty"`
	Key              []*Reference    `protobuf:"bytes,6,rep,name=key" json:"key,omitempty"`
	Transaction      *Transaction    `protobuf:"bytes,5,opt,name=transaction" json:"transaction,omitempty"`
	Trusted          *bool           `protobuf:"varint,4,opt,name=trusted,def=0" json:"trusted,omitempty"`
	Force            *bool           `protobuf:"varint,7,opt,name=force,def=0" json:"force,omitempty"`
	MarkChanges      *bool           `protobuf:"varint,8,opt,name=mark_changes,def=0" json:"mark_changes,omitempty"`
	Snapshot         []*Snapshot     `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *DeleteRequest) Reset()         { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()    {}

const Default_DeleteRequest_Trusted bool = false
const Default_DeleteRequest_Force bool = false
const Default_DeleteRequest_MarkChanges bool = false

func (m *DeleteRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *DeleteRequest) GetKey() []*Reference {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *DeleteRequest) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *DeleteRequest) GetTrusted() bool {
	if m != nil && m.Trusted != nil {
		return *m.Trusted
	}
	return Default_DeleteRequest_Trusted
}

func (m *DeleteRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return Default_DeleteRequest_Force
}

func (m *DeleteRequest) GetMarkChanges() bool {
	if m != nil && m.MarkChanges != nil {
		return *m.MarkChanges
	}
	return Default_DeleteRequest_MarkChanges
}

func (m *DeleteRequest) GetSnapshot() []*Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

type DeleteResponse struct {
	Cost             *Cost   `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
	Version          []int64 `protobuf:"varint,3,rep,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DeleteResponse) Reset()         { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()    {}

func (m *DeleteResponse) GetCost() *Cost {
	if m != nil {
		return m.Cost
	}
	return nil
}

func (m *DeleteResponse) GetVersion() []int64 {
	if m != nil {
		return m.Version
	}
	return nil
}

type NextRequest struct {
	Header           *InternalHeader `protobuf:"bytes,5,opt,name=header" json:"header,omitempty"`
	Cursor           *Cursor         `protobuf:"bytes,1,req,name=cursor" json:"cursor,omitempty"`
	Count            *int32          `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	Offset           *int32          `protobuf:"varint,4,opt,name=offset,def=0" json:"offset,omitempty"`
	Compile          *bool           `protobuf:"varint,3,opt,name=compile,def=0" json:"compile,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *NextRequest) Reset()         { *m = NextRequest{} }
func (m *NextRequest) String() string { return proto.CompactTextString(m) }
func (*NextRequest) ProtoMessage()    {}

const Default_NextRequest_Offset int32 = 0
const Default_NextRequest_Compile bool = false

func (m *NextRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *NextRequest) GetCursor() *Cursor {
	if m != nil {
		return m.Cursor
	}
	return nil
}

func (m *NextRequest) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *NextRequest) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return Default_NextRequest_Offset
}

func (m *NextRequest) GetCompile() bool {
	if m != nil && m.Compile != nil {
		return *m.Compile
	}
	return Default_NextRequest_Compile
}

type QueryResult struct {
	Cursor           *Cursor           `protobuf:"bytes,1,opt,name=cursor" json:"cursor,omitempty"`
	Result           []*EntityProto    `protobuf:"bytes,2,rep,name=result" json:"result,omitempty"`
	SkippedResults   *int32            `protobuf:"varint,7,opt,name=skipped_results" json:"skipped_results,omitempty"`
	MoreResults      *bool             `protobuf:"varint,3,req,name=more_results" json:"more_results,omitempty"`
	KeysOnly         *bool             `protobuf:"varint,4,opt,name=keys_only" json:"keys_only,omitempty"`
	IndexOnly        *bool             `protobuf:"varint,9,opt,name=index_only" json:"index_only,omitempty"`
	SmallOps         *bool             `protobuf:"varint,10,opt,name=small_ops" json:"small_ops,omitempty"`
	CompiledQuery    *CompiledQuery    `protobuf:"bytes,5,opt,name=compiled_query" json:"compiled_query,omitempty"`
	CompiledCursor   *CompiledCursor   `protobuf:"bytes,6,opt,name=compiled_cursor" json:"compiled_cursor,omitempty"`
	Index            []*CompositeIndex `protobuf:"bytes,8,rep,name=index" json:"index,omitempty"`
	Version          []int64           `protobuf:"varint,11,rep,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}

func (m *QueryResult) GetCursor() *Cursor {
	if m != nil {
		return m.Cursor
	}
	return nil
}

func (m *QueryResult) GetResult() []*EntityProto {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *QueryResult) GetSkippedResults() int32 {
	if m != nil && m.SkippedResults != nil {
		return *m.SkippedResults
	}
	return 0
}

func (m *QueryResult) GetMoreResults() bool {
	if m != nil && m.MoreResults != nil {
		return *m.MoreResults
	}
	return false
}

func (m *QueryResult) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

func (m *QueryResult) GetIndexOnly() bool {
	if m != nil && m.IndexOnly != nil {
		return *m.IndexOnly
	}
	return false
}

func (m *QueryResult) GetSmallOps() bool {
	if m != nil && m.SmallOps != nil {
		return *m.SmallOps
	}
	return false
}

func (m *QueryResult) GetCompiledQuery() *CompiledQuery {
	if m != nil {
		return m.CompiledQuery
	}
	return nil
}

func (m *QueryResult) GetCompiledCursor() *CompiledCursor {
	if m != nil {
		return m.CompiledCursor
	}
	return nil
}

func (m *QueryResult) GetIndex() []*CompositeIndex {
	if m != nil {
		return m.Index
	}
	return nil
}

func (m *QueryResult) GetVersion() []int64 {
	if m != nil {
		return m.Version
	}
	return nil
}

type AllocateIdsRequest struct {
	Header           *InternalHeader `protobuf:"bytes,4,opt,name=header" json:"header,omitempty"`
	ModelKey         *Reference      `protobuf:"bytes,1,opt,name=model_key" json:"model_key,omitempty"`
	Size             *int64          `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	Max              *int64          `protobuf:"varint,3,opt,name=max" json:"max,omitempty"`
	Reserve          []*Reference    `protobuf:"bytes,5,rep,name=reserve" json:"reserve,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *AllocateIdsRequest) Reset()         { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()    {}

func (m *AllocateIdsRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *AllocateIdsRequest) GetModelKey() *Reference {
	if m != nil {
		return m.ModelKey
	}
	return nil
}

func (m *AllocateIdsRequest) GetSize() int64 {
	if m != nil && m.Size != nil {
		return *m.Size
	}
	return 0
}

func (m *AllocateIdsRequest) GetMax() int64 {
	if m != nil && m.Max != nil {
		return *m.Max
	}
	return 0
}

func (m *AllocateIdsRequest) GetReserve() []*Reference {
	if m != nil {
		return m.Reserve
	}
	return nil
}

type AllocateIdsResponse struct {
	Start            *int64 `protobuf:"varint,1,req,name=start" json:"start,omitempty"`
	End              *int64 `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
	Cost             *Cost  `protobuf:"bytes,3,opt,name=cost" json:"cost,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AllocateIdsResponse) Reset()         { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()    {}

func (m *AllocateIdsResponse) GetStart() int64 {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return 0
}

func (m *AllocateIdsResponse) GetEnd() int64 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

func (m *AllocateIdsResponse) GetCost() *Cost {
	if m != nil {
		return m.Cost
	}
	return nil
}

type CompositeIndices struct {
	Index            []*CompositeIndex `protobuf:"bytes,1,rep,name=index" json:"index,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *CompositeIndices) Reset()         { *m = CompositeIndices{} }
func (m *CompositeIndices) String() string { return proto.CompactTextString(m) }
func (*CompositeIndices) ProtoMessage()    {}

func (m *CompositeIndices) GetIndex() []*CompositeIndex {
	if m != nil {
		return m.Index
	}
	return nil
}

type AddActionsRequest struct {
	Header           *InternalHeader `protobuf:"bytes,3,opt,name=header" json:"header,omitempty"`
	Transaction      *Transaction    `protobuf:"bytes,1,req,name=transaction" json:"transaction,omitempty"`
	Action           []*Action       `protobuf:"bytes,2,rep,name=action" json:"action,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *AddActionsRequest) Reset()         { *m = AddActionsRequest{} }
func (m *AddActionsRequest) String() string { return proto.CompactTextString(m) }
func (*AddActionsRequest) ProtoMessage()    {}

func (m *AddActionsRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *AddActionsRequest) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *AddActionsRequest) GetAction() []*Action {
	if m != nil {
		return m.Action
	}
	return nil
}

type AddActionsResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *AddActionsResponse) Reset()         { *m = AddActionsResponse{} }
func (m *AddActionsResponse) String() string { return proto.CompactTextString(m) }
func (*AddActionsResponse) ProtoMessage()    {}

type BeginTransactionRequest struct {
	Header           *InternalHeader `protobuf:"bytes,3,opt,name=header" json:"header,omitempty"`
	App              *string         `protobuf:"bytes,1,req,name=app" json:"app,omitempty"`
	AllowMultipleEg  *bool           `protobuf:"varint,2,opt,name=allow_multiple_eg,def=0" json:"allow_multiple_eg,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}

const Default_BeginTransactionRequest_AllowMultipleEg bool = false

func (m *BeginTransactionRequest) GetHeader() *InternalHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *BeginTransactionRequest) GetApp() string {
	if m != nil && m.App != nil {
		return *m.App
	}
	return ""
}

func (m *BeginTransactionRequest) GetAllowMultipleEg() bool {
	if m != nil && m.AllowMultipleEg != nil {
		return *m.AllowMultipleEg
	}
	return Default_BeginTransactionRequest_AllowMultipleEg
}

type CommitResponse struct {
	Cost             *Cost                     `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
	Version          []*CommitResponse_Version `protobuf:"group,3,rep" json:"version,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}

func (m *CommitResponse) GetCost() *Cost {
	if m != nil {
		return m.Cost
	}
	return nil
}

func (m *CommitResponse) GetVersion() []*CommitResponse_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type CommitResponse_Version struct {
	RootEntityKey    *Reference `protobuf:"bytes,4,req,name=root_entity_key" json:"root_entity_key,omitempty"`
	Version          *int64     `protobuf:"varint,5,req,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *CommitResponse_Version) Reset()         { *m = CommitResponse_Version{} }
func (m *CommitResponse_Version) String() string { return proto.CompactTextString(m) }
func (*CommitResponse_Version) ProtoMessage()    {}

func (m *CommitResponse_Version) GetRootEntityKey() *Reference {
	if m != nil {
		return m.RootEntityKey
	}
	return nil
}

func (m *CommitResponse_Version) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func init() {
	proto.RegisterEnum("appengine.Property_Meaning", Property_Meaning_name, Property_Meaning_value)
	proto.RegisterEnum("appengine.Property_FtsTokenizationOption", Property_FtsTokenizationOption_name, Property_FtsTokenizationOption_value)
	proto.RegisterEnum("appengine.EntityProto_Kind", EntityProto_Kind_name, EntityProto_Kind_value)
	proto.RegisterEnum("appengine.Index_Property_Direction", Index_Property_Direction_name, Index_Property_Direction_value)
	proto.RegisterEnum("appengine.CompositeIndex_State", CompositeIndex_State_name, CompositeIndex_State_value)
	proto.RegisterEnum("appengine.Snapshot_Status", Snapshot_Status_name, Snapshot_Status_value)
	proto.RegisterEnum("appengine.Query_Hint", Query_Hint_name, Query_Hint_value)
	proto.RegisterEnum("appengine.Query_Filter_Operator", Query_Filter_Operator_name, Query_Filter_Operator_value)
	proto.RegisterEnum("appengine.Query_Order_Direction", Query_Order_Direction_name, Query_Order_Direction_value)
	proto.RegisterEnum("appengine.Error_ErrorCode", Error_ErrorCode_name, Error_ErrorCode_value)
	proto.RegisterEnum("appengine.PutRequest_AutoIdPolicy", PutRequest_AutoIdPolicy_name, PutRequest_AutoIdPolicy_value)
}
