package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_Route = map[string]string{
	"":         "Route encapsulates the inputs needed to connect an alias to endpoints.",
	"metadata": "Standard object's metadata.",
	"spec":     "Spec is the desired state of the route",
	"status":   "Status is the current state of the route",
}

func (Route) SwaggerDoc() map[string]string {
	return map_Route
}

var map_RouteIngress = map[string]string{
	"":           "RouteIngress holds information about the places where a route is exposed",
	"host":       "Host is the host string under which the route is exposed; this value is required",
	"routerName": "Name is a name chosen by the router to identify itself; this value is required",
	"conditions": "Conditions is the state of the route, may be empty.",
}

func (RouteIngress) SwaggerDoc() map[string]string {
	return map_RouteIngress
}

var map_RouteIngressCondition = map[string]string{
	"":                   "RouteIngressCondition contains details for the current condition of this pod.",
	"type":               "Type is the type of the condition. Currently only Ready.",
	"status":             "Status is the status of the condition. Can be True, False, Unknown.",
	"reason":             "(brief) reason for the condition's last transition, and is usually a machine and human readable constant",
	"message":            "Human readable message indicating details about last transition.",
	"lastTransitionTime": "RFC 3339 date and time when this condition last transitioned",
}

func (RouteIngressCondition) SwaggerDoc() map[string]string {
	return map_RouteIngressCondition
}

var map_RouteList = map[string]string{
	"":         "RouteList is a collection of Routes.",
	"metadata": "Standard object's metadata.",
	"items":    "Items is a list of routes",
}

func (RouteList) SwaggerDoc() map[string]string {
	return map_RouteList
}

var map_RoutePort = map[string]string{
	"":           "RoutePort defines a port mapping from a router to an endpoint in the service endpoints.",
	"targetPort": "The target port on pods selected by the service this route points to. If this is a string, it will be looked up as a named port in the target endpoints port list. Required",
}

func (RoutePort) SwaggerDoc() map[string]string {
	return map_RoutePort
}

var map_RouteSpec = map[string]string{
	"":                  "RouteSpec describes the route the user wishes to exist.",
	"host":              "Host is an alias/DNS that points to the service. Optional Must follow DNS952 subdomain conventions.",
	"path":              "Path that the router watches for, to route traffic for to the service. Optional",
	"to":                "To is an object the route points to. Only the Service kind is allowed, and it will be defaulted to Service.",
	"alternateBackends": "AlternateBackends is an extension of the 'to' field. If more than one service needs to be pointed to, then use this field. Use the weight field in RouteTargetReference object to specify relative preference",
	"port":              "If specified, the port to be used by the router. Most routers will use all endpoints exposed by the service by default - set this value to instruct routers which port to use.",
	"tls":               "TLS provides the ability to configure certificates and termination for the route",
}

func (RouteSpec) SwaggerDoc() map[string]string {
	return map_RouteSpec
}

var map_RouteStatus = map[string]string{
	"":        "RouteStatus provides relevant info about the status of a route, including which routers acknowledge it.",
	"ingress": "Ingress describes the places where the route may be exposed. The list of ingress points may contain duplicate Host or RouterName values. Routes are considered live once they are `Ready`",
}

func (RouteStatus) SwaggerDoc() map[string]string {
	return map_RouteStatus
}

var map_RouteTargetReference = map[string]string{
	"":       "RouteTargetReference specifies the target that resolve into endpoints. Only the 'Service' kind is allowed. Use 'weight' field to emphasize one over others.",
	"kind":   "The kind of target that the route is referring to. Currently, only 'Service' is allowed",
	"name":   "Name of the service/target that is being referred to. e.g. name of the service",
	"weight": "Weight as an integer between 1 and 256 that specifies the target's relative weight against other target reference objects",
}

func (RouteTargetReference) SwaggerDoc() map[string]string {
	return map_RouteTargetReference
}

var map_RouterShard = map[string]string{
	"":          "RouterShard has information of a routing shard and is used to generate host names and routing table entries when a routing shard is allocated for a specific route. Caveat: This is WIP and will likely undergo modifications when sharding\n        support is added.",
	"shardName": "ShardName uniquely identifies a router shard in the \"set\" of routers used for routing traffic to the services.",
	"dnsSuffix": "DNSSuffix for the shard ala: shard-1.v3.openshift.com",
}

func (RouterShard) SwaggerDoc() map[string]string {
	return map_RouterShard
}

var map_TLSConfig = map[string]string{
	"":                              "TLSConfig defines config used to secure a route and provide termination",
	"termination":                   "Termination indicates termination type.",
	"certificate":                   "Certificate provides certificate contents",
	"key":                           "Key provides key file contents",
	"caCertificate":                 "CACertificate provides the cert authority certificate contents",
	"destinationCACertificate":      "DestinationCACertificate provides the contents of the ca certificate of the final destination.  When using reencrypt termination this file should be provided in order to have routers use it for health checks on the secure connection",
	"insecureEdgeTerminationPolicy": "InsecureEdgeTerminationPolicy indicates the desired behavior for insecure connections to an edge-terminated route:\n  disable, allow or redirect",
}

func (TLSConfig) SwaggerDoc() map[string]string {
	return map_TLSConfig
}
