/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package imagepolicy

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/1.4/pkg/api"
	pkg1_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg3_types "k8s.io/client-go/1.4/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *ImageReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [19]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.Name != ""
			yyq2[3] = x.GenerateName != ""
			yyq2[4] = x.Namespace != ""
			yyq2[5] = x.SelfLink != ""
			yyq2[6] = x.UID != ""
			yyq2[7] = x.ResourceVersion != ""
			yyq2[8] = x.Generation != 0
			yyq2[9] = true
			yyq2[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq2[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq2[12] = len(x.Labels) != 0
			yyq2[13] = len(x.Annotations) != 0
			yyq2[14] = len(x.OwnerReferences) != 0
			yyq2[15] = len(x.Finalizers) != 0
			yyq2[16] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(19)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yy31 := &x.CreationTimestamp
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else if z.HasExtensions() && z.EncExt(yy31) {
					} else if yym32 {
						z.EncBinaryMarshal(yy31)
					} else if !yym32 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy31)
					} else {
						z.EncFallback(yy31)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy33 := &x.CreationTimestamp
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else if z.HasExtensions() && z.EncExt(yy33) {
					} else if yym34 {
						z.EncBinaryMarshal(yy33)
					} else if !yym34 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy33)
					} else {
						z.EncFallback(yy33)
					}
				}
			}
			var yyn35 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn35 = true
				goto LABEL35
			}
		LABEL35:
			if yyr2 || yy2arr2 {
				if yyn35 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym36 := z.EncBinary()
							_ = yym36
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym36 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym36 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn35 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym37 := z.EncBinary()
							_ = yym37
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym37 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym37 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn38 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn38 = true
				goto LABEL38
			}
		LABEL38:
			if yyr2 || yy2arr2 {
				if yyn38 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy39 := *x.DeletionGracePeriodSeconds
							yym40 := z.EncBinary()
							_ = yym40
							if false {
							} else {
								r.EncodeInt(int64(yy39))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn38 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy41 := *x.DeletionGracePeriodSeconds
							yym42 := z.EncBinary()
							_ = yym42
							if false {
							} else {
								r.EncodeInt(int64(yy41))
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym50 := z.EncBinary()
						_ = yym50
						if false {
						} else {
							h.encSliceapi_OwnerReference(([]pkg2_api.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym51 := z.EncBinary()
						_ = yym51
						if false {
						} else {
							h.encSliceapi_OwnerReference(([]pkg2_api.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym53 := z.EncBinary()
						_ = yym53
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym54 := z.EncBinary()
						_ = yym54
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					yym56 := z.EncBinary()
					_ = yym56
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy59 := &x.Spec
				yy59.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy60 := &x.Spec
				yy60.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy62 := &x.Status
				yy62.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.Status
				yy63.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ImageReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym64 := z.DecBinary()
	_ = yym64
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct65 := r.ContainerType()
		if yyct65 == codecSelferValueTypeMap1234 {
			yyl65 := r.ReadMapStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl65, d)
			}
		} else if yyct65 == codecSelferValueTypeArray1234 {
			yyl65 := r.ReadArrayStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl65, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ImageReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys66Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys66Slc
	var yyhl66 bool = l >= 0
	for yyj66 := 0; ; yyj66++ {
		if yyhl66 {
			if yyj66 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys66Slc = r.DecodeBytes(yys66Slc, true, true)
		yys66 := string(yys66Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys66 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg3_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_unversioned.Time{}
			} else {
				yyv76 := &x.CreationTimestamp
				yym77 := z.DecBinary()
				_ = yym77
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv76) {
				} else if yym77 {
					z.DecBinaryUnmarshal(yyv76)
				} else if !yym77 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv76)
				} else {
					z.DecFallback(yyv76, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_unversioned.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_unversioned.Time)
				}
				yym79 := z.DecBinary()
				_ = yym79
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym79 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym79 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym81 := z.DecBinary()
				_ = yym81
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv82 := &x.Labels
				yym83 := z.DecBinary()
				_ = yym83
				if false {
				} else {
					z.F.DecMapStringStringX(yyv82, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv84 := &x.Annotations
				yym85 := z.DecBinary()
				_ = yym85
				if false {
				} else {
					z.F.DecMapStringStringX(yyv84, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv86 := &x.OwnerReferences
				yym87 := z.DecBinary()
				_ = yym87
				if false {
				} else {
					h.decSliceapi_OwnerReference((*[]pkg2_api.OwnerReference)(yyv86), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv88 := &x.Finalizers
				yym89 := z.DecBinary()
				_ = yym89
				if false {
				} else {
					z.F.DecSliceStringX(yyv88, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "Spec":
			if r.TryDecodeAsNil() {
				x.Spec = ImageReviewSpec{}
			} else {
				yyv91 := &x.Spec
				yyv91.CodecDecodeSelf(d)
			}
		case "Status":
			if r.TryDecodeAsNil() {
				x.Status = ImageReviewStatus{}
			} else {
				yyv92 := &x.Status
				yyv92.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys66)
		} // end switch yys66
	} // end for yyj66
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ImageReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj93 int
	var yyb93 bool
	var yyhl93 bool = l >= 0
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg3_types.UID(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_unversioned.Time{}
	} else {
		yyv103 := &x.CreationTimestamp
		yym104 := z.DecBinary()
		_ = yym104
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv103) {
		} else if yym104 {
			z.DecBinaryUnmarshal(yyv103)
		} else if !yym104 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv103)
		} else {
			z.DecFallback(yyv103, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_unversioned.Time)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_unversioned.Time)
		}
		yym106 := z.DecBinary()
		_ = yym106
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym106 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym106 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv109 := &x.Labels
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else {
			z.F.DecMapStringStringX(yyv109, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv111 := &x.Annotations
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			z.F.DecMapStringStringX(yyv111, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv113 := &x.OwnerReferences
		yym114 := z.DecBinary()
		_ = yym114
		if false {
		} else {
			h.decSliceapi_OwnerReference((*[]pkg2_api.OwnerReference)(yyv113), d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv115 := &x.Finalizers
		yym116 := z.DecBinary()
		_ = yym116
		if false {
		} else {
			z.F.DecSliceStringX(yyv115, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ImageReviewSpec{}
	} else {
		yyv118 := &x.Spec
		yyv118.CodecDecodeSelf(d)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ImageReviewStatus{}
	} else {
		yyv119 := &x.Status
		yyv119.CodecDecodeSelf(d)
	}
	for {
		yyj93++
		if yyhl93 {
			yyb93 = yyj93 > l
		} else {
			yyb93 = r.CheckBreak()
		}
		if yyb93 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj93-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ImageReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym120 := z.EncBinary()
		_ = yym120
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep121 := !z.EncBinary()
			yy2arr121 := z.EncBasicHandle().StructToArray
			var yyq121 [3]bool
			_, _, _ = yysep121, yyq121, yy2arr121
			const yyr121 bool = false
			var yynn121 int
			if yyr121 || yy2arr121 {
				r.EncodeArrayStart(3)
			} else {
				yynn121 = 3
				for _, b := range yyq121 {
					if b {
						yynn121++
					}
				}
				r.EncodeMapStart(yynn121)
				yynn121 = 0
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym123 := z.EncBinary()
					_ = yym123
					if false {
					} else {
						h.encSliceImageReviewContainerSpec(([]ImageReviewContainerSpec)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym124 := z.EncBinary()
					_ = yym124
					if false {
					} else {
						h.encSliceImageReviewContainerSpec(([]ImageReviewContainerSpec)(x.Containers), e)
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Annotations == nil {
					r.EncodeNil()
				} else {
					yym126 := z.EncBinary()
					_ = yym126
					if false {
					} else {
						z.F.EncMapStringStringV(x.Annotations, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Annotations"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Annotations == nil {
					r.EncodeNil()
				} else {
					yym127 := z.EncBinary()
					_ = yym127
					if false {
					} else {
						z.F.EncMapStringStringV(x.Annotations, false, e)
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym129 := z.EncBinary()
				_ = yym129
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Namespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym130 := z.EncBinary()
				_ = yym130
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ImageReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym131 := z.DecBinary()
	_ = yym131
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct132 := r.ContainerType()
		if yyct132 == codecSelferValueTypeMap1234 {
			yyl132 := r.ReadMapStart()
			if yyl132 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl132, d)
			}
		} else if yyct132 == codecSelferValueTypeArray1234 {
			yyl132 := r.ReadArrayStart()
			if yyl132 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl132, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ImageReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys133Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys133Slc
	var yyhl133 bool = l >= 0
	for yyj133 := 0; ; yyj133++ {
		if yyhl133 {
			if yyj133 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys133Slc = r.DecodeBytes(yys133Slc, true, true)
		yys133 := string(yys133Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys133 {
		case "Containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv134 := &x.Containers
				yym135 := z.DecBinary()
				_ = yym135
				if false {
				} else {
					h.decSliceImageReviewContainerSpec((*[]ImageReviewContainerSpec)(yyv134), d)
				}
			}
		case "Annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv136 := &x.Annotations
				yym137 := z.DecBinary()
				_ = yym137
				if false {
				} else {
					z.F.DecMapStringStringX(yyv136, false, d)
				}
			}
		case "Namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys133)
		} // end switch yys133
	} // end for yyj133
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ImageReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj139 int
	var yyb139 bool
	var yyhl139 bool = l >= 0
	yyj139++
	if yyhl139 {
		yyb139 = yyj139 > l
	} else {
		yyb139 = r.CheckBreak()
	}
	if yyb139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv140 := &x.Containers
		yym141 := z.DecBinary()
		_ = yym141
		if false {
		} else {
			h.decSliceImageReviewContainerSpec((*[]ImageReviewContainerSpec)(yyv140), d)
		}
	}
	yyj139++
	if yyhl139 {
		yyb139 = yyj139 > l
	} else {
		yyb139 = r.CheckBreak()
	}
	if yyb139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv142 := &x.Annotations
		yym143 := z.DecBinary()
		_ = yym143
		if false {
		} else {
			z.F.DecMapStringStringX(yyv142, false, d)
		}
	}
	yyj139++
	if yyhl139 {
		yyb139 = yyj139 > l
	} else {
		yyb139 = r.CheckBreak()
	}
	if yyb139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	for {
		yyj139++
		if yyhl139 {
			yyb139 = yyj139 > l
		} else {
			yyb139 = r.CheckBreak()
		}
		if yyb139 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj139-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ImageReviewContainerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym145 := z.EncBinary()
		_ = yym145
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep146 := !z.EncBinary()
			yy2arr146 := z.EncBasicHandle().StructToArray
			var yyq146 [1]bool
			_, _, _ = yysep146, yyq146, yy2arr146
			const yyr146 bool = false
			var yynn146 int
			if yyr146 || yy2arr146 {
				r.EncodeArrayStart(1)
			} else {
				yynn146 = 1
				for _, b := range yyq146 {
					if b {
						yynn146++
					}
				}
				r.EncodeMapStart(yynn146)
				yynn146 = 0
			}
			if yyr146 || yy2arr146 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym148 := z.EncBinary()
				_ = yym148
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym149 := z.EncBinary()
				_ = yym149
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr146 || yy2arr146 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ImageReviewContainerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym150 := z.DecBinary()
	_ = yym150
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct151 := r.ContainerType()
		if yyct151 == codecSelferValueTypeMap1234 {
			yyl151 := r.ReadMapStart()
			if yyl151 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl151, d)
			}
		} else if yyct151 == codecSelferValueTypeArray1234 {
			yyl151 := r.ReadArrayStart()
			if yyl151 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl151, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ImageReviewContainerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys152Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys152Slc
	var yyhl152 bool = l >= 0
	for yyj152 := 0; ; yyj152++ {
		if yyhl152 {
			if yyj152 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys152Slc = r.DecodeBytes(yys152Slc, true, true)
		yys152 := string(yys152Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys152 {
		case "Image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys152)
		} // end switch yys152
	} // end for yyj152
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ImageReviewContainerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj154 int
	var yyb154 bool
	var yyhl154 bool = l >= 0
	yyj154++
	if yyhl154 {
		yyb154 = yyj154 > l
	} else {
		yyb154 = r.CheckBreak()
	}
	if yyb154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	for {
		yyj154++
		if yyhl154 {
			yyb154 = yyj154 > l
		} else {
			yyb154 = r.CheckBreak()
		}
		if yyb154 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj154-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ImageReviewStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym156 := z.EncBinary()
		_ = yym156
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep157 := !z.EncBinary()
			yy2arr157 := z.EncBasicHandle().StructToArray
			var yyq157 [2]bool
			_, _, _ = yysep157, yyq157, yy2arr157
			const yyr157 bool = false
			var yynn157 int
			if yyr157 || yy2arr157 {
				r.EncodeArrayStart(2)
			} else {
				yynn157 = 2
				for _, b := range yyq157 {
					if b {
						yynn157++
					}
				}
				r.EncodeMapStart(yynn157)
				yynn157 = 0
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Allowed"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym160 := z.EncBinary()
				_ = yym160
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Reason"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym163 := z.EncBinary()
				_ = yym163
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ImageReviewStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym164 := z.DecBinary()
	_ = yym164
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct165 := r.ContainerType()
		if yyct165 == codecSelferValueTypeMap1234 {
			yyl165 := r.ReadMapStart()
			if yyl165 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl165, d)
			}
		} else if yyct165 == codecSelferValueTypeArray1234 {
			yyl165 := r.ReadArrayStart()
			if yyl165 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl165, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ImageReviewStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys166Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys166Slc
	var yyhl166 bool = l >= 0
	for yyj166 := 0; ; yyj166++ {
		if yyhl166 {
			if yyj166 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys166Slc = r.DecodeBytes(yys166Slc, true, true)
		yys166 := string(yys166Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys166 {
		case "Allowed":
			if r.TryDecodeAsNil() {
				x.Allowed = false
			} else {
				x.Allowed = bool(r.DecodeBool())
			}
		case "Reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys166)
		} // end switch yys166
	} // end for yyj166
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ImageReviewStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj169 int
	var yyb169 bool
	var yyhl169 bool = l >= 0
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allowed = false
	} else {
		x.Allowed = bool(r.DecodeBool())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj169++
		if yyhl169 {
			yyb169 = yyj169 > l
		} else {
			yyb169 = r.CheckBreak()
		}
		if yyb169 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj169-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceapi_OwnerReference(v []pkg2_api.OwnerReference, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv172 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy173 := &yyv172
		yy173.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceapi_OwnerReference(v *[]pkg2_api.OwnerReference, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv174 := *v
	yyh174, yyl174 := z.DecSliceHelperStart()
	var yyc174 bool
	if yyl174 == 0 {
		if yyv174 == nil {
			yyv174 = []pkg2_api.OwnerReference{}
			yyc174 = true
		} else if len(yyv174) != 0 {
			yyv174 = yyv174[:0]
			yyc174 = true
		}
	} else if yyl174 > 0 {
		var yyrr174, yyrl174 int
		var yyrt174 bool
		if yyl174 > cap(yyv174) {

			yyrg174 := len(yyv174) > 0
			yyv2174 := yyv174
			yyrl174, yyrt174 = z.DecInferLen(yyl174, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt174 {
				if yyrl174 <= cap(yyv174) {
					yyv174 = yyv174[:yyrl174]
				} else {
					yyv174 = make([]pkg2_api.OwnerReference, yyrl174)
				}
			} else {
				yyv174 = make([]pkg2_api.OwnerReference, yyrl174)
			}
			yyc174 = true
			yyrr174 = len(yyv174)
			if yyrg174 {
				copy(yyv174, yyv2174)
			}
		} else if yyl174 != len(yyv174) {
			yyv174 = yyv174[:yyl174]
			yyc174 = true
		}
		yyj174 := 0
		for ; yyj174 < yyrr174; yyj174++ {
			yyh174.ElemContainerState(yyj174)
			if r.TryDecodeAsNil() {
				yyv174[yyj174] = pkg2_api.OwnerReference{}
			} else {
				yyv175 := &yyv174[yyj174]
				yyv175.CodecDecodeSelf(d)
			}

		}
		if yyrt174 {
			for ; yyj174 < yyl174; yyj174++ {
				yyv174 = append(yyv174, pkg2_api.OwnerReference{})
				yyh174.ElemContainerState(yyj174)
				if r.TryDecodeAsNil() {
					yyv174[yyj174] = pkg2_api.OwnerReference{}
				} else {
					yyv176 := &yyv174[yyj174]
					yyv176.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj174 := 0
		for ; !r.CheckBreak(); yyj174++ {

			if yyj174 >= len(yyv174) {
				yyv174 = append(yyv174, pkg2_api.OwnerReference{}) // var yyz174 pkg2_api.OwnerReference
				yyc174 = true
			}
			yyh174.ElemContainerState(yyj174)
			if yyj174 < len(yyv174) {
				if r.TryDecodeAsNil() {
					yyv174[yyj174] = pkg2_api.OwnerReference{}
				} else {
					yyv177 := &yyv174[yyj174]
					yyv177.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj174 < len(yyv174) {
			yyv174 = yyv174[:yyj174]
			yyc174 = true
		} else if yyj174 == 0 && yyv174 == nil {
			yyv174 = []pkg2_api.OwnerReference{}
			yyc174 = true
		}
	}
	yyh174.End()
	if yyc174 {
		*v = yyv174
	}
}

func (x codecSelfer1234) encSliceImageReviewContainerSpec(v []ImageReviewContainerSpec, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv178 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy179 := &yyv178
		yy179.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceImageReviewContainerSpec(v *[]ImageReviewContainerSpec, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv180 := *v
	yyh180, yyl180 := z.DecSliceHelperStart()
	var yyc180 bool
	if yyl180 == 0 {
		if yyv180 == nil {
			yyv180 = []ImageReviewContainerSpec{}
			yyc180 = true
		} else if len(yyv180) != 0 {
			yyv180 = yyv180[:0]
			yyc180 = true
		}
	} else if yyl180 > 0 {
		var yyrr180, yyrl180 int
		var yyrt180 bool
		if yyl180 > cap(yyv180) {

			yyrg180 := len(yyv180) > 0
			yyv2180 := yyv180
			yyrl180, yyrt180 = z.DecInferLen(yyl180, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt180 {
				if yyrl180 <= cap(yyv180) {
					yyv180 = yyv180[:yyrl180]
				} else {
					yyv180 = make([]ImageReviewContainerSpec, yyrl180)
				}
			} else {
				yyv180 = make([]ImageReviewContainerSpec, yyrl180)
			}
			yyc180 = true
			yyrr180 = len(yyv180)
			if yyrg180 {
				copy(yyv180, yyv2180)
			}
		} else if yyl180 != len(yyv180) {
			yyv180 = yyv180[:yyl180]
			yyc180 = true
		}
		yyj180 := 0
		for ; yyj180 < yyrr180; yyj180++ {
			yyh180.ElemContainerState(yyj180)
			if r.TryDecodeAsNil() {
				yyv180[yyj180] = ImageReviewContainerSpec{}
			} else {
				yyv181 := &yyv180[yyj180]
				yyv181.CodecDecodeSelf(d)
			}

		}
		if yyrt180 {
			for ; yyj180 < yyl180; yyj180++ {
				yyv180 = append(yyv180, ImageReviewContainerSpec{})
				yyh180.ElemContainerState(yyj180)
				if r.TryDecodeAsNil() {
					yyv180[yyj180] = ImageReviewContainerSpec{}
				} else {
					yyv182 := &yyv180[yyj180]
					yyv182.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj180 := 0
		for ; !r.CheckBreak(); yyj180++ {

			if yyj180 >= len(yyv180) {
				yyv180 = append(yyv180, ImageReviewContainerSpec{}) // var yyz180 ImageReviewContainerSpec
				yyc180 = true
			}
			yyh180.ElemContainerState(yyj180)
			if yyj180 < len(yyv180) {
				if r.TryDecodeAsNil() {
					yyv180[yyj180] = ImageReviewContainerSpec{}
				} else {
					yyv183 := &yyv180[yyj180]
					yyv183.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj180 < len(yyv180) {
			yyv180 = yyv180[:yyj180]
			yyc180 = true
		} else if yyj180 == 0 && yyv180 == nil {
			yyv180 = []ImageReviewContainerSpec{}
			yyc180 = true
		}
	}
	yyh180.End()
	if yyc180 {
		*v = yyv180
	}
}
