/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo.
// source: api.proto
// DO NOT EDIT!

/*
Package runtime is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	VersionRequest
	VersionResponse
	DNSOption
	PortMapping
	Mount
	NamespaceOption
	LinuxPodSandboxConfig
	PodSandboxMetadata
	PodSandboxConfig
	CreatePodSandboxRequest
	CreatePodSandboxResponse
	StopPodSandboxRequest
	StopPodSandboxResponse
	RemovePodSandboxRequest
	RemovePodSandboxResponse
	PodSandboxStatusRequest
	PodSandboxNetworkStatus
	Namespace
	LinuxPodSandboxStatus
	PodSandboxStatus
	PodSandboxStatusResponse
	PodSandboxFilter
	ListPodSandboxRequest
	PodSandbox
	ListPodSandboxResponse
	ImageSpec
	KeyValue
	LinuxContainerResources
	SELinuxOption
	Capability
	LinuxContainerConfig
	LinuxUser
	ContainerMetadata
	ContainerConfig
	CreateContainerRequest
	CreateContainerResponse
	StartContainerRequest
	StartContainerResponse
	StopContainerRequest
	StopContainerResponse
	RemoveContainerRequest
	RemoveContainerResponse
	ContainerFilter
	ListContainersRequest
	Container
	ListContainersResponse
	ContainerStatusRequest
	ContainerStatus
	ContainerStatusResponse
	ExecRequest
	ExecResponse
	ImageFilter
	ListImagesRequest
	Image
	ListImagesResponse
	ImageStatusRequest
	ImageStatusResponse
	AuthConfig
	PullImageRequest
	PullImageResponse
	RemoveImageRequest
	RemoveImageResponse
*/
package runtime

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

type Protocol int32

const (
	Protocol_TCP Protocol = 0
	Protocol_UDP Protocol = 1
)

var Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x Protocol) Enum() *Protocol {
	p := new(Protocol)
	*p = x
	return p
}
func (x Protocol) String() string {
	return proto.EnumName(Protocol_name, int32(x))
}
func (x *Protocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Protocol_value, data, "Protocol")
	if err != nil {
		return err
	}
	*x = Protocol(value)
	return nil
}
func (Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

type PodSandBoxState int32

const (
	PodSandBoxState_READY    PodSandBoxState = 0
	PodSandBoxState_NOTREADY PodSandBoxState = 1
)

var PodSandBoxState_name = map[int32]string{
	0: "READY",
	1: "NOTREADY",
}
var PodSandBoxState_value = map[string]int32{
	"READY":    0,
	"NOTREADY": 1,
}

func (x PodSandBoxState) Enum() *PodSandBoxState {
	p := new(PodSandBoxState)
	*p = x
	return p
}
func (x PodSandBoxState) String() string {
	return proto.EnumName(PodSandBoxState_name, int32(x))
}
func (x *PodSandBoxState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PodSandBoxState_value, data, "PodSandBoxState")
	if err != nil {
		return err
	}
	*x = PodSandBoxState(value)
	return nil
}
func (PodSandBoxState) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

type ContainerState int32

const (
	ContainerState_CREATED ContainerState = 0
	ContainerState_RUNNING ContainerState = 1
	ContainerState_EXITED  ContainerState = 2
	ContainerState_UNKNOWN ContainerState = 3
)

var ContainerState_name = map[int32]string{
	0: "CREATED",
	1: "RUNNING",
	2: "EXITED",
	3: "UNKNOWN",
}
var ContainerState_value = map[string]int32{
	"CREATED": 0,
	"RUNNING": 1,
	"EXITED":  2,
	"UNKNOWN": 3,
}

func (x ContainerState) Enum() *ContainerState {
	p := new(ContainerState)
	*p = x
	return p
}
func (x ContainerState) String() string {
	return proto.EnumName(ContainerState_name, int32(x))
}
func (x *ContainerState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerState_value, data, "ContainerState")
	if err != nil {
		return err
	}
	*x = ContainerState(value)
	return nil
}
func (ContainerState) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

type VersionRequest struct {
	// The version of kubelet runtime API.
	Version          *string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *VersionRequest) Reset()                    { *m = VersionRequest{} }
func (m *VersionRequest) String() string            { return proto.CompactTextString(m) }
func (*VersionRequest) ProtoMessage()               {}
func (*VersionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

func (m *VersionRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

type VersionResponse struct {
	// The version of the kubelet runtime API.
	Version *string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The name of the container runtime.
	RuntimeName *string `protobuf:"bytes,2,opt,name=runtime_name,json=runtimeName" json:"runtime_name,omitempty"`
	// The version of the container runtime.
	RuntimeVersion *string `protobuf:"bytes,3,opt,name=runtime_version,json=runtimeVersion" json:"runtime_version,omitempty"`
	// The API version of the container runtime.
	RuntimeApiVersion *string `protobuf:"bytes,4,opt,name=runtime_api_version,json=runtimeApiVersion" json:"runtime_api_version,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *VersionResponse) Reset()                    { *m = VersionResponse{} }
func (m *VersionResponse) String() string            { return proto.CompactTextString(m) }
func (*VersionResponse) ProtoMessage()               {}
func (*VersionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

func (m *VersionResponse) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *VersionResponse) GetRuntimeName() string {
	if m != nil && m.RuntimeName != nil {
		return *m.RuntimeName
	}
	return ""
}

func (m *VersionResponse) GetRuntimeVersion() string {
	if m != nil && m.RuntimeVersion != nil {
		return *m.RuntimeVersion
	}
	return ""
}

func (m *VersionResponse) GetRuntimeApiVersion() string {
	if m != nil && m.RuntimeApiVersion != nil {
		return *m.RuntimeApiVersion
	}
	return ""
}

// DNSOption specifies the DNS servers and search domains.
type DNSOption struct {
	// List of DNS servers of the cluster.
	Servers []string `protobuf:"bytes,1,rep,name=servers" json:"servers,omitempty"`
	// List of DNS search domains of the cluster.
	Searches         []string `protobuf:"bytes,2,rep,name=searches" json:"searches,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *DNSOption) Reset()                    { *m = DNSOption{} }
func (m *DNSOption) String() string            { return proto.CompactTextString(m) }
func (*DNSOption) ProtoMessage()               {}
func (*DNSOption) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

func (m *DNSOption) GetServers() []string {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *DNSOption) GetSearches() []string {
	if m != nil {
		return m.Searches
	}
	return nil
}

// PortMapping specifies the port mapping configurations of sandbox
type PortMapping struct {
	// The name of the port mapping
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The protocol of the port mapping.
	Protocol *Protocol `protobuf:"varint,2,opt,name=protocol,enum=runtime.Protocol" json:"protocol,omitempty"`
	// The port number within the container.
	ContainerPort *int32 `protobuf:"varint,3,opt,name=container_port,json=containerPort" json:"container_port,omitempty"`
	// The port number on the host.
	HostPort *int32 `protobuf:"varint,4,opt,name=host_port,json=hostPort" json:"host_port,omitempty"`
	// The host IP.
	HostIp           *string `protobuf:"bytes,5,opt,name=host_ip,json=hostIp" json:"host_ip,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PortMapping) Reset()                    { *m = PortMapping{} }
func (m *PortMapping) String() string            { return proto.CompactTextString(m) }
func (*PortMapping) ProtoMessage()               {}
func (*PortMapping) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

func (m *PortMapping) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PortMapping) GetProtocol() Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Protocol_TCP
}

func (m *PortMapping) GetContainerPort() int32 {
	if m != nil && m.ContainerPort != nil {
		return *m.ContainerPort
	}
	return 0
}

func (m *PortMapping) GetHostPort() int32 {
	if m != nil && m.HostPort != nil {
		return *m.HostPort
	}
	return 0
}

func (m *PortMapping) GetHostIp() string {
	if m != nil && m.HostIp != nil {
		return *m.HostIp
	}
	return ""
}

// Mount specifies the volume mount for the sandbox
type Mount struct {
	// The name of the volume mount.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The path of the mount within the container.
	ContainerPath *string `protobuf:"bytes,2,opt,name=container_path,json=containerPath" json:"container_path,omitempty"`
	// The path of the mount on the host.
	HostPath *string `protobuf:"bytes,3,opt,name=host_path,json=hostPath" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	Readonly *bool `protobuf:"varint,4,opt,name=readonly" json:"readonly,omitempty"`
	// If set, the mount needs SELinux relabeling
	SelinuxRelabel   *bool  `protobuf:"varint,5,opt,name=selinux_relabel,json=selinuxRelabel" json:"selinux_relabel,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Mount) Reset()                    { *m = Mount{} }
func (m *Mount) String() string            { return proto.CompactTextString(m) }
func (*Mount) ProtoMessage()               {}
func (*Mount) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

func (m *Mount) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Mount) GetContainerPath() string {
	if m != nil && m.ContainerPath != nil {
		return *m.ContainerPath
	}
	return ""
}

func (m *Mount) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Mount) GetReadonly() bool {
	if m != nil && m.Readonly != nil {
		return *m.Readonly
	}
	return false
}

func (m *Mount) GetSelinuxRelabel() bool {
	if m != nil && m.SelinuxRelabel != nil {
		return *m.SelinuxRelabel
	}
	return false
}

// NamespaceOption provides options for Linux namespaces.
type NamespaceOption struct {
	// If set, use the host's network namespace.
	HostNetwork *bool `protobuf:"varint,1,opt,name=host_network,json=hostNetwork" json:"host_network,omitempty"`
	// If set, use the host's pid namesapce.
	HostPid *bool `protobuf:"varint,2,opt,name=host_pid,json=hostPid" json:"host_pid,omitempty"`
	// If set, use the host's ipc namespace.
	HostIpc          *bool  `protobuf:"varint,3,opt,name=host_ipc,json=hostIpc" json:"host_ipc,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *NamespaceOption) Reset()                    { *m = NamespaceOption{} }
func (m *NamespaceOption) String() string            { return proto.CompactTextString(m) }
func (*NamespaceOption) ProtoMessage()               {}
func (*NamespaceOption) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

func (m *NamespaceOption) GetHostNetwork() bool {
	if m != nil && m.HostNetwork != nil {
		return *m.HostNetwork
	}
	return false
}

func (m *NamespaceOption) GetHostPid() bool {
	if m != nil && m.HostPid != nil {
		return *m.HostPid
	}
	return false
}

func (m *NamespaceOption) GetHostIpc() bool {
	if m != nil && m.HostIpc != nil {
		return *m.HostIpc
	}
	return false
}

// LinuxPodSandboxConfig holds platform-specific configuraions for Linux
// host platforms and Linux-based containers.
type LinuxPodSandboxConfig struct {
	// The parent cgroup of the pod sandbox.
	// The cgroupfs style syntax will be used, but the container runtime can
	// convert it to systemd semantices if needed.
	CgroupParent *string `protobuf:"bytes,1,opt,name=cgroup_parent,json=cgroupParent" json:"cgroup_parent,omitempty"`
	// The configurations for the sandbox's namespaces.
	// This will be used only if the PodSandbox uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,2,opt,name=namespace_options,json=namespaceOptions" json:"namespace_options,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *LinuxPodSandboxConfig) Reset()                    { *m = LinuxPodSandboxConfig{} }
func (m *LinuxPodSandboxConfig) String() string            { return proto.CompactTextString(m) }
func (*LinuxPodSandboxConfig) ProtoMessage()               {}
func (*LinuxPodSandboxConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

func (m *LinuxPodSandboxConfig) GetCgroupParent() string {
	if m != nil && m.CgroupParent != nil {
		return *m.CgroupParent
	}
	return ""
}

func (m *LinuxPodSandboxConfig) GetNamespaceOptions() *NamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

// PodSandboxMetadata holds all necessary information for building the sandbox name.
// The container runtime is encouraged to expose the metadata associated with the
// PodSandbox in its user interface for better user experience. E.g., runtime can
// construct a unique PodSandboxName based on the metadata.
type PodSandboxMetadata struct {
	// The pod name of the sandbox. Same as the pod name in the PodSpec.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The pod uid of the sandbox. Same as the pod UID in the PodSpec.
	Uid *string `protobuf:"bytes,2,opt,name=uid" json:"uid,omitempty"`
	// The pod namespace of the sandbox. Same as the pod namespace in the PodSpec.
	Namespace *string `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	// The attempt number of creating the sandbox.
	Attempt          *uint32 `protobuf:"varint,4,opt,name=attempt" json:"attempt,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxMetadata) Reset()                    { *m = PodSandboxMetadata{} }
func (m *PodSandboxMetadata) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxMetadata) ProtoMessage()               {}
func (*PodSandboxMetadata) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{7} }

func (m *PodSandboxMetadata) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PodSandboxMetadata) GetUid() string {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return ""
}

func (m *PodSandboxMetadata) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *PodSandboxMetadata) GetAttempt() uint32 {
	if m != nil && m.Attempt != nil {
		return *m.Attempt
	}
	return 0
}

// PodSandboxConfig holds all the required and optional fields for creating a
// sandbox.
type PodSandboxConfig struct {
	// The metadata of the sandbox. This information will uniquely identify
	// the sandbox, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *PodSandboxMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The hostname of the sandbox.
	Hostname *string `protobuf:"bytes,2,opt,name=hostname" json:"hostname,omitempty"`
	// Path to the directory on the host in which container log files are
	// stored.
	// By default the log of a container going into the LogDirectory will be
	// hooked up to STDOUT and STDERR. However, the LogDirectory may contain
	// binary log files with structured logging data from the individual
	// containers. For example, the files might be newline separated JSON
	// structured logs, systemd-journald journal files, gRPC trace files, etc.
	// E.g.,
	//     PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//     ContainerConfig.LogPath = `containerName_Instance#.log`
	//
	// WARNING: Log management and how kubelet should interface with the
	// container logs are under active discussion in
	// https://issues.k8s.io/24677. There *may* be future change of direction
	// for logging as the discussion carries on.
	LogDirectory *string `protobuf:"bytes,3,opt,name=log_directory,json=logDirectory" json:"log_directory,omitempty"`
	// The DNS options for the sandbox.
	DnsOptions *DNSOption `protobuf:"bytes,4,opt,name=dns_options,json=dnsOptions" json:"dns_options,omitempty"`
	// The port mappings for the sandbox.
	PortMappings []*PortMapping `protobuf:"bytes,5,rep,name=port_mappings,json=portMappings" json:"port_mappings,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional configurations specific to Linux hosts.
	Linux            *LinuxPodSandboxConfig `protobuf:"bytes,8,opt,name=linux" json:"linux,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *PodSandboxConfig) Reset()                    { *m = PodSandboxConfig{} }
func (m *PodSandboxConfig) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxConfig) ProtoMessage()               {}
func (*PodSandboxConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{8} }

func (m *PodSandboxConfig) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxConfig) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *PodSandboxConfig) GetLogDirectory() string {
	if m != nil && m.LogDirectory != nil {
		return *m.LogDirectory
	}
	return ""
}

func (m *PodSandboxConfig) GetDnsOptions() *DNSOption {
	if m != nil {
		return m.DnsOptions
	}
	return nil
}

func (m *PodSandboxConfig) GetPortMappings() []*PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *PodSandboxConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodSandboxConfig) GetLinux() *LinuxPodSandboxConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

type CreatePodSandboxRequest struct {
	// The configuration for creating a PodSandBox.
	Config           *PodSandboxConfig `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *CreatePodSandboxRequest) Reset()                    { *m = CreatePodSandboxRequest{} }
func (m *CreatePodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePodSandboxRequest) ProtoMessage()               {}
func (*CreatePodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{9} }

func (m *CreatePodSandboxRequest) GetConfig() *PodSandboxConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

type CreatePodSandboxResponse struct {
	// The id of the PodSandBox
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CreatePodSandboxResponse) Reset()                    { *m = CreatePodSandboxResponse{} }
func (m *CreatePodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*CreatePodSandboxResponse) ProtoMessage()               {}
func (*CreatePodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{10} }

func (m *CreatePodSandboxResponse) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type StopPodSandboxRequest struct {
	// The id of the PodSandBox
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StopPodSandboxRequest) Reset()                    { *m = StopPodSandboxRequest{} }
func (m *StopPodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*StopPodSandboxRequest) ProtoMessage()               {}
func (*StopPodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{11} }

func (m *StopPodSandboxRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type StopPodSandboxResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopPodSandboxResponse) Reset()                    { *m = StopPodSandboxResponse{} }
func (m *StopPodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*StopPodSandboxResponse) ProtoMessage()               {}
func (*StopPodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{12} }

type RemovePodSandboxRequest struct {
	// The id of the PodSandBox
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RemovePodSandboxRequest) Reset()                    { *m = RemovePodSandboxRequest{} }
func (m *RemovePodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*RemovePodSandboxRequest) ProtoMessage()               {}
func (*RemovePodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{13} }

func (m *RemovePodSandboxRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type RemovePodSandboxResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemovePodSandboxResponse) Reset()                    { *m = RemovePodSandboxResponse{} }
func (m *RemovePodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*RemovePodSandboxResponse) ProtoMessage()               {}
func (*RemovePodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{14} }

type PodSandboxStatusRequest struct {
	// The id of the PodSandBox
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxStatusRequest) Reset()                    { *m = PodSandboxStatusRequest{} }
func (m *PodSandboxStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatusRequest) ProtoMessage()               {}
func (*PodSandboxStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{15} }

func (m *PodSandboxStatusRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

// PodSandboxNetworkStatus is the status of the network for a PodSandbox.
type PodSandboxNetworkStatus struct {
	// The IP address of the PodSandbox
	Ip               *string `protobuf:"bytes,1,opt,name=ip" json:"ip,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxNetworkStatus) Reset()                    { *m = PodSandboxNetworkStatus{} }
func (m *PodSandboxNetworkStatus) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxNetworkStatus) ProtoMessage()               {}
func (*PodSandboxNetworkStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{16} }

func (m *PodSandboxNetworkStatus) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

// Namespace contains paths to the namespaces.
type Namespace struct {
	// Network is the path to the network namespace.
	Network *string `protobuf:"bytes,1,opt,name=network" json:"network,omitempty"`
	// Options is the namespace options for linux namespaces
	Options          *NamespaceOption `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Namespace) Reset()                    { *m = Namespace{} }
func (m *Namespace) String() string            { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()               {}
func (*Namespace) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{17} }

func (m *Namespace) GetNetwork() string {
	if m != nil && m.Network != nil {
		return *m.Network
	}
	return ""
}

func (m *Namespace) GetOptions() *NamespaceOption {
	if m != nil {
		return m.Options
	}
	return nil
}

// LinuxSandBoxStatus contains status specific to Linux sandboxes.
type LinuxPodSandboxStatus struct {
	// Namespaces contains paths to the sandbox's namespaces.
	Namespaces       *Namespace `protobuf:"bytes,1,opt,name=namespaces" json:"namespaces,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *LinuxPodSandboxStatus) Reset()                    { *m = LinuxPodSandboxStatus{} }
func (m *LinuxPodSandboxStatus) String() string            { return proto.CompactTextString(m) }
func (*LinuxPodSandboxStatus) ProtoMessage()               {}
func (*LinuxPodSandboxStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{18} }

func (m *LinuxPodSandboxStatus) GetNamespaces() *Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

// PodSandboxStatus contains the status of the PodSandbox.
type PodSandboxStatus struct {
	// ID of the sandbox.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// State of the sandbox.
	State *PodSandBoxState `protobuf:"varint,3,opt,name=state,enum=runtime.PodSandBoxState" json:"state,omitempty"`
	// Creation timestamp of the sandbox
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Network contains network status if network is handled by the runtime.
	Network *PodSandboxNetworkStatus `protobuf:"bytes,5,opt,name=network" json:"network,omitempty"`
	// Linux specific status to a pod sandbox.
	Linux *LinuxPodSandboxStatus `protobuf:"bytes,6,opt,name=linux" json:"linux,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations      map[string]string `protobuf:"bytes,8,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxStatus) Reset()                    { *m = PodSandboxStatus{} }
func (m *PodSandboxStatus) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatus) ProtoMessage()               {}
func (*PodSandboxStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{19} }

func (m *PodSandboxStatus) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandboxStatus) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxStatus) GetState() PodSandBoxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandBoxState_READY
}

func (m *PodSandboxStatus) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *PodSandboxStatus) GetNetwork() *PodSandboxNetworkStatus {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *PodSandboxStatus) GetLinux() *LinuxPodSandboxStatus {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *PodSandboxStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type PodSandboxStatusResponse struct {
	// The status of the PodSandbox
	Status           *PodSandboxStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxStatusResponse) Reset()                    { *m = PodSandboxStatusResponse{} }
func (m *PodSandboxStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatusResponse) ProtoMessage()               {}
func (*PodSandboxStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{20} }

func (m *PodSandboxStatusResponse) GetStatus() *PodSandboxStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PodSandboxFilter is used to filter a list of PodSandboxes.
// All those fields are combined with 'AND'
type PodSandboxFilter struct {
	// Name of the sandbox.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// ID of the sandbox.
	Id *string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// State of the sandbox.
	State *PodSandBoxState `protobuf:"varint,3,opt,name=state,enum=runtime.PodSandBoxState" json:"state,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector    map[string]string `protobuf:"bytes,4,rep,name=label_selector,json=labelSelector" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxFilter) Reset()                    { *m = PodSandboxFilter{} }
func (m *PodSandboxFilter) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxFilter) ProtoMessage()               {}
func (*PodSandboxFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{21} }

func (m *PodSandboxFilter) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PodSandboxFilter) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandboxFilter) GetState() PodSandBoxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandBoxState_READY
}

func (m *PodSandboxFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListPodSandboxRequest struct {
	// PodSandboxFilter to filter a list of PodSandboxes.
	Filter           *PodSandboxFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ListPodSandboxRequest) Reset()                    { *m = ListPodSandboxRequest{} }
func (m *ListPodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPodSandboxRequest) ProtoMessage()               {}
func (*ListPodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{22} }

func (m *ListPodSandboxRequest) GetFilter() *PodSandboxFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// PodSandbox contains minimal information about a sandbox.
type PodSandbox struct {
	// The id of the PodSandbox
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the sandbox
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// The state of the PodSandbox
	State *PodSandBoxState `protobuf:"varint,3,opt,name=state,enum=runtime.PodSandBoxState" json:"state,omitempty"`
	// Creation timestamps of the sandbox
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// The labels of the PodSandbox
	Labels           map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandbox) Reset()                    { *m = PodSandbox{} }
func (m *PodSandbox) String() string            { return proto.CompactTextString(m) }
func (*PodSandbox) ProtoMessage()               {}
func (*PodSandbox) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{23} }

func (m *PodSandbox) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandbox) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandbox) GetState() PodSandBoxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandBoxState_READY
}

func (m *PodSandbox) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *PodSandbox) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type ListPodSandboxResponse struct {
	// List of PodSandbox
	Items            []*PodSandbox `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ListPodSandboxResponse) Reset()                    { *m = ListPodSandboxResponse{} }
func (m *ListPodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPodSandboxResponse) ProtoMessage()               {}
func (*ListPodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{24} }

func (m *ListPodSandboxResponse) GetItems() []*PodSandbox {
	if m != nil {
		return m.Items
	}
	return nil
}

// ImageSpec is an internal representation of an image.  Currently, it wraps the
// value of a Container's Image field (e.g. imageName, imageName:tag, or
// imageName:digest), but in the future it will include more detailed
// information about the different image types.
type ImageSpec struct {
	Image            *string `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImageSpec) Reset()                    { *m = ImageSpec{} }
func (m *ImageSpec) String() string            { return proto.CompactTextString(m) }
func (*ImageSpec) ProtoMessage()               {}
func (*ImageSpec) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{25} }

func (m *ImageSpec) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

type KeyValue struct {
	Key              *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{26} }

func (m *KeyValue) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *KeyValue) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// LinuxContainerResources specifies Linux specific configuration for
// resources.
// TODO: Consider using Resources from opencontainers/runtime-spec/specs-go
// directly.
type LinuxContainerResources struct {
	// CPU CFS (Completely Fair Scheduler) period
	CpuPeriod *int64 `protobuf:"varint,1,opt,name=cpu_period,json=cpuPeriod" json:"cpu_period,omitempty"`
	// CPU CFS (Completely Fair Scheduler) quota
	CpuQuota *int64 `protobuf:"varint,2,opt,name=cpu_quota,json=cpuQuota" json:"cpu_quota,omitempty"`
	// CPU shares (relative weight vs. other containers)
	CpuShares *int64 `protobuf:"varint,3,opt,name=cpu_shares,json=cpuShares" json:"cpu_shares,omitempty"`
	// Memory limit in bytes
	MemoryLimitInBytes *int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes" json:"memory_limit_in_bytes,omitempty"`
	// OOMScoreAdj adjusts the oom-killer score.
	OomScoreAdj      *int64 `protobuf:"varint,5,opt,name=oom_score_adj,json=oomScoreAdj" json:"oom_score_adj,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *LinuxContainerResources) Reset()                    { *m = LinuxContainerResources{} }
func (m *LinuxContainerResources) String() string            { return proto.CompactTextString(m) }
func (*LinuxContainerResources) ProtoMessage()               {}
func (*LinuxContainerResources) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{27} }

func (m *LinuxContainerResources) GetCpuPeriod() int64 {
	if m != nil && m.CpuPeriod != nil {
		return *m.CpuPeriod
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuQuota() int64 {
	if m != nil && m.CpuQuota != nil {
		return *m.CpuQuota
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuShares() int64 {
	if m != nil && m.CpuShares != nil {
		return *m.CpuShares
	}
	return 0
}

func (m *LinuxContainerResources) GetMemoryLimitInBytes() int64 {
	if m != nil && m.MemoryLimitInBytes != nil {
		return *m.MemoryLimitInBytes
	}
	return 0
}

func (m *LinuxContainerResources) GetOomScoreAdj() int64 {
	if m != nil && m.OomScoreAdj != nil {
		return *m.OomScoreAdj
	}
	return 0
}

// SELinuxOption are the labels to be applied to the container.
type SELinuxOption struct {
	User             *string `protobuf:"bytes,1,opt,name=user" json:"user,omitempty"`
	Role             *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
	Type             *string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	Level            *string `protobuf:"bytes,4,opt,name=level" json:"level,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SELinuxOption) Reset()                    { *m = SELinuxOption{} }
func (m *SELinuxOption) String() string            { return proto.CompactTextString(m) }
func (*SELinuxOption) ProtoMessage()               {}
func (*SELinuxOption) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{28} }

func (m *SELinuxOption) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *SELinuxOption) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *SELinuxOption) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *SELinuxOption) GetLevel() string {
	if m != nil && m.Level != nil {
		return *m.Level
	}
	return ""
}

// Capability contains the container capabilities to add or drop
type Capability struct {
	// List of capabilities to add.
	AddCapabilities []string `protobuf:"bytes,1,rep,name=add_capabilities,json=addCapabilities" json:"add_capabilities,omitempty"`
	// List of capabilities to drop.
	DropCapabilities []string `protobuf:"bytes,2,rep,name=drop_capabilities,json=dropCapabilities" json:"drop_capabilities,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Capability) Reset()                    { *m = Capability{} }
func (m *Capability) String() string            { return proto.CompactTextString(m) }
func (*Capability) ProtoMessage()               {}
func (*Capability) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{29} }

func (m *Capability) GetAddCapabilities() []string {
	if m != nil {
		return m.AddCapabilities
	}
	return nil
}

func (m *Capability) GetDropCapabilities() []string {
	if m != nil {
		return m.DropCapabilities
	}
	return nil
}

// LinuxContainerConfig contains platform-specific configuration for
// Linux-based containers.
type LinuxContainerConfig struct {
	// Resources specification for the container.
	Resources *LinuxContainerResources `protobuf:"bytes,1,opt,name=resources" json:"resources,omitempty"`
	// Capabilities to add or drop.
	Capabilities *Capability `protobuf:"bytes,2,opt,name=capabilities" json:"capabilities,omitempty"`
	// Optional SELinux context to be applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,3,opt,name=selinux_options,json=selinuxOptions" json:"selinux_options,omitempty"`
	// User contains the user for the container process.
	User             *LinuxUser `protobuf:"bytes,4,opt,name=user" json:"user,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *LinuxContainerConfig) Reset()                    { *m = LinuxContainerConfig{} }
func (m *LinuxContainerConfig) String() string            { return proto.CompactTextString(m) }
func (*LinuxContainerConfig) ProtoMessage()               {}
func (*LinuxContainerConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{30} }

func (m *LinuxContainerConfig) GetResources() *LinuxContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *LinuxContainerConfig) GetCapabilities() *Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *LinuxContainerConfig) GetSelinuxOptions() *SELinuxOption {
	if m != nil {
		return m.SelinuxOptions
	}
	return nil
}

func (m *LinuxContainerConfig) GetUser() *LinuxUser {
	if m != nil {
		return m.User
	}
	return nil
}

type LinuxUser struct {
	// uid specifies the user ID the container process has.
	Uid *int64 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	// gid specifies the group ID the container process has.
	Gid *int64 `protobuf:"varint,2,opt,name=gid" json:"gid,omitempty"`
	// additional_gids specifies additional GIDs the container process has.
	AdditionalGids   []int64 `protobuf:"varint,3,rep,name=additional_gids,json=additionalGids" json:"additional_gids,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LinuxUser) Reset()                    { *m = LinuxUser{} }
func (m *LinuxUser) String() string            { return proto.CompactTextString(m) }
func (*LinuxUser) ProtoMessage()               {}
func (*LinuxUser) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{31} }

func (m *LinuxUser) GetUid() int64 {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return 0
}

func (m *LinuxUser) GetGid() int64 {
	if m != nil && m.Gid != nil {
		return *m.Gid
	}
	return 0
}

func (m *LinuxUser) GetAdditionalGids() []int64 {
	if m != nil {
		return m.AdditionalGids
	}
	return nil
}

// ContainerMetadata holds all necessary information for building the container
// name. The container runtime is encouraged to expose the metadata in its user
// interface for better user experience. E.g., runtime can construct a unique
// container name based on the metadata. Note that (name, attempt) is unique
// within a sandbox for the entire lifetime of the sandbox.
type ContainerMetadata struct {
	// The name of the container. Same as the container name in the PodSpec.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The attempt number of creating the container.
	Attempt          *uint32 `protobuf:"varint,2,opt,name=attempt" json:"attempt,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerMetadata) Reset()                    { *m = ContainerMetadata{} }
func (m *ContainerMetadata) String() string            { return proto.CompactTextString(m) }
func (*ContainerMetadata) ProtoMessage()               {}
func (*ContainerMetadata) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{32} }

func (m *ContainerMetadata) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ContainerMetadata) GetAttempt() uint32 {
	if m != nil && m.Attempt != nil {
		return *m.Attempt
	}
	return 0
}

// ContainerConfig holds all the required and optional fields for creating a
// container.
type ContainerConfig struct {
	// The metadata of the container. This information will uniquely identify
	// the container, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *ContainerMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Image to use.
	Image *ImageSpec `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Command to execute (i.e., entrypoint for docker)
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Args for the Command (i.e., command for docker)
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Current working directory of the command.
	WorkingDir *string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir" json:"working_dir,omitempty"`
	// List of environment variable to set in the container
	Envs []*KeyValue `protobuf:"bytes,6,rep,name=envs" json:"envs,omitempty"`
	// Mounts specifies mounts for the container
	Mounts []*Mount `protobuf:"bytes,7,rep,name=mounts" json:"mounts,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	// Label keys are of the form:
	//     label-key ::= prefixed-name | name
	//     prefixed-name ::= prefix '/' name
	//     prefix ::= DNS_SUBDOMAIN
	//     name ::= DNS_LABEL
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// If set, run container in privileged mode.
	// Processes in privileged containers are essentially equivalent to root on the host.
	Privileged *bool `protobuf:"varint,10,opt,name=privileged" json:"privileged,omitempty"`
	// If set, the root filesystem of the container is read-only.
	ReadonlyRootfs *bool `protobuf:"varint,11,opt,name=readonly_rootfs,json=readonlyRootfs" json:"readonly_rootfs,omitempty"`
	// Path relative to PodSandboxConfig.LogDirectory for container to store
	// the log (STDOUT and STDERR) on the host.
	// E.g.,
	//     PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//     ContainerConfig.LogPath = `containerName_Instance#.log`
	//
	// WARNING: Log management and how kubelet should interface with the
	// container logs are under active discussion in
	// https://issues.k8s.io/24677. There *may* be future change of direction
	// for logging as the discussion carries on.
	LogPath *string `protobuf:"bytes,12,opt,name=log_path,json=logPath" json:"log_path,omitempty"`
	// Variables for interactive containers, these have very specialized
	// use-cases (e.g. debugging).
	// TODO: Determine if we need to continue supporting these fields that are
	// part of Kubernetes's Container Spec.
	Stdin     *bool `protobuf:"varint,13,opt,name=stdin" json:"stdin,omitempty"`
	StdinOnce *bool `protobuf:"varint,14,opt,name=stdin_once,json=stdinOnce" json:"stdin_once,omitempty"`
	Tty       *bool `protobuf:"varint,15,opt,name=tty" json:"tty,omitempty"`
	// Linux contains configuration specific to Linux containers.
	Linux            *LinuxContainerConfig `protobuf:"bytes,16,opt,name=linux" json:"linux,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *ContainerConfig) Reset()                    { *m = ContainerConfig{} }
func (m *ContainerConfig) String() string            { return proto.CompactTextString(m) }
func (*ContainerConfig) ProtoMessage()               {}
func (*ContainerConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{33} }

func (m *ContainerConfig) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerConfig) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerConfig) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ContainerConfig) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ContainerConfig) GetWorkingDir() string {
	if m != nil && m.WorkingDir != nil {
		return *m.WorkingDir
	}
	return ""
}

func (m *ContainerConfig) GetEnvs() []*KeyValue {
	if m != nil {
		return m.Envs
	}
	return nil
}

func (m *ContainerConfig) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *ContainerConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerConfig) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return false
}

func (m *ContainerConfig) GetReadonlyRootfs() bool {
	if m != nil && m.ReadonlyRootfs != nil {
		return *m.ReadonlyRootfs
	}
	return false
}

func (m *ContainerConfig) GetLogPath() string {
	if m != nil && m.LogPath != nil {
		return *m.LogPath
	}
	return ""
}

func (m *ContainerConfig) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

func (m *ContainerConfig) GetStdinOnce() bool {
	if m != nil && m.StdinOnce != nil {
		return *m.StdinOnce
	}
	return false
}

func (m *ContainerConfig) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *ContainerConfig) GetLinux() *LinuxContainerConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

type CreateContainerRequest struct {
	// The id of the PodSandbox
	PodSandboxId *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// The config of the container
	Config *ContainerConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// The config of the PodSandbox
	SandboxConfig    *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig" json:"sandbox_config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{34} }

func (m *CreateContainerRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *CreateContainerRequest) GetConfig() *ContainerConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CreateContainerRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type CreateContainerResponse struct {
	// The id of the created container
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{35} }

func (m *CreateContainerResponse) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type StartContainerRequest struct {
	// The id of the container
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StartContainerRequest) Reset()                    { *m = StartContainerRequest{} }
func (m *StartContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*StartContainerRequest) ProtoMessage()               {}
func (*StartContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{36} }

func (m *StartContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type StartContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StartContainerResponse) Reset()                    { *m = StartContainerResponse{} }
func (m *StartContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*StartContainerResponse) ProtoMessage()               {}
func (*StartContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{37} }

type StopContainerRequest struct {
	// The id of the container
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// Timeout in seconds to stop the container
	Timeout          *int64 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopContainerRequest) Reset()                    { *m = StopContainerRequest{} }
func (m *StopContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*StopContainerRequest) ProtoMessage()               {}
func (*StopContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{38} }

func (m *StopContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *StopContainerRequest) GetTimeout() int64 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type StopContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopContainerResponse) Reset()                    { *m = StopContainerResponse{} }
func (m *StopContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*StopContainerResponse) ProtoMessage()               {}
func (*StopContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{39} }

type RemoveContainerRequest struct {
	// The id of the container
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RemoveContainerRequest) Reset()                    { *m = RemoveContainerRequest{} }
func (m *RemoveContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*RemoveContainerRequest) ProtoMessage()               {}
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{40} }

func (m *RemoveContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type RemoveContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemoveContainerResponse) Reset()                    { *m = RemoveContainerResponse{} }
func (m *RemoveContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*RemoveContainerResponse) ProtoMessage()               {}
func (*RemoveContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{41} }

// ContainerFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerFilter struct {
	// Name of the container.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// ID of the container.
	Id *string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// State of the container.
	State *ContainerState `protobuf:"varint,3,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// The id of the pod sandbox
	PodSandboxId *string `protobuf:"bytes,4,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector    map[string]string `protobuf:"bytes,5,rep,name=label_selector,json=labelSelector" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ContainerFilter) Reset()                    { *m = ContainerFilter{} }
func (m *ContainerFilter) String() string            { return proto.CompactTextString(m) }
func (*ContainerFilter) ProtoMessage()               {}
func (*ContainerFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{42} }

func (m *ContainerFilter) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ContainerFilter) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *ContainerFilter) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CREATED
}

func (m *ContainerFilter) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *ContainerFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListContainersRequest struct {
	Filter           *ContainerFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ListContainersRequest) Reset()                    { *m = ListContainersRequest{} }
func (m *ListContainersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListContainersRequest) ProtoMessage()               {}
func (*ListContainersRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{43} }

func (m *ListContainersRequest) GetFilter() *ContainerFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Container provides the runtime information for a container, such as ID, hash,
// state of the container.
type Container struct {
	// The ID of the container, used by the container runtime to identify
	// a container.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// The spec of the image
	Image *ImageSpec `protobuf:"bytes,3,opt,name=image" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID.
	ImageRef *string `protobuf:"bytes,4,opt,name=image_ref,json=imageRef" json:"image_ref,omitempty"`
	// State is the state of the container.
	State *ContainerState `protobuf:"varint,5,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations      map[string]string `protobuf:"bytes,7,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{44} }

func (m *Container) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Container) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Container) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Container) GetImageRef() string {
	if m != nil && m.ImageRef != nil {
		return *m.ImageRef
	}
	return ""
}

func (m *Container) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CREATED
}

func (m *Container) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Container) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type ListContainersResponse struct {
	// List of containers
	Containers       []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ListContainersResponse) Reset()                    { *m = ListContainersResponse{} }
func (m *ListContainersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListContainersResponse) ProtoMessage()               {}
func (*ListContainersResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{45} }

func (m *ListContainersResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

type ContainerStatusRequest struct {
	// The id of the container
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerStatusRequest) Reset()                    { *m = ContainerStatusRequest{} }
func (m *ContainerStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatusRequest) ProtoMessage()               {}
func (*ContainerStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{46} }

func (m *ContainerStatusRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

// ContainerStatus represents the status of a container.
type ContainerStatus struct {
	// ID of the container.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// Status of the container.
	State *ContainerState `protobuf:"varint,3,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// Creation time of the container.
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Start time of the container.
	StartedAt *int64 `protobuf:"varint,5,opt,name=started_at,json=startedAt" json:"started_at,omitempty"`
	// Finish time of the container.
	FinishedAt *int64 `protobuf:"varint,6,opt,name=finished_at,json=finishedAt" json:"finished_at,omitempty"`
	// Exit code of the container.
	ExitCode *int32 `protobuf:"varint,7,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
	// The spec of the image
	Image *ImageSpec `protobuf:"bytes,8,opt,name=image" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID
	ImageRef *string `protobuf:"bytes,9,opt,name=image_ref,json=imageRef" json:"image_ref,omitempty"`
	// A string explains why container is in such a status.
	Reason *string `protobuf:"bytes,10,opt,name=reason" json:"reason,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map.
	Annotations map[string]string `protobuf:"bytes,12,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mounts specifies mounts for the container
	Mounts           []*Mount `protobuf:"bytes,13,rep,name=mounts" json:"mounts,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (m *ContainerStatus) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{47} }

func (m *ContainerStatus) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *ContainerStatus) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerStatus) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CREATED
}

func (m *ContainerStatus) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *ContainerStatus) GetStartedAt() int64 {
	if m != nil && m.StartedAt != nil {
		return *m.StartedAt
	}
	return 0
}

func (m *ContainerStatus) GetFinishedAt() int64 {
	if m != nil && m.FinishedAt != nil {
		return *m.FinishedAt
	}
	return 0
}

func (m *ContainerStatus) GetExitCode() int32 {
	if m != nil && m.ExitCode != nil {
		return *m.ExitCode
	}
	return 0
}

func (m *ContainerStatus) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerStatus) GetImageRef() string {
	if m != nil && m.ImageRef != nil {
		return *m.ImageRef
	}
	return ""
}

func (m *ContainerStatus) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *ContainerStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerStatus) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

type ContainerStatusResponse struct {
	// The status of the container
	Status           *ContainerStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ContainerStatusResponse) Reset()                    { *m = ContainerStatusResponse{} }
func (m *ContainerStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatusResponse) ProtoMessage()               {}
func (*ContainerStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{48} }

func (m *ContainerStatusResponse) GetStatus() *ContainerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type ExecRequest struct {
	// The id of the container
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// The cmd to execute
	Cmd []string `protobuf:"bytes,2,rep,name=cmd" json:"cmd,omitempty"`
	// Whether use tty
	Tty *bool `protobuf:"varint,3,opt,name=tty" json:"tty,omitempty"`
	// Streaming stdin
	Stdin            []byte `protobuf:"bytes,4,opt,name=stdin" json:"stdin,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ExecRequest) Reset()                    { *m = ExecRequest{} }
func (m *ExecRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecRequest) ProtoMessage()               {}
func (*ExecRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{49} }

func (m *ExecRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *ExecRequest) GetCmd() []string {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *ExecRequest) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *ExecRequest) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

type ExecResponse struct {
	// Streaming stdout
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout" json:"stdout,omitempty"`
	// Streaming stderr
	Stderr           []byte `protobuf:"bytes,2,opt,name=stderr" json:"stderr,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ExecResponse) Reset()                    { *m = ExecResponse{} }
func (m *ExecResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecResponse) ProtoMessage()               {}
func (*ExecResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{50} }

func (m *ExecResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *ExecResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

type ImageFilter struct {
	// The spec of the image
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImageFilter) Reset()                    { *m = ImageFilter{} }
func (m *ImageFilter) String() string            { return proto.CompactTextString(m) }
func (*ImageFilter) ProtoMessage()               {}
func (*ImageFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{51} }

func (m *ImageFilter) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type ListImagesRequest struct {
	// The filter to list images
	Filter           *ImageFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ListImagesRequest) Reset()                    { *m = ListImagesRequest{} }
func (m *ListImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListImagesRequest) ProtoMessage()               {}
func (*ListImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{52} }

func (m *ListImagesRequest) GetFilter() *ImageFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Basic information about a container image.
type Image struct {
	// ID of the image.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Other names by which this image is known.
	RepoTags []string `protobuf:"bytes,2,rep,name=repo_tags,json=repoTags" json:"repo_tags,omitempty"`
	// Digests by which this image is known.
	RepoDigests []string `protobuf:"bytes,3,rep,name=repo_digests,json=repoDigests" json:"repo_digests,omitempty"`
	// The size of the image in bytes.
	Size_            *uint64 `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{53} }

func (m *Image) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Image) GetRepoTags() []string {
	if m != nil {
		return m.RepoTags
	}
	return nil
}

func (m *Image) GetRepoDigests() []string {
	if m != nil {
		return m.RepoDigests
	}
	return nil
}

func (m *Image) GetSize_() uint64 {
	if m != nil && m.Size_ != nil {
		return *m.Size_
	}
	return 0
}

type ListImagesResponse struct {
	// List of images
	Images           []*Image `protobuf:"bytes,1,rep,name=images" json:"images,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ListImagesResponse) Reset()                    { *m = ListImagesResponse{} }
func (m *ListImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListImagesResponse) ProtoMessage()               {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{54} }

func (m *ListImagesResponse) GetImages() []*Image {
	if m != nil {
		return m.Images
	}
	return nil
}

type ImageStatusRequest struct {
	// The spec of the image
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImageStatusRequest) Reset()                    { *m = ImageStatusRequest{} }
func (m *ImageStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*ImageStatusRequest) ProtoMessage()               {}
func (*ImageStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{55} }

func (m *ImageStatusRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImageStatusResponse struct {
	// The status of the image
	Image            *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ImageStatusResponse) Reset()                    { *m = ImageStatusResponse{} }
func (m *ImageStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*ImageStatusResponse) ProtoMessage()               {}
func (*ImageStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{56} }

func (m *ImageStatusResponse) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// AuthConfig contains authorization information for connecting to a registry.
type AuthConfig struct {
	Username      *string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	Password      *string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	Auth          *string `protobuf:"bytes,3,opt,name=auth" json:"auth,omitempty"`
	ServerAddress *string `protobuf:"bytes,4,opt,name=server_address,json=serverAddress" json:"server_address,omitempty"`
	// IdentityToken is used to authenticate the user and get
	// an access token for the registry.
	IdentityToken *string `protobuf:"bytes,5,opt,name=identity_token,json=identityToken" json:"identity_token,omitempty"`
	// RegistryToken is a bearer token to be sent to a registry
	RegistryToken    *string `protobuf:"bytes,6,opt,name=registry_token,json=registryToken" json:"registry_token,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AuthConfig) Reset()                    { *m = AuthConfig{} }
func (m *AuthConfig) String() string            { return proto.CompactTextString(m) }
func (*AuthConfig) ProtoMessage()               {}
func (*AuthConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{57} }

func (m *AuthConfig) GetUsername() string {
	if m != nil && m.Username != nil {
		return *m.Username
	}
	return ""
}

func (m *AuthConfig) GetPassword() string {
	if m != nil && m.Password != nil {
		return *m.Password
	}
	return ""
}

func (m *AuthConfig) GetAuth() string {
	if m != nil && m.Auth != nil {
		return *m.Auth
	}
	return ""
}

func (m *AuthConfig) GetServerAddress() string {
	if m != nil && m.ServerAddress != nil {
		return *m.ServerAddress
	}
	return ""
}

func (m *AuthConfig) GetIdentityToken() string {
	if m != nil && m.IdentityToken != nil {
		return *m.IdentityToken
	}
	return ""
}

func (m *AuthConfig) GetRegistryToken() string {
	if m != nil && m.RegistryToken != nil {
		return *m.RegistryToken
	}
	return ""
}

type PullImageRequest struct {
	// The spec of the image
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	// The auth config for pulling image
	Auth *AuthConfig `protobuf:"bytes,2,opt,name=auth" json:"auth,omitempty"`
	// The config of the PodSandbox, which is used to pull image in PodSandbox context
	SandboxConfig    *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig" json:"sandbox_config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PullImageRequest) Reset()                    { *m = PullImageRequest{} }
func (m *PullImageRequest) String() string            { return proto.CompactTextString(m) }
func (*PullImageRequest) ProtoMessage()               {}
func (*PullImageRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{58} }

func (m *PullImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *PullImageRequest) GetAuth() *AuthConfig {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *PullImageRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type PullImageResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *PullImageResponse) Reset()                    { *m = PullImageResponse{} }
func (m *PullImageResponse) String() string            { return proto.CompactTextString(m) }
func (*PullImageResponse) ProtoMessage()               {}
func (*PullImageResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{59} }

type RemoveImageRequest struct {
	// The spec of the image
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *RemoveImageRequest) Reset()                    { *m = RemoveImageRequest{} }
func (m *RemoveImageRequest) String() string            { return proto.CompactTextString(m) }
func (*RemoveImageRequest) ProtoMessage()               {}
func (*RemoveImageRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{60} }

func (m *RemoveImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type RemoveImageResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemoveImageResponse) Reset()                    { *m = RemoveImageResponse{} }
func (m *RemoveImageResponse) String() string            { return proto.CompactTextString(m) }
func (*RemoveImageResponse) ProtoMessage()               {}
func (*RemoveImageResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{61} }

func init() {
	proto.RegisterType((*VersionRequest)(nil), "runtime.VersionRequest")
	proto.RegisterType((*VersionResponse)(nil), "runtime.VersionResponse")
	proto.RegisterType((*DNSOption)(nil), "runtime.DNSOption")
	proto.RegisterType((*PortMapping)(nil), "runtime.PortMapping")
	proto.RegisterType((*Mount)(nil), "runtime.Mount")
	proto.RegisterType((*NamespaceOption)(nil), "runtime.NamespaceOption")
	proto.RegisterType((*LinuxPodSandboxConfig)(nil), "runtime.LinuxPodSandboxConfig")
	proto.RegisterType((*PodSandboxMetadata)(nil), "runtime.PodSandboxMetadata")
	proto.RegisterType((*PodSandboxConfig)(nil), "runtime.PodSandboxConfig")
	proto.RegisterType((*CreatePodSandboxRequest)(nil), "runtime.CreatePodSandboxRequest")
	proto.RegisterType((*CreatePodSandboxResponse)(nil), "runtime.CreatePodSandboxResponse")
	proto.RegisterType((*StopPodSandboxRequest)(nil), "runtime.StopPodSandboxRequest")
	proto.RegisterType((*StopPodSandboxResponse)(nil), "runtime.StopPodSandboxResponse")
	proto.RegisterType((*RemovePodSandboxRequest)(nil), "runtime.RemovePodSandboxRequest")
	proto.RegisterType((*RemovePodSandboxResponse)(nil), "runtime.RemovePodSandboxResponse")
	proto.RegisterType((*PodSandboxStatusRequest)(nil), "runtime.PodSandboxStatusRequest")
	proto.RegisterType((*PodSandboxNetworkStatus)(nil), "runtime.PodSandboxNetworkStatus")
	proto.RegisterType((*Namespace)(nil), "runtime.Namespace")
	proto.RegisterType((*LinuxPodSandboxStatus)(nil), "runtime.LinuxPodSandboxStatus")
	proto.RegisterType((*PodSandboxStatus)(nil), "runtime.PodSandboxStatus")
	proto.RegisterType((*PodSandboxStatusResponse)(nil), "runtime.PodSandboxStatusResponse")
	proto.RegisterType((*PodSandboxFilter)(nil), "runtime.PodSandboxFilter")
	proto.RegisterType((*ListPodSandboxRequest)(nil), "runtime.ListPodSandboxRequest")
	proto.RegisterType((*PodSandbox)(nil), "runtime.PodSandbox")
	proto.RegisterType((*ListPodSandboxResponse)(nil), "runtime.ListPodSandboxResponse")
	proto.RegisterType((*ImageSpec)(nil), "runtime.ImageSpec")
	proto.RegisterType((*KeyValue)(nil), "runtime.KeyValue")
	proto.RegisterType((*LinuxContainerResources)(nil), "runtime.LinuxContainerResources")
	proto.RegisterType((*SELinuxOption)(nil), "runtime.SELinuxOption")
	proto.RegisterType((*Capability)(nil), "runtime.Capability")
	proto.RegisterType((*LinuxContainerConfig)(nil), "runtime.LinuxContainerConfig")
	proto.RegisterType((*LinuxUser)(nil), "runtime.LinuxUser")
	proto.RegisterType((*ContainerMetadata)(nil), "runtime.ContainerMetadata")
	proto.RegisterType((*ContainerConfig)(nil), "runtime.ContainerConfig")
	proto.RegisterType((*CreateContainerRequest)(nil), "runtime.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "runtime.CreateContainerResponse")
	proto.RegisterType((*StartContainerRequest)(nil), "runtime.StartContainerRequest")
	proto.RegisterType((*StartContainerResponse)(nil), "runtime.StartContainerResponse")
	proto.RegisterType((*StopContainerRequest)(nil), "runtime.StopContainerRequest")
	proto.RegisterType((*StopContainerResponse)(nil), "runtime.StopContainerResponse")
	proto.RegisterType((*RemoveContainerRequest)(nil), "runtime.RemoveContainerRequest")
	proto.RegisterType((*RemoveContainerResponse)(nil), "runtime.RemoveContainerResponse")
	proto.RegisterType((*ContainerFilter)(nil), "runtime.ContainerFilter")
	proto.RegisterType((*ListContainersRequest)(nil), "runtime.ListContainersRequest")
	proto.RegisterType((*Container)(nil), "runtime.Container")
	proto.RegisterType((*ListContainersResponse)(nil), "runtime.ListContainersResponse")
	proto.RegisterType((*ContainerStatusRequest)(nil), "runtime.ContainerStatusRequest")
	proto.RegisterType((*ContainerStatus)(nil), "runtime.ContainerStatus")
	proto.RegisterType((*ContainerStatusResponse)(nil), "runtime.ContainerStatusResponse")
	proto.RegisterType((*ExecRequest)(nil), "runtime.ExecRequest")
	proto.RegisterType((*ExecResponse)(nil), "runtime.ExecResponse")
	proto.RegisterType((*ImageFilter)(nil), "runtime.ImageFilter")
	proto.RegisterType((*ListImagesRequest)(nil), "runtime.ListImagesRequest")
	proto.RegisterType((*Image)(nil), "runtime.Image")
	proto.RegisterType((*ListImagesResponse)(nil), "runtime.ListImagesResponse")
	proto.RegisterType((*ImageStatusRequest)(nil), "runtime.ImageStatusRequest")
	proto.RegisterType((*ImageStatusResponse)(nil), "runtime.ImageStatusResponse")
	proto.RegisterType((*AuthConfig)(nil), "runtime.AuthConfig")
	proto.RegisterType((*PullImageRequest)(nil), "runtime.PullImageRequest")
	proto.RegisterType((*PullImageResponse)(nil), "runtime.PullImageResponse")
	proto.RegisterType((*RemoveImageRequest)(nil), "runtime.RemoveImageRequest")
	proto.RegisterType((*RemoveImageResponse)(nil), "runtime.RemoveImageResponse")
	proto.RegisterEnum("runtime.Protocol", Protocol_name, Protocol_value)
	proto.RegisterEnum("runtime.PodSandBoxState", PodSandBoxState_name, PodSandBoxState_value)
	proto.RegisterEnum("runtime.ContainerState", ContainerState_name, ContainerState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for RuntimeService service

type RuntimeServiceClient interface {
	// Version returns the runtime name, runtime version and runtime API version
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// CreatePodSandbox creates a pod-level sandbox.
	// The definition of PodSandbox is at https://github.com/kubernetes/kubernetes/pull/25899
	CreatePodSandbox(ctx context.Context, in *CreatePodSandboxRequest, opts ...grpc.CallOption) (*CreatePodSandboxResponse, error)
	// StopPodSandbox stops the running sandbox. If there are any running
	// containers in the sandbox, they should be forcibly terminated.
	StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers in the
	// sandbox, they should be forcibly removed.
	// It should return success if the sandbox has already been removed.
	RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox.
	PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of SandBox.
	ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container should be forcibly removed.
	// It should return success if the container has already been removed.
	RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container.
	ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error)
	// Exec executes the command in the container.
	Exec(ctx context.Context, opts ...grpc.CallOption) (RuntimeService_ExecClient, error)
}

type runtimeServiceClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeServiceClient(cc *grpc.ClientConn) RuntimeServiceClient {
	return &runtimeServiceClient{cc}
}

func (c *runtimeServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	out := new(VersionResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/Version", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) CreatePodSandbox(ctx context.Context, in *CreatePodSandboxRequest, opts ...grpc.CallOption) (*CreatePodSandboxResponse, error) {
	out := new(CreatePodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/CreatePodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error) {
	out := new(StopPodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StopPodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error) {
	out := new(RemovePodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/RemovePodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error) {
	out := new(PodSandboxStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/PodSandboxStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error) {
	out := new(ListPodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ListPodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error) {
	out := new(StartContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StartContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error) {
	out := new(StopContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StopContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error) {
	out := new(RemoveContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/RemoveContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error) {
	out := new(ListContainersResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ListContainers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error) {
	out := new(ContainerStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ContainerStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Exec(ctx context.Context, opts ...grpc.CallOption) (RuntimeService_ExecClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RuntimeService_serviceDesc.Streams[0], c.cc, "/runtime.RuntimeService/Exec", opts...)
	if err != nil {
		return nil, err
	}
	x := &runtimeServiceExecClient{stream}
	return x, nil
}

type RuntimeService_ExecClient interface {
	Send(*ExecRequest) error
	Recv() (*ExecResponse, error)
	grpc.ClientStream
}

type runtimeServiceExecClient struct {
	grpc.ClientStream
}

func (x *runtimeServiceExecClient) Send(m *ExecRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *runtimeServiceExecClient) Recv() (*ExecResponse, error) {
	m := new(ExecResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for RuntimeService service

type RuntimeServiceServer interface {
	// Version returns the runtime name, runtime version and runtime API version
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// CreatePodSandbox creates a pod-level sandbox.
	// The definition of PodSandbox is at https://github.com/kubernetes/kubernetes/pull/25899
	CreatePodSandbox(context.Context, *CreatePodSandboxRequest) (*CreatePodSandboxResponse, error)
	// StopPodSandbox stops the running sandbox. If there are any running
	// containers in the sandbox, they should be forcibly terminated.
	StopPodSandbox(context.Context, *StopPodSandboxRequest) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers in the
	// sandbox, they should be forcibly removed.
	// It should return success if the sandbox has already been removed.
	RemovePodSandbox(context.Context, *RemovePodSandboxRequest) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox.
	PodSandboxStatus(context.Context, *PodSandboxStatusRequest) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of SandBox.
	ListPodSandbox(context.Context, *ListPodSandboxRequest) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(context.Context, *StartContainerRequest) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	StopContainer(context.Context, *StopContainerRequest) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container should be forcibly removed.
	// It should return success if the container has already been removed.
	RemoveContainer(context.Context, *RemoveContainerRequest) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(context.Context, *ListContainersRequest) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container.
	ContainerStatus(context.Context, *ContainerStatusRequest) (*ContainerStatusResponse, error)
	// Exec executes the command in the container.
	Exec(RuntimeService_ExecServer) error
}

func RegisterRuntimeServiceServer(s *grpc.Server, srv RuntimeServiceServer) {
	s.RegisterService(&_RuntimeService_serviceDesc, srv)
}

func _RuntimeService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_CreatePodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).CreatePodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/CreatePodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).CreatePodSandbox(ctx, req.(*CreatePodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StopPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, req.(*StopPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemovePodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/RemovePodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, req.(*RemovePodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PodSandboxStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PodSandboxStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/PodSandboxStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, req.(*PodSandboxStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ListPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, req.(*ListPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StartContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StartContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StartContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StartContainer(ctx, req.(*StartContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StopContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopContainer(ctx, req.(*StopContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemoveContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/RemoveContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, req.(*RemoveContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListContainers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListContainers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ListContainers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListContainers(ctx, req.(*ListContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ContainerStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ContainerStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, req.(*ContainerStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Exec_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RuntimeServiceServer).Exec(&runtimeServiceExecServer{stream})
}

type RuntimeService_ExecServer interface {
	Send(*ExecResponse) error
	Recv() (*ExecRequest, error)
	grpc.ServerStream
}

type runtimeServiceExecServer struct {
	grpc.ServerStream
}

func (x *runtimeServiceExecServer) Send(m *ExecResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *runtimeServiceExecServer) Recv() (*ExecRequest, error) {
	m := new(ExecRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _RuntimeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.RuntimeService",
	HandlerType: (*RuntimeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Version",
			Handler:    _RuntimeService_Version_Handler,
		},
		{
			MethodName: "CreatePodSandbox",
			Handler:    _RuntimeService_CreatePodSandbox_Handler,
		},
		{
			MethodName: "StopPodSandbox",
			Handler:    _RuntimeService_StopPodSandbox_Handler,
		},
		{
			MethodName: "RemovePodSandbox",
			Handler:    _RuntimeService_RemovePodSandbox_Handler,
		},
		{
			MethodName: "PodSandboxStatus",
			Handler:    _RuntimeService_PodSandboxStatus_Handler,
		},
		{
			MethodName: "ListPodSandbox",
			Handler:    _RuntimeService_ListPodSandbox_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _RuntimeService_CreateContainer_Handler,
		},
		{
			MethodName: "StartContainer",
			Handler:    _RuntimeService_StartContainer_Handler,
		},
		{
			MethodName: "StopContainer",
			Handler:    _RuntimeService_StopContainer_Handler,
		},
		{
			MethodName: "RemoveContainer",
			Handler:    _RuntimeService_RemoveContainer_Handler,
		},
		{
			MethodName: "ListContainers",
			Handler:    _RuntimeService_ListContainers_Handler,
		},
		{
			MethodName: "ContainerStatus",
			Handler:    _RuntimeService_ContainerStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Exec",
			Handler:       _RuntimeService_Exec_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: fileDescriptorApi,
}

// Client API for ImageService service

type ImageServiceClient interface {
	// ListImages lists existing images.
	ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image.
	ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// It should return success if the image has already been removed.
	RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error)
}

type imageServiceClient struct {
	cc *grpc.ClientConn
}

func NewImageServiceClient(cc *grpc.ClientConn) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/ListImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error) {
	out := new(ImageStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/ImageStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error) {
	out := new(PullImageResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/PullImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error) {
	out := new(RemoveImageResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/RemoveImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ImageService service

type ImageServiceServer interface {
	// ListImages lists existing images.
	ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image.
	ImageStatus(context.Context, *ImageStatusRequest) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(context.Context, *PullImageRequest) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// It should return success if the image has already been removed.
	RemoveImage(context.Context, *RemoveImageRequest) (*RemoveImageResponse, error)
}

func RegisterImageServiceServer(s *grpc.Server, srv ImageServiceServer) {
	s.RegisterService(&_ImageService_serviceDesc, srv)
}

func _ImageService_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ListImages(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ImageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ImageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/ImageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ImageStatus(ctx, req.(*ImageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_PullImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).PullImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/PullImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).PullImage(ctx, req.(*PullImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_RemoveImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).RemoveImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/RemoveImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).RemoveImage(ctx, req.(*RemoveImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListImages",
			Handler:    _ImageService_ListImages_Handler,
		},
		{
			MethodName: "ImageStatus",
			Handler:    _ImageService_ImageStatus_Handler,
		},
		{
			MethodName: "PullImage",
			Handler:    _ImageService_PullImage_Handler,
		},
		{
			MethodName: "RemoveImage",
			Handler:    _ImageService_RemoveImage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptorApi,
}

var fileDescriptorApi = []byte{
	// 2829 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xcc, 0x5a, 0x4b, 0x73, 0x1b, 0xc7,
	0x11, 0x16, 0x08, 0x82, 0x04, 0x1a, 0x04, 0x08, 0x8e, 0x28, 0x12, 0x82, 0x5e, 0xd4, 0xda, 0x4e,
	0x24, 0xda, 0x66, 0x29, 0x4c, 0x4a, 0x8a, 0x64, 0x5b, 0x16, 0x4d, 0x32, 0x2a, 0x5a, 0x14, 0xc5,
	0x2c, 0x24, 0xc5, 0x3a, 0xa1, 0x56, 0xd8, 0x21, 0xb9, 0x12, 0xb0, 0xbb, 0xde, 0x5d, 0x30, 0x62,
	0xae, 0xf9, 0x05, 0xb9, 0xe5, 0x98, 0x83, 0xab, 0x72, 0xca, 0x25, 0x55, 0xb9, 0xe4, 0x9a, 0x5b,
	0x52, 0xf9, 0x3d, 0xc9, 0x25, 0x55, 0xe9, 0x79, 0xec, 0xec, 0xec, 0x03, 0x14, 0x21, 0x57, 0xd9,
	0xba, 0xed, 0x74, 0xf7, 0xcc, 0xf4, 0x74, 0xf7, 0xf4, 0xf4, 0x37, 0xb3, 0x50, 0xb3, 0x7c, 0x67,
	0xcd, 0x0f, 0xbc, 0xc8, 0x23, 0xb3, 0xc1, 0xc8, 0x8d, 0x9c, 0x21, 0x35, 0x56, 0xa1, 0xf9, 0x9c,
	0x06, 0xa1, 0xe3, 0xb9, 0x26, 0xfd, 0x76, 0x44, 0xc3, 0x88, 0xb4, 0x61, 0xf6, 0x58, 0x50, 0xda,
	0xa5, 0x95, 0xd2, 0x8d, 0x9a, 0x19, 0x37, 0x8d, 0x3f, 0x97, 0x60, 0x5e, 0x09, 0x87, 0xbe, 0xe7,
	0x86, 0x74, 0xbc, 0x34, 0xb9, 0x0e, 0x73, 0x72, 0x92, 0x9e, 0x6b, 0x0d, 0x69, 0x7b, 0x8a, 0xb3,
	0xeb, 0x92, 0xb6, 0x87, 0x24, 0xf2, 0x53, 0x98, 0x8f, 0x45, 0xe2, 0x41, 0xca, 0x5c, 0xaa, 0x29,
	0xc9, 0x72, 0x36, 0xb2, 0x06, 0xe7, 0x63, 0x41, 0x5c, 0x83, 0x12, 0x9e, 0xe6, 0xc2, 0x0b, 0x92,
	0xb5, 0xe1, 0x3b, 0x52, 0xde, 0xd8, 0x80, 0xda, 0xd6, 0x5e, 0xf7, 0x89, 0x1f, 0xb1, 0xce, 0xa8,
	0x62, 0x48, 0x03, 0xd6, 0x07, 0x55, 0x2c, 0x33, 0x15, 0x65, 0x93, 0x74, 0xa0, 0x1a, 0x52, 0x2b,
	0xe8, 0x1f, 0xd1, 0x10, 0xd5, 0x63, 0x2c, 0xd5, 0x36, 0xfe, 0x52, 0x82, 0xfa, 0xbe, 0x17, 0x44,
	0x8f, 0x2d, 0xdf, 0x77, 0xdc, 0x43, 0x42, 0x60, 0x9a, 0x2f, 0x43, 0xac, 0x92, 0x7f, 0x93, 0x4f,
	0xa1, 0xca, 0xcd, 0xd9, 0xf7, 0x06, 0x7c, 0x79, 0xcd, 0xf5, 0x85, 0x35, 0xa9, 0xcc, 0xda, 0xbe,
	0x64, 0x98, 0x4a, 0x84, 0x7c, 0x04, 0xcd, 0xbe, 0xe7, 0x46, 0x96, 0xe3, 0xd2, 0xa0, 0xe7, 0xe3,
	0xd8, 0x7c, 0xb5, 0x15, 0xb3, 0xa1, 0xa8, 0x6c, 0x42, 0x72, 0x09, 0x6a, 0x47, 0x5e, 0x18, 0x09,
	0x89, 0x69, 0x2e, 0x51, 0x65, 0x04, 0xce, 0x5c, 0x86, 0x59, 0xce, 0x74, 0xfc, 0x76, 0x85, 0x6b,
	0x32, 0xc3, 0x9a, 0x3b, 0xbe, 0xf1, 0x5d, 0x09, 0x2a, 0x8f, 0x3d, 0x9c, 0xbc, 0x50, 0xd3, 0xf4,
	0xd4, 0x56, 0x74, 0x24, 0xdd, 0xa1, 0x4d, 0x8d, 0xc4, 0x64, 0x6a, 0x26, 0x21, 0x5c, 0x21, 0xa6,
	0x66, 0x4c, 0xb4, 0x56, 0x40, 0x2d, 0xdb, 0x73, 0x07, 0x27, 0x5c, 0xad, 0xaa, 0xa9, 0xda, 0xcc,
	0x93, 0x21, 0x1d, 0x38, 0xee, 0xe8, 0x4d, 0x2f, 0xa0, 0x03, 0xeb, 0x25, 0x1d, 0x70, 0xf5, 0xaa,
	0x66, 0x53, 0x92, 0x4d, 0x41, 0x35, 0x5e, 0xc1, 0x3c, 0x73, 0x7d, 0xe8, 0x5b, 0x7d, 0x2a, 0xfd,
	0x83, 0x81, 0xc2, 0x27, 0x75, 0x69, 0xf4, 0x5b, 0x2f, 0x78, 0xcd, 0xf5, 0xae, 0x9a, 0x75, 0x46,
	0xdb, 0x13, 0x24, 0x72, 0x11, 0xaa, 0x42, 0x2f, 0xc7, 0xe6, 0x8a, 0x57, 0x4d, 0x6e, 0x85, 0x7d,
	0xc7, 0x56, 0x2c, 0xc7, 0xef, 0x73, 0x8d, 0x25, 0x6b, 0xc7, 0xef, 0x1b, 0xbf, 0x2f, 0xc1, 0x85,
	0x5d, 0x36, 0xf9, 0xbe, 0x67, 0x77, 0x2d, 0xd7, 0x7e, 0xe9, 0xbd, 0xd9, 0xf4, 0xdc, 0x03, 0xe7,
	0x90, 0x7c, 0x00, 0x8d, 0xfe, 0x61, 0xe0, 0x8d, 0x7c, 0x5c, 0x69, 0x40, 0xdd, 0x48, 0xda, 0x6a,
	0x4e, 0x10, 0xf7, 0x39, 0x8d, 0x6c, 0xc3, 0x82, 0x1b, 0xab, 0xda, 0xf3, 0xb8, 0xae, 0x21, 0x9f,
	0xbd, 0xbe, 0xde, 0x56, 0x6e, 0xce, 0x2c, 0xc6, 0x6c, 0xb9, 0x69, 0x42, 0x68, 0x04, 0x40, 0x92,
	0xf9, 0x1f, 0xd3, 0xc8, 0xb2, 0xad, 0xc8, 0x2a, 0x74, 0x52, 0x0b, 0xca, 0x23, 0xb9, 0xc0, 0x9a,
	0xc9, 0x3e, 0xc9, 0x65, 0xa8, 0xa9, 0xf1, 0xa4, 0x3f, 0x12, 0x02, 0x0b, 0x6c, 0x2b, 0x8a, 0xe8,
	0xd0, 0x17, 0x61, 0xd2, 0x30, 0xe3, 0xa6, 0xf1, 0xf7, 0x69, 0x68, 0xe5, 0x16, 0x7d, 0x07, 0xaa,
	0x43, 0x39, 0x3d, 0x9f, 0xb6, 0xbe, 0x7e, 0x29, 0x89, 0xd6, 0x9c, 0x86, 0xa6, 0x12, 0x66, 0x8e,
	0x67, 0x26, 0xd5, 0x76, 0xb1, 0x6a, 0x33, 0x4b, 0x0e, 0xbc, 0xc3, 0x9e, 0xed, 0x04, 0xb4, 0x1f,
	0x79, 0xc1, 0x89, 0xd4, 0x72, 0x0e, 0x89, 0x5b, 0x31, 0x8d, 0xfc, 0x1c, 0xea, 0xb6, 0x1b, 0x2a,
	0x1b, 0x4e, 0xf3, 0xc9, 0x89, 0x9a, 0x5c, 0x6d, 0x55, 0x13, 0x50, 0x4c, 0xda, 0x8d, 0xdc, 0x85,
	0x06, 0xdb, 0x01, 0xbd, 0xa1, 0xd8, 0x80, 0x21, 0x06, 0x54, 0x19, 0xbb, 0x2d, 0x6a, 0x3a, 0xab,
	0xdd, 0x69, 0xce, 0xf9, 0x49, 0x23, 0x24, 0x5f, 0xc0, 0x0c, 0x8f, 0xb6, 0xb0, 0x3d, 0xc3, 0xfb,
	0x7c, 0x54, 0xb0, 0x4e, 0x61, 0x94, 0xb5, 0x5d, 0x2e, 0xb7, 0xed, 0x46, 0xc1, 0x89, 0x29, 0x3b,
	0x91, 0x5d, 0xa8, 0x5b, 0xae, 0xeb, 0x45, 0x96, 0x50, 0x77, 0x96, 0x8f, 0xb1, 0x3a, 0x7e, 0x8c,
	0x8d, 0x44, 0x58, 0x0c, 0xa4, 0x77, 0x27, 0xbf, 0x80, 0x0a, 0xdf, 0x01, 0xed, 0x2a, 0x5f, 0xf6,
	0x55, 0x35, 0x4e, 0x61, 0x68, 0x9a, 0x42, 0xb8, 0x73, 0x17, 0xea, 0x9a, 0x6a, 0x2c, 0x34, 0x5e,
	0xd3, 0x13, 0x19, 0x2d, 0xec, 0x93, 0x2c, 0x42, 0xe5, 0xd8, 0x1a, 0x8c, 0x62, 0x8f, 0x88, 0xc6,
	0xbd, 0xa9, 0x5f, 0x96, 0x3a, 0xf7, 0xa1, 0x95, 0xd5, 0x68, 0x92, 0xfe, 0xc6, 0x2e, 0x2c, 0x6f,
	0xe2, 0xc6, 0x8e, 0x68, 0xa2, 0x5b, 0x7c, 0x36, 0xfc, 0x0c, 0x66, 0xfa, 0x5c, 0x4d, 0x19, 0x40,
	0x17, 0xc7, 0x1a, 0xc5, 0x94, 0x82, 0xc6, 0x03, 0x68, 0xe7, 0x47, 0x93, 0x87, 0xc7, 0x87, 0xd0,
	0xf4, 0x3d, 0xbb, 0x17, 0x0a, 0x72, 0x0f, 0x63, 0x5f, 0xee, 0x43, 0x5f, 0xc9, 0xee, 0xd8, 0xc6,
	0x17, 0x70, 0xa1, 0x1b, 0x79, 0x7e, 0x5e, 0x9b, 0xb3, 0x75, 0x6f, 0xc3, 0x52, 0xb6, 0xbb, 0x98,
	0xde, 0xf8, 0x12, 0x96, 0x4d, 0x3a, 0xf4, 0x8e, 0xe9, 0xbb, 0x0e, 0xdd, 0x81, 0x76, 0x7e, 0x80,
	0x64, 0xf0, 0x84, 0xda, 0x45, 0x67, 0x8c, 0xc2, 0xc9, 0x06, 0xbf, 0xa9, 0x0f, 0x20, 0x13, 0xa1,
	0x18, 0x87, 0x34, 0x61, 0x0a, 0xf3, 0xbf, 0xe8, 0x84, 0x5f, 0xc6, 0x0b, 0xa8, 0xed, 0xe9, 0x59,
	0x41, 0xcf, 0xa4, 0x78, 0xdc, 0xc9, 0x26, 0x59, 0x87, 0xd9, 0xb3, 0xa6, 0xb1, 0x58, 0xd0, 0x78,
	0x94, 0x4b, 0xa1, 0x52, 0x87, 0x75, 0x00, 0x95, 0x89, 0x42, 0x19, 0x0e, 0x24, 0x3f, 0x9e, 0xa9,
	0x49, 0x19, 0xdf, 0xa5, 0xd2, 0x92, 0xb6, 0x18, 0x5b, 0x2d, 0xc6, 0x4e, 0xa5, 0xa9, 0xa9, 0x49,
	0xd2, 0xd4, 0x1a, 0x54, 0x42, 0x1c, 0x52, 0x24, 0xca, 0xa6, 0xb6, 0x38, 0xd9, 0xeb, 0x2b, 0x31,
	0x25, 0x35, 0x85, 0x18, 0xb9, 0x02, 0xd0, 0xe7, 0x91, 0x69, 0xf7, 0x2c, 0x91, 0x41, 0xcb, 0x66,
	0x4d, 0x52, 0x36, 0x22, 0x72, 0x2f, 0xb1, 0x63, 0x85, 0xab, 0xb1, 0x52, 0xa0, 0x46, 0xca, 0x2f,
	0x89, 0xa5, 0xd5, 0x9e, 0x9f, 0x39, 0x7d, 0xcf, 0xcb, 0x7e, 0x42, 0x58, 0x4b, 0x5b, 0xb3, 0x63,
	0xd3, 0x96, 0xe8, 0x71, 0x96, 0xb4, 0x55, 0x1d, 0x9b, 0xb6, 0xe4, 0x18, 0xa7, 0xa6, 0xad, 0x1f,
	0x33, 0x01, 0x3d, 0x86, 0x76, 0x7e, 0xeb, 0xc8, 0x94, 0x81, 0x19, 0x28, 0xe4, 0x94, 0x53, 0x32,
	0x90, 0xec, 0x22, 0x05, 0x8d, 0xff, 0x95, 0xf4, 0xa8, 0xfb, 0x95, 0x33, 0x88, 0x68, 0x50, 0x78,
	0xfe, 0x8a, 0x48, 0x9c, 0x52, 0x91, 0x38, 0x69, 0x40, 0x75, 0xa1, 0xc9, 0x5d, 0xd1, 0xc3, 0x9a,
	0x87, 0x9f, 0x7c, 0x18, 0x54, 0xcc, 0x07, 0x9f, 0x14, 0xe8, 0x28, 0xd4, 0x10, 0x7e, 0xec, 0x4a,
	0x71, 0xe1, 0x85, 0xc6, 0x40, 0xa7, 0x75, 0x1e, 0x00, 0xc9, 0x0b, 0x4d, 0x64, 0xce, 0xaf, 0xd9,
	0x16, 0x66, 0xe5, 0x63, 0x41, 0x36, 0x3f, 0xe0, 0x6a, 0x9c, 0x62, 0x4b, 0xa1, 0xa7, 0x29, 0x05,
	0x8d, 0x3f, 0x4e, 0x01, 0x24, 0xcc, 0xf7, 0x76, 0xef, 0xde, 0x51, 0x3b, 0x49, 0x14, 0x0d, 0xd7,
	0x0a, 0xb4, 0x28, 0xda, 0x43, 0xdf, 0x23, 0xea, 0x8d, 0x4d, 0x58, 0xca, 0x9a, 0x59, 0xc6, 0xec,
	0x4d, 0xa8, 0x38, 0x58, 0x97, 0x09, 0xf8, 0x51, 0x5f, 0x3f, 0x5f, 0xa0, 0x8c, 0x29, 0x24, 0x8c,
	0xeb, 0x50, 0xdb, 0x19, 0x5a, 0x87, 0xb4, 0xeb, 0xd3, 0x3e, 0x9b, 0xcb, 0x61, 0x0d, 0x39, 0xbf,
	0x68, 0x18, 0xeb, 0x50, 0x7d, 0x44, 0x4f, 0x9e, 0xb3, 0x79, 0xcf, 0xaa, 0x9f, 0xf1, 0xaf, 0x12,
	0x2c, 0xf3, 0xd4, 0xb3, 0x19, 0x97, 0xfb, 0xa8, 0x9c, 0x37, 0x0a, 0x30, 0x29, 0x73, 0x53, 0xfa,
	0xa3, 0x9e, 0x4f, 0x03, 0xc7, 0x13, 0xbe, 0x64, 0xa6, 0xf4, 0x47, 0xfb, 0x9c, 0xc0, 0x20, 0x01,
	0x63, 0x7f, 0x3b, 0xf2, 0xa4, 0x4f, 0xcb, 0x66, 0x15, 0x09, 0xbf, 0x66, 0xed, 0xb8, 0x6f, 0x78,
	0x84, 0x15, 0x73, 0xc8, 0x7d, 0x27, 0xfa, 0x76, 0x39, 0x01, 0x03, 0xec, 0xc2, 0x10, 0xcf, 0xc7,
	0xe0, 0xa4, 0x37, 0x70, 0x86, 0x0e, 0xd6, 0xe8, 0x6e, 0xef, 0xe5, 0x49, 0x44, 0x43, 0xe9, 0x30,
	0x22, 0x98, 0xbb, 0x8c, 0xb7, 0xe3, 0x7e, 0xc5, 0x38, 0xc4, 0x80, 0x86, 0xe7, 0x0d, 0x7b, 0x61,
	0xdf, 0x0b, 0x10, 0xeb, 0xd9, 0xaf, 0x78, 0xee, 0x2d, 0x9b, 0x75, 0x24, 0x76, 0x19, 0x6d, 0xc3,
	0x7e, 0x65, 0x58, 0xd0, 0xe8, 0x6e, 0xf3, 0xe5, 0x48, 0x04, 0x81, 0x9b, 0x79, 0x14, 0xca, 0x30,
	0xc6, 0xcd, 0xcc, 0xbe, 0x19, 0x2d, 0xf0, 0x06, 0xb1, 0x1d, 0xf8, 0x37, 0xa3, 0x45, 0x27, 0x7e,
	0x5c, 0x49, 0xf3, 0x6f, 0x66, 0xb0, 0x01, 0x3d, 0x46, 0xbc, 0x22, 0xc0, 0xa4, 0x68, 0x18, 0x36,
	0xc0, 0xa6, 0xe5, 0x5b, 0x2f, 0x9d, 0x81, 0x13, 0x9d, 0xa0, 0x03, 0x5b, 0x96, 0x6d, 0xf7, 0xfa,
	0x31, 0xc5, 0xa1, 0x31, 0x94, 0x9c, 0x47, 0xfa, 0xa6, 0x46, 0x26, 0x1f, 0xc3, 0x82, 0x1d, 0x78,
	0x7e, 0x5a, 0x56, 0x60, 0xcb, 0x16, 0x63, 0xe8, 0xc2, 0xc6, 0x7f, 0x4b, 0xb0, 0x98, 0x76, 0x8b,
	0x2c, 0xd5, 0xef, 0x43, 0x2d, 0x88, 0x1d, 0x24, 0x37, 0xe7, 0x4a, 0xfa, 0x0c, 0xc9, 0x3b, 0xd2,
	0x4c, 0xba, 0x60, 0xfc, 0xcf, 0x65, 0x14, 0x28, 0xa5, 0x02, 0x2f, 0x59, 0x9b, 0x99, 0x12, 0x24,
	0x5f, 0x26, 0x38, 0x2e, 0x2e, 0x15, 0xca, 0xbc, 0xef, 0x92, 0xea, 0x9b, 0x32, 0xbd, 0xc2, 0x77,
	0x71, 0xd5, 0xfe, 0x13, 0xe9, 0x8a, 0x6c, 0x8d, 0xcf, 0xfb, 0x3c, 0x43, 0x8e, 0x70, 0x8f, 0xf1,
	0x0d, 0xd4, 0x14, 0x29, 0x06, 0x3e, 0x22, 0xf6, 0x38, 0xf0, 0x41, 0xca, 0xa1, 0xcc, 0xc5, 0x48,
	0xc1, 0x4f, 0x86, 0x30, 0xd1, 0xd6, 0x0e, 0x9b, 0xc5, 0x1a, 0xf4, 0x90, 0xc2, 0x34, 0x2b, 0x23,
	0xb7, 0x99, 0x90, 0x1f, 0x22, 0x15, 0xb1, 0xff, 0x82, 0x32, 0xce, 0xa9, 0x70, 0x4b, 0x83, 0x4f,
	0x53, 0x69, 0xf8, 0xf4, 0x9f, 0x0a, 0xcc, 0x67, 0x5d, 0x72, 0x3b, 0x87, 0x9e, 0x3a, 0x89, 0x39,
	0xb3, 0xf3, 0x69, 0x99, 0xed, 0x46, 0xbc, 0x89, 0xa7, 0x32, 0x16, 0x51, 0xfb, 0x5c, 0x6e, 0x6c,
	0xa6, 0x4f, 0xdf, 0x1b, 0x0e, 0x31, 0x21, 0xf0, 0x95, 0x61, 0xe1, 0x26, 0x9b, 0x4c, 0x7b, 0x2b,
	0x38, 0x0c, 0xf9, 0x71, 0x82, 0xda, 0xb3, 0x6f, 0x72, 0x0d, 0xea, 0xac, 0xd4, 0x40, 0xbc, 0xc3,
	0xc0, 0x97, 0xbc, 0x0c, 0x00, 0x49, 0x42, 0xe8, 0x85, 0x90, 0x7f, 0x9a, 0xba, 0xc7, 0x31, 0x04,
	0x4a, 0x2e, 0x26, 0xe2, 0xe4, 0x61, 0x72, 0x36, 0x3a, 0x6c, 0x66, 0xc8, 0xae, 0x0d, 0xe2, 0xa2,
	0xa3, 0xa9, 0x04, 0xf9, 0x6d, 0x82, 0x29, 0xb9, 0xe4, 0x73, 0x95, 0x52, 0x45, 0x61, 0xf1, 0x61,
	0x7e, 0xf5, 0xa7, 0x40, 0xaa, 0x47, 0xe9, 0xda, 0xa4, 0xc6, 0x87, 0xb8, 0x39, 0x76, 0x88, 0xd3,
	0x11, 0xd5, 0x55, 0x00, 0x3f, 0x70, 0x8e, 0x9d, 0x01, 0x3d, 0xa4, 0x76, 0x1b, 0x38, 0xe8, 0xd7,
	0x28, 0xfc, 0x5a, 0x49, 0x5e, 0x4c, 0xf4, 0x02, 0xcf, 0x8b, 0x0e, 0xc2, 0x76, 0x5d, 0x5c, 0x46,
	0xc4, 0x64, 0x93, 0x53, 0xd9, 0xdd, 0x01, 0x03, 0xaf, 0xfc, 0xb6, 0x63, 0x4e, 0xd4, 0xca, 0xd8,
	0xe6, 0x97, 0x1d, 0x8b, 0xec, 0x40, 0xb2, 0x1d, 0xb7, 0xdd, 0xe0, 0x3d, 0x45, 0x83, 0xe5, 0x3b,
	0xfe, 0xd1, 0xf3, 0x5c, 0x04, 0xe4, 0x4d, 0xce, 0xaa, 0x71, 0xca, 0x13, 0x24, 0xb0, 0xa8, 0x8d,
	0xa2, 0x93, 0xf6, 0x3c, 0xa7, 0xb3, 0x4f, 0x44, 0xbe, 0xb2, 0x10, 0x6c, 0x71, 0xef, 0x5f, 0x19,
	0xb3, 0x89, 0xdf, 0x1b, 0xec, 0xf7, 0xd7, 0x12, 0x2c, 0x09, 0xb8, 0xa6, 0x25, 0x98, 0x09, 0x50,
	0x0b, 0xb9, 0xa5, 0x10, 0x62, 0x16, 0x62, 0x64, 0x17, 0x2b, 0xe5, 0xc8, 0x03, 0x68, 0xc6, 0x63,
	0xca, 0x9e, 0xe5, 0xb7, 0x61, 0xcb, 0x46, 0xa8, 0x37, 0x8d, 0xcf, 0x63, 0xc0, 0xaa, 0x27, 0x45,
	0x71, 0xf4, 0x5e, 0xc7, 0x44, 0xa8, 0xee, 0xbd, 0x94, 0xca, 0x75, 0x45, 0x43, 0x9c, 0x75, 0x8f,
	0xc1, 0x4b, 0x2b, 0x88, 0x72, 0x0b, 0x3e, 0x43, 0x5f, 0x8e, 0x2d, 0xd3, 0x7d, 0x25, 0xfc, 0xeb,
	0xc2, 0x22, 0x43, 0x9d, 0xef, 0x30, 0x28, 0xcb, 0x03, 0x6c, 0xd9, 0xde, 0x28, 0x92, 0xf9, 0x2f,
	0x6e, 0x1a, 0xcb, 0x02, 0x09, 0xe7, 0x67, 0xfb, 0x0c, 0x96, 0x04, 0x10, 0x7d, 0x97, 0x45, 0x5c,
	0x8c, 0x61, 0x70, 0x7e, 0xdc, 0x3f, 0x4d, 0x69, 0x89, 0x70, 0x82, 0xca, 0xf9, 0xd3, 0x74, 0x39,
	0xb7, 0x9c, 0x0f, 0x82, 0x54, 0x35, 0x97, 0x0f, 0xad, 0xe9, 0x82, 0xd0, 0x32, 0x73, 0xe5, 0xb5,
	0x28, 0xee, 0x3e, 0xce, 0x8f, 0xfe, 0x03, 0x56, 0xd7, 0x3b, 0xa2, 0xba, 0x56, 0x53, 0x2b, 0x94,
	0x7f, 0x2b, 0x53, 0x5d, 0xb7, 0xc7, 0xa9, 0xa9, 0x8a, 0xeb, 0x7f, 0x94, 0xa1, 0xa6, 0x78, 0xb9,
	0xda, 0xfa, 0x76, 0xae, 0xb6, 0x9e, 0xf0, 0x00, 0x2a, 0xbf, 0xed, 0x00, 0xc2, 0x52, 0x8f, 0x7f,
	0xf4, 0x02, 0x7a, 0x20, 0x3d, 0x50, 0xe5, 0x04, 0x93, 0x1e, 0x24, 0x2e, 0xad, 0x9c, 0xc9, 0xa5,
	0xb7, 0x33, 0x57, 0x70, 0x57, 0xf3, 0xf2, 0x85, 0x07, 0xc5, 0x76, 0xd1, 0xdd, 0xdb, 0x07, 0x05,
	0x9d, 0xdf, 0x5b, 0xf4, 0xba, 0x2b, 0x70, 0x80, 0x1e, 0x10, 0x32, 0x19, 0xad, 0x63, 0xb5, 0xac,
	0xa8, 0x12, 0x0c, 0x90, 0xfc, 0xd2, 0x4c, 0x4d, 0x8a, 0xed, 0xec, 0x94, 0x81, 0x93, 0x5b, 0xa4,
	0x33, 0xec, 0xec, 0x3f, 0xe8, 0x75, 0xcc, 0x98, 0xeb, 0x96, 0x77, 0x0d, 0xab, 0x09, 0xb7, 0xf8,
	0x5b, 0x00, 0x1b, 0x3f, 0x58, 0x31, 0x91, 0x0a, 0xb6, 0xa8, 0xf9, 0x6b, 0x92, 0x82, 0x6c, 0x2c,
	0x76, 0x0e, 0x1c, 0xd7, 0x09, 0x8f, 0x04, 0x7f, 0x86, 0xf3, 0x21, 0x26, 0x6d, 0xf0, 0x37, 0x13,
	0xfa, 0x06, 0x11, 0x46, 0xdf, 0xb3, 0x29, 0x06, 0x0d, 0x7f, 0x33, 0x61, 0x84, 0x4d, 0x6c, 0x27,
	0x3b, 0xa0, 0x3a, 0xd1, 0x0e, 0xa8, 0x65, 0x76, 0xc0, 0x12, 0xcc, 0xa0, 0xbe, 0xa1, 0xe7, 0xf2,
	0x92, 0xa3, 0x66, 0xca, 0x96, 0x56, 0x19, 0xd5, 0xc7, 0x55, 0x46, 0xa7, 0xdc, 0xda, 0x64, 0x2a,
	0xa3, 0xb9, 0x71, 0x95, 0xd1, 0x59, 0x2e, 0x6d, 0xb4, 0x62, 0xae, 0x71, 0x5a, 0x31, 0xf7, 0x63,
	0x6e, 0x8f, 0x47, 0x78, 0x58, 0x67, 0x03, 0x5a, 0xee, 0x8f, 0x5b, 0x99, 0xbb, 0x9d, 0xf6, 0x38,
	0x2b, 0xa8, 0xab, 0x9d, 0x57, 0x50, 0xdf, 0x7e, 0x83, 0xee, 0x3b, 0xfb, 0xe1, 0x8a, 0xaa, 0xf6,
	0x87, 0xb6, 0x44, 0x64, 0xec, 0x33, 0x2e, 0xda, 0xca, 0x49, 0xd1, 0xa6, 0x6a, 0x3f, 0x16, 0xa6,
	0x73, 0xb2, 0xf6, 0x33, 0xee, 0xc3, 0x9c, 0x98, 0x4b, 0x6a, 0xbb, 0xc4, 0xb4, 0xb5, 0xd9, 0x29,
	0x5d, 0xe2, 0x62, 0xb2, 0x25, 0xe9, 0x34, 0x08, 0xf8, 0xda, 0x05, 0x1d, 0x5b, 0xc6, 0x1d, 0xa8,
	0xf3, 0x78, 0x93, 0xc7, 0xe8, 0x0d, 0x1d, 0xdc, 0x9f, 0x16, 0x94, 0x0c, 0xd0, 0xb0, 0x84, 0xc2,
	0xe9, 0x6a, 0xf7, 0x7f, 0x92, 0x39, 0x5d, 0x16, 0xd3, 0xfd, 0x33, 0x27, 0xcb, 0x6b, 0xa8, 0x70,
	0x72, 0x6e, 0xf7, 0x5f, 0x62, 0x40, 0xd3, 0xf7, 0x7a, 0x91, 0x75, 0xa8, 0x9e, 0x40, 0x19, 0xe1,
	0x29, 0xb6, 0xf9, 0x0b, 0x2e, 0x63, 0xda, 0x0e, 0x4e, 0x1c, 0x85, 0x12, 0x95, 0xd4, 0x19, 0x6d,
	0x4b, 0x90, 0x58, 0x31, 0x10, 0x3a, 0xbf, 0xa3, 0xdc, 0x52, 0xd3, 0x26, 0xff, 0xc6, 0x72, 0x8c,
	0xe8, 0xfa, 0x4a, 0x73, 0x61, 0x68, 0xf2, 0xe5, 0xc4, 0x89, 0xaf, 0x99, 0x56, 0xd8, 0x94, 0x5c,
	0x34, 0x33, 0x11, 0x16, 0x48, 0x25, 0xbb, 0xb3, 0x5b, 0xeb, 0x33, 0x38, 0x9f, 0xea, 0xaf, 0x9e,
	0x1a, 0x52, 0x03, 0x64, 0x67, 0x97, 0x9d, 0xff, 0x5d, 0x02, 0xd8, 0x18, 0x45, 0x47, 0x12, 0xf3,
	0x75, 0xa0, 0xca, 0xc0, 0xaa, 0x56, 0xee, 0xa8, 0x36, 0xe3, 0xf9, 0x56, 0x18, 0x22, 0xe0, 0x8a,
	0x0b, 0x1f, 0xd5, 0xe6, 0x78, 0x6d, 0xa4, 0x5e, 0x50, 0xf9, 0x37, 0x7b, 0x81, 0x15, 0xcf, 0xce,
	0x3d, 0xc4, 0xab, 0x88, 0xd4, 0x43, 0x79, 0xc2, 0x36, 0x04, 0x75, 0x43, 0x10, 0x99, 0x98, 0x63,
	0x53, 0x54, 0x2d, 0x3a, 0xe9, 0x45, 0xde, 0x6b, 0xea, 0x4a, 0x64, 0xd7, 0x88, 0xa9, 0x4f, 0x19,
	0x91, 0x89, 0x05, 0xf4, 0x10, 0xad, 0x1c, 0xc4, 0x62, 0x33, 0x42, 0x2c, 0xa6, 0x72, 0x31, 0xf6,
	0x62, 0xdf, 0xda, 0x1f, 0x0d, 0x06, 0x62, 0x91, 0x93, 0xda, 0x12, 0x81, 0x94, 0x58, 0x47, 0xf6,
	0xfa, 0x20, 0x31, 0x91, 0x5c, 0xdc, 0xf7, 0xaf, 0xe1, 0xcf, 0xc3, 0x82, 0xa6, 0xa8, 0x2c, 0x3f,
	0x31, 0x16, 0x44, 0x65, 0xfa, 0x6e, 0xfa, 0x1b, 0x17, 0xe0, 0x7c, 0xaa, 0xbf, 0x18, 0x76, 0xf5,
	0x32, 0x54, 0xe3, 0xd7, 0x79, 0x32, 0x0b, 0xe5, 0xa7, 0x9b, 0xfb, 0xad, 0x73, 0xec, 0xe3, 0xd9,
	0xd6, 0x7e, 0xab, 0xb4, 0xba, 0x0a, 0xf3, 0x99, 0x4b, 0x47, 0x52, 0x83, 0x8a, 0xb9, 0xbd, 0xb1,
	0xf5, 0x02, 0xc5, 0xe6, 0xa0, 0xba, 0xf7, 0xe4, 0xa9, 0x68, 0x95, 0x56, 0x37, 0xa1, 0x99, 0x3e,
	0xee, 0x48, 0x1d, 0x66, 0x37, 0x91, 0xfb, 0x74, 0x7b, 0x0b, 0x85, 0xb1, 0x61, 0x3e, 0xdb, 0xdb,
	0xdb, 0xd9, 0x7b, 0xd8, 0x2a, 0x11, 0x80, 0x99, 0xed, 0x6f, 0x76, 0x18, 0x63, 0x8a, 0x31, 0x9e,
	0xed, 0x3d, 0xda, 0x7b, 0xf2, 0x9b, 0xbd, 0x56, 0x79, 0xfd, 0x9f, 0x55, 0x68, 0x9a, 0x62, 0x09,
	0x5d, 0x8c, 0x05, 0x07, 0x81, 0xe4, 0x7d, 0x98, 0x8d, 0x7f, 0x7d, 0x48, 0x0e, 0xd6, 0xf4, 0x7f,
	0x1a, 0x9d, 0x76, 0x9e, 0x21, 0xcd, 0x76, 0x8e, 0xbc, 0x80, 0x56, 0xf6, 0xd1, 0x8d, 0x24, 0x17,
	0x48, 0x63, 0x5e, 0xf7, 0x3a, 0xd7, 0x4f, 0x91, 0x50, 0x43, 0x77, 0xa1, 0x99, 0x7e, 0x4e, 0x23,
	0x49, 0x69, 0x57, 0xf8, 0x4c, 0xd7, 0xb9, 0x36, 0x96, 0xaf, 0xeb, 0x9b, 0x7d, 0x48, 0xd3, 0xf4,
	0x1d, 0xf3, 0x48, 0xa7, 0xe9, 0x3b, 0xf6, 0x15, 0x8e, 0x0f, 0x9d, 0x7b, 0x72, 0x5a, 0x19, 0xff,
	0x68, 0x90, 0x1b, 0x7a, 0xdc, 0x4b, 0x84, 0x30, 0x45, 0xfa, 0xc6, 0x97, 0xe8, 0x0f, 0x3d, 0x05,
	0x37, 0xee, 0x9a, 0x29, 0x8a, 0xaf, 0x8a, 0x71, 0xd0, 0xe7, 0x58, 0xb2, 0xa5, 0xc1, 0x2c, 0xb9,
	0x96, 0xf1, 0x4b, 0x16, 0xe4, 0x75, 0x56, 0xc6, 0x0b, 0xa4, 0xfd, 0xa6, 0x43, 0xd5, 0x94, 0xdf,
	0x0a, 0xf0, 0x6f, 0xca, 0x6f, 0x85, 0x18, 0xf7, 0x1c, 0xd9, 0x87, 0x46, 0x0a, 0x90, 0x92, 0x2b,
	0x29, 0x5f, 0xe7, 0x86, 0xbc, 0x3a, 0x8e, 0xad, 0x2f, 0x3f, 0x03, 0x46, 0xb5, 0xe5, 0x17, 0x63,
	0xdc, 0xce, 0xca, 0x78, 0x81, 0xac, 0xaf, 0x92, 0xaa, 0x3c, 0xe3, 0xab, 0x1c, 0x7e, 0xcb, 0xf8,
	0x2a, 0x5f, 0xce, 0x4b, 0x5f, 0x65, 0xca, 0xeb, 0x6b, 0x63, 0x6b, 0x96, 0xbc, 0xaf, 0x8a, 0xcb,
	0x20, 0x1c, 0xf7, 0x2e, 0x4c, 0xb3, 0x52, 0x83, 0x24, 0x87, 0xba, 0x56, 0xe5, 0x74, 0x2e, 0x64,
	0xa8, 0x71, 0xb7, 0x1b, 0xa5, 0x5b, 0xa5, 0xf5, 0xbf, 0x4d, 0xc1, 0x9c, 0xc8, 0x83, 0x32, 0x95,
	0x3c, 0x04, 0x48, 0x4e, 0x63, 0xd2, 0x49, 0x2d, 0x2a, 0x55, 0x52, 0x74, 0x2e, 0x15, 0xf2, 0x94,
	0x52, 0x5f, 0xcb, 0xfa, 0x45, 0x2e, 0xf4, 0x52, 0x26, 0xed, 0xa6, 0x16, 0x79, 0xb9, 0x98, 0xa9,
	0xc6, 0xda, 0x82, 0x9a, 0xca, 0xf6, 0x44, 0x3b, 0x24, 0x32, 0x47, 0x55, 0xa7, 0x53, 0xc4, 0xd2,
	0x35, 0xd2, 0xd2, 0xbb, 0xa6, 0x51, 0xfe, 0xd0, 0xd0, 0x34, 0x2a, 0x38, 0x11, 0x8c, 0x73, 0xff,
	0x0f, 0x00, 0x00, 0xff, 0xff, 0x42, 0xad, 0xb8, 0x8d, 0x1c, 0x27, 0x00, 0x00,
}
