/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1beta1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg2_v1 "k8s.io/client-go/1.4/pkg/api/v1"
	pkg3_types "k8s.io/client-go/1.4/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_v1.ObjectMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *SubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy13 := &x.Spec
				yy13.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy14 := &x.Spec
				yy14.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = SubjectAccessReviewSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SubjectAccessReviewSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SelfSubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [5]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[0] = x.Kind != ""
			yyq33[1] = x.APIVersion != ""
			yyq33[2] = true
			yyq33[4] = true
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(5)
			} else {
				yynn33 = 1
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[0] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[1] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[2] {
					yy41 := &x.ObjectMeta
					yy41.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy42 := &x.ObjectMeta
					yy42.CodecEncodeSelf(e)
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy44 := &x.Spec
				yy44.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy45 := &x.Spec
				yy45.CodecEncodeSelf(e)
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[4] {
					yy47 := &x.Status
					yy47.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy48 := &x.Status
					yy48.CodecEncodeSelf(e)
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SelfSubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym49 := z.DecBinary()
	_ = yym49
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct50 := r.ContainerType()
		if yyct50 == codecSelferValueTypeMap1234 {
			yyl50 := r.ReadMapStart()
			if yyl50 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl50, d)
			}
		} else if yyct50 == codecSelferValueTypeArray1234 {
			yyl50 := r.ReadArrayStart()
			if yyl50 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl50, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SelfSubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys51Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys51Slc
	var yyhl51 bool = l >= 0
	for yyj51 := 0; ; yyj51++ {
		if yyhl51 {
			if yyj51 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys51Slc = r.DecodeBytes(yys51Slc, true, true)
		yys51 := string(yys51Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys51 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv54 := &x.ObjectMeta
				yyv54.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = SelfSubjectAccessReviewSpec{}
			} else {
				yyv55 := &x.Spec
				yyv55.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv56 := &x.Status
				yyv56.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys51)
		} // end switch yys51
	} // end for yyj51
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SelfSubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj57 int
	var yyb57 bool
	var yyhl57 bool = l >= 0
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv60 := &x.ObjectMeta
		yyv60.CodecDecodeSelf(d)
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SelfSubjectAccessReviewSpec{}
	} else {
		yyv61 := &x.Spec
		yyv61.CodecDecodeSelf(d)
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv62 := &x.Status
		yyv62.CodecDecodeSelf(d)
	}
	for {
		yyj57++
		if yyhl57 {
			yyb57 = yyj57 > l
		} else {
			yyb57 = r.CheckBreak()
		}
		if yyb57 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj57-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LocalSubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym63 := z.EncBinary()
		_ = yym63
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep64 := !z.EncBinary()
			yy2arr64 := z.EncBasicHandle().StructToArray
			var yyq64 [5]bool
			_, _, _ = yysep64, yyq64, yy2arr64
			const yyr64 bool = false
			yyq64[0] = x.Kind != ""
			yyq64[1] = x.APIVersion != ""
			yyq64[2] = true
			yyq64[4] = true
			var yynn64 int
			if yyr64 || yy2arr64 {
				r.EncodeArrayStart(5)
			} else {
				yynn64 = 1
				for _, b := range yyq64 {
					if b {
						yynn64++
					}
				}
				r.EncodeMapStart(yynn64)
				yynn64 = 0
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq64[0] {
					yym66 := z.EncBinary()
					_ = yym66
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq64[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq64[1] {
					yym69 := z.EncBinary()
					_ = yym69
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq64[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym70 := z.EncBinary()
					_ = yym70
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq64[2] {
					yy72 := &x.ObjectMeta
					yy72.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq64[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy73 := &x.ObjectMeta
					yy73.CodecEncodeSelf(e)
				}
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy75 := &x.Spec
				yy75.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy76 := &x.Spec
				yy76.CodecEncodeSelf(e)
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq64[4] {
					yy78 := &x.Status
					yy78.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq64[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy79 := &x.Status
					yy79.CodecEncodeSelf(e)
				}
			}
			if yyr64 || yy2arr64 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LocalSubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym80 := z.DecBinary()
	_ = yym80
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct81 := r.ContainerType()
		if yyct81 == codecSelferValueTypeMap1234 {
			yyl81 := r.ReadMapStart()
			if yyl81 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl81, d)
			}
		} else if yyct81 == codecSelferValueTypeArray1234 {
			yyl81 := r.ReadArrayStart()
			if yyl81 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl81, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LocalSubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys82Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys82Slc
	var yyhl82 bool = l >= 0
	for yyj82 := 0; ; yyj82++ {
		if yyhl82 {
			if yyj82 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys82Slc = r.DecodeBytes(yys82Slc, true, true)
		yys82 := string(yys82Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys82 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv85 := &x.ObjectMeta
				yyv85.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = SubjectAccessReviewSpec{}
			} else {
				yyv86 := &x.Spec
				yyv86.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv87 := &x.Status
				yyv87.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys82)
		} // end switch yys82
	} // end for yyj82
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LocalSubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj88 int
	var yyb88 bool
	var yyhl88 bool = l >= 0
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv91 := &x.ObjectMeta
		yyv91.CodecDecodeSelf(d)
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SubjectAccessReviewSpec{}
	} else {
		yyv92 := &x.Spec
		yyv92.CodecDecodeSelf(d)
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv93 := &x.Status
		yyv93.CodecDecodeSelf(d)
	}
	for {
		yyj88++
		if yyhl88 {
			yyb88 = yyj88 > l
		} else {
			yyb88 = r.CheckBreak()
		}
		if yyb88 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj88-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceAttributes) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym94 := z.EncBinary()
		_ = yym94
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep95 := !z.EncBinary()
			yy2arr95 := z.EncBasicHandle().StructToArray
			var yyq95 [7]bool
			_, _, _ = yysep95, yyq95, yy2arr95
			const yyr95 bool = false
			yyq95[0] = x.Namespace != ""
			yyq95[1] = x.Verb != ""
			yyq95[2] = x.Group != ""
			yyq95[3] = x.Version != ""
			yyq95[4] = x.Resource != ""
			yyq95[5] = x.Subresource != ""
			yyq95[6] = x.Name != ""
			var yynn95 int
			if yyr95 || yy2arr95 {
				r.EncodeArrayStart(7)
			} else {
				yynn95 = 0
				for _, b := range yyq95 {
					if b {
						yynn95++
					}
				}
				r.EncodeMapStart(yynn95)
				yynn95 = 0
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[0] {
					yym97 := z.EncBinary()
					_ = yym97
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym98 := z.EncBinary()
					_ = yym98
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[1] {
					yym100 := z.EncBinary()
					_ = yym100
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("verb"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym101 := z.EncBinary()
					_ = yym101
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[2] {
					yym103 := z.EncBinary()
					_ = yym103
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym104 := z.EncBinary()
					_ = yym104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[3] {
					yym106 := z.EncBinary()
					_ = yym106
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Version))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("version"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym107 := z.EncBinary()
					_ = yym107
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Version))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[4] {
					yym109 := z.EncBinary()
					_ = yym109
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym110 := z.EncBinary()
					_ = yym110
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[5] {
					yym112 := z.EncBinary()
					_ = yym112
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subresource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym113 := z.EncBinary()
					_ = yym113
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq95[6] {
					yym115 := z.EncBinary()
					_ = yym115
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq95[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym116 := z.EncBinary()
					_ = yym116
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr95 || yy2arr95 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceAttributes) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym117 := z.DecBinary()
	_ = yym117
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct118 := r.ContainerType()
		if yyct118 == codecSelferValueTypeMap1234 {
			yyl118 := r.ReadMapStart()
			if yyl118 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl118, d)
			}
		} else if yyct118 == codecSelferValueTypeArray1234 {
			yyl118 := r.ReadArrayStart()
			if yyl118 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl118, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceAttributes) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys119Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys119Slc
	var yyhl119 bool = l >= 0
	for yyj119 := 0; ; yyj119++ {
		if yyhl119 {
			if yyj119 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys119Slc = r.DecodeBytes(yys119Slc, true, true)
		yys119 := string(yys119Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys119 {
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "verb":
			if r.TryDecodeAsNil() {
				x.Verb = ""
			} else {
				x.Verb = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		case "version":
			if r.TryDecodeAsNil() {
				x.Version = ""
			} else {
				x.Version = string(r.DecodeString())
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys119)
		} // end switch yys119
	} // end for yyj119
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceAttributes) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj127 int
	var yyb127 bool
	var yyhl127 bool = l >= 0
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verb = ""
	} else {
		x.Verb = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Version = ""
	} else {
		x.Version = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	yyj127++
	if yyhl127 {
		yyb127 = yyj127 > l
	} else {
		yyb127 = r.CheckBreak()
	}
	if yyb127 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj127++
		if yyhl127 {
			yyb127 = yyj127 > l
		} else {
			yyb127 = r.CheckBreak()
		}
		if yyb127 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj127-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NonResourceAttributes) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym135 := z.EncBinary()
		_ = yym135
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep136 := !z.EncBinary()
			yy2arr136 := z.EncBasicHandle().StructToArray
			var yyq136 [2]bool
			_, _, _ = yysep136, yyq136, yy2arr136
			const yyr136 bool = false
			yyq136[0] = x.Path != ""
			yyq136[1] = x.Verb != ""
			var yynn136 int
			if yyr136 || yy2arr136 {
				r.EncodeArrayStart(2)
			} else {
				yynn136 = 0
				for _, b := range yyq136 {
					if b {
						yynn136++
					}
				}
				r.EncodeMapStart(yynn136)
				yynn136 = 0
			}
			if yyr136 || yy2arr136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq136[0] {
					yym138 := z.EncBinary()
					_ = yym138
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq136[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym139 := z.EncBinary()
					_ = yym139
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr136 || yy2arr136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq136[1] {
					yym141 := z.EncBinary()
					_ = yym141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq136[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("verb"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
					}
				}
			}
			if yyr136 || yy2arr136 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NonResourceAttributes) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym143 := z.DecBinary()
	_ = yym143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct144 := r.ContainerType()
		if yyct144 == codecSelferValueTypeMap1234 {
			yyl144 := r.ReadMapStart()
			if yyl144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl144, d)
			}
		} else if yyct144 == codecSelferValueTypeArray1234 {
			yyl144 := r.ReadArrayStart()
			if yyl144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NonResourceAttributes) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys145Slc
	var yyhl145 bool = l >= 0
	for yyj145 := 0; ; yyj145++ {
		if yyhl145 {
			if yyj145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys145Slc = r.DecodeBytes(yys145Slc, true, true)
		yys145 := string(yys145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys145 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "verb":
			if r.TryDecodeAsNil() {
				x.Verb = ""
			} else {
				x.Verb = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys145)
		} // end switch yys145
	} // end for yyj145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NonResourceAttributes) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj148 int
	var yyb148 bool
	var yyhl148 bool = l >= 0
	yyj148++
	if yyhl148 {
		yyb148 = yyj148 > l
	} else {
		yyb148 = r.CheckBreak()
	}
	if yyb148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj148++
	if yyhl148 {
		yyb148 = yyj148 > l
	} else {
		yyb148 = r.CheckBreak()
	}
	if yyb148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verb = ""
	} else {
		x.Verb = string(r.DecodeString())
	}
	for {
		yyj148++
		if yyhl148 {
			yyb148 = yyj148 > l
		} else {
			yyb148 = r.CheckBreak()
		}
		if yyb148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubjectAccessReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym151 := z.EncBinary()
		_ = yym151
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep152 := !z.EncBinary()
			yy2arr152 := z.EncBasicHandle().StructToArray
			var yyq152 [5]bool
			_, _, _ = yysep152, yyq152, yy2arr152
			const yyr152 bool = false
			yyq152[0] = x.ResourceAttributes != nil
			yyq152[1] = x.NonResourceAttributes != nil
			yyq152[2] = x.User != ""
			yyq152[3] = len(x.Groups) != 0
			yyq152[4] = len(x.Extra) != 0
			var yynn152 int
			if yyr152 || yy2arr152 {
				r.EncodeArrayStart(5)
			} else {
				yynn152 = 0
				for _, b := range yyq152 {
					if b {
						yynn152++
					}
				}
				r.EncodeMapStart(yynn152)
				yynn152 = 0
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq152[0] {
					if x.ResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.ResourceAttributes.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq152[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceAttributes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.ResourceAttributes.CodecEncodeSelf(e)
					}
				}
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq152[1] {
					if x.NonResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.NonResourceAttributes.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq152[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nonResourceAttributes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NonResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.NonResourceAttributes.CodecEncodeSelf(e)
					}
				}
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq152[2] {
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq152[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym157 := z.EncBinary()
					_ = yym157
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq152[3] {
					if x.Groups == nil {
						r.EncodeNil()
					} else {
						yym159 := z.EncBinary()
						_ = yym159
						if false {
						} else {
							z.F.EncSliceStringV(x.Groups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq152[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Groups == nil {
						r.EncodeNil()
					} else {
						yym160 := z.EncBinary()
						_ = yym160
						if false {
						} else {
							z.F.EncSliceStringV(x.Groups, false, e)
						}
					}
				}
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq152[4] {
					if x.Extra == nil {
						r.EncodeNil()
					} else {
						yym162 := z.EncBinary()
						_ = yym162
						if false {
						} else {
							h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq152[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("extra"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Extra == nil {
						r.EncodeNil()
					} else {
						yym163 := z.EncBinary()
						_ = yym163
						if false {
						} else {
							h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
						}
					}
				}
			}
			if yyr152 || yy2arr152 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym164 := z.DecBinary()
	_ = yym164
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct165 := r.ContainerType()
		if yyct165 == codecSelferValueTypeMap1234 {
			yyl165 := r.ReadMapStart()
			if yyl165 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl165, d)
			}
		} else if yyct165 == codecSelferValueTypeArray1234 {
			yyl165 := r.ReadArrayStart()
			if yyl165 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl165, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys166Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys166Slc
	var yyhl166 bool = l >= 0
	for yyj166 := 0; ; yyj166++ {
		if yyhl166 {
			if yyj166 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys166Slc = r.DecodeBytes(yys166Slc, true, true)
		yys166 := string(yys166Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys166 {
		case "resourceAttributes":
			if r.TryDecodeAsNil() {
				if x.ResourceAttributes != nil {
					x.ResourceAttributes = nil
				}
			} else {
				if x.ResourceAttributes == nil {
					x.ResourceAttributes = new(ResourceAttributes)
				}
				x.ResourceAttributes.CodecDecodeSelf(d)
			}
		case "nonResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.NonResourceAttributes != nil {
					x.NonResourceAttributes = nil
				}
			} else {
				if x.NonResourceAttributes == nil {
					x.NonResourceAttributes = new(NonResourceAttributes)
				}
				x.NonResourceAttributes.CodecDecodeSelf(d)
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Groups = nil
			} else {
				yyv170 := &x.Groups
				yym171 := z.DecBinary()
				_ = yym171
				if false {
				} else {
					z.F.DecSliceStringX(yyv170, false, d)
				}
			}
		case "extra":
			if r.TryDecodeAsNil() {
				x.Extra = nil
			} else {
				yyv172 := &x.Extra
				yym173 := z.DecBinary()
				_ = yym173
				if false {
				} else {
					h.decMapstringExtraValue((*map[string]ExtraValue)(yyv172), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys166)
		} // end switch yys166
	} // end for yyj166
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj174 int
	var yyb174 bool
	var yyhl174 bool = l >= 0
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceAttributes != nil {
			x.ResourceAttributes = nil
		}
	} else {
		if x.ResourceAttributes == nil {
			x.ResourceAttributes = new(ResourceAttributes)
		}
		x.ResourceAttributes.CodecDecodeSelf(d)
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NonResourceAttributes != nil {
			x.NonResourceAttributes = nil
		}
	} else {
		if x.NonResourceAttributes == nil {
			x.NonResourceAttributes = new(NonResourceAttributes)
		}
		x.NonResourceAttributes.CodecDecodeSelf(d)
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Groups = nil
	} else {
		yyv178 := &x.Groups
		yym179 := z.DecBinary()
		_ = yym179
		if false {
		} else {
			z.F.DecSliceStringX(yyv178, false, d)
		}
	}
	yyj174++
	if yyhl174 {
		yyb174 = yyj174 > l
	} else {
		yyb174 = r.CheckBreak()
	}
	if yyb174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Extra = nil
	} else {
		yyv180 := &x.Extra
		yym181 := z.DecBinary()
		_ = yym181
		if false {
		} else {
			h.decMapstringExtraValue((*map[string]ExtraValue)(yyv180), d)
		}
	}
	for {
		yyj174++
		if yyhl174 {
			yyb174 = yyj174 > l
		} else {
			yyb174 = r.CheckBreak()
		}
		if yyb174 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj174-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ExtraValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym182 := z.EncBinary()
		_ = yym182
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encExtraValue((ExtraValue)(x), e)
		}
	}
}

func (x *ExtraValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym183 := z.DecBinary()
	_ = yym183
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decExtraValue((*ExtraValue)(x), d)
	}
}

func (x *SelfSubjectAccessReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym184 := z.EncBinary()
		_ = yym184
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep185 := !z.EncBinary()
			yy2arr185 := z.EncBasicHandle().StructToArray
			var yyq185 [2]bool
			_, _, _ = yysep185, yyq185, yy2arr185
			const yyr185 bool = false
			yyq185[0] = x.ResourceAttributes != nil
			yyq185[1] = x.NonResourceAttributes != nil
			var yynn185 int
			if yyr185 || yy2arr185 {
				r.EncodeArrayStart(2)
			} else {
				yynn185 = 0
				for _, b := range yyq185 {
					if b {
						yynn185++
					}
				}
				r.EncodeMapStart(yynn185)
				yynn185 = 0
			}
			if yyr185 || yy2arr185 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq185[0] {
					if x.ResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.ResourceAttributes.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq185[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceAttributes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.ResourceAttributes.CodecEncodeSelf(e)
					}
				}
			}
			if yyr185 || yy2arr185 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq185[1] {
					if x.NonResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.NonResourceAttributes.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq185[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nonResourceAttributes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NonResourceAttributes == nil {
						r.EncodeNil()
					} else {
						x.NonResourceAttributes.CodecEncodeSelf(e)
					}
				}
			}
			if yyr185 || yy2arr185 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SelfSubjectAccessReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym188 := z.DecBinary()
	_ = yym188
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct189 := r.ContainerType()
		if yyct189 == codecSelferValueTypeMap1234 {
			yyl189 := r.ReadMapStart()
			if yyl189 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl189, d)
			}
		} else if yyct189 == codecSelferValueTypeArray1234 {
			yyl189 := r.ReadArrayStart()
			if yyl189 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl189, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SelfSubjectAccessReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys190Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys190Slc
	var yyhl190 bool = l >= 0
	for yyj190 := 0; ; yyj190++ {
		if yyhl190 {
			if yyj190 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys190Slc = r.DecodeBytes(yys190Slc, true, true)
		yys190 := string(yys190Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys190 {
		case "resourceAttributes":
			if r.TryDecodeAsNil() {
				if x.ResourceAttributes != nil {
					x.ResourceAttributes = nil
				}
			} else {
				if x.ResourceAttributes == nil {
					x.ResourceAttributes = new(ResourceAttributes)
				}
				x.ResourceAttributes.CodecDecodeSelf(d)
			}
		case "nonResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.NonResourceAttributes != nil {
					x.NonResourceAttributes = nil
				}
			} else {
				if x.NonResourceAttributes == nil {
					x.NonResourceAttributes = new(NonResourceAttributes)
				}
				x.NonResourceAttributes.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys190)
		} // end switch yys190
	} // end for yyj190
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SelfSubjectAccessReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj193 int
	var yyb193 bool
	var yyhl193 bool = l >= 0
	yyj193++
	if yyhl193 {
		yyb193 = yyj193 > l
	} else {
		yyb193 = r.CheckBreak()
	}
	if yyb193 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceAttributes != nil {
			x.ResourceAttributes = nil
		}
	} else {
		if x.ResourceAttributes == nil {
			x.ResourceAttributes = new(ResourceAttributes)
		}
		x.ResourceAttributes.CodecDecodeSelf(d)
	}
	yyj193++
	if yyhl193 {
		yyb193 = yyj193 > l
	} else {
		yyb193 = r.CheckBreak()
	}
	if yyb193 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NonResourceAttributes != nil {
			x.NonResourceAttributes = nil
		}
	} else {
		if x.NonResourceAttributes == nil {
			x.NonResourceAttributes = new(NonResourceAttributes)
		}
		x.NonResourceAttributes.CodecDecodeSelf(d)
	}
	for {
		yyj193++
		if yyhl193 {
			yyb193 = yyj193 > l
		} else {
			yyb193 = r.CheckBreak()
		}
		if yyb193 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj193-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubjectAccessReviewStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym196 := z.EncBinary()
		_ = yym196
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep197 := !z.EncBinary()
			yy2arr197 := z.EncBasicHandle().StructToArray
			var yyq197 [3]bool
			_, _, _ = yysep197, yyq197, yy2arr197
			const yyr197 bool = false
			yyq197[1] = x.Reason != ""
			yyq197[2] = x.EvaluationError != ""
			var yynn197 int
			if yyr197 || yy2arr197 {
				r.EncodeArrayStart(3)
			} else {
				yynn197 = 1
				for _, b := range yyq197 {
					if b {
						yynn197++
					}
				}
				r.EncodeMapStart(yynn197)
				yynn197 = 0
			}
			if yyr197 || yy2arr197 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym199 := z.EncBinary()
				_ = yym199
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowed"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			}
			if yyr197 || yy2arr197 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq197[1] {
					yym202 := z.EncBinary()
					_ = yym202
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq197[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym203 := z.EncBinary()
					_ = yym203
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr197 || yy2arr197 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq197[2] {
					yym205 := z.EncBinary()
					_ = yym205
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvaluationError))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq197[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evaluationError"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym206 := z.EncBinary()
					_ = yym206
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvaluationError))
					}
				}
			}
			if yyr197 || yy2arr197 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReviewStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym207 := z.DecBinary()
	_ = yym207
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct208 := r.ContainerType()
		if yyct208 == codecSelferValueTypeMap1234 {
			yyl208 := r.ReadMapStart()
			if yyl208 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl208, d)
			}
		} else if yyct208 == codecSelferValueTypeArray1234 {
			yyl208 := r.ReadArrayStart()
			if yyl208 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl208, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReviewStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys209Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys209Slc
	var yyhl209 bool = l >= 0
	for yyj209 := 0; ; yyj209++ {
		if yyhl209 {
			if yyj209 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys209Slc = r.DecodeBytes(yys209Slc, true, true)
		yys209 := string(yys209Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys209 {
		case "allowed":
			if r.TryDecodeAsNil() {
				x.Allowed = false
			} else {
				x.Allowed = bool(r.DecodeBool())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "evaluationError":
			if r.TryDecodeAsNil() {
				x.EvaluationError = ""
			} else {
				x.EvaluationError = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys209)
		} // end switch yys209
	} // end for yyj209
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReviewStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj213 int
	var yyb213 bool
	var yyhl213 bool = l >= 0
	yyj213++
	if yyhl213 {
		yyb213 = yyj213 > l
	} else {
		yyb213 = r.CheckBreak()
	}
	if yyb213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allowed = false
	} else {
		x.Allowed = bool(r.DecodeBool())
	}
	yyj213++
	if yyhl213 {
		yyb213 = yyj213 > l
	} else {
		yyb213 = r.CheckBreak()
	}
	if yyb213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj213++
	if yyhl213 {
		yyb213 = yyj213 > l
	} else {
		yyb213 = r.CheckBreak()
	}
	if yyb213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvaluationError = ""
	} else {
		x.EvaluationError = string(r.DecodeString())
	}
	for {
		yyj213++
		if yyhl213 {
			yyb213 = yyj213 > l
		} else {
			yyb213 = r.CheckBreak()
		}
		if yyb213 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj213-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encMapstringExtraValue(v map[string]ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk217, yyv217 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym218 := z.EncBinary()
		_ = yym218
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk217))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		if yyv217 == nil {
			r.EncodeNil()
		} else {
			yyv217.CodecEncodeSelf(e)
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decMapstringExtraValue(v *map[string]ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv219 := *v
	yyl219 := r.ReadMapStart()
	yybh219 := z.DecBasicHandle()
	if yyv219 == nil {
		yyrl219, _ := z.DecInferLen(yyl219, yybh219.MaxInitLen, 40)
		yyv219 = make(map[string]ExtraValue, yyrl219)
		*v = yyv219
	}
	var yymk219 string
	var yymv219 ExtraValue
	var yymg219 bool
	if yybh219.MapValueReset {
		yymg219 = true
	}
	if yyl219 > 0 {
		for yyj219 := 0; yyj219 < yyl219; yyj219++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk219 = ""
			} else {
				yymk219 = string(r.DecodeString())
			}

			if yymg219 {
				yymv219 = yyv219[yymk219]
			} else {
				yymv219 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv219 = nil
			} else {
				yyv221 := &yymv219
				yyv221.CodecDecodeSelf(d)
			}

			if yyv219 != nil {
				yyv219[yymk219] = yymv219
			}
		}
	} else if yyl219 < 0 {
		for yyj219 := 0; !r.CheckBreak(); yyj219++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk219 = ""
			} else {
				yymk219 = string(r.DecodeString())
			}

			if yymg219 {
				yymv219 = yyv219[yymk219]
			} else {
				yymv219 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv219 = nil
			} else {
				yyv223 := &yymv219
				yyv223.CodecDecodeSelf(d)
			}

			if yyv219 != nil {
				yyv219[yymk219] = yymv219
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) encExtraValue(v ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv224 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym225 := z.EncBinary()
		_ = yym225
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv224))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decExtraValue(v *ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv226 := *v
	yyh226, yyl226 := z.DecSliceHelperStart()
	var yyc226 bool
	if yyl226 == 0 {
		if yyv226 == nil {
			yyv226 = []string{}
			yyc226 = true
		} else if len(yyv226) != 0 {
			yyv226 = yyv226[:0]
			yyc226 = true
		}
	} else if yyl226 > 0 {
		var yyrr226, yyrl226 int
		var yyrt226 bool
		if yyl226 > cap(yyv226) {

			yyrl226, yyrt226 = z.DecInferLen(yyl226, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt226 {
				if yyrl226 <= cap(yyv226) {
					yyv226 = yyv226[:yyrl226]
				} else {
					yyv226 = make([]string, yyrl226)
				}
			} else {
				yyv226 = make([]string, yyrl226)
			}
			yyc226 = true
			yyrr226 = len(yyv226)
		} else if yyl226 != len(yyv226) {
			yyv226 = yyv226[:yyl226]
			yyc226 = true
		}
		yyj226 := 0
		for ; yyj226 < yyrr226; yyj226++ {
			yyh226.ElemContainerState(yyj226)
			if r.TryDecodeAsNil() {
				yyv226[yyj226] = ""
			} else {
				yyv226[yyj226] = string(r.DecodeString())
			}

		}
		if yyrt226 {
			for ; yyj226 < yyl226; yyj226++ {
				yyv226 = append(yyv226, "")
				yyh226.ElemContainerState(yyj226)
				if r.TryDecodeAsNil() {
					yyv226[yyj226] = ""
				} else {
					yyv226[yyj226] = string(r.DecodeString())
				}

			}
		}

	} else {
		yyj226 := 0
		for ; !r.CheckBreak(); yyj226++ {

			if yyj226 >= len(yyv226) {
				yyv226 = append(yyv226, "") // var yyz226 string
				yyc226 = true
			}
			yyh226.ElemContainerState(yyj226)
			if yyj226 < len(yyv226) {
				if r.TryDecodeAsNil() {
					yyv226[yyj226] = ""
				} else {
					yyv226[yyj226] = string(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj226 < len(yyv226) {
			yyv226 = yyv226[:yyj226]
			yyc226 = true
		} else if yyj226 == 0 && yyv226 == nil {
			yyv226 = []string{}
			yyc226 = true
		}
	}
	yyh226.End()
	if yyc226 {
		*v = yyv226
	}
}
