/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/client-go/1.4/pkg/api/resource"
	pkg1_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg2_v1 "k8s.io/client-go/1.4/pkg/api/v1"
	pkg3_types "k8s.io/client-go/1.4/pkg/types"
	pkg5_intstr "k8s.io/client-go/1.4/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg2_v1.ObjectMeta
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.Spec
					yy13.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.Spec
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [4]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[0] = x.Kind != ""
			yyq33[1] = x.APIVersion != ""
			yyq33[2] = true
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(4)
			} else {
				yynn33 = 1
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[0] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[1] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[2] {
					yy41 := &x.ListMeta
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else if z.HasExtensions() && z.EncExt(yy41) {
					} else {
						z.EncFallback(yy41)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.ListMeta
					yym44 := z.EncBinary()
					_ = yym44
					if false {
					} else if z.HasExtensions() && z.EncExt(yy43) {
					} else {
						z.EncFallback(yy43)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym48 := z.DecBinary()
	_ = yym48
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct49 := r.ContainerType()
		if yyct49 == codecSelferValueTypeMap1234 {
			yyl49 := r.ReadMapStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl49, d)
			}
		} else if yyct49 == codecSelferValueTypeArray1234 {
			yyl49 := r.ReadArrayStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl49, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys50Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys50Slc
	var yyhl50 bool = l >= 0
	for yyj50 := 0; ; yyj50++ {
		if yyhl50 {
			if yyj50 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys50Slc = r.DecodeBytes(yys50Slc, true, true)
		yys50 := string(yys50Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys50 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv53 := &x.ListMeta
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv53) {
				} else {
					z.DecFallback(yyv53, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv55 := &x.Items
				yym56 := z.DecBinary()
				_ = yym56
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv55), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys50)
		} // end switch yys50
	} // end for yyj50
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj57 int
	var yyb57 bool
	var yyhl57 bool = l >= 0
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv60 := &x.ListMeta
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv60) {
		} else {
			z.DecFallback(yyv60, false)
		}
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv62 := &x.Items
		yym63 := z.DecBinary()
		_ = yym63
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv62), d)
		}
	}
	for {
		yyj57++
		if yyhl57 {
			yyb57 = yyj57 > l
		} else {
			yyb57 = r.CheckBreak()
		}
		if yyb57 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj57-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym64 := z.EncBinary()
		_ = yym64
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep65 := !z.EncBinary()
			yy2arr65 := z.EncBasicHandle().StructToArray
			var yyq65 [6]bool
			_, _, _ = yysep65, yyq65, yy2arr65
			const yyr65 bool = false
			yyq65[0] = x.Parallelism != nil
			yyq65[1] = x.Completions != nil
			yyq65[2] = x.ActiveDeadlineSeconds != nil
			yyq65[3] = x.Selector != nil
			yyq65[4] = x.ManualSelector != nil
			var yynn65 int
			if yyr65 || yy2arr65 {
				r.EncodeArrayStart(6)
			} else {
				yynn65 = 1
				for _, b := range yyq65 {
					if b {
						yynn65++
					}
				}
				r.EncodeMapStart(yynn65)
				yynn65 = 0
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy67 := *x.Parallelism
						yym68 := z.EncBinary()
						_ = yym68
						if false {
						} else {
							r.EncodeInt(int64(yy67))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy69 := *x.Parallelism
						yym70 := z.EncBinary()
						_ = yym70
						if false {
						} else {
							r.EncodeInt(int64(yy69))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy72 := *x.Completions
						yym73 := z.EncBinary()
						_ = yym73
						if false {
						} else {
							r.EncodeInt(int64(yy72))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy74 := *x.Completions
						yym75 := z.EncBinary()
						_ = yym75
						if false {
						} else {
							r.EncodeInt(int64(yy74))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy77 := *x.ActiveDeadlineSeconds
						yym78 := z.EncBinary()
						_ = yym78
						if false {
						} else {
							r.EncodeInt(int64(yy77))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy79 := *x.ActiveDeadlineSeconds
						yym80 := z.EncBinary()
						_ = yym80
						if false {
						} else {
							r.EncodeInt(int64(yy79))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[4] {
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy83 := *x.ManualSelector
						yym84 := z.EncBinary()
						_ = yym84
						if false {
						} else {
							r.EncodeBool(bool(yy83))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("manualSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy85 := *x.ManualSelector
						yym86 := z.EncBinary()
						_ = yym86
						if false {
						} else {
							r.EncodeBool(bool(yy85))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy88 := &x.Template
				yy88.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy89 := &x.Template
				yy89.CodecEncodeSelf(e)
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym90 := z.DecBinary()
	_ = yym90
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct91 := r.ContainerType()
		if yyct91 == codecSelferValueTypeMap1234 {
			yyl91 := r.ReadMapStart()
			if yyl91 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl91, d)
			}
		} else if yyct91 == codecSelferValueTypeArray1234 {
			yyl91 := r.ReadArrayStart()
			if yyl91 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl91, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys92Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys92Slc
	var yyhl92 bool = l >= 0
	for yyj92 := 0; ; yyj92++ {
		if yyhl92 {
			if yyj92 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys92Slc = r.DecodeBytes(yys92Slc, true, true)
		yys92 := string(yys92Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys92 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym94 := z.DecBinary()
				_ = yym94
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym96 := z.DecBinary()
				_ = yym96
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym98 := z.DecBinary()
				_ = yym98
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "manualSelector":
			if r.TryDecodeAsNil() {
				if x.ManualSelector != nil {
					x.ManualSelector = nil
				}
			} else {
				if x.ManualSelector == nil {
					x.ManualSelector = new(bool)
				}
				yym101 := z.DecBinary()
				_ = yym101
				if false {
				} else {
					*((*bool)(x.ManualSelector)) = r.DecodeBool()
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv102 := &x.Template
				yyv102.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys92)
		} // end switch yys92
	} // end for yyj92
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym105 := z.DecBinary()
		_ = yym105
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym107 := z.DecBinary()
		_ = yym107
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym109 := z.DecBinary()
		_ = yym109
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ManualSelector != nil {
			x.ManualSelector = nil
		}
	} else {
		if x.ManualSelector == nil {
			x.ManualSelector = new(bool)
		}
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			*((*bool)(x.ManualSelector)) = r.DecodeBool()
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv113 := &x.Template
		yyv113.CodecDecodeSelf(d)
	}
	for {
		yyj103++
		if yyhl103 {
			yyb103 = yyj103 > l
		} else {
			yyb103 = r.CheckBreak()
		}
		if yyb103 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj103-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym114 := z.EncBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep115 := !z.EncBinary()
			yy2arr115 := z.EncBasicHandle().StructToArray
			var yyq115 [6]bool
			_, _, _ = yysep115, yyq115, yy2arr115
			const yyr115 bool = false
			yyq115[0] = len(x.Conditions) != 0
			yyq115[1] = x.StartTime != nil
			yyq115[2] = x.CompletionTime != nil
			yyq115[3] = x.Active != 0
			yyq115[4] = x.Succeeded != 0
			yyq115[5] = x.Failed != 0
			var yynn115 int
			if yyr115 || yy2arr115 {
				r.EncodeArrayStart(6)
			} else {
				yynn115 = 0
				for _, b := range yyq115 {
					if b {
						yynn115++
					}
				}
				r.EncodeMapStart(yynn115)
				yynn115 = 0
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym117 := z.EncBinary()
						_ = yym117
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym118 := z.EncBinary()
						_ = yym118
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym120 := z.EncBinary()
						_ = yym120
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym120 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym120 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym121 := z.EncBinary()
						_ = yym121
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym121 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym121 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym123 := z.EncBinary()
						_ = yym123
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym123 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym123 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym124 := z.EncBinary()
						_ = yym124
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym124 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym124 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[3] {
					yym126 := z.EncBinary()
					_ = yym126
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq115[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym127 := z.EncBinary()
					_ = yym127
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[4] {
					yym129 := z.EncBinary()
					_ = yym129
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq115[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym130 := z.EncBinary()
					_ = yym130
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[5] {
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq115[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym134 := z.DecBinary()
	_ = yym134
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct135 := r.ContainerType()
		if yyct135 == codecSelferValueTypeMap1234 {
			yyl135 := r.ReadMapStart()
			if yyl135 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl135, d)
			}
		} else if yyct135 == codecSelferValueTypeArray1234 {
			yyl135 := r.ReadArrayStart()
			if yyl135 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl135, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys136Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys136Slc
	var yyhl136 bool = l >= 0
	for yyj136 := 0; ; yyj136++ {
		if yyhl136 {
			if yyj136 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys136Slc = r.DecodeBytes(yys136Slc, true, true)
		yys136 := string(yys136Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys136 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv137 := &x.Conditions
				yym138 := z.DecBinary()
				_ = yym138
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv137), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym140 := z.DecBinary()
				_ = yym140
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym140 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym140 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym142 := z.DecBinary()
				_ = yym142
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym142 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym142 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys136)
		} // end switch yys136
	} // end for yyj136
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj146 int
	var yyb146 bool
	var yyhl146 bool = l >= 0
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv147 := &x.Conditions
		yym148 := z.DecBinary()
		_ = yym148
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv147), d)
		}
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym150 := z.DecBinary()
		_ = yym150
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym150 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym150 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym152 := z.DecBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym152 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym152 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj146++
		if yyhl146 {
			yyb146 = yyj146 > l
		} else {
			yyb146 = r.CheckBreak()
		}
		if yyb146 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj146-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym156 := z.EncBinary()
	_ = yym156
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym157 := z.DecBinary()
	_ = yym157
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym158 := z.EncBinary()
		_ = yym158
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep159 := !z.EncBinary()
			yy2arr159 := z.EncBasicHandle().StructToArray
			var yyq159 [6]bool
			_, _, _ = yysep159, yyq159, yy2arr159
			const yyr159 bool = false
			yyq159[2] = true
			yyq159[3] = true
			yyq159[4] = x.Reason != ""
			yyq159[5] = x.Message != ""
			var yynn159 int
			if yyr159 || yy2arr159 {
				r.EncodeArrayStart(6)
			} else {
				yynn159 = 2
				for _, b := range yyq159 {
					if b {
						yynn159++
					}
				}
				r.EncodeMapStart(yynn159)
				yynn159 = 0
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym163 := z.EncBinary()
				_ = yym163
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq159[2] {
					yy165 := &x.LastProbeTime
					yym166 := z.EncBinary()
					_ = yym166
					if false {
					} else if z.HasExtensions() && z.EncExt(yy165) {
					} else if yym166 {
						z.EncBinaryMarshal(yy165)
					} else if !yym166 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy165)
					} else {
						z.EncFallback(yy165)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq159[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy167 := &x.LastProbeTime
					yym168 := z.EncBinary()
					_ = yym168
					if false {
					} else if z.HasExtensions() && z.EncExt(yy167) {
					} else if yym168 {
						z.EncBinaryMarshal(yy167)
					} else if !yym168 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy167)
					} else {
						z.EncFallback(yy167)
					}
				}
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq159[3] {
					yy170 := &x.LastTransitionTime
					yym171 := z.EncBinary()
					_ = yym171
					if false {
					} else if z.HasExtensions() && z.EncExt(yy170) {
					} else if yym171 {
						z.EncBinaryMarshal(yy170)
					} else if !yym171 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy170)
					} else {
						z.EncFallback(yy170)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq159[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy172 := &x.LastTransitionTime
					yym173 := z.EncBinary()
					_ = yym173
					if false {
					} else if z.HasExtensions() && z.EncExt(yy172) {
					} else if yym173 {
						z.EncBinaryMarshal(yy172)
					} else if !yym173 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy172)
					} else {
						z.EncFallback(yy172)
					}
				}
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq159[4] {
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq159[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq159[5] {
					yym178 := z.EncBinary()
					_ = yym178
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq159[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym179 := z.EncBinary()
					_ = yym179
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr159 || yy2arr159 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym180 := z.DecBinary()
	_ = yym180
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct181 := r.ContainerType()
		if yyct181 == codecSelferValueTypeMap1234 {
			yyl181 := r.ReadMapStart()
			if yyl181 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl181, d)
			}
		} else if yyct181 == codecSelferValueTypeArray1234 {
			yyl181 := r.ReadArrayStart()
			if yyl181 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl181, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys182Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys182Slc
	var yyhl182 bool = l >= 0
	for yyj182 := 0; ; yyj182++ {
		if yyhl182 {
			if yyj182 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys182Slc = r.DecodeBytes(yys182Slc, true, true)
		yys182 := string(yys182Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys182 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv185 := &x.LastProbeTime
				yym186 := z.DecBinary()
				_ = yym186
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv185) {
				} else if yym186 {
					z.DecBinaryUnmarshal(yyv185)
				} else if !yym186 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv185)
				} else {
					z.DecFallback(yyv185, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv187 := &x.LastTransitionTime
				yym188 := z.DecBinary()
				_ = yym188
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv187) {
				} else if yym188 {
					z.DecBinaryUnmarshal(yyv187)
				} else if !yym188 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv187)
				} else {
					z.DecFallback(yyv187, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys182)
		} // end switch yys182
	} // end for yyj182
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj191 int
	var yyb191 bool
	var yyhl191 bool = l >= 0
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv194 := &x.LastProbeTime
		yym195 := z.DecBinary()
		_ = yym195
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv194) {
		} else if yym195 {
			z.DecBinaryUnmarshal(yyv194)
		} else if !yym195 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv194)
		} else {
			z.DecFallback(yyv194, false)
		}
	}
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv196 := &x.LastTransitionTime
		yym197 := z.DecBinary()
		_ = yym197
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv196) {
		} else if yym197 {
			z.DecBinaryUnmarshal(yyv196)
		} else if !yym197 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv196)
		} else {
			z.DecFallback(yyv196, false)
		}
	}
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj191++
	if yyhl191 {
		yyb191 = yyj191 > l
	} else {
		yyb191 = r.CheckBreak()
	}
	if yyb191 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj191++
		if yyhl191 {
			yyb191 = yyj191 > l
		} else {
			yyb191 = r.CheckBreak()
		}
		if yyb191 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj191-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym200 := z.EncBinary()
		_ = yym200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep201 := !z.EncBinary()
			yy2arr201 := z.EncBasicHandle().StructToArray
			var yyq201 [2]bool
			_, _, _ = yysep201, yyq201, yy2arr201
			const yyr201 bool = false
			yyq201[0] = len(x.MatchLabels) != 0
			yyq201[1] = len(x.MatchExpressions) != 0
			var yynn201 int
			if yyr201 || yy2arr201 {
				r.EncodeArrayStart(2)
			} else {
				yynn201 = 0
				for _, b := range yyq201 {
					if b {
						yynn201++
					}
				}
				r.EncodeMapStart(yynn201)
				yynn201 = 0
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[0] {
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym203 := z.EncBinary()
						_ = yym203
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchLabels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym204 := z.EncBinary()
						_ = yym204
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[1] {
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym206 := z.EncBinary()
						_ = yym206
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym207 := z.EncBinary()
						_ = yym207
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym208 := z.DecBinary()
	_ = yym208
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct209 := r.ContainerType()
		if yyct209 == codecSelferValueTypeMap1234 {
			yyl209 := r.ReadMapStart()
			if yyl209 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl209, d)
			}
		} else if yyct209 == codecSelferValueTypeArray1234 {
			yyl209 := r.ReadArrayStart()
			if yyl209 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl209, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys210Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys210Slc
	var yyhl210 bool = l >= 0
	for yyj210 := 0; ; yyj210++ {
		if yyhl210 {
			if yyj210 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys210Slc = r.DecodeBytes(yys210Slc, true, true)
		yys210 := string(yys210Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys210 {
		case "matchLabels":
			if r.TryDecodeAsNil() {
				x.MatchLabels = nil
			} else {
				yyv211 := &x.MatchLabels
				yym212 := z.DecBinary()
				_ = yym212
				if false {
				} else {
					z.F.DecMapStringStringX(yyv211, false, d)
				}
			}
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv213 := &x.MatchExpressions
				yym214 := z.DecBinary()
				_ = yym214
				if false {
				} else {
					h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv213), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys210)
		} // end switch yys210
	} // end for yyj210
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj215 int
	var yyb215 bool
	var yyhl215 bool = l >= 0
	yyj215++
	if yyhl215 {
		yyb215 = yyj215 > l
	} else {
		yyb215 = r.CheckBreak()
	}
	if yyb215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchLabels = nil
	} else {
		yyv216 := &x.MatchLabels
		yym217 := z.DecBinary()
		_ = yym217
		if false {
		} else {
			z.F.DecMapStringStringX(yyv216, false, d)
		}
	}
	yyj215++
	if yyhl215 {
		yyb215 = yyj215 > l
	} else {
		yyb215 = r.CheckBreak()
	}
	if yyb215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv218 := &x.MatchExpressions
		yym219 := z.DecBinary()
		_ = yym219
		if false {
		} else {
			h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv218), d)
		}
	}
	for {
		yyj215++
		if yyhl215 {
			yyb215 = yyj215 > l
		} else {
			yyb215 = r.CheckBreak()
		}
		if yyb215 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj215-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym220 := z.EncBinary()
		_ = yym220
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep221 := !z.EncBinary()
			yy2arr221 := z.EncBasicHandle().StructToArray
			var yyq221 [3]bool
			_, _, _ = yysep221, yyq221, yy2arr221
			const yyr221 bool = false
			yyq221[2] = len(x.Values) != 0
			var yynn221 int
			if yyr221 || yy2arr221 {
				r.EncodeArrayStart(3)
			} else {
				yynn221 = 2
				for _, b := range yyq221 {
					if b {
						yynn221++
					}
				}
				r.EncodeMapStart(yynn221)
				yynn221 = 0
			}
			if yyr221 || yy2arr221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym223 := z.EncBinary()
				_ = yym223
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr221 || yy2arr221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr221 || yy2arr221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq221[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym227 := z.EncBinary()
						_ = yym227
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq221[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym228 := z.EncBinary()
						_ = yym228
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr221 || yy2arr221 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym229 := z.DecBinary()
	_ = yym229
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct230 := r.ContainerType()
		if yyct230 == codecSelferValueTypeMap1234 {
			yyl230 := r.ReadMapStart()
			if yyl230 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl230, d)
			}
		} else if yyct230 == codecSelferValueTypeArray1234 {
			yyl230 := r.ReadArrayStart()
			if yyl230 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl230, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys231Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys231Slc
	var yyhl231 bool = l >= 0
	for yyj231 := 0; ; yyj231++ {
		if yyhl231 {
			if yyj231 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys231Slc = r.DecodeBytes(yys231Slc, true, true)
		yys231 := string(yys231Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys231 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = LabelSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv234 := &x.Values
				yym235 := z.DecBinary()
				_ = yym235
				if false {
				} else {
					z.F.DecSliceStringX(yyv234, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys231)
		} // end switch yys231
	} // end for yyj231
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj236 int
	var yyb236 bool
	var yyhl236 bool = l >= 0
	yyj236++
	if yyhl236 {
		yyb236 = yyj236 > l
	} else {
		yyb236 = r.CheckBreak()
	}
	if yyb236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj236++
	if yyhl236 {
		yyb236 = yyj236 > l
	} else {
		yyb236 = r.CheckBreak()
	}
	if yyb236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = LabelSelectorOperator(r.DecodeString())
	}
	yyj236++
	if yyhl236 {
		yyb236 = yyj236 > l
	} else {
		yyb236 = r.CheckBreak()
	}
	if yyb236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv239 := &x.Values
		yym240 := z.DecBinary()
		_ = yym240
		if false {
		} else {
			z.F.DecSliceStringX(yyv239, false, d)
		}
	}
	for {
		yyj236++
		if yyhl236 {
			yyb236 = yyj236 > l
		} else {
			yyb236 = r.CheckBreak()
		}
		if yyb236 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj236-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LabelSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym241 := z.EncBinary()
	_ = yym241
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LabelSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym242 := z.DecBinary()
	_ = yym242
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv243 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy244 := &yyv243
		yy244.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv245 := *v
	yyh245, yyl245 := z.DecSliceHelperStart()
	var yyc245 bool
	if yyl245 == 0 {
		if yyv245 == nil {
			yyv245 = []Job{}
			yyc245 = true
		} else if len(yyv245) != 0 {
			yyv245 = yyv245[:0]
			yyc245 = true
		}
	} else if yyl245 > 0 {
		var yyrr245, yyrl245 int
		var yyrt245 bool
		if yyl245 > cap(yyv245) {

			yyrg245 := len(yyv245) > 0
			yyv2245 := yyv245
			yyrl245, yyrt245 = z.DecInferLen(yyl245, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt245 {
				if yyrl245 <= cap(yyv245) {
					yyv245 = yyv245[:yyrl245]
				} else {
					yyv245 = make([]Job, yyrl245)
				}
			} else {
				yyv245 = make([]Job, yyrl245)
			}
			yyc245 = true
			yyrr245 = len(yyv245)
			if yyrg245 {
				copy(yyv245, yyv2245)
			}
		} else if yyl245 != len(yyv245) {
			yyv245 = yyv245[:yyl245]
			yyc245 = true
		}
		yyj245 := 0
		for ; yyj245 < yyrr245; yyj245++ {
			yyh245.ElemContainerState(yyj245)
			if r.TryDecodeAsNil() {
				yyv245[yyj245] = Job{}
			} else {
				yyv246 := &yyv245[yyj245]
				yyv246.CodecDecodeSelf(d)
			}

		}
		if yyrt245 {
			for ; yyj245 < yyl245; yyj245++ {
				yyv245 = append(yyv245, Job{})
				yyh245.ElemContainerState(yyj245)
				if r.TryDecodeAsNil() {
					yyv245[yyj245] = Job{}
				} else {
					yyv247 := &yyv245[yyj245]
					yyv247.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj245 := 0
		for ; !r.CheckBreak(); yyj245++ {

			if yyj245 >= len(yyv245) {
				yyv245 = append(yyv245, Job{}) // var yyz245 Job
				yyc245 = true
			}
			yyh245.ElemContainerState(yyj245)
			if yyj245 < len(yyv245) {
				if r.TryDecodeAsNil() {
					yyv245[yyj245] = Job{}
				} else {
					yyv248 := &yyv245[yyj245]
					yyv248.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj245 < len(yyv245) {
			yyv245 = yyv245[:yyj245]
			yyc245 = true
		} else if yyj245 == 0 && yyv245 == nil {
			yyv245 = []Job{}
			yyc245 = true
		}
	}
	yyh245.End()
	if yyc245 {
		*v = yyv245
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv249 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy250 := &yyv249
		yy250.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv251 := *v
	yyh251, yyl251 := z.DecSliceHelperStart()
	var yyc251 bool
	if yyl251 == 0 {
		if yyv251 == nil {
			yyv251 = []JobCondition{}
			yyc251 = true
		} else if len(yyv251) != 0 {
			yyv251 = yyv251[:0]
			yyc251 = true
		}
	} else if yyl251 > 0 {
		var yyrr251, yyrl251 int
		var yyrt251 bool
		if yyl251 > cap(yyv251) {

			yyrg251 := len(yyv251) > 0
			yyv2251 := yyv251
			yyrl251, yyrt251 = z.DecInferLen(yyl251, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt251 {
				if yyrl251 <= cap(yyv251) {
					yyv251 = yyv251[:yyrl251]
				} else {
					yyv251 = make([]JobCondition, yyrl251)
				}
			} else {
				yyv251 = make([]JobCondition, yyrl251)
			}
			yyc251 = true
			yyrr251 = len(yyv251)
			if yyrg251 {
				copy(yyv251, yyv2251)
			}
		} else if yyl251 != len(yyv251) {
			yyv251 = yyv251[:yyl251]
			yyc251 = true
		}
		yyj251 := 0
		for ; yyj251 < yyrr251; yyj251++ {
			yyh251.ElemContainerState(yyj251)
			if r.TryDecodeAsNil() {
				yyv251[yyj251] = JobCondition{}
			} else {
				yyv252 := &yyv251[yyj251]
				yyv252.CodecDecodeSelf(d)
			}

		}
		if yyrt251 {
			for ; yyj251 < yyl251; yyj251++ {
				yyv251 = append(yyv251, JobCondition{})
				yyh251.ElemContainerState(yyj251)
				if r.TryDecodeAsNil() {
					yyv251[yyj251] = JobCondition{}
				} else {
					yyv253 := &yyv251[yyj251]
					yyv253.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj251 := 0
		for ; !r.CheckBreak(); yyj251++ {

			if yyj251 >= len(yyv251) {
				yyv251 = append(yyv251, JobCondition{}) // var yyz251 JobCondition
				yyc251 = true
			}
			yyh251.ElemContainerState(yyj251)
			if yyj251 < len(yyv251) {
				if r.TryDecodeAsNil() {
					yyv251[yyj251] = JobCondition{}
				} else {
					yyv254 := &yyv251[yyj251]
					yyv254.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj251 < len(yyv251) {
			yyv251 = yyv251[:yyj251]
			yyc251 = true
		} else if yyj251 == 0 && yyv251 == nil {
			yyv251 = []JobCondition{}
			yyc251 = true
		}
	}
	yyh251.End()
	if yyc251 {
		*v = yyv251
	}
}

func (x codecSelfer1234) encSliceLabelSelectorRequirement(v []LabelSelectorRequirement, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv255 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy256 := &yyv255
		yy256.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceLabelSelectorRequirement(v *[]LabelSelectorRequirement, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv257 := *v
	yyh257, yyl257 := z.DecSliceHelperStart()
	var yyc257 bool
	if yyl257 == 0 {
		if yyv257 == nil {
			yyv257 = []LabelSelectorRequirement{}
			yyc257 = true
		} else if len(yyv257) != 0 {
			yyv257 = yyv257[:0]
			yyc257 = true
		}
	} else if yyl257 > 0 {
		var yyrr257, yyrl257 int
		var yyrt257 bool
		if yyl257 > cap(yyv257) {

			yyrg257 := len(yyv257) > 0
			yyv2257 := yyv257
			yyrl257, yyrt257 = z.DecInferLen(yyl257, z.DecBasicHandle().MaxInitLen, 56)
			if yyrt257 {
				if yyrl257 <= cap(yyv257) {
					yyv257 = yyv257[:yyrl257]
				} else {
					yyv257 = make([]LabelSelectorRequirement, yyrl257)
				}
			} else {
				yyv257 = make([]LabelSelectorRequirement, yyrl257)
			}
			yyc257 = true
			yyrr257 = len(yyv257)
			if yyrg257 {
				copy(yyv257, yyv2257)
			}
		} else if yyl257 != len(yyv257) {
			yyv257 = yyv257[:yyl257]
			yyc257 = true
		}
		yyj257 := 0
		for ; yyj257 < yyrr257; yyj257++ {
			yyh257.ElemContainerState(yyj257)
			if r.TryDecodeAsNil() {
				yyv257[yyj257] = LabelSelectorRequirement{}
			} else {
				yyv258 := &yyv257[yyj257]
				yyv258.CodecDecodeSelf(d)
			}

		}
		if yyrt257 {
			for ; yyj257 < yyl257; yyj257++ {
				yyv257 = append(yyv257, LabelSelectorRequirement{})
				yyh257.ElemContainerState(yyj257)
				if r.TryDecodeAsNil() {
					yyv257[yyj257] = LabelSelectorRequirement{}
				} else {
					yyv259 := &yyv257[yyj257]
					yyv259.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj257 := 0
		for ; !r.CheckBreak(); yyj257++ {

			if yyj257 >= len(yyv257) {
				yyv257 = append(yyv257, LabelSelectorRequirement{}) // var yyz257 LabelSelectorRequirement
				yyc257 = true
			}
			yyh257.ElemContainerState(yyj257)
			if yyj257 < len(yyv257) {
				if r.TryDecodeAsNil() {
					yyv257[yyj257] = LabelSelectorRequirement{}
				} else {
					yyv260 := &yyv257[yyj257]
					yyv260.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj257 < len(yyv257) {
			yyv257 = yyv257[:yyj257]
			yyc257 = true
		} else if yyj257 == 0 && yyv257 == nil {
			yyv257 = []LabelSelectorRequirement{}
			yyc257 = true
		}
	}
	yyh257.End()
	if yyc257 {
		*v = yyv257
	}
}
