// +build !ignore_autogenerated

/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package v1

import (
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
	types "k8s.io/kubernetes/pkg/types"
	reflect "reflect"
)

func init() {
	SchemeBuilder.Register(RegisterDeepCopies)
}

// RegisterDeepCopies adds deep-copy functions to the given scheme. Public
// to allow building arbitrary schemes.
func RegisterDeepCopies(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedDeepCopyFuncs(
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_AWSElasticBlockStoreVolumeSource, InType: reflect.TypeOf(&AWSElasticBlockStoreVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Affinity, InType: reflect.TypeOf(&Affinity{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_AttachedVolume, InType: reflect.TypeOf(&AttachedVolume{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_AvoidPods, InType: reflect.TypeOf(&AvoidPods{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_AzureDiskVolumeSource, InType: reflect.TypeOf(&AzureDiskVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_AzureFileVolumeSource, InType: reflect.TypeOf(&AzureFileVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Binding, InType: reflect.TypeOf(&Binding{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Capabilities, InType: reflect.TypeOf(&Capabilities{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_CephFSVolumeSource, InType: reflect.TypeOf(&CephFSVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_CinderVolumeSource, InType: reflect.TypeOf(&CinderVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ComponentCondition, InType: reflect.TypeOf(&ComponentCondition{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ComponentStatus, InType: reflect.TypeOf(&ComponentStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ComponentStatusList, InType: reflect.TypeOf(&ComponentStatusList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ConfigMap, InType: reflect.TypeOf(&ConfigMap{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ConfigMapKeySelector, InType: reflect.TypeOf(&ConfigMapKeySelector{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ConfigMapList, InType: reflect.TypeOf(&ConfigMapList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ConfigMapVolumeSource, InType: reflect.TypeOf(&ConfigMapVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Container, InType: reflect.TypeOf(&Container{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerImage, InType: reflect.TypeOf(&ContainerImage{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerPort, InType: reflect.TypeOf(&ContainerPort{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerState, InType: reflect.TypeOf(&ContainerState{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerStateRunning, InType: reflect.TypeOf(&ContainerStateRunning{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerStateTerminated, InType: reflect.TypeOf(&ContainerStateTerminated{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerStateWaiting, InType: reflect.TypeOf(&ContainerStateWaiting{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ContainerStatus, InType: reflect.TypeOf(&ContainerStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DaemonEndpoint, InType: reflect.TypeOf(&DaemonEndpoint{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DeleteOptions, InType: reflect.TypeOf(&DeleteOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DeprecatedDownwardAPIVolumeFile, InType: reflect.TypeOf(&DeprecatedDownwardAPIVolumeFile{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DeprecatedDownwardAPIVolumeSource, InType: reflect.TypeOf(&DeprecatedDownwardAPIVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DownwardAPIVolumeFile, InType: reflect.TypeOf(&DownwardAPIVolumeFile{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_DownwardAPIVolumeSource, InType: reflect.TypeOf(&DownwardAPIVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EmptyDirVolumeSource, InType: reflect.TypeOf(&EmptyDirVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EndpointAddress, InType: reflect.TypeOf(&EndpointAddress{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EndpointPort, InType: reflect.TypeOf(&EndpointPort{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EndpointSubset, InType: reflect.TypeOf(&EndpointSubset{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Endpoints, InType: reflect.TypeOf(&Endpoints{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EndpointsList, InType: reflect.TypeOf(&EndpointsList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EnvVar, InType: reflect.TypeOf(&EnvVar{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EnvVarSource, InType: reflect.TypeOf(&EnvVarSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Event, InType: reflect.TypeOf(&Event{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EventList, InType: reflect.TypeOf(&EventList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_EventSource, InType: reflect.TypeOf(&EventSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ExecAction, InType: reflect.TypeOf(&ExecAction{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ExportOptions, InType: reflect.TypeOf(&ExportOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_FCVolumeSource, InType: reflect.TypeOf(&FCVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_FSGroupStrategyOptions, InType: reflect.TypeOf(&FSGroupStrategyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_FlexVolumeSource, InType: reflect.TypeOf(&FlexVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_FlockerVolumeSource, InType: reflect.TypeOf(&FlockerVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_GCEPersistentDiskVolumeSource, InType: reflect.TypeOf(&GCEPersistentDiskVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_GitRepoVolumeSource, InType: reflect.TypeOf(&GitRepoVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_GlusterfsVolumeSource, InType: reflect.TypeOf(&GlusterfsVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_HTTPGetAction, InType: reflect.TypeOf(&HTTPGetAction{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_HTTPHeader, InType: reflect.TypeOf(&HTTPHeader{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Handler, InType: reflect.TypeOf(&Handler{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_HostPathVolumeSource, InType: reflect.TypeOf(&HostPathVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_IDRange, InType: reflect.TypeOf(&IDRange{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ISCSIVolumeSource, InType: reflect.TypeOf(&ISCSIVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_KeyToPath, InType: reflect.TypeOf(&KeyToPath{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Lifecycle, InType: reflect.TypeOf(&Lifecycle{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LimitRange, InType: reflect.TypeOf(&LimitRange{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LimitRangeItem, InType: reflect.TypeOf(&LimitRangeItem{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LimitRangeList, InType: reflect.TypeOf(&LimitRangeList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LimitRangeSpec, InType: reflect.TypeOf(&LimitRangeSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_List, InType: reflect.TypeOf(&List{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ListOptions, InType: reflect.TypeOf(&ListOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LoadBalancerIngress, InType: reflect.TypeOf(&LoadBalancerIngress{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LoadBalancerStatus, InType: reflect.TypeOf(&LoadBalancerStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_LocalObjectReference, InType: reflect.TypeOf(&LocalObjectReference{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NFSVolumeSource, InType: reflect.TypeOf(&NFSVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Namespace, InType: reflect.TypeOf(&Namespace{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NamespaceList, InType: reflect.TypeOf(&NamespaceList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NamespaceSpec, InType: reflect.TypeOf(&NamespaceSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NamespaceStatus, InType: reflect.TypeOf(&NamespaceStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Node, InType: reflect.TypeOf(&Node{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeAddress, InType: reflect.TypeOf(&NodeAddress{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeAffinity, InType: reflect.TypeOf(&NodeAffinity{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeCondition, InType: reflect.TypeOf(&NodeCondition{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeDaemonEndpoints, InType: reflect.TypeOf(&NodeDaemonEndpoints{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeList, InType: reflect.TypeOf(&NodeList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeProxyOptions, InType: reflect.TypeOf(&NodeProxyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeSelector, InType: reflect.TypeOf(&NodeSelector{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeSelectorRequirement, InType: reflect.TypeOf(&NodeSelectorRequirement{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeSelectorTerm, InType: reflect.TypeOf(&NodeSelectorTerm{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeSpec, InType: reflect.TypeOf(&NodeSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeStatus, InType: reflect.TypeOf(&NodeStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_NodeSystemInfo, InType: reflect.TypeOf(&NodeSystemInfo{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ObjectFieldSelector, InType: reflect.TypeOf(&ObjectFieldSelector{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ObjectMeta, InType: reflect.TypeOf(&ObjectMeta{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ObjectReference, InType: reflect.TypeOf(&ObjectReference{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_OwnerReference, InType: reflect.TypeOf(&OwnerReference{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolume, InType: reflect.TypeOf(&PersistentVolume{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeClaim, InType: reflect.TypeOf(&PersistentVolumeClaim{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeClaimList, InType: reflect.TypeOf(&PersistentVolumeClaimList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeClaimSpec, InType: reflect.TypeOf(&PersistentVolumeClaimSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeClaimStatus, InType: reflect.TypeOf(&PersistentVolumeClaimStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeClaimVolumeSource, InType: reflect.TypeOf(&PersistentVolumeClaimVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeList, InType: reflect.TypeOf(&PersistentVolumeList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeSource, InType: reflect.TypeOf(&PersistentVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeSpec, InType: reflect.TypeOf(&PersistentVolumeSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PersistentVolumeStatus, InType: reflect.TypeOf(&PersistentVolumeStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Pod, InType: reflect.TypeOf(&Pod{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodAffinity, InType: reflect.TypeOf(&PodAffinity{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodAffinityTerm, InType: reflect.TypeOf(&PodAffinityTerm{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodAntiAffinity, InType: reflect.TypeOf(&PodAntiAffinity{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodAttachOptions, InType: reflect.TypeOf(&PodAttachOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodCondition, InType: reflect.TypeOf(&PodCondition{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodExecOptions, InType: reflect.TypeOf(&PodExecOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodList, InType: reflect.TypeOf(&PodList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodLogOptions, InType: reflect.TypeOf(&PodLogOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodProxyOptions, InType: reflect.TypeOf(&PodProxyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodSecurityContext, InType: reflect.TypeOf(&PodSecurityContext{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodSignature, InType: reflect.TypeOf(&PodSignature{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodSpec, InType: reflect.TypeOf(&PodSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodStatus, InType: reflect.TypeOf(&PodStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodStatusResult, InType: reflect.TypeOf(&PodStatusResult{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodTemplate, InType: reflect.TypeOf(&PodTemplate{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodTemplateList, InType: reflect.TypeOf(&PodTemplateList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PodTemplateSpec, InType: reflect.TypeOf(&PodTemplateSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Preconditions, InType: reflect.TypeOf(&Preconditions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PreferAvoidPodsEntry, InType: reflect.TypeOf(&PreferAvoidPodsEntry{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_PreferredSchedulingTerm, InType: reflect.TypeOf(&PreferredSchedulingTerm{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Probe, InType: reflect.TypeOf(&Probe{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_QuobyteVolumeSource, InType: reflect.TypeOf(&QuobyteVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_RBDVolumeSource, InType: reflect.TypeOf(&RBDVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_RangeAllocation, InType: reflect.TypeOf(&RangeAllocation{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ReplicationController, InType: reflect.TypeOf(&ReplicationController{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ReplicationControllerList, InType: reflect.TypeOf(&ReplicationControllerList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ReplicationControllerSpec, InType: reflect.TypeOf(&ReplicationControllerSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ReplicationControllerStatus, InType: reflect.TypeOf(&ReplicationControllerStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceFieldSelector, InType: reflect.TypeOf(&ResourceFieldSelector{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceQuota, InType: reflect.TypeOf(&ResourceQuota{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceQuotaList, InType: reflect.TypeOf(&ResourceQuotaList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceQuotaSpec, InType: reflect.TypeOf(&ResourceQuotaSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceQuotaStatus, InType: reflect.TypeOf(&ResourceQuotaStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ResourceRequirements, InType: reflect.TypeOf(&ResourceRequirements{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_RunAsUserStrategyOptions, InType: reflect.TypeOf(&RunAsUserStrategyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SELinuxContextStrategyOptions, InType: reflect.TypeOf(&SELinuxContextStrategyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SELinuxOptions, InType: reflect.TypeOf(&SELinuxOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Secret, InType: reflect.TypeOf(&Secret{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecretKeySelector, InType: reflect.TypeOf(&SecretKeySelector{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecretList, InType: reflect.TypeOf(&SecretList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecretVolumeSource, InType: reflect.TypeOf(&SecretVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecurityContext, InType: reflect.TypeOf(&SecurityContext{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecurityContextConstraints, InType: reflect.TypeOf(&SecurityContextConstraints{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SecurityContextConstraintsList, InType: reflect.TypeOf(&SecurityContextConstraintsList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SerializedReference, InType: reflect.TypeOf(&SerializedReference{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Service, InType: reflect.TypeOf(&Service{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceAccount, InType: reflect.TypeOf(&ServiceAccount{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceAccountList, InType: reflect.TypeOf(&ServiceAccountList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceList, InType: reflect.TypeOf(&ServiceList{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServicePort, InType: reflect.TypeOf(&ServicePort{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceProxyOptions, InType: reflect.TypeOf(&ServiceProxyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceSpec, InType: reflect.TypeOf(&ServiceSpec{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_ServiceStatus, InType: reflect.TypeOf(&ServiceStatus{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_SupplementalGroupsStrategyOptions, InType: reflect.TypeOf(&SupplementalGroupsStrategyOptions{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_TCPSocketAction, InType: reflect.TypeOf(&TCPSocketAction{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Taint, InType: reflect.TypeOf(&Taint{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Toleration, InType: reflect.TypeOf(&Toleration{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_Volume, InType: reflect.TypeOf(&Volume{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_VolumeMount, InType: reflect.TypeOf(&VolumeMount{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_VolumeSource, InType: reflect.TypeOf(&VolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_VsphereVirtualDiskVolumeSource, InType: reflect.TypeOf(&VsphereVirtualDiskVolumeSource{})},
		conversion.GeneratedDeepCopyFunc{Fn: DeepCopy_v1_WeightedPodAffinityTerm, InType: reflect.TypeOf(&WeightedPodAffinityTerm{})},
	)
}

func DeepCopy_v1_AWSElasticBlockStoreVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*AWSElasticBlockStoreVolumeSource)
		out := out.(*AWSElasticBlockStoreVolumeSource)
		out.VolumeID = in.VolumeID
		out.FSType = in.FSType
		out.Partition = in.Partition
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_Affinity(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Affinity)
		out := out.(*Affinity)
		if in.NodeAffinity != nil {
			in, out := &in.NodeAffinity, &out.NodeAffinity
			*out = new(NodeAffinity)
			if err := DeepCopy_v1_NodeAffinity(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.NodeAffinity = nil
		}
		if in.PodAffinity != nil {
			in, out := &in.PodAffinity, &out.PodAffinity
			*out = new(PodAffinity)
			if err := DeepCopy_v1_PodAffinity(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.PodAffinity = nil
		}
		if in.PodAntiAffinity != nil {
			in, out := &in.PodAntiAffinity, &out.PodAntiAffinity
			*out = new(PodAntiAffinity)
			if err := DeepCopy_v1_PodAntiAffinity(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.PodAntiAffinity = nil
		}
		return nil
	}
}

func DeepCopy_v1_AttachedVolume(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*AttachedVolume)
		out := out.(*AttachedVolume)
		out.Name = in.Name
		out.DevicePath = in.DevicePath
		return nil
	}
}

func DeepCopy_v1_AvoidPods(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*AvoidPods)
		out := out.(*AvoidPods)
		if in.PreferAvoidPods != nil {
			in, out := &in.PreferAvoidPods, &out.PreferAvoidPods
			*out = make([]PreferAvoidPodsEntry, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PreferAvoidPodsEntry(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.PreferAvoidPods = nil
		}
		return nil
	}
}

func DeepCopy_v1_AzureDiskVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*AzureDiskVolumeSource)
		out := out.(*AzureDiskVolumeSource)
		out.DiskName = in.DiskName
		out.DataDiskURI = in.DataDiskURI
		if in.CachingMode != nil {
			in, out := &in.CachingMode, &out.CachingMode
			*out = new(AzureDataDiskCachingMode)
			**out = **in
		} else {
			out.CachingMode = nil
		}
		if in.FSType != nil {
			in, out := &in.FSType, &out.FSType
			*out = new(string)
			**out = **in
		} else {
			out.FSType = nil
		}
		if in.ReadOnly != nil {
			in, out := &in.ReadOnly, &out.ReadOnly
			*out = new(bool)
			**out = **in
		} else {
			out.ReadOnly = nil
		}
		return nil
	}
}

func DeepCopy_v1_AzureFileVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*AzureFileVolumeSource)
		out := out.(*AzureFileVolumeSource)
		out.SecretName = in.SecretName
		out.ShareName = in.ShareName
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_Binding(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Binding)
		out := out.(*Binding)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		out.Target = in.Target
		return nil
	}
}

func DeepCopy_v1_Capabilities(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Capabilities)
		out := out.(*Capabilities)
		if in.Add != nil {
			in, out := &in.Add, &out.Add
			*out = make([]Capability, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Add = nil
		}
		if in.Drop != nil {
			in, out := &in.Drop, &out.Drop
			*out = make([]Capability, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Drop = nil
		}
		return nil
	}
}

func DeepCopy_v1_CephFSVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*CephFSVolumeSource)
		out := out.(*CephFSVolumeSource)
		if in.Monitors != nil {
			in, out := &in.Monitors, &out.Monitors
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Monitors = nil
		}
		out.Path = in.Path
		out.User = in.User
		out.SecretFile = in.SecretFile
		if in.SecretRef != nil {
			in, out := &in.SecretRef, &out.SecretRef
			*out = new(LocalObjectReference)
			**out = **in
		} else {
			out.SecretRef = nil
		}
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_CinderVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*CinderVolumeSource)
		out := out.(*CinderVolumeSource)
		out.VolumeID = in.VolumeID
		out.FSType = in.FSType
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_ComponentCondition(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ComponentCondition)
		out := out.(*ComponentCondition)
		out.Type = in.Type
		out.Status = in.Status
		out.Message = in.Message
		out.Error = in.Error
		return nil
	}
}

func DeepCopy_v1_ComponentStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ComponentStatus)
		out := out.(*ComponentStatus)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Conditions != nil {
			in, out := &in.Conditions, &out.Conditions
			*out = make([]ComponentCondition, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Conditions = nil
		}
		return nil
	}
}

func DeepCopy_v1_ComponentStatusList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ComponentStatusList)
		out := out.(*ComponentStatusList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]ComponentStatus, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ComponentStatus(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ConfigMap(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ConfigMap)
		out := out.(*ConfigMap)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Data != nil {
			in, out := &in.Data, &out.Data
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Data = nil
		}
		return nil
	}
}

func DeepCopy_v1_ConfigMapKeySelector(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ConfigMapKeySelector)
		out := out.(*ConfigMapKeySelector)
		out.LocalObjectReference = in.LocalObjectReference
		out.Key = in.Key
		return nil
	}
}

func DeepCopy_v1_ConfigMapList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ConfigMapList)
		out := out.(*ConfigMapList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]ConfigMap, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ConfigMap(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ConfigMapVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ConfigMapVolumeSource)
		out := out.(*ConfigMapVolumeSource)
		out.LocalObjectReference = in.LocalObjectReference
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]KeyToPath, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_KeyToPath(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		if in.DefaultMode != nil {
			in, out := &in.DefaultMode, &out.DefaultMode
			*out = new(int32)
			**out = **in
		} else {
			out.DefaultMode = nil
		}
		return nil
	}
}

func DeepCopy_v1_Container(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Container)
		out := out.(*Container)
		out.Name = in.Name
		out.Image = in.Image
		if in.Command != nil {
			in, out := &in.Command, &out.Command
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Command = nil
		}
		if in.Args != nil {
			in, out := &in.Args, &out.Args
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Args = nil
		}
		out.WorkingDir = in.WorkingDir
		if in.Ports != nil {
			in, out := &in.Ports, &out.Ports
			*out = make([]ContainerPort, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ports = nil
		}
		if in.Env != nil {
			in, out := &in.Env, &out.Env
			*out = make([]EnvVar, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_EnvVar(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Env = nil
		}
		if err := DeepCopy_v1_ResourceRequirements(&in.Resources, &out.Resources, c); err != nil {
			return err
		}
		if in.VolumeMounts != nil {
			in, out := &in.VolumeMounts, &out.VolumeMounts
			*out = make([]VolumeMount, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.VolumeMounts = nil
		}
		if in.LivenessProbe != nil {
			in, out := &in.LivenessProbe, &out.LivenessProbe
			*out = new(Probe)
			if err := DeepCopy_v1_Probe(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.LivenessProbe = nil
		}
		if in.ReadinessProbe != nil {
			in, out := &in.ReadinessProbe, &out.ReadinessProbe
			*out = new(Probe)
			if err := DeepCopy_v1_Probe(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ReadinessProbe = nil
		}
		if in.Lifecycle != nil {
			in, out := &in.Lifecycle, &out.Lifecycle
			*out = new(Lifecycle)
			if err := DeepCopy_v1_Lifecycle(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Lifecycle = nil
		}
		out.TerminationMessagePath = in.TerminationMessagePath
		out.ImagePullPolicy = in.ImagePullPolicy
		if in.SecurityContext != nil {
			in, out := &in.SecurityContext, &out.SecurityContext
			*out = new(SecurityContext)
			if err := DeepCopy_v1_SecurityContext(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.SecurityContext = nil
		}
		out.Stdin = in.Stdin
		out.StdinOnce = in.StdinOnce
		out.TTY = in.TTY
		return nil
	}
}

func DeepCopy_v1_ContainerImage(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerImage)
		out := out.(*ContainerImage)
		if in.Names != nil {
			in, out := &in.Names, &out.Names
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Names = nil
		}
		out.SizeBytes = in.SizeBytes
		return nil
	}
}

func DeepCopy_v1_ContainerPort(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerPort)
		out := out.(*ContainerPort)
		out.Name = in.Name
		out.HostPort = in.HostPort
		out.ContainerPort = in.ContainerPort
		out.Protocol = in.Protocol
		out.HostIP = in.HostIP
		return nil
	}
}

func DeepCopy_v1_ContainerState(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerState)
		out := out.(*ContainerState)
		if in.Waiting != nil {
			in, out := &in.Waiting, &out.Waiting
			*out = new(ContainerStateWaiting)
			**out = **in
		} else {
			out.Waiting = nil
		}
		if in.Running != nil {
			in, out := &in.Running, &out.Running
			*out = new(ContainerStateRunning)
			if err := DeepCopy_v1_ContainerStateRunning(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Running = nil
		}
		if in.Terminated != nil {
			in, out := &in.Terminated, &out.Terminated
			*out = new(ContainerStateTerminated)
			if err := DeepCopy_v1_ContainerStateTerminated(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Terminated = nil
		}
		return nil
	}
}

func DeepCopy_v1_ContainerStateRunning(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerStateRunning)
		out := out.(*ContainerStateRunning)
		out.StartedAt = in.StartedAt.DeepCopy()
		return nil
	}
}

func DeepCopy_v1_ContainerStateTerminated(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerStateTerminated)
		out := out.(*ContainerStateTerminated)
		out.ExitCode = in.ExitCode
		out.Signal = in.Signal
		out.Reason = in.Reason
		out.Message = in.Message
		out.StartedAt = in.StartedAt.DeepCopy()
		out.FinishedAt = in.FinishedAt.DeepCopy()
		out.ContainerID = in.ContainerID
		return nil
	}
}

func DeepCopy_v1_ContainerStateWaiting(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerStateWaiting)
		out := out.(*ContainerStateWaiting)
		out.Reason = in.Reason
		out.Message = in.Message
		return nil
	}
}

func DeepCopy_v1_ContainerStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ContainerStatus)
		out := out.(*ContainerStatus)
		out.Name = in.Name
		if err := DeepCopy_v1_ContainerState(&in.State, &out.State, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ContainerState(&in.LastTerminationState, &out.LastTerminationState, c); err != nil {
			return err
		}
		out.Ready = in.Ready
		out.RestartCount = in.RestartCount
		out.Image = in.Image
		out.ImageID = in.ImageID
		out.ContainerID = in.ContainerID
		return nil
	}
}

func DeepCopy_v1_DaemonEndpoint(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DaemonEndpoint)
		out := out.(*DaemonEndpoint)
		out.Port = in.Port
		return nil
	}
}

func DeepCopy_v1_DeleteOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DeleteOptions)
		out := out.(*DeleteOptions)
		out.TypeMeta = in.TypeMeta
		if in.GracePeriodSeconds != nil {
			in, out := &in.GracePeriodSeconds, &out.GracePeriodSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.GracePeriodSeconds = nil
		}
		if in.Preconditions != nil {
			in, out := &in.Preconditions, &out.Preconditions
			*out = new(Preconditions)
			if err := DeepCopy_v1_Preconditions(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Preconditions = nil
		}
		if in.OrphanDependents != nil {
			in, out := &in.OrphanDependents, &out.OrphanDependents
			*out = new(bool)
			**out = **in
		} else {
			out.OrphanDependents = nil
		}
		return nil
	}
}

func DeepCopy_v1_DeprecatedDownwardAPIVolumeFile(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DeprecatedDownwardAPIVolumeFile)
		out := out.(*DeprecatedDownwardAPIVolumeFile)
		out.Path = in.Path
		if in.FieldRef != nil {
			in, out := &in.FieldRef, &out.FieldRef
			*out = new(ObjectFieldSelector)
			**out = **in
		} else {
			out.FieldRef = nil
		}
		if in.ResourceFieldRef != nil {
			in, out := &in.ResourceFieldRef, &out.ResourceFieldRef
			*out = new(ResourceFieldSelector)
			if err := DeepCopy_v1_ResourceFieldSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ResourceFieldRef = nil
		}
		if in.Mode != nil {
			in, out := &in.Mode, &out.Mode
			*out = new(int32)
			**out = **in
		} else {
			out.Mode = nil
		}
		return nil
	}
}

func DeepCopy_v1_DeprecatedDownwardAPIVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DeprecatedDownwardAPIVolumeSource)
		out := out.(*DeprecatedDownwardAPIVolumeSource)
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]DeprecatedDownwardAPIVolumeFile, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_DeprecatedDownwardAPIVolumeFile(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		if in.DefaultMode != nil {
			in, out := &in.DefaultMode, &out.DefaultMode
			*out = new(int32)
			**out = **in
		} else {
			out.DefaultMode = nil
		}
		return nil
	}
}

func DeepCopy_v1_DownwardAPIVolumeFile(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DownwardAPIVolumeFile)
		out := out.(*DownwardAPIVolumeFile)
		out.Path = in.Path
		if in.FieldRef != nil {
			in, out := &in.FieldRef, &out.FieldRef
			*out = new(ObjectFieldSelector)
			**out = **in
		} else {
			out.FieldRef = nil
		}
		if in.ResourceFieldRef != nil {
			in, out := &in.ResourceFieldRef, &out.ResourceFieldRef
			*out = new(ResourceFieldSelector)
			if err := DeepCopy_v1_ResourceFieldSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ResourceFieldRef = nil
		}
		if in.Mode != nil {
			in, out := &in.Mode, &out.Mode
			*out = new(int32)
			**out = **in
		} else {
			out.Mode = nil
		}
		return nil
	}
}

func DeepCopy_v1_DownwardAPIVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*DownwardAPIVolumeSource)
		out := out.(*DownwardAPIVolumeSource)
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]DownwardAPIVolumeFile, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_DownwardAPIVolumeFile(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		if in.DefaultMode != nil {
			in, out := &in.DefaultMode, &out.DefaultMode
			*out = new(int32)
			**out = **in
		} else {
			out.DefaultMode = nil
		}
		return nil
	}
}

func DeepCopy_v1_EmptyDirVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EmptyDirVolumeSource)
		out := out.(*EmptyDirVolumeSource)
		out.Medium = in.Medium
		return nil
	}
}

func DeepCopy_v1_EndpointAddress(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EndpointAddress)
		out := out.(*EndpointAddress)
		out.IP = in.IP
		out.Hostname = in.Hostname
		if in.NodeName != nil {
			in, out := &in.NodeName, &out.NodeName
			*out = new(string)
			**out = **in
		} else {
			out.NodeName = nil
		}
		if in.TargetRef != nil {
			in, out := &in.TargetRef, &out.TargetRef
			*out = new(ObjectReference)
			**out = **in
		} else {
			out.TargetRef = nil
		}
		return nil
	}
}

func DeepCopy_v1_EndpointPort(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EndpointPort)
		out := out.(*EndpointPort)
		out.Name = in.Name
		out.Port = in.Port
		out.Protocol = in.Protocol
		return nil
	}
}

func DeepCopy_v1_EndpointSubset(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EndpointSubset)
		out := out.(*EndpointSubset)
		if in.Addresses != nil {
			in, out := &in.Addresses, &out.Addresses
			*out = make([]EndpointAddress, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_EndpointAddress(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Addresses = nil
		}
		if in.NotReadyAddresses != nil {
			in, out := &in.NotReadyAddresses, &out.NotReadyAddresses
			*out = make([]EndpointAddress, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_EndpointAddress(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.NotReadyAddresses = nil
		}
		if in.Ports != nil {
			in, out := &in.Ports, &out.Ports
			*out = make([]EndpointPort, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ports = nil
		}
		return nil
	}
}

func DeepCopy_v1_Endpoints(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Endpoints)
		out := out.(*Endpoints)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Subsets != nil {
			in, out := &in.Subsets, &out.Subsets
			*out = make([]EndpointSubset, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_EndpointSubset(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Subsets = nil
		}
		return nil
	}
}

func DeepCopy_v1_EndpointsList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EndpointsList)
		out := out.(*EndpointsList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Endpoints, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Endpoints(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_EnvVar(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EnvVar)
		out := out.(*EnvVar)
		out.Name = in.Name
		out.Value = in.Value
		if in.ValueFrom != nil {
			in, out := &in.ValueFrom, &out.ValueFrom
			*out = new(EnvVarSource)
			if err := DeepCopy_v1_EnvVarSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ValueFrom = nil
		}
		return nil
	}
}

func DeepCopy_v1_EnvVarSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EnvVarSource)
		out := out.(*EnvVarSource)
		if in.FieldRef != nil {
			in, out := &in.FieldRef, &out.FieldRef
			*out = new(ObjectFieldSelector)
			**out = **in
		} else {
			out.FieldRef = nil
		}
		if in.ResourceFieldRef != nil {
			in, out := &in.ResourceFieldRef, &out.ResourceFieldRef
			*out = new(ResourceFieldSelector)
			if err := DeepCopy_v1_ResourceFieldSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ResourceFieldRef = nil
		}
		if in.ConfigMapKeyRef != nil {
			in, out := &in.ConfigMapKeyRef, &out.ConfigMapKeyRef
			*out = new(ConfigMapKeySelector)
			**out = **in
		} else {
			out.ConfigMapKeyRef = nil
		}
		if in.SecretKeyRef != nil {
			in, out := &in.SecretKeyRef, &out.SecretKeyRef
			*out = new(SecretKeySelector)
			**out = **in
		} else {
			out.SecretKeyRef = nil
		}
		return nil
	}
}

func DeepCopy_v1_Event(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Event)
		out := out.(*Event)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		out.InvolvedObject = in.InvolvedObject
		out.Reason = in.Reason
		out.Message = in.Message
		out.Source = in.Source
		out.FirstTimestamp = in.FirstTimestamp.DeepCopy()
		out.LastTimestamp = in.LastTimestamp.DeepCopy()
		out.Count = in.Count
		out.Type = in.Type
		return nil
	}
}

func DeepCopy_v1_EventList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EventList)
		out := out.(*EventList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Event, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Event(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_EventSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*EventSource)
		out := out.(*EventSource)
		out.Component = in.Component
		out.Host = in.Host
		return nil
	}
}

func DeepCopy_v1_ExecAction(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ExecAction)
		out := out.(*ExecAction)
		if in.Command != nil {
			in, out := &in.Command, &out.Command
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Command = nil
		}
		return nil
	}
}

func DeepCopy_v1_ExportOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ExportOptions)
		out := out.(*ExportOptions)
		out.TypeMeta = in.TypeMeta
		out.Export = in.Export
		out.Exact = in.Exact
		return nil
	}
}

func DeepCopy_v1_FCVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*FCVolumeSource)
		out := out.(*FCVolumeSource)
		if in.TargetWWNs != nil {
			in, out := &in.TargetWWNs, &out.TargetWWNs
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.TargetWWNs = nil
		}
		if in.Lun != nil {
			in, out := &in.Lun, &out.Lun
			*out = new(int32)
			**out = **in
		} else {
			out.Lun = nil
		}
		out.FSType = in.FSType
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_FSGroupStrategyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*FSGroupStrategyOptions)
		out := out.(*FSGroupStrategyOptions)
		out.Type = in.Type
		if in.Ranges != nil {
			in, out := &in.Ranges, &out.Ranges
			*out = make([]IDRange, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ranges = nil
		}
		return nil
	}
}

func DeepCopy_v1_FlexVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*FlexVolumeSource)
		out := out.(*FlexVolumeSource)
		out.Driver = in.Driver
		out.FSType = in.FSType
		if in.SecretRef != nil {
			in, out := &in.SecretRef, &out.SecretRef
			*out = new(LocalObjectReference)
			**out = **in
		} else {
			out.SecretRef = nil
		}
		out.ReadOnly = in.ReadOnly
		if in.Options != nil {
			in, out := &in.Options, &out.Options
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Options = nil
		}
		return nil
	}
}

func DeepCopy_v1_FlockerVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*FlockerVolumeSource)
		out := out.(*FlockerVolumeSource)
		out.DatasetName = in.DatasetName
		return nil
	}
}

func DeepCopy_v1_GCEPersistentDiskVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*GCEPersistentDiskVolumeSource)
		out := out.(*GCEPersistentDiskVolumeSource)
		out.PDName = in.PDName
		out.FSType = in.FSType
		out.Partition = in.Partition
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_GitRepoVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*GitRepoVolumeSource)
		out := out.(*GitRepoVolumeSource)
		out.Repository = in.Repository
		out.Revision = in.Revision
		out.Directory = in.Directory
		return nil
	}
}

func DeepCopy_v1_GlusterfsVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*GlusterfsVolumeSource)
		out := out.(*GlusterfsVolumeSource)
		out.EndpointsName = in.EndpointsName
		out.Path = in.Path
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_HTTPGetAction(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*HTTPGetAction)
		out := out.(*HTTPGetAction)
		out.Path = in.Path
		out.Port = in.Port
		out.Host = in.Host
		out.Scheme = in.Scheme
		if in.HTTPHeaders != nil {
			in, out := &in.HTTPHeaders, &out.HTTPHeaders
			*out = make([]HTTPHeader, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.HTTPHeaders = nil
		}
		return nil
	}
}

func DeepCopy_v1_HTTPHeader(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*HTTPHeader)
		out := out.(*HTTPHeader)
		out.Name = in.Name
		out.Value = in.Value
		return nil
	}
}

func DeepCopy_v1_Handler(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Handler)
		out := out.(*Handler)
		if in.Exec != nil {
			in, out := &in.Exec, &out.Exec
			*out = new(ExecAction)
			if err := DeepCopy_v1_ExecAction(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Exec = nil
		}
		if in.HTTPGet != nil {
			in, out := &in.HTTPGet, &out.HTTPGet
			*out = new(HTTPGetAction)
			if err := DeepCopy_v1_HTTPGetAction(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.HTTPGet = nil
		}
		if in.TCPSocket != nil {
			in, out := &in.TCPSocket, &out.TCPSocket
			*out = new(TCPSocketAction)
			**out = **in
		} else {
			out.TCPSocket = nil
		}
		return nil
	}
}

func DeepCopy_v1_HostPathVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*HostPathVolumeSource)
		out := out.(*HostPathVolumeSource)
		out.Path = in.Path
		return nil
	}
}

func DeepCopy_v1_IDRange(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*IDRange)
		out := out.(*IDRange)
		out.Min = in.Min
		out.Max = in.Max
		return nil
	}
}

func DeepCopy_v1_ISCSIVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ISCSIVolumeSource)
		out := out.(*ISCSIVolumeSource)
		out.TargetPortal = in.TargetPortal
		out.IQN = in.IQN
		out.Lun = in.Lun
		out.ISCSIInterface = in.ISCSIInterface
		out.FSType = in.FSType
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_KeyToPath(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*KeyToPath)
		out := out.(*KeyToPath)
		out.Key = in.Key
		out.Path = in.Path
		if in.Mode != nil {
			in, out := &in.Mode, &out.Mode
			*out = new(int32)
			**out = **in
		} else {
			out.Mode = nil
		}
		return nil
	}
}

func DeepCopy_v1_Lifecycle(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Lifecycle)
		out := out.(*Lifecycle)
		if in.PostStart != nil {
			in, out := &in.PostStart, &out.PostStart
			*out = new(Handler)
			if err := DeepCopy_v1_Handler(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.PostStart = nil
		}
		if in.PreStop != nil {
			in, out := &in.PreStop, &out.PreStop
			*out = new(Handler)
			if err := DeepCopy_v1_Handler(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.PreStop = nil
		}
		return nil
	}
}

func DeepCopy_v1_LimitRange(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LimitRange)
		out := out.(*LimitRange)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_LimitRangeSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_LimitRangeItem(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LimitRangeItem)
		out := out.(*LimitRangeItem)
		out.Type = in.Type
		if in.Max != nil {
			in, out := &in.Max, &out.Max
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Max = nil
		}
		if in.Min != nil {
			in, out := &in.Min, &out.Min
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Min = nil
		}
		if in.Default != nil {
			in, out := &in.Default, &out.Default
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Default = nil
		}
		if in.DefaultRequest != nil {
			in, out := &in.DefaultRequest, &out.DefaultRequest
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.DefaultRequest = nil
		}
		if in.MaxLimitRequestRatio != nil {
			in, out := &in.MaxLimitRequestRatio, &out.MaxLimitRequestRatio
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.MaxLimitRequestRatio = nil
		}
		return nil
	}
}

func DeepCopy_v1_LimitRangeList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LimitRangeList)
		out := out.(*LimitRangeList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]LimitRange, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_LimitRange(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_LimitRangeSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LimitRangeSpec)
		out := out.(*LimitRangeSpec)
		if in.Limits != nil {
			in, out := &in.Limits, &out.Limits
			*out = make([]LimitRangeItem, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_LimitRangeItem(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Limits = nil
		}
		return nil
	}
}

func DeepCopy_v1_List(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*List)
		out := out.(*List)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]runtime.RawExtension, len(*in))
			for i := range *in {
				if err := runtime.DeepCopy_runtime_RawExtension(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ListOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ListOptions)
		out := out.(*ListOptions)
		out.TypeMeta = in.TypeMeta
		out.LabelSelector = in.LabelSelector
		out.FieldSelector = in.FieldSelector
		out.Watch = in.Watch
		out.ResourceVersion = in.ResourceVersion
		if in.TimeoutSeconds != nil {
			in, out := &in.TimeoutSeconds, &out.TimeoutSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.TimeoutSeconds = nil
		}
		return nil
	}
}

func DeepCopy_v1_LoadBalancerIngress(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LoadBalancerIngress)
		out := out.(*LoadBalancerIngress)
		out.IP = in.IP
		out.Hostname = in.Hostname
		return nil
	}
}

func DeepCopy_v1_LoadBalancerStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LoadBalancerStatus)
		out := out.(*LoadBalancerStatus)
		if in.Ingress != nil {
			in, out := &in.Ingress, &out.Ingress
			*out = make([]LoadBalancerIngress, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ingress = nil
		}
		return nil
	}
}

func DeepCopy_v1_LocalObjectReference(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*LocalObjectReference)
		out := out.(*LocalObjectReference)
		out.Name = in.Name
		return nil
	}
}

func DeepCopy_v1_NFSVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NFSVolumeSource)
		out := out.(*NFSVolumeSource)
		out.Server = in.Server
		out.Path = in.Path
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_Namespace(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Namespace)
		out := out.(*Namespace)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_NamespaceSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		out.Status = in.Status
		return nil
	}
}

func DeepCopy_v1_NamespaceList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NamespaceList)
		out := out.(*NamespaceList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Namespace, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Namespace(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_NamespaceSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NamespaceSpec)
		out := out.(*NamespaceSpec)
		if in.Finalizers != nil {
			in, out := &in.Finalizers, &out.Finalizers
			*out = make([]FinalizerName, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Finalizers = nil
		}
		return nil
	}
}

func DeepCopy_v1_NamespaceStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NamespaceStatus)
		out := out.(*NamespaceStatus)
		out.Phase = in.Phase
		return nil
	}
}

func DeepCopy_v1_Node(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Node)
		out := out.(*Node)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		out.Spec = in.Spec
		if err := DeepCopy_v1_NodeStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_NodeAddress(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeAddress)
		out := out.(*NodeAddress)
		out.Type = in.Type
		out.Address = in.Address
		return nil
	}
}

func DeepCopy_v1_NodeAffinity(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeAffinity)
		out := out.(*NodeAffinity)
		if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
			*out = new(NodeSelector)
			if err := DeepCopy_v1_NodeSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
		if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
			*out = make([]PreferredSchedulingTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PreferredSchedulingTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.PreferredDuringSchedulingIgnoredDuringExecution = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeCondition(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeCondition)
		out := out.(*NodeCondition)
		out.Type = in.Type
		out.Status = in.Status
		out.LastHeartbeatTime = in.LastHeartbeatTime.DeepCopy()
		out.LastTransitionTime = in.LastTransitionTime.DeepCopy()
		out.Reason = in.Reason
		out.Message = in.Message
		return nil
	}
}

func DeepCopy_v1_NodeDaemonEndpoints(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeDaemonEndpoints)
		out := out.(*NodeDaemonEndpoints)
		out.KubeletEndpoint = in.KubeletEndpoint
		return nil
	}
}

func DeepCopy_v1_NodeList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeList)
		out := out.(*NodeList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Node, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Node(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeProxyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeProxyOptions)
		out := out.(*NodeProxyOptions)
		out.TypeMeta = in.TypeMeta
		out.Path = in.Path
		return nil
	}
}

func DeepCopy_v1_NodeSelector(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeSelector)
		out := out.(*NodeSelector)
		if in.NodeSelectorTerms != nil {
			in, out := &in.NodeSelectorTerms, &out.NodeSelectorTerms
			*out = make([]NodeSelectorTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_NodeSelectorTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.NodeSelectorTerms = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeSelectorRequirement(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeSelectorRequirement)
		out := out.(*NodeSelectorRequirement)
		out.Key = in.Key
		out.Operator = in.Operator
		if in.Values != nil {
			in, out := &in.Values, &out.Values
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Values = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeSelectorTerm(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeSelectorTerm)
		out := out.(*NodeSelectorTerm)
		if in.MatchExpressions != nil {
			in, out := &in.MatchExpressions, &out.MatchExpressions
			*out = make([]NodeSelectorRequirement, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_NodeSelectorRequirement(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.MatchExpressions = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeSpec)
		out := out.(*NodeSpec)
		out.PodCIDR = in.PodCIDR
		out.ExternalID = in.ExternalID
		out.ProviderID = in.ProviderID
		out.Unschedulable = in.Unschedulable
		return nil
	}
}

func DeepCopy_v1_NodeStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeStatus)
		out := out.(*NodeStatus)
		if in.Capacity != nil {
			in, out := &in.Capacity, &out.Capacity
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Capacity = nil
		}
		if in.Allocatable != nil {
			in, out := &in.Allocatable, &out.Allocatable
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Allocatable = nil
		}
		out.Phase = in.Phase
		if in.Conditions != nil {
			in, out := &in.Conditions, &out.Conditions
			*out = make([]NodeCondition, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_NodeCondition(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Conditions = nil
		}
		if in.Addresses != nil {
			in, out := &in.Addresses, &out.Addresses
			*out = make([]NodeAddress, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Addresses = nil
		}
		out.DaemonEndpoints = in.DaemonEndpoints
		out.NodeInfo = in.NodeInfo
		if in.Images != nil {
			in, out := &in.Images, &out.Images
			*out = make([]ContainerImage, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ContainerImage(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Images = nil
		}
		if in.VolumesInUse != nil {
			in, out := &in.VolumesInUse, &out.VolumesInUse
			*out = make([]UniqueVolumeName, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.VolumesInUse = nil
		}
		if in.VolumesAttached != nil {
			in, out := &in.VolumesAttached, &out.VolumesAttached
			*out = make([]AttachedVolume, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.VolumesAttached = nil
		}
		return nil
	}
}

func DeepCopy_v1_NodeSystemInfo(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*NodeSystemInfo)
		out := out.(*NodeSystemInfo)
		out.MachineID = in.MachineID
		out.SystemUUID = in.SystemUUID
		out.BootID = in.BootID
		out.KernelVersion = in.KernelVersion
		out.OSImage = in.OSImage
		out.ContainerRuntimeVersion = in.ContainerRuntimeVersion
		out.KubeletVersion = in.KubeletVersion
		out.KubeProxyVersion = in.KubeProxyVersion
		out.OperatingSystem = in.OperatingSystem
		out.Architecture = in.Architecture
		return nil
	}
}

func DeepCopy_v1_ObjectFieldSelector(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ObjectFieldSelector)
		out := out.(*ObjectFieldSelector)
		out.APIVersion = in.APIVersion
		out.FieldPath = in.FieldPath
		return nil
	}
}

func DeepCopy_v1_ObjectMeta(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ObjectMeta)
		out := out.(*ObjectMeta)
		out.Name = in.Name
		out.GenerateName = in.GenerateName
		out.Namespace = in.Namespace
		out.SelfLink = in.SelfLink
		out.UID = in.UID
		out.ResourceVersion = in.ResourceVersion
		out.Generation = in.Generation
		out.CreationTimestamp = in.CreationTimestamp.DeepCopy()
		if in.DeletionTimestamp != nil {
			in, out := &in.DeletionTimestamp, &out.DeletionTimestamp
			*out = new(unversioned.Time)
			**out = (*in).DeepCopy()
		} else {
			out.DeletionTimestamp = nil
		}
		if in.DeletionGracePeriodSeconds != nil {
			in, out := &in.DeletionGracePeriodSeconds, &out.DeletionGracePeriodSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.DeletionGracePeriodSeconds = nil
		}
		if in.Labels != nil {
			in, out := &in.Labels, &out.Labels
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Labels = nil
		}
		if in.Annotations != nil {
			in, out := &in.Annotations, &out.Annotations
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Annotations = nil
		}
		if in.OwnerReferences != nil {
			in, out := &in.OwnerReferences, &out.OwnerReferences
			*out = make([]OwnerReference, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_OwnerReference(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.OwnerReferences = nil
		}
		if in.Finalizers != nil {
			in, out := &in.Finalizers, &out.Finalizers
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Finalizers = nil
		}
		out.ClusterName = in.ClusterName
		return nil
	}
}

func DeepCopy_v1_ObjectReference(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ObjectReference)
		out := out.(*ObjectReference)
		out.Kind = in.Kind
		out.Namespace = in.Namespace
		out.Name = in.Name
		out.UID = in.UID
		out.APIVersion = in.APIVersion
		out.ResourceVersion = in.ResourceVersion
		out.FieldPath = in.FieldPath
		return nil
	}
}

func DeepCopy_v1_OwnerReference(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*OwnerReference)
		out := out.(*OwnerReference)
		out.APIVersion = in.APIVersion
		out.Kind = in.Kind
		out.Name = in.Name
		out.UID = in.UID
		if in.Controller != nil {
			in, out := &in.Controller, &out.Controller
			*out = new(bool)
			**out = **in
		} else {
			out.Controller = nil
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolume(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolume)
		out := out.(*PersistentVolume)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PersistentVolumeSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		out.Status = in.Status
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeClaim(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeClaim)
		out := out.(*PersistentVolumeClaim)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PersistentVolumeClaimSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PersistentVolumeClaimStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeClaimList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeClaimList)
		out := out.(*PersistentVolumeClaimList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]PersistentVolumeClaim, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PersistentVolumeClaim(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeClaimSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeClaimSpec)
		out := out.(*PersistentVolumeClaimSpec)
		if in.AccessModes != nil {
			in, out := &in.AccessModes, &out.AccessModes
			*out = make([]PersistentVolumeAccessMode, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.AccessModes = nil
		}
		if in.Selector != nil {
			in, out := &in.Selector, &out.Selector
			*out = new(unversioned.LabelSelector)
			if err := unversioned.DeepCopy_unversioned_LabelSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Selector = nil
		}
		if err := DeepCopy_v1_ResourceRequirements(&in.Resources, &out.Resources, c); err != nil {
			return err
		}
		out.VolumeName = in.VolumeName
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeClaimStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeClaimStatus)
		out := out.(*PersistentVolumeClaimStatus)
		out.Phase = in.Phase
		if in.AccessModes != nil {
			in, out := &in.AccessModes, &out.AccessModes
			*out = make([]PersistentVolumeAccessMode, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.AccessModes = nil
		}
		if in.Capacity != nil {
			in, out := &in.Capacity, &out.Capacity
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Capacity = nil
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeClaimVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeClaimVolumeSource)
		out := out.(*PersistentVolumeClaimVolumeSource)
		out.ClaimName = in.ClaimName
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeList)
		out := out.(*PersistentVolumeList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]PersistentVolume, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PersistentVolume(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeSource)
		out := out.(*PersistentVolumeSource)
		if in.GCEPersistentDisk != nil {
			in, out := &in.GCEPersistentDisk, &out.GCEPersistentDisk
			*out = new(GCEPersistentDiskVolumeSource)
			**out = **in
		} else {
			out.GCEPersistentDisk = nil
		}
		if in.AWSElasticBlockStore != nil {
			in, out := &in.AWSElasticBlockStore, &out.AWSElasticBlockStore
			*out = new(AWSElasticBlockStoreVolumeSource)
			**out = **in
		} else {
			out.AWSElasticBlockStore = nil
		}
		if in.HostPath != nil {
			in, out := &in.HostPath, &out.HostPath
			*out = new(HostPathVolumeSource)
			**out = **in
		} else {
			out.HostPath = nil
		}
		if in.Glusterfs != nil {
			in, out := &in.Glusterfs, &out.Glusterfs
			*out = new(GlusterfsVolumeSource)
			**out = **in
		} else {
			out.Glusterfs = nil
		}
		if in.NFS != nil {
			in, out := &in.NFS, &out.NFS
			*out = new(NFSVolumeSource)
			**out = **in
		} else {
			out.NFS = nil
		}
		if in.RBD != nil {
			in, out := &in.RBD, &out.RBD
			*out = new(RBDVolumeSource)
			if err := DeepCopy_v1_RBDVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.RBD = nil
		}
		if in.ISCSI != nil {
			in, out := &in.ISCSI, &out.ISCSI
			*out = new(ISCSIVolumeSource)
			**out = **in
		} else {
			out.ISCSI = nil
		}
		if in.Cinder != nil {
			in, out := &in.Cinder, &out.Cinder
			*out = new(CinderVolumeSource)
			**out = **in
		} else {
			out.Cinder = nil
		}
		if in.CephFS != nil {
			in, out := &in.CephFS, &out.CephFS
			*out = new(CephFSVolumeSource)
			if err := DeepCopy_v1_CephFSVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.CephFS = nil
		}
		if in.FC != nil {
			in, out := &in.FC, &out.FC
			*out = new(FCVolumeSource)
			if err := DeepCopy_v1_FCVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.FC = nil
		}
		if in.Flocker != nil {
			in, out := &in.Flocker, &out.Flocker
			*out = new(FlockerVolumeSource)
			**out = **in
		} else {
			out.Flocker = nil
		}
		if in.FlexVolume != nil {
			in, out := &in.FlexVolume, &out.FlexVolume
			*out = new(FlexVolumeSource)
			if err := DeepCopy_v1_FlexVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.FlexVolume = nil
		}
		if in.AzureFile != nil {
			in, out := &in.AzureFile, &out.AzureFile
			*out = new(AzureFileVolumeSource)
			**out = **in
		} else {
			out.AzureFile = nil
		}
		if in.VsphereVolume != nil {
			in, out := &in.VsphereVolume, &out.VsphereVolume
			*out = new(VsphereVirtualDiskVolumeSource)
			**out = **in
		} else {
			out.VsphereVolume = nil
		}
		if in.Quobyte != nil {
			in, out := &in.Quobyte, &out.Quobyte
			*out = new(QuobyteVolumeSource)
			**out = **in
		} else {
			out.Quobyte = nil
		}
		if in.AzureDisk != nil {
			in, out := &in.AzureDisk, &out.AzureDisk
			*out = new(AzureDiskVolumeSource)
			if err := DeepCopy_v1_AzureDiskVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.AzureDisk = nil
		}
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeSpec)
		out := out.(*PersistentVolumeSpec)
		if in.Capacity != nil {
			in, out := &in.Capacity, &out.Capacity
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Capacity = nil
		}
		if err := DeepCopy_v1_PersistentVolumeSource(&in.PersistentVolumeSource, &out.PersistentVolumeSource, c); err != nil {
			return err
		}
		if in.AccessModes != nil {
			in, out := &in.AccessModes, &out.AccessModes
			*out = make([]PersistentVolumeAccessMode, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.AccessModes = nil
		}
		if in.ClaimRef != nil {
			in, out := &in.ClaimRef, &out.ClaimRef
			*out = new(ObjectReference)
			**out = **in
		} else {
			out.ClaimRef = nil
		}
		out.PersistentVolumeReclaimPolicy = in.PersistentVolumeReclaimPolicy
		return nil
	}
}

func DeepCopy_v1_PersistentVolumeStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PersistentVolumeStatus)
		out := out.(*PersistentVolumeStatus)
		out.Phase = in.Phase
		out.Message = in.Message
		out.Reason = in.Reason
		return nil
	}
}

func DeepCopy_v1_Pod(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Pod)
		out := out.(*Pod)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PodSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PodStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_PodAffinity(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodAffinity)
		out := out.(*PodAffinity)
		if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
			*out = make([]PodAffinityTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PodAffinityTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
		if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
			*out = make([]WeightedPodAffinityTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_WeightedPodAffinityTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.PreferredDuringSchedulingIgnoredDuringExecution = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodAffinityTerm(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodAffinityTerm)
		out := out.(*PodAffinityTerm)
		if in.LabelSelector != nil {
			in, out := &in.LabelSelector, &out.LabelSelector
			*out = new(unversioned.LabelSelector)
			if err := unversioned.DeepCopy_unversioned_LabelSelector(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.LabelSelector = nil
		}
		if in.Namespaces != nil {
			in, out := &in.Namespaces, &out.Namespaces
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Namespaces = nil
		}
		out.TopologyKey = in.TopologyKey
		return nil
	}
}

func DeepCopy_v1_PodAntiAffinity(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodAntiAffinity)
		out := out.(*PodAntiAffinity)
		if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
			*out = make([]PodAffinityTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PodAffinityTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
		if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
			in, out := &in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
			*out = make([]WeightedPodAffinityTerm, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_WeightedPodAffinityTerm(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.PreferredDuringSchedulingIgnoredDuringExecution = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodAttachOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodAttachOptions)
		out := out.(*PodAttachOptions)
		out.TypeMeta = in.TypeMeta
		out.Stdin = in.Stdin
		out.Stdout = in.Stdout
		out.Stderr = in.Stderr
		out.TTY = in.TTY
		out.Container = in.Container
		return nil
	}
}

func DeepCopy_v1_PodCondition(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodCondition)
		out := out.(*PodCondition)
		out.Type = in.Type
		out.Status = in.Status
		out.LastProbeTime = in.LastProbeTime.DeepCopy()
		out.LastTransitionTime = in.LastTransitionTime.DeepCopy()
		out.Reason = in.Reason
		out.Message = in.Message
		return nil
	}
}

func DeepCopy_v1_PodExecOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodExecOptions)
		out := out.(*PodExecOptions)
		out.TypeMeta = in.TypeMeta
		out.Stdin = in.Stdin
		out.Stdout = in.Stdout
		out.Stderr = in.Stderr
		out.TTY = in.TTY
		out.Container = in.Container
		if in.Command != nil {
			in, out := &in.Command, &out.Command
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Command = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodList)
		out := out.(*PodList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Pod, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Pod(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodLogOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodLogOptions)
		out := out.(*PodLogOptions)
		out.TypeMeta = in.TypeMeta
		out.Container = in.Container
		out.Follow = in.Follow
		out.Previous = in.Previous
		if in.SinceSeconds != nil {
			in, out := &in.SinceSeconds, &out.SinceSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.SinceSeconds = nil
		}
		if in.SinceTime != nil {
			in, out := &in.SinceTime, &out.SinceTime
			*out = new(unversioned.Time)
			**out = (*in).DeepCopy()
		} else {
			out.SinceTime = nil
		}
		out.Timestamps = in.Timestamps
		if in.TailLines != nil {
			in, out := &in.TailLines, &out.TailLines
			*out = new(int64)
			**out = **in
		} else {
			out.TailLines = nil
		}
		if in.LimitBytes != nil {
			in, out := &in.LimitBytes, &out.LimitBytes
			*out = new(int64)
			**out = **in
		} else {
			out.LimitBytes = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodProxyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodProxyOptions)
		out := out.(*PodProxyOptions)
		out.TypeMeta = in.TypeMeta
		out.Path = in.Path
		return nil
	}
}

func DeepCopy_v1_PodSecurityContext(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodSecurityContext)
		out := out.(*PodSecurityContext)
		if in.SELinuxOptions != nil {
			in, out := &in.SELinuxOptions, &out.SELinuxOptions
			*out = new(SELinuxOptions)
			**out = **in
		} else {
			out.SELinuxOptions = nil
		}
		if in.RunAsUser != nil {
			in, out := &in.RunAsUser, &out.RunAsUser
			*out = new(int64)
			**out = **in
		} else {
			out.RunAsUser = nil
		}
		if in.RunAsNonRoot != nil {
			in, out := &in.RunAsNonRoot, &out.RunAsNonRoot
			*out = new(bool)
			**out = **in
		} else {
			out.RunAsNonRoot = nil
		}
		if in.SupplementalGroups != nil {
			in, out := &in.SupplementalGroups, &out.SupplementalGroups
			*out = make([]int64, len(*in))
			copy(*out, *in)
		} else {
			out.SupplementalGroups = nil
		}
		if in.FSGroup != nil {
			in, out := &in.FSGroup, &out.FSGroup
			*out = new(int64)
			**out = **in
		} else {
			out.FSGroup = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodSignature(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodSignature)
		out := out.(*PodSignature)
		if in.PodController != nil {
			in, out := &in.PodController, &out.PodController
			*out = new(OwnerReference)
			if err := DeepCopy_v1_OwnerReference(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.PodController = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodSpec)
		out := out.(*PodSpec)
		if in.Volumes != nil {
			in, out := &in.Volumes, &out.Volumes
			*out = make([]Volume, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Volume(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Volumes = nil
		}
		if in.InitContainers != nil {
			in, out := &in.InitContainers, &out.InitContainers
			*out = make([]Container, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Container(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.InitContainers = nil
		}
		if in.Containers != nil {
			in, out := &in.Containers, &out.Containers
			*out = make([]Container, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Container(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Containers = nil
		}
		out.RestartPolicy = in.RestartPolicy
		if in.TerminationGracePeriodSeconds != nil {
			in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.TerminationGracePeriodSeconds = nil
		}
		if in.ActiveDeadlineSeconds != nil {
			in, out := &in.ActiveDeadlineSeconds, &out.ActiveDeadlineSeconds
			*out = new(int64)
			**out = **in
		} else {
			out.ActiveDeadlineSeconds = nil
		}
		out.DNSPolicy = in.DNSPolicy
		if in.NodeSelector != nil {
			in, out := &in.NodeSelector, &out.NodeSelector
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.NodeSelector = nil
		}
		out.ServiceAccountName = in.ServiceAccountName
		out.DeprecatedServiceAccount = in.DeprecatedServiceAccount
		out.NodeName = in.NodeName
		out.HostNetwork = in.HostNetwork
		out.HostPID = in.HostPID
		out.HostIPC = in.HostIPC
		if in.SecurityContext != nil {
			in, out := &in.SecurityContext, &out.SecurityContext
			*out = new(PodSecurityContext)
			if err := DeepCopy_v1_PodSecurityContext(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.SecurityContext = nil
		}
		if in.ImagePullSecrets != nil {
			in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
			*out = make([]LocalObjectReference, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.ImagePullSecrets = nil
		}
		out.Hostname = in.Hostname
		out.Subdomain = in.Subdomain
		return nil
	}
}

func DeepCopy_v1_PodStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodStatus)
		out := out.(*PodStatus)
		out.Phase = in.Phase
		if in.Conditions != nil {
			in, out := &in.Conditions, &out.Conditions
			*out = make([]PodCondition, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PodCondition(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Conditions = nil
		}
		out.Message = in.Message
		out.Reason = in.Reason
		out.HostIP = in.HostIP
		out.PodIP = in.PodIP
		if in.StartTime != nil {
			in, out := &in.StartTime, &out.StartTime
			*out = new(unversioned.Time)
			**out = (*in).DeepCopy()
		} else {
			out.StartTime = nil
		}
		if in.InitContainerStatuses != nil {
			in, out := &in.InitContainerStatuses, &out.InitContainerStatuses
			*out = make([]ContainerStatus, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ContainerStatus(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.InitContainerStatuses = nil
		}
		if in.ContainerStatuses != nil {
			in, out := &in.ContainerStatuses, &out.ContainerStatuses
			*out = make([]ContainerStatus, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ContainerStatus(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.ContainerStatuses = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodStatusResult(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodStatusResult)
		out := out.(*PodStatusResult)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PodStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_PodTemplate(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodTemplate)
		out := out.(*PodTemplate)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PodTemplateSpec(&in.Template, &out.Template, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_PodTemplateList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodTemplateList)
		out := out.(*PodTemplateList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]PodTemplate, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_PodTemplate(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_PodTemplateSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PodTemplateSpec)
		out := out.(*PodTemplateSpec)
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_PodSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_Preconditions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Preconditions)
		out := out.(*Preconditions)
		if in.UID != nil {
			in, out := &in.UID, &out.UID
			*out = new(types.UID)
			**out = **in
		} else {
			out.UID = nil
		}
		return nil
	}
}

func DeepCopy_v1_PreferAvoidPodsEntry(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PreferAvoidPodsEntry)
		out := out.(*PreferAvoidPodsEntry)
		if err := DeepCopy_v1_PodSignature(&in.PodSignature, &out.PodSignature, c); err != nil {
			return err
		}
		out.EvictionTime = in.EvictionTime.DeepCopy()
		out.Reason = in.Reason
		out.Message = in.Message
		return nil
	}
}

func DeepCopy_v1_PreferredSchedulingTerm(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*PreferredSchedulingTerm)
		out := out.(*PreferredSchedulingTerm)
		out.Weight = in.Weight
		if err := DeepCopy_v1_NodeSelectorTerm(&in.Preference, &out.Preference, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_Probe(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Probe)
		out := out.(*Probe)
		if err := DeepCopy_v1_Handler(&in.Handler, &out.Handler, c); err != nil {
			return err
		}
		out.InitialDelaySeconds = in.InitialDelaySeconds
		out.TimeoutSeconds = in.TimeoutSeconds
		out.PeriodSeconds = in.PeriodSeconds
		out.SuccessThreshold = in.SuccessThreshold
		out.FailureThreshold = in.FailureThreshold
		return nil
	}
}

func DeepCopy_v1_QuobyteVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*QuobyteVolumeSource)
		out := out.(*QuobyteVolumeSource)
		out.Registry = in.Registry
		out.Volume = in.Volume
		out.ReadOnly = in.ReadOnly
		out.User = in.User
		out.Group = in.Group
		return nil
	}
}

func DeepCopy_v1_RBDVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*RBDVolumeSource)
		out := out.(*RBDVolumeSource)
		if in.CephMonitors != nil {
			in, out := &in.CephMonitors, &out.CephMonitors
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.CephMonitors = nil
		}
		out.RBDImage = in.RBDImage
		out.FSType = in.FSType
		out.RBDPool = in.RBDPool
		out.RadosUser = in.RadosUser
		out.Keyring = in.Keyring
		if in.SecretRef != nil {
			in, out := &in.SecretRef, &out.SecretRef
			*out = new(LocalObjectReference)
			**out = **in
		} else {
			out.SecretRef = nil
		}
		out.ReadOnly = in.ReadOnly
		return nil
	}
}

func DeepCopy_v1_RangeAllocation(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*RangeAllocation)
		out := out.(*RangeAllocation)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		out.Range = in.Range
		if in.Data != nil {
			in, out := &in.Data, &out.Data
			*out = make([]byte, len(*in))
			copy(*out, *in)
		} else {
			out.Data = nil
		}
		return nil
	}
}

func DeepCopy_v1_ReplicationController(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ReplicationController)
		out := out.(*ReplicationController)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ReplicationControllerSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		out.Status = in.Status
		return nil
	}
}

func DeepCopy_v1_ReplicationControllerList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ReplicationControllerList)
		out := out.(*ReplicationControllerList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]ReplicationController, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ReplicationController(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ReplicationControllerSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ReplicationControllerSpec)
		out := out.(*ReplicationControllerSpec)
		if in.Replicas != nil {
			in, out := &in.Replicas, &out.Replicas
			*out = new(int32)
			**out = **in
		} else {
			out.Replicas = nil
		}
		if in.Selector != nil {
			in, out := &in.Selector, &out.Selector
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Selector = nil
		}
		if in.Template != nil {
			in, out := &in.Template, &out.Template
			*out = new(PodTemplateSpec)
			if err := DeepCopy_v1_PodTemplateSpec(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Template = nil
		}
		return nil
	}
}

func DeepCopy_v1_ReplicationControllerStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ReplicationControllerStatus)
		out := out.(*ReplicationControllerStatus)
		out.Replicas = in.Replicas
		out.FullyLabeledReplicas = in.FullyLabeledReplicas
		out.ReadyReplicas = in.ReadyReplicas
		out.ObservedGeneration = in.ObservedGeneration
		return nil
	}
}

func DeepCopy_v1_ResourceFieldSelector(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceFieldSelector)
		out := out.(*ResourceFieldSelector)
		out.ContainerName = in.ContainerName
		out.Resource = in.Resource
		out.Divisor = in.Divisor.DeepCopy()
		return nil
	}
}

func DeepCopy_v1_ResourceQuota(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceQuota)
		out := out.(*ResourceQuota)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ResourceQuotaSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ResourceQuotaStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_ResourceQuotaList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceQuotaList)
		out := out.(*ResourceQuotaList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]ResourceQuota, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ResourceQuota(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ResourceQuotaSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceQuotaSpec)
		out := out.(*ResourceQuotaSpec)
		if in.Hard != nil {
			in, out := &in.Hard, &out.Hard
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Hard = nil
		}
		if in.Scopes != nil {
			in, out := &in.Scopes, &out.Scopes
			*out = make([]ResourceQuotaScope, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Scopes = nil
		}
		return nil
	}
}

func DeepCopy_v1_ResourceQuotaStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceQuotaStatus)
		out := out.(*ResourceQuotaStatus)
		if in.Hard != nil {
			in, out := &in.Hard, &out.Hard
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Hard = nil
		}
		if in.Used != nil {
			in, out := &in.Used, &out.Used
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Used = nil
		}
		return nil
	}
}

func DeepCopy_v1_ResourceRequirements(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ResourceRequirements)
		out := out.(*ResourceRequirements)
		if in.Limits != nil {
			in, out := &in.Limits, &out.Limits
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Limits = nil
		}
		if in.Requests != nil {
			in, out := &in.Requests, &out.Requests
			*out = make(ResourceList)
			for key, val := range *in {
				(*out)[key] = val.DeepCopy()
			}
		} else {
			out.Requests = nil
		}
		return nil
	}
}

func DeepCopy_v1_RunAsUserStrategyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*RunAsUserStrategyOptions)
		out := out.(*RunAsUserStrategyOptions)
		out.Type = in.Type
		if in.UID != nil {
			in, out := &in.UID, &out.UID
			*out = new(int64)
			**out = **in
		} else {
			out.UID = nil
		}
		if in.UIDRangeMin != nil {
			in, out := &in.UIDRangeMin, &out.UIDRangeMin
			*out = new(int64)
			**out = **in
		} else {
			out.UIDRangeMin = nil
		}
		if in.UIDRangeMax != nil {
			in, out := &in.UIDRangeMax, &out.UIDRangeMax
			*out = new(int64)
			**out = **in
		} else {
			out.UIDRangeMax = nil
		}
		return nil
	}
}

func DeepCopy_v1_SELinuxContextStrategyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SELinuxContextStrategyOptions)
		out := out.(*SELinuxContextStrategyOptions)
		out.Type = in.Type
		if in.SELinuxOptions != nil {
			in, out := &in.SELinuxOptions, &out.SELinuxOptions
			*out = new(SELinuxOptions)
			**out = **in
		} else {
			out.SELinuxOptions = nil
		}
		return nil
	}
}

func DeepCopy_v1_SELinuxOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SELinuxOptions)
		out := out.(*SELinuxOptions)
		out.User = in.User
		out.Role = in.Role
		out.Type = in.Type
		out.Level = in.Level
		return nil
	}
}

func DeepCopy_v1_Secret(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Secret)
		out := out.(*Secret)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Data != nil {
			in, out := &in.Data, &out.Data
			*out = make(map[string][]byte)
			for key, val := range *in {
				if newVal, err := c.DeepCopy(&val); err != nil {
					return err
				} else {
					(*out)[key] = *newVal.(*[]byte)
				}
			}
		} else {
			out.Data = nil
		}
		if in.StringData != nil {
			in, out := &in.StringData, &out.StringData
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.StringData = nil
		}
		out.Type = in.Type
		return nil
	}
}

func DeepCopy_v1_SecretKeySelector(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecretKeySelector)
		out := out.(*SecretKeySelector)
		out.LocalObjectReference = in.LocalObjectReference
		out.Key = in.Key
		return nil
	}
}

func DeepCopy_v1_SecretList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecretList)
		out := out.(*SecretList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Secret, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Secret(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_SecretVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecretVolumeSource)
		out := out.(*SecretVolumeSource)
		out.SecretName = in.SecretName
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]KeyToPath, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_KeyToPath(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		if in.DefaultMode != nil {
			in, out := &in.DefaultMode, &out.DefaultMode
			*out = new(int32)
			**out = **in
		} else {
			out.DefaultMode = nil
		}
		return nil
	}
}

func DeepCopy_v1_SecurityContext(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecurityContext)
		out := out.(*SecurityContext)
		if in.Capabilities != nil {
			in, out := &in.Capabilities, &out.Capabilities
			*out = new(Capabilities)
			if err := DeepCopy_v1_Capabilities(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Capabilities = nil
		}
		if in.Privileged != nil {
			in, out := &in.Privileged, &out.Privileged
			*out = new(bool)
			**out = **in
		} else {
			out.Privileged = nil
		}
		if in.SELinuxOptions != nil {
			in, out := &in.SELinuxOptions, &out.SELinuxOptions
			*out = new(SELinuxOptions)
			**out = **in
		} else {
			out.SELinuxOptions = nil
		}
		if in.RunAsUser != nil {
			in, out := &in.RunAsUser, &out.RunAsUser
			*out = new(int64)
			**out = **in
		} else {
			out.RunAsUser = nil
		}
		if in.RunAsNonRoot != nil {
			in, out := &in.RunAsNonRoot, &out.RunAsNonRoot
			*out = new(bool)
			**out = **in
		} else {
			out.RunAsNonRoot = nil
		}
		if in.ReadOnlyRootFilesystem != nil {
			in, out := &in.ReadOnlyRootFilesystem, &out.ReadOnlyRootFilesystem
			*out = new(bool)
			**out = **in
		} else {
			out.ReadOnlyRootFilesystem = nil
		}
		return nil
	}
}

func DeepCopy_v1_SecurityContextConstraints(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecurityContextConstraints)
		out := out.(*SecurityContextConstraints)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Priority != nil {
			in, out := &in.Priority, &out.Priority
			*out = new(int32)
			**out = **in
		} else {
			out.Priority = nil
		}
		out.AllowPrivilegedContainer = in.AllowPrivilegedContainer
		if in.DefaultAddCapabilities != nil {
			in, out := &in.DefaultAddCapabilities, &out.DefaultAddCapabilities
			*out = make([]Capability, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.DefaultAddCapabilities = nil
		}
		if in.RequiredDropCapabilities != nil {
			in, out := &in.RequiredDropCapabilities, &out.RequiredDropCapabilities
			*out = make([]Capability, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.RequiredDropCapabilities = nil
		}
		if in.AllowedCapabilities != nil {
			in, out := &in.AllowedCapabilities, &out.AllowedCapabilities
			*out = make([]Capability, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.AllowedCapabilities = nil
		}
		out.AllowHostDirVolumePlugin = in.AllowHostDirVolumePlugin
		if in.Volumes != nil {
			in, out := &in.Volumes, &out.Volumes
			*out = make([]FSType, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Volumes = nil
		}
		out.AllowHostNetwork = in.AllowHostNetwork
		out.AllowHostPorts = in.AllowHostPorts
		out.AllowHostPID = in.AllowHostPID
		out.AllowHostIPC = in.AllowHostIPC
		if err := DeepCopy_v1_SELinuxContextStrategyOptions(&in.SELinuxContext, &out.SELinuxContext, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_RunAsUserStrategyOptions(&in.RunAsUser, &out.RunAsUser, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_SupplementalGroupsStrategyOptions(&in.SupplementalGroups, &out.SupplementalGroups, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_FSGroupStrategyOptions(&in.FSGroup, &out.FSGroup, c); err != nil {
			return err
		}
		out.ReadOnlyRootFilesystem = in.ReadOnlyRootFilesystem
		if in.Users != nil {
			in, out := &in.Users, &out.Users
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Users = nil
		}
		if in.Groups != nil {
			in, out := &in.Groups, &out.Groups
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.Groups = nil
		}
		if in.SeccompProfiles != nil {
			in, out := &in.SeccompProfiles, &out.SeccompProfiles
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.SeccompProfiles = nil
		}
		return nil
	}
}

func DeepCopy_v1_SecurityContextConstraintsList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SecurityContextConstraintsList)
		out := out.(*SecurityContextConstraintsList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]SecurityContextConstraints, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_SecurityContextConstraints(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_SerializedReference(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SerializedReference)
		out := out.(*SerializedReference)
		out.TypeMeta = in.TypeMeta
		out.Reference = in.Reference
		return nil
	}
}

func DeepCopy_v1_Service(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Service)
		out := out.(*Service)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ServiceSpec(&in.Spec, &out.Spec, c); err != nil {
			return err
		}
		if err := DeepCopy_v1_ServiceStatus(&in.Status, &out.Status, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_ServiceAccount(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceAccount)
		out := out.(*ServiceAccount)
		out.TypeMeta = in.TypeMeta
		if err := DeepCopy_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, c); err != nil {
			return err
		}
		if in.Secrets != nil {
			in, out := &in.Secrets, &out.Secrets
			*out = make([]ObjectReference, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Secrets = nil
		}
		if in.ImagePullSecrets != nil {
			in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
			*out = make([]LocalObjectReference, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.ImagePullSecrets = nil
		}
		return nil
	}
}

func DeepCopy_v1_ServiceAccountList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceAccountList)
		out := out.(*ServiceAccountList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]ServiceAccount, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_ServiceAccount(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ServiceList(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceList)
		out := out.(*ServiceList)
		out.TypeMeta = in.TypeMeta
		out.ListMeta = in.ListMeta
		if in.Items != nil {
			in, out := &in.Items, &out.Items
			*out = make([]Service, len(*in))
			for i := range *in {
				if err := DeepCopy_v1_Service(&(*in)[i], &(*out)[i], c); err != nil {
					return err
				}
			}
		} else {
			out.Items = nil
		}
		return nil
	}
}

func DeepCopy_v1_ServicePort(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServicePort)
		out := out.(*ServicePort)
		out.Name = in.Name
		out.Protocol = in.Protocol
		out.Port = in.Port
		out.TargetPort = in.TargetPort
		out.NodePort = in.NodePort
		return nil
	}
}

func DeepCopy_v1_ServiceProxyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceProxyOptions)
		out := out.(*ServiceProxyOptions)
		out.TypeMeta = in.TypeMeta
		out.Path = in.Path
		return nil
	}
}

func DeepCopy_v1_ServiceSpec(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceSpec)
		out := out.(*ServiceSpec)
		if in.Ports != nil {
			in, out := &in.Ports, &out.Ports
			*out = make([]ServicePort, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ports = nil
		}
		if in.Selector != nil {
			in, out := &in.Selector, &out.Selector
			*out = make(map[string]string)
			for key, val := range *in {
				(*out)[key] = val
			}
		} else {
			out.Selector = nil
		}
		out.ClusterIP = in.ClusterIP
		out.Type = in.Type
		if in.ExternalIPs != nil {
			in, out := &in.ExternalIPs, &out.ExternalIPs
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.ExternalIPs = nil
		}
		if in.DeprecatedPublicIPs != nil {
			in, out := &in.DeprecatedPublicIPs, &out.DeprecatedPublicIPs
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.DeprecatedPublicIPs = nil
		}
		out.SessionAffinity = in.SessionAffinity
		out.LoadBalancerIP = in.LoadBalancerIP
		if in.LoadBalancerSourceRanges != nil {
			in, out := &in.LoadBalancerSourceRanges, &out.LoadBalancerSourceRanges
			*out = make([]string, len(*in))
			copy(*out, *in)
		} else {
			out.LoadBalancerSourceRanges = nil
		}
		out.ExternalName = in.ExternalName
		return nil
	}
}

func DeepCopy_v1_ServiceStatus(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*ServiceStatus)
		out := out.(*ServiceStatus)
		if err := DeepCopy_v1_LoadBalancerStatus(&in.LoadBalancer, &out.LoadBalancer, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_SupplementalGroupsStrategyOptions(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*SupplementalGroupsStrategyOptions)
		out := out.(*SupplementalGroupsStrategyOptions)
		out.Type = in.Type
		if in.Ranges != nil {
			in, out := &in.Ranges, &out.Ranges
			*out = make([]IDRange, len(*in))
			for i := range *in {
				(*out)[i] = (*in)[i]
			}
		} else {
			out.Ranges = nil
		}
		return nil
	}
}

func DeepCopy_v1_TCPSocketAction(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*TCPSocketAction)
		out := out.(*TCPSocketAction)
		out.Port = in.Port
		return nil
	}
}

func DeepCopy_v1_Taint(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Taint)
		out := out.(*Taint)
		out.Key = in.Key
		out.Value = in.Value
		out.Effect = in.Effect
		return nil
	}
}

func DeepCopy_v1_Toleration(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Toleration)
		out := out.(*Toleration)
		out.Key = in.Key
		out.Operator = in.Operator
		out.Value = in.Value
		out.Effect = in.Effect
		return nil
	}
}

func DeepCopy_v1_Volume(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*Volume)
		out := out.(*Volume)
		out.Name = in.Name
		if err := DeepCopy_v1_VolumeSource(&in.VolumeSource, &out.VolumeSource, c); err != nil {
			return err
		}
		return nil
	}
}

func DeepCopy_v1_VolumeMount(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*VolumeMount)
		out := out.(*VolumeMount)
		out.Name = in.Name
		out.ReadOnly = in.ReadOnly
		out.MountPath = in.MountPath
		out.SubPath = in.SubPath
		return nil
	}
}

func DeepCopy_v1_VolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*VolumeSource)
		out := out.(*VolumeSource)
		if in.HostPath != nil {
			in, out := &in.HostPath, &out.HostPath
			*out = new(HostPathVolumeSource)
			**out = **in
		} else {
			out.HostPath = nil
		}
		if in.EmptyDir != nil {
			in, out := &in.EmptyDir, &out.EmptyDir
			*out = new(EmptyDirVolumeSource)
			**out = **in
		} else {
			out.EmptyDir = nil
		}
		if in.GCEPersistentDisk != nil {
			in, out := &in.GCEPersistentDisk, &out.GCEPersistentDisk
			*out = new(GCEPersistentDiskVolumeSource)
			**out = **in
		} else {
			out.GCEPersistentDisk = nil
		}
		if in.AWSElasticBlockStore != nil {
			in, out := &in.AWSElasticBlockStore, &out.AWSElasticBlockStore
			*out = new(AWSElasticBlockStoreVolumeSource)
			**out = **in
		} else {
			out.AWSElasticBlockStore = nil
		}
		if in.GitRepo != nil {
			in, out := &in.GitRepo, &out.GitRepo
			*out = new(GitRepoVolumeSource)
			**out = **in
		} else {
			out.GitRepo = nil
		}
		if in.Secret != nil {
			in, out := &in.Secret, &out.Secret
			*out = new(SecretVolumeSource)
			if err := DeepCopy_v1_SecretVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Secret = nil
		}
		if in.NFS != nil {
			in, out := &in.NFS, &out.NFS
			*out = new(NFSVolumeSource)
			**out = **in
		} else {
			out.NFS = nil
		}
		if in.ISCSI != nil {
			in, out := &in.ISCSI, &out.ISCSI
			*out = new(ISCSIVolumeSource)
			**out = **in
		} else {
			out.ISCSI = nil
		}
		if in.Glusterfs != nil {
			in, out := &in.Glusterfs, &out.Glusterfs
			*out = new(GlusterfsVolumeSource)
			**out = **in
		} else {
			out.Glusterfs = nil
		}
		if in.PersistentVolumeClaim != nil {
			in, out := &in.PersistentVolumeClaim, &out.PersistentVolumeClaim
			*out = new(PersistentVolumeClaimVolumeSource)
			**out = **in
		} else {
			out.PersistentVolumeClaim = nil
		}
		if in.RBD != nil {
			in, out := &in.RBD, &out.RBD
			*out = new(RBDVolumeSource)
			if err := DeepCopy_v1_RBDVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.RBD = nil
		}
		if in.FlexVolume != nil {
			in, out := &in.FlexVolume, &out.FlexVolume
			*out = new(FlexVolumeSource)
			if err := DeepCopy_v1_FlexVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.FlexVolume = nil
		}
		if in.Cinder != nil {
			in, out := &in.Cinder, &out.Cinder
			*out = new(CinderVolumeSource)
			**out = **in
		} else {
			out.Cinder = nil
		}
		if in.CephFS != nil {
			in, out := &in.CephFS, &out.CephFS
			*out = new(CephFSVolumeSource)
			if err := DeepCopy_v1_CephFSVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.CephFS = nil
		}
		if in.Flocker != nil {
			in, out := &in.Flocker, &out.Flocker
			*out = new(FlockerVolumeSource)
			**out = **in
		} else {
			out.Flocker = nil
		}
		if in.DownwardAPI != nil {
			in, out := &in.DownwardAPI, &out.DownwardAPI
			*out = new(DownwardAPIVolumeSource)
			if err := DeepCopy_v1_DownwardAPIVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.DownwardAPI = nil
		}
		if in.FC != nil {
			in, out := &in.FC, &out.FC
			*out = new(FCVolumeSource)
			if err := DeepCopy_v1_FCVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.FC = nil
		}
		if in.AzureFile != nil {
			in, out := &in.AzureFile, &out.AzureFile
			*out = new(AzureFileVolumeSource)
			**out = **in
		} else {
			out.AzureFile = nil
		}
		if in.ConfigMap != nil {
			in, out := &in.ConfigMap, &out.ConfigMap
			*out = new(ConfigMapVolumeSource)
			if err := DeepCopy_v1_ConfigMapVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.ConfigMap = nil
		}
		if in.VsphereVolume != nil {
			in, out := &in.VsphereVolume, &out.VsphereVolume
			*out = new(VsphereVirtualDiskVolumeSource)
			**out = **in
		} else {
			out.VsphereVolume = nil
		}
		if in.Quobyte != nil {
			in, out := &in.Quobyte, &out.Quobyte
			*out = new(QuobyteVolumeSource)
			**out = **in
		} else {
			out.Quobyte = nil
		}
		if in.AzureDisk != nil {
			in, out := &in.AzureDisk, &out.AzureDisk
			*out = new(AzureDiskVolumeSource)
			if err := DeepCopy_v1_AzureDiskVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.AzureDisk = nil
		}
		if in.Metadata != nil {
			in, out := &in.Metadata, &out.Metadata
			*out = new(DeprecatedDownwardAPIVolumeSource)
			if err := DeepCopy_v1_DeprecatedDownwardAPIVolumeSource(*in, *out, c); err != nil {
				return err
			}
		} else {
			out.Metadata = nil
		}
		return nil
	}
}

func DeepCopy_v1_VsphereVirtualDiskVolumeSource(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*VsphereVirtualDiskVolumeSource)
		out := out.(*VsphereVirtualDiskVolumeSource)
		out.VolumePath = in.VolumePath
		out.FSType = in.FSType
		return nil
	}
}

func DeepCopy_v1_WeightedPodAffinityTerm(in interface{}, out interface{}, c *conversion.Cloner) error {
	{
		in := in.(*WeightedPodAffinityTerm)
		out := out.(*WeightedPodAffinityTerm)
		out.Weight = in.Weight
		if err := DeepCopy_v1_PodAffinityTerm(&in.PodAffinityTerm, &out.PodAffinityTerm, c); err != nil {
			return err
		}
		return nil
	}
}
