#!/bin/bash
source "$(dirname "${BASH_SOURCE}")/lib/init.sh"

echo "===== Verifying API Swagger Spec ====="

SPECROOT="${OS_ROOT}/api"
REL_TMP_PATH="_output/verify-generated-swagger-spec"
TMP_SPECROOT="${OS_ROOT}/${REL_TMP_PATH}/api"

echo "Generating a fresh spec..."
if ! output=`${OS_ROOT}/hack/update-generated-swagger-spec.sh ${REL_TMP_PATH} 2>&1`
then
	echo "FAILURE: Generation of fresh spec failed:"
	echo "$output"
  exit 1
fi

# TODO: more effective way to do this, or have readme be generated
cp "${SPECROOT}/README.md" "${TMP_SPECROOT}"

echo "Diffing current spec against freshly generated spec..."
ret=0
diff -Naupr -I 'Auto generated by' "${SPECROOT}" "${TMP_SPECROOT}" || ret=$?
rm -rf "${TMP_SPECROOT}"
if [[ $ret -eq 0 ]]
then
  echo "SUCCESS: Swagger spec up to date."
else
  echo "FAILURE: Swagger spec is out of date. Please run hack/update-generated-swagger-spec.sh"
  exit 1
fi