package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_ClusterNetwork = map[string]string{
	"":                 "ClusterNetwork describes the cluster network. There is normally only one object of this type, named \"default\", which is created by the SDN network plugin based on the master configuration when the cluster is brought up for the first time.",
	"metadata":         "Standard object's metadata.",
	"network":          "Network is a CIDR string specifying the global overlay network's L3 space",
	"hostsubnetlength": "HostSubnetLength is the number of bits of network to allocate to each node. eg, 8 would mean that each node would have a /24 slice of the overlay network for its pods",
	"serviceNetwork":   "ServiceNetwork is the CIDR range that Service IP addresses are allocated from",
	"pluginName":       "PluginName is the name of the network plugin being used",
}

func (ClusterNetwork) SwaggerDoc() map[string]string {
	return map_ClusterNetwork
}

var map_ClusterNetworkList = map[string]string{
	"":         "ClusterNetworkList is a collection of ClusterNetworks",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of cluster networks",
}

func (ClusterNetworkList) SwaggerDoc() map[string]string {
	return map_ClusterNetworkList
}

var map_EgressNetworkPolicy = map[string]string{
	"":         "EgressNetworkPolicy describes the current egress network policy for a Namespace. When using the 'redhat/openshift-ovs-multitenant' network plugin, traffic from a pod to an IP address outside the cluster will be checked against each EgressNetworkPolicyRule in the pod's namespace's EgressNetworkPolicy, in order. If no rule matches (or no EgressNetworkPolicy is present) then the traffic will be allowed by default.",
	"metadata": "metadata for EgressNetworkPolicy",
	"spec":     "spec is the specification of the current egress network policy",
}

func (EgressNetworkPolicy) SwaggerDoc() map[string]string {
	return map_EgressNetworkPolicy
}

var map_EgressNetworkPolicyList = map[string]string{
	"":         "EgressNetworkPolicyList is a collection of EgressNetworkPolicy",
	"metadata": "metadata for EgressNetworkPolicyList",
	"items":    "items is the list of policies",
}

func (EgressNetworkPolicyList) SwaggerDoc() map[string]string {
	return map_EgressNetworkPolicyList
}

var map_EgressNetworkPolicyPeer = map[string]string{
	"":             "EgressNetworkPolicyPeer specifies a target to apply egress network policy to",
	"cidrSelector": "cidrSelector is the CIDR range to allow/deny traffic to",
}

func (EgressNetworkPolicyPeer) SwaggerDoc() map[string]string {
	return map_EgressNetworkPolicyPeer
}

var map_EgressNetworkPolicyRule = map[string]string{
	"":     "EgressNetworkPolicyRule contains a single egress network policy rule",
	"type": "type marks this as an \"Allow\" or \"Deny\" rule",
	"to":   "to is the target that traffic is allowed/denied to",
}

func (EgressNetworkPolicyRule) SwaggerDoc() map[string]string {
	return map_EgressNetworkPolicyRule
}

var map_EgressNetworkPolicySpec = map[string]string{
	"":       "EgressNetworkPolicySpec provides a list of policies on outgoing network traffic",
	"egress": "egress contains the list of egress policy rules",
}

func (EgressNetworkPolicySpec) SwaggerDoc() map[string]string {
	return map_EgressNetworkPolicySpec
}

var map_HostSubnet = map[string]string{
	"":         "HostSubnet describes the container subnet network on a node. The HostSubnet object must have the same name as the Node object it corresponds to.",
	"metadata": "Standard object's metadata.",
	"host":     "Host is the name of the node. (This is redundant with the object's name, and this field is not actually used any more.)",
	"hostIP":   "HostIP is the IP address to be used as a VTEP by other nodes in the overlay network",
	"subnet":   "Subnet is the CIDR range of the overlay network assigned to the node for its pods",
}

func (HostSubnet) SwaggerDoc() map[string]string {
	return map_HostSubnet
}

var map_HostSubnetList = map[string]string{
	"":         "HostSubnetList is a collection of HostSubnets",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of host subnets",
}

func (HostSubnetList) SwaggerDoc() map[string]string {
	return map_HostSubnetList
}

var map_NetNamespace = map[string]string{
	"":         "NetNamespace describes a single isolated network. When using the redhat/openshift-ovs-multitenant plugin, every Namespace will have a corresponding NetNamespace object with the same name. (When using redhat/openshift-ovs-subnet, NetNamespaces are not used.)",
	"metadata": "Standard object's metadata.",
	"netname":  "NetName is the name of the network namespace. (This is the same as the object's name, but both fields must be set.)",
	"netid":    "NetID is the network identifier of the network namespace assigned to each overlay network packet. This can be manipulated with the \"oadm pod-network\" commands.",
}

func (NetNamespace) SwaggerDoc() map[string]string {
	return map_NetNamespace
}

var map_NetNamespaceList = map[string]string{
	"":         "NetNamespaceList is a collection of NetNamespaces",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of net namespaces",
}

func (NetNamespaceList) SwaggerDoc() map[string]string {
	return map_NetNamespaceList
}
