// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	api "github.com/openshift/origin/pkg/route/api"
	pkg_api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_Route_To_api_Route,
		Convert_api_Route_To_v1_Route,
		Convert_v1_RouteIngress_To_api_RouteIngress,
		Convert_api_RouteIngress_To_v1_RouteIngress,
		Convert_v1_RouteIngressCondition_To_api_RouteIngressCondition,
		Convert_api_RouteIngressCondition_To_v1_RouteIngressCondition,
		Convert_v1_RouteList_To_api_RouteList,
		Convert_api_RouteList_To_v1_RouteList,
		Convert_v1_RoutePort_To_api_RoutePort,
		Convert_api_RoutePort_To_v1_RoutePort,
		Convert_v1_RouteSpec_To_api_RouteSpec,
		Convert_api_RouteSpec_To_v1_RouteSpec,
		Convert_v1_RouteStatus_To_api_RouteStatus,
		Convert_api_RouteStatus_To_v1_RouteStatus,
		Convert_v1_RouteTargetReference_To_api_RouteTargetReference,
		Convert_api_RouteTargetReference_To_v1_RouteTargetReference,
		Convert_v1_RouterShard_To_api_RouterShard,
		Convert_api_RouterShard_To_v1_RouterShard,
		Convert_v1_TLSConfig_To_api_TLSConfig,
		Convert_api_TLSConfig_To_v1_TLSConfig,
	)
}

func autoConvert_v1_Route_To_api_Route(in *Route, out *api.Route, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_RouteSpec_To_api_RouteSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_RouteStatus_To_api_RouteStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_Route_To_api_Route(in *Route, out *api.Route, s conversion.Scope) error {
	return autoConvert_v1_Route_To_api_Route(in, out, s)
}

func autoConvert_api_Route_To_v1_Route(in *api.Route, out *Route, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_RouteSpec_To_v1_RouteSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_RouteStatus_To_v1_RouteStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_Route_To_v1_Route(in *api.Route, out *Route, s conversion.Scope) error {
	return autoConvert_api_Route_To_v1_Route(in, out, s)
}

func autoConvert_v1_RouteIngress_To_api_RouteIngress(in *RouteIngress, out *api.RouteIngress, s conversion.Scope) error {
	SetDefaults_RouteIngress(in)
	out.Host = in.Host
	out.RouterName = in.RouterName
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]api.RouteIngressCondition, len(*in))
		for i := range *in {
			if err := Convert_v1_RouteIngressCondition_To_api_RouteIngressCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.WildcardPolicy = api.WildcardPolicyType(in.WildcardPolicy)
	return nil
}

func Convert_v1_RouteIngress_To_api_RouteIngress(in *RouteIngress, out *api.RouteIngress, s conversion.Scope) error {
	return autoConvert_v1_RouteIngress_To_api_RouteIngress(in, out, s)
}

func autoConvert_api_RouteIngress_To_v1_RouteIngress(in *api.RouteIngress, out *RouteIngress, s conversion.Scope) error {
	out.Host = in.Host
	out.RouterName = in.RouterName
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]RouteIngressCondition, len(*in))
		for i := range *in {
			if err := Convert_api_RouteIngressCondition_To_v1_RouteIngressCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.WildcardPolicy = WildcardPolicyType(in.WildcardPolicy)
	return nil
}

func Convert_api_RouteIngress_To_v1_RouteIngress(in *api.RouteIngress, out *RouteIngress, s conversion.Scope) error {
	return autoConvert_api_RouteIngress_To_v1_RouteIngress(in, out, s)
}

func autoConvert_v1_RouteIngressCondition_To_api_RouteIngressCondition(in *RouteIngressCondition, out *api.RouteIngressCondition, s conversion.Scope) error {
	out.Type = api.RouteIngressConditionType(in.Type)
	out.Status = pkg_api.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

func Convert_v1_RouteIngressCondition_To_api_RouteIngressCondition(in *RouteIngressCondition, out *api.RouteIngressCondition, s conversion.Scope) error {
	return autoConvert_v1_RouteIngressCondition_To_api_RouteIngressCondition(in, out, s)
}

func autoConvert_api_RouteIngressCondition_To_v1_RouteIngressCondition(in *api.RouteIngressCondition, out *RouteIngressCondition, s conversion.Scope) error {
	out.Type = RouteIngressConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

func Convert_api_RouteIngressCondition_To_v1_RouteIngressCondition(in *api.RouteIngressCondition, out *RouteIngressCondition, s conversion.Scope) error {
	return autoConvert_api_RouteIngressCondition_To_v1_RouteIngressCondition(in, out, s)
}

func autoConvert_v1_RouteList_To_api_RouteList(in *RouteList, out *api.RouteList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Route, len(*in))
		for i := range *in {
			if err := Convert_v1_Route_To_api_Route(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_RouteList_To_api_RouteList(in *RouteList, out *api.RouteList, s conversion.Scope) error {
	return autoConvert_v1_RouteList_To_api_RouteList(in, out, s)
}

func autoConvert_api_RouteList_To_v1_RouteList(in *api.RouteList, out *RouteList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Route, len(*in))
		for i := range *in {
			if err := Convert_api_Route_To_v1_Route(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_RouteList_To_v1_RouteList(in *api.RouteList, out *RouteList, s conversion.Scope) error {
	return autoConvert_api_RouteList_To_v1_RouteList(in, out, s)
}

func autoConvert_v1_RoutePort_To_api_RoutePort(in *RoutePort, out *api.RoutePort, s conversion.Scope) error {
	if err := pkg_api.Convert_intstr_IntOrString_To_intstr_IntOrString(&in.TargetPort, &out.TargetPort, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_RoutePort_To_api_RoutePort(in *RoutePort, out *api.RoutePort, s conversion.Scope) error {
	return autoConvert_v1_RoutePort_To_api_RoutePort(in, out, s)
}

func autoConvert_api_RoutePort_To_v1_RoutePort(in *api.RoutePort, out *RoutePort, s conversion.Scope) error {
	if err := pkg_api.Convert_intstr_IntOrString_To_intstr_IntOrString(&in.TargetPort, &out.TargetPort, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_RoutePort_To_v1_RoutePort(in *api.RoutePort, out *RoutePort, s conversion.Scope) error {
	return autoConvert_api_RoutePort_To_v1_RoutePort(in, out, s)
}

func autoConvert_v1_RouteSpec_To_api_RouteSpec(in *RouteSpec, out *api.RouteSpec, s conversion.Scope) error {
	SetDefaults_RouteSpec(in)
	out.Host = in.Host
	out.Path = in.Path
	if err := Convert_v1_RouteTargetReference_To_api_RouteTargetReference(&in.To, &out.To, s); err != nil {
		return err
	}
	if in.AlternateBackends != nil {
		in, out := &in.AlternateBackends, &out.AlternateBackends
		*out = make([]api.RouteTargetReference, len(*in))
		for i := range *in {
			if err := Convert_v1_RouteTargetReference_To_api_RouteTargetReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AlternateBackends = nil
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(api.RoutePort)
		if err := Convert_v1_RoutePort_To_api_RoutePort(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Port = nil
	}
	if in.TLS != nil {
		in, out := &in.TLS, &out.TLS
		*out = new(api.TLSConfig)
		if err := Convert_v1_TLSConfig_To_api_TLSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TLS = nil
	}
	out.WildcardPolicy = api.WildcardPolicyType(in.WildcardPolicy)
	return nil
}

func Convert_v1_RouteSpec_To_api_RouteSpec(in *RouteSpec, out *api.RouteSpec, s conversion.Scope) error {
	return autoConvert_v1_RouteSpec_To_api_RouteSpec(in, out, s)
}

func autoConvert_api_RouteSpec_To_v1_RouteSpec(in *api.RouteSpec, out *RouteSpec, s conversion.Scope) error {
	out.Host = in.Host
	out.Path = in.Path
	if err := Convert_api_RouteTargetReference_To_v1_RouteTargetReference(&in.To, &out.To, s); err != nil {
		return err
	}
	if in.AlternateBackends != nil {
		in, out := &in.AlternateBackends, &out.AlternateBackends
		*out = make([]RouteTargetReference, len(*in))
		for i := range *in {
			if err := Convert_api_RouteTargetReference_To_v1_RouteTargetReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AlternateBackends = nil
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(RoutePort)
		if err := Convert_api_RoutePort_To_v1_RoutePort(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Port = nil
	}
	if in.TLS != nil {
		in, out := &in.TLS, &out.TLS
		*out = new(TLSConfig)
		if err := Convert_api_TLSConfig_To_v1_TLSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TLS = nil
	}
	out.WildcardPolicy = WildcardPolicyType(in.WildcardPolicy)
	return nil
}

func Convert_api_RouteSpec_To_v1_RouteSpec(in *api.RouteSpec, out *RouteSpec, s conversion.Scope) error {
	return autoConvert_api_RouteSpec_To_v1_RouteSpec(in, out, s)
}

func autoConvert_v1_RouteStatus_To_api_RouteStatus(in *RouteStatus, out *api.RouteStatus, s conversion.Scope) error {
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]api.RouteIngress, len(*in))
		for i := range *in {
			if err := Convert_v1_RouteIngress_To_api_RouteIngress(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Ingress = nil
	}
	return nil
}

func Convert_v1_RouteStatus_To_api_RouteStatus(in *RouteStatus, out *api.RouteStatus, s conversion.Scope) error {
	return autoConvert_v1_RouteStatus_To_api_RouteStatus(in, out, s)
}

func autoConvert_api_RouteStatus_To_v1_RouteStatus(in *api.RouteStatus, out *RouteStatus, s conversion.Scope) error {
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]RouteIngress, len(*in))
		for i := range *in {
			if err := Convert_api_RouteIngress_To_v1_RouteIngress(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Ingress = nil
	}
	return nil
}

func Convert_api_RouteStatus_To_v1_RouteStatus(in *api.RouteStatus, out *RouteStatus, s conversion.Scope) error {
	return autoConvert_api_RouteStatus_To_v1_RouteStatus(in, out, s)
}

func autoConvert_v1_RouteTargetReference_To_api_RouteTargetReference(in *RouteTargetReference, out *api.RouteTargetReference, s conversion.Scope) error {
	SetDefaults_RouteTargetReference(in)
	out.Kind = in.Kind
	out.Name = in.Name
	out.Weight = in.Weight
	return nil
}

func Convert_v1_RouteTargetReference_To_api_RouteTargetReference(in *RouteTargetReference, out *api.RouteTargetReference, s conversion.Scope) error {
	return autoConvert_v1_RouteTargetReference_To_api_RouteTargetReference(in, out, s)
}

func autoConvert_api_RouteTargetReference_To_v1_RouteTargetReference(in *api.RouteTargetReference, out *RouteTargetReference, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Name = in.Name
	out.Weight = in.Weight
	return nil
}

func Convert_api_RouteTargetReference_To_v1_RouteTargetReference(in *api.RouteTargetReference, out *RouteTargetReference, s conversion.Scope) error {
	return autoConvert_api_RouteTargetReference_To_v1_RouteTargetReference(in, out, s)
}

func autoConvert_v1_RouterShard_To_api_RouterShard(in *RouterShard, out *api.RouterShard, s conversion.Scope) error {
	out.ShardName = in.ShardName
	out.DNSSuffix = in.DNSSuffix
	return nil
}

func Convert_v1_RouterShard_To_api_RouterShard(in *RouterShard, out *api.RouterShard, s conversion.Scope) error {
	return autoConvert_v1_RouterShard_To_api_RouterShard(in, out, s)
}

func autoConvert_api_RouterShard_To_v1_RouterShard(in *api.RouterShard, out *RouterShard, s conversion.Scope) error {
	out.ShardName = in.ShardName
	out.DNSSuffix = in.DNSSuffix
	return nil
}

func Convert_api_RouterShard_To_v1_RouterShard(in *api.RouterShard, out *RouterShard, s conversion.Scope) error {
	return autoConvert_api_RouterShard_To_v1_RouterShard(in, out, s)
}

func autoConvert_v1_TLSConfig_To_api_TLSConfig(in *TLSConfig, out *api.TLSConfig, s conversion.Scope) error {
	SetDefaults_TLSConfig(in)
	out.Termination = api.TLSTerminationType(in.Termination)
	out.Certificate = in.Certificate
	out.Key = in.Key
	out.CACertificate = in.CACertificate
	out.DestinationCACertificate = in.DestinationCACertificate
	out.InsecureEdgeTerminationPolicy = api.InsecureEdgeTerminationPolicyType(in.InsecureEdgeTerminationPolicy)
	return nil
}

func Convert_v1_TLSConfig_To_api_TLSConfig(in *TLSConfig, out *api.TLSConfig, s conversion.Scope) error {
	return autoConvert_v1_TLSConfig_To_api_TLSConfig(in, out, s)
}

func autoConvert_api_TLSConfig_To_v1_TLSConfig(in *api.TLSConfig, out *TLSConfig, s conversion.Scope) error {
	out.Termination = TLSTerminationType(in.Termination)
	out.Certificate = in.Certificate
	out.Key = in.Key
	out.CACertificate = in.CACertificate
	out.DestinationCACertificate = in.DestinationCACertificate
	out.InsecureEdgeTerminationPolicy = InsecureEdgeTerminationPolicyType(in.InsecureEdgeTerminationPolicy)
	return nil
}

func Convert_api_TLSConfig_To_v1_TLSConfig(in *api.TLSConfig, out *TLSConfig, s conversion.Scope) error {
	return autoConvert_api_TLSConfig_To_v1_TLSConfig(in, out, s)
}
