/* SPDX-License-Identifier: GPL-2.0 */

#ifndef _LINUX_PM_OPP_UPSTREAM
#define _LINUX_PM_OPP_UPSTREAM

#include <linux/cleanup.h>
#include <linux/pm_opp.h>

/* Scope based cleanup macro for OPP reference counting */
DEFINE_FREE(put_opp, struct dev_pm_opp *, if (!IS_ERR_OR_NULL(_T)) dev_pm_opp_put(_T))

/* Scope based cleanup macro for OPP table reference counting */
DEFINE_FREE(put_opp_table, struct opp_table *, if (!IS_ERR_OR_NULL(_T)) dev_pm_opp_put_opp_table(_T))

static inline int dev_pm_opp_set_level(struct device *dev, unsigned int level)
{
	struct dev_pm_opp *opp __free(put_opp) = dev_pm_opp_find_level_exact(dev, level);

	if (IS_ERR(opp))
		return PTR_ERR(opp);

	return dev_pm_opp_set_opp(dev, opp);
}

#endif		/* _LINUX_PM_OPP_UPSTREAM */
