/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class DumpFileUtils {
    private DumpFileUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static synchronized File newDumpFile(File reportsDir, String dumpFileName) {
        return new File(reportsDir, dumpFileName);
    }

    public static void dumpException(Throwable t, File dumpFile) {
        DumpFileUtils.dumpException(t, null, dumpFile);
    }

    public static void dumpException(Throwable t, String msg, File dumpFile) {
        try {
            if (t != null && dumpFile != null && (dumpFile.exists() || DumpFileUtils.mkdirs(dumpFile) && dumpFile.createNewFile())) {
                Writer fw = DumpFileUtils.createWriter(dumpFile);
                if (msg != null) {
                    fw.append(msg).append(StringUtils.NL);
                }
                PrintWriter pw = new PrintWriter(fw);
                t.printStackTrace(pw);
                pw.flush();
                fw.append(StringUtils.NL).append(StringUtils.NL).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void dumpText(String msg, File dumpFile) {
        try {
            if (msg != null && dumpFile != null && (dumpFile.exists() || DumpFileUtils.mkdirs(dumpFile) && dumpFile.createNewFile())) {
                DumpFileUtils.createWriter(dumpFile).append(msg).append(StringUtils.NL).append(StringUtils.NL).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String newFormattedDateFileName() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss_SSS").format(new Date());
    }

    private static Writer createWriter(File dumpFile) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile, true), StringUtils.UTF_8).append("# Created at ").append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date())).append(StringUtils.NL);
    }

    private static boolean mkdirs(File dumpFile) {
        File dir = dumpFile.getParentFile();
        return dir.exists() || dir.mkdirs();
    }
}

