/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.test.SlowTests;
import org.openjdk.jmc.common.test.TestToolkit;
import org.openjdk.jmc.common.test.io.IOResource;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestRulesWithJfr {
    private static final String JFR_RULE_BASELINE_JFR = "JfrRuleBaseline.xml";
    private static final String BASELINE_DIR = "baseline";
    static final String RECORDINGS_DIR = "jfr";
    static final String RECORDINGS_INDEXFILE = "index.txt";
    private TimeZone defaultTimeZone;

    @Before
    public void before() {
        DetailsTracker.clear();
        this.defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @After
    public void after() {
        TimeZone.setDefault(this.defaultTimeZone);
    }

    @Test
    public void verifyOneResult() throws IOException {
        this.verifyRuleResults(true);
    }

    @Category(value={SlowTests.class})
    @Test
    public void verifyAllResults() throws IOException {
        this.verifyRuleResults(false);
    }

    private void verifyRuleResults(boolean onlyOneRecording) throws IOException {
        ReportCollection baselineReport;
        ReportCollection rulesReport;
        boolean resultsEqual;
        IOResourceSet jfrs = TestToolkit.getResourcesInDirectory(TestRulesWithJfr.class, (String)RECORDINGS_DIR, (String)RECORDINGS_INDEXFILE);
        String reportName = null;
        if (onlyOneRecording) {
            IOResource firstJfr = (IOResource)jfrs.iterator().next();
            jfrs = new IOResourceSet(new IOResource[]{firstJfr});
            reportName = firstJfr.getName();
        }
        if (!(resultsEqual = (rulesReport = TestRulesWithJfr.generateRulesReport(jfrs)).compareAndLog(baselineReport = TestRulesWithJfr.parseRulesReportXml(BASELINE_DIR, JFR_RULE_BASELINE_JFR, reportName)))) {
            TestRulesWithJfr.saveToFile(rulesReport.toXml(), BASELINE_DIR, JFR_RULE_BASELINE_JFR, onlyOneRecording);
        }
        Assert.assertTrue((String)DetailsTracker.getEntries(), (boolean)resultsEqual);
    }

    private static void saveToFile(Document doc, String directory, String fileName, boolean onlyOneRecording) {
        String filePath = TestRulesWithJfr.getResultDir().getAbsolutePath() + File.separator + (directory != null ? directory + File.separator : "") + (onlyOneRecording ? "Generated_One_" : "Generated_") + fileName;
        File resultFile = new File(filePath);
        TestRulesWithJfr.prepareFile(resultFile);
        try (FileOutputStream resultFos = new FileOutputStream(resultFile);){
            TestRulesWithJfr.writeDomToStream(doc, resultFos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void prepareFile(File file) {
        File parent;
        if (file.exists()) {
            file.delete();
        }
        if ((parent = file.getParentFile()) != null) {
            parent.mkdirs();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Error creating file \"" + file.getAbsolutePath() + "\". Error:\n" + e.getMessage()));
        }
    }

    private static void writeDomToStream(Document doc, OutputStream os) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult console = new StreamResult(os);
            transformer.transform(source, console);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static ReportCollection parseRulesReportXml(String directory, String fileName, String reportName) {
        ReportCollection collection = new ReportCollection();
        try {
            File dir = TestToolkit.materialize(TestRulesWithJfr.class, (String)directory, (String)fileName);
            File file = new File(dir, fileName);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document baselineDoc = docBuilder.parse(file);
            collection = ReportCollection.fromXml(baselineDoc, reportName);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return collection;
    }

    private static ReportCollection generateRulesReport(IOResourceSet jfrs) {
        ReportCollection collection = new ReportCollection();
        for (IOResource jfr : jfrs) {
            Report report = TestRulesWithJfr.generateReport(jfr, false, null);
            collection.put(report.getName(), report);
        }
        return collection;
    }

    private static File getResultDir() {
        if (System.getProperty("results.dir") != null) {
            return new File(System.getProperty("results.dir"));
        }
        return new File(System.getProperty("user.dir"));
    }

    private static boolean shouldEvaluate(Map<Class<? extends IRule>, Severity> evaluatedRules, IRule rule) {
        Class dependencyType;
        DependsOn dependency = rule.getClass().getAnnotation(DependsOn.class);
        if (dependency != null && (dependencyType = dependency.value()) != null) {
            while (!evaluatedRules.containsKey(dependencyType)) {
            }
            return evaluatedRules.get(dependencyType).compareTo((Enum)dependency.severity()) >= 0;
        }
        return true;
    }

    private static Report generateReport(IOResource jfr, boolean verbose, Severity minSeverity) {
        Report report = new Report(jfr.getName());
        ResultProvider rp = new ResultProvider();
        HashMap<Class<? extends IRule>, Severity> evaluatedRules = new HashMap<Class<? extends IRule>, Severity>();
        try {
            IItemCollection events = JfrLoaderToolkit.loadEvents((InputStream)jfr.open());
            for (IRule rule : RuleRegistry.getRules()) {
                if (!TestRulesWithJfr.shouldEvaluate(evaluatedRules, rule)) continue;
                try {
                    IResult result;
                    RunnableFuture future = rule.createEvaluation(events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)rp);
                    if (!RulesToolkit.matchesEventAvailabilityMap((IItemCollection)events, (Map)rule.getRequiredEvents())) {
                        result = ResultBuilder.createFor((IRule)rule, (IPreferenceValueProvider)IPreferenceValueProvider.DEFAULT_VALUES).setSeverity(Severity.NA).build();
                    } else {
                        future.run();
                        result = (IResult)future.get();
                    }
                    evaluatedRules.put(rule.getClass(), result.getSeverity());
                    rp.addResults(result);
                    if (minSeverity != null && result.getSeverity().compareTo((Enum)minSeverity) < 0) continue;
                    ItemSet itemSet = null;
                    IItemQuery itemQuery = (IItemQuery)result.getResult(TypedResult.ITEM_QUERY);
                    if (verbose && itemQuery != null && !itemQuery.getAttributes().isEmpty()) {
                        itemSet = new ItemSet();
                        IItemCollection resultEvents = events.apply(itemQuery.getFilter());
                        Collection attributes = itemQuery.getAttributes();
                        for (IAttribute attribute : attributes) {
                            itemSet.addField(attribute.getName());
                        }
                        for (IItemIterable ii : resultEvents) {
                            IType type = ii.getType();
                            ArrayList<IMemberAccessor> accessors = new ArrayList<IMemberAccessor>(attributes.size());
                            for (IAttribute a : attributes) {
                                accessors.add(a.getAccessor(type));
                            }
                            Iterator items = ii.iterator();
                            while (items.hasNext()) {
                                ItemList itemList = new ItemList();
                                IItem item = (IItem)items.next();
                                for (IMemberAccessor a : accessors) {
                                    itemList.add(String.valueOf(a.getMember((Object)item)));
                                }
                                itemSet.addItem(itemList);
                            }
                        }
                    }
                    RuleResult ruleResult = new RuleResult(result, itemSet);
                    report.put(String.valueOf(result.getRule().getId()), ruleResult);
                }
                catch (InterruptedException | RuntimeException | ExecutionException e) {
                    e.printStackTrace();
                    System.out.println("Problem while evaluating rules for \"" + jfr.getName() + "\". Message: " + e.getLocalizedMessage());
                    evaluatedRules.put(rule.getClass(), Severity.NA);
                }
            }
        }
        catch (IOException | CouldNotLoadRecordingException e) {
            e.printStackTrace();
        }
        return report;
    }

    private static Element createValueNode(Document doc, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value != null ? value : ""));
        return node;
    }

    private static List<String> getNodeValues(String xpathExpr, Node node) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expression = xpath.compile(xpathExpr);
            NodeList nodes = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node thisNodeOnly = nodes.item(i);
                thisNodeOnly.getParentNode().removeChild(thisNodeOnly);
                Node child = thisNodeOnly.getFirstChild();
                if (child != null) {
                    values.add(child.getNodeValue());
                    continue;
                }
                values.add("");
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return values;
    }

    private static NodeList getNodeSet(String expr, Node node) {
        NodeList result = null;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xPath = xpath.compile(expr);
            result = (NodeList)xPath.evaluate(node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static class DetailsTracker {
        private static Deque<String> entries = new ArrayDeque<String>();

        private DetailsTracker() {
        }

        public static void log(String entry) {
            entries.addFirst(entry);
        }

        public static String getEntries() {
            StringBuilder sb = new StringBuilder();
            for (String entry : entries) {
                sb.append(entry);
            }
            return sb.toString();
        }

        public static void clear() {
            entries.clear();
        }
    }

    private static class ItemList {
        private List<String> items;

        public ItemList() {
            this.items = new ArrayList<String>();
        }

        private ItemList(List<String> list) {
            this.items = list;
        }

        public void add(String item) {
            this.items.add(item);
        }

        public String toString() {
            return this.items.toString();
        }

        public boolean equals(Object other) {
            ItemList otherItemList = (ItemList)other;
            boolean equals = this.items.equals(otherItemList.items);
            if (!equals) {
                DetailsTracker.log("Item lists differ: " + this.items + " was not equal to " + otherItemList.items + ". ");
            }
            return equals;
        }

        public void toXml(Element parent) {
            Element itemNode = parent.getOwnerDocument().createElement("item");
            parent.appendChild(itemNode);
            for (String item : this.items) {
                itemNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "value", item));
            }
        }

        public static ItemList fromXml(Node node) {
            return new ItemList(TestRulesWithJfr.getNodeValues("./value", node));
        }
    }

    private static class ItemSet {
        private List<String> fields;
        private List<ItemList> items;

        public ItemSet() {
            this.fields = new ArrayList<String>();
            this.items = new ArrayList<ItemList>();
        }

        private ItemSet(List<String> fields, List<ItemList> items) {
            this.fields = fields;
            this.items = items;
        }

        public void addField(String field) {
            this.fields.add(field);
        }

        public void addItem(ItemList itemList) {
            this.items.add(itemList);
        }

        public String toString() {
            return "Fields: " + this.fields + "\n      Items: " + this.items;
        }

        public boolean compareAndLog(Object other) {
            boolean itemEquality;
            ItemSet otherItemSet = (ItemSet)other;
            boolean fieldEquality = this.fields.equals(otherItemSet.fields);
            if (!fieldEquality) {
                DetailsTracker.log("Item fields differ: " + this.fields + " was not equal to " + otherItemSet.fields + ". ");
            }
            return (itemEquality = this.items.equals(otherItemSet.items)) && fieldEquality;
        }

        public void toXml(Element parent) {
            Element itemSetNode = parent.getOwnerDocument().createElement("itemset");
            parent.appendChild(itemSetNode);
            Element fieldsNode = parent.getOwnerDocument().createElement("fields");
            itemSetNode.appendChild(fieldsNode);
            for (String field : this.fields) {
                Element fieldNode = parent.getOwnerDocument().createElement("field");
                fieldsNode.appendChild(fieldNode);
                fieldNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "name", field));
            }
            Element itemsNode = parent.getOwnerDocument().createElement("items");
            itemSetNode.appendChild(itemsNode);
            for (ItemList list : this.items) {
                list.toXml(itemsNode);
            }
        }

        public static ItemSet fromXml(Node node) {
            ItemSet set = null;
            ArrayList<ItemList> itemList = new ArrayList<ItemList>();
            NodeList items = TestRulesWithJfr.getNodeSet("./items/item", node);
            for (int i = 0; i < items.getLength(); ++i) {
                Node thisItemOnly = items.item(i);
                thisItemOnly.getParentNode().removeChild(thisItemOnly);
                itemList.add(ItemList.fromXml(thisItemOnly));
            }
            List fields = TestRulesWithJfr.getNodeValues("./fields/field/name", node);
            set = new ItemSet(fields, itemList);
            return set;
        }
    }

    private static class RuleResult {
        private String id;
        private String severity;
        private String summary;
        private String solution;
        private String explanation;
        private ItemSet itemset;

        public RuleResult(IResult result, ItemSet itemset) {
            this.id = result.getRule().getId();
            this.severity = result.getSeverity().getLocalizedName();
            this.summary = ResultToolkit.populateMessage((IResult)result, (String)result.getSummary(), (boolean)true);
            this.solution = ResultToolkit.populateMessage((IResult)result, (String)result.getSolution(), (boolean)true);
            this.explanation = ResultToolkit.populateMessage((IResult)result, (String)result.getExplanation(), (boolean)true);
            this.itemset = itemset;
        }

        public RuleResult(String id, String severity, String summary, String explanation, String solution, ItemSet itemset) {
            this.id = id;
            this.severity = severity;
            this.summary = summary;
            this.solution = solution;
            this.explanation = explanation;
            this.itemset = itemset;
        }

        public String getId() {
            return this.id;
        }

        public boolean compareAndLog(Object other) {
            boolean ruleEquality;
            RuleResult otherRule = (RuleResult)other;
            boolean itemSetEquality = this.compareAndLogItemSets(other);
            boolean bl = ruleEquality = Objects.equals(this.severity, otherRule.severity) && Objects.equals(this.summary, otherRule.summary) && Objects.equals(this.explanation, otherRule.explanation) && Objects.equals(this.solution, otherRule.solution);
            if (!ruleEquality) {
                if (!Objects.equals(this.severity, otherRule.severity)) {
                    DetailsTracker.log("\n    Severity mismatch: \"" + this.severity + "\" was not equal to \"" + otherRule.severity + "\". ");
                }
                if (!Objects.equals(this.summary, otherRule.summary)) {
                    DetailsTracker.log("\n    Summary mismatch: \"" + this.summary + "\" was not equal to \"" + otherRule.summary + "\". ");
                }
                if (!Objects.equals(this.solution, otherRule.solution)) {
                    DetailsTracker.log("\n    Solution mismatch: \"" + this.solution + "\" was not equal to \"" + otherRule.solution + "\". ");
                }
                if (!Objects.equals(this.explanation, otherRule.explanation)) {
                    DetailsTracker.log("\n    Explanation mismatch: \"" + this.explanation + "\" was not equal to \"" + otherRule.explanation + "\". ");
                }
            }
            if (!itemSetEquality || !ruleEquality) {
                DetailsTracker.log("\n  Rule: \"" + this.id + "\". ");
            }
            return itemSetEquality && ruleEquality;
        }

        private boolean compareAndLogItemSets(Object other) {
            RuleResult otherRule = (RuleResult)other;
            if (this.itemset != null && otherRule.itemset != null) {
                return this.itemset.compareAndLog(otherRule.itemset);
            }
            if (this.itemset == null && otherRule.itemset == null) {
                return true;
            }
            if (this.itemset == null) {
                DetailsTracker.log("\n    This item set was null while the other wasn't. The other: " + otherRule.itemset + ". ");
            } else {
                DetailsTracker.log("\n    The other item set was null while this wasn't. This: " + this.itemset + ". ");
            }
            return false;
        }

        public void toXml(Element parent) {
            Element ruleNode = parent.getOwnerDocument().createElement("rule");
            parent.appendChild(ruleNode);
            ruleNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "id", this.id));
            ruleNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "severity", this.severity));
            if (this.summary != null) {
                ruleNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "summary", this.summary));
            }
            if (this.explanation != null) {
                ruleNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "explanation", this.explanation));
            }
            if (this.solution != null) {
                ruleNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "solution", this.solution));
            }
            if (this.itemset != null) {
                this.itemset.toXml(ruleNode);
            }
        }

        public static RuleResult fromXml(Node node) {
            RuleResult rule = null;
            String summary = RuleResult.getOptional(TestRulesWithJfr.getNodeValues("./summary", node));
            String explanation = RuleResult.getOptional(TestRulesWithJfr.getNodeValues("./explanation", node));
            String solution = RuleResult.getOptional(TestRulesWithJfr.getNodeValues("./solution", node));
            NodeList items = TestRulesWithJfr.getNodeSet("./itemset", node);
            ItemSet itemset = null;
            if (items != null && items.getLength() == 1) {
                itemset = ItemSet.fromXml(items.item(0));
            }
            rule = new RuleResult((String)TestRulesWithJfr.getNodeValues("./id", node).get(0), (String)TestRulesWithJfr.getNodeValues("./severity", node).get(0), summary, explanation, solution, itemset);
            return rule;
        }

        private static String getOptional(List<String> optionalMessage) {
            String message = null;
            if (optionalMessage != null && optionalMessage.size() == 1) {
                message = optionalMessage.get(0);
            }
            return message;
        }
    }

    private static class Report {
        private String filename;
        private SortedMap<String, RuleResult> rules;

        public Report(String filename) {
            this.filename = filename;
            this.rules = new TreeMap<String, RuleResult>();
        }

        public void put(String id, RuleResult rule) {
            this.rules.put(id, rule);
        }

        public RuleResult get(String id) {
            return (RuleResult)this.rules.get(id);
        }

        public String getName() {
            return this.filename;
        }

        public boolean compareAndLog(Object other) {
            Report otherReport = (Report)other;
            boolean equals = this.rules.size() == otherReport.rules.size();
            boolean fileNamePrinted = false;
            if (equals) {
                for (String rulename : this.rules.keySet()) {
                    RuleResult otherRule = otherReport.get(rulename);
                    if (otherRule != null) {
                        equals = ((RuleResult)this.rules.get(rulename)).compareAndLog(otherRule) && equals;
                        if (equals || fileNamePrinted) continue;
                        DetailsTracker.log("\n\nReport: \"" + this.filename + "\", ");
                        fileNamePrinted = true;
                        continue;
                    }
                    DetailsTracker.log("\n\nReport: \"" + this.filename + "\". Rule result for " + rulename + " could not be found in the other report. ");
                    equals = false;
                }
            } else {
                if (this.rules.size() > otherReport.rules.size()) {
                    for (String ruleId : this.rules.keySet()) {
                        RuleResult otherRule = otherReport.get(ruleId);
                        if (otherRule != null) {
                            equals = ((RuleResult)this.rules.get(ruleId)).compareAndLog(otherRule) && equals;
                            continue;
                        }
                        DetailsTracker.log("\nReport for file \"" + this.filename + "\", rule result for \"" + ruleId + "\" could not be found in the other report. ");
                    }
                } else {
                    for (String ruleId : otherReport.rules.keySet()) {
                        RuleResult rule = (RuleResult)this.rules.get(ruleId);
                        if (rule != null) {
                            equals = rule.compareAndLog(otherReport.rules.get(ruleId)) && equals;
                            continue;
                        }
                        DetailsTracker.log("\nReport for file \"" + this.filename + "\", rule result for \"" + ruleId + "\" could not be found in this report. ");
                    }
                }
                DetailsTracker.log("\n");
            }
            return equals;
        }

        public void toXml(Element parent) {
            Element reportNode = parent.getOwnerDocument().createElement("report");
            parent.appendChild(reportNode);
            reportNode.appendChild(TestRulesWithJfr.createValueNode(parent.getOwnerDocument(), "file", this.filename));
            for (RuleResult rule : this.rules.values()) {
                rule.toXml(reportNode);
            }
        }

        public static Report fromXml(Node node) {
            Report report = new Report((String)TestRulesWithJfr.getNodeValues("./file", node).get(0));
            NodeList rules = TestRulesWithJfr.getNodeSet("./rule", node);
            for (int i = 0; i < rules.getLength(); ++i) {
                Node thisRuleOnly = rules.item(i);
                thisRuleOnly.getParentNode().removeChild(thisRuleOnly);
                RuleResult rule = RuleResult.fromXml(thisRuleOnly);
                report.put(rule.getId(), rule);
            }
            return report;
        }
    }

    private static class ReportCollection {
        private SortedMap<String, Report> reports = new TreeMap<String, Report>();

        public void put(String filename, Report report) {
            this.reports.put(filename, report);
        }

        public Report get(String filename) {
            return (Report)this.reports.get(filename);
        }

        public boolean compareAndLog(Object other) {
            boolean equals;
            ReportCollection otherReportCollection = (ReportCollection)other;
            boolean bl = equals = this.reports.size() == otherReportCollection.reports.size();
            if (!equals) {
                if (this.reports.size() > otherReportCollection.reports.size()) {
                    for (String reportname : this.reports.keySet()) {
                        if (otherReportCollection.get(reportname) != null) continue;
                        DetailsTracker.log("Report for " + reportname + " could not be found in the other report collection. ");
                    }
                } else {
                    for (String reportname : otherReportCollection.reports.keySet()) {
                        if (this.reports.get(reportname) != null) continue;
                        DetailsTracker.log("Report for " + reportname + " could not be found in this report collection. ");
                    }
                }
                DetailsTracker.log("\n");
            }
            for (String reportname : this.reports.keySet()) {
                Report otherReport = otherReportCollection.get(reportname);
                if (otherReport != null) {
                    equals = ((Report)this.reports.get(reportname)).compareAndLog(otherReport) && equals;
                    continue;
                }
                DetailsTracker.log("\nReport for " + reportname + " could not be found in the other report collection. ");
                equals = false;
            }
            return equals;
        }

        public Document toXml() {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            Document doc = null;
            try {
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("reportcollection");
                doc.appendChild(rootElement);
                for (Report report : this.reports.values()) {
                    report.toXml(rootElement);
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return doc;
        }

        public static ReportCollection fromXml(Document doc, String reportName) {
            ReportCollection collection = new ReportCollection();
            NodeList reports = TestRulesWithJfr.getNodeSet("//report", doc);
            for (int i = 0; i < reports.getLength(); ++i) {
                Node thisReportOnly = reports.item(i);
                thisReportOnly.getParentNode().removeChild(thisReportOnly);
                Report report = Report.fromXml(thisReportOnly);
                if (reportName != null && !report.getName().equals(reportName)) continue;
                collection.put(report.getName(), report);
            }
            return collection;
        }
    }
}

