/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;

public class QuantityRangeTest {
    @Test
    public void intersection_overlap() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(5L), (IQuantity)UnitLookup.SECOND.quantity(15L));
        IRange intersection = QuantityRange.intersection((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(5L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        Assert.assertEquals((Object)expected, (Object)intersection);
    }

    @Test
    public void intersection_full_overlap() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange intersection = QuantityRange.intersection((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        Assert.assertEquals((Object)expected, (Object)intersection);
    }

    @Test
    public void intersection_limit() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(10L), (IQuantity)UnitLookup.SECOND.quantity(20L));
        IRange intersection = QuantityRange.intersection((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(10L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        Assert.assertEquals((Object)expected, (Object)intersection);
    }

    @Test
    public void intersection_disjoint() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(5L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(10L), (IQuantity)UnitLookup.SECOND.quantity(15L));
        IRange intersection = QuantityRange.intersection((IRange)r1, (IRange)r2);
        Assert.assertNull((Object)intersection);
    }

    @Test
    public void union_overlap() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(5L), (IQuantity)UnitLookup.SECOND.quantity(15L));
        IRange union = QuantityRange.union((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(15L));
        Assert.assertEquals((Object)expected, (Object)union);
    }

    @Test
    public void union_full_overlap() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange union = QuantityRange.union((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        Assert.assertEquals((Object)expected, (Object)union);
    }

    @Test
    public void union_limit() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(10L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(10L), (IQuantity)UnitLookup.SECOND.quantity(20L));
        IRange union = QuantityRange.union((IRange)r1, (IRange)r2);
        IRange expected = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(20L));
        Assert.assertEquals((Object)expected, (Object)union);
    }

    @Test
    public void union_disjoint() {
        IRange r1 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(0L), (IQuantity)UnitLookup.SECOND.quantity(5L));
        IRange r2 = QuantityRange.createWithEnd((IQuantity)UnitLookup.SECOND.quantity(10L), (IQuantity)UnitLookup.SECOND.quantity(15L));
        IRange union = QuantityRange.union((IRange)r1, (IRange)r2);
        Assert.assertNull((Object)union);
    }
}

