/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.test.unit.AdHocQuantityTest;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;

@RunWith(value=Parameterized.class)
public class KindOfQuantityTest
extends MCTestCase {
    @Parameterized.Parameter
    public KindOfQuantity<?> kindOfQuantity;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> units = new ArrayList<Object[]>();
        for (ContentType type : UnitLookup.getAllContentTypes()) {
            if (!(type instanceof KindOfQuantity)) continue;
            Object[] array = new Object[]{type, KindOfQuantityTest.class.getSimpleName() + ": " + type.getIdentifier()};
            units.add(array);
        }
        return units;
    }

    protected static IQuantity randomQuantity(IUnit unit, Random rnd) {
        return rnd.nextBoolean() ? unit.quantity(rnd.nextDouble()) : unit.quantity(rnd.nextLong());
    }

    protected static ITypedQuantity<LinearUnit> randomQuantity(LinearUnit unit, Random rnd) {
        return rnd.nextBoolean() ? unit.quantity(rnd.nextDouble()) : unit.quantity(rnd.nextLong());
    }

    protected static ITypedQuantity<LinearUnit> randomPositiveQuantity(LinearUnit unit, Random rnd) {
        return rnd.nextBoolean() ? unit.quantity(Math.abs(rnd.nextDouble())) : unit.quantity(Math.abs(rnd.nextLong()));
    }

    protected static ITypedQuantity<LinearUnit> randomCustomQuantity(LinearUnit unit, Random rnd) {
        ITypedQuantity<LinearUnit> unitQuantity = KindOfQuantityTest.randomPositiveQuantity(unit, rnd);
        LinearUnit customUnit = unit.getContentType().makeCustomUnit(unitQuantity);
        return KindOfQuantityTest.randomQuantity(customUnit, rnd);
    }

    @Test
    public void testAllUnitsSupersetOfCommon() {
        if (!this.kindOfQuantity.getAllUnits().containsAll(this.kindOfQuantity.getCommonUnits())) {
            HashSet missing = new HashSet(this.kindOfQuantity.getCommonUnits());
            missing.removeAll(this.kindOfQuantity.getAllUnits());
            Assert.fail((String)("Common units not in 'all': " + missing));
        }
    }

    @Test
    public void testUnitUniqueness() {
        Collection units = this.kindOfQuantity.getAllUnits();
        HashMap<String, IUnit> strToUnit = new HashMap<String, IUnit>();
        for (IUnit unit : units) {
            KindOfQuantityTest.assertNull("Unit " + unit + " ID collides with other unit", strToUnit.put(unit.getIdentifier(), unit));
            if (unit.getIdentifier().equals(unit.getLocalizedSymbol())) continue;
            KindOfQuantityTest.assertNull("Unit " + unit + " symbol collides with other unit", strToUnit.put(unit.getLocalizedDescription(), unit));
        }
    }

    @Test
    public void testUnitLookupByIdentifier() {
        Collection units = this.kindOfQuantity.getAllUnits();
        for (IUnit unit : units) {
            String id = UnitLookup.getUnitIdentifier((IUnit)unit);
            IUnit backUnit = UnitLookup.getUnitOrNull((String)id);
            Assert.assertEquals((Object)unit, (Object)backUnit);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ScalarUnitTest
    extends MCTestCase {
        @Parameterized.Parameter
        public IUnit unit;
        @Parameterized.Parameter(value=1)
        public String name;

        @Parameterized.Parameters(name="{1}")
        public static Collection<Object[]> data() {
            ArrayList<Object[]> units = new ArrayList<Object[]>();
            for (ContentType type : UnitLookup.getAllContentTypes()) {
                if (!(type instanceof LinearKindOfQuantity)) continue;
                KindOfQuantity kind = (KindOfQuantity)type;
                for (IUnit unit : kind.getAllUnits()) {
                    Object[] array = new Object[]{unit, ScalarUnitTest.class.getSimpleName() + " (" + type.getIdentifier() + "): " + unit.getIdentifier()};
                    units.add(array);
                }
            }
            return units;
        }

        @Test
        public void testDefaultFormat() {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = KindOfQuantityTest.randomQuantity(this.unit, rnd);
                try {
                    Assert.assertNotNull((Object)KindOfQuantity.format((Number)quantity.doubleValue(), (IUnit)this.unit));
                    continue;
                }
                catch (NullPointerException e) {
                    throw new NullPointerException("When formatting " + quantity);
                }
            }
        }

        private static void assertNotEquals(Object unexpected, Object actual) {
            if (unexpected.equals(actual)) {
                Assert.fail((String)("Unexpectedly equal: " + unexpected + " and " + actual));
            }
        }

        private static void assertAllSpacesAreNonBreaking(String displayStr) {
            boolean hasBreaking = displayStr.contains(" ");
            if (hasBreaking) {
                Assert.fail((String)("Breaking spaces in : " + displayStr.replace('\u00a0', '_')));
            }
        }

        private static void assertAllSpacesAreBreaking(String displayStr) {
            boolean hasNonBreaking = displayStr.contains("\u00a0");
            if (hasNonBreaking) {
                Assert.fail((String)("Non-breaking spaces (shown as '_') in : " + displayStr.replace('\u00a0', '_')));
            }
        }

        @Test
        public void testUnitSymbol() {
            ScalarUnitTest.assertAllSpacesAreNonBreaking(this.unit.getLocalizedSymbol());
        }

        @Test
        public void testCommonFormats() {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = KindOfQuantityTest.randomQuantity(this.unit, rnd);
                String auto = quantity.displayUsing("auto");
                String exact = quantity.displayUsing("exact");
                String verbose = quantity.displayUsing("verbose");
                ScalarUnitTest.assertAllSpacesAreNonBreaking(auto);
                ScalarUnitTest.assertAllSpacesAreNonBreaking(exact);
                if (exact.length() == verbose.length()) {
                    ScalarUnitTest.assertAllSpacesAreNonBreaking(verbose);
                }
                if (auto.length() > exact.length()) {
                    Assert.fail((String)("auto (" + auto + ").len <= exact (" + exact + ").len"));
                }
                if (exact.length() <= verbose.length()) continue;
                Assert.fail((String)("exact (" + exact + ").len <= verbose (" + verbose + ").len"));
            }
        }

        @Test
        public void testInteractiveSpaces() {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = KindOfQuantityTest.randomQuantity(this.unit, rnd);
                String interactive = quantity.interactiveFormat();
                ScalarUnitTest.assertAllSpacesAreBreaking(interactive);
            }
        }

        @Test
        public void testPersistedSpaces() {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = KindOfQuantityTest.randomQuantity(this.unit, rnd);
                String persisted = quantity.persistableString();
                ScalarUnitTest.assertAllSpacesAreBreaking(persisted);
            }
        }

        @Test
        public void testCustomUnitSymbols() {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> quantity = KindOfQuantityTest.randomCustomQuantity(unit, rnd);
                ScalarUnitTest.assertAllSpacesAreNonBreaking(quantity.getUnit().getLocalizedSymbol());
            }
        }

        @Test
        public void testCustomCommonFormats() {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> quantity = KindOfQuantityTest.randomCustomQuantity(unit, rnd);
                String auto = quantity.displayUsing("auto");
                String exact = quantity.displayUsing("exact");
                String verbose = quantity.displayUsing("verbose");
                ScalarUnitTest.assertAllSpacesAreNonBreaking(auto);
                ScalarUnitTest.assertAllSpacesAreNonBreaking(exact);
                if (exact.length() == verbose.length()) {
                    ScalarUnitTest.assertAllSpacesAreNonBreaking(verbose);
                }
                Assert.assertTrue((String)"auto <= exact", (auto.length() <= exact.length() ? 1 : 0) != 0);
                Assert.assertTrue((String)"exact <= verbose", (exact.length() <= verbose.length() ? 1 : 0) != 0);
            }
        }

        @Test
        public void testCustomInteractiveSpaces() {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> quantity = KindOfQuantityTest.randomCustomQuantity(unit, rnd);
                String interactive = quantity.interactiveFormat();
                String customInteractive = quantity.interactiveFormat(true);
                ScalarUnitTest.assertAllSpacesAreBreaking(interactive);
                ScalarUnitTest.assertAllSpacesAreBreaking(customInteractive);
                ScalarUnitTest.assertNotEquals(interactive, customInteractive);
            }
        }

        @Test
        public void testCustomPersistedSpaces() {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> quantity = KindOfQuantityTest.randomCustomQuantity(unit, rnd);
                String persisted = quantity.persistableString();
                ScalarUnitTest.assertAllSpacesAreBreaking(persisted);
            }
        }

        @Test
        public void testCustomInteractiveRoundtrip() throws Exception {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> quantity = KindOfQuantityTest.randomCustomQuantity(unit, rnd);
                String interactive = quantity.interactiveFormat();
                String customInteractive = quantity.interactiveFormat(true);
                ScalarUnitTest.assertNotEquals(interactive, customInteractive);
                ITypedQuantity wellKnownQuantity = unit.getContentType().parseInteractive(interactive);
                ITypedQuantity customQuantity = ((LinearUnit)quantity.getUnit()).customParseInteractive(customInteractive);
                ScalarUnitTest.assertNotEquals(wellKnownQuantity, customQuantity);
                AdHocQuantityTest.assertNearlySame((IQuantity)customQuantity, (IQuantity)wellKnownQuantity);
                AdHocQuantityTest.assertNearlySame((IQuantity)wellKnownQuantity, (IQuantity)customQuantity);
                try {
                    ITypedQuantity brokenQuantity = unit.getContentType().parseInteractive(customInteractive);
                    Assert.fail((String)("Didn't fail to parse '" + interactive + "' (into " + brokenQuantity + ')'));
                    continue;
                }
                catch (QuantityConversionException expected) {
                    Assert.assertEquals((Object)QuantityConversionException.Problem.UNKNOWN_UNIT, (Object)expected.getProblem());
                }
            }
        }

        @Test
        public void testCustomPersistedRoundtrip() throws Exception {
            Assume.assumeTrue((String)"Custom units currently only supported for LinearUnit:s", (boolean)(this.unit instanceof LinearUnit));
            LinearUnit unit = (LinearUnit)this.unit;
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                ITypedQuantity<LinearUnit> wellKnownQuantity = KindOfQuantityTest.randomPositiveQuantity(unit, rnd);
                String wellKnownPersisted = wellKnownQuantity.persistableString();
                LinearUnit customUnit = unit.getContentType().makeCustomUnit(wellKnownQuantity);
                ITypedQuantity customQuantity = customUnit.quantity(1L);
                String customPersisted = customQuantity.persistableString();
                ScalarUnitTest.assertAllSpacesAreBreaking(customPersisted);
                ScalarUnitTest.assertAllSpacesAreBreaking(wellKnownPersisted);
                Assert.assertEquals((Object)wellKnownPersisted, (Object)customPersisted);
                customQuantity = customUnit.quantity(17L);
                customPersisted = customQuantity.persistableString();
                ScalarUnitTest.assertAllSpacesAreBreaking(customPersisted);
                ITypedQuantity roundtripped = unit.getContentType().parsePersisted(customPersisted);
                ScalarUnitTest.assertNotEquals(customQuantity, roundtripped);
                AdHocQuantityTest.assertNearlySame((IQuantity)customQuantity, (IQuantity)roundtripped);
                AdHocQuantityTest.assertNearlySame((IQuantity)roundtripped, (IQuantity)customQuantity);
            }
        }

        @Test
        public void testPersistedLongRoundtrip() throws Exception {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = this.unit.quantity(rnd.nextLong());
                AdHocQuantityTest.assertPersistedRoundtrip(quantity);
            }
        }

        @Test
        public void testPersistedDoubleRoundtrip() throws Exception {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = this.unit.quantity(rnd.nextDouble());
                AdHocQuantityTest.assertPersistedRoundtrip(quantity);
            }
        }

        @Test
        public void testInteractiveLongRoundtrip() throws Exception {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = this.unit.quantity(rnd.nextLong());
                AdHocQuantityTest.assertInteractiveRoundtrip(quantity);
            }
        }

        @Test
        public void testInteractiveDoubleRoundtrip() throws Exception {
            Random rnd = new Random(17L);
            for (int i = 0; i < 1000; ++i) {
                IQuantity quantity = this.unit.quantity(rnd.nextDouble());
                AdHocQuantityTest.assertInteractiveRoundtrip(quantity);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class UnitConversionTest
    extends MCTestCase {
        @Parameterized.Parameter
        public IUnit fromUnit;
        @Parameterized.Parameter(value=1)
        public IUnit toUnit;
        @Parameterized.Parameter(value=2)
        public String name;

        @Parameterized.Parameters(name="{2}")
        public static Collection<Object[]> data() {
            ArrayList<Object[]> units = new ArrayList<Object[]>();
            for (ContentType type : UnitLookup.getAllContentTypes()) {
                if (!(type instanceof LinearKindOfQuantity)) continue;
                KindOfQuantity kind = (KindOfQuantity)type;
                for (IUnit unit : kind.getAllUnits()) {
                    for (IUnit toUnit : kind.getAllUnits()) {
                        Object[] array = new Object[]{unit, toUnit, UnitConversionTest.class.getSimpleName() + " (" + type.getIdentifier() + "): " + unit.getIdentifier() + " -> " + toUnit.getIdentifier()};
                        units.add(array);
                    }
                }
            }
            return units;
        }

        @Test
        public void testRoundTripConversionDouble() {
            IQuantity fromQuantity = this.fromUnit.quantity(17.0);
            IQuantity toQuantity = fromQuantity.in(this.toUnit);
            Assert.assertEquals((double)fromQuantity.doubleValue(), (double)toQuantity.in(this.fromUnit).doubleValue(), (double)1.0E-6);
        }
    }
}

