/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.resolve.transform;

import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.ExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.OrFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeNode;

public class ArtifactIncludeFilterTransformer
implements FilterTransformer<ArtifactFilter> {
    @Override
    public ArtifactFilter transform(final ScopeFilter scopeFilter) {
        return new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                boolean isIncluded = scopeFilter.getIncluded() != null ? scopeFilter.getIncluded().contains(artifact.getScope()) : true;
                boolean isExcluded = scopeFilter.getExcluded() != null ? scopeFilter.getExcluded().contains(artifact.getScope()) : false;
                return isIncluded && !isExcluded;
            }
        };
    }

    @Override
    public AndArtifactFilter transform(AndFilter andFilter) {
        AndArtifactFilter filter = new AndArtifactFilter();
        for (TransformableFilter subFilter : andFilter.getFilters()) {
            filter.add(subFilter.transform(this));
        }
        return filter;
    }

    @Override
    public ArtifactFilter transform(ExclusionsFilter exclusionsFilter) {
        return new ExcludesArtifactFilter(new ArrayList<String>(exclusionsFilter.getExcludes()));
    }

    @Override
    public ArtifactFilter transform(OrFilter orFilter) {
        final ArrayList<ArtifactFilter> filters = new ArrayList<ArtifactFilter>(orFilter.getFilters().size());
        for (TransformableFilter subFilter : orFilter.getFilters()) {
            filters.add(subFilter.transform(this));
        }
        return new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                for (ArtifactFilter filter : filters) {
                    if (!filter.include(artifact)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public ArtifactFilter transform(PatternExclusionsFilter patternExclusionsFilter) {
        return new PatternExcludesArtifactFilter(patternExclusionsFilter.getExcludes());
    }

    @Override
    public ArtifactFilter transform(PatternInclusionsFilter patternInclusionsFilter) {
        return new PatternIncludesArtifactFilter(patternInclusionsFilter.getIncludes());
    }

    @Override
    public ArtifactFilter transform(final AbstractFilter filter) {
        return new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return filter.accept(new ArtifactIncludeNode(artifact), null);
            }
        };
    }
}

