/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.json.test;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.TestToolkit;
import org.openjdk.jmc.common.test.io.IOResource;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.serializers.json.FlameGraphJsonSerializer;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.flightrecorder.test.util.StacktraceTestToolkit;

public class FlameGraphJsonSerializerTest {
    private static final boolean INVERTED_STACKS = true;
    private static final boolean REGULAR_STACKS = false;
    private static final FrameSeparator METHOD_SEPARATOR = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
    private static IItemCollection testRecording;

    @BeforeClass
    public static void beforeAll() throws IOException, CouldNotLoadRecordingException {
        IOResourceSet[] testResources = StacktraceTestToolkit.getTestResources();
        IOResourceSet resourceSet = testResources[0];
        testRecording = RecordingToolkit.getFlightRecording((IOResourceSet)resourceSet);
    }

    @Test
    public void testSerializeKnownRecording() throws IOException, CouldNotLoadRecordingException {
        IItemCollection collection = RecordingToolkit.getFlightRecording((IOResource)TestToolkit.getNamedResource(FlameGraphJsonSerializerTest.class, (String)"recordings", (String)"hotmethods.jfr"));
        Assert.assertNotNull((Object)collection);
        String json = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)new StacktraceTreeModel(collection, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false)));
        Assert.assertTrue((String)"JSon file should contain Method Profiling Sample[24526]", (boolean)json.contains("Method Profiling Sample[24526]"));
    }

    @Test
    public void testRenderedJsonWithAttribute() throws Exception {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, METHOD_SEPARATOR, false, JdkAttributes.ALLOCATION_SIZE);
        String flameGraphJson = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)model);
        String expectedJson = this.readResource("/flamegraph-attribute.json");
        Assert.assertEquals((Object)expectedJson, (Object)flameGraphJson);
    }

    @Test
    public void testRenderedJsonWithAttributeInvertedStacks() throws Exception {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, METHOD_SEPARATOR, true, JdkAttributes.ALLOCATION_SIZE);
        String flameGraphJson = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)model);
        String expectedJson = this.readResource("/flamegraph-attribute-inverted.json");
        Assert.assertEquals((Object)expectedJson, (Object)flameGraphJson);
    }

    @Test
    public void testRenderedJsonWithCounts() throws Exception {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording);
        String flameGraphJson = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)model);
        String expectedJson = this.readResource("/flamegraph-counts.json");
        Assert.assertEquals((Object)expectedJson, (Object)flameGraphJson);
    }

    @Test
    public void testRenderedJsonWithCountsInvertedStacks() throws Exception {
        StacktraceTreeModel model = new StacktraceTreeModel(testRecording, METHOD_SEPARATOR, true);
        String flameGraphJson = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)model);
        String expectedJson = this.readResource("/flamegraph-counts-inverted.json");
        Assert.assertEquals((Object)expectedJson, (Object)flameGraphJson);
    }

    private String readResource(String resourcePath) throws IOException {
        try (InputStream is = FlameGraphJsonSerializer.class.getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IllegalArgumentException(resourcePath + " not found");
            }
            String string = StringToolkit.readString((InputStream)is);
            return string;
        }
    }
}

