/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.tycho.repository.p2base.artifact.provider.CompositeArtifactProviderBaseImpl;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;

public class RepositoryArtifactProvider
extends CompositeArtifactProviderBaseImpl
implements IRawArtifactProvider {
    private final RepositoryLoader repositoryLoader;
    List<? extends IArtifactRepository> repositories;
    final ArtifactTransferPolicy transferPolicy;

    public RepositoryArtifactProvider(List<? extends IArtifactRepository> repositories, ArtifactTransferPolicy transferPolicy) {
        this.repositories = repositories;
        this.repositoryLoader = null;
        this.transferPolicy = transferPolicy;
    }

    public RepositoryArtifactProvider(List<URI> artifactRepositories, ArtifactTransferPolicy transferPolicy, IProvisioningAgent agent) {
        this(new RepositoryLoader(artifactRepositories, RepositoryArtifactProvider.getRepositoryManager(agent)), transferPolicy);
    }

    RepositoryArtifactProvider(RepositoryLoader repositoryLoader, ArtifactTransferPolicy transferPolicy) {
        this.repositories = null;
        this.repositoryLoader = repositoryLoader;
        this.transferPolicy = transferPolicy;
    }

    private static IArtifactRepositoryManager getRepositoryManager(IProvisioningAgent agent) {
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (repositoryManager == null) {
            throw new IllegalArgumentException("IArtifactRepositoryManager in p2 agent " + agent);
        }
        return repositoryManager;
    }

    protected void init() {
        if (this.repositories == null) {
            this.repositories = this.repositoryLoader.loadRepositories();
            this.repositoriesLoaded();
        }
    }

    protected void repositoriesLoaded() {
    }

    @Override
    public boolean contains(IArtifactKey key) {
        this.init();
        for (IArtifactRepository iArtifactRepository : this.repositories) {
            if (!iArtifactRepository.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IArtifactDescriptor descriptor) {
        this.init();
        for (IArtifactRepository iArtifactRepository : this.repositories) {
            if (!iArtifactRepository.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void getArtifactDescriptorsOfAllSources(IArtifactKey key, Set<IArtifactDescriptor> result) {
        this.init();
        for (IArtifactRepository iArtifactRepository : this.repositories) {
            IArtifactDescriptor[] iArtifactDescriptorArray = iArtifactRepository.getArtifactDescriptors(key);
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                result.add(descriptor);
                ++n2;
            }
        }
    }

    @Override
    protected void getArtifactFromAnySource(IArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        this.init();
        for (IArtifactRepository iArtifactRepository : this.repositories) {
            boolean artifactWasRead = this.getArtifactFromAnyFormatAvailableInRepository(iArtifactRepository, sink, statusCollector, monitor);
            if (!artifactWasRead) continue;
            return;
        }
    }

    private boolean getArtifactFromAnyFormatAvailableInRepository(IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        IArtifactDescriptor[] allFormats = repository.getArtifactDescriptors(sink.getArtifactToBeWritten());
        List<IArtifactDescriptor> formatsByPreference = this.transferPolicy.sortFormatsByPreference(allFormats);
        return this.getArtifactFromAnyChildRepository(formatsByPreference, repository, sink, statusCollector, monitor);
    }

    private boolean getArtifactFromAnyChildRepository(final List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, final IArtifactSink sink, final List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        BooleanStatusArtifactRequest request = new BooleanStatusArtifactRequest(sink.getArtifactToBeWritten()){
            private final RetryTracker retryTracker;
            {
                super($anonymous0);
                this.retryTracker = new RetryTracker();
            }

            public void perform(IArtifactRepository childRepository, IProgressMonitor monitor) {
                try {
                    boolean artifactWasRead = RepositoryArtifactProvider.this.getArtifactFromAnyMirror(availableDescriptors, childRepository, sink, statusCollector, this.retryTracker, monitor);
                    if (artifactWasRead) {
                        this.markSuccessful();
                    }
                }
                catch (ArtifactSinkException e) {
                    throw new ArtifactSinkExceptionWrapper(e);
                }
            }
        };
        try {
            repository.getArtifacts(new IArtifactRequest[]{request}, monitor);
        }
        catch (ArtifactSinkExceptionWrapper e) {
            throw e.getWrappedException();
        }
        return request.wasSuccessful();
    }

    private boolean getArtifactFromAnyMirror(List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, RetryTracker retryTracker, IProgressMonitor monitor) throws ArtifactSinkException {
        while (retryTracker.canRetry()) {
            boolean artifactWasRead = this.getArtifactFromOneMirror(availableDescriptors, repository, sink, statusCollector, retryTracker, monitor);
            if (artifactWasRead) {
                return true;
            }
            retryTracker.increment();
        }
        return false;
    }

    private boolean getArtifactFromOneMirror(List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, RetryTracker retryTracker, IProgressMonitor monitor) throws ArtifactSinkException {
        for (IArtifactDescriptor descriptor : availableDescriptors) {
            if (!sink.canBeginWrite()) {
                return false;
            }
            IStatus status = repository.getArtifact(descriptor, sink.beginWrite(), monitor);
            statusCollector.add(this.improveMessageIfError(status, repository, descriptor));
            if (RepositoryArtifactProvider.isFatal(status)) {
                sink.abortWrite();
                if (status.getCode() == 13) continue;
                retryTracker.noMoreRetries();
                continue;
            }
            sink.commitWrite();
            return true;
        }
        return false;
    }

    @Override
    protected void getRawArtifactFromAnySource(IRawArtifactSink sink, IProgressMonitor monitor, List<IStatus> statusCollector) throws ArtifactSinkException {
        this.init();
        for (IArtifactRepository iArtifactRepository : this.repositories) {
            boolean artifactWasRead = this.getRawArtifactFromRepository(iArtifactRepository, sink, statusCollector, monitor);
            if (!artifactWasRead) continue;
            return;
        }
    }

    private boolean getRawArtifactFromRepository(IArtifactRepository repository, IRawArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        IArtifactDescriptor requestedDescriptor = sink.getArtifactFormatToBeWritten();
        if (repository.contains(requestedDescriptor)) {
            if (!sink.canBeginWrite()) {
                return false;
            }
            IStatus status = repository.getRawArtifact(requestedDescriptor, sink.beginWrite(), monitor);
            statusCollector.add(this.improveMessageIfError(status, repository, requestedDescriptor));
            if (RepositoryArtifactProvider.isFatal(status)) {
                sink.abortWrite();
            } else {
                sink.commitWrite();
                return true;
            }
        }
        return false;
    }

    private IStatus improveMessageIfError(IStatus originalStatus, IArtifactRepository repository, IArtifactDescriptor currentDescriptor) {
        if (!RepositoryArtifactProvider.isFatal(originalStatus)) {
            return originalStatus;
        }
        String message = "An error occurred while transferring artifact " + currentDescriptor + " from repository " + repository.getLocation();
        return new MultiStatus("org.eclipse.tycho.p2.maven.repository", 0, new IStatus[]{originalStatus}, message, null);
    }

    protected Status getArtifactNotFoundError(String artifact) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", 1200, "Artifact " + artifact + " is not available in any of the following repositories: " + this.repositoryLoader.getRepositoryURLs(), null);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        this.init();
        return this.repositoriesAsQueriable().query(query, monitor);
    }

    private IQueryable<IArtifactKey> repositoriesAsQueriable() {
        int repositoryCount = this.repositories.size();
        if (repositoryCount == 1) {
            return (IQueryable)this.repositories.get(0);
        }
        IArtifactRepository[] repositoriesArray = this.repositories.toArray(new IArtifactRepository[repositoryCount]);
        return new CompoundQueryable((IQueryable[])repositoriesArray);
    }

    private static class ArtifactSinkExceptionWrapper
    extends RuntimeException {
        private ArtifactSinkException wrappedException;

        public ArtifactSinkExceptionWrapper(ArtifactSinkException wrappedException) {
            this.wrappedException = wrappedException;
        }

        public ArtifactSinkException getWrappedException() {
            return this.wrappedException;
        }
    }

    private static abstract class BooleanStatusArtifactRequest
    implements IArtifactRequest {
        private final IArtifactKey key;
        private boolean successful = false;

        public BooleanStatusArtifactRequest(IArtifactKey key) {
            this.key = key;
        }

        public final IArtifactKey getArtifactKey() {
            return this.key;
        }

        protected void markSuccessful() {
            this.successful = true;
        }

        public boolean wasSuccessful() {
            return this.successful;
        }

        public IStatus getResult() {
            if (this.successful) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.tycho.p2.maven.repository", "failure marker");
        }
    }

    static class RepositoryLoader {
        private IArtifactRepositoryManager repositoryManager;
        private List<URI> repositoryURLs;

        RepositoryLoader(List<URI> repositoryURLs, IArtifactRepositoryManager repositoryManager) {
            this.repositoryURLs = repositoryURLs;
            this.repositoryManager = repositoryManager;
        }

        List<IArtifactRepository> loadRepositories() {
            ArrayList<IArtifactRepository> result = new ArrayList<IArtifactRepository>(this.repositoryURLs.size());
            for (URI repositoryURL : this.repositoryURLs) {
                try {
                    result.add(this.repositoryManager.loadRepository(repositoryURL, null));
                }
                catch (ProvisionException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        List<URI> getRepositoryURLs() {
            return this.repositoryURLs;
        }
    }

    private static class RetryTracker {
        private int remaining = 16;

        private RetryTracker() {
        }

        boolean canRetry() {
            return this.remaining > 0;
        }

        void increment() {
            --this.remaining;
        }

        void noMoreRetries() {
            this.remaining = 0;
        }
    }
}

