/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.cfg.Percentage;
import com.atlassian.clover.model.CoverageDataPoint;
import com.atlassian.clover.model.XmlConverter;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.BaseProjectInfo;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.util.MetricsDiffSummary;
import com.atlassian.clover.util.Formatting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalSupport {
    private static Column DEFAULT_COLUMN = new Columns.TotalPercentageCovered();

    static SortedMap getPackageMetricsForRange(String pkgStr, File[] files, long from, long to) throws IOException {
        List modelList = HistoricalSupport.getModelsForRange(files, from, to, 2);
        TreeMap<Long, HasMetricsWrapper> result = new TreeMap<Long, HasMetricsWrapper>();
        for (CoverageDataPoint model : modelList) {
            BaseProjectInfo project = model.getProject();
            BasePackageInfo pkg = project.getNamedPackage(pkgStr);
            if (pkg != null) {
                result.put(new Long(project.getVersion()), new HasMetricsWrapper(pkg, model.getDataFile()));
                continue;
            }
            Logger.getInstance().warn("Package " + pkgStr + " not found in historical data at " + Formatting.formatDate(new Date(project.getVersion())));
        }
        return result;
    }

    public static SortedMap getAllProjectMetrics(File[] files) throws IOException {
        return HistoricalSupport.getProjectMetricsForRange(files, 0L, Long.MAX_VALUE);
    }

    static SortedMap getProjectMetricsForRange(File[] files, long from, long to) throws IOException {
        List modelList = HistoricalSupport.getModelsForRange(files, from, to, 1);
        TreeMap<Long, HasMetricsWrapper> result = new TreeMap<Long, HasMetricsWrapper>();
        for (CoverageDataPoint model : modelList) {
            BaseProjectInfo project = model.getProject();
            result.put(new Long(project.getVersion()), new HasMetricsWrapper(project, model.getDataFile()));
        }
        return result;
    }

    public static HasMetrics getFullMetrics(HasMetricsWrapper wrapper, String pkg) throws IOException, CloverException {
        CoverageDataPoint model = XmlConverter.getFromXmlFile(wrapper.getDataFile(), 4);
        if (pkg == null) {
            return model.getProject();
        }
        return model.getProject().getNamedPackage(pkg);
    }

    private static List getModelsForRange(File[] files, long from, long to, int level) {
        LinkedList<CoverageDataPoint> models = new LinkedList<CoverageDataPoint>();
        for (int i = 0; i < files.length; ++i) {
            CoverageDataPoint model;
            try {
                model = XmlConverter.getFromXmlFile(files[i], level);
            }
            catch (Exception e) {
                Logger.getInstance().error(e.getClass().getName() + " occured processing file " + files[i], e);
                Logger.getInstance().error("Error processing file " + files[i] + ", skipped.");
                continue;
            }
            if (model.getProject() == null) {
                Logger.getInstance().warn("File '" + files[i].getAbsolutePath() + "' does not contain a valid history point. Ignoring.");
                continue;
            }
            long ts = model.getProject().getVersion();
            if (ts >= from && ts <= to) {
                models.add(model);
                continue;
            }
            Logger.getInstance().verbose("Snapshot in file " + files[i] + " was outside the specified range.");
        }
        Logger.getInstance().info("Read " + models.size() + " history point" + (models.size() == 1 ? "" : "s") + ".");
        Collections.sort(models, CoverageDataPoint.CHRONOLOGICAL_CMP);
        return models;
    }

    public static List<MetricsDiffSummary> getClassesMetricsDifference(HasMetrics then, HasMetrics now, Percentage threshold, boolean onlyDiffs) throws CloverException {
        return HistoricalSupport.getClassesMetricsDifference(then, now, threshold, DEFAULT_COLUMN, onlyDiffs);
    }

    public static List<MetricsDiffSummary> getClassesMetricsDifference(HasMetrics then, HasMetrics now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        if (then instanceof BasePackageInfo) {
            return HistoricalSupport.getPackageClassesMetricsDiff((BasePackageInfo)then, (BasePackageInfo)now, threshold, column, onlyDiffs);
        }
        return HistoricalSupport.getProjectClassesMetricsDiff((BaseProjectInfo)then, (BaseProjectInfo)now, threshold, column, onlyDiffs);
    }

    public static List<MetricsDiffSummary> getProjectClassesMetricsDiff(BaseProjectInfo then, BaseProjectInfo now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        LinkedList<MetricsDiffSummary> diffs = new LinkedList<MetricsDiffSummary>();
        if (onlyDiffs) {
            List<? extends PackageInfo> pkgList = then.getAllPackages();
            for (BasePackageInfo basePackageInfo : pkgList) {
                BasePackageInfo p2 = now.getNamedPackage(basePackageInfo.getName());
                if (p2 == null) continue;
                Logger.getInstance().debug("diffing classes in package " + basePackageInfo.getName());
                diffs.addAll(HistoricalSupport.getClassesMetricsDifference(basePackageInfo, p2, threshold, column, onlyDiffs));
            }
        } else {
            List<? extends PackageInfo> pkgList = now.getAllPackages();
            for (BasePackageInfo basePackageInfo : pkgList) {
                BasePackageInfo p1 = then.getNamedPackage(basePackageInfo.getName());
                if (p1 != null) {
                    Logger.getInstance().debug("looking for new classes in package " + basePackageInfo.getName());
                    diffs.addAll(HistoricalSupport.getClassesMetricsDifference(p1, basePackageInfo, threshold, column, onlyDiffs));
                    continue;
                }
                Iterator<? extends ClassInfo> i$ = basePackageInfo.getClasses().iterator();
                while (i$.hasNext()) {
                    ClassInfo o;
                    ClassInfo classInfo = o = i$.next();
                    diffs.add(HistoricalSupport.getNewClassMetrics(null, classInfo, threshold, column));
                }
            }
        }
        Collections.sort(diffs, MetricsDiffSummary.DIFF_COMP);
        return diffs;
    }

    public static List<MetricsDiffSummary> getPackageClassesMetricsDiff(BasePackageInfo then, BasePackageInfo now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        if (!then.getName().equals(now.getName())) {
            throw new IllegalArgumentException("Can't compare different packages");
        }
        LinkedList<MetricsDiffSummary> diffs = new LinkedList<MetricsDiffSummary>();
        if (onlyDiffs) {
            List<? extends ClassInfo> classList = then.getClasses();
            for (ClassInfo classInfo : classList) {
                ClassInfo c2;
                MetricsDiffSummary diff = HistoricalSupport.getClassMetricsDiff(classInfo, c2 = now.getContainingProject().findClass(classInfo.getQualifiedName()), threshold, column);
                if (diff == null) continue;
                diffs.add(diff);
            }
        } else {
            List<? extends ClassInfo> classList = now.getClasses();
            for (ClassInfo classInfo : classList) {
                ClassInfo c1 = then.getContainingProject().findClass(classInfo.getQualifiedName());
                MetricsDiffSummary diff = HistoricalSupport.getNewClassMetrics(c1, classInfo, threshold, column);
                if (diff == null) continue;
                diffs.add(diff);
            }
        }
        Collections.sort(diffs, MetricsDiffSummary.DIFF_COMP);
        return diffs;
    }

    public static MetricsDiffSummary getClassMetricsDiff(ClassInfo c1, ClassInfo c2, Percentage threshold, Column column) throws CloverException {
        if (c2 != null) {
            float diff;
            Number pc2;
            Number pc1;
            Logger.getInstance().debug("diffing " + column.getTitle() + " for " + c1.getQualifiedName());
            Column col1 = column.copy();
            Column col2 = column.copy();
            col1.init(c1.getMetrics());
            col2.init(c2.getMetrics());
            if (column.getColumnData() == null) {
                column.init(c1.getMetrics());
            }
            if (col1.getNumber().doubleValue() > column.getNumber().doubleValue()) {
                column.init(c1.getMetrics());
            }
            if (col2.getNumber().doubleValue() > column.getNumber().doubleValue()) {
                column.init(c2.getMetrics());
            }
            if (!(pc1 = col1.getNumber()).equals(pc2 = col2.getNumber())) {
                if (pc1.intValue() == -1) {
                    pc1 = new Integer(0);
                } else if (pc2.intValue() == -1) {
                    pc2 = new Integer(0);
                }
            }
            if (Math.abs(diff = pc2.floatValue() - pc1.floatValue()) >= threshold.getValue().floatValue()) {
                Logger.getInstance().debug("added " + c1.getQualifiedName());
                return new MetricsDiffSummary(c1, c2, pc1, pc2, diff, column);
            }
        }
        return null;
    }

    public static MetricsDiffSummary getNewClassMetrics(ClassInfo c1, ClassInfo c2, Percentage threshold, Column column) throws CloverException {
        Column col2 = column.copy();
        col2.init(c2.getMetrics());
        if (column.getColumnData() == null) {
            column.init(c2.getMetrics());
        }
        if (col2.getNumber().doubleValue() > column.getNumber().doubleValue()) {
            column.init(c2.getMetrics());
        }
        if (c1 == null) {
            Logger.getInstance().debug("found new " + column.getTitle() + " for " + c2.getQualifiedName());
            Number pc2 = col2.getNumber();
            Integer pc1 = new Integer(100);
            if (pc2.intValue() == -1) {
                pc2 = new Integer(0);
            }
            return new MetricsDiffSummary(c1, c2, pc1, pc2, pc2.floatValue(), column);
        }
        return null;
    }

    public static class HasMetricsWrapper
    implements HasMetrics {
        private HasMetrics hm;
        public File dataFile;

        public HasMetricsWrapper(HasMetrics hm, File sourceFile) {
            this.hm = hm;
            this.dataFile = sourceFile;
        }

        public String getName() {
            return this.hm.getName();
        }

        public BlockMetrics getMetrics() {
            return this.hm.getMetrics();
        }

        public BlockMetrics getRawMetrics() {
            return this.hm.getRawMetrics();
        }

        public File getDataFile() {
            return this.dataFile;
        }

        public void setMetrics(BlockMetrics metrics) {
            this.hm.setMetrics(metrics);
        }
    }
}

