/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.registry.AnnotationValueCollection;
import com.atlassian.clover.registry.PersistentAnnotationValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAnnotationValue
implements PersistentAnnotationValue,
AnnotationValueCollection {
    private ArrayList<PersistentAnnotationValue> values = new ArrayList();

    public ArrayAnnotationValue() {
    }

    public ArrayAnnotationValue(PersistentAnnotationValue[] annotationValues) {
        this.values.addAll(Arrays.asList(annotationValues));
    }

    @Override
    public void put(String key, PersistentAnnotationValue value) {
        this.values.add(value);
    }

    public List<PersistentAnnotationValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    @NotNull
    public List<? extends AnnotationValue> toList() {
        return this.getValues();
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeInt(this.values.size());
        for (PersistentAnnotationValue value : this.values) {
            out.write(value.getClass(), value);
        }
    }

    public static ArrayAnnotationValue read(TaggedDataInput in) throws IOException {
        ArrayAnnotationValue result = new ArrayAnnotationValue();
        int valueSize = in.readInt();
        for (int i = 0; i < valueSize; ++i) {
            result.put(null, in.read(PersistentAnnotationValue.class));
        }
        return result;
    }

    public String toString() {
        return "ArrayAnnotationValue{values=" + this.values + '}';
    }
}

