/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.RuntimeType;
import com.atlassian.clover.recorder.ActivePerTestRecorderAny;
import com.atlassian.clover.recorder.ActivePerTestRecorderMany;
import com.atlassian.clover.recorder.ActivePerTestRecorderNone;
import com.atlassian.clover.recorder.FileBasedPerTestRecording;
import com.atlassian.clover.recorder.LivePerTestRecording;
import com.atlassian.clover.recorder.RecordingResult;
import com.atlassian.clover.util.CloverBitSet;
import com_cenqua_clover.CoverageRecorder;

public final class ActivePerTestRecorderOne
extends ActivePerTestRecorderAny {
    protected volatile boolean[] coverageShortcut;
    protected final CloverBitSet coverage;
    protected final RuntimeType type;
    protected final long start;
    protected final int slice;
    protected final int testRunID;

    public ActivePerTestRecorderOne(CoverageRecorder coverageRecorder, CloverBitSet coverage, RuntimeType type, long start, int slice, int testRunID) {
        super(coverageRecorder);
        this.coverageShortcut = new boolean[coverage.size()];
        this.coverage = coverage;
        this.type = type;
        this.start = start;
        this.slice = slice;
        this.testRunID = testRunID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index) {
        if (index > this.coverageShortcut.length - 1) {
            ActivePerTestRecorderOne activePerTestRecorderOne = this;
            synchronized (activePerTestRecorderOne) {
                int newSize = Math.max(this.coverageShortcut.length * 2, index + 1);
                boolean[] newShortcut = new boolean[newSize];
                System.arraycopy(this.coverageShortcut, 0, newShortcut, 0, this.coverageShortcut.length);
                this.coverageShortcut = newShortcut;
            }
        }
        if (!this.coverageShortcut[index]) {
            this.coverageShortcut[index] = true;
            this.coverage.add(index);
        }
    }

    public ActivePerTestRecorderAny testStarted(String type, long start, int slice, int testRunID) {
        return new ActivePerTestRecorderMany(this.coverageRecorder, new ActivePerTestRecorderOne[]{new ActivePerTestRecorderOne(this.coverageRecorder, this.coverageRecorder.createEmptyHitsMask(), new RuntimeType(type), start, slice, testRunID), this});
    }

    public RecordingResult testFinished(String type, String method, String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
        if (!this.matchesTest(type, slice, testRunId)) {
            Logger.getInstance().verbose("Per-test recorder ending " + ActivePerTestRecorderOne.asString(type, slice, testRunId) + " " + "but different recorder in focus " + ActivePerTestRecorderOne.asString(this.type.name, this.slice, this.testRunID));
            return new RecordingResult(LivePerTestRecording.NULL, this);
        }
        LivePerTestRecording perTestRecording = this.coverage.isModified() ? new FileBasedPerTestRecording(this.coverageRecorder, this.coverage, method, runtimeTestName, this.start, end, this.type, slice, testRunId, exitStatus, errorInfo) : LivePerTestRecording.NULL;
        return new RecordingResult(perTestRecording, new ActivePerTestRecorderNone(this.coverageRecorder));
    }

    boolean matchesTest(String type, int slice, int testRunId) {
        return this.type.matches(type) && this.slice == slice && this.testRunID == testRunId;
    }

    public String toString() {
        return "One:PerTestRecorders[type=" + this.type + ", start=" + this.start + ", slice=" + this.slice + ", testRunID=" + this.testRunID + ']';
    }
}

