/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseInfoLookup {
    private ConcurrentHashMap<Integer, TestCaseInfo> byId = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TestCaseInfo> byQualifiedName = new ConcurrentHashMap();

    public void add(TestCaseInfo tci) {
        this.byId.putIfAbsent(tci.getId(), tci);
        this.byQualifiedName.putIfAbsent(tci.getQualifiedName(), tci);
    }

    public TestCaseInfo getBy(Integer id) {
        return this.byId.get(id);
    }

    public TestCaseInfo getBy(String qualifiedName) {
        return this.byQualifiedName.get(qualifiedName);
    }

    public Set<TestCaseInfo> getTestCaseInfos() {
        return new HashSet<TestCaseInfo>(this.byId.values());
    }
}

