/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import org.jemmy.Point;
import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.interfaces.Drag;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.Mouse;
import org.jemmy.interfaces.Showable;

public class DragImpl
implements Drag {
    public static final int DND_POINTS = 10;
    private Wrap<?> source;

    public DragImpl(Wrap<?> source) {
        this.source = source;
    }

    public void dnd(Point targetPoint) {
        this.dnd(this.source, targetPoint);
    }

    public void dnd(Wrap target, Point targetPoint) {
        this.dnd(this.source.getClickPoint(), target, targetPoint);
    }

    public void dnd(Point point, Wrap target, Point targetPoint) {
        this.dnd(point, target, targetPoint, (Mouse.MouseButton)Mouse.MouseButtons.BUTTON1);
    }

    public void dnd(Point point, Wrap target, Point targetPoint, Mouse.MouseButton button) {
        this.dnd(point, target, targetPoint, button, new Modifier[0]);
    }

    public void dnd(Point pointParam, final Wrap target, final Point targetPoint, final Mouse.MouseButton button, final Modifier ... modifiers) {
        final Point point = pointParam == null ? this.source.getClickPoint() : pointParam;
        this.source.getEnvironment().getExecutor().execute(target.getEnvironment(), false, new Action(){

            public void run(Object ... parameters) {
                if (DragImpl.this.source.is(Showable.class)) {
                    ((Showable)DragImpl.this.source.as(Showable.class)).shower().show();
                }
                DragImpl.this.source.mouse().move(point);
                DragImpl.this.source.mouse().press(button, modifiers);
                DragImpl.this.source.getEnvironment().getTimeout(Drag.BEFORE_DRAG_TIMEOUT.getName()).sleep();
                Point intermediatePoint = new Point();
                int xDistance = target.getScreenBounds().x + targetPoint.x - ((DragImpl)DragImpl.this).source.getScreenBounds().x - point.x;
                int yDistance = target.getScreenBounds().y + targetPoint.y - ((DragImpl)DragImpl.this).source.getScreenBounds().y - point.y;
                int startX = point.x + ((DragImpl)DragImpl.this).source.getScreenBounds().x;
                int startY = point.y + ((DragImpl)DragImpl.this).source.getScreenBounds().y;
                int endX = startX + xDistance;
                int endY = startY + yDistance;
                for (int i = 0; i < 11; ++i) {
                    intermediatePoint.x = startX + xDistance * i / 10 - ((DragImpl)DragImpl.this).source.getScreenBounds().x;
                    intermediatePoint.y = startY + yDistance * i / 10 - ((DragImpl)DragImpl.this).source.getScreenBounds().y;
                    DragImpl.this.source.mouse().move(intermediatePoint);
                    DragImpl.this.source.getEnvironment().getTimeout(Drag.IN_DRAG_TIMEOUT.getName()).sleep();
                }
                DragImpl.this.source.mouse().move(new Point(endX - ((DragImpl)DragImpl.this).source.getScreenBounds().x, endY - ((DragImpl)DragImpl.this).source.getScreenBounds().y));
                DragImpl.this.source.getEnvironment().getTimeout(Drag.BEFORE_DROP_TIMEOUT.getName()).sleep();
                target.mouse().release(button, modifiers);
            }

            public String toString() {
                return "grag'n'drop from " + point + " to " + targetPoint + " of " + target.getClass() + " with mouse button " + button + " with " + modifiers + " modifiers";
            }
        }, new Object[]{button, modifiers});
    }

    static {
        Environment.getEnvironment().setTimeout(BEFORE_DRAG_TIMEOUT);
        Environment.getEnvironment().setTimeout(BEFORE_DROP_TIMEOUT);
        Environment.getEnvironment().setTimeout(IN_DRAG_TIMEOUT);
    }
}

