/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.json;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.serializers.internal.Messages;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.AggregatableFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;

public class FlameGraphJsonSerializer {
    private static final String UNCLASSIFIABLE_FRAME = Messages.getString("STACKTRACE_UNCLASSIFIABLE_FRAME");
    private static final String UNCLASSIFIABLE_FRAME_DESC = Messages.getString("STACKTRACE_UNCLASSIFIABLE_FRAME_DESC");
    private static final int MAX_TYPES_IN_ROOT_TITLE = 2;
    private static final int MAX_TYPES_IN_ROOT_DESCRIPTION = 10;

    public static String toJson(StacktraceTreeModel model) {
        return FlameGraphJsonSerializer.toJson(model, model.getRoot());
    }

    private static String toJson(StacktraceTreeModel model, Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (node.isRoot()) {
            sb.append(FlameGraphJsonSerializer.createRootNodeJson(model.getItems()));
        } else {
            sb.append(FlameGraphJsonSerializer.createNodeJsonProps(node.getFrame(), node.getCumulativeWeight()));
        }
        sb.append(", ").append(FlameGraphJsonSerializer.addQuotes("c")).append(": [ ");
        boolean first = true;
        for (Node child : node.getChildren()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(FlameGraphJsonSerializer.toJson(model, child));
            first = false;
        }
        sb.append("]").append("}");
        return sb.toString();
    }

    private static String createNodeJsonProps(AggregatableFrame frame, double value) {
        StringBuilder sb = new StringBuilder();
        if (frame.getType().equals((Object)IMCFrame.Type.UNKNOWN) && frame.getHumanReadableShortString().equals(".()")) {
            sb.append(FlameGraphJsonSerializer.addQuotes("n")).append(": ").append(FlameGraphJsonSerializer.addQuotes(UNCLASSIFIABLE_FRAME));
            sb.append(",");
            sb.append(FlameGraphJsonSerializer.addQuotes("d")).append(": ").append(FlameGraphJsonSerializer.addQuotes(UNCLASSIFIABLE_FRAME_DESC));
            sb.append(",");
            sb.append(FlameGraphJsonSerializer.addQuotes("p")).append(": ").append(FlameGraphJsonSerializer.addQuotes(""));
            sb.append(",");
        } else {
            String frameName = frame.getHumanReadableShortString();
            String packageName = FormatToolkit.getPackage((IMCPackage)frame.getMethod().getType().getPackage());
            sb.append(FlameGraphJsonSerializer.addQuotes("n")).append(": ").append(FlameGraphJsonSerializer.addQuotes(frameName));
            sb.append(",");
            sb.append(FlameGraphJsonSerializer.addQuotes("p")).append(": ").append(FlameGraphJsonSerializer.addQuotes(packageName));
            sb.append(",");
        }
        sb.append(FlameGraphJsonSerializer.addQuotes("v")).append(": ").append(String.valueOf((int)value));
        return sb.toString();
    }

    private static String createJsonProps(String frameName, String description, double value) {
        StringBuilder sb = new StringBuilder();
        sb.append(FlameGraphJsonSerializer.addQuotes("n")).append(": ").append(FlameGraphJsonSerializer.addQuotes(frameName));
        sb.append(",");
        sb.append(FlameGraphJsonSerializer.addQuotes("p")).append(": ").append(FlameGraphJsonSerializer.addQuotes(""));
        sb.append(",");
        sb.append(FlameGraphJsonSerializer.addQuotes("d")).append(": ").append(FlameGraphJsonSerializer.addQuotes(description));
        sb.append(",");
        sb.append(FlameGraphJsonSerializer.addQuotes("v")).append(": ").append(String.valueOf((int)value));
        return sb.toString();
    }

    private static String addQuotes(String str) {
        return String.format("\"%s\"", str);
    }

    private static Map<String, Long> countEventsByType(IItemCollection items) {
        HashMap<String, Long> eventCountByType = new HashMap<String, Long>();
        for (IItemIterable eventIterable : items) {
            if (eventIterable.getItemCount() == 0L) continue;
            String typeName = eventIterable.getType().getName();
            long newValue = eventCountByType.getOrDefault(typeName, 0L) + eventIterable.getItemCount();
            eventCountByType.put(typeName, newValue);
        }
        return eventCountByType.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static String createRootNodeJson(IItemCollection events) {
        Map<String, Long> eventCountsByType = FlameGraphJsonSerializer.countEventsByType(events);
        String rootTitle = FlameGraphJsonSerializer.createRootNodeTitle(eventCountsByType);
        String rootDescription = FlameGraphJsonSerializer.createRootNodeDescription(eventCountsByType);
        return FlameGraphJsonSerializer.createJsonProps(rootTitle, rootDescription, eventCountsByType.values().stream().mapToLong(Long::longValue).sum());
    }

    private static String createRootNodeTitle(Map<String, Long> eventCountsByType) {
        int eventsInTitle = Math.min(eventCountsByType.size(), 2);
        long totalEvents = eventCountsByType.values().stream().mapToLong(Long::longValue).sum();
        if (totalEvents == 0L) {
            return Messages.getString("FLAMEGRAPH_SELECT_STACKTRACE_NOT_AVAILABLE");
        }
        StringBuilder title = new StringBuilder(FlameGraphJsonSerializer.createRootNodeTitlePrefix(totalEvents, eventCountsByType.size()));
        int i = 0;
        for (Map.Entry<String, Long> entry : eventCountsByType.entrySet()) {
            String eventType = Messages.getFormattedMessage("FLAMEGRAPH_SELECT_TITLE_EVENT_PATTERN", entry.getKey(), String.valueOf(entry.getValue()));
            title.append(eventType);
            if (i >= eventsInTitle) break;
            title.append(Messages.getFormattedMessage("FLAMEGRAPH_SELECT_TITLE_EVENT_MORE_DELIMITER", new Object[0]));
            ++i;
        }
        if (eventCountsByType.size() > 2) {
            title.append(Messages.getFormattedMessage("FLAMEGRAPH_SELECT_HTML_MORE", new Object[0]));
        }
        return title.toString();
    }

    private static String createRootNodeTitlePrefix(long events, int types) {
        String eventText = Messages.getFormattedMessage(events > 1L ? "FLAMEGRAPH_SELECT_ROOT_NODE_EVENTS" : "FLAMEGRAPH_SELECT_ROOT_NODE_EVENT", new Object[0]);
        String typeText = Messages.getFormattedMessage(types > 1 ? "FLAMEGRAPH_SELECT_ROOT_NODE_TYPES" : "FLAMEGRAPH_SELECT_ROOT_NODE_TYPE", new Object[0]);
        return Messages.getFormattedMessage("FLAMEGRAPH_SELECT_ROOT_NODE", String.valueOf(events), eventText, String.valueOf(types), typeText);
    }

    private static String createRootNodeDescription(Map<String, Long> eventCountsByType) {
        StringBuilder description = new StringBuilder();
        int i = 0;
        long remainingEvents = 0L;
        for (Map.Entry<String, Long> entry : eventCountsByType.entrySet()) {
            if (i < 10) {
                description.append(Messages.getFormattedMessage("FLAMEGRAPH_SELECT_HTML_TABLE_EVENT_PATTERN", String.valueOf(entry.getValue()), entry.getKey()));
            } else {
                remainingEvents = Long.sum(remainingEvents, entry.getValue());
            }
            ++i;
        }
        if (remainingEvents > 0L) {
            int remainingTypes = eventCountsByType.size() - 10;
            description.append(Messages.getFormattedMessage("FLAMEGRAPH_SELECT_HTML_TABLE_EVENT_REST_PATTERN", String.valueOf(remainingEvents), String.valueOf(remainingTypes)));
        }
        return description.toString();
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        if (args.length != 1) {
            System.out.println("Usage: FlameGraphJsonSerializer <filename>\n");
            System.out.println("Serializes the execution sample events a JFR file into a JSON file, suitable for visualizing with flame graph library.");
            System.exit(2);
        }
        File jfrFile = new File(args[0]);
        IItemCollection items = JfrLoaderToolkit.loadEvents((File)jfrFile);
        IItemCollection filteredItems = items.apply(JdkFilters.EXECUTION_SAMPLE);
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        StacktraceTreeModel model = new StacktraceTreeModel(filteredItems, frameSeparator);
        System.out.println(FlameGraphJsonSerializer.toJson(model));
    }
}

