/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionInfoRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

@DependsOn(value=GarbageCollectionInfoRule.class)
public class GcLockerRule
implements IRule {
    private static final String GC_LOCKER_RESULT_ID = "GcLocker";
    public static final TypedPreference<IQuantity> GC_LOCKER_RATIO_LIMIT = new TypedPreference("gc.locker.info.limit", Messages.getString("GcLockerRule_CONFIG_WARNING_LIMIT"), Messages.getString("GcLockerRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.1));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(GC_LOCKER_RATIO_LIMIT);
    public static final TypedResult<IQuantity> GC_LOCKER_RATIO = new TypedResult("gcLockerRatio", "GC Locker Ratio", "Ratio of GC locker caused GCs to total GCs.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, GC_LOCKER_RATIO);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GarbageCollection", RulesToolkit.EventAvailability.ENABLED).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)resultProvider.getResultValue(GarbageCollectionInfoRule.GC_INFO);
        if (aggregate != null) {
            int gcLockers = aggregate.getGcLockers();
            if (gcLockers > 0) {
                int gcCount = aggregate.getGcCount();
                IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(GC_LOCKER_RATIO_LIMIT);
                double ratio = gcLockers / gcCount;
                double score = RulesToolkit.mapExp74((double)ratio, (double)limit.doubleValue());
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("GcLockerRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("GcLockerRuleFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(GC_LOCKER_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(ratio)).build();
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("GcLockerRuleFactory_TEXT_OK")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.NA).setSummary(Messages.getString("GcLockerRule_TEXT_NA")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return GcLockerRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return GC_LOCKER_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcLockerRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

