/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DumpReasonRule
implements IRule {
    private static final String DUMP_REASON_RESULT_ID = "DumpReason";
    public static final TypedPreference<IQuantity> CRASH_SCORE = new TypedPreference("crash.score", Messages.getString("DumpReasonRule_CRASH_SCORE"), Messages.getString("DumpReasonRule_CRASH_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(100L));
    public static final TypedPreference<IQuantity> COREDUMP_SCORE = new TypedPreference("coredump.score", Messages.getString("DumpReasonRule_COREDUMP_SCORE"), Messages.getString("DumpReasonRule_COREDUMP_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(90L));
    public static final TypedPreference<IQuantity> OOM_SCORE = new TypedPreference("oom.score", Messages.getString("DumpReasonRule_OOM_SCORE"), Messages.getString("DumpReasonRule_OOM_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CRASH_SCORE, COREDUMP_SCORE, OOM_SCORE);
    public static final TypedResult<String> DUMP_REASON = new TypedResult("dumpReason", JdkAttributes.DUMP_REASON.getName(), JdkAttributes.DUMP_REASON.getDescription(), UnitLookup.PLAIN_TEXT, String.class);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, DUMP_REASON);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.DumpReason", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String eventType = "jdk.DumpReason";
        IQuantity crashScore = (IQuantity)valueProvider.getPreferenceValue(CRASH_SCORE);
        IQuantity coredumpScore = (IQuantity)valueProvider.getPreferenceValue(COREDUMP_SCORE);
        IQuantity oomScore = (IQuantity)valueProvider.getPreferenceValue(OOM_SCORE);
        IItemFilter itemFilter = ItemFilters.type((String)eventType);
        IItemCollection filtered = items.apply(itemFilter);
        String reasons = (String)filtered.getAggregate(Aggregators.distinctAsString((String)"jdk.DumpReason", (IAttribute)JdkAttributes.DUMP_REASON));
        String reasonsLower = reasons != null ? reasons.toLowerCase() : "";
        ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSummary(Messages.getString("DumpReasonRule_TEXT_INFO"));
        if (reasonsLower.contains("crash")) {
            return builder.setSeverity(Severity.get((double)crashScore.doubleValue())).addResult(TypedResult.SCORE, (Object)crashScore).setExplanation(Messages.getString("DumpReasonRule_TEXT_LONG_CRASH")).build();
        }
        if (reasonsLower.contains("core dump")) {
            return builder.setSeverity(Severity.get((double)coredumpScore.doubleValue())).addResult(TypedResult.SCORE, (Object)coredumpScore).setExplanation(Messages.getString("DumpReasonRule_TEXT_LONG_COREDUMP")).build();
        }
        if (reasonsLower.contains("out of memory")) {
            return builder.setSeverity(Severity.get((double)oomScore.doubleValue())).addResult(TypedResult.SCORE, (Object)oomScore).setExplanation(Messages.getString("DumpReasonRule_TEXT_LONG_OOM")).build();
        }
        return builder.setSeverity(Severity.OK).setSummary(Messages.getString("DumpReasonRule_TEXT_INFO_UNKNOWN")).setExplanation(Messages.getString("DumpReasonRule_TEXT_LONG_UNKNOWN")).addResult(DUMP_REASON, (Object)reasons).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DumpReasonRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return DUMP_REASON_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DumpReason_RULE_NAME");
    }

    public String getTopic() {
        return "recording";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

