/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.publisher;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

public class CategoryPublisher {
    private static final String CATEGORY_PUBLISHER_APP_NAME = "org.eclipse.equinox.p2.publisher.CategoryPublisher";
    private final P2ApplicationLauncher launcher;
    private final int forkedProcessTimeoutInSeconds;
    private final String[] additionalArgs;
    private final String categoryFileLocation;
    private final String metadataRepositoryLocation;

    public CategoryPublisher(P2ApplicationLauncher launcher, int forkedProcessTimeoutInSeconds, String[] additionalArgs, String categoryFileLocation, String metadataRepositoryLocation) {
        this.launcher = launcher;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.additionalArgs = additionalArgs;
        this.categoryFileLocation = categoryFileLocation;
        this.metadataRepositoryLocation = metadataRepositoryLocation;
    }

    public void execute() throws AbstractMojoExecutionException, IOException {
        this.configureLauncher(this.categoryFileLocation, this.metadataRepositoryLocation);
        this.executeLauncher();
    }

    private void configureLauncher(String categoryFileLocation, String metadataRepositoryLocation) throws AbstractMojoExecutionException, IOException {
        File metadataRepositoryDir = new File(metadataRepositoryLocation).getCanonicalFile();
        File categoryDefinitionFileSource = new File(categoryFileLocation);
        File categoryDefinitionFileTarget = new File(metadataRepositoryDir, "category.xml");
        FileUtils.copyFile((File)categoryDefinitionFileSource, (File)categoryDefinitionFileTarget);
        this.launcher.setWorkingDirectory(metadataRepositoryDir);
        this.launcher.setApplicationName(CATEGORY_PUBLISHER_APP_NAME);
        this.launcher.addArguments(new String[]{"-categoryDefinition", "file:/" + new File(categoryDefinitionFileTarget.toURI()).getAbsolutePath()});
        this.launcher.addArguments(new String[]{"-metadataRepository", "file:/" + new File(metadataRepositoryDir.toURI()).getAbsolutePath()});
        this.launcher.addArguments(this.additionalArgs);
    }

    private void executeLauncher() throws MojoFailureException {
        int result = this.launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private P2ApplicationLauncher launcher;
        private int forkedProcessTimeoutInSeconds = 0;
        private String[] additionalArgs;
        private String categoryFileLocation;
        private String metadataRepositoryLocation;

        public Builder p2ApplicationLauncher(P2ApplicationLauncher launcher) {
            Preconditions.checkNotNull((Object)launcher, (Object)"p2ApplicationLauncher cannot be null");
            this.launcher = launcher;
            return this;
        }

        public Builder forkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
            Preconditions.checkArgument((forkedProcessTimeoutInSeconds >= 0 ? 1 : 0) != 0, (Object)"forkedProcessTimeoutInSeconds cannot be negative");
            this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
            return this;
        }

        public Builder additionalArgs(String additionalArgs) {
            try {
                this.additionalArgs = CommandLineUtils.translateCommandline((String)additionalArgs);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to translate additional arguments into command line array", e);
            }
            return this;
        }

        public Builder categoryFileLocation(String categoryFileLocation) {
            Preconditions.checkNotNull((Object)categoryFileLocation, (Object)"categoryFileLocation cannot be null");
            this.categoryFileLocation = categoryFileLocation;
            return this;
        }

        public Builder metadataRepositoryLocation(String metadataRepositoryLocation) {
            Preconditions.checkNotNull((Object)metadataRepositoryLocation, (Object)"metadataRepositoryLocation cannot be null");
            this.metadataRepositoryLocation = metadataRepositoryLocation;
            return this;
        }

        public CategoryPublisher build() {
            Preconditions.checkNotNull((Object)this.launcher, (Object)"p2ApplicationLauncher cannot be null");
            Preconditions.checkNotNull((Object)this.categoryFileLocation, (Object)"categoryFileLocation cannot be null");
            Preconditions.checkNotNull((Object)this.metadataRepositoryLocation, (Object)"metadataRepositoryLocation cannot be null");
            return new CategoryPublisher(this.launcher, this.forkedProcessTimeoutInSeconds, this.additionalArgs, this.categoryFileLocation, this.metadataRepositoryLocation);
        }
    }
}

