/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="update-site-packaging", threadSafe=true)
public class PackageUpdateSiteMojo
extends AbstractMojo {
    private static final Object LOCK = new Object();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/site")
    private File target;
    @Parameter(defaultValue="false")
    private boolean archiveSite;
    @Component
    private MavenProjectHelper projectHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.target == null || !this.target.isDirectory()) {
            throw new MojoExecutionException("Update site folder does not exist at: " + this.target != null ? this.target.getAbsolutePath() : "null");
        }
        Object object = LOCK;
        synchronized (object) {
            try {
                ZipArchiver siteZipper = new ZipArchiver();
                File siteDestination = new File(this.target.getParentFile(), "site.zip");
                siteZipper.addFile(new File(this.target, "site.xml"), "site.xml");
                siteZipper.setDestFile(siteDestination);
                siteZipper.createArchive();
                this.project.getArtifact().setFile(siteDestination);
                if (this.archiveSite) {
                    ZipArchiver asssemblyZipper = new ZipArchiver();
                    File asssemblyDestFile = new File(this.target.getParentFile(), "site_assembly.zip");
                    asssemblyZipper.addDirectory(this.target);
                    asssemblyZipper.setDestFile(asssemblyDestFile);
                    asssemblyZipper.createArchive();
                    this.projectHelper.attachArtifact(this.project, "zip", "assembly", asssemblyDestFile);
                }
            }
            catch (IOException | ArchiverException e) {
                throw new MojoExecutionException("Error packing update site", (Exception)e);
            }
        }
    }
}

