/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0L) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    long clearFunc(long l, long l2) {
        if (l == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (l == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long l, long l2, long l3, long l4) {
        Object object;
        long l5;
        if (l2 == 0L) {
            return 0L;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            l5 = OS.gtk_selection_data_get_target(l2);
        } else {
            object = new GtkSelectionData();
            OS.memmove((GtkSelectionData)object, l2, (long)GtkSelectionData.sizeof);
            l5 = ((GtkSelectionData)object).target;
        }
        object = new TransferData();
        ((TransferData)object).type = l5;
        Transfer[] transferArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n = -1;
        for (int i = 0; i < transferArray.length; ++i) {
            if (!transferArray[i].isSupportedType((TransferData)object)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return 0L;
        }
        Object[] objectArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n].javaToNative(objectArray[n], (TransferData)object);
        if (((TransferData)object).format < 8 || ((TransferData)object).format % 8 != 0) {
            return 0L;
        }
        OS.gtk_selection_data_set(l2, ((TransferData)object).type, ((TransferData)object).format, ((TransferData)object).pValue, ((TransferData)object).length);
        OS.g_free(((TransferData)object).pValue);
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setData(Clipboard clipboard, Object[] objectArray, Transfer[] transferArray, int n) {
        boolean bl;
        long l;
        GtkTargetEntry[] gtkTargetEntryArray;
        block19: {
            boolean bl2;
            block18: {
                boolean bl3;
                block17: {
                    gtkTargetEntryArray = new GtkTargetEntry[]{};
                    l = 0L;
                    try {
                        int n2;
                        for (n2 = 0; n2 < transferArray.length; ++n2) {
                            Transfer transfer = transferArray[n2];
                            int[] nArray = transfer.getTypeIds();
                            String[] stringArray = transfer.getTypeNames();
                            for (int i = 0; i < nArray.length; ++i) {
                                GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                                gtkTargetEntry.info = nArray[i];
                                byte[] byArray = Converter.wcsToMbcs(null, stringArray[i], true);
                                long l2 = OS.g_malloc(byArray.length);
                                OS.memmove(l2, byArray, (long)byArray.length);
                                gtkTargetEntry.target = l2;
                                GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                                System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                                gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                                gtkTargetEntryArray = gtkTargetEntryArray2;
                            }
                        }
                        l = OS.g_malloc(GtkTargetEntry.sizeof * gtkTargetEntryArray.length);
                        n2 = 0;
                        for (int i = 0; i < gtkTargetEntryArray.length; n2 += GtkTargetEntry.sizeof, ++i) {
                            OS.memmove(l + (long)n2, gtkTargetEntryArray[i], (long)GtkTargetEntry.sizeof);
                        }
                        if ((n & 1) != 0) {
                            long l3;
                            this.clipboardData = objectArray;
                            this.clipboardDataTypes = transferArray;
                            long l4 = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, l, gtkTargetEntryArray.length, l4, l3 = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl3 = false;
                                Object var19_24 = null;
                                break block17;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
                            this.activeClipboard = clipboard;
                        }
                        if ((n & 2) != 0) {
                            long l5;
                            this.primaryClipboardData = objectArray;
                            this.primaryClipboardDataTypes = transferArray;
                            long l6 = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, l, gtkTargetEntryArray.length, l6, l5 = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl2 = false;
                                break block18;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
                            this.activePrimaryClipboard = clipboard;
                        }
                        bl = true;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var19_27 = null;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= gtkTargetEntryArray.length) {
                                if (l == 0L) throw throwable;
                                OS.g_free(l);
                                throw throwable;
                            }
                            GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[n3];
                            if (gtkTargetEntry.target != 0L) {
                                OS.g_free(gtkTargetEntry.target);
                            }
                            ++n3;
                        }
                    }
                }
                for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
                    GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[i];
                    if (gtkTargetEntry.target == 0L) continue;
                    OS.g_free(gtkTargetEntry.target);
                }
                if (l == 0L) return bl3;
                OS.g_free(l);
                return bl3;
            }
            Object var19_25 = null;
            for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
                GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[i];
                if (gtkTargetEntry.target == 0L) continue;
                OS.g_free(gtkTargetEntry.target);
            }
            if (l == 0L) return bl2;
            OS.g_free(l);
            return bl2;
        }
        Object var19_26 = null;
        int n4 = 0;
        while (true) {
            if (n4 >= gtkTargetEntryArray.length) {
                if (l == 0L) return bl;
                OS.g_free(l);
                return bl;
            }
            GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[n4];
            if (gtkTargetEntry.target != 0L) {
                OS.g_free(gtkTargetEntry.target);
            }
            ++n4;
        }
    }
}

