/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.util.internal.ConcurrencyUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class Notifier
extends RunNotifier {
    private final Collection<RunListener> listeners = new ArrayList<RunListener>();
    private final Queue<String> testClassNames = new ConcurrentLinkedQueue<String>();
    private final AtomicInteger skipAfterFailureCount;
    private final JUnit4RunListener reporter;
    private volatile boolean failFast;

    public Notifier(JUnit4RunListener reporter, int skipAfterFailureCount) {
        this.addListener(reporter);
        this.reporter = reporter;
        this.skipAfterFailureCount = new AtomicInteger(skipAfterFailureCount);
    }

    private Notifier() {
        this.reporter = null;
        this.skipAfterFailureCount = null;
    }

    public static Notifier pureNotifier() {
        return new Notifier(){

            @Override
            public void asFailFast(boolean failFast) {
                throw new UnsupportedOperationException("pure notifier");
            }
        };
    }

    public void asFailFast(boolean enableFailFast) {
        this.failFast = enableFailFast;
    }

    public final boolean isFailFast() {
        return this.failFast;
    }

    public final void fireTestStarted(Description description) throws StoppedByUserException {
        super.fireTestStarted(description);
        if (!this.testClassNames.isEmpty()) {
            this.testClassNames.remove(JUnit4ProviderUtil.cutTestClassAndMethod(description).getClazz());
        }
    }

    public final void fireTestFailure(Failure failure) {
        if (this.failFast) {
            this.fireStopEvent();
        }
        super.fireTestFailure(failure);
    }

    public final void addListener(RunListener listener) {
        this.listeners.add(listener);
        super.addListener(listener);
    }

    public final Notifier addListeners(Collection<RunListener> given) {
        for (RunListener listener : given) {
            this.addListener(listener);
        }
        return this;
    }

    public final Notifier addListeners(RunListener ... given) {
        for (RunListener listener : given) {
            this.addListener(listener);
        }
        return this;
    }

    public final void removeListener(RunListener listener) {
        this.listeners.remove(listener);
        super.removeListener(listener);
    }

    public final void removeListeners() {
        Iterator<RunListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            RunListener listener = it.next();
            it.remove();
            super.removeListener(listener);
        }
    }

    public final Queue<String> getRemainingTestClasses() {
        return this.failFast ? this.testClassNames : null;
    }

    public final void copyListenersTo(Notifier copyTo) {
        copyTo.addListeners(this.listeners);
    }

    private void fireStopEvent() {
        if (ConcurrencyUtils.countDownToZero((AtomicInteger)this.skipAfterFailureCount)) {
            this.pleaseStop();
        }
        this.reporter.testExecutionSkippedByUser();
    }
}

