/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.tycho.p2.maven.repository.Activator;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.util.internal.RepositoryFactoryTools;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LocalArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    private static final String REPOSITORY_TYPE = LocalArtifactRepository.class.getSimpleName();

    public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        throw RepositoryFactoryTools.unsupportedCreation(REPOSITORY_TYPE);
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        File localRepositoryDirectory;
        if ("file".equals(location.getScheme()) && (localRepositoryDirectory = new File(location)).isDirectory() && new File(localRepositoryDirectory, ".meta/p2-artifacts.properties").exists()) {
            return new LocalArtifactRepository(this.getAgent(), this.lookupLocalRepoIndices());
        }
        return null;
    }

    protected LocalRepositoryP2Indices lookupLocalRepoIndices() {
        LocalRepositoryP2Indices localRepoIndices;
        BundleContext context = Activator.getContext();
        ServiceReference localRepoIndicesRef = context.getServiceReference(LocalRepositoryP2Indices.class);
        if (localRepoIndicesRef != null && (localRepoIndices = (LocalRepositoryP2Indices)context.getService(localRepoIndicesRef)) != null) {
            return localRepoIndices;
        }
        throw new IllegalStateException("service not registered: " + LocalRepositoryP2Indices.class.getName());
    }
}

