/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.MavenArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.container.ContainerUtils;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Extension;
import org.apache.maven.plugin.DefaultPluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtensionManager
extends AbstractLogEnabled
implements ExtensionManager,
Contextualizable {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private DefaultPlexusContainer container;
    private ArtifactFilter artifactFilter = MavenArtifactFilterManager.createExtensionFilter();
    private WagonManager wagonManager;
    private PlexusContainer extensionContainer;
    private static final String CONTAINER_NAME = "extensions";

    @Override
    public void addExtension(Extension extension, MavenProject project, ArtifactRepository localRepository) throws ArtifactResolutionException, PlexusContainerException, ArtifactNotFoundException {
        String extensionId = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
        this.getLogger().debug("Initialising extension: " + extensionId);
        Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(extensionId);
        if (artifact != null) {
            ResolutionGroup resolutionGroup;
            ProjectArtifactExceptionFilter filter = new ProjectArtifactExceptionFilter(this.artifactFilter, project.getArtifact());
            try {
                resolutionGroup = this.artifactMetadataSource.retrieve(artifact, localRepository, project.getRemoteArtifactRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException("Unable to download metadata from repository for plugin '" + artifact.getId() + "': " + e.getMessage(), artifact, (Throwable)e);
            }
            Set rgArtifacts = resolutionGroup.getArtifacts();
            rgArtifacts = DefaultPluginManager.checkPlexusUtils(rgArtifacts, this.artifactFactory);
            LinkedHashSet<Artifact> dependencies = new LinkedHashSet<Artifact>();
            dependencies.add(artifact);
            dependencies.addAll(rgArtifacts);
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencies, project.getArtifact(), Collections.EMPTY_MAP, localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, (ArtifactFilter)filter);
            Set artifacts = result.getArtifacts();
            if (this.extensionContainsLifeycle(artifact.getFile())) {
                for (Artifact a : artifacts) {
                    if (!this.artifactFilter.include(a)) continue;
                    this.getLogger().debug("Adding extension to core container: " + a.getFile());
                    this.container.addJarResource(a.getFile());
                }
            } else if (artifacts.size() == 2) {
                for (Artifact a : artifacts) {
                    if (a.getArtifactId().equals("plexus-utils")) continue;
                    a = project.replaceWithActiveArtifact(a);
                    this.getLogger().debug("Adding extension to core container: " + a.getFile());
                    this.container.addJarResource(a.getFile());
                }
            } else {
                if (this.extensionContainer == null) {
                    this.extensionContainer = this.createContainer();
                }
                for (Artifact a : result.getArtifacts()) {
                    a = project.replaceWithActiveArtifact(a);
                    this.getLogger().debug("Adding to extension classpath: " + a.getFile());
                    this.extensionContainer.addJarResource(a.getFile());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Extension container contents:");
                    this.extensionContainer.getContainerRealm().display();
                }
            }
        }
    }

    private PlexusContainer createContainer() throws PlexusContainerException {
        DefaultPlexusContainer child = new DefaultPlexusContainer();
        ClassWorld classWorld = this.container.getClassWorld();
        child.setClassWorld(classWorld);
        ClassRealm childRealm = null;
        String childRealmId = "plexus.core.child-container[extensions]";
        try {
            childRealm = classWorld.getRealm(childRealmId);
        }
        catch (NoSuchRealmException e) {
            try {
                childRealm = classWorld.newRealm(childRealmId);
            }
            catch (DuplicateRealmException impossibleError) {
                this.getLogger().error("An impossible error has occurred. After getRealm() failed, newRealm() produced duplication error on same id!", (Throwable)impossibleError);
            }
        }
        childRealm.setParent(this.container.getContainerRealm());
        child.setCoreRealm(childRealm);
        child.setName(CONTAINER_NAME);
        child.setLoggerManager(this.container.getLoggerManager());
        child.initialize();
        child.start();
        return child;
    }

    @Override
    public void registerWagons() {
        if (this.extensionContainer != null) {
            Set<String> wagons = ContainerUtils.findChildComponentHints(Wagon.ROLE, (PlexusContainer)this.container, this.extensionContainer);
            if (wagons != null && !wagons.isEmpty()) {
                this.getLogger().debug("Wagons to register: " + wagons);
                this.wagonManager.registerWagons(wagons, this.extensionContainer);
            }
        } else {
            this.getLogger().debug("Wagons could not be registered as the extension container was never created");
        }
    }

    @Override
    public Map<String, ArtifactHandler> getArtifactTypeHandlers() {
        HashMap<String, ArtifactHandler> result = new HashMap<String, ArtifactHandler>();
        if (this.extensionContainer != null) {
            try {
                result.putAll(this.extensionContainer.lookupMap(ArtifactHandler.ROLE));
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("ArtifactHandler extensions could not be loaded: " + e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                result.putAll(this.container.lookupMap(ArtifactHandler.ROLE));
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("ArtifactHandler extensions could not be loaded: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (DefaultPlexusContainer)context.get((Object)"plexus");
    }

    private boolean extensionContainsLifeycle(File extension) {
        try {
            JarFile f = new JarFile(extension);
            InputStream is = f.getInputStream(f.getEntry("META-INF/plexus/components.xml"));
            if (is == null) {
                return false;
            }
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new InputStreamReader(is));
            Xpp3Dom[] components = dom.getChild("components").getChildren("component");
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].getChild("role").getValue().equals("org.apache.maven.lifecycle.mapping.LifecycleMapping")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static final class ProjectArtifactExceptionFilter
    implements ArtifactFilter {
        private ArtifactFilter passThroughFilter;
        private String projectDependencyConflictId;

        ProjectArtifactExceptionFilter(ArtifactFilter passThroughFilter, Artifact projectArtifact) {
            this.passThroughFilter = passThroughFilter;
            this.projectDependencyConflictId = projectArtifact.getDependencyConflictId();
        }

        public boolean include(Artifact artifact) {
            String depConflictId = artifact.getDependencyConflictId();
            return this.projectDependencyConflictId.equals(depConflictId) || this.passThroughFilter.include(artifact);
        }
    }
}

