/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders;

import java.util.List;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;

public class MethodProfilingDataProvider {
    public static final IItemFilter SAMPLES_OR_CPU_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.EXECUTION_SAMPLE, JdkFilters.CPU_LOAD});
    public static final IAggregator<IQuantity, ?> MIN_ENDTIME = Aggregators.min((String)Messages.getString("MethodProfilingDataProvider_AGGR_MIN_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    public static final IAggregator<IQuantity, ?> MAX_ENDTIME = Aggregators.max((String)Messages.getString("MethodProfilingDataProvider_AGGR_MAX_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    public static final IAccessorFactory<IMCMethod> TOP_FRAME_ACCESSOR_FACTORY = new IAccessorFactory<IMCMethod>(){

        public <T> IMemberAccessor<IMCMethod, T> getAccessor(IType<T> type) {
            final IMemberAccessor sta = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return new IMemberAccessor<IMCMethod, T>(){

                public IMCMethod getMember(T inObject) {
                    IMCStackTrace st = (IMCStackTrace)sta.getMember(inObject);
                    if (st != null && !st.getFrames().isEmpty()) {
                        return ((IMCFrame)st.getFrames().get(0)).getMethod();
                    }
                    return null;
                }
            };
        }
    };
    public static final IAccessorFactory<IMCStackTrace> PATH_ACCESSOR_FACTORY = new IAccessorFactory<IMCStackTrace>(){

        public <T> IMemberAccessor<IMCStackTrace, T> getAccessor(IType<T> type) {
            final IMemberAccessor sta = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return new IMemberAccessor<IMCStackTrace, T>(){

                public IMCStackTrace getMember(T inObject) {
                    IMCStackTrace st = (IMCStackTrace)sta.getMember(inObject);
                    if (st != null && !st.getFrames().isEmpty()) {
                        return st;
                    }
                    return null;
                }
            };
        }
    };
    public static final GroupingAggregator.IQuantityListFinisher<IQuantity> topFrameBalanceFunction = new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> values, IQuantity total) {
            if (total != null && total.doubleValue() > 0.0) {
                IUnit totalUnit = total.getUnit();
                double totalValue = total.doubleValue();
                double score = 0.0;
                for (int i = values.size() - 1; i >= 0; --i) {
                    int index = values.size() - i;
                    score += values.get(i).doubleValueIn(totalUnit) / (double)index;
                }
                return UnitLookup.NUMBER_UNITY.quantity(score / totalValue);
            }
            return null;
        }
    };
    public static final GroupingAggregator.IQuantityListFinisher<IQuantity> topFrameQuotaFunction = new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> values, IQuantity total) {
            if (total != null && total.doubleValue() > 0.0) {
                double score = values.get(values.size() - 1).ratioTo(total);
                return UnitLookup.NUMBER_UNITY.quantity(score);
            }
            return null;
        }
    };
    public static final IAggregator<IQuantity, ?> TOP_FRAME_BALANCE = GroupingAggregator.build((String)Messages.getString("MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE"), (String)Messages.getString("MethodProfilingDataProvider_AGGR_TOP_FRAME_BALANCE_DESC"), TOP_FRAME_ACCESSOR_FACTORY, (IAggregator)JdkAggregators.EXECUTION_SAMPLE_COUNT, topFrameBalanceFunction);
    public static final IAggregator<IQuantity, ?> TOP_FRAME_QUOTA = GroupingAggregator.build((String)Messages.getString("MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA"), (String)Messages.getString("MethodProfilingDataProvider_AGGR_AGGR_TOP_FRAME_QUOTA_DESC"), TOP_FRAME_ACCESSOR_FACTORY, (IAggregator)JdkAggregators.EXECUTION_SAMPLE_COUNT, topFrameQuotaFunction);
}

