/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.control;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jemmy.JemmyException;
import org.jemmy.Point;
import org.jemmy.Rectangle;
import org.jemmy.TimeoutExpiredException;
import org.jemmy.action.GetAction;
import org.jemmy.control.As;
import org.jemmy.control.ControlInterfaces;
import org.jemmy.control.ControlType;
import org.jemmy.control.DefaultWrapper;
import org.jemmy.control.FieldProperties;
import org.jemmy.control.MethodProperties;
import org.jemmy.control.Property;
import org.jemmy.env.Environment;
import org.jemmy.env.TestOut;
import org.jemmy.env.Timeout;
import org.jemmy.image.Image;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.Drag;
import org.jemmy.interfaces.InterfaceException;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Mouse;
import org.jemmy.interfaces.TypeControlInterface;
import org.jemmy.timing.State;

@ControlType(value={Object.class})
@ControlInterfaces(value={Mouse.class, Keyboard.class, Drag.class})
public abstract class Wrap<CONTROL> {
    public static final String BOUNDS_PROP_NAME = "bounds";
    public static final String CLICKPOINT_PROP_NAME = "clickPoint";
    public static final String CONTROL_CLASS_PROP_NAME = "control.class";
    public static final String CONTROL_PROP_NAME = "control";
    public static final String INPUT_FACTORY_PROPERTY = "input.control.interface.factory";
    public static final String IMAGE_LOADER_PROPERTY = "image.loader";
    public static final String IMAGE_CAPTURER_PROPERTY = "image.capturer";
    public static final String TEXT_PROP_NAME = "text";
    public static final String POSITION_PROP_NAME = "position";
    public static final String VALUE_PROP_NAME = "value";
    public static final String WRAPPER_CLASS_PROP_NAME = "wrapper.class";
    public static final String TOOLTIP_PROP_NAME = "tooltip";
    public static final String NAME_PROP_NAME = "name";
    public static final Timeout WAIT_STATE_TIMEOUT = new Timeout("wait.state", 1000L);
    public static final String OUTPUT = Wrap.class.getName() + ".OUTPUT";
    private static DefaultWrapper theWrapper = new DefaultWrapper(Environment.getEnvironment());
    CONTROL node;
    Environment env;
    private Mouse mouse = null;
    private Drag drag = null;
    private Keyboard keyboard = null;
    private HashMap<String, Object> properties = new HashMap();

    public static DefaultWrapper getWrapper() {
        return theWrapper;
    }

    protected Wrap(Environment env) {
        this.env = env;
        this.node = null;
        this.fillTheProps(false);
    }

    protected Wrap(Environment env, CONTROL node) {
        this.env = env;
        this.node = node;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    @Property(value="control")
    public CONTROL getControl() {
        return this.node;
    }

    @Property(value="clickPoint")
    public Point getClickPoint() {
        return new Point(this.getScreenBounds().width / 2, this.getScreenBounds().height / 2);
    }

    @Property(value="bounds")
    public abstract Rectangle getScreenBounds();

    public Point toAbsolute(Point local) {
        Rectangle bounds = this.getScreenBounds();
        return local.translate(bounds.x, bounds.y);
    }

    public Point toLocal(Point local) {
        Rectangle bounds = this.getScreenBounds();
        return local.translate(-bounds.x, -bounds.y);
    }

    public Image getScreenImage() {
        Rectangle bounds = this.getScreenBounds();
        return this.getScreenImage(new Rectangle(0, 0, bounds.width, bounds.height));
    }

    public Image getScreenImage(Rectangle rect) {
        if (this.getEnvironment().getImageCapturer() == null) {
            throw new JemmyException("Image capturer is not specified.");
        }
        return this.getEnvironment().getImageCapturer().capture(this, rect);
    }

    public void waitImage(final Image golden, final Rectangle rect, String resID, String diffID) {
        try {
            this.waitState(new State<Object>(){

                @Override
                public Object reached() {
                    return Wrap.this.getScreenImage(rect).compareTo(golden) == null ? Boolean.valueOf(true) : null;
                }

                public String toString() {
                    return "Control having expected image";
                }
            });
        }
        catch (TimeoutExpiredException e) {
            if (diffID != null) {
                this.getEnvironment().getOutput(OUTPUT).println("Saving difference to " + diffID);
                this.getScreenImage(rect).compareTo(golden).save(diffID);
            }
            throw e;
        }
        finally {
            if (resID != null) {
                this.getEnvironment().getOutput(OUTPUT).println("Saving result to " + resID);
                this.getScreenImage(rect).save(resID);
            }
        }
    }

    public void waitImage(Image golden, String resID, String diffID) {
        Rectangle bounds = this.getScreenBounds();
        this.waitImage(golden, new Rectangle(0, 0, bounds.width, bounds.height), resID, diffID);
    }

    public <V> V waitState(State<V> state, V value) {
        return this.getEnvironment().getWaiter(WAIT_STATE_TIMEOUT).ensureValue(value, state);
    }

    public <V> V waitState(State<V> state) {
        return this.getEnvironment().getWaiter(WAIT_STATE_TIMEOUT).ensureState(state);
    }

    private Method findAsMethod(Class<? extends ControlInterface> interfaceClass, Class type) {
        while (type != null) {
            for (Method m : this.getClass().getMethods()) {
                As as = m.getAnnotation(As.class);
                Class<?> returnType = m.getReturnType();
                if (as == null || !interfaceClass.isAssignableFrom(returnType) || !as.value().equals(type)) continue;
                if (m.getParameterTypes().length > 0 && type.equals(Void.class) || m.getParameterTypes().length > 1 && !type.equals(Void.class)) {
                    throw new IllegalStateException("wrong number of parameters in an @As method");
                }
                return m;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public <INTERFACE extends ControlInterface> boolean is(Class<INTERFACE> interfaceClass) {
        if (interfaceClass.isInstance(this)) {
            return true;
        }
        return this.findAsMethod(interfaceClass, Void.class) != null;
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> boolean is(Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        if (interfaceClass.isInstance(this) && ((TypeControlInterface)interfaceClass.cast(this)).getType().isAssignableFrom(type)) {
            return true;
        }
        return this.findAsMethod(interfaceClass, type) != null;
    }

    private Object callAsMethod(Class<? extends ControlInterface> interfaceClass, Class type) {
        Method m = this.findAsMethod(interfaceClass, type);
        if (m != null) {
            try {
                if (m.getParameterTypes().length == 0) {
                    return m.invoke((Object)this, new Object[0]);
                }
                if (m.getParameterTypes().length == 1) {
                    return m.invoke((Object)this, !type.equals(Void.class) ? type : Object.class);
                }
                throw new InterfaceException(this, interfaceClass);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to call method \"" + m.getName() + "()\"", ex, this);
            }
            catch (IllegalArgumentException ex) {
                throw new JemmyException("Unable to call method \"" + m.getName() + "()\"", ex, this);
            }
            catch (InvocationTargetException ex) {
                throw new JemmyException("Unable to call method \"" + m.getName() + "()\"", ex, this);
            }
        }
        return null;
    }

    public <INTERFACE extends ControlInterface> INTERFACE as(Class<INTERFACE> interfaceClass) {
        if (interfaceClass.isInstance(this)) {
            return (INTERFACE)((ControlInterface)interfaceClass.cast(this));
        }
        Object res = this.callAsMethod(interfaceClass, Void.class);
        if (res != null) {
            return (INTERFACE)((ControlInterface)res);
        }
        throw new InterfaceException(this, interfaceClass);
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> INTERFACE as(Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        if (interfaceClass.isInstance(this) && ((TypeControlInterface)interfaceClass.cast(this)).getType().isAssignableFrom(type)) {
            return (INTERFACE)((TypeControlInterface)interfaceClass.cast(this));
        }
        Object res = this.callAsMethod(interfaceClass, type);
        if (res != null) {
            return (INTERFACE)((TypeControlInterface)res);
        }
        throw new InterfaceException(this, interfaceClass);
    }

    @As(value=Mouse.class)
    public Mouse mouse() {
        if (this.mouse == null) {
            this.mouse = this.getEnvironment().getInputFactory().create(this, Mouse.class);
        }
        return this.mouse;
    }

    @As(value=Drag.class)
    public Drag drag() {
        if (this.drag == null) {
            this.drag = this.getEnvironment().getInputFactory().create(this, Drag.class);
        }
        return this.drag;
    }

    @As(value=Keyboard.class)
    public Keyboard keyboard() {
        if (this.keyboard == null) {
            this.keyboard = this.getEnvironment().getInputFactory().create(this, Keyboard.class);
        }
        return this.keyboard;
    }

    @Property(value="control.class")
    public Class<?> getControlClass() {
        return this.getControl().getClass();
    }

    private void fillTheProps(boolean quiet) {
        this.properties.clear();
        this.properties.put(WRAPPER_CLASS_PROP_NAME, this.getClass());
        this.readAnnotationProps(quiet);
        this.readControlProps(quiet);
    }

    private void readControlProps(boolean quiet) {
        Class<?> cls = this.getClass();
        do {
            Object value;
            if (cls.isAnnotationPresent(FieldProperties.class)) {
                for (String s : cls.getAnnotation(FieldProperties.class).value()) {
                    block8: {
                        try {
                            value = this.getFieldProperty(s);
                        }
                        catch (Exception e) {
                            this.getEnvironment().getOutput().printStackTrace(e);
                            value = e.toString();
                            if (e instanceof JemmyException || quiet) break block8;
                            throw new JemmyException("Exception while getting property \"" + s + "\"", e);
                        }
                    }
                    this.properties.put(s, value);
                }
            }
            if (!cls.isAnnotationPresent(MethodProperties.class)) continue;
            for (String s : cls.getAnnotation(MethodProperties.class).value()) {
                block9: {
                    try {
                        value = this.getMethodProperty(s);
                    }
                    catch (Exception e) {
                        this.getEnvironment().getOutput().printStackTrace(e);
                        value = e.toString();
                        if (e instanceof JemmyException || quiet) break block9;
                        throw new JemmyException("Exception while getting property \"" + s + "\"", e);
                    }
                }
                this.properties.put(s, value);
            }
        } while ((cls = cls.getSuperclass()) != null);
    }

    private void addAnnotationProps(Class cls, boolean quiet) {
        for (Method m : cls.getMethods()) {
            Object value;
            String name;
            if (!m.isAnnotationPresent(Property.class) || this.properties.containsKey(name = m.getAnnotation(Property.class).value())) continue;
            try {
                value = this.getProperty(this, m);
            }
            catch (Exception e) {
                if (quiet) {
                    this.getEnvironment().getOutput().printStackTrace(e);
                    value = e.toString();
                }
                throw new JemmyException("Exception while getting property \"" + name + "\"", e);
            }
            this.properties.put(name, value);
        }
    }

    private void readAnnotationProps(boolean quiet) {
        Class<?> cls = this.getClass();
        do {
            this.addAnnotationProps(cls, quiet);
        } while ((cls = cls.getSuperclass()) != null);
        for (Class<?> intf : this.getClass().getInterfaces()) {
            this.addAnnotationProps(intf, quiet);
        }
    }

    private void checkPropertyMethod(Method m) {
        if (m.getParameterTypes().length > 0) {
            throw new JemmyException("Method marked by @Property must not have parameters: " + m.getDeclaringClass().getName() + "." + m.getName());
        }
    }

    private Method getPropertyMethod(Class cls, String name) {
        Class scls = cls;
        do {
            for (Method method : scls.getMethods()) {
                if (!method.isAnnotationPresent(Property.class) || !method.getAnnotation(Property.class).value().equals(name)) continue;
                this.checkPropertyMethod(method);
                return method;
            }
        } while ((scls = scls.getSuperclass()) != null);
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            for (Method m : ((Class)genericDeclaration).getMethods()) {
                if (!m.isAnnotationPresent(Property.class) || !m.getAnnotation(Property.class).value().equals(name)) continue;
                this.checkPropertyMethod(m);
                return m;
            }
        }
        return null;
    }

    private Object getProperty(Object object, Method m) {
        Property prop = m.getAnnotation(Property.class);
        try {
            return m.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new JemmyException("Unable to obtain property \"" + (prop != null ? prop.value() : "null") + "\"", ex, this);
        }
        catch (IllegalArgumentException ex) {
            throw new JemmyException("Unable to obtain property \"" + (prop != null ? prop.value() : "null") + "\"", ex, this);
        }
        catch (InvocationTargetException ex) {
            throw new JemmyException("Unable to obtain property \"" + (prop != null ? prop.value() : "null") + "\"", ex, this);
        }
    }

    public Object getProperty(String name) {
        if (WRAPPER_CLASS_PROP_NAME.equals(name)) {
            return this.getClass();
        }
        Method m = this.getPropertyMethod(this.getClass(), name);
        if (m != null) {
            return this.getProperty(this, m);
        }
        if (this.hasMethodProperty(name)) {
            return this.getMethodProperty(name);
        }
        if (this.hasFieldProperty(name)) {
            return this.getFieldProperty(name);
        }
        throw new JemmyException("No property \"" + name + "\"", this);
    }

    private Object getInterfaceProperty(Class cls, Object instance, String name) {
        Method m = this.getPropertyMethod(cls, name);
        if (m != null) {
            return this.getProperty(instance, m);
        }
        throw new JemmyException("No property \"" + name + "\" in interface " + cls.getName(), instance);
    }

    public <INTERFACE extends ControlInterface> Object getProperty(String name, Class<INTERFACE> intrfc) {
        return this.getInterfaceProperty(intrfc, this.as(intrfc), name);
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> Object getProperty(String name, Class<INTERFACE> intrfc, Class<TYPE> type) {
        return this.getInterfaceProperty(intrfc, this.as(intrfc, type), name);
    }

    public void waitProperty(final String property, final Object value) {
        this.getEnvironment().getWaiter(WAIT_STATE_TIMEOUT).ensureValue(value, new State<Object>(){

            @Override
            public Object reached() {
                return Wrap.this.getProperty(property);
            }

            public String toString() {
                return "Control having property " + property + " expected value '" + value + "' (Property = '" + Wrap.this.getProperty(property) + "')";
            }
        });
    }

    public <INTERFACE extends ControlInterface> void waitProperty(final String property, final Class<INTERFACE> intrfc, final Object value) {
        INTERFACE instance = this.as(intrfc);
        this.getEnvironment().getWaiter(WAIT_STATE_TIMEOUT).ensureValue(value, new State<Object>(){

            @Override
            public Object reached() {
                return Wrap.this.getProperty(property, intrfc);
            }

            public String toString() {
                return "Interface " + intrfc.getName() + " having property " + property + " expected value '" + value + "' (Property = '" + Wrap.this.getProperty(property, intrfc) + "')";
            }
        });
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> void waitProperty(final String property, final Class<INTERFACE> intrfc, final Class<TYPE> type, final Object value) {
        this.getEnvironment().getWaiter(WAIT_STATE_TIMEOUT).ensureValue(value, new State<Object>(){

            @Override
            public Object reached() {
                return Wrap.this.getProperty(property, intrfc, type);
            }

            public String toString() {
                return "Interface " + intrfc.getName() + " having property " + property + " expected value '" + value + "' (Property = '" + Wrap.this.getProperty(property) + "')";
            }
        });
    }

    public boolean hasFieldProperty(String name) {
        Class<?> cls = this.getClass();
        do {
            FieldProperties props;
            if (!cls.isAnnotationPresent(FieldProperties.class) || !this.contains((props = cls.getAnnotation(FieldProperties.class)).value(), name)) continue;
            return true;
        } while ((cls = cls.getSuperclass()) != null);
        return false;
    }

    public boolean hasMethodProperty(String name) {
        Class<?> cls = this.getClass();
        do {
            MethodProperties props;
            if (!cls.isAnnotationPresent(MethodProperties.class) || !this.contains((props = cls.getAnnotation(MethodProperties.class)).value(), name)) continue;
            return true;
        } while ((cls = cls.getSuperclass()) != null);
        return false;
    }

    private boolean contains(String[] values, String name) {
        for (int i = 0; i < values.length; ++i) {
            if (!name.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    public Object getFieldProperty(final String name) {
        if (!this.hasFieldProperty(name)) {
            throw new JemmyException("No \"" + name + "\" field property specified on " + this.getClass().getName());
        }
        GetAction action = new GetAction(){

            @Override
            public void run(Object ... parameters) throws Exception {
                this.setResult(Wrap.this.getControl().getClass().getField(name).get(Wrap.this.getControl()));
            }
        };
        Object result = action.dispatch(this.env, new Object[0]);
        if (action.getThrowable() != null) {
            throw new JemmyException("Unable to obtain property \"" + name + "\"", action.getThrowable(), this);
        }
        return result;
    }

    public Object getMethodProperty(final String name) {
        if (!this.hasMethodProperty(name)) {
            throw new JemmyException("No \"" + name + "\" method property specified on " + this.getClass().getName());
        }
        GetAction action = new GetAction(){

            @Override
            public void run(Object ... parameters) throws Exception {
                this.setResult(Wrap.this.getControl().getClass().getMethod(name, new Class[0]).invoke(Wrap.this.getControl(), new Object[0]));
            }

            @Override
            public String toString() {
                return "Getting property \"" + name + "\" on " + this.getClass().getName();
            }
        };
        Object result = action.dispatch(this.env, new Object[0]);
        if (action.getThrowable() != null) {
            throw new JemmyException("Unable to obtain property \"" + name + "\"", action.getThrowable(), this);
        }
        return result;
    }

    public <P> P getProperty(Class<P> valueClass, String name) {
        return valueClass.cast(this.getProperty(name));
    }

    public HashMap<String, Object> getProperties() {
        this.fillTheProps(false);
        return this.properties;
    }

    public HashMap<String, Object> getPropertiesQiuet() {
        this.fillTheProps(true);
        return this.properties;
    }

    static {
        Environment.getEnvironment().initTimeout(WAIT_STATE_TIMEOUT);
        Environment.getEnvironment().initOutput(OUTPUT, TestOut.getNullOutput());
        Environment.getEnvironment().initTimeout(Mouse.CLICK);
        Environment.getEnvironment().initTimeout(Drag.BEFORE_DRAG_TIMEOUT);
        Environment.getEnvironment().initTimeout(Drag.BEFORE_DROP_TIMEOUT);
        Environment.getEnvironment().initTimeout(Drag.IN_DRAG_TIMEOUT);
        Environment.getEnvironment().initTimeout(Keyboard.PUSH);
    }
}

