/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.tycho.repository.p2base.artifact.provider.CompositeArtifactProviderBaseImpl;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.repository.ArtifactRepositorySupplier;

public class RepositoryArtifactProvider
extends CompositeArtifactProviderBaseImpl
implements IRawArtifactProvider {
    private final ArtifactRepositorySupplier repositoryLoader;
    IArtifactRepository[] repositories;
    final ArtifactTransferPolicy transferPolicy;

    public RepositoryArtifactProvider(List<? extends IArtifactRepository> repositories, ArtifactTransferPolicy transferPolicy) {
        this.repositories = repositories.toArray(new IArtifactRepository[0]);
        this.repositoryLoader = null;
        this.transferPolicy = transferPolicy;
    }

    public RepositoryArtifactProvider(List<URI> artifactRepositories, ArtifactTransferPolicy transferPolicy, IProvisioningAgent agent) {
        this(RepositoryArtifactProvider.createRepositoryLoader(artifactRepositories, agent), transferPolicy);
    }

    public RepositoryArtifactProvider(ArtifactRepositorySupplier repositoryLoader, ArtifactTransferPolicy transferPolicy) {
        this.repositories = null;
        this.repositoryLoader = repositoryLoader;
        this.transferPolicy = transferPolicy;
    }

    public static ArtifactRepositorySupplier createRepositoryLoader(Collection<URI> artifactRepositories, IProvisioningAgent agent) {
        return new RepositoryLoader(artifactRepositories, agent);
    }

    public static IArtifactRepository loadRepository(URI repositoryURL, IProvisioningAgent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("IProvisioningAgent is null");
        }
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
        if (repositoryManager == null) {
            throw new IllegalArgumentException("IArtifactRepositoryManager in p2 agent " + agent);
        }
        try {
            return repositoryManager.loadRepository(repositoryURL, null);
        }
        catch (ProvisionException e) {
            throw new RuntimeException("Load repository from url " + repositoryURL + " failed (" + (Object)((Object)e) + ")", e);
        }
    }

    protected void init() {
        if (this.repositories == null) {
            this.repositories = ((Collection)this.repositoryLoader.get()).toArray(new IArtifactRepository[0]);
            this.repositoriesLoaded();
        }
    }

    protected void repositoriesLoaded() {
    }

    @Override
    public boolean contains(IArtifactKey key) {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            if (repository.contains(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean contains(IArtifactDescriptor descriptor) {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            if (repository.contains(descriptor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void getArtifactDescriptorsOfAllSources(IArtifactKey key, Set<IArtifactDescriptor> result) {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            result.addAll(Arrays.asList(repository.getArtifactDescriptors(key)));
            ++n2;
        }
    }

    @Override
    protected void getArtifactFromAnySource(IArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            boolean artifactWasRead = this.getArtifactFromAnyFormatAvailableInRepository(repository, sink, statusCollector, monitor);
            if (artifactWasRead) {
                return;
            }
            ++n2;
        }
    }

    private boolean getArtifactFromAnyFormatAvailableInRepository(IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        IArtifactDescriptor[] allFormats = repository.getArtifactDescriptors(sink.getArtifactToBeWritten());
        List<IArtifactDescriptor> formatsByPreference = this.transferPolicy.sortFormatsByPreference(allFormats);
        return this.getArtifactFromAnyChildRepository(formatsByPreference, repository, sink, statusCollector, monitor);
    }

    private boolean getArtifactFromAnyChildRepository(final List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, final IArtifactSink sink, final List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        BooleanStatusArtifactRequest request = new BooleanStatusArtifactRequest(sink.getArtifactToBeWritten()){

            public void perform(IArtifactRepository childRepository, IProgressMonitor monitor) {
                RetryTracker retryTracker = new RetryTracker();
                List<IArtifactDescriptor> localArtifactDescriptors = availableDescriptors.stream().filter(desc -> desc.getRepository() == null || desc.getRepository().equals(childRepository)).collect(Collectors.toList());
                try {
                    boolean artifactWasRead = RepositoryArtifactProvider.this.getArtifactFromAnyMirror(localArtifactDescriptors, childRepository, sink, statusCollector, retryTracker, monitor);
                    if (artifactWasRead) {
                        this.markSuccessful();
                    }
                }
                catch (ArtifactSinkException e) {
                    throw new ArtifactSinkExceptionWrapper(e);
                }
            }
        };
        try {
            repository.getArtifacts(new IArtifactRequest[]{request}, monitor);
        }
        catch (ArtifactSinkExceptionWrapper e) {
            throw e.getWrappedException();
        }
        return request.wasSuccessful();
    }

    private boolean getArtifactFromAnyMirror(List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, RetryTracker retryTracker, IProgressMonitor monitor) throws ArtifactSinkException {
        while (retryTracker.canRetry()) {
            boolean artifactWasRead = this.getArtifactFromOneMirror(availableDescriptors, repository, sink, statusCollector, retryTracker, monitor);
            if (artifactWasRead) {
                return true;
            }
            retryTracker.increment();
        }
        return false;
    }

    private boolean getArtifactFromOneMirror(List<IArtifactDescriptor> availableDescriptors, IArtifactRepository repository, IArtifactSink sink, List<IStatus> statusCollector, RetryTracker retryTracker, IProgressMonitor monitor) throws ArtifactSinkException {
        for (IArtifactDescriptor descriptor : availableDescriptors) {
            if (descriptor.getRepository() != null && !descriptor.getRepository().equals(repository)) {
                return false;
            }
            if (!sink.canBeginWrite()) {
                return false;
            }
            IStatus status = repository.getArtifact(descriptor, sink.beginWrite(), monitor);
            statusCollector.add(this.improveMessageIfError(status, repository, descriptor));
            if (RepositoryArtifactProvider.isFatal(status)) {
                sink.abortWrite();
                if (status.getCode() == 13) continue;
                retryTracker.noMoreRetries();
                continue;
            }
            sink.commitWrite();
            return true;
        }
        return false;
    }

    @Override
    protected void getRawArtifactFromAnySource(IRawArtifactSink sink, IProgressMonitor monitor, List<IStatus> statusCollector) throws ArtifactSinkException {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            boolean artifactWasRead = this.getRawArtifactFromRepository(repository, sink, statusCollector, monitor);
            if (artifactWasRead) {
                return;
            }
            ++n2;
        }
    }

    private boolean getRawArtifactFromRepository(IArtifactRepository repository, IRawArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        IArtifactDescriptor requestedDescriptor = sink.getArtifactFormatToBeWritten();
        if (repository.contains(requestedDescriptor)) {
            if (!sink.canBeginWrite()) {
                return false;
            }
            IStatus status = repository.getRawArtifact(requestedDescriptor, sink.beginWrite(), monitor);
            statusCollector.add(this.improveMessageIfError(status, repository, requestedDescriptor));
            if (RepositoryArtifactProvider.isFatal(status)) {
                sink.abortWrite();
            } else {
                sink.commitWrite();
                return true;
            }
        }
        return false;
    }

    private IStatus improveMessageIfError(IStatus originalStatus, IArtifactRepository repository, IArtifactDescriptor currentDescriptor) {
        if (!RepositoryArtifactProvider.isFatal(originalStatus)) {
            return originalStatus;
        }
        String message = "An error occurred while transferring artifact " + currentDescriptor + " from repository " + repository.getLocation();
        return new MultiStatus("org.eclipse.tycho.p2.maven.repository", 0, new IStatus[]{originalStatus}, message, null);
    }

    protected Status getArtifactNotFoundError(String artifact) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", 1200, "Artifact " + artifact + " is not available in any of the following repositories: " + this.repositoryLoader.getRepositoryURLs(), null);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        this.init();
        return this.repositoriesAsQueriable().query(query, monitor);
    }

    private IQueryable<IArtifactKey> repositoriesAsQueriable() {
        if (this.repositories.length == 1) {
            return this.repositories[0];
        }
        return new CompoundQueryable((IQueryable[])this.repositories.clone());
    }

    private static class ArtifactSinkExceptionWrapper
    extends RuntimeException {
        private final ArtifactSinkException wrappedException;

        public ArtifactSinkExceptionWrapper(ArtifactSinkException wrappedException) {
            this.wrappedException = wrappedException;
        }

        public ArtifactSinkException getWrappedException() {
            return this.wrappedException;
        }
    }

    private static abstract class BooleanStatusArtifactRequest
    implements IArtifactRequest {
        private final IArtifactKey key;
        private boolean successful = false;

        public BooleanStatusArtifactRequest(IArtifactKey key) {
            this.key = key;
        }

        public final IArtifactKey getArtifactKey() {
            return this.key;
        }

        protected void markSuccessful() {
            this.successful = true;
        }

        public boolean wasSuccessful() {
            return this.successful;
        }

        public IStatus getResult() {
            if (this.successful) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.tycho.p2.maven.repository", "failure marker");
        }
    }

    private static class RepositoryLoader
    implements ArtifactRepositorySupplier {
        private Collection<URI> repositoryURLs;
        private IProvisioningAgent agent;

        RepositoryLoader(Collection<URI> repositoryURLs, IProvisioningAgent agent) {
            this.repositoryURLs = repositoryURLs;
            this.agent = agent;
        }

        @Override
        public Collection<IArtifactRepository> get() {
            ArrayList<IArtifactRepository> result = new ArrayList<IArtifactRepository>(this.repositoryURLs.size());
            for (URI repositoryURL : this.repositoryURLs) {
                result.add(RepositoryArtifactProvider.loadRepository(repositoryURL, this.agent));
            }
            return result;
        }

        @Override
        public Collection<URI> getRepositoryURLs() {
            return Collections.unmodifiableCollection(this.repositoryURLs);
        }
    }

    private static class RetryTracker {
        private int remaining = 16;

        private RetryTracker() {
        }

        boolean canRetry() {
            return this.remaining > 0;
        }

        void increment() {
            --this.remaining;
        }

        void noMoreRetries() {
            this.remaining = 0;
        }
    }
}

