/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public interface ArtifactRepositorySupplier
extends Supplier<Collection<IArtifactRepository>> {
    default public Collection<URI> getRepositoryURLs() {
        return Collections.emptySet();
    }

    public static ArtifactRepositorySupplier composite(final ArtifactRepositorySupplier ... suppliers) {
        return new ArtifactRepositorySupplier(){

            @Override
            public Collection<IArtifactRepository> get() {
                ArrayList<IArtifactRepository> list = new ArrayList<IArtifactRepository>();
                ArtifactRepositorySupplier[] artifactRepositorySupplierArray = suppliers;
                int n = suppliers.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactRepositorySupplier supplier = artifactRepositorySupplierArray[n2];
                    list.addAll((Collection)supplier.get());
                    ++n2;
                }
                return list;
            }

            @Override
            public Collection<URI> getRepositoryURLs() {
                ArrayList<URI> list = new ArrayList<URI>();
                ArtifactRepositorySupplier[] artifactRepositorySupplierArray = suppliers;
                int n = suppliers.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactRepositorySupplier supplier = artifactRepositorySupplierArray[n2];
                    list.addAll(supplier.getRepositoryURLs());
                    ++n2;
                }
                return list;
            }
        };
    }
}

