/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.MirroringArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;

final class PackedFormatMirroringArtifactProvider
extends MirroringArtifactProvider {
    PackedFormatMirroringArtifactProvider(LocalArtifactRepository localArtifactRepository, IRawArtifactProvider remoteProviders, MavenLogger logger) {
        super(localArtifactRepository, remoteProviders, logger);
    }

    @Override
    protected boolean makeOneFormatLocallyAvailable(IArtifactKey key) throws MirroringArtifactProvider.MirroringFailedException, ProvisionException, ArtifactSinkException {
        if (this.isAvailableLocally(key)) {
            return true;
        }
        if (PackedFormatMirroringArtifactProvider.findPackedDescriptor(this.remoteProviders.getArtifactDescriptors(key)) != null) {
            Lock downloadLock = this.localArtifactRepository.getLockForDownload(key);
            downloadLock.lock();
            try {
                if (!this.isAvailableLocally(key)) {
                    this.downloadArtifact(key);
                }
            }
            finally {
                downloadLock.unlock();
            }
            return true;
        }
        return super.makeOneFormatLocallyAvailable(key);
    }

    private boolean isAvailableLocally(IArtifactKey key) {
        return PackedFormatMirroringArtifactProvider.findPackedDescriptor(this.localArtifactRepository.getArtifactDescriptors(key)) != null;
    }

    @Override
    protected IStatus downloadMostSpecificNeededFormatOfArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        IArtifactDescriptor[] allDescriptors = this.remoteProviders.getArtifactDescriptors(key);
        IArtifactDescriptor packedDescriptor = PackedFormatMirroringArtifactProvider.findPackedDescriptor(allDescriptors);
        if (packedDescriptor != null) {
            return this.downloadRawArtifact(packedDescriptor);
        }
        this.logger.debug("No remote repository provides " + key.getId() + "_" + key.getVersion() + " in packed format. Only the canonical format will be available in the build.");
        return this.downloadCanonicalArtifact(key);
    }

    private final IStatus downloadRawArtifact(IArtifactDescriptor descriptor) throws ProvisionException, ArtifactSinkException {
        IRawArtifactSink localSink = this.localArtifactRepository.newAddingRawArtifactSink(descriptor);
        return this.remoteProviders.getRawArtifact(localSink, this.monitorForDownload());
    }
}

