/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.p2.maven.repository.AbstractMavenMetadataRepository;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class LocalMetadataRepository
extends AbstractMavenMetadataRepository {
    private Set<GAV> changedGAVs = new LinkedHashSet<GAV>();

    public LocalMetadataRepository(URI location, TychoRepositoryIndex metadataIndex) {
        super(location, metadataIndex, null);
        if (!location.getScheme().equals("file")) {
            throw new IllegalArgumentException("Invalid local repository location: " + location);
        }
        this.save();
    }

    public LocalMetadataRepository(URI location, TychoRepositoryIndex projectIndex, RepositoryReader contentLocator) {
        super(location, projectIndex, contentLocator);
    }

    public void addInstallableUnits(Collection<IInstallableUnit> newUnits) {
        for (IInstallableUnit unit : newUnits) {
            GAV gav = RepositoryLayoutHelper.getGAV((Map)unit.getProperties());
            this.addInstallableUnit(unit, gav);
        }
        this.save();
    }

    public void addInstallableUnit(IInstallableUnit unit, GAV gav) {
        this.units.add(unit);
        LinkedHashSet<IInstallableUnit> gavUnits = (LinkedHashSet<IInstallableUnit>)this.unitsMap.get(gav);
        if (gavUnits == null) {
            gavUnits = new LinkedHashSet<IInstallableUnit>();
            this.unitsMap.put(gav, gavUnits);
        }
        gavUnits.add(unit);
        this.changedGAVs.add(gav);
    }

    public void save() {
        File basedir = new File(this.getLocation());
        MetadataIO io = new MetadataIO();
        for (GAV gav : this.changedGAVs) {
            Set gavUnits = (Set)this.unitsMap.get(gav);
            if (gavUnits == null || gavUnits.isEmpty()) continue;
            String relpath = RepositoryLayoutHelper.getRelativePath((GAV)gav, (String)"p2metadata", (String)"xml");
            File file = new File(basedir, relpath);
            file.getParentFile().mkdirs();
            try {
                io.writeXML((Set<IInstallableUnit>)gavUnits, file);
                this.metadataIndex.addGav(gav);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.metadataIndex.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.changedGAVs.clear();
    }

    public boolean isModifiable() {
        return true;
    }
}

